/* automatically generated by rust-bindgen 0.65.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::core::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::core::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::core::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::core::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::core::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::core::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::core::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::core::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::core::mem::transmute(self)
    }
}
impl<T> ::core::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::core::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::core::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::core::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::core::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::core::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::core::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::core::cmp::Eq for __BindgenUnionField<T> {}
pub const CONFIG_IP6_NF_MATCH_AH_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_861_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NAND_MODULE: u32 = 1;
pub const CONFIG_RING_BUFFER: u32 = 1;
pub const CONFIG_SND_SOC_WM8804_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_H323_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_SECCOMP_FILTER: u32 = 1;
pub const CONFIG_IP6_NF_SECURITY_MODULE: u32 = 1;
pub const CONFIG_SND_PROC_FS: u32 = 1;
pub const CONFIG_VFIO_PCI_MMAP: u32 = 1;
pub const CONFIG_SCSI_DMA: u32 = 1;
pub const CONFIG_IQS624_POS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_FAMILY_BRIDGE: u32 = 1;
pub const CONFIG_TWL6040_CORE: u32 = 1;
pub const CONFIG_DRM_PRIVACY_SCREEN: u32 = 1;
pub const CONFIG_ADMV4420_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDLE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_IQS5XX_MODULE: u32 = 1;
pub const CONFIG_TCP_MD5SIG: u32 = 1;
pub const CONFIG_HID_GT683R_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_SANCOV_TRACE_PC: u32 = 1;
pub const CONFIG_DEFAULT_INIT: &[u8; 1usize] = b"\0";
pub const CONFIG_MT7615_COMMON_MODULE: u32 = 1;
pub const CONFIG_MICROCODE: u32 = 1;
pub const CONFIG_ATM_ENI_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_MMA7455_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_V4L2_MODULE: u32 = 1;
pub const CONFIG_TI_DAC5571_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CS3308_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPMARK_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ADV7511_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEBUG_VM_PGTABLE: u32 = 1;
pub const CONFIG_MAX1118_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_INEXIO_MODULE: u32 = 1;
pub const CONFIG_RTLBTCOEXIST_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_NC: u32 = 1;
pub const CONFIG_NFT_NAT_MODULE: u32 = 1;
pub const CONFIG_DW_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_POLYNOMIAL_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_WM831X_MODULE: u32 = 1;
pub const CONFIG_ZRAM_WRITEBACK: u32 = 1;
pub const CONFIG_NEED_PER_CPU_EMBED_FIRST_CHUNK: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM9705: u32 = 1;
pub const CONFIG_INPUT_KEYBOARD: u32 = 1;
pub const CONFIG_BAREUDP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ABITUGURU_MODULE: u32 = 1;
pub const CONFIG_INET_TABLE_PERTURB_ORDER: u32 = 16;
pub const CONFIG_ARCH_SUPPORTS_INT128: u32 = 1;
pub const CONFIG_IP_NF_TARGET_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_MEMORY_ISOLATION: u32 = 1;
pub const CONFIG_SLUB_CPU_PARTIAL: u32 = 1;
pub const CONFIG_USB_C67X00_HCD_MODULE: u32 = 1;
pub const CONFIG_RFS_ACCEL: u32 = 1;
pub const CONFIG_COMEDI_TEST_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_RT288X: u32 = 1;
pub const CONFIG_IP_NF_TARGET_REDIRECT_MODULE: u32 = 1;
pub const CONFIG_SERIO_ALTERA_PS2_MODULE: u32 = 1;
pub const CONFIG_DRM_GMA500_MODULE: u32 = 1;
pub const CONFIG_SCSI_MPI3MR_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANTS_THP_SWAP: u32 = 1;
pub const CONFIG_CRC32: u32 = 1;
pub const CONFIG_DRM_XE_JOB_TIMEOUT_MAX: u32 = 10000;
pub const CONFIG_SND_SOC_MAX98396_MODULE: u32 = 1;
pub const CONFIG_I2C_BOARDINFO: u32 = 1;
pub const CONFIG_ATH9K_HTC_DEBUGFS: u32 = 1;
pub const CONFIG_DWC_XLGMAC_PCI_MODULE: u32 = 1;
pub const CONFIG_TI_ADC12138_MODULE: u32 = 1;
pub const CONFIG_DMI_SYSFS_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_LTLK_MODULE: u32 = 1;
pub const CONFIG_XEN_PV: u32 = 1;
pub const CONFIG_DRM_VKMS_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_PROTO: u32 = 1;
pub const CONFIG_USB_ALI_M5632: u32 = 1;
pub const CONFIG_NFT_FIB_INET_MODULE: u32 = 1;
pub const CONFIG_DM_SNAPSHOT_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM831X_MODULE: u32 = 1;
pub const CONFIG_IP_VS_MH_MODULE: u32 = 1;
pub const CONFIG_MFD_WM831X_I2C: u32 = 1;
pub const CONFIG_IMA_APPRAISE_BOOTPARAM: u32 = 1;
pub const CONFIG_CAIF_MODULE: u32 = 1;
pub const CONFIG_MEMREGION: u32 = 1;
pub const CONFIG_PNFS_FLEXFILE_LAYOUT_MODULE: u32 = 1;
pub const CONFIG_IR_JVC_DECODER_MODULE: u32 = 1;
pub const CONFIG_ZERO_CALL_USED_REGS: u32 = 1;
pub const CONFIG_X86_MCE: u32 = 1;
pub const CONFIG_PCMCIA_QLOGIC_MODULE: u32 = 1;
pub const CONFIG_SIGNED_PE_FILE_VERIFICATION: u32 = 1;
pub const CONFIG_USB_CONFIGFS_NCM: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_MODULE: u32 = 1;
pub const CONFIG_FSCACHE: u32 = 1;
pub const CONFIG_UNICODE: u32 = 1;
pub const CONFIG_COMEDI_USBDUX_MODULE: u32 = 1;
pub const CONFIG_PARPORT_NOT_PC: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CPU_MODULE: u32 = 1;
pub const CONFIG_DVB_ISL6405_MODULE: u32 = 1;
pub const CONFIG_B43_BCMA_PIO: u32 = 1;
pub const CONFIG_AD7192_MODULE: u32 = 1;
pub const CONFIG_MOUSE_ELAN_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_SNP_CORE_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF85363_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CURVE25519_X86_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX1668_MODULE: u32 = 1;
pub const CONFIG_BLK_SED_OPAL: u32 = 1;
pub const CONFIG_MEDIATEK_MT6370_ADC_MODULE: u32 = 1;
pub const CONFIG_GPIO_AMD8111_MODULE: u32 = 1;
pub const CONFIG_SUNRPC_SWAP: u32 = 1;
pub const CONFIG_FB_TILEBLITTING: u32 = 1;
pub const CONFIG_TCM_QLA2XXX_MODULE: u32 = 1;
pub const CONFIG_KEY_DH_OPERATIONS: u32 = 1;
pub const CONFIG_IR_MCE_KBD_DECODER_MODULE: u32 = 1;
pub const CONFIG_MFD_RT5033_MODULE: u32 = 1;
pub const CONFIG_HSR_MODULE: u32 = 1;
pub const CONFIG_IXGBE_DCB: u32 = 1;
pub const CONFIG_NET_DSA_TAG_QCA_MODULE: u32 = 1;
pub const CONFIG_SECCOMP: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_CONSERVATIVE: u32 = 1;
pub const CONFIG_HIGH_RES_TIMERS: u32 = 1;
pub const CONFIG_PCMCIA_AXNET_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_WM831X_MODULE: u32 = 1;
pub const CONFIG_KGDB_HONOUR_BLOCKLIST: u32 = 1;
pub const CONFIG_BE2NET_LANCER: u32 = 1;
pub const CONFIG_PVPANIC_MMIO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_WM8739_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_SET_MEMORY: u32 = 1;
pub const CONFIG_DRM_AMD_DC: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_MAX_AUDIT_LOG: u32 = 1024;
pub const CONFIG_BLK_DEV_DM: u32 = 1;
pub const CONFIG_RTC_DRV_88PM80X_MODULE: u32 = 1;
pub const CONFIG_SWIOTLB_DYNAMIC: u32 = 1;
pub const CONFIG_WWAN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_KBL_RT5660_MACH_MODULE: u32 = 1;
pub const CONFIG_PWM_TWL_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT3573: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_SSP_AMP_MACH_MODULE: u32 = 1;
pub const CONFIG_VLAN_8021Q_MODULE: u32 = 1;
pub const CONFIG_IP_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_MTRR_SANITIZER_SPARE_REG_NR_DEFAULT: u32 = 1;
pub const CONFIG_VFIO_PCI_VGA: u32 = 1;
pub const CONFIG_ACPI_BGRT: u32 = 1;
pub const CONFIG_SND_SOC_PCM1789_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_REALTEK_COMMON_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4260_MODULE: u32 = 1;
pub const CONFIG_UEVENT_HELPER: u32 = 1;
pub const CONFIG_CRYPTO_KEYWRAP_MODULE: u32 = 1;
pub const CONFIG_XEN_DOM0: u32 = 1;
pub const CONFIG_FIRMWARE_MEMMAP: u32 = 1;
pub const CONFIG_SSB_SDIOHOST: u32 = 1;
pub const CONFIG_BT_RFCOMM_MODULE: u32 = 1;
pub const CONFIG_FIX_EARLYCON_MEM: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_HEARTBEAT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MPQ7932_MODULE: u32 = 1;
pub const CONFIG_RAS_CEC: u32 = 1;
pub const CONFIG_INTEL_PUNIT_IPC_MODULE: u32 = 1;
pub const CONFIG_BLK_INLINE_ENCRYPTION: u32 = 1;
pub const CONFIG_FB_TFT_HX8353D_MODULE: u32 = 1;
pub const CONFIG_ND_PFN_MODULE: u32 = 1;
pub const CONFIG_CHARGER_LP8727_MODULE: u32 = 1;
pub const CONFIG_SCSI_INITIO_MODULE: u32 = 1;
pub const CONFIG_STK8BA50_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA1004X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_DA9211_MODULE: u32 = 1;
pub const CONFIG_RFD77402_MODULE: u32 = 1;
pub const CONFIG_INPUT_RETU_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ELAN: u32 = 1;
pub const CONFIG_JOYSTICK_ADI_MODULE: u32 = 1;
pub const CONFIG_DVB_BCM3510_MODULE: u32 = 1;
pub const CONFIG_INOTIFY_USER: u32 = 1;
pub const CONFIG_SND_SOC_RT286_MODULE: u32 = 1;
pub const CONFIG_PWM_DWC_CORE_MODULE: u32 = 1;
pub const CONFIG_WDAT_WDT_MODULE: u32 = 1;
pub const CONFIG_SECURITY_NETWORK_XFRM: u32 = 1;
pub const CONFIG_MHI_BUS_EP_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_NETBIOS_NS_MODULE: u32 = 1;
pub const CONFIG_HDMI: u32 = 1;
pub const CONFIG_MULTIPLEXER_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH: u32 = 1;
pub const CONFIG_SCSI_LOGGING: u32 = 1;
pub const CONFIG_DRM_I2C_NXP_TDA9950_MODULE: u32 = 1;
pub const CONFIG_SAMPLES: u32 = 1;
pub const CONFIG_SX9500_MODULE: u32 = 1;
pub const CONFIG_FB_CYBER2000_DDC: u32 = 1;
pub const CONFIG_BRIDGE_EBT_T_FILTER_MODULE: u32 = 1;
pub const CONFIG_NETWORK_FILESYSTEMS: u32 = 1;
pub const CONFIG_SND_SOC_AMD_YC_MACH_MODULE: u32 = 1;
pub const CONFIG_IRQ_POLL: u32 = 1;
pub const CONFIG_JOYSTICK_IFORCE_232_MODULE: u32 = 1;
pub const CONFIG_B53_SERDES_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_LOOPBACK_MODULE: u32 = 1;
pub const CONFIG_HID_MCP2221_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_SPI_CR50: u32 = 1;
pub const CONFIG_KVM_INTEL_MODULE: u32 = 1;
pub const CONFIG_ASUS_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_NF_FLOW_TABLE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MD4_MODULE: u32 = 1;
pub const CONFIG_BCMA_HOST_PCI: u32 = 1;
pub const CONFIG_AD7298_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_METEORLAKE_MODULE: u32 = 1;
pub const CONFIG_SATA_AHCI_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_USB_SI470X_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_BANG_BANG: u32 = 1;
pub const CONFIG_X86_MINIMUM_CPU_FAMILY: u32 = 64;
pub const CONFIG_AD7923_MODULE: u32 = 1;
pub const CONFIG_SND_I2S_HI6210_I2S_MODULE: u32 = 1;
pub const CONFIG_SCSI_BFA_FC_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_ONDEMAND: u32 = 1;
pub const CONFIG_KDB_DEFAULT_ENABLE: u32 = 1;
pub const CONFIG_MAX34408_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM95245_MODULE: u32 = 1;
pub const CONFIG_POWER_RESET_TPS65086: u32 = 1;
pub const CONFIG_USB_GSPCA_JL2005BCD_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MC13XXX_MODULE: u32 = 1;
pub const CONFIG_CM36651_MODULE: u32 = 1;
pub const CONFIG_AMD_PHY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX18_ALSA_MODULE: u32 = 1;
pub const CONFIG_AD5770R_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBFUSB_MODULE: u32 = 1;
pub const CONFIG_FS_ENCRYPTION_INLINE_CRYPT: u32 = 1;
pub const CONFIG_MFD_CS47L24: u32 = 1;
pub const CONFIG_FB_CORE: u32 = 1;
pub const CONFIG_GLOB: u32 = 1;
pub const CONFIG_ARCH_WANT_LD_ORPHAN_WARN: u32 = 1;
pub const CONFIG_SND_SOC_CS42L73_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL_SOUNDWIRE_ACPI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AEGIS128_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SY7636A_MODULE: u32 = 1;
pub const CONFIG_PARAVIRT_SPINLOCKS: u32 = 1;
pub const CONFIG_CGROUP_DEVICE: u32 = 1;
pub const CONFIG_WL12XX_MODULE: u32 = 1;
pub const CONFIG_X86_TSC: u32 = 1;
pub const CONFIG_104_QUAD_8_MODULE: u32 = 1;
pub const CONFIG_PPP_SYNC_TTY_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MCDI_MON: u32 = 1;
pub const CONFIG_FXLS8962AF_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUSPEND_POSSIBLE: u32 = 1;
pub const CONFIG_HID_PLANTRONICS_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS65090: u32 = 1;
pub const CONFIG_MMU_LAZY_TLB_REFCOUNT: u32 = 1;
pub const CONFIG_DA9055_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_COMPAT_NETLINK_MESSAGES: u32 = 1;
pub const CONFIG_RC_CORE_MODULE: u32 = 1;
pub const CONFIG_TCG_VTPM_PROXY_MODULE: u32 = 1;
pub const CONFIG_USB_G_SERIAL_MODULE: u32 = 1;
pub const CONFIG_CGROUP_WRITEBACK: u32 = 1;
pub const CONFIG_PSTORE_DEFAULT_KMSG_BYTES: u32 = 10240;
pub const CONFIG_SND_SOC_TPA6130A2_MODULE: u32 = 1;
pub const CONFIG_MISC_ALCOR_PCI_MODULE: u32 = 1;
pub const CONFIG_MAC80211_STA_HASH_MAX_SIZE: u32 = 0;
pub const CONFIG_LEDS_PCA955X_MODULE: u32 = 1;
pub const CONFIG_HAVE_OBJTOOL_NOP_MCOUNT: u32 = 1;
pub const CONFIG_NLS_MAC_TURKISH_MODULE: u32 = 1;
pub const CONFIG_IXGBE_IPSEC: u32 = 1;
pub const CONFIG_IP_VS_NQ_MODULE: u32 = 1;
pub const CONFIG_DVB_DRXD_MODULE: u32 = 1;
pub const CONFIG_IR_IMON_DECODER_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_QEDR_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4245_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_MMAP_RND_BITS: u32 = 1;
pub const CONFIG_TCG_TIS_CORE: u32 = 1;
pub const CONFIG_AMD_HSMP_MODULE: u32 = 1;
pub const CONFIG_YOGABOOK_MODULE: u32 = 1;
pub const CONFIG_HID_SPEEDLINK_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_APOLLO_MODULE: u32 = 1;
pub const CONFIG_HIBERNATION: u32 = 1;
pub const CONFIG_BLK_DEV_NBD_MODULE: u32 = 1;
pub const CONFIG_NTB_EPF_MODULE: u32 = 1;
pub const CONFIG_PNPACPI: u32 = 1;
pub const CONFIG_USB_CDNS2_UDC_MODULE: u32 = 1;
pub const CONFIG_I8254_MODULE: u32 = 1;
pub const CONFIG_AD7280_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_SOF_MACH_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_NAVMAN_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_ATTR_SET: u32 = 1;
pub const CONFIG_RMI4_F12: u32 = 1;
pub const CONFIG_JOYSTICK_SPACEORB_MODULE: u32 = 1;
pub const CONFIG_ACPI_TAD_MODULE: u32 = 1;
pub const CONFIG_EDAC_I5400_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_HTCP_MODULE: u32 = 1;
pub const CONFIG_EXT4_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_SERIAL_RP2_MODULE: u32 = 1;
pub const CONFIG_SCSI_DEBUG_MODULE: u32 = 1;
pub const CONFIG_NET_SWITCHDEV: u32 = 1;
pub const CONFIG_SF_PDMA_MODULE: u32 = 1;
pub const CONFIG_PHYLINK_MODULE: u32 = 1;
pub const CONFIG_ZSTD_COMPRESS: u32 = 1;
pub const CONFIG_XEN_GRANT_DMA_ALLOC: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOUNDWIRE_SOF_MACH_MODULE: u32 = 1;
pub const CONFIG_IPV6_IOAM6_LWTUNNEL: u32 = 1;
pub const CONFIG_DRM_I915_MODULE: u32 = 1;
pub const CONFIG_BINFMT_MISC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AD7314_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_KBL_MODULE: u32 = 1;
pub const CONFIG_RTW89_DEBUGMSG: u32 = 1;
pub const CONFIG_CXL_SUSPEND: u32 = 1;
pub const CONFIG_SND_SOC_PCM179X_I2C_MODULE: u32 = 1;
pub const CONFIG_CXL_PORT_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_HELPER_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6397_MODULE: u32 = 1;
pub const CONFIG_SSB_POSSIBLE: u32 = 1;
pub const CONFIG_SND_SOC_PEB2466_MODULE: u32 = 1;
pub const CONFIG_HPET_MMAP_DEFAULT: u32 = 1;
pub const CONFIG_NFS_V4_2: u32 = 1;
pub const CONFIG_USBIP_VUDC_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_T_NAT_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_SIP_MODULE: u32 = 1;
pub const CONFIG_HAVE_OBJTOOL: u32 = 1;
pub const CONFIG_USB_F_EEM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83792D_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INA3221_MODULE: u32 = 1;
pub const CONFIG_MMU_NOTIFIER: u32 = 1;
pub const CONFIG_SYSV68_PARTITION: u32 = 1;
pub const CONFIG_RADIO_SHARK_MODULE: u32 = 1;
pub const CONFIG_ASYMMETRIC_KEY_TYPE: u32 = 1;
pub const CONFIG_VFIO_VIRQFD: u32 = 1;
pub const CONFIG_SCSI_UFS_CRYPTO: u32 = 1;
pub const CONFIG_VHOST_VSOCK_MODULE: u32 = 1;
pub const CONFIG_NET_9P_RDMA_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_ELANTECH_SMBUS: u32 = 1;
pub const CONFIG_TRANSPARENT_HUGEPAGE_MADVISE: u32 = 1;
pub const CONFIG_DRM_RADEON_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_STATISTIC_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_PCIMIO_MODULE: u32 = 1;
pub const CONFIG_ACPI_PRMT: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_1032_MODULE: u32 = 1;
pub const CONFIG_TERANETICS_PHY_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_855_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_ILI9486_MODULE: u32 = 1;
pub const CONFIG_USER_EVENTS: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYT_CHT_CX2072X_MACH_MODULE: u32 = 1;
pub const CONFIG_SPI_DYNAMIC: u32 = 1;
pub const CONFIG_ARCH_CORRECT_STACKTRACE_ON_KRETPROBE: u32 = 1;
pub const CONFIG_ATH9K_COMMON_SPECTRAL: u32 = 1;
pub const CONFIG_MPTCP_IPV6: u32 = 1;
pub const CONFIG_MTD_CMDLINE_PARTS_MODULE: u32 = 1;
pub const CONFIG_TMP006_MODULE: u32 = 1;
pub const CONFIG_SECURITY_YAMA: u32 = 1;
pub const CONFIG_VIDEO_SAA7127_MODULE: u32 = 1;
pub const CONFIG_I2C_ISMT_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_FC_APPID: u32 = 1;
pub const CONFIG_AD5758_MODULE: u32 = 1;
pub const CONFIG_UHID_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_ATMEL_ECC_MODULE: u32 = 1;
pub const CONFIG_NETCONSOLE_DYNAMIC: u32 = 1;
pub const CONFIG_UBSAN_BOUNDS: u32 = 1;
pub const CONFIG_EDAC_I5100_MODULE: u32 = 1;
pub const CONFIG_DVB_EC100_MODULE: u32 = 1;
pub const CONFIG_IP_NF_NAT_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_EDGEPORT_TI_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_HID_MODULE: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_SIGNATURE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF50633_MODULE: u32 = 1;
pub const CONFIG_HDLC_RAW_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_LEDS: u32 = 1;
pub const CONFIG_BME680_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SAFE_MODULE: u32 = 1;
pub const CONFIG_NFC_NCI_UART_MODULE: u32 = 1;
pub const CONFIG_DVB_LGS8GL5_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_HDCP_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_NF_EBTABLES_MODULE: u32 = 1;
pub const CONFIG_HARDLOCKUP_DETECTOR_PERF: u32 = 1;
pub const CONFIG_DVB_LG2160_MODULE: u32 = 1;
pub const CONFIG_MTD_AMD76XROM_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_COMPRESS: u32 = 1;
pub const CONFIG_USB_OHCI_LITTLE_ENDIAN: u32 = 1;
pub const CONFIG_NET_SCH_FIFO: u32 = 1;
pub const CONFIG_WILC1000_SPI_MODULE: u32 = 1;
pub const CONFIG_REISERFS_FS_MODULE: u32 = 1;
pub const CONFIG_SWPHY: u32 = 1;
pub const CONFIG_STM_SOURCE_CONSOLE_MODULE: u32 = 1;
pub const CONFIG_TWL4030_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_THP_SWAP: u32 = 1;
pub const CONFIG_SATA_NV_MODULE: u32 = 1;
pub const CONFIG_FSNOTIFY: u32 = 1;
pub const CONFIG_ACPI_CONFIGFS_MODULE: u32 = 1;
pub const CONFIG_LEDS_MAX8997_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_LOOP_MIN_COUNT: u32 = 8;
pub const CONFIG_STP_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SQ905_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS65910: u32 = 1;
pub const CONFIG_SPI_CADENCE_MODULE: u32 = 1;
pub const CONFIG_DVB_AU8522_MODULE: u32 = 1;
pub const CONFIG_INET6_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_NVDIMM_KEYS: u32 = 1;
pub const CONFIG_REGULATOR_MAX8925_MODULE: u32 = 1;
pub const CONFIG_INTEL_RAPL_MODULE: u32 = 1;
pub const CONFIG_VIDEO_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI_DC395x_MODULE: u32 = 1;
pub const CONFIG_AS_WRUSS: u32 = 1;
pub const CONFIG_DVB_M88RS2000_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SIP_MODULE: u32 = 1;
pub const CONFIG_STACK_TRACER: u32 = 1;
pub const CONFIG_MEDIA_ATTACH: u32 = 1;
pub const CONFIG_SND_NM256_MODULE: u32 = 1;
pub const CONFIG_UCLAMP_BUCKETS_COUNT: u32 = 5;
pub const CONFIG_CRYPTO_MANAGER_DISABLE_TESTS: u32 = 1;
pub const CONFIG_SENSORS_RM3100_MODULE: u32 = 1;
pub const CONFIG_HIDRAW: u32 = 1;
pub const CONFIG_NET_SCH_FQ_CODEL_MODULE: u32 = 1;
pub const CONFIG_WIL6210_ISR_COR: u32 = 1;
pub const CONFIG_SENSORS_ADM1025_MODULE: u32 = 1;
pub const CONFIG_HAVE_KERNEL_LZMA: u32 = 1;
pub const CONFIG_CEC_GPIO_MODULE: u32 = 1;
pub const CONFIG_HID_PRODIKEYS_MODULE: u32 = 1;
pub const CONFIG_NET_TC_SKB_EXT: u32 = 1;
pub const CONFIG_RT2X00_LIB_LEDS: u32 = 1;
pub const CONFIG_LIQUIDIO_CORE_MODULE: u32 = 1;
pub const CONFIG_RTL8XXXU_UNTESTED: u32 = 1;
pub const CONFIG_NET_PTP_CLASSIFY: u32 = 1;
pub const CONFIG_UNIX_DIAG_MODULE: u32 = 1;
pub const CONFIG_TSYS02D_MODULE: u32 = 1;
pub const CONFIG_VCNL4000_MODULE: u32 = 1;
pub const CONFIG_AL3010_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3168A_SPI_MODULE: u32 = 1;
pub const CONFIG_IP_VS_SED_MODULE: u32 = 1;
pub const CONFIG_GENERIC_SMP_IDLE_THREAD: u32 = 1;
pub const CONFIG_CRYPTO_SM3_GENERIC_MODULE: u32 = 1;
pub const CONFIG_HID_COUGAR_MODULE: u32 = 1;
pub const CONFIG_MOUSE_CYAPA_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_QUALCOMM: u32 = 1;
pub const CONFIG_DVB_DS3000_MODULE: u32 = 1;
pub const CONFIG_CHARGER_LT3651_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_IPC: u32 = 1;
pub const CONFIG_FB_S1D13XXX_MODULE: u32 = 1;
pub const CONFIG_MTD_SST25L_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_NUMA_BALANCING: u32 = 1;
pub const CONFIG_SD_ADC_MODULATOR_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LP3971_MODULE: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_MIDI_V2: u32 = 1;
pub const CONFIG_DM_FLAKEY_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_GRAPH_RETVAL: u32 = 1;
pub const CONFIG_VME_USER_MODULE: u32 = 1;
pub const CONFIG_PATA_OPTIDMA_MODULE: u32 = 1;
pub const CONFIG_MACVTAP_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_DEBUG: u32 = 1;
pub const CONFIG_LEDS_REGULATOR_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T4VF_MODULE: u32 = 1;
pub const CONFIG_CPUMASK_OFFSTACK: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_CRASH_DUMP: u32 = 1;
pub const CONFIG_USB_SERIAL_FTDI_SIO_MODULE: u32 = 1;
pub const CONFIG_EXTCON_RT8973A_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_EZCHIP: u32 = 1;
pub const CONFIG_MFD_CS42L43_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_REDIRECT_MODULE: u32 = 1;
pub const CONFIG_XEN_COMPAT_XENFS: u32 = 1;
pub const CONFIG_XEN_SCSI_BACKEND_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_PCI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_TIOCMD_MODULE: u32 = 1;
pub const CONFIG_MEDIA_DIGITAL_TV_SUPPORT: u32 = 1;
pub const CONFIG_RV_REACTORS: u32 = 1;
pub const CONFIG_8139CP_MODULE: u32 = 1;
pub const CONFIG_LDISC_AUTOLOAD: u32 = 1;
pub const CONFIG_GREYBUS_ES2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CROS_EC_CODEC_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_RSA: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L56_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_QM1D1B0004_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_OCELOT_8021Q_MODULE: u32 = 1;
pub const CONFIG_FIB_RULES: u32 = 1;
pub const CONFIG_HID_ACRUX_FF: u32 = 1;
pub const CONFIG_PINCTRL_ALDERLAKE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRCT10DIF: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2408_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_OBEX: u32 = 1;
pub const CONFIG_RTC_DRV_MCP795_MODULE: u32 = 1;
pub const CONFIG_DVB_FIREDTV_INPUT: u32 = 1;
pub const CONFIG_SND_SOC_ADI_AXI_I2S_MODULE: u32 = 1;
pub const CONFIG_SND_ES1968_INPUT: u32 = 1;
pub const CONFIG_SCSI_MYRB_MODULE: u32 = 1;
pub const CONFIG_IP_VS_NFCT: u32 = 1;
pub const CONFIG_HID_EMS_FF_MODULE: u32 = 1;
pub const CONFIG_NTB_MSI: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_16XX_MODULE: u32 = 1;
pub const CONFIG_USB_AUTOSUSPEND_DELAY: u32 = 2;
pub const CONFIG_VLAN_8021Q_GVRP: u32 = 1;
pub const CONFIG_VDPA_USER_MODULE: u32 = 1;
pub const CONFIG_IWLWIFI_DEBUGFS: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETIFACE_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_KMSG_SIZE: u32 = 64;
pub const CONFIG_IP6_NF_MANGLE_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_DSA_MODULE: u32 = 1;
pub const CONFIG_MTD_PLATRAM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8316_MODULE: u32 = 1;
pub const CONFIG_SYSFB_SIMPLEFB: u32 = 1;
pub const CONFIG_SIOX_BUS_GPIO_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_SI2157_MODULE: u32 = 1;
pub const CONFIG_SCSI_CONSTANTS: u32 = 1;
pub const CONFIG_HAVE_KVM_DIRTY_RING_ACQ_REL: u32 = 1;
pub const CONFIG_HAVE_IRQ_TIME_ACCOUNTING: u32 = 1;
pub const CONFIG_CFAG12864B_MODULE: u32 = 1;
pub const CONFIG_BT_MRVL_SDIO_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_REALM_MODULE: u32 = 1;
pub const CONFIG_MFD_ATC260X_MODULE: u32 = 1;
pub const CONFIG_SFC_FALCON_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBPA10X_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_OCELOT_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_NEWGEN: u32 = 1;
pub const CONFIG_INTEL_TXT: u32 = 1;
pub const CONFIG_HID_GFRM_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_XATTR: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ_COMMON_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEVMEM_IS_ALLOWED: u32 = 1;
pub const CONFIG_IP_VS_RR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_MAX98090_TI_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1019_MODULE: u32 = 1;
pub const CONFIG_IPV6: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BDW_RT5650_MACH_MODULE: u32 = 1;
pub const CONFIG_ALTERA_PR_IP_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_QUALCOMM_MODULE: u32 = 1;
pub const CONFIG_HAVE_STACKPROTECTOR: u32 = 1;
pub const CONFIG_MAX1027_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_HFI1_MODULE: u32 = 1;
pub const CONFIG_VIDEO_S5K6A3_MODULE: u32 = 1;
pub const CONFIG_MT76x02_LIB_MODULE: u32 = 1;
pub const CONFIG_NET_9P_MODULE: u32 = 1;
pub const CONFIG_NET_HANDSHAKE: u32 = 1;
pub const CONFIG_REGULATOR_TPS62360_MODULE: u32 = 1;
pub const CONFIG_USB_GADGET_TARGET_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AEAD: u32 = 1;
pub const CONFIG_FB_HECUBA_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_BPCK_MODULE: u32 = 1;
pub const CONFIG_AUDIT_ARCH: u32 = 1;
pub const CONFIG_NET_EMATCH_IPT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83773G_MODULE: u32 = 1;
pub const CONFIG_COMPAT: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_ES8336_MODULE: u32 = 1;
pub const CONFIG_POWERCAP: u32 = 1;
pub const CONFIG_I2C_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_DEFAULT_GOV_SCHEDUTIL: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ_SERIAL: u32 = 1;
pub const CONFIG_TOUCHSCREEN_NOVATEK_NVT_TS_MODULE: u32 = 1;
pub const CONFIG_LIQUIDIO_VF_MODULE: u32 = 1;
pub const CONFIG_BQL: u32 = 1;
pub const CONFIG_ADJD_S311_MODULE: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_PSAUX: u32 = 1;
pub const CONFIG_ARCH_WANT_OPTIMIZE_DAX_VMEMMAP: u32 = 1;
pub const CONFIG_RESET_TI_SYSCON_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCA953X_IRQ: u32 = 1;
pub const CONFIG_HAVE_KERNEL_BZIP2: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_3501_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_TCP_CONG: &[u8; 6usize] = b"cubic\0";
pub const CONFIG_MOST_NET_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_FSL_MODULE: u32 = 1;
pub const CONFIG_INTEL_CHTWC_INT33FE_MODULE: u32 = 1;
pub const CONFIG_MCP4725_MODULE: u32 = 1;
pub const CONFIG_UEVENT_HELPER_PATH: &[u8; 1usize] = b"\0";
pub const CONFIG_USB_UAS_MODULE: u32 = 1;
pub const CONFIG_U_SERIAL_CONSOLE: u32 = 1;
pub const CONFIG_VIDEO_MT9M001_MODULE: u32 = 1;
pub const CONFIG_ORANGEFS_FS_MODULE: u32 = 1;
pub const CONFIG_NTB_NETDEV_MODULE: u32 = 1;
pub const CONFIG_DEVTMPFS: u32 = 1;
pub const CONFIG_NET_CLS_FLOW_MODULE: u32 = 1;
pub const CONFIG_PROCESSOR_SELECT: u32 = 1;
pub const CONFIG_PCENGINES_APU2_MODULE: u32 = 1;
pub const CONFIG_X86_INTEL_TSX_MODE_OFF: u32 = 1;
pub const CONFIG_TIGON3_HWMON: u32 = 1;
pub const CONFIG_SENSORS_MAX8688_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PC87427_MODULE: u32 = 1;
pub const CONFIG_INPUT_MAX77693_HAPTIC_MODULE: u32 = 1;
pub const CONFIG_SM_FTL_MODULE: u32 = 1;
pub const CONFIG_TI_ADC108S102_MODULE: u32 = 1;
pub const CONFIG_PNFS_FILE_LAYOUT_MODULE: u32 = 1;
pub const CONFIG_MCB_LPC_MODULE: u32 = 1;
pub const CONFIG_QED_SRIOV: u32 = 1;
pub const CONFIG_HSU_DMA: u32 = 1;
pub const CONFIG_I82092_MODULE: u32 = 1;
pub const CONFIG_NET_IPVTI_MODULE: u32 = 1;
pub const CONFIG_SCSI_PMCRAID_MODULE: u32 = 1;
pub const CONFIG_NFC_NXP_NCI_MODULE: u32 = 1;
pub const CONFIG_DVB_ISL6423_MODULE: u32 = 1;
pub const CONFIG_FB_S3_DDC: u32 = 1;
pub const CONFIG_USB_STORAGE_USBAT_MODULE: u32 = 1;
pub const CONFIG_DEBUG_INFO_BTF: u32 = 1;
pub const CONFIG_REISERFS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_SND_FIREWIRE_DIGI00X_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_USER_MEM: u32 = 1;
pub const CONFIG_REGULATOR_ARIZONA_LDO1_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX7301_MODULE: u32 = 1;
pub const CONFIG_INPUT_88PM80X_ONKEY_MODULE: u32 = 1;
pub const CONFIG_APPLE_GMUX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_TOPLEVEL_MODULE: u32 = 1;
pub const CONFIG_YENTA_RICOH: u32 = 1;
pub const CONFIG_SUNRPC_BACKCHANNEL: u32 = 1;
pub const CONFIG_NLS_ISO8859_7_MODULE: u32 = 1;
pub const CONFIG_HID_EVISION_MODULE: u32 = 1;
pub const CONFIG_QEDF_MODULE: u32 = 1;
pub const CONFIG_ANDROID_BINDER_IPC_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_SMBUS: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC32X4_SPI_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_IDT82P33_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_PCBC_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_REJECT_MODULE: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_COMPAT_BITS_MAX: u32 = 16;
pub const CONFIG_PINCTRL_LYNXPOINT_MODULE: u32 = 1;
pub const CONFIG_UPROBES: u32 = 1;
pub const CONFIG_PWM_PCA9685_MODULE: u32 = 1;
pub const CONFIG_IR_SHARP_DECODER_MODULE: u32 = 1;
pub const CONFIG_HID_APPLEIR_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCL812_MODULE: u32 = 1;
pub const CONFIG_NFC_FDP_MODULE: u32 = 1;
pub const CONFIG_CHARGER_RT9471_MODULE: u32 = 1;
pub const CONFIG_ASYNC_MEMCPY_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8998_MODULE: u32 = 1;
pub const CONFIG_ADIS16480_MODULE: u32 = 1;
pub const CONFIG_AD7292_MODULE: u32 = 1;
pub const CONFIG_X86_POWERNOW_K8: u32 = 1;
pub const CONFIG_ARCH_SPARSEMEM_ENABLE: u32 = 1;
pub const CONFIG_V4L_TEST_DRIVERS: u32 = 1;
pub const CONFIG_SENSORS_TDA38640_REGULATOR: u32 = 1;
pub const CONFIG_NFT_OSF_MODULE: u32 = 1;
pub const CONFIG_SC1200_WDT_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_REDIRECT: u32 = 1;
pub const CONFIG_DCDBAS_MODULE: u32 = 1;
pub const CONFIG_CIO_DAC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1305_MODULE: u32 = 1;
pub const CONFIG_I2C_HID_ACPI_MODULE: u32 = 1;
pub const CONFIG_SFP_MODULE: u32 = 1;
pub const CONFIG_IR_NEC_DECODER_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_CPU: u32 = 1;
pub const CONFIG_SECURITY_LOCKDOWN_LSM: u32 = 1;
pub const CONFIG_MUX_ADGS1408_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MOS7840_MODULE: u32 = 1;
pub const CONFIG_MAXLINEAR_GPHY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_GENERIC_DMAENGINE_PCM: u32 = 1;
pub const CONFIG_INET_DIAG_DESTROY: u32 = 1;
pub const CONFIG_NLS_MAC_CYRILLIC_MODULE: u32 = 1;
pub const CONFIG_MICROCHIP_T1S_PHY_MODULE: u32 = 1;
pub const CONFIG_USB_SL811_HCD_ISO: u32 = 1;
pub const CONFIG_PM_SLEEP_DEBUG: u32 = 1;
pub const CONFIG_SND_MAESTRO3_INPUT: u32 = 1;
pub const CONFIG_MEDIA_PCI_SUPPORT: u32 = 1;
pub const CONFIG_NVME_TARGET_AUTH: u32 = 1;
pub const CONFIG_WLAN: u32 = 1;
pub const CONFIG_EDAC_I10NM_MODULE: u32 = 1;
pub const CONFIG_AFFS_FS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_1516_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ATC260X_MODULE: u32 = 1;
pub const CONFIG_NFP_MODULE: u32 = 1;
pub const CONFIG_NAMESPACES: u32 = 1;
pub const CONFIG_VIDEO_AK881X_MODULE: u32 = 1;
pub const CONFIG_USB_U_AUDIO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_HI846_MODULE: u32 = 1;
pub const CONFIG_BLK_RQ_ALLOC_TIME: u32 = 1;
pub const CONFIG_TIMERLAT_TRACER: u32 = 1;
pub const CONFIG_SENSORS_ADM1177_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2423_MODULE: u32 = 1;
pub const CONFIG_L2TP_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_XEN_512GB: u32 = 1;
pub const CONFIG_HAVE_CMPXCHG_DOUBLE: u32 = 1;
pub const CONFIG_AMD_PTDMA_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_SYSFS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ABX80X_MODULE: u32 = 1;
pub const CONFIG_USB_NET_INT51X1_MODULE: u32 = 1;
pub const CONFIG_KGDB_SERIAL_CONSOLE: u32 = 1;
pub const CONFIG_PATA_PARPORT_KTTI_MODULE: u32 = 1;
pub const CONFIG_PATA_ATP867X_MODULE: u32 = 1;
pub const CONFIG_TYPEC_STUSB160X_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_MEMREMAP_PROT: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_SHARED_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_HUGE_VMAP: u32 = 1;
pub const CONFIG_FM10K_MODULE: u32 = 1;
pub const CONFIG_DW_DMAC_PCI_MODULE: u32 = 1;
pub const CONFIG_IA32_EMULATION: u32 = 1;
pub const CONFIG_SND_SOC_SIGMADSP_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_KTZ8866_MODULE: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE_DETECT_PRIMARY: u32 = 1;
pub const CONFIG_DRM_GEM_DMA_HELPER_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_MODULE: u32 = 1;
pub const CONFIG_FORTIFY_SOURCE: u32 = 1;
pub const CONFIG_COMEDI_CONTEC_PCI_DIO_MODULE: u32 = 1;
pub const CONFIG_AXP20X_ADC_MODULE: u32 = 1;
pub const CONFIG_SECURITY_DMESG_RESTRICT: u32 = 1;
pub const CONFIG_BLK_DEV_BSG: u32 = 1;
pub const CONFIG_CRYPTO_ADIANTUM_MODULE: u32 = 1;
pub const CONFIG_LEDS_WM8350_MODULE: u32 = 1;
pub const CONFIG_ENIC_MODULE: u32 = 1;
pub const CONFIG_SCSI_ISCI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6697_MODULE: u32 = 1;
pub const CONFIG_PATA_SERVERWORKS_MODULE: u32 = 1;
pub const CONFIG_CONNECTOR: u32 = 1;
pub const CONFIG_COMEDI_DAS16M1_MODULE: u32 = 1;
pub const CONFIG_SND_SST_ATOM_HIFI2_PLATFORM_ACPI_MODULE: u32 = 1;
pub const CONFIG_MEDIA_USB_SUPPORT: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_RATEEST_MODULE: u32 = 1;
pub const CONFIG_PCIEAER: u32 = 1;
pub const CONFIG_X86_AMD_PSTATE: u32 = 1;
pub const CONFIG_CRYPTO_ARCH_HAVE_LIB_CHACHA_MODULE: u32 = 1;
pub const CONFIG_EPIC100_MODULE: u32 = 1;
pub const CONFIG_SCTP_COOKIE_HMAC_SHA1: u32 = 1;
pub const CONFIG_BRIDGE_EBT_ARPREPLY_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP5_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_APPLE_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_DMA_AND_PIO_MODE: u32 = 1;
pub const CONFIG_RTC_DRV_SD3078_MODULE: u32 = 1;
pub const CONFIG_MEM_SOFT_DIRTY: u32 = 1;
pub const CONFIG_INTEGRITY: u32 = 1;
pub const CONFIG_MPL115_MODULE: u32 = 1;
pub const CONFIG_ZONEFS_FS_MODULE: u32 = 1;
pub const CONFIG_TQMX86_WDT_MODULE: u32 = 1;
pub const CONFIG_DVB_MAX_ADAPTERS: u32 = 8;
pub const CONFIG_SENSORS_SIS5595_MODULE: u32 = 1;
pub const CONFIG_EISA_PCI_EISA: u32 = 1;
pub const CONFIG_MPU3050_I2C_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AEGIS128_AESNI_SSE2_MODULE: u32 = 1;
pub const CONFIG_CW1200_WLAN_SDIO_MODULE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_QL_MODULE: u32 = 1;
pub const CONFIG_LEGACY_PTYS: u32 = 1;
pub const CONFIG_LIBERTAS_USB_MODULE: u32 = 1;
pub const CONFIG_JFS_FS_MODULE: u32 = 1;
pub const CONFIG_CAN_EMS_USB_MODULE: u32 = 1;
pub const CONFIG_XFRM_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_MENU: u32 = 1;
pub const CONFIG_CRYPTO_RNG2: u32 = 1;
pub const CONFIG_UIO_CIF_MODULE: u32 = 1;
pub const CONFIG_USB_PWC_INPUT_EVDEV: u32 = 1;
pub const CONFIG_MDIO_I2C_MODULE: u32 = 1;
pub const CONFIG_FUSION_FC_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_QUEUE_MODULE: u32 = 1;
pub const CONFIG_MFD_CROS_EC_DEV_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_CSUM_MODULE: u32 = 1;
pub const CONFIG_RTLLIB_CRYPTO_CCMP_MODULE: u32 = 1;
pub const CONFIG_CEPH_LIB_USE_DNS_RESOLVER: u32 = 1;
pub const CONFIG_DVB_CXD2880_MODULE: u32 = 1;
pub const CONFIG_THERMAL_WRITABLE_TRIPS: u32 = 1;
pub const CONFIG_SCSI_MPT3SAS_MODULE: u32 = 1;
pub const CONFIG_NFTL_RW: u32 = 1;
pub const CONFIG_MFD_MC13XXX_MODULE: u32 = 1;
pub const CONFIG_NETWORK_PHY_TIMESTAMPING: u32 = 1;
pub const CONFIG_MSDOS_FS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ISL29028_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT2811_MODULE: u32 = 1;
pub const CONFIG_USB_U_SERIAL_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_UART_MODULE: u32 = 1;
pub const CONFIG_FB_VGA16_MODULE: u32 = 1;
pub const CONFIG_SCSI_FLASHPOINT: u32 = 1;
pub const CONFIG_NET_CLS_CGROUP_MODULE: u32 = 1;
pub const CONFIG_TUN: u32 = 1;
pub const CONFIG_WLAN_VENDOR_MICROCHIP: u32 = 1;
pub const CONFIG_NET_VENDOR_DAVICOM: u32 = 1;
pub const CONFIG_SOFTIRQ_ON_OWN_STACK: u32 = 1;
pub const CONFIG_SND_SOC_ES8328_MODULE: u32 = 1;
pub const CONFIG_MB1232_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_AUDIO_CODEC: u32 = 1;
pub const CONFIG_IP_VS_FO_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SUNPLUS_MODULE: u32 = 1;
pub const CONFIG_HYPERV_TIMER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_ATOM_HIFI_EP_MODULE: u32 = 1;
pub const CONFIG_VZ89X_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DAS6402_MODULE: u32 = 1;
pub const CONFIG_ATM_IDT77252_MODULE: u32 = 1;
pub const CONFIG_DVB_AU8522_V4L_MODULE: u32 = 1;
pub const CONFIG_AD9832_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_BRIDGED_PHY_MODULE: u32 = 1;
pub const CONFIG_IIO_KFIFO_BUF_MODULE: u32 = 1;
pub const CONFIG_ENCLOSURE_SERVICES_MODULE: u32 = 1;
pub const CONFIG_ADXL355_I2C_MODULE: u32 = 1;
pub const CONFIG_UCSI_ACPI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP513_MODULE: u32 = 1;
pub const CONFIG_IPV6_PIMSM_V2: u32 = 1;
pub const CONFIG_CHARGER_BD99954_MODULE: u32 = 1;
pub const CONFIG_ARCH_ENABLE_THP_MIGRATION: u32 = 1;
pub const CONFIG_USB_XHCI_DBGCAP: u32 = 1;
pub const CONFIG_DVB_USB_DVBSKY_MODULE: u32 = 1;
pub const CONFIG_WIZNET_BUS_ANY: u32 = 1;
pub const CONFIG_BNX2_MODULE: u32 = 1;
pub const CONFIG_ZRAM_DEF_COMP_LZORLE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_DISK: u32 = 1;
pub const CONFIG_CAN_MODULE: u32 = 1;
pub const CONFIG_SND_VX222_MODULE: u32 = 1;
pub const CONFIG_CFG80211_MODULE: u32 = 1;
pub const CONFIG_PAGE_SIZE_LESS_THAN_256KB: u32 = 1;
pub const CONFIG_MACSEC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CHACHA20POLY1305_MODULE: u32 = 1;
pub const CONFIG_SSB_BLOCKIO: u32 = 1;
pub const CONFIG_MTD_BLOCK_RO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CHELSIO_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9063: u32 = 1;
pub const CONFIG_EQUALIZER_MODULE: u32 = 1;
pub const CONFIG_SAMPLE_TRACE_PRINTK_MODULE: u32 = 1;
pub const CONFIG_HUAWEI_WMI_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_HX8347D_MODULE: u32 = 1;
pub const CONFIG_COMEDI_JR3_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2562_MODULE: u32 = 1;
pub const CONFIG_SND_AU8810_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETNET_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6621_MODULE: u32 = 1;
pub const CONFIG_CPU_IBPB_ENTRY: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_1250_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_6527_MODULE: u32 = 1;
pub const CONFIG_VFIO_PCI_IGD: u32 = 1;
pub const CONFIG_CALL_DEPTH_TRACKING: u32 = 1;
pub const CONFIG_SND_SOC_AK4118_MODULE: u32 = 1;
pub const CONFIG_DM_CRYPT_MODULE: u32 = 1;
pub const CONFIG_REED_SOLOMON_ENC8: u32 = 1;
pub const CONFIG_REGULATOR_PV88060_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250: u32 = 1;
pub const CONFIG_RTC_DRV_ISL12022_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TSCS454_MODULE: u32 = 1;
pub const CONFIG_PWM_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_UBLK_MODULE: u32 = 1;
pub const CONFIG_MLXREG_HOTPLUG_MODULE: u32 = 1;
pub const CONFIG_XEN_GNTDEV_MODULE: u32 = 1;
pub const CONFIG_XEN_VIRTIO: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_MXIC: u32 = 1;
pub const CONFIG_XZ_DEC_TEST_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83793_MODULE: u32 = 1;
pub const CONFIG_PI433_MODULE: u32 = 1;
pub const CONFIG_SPMI_HISI3670_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_PIO: u32 = 1;
pub const CONFIG_LZO_DECOMPRESS: u32 = 1;
pub const CONFIG_USB_EHCI_ROOT_HUB_TT: u32 = 1;
pub const CONFIG_LIBERTAS_THINFIRM_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_AH: u32 = 1;
pub const CONFIG_SCSI_UFS_CDNS_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_IOMMU_SUPPORT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HYNITRON_CSTXXX_MODULE: u32 = 1;
pub const CONFIG_HID_BELKIN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD_CLASSH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IR_I2C_MODULE: u32 = 1;
pub const CONFIG_ROMFS_BACKED_BY_BLOCK: u32 = 1;
pub const CONFIG_VFIO_IOMMU_TYPE1_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0367_MODULE: u32 = 1;
pub const CONFIG_STMMAC_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6594_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_CAMERA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2640_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_862_MODULE: u32 = 1;
pub const CONFIG_CRAMFS_BLOCKDEV: u32 = 1;
pub const CONFIG_PDS_VDPA_MODULE: u32 = 1;
pub const CONFIG_NFSD_MODULE: u32 = 1;
pub const CONFIG_APPLE_MFI_FASTCHARGE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TSL2550_MODULE: u32 = 1;
pub const CONFIG_ITG3200_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_DA7219_MAX98357A_GENERIC_MODULE: u32 = 1;
pub const CONFIG_COMPAT_BINFMT_ELF: u32 = 1;
pub const CONFIG_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_PWM_LPSS: u32 = 1;
pub const CONFIG_X86_DIRECT_GBPAGES: u32 = 1;
pub const CONFIG_VIDEO_IVTV_ALSA_MODULE: u32 = 1;
pub const CONFIG_PATA_MPIIX_MODULE: u32 = 1;
pub const CONFIG_ARCH_SELECTS_KEXEC_FILE: u32 = 1;
pub const CONFIG_USB_SERIAL_OPTION_MODULE: u32 = 1;
pub const CONFIG_HID_ACRUX_MODULE: u32 = 1;
pub const CONFIG_RD_LZMA: u32 = 1;
pub const CONFIG_USB_GSPCA_SE401_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_GEMINILAKE_MODULE: u32 = 1;
pub const CONFIG_USB: u32 = 1;
pub const CONFIG_PATA_SIL680_MODULE: u32 = 1;
pub const CONFIG_ACPI_IPMI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5651_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX8998_MODULE: u32 = 1;
pub const CONFIG_SENSORS_CORSAIR_CPRO_MODULE: u32 = 1;
pub const CONFIG_CHARGER_AXP20X_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_SPEEDTOUCH_MODULE: u32 = 1;
pub const CONFIG_I2C_XILINX_MODULE: u32 = 1;
pub const CONFIG_NEED_PER_CPU_PAGE_FIRST_CHUNK: u32 = 1;
pub const CONFIG_REGULATOR_88PM8607_MODULE: u32 = 1;
pub const CONFIG_ALIM7101_WDT_MODULE: u32 = 1;
pub const CONFIG_ACPI_PCI_SLOT: u32 = 1;
pub const CONFIG_PM_WAKELOCKS_GC: u32 = 1;
pub const CONFIG_NFC_MRVL_I2C_MODULE: u32 = 1;
pub const CONFIG_MODULES_USE_ELF_RELA: u32 = 1;
pub const CONFIG_AD5686_MODULE: u32 = 1;
pub const CONFIG_SND_BCD2000_MODULE: u32 = 1;
pub const CONFIG_BTREE: u32 = 1;
pub const CONFIG_CRYPTO_HMAC: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7118_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_ON20_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_REALTEK: u32 = 1;
pub const CONFIG_TYPEC_ANX7411_MODULE: u32 = 1;
pub const CONFIG_BLK_WBT: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_MACRO_COMMON_MODULE: u32 = 1;
pub const CONFIG_INPUT_ADXL34X_SPI_MODULE: u32 = 1;
pub const CONFIG_ETHERNET: u32 = 1;
pub const CONFIG_MFD_INTEL_M10_BMC_PMCI_MODULE: u32 = 1;
pub const CONFIG_PATA_CMD640_PCI_MODULE: u32 = 1;
pub const CONFIG_KXSD9_SPI_MODULE: u32 = 1;
pub const CONFIG_VFIO_NOIOMMU: u32 = 1;
pub const CONFIG_NET_SCH_CODEL_MODULE: u32 = 1;
pub const CONFIG_JFFS2_LZO: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE_ROTATION: u32 = 1;
pub const CONFIG_NVME_TARGET_FC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP5990_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3060_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_COMLIB_MODULE: u32 = 1;
pub const CONFIG_INPUT_BMA150_MODULE: u32 = 1;
pub const CONFIG_USBIP_VHCI_HC_PORTS: u32 = 8;
pub const CONFIG_USB_GSPCA_JEILINJ_MODULE: u32 = 1;
pub const CONFIG_SCHED_OMIT_FRAME_POINTER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_JASPERLAKE_MODULE: u32 = 1;
pub const CONFIG_HID_LOGITECH_HIDPP_MODULE: u32 = 1;
pub const CONFIG_BATTERY_CW2015_MODULE: u32 = 1;
pub const CONFIG_RETU_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SHA3: u32 = 1;
pub const CONFIG_UBIFS_FS_ZSTD: u32 = 1;
pub const CONFIG_BRANCH_PROFILE_NONE: u32 = 1;
pub const CONFIG_X86_IOPL_IOPERM: u32 = 1;
pub const CONFIG_AD3552R_MODULE: u32 = 1;
pub const CONFIG_SCSI_SCAN_ASYNC: u32 = 1;
pub const CONFIG_VIDEO_IMX274_MODULE: u32 = 1;
pub const CONFIG_SPI_DW_MMIO_MODULE: u32 = 1;
pub const CONFIG_CRC_ITU_T_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_GENERIC_LEDS: u32 = 1;
pub const CONFIG_NET_DROP_MONITOR: u32 = 1;
pub const CONFIG_HW_RANDOM_BA431_MODULE: u32 = 1;
pub const CONFIG_SND_HRTIMER_MODULE: u32 = 1;
pub const CONFIG_HAVE_DMA_CONTIGUOUS: u32 = 1;
pub const CONFIG_RAPIDIO_DISC_TIMEOUT: u32 = 30;
pub const CONFIG_DQL: u32 = 1;
pub const CONFIG_VXLAN_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_BROXTON_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_VSC_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PC_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE: u32 = 1;
pub const CONFIG_SND_SOC_PCM512x_I2C_MODULE: u32 = 1;
pub const CONFIG_RMI4_F55: u32 = 1;
pub const CONFIG_TYPEC_TCPCI_MAXIM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADI_AXI_SPDIF_MODULE: u32 = 1;
pub const CONFIG_SENSORS_OXP_MODULE: u32 = 1;
pub const CONFIG_DM_ZERO_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB8000_MODULE: u32 = 1;
pub const CONFIG_X86_SUPPORTS_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_MGR_MODULE: u32 = 1;
pub const CONFIG_CROS_USBPD_LOGGER_MODULE: u32 = 1;
pub const CONFIG_SND_SEQUENCER_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_LP_MODULE: u32 = 1;
pub const CONFIG_SONY_FF: u32 = 1;
pub const CONFIG_PINCTRL_BAYTRAIL: u32 = 1;
pub const CONFIG_AD5064_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SRC4XXX_MODULE: u32 = 1;
pub const CONFIG_GAMEPORT_EMU10K1_MODULE: u32 = 1;
pub const CONFIG_SOCK_CGROUP_DATA: u32 = 1;
pub const CONFIG_WL1251_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_CDNSP_HOST: u32 = 1;
pub const CONFIG_SND_BEBOB_MODULE: u32 = 1;
pub const CONFIG_COREDUMP: u32 = 1;
pub const CONFIG_NET_FOU_IP_TUNNELS: u32 = 1;
pub const CONFIG_USB_NET_GL620A_MODULE: u32 = 1;
pub const CONFIG_CLK_TWL_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_PXP: u32 = 1;
pub const CONFIG_MICREL_KS8995MA_MODULE: u32 = 1;
pub const CONFIG_AS_GFNI: u32 = 1;
pub const CONFIG_VMLINUX_MAP: u32 = 1;
pub const CONFIG_CROS_TYPEC_SWITCH_MODULE: u32 = 1;
pub const CONFIG_DVB_LGDT3306A_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_1500_MODULE: u32 = 1;
pub const CONFIG_POWER_RESET_MT6323: u32 = 1;
pub const CONFIG_SND_OPL3_LIB_MODULE: u32 = 1;
pub const CONFIG_IP_NF_ARPTABLES_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2947_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_TCM: u32 = 1;
pub const CONFIG_REGULATOR_SKY81452_MODULE: u32 = 1;
pub const CONFIG_DVB_ASCOT2E_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_GP8PSK_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_GENERIC: u32 = 1;
pub const CONFIG_HID_CHERRY_MODULE: u32 = 1;
pub const CONFIG_PC87413_WDT_MODULE: u32 = 1;
pub const CONFIG_CAN_J1939_MODULE: u32 = 1;
pub const CONFIG_DRM_SUBALLOC_HELPER_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_SH1106_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3532_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMX_AUDMUX_MODULE: u32 = 1;
pub const CONFIG_JFFS2_COMPRESSION_OPTIONS: u32 = 1;
pub const CONFIG_CM3323_MODULE: u32 = 1;
pub const CONFIG_BATTERY_MAX17040_MODULE: u32 = 1;
pub const CONFIG_FTRACE_MCOUNT_USE_CC: u32 = 1;
pub const CONFIG_VBOXSF_FS_MODULE: u32 = 1;
pub const CONFIG_ACCESSIBILITY: u32 = 1;
pub const CONFIG_USERIO_MODULE: u32 = 1;
pub const CONFIG_MKISS_MODULE: u32 = 1;
pub const CONFIG_USE_PERCPU_NUMA_NODE_ID: u32 = 1;
pub const CONFIG_NFT_FIB_MODULE: u32 = 1;
pub const CONFIG_AD9467_MODULE: u32 = 1;
pub const CONFIG_HID_SUNPLUS_MODULE: u32 = 1;
pub const CONFIG_INPUT_ADXL34X_MODULE: u32 = 1;
pub const CONFIG_KSZ884X_PCI_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_DYNAMIC: u32 = 1;
pub const CONFIG_HID_PICOLCD_MODULE: u32 = 1;
pub const CONFIG_BCMA_POSSIBLE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_RNDIS: u32 = 1;
pub const CONFIG_NF_LOG_IPV4_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_MCR20A_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_SFB_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_CIRRUS: u32 = 1;
pub const CONFIG_FUSION_CTL_MODULE: u32 = 1;
pub const CONFIG_TULIP_MODULE: u32 = 1;
pub const CONFIG_FB_SM750_MODULE: u32 = 1;
pub const CONFIG_AF_RXRPC_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_AUTO_VAR_INIT_ZERO: u32 = 1;
pub const CONFIG_FUSE_DAX: u32 = 1;
pub const CONFIG_ZRAM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST5_MODULE: u32 = 1;
pub const CONFIG_VGA_ARB: u32 = 1;
pub const CONFIG_SATA_HOST: u32 = 1;
pub const CONFIG_USB_CDNS_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_CORETEMP_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_ARP: u32 = 1;
pub const CONFIG_SND_SOC_ACPI_MODULE: u32 = 1;
pub const CONFIG_FB_CARMINE_DRAM_EVAL: u32 = 1;
pub const CONFIG_FB_NVIDIA_BACKLIGHT: u32 = 1;
pub const CONFIG_SND_SOC_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6060_MODULE: u32 = 1;
pub const CONFIG_FXAS21002C_I2C_MODULE: u32 = 1;
pub const CONFIG_CEC_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_MAXIM_THERMOCOUPLE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS51632_MODULE: u32 = 1;
pub const CONFIG_INV_ICM42600_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_SKYLAKE_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_SBP2_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX77693: u32 = 1;
pub const CONFIG_SCSI_COMMON: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_POLICY_LOADER: &[u8; 18usize] = b"/sbin/tomoyo-init\0";
pub const CONFIG_SURFACE_PLATFORMS: u32 = 1;
pub const CONFIG_NET_IPGRE_DEMUX_MODULE: u32 = 1;
pub const CONFIG_COMEDI_MULTIQ3_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_XC5000_MODULE: u32 = 1;
pub const CONFIG_NET_POLL_CONTROLLER: u32 = 1;
pub const CONFIG_PRINTK: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_MTL_MODULE: u32 = 1;
pub const CONFIG_MT7996E_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_BNS_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_QCOM_LABIBB_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_ROUTING_MODULE: u32 = 1;
pub const CONFIG_SFC_MODULE: u32 = 1;
pub const CONFIG_PHANTOM_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_FINTEK: u32 = 1;
pub const CONFIG_PINCTRL_CANNONLAKE_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_IQS7211_MODULE: u32 = 1;
pub const CONFIG_BMC150_ACCEL_MODULE: u32 = 1;
pub const CONFIG_FORCEDETH_MODULE: u32 = 1;
pub const CONFIG_ACPI_LPIT: u32 = 1;
pub const CONFIG_COMEDI_DAS08_CS_MODULE: u32 = 1;
pub const CONFIG_FB_SYS_FILLRECT: u32 = 1;
pub const CONFIG_TIMERFD: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CHACHA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_SPI_AXI_SPI_ENGINE_MODULE: u32 = 1;
pub const CONFIG_HID_THRUSTMASTER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RK3328_MODULE: u32 = 1;
pub const CONFIG_IPMI_PLAT_DATA: u32 = 1;
pub const CONFIG_USB_DYNAMIC_MINORS: u32 = 1;
pub const CONFIG_SENSORS_MAX16065_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES83XX_DSM_COMMON_MODULE: u32 = 1;
pub const CONFIG_HD44780_COMMON_MODULE: u32 = 1;
pub const CONFIG_SENSORS_I5K_AMB_MODULE: u32 = 1;
pub const CONFIG_DNS_RESOLVER: u32 = 1;
pub const CONFIG_SX_COMMON_MODULE: u32 = 1;
pub const CONFIG_FIRMWARE_TABLE: u32 = 1;
pub const CONFIG_B53_MMAP_DRIVER_MODULE: u32 = 1;
pub const CONFIG_ITCO_VENDOR_SUPPORT: u32 = 1;
pub const CONFIG_TRACEPOINTS: u32 = 1;
pub const CONFIG_NET_DSA_TAG_HELLCREEK_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_LP: u32 = 1;
pub const CONFIG_MTD_CFI_I2: u32 = 1;
pub const CONFIG_IKHEADERS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AUTHENC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_AESNI_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_AT803X_PHY_MODULE: u32 = 1;
pub const CONFIG_DVB_SP8870_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CIRRUS_SCODEC_MODULE: u32 = 1;
pub const CONFIG_I6300ESB_WDT_MODULE: u32 = 1;
pub const CONFIG_GPIO_ML_IOH_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ_SPI_MODULE: u32 = 1;
pub const CONFIG_YENTA_MODULE: u32 = 1;
pub const CONFIG_USB_GPIO_VBUS_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_DS2482_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SIDEWINDER_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_STACK: u32 = 32;
pub const CONFIG_SRF04_MODULE: u32 = 1;
pub const CONFIG_CARL9170_LEDS: u32 = 1;
pub const CONFIG_XILINX_DMA_MODULE: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_V4L2_SUBDEV_API: u32 = 1;
pub const CONFIG_UCLAMP_TASK_GROUP: u32 = 1;
pub const CONFIG_ATL1E_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_PREEMPT_TIMEOUT: u32 = 640;
pub const CONFIG_USB_STORAGE_ENE_UB6250_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_ACTIVITY_MODULE: u32 = 1;
pub const CONFIG_DVB_DDBRIDGE_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_CENTEURO_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_SDIO: u32 = 1;
pub const CONFIG_ARCH_HAS_SYSCALL_WRAPPER: u32 = 1;
pub const CONFIG_LEDS_DA903X_MODULE: u32 = 1;
pub const CONFIG_DWMAC_GENERIC_MODULE: u32 = 1;
pub const CONFIG_MAX5821_MODULE: u32 = 1;
pub const CONFIG_RDS_RDMA_MODULE: u32 = 1;
pub const CONFIG_NFC_VIRTUAL_NCI_MODULE: u32 = 1;
pub const CONFIG_AD5592R_MODULE: u32 = 1;
pub const CONFIG_NUMA_BALANCING: u32 = 1;
pub const CONFIG_COMEDI_TESTS_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_BAYTRAIL: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_MODULE: u32 = 1;
pub const CONFIG_P54_COMMON_MODULE: u32 = 1;
pub const CONFIG_QRTR_SMD_MODULE: u32 = 1;
pub const CONFIG_GPIO_AAEON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_I2S_TEST_MODULE: u32 = 1;
pub const CONFIG_COMPAT_32BIT_TIME: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_HASH: u32 = 1;
pub const CONFIG_RTW88_8822BU_MODULE: u32 = 1;
pub const CONFIG_SHMEM: u32 = 1;
pub const CONFIG_MTD_MODULE: u32 = 1;
pub const CONFIG_MIGRATION: u32 = 1;
pub const CONFIG_HAVE_ARCH_JUMP_LABEL: u32 = 1;
pub const CONFIG_LEDS_PCA9532_GPIO: u32 = 1;
pub const CONFIG_COMEDI_C6XDIGIO_MODULE: u32 = 1;
pub const CONFIG_BUILD_SALT: &[u8; 1usize] = b"\0";
pub const CONFIG_MMC_BLOCK_MINORS: u32 = 8;
pub const CONFIG_SND_XEN_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_LZ4: u32 = 1;
pub const CONFIG_IIO_SSP_SENSORS_COMMONS_MODULE: u32 = 1;
pub const CONFIG_USB_HSO_MODULE: u32 = 1;
pub const CONFIG_ACPI_PFRUT_MODULE: u32 = 1;
pub const CONFIG_HID_PRIMAX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_COFFEELAKE_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_PREL32_RELOCATIONS: u32 = 1;
pub const CONFIG_DECOMPRESS_LZMA: u32 = 1;
pub const CONFIG_SYSTEM_REVOCATION_LIST: u32 = 1;
pub const CONFIG_PCI_IOV: u32 = 1;
pub const CONFIG_WATCHDOG_SYSFS: u32 = 1;
pub const CONFIG_SENSORS_IIO_HWMON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8776_MODULE: u32 = 1;
pub const CONFIG_GPIO_VIPERBOARD_MODULE: u32 = 1;
pub const CONFIG_QED_LL2: u32 = 1;
pub const CONFIG_DEVTMPFS_MOUNT: u32 = 1;
pub const CONFIG_IIO_BUFFER_DMAENGINE_MODULE: u32 = 1;
pub const CONFIG_SURFACE_GPE_MODULE: u32 = 1;
pub const CONFIG_PM_DEVFREQ_EVENT: u32 = 1;
pub const CONFIG_SND_HDA_DSP_LOADER: u32 = 1;
pub const CONFIG_EXCLUSIVE_SYSTEM_RAM: u32 = 1;
pub const CONFIG_SENSORS_AMC6821_MODULE: u32 = 1;
pub const CONFIG_MFD_SI476X_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_IPHETH_MODULE: u32 = 1;
pub const CONFIG_IXGBEVF_IPSEC: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_850_MODULE: u32 = 1;
pub const CONFIG_DVB_CX22700_MODULE: u32 = 1;
pub const CONFIG_SOCK_VALIDATE_XMIT: u32 = 1;
pub const CONFIG_HAVE_PREEMPT_DYNAMIC: u32 = 1;
pub const CONFIG_DNOTIFY: u32 = 1;
pub const CONFIG_X86_VMX_FEATURE_NAMES: u32 = 1;
pub const CONFIG_BCM54140_PHY_MODULE: u32 = 1;
pub const CONFIG_ACRN_GUEST: u32 = 1;
pub const CONFIG_COMEDI_DAS800_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CTS: u32 = 1;
pub const CONFIG_KEYBOARD_LM8333_MODULE: u32 = 1;
pub const CONFIG_HID_VRC2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88395_LIB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM5102_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_CML_RT1011_RT5682_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_USB_PODHD_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_UMT_010_MODULE: u32 = 1;
pub const CONFIG_SUNGEM_PHY_MODULE: u32 = 1;
pub const CONFIG_EDD: u32 = 1;
pub const CONFIG_JOYSTICK_DB9_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822C_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_RFDS: u32 = 1;
pub const CONFIG_SND_SOC_SOF_DEBUG_PROBES_MODULE: u32 = 1;
pub const CONFIG_EFI_CUSTOM_SSDT_OVERLAYS: u32 = 1;
pub const CONFIG_RTC_DRV_R9701_MODULE: u32 = 1;
pub const CONFIG_NFC_S3FWRN5_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI_UFSHCD_MODULE: u32 = 1;
pub const CONFIG_THERMAL_STATISTICS: u32 = 1;
pub const CONFIG_ARCH_HAS_GENERIC_CRASHKERNEL_RESERVATION: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV: u32 = 1;
pub const CONFIG_GENERIC_NET_UTILS: u32 = 1;
pub const CONFIG_IPV6_ILA_MODULE: u32 = 1;
pub const CONFIG_FB_RADEON_BACKLIGHT: u32 = 1;
pub const CONFIG_REGULATOR_MC13XXX_CORE_MODULE: u32 = 1;
pub const CONFIG_INPUT_WM831X_ON_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EKTF2127_MODULE: u32 = 1;
pub const CONFIG_ATA: u32 = 1;
pub const CONFIG_KEYBOARD_SUNKBD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42XX8_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PALMAS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TPS40422_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KMSAN: u32 = 1;
pub const CONFIG_GPIO_MAX730X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DES_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8994_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_3C589_MODULE: u32 = 1;
pub const CONFIG_USB_ROLE_SWITCH: u32 = 1;
pub const CONFIG_RTW88_PCI_MODULE: u32 = 1;
pub const CONFIG_INV_ICM42600_SPI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM9712: u32 = 1;
pub const CONFIG_GPIOLIB_FASTPATH_LIMIT: u32 = 512;
pub const CONFIG_CEPH_LIB_MODULE: u32 = 1;
pub const CONFIG_INTEL_SPEED_SELECT_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_REMOTEPROC: u32 = 1;
pub const CONFIG_GPIO_LP3943_MODULE: u32 = 1;
pub const CONFIG_STM_MODULE: u32 = 1;
pub const CONFIG_COMEDI_MF6X4_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_COMPRESS: u32 = 1;
pub const CONFIG_ND_BTT_MODULE: u32 = 1;
pub const CONFIG_XEN_MCE_LOG: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_437: u32 = 1;
pub const CONFIG_HAVE_ARCH_SOFT_DIRTY: u32 = 1;
pub const CONFIG_SND_SOC_INNO_RK3036_MODULE: u32 = 1;
pub const CONFIG_HYPERV_KEYBOARD_MODULE: u32 = 1;
pub const CONFIG_EFI_RCI2_TABLE: u32 = 1;
pub const CONFIG_INTEL_TH_GTH_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_DA9052_MODULE: u32 = 1;
pub const CONFIG_NATSEMI_MODULE: u32 = 1;
pub const CONFIG_PATA_TIMINGS: u32 = 1;
pub const CONFIG_ARCH_PROC_KCORE_TEXT: u32 = 1;
pub const CONFIG_GET_FREE_REGION: u32 = 1;
pub const CONFIG_VFIO_DEVICE_CDEV: u32 = 1;
pub const CONFIG_NET_CLS_U32_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_GLUE_CT: u32 = 1;
pub const CONFIG_MISDN_MODULE: u32 = 1;
pub const CONFIG_EXPORTFS: u32 = 1;
pub const CONFIG_REGULATOR_RT6245_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_WL_THRESHOLD: u32 = 4096;
pub const CONFIG_BMC150_MAGN_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VISL_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_KBIC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8907_MODULE: u32 = 1;
pub const CONFIG_AD525X_DPOT_I2C_MODULE: u32 = 1;
pub const CONFIG_MMC_RICOH_MMC: u32 = 1;
pub const CONFIG_SQUASHFS_CHOICE_DECOMP_BY_MOUNT: u32 = 1;
pub const CONFIG_VIDEO_OV64A40_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_HUB_MODULE: u32 = 1;
pub const CONFIG_SND_MIXER_OSS_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_PENMOUNT_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_MH_MODULE: u32 = 1;
pub const CONFIG_IP_MROUTE_COMMON: u32 = 1;
pub const CONFIG_SENSORS_PXE1610_MODULE: u32 = 1;
pub const CONFIG_NET_INGRESS: u32 = 1;
pub const CONFIG_FB_TFT_ST7789V_MODULE: u32 = 1;
pub const CONFIG_DVB_S921_MODULE: u32 = 1;
pub const CONFIG_MSI_WMI_MODULE: u32 = 1;
pub const CONFIG_IT87_WDT_MODULE: u32 = 1;
pub const CONFIG_LRU_CACHE_MODULE: u32 = 1;
pub const CONFIG_SCSI_CXGB3_ISCSI_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_INTEGRITY_T10: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_ERROR_INJECTION: u32 = 1;
pub const CONFIG_REGULATOR_LP3972_MODULE: u32 = 1;
pub const CONFIG_SND_DARLA24_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX1619_MODULE: u32 = 1;
pub const CONFIG_IPW2200_MONITOR: u32 = 1;
pub const CONFIG_USB_XEN_HCD_MODULE: u32 = 1;
pub const CONFIG_DVB_AF9013_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_SYM53C500_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_BZIMAGE_VERIFY_SIG: u32 = 1;
pub const CONFIG_OLD_SIGSUSPEND3: u32 = 1;
pub const CONFIG_SERIO: u32 = 1;
pub const CONFIG_DVB_USB_DTV5100_MODULE: u32 = 1;
pub const CONFIG_SCHEDSTATS: u32 = 1;
pub const CONFIG_TYPEC_UCSI_MODULE: u32 = 1;
pub const CONFIG_IBMASR_MODULE: u32 = 1;
pub const CONFIG_INPUT_MOUSE: u32 = 1;
pub const CONFIG_RTLWIFI_PCI_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ISER_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_SMT: u32 = 1;
pub const CONFIG_FB_SYS_IMAGEBLIT: u32 = 1;
pub const CONFIG_VIDEO_TVEEPROM_MODULE: u32 = 1;
pub const CONFIG_X86: u32 = 1;
pub const CONFIG_PPS_CLIENT_PARPORT_MODULE: u32 = 1;
pub const CONFIG_VIDEO_LM3646_MODULE: u32 = 1;
pub const CONFIG_DEFXX_MODULE: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_ACP70_MODULE: u32 = 1;
pub const CONFIG_SUNRPC_GSS_MODULE: u32 = 1;
pub const CONFIG_HID_LED_MODULE: u32 = 1;
pub const CONFIG_CORE_DUMP_DEFAULT_ELF_HEADERS: u32 = 1;
pub const CONFIG_TYPHOON_MODULE: u32 = 1;
pub const CONFIG_TIGON3_MODULE: u32 = 1;
pub const CONFIG_KCMP: u32 = 1;
pub const CONFIG_REGULATOR_RT4801_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST5_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM90_MODULE: u32 = 1;
pub const CONFIG_XILINX_XADC_MODULE: u32 = 1;
pub const CONFIG_NETCONSOLE_MODULE: u32 = 1;
pub const CONFIG_RTC_INTF_SYSFS: u32 = 1;
pub const CONFIG_CHARGER_BQ24257_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_ACPI_MODULE: u32 = 1;
pub const CONFIG_BCMA_DRIVER_GPIO: u32 = 1;
pub const CONFIG_SND_SOC_SPDIF_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_TX_MACRO_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RS5C372_MODULE: u32 = 1;
pub const CONFIG_QED_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_U32_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2780_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TOUCHWIN_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_COMMON: u32 = 1;
pub const CONFIG_BLK_DEV_INITRD: u32 = 1;
pub const CONFIG_USB_EMI62_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_N: u32 = 1;
pub const CONFIG_SCSI_IPS_MODULE: u32 = 1;
pub const CONFIG_X86_MCE_AMD: u32 = 1;
pub const CONFIG_ARCH_ENABLE_MEMORY_HOTREMOVE: u32 = 1;
pub const CONFIG_DM_BUFIO_MODULE: u32 = 1;
pub const CONFIG_I2C_ALGOPCA_MODULE: u32 = 1;
pub const CONFIG_CAN_GS_USB_MODULE: u32 = 1;
pub const CONFIG_SMB_SERVER_MODULE: u32 = 1;
pub const CONFIG_BT_ATH3K_MODULE: u32 = 1;
pub const CONFIG_PCPU_DEV_REFCNT: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_TIMER_MODULE: u32 = 1;
pub const CONFIG_MCB_PCI_MODULE: u32 = 1;
pub const CONFIG_DRM_VIRTIO_GPU_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_PALMAS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M48T59_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8510_MODULE: u32 = 1;
pub const CONFIG_RT2800_LIB_MODULE: u32 = 1;
pub const CONFIG_EXTCON_ADC_JACK_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_LED_MODULE: u32 = 1;
pub const CONFIG_X86_X2APIC: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC3X_MODULE: u32 = 1;
pub const CONFIG_SERIAL_LANTIQ_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_SECURITY_APPARMOR: u32 = 1;
pub const CONFIG_NFS_DEBUG: u32 = 1;
pub const CONFIG_AD7949_MODULE: u32 = 1;
pub const CONFIG_EFI_DXE_MEM_ATTRIBUTES: u32 = 1;
pub const CONFIG_CRYPTO_BLOWFISH_COMMON_MODULE: u32 = 1;
pub const CONFIG_USB_RAREMONO_MODULE: u32 = 1;
pub const CONFIG_BT_INTEL_MODULE: u32 = 1;
pub const CONFIG_SECURITY_LANDLOCK: u32 = 1;
pub const CONFIG_CRC4_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_WM831X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS65090_MODULE: u32 = 1;
pub const CONFIG_FUSION_LAN_MODULE: u32 = 1;
pub const CONFIG_DRM_BOCHS_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DW2102_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_HASH: u32 = 1;
pub const CONFIG_PATA_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SANE_MODULE: u32 = 1;
pub const CONFIG_SERIO_PARKBD_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCF857X_MODULE: u32 = 1;
pub const CONFIG_SND_OSSEMUL: u32 = 1;
pub const CONFIG_CRYPTO_GHASH_CLMUL_NI_INTEL_MODULE: u32 = 1;
pub const CONFIG_GDB_SCRIPTS: u32 = 1;
pub const CONFIG_BACKLIGHT_SAHARA_MODULE: u32 = 1;
pub const CONFIG_FB_SYSMEM_HELPERS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2004_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU_UTILS_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SURFACE3_SPI_MODULE: u32 = 1;
pub const CONFIG_IBM_RTL_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_PTN36502_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MOS7720_MODULE: u32 = 1;
pub const CONFIG_XILLYBUS_MODULE: u32 = 1;
pub const CONFIG_SERIAL_DEV_BUS: u32 = 1;
pub const CONFIG_PREEMPT_NOTIFIERS: u32 = 1;
pub const CONFIG_NET_DSA_TAG_EDSA_MODULE: u32 = 1;
pub const CONFIG_XEN_PVHVM: u32 = 1;
pub const CONFIG_FB_ARC_MODULE: u32 = 1;
pub const CONFIG_SPI_XILINX_MODULE: u32 = 1;
pub const CONFIG_NF_CT_PROTO_DCCP: u32 = 1;
pub const CONFIG_ZLIB_INFLATE: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM36274_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SYNOPSYS: u32 = 1;
pub const CONFIG_HTE: u32 = 1;
pub const CONFIG_DVB_TUA6100_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SHTC1_MODULE: u32 = 1;
pub const CONFIG_NFT_FLOW_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_KVM_ASYNC_PF: u32 = 1;
pub const CONFIG_BMP280_MODULE: u32 = 1;
pub const CONFIG_SURFACE_3_POWER_OPREGION_MODULE: u32 = 1;
pub const CONFIG_CRC_T10DIF: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_BOARD_HELPERS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT6775_CORE_MODULE: u32 = 1;
pub const CONFIG_EXTCON_USBC_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_RTW89_8851BE_MODULE: u32 = 1;
pub const CONFIG_AD7746_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_MMA8452_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_FAIR_SHARE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_QT1010_MODULE: u32 = 1;
pub const CONFIG_ENCRYPTED_KEYS: u32 = 1;
pub const CONFIG_DVB_DYNAMIC_MINORS: u32 = 1;
pub const CONFIG_IIO_KX022A_I2C_MODULE: u32 = 1;
pub const CONFIG_GPIO_WM831X_MODULE: u32 = 1;
pub const CONFIG_SSB_PCIHOST_POSSIBLE: u32 = 1;
pub const CONFIG_LCD_LMS283GF05_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_PM_NOTIFIER: u32 = 1;
pub const CONFIG_FXOS8700_SPI_MODULE: u32 = 1;
pub const CONFIG_HWMON: u32 = 1;
pub const CONFIG_AD5791_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8824_MODULE: u32 = 1;
pub const CONFIG_INTEL_GTT: u32 = 1;
pub const CONFIG_RTC_DRV_PCF85063_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_DLINK: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_COMMON_MODULE: u32 = 1;
pub const CONFIG_AUDITSYSCALL: u32 = 1;
pub const CONFIG_USB_LJCA_MODULE: u32 = 1;
pub const CONFIG_LCD2S_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_3WIRE: u32 = 1;
pub const CONFIG_INTEL_SCU_IPC_UTIL_MODULE: u32 = 1;
pub const CONFIG_USB_PHY: u32 = 1;
pub const CONFIG_MANAGER_SBS_MODULE: u32 = 1;
pub const CONFIG_X86_ACPI_CPUFREQ_CPB: u32 = 1;
pub const CONFIG_NLS_ISO8859_2_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9052_I2C: u32 = 1;
pub const CONFIG_QEDE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM63_MODULE: u32 = 1;
pub const CONFIG_IMA_MEASURE_ASYMMETRIC_KEYS: u32 = 1;
pub const CONFIG_RC_DEVICES: u32 = 1;
pub const CONFIG_XDP_SOCKETS_DIAG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRC32_PCLMUL_MODULE: u32 = 1;
pub const CONFIG_USB_VIDEO_CLASS_MODULE: u32 = 1;
pub const CONFIG_ACPI_DPTF: u32 = 1;
pub const CONFIG_EXTCON_INTEL_CHT_WC_MODULE: u32 = 1;
pub const CONFIG_CLKBLD_I8253: u32 = 1;
pub const CONFIG_ATM_NICSTAR_MODULE: u32 = 1;
pub const CONFIG_MCP4131_MODULE: u32 = 1;
pub const CONFIG_FB_ATY_GX: u32 = 1;
pub const CONFIG_RTC_INTF_PROC: u32 = 1;
pub const CONFIG_HID_PICOLCD_FB: u32 = 1;
pub const CONFIG_IR_RCMM_DECODER_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_TI_MODULE: u32 = 1;
pub const CONFIG_BCMGENET_MODULE: u32 = 1;
pub const CONFIG_KEXEC_SIG: u32 = 1;
pub const CONFIG_VIDEO_VP27SMPX_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HDCP_HELPER: u32 = 1;
pub const CONFIG_DYNAMIC_DEBUG_CORE: u32 = 1;
pub const CONFIG_PM_CLK: u32 = 1;
pub const CONFIG_SND_AMD_ACP_CONFIG_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_HID: u32 = 1;
pub const CONFIG_ARCH_USE_BUILTIN_BSWAP: u32 = 1;
pub const CONFIG_GPIO_SIM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKYLAKE_COMMON_MODULE: u32 = 1;
pub const CONFIG_ATH12K_TRACING: u32 = 1;
pub const CONFIG_SENSORS_LTC2990_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_INTEL_RAPL_MODULE: u32 = 1;
pub const CONFIG_USB_DWC2_PCI_MODULE: u32 = 1;
pub const CONFIG_IR_TOY_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MOS7715_PARPORT: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_MODULE: u32 = 1;
pub const CONFIG_DVB_SI2168_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_PADDING_CFI: u32 = 11;
pub const CONFIG_CC_IMPLICIT_FALLTHROUGH: &[u8; 25usize] = b"-Wimplicit-fallthrough=5\0";
pub const CONFIG_CPU_IDLE_GOV_MENU: u32 = 1;
pub const CONFIG_MOST_USB_HDM_MODULE: u32 = 1;
pub const CONFIG_USB_EHSET_TEST_FIXTURE_MODULE: u32 = 1;
pub const CONFIG_MTD_PCI_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_OVS: u32 = 1;
pub const CONFIG_FB_TFT_TINYLCD_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_LPSS_MODULE: u32 = 1;
pub const CONFIG_ACPI_FAN: u32 = 1;
pub const CONFIG_SND_FM801_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_SENTELIC: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8925_MODULE: u32 = 1;
pub const CONFIG_FB_MATROX_MYSTIQUE: u32 = 1;
pub const CONFIG_VIDEO_CS5345_MODULE: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR: u32 = 1;
pub const CONFIG_RTC_DRV_RX8010_MODULE: u32 = 1;
pub const CONFIG_DP83867_PHY_MODULE: u32 = 1;
pub const CONFIG_SPI_DW_DMA: u32 = 1;
pub const CONFIG_CC_HAS_ENTRY_PADDING: u32 = 1;
pub const CONFIG_STACKTRACE_SUPPORT: u32 = 1;
pub const CONFIG_ARCH_WANT_OPTIMIZE_HUGETLB_VMEMMAP: u32 = 1;
pub const CONFIG_SERIAL_8250_PCILIB: u32 = 1;
pub const CONFIG_FXLS8962AF_I2C_MODULE: u32 = 1;
pub const CONFIG_B44_PCI_AUTOSELECT: u32 = 1;
pub const CONFIG_DVB_USB_AF9035_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PCI224_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_TIO_MODULE: u32 = 1;
pub const CONFIG_MFD_TI_LP873X_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MAX3100_MODULE: u32 = 1;
pub const CONFIG_LEDS_LP8788_MODULE: u32 = 1;
pub const CONFIG_SENSORS_EMC1403_MODULE: u32 = 1;
pub const CONFIG_MLXFW_MODULE: u32 = 1;
pub const CONFIG_RESET_CONTROLLER: u32 = 1;
pub const CONFIG_BNA_MODULE: u32 = 1;
pub const CONFIG_SURFACE_HID_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DPS920AB_MODULE: u32 = 1;
pub const CONFIG_MAXSMP: u32 = 1;
pub const CONFIG_COMEDI_TESTS_EXAMPLE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_PROBE_MODULE: u32 = 1;
pub const CONFIG_VCNL3020_MODULE: u32 = 1;
pub const CONFIG_OUTPUT_FORMAT: &[u8; 13usize] = b"elf64-x86-64\0";
pub const CONFIG_I2C_MUX_LTC4306_MODULE: u32 = 1;
pub const CONFIG_VIDEO_M52790_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AES_TI_MODULE: u32 = 1;
pub const CONFIG_ACPI: u32 = 1;
pub const CONFIG_HTS221_SPI_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_2_MODULE: u32 = 1;
pub const CONFIG_MTK_T7XX_MODULE: u32 = 1;
pub const CONFIG_ZRAM_TRACK_ENTRY_ACTIME: u32 = 1;
pub const CONFIG_HAVE_IMA_KEXEC: u32 = 1;
pub const CONFIG_PCS_LYNX_MODULE: u32 = 1;
pub const CONFIG_SCSI_CXGB4_ISCSI_MODULE: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_MSM_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_PEGASUS_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPMAC_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_HX8340BN_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SHT15_MODULE: u32 = 1;
pub const CONFIG_USB_UHCI_HCD: u32 = 1;
pub const CONFIG_NVRAM_MODULE: u32 = 1;
pub const CONFIG_NTFS3_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_INFINIBAND_VIRT_DMA: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CY8CTMA140_MODULE: u32 = 1;
pub const CONFIG_USB_ISP1760_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ24735_MODULE: u32 = 1;
pub const CONFIG_LOCKD_MODULE: u32 = 1;
pub const CONFIG_LEDS_INTEL_SS4200_MODULE: u32 = 1;
pub const CONFIG_RTW88_DEBUGFS: u32 = 1;
pub const CONFIG_DM_WRITECACHE_MODULE: u32 = 1;
pub const CONFIG_MLX5_VDPA: u32 = 1;
pub const CONFIG_USB_F_FS_MODULE: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_UDC: u32 = 1;
pub const CONFIG_DVB_FIREDTV_MODULE: u32 = 1;
pub const CONFIG_DVB_S5H1411_MODULE: u32 = 1;
pub const CONFIG_NF_CT_NETLINK_TIMEOUT_MODULE: u32 = 1;
pub const CONFIG_ARCH_MIGHT_HAVE_ACPI_PDC: u32 = 1;
pub const CONFIG_SOUND_OSS_CORE: u32 = 1;
pub const CONFIG_PCIE_DW_HOST: u32 = 1;
pub const CONFIG_SND_SOC_RT5682_SDW_MODULE: u32 = 1;
pub const CONFIG_AIC79XX_REG_PRETTY_PRINT: u32 = 1;
pub const CONFIG_MIPI_I3C_HCI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_ARC4_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_AES: u32 = 1;
pub const CONFIG_TI_ADC0832_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT35XX: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_SSM4567_MODULE: u32 = 1;
pub const CONFIG_FB_SAVAGE_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_PCI: u32 = 1;
pub const CONFIG_SND_SOC_TAS2770_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_MODULE: u32 = 1;
pub const CONFIG_HPET_MMAP: u32 = 1;
pub const CONFIG_WLAN_VENDOR_RALINK: u32 = 1;
pub const CONFIG_NTB_PINGPONG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L42_CORE_MODULE: u32 = 1;
pub const CONFIG_MT7603E_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_TV8532_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_KPP2: u32 = 1;
pub const CONFIG_IO_DELAY_0XED: u32 = 1;
pub const CONFIG_LATENCYTOP: u32 = 1;
pub const CONFIG_LTE_GDM724X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_APL_MODULE: u32 = 1;
pub const CONFIG_DRM_VMWGFX_MODULE: u32 = 1;
pub const CONFIG_DM9051_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MICROCHIP: u32 = 1;
pub const CONFIG_NEED_SG_DMA_FLAGS: u32 = 1;
pub const CONFIG_HAVE_UACCESS_VALIDATION: u32 = 1;
pub const CONFIG_JFFS2_FS_MODULE: u32 = 1;
pub const CONFIG_STE10XP_MODULE: u32 = 1;
pub const CONFIG_KVM_GENERIC_MMU_NOTIFIER: u32 = 1;
pub const CONFIG_FUNCTION_ALIGNMENT: u32 = 16;
pub const CONFIG_NFT_REJECT_IPV6_MODULE: u32 = 1;
pub const CONFIG_HID_SAITEK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8750_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MT6397_MODULE: u32 = 1;
pub const CONFIG_CASSINI_MODULE: u32 = 1;
pub const CONFIG_DRM_ACCEL_IVPU_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5660_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_PROBES_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_ALUA_MODULE: u32 = 1;
pub const CONFIG_MTRR: u32 = 1;
pub const CONFIG_USB_G_NCM_MODULE: u32 = 1;
pub const CONFIG_ADIS16203_MODULE: u32 = 1;
pub const CONFIG_MFD_MC13XXX_I2C_MODULE: u32 = 1;
pub const CONFIG_BT_RFCOMM_TTY: u32 = 1;
pub const CONFIG_LIBFCOE_MODULE: u32 = 1;
pub const CONFIG_NET_UDP_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_SIGNATURE: u32 = 1;
pub const CONFIG_INPUT_MAX8997_HAPTIC_MODULE: u32 = 1;
pub const CONFIG_ASUS_TF103C_DOCK_MODULE: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_MLINK_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_LP8788_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_UTIL_MODULE: u32 = 1;
pub const CONFIG_IRSD200_MODULE: u32 = 1;
pub const CONFIG_USB_ISP1761_UDC: u32 = 1;
pub const CONFIG_USB_RAW_GADGET_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4271_I2C_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_ROMANIAN_MODULE: u32 = 1;
pub const CONFIG_SND_LX6464ES_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ADAPTEC: u32 = 1;
pub const CONFIG_CFG80211_REQUIRE_SIGNED_REGDB: u32 = 1;
pub const CONFIG_VIDEO_HI556_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PCF8591_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0299_MODULE: u32 = 1;
pub const CONFIG_NUMA_KEEP_MEMINFO: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_NO_PATCHABLE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_ACCEL_LEGACY_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_TIMESLICE_MAX: u32 = 10000000;
pub const CONFIG_MOUSE_PS2_BYD: u32 = 1;
pub const CONFIG_IPW2200_RADIOTAP: u32 = 1;
pub const CONFIG_SSB_B43_PCI_BRIDGE: u32 = 1;
pub const CONFIG_ACER_WMI_MODULE: u32 = 1;
pub const CONFIG_PHY_CAN_TRANSCEIVER_MODULE: u32 = 1;
pub const CONFIG_KXSD9_MODULE: u32 = 1;
pub const CONFIG_CHARGER_TWL4030_MODULE: u32 = 1;
pub const CONFIG_USB_AN2720: u32 = 1;
pub const CONFIG_F2FS_STAT_FS: u32 = 1;
pub const CONFIG_SENSORS_UCD9200_MODULE: u32 = 1;
pub const CONFIG_EXTCON_INTEL_INT3496_MODULE: u32 = 1;
pub const CONFIG_MLX4_DEBUG: u32 = 1;
pub const CONFIG_BSD_PROCESS_ACCT: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_STRING_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_TPS6594_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_PS_MACH_MODULE: u32 = 1;
pub const CONFIG_SSB_DRIVER_PCICORE: u32 = 1;
pub const CONFIG_INPUT_TABLET: u32 = 1;
pub const CONFIG_HID_SENSOR_IIO_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_SOCK_RX_QUEUE_MAPPING: u32 = 1;
pub const CONFIG_IIO_CROS_EC_SENSORS_LID_ANGLE_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MAX2165_MODULE: u32 = 1;
pub const CONFIG_PHY_INTEL_LGM_EMMC_MODULE: u32 = 1;
pub const CONFIG_GPIO_FXL6408_MODULE: u32 = 1;
pub const CONFIG_PLFXLC_MODULE: u32 = 1;
pub const CONFIG_MDIO_MODULE: u32 = 1;
pub const CONFIG_N_HDLC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7118_I2C_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_INTELEXT_MODULE: u32 = 1;
pub const CONFIG_MPTCP: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_HMAC: u32 = 1;
pub const CONFIG_ATM_LANAI_MODULE: u32 = 1;
pub const CONFIG_MISDN_HDLC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_GTM601_MODULE: u32 = 1;
pub const CONFIG_DRM_BRIDGE: u32 = 1;
pub const CONFIG_LLC2_MODULE: u32 = 1;
pub const CONFIG_FB_DEVICE: u32 = 1;
pub const CONFIG_IR_WINBOND_CIR_MODULE: u32 = 1;
pub const CONFIG_HPET_EMULATE_RTC: u32 = 1;
pub const CONFIG_USB_F_SERIAL_MODULE: u32 = 1;
pub const CONFIG_X86_MPPARSE: u32 = 1;
pub const CONFIG_RAVE_SP_CORE_MODULE: u32 = 1;
pub const CONFIG_BNXT_MODULE: u32 = 1;
pub const CONFIG_NITRO_ENCLAVES_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SILAN: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_LIB_MODULE: u32 = 1;
pub const CONFIG_SENSORS_UCD9000_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_QCOM_MODULE: u32 = 1;
pub const CONFIG_SND_OXYGEN_LIB_MODULE: u32 = 1;
pub const CONFIG_US5182D_MODULE: u32 = 1;
pub const CONFIG_MLXREG_LC_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L90: u32 = 1;
pub const CONFIG_ADDRESS_MASKING: u32 = 1;
pub const CONFIG_SX9310_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98357A_MODULE: u32 = 1;
pub const CONFIG_DLM_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ARC_MODULE: u32 = 1;
pub const CONFIG_STK8312_MODULE: u32 = 1;
pub const CONFIG_DRM_ANALOGIX_ANX78XX_MODULE: u32 = 1;
pub const CONFIG_CAN_CC770_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_BPF_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_GOTOP: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_REMBRANDT_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PER_VMA_LOCK: u32 = 1;
pub const CONFIG_EEEPC_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_HID_ACCUTOUCH_MODULE: u32 = 1;
pub const CONFIG_BT_6LOWPAN_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_MODULE: u32 = 1;
pub const CONFIG_GPIO_LP873X_MODULE: u32 = 1;
pub const CONFIG_MAG3110_MODULE: u32 = 1;
pub const CONFIG_HMC6352_MODULE: u32 = 1;
pub const CONFIG_ACRN_HSM_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_BROADCOM: u32 = 1;
pub const CONFIG_SYNTH_EVENTS: u32 = 1;
pub const CONFIG_SERIAL_FSL_LPUART_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_PCTV452E_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_SKIP_EGRESS: u32 = 1;
pub const CONFIG_JOYSTICK_PSXPAD_SPI_FF: u32 = 1;
pub const CONFIG_DVB_VES1820_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CPU_AUTOPROBE: u32 = 1;
pub const CONFIG_BOSCH_BNO055_MODULE: u32 = 1;
pub const CONFIG_BAYCOM_SER_HDX_MODULE: u32 = 1;
pub const CONFIG_SCHED_MC: u32 = 1;
pub const CONFIG_DELL_RBU_MODULE: u32 = 1;
pub const CONFIG_ALTERA_MBOX_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_ATA: u32 = 1;
pub const CONFIG_AD7266_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_LABPC_PCI_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DS2782_MODULE: u32 = 1;
pub const CONFIG_SECONDARY_TRUSTED_KEYRING: u32 = 1;
pub const CONFIG_DEV_DAX_PMEM_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_PERFORMANCE: u32 = 1;
pub const CONFIG_GPIO_ICH_MODULE: u32 = 1;
pub const CONFIG_EFI: u32 = 1;
pub const CONFIG_RATIONAL: u32 = 1;
pub const CONFIG_I2C_MUX_MODULE: u32 = 1;
pub const CONFIG_LMP91000_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_LOOP_MODULE: u32 = 1;
pub const CONFIG_SATA_MV_MODULE: u32 = 1;
pub const CONFIG_ACPI_FFH: u32 = 1;
pub const CONFIG_DVB_TS2020_MODULE: u32 = 1;
pub const CONFIG_AGP_AMD64: u32 = 1;
pub const CONFIG_WLAN_VENDOR_INTEL: u32 = 1;
pub const CONFIG_HAVE_SETUP_PER_CPU_AREA: u32 = 1;
pub const CONFIG_SENSORS_DELTA_AHE50DC_FAN_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ_PTP: u32 = 1;
pub const CONFIG_TI_DAC082S085_MODULE: u32 = 1;
pub const CONFIG_AD74115_MODULE: u32 = 1;
pub const CONFIG_CHARGER_ISP1704_MODULE: u32 = 1;
pub const CONFIG_SND_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_USERPTR: u32 = 1;
pub const CONFIG_SPI_SLAVE_TIME_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_TRUSTED_KEYRING: u32 = 1;
pub const CONFIG_TYPEC_HD3SS3220_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_QM1D1C0042_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_CORE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_SPDIF_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SIMPLE_MODULE: u32 = 1;
pub const CONFIG_GENERIC_EARLY_IOREMAP: u32 = 1;
pub const CONFIG_DVB_TUNER_DIB0090_MODULE: u32 = 1;
pub const CONFIG_PCI_XEN: u32 = 1;
pub const CONFIG_PMIC_OPREGION: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_MODULE: u32 = 1;
pub const CONFIG_LCD_AMS369FG06_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EGALAX_SERIAL_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_ATUSB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SMA1303_MODULE: u32 = 1;
pub const CONFIG_ARCNET_CAP_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_MODULE: u32 = 1;
pub const CONFIG_NULL_TTY_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_UBSAN_BOUNDS_STRICT: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_TXPRT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31790_MODULE: u32 = 1;
pub const CONFIG_NVME_HWMON: u32 = 1;
pub const CONFIG_X25_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX290_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_WANGXUN: u32 = 1;
pub const CONFIG_NET_L3_MASTER_DEV: u32 = 1;
pub const CONFIG_HID_SENSOR_INCLINOMETER_3D_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SBTSI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_FTSTEUTATES_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_YEAH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_RT5682_MACH_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_DMA_ADDRESSING_MODE: u32 = 1;
pub const CONFIG_SENSORS_LTC2947_SPI_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_MODULE: u32 = 1;
pub const CONFIG_DA9063_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_CUSTOM_SENSOR_MODULE: u32 = 1;
pub const CONFIG_SCSI_QLA_FC_MODULE: u32 = 1;
pub const CONFIG_VMAP_STACK: u32 = 1;
pub const CONFIG_TELCLOCK_MODULE: u32 = 1;
pub const CONFIG_I40EVF_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PC263_ISA_MODULE: u32 = 1;
pub const CONFIG_BE2NET_BE2: u32 = 1;
pub const CONFIG_BMG160_SPI_MODULE: u32 = 1;
pub const CONFIG_BLOCK: u32 = 1;
pub const CONFIG_IP_VS_LC_MODULE: u32 = 1;
pub const CONFIG_ARCH_STACKWALK: u32 = 1;
pub const CONFIG_USB_DWC3_PCI_MODULE: u32 = 1;
pub const CONFIG_RANDOM_KMALLOC_CACHES: u32 = 1;
pub const CONFIG_HID_APPLE_MODULE: u32 = 1;
pub const CONFIG_ADXL313_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB9000_MODULE: u32 = 1;
pub const CONFIG_BNXT_FLOWER_OFFLOAD: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_STREAM_PARSER: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA827X_MODULE: u32 = 1;
pub const CONFIG_VMXNET3_MODULE: u32 = 1;
pub const CONFIG_INIT_ENV_ARG_LIMIT: u32 = 32;
pub const CONFIG_IP_NF_ARP_MANGLE_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_SSD1306_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6594_SPI_MODULE: u32 = 1;
pub const CONFIG_DRM_ACCEL: u32 = 1;
pub const CONFIG_P54_LEDS: u32 = 1;
pub const CONFIG_SAMPLE_TRACE_ARRAY_MODULE: u32 = 1;
pub const CONFIG_MOST_CDEV_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_88PM860X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX34440_MODULE: u32 = 1;
pub const CONFIG_SENSORS_G760A_MODULE: u32 = 1;
pub const CONFIG_RDS_MODULE: u32 = 1;
pub const CONFIG_AK09911_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_LZORLE: u32 = 1;
pub const CONFIG_DVB_ATBM8830_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6594_I2C_MODULE: u32 = 1;
pub const CONFIG_PATA_EFAR_MODULE: u32 = 1;
pub const CONFIG_PCI_ENDPOINT_CONFIGFS: u32 = 1;
pub const CONFIG_HOLTEK_FF: u32 = 1;
pub const CONFIG_NET_SCH_FQ_PIE_MODULE: u32 = 1;
pub const CONFIG_EXFAT_FS_MODULE: u32 = 1;
pub const CONFIG_EEPROM_93XX46_MODULE: u32 = 1;
pub const CONFIG_LEDS_BD2606MVV_MODULE: u32 = 1;
pub const CONFIG_AF_UNIX_OOB: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKYLAKE_SSP_CLK_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2430_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_PRIVACY: u32 = 1;
pub const CONFIG_COMEDI_DYNA_PCI10XX_MODULE: u32 = 1;
pub const CONFIG_ATL2_MODULE: u32 = 1;
pub const CONFIG_USER_NS: u32 = 1;
pub const CONFIG_ARCH_WANT_BATCHED_UNMAP_TLB_FLUSH: u32 = 1;
pub const CONFIG_COMMON_CLK_MAX9485_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_MODULE: u32 = 1;
pub const CONFIG_CHROMEOS_TBMC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TFA989X_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_PPTP_MODULE: u32 = 1;
pub const CONFIG_CPU_SUP_INTEL: u32 = 1;
pub const CONFIG_FUEL_GAUGE_MM8013_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_CDG_MODULE: u32 = 1;
pub const CONFIG_INTEL_WMI_SBL_FW_UPDATE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TDA1997X_MODULE: u32 = 1;
pub const CONFIG_DVB_ZL10036_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_ALSA_MODULE: u32 = 1;
pub const CONFIG_CHARGER_DA9150_MODULE: u32 = 1;
pub const CONFIG_HFSPLUS_FS_MODULE: u32 = 1;
pub const CONFIG_TMPFS_POSIX_ACL: u32 = 1;
pub const CONFIG_STRICT_KERNEL_RWX: u32 = 1;
pub const CONFIG_HAVE_ARCH_KCSAN: u32 = 1;
pub const CONFIG_SENSORS_ADM9240_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CAFE_CCIC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7118_HW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKL_RT286_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_USB_UA101_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_PCIEAER: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP_CORE_MODULE: u32 = 1;
pub const CONFIG_NETLINK_DIAG_MODULE: u32 = 1;
pub const CONFIG_CAN_IFI_CANFD_MODULE: u32 = 1;
pub const CONFIG_BUG: u32 = 1;
pub const CONFIG_KS0108_PORT: u32 = 888;
pub const CONFIG_SCSI_AIC7XXX_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_SWITCH_TRACER: u32 = 1;
pub const CONFIG_MAC80211_HAS_RC: u32 = 1;
pub const CONFIG_BATMAN_ADV_BLA: u32 = 1;
pub const CONFIG_KDB_KEYBOARD: u32 = 1;
pub const CONFIG_SND_SOC_SSM2602_SPI_MODULE: u32 = 1;
pub const CONFIG_LOGIWHEELS_FF: u32 = 1;
pub const CONFIG_SENSORS_INA209_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEBUG_WX: u32 = 1;
pub const CONFIG_USB_SL811_HCD_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_ADC_MODULE: u32 = 1;
pub const CONFIG_OCFS2_FS_O2CB_MODULE: u32 = 1;
pub const CONFIG_MDIO_GPIO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DW9807_VCM_MODULE: u32 = 1;
pub const CONFIG_XEN: u32 = 1;
pub const CONFIG_CRYPTO_CAST6_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_UDP_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_META_MODULE: u32 = 1;
pub const CONFIG_KS8842_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPR_DUMP: u32 = 1;
pub const CONFIG_I40E_DCB: u32 = 1;
pub const CONFIG_GREYBUS_LIGHT_MODULE: u32 = 1;
pub const CONFIG_TYPEC_WCOVE_MODULE: u32 = 1;
pub const CONFIG_MFD_MT6360_MODULE: u32 = 1;
pub const CONFIG_PANTHERLORD_FF: u32 = 1;
pub const CONFIG_I2C_DIOLAN_U2C_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_MEMBARRIER_SYNC_CORE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_KBL_DA7219_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_RC_XBOX_DVD_MODULE: u32 = 1;
pub const CONFIG_PM: u32 = 1;
pub const CONFIG_LTC1660_MODULE: u32 = 1;
pub const CONFIG_SND_CS46XX_NEW_DSP: u32 = 1;
pub const CONFIG_VIDEO_ADV7343_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CCS_PLL_MODULE: u32 = 1;
pub const CONFIG_MXC6255_MODULE: u32 = 1;
pub const CONFIG_PPS: u32 = 1;
pub const CONFIG_FB_RIVA_BACKLIGHT: u32 = 1;
pub const CONFIG_NETFILTER_XTABLES_COMPAT: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_PATTERN_MODULE: u32 = 1;
pub const CONFIG_GENERIC_ISA_DMA: u32 = 1;
pub const CONFIG_IEEE802154_CA8210_DEBUGFS: u32 = 1;
pub const CONFIG_NFC_PN544_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX8903_MODULE: u32 = 1;
pub const CONFIG_USB_LCD_MODULE: u32 = 1;
pub const CONFIG_MEMCG: u32 = 1;
pub const CONFIG_SPI: u32 = 1;
pub const CONFIG_TCS3414_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MENF21BMC_HWMON_MODULE: u32 = 1;
pub const CONFIG_RTC_SYSTOHC_DEVICE: &[u8; 5usize] = b"rtc0\0";
pub const CONFIG_SENSORS_DS620_MODULE: u32 = 1;
pub const CONFIG_EVM_EXTRA_SMACK_XATTRS: u32 = 1;
pub const CONFIG_CRYPTO_BLAKE2S_X86: u32 = 1;
pub const CONFIG_V4L_MEM2MEM_DRIVERS: u32 = 1;
pub const CONFIG_X86_SPEEDSTEP_CENTRINO: u32 = 1;
pub const CONFIG_MFD_TPS65912_SPI: u32 = 1;
pub const CONFIG_HAVE_KVM_CPU_RELAX_INTERCEPT: u32 = 1;
pub const CONFIG_NFT_HASH_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_IRC_MODULE: u32 = 1;
pub const CONFIG_RENESAS_PHY_MODULE: u32 = 1;
pub const CONFIG_NOUVEAU_DEBUG_DEFAULT: u32 = 3;
pub const CONFIG_BACKLIGHT_AAT2870_MODULE: u32 = 1;
pub const CONFIG_PATA_NS87410_MODULE: u32 = 1;
pub const CONFIG_L2TP_IP_MODULE: u32 = 1;
pub const CONFIG_RADIO_SI476X_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SAFESETID: u32 = 1;
pub const CONFIG_GPIO_DS4520_MODULE: u32 = 1;
pub const CONFIG_MTD_REDBOOT_PARTS_MODULE: u32 = 1;
pub const CONFIG_DLHL60D_MODULE: u32 = 1;
pub const CONFIG_VBOXGUEST_MODULE: u32 = 1;
pub const CONFIG_BT_MSFTEXT: u32 = 1;
pub const CONFIG_MTD_UBI_FASTMAP: u32 = 1;
pub const CONFIG_XZ_DEC_MICROLZMA: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_ENCTYPES_AES_SHA1: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC23_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMG_SPDIF_IN_MODULE: u32 = 1;
pub const CONFIG_NET_FAILOVER: u32 = 1;
pub const CONFIG_SND_SOC_FSL_XCVR_MODULE: u32 = 1;
pub const CONFIG_USB_STV06XX_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_PURELIFI: u32 = 1;
pub const CONFIG_PPP_DEFLATE_MODULE: u32 = 1;
pub const CONFIG_USELIB: u32 = 1;
pub const CONFIG_REGULATOR_DA903X_MODULE: u32 = 1;
pub const CONFIG_VGA_SWITCHEROO: u32 = 1;
pub const CONFIG_PSAMPLE_MODULE: u32 = 1;
pub const CONFIG_USB_ISP1301_MODULE: u32 = 1;
pub const CONFIG_MFD_CS42L43_SDW_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DA9052_MODULE: u32 = 1;
pub const CONFIG_B53_MDIO_DRIVER_MODULE: u32 = 1;
pub const CONFIG_IRQ_REMAP: u32 = 1;
pub const CONFIG_MLX5_TC_CT: u32 = 1;
pub const CONFIG_DVB_PT3_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH_KMP_MODULE: u32 = 1;
pub const CONFIG_IO_URING: u32 = 1;
pub const CONFIG_MAX31856_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRC64_ROCKSOFT: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PC263_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_MAESTRO3_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_SMEM_MODULE: u32 = 1;
pub const CONFIG_VT: u32 = 1;
pub const CONFIG_HAVE_KERNEL_ZSTD: u32 = 1;
pub const CONFIG_USB_NET_NET1080_MODULE: u32 = 1;
pub const CONFIG_VMAP_PFN: u32 = 1;
pub const CONFIG_HID_REDRAGON_MODULE: u32 = 1;
pub const CONFIG_DMABUF_HEAPS: u32 = 1;
pub const CONFIG_STK3310_MODULE: u32 = 1;
pub const CONFIG_SENSORS_F71805F_MODULE: u32 = 1;
pub const CONFIG_SECRETMEM: u32 = 1;
pub const CONFIG_SUNRPC_DEBUG: u32 = 1;
pub const CONFIG_AD7124_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CLASSIFY_MODULE: u32 = 1;
pub const CONFIG_INET6_ESP_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMG_SPDIF_OUT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INA238_MODULE: u32 = 1;
pub const CONFIG_CCS811_MODULE: u32 = 1;
pub const CONFIG_HID_TIVO_MODULE: u32 = 1;
pub const CONFIG_HID_ICADE_MODULE: u32 = 1;
pub const CONFIG_PCI_ATS: u32 = 1;
pub const CONFIG_MISDN_IPAC_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_SECURITY: u32 = 1;
pub const CONFIG_LTC2497_MODULE: u32 = 1;
pub const CONFIG_USB_NET_AQC111_MODULE: u32 = 1;
pub const CONFIG_MACB_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CIRRUS_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCI_IDIO_16_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SPI: u32 = 1;
pub const CONFIG_BT_BREDR: u32 = 1;
pub const CONFIG_DMA_ACPI: u32 = 1;
pub const CONFIG_VIDEO_HEXIUM_GEMINI_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_HANDLE_BOOT_ENABLED: u32 = 1;
pub const CONFIG_EXTCON_SM5502_MODULE: u32 = 1;
pub const CONFIG_MSCC_OCELOT_SWITCH_LIB_MODULE: u32 = 1;
pub const CONFIG_CB710_DEBUG_ASSUMPTIONS: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_CHTWC: u32 = 1;
pub const CONFIG_SPLIT_PTLOCK_CPUS: u32 = 4;
pub const CONFIG_LEDS_AS3645A_MODULE: u32 = 1;
pub const CONFIG_USB_R8A66597_MODULE: u32 = 1;
pub const CONFIG_SBITMAP: u32 = 1;
pub const CONFIG_MAX77541_ADC_MODULE: u32 = 1;
pub const CONFIG_INPUT_DRV2665_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_EDAC_E752X_MODULE: u32 = 1;
pub const CONFIG_GTP_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV_SEL_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX3355_MODULE: u32 = 1;
pub const CONFIG_MSPRO_BLOCK_MODULE: u32 = 1;
pub const CONFIG_DVB_TUNER_ITD1000_MODULE: u32 = 1;
pub const CONFIG_POWER_SUPPLY: u32 = 1;
pub const CONFIG_SPI_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_DM_PERSISTENT_DATA_MODULE: u32 = 1;
pub const CONFIG_PATA_VIA_MODULE: u32 = 1;
pub const CONFIG_SCSI_UFSHCD_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_DAVICOM_PHY_MODULE: u32 = 1;
pub const CONFIG_SCTP_COOKIE_HMAC_MD5: u32 = 1;
pub const CONFIG_PARAVIRT_XXL: u32 = 1;
pub const CONFIG_KVM_GENERIC_MEMORY_ATTRIBUTES: u32 = 1;
pub const CONFIG_CIFS_XATTR: u32 = 1;
pub const CONFIG_CRYPTO_ZSTD_MODULE: u32 = 1;
pub const CONFIG_KEXEC_JUMP: u32 = 1;
pub const CONFIG_SENSORS_ADM1275_MODULE: u32 = 1;
pub const CONFIG_SND_DMAENGINE_PCM_MODULE: u32 = 1;
pub const CONFIG_I2C_PCA_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NFQUEUE_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_BOOTPARAM: u32 = 1;
pub const CONFIG_ARCH_HAS_UACCESS_FLUSHCACHE: u32 = 1;
pub const CONFIG_DRM_ACCEL_QAIC_MODULE: u32 = 1;
pub const CONFIG_CAN_8DEV_USB_MODULE: u32 = 1;
pub const CONFIG_PAHOLE_HAS_SPLIT_BTF: u32 = 1;
pub const CONFIG_SND_HDA_INPUT_BEEP: u32 = 1;
pub const CONFIG_WEXT_CORE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_CORE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_MR97310A_MODULE: u32 = 1;
pub const CONFIG_DVB_HOPPER_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_CHIP: u32 = 1;
pub const CONFIG_ACPI_THERMAL_REL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SKCIPHER2: u32 = 1;
pub const CONFIG_NETLABEL: u32 = 1;
pub const CONFIG_VIDEO_WM8775_MODULE: u32 = 1;
pub const CONFIG_CHARGER_SBS_MODULE: u32 = 1;
pub const CONFIG_NLS: u32 = 1;
pub const CONFIG_REGULATOR_MAX77826_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_4XXX_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_TIMEOUT: u32 = 1;
pub const CONFIG_ARCH_WANTS_NO_INSTR: u32 = 1;
pub const CONFIG_GPIO_SCH311X_MODULE: u32 = 1;
pub const CONFIG_MT76_SDIO_MODULE: u32 = 1;
pub const CONFIG_INPUT_PCAP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_HDAC_HDMI_MODULE: u32 = 1;
pub const CONFIG_INPUT_PALMAS_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_V4L2_FLASH_LED_CLASS_MODULE: u32 = 1;
pub const CONFIG_MFD_ARIZONA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_COBALT_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPPORTNET_MODULE: u32 = 1;
pub const CONFIG_SMC_DIAG_MODULE: u32 = 1;
pub const CONFIG_SURFACE_DTX_MODULE: u32 = 1;
pub const CONFIG_LEDS_APU_MODULE: u32 = 1;
pub const CONFIG_SCHED_AUTOGROUP: u32 = 1;
pub const CONFIG_XILINX_LL_TEMAC_MODULE: u32 = 1;
pub const CONFIG_BCACHEFS_ERASURE_CODING: u32 = 1;
pub const CONFIG_COMEDI_PCL730_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPS65912_MODULE: u32 = 1;
pub const CONFIG_SPI_SPIDEV_MODULE: u32 = 1;
pub const CONFIG_EFI_BOOTLOADER_CONTROL_MODULE: u32 = 1;
pub const CONFIG_AS_IS_GNU: u32 = 1;
pub const CONFIG_MEDIA_CAMERA_SUPPORT: u32 = 1;
pub const CONFIG_BT_MTKSDIO_MODULE: u32 = 1;
pub const CONFIG_EFI_HANDOVER_PROTOCOL: u32 = 1;
pub const CONFIG_PRISM2_USB_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6359_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8893_MODULE: u32 = 1;
pub const CONFIG_ADM8211_MODULE: u32 = 1;
pub const CONFIG_IMA_SECURE_AND_OR_TRUSTED_BOOT: u32 = 1;
pub const CONFIG_MFD_WM8997: u32 = 1;
pub const CONFIG_HWPOISON_INJECT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98373_I2C_MODULE: u32 = 1;
pub const CONFIG_MAX1241_MODULE: u32 = 1;
pub const CONFIG_NTB_TOOL_MODULE: u32 = 1;
pub const CONFIG_VME_FAKE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX20730_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_ILI9325_MODULE: u32 = 1;
pub const CONFIG_RTL8188EE_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_DFL_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_VERIFY_ROOTHASH_SIG: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_SECMARK_MODULE: u32 = 1;
pub const CONFIG_HID_MAGICMOUSE_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_SENSORHUB_MODULE: u32 = 1;
pub const CONFIG_MICROSEMI_PHY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW686X_MODULE: u32 = 1;
pub const CONFIG_TI_DAC7311_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4554_MODULE: u32 = 1;
pub const CONFIG_I2C_GPIO_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L35: u32 = 1;
pub const CONFIG_ADXL355_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TDA9840_MODULE: u32 = 1;
pub const CONFIG_INET_UDP_DIAG_MODULE: u32 = 1;
pub const CONFIG_MEDIA_SDR_SUPPORT: u32 = 1;
pub const CONFIG_USB_CONFIGFS_ACM: u32 = 1;
pub const CONFIG_CGROUP_BPF: u32 = 1;
pub const CONFIG_RAPIDIO_ENUM_BASIC_MODULE: u32 = 1;
pub const CONFIG_XEN_SAVE_RESTORE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC3X_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_ZD1301_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ETURBO: u32 = 1;
pub const CONFIG_DELL_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_PPPOE_MODULE: u32 = 1;
pub const CONFIG_IPV6_SEG6_HMAC: u32 = 1;
pub const CONFIG_CRYPTO_CRCT10DIF_PCLMUL_MODULE: u32 = 1;
pub const CONFIG_LEDS_AW200XX_MODULE: u32 = 1;
pub const CONFIG_WL1251_SDIO_MODULE: u32 = 1;
pub const CONFIG_GPIO_TQMX86_MODULE: u32 = 1;
pub const CONFIG_PCI_REALLOC_ENABLE_AUTO: u32 = 1;
pub const CONFIG_X86_INTEL_PSTATE: u32 = 1;
pub const CONFIG_TMPFS_INODE64: u32 = 1;
pub const CONFIG_NTFS3_LZX_XPRESS: u32 = 1;
pub const CONFIG_SND_LAYLA24_MODULE: u32 = 1;
pub const CONFIG_ADXL355_SPI_MODULE: u32 = 1;
pub const CONFIG_NFC_PN533_USB_MODULE: u32 = 1;
pub const CONFIG_ZONE_DMA: u32 = 1;
pub const CONFIG_VIDEO_CX25821_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA508_MODULE: u32 = 1;
pub const CONFIG_USB_LEGOTOWER_MODULE: u32 = 1;
pub const CONFIG_INTEL_RAPL_TPMI_MODULE: u32 = 1;
pub const CONFIG_I2C_ROBOTFUZZ_OSIF_MODULE: u32 = 1;
pub const CONFIG_MTD_DATAFLASH_MODULE: u32 = 1;
pub const CONFIG_DVB_DRX39XYJ_MODULE: u32 = 1;
pub const CONFIG_FB_MB862XX_I2C: u32 = 1;
pub const CONFIG_QLCNIC_HWMON: u32 = 1;
pub const CONFIG_ACPI_I2C_OPREGION: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_DA7219_MODULE: u32 = 1;
pub const CONFIG_UBSAN_ENUM: u32 = 1;
pub const CONFIG_DEV_DAX_HMEM_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIBUSB_MC_MODULE: u32 = 1;
pub const CONFIG_I2C_CBUS_GPIO_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_VP702X_MODULE: u32 = 1;
pub const CONFIG_CAN_CC770_ISA_MODULE: u32 = 1;
pub const CONFIG_ROCKER_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_OWNER_MODULE: u32 = 1;
pub const CONFIG_GPIO_WM8994_MODULE: u32 = 1;
pub const CONFIG_I2C_SIS5595_MODULE: u32 = 1;
pub const CONFIG_VMGENID_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_DEVICE_MODULE: u32 = 1;
pub const CONFIG_SUN_PARTITION: u32 = 1;
pub const CONFIG_IP_NF_TARGET_ECN_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GC0308_MODULE: u32 = 1;
pub const CONFIG_SND_GINA24_MODULE: u32 = 1;
pub const CONFIG_NFC_NXP_NCI_I2C_MODULE: u32 = 1;
pub const CONFIG_SYN_COOKIES: u32 = 1;
pub const CONFIG_HAVE_NOINSTR_VALIDATION: u32 = 1;
pub const CONFIG_SENSORS_IR35221_MODULE: u32 = 1;
pub const CONFIG_REED_SOLOMON_DEC8: u32 = 1;
pub const CONFIG_IRQ_WORK: u32 = 1;
pub const CONFIG_ATH9K_MODULE: u32 = 1;
pub const CONFIG_PCI_MSI: u32 = 1;
pub const CONFIG_IP_ADVANCED_ROUTER: u32 = 1;
pub const CONFIG_MISDN_NETJET_MODULE: u32 = 1;
pub const CONFIG_ARCNET_COM20020_CS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_CB_PCIDDA_MODULE: u32 = 1;
pub const CONFIG_DRM_XEN_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_FB_SYS_COPYAREA: u32 = 1;
pub const CONFIG_CHTCRC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_HAVE_ARCH_RANDOMIZE_KSTACK_OFFSET: u32 = 1;
pub const CONFIG_SENSORS_OCC_P8_I2C_MODULE: u32 = 1;
pub const CONFIG_X86_64_SMP: u32 = 1;
pub const CONFIG_HTU21_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_PCI: u32 = 1;
pub const CONFIG_XILINX_AXI_EMAC_MODULE: u32 = 1;
pub const CONFIG_PATA_CYPRESS_MODULE: u32 = 1;
pub const CONFIG_TYPEC_RT1711H_MODULE: u32 = 1;
pub const CONFIG_SPI_BITBANG_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2063_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_ALAUDA_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_FUJITSU: u32 = 1;
pub const CONFIG_JOYSTICK_GRIP_MP_MODULE: u32 = 1;
pub const CONFIG_SPARSEMEM_EXTREME: u32 = 1;
pub const CONFIG_DMARD09_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2406_MODULE: u32 = 1;
pub const CONFIG_B44_PCICORE_AUTOSELECT: u32 = 1;
pub const CONFIG_IWLWIFI_MODULE: u32 = 1;
pub const CONFIG_USB_COMMON: u32 = 1;
pub const CONFIG_CYPRESS_FIRMWARE_MODULE: u32 = 1;
pub const CONFIG_BPF_KPROBE_OVERRIDE: u32 = 1;
pub const CONFIG_SENSORS_ADM1031_MODULE: u32 = 1;
pub const CONFIG_TASK_XACCT: u32 = 1;
pub const CONFIG_SND_SOC_RT9120_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HDMI_HELPER: u32 = 1;
pub const CONFIG_ARCNET_1051_MODULE: u32 = 1;
pub const CONFIG_LEDS_MT6370_RGB_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18271_MODULE: u32 = 1;
pub const CONFIG_IP_SET_BITMAP_PORT_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_IPTABLES_MODULE: u32 = 1;
pub const CONFIG_LZ4_COMPRESS_MODULE: u32 = 1;
pub const CONFIG_DRM_GPUVM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SIGMADSP_REGMAP_MODULE: u32 = 1;
pub const CONFIG_KVM_VFIO: u32 = 1;
pub const CONFIG_SENSORS_FSP_3Y_MODULE: u32 = 1;
pub const CONFIG_PHY_QCOM_USB_HSIC_MODULE: u32 = 1;
pub const CONFIG_USB_HSIC_USB3503_MODULE: u32 = 1;
pub const CONFIG_X86_PCC_CPUFREQ: u32 = 1;
pub const CONFIG_QFMT_V1_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_ANCHOR: u32 = 1;
pub const CONFIG_DVB_IX2505V_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ZYTRONIC: u32 = 1;
pub const CONFIG_SND_SONICVIBES_MODULE: u32 = 1;
pub const CONFIG_FIXED_PHY: u32 = 1;
pub const CONFIG_CHELSIO_T4_FCOE: u32 = 1;
pub const CONFIG_DVB_SP2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SHT4x_MODULE: u32 = 1;
pub const CONFIG_GPIO_WS16C48_MODULE: u32 = 1;
pub const CONFIG_GPIO_ACPI: u32 = 1;
pub const CONFIG_MFD_MAX8998: u32 = 1;
pub const CONFIG_ARCH_HAS_SYNC_CORE_BEFORE_USERMODE: u32 = 1;
pub const CONFIG_SENSORS_TMP103_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_GAELIC_MODULE: u32 = 1;
pub const CONFIG_SND_UMP_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_USERSPACE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_PASID: u32 = 1;
pub const CONFIG_FTRACE_SYSCALLS: u32 = 1;
pub const CONFIG_IMG_ASCII_LCD_MODULE: u32 = 1;
pub const CONFIG_AS_TPAUSE: u32 = 1;
pub const CONFIG_SND_SOC_TSCS42XX_MODULE: u32 = 1;
pub const CONFIG_SND_CA0106_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIA_CAMERA_MODULE: u32 = 1;
pub const CONFIG_LOG_CPU_MAX_BUF_SHIFT: u32 = 12;
pub const CONFIG_CRYPTO_JITTERENTROPY_MEMORY_BLOCKSIZE: u32 = 32;
pub const CONFIG_VIDEO_SAA6752HS_MODULE: u32 = 1;
pub const CONFIG_NF_DUP_IPV4_MODULE: u32 = 1;
pub const CONFIG_XEN_PVHVM_SMP: u32 = 1;
pub const CONFIG_BLK_DEV_DM_BUILTIN: u32 = 1;
pub const CONFIG_INTEL_CHTDC_TI_PWRBTN_MODULE: u32 = 1;
pub const CONFIG_HID_FT260_MODULE: u32 = 1;
pub const CONFIG_RPR0521_MODULE: u32 = 1;
pub const CONFIG_HMC425_MODULE: u32 = 1;
pub const CONFIG_COMEDI_FL512_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_IPW_MODULE: u32 = 1;
pub const CONFIG_I2C_PIIX4_MODULE: u32 = 1;
pub const CONFIG_EDAC_I7300_MODULE: u32 = 1;
pub const CONFIG_USB_HCD_SSB_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_DTS_THERMAL_MODULE: u32 = 1;
pub const CONFIG_ARCNET_COM20020_PCI_MODULE: u32 = 1;
pub const CONFIG_SERIAL_UARTLITE_MODULE: u32 = 1;
pub const CONFIG_INET_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_FSCHMD_MODULE: u32 = 1;
pub const CONFIG_TASKS_RCU: u32 = 1;
pub const CONFIG_INTEL_RAPL_CORE_MODULE: u32 = 1;
pub const CONFIG_DP83TD510_PHY_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIB0700_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_FUJITSU_MODULE: u32 = 1;
pub const CONFIG_VGA_ARB_MAX_GPUS: u32 = 16;
pub const CONFIG_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_XEN_BLKDEV_BACKEND_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5514_SPI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PINCONF: u32 = 1;
pub const CONFIG_SCSI_EFCT_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_USB_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBLUECARD_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_XATTR: u32 = 1;
pub const CONFIG_HID_XIAOMI_MODULE: u32 = 1;
pub const CONFIG_XILLYBUS_PCIE_MODULE: u32 = 1;
pub const CONFIG_EVENT_TRACING: u32 = 1;
pub const CONFIG_MFD_INTEL_LPSS_MODULE: u32 = 1;
pub const CONFIG_PAGE_TABLE_ISOLATION: u32 = 1;
pub const CONFIG_ARCH_HAS_NMI_SAFE_THIS_CPU_OPS: u32 = 1;
pub const CONFIG_SND_ENS1370_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX77503_MODULE: u32 = 1;
pub const CONFIG_AD7476_MODULE: u32 = 1;
pub const CONFIG_ASYNC_PQ_MODULE: u32 = 1;
pub const CONFIG_HID_KEYTOUCH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT712_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_AS_SHA1_NI: u32 = 1;
pub const CONFIG_HID_CYPRESS_MODULE: u32 = 1;
pub const CONFIG_N_GSM_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_2_SSC_HELPER: u32 = 1;
pub const CONFIG_REGULATOR_LM363X_MODULE: u32 = 1;
pub const CONFIG_SG_POOL: u32 = 1;
pub const CONFIG_BRIDGE_EBT_LIMIT_MODULE: u32 = 1;
pub const CONFIG_SURFACE_PRO3_BUTTON_MODULE: u32 = 1;
pub const CONFIG_DRM_KMS_HELPER: u32 = 1;
pub const CONFIG_SERIAL_IPOCTAL_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_INTEL_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_PACKET_ENGINES: u32 = 1;
pub const CONFIG_DRM_PANEL_RASPBERRYPI_TOUCHSCREEN_MODULE: u32 = 1;
pub const CONFIG_IPW2200_PROMISCUOUS: u32 = 1;
pub const CONFIG_DMA_COHERENT_POOL: u32 = 1;
pub const CONFIG_NF_SOCKET_IPV6_MODULE: u32 = 1;
pub const CONFIG_OCFS2_FS_USERSPACE_CLUSTER_MODULE: u32 = 1;
pub const CONFIG_INTEL_BXTWC_PMIC_TMU_MODULE: u32 = 1;
pub const CONFIG_INIT_ON_ALLOC_DEFAULT_ON: u32 = 1;
pub const CONFIG_PINCTRL_TIGERLAKE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADL_PCI9111_MODULE: u32 = 1;
pub const CONFIG_ATA_OVER_ETH_MODULE: u32 = 1;
pub const CONFIG_BLK_MQ_PCI: u32 = 1;
pub const CONFIG_SPI_MXIC_MODULE: u32 = 1;
pub const CONFIG_USB_NET_PLUSB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TDA7419_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA711X_MODULE: u32 = 1;
pub const CONFIG_RTL8192C_COMMON_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PWM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CURVE25519_MODULE: u32 = 1;
pub const CONFIG_MFD_WM831X_SPI: u32 = 1;
pub const CONFIG_SENSORS_LM95234_MODULE: u32 = 1;
pub const CONFIG_ADXL372_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW9910_MODULE: u32 = 1;
pub const CONFIG_MEN_A21_WDT_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_VOLUNTARY: u32 = 1;
pub const CONFIG_DVB_BUDGET_CORE_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_1_MODULE: u32 = 1;
pub const CONFIG_LMK04832_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8400: u32 = 1;
pub const CONFIG_MTD_INTEL_VR_NOR_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WDT87XX_I2C_MODULE: u32 = 1;
pub const CONFIG_LRU_GEN: u32 = 1;
pub const CONFIG_MACINTOSH_DRIVERS: u32 = 1;
pub const CONFIG_NFC_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RNBD: u32 = 1;
pub const CONFIG_ALX_MODULE: u32 = 1;
pub const CONFIG_CIFS_FSCACHE: u32 = 1;
pub const CONFIG_R8169_MODULE: u32 = 1;
pub const CONFIG_MAX30102_MODULE: u32 = 1;
pub const CONFIG_PCI_STUB_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_HYBLA_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG_CTR: u32 = 1;
pub const CONFIG_DRM_I2C_NXP_TDA998X_MODULE: u32 = 1;
pub const CONFIG_MMC_CQHCI_MODULE: u32 = 1;
pub const CONFIG_HID_KENSINGTON_MODULE: u32 = 1;
pub const CONFIG_SMB_SERVER_KERBEROS5: u32 = 1;
pub const CONFIG_SND_SOC_RT700_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_HCD: u32 = 1;
pub const CONFIG_BATTERY_DS2760_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH_BM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HMC5843_I2C_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ25890_MODULE: u32 = 1;
pub const CONFIG_MFD_MP2629_MODULE: u32 = 1;
pub const CONFIG_FUJITSU_ES_MODULE: u32 = 1;
pub const CONFIG_ADRF6780_MODULE: u32 = 1;
pub const CONFIG_FS_IOMAP: u32 = 1;
pub const CONFIG_8139TOO_MODULE: u32 = 1;
pub const CONFIG_JFS_SECURITY: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC32X4_I2C_MODULE: u32 = 1;
pub const CONFIG_PCI_EPF_NTB_MODULE: u32 = 1;
pub const CONFIG_KVM_PRIVATE_MEM: u32 = 1;
pub const CONFIG_AFS_FSCACHE: u32 = 1;
pub const CONFIG_SND_PDAUDIOCF_MODULE: u32 = 1;
pub const CONFIG_TCP_SIGPOOL: u32 = 1;
pub const CONFIG_NLS_MAC_INUIT_MODULE: u32 = 1;
pub const CONFIG_PHY_QCOM_USB_HS_MODULE: u32 = 1;
pub const CONFIG_MFD_SIMPLE_MFD_I2C_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_LL: u32 = 1;
pub const CONFIG_HAVE_EISA: u32 = 1;
pub const CONFIG_MODULE_SIG_KEY_TYPE_RSA: u32 = 1;
pub const CONFIG_HID_ZYDACRON_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LP8755_MODULE: u32 = 1;
pub const CONFIG_PPP_MPPE_MODULE: u32 = 1;
pub const CONFIG_CAN_CALC_BITTIMING: u32 = 1;
pub const CONFIG_NFSD_V4_2_INTER_SSC: u32 = 1;
pub const CONFIG_HID_SENSOR_ACCEL_3D_MODULE: u32 = 1;
pub const CONFIG_DE2104X_MODULE: u32 = 1;
pub const CONFIG_KXSD9_I2C_MODULE: u32 = 1;
pub const CONFIG_ISA_BUS_API: u32 = 1;
pub const CONFIG_MEMORY_HOTPLUG: u32 = 1;
pub const CONFIG_SND_HDA_CS_DSP_CONTROLS_MODULE: u32 = 1;
pub const CONFIG_VMD_MODULE: u32 = 1;
pub const CONFIG_DVB_B2C2_FLEXCOP_MODULE: u32 = 1;
pub const CONFIG_COMPACT_UNEVICTABLE_DEFAULT: u32 = 1;
pub const CONFIG_RD_ZSTD: u32 = 1;
pub const CONFIG_UCSI_STM32G0_MODULE: u32 = 1;
pub const CONFIG_MOST_VIDEO_MODULE: u32 = 1;
pub const CONFIG_USB_NET_SR9700_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_ACPI: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1372_MODULE: u32 = 1;
pub const CONFIG_MFD_TQMX86_MODULE: u32 = 1;
pub const CONFIG_SATA_ZPODD: u32 = 1;
pub const CONFIG_HID_CMEDIA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8960_MODULE: u32 = 1;
pub const CONFIG_RFKILL: u32 = 1;
pub const CONFIG_AD5272_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TVP5150_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC0012_MODULE: u32 = 1;
pub const CONFIG_MT7915E_MODULE: u32 = 1;
pub const CONFIG_NETDEVICES: u32 = 1;
pub const CONFIG_ISA_BUS: u32 = 1;
pub const CONFIG_NET_KEY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ADV7180_MODULE: u32 = 1;
pub const CONFIG_SMS_SIANO_MDTV_MODULE: u32 = 1;
pub const CONFIG_EXTCON_INTEL_MRFLD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD9335_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_HL_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_CONNCOUNT_MODULE: u32 = 1;
pub const CONFIG_ATM_IDT77252_USE_SUNI: u32 = 1;
pub const CONFIG_SND_OPL3_LIB_SEQ_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_KCOV: u32 = 1;
pub const CONFIG_CGROUP_FREEZER: u32 = 1;
pub const CONFIG_VIDEO_UPD64083_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_JTAGUART_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MELFAS_MIP4_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_STACKLEAK: u32 = 1;
pub const CONFIG_EVENTFD: u32 = 1;
pub const CONFIG_CRYPTO_DEV_PADLOCK_SHA_MODULE: u32 = 1;
pub const CONFIG_SPI_DESIGNWARE_MODULE: u32 = 1;
pub const CONFIG_MTD_CK804XROM_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_TCP_TLS: u32 = 1;
pub const CONFIG_RTL8192CE_MODULE: u32 = 1;
pub const CONFIG_WAN: u32 = 1;
pub const CONFIG_VLAN_8021Q_MVRP: u32 = 1;
pub const CONFIG_RTL8821AE_MODULE: u32 = 1;
pub const CONFIG_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_ADXRS290_MODULE: u32 = 1;
pub const CONFIG_IPV6_SIT_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_IRDMA_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS65912_MODULE: u32 = 1;
pub const CONFIG_QTNFMAC_PCIE_MODULE: u32 = 1;
pub const CONFIG_EEPROM_EE1004_MODULE: u32 = 1;
pub const CONFIG_XFRM: u32 = 1;
pub const CONFIG_SENSORS_K8TEMP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_BT_SCO_MODULE: u32 = 1;
pub const CONFIG_ASYNC_TX_DMA: u32 = 1;
pub const CONFIG_COMEDI_DAS16_MODULE: u32 = 1;
pub const CONFIG_GPIO_LATCH_MODULE: u32 = 1;
pub const CONFIG_CAIF_USB_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PMEM_API: u32 = 1;
pub const CONFIG_USB_F_UAC2_MODULE: u32 = 1;
pub const CONFIG_LINEAR_RANGES: u32 = 1;
pub const CONFIG_DM_UNSTRIPED_MODULE: u32 = 1;
pub const CONFIG_HAVE_KPROBES_ON_FTRACE: u32 = 1;
pub const CONFIG_REGULATOR_PV88090_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IP_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_ST7586_MODULE: u32 = 1;
pub const CONFIG_YENTA_TOSHIBA: u32 = 1;
pub const CONFIG_USB_MR800_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_AS5011_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5695_MODULE: u32 = 1;
pub const CONFIG_MTD_NETtel_MODULE: u32 = 1;
pub const CONFIG_MFD_VX855_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_CONSOLE: u32 = 1;
pub const CONFIG_PATA_PARPORT_FIT3_MODULE: u32 = 1;
pub const CONFIG_DRM_BUDDY_MODULE: u32 = 1;
pub const CONFIG_IPV6_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_USB_ANNOUNCE_NEW_DEVICES: u32 = 1;
pub const CONFIG_CRYPTO_GENIV: u32 = 1;
pub const CONFIG_USB_SERIAL_WHITEHEAT_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_ROUTE4_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TVP514X_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_XRS700X_MDIO_MODULE: u32 = 1;
pub const CONFIG_HSA_AMD_P2P: u32 = 1;
pub const CONFIG_JUMP_LABEL: u32 = 1;
pub const CONFIG_NTFS3_FS_MODULE: u32 = 1;
pub const CONFIG_HID_UDRAW_PS3_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_FMVJ18X_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_QT1070_MODULE: u32 = 1;
pub const CONFIG_MFD_KEMPLD_MODULE: u32 = 1;
pub const CONFIG_LEDS_PCA995X_MODULE: u32 = 1;
pub const CONFIG_USB_NET2272_MODULE: u32 = 1;
pub const CONFIG_CHARGER_CROS_PCHG_MODULE: u32 = 1;
pub const CONFIG_OVERLAY_FS_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETPORT_MODULE: u32 = 1;
pub const CONFIG_CIFS_ALLOW_INSECURE_LEGACY: u32 = 1;
pub const CONFIG_DEBUG_INFO_COMPRESSED_NONE: u32 = 1;
pub const CONFIG_TCG_INFINEON_MODULE: u32 = 1;
pub const CONFIG_ATH9K_HTC_MODULE: u32 = 1;
pub const CONFIG_IP_VS_DH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8753_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_PROTO_MSGBUF: u32 = 1;
pub const CONFIG_AX25_DAMA_SLAVE: u32 = 1;
pub const CONFIG_AD5380_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT3290: u32 = 1;
pub const CONFIG_SX9324_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MEM2MEM_DEINTERLACE_MODULE: u32 = 1;
pub const CONFIG_RADIO_WL128X_MODULE: u32 = 1;
pub const CONFIG_PPPOE_HASH_BITS_4: u32 = 1;
pub const CONFIG_COMMON_CLK_CS2000_CP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8326_MODULE: u32 = 1;
pub const CONFIG_DA311_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_MASQUERADE_MODULE: u32 = 1;
pub const CONFIG_AIC79XX_RESET_DELAY_MS: u32 = 5000;
pub const CONFIG_UIO_HV_GENERIC_MODULE: u32 = 1;
pub const CONFIG_ARCNET_COM20020_MODULE: u32 = 1;
pub const CONFIG_MFD_AAT2870_CORE: u32 = 1;
pub const CONFIG_MT7921S_MODULE: u32 = 1;
pub const CONFIG_HAVE_EBPF_JIT: u32 = 1;
pub const CONFIG_NF_CONNTRACK_BROADCAST_MODULE: u32 = 1;
pub const CONFIG_ECRYPT_FS: u32 = 1;
pub const CONFIG_NFT_FWD_NETDEV_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LZ4_MODULE: u32 = 1;
pub const CONFIG_PROC_PAGE_MONITOR: u32 = 1;
pub const CONFIG_USB_CONFIGFS_ECM: u32 = 1;
pub const CONFIG_MFD_MAX8907_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_EXTENDED: u32 = 1;
pub const CONFIG_GAMEPORT_FM801_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_MASQUERADE_MODULE: u32 = 1;
pub const CONFIG_PWM_IQS620A_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX6916_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_MAGELLAN_MODULE: u32 = 1;
pub const CONFIG_AD7887_MODULE: u32 = 1;
pub const CONFIG_AD7780_MODULE: u32 = 1;
pub const CONFIG_ADXL313_I2C_MODULE: u32 = 1;
pub const CONFIG_FTL_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER_DMA_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARCH_HAVE_LIB_CURVE25519_MODULE: u32 = 1;
pub const CONFIG_TXGBE_MODULE: u32 = 1;
pub const CONFIG_XEN_MEMORY_HOTPLUG_LIMIT: u32 = 512;
pub const CONFIG_IGB_HWMON: u32 = 1;
pub const CONFIG_DM_CACHE_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_R820T_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NOR_USE_4K_SECTORS: u32 = 1;
pub const CONFIG_TYPEC_DP_ALTMODE_MODULE: u32 = 1;
pub const CONFIG_MOST_I2C_MODULE: u32 = 1;
pub const CONFIG_IPMI_DEVICE_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_BPF: u32 = 1;
pub const CONFIG_9P_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_OCTEON_EP_MODULE: u32 = 1;
pub const CONFIG_STM_SOURCE_HEARTBEAT_MODULE: u32 = 1;
pub const CONFIG_USB_VIDEO_CLASS_INPUT_EVDEV: u32 = 1;
pub const CONFIG_DELL_WMI_DDV_MODULE: u32 = 1;
pub const CONFIG_X86_BOOTPARAM_MEMORY_CORRUPTION_CHECK: u32 = 1;
pub const CONFIG_C2PORT_MODULE: u32 = 1;
pub const CONFIG_EVM_ATTR_FSUUID: u32 = 1;
pub const CONFIG_DM_DELAY_MODULE: u32 = 1;
pub const CONFIG_XEN_GRANT_DMA_OPS: u32 = 1;
pub const CONFIG_BLK_DEV_RNBD_SERVER_MODULE: u32 = 1;
pub const CONFIG_MEMORY_HOTPLUG_DEFAULT_ONLINE: u32 = 1;
pub const CONFIG_X86_CMOV: u32 = 1;
pub const CONFIG_USB_SERIAL_CH341_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_IIO_COMMON_MODULE: u32 = 1;
pub const CONFIG_CAIF_DRIVERS: u32 = 1;
pub const CONFIG_NET_DSA_TAG_SJA1105_MODULE: u32 = 1;
pub const CONFIG_ACPI_HOTPLUG_CPU: u32 = 1;
pub const CONFIG_XILINX_SDFEC_MODULE: u32 = 1;
pub const CONFIG_PM_TRACE_RTC: u32 = 1;
pub const CONFIG_RD_LZO: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_1564_MODULE: u32 = 1;
pub const CONFIG_USB_RAINSHADOW_CEC_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_SECURITY: u32 = 1;
pub const CONFIG_USB_G_NOKIA_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPPORT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_NHPOLY1305_SSE2_MODULE: u32 = 1;
pub const CONFIG_CAIF_TTY_MODULE: u32 = 1;
pub const CONFIG_KPROBE_EVENTS: u32 = 1;
pub const CONFIG_SENSORS_SHT21_MODULE: u32 = 1;
pub const CONFIG_USB_IOWARRIOR_MODULE: u32 = 1;
pub const CONFIG_SND_HDSP_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DA9052_MODULE: u32 = 1;
pub const CONFIG_SERIO_CT82C710_MODULE: u32 = 1;
pub const CONFIG_OPENVSWITCH_GENEVE_MODULE: u32 = 1;
pub const CONFIG_MLX4_CORE_GEN2: u32 = 1;
pub const CONFIG_USBPCWATCHDOG_MODULE: u32 = 1;
pub const CONFIG_CAN_KVASER_PCIEFD_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_ALL: u32 = 1;
pub const CONFIG_USB_EZUSB_FX2_MODULE: u32 = 1;
pub const CONFIG_SND_USB_TONEPORT_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_ZSTD: u32 = 1;
pub const CONFIG_SND_USB_USX2Y_MODULE: u32 = 1;
pub const CONFIG_SCSI_SPI_ATTRS_MODULE: u32 = 1;
pub const CONFIG_FB_CYBER2000_MODULE: u32 = 1;
pub const CONFIG_BCMA_DRIVER_GMAC_CMN: u32 = 1;
pub const CONFIG_RTL8XXXU_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_COPY_MC: u32 = 1;
pub const CONFIG_GREENASIA_FF: u32 = 1;
pub const CONFIG_MFD_CS47L92: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_GRAPH_RETVAL: u32 = 1;
pub const CONFIG_SND_SOC_SOF_BROADWELL_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CEDARFORK_MODULE: u32 = 1;
pub const CONFIG_SCSI_HPSA_MODULE: u32 = 1;
pub const CONFIG_XEN_GNTDEV_DMABUF: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP_DEFLATE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_ACNTSA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88395_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMG_I2S_IN_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TDA38640_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_TSI721_MODULE: u32 = 1;
pub const CONFIG_SND_KORG1212_MODULE: u32 = 1;
pub const CONFIG_SENSORS_VIA_CPUTEMP_MODULE: u32 = 1;
pub const CONFIG_MLX5_EN_ARFS: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SECMARK: u32 = 1;
pub const CONFIG_GP2AP020A00F_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T3_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV7640_MODULE: u32 = 1;
pub const CONFIG_INSTRUCTION_DECODER: u32 = 1;
pub const CONFIG_CRYPTO_SHA512: u32 = 1;
pub const CONFIG_SND_SOC_IMG_PISTACHIO_INTERNAL_DAC_MODULE: u32 = 1;
pub const CONFIG_CAN_ISOTP_MODULE: u32 = 1;
pub const CONFIG_PHONET_MODULE: u32 = 1;
pub const CONFIG_MWIFIEX_PCIE_MODULE: u32 = 1;
pub const CONFIG_CAN_C_CAN_PCI_MODULE: u32 = 1;
pub const CONFIG_CAN_VXCAN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AC97_BUS: u32 = 1;
pub const CONFIG_TRUSTED_KEYS: u32 = 1;
pub const CONFIG_TEE_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_CLASS_DEVICE: u32 = 1;
pub const CONFIG_CC_HAS_ASM_INLINE: u32 = 1;
pub const CONFIG_B43_HWRNG: u32 = 1;
pub const CONFIG_NVME_AUTH_MODULE: u32 = 1;
pub const CONFIG_VHOST_MODULE: u32 = 1;
pub const CONFIG_USB_M5602_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_USB_MODULE: u32 = 1;
pub const CONFIG_UIO_MF624_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_LINK: u32 = 1;
pub const CONFIG_WM8350_POWER_MODULE: u32 = 1;
pub const CONFIG_SPI_DLN2_MODULE: u32 = 1;
pub const CONFIG_INPUT_CMA3000_I2C_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_NULL: u32 = 1;
pub const CONFIG_INTEL_WMI_THUNDERBOLT_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AF9005_REMOTE_MODULE: u32 = 1;
pub const CONFIG_GPIO_CDEV_V1: u32 = 1;
pub const CONFIG_B43_PHY_G: u32 = 1;
pub const CONFIG_NET_VENDOR_SEEQ: u32 = 1;
pub const CONFIG_NF_DEFRAG_IPV4_MODULE: u32 = 1;
pub const CONFIG_USER_RETURN_NOTIFIER: u32 = 1;
pub const CONFIG_INTEL_IOMMU_FLOPPY_WA: u32 = 1;
pub const CONFIG_BT_QCA_MODULE: u32 = 1;
pub const CONFIG_USB_IDMOUSE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_AESNI_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6370_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WSA883X_MODULE: u32 = 1;
pub const CONFIG_SND_FIREWIRE_TASCAM_MODULE: u32 = 1;
pub const CONFIG_MISDN_INFINEON_MODULE: u32 = 1;
pub const CONFIG_HID_LCPOWER_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_HWSIM_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_CONSOLE: u32 = 1;
pub const CONFIG_MOUSE_ELAN_I2C_SMBUS: u32 = 1;
pub const CONFIG_ARCH_CLOCKSOURCE_INIT: u32 = 1;
pub const CONFIG_ATH11K_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_EINJ_MODULE: u32 = 1;
pub const CONFIG_PVH: u32 = 1;
pub const CONFIG_STM_PROTO_BASIC_MODULE: u32 = 1;
pub const CONFIG_PERSISTENT_KEYRINGS: u32 = 1;
pub const CONFIG_REGULATOR_RTQ6752_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_BFS_FS_MODULE: u32 = 1;
pub const CONFIG_FS_ENCRYPTION: u32 = 1;
pub const CONFIG_SND_ES1938_MODULE: u32 = 1;
pub const CONFIG_PM_DEBUG: u32 = 1;
pub const CONFIG_VIDEO_TW9906_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_VITESSE_VSC73XX_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_BT_AOSPEXT: u32 = 1;
pub const CONFIG_DVB_BUDGET_AV_MODULE: u32 = 1;
pub const CONFIG_IPV6_ROUTE_INFO: u32 = 1;
pub const CONFIG_MFD_WM8350_I2C: u32 = 1;
pub const CONFIG_RTW88_8821CS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_ADVANCED: u32 = 1;
pub const CONFIG_CRYPTO_DEFLATE: u32 = 1;
pub const CONFIG_GENERIC_STRNLEN_USER: u32 = 1;
pub const CONFIG_MFD_WM8350: u32 = 1;
pub const CONFIG_NFT_DUP_NETDEV_MODULE: u32 = 1;
pub const CONFIG_USB_APPLEDISPLAY_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_KLSI_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_TCPMSS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DA9063_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SMPRO_MODULE: u32 = 1;
pub const CONFIG_IGB_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_USBDUXSIGMA_MODULE: u32 = 1;
pub const CONFIG_QCOM_VADC_COMMON_MODULE: u32 = 1;
pub const CONFIG_AD7768_1_MODULE: u32 = 1;
pub const CONFIG_RPMSG_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_IPV6_ROUTER_PREF: u32 = 1;
pub const CONFIG_JFFS2_FS_DEBUG: u32 = 0;
pub const CONFIG_BT_HCIBTSDIO_MODULE: u32 = 1;
pub const CONFIG_DRM_QXL_MODULE: u32 = 1;
pub const CONFIG_CHARGER_RT5033_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_RSI: u32 = 1;
pub const CONFIG_KVM_MAX_NR_VCPUS: u32 = 4096;
pub const CONFIG_SLIP_COMPRESSED: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY: u32 = 1;
pub const CONFIG_JOYSTICK_PSXPAD_SPI_MODULE: u32 = 1;
pub const CONFIG_NTB_INTEL_MODULE: u32 = 1;
pub const CONFIG_SND_VX_LIB_MODULE: u32 = 1;
pub const CONFIG_ATM_MPOA_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MODULE: u32 = 1;
pub const CONFIG_ARCH_ENABLE_HUGEPAGE_MIGRATION: u32 = 1;
pub const CONFIG_CHARGER_WILCO_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_L2TP_MODULE: u32 = 1;
pub const CONFIG_DVB_MXL692_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_SERDEV: u32 = 1;
pub const CONFIG_LEDS_AAEON_MODULE: u32 = 1;
pub const CONFIG_INPUT_ARIZONA_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_DM_SWITCH_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_GCM: u32 = 1;
pub const CONFIG_SND_INDIGOIO_MODULE: u32 = 1;
pub const CONFIG_NE2K_PCI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2680_MODULE: u32 = 1;
pub const CONFIG_MOUSE_SYNAPTICS_USB_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_LOG_MODULE: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE: u32 = 1;
pub const CONFIG_PWM_LPSS_PCI: u32 = 1;
pub const CONFIG_MLX5_DPLL_MODULE: u32 = 1;
pub const CONFIG_CDROM: u32 = 1;
pub const CONFIG_PCIEAER_CXL: u32 = 1;
pub const CONFIG_PINCTRL_CHERRYVIEW: u32 = 1;
pub const CONFIG_NLS_ISO8859_14_MODULE: u32 = 1;
pub const CONFIG_DS1803_MODULE: u32 = 1;
pub const CONFIG_MTD_PHRAM_MODULE: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ: u32 = 1;
pub const CONFIG_MFD_88PM860X: u32 = 1;
pub const CONFIG_CROS_EC_CHARDEV_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_FS: u32 = 1;
pub const CONFIG_E100_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS6586X_MODULE: u32 = 1;
pub const CONFIG_ATH11K_TRACING: u32 = 1;
pub const CONFIG_THERMAL_EMULATION: u32 = 1;
pub const CONFIG_MDIO_THUNDER_MODULE: u32 = 1;
pub const CONFIG_DMI: u32 = 1;
pub const CONFIG_IPV6_SIT_6RD: u32 = 1;
pub const CONFIG_SND_SOC_NAU8540_MODULE: u32 = 1;
pub const CONFIG_WIL6210_TRACING: u32 = 1;
pub const CONFIG_DW_XDATA_PCIE_MODULE: u32 = 1;
pub const CONFIG_PARPORT_SERIAL_MODULE: u32 = 1;
pub const CONFIG_SND_DICE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_KPP: u32 = 1;
pub const CONFIG_PNFS_BLOCK_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_RDC: u32 = 1;
pub const CONFIG_MACHZ_WDT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR38064_REGULATOR: u32 = 1;
pub const CONFIG_PGTABLE_LEVELS: u32 = 5;
pub const CONFIG_CPUSETS: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_MARK_MODULE: u32 = 1;
pub const CONFIG_FB_MATROX_MODULE: u32 = 1;
pub const CONFIG_ISDN: u32 = 1;
pub const CONFIG_VIDEO_PVRUSB2_SYSFS: u32 = 1;
pub const CONFIG_ATLAS_PH_SENSOR_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_PROFILER: u32 = 1;
pub const CONFIG_SMBFS_MODULE: u32 = 1;
pub const CONFIG_MAC80211_RC_DEFAULT_MINSTREL: u32 = 1;
pub const CONFIG_SENSORS_MP2975_REGULATOR: u32 = 1;
pub const CONFIG_NVME_MULTIPATH: u32 = 1;
pub const CONFIG_FW_UPLOAD: u32 = 1;
pub const CONFIG_RMI4_F03_SERIO_MODULE: u32 = 1;
pub const CONFIG_SPARSE_IRQ: u32 = 1;
pub const CONFIG_MMA7455_I2C_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PC236_MODULE: u32 = 1;
pub const CONFIG_DVB_LGS8GXX_MODULE: u32 = 1;
pub const CONFIG_IR_SERIAL_TRANSMITTER: u32 = 1;
pub const CONFIG_XILLYUSB_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_MQPRIO_LIB_MODULE: u32 = 1;
pub const CONFIG_CAN_M_CAN_PCI_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TCPOPTSTRIP_MODULE: u32 = 1;
pub const CONFIG_INPUT_IDEAPAD_SLIDEBAR_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_MODULE: u32 = 1;
pub const CONFIG_SSFDC_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MANGLE_MODULE: u32 = 1;
pub const CONFIG_LEDS_USER_MODULE: u32 = 1;
pub const CONFIG_TIFM_7XX1_MODULE: u32 = 1;
pub const CONFIG_SCSI_UFS_DWC_TC_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_MASS_STORAGE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKYLAKE_HDAUDIO_CODEC: u32 = 1;
pub const CONFIG_BT_HCIBCM4377_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_LEDS: u32 = 1;
pub const CONFIG_COMEDI_CB_DAS16_CS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1286_MODULE: u32 = 1;
pub const CONFIG_FCOE_FNIC_MODULE: u32 = 1;
pub const CONFIG_INTEL_SMARTCONNECT_MODULE: u32 = 1;
pub const CONFIG_ATH10K_DEBUGFS: u32 = 1;
pub const CONFIG_BCM_KONA_USB2_PHY_MODULE: u32 = 1;
pub const CONFIG_MOXA_INTELLIO_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MCS5000_MODULE: u32 = 1;
pub const CONFIG_DVB_VES1X93_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_ILI9341_MODULE: u32 = 1;
pub const CONFIG_SECURITY_PERF_EVENTS_RESTRICT: u32 = 1;
pub const CONFIG_DRM_UDL_MODULE: u32 = 1;
pub const CONFIG_SECURITYFS: u32 = 1;
pub const CONFIG_LIBERTAS_MESH: u32 = 1;
pub const CONFIG_VIDEO_FB_IVTV_FORCE_PAT: u32 = 1;
pub const CONFIG_RCU_STALL_COMMON: u32 = 1;
pub const CONFIG_MCP9600_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_PCIDIO_MODULE: u32 = 1;
pub const CONFIG_BT_DEBUGFS: u32 = 1;
pub const CONFIG_CPU_SUP_AMD: u32 = 1;
pub const CONFIG_DRM_PANEL_AUO_A030JTN01_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_QUARK_I2C_GPIO_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_VLAN_MODULE: u32 = 1;
pub const CONFIG_PCIEPORTBUS: u32 = 1;
pub const CONFIG_MEDIA_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_NFT_FIB_IPV6_MODULE: u32 = 1;
pub const CONFIG_SENSORS_F75375S_MODULE: u32 = 1;
pub const CONFIG_DEBUG_BUGVERBOSE: u32 = 1;
pub const CONFIG_HAVE_IRQ_EXIT_ON_IRQ_STACK: u32 = 1;
pub const CONFIG_CRYPTO_XCTR_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ST_MIPID02_MODULE: u32 = 1;
pub const CONFIG_ACPI_CUSTOM_DSDT_FILE: &[u8; 1usize] = b"\0";
pub const CONFIG_IIO_KX022A_MODULE: u32 = 1;
pub const CONFIG_IP_NF_FILTER_MODULE: u32 = 1;
pub const CONFIG_BH1780_MODULE: u32 = 1;
pub const CONFIG_HID_ZEROPLUS_MODULE: u32 = 1;
pub const CONFIG_REED_SOLOMON_DEC16: u32 = 1;
pub const CONFIG_INTEL_UNCORE_FREQ_CONTROL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_MERRIFIELD_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_MEMORY_LAYOUT: u32 = 1;
pub const CONFIG_SENSORS_MC13783_ADC_MODULE: u32 = 1;
pub const CONFIG_DM_INTEGRITY_MODULE: u32 = 1;
pub const CONFIG_RV: u32 = 1;
pub const CONFIG_MFD_WCD934X_MODULE: u32 = 1;
pub const CONFIG_SATA_SX4_MODULE: u32 = 1;
pub const CONFIG_MAC802154_MODULE: u32 = 1;
pub const CONFIG_IBM_ASM_MODULE: u32 = 1;
pub const CONFIG_IP5XXX_POWER_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_LENGTH_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_PKTTYPE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_POLYVAL_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT6775_I2C_MODULE: u32 = 1;
pub const CONFIG_XFRM_ESPINTCP: u32 = 1;
pub const CONFIG_HID_SENSOR_GYRO_3D_MODULE: u32 = 1;
pub const CONFIG_HAVE_BUILDTIME_MCOUNT_SORT: u32 = 1;
pub const CONFIG_COMEDI_8255_SA_MODULE: u32 = 1;
pub const CONFIG_MPRLS0025PA_MODULE: u32 = 1;
pub const CONFIG_AFE4403_MODULE: u32 = 1;
pub const CONFIG_MODULES_TREE_LOOKUP: u32 = 1;
pub const CONFIG_FAT_FS: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CA0132_MODULE: u32 = 1;
pub const CONFIG_FCOE_MODULE: u32 = 1;
pub const CONFIG_CAN_SJA1000_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SIG: u32 = 1;
pub const CONFIG_SND_HDA_INTEL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_DH895xCCVF_MODULE: u32 = 1;
pub const CONFIG_BLK_DEBUG_FS_ZONED: u32 = 1;
pub const CONFIG_ACPI_ADXL: u32 = 1;
pub const CONFIG_TEXTSEARCH_FSM_MODULE: u32 = 1;
pub const CONFIG_USB_HSIC_USB4604_MODULE: u32 = 1;
pub const CONFIG_PECI_MODULE: u32 = 1;
pub const CONFIG_MISDN_DSP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM75_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_CXGB4_MODULE: u32 = 1;
pub const CONFIG_PANEL_PROFILE: u32 = 5;
pub const CONFIG_DVB_STV0910_MODULE: u32 = 1;
pub const CONFIG_LSI_ET1011C_PHY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5616_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_RAW_MODULE: u32 = 1;
pub const CONFIG_BUILDTIME_TABLE_SORT: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_SOFT_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX127_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_EC168_MODULE: u32 = 1;
pub const CONFIG_TDX_GUEST_DRIVER_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1742_MODULE: u32 = 1;
pub const CONFIG_BMI323_I2C_MODULE: u32 = 1;
pub const CONFIG_HSC030PA_SPI_MODULE: u32 = 1;
pub const CONFIG_NVMEM: u32 = 1;
pub const CONFIG_INET_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_X86_INTERNODE_CACHE_SHIFT: u32 = 6;
pub const CONFIG_BMA220_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_SSE2_X86_64_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_ARP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_PADLOCK: u32 = 1;
pub const CONFIG_SENSORS_PMBUS_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CC_PLATFORM: u32 = 1;
pub const CONFIG_MT76x0_COMMON_MODULE: u32 = 1;
pub const CONFIG_EEPROM_93CX6_MODULE: u32 = 1;
pub const CONFIG_GPIO_WM8350_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_CA8210_MODULE: u32 = 1;
pub const CONFIG_LTC2309_MODULE: u32 = 1;
pub const CONFIG_NET_9P_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_SKBMOD_MODULE: u32 = 1;
pub const CONFIG_PINCONF: u32 = 1;
pub const CONFIG_MFD_DA9052_SPI: u32 = 1;
pub const CONFIG_X86_CHECK_BIOS_CORRUPTION: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SMSC_LAN9303_I2C_MODULE: u32 = 1;
pub const CONFIG_BLOCK_HOLDER_DEPRECATED: u32 = 1;
pub const CONFIG_MLX4_CORE_MODULE: u32 = 1;
pub const CONFIG_UBSAN_BOOL: u32 = 1;
pub const CONFIG_AD4130_MODULE: u32 = 1;
pub const CONFIG_GPIO_MENZ127_MODULE: u32 = 1;
pub const CONFIG_DW_I3C_MASTER_MODULE: u32 = 1;
pub const CONFIG_RETHUNK: u32 = 1;
pub const CONFIG_INTEL_SAR_INT1092_MODULE: u32 = 1;
pub const CONFIG_MTD_REDBOOT_DIRECTORY_BLOCK: i32 = -1;
pub const CONFIG_SND_MIA_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_OCP_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS: u32 = 1;
pub const CONFIG_ROMFS_FS_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_USERFAULTFD_WP: u32 = 1;
pub const CONFIG_OID_REGISTRY: u32 = 1;
pub const CONFIG_MFD_88PM805_MODULE: u32 = 1;
pub const CONFIG_SGI_GRU_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_GENERIC_ALLOCATION_MODULE: u32 = 1;
pub const CONFIG_PHY_PXA_28NM_HSIC_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DTT200U_MODULE: u32 = 1;
pub const CONFIG_CIFS_UPCALL: u32 = 1;
pub const CONFIG_GREYBUS_VIBRATOR_MODULE: u32 = 1;
pub const CONFIG_THUNDER_NIC_PF_MODULE: u32 = 1;
pub const CONFIG_RADIO_TEA575X_MODULE: u32 = 1;
pub const CONFIG_LIB80211_MODULE: u32 = 1;
pub const CONFIG_MT7921E_MODULE: u32 = 1;
pub const CONFIG_RUSTC_VERSION_TEXT: &[u8; 66usize] =
    b"rustc 1.75.0 (82e1608df 2023-12-21) (built from a source tarball)\0";
pub const CONFIG_INTEGRITY_PLATFORM_KEYRING: u32 = 1;
pub const CONFIG_MEDIA_CEC_SUPPORT: u32 = 1;
pub const CONFIG_MFD_CORE: u32 = 1;
pub const CONFIG_AS_SHA256_NI: u32 = 1;
pub const CONFIG_HAVE_KERNEL_XZ: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PC236_ISA_MODULE: u32 = 1;
pub const CONFIG_USB_CXACRU_MODULE: u32 = 1;
pub const CONFIG_WINMATE_FM07_KEYS_MODULE: u32 = 1;
pub const CONFIG_X86_PKG_TEMP_THERMAL_MODULE: u32 = 1;
pub const CONFIG_RAID_ATTRS_MODULE: u32 = 1;
pub const CONFIG_CAN_NETLINK: u32 = 1;
pub const CONFIG_RFKILL_LEDS: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_BCM: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_RX_MACRO_MODULE: u32 = 1;
pub const CONFIG_CONSOLE_TRANSLATIONS: u32 = 1;
pub const CONFIG_PATA_CMD64X_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_TM2_TOUCHKEY_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_STAA_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_ATOMIC_RMW: u32 = 1;
pub const CONFIG_TCG_CRB: u32 = 1;
pub const CONFIG_MT7925U_MODULE: u32 = 1;
pub const CONFIG_BMA400_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_VL: u32 = 1;
pub const CONFIG_REGULATOR_AD5398_MODULE: u32 = 1;
pub const CONFIG_CHARGER_SURFACE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR36021_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_LSM9DS0_MODULE: u32 = 1;
pub const CONFIG_USB_F_UVC_MODULE: u32 = 1;
pub const CONFIG_RAID6_PQ_MODULE: u32 = 1;
pub const CONFIG_SBC_FITPC2_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_TIMERIOMEM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_VANGOGH_MACH_MODULE: u32 = 1;
pub const CONFIG_ST_UVIS25_SPI_MODULE: u32 = 1;
pub const CONFIG_FXLS8962AF_SPI_MODULE: u32 = 1;
pub const CONFIG_NET_IPGRE_MODULE: u32 = 1;
pub const CONFIG_ADT7316_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_SDIO_MODULE: u32 = 1;
pub const CONFIG_MDIO_MSCC_MIIM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_MODULE: u32 = 1;
pub const CONFIG_FUSION: u32 = 1;
pub const CONFIG_MTDRAM_TOTAL_SIZE: u32 = 4096;
pub const CONFIG_TINYDRM_ST7735R_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TEA6420_MODULE: u32 = 1;
pub const CONFIG_IPV6_SEG6_BPF: u32 = 1;
pub const CONFIG_SWIOTLB_XEN: u32 = 1;
pub const CONFIG_DM_INIT: u32 = 1;
pub const CONFIG_BRIDGE_EBT_IP6_MODULE: u32 = 1;
pub const CONFIG_IQS620AT_TEMP_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_SNMP_BASIC_MODULE: u32 = 1;
pub const CONFIG_SND_X86: u32 = 1;
pub const CONFIG_PCMCIA_LOAD_CIS: u32 = 1;
pub const CONFIG_NFT_FIB_NETDEV_MODULE: u32 = 1;
pub const CONFIG_XEN_SYMS: u32 = 1;
pub const CONFIG_SERIAL_EARLYCON: u32 = 1;
pub const CONFIG_VIDEO_OV9640_MODULE: u32 = 1;
pub const CONFIG_CLS_U32_MARK: u32 = 1;
pub const CONFIG_DVB_CX24120_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_NI: u32 = 1;
pub const CONFIG_SND_SOC_ARIZONA_MODULE: u32 = 1;
pub const CONFIG_SND_ICE1712_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_MAX8925_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AKCIPHER: u32 = 1;
pub const CONFIG_LIBERTAS_SPI_MODULE: u32 = 1;
pub const CONFIG_SCSI_ACARD_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_ZIP: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L41_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SIGMADSP_I2C_MODULE: u32 = 1;
pub const CONFIG_ETHTOOL_NETLINK: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_ACPI_CPU_FREQ_PSS: u32 = 1;
pub const CONFIG_HDC3020_MODULE: u32 = 1;
pub const CONFIG_CAN_ETAS_ES58X_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ: u32 = 1;
pub const CONFIG_USB_OHCI_HCD: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_FILE: u32 = 1;
pub const CONFIG_VIA_RHINE_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_MODULE: u32 = 1;
pub const CONFIG_VHOST_RING_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS_DEFAULT: u32 = 8192;
pub const CONFIG_DVB_DUMMY_FE_MODULE: u32 = 1;
pub const CONFIG_DM_MIRROR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_BLOWFISH_MODULE: u32 = 1;
pub const CONFIG_FB_SIS_MODULE: u32 = 1;
pub const CONFIG_ATH11K_PCI_MODULE: u32 = 1;
pub const CONFIG_ARCH_CPUIDLE_HALTPOLL: u32 = 1;
pub const CONFIG_DUMMY_CONSOLE: u32 = 1;
pub const CONFIG_MLXSW_CORE_HWMON: u32 = 1;
pub const CONFIG_MMU_GATHER_MERGE_VMAS: u32 = 1;
pub const CONFIG_AIC7XXX_DEBUG_MASK: u32 = 0;
pub const CONFIG_SENSORS_LTC3815_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_USB_F_TCM_MODULE: u32 = 1;
pub const CONFIG_USB_PCI: u32 = 1;
pub const CONFIG_COMEDI_DAS08_PCI_MODULE: u32 = 1;
pub const CONFIG_NLS_ASCII_MODULE: u32 = 1;
pub const CONFIG_RFKILL_GPIO_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_DA9055_MODULE: u32 = 1;
pub const CONFIG_USB_G_PRINTER_MODULE: u32 = 1;
pub const CONFIG_B43_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_ALTERA_CVP_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GRIP_MODULE: u32 = 1;
pub const CONFIG_BAYCOM_SER_FDX_MODULE: u32 = 1;
pub const CONFIG_MEDIA_ALTERA_CI_MODULE: u32 = 1;
pub const CONFIG_TIPC_DIAG_MODULE: u32 = 1;
pub const CONFIG_NF_REJECT_IPV4_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T94_MODULE: u32 = 1;
pub const CONFIG_AD_SIGMA_DELTA_MODULE: u32 = 1;
pub const CONFIG_HAVE_CALL_THUNKS: u32 = 1;
pub const CONFIG_RANDOMIZE_MEMORY: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_BITS_MAX: u32 = 32;
pub const CONFIG_SND_SOC_FSL_SSI_MODULE: u32 = 1;
pub const CONFIG_USB_LAN78XX_MODULE: u32 = 1;
pub const CONFIG_NFT_CONNLIMIT_MODULE: u32 = 1;
pub const CONFIG_BPF_EVENTS: u32 = 1;
pub const CONFIG_SND_SOC_ZL38060_MODULE: u32 = 1;
pub const CONFIG_BOOT_CONFIG: u32 = 1;
pub const CONFIG_GREYBUS_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_HEXIUM_ORION_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_NHPOLY1305_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_SENSORS_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_TRANSPARENT_HUGEPAGE: u32 = 1;
pub const CONFIG_MODULE_DECOMPRESS: u32 = 1;
pub const CONFIG_BACKLIGHT_GPIO_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_ME_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_QIB_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_MTK: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_MOBILITY_MODULE: u32 = 1;
pub const CONFIG_LAPBETHER_MODULE: u32 = 1;
pub const CONFIG_USB_SI4713_MODULE: u32 = 1;
pub const CONFIG_SATA_SVW_MODULE: u32 = 1;
pub const CONFIG_MAX11100_MODULE: u32 = 1;
pub const CONFIG_VIDEO_RJ54N1_MODULE: u32 = 1;
pub const CONFIG_AD5360_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_MRF24J40_MODULE: u32 = 1;
pub const CONFIG_TRACE_IRQFLAGS_SUPPORT: u32 = 1;
pub const CONFIG_MTD_NAND_CORE_MODULE: u32 = 1;
pub const CONFIG_MFD_SYSCON: u32 = 1;
pub const CONFIG_SND_SOC_TAS5720_MODULE: u32 = 1;
pub const CONFIG_MTD_PHYSMAP_MODULE: u32 = 1;
pub const CONFIG_MS5611_SPI_MODULE: u32 = 1;
pub const CONFIG_NFS_V3_ACL: u32 = 1;
pub const CONFIG_HDLC_X25_MODULE: u32 = 1;
pub const CONFIG_IPV6_SEG6_LWTUNNEL: u32 = 1;
pub const CONFIG_KVM_SW_PROTECTED_VM: u32 = 1;
pub const CONFIG_CHARGER_GPIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_TGL_MODULE: u32 = 1;
pub const CONFIG_INPUT_GPIO_DECODER_MODULE: u32 = 1;
pub const CONFIG_INFTL_MODULE: u32 = 1;
pub const CONFIG_KVM_HYPERV: u32 = 1;
pub const CONFIG_NFT_NUMGEN_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7462_MODULE: u32 = 1;
pub const CONFIG_DETECT_HUNG_TASK: u32 = 1;
pub const CONFIG_MAX11410_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX14577_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT7802_MODULE: u32 = 1;
pub const CONFIG_CAN_MCP251X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CCM_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_ADVANCED: u32 = 1;
pub const CONFIG_MTRR_SANITIZER_ENABLE_DEFAULT: u32 = 1;
pub const CONFIG_USB_NET_CDC_SUBSET_MODULE: u32 = 1;
pub const CONFIG_BT_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_BT_RTL_MODULE: u32 = 1;
pub const CONFIG_MMA9551_CORE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIMC_MODULE: u32 = 1;
pub const CONFIG_KVM_GUEST: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_APOLLOLAKE_MODULE: u32 = 1;
pub const CONFIG_QFMT_V2_MODULE: u32 = 1;
pub const CONFIG_USB_S2255_MODULE: u32 = 1;
pub const CONFIG_INET_DCCP_DIAG_MODULE: u32 = 1;
pub const CONFIG_TAP_MODULE: u32 = 1;
pub const CONFIG_MLX5_CLS_ACT: u32 = 1;
pub const CONFIG_ARCNET_COM90xxIO_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_ATH9K_HW_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP: u32 = 1;
pub const CONFIG_USB_SERIAL_MCT_U232_MODULE: u32 = 1;
pub const CONFIG_PCIE_BUS_DEFAULT: u32 = 1;
pub const CONFIG_UIO_PDRV_GENIRQ_MODULE: u32 = 1;
pub const CONFIG_BATTERY_SURFACE_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBT3C_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGERS: u32 = 1;
pub const CONFIG_NET_FOU_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RNG: u32 = 1;
pub const CONFIG_USB_SERIAL_GARMIN_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_GPIO_MODULE: u32 = 1;
pub const CONFIG_MTD_ESB2ROM_MODULE: u32 = 1;
pub const CONFIG_XFS_QUOTA: u32 = 1;
pub const CONFIG_COMEDI_ISA_DRIVERS: u32 = 1;
pub const CONFIG_JOYSTICK_QWIIC_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_COBRA_MODULE: u32 = 1;
pub const CONFIG_ATH10K_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SMACK: u32 = 1;
pub const CONFIG_F2FS_UNFAIR_RWSEM: u32 = 1;
pub const CONFIG_DRM_AMDGPU_CIK: u32 = 1;
pub const CONFIG_WINBOND_840_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L42_SDW_MODULE: u32 = 1;
pub const CONFIG_GPIO_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_ACPI_VIOT: u32 = 1;
pub const CONFIG_REGULATOR_MAX77857_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP_SPI_MODULE: u32 = 1;
pub const CONFIG_TI_TLC4541_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_INLINE_CRYPTO: u32 = 1;
pub const CONFIG_SCSI_3W_9XXX_MODULE: u32 = 1;
pub const CONFIG_DRM_TTM_HELPER_MODULE: u32 = 1;
pub const CONFIG_HSA_AMD_SVM: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_COMPAT_BITS_MIN: u32 = 8;
pub const CONFIG_VIDEO_KS0127_MODULE: u32 = 1;
pub const CONFIG_MVMDIO_MODULE: u32 = 1;
pub const CONFIG_NVME_TCP_TLS: u32 = 1;
pub const CONFIG_HWLAT_TRACER: u32 = 1;
pub const CONFIG_CRYPTO_LIB_UTILS: u32 = 1;
pub const CONFIG_HID_BPF: u32 = 1;
pub const CONFIG_SENSORS_IRPS5401_MODULE: u32 = 1;
pub const CONFIG_SND_USB: u32 = 1;
pub const CONFIG_LOGIG940_FF: u32 = 1;
pub const CONFIG_PCIE_EDR: u32 = 1;
pub const CONFIG_VIDEOBUF2_MEMOPS_MODULE: u32 = 1;
pub const CONFIG_CEC_SECO_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS3232_HWMON: u32 = 1;
pub const CONFIG_RD_GZIP: u32 = 1;
pub const CONFIG_CRYPTO_DEV_SAFEXCEL_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_E2I: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_RELAX: u32 = 1;
pub const CONFIG_HAVE_REGS_AND_STACK_ACCESS_API: u32 = 1;
pub const CONFIG_BLK_PM: u32 = 1;
pub const CONFIG_BCMA_HOST_PCI_POSSIBLE: u32 = 1;
pub const CONFIG_SND_SOC_TFA9879_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_IOPRIO: u32 = 1;
pub const CONFIG_CRYPTO_ARCH_HAVE_LIB_POLY1305_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4261_MODULE: u32 = 1;
pub const CONFIG_MMC_SDRICOH_CS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADV_PCI1720_MODULE: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_PARANOID_LOAD: u32 = 1;
pub const CONFIG_MISDN_W6692_MODULE: u32 = 1;
pub const CONFIG_QCOM_PMIC_PDCHARGER_ULOG_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_KEYSPAN_MODULE: u32 = 1;
pub const CONFIG_THRUSTMASTER_FF: u32 = 1;
pub const CONFIG_MDIO_BUS: u32 = 1;
pub const CONFIG_TREE_RCU: u32 = 1;
pub const CONFIG_PWM_SYSFS: u32 = 1;
pub const CONFIG_TINYDRM_ILI9163_MODULE: u32 = 1;
pub const CONFIG_SOC_TI: u32 = 1;
pub const CONFIG_GNSS_MODULE: u32 = 1;
pub const CONFIG_ALLOW_DEV_COREDUMP: u32 = 1;
pub const CONFIG_ADXL313_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MT6360_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_GPIO_MODULE: u32 = 1;
pub const CONFIG_SWIOTLB: u32 = 1;
pub const CONFIG_PLX_DMA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8822_MODULE: u32 = 1;
pub const CONFIG_SND_USB_CAIAQ_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_CYPRESS_ATACB_MODULE: u32 = 1;
pub const CONFIG_EXT4_FS_SECURITY: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_DUMMY_MODULE: u32 = 1;
pub const CONFIG_ATH9K_HWRNG: u32 = 1;
pub const CONFIG_LTC2983_MODULE: u32 = 1;
pub const CONFIG_GRO_CELLS: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_HASH_DEFAULT: u32 = 1;
pub const CONFIG_SCSI_MVUMI_MODULE: u32 = 1;
pub const CONFIG_DVB_S5H1432_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_ACTIVEBACKUP_MODULE: u32 = 1;
pub const CONFIG_9P_FS_SECURITY: u32 = 1;
pub const CONFIG_PCI_P2PDMA: u32 = 1;
pub const CONFIG_IR_XMP_DECODER_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_SYSFS: u32 = 1;
pub const CONFIG_HAVE_VIRT_CPU_ACCOUNTING_GEN: u32 = 1;
pub const CONFIG_LV0104CS_MODULE: u32 = 1;
pub const CONFIG_BEFS_FS_MODULE: u32 = 1;
pub const CONFIG_SND_ALI5451_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_USER_MAD_MODULE: u32 = 1;
pub const CONFIG_ALIBABA_ENI_VDPA_MODULE: u32 = 1;
pub const CONFIG_GENERIC_ADC_THERMAL_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852BE_MODULE: u32 = 1;
pub const CONFIG_HID_ROCCAT_MODULE: u32 = 1;
pub const CONFIG_F71808E_WDT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_NETLINK_EVENTS: u32 = 1;
pub const CONFIG_HID_SENSOR_TEMP_MODULE: u32 = 1;
pub const CONFIG_MTD_HYPERBUS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MD5: u32 = 1;
pub const CONFIG_IMA_DEFAULT_TEMPLATE: &[u8; 7usize] = b"ima-ng\0";
pub const CONFIG_VIDEO_CS53L32A_MODULE: u32 = 1;
pub const CONFIG_IR_REDRAT3_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_VICAM_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7879_SPI_MODULE: u32 = 1;
pub const CONFIG_TRANSPARENT_HUGEPAGE: u32 = 1;
pub const CONFIG_CLOCKSOURCE_VALIDATE_LAST_CYCLE: u32 = 1;
pub const CONFIG_VSOCKETS_LOOPBACK_MODULE: u32 = 1;
pub const CONFIG_USB_F_SS_LB_MODULE: u32 = 1;
pub const CONFIG_ISCSI_TCP_MODULE: u32 = 1;
pub const CONFIG_ATA_ACPI: u32 = 1;
pub const CONFIG_USB_PCI_AMD: u32 = 1;
pub const CONFIG_NET_SCH_SKBPRIO_MODULE: u32 = 1;
pub const CONFIG_PATA_ALI_MODULE: u32 = 1;
pub const CONFIG_X86_EXTENDED_PLATFORM: u32 = 1;
pub const CONFIG_SENSORS_MPQ7932_REGULATOR: u32 = 1;
pub const CONFIG_GPIO_JANZ_TTL_MODULE: u32 = 1;
pub const CONFIG_MAX30208_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_ATMEL_I2C_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822CS_MODULE: u32 = 1;
pub const CONFIG_XEN_FRONT_PGDIR_SHBUF_MODULE: u32 = 1;
pub const CONFIG_P2SB: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_MAXIM_COMMON_MODULE: u32 = 1;
pub const CONFIG_MFD_WL1273_CORE_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT53XX: u32 = 1;
pub const CONFIG_NET_VENDOR_CORTINA: u32 = 1;
pub const CONFIG_ADUX1020_MODULE: u32 = 1;
pub const CONFIG_NOA1305_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_SPI_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_ENABLE_SCHEDTIMEOUT_LIMIT: u32 = 1;
pub const CONFIG_VIDEO_MGB4_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT715_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_SND_ECHO3G_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC0011_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR: u32 = 1;
pub const CONFIG_DVB_TDA10023_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV9734_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TEA5767_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_MODULE: u32 = 1;
pub const CONFIG_ELFCORE: u32 = 1;
pub const CONFIG_REGULATOR_BD9571MWV_MODULE: u32 = 1;
pub const CONFIG_HIBERNATION_SNAPSHOT_DEV: u32 = 1;
pub const CONFIG_HAVE_KVM: u32 = 1;
pub const CONFIG_SND_FIREWIRE: u32 = 1;
pub const CONFIG_PAGE_POISONING: u32 = 1;
pub const CONFIG_VF610_DAC_MODULE: u32 = 1;
pub const CONFIG_EDAC_SKX_MODULE: u32 = 1;
pub const CONFIG_FRAMEBUFFER_CONSOLE_DEFERRED_TAKEOVER: u32 = 1;
pub const CONFIG_COMEDI_PCMDA12_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP3x_MODULE: u32 = 1;
pub const CONFIG_PCCARD_MODULE: u32 = 1;
pub const CONFIG_SYSFB: u32 = 1;
pub const CONFIG_HID_VIVALDI_COMMON_MODULE: u32 = 1;
pub const CONFIG_CPU_SRSO: u32 = 1;
pub const CONFIG_USB_GSPCA_OV519_MODULE: u32 = 1;
pub const CONFIG_DM_LOG_WRITES_MODULE: u32 = 1;
pub const CONFIG_BINFMT_ELF: u32 = 1;
pub const CONFIG_RTC_DRV_RX4581_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4349_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_FLOWER_MODULE: u32 = 1;
pub const CONFIG_SCSI_PROC_FS: u32 = 1;
pub const CONFIG_RMI4_F11: u32 = 1;
pub const CONFIG_I2C_HID_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L43_MODULE: u32 = 1;
pub const CONFIG_MD_RAID456_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PCF50633_MODULE: u32 = 1;
pub const CONFIG_IIO_TRIGGER: u32 = 1;
pub const CONFIG_SENSORS_BEL_PFE_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_IFORCE_USB_MODULE: u32 = 1;
pub const CONFIG_SCHED_TRACER: u32 = 1;
pub const CONFIG_RTS5208_MODULE: u32 = 1;
pub const CONFIG_CICADA_PHY_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_STINGER_MODULE: u32 = 1;
pub const CONFIG_HAVE_PERF_REGS: u32 = 1;
pub const CONFIG_V4L2_ASYNC_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_DENVERTON_MODULE: u32 = 1;
pub const CONFIG_CIFS_DEBUG: u32 = 1;
pub const CONFIG_DRM_I915_USERFAULT_AUTOSUSPEND: u32 = 250;
pub const CONFIG_MEDIA_ANALOG_TV_SUPPORT: u32 = 1;
pub const CONFIG_IP_PIMSM_V1: u32 = 1;
pub const CONFIG_HAVE_KVM_MSI: u32 = 1;
pub const CONFIG_WATCH_QUEUE: u32 = 1;
pub const CONFIG_BMA400_MODULE: u32 = 1;
pub const CONFIG_BCACHE_MODULE: u32 = 1;
pub const CONFIG_INET6_AH_MODULE: u32 = 1;
pub const CONFIG_KVM_GENERIC_DIRTYLOG_READ_PROTECT: u32 = 1;
pub const CONFIG_SENSORS_MAX197_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_CHMAN_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT4831_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_REGISTRY_MODULE: u32 = 1;
pub const CONFIG_TARGET_CORE_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MSCC_FELIX_DSA_LIB_MODULE: u32 = 1;
pub const CONFIG_HID_XINMO_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_BNXT_RE_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_SECURITY_LABEL: u32 = 1;
pub const CONFIG_USB_SERIAL_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_ALSA_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ALTEON: u32 = 1;
pub const CONFIG_NFT_DUP_IPV4_MODULE: u32 = 1;
pub const CONFIG_SENSORS_GL518SM_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_IPOIB: u32 = 1;
pub const CONFIG_IIO_ST_LSM9DS0_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_MON_MODULE: u32 = 1;
pub const CONFIG_COMEDI_CB_PCIMDAS_MODULE: u32 = 1;
pub const CONFIG_NTB_IDT_MODULE: u32 = 1;
pub const CONFIG_VGASTATE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_FIXED_VOLTAGE_MODULE: u32 = 1;
pub const CONFIG_INET_MPTCP_DIAG_MODULE: u32 = 1;
pub const CONFIG_LCD_L4F00242T03_MODULE: u32 = 1;
pub const CONFIG_XEN_PVCALLS_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_RENESAS: u32 = 1;
pub const CONFIG_VIDEO_SAA717X_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_MODULE: u32 = 1;
pub const CONFIG_INTEL_LDMA: u32 = 1;
pub const CONFIG_VIDEO_ET8EK8_MODULE: u32 = 1;
pub const CONFIG_KEYS: u32 = 1;
pub const CONFIG_XEN_PV_SMP: u32 = 1;
pub const CONFIG_FXOS8700_I2C_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS6507X_MODULE: u32 = 1;
pub const CONFIG_BE2ISCSI_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_ETF_MODULE: u32 = 1;
pub const CONFIG_INET_XFRM_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_FM3130_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX9860_MODULE: u32 = 1;
pub const CONFIG_RMI4_2D_SENSOR: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR_CSTATE: u32 = 1;
pub const CONFIG_TMP007_MODULE: u32 = 1;
pub const CONFIG_XEN_EFI: u32 = 1;
pub const CONFIG_IPMI_POWEROFF_MODULE: u32 = 1;
pub const CONFIG_FUN_CORE_MODULE: u32 = 1;
pub const CONFIG_SND_VMASTER: u32 = 1;
pub const CONFIG_NETFILTER_XT_MARK_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XTABLES_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_ORIENTATION_QUIRKS: u32 = 1;
pub const CONFIG_IP_VS_LBLC_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_BLACKLIST_KEYRING: u32 = 1;
pub const CONFIG_HAVE_KVM_IRQ_BYPASS: u32 = 1;
pub const CONFIG_BLK_DEV_NULL_BLK_MODULE: u32 = 1;
pub const CONFIG_DP83640_PHY_MODULE: u32 = 1;
pub const CONFIG_SOFTLOCKUP_DETECTOR: u32 = 1;
pub const CONFIG_NFC_PN533_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_ISP1760_HCD: u32 = 1;
pub const CONFIG_MFD_AXP20X_I2C_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_OPERA1_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_COMMON_MODULE: u32 = 1;
pub const CONFIG_SENSORS_INSPUR_IPSPS_MODULE: u32 = 1;
pub const CONFIG_ROHM_BM1390_MODULE: u32 = 1;
pub const CONFIG_LEDS_PWM_MULTICOLOR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECHAINIV_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_AUDITSYSCALL: u32 = 1;
pub const CONFIG_LEDS_BD2802_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MC13783_MODULE: u32 = 1;
pub const CONFIG_CXL_REGION: u32 = 1;
pub const CONFIG_VIDEO_CADENCE_CSI2TX_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_STOWAWAY_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_FB_RIVA_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_GOLDFISH_MODULE: u32 = 1;
pub const CONFIG_ATM_HE_MODULE: u32 = 1;
pub const CONFIG_BATTERY_UG3105_MODULE: u32 = 1;
pub const CONFIG_SPI_AX88796C_MODULE: u32 = 1;
pub const CONFIG_GNSS_SIRF_SERIAL_MODULE: u32 = 1;
pub const CONFIG_PCI_EPF_MHI_MODULE: u32 = 1;
pub const CONFIG_IPMI_SI_MODULE: u32 = 1;
pub const CONFIG_TI_ADS1015_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PMEM_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_DATAFAB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT274_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AF9005_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_MT6370_MODULE: u32 = 1;
pub const CONFIG_MFD_RC5T583: u32 = 1;
pub const CONFIG_TCP_CONG_VEGAS_MODULE: u32 = 1;
pub const CONFIG_LEDS_88PM860X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_HASH_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PLI1209BC_REGULATOR: u32 = 1;
pub const CONFIG_SENSORS_IBMPEX_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_TAPRIO_MODULE: u32 = 1;
pub const CONFIG_BOOT_PRINTK_DELAY: u32 = 1;
pub const CONFIG_CHARGER_88PM860X_MODULE: u32 = 1;
pub const CONFIG_IWLMVM_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_COLIBRI_VF50_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM1026_MODULE: u32 = 1;
pub const CONFIG_PATA_NINJA32_MODULE: u32 = 1;
pub const CONFIG_BARCO_P50_GPIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RENOIR_MACH_MODULE: u32 = 1;
pub const CONFIG_IIO_MUX_MODULE: u32 = 1;
pub const CONFIG_NVIDIA_SHIELD_FF: u32 = 1;
pub const CONFIG_SENSORS_ADT7470_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CCP_DD_MODULE: u32 = 1;
pub const CONFIG_PM_SLEEP_SMP: u32 = 1;
pub const CONFIG_SPI_PXA2XX_PCI_MODULE: u32 = 1;
pub const CONFIG_FB_PM3_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV7740_MODULE: u32 = 1;
pub const CONFIG_MT7663S_MODULE: u32 = 1;
pub const CONFIG_X86_16BIT: u32 = 1;
pub const CONFIG_CRYPTO_HW: u32 = 1;
pub const CONFIG_SND_SOC_RT715_SDW_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_GATE_MODULE: u32 = 1;
pub const CONFIG_USB_EG20T_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_KARMA_MODULE: u32 = 1;
pub const CONFIG_TTPCI_EEPROM_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP4_SPI_MODULE: u32 = 1;
pub const CONFIG_NTB_PERF_MODULE: u32 = 1;
pub const CONFIG_SURFACE_KBD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_LNL_MODULE: u32 = 1;
pub const CONFIG_TEHUTI_MODULE: u32 = 1;
pub const CONFIG_PUNIT_ATOM_DEBUG_MODULE: u32 = 1;
pub const CONFIG_SIS900_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_MAGN_SPI_3AXIS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_VA_MACRO_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_PI3USB30532_MODULE: u32 = 1;
pub const CONFIG_PCSPKR_PLATFORM: u32 = 1;
pub const CONFIG_INFINIBAND_EFA_MODULE: u32 = 1;
pub const CONFIG_LEDS_LP3952_MODULE: u32 = 1;
pub const CONFIG_KFENCE_STRESS_TEST_FAULTS: u32 = 0;
pub const CONFIG_NET_DSA_AR9331_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS68470_MODULE: u32 = 1;
pub const CONFIG_HAVE_LIVEPATCH: u32 = 1;
pub const CONFIG_MEGARAID_LEGACY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_POLY1305_X86_64_MODULE: u32 = 1;
pub const CONFIG_DVB_AV7110_IR: u32 = 1;
pub const CONFIG_CARDBUS: u32 = 1;
pub const CONFIG_SPI_ALTERA_CORE_MODULE: u32 = 1;
pub const CONFIG_ATH9K_AHB: u32 = 1;
pub const CONFIG_SENSORS_BPA_RS600_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ISL29018_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ8863_SMI_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1307_CENTURY: u32 = 1;
pub const CONFIG_IIO_SSP_SENSORHUB_MODULE: u32 = 1;
pub const CONFIG_HID_GREENASIA_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX77976_MODULE: u32 = 1;
pub const CONFIG_PROC_VMCORE_DEVICE_DUMP: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ILI210X_MODULE: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_WITH_ARGS: u32 = 1;
pub const CONFIG_XEN_ACPI_PROCESSOR: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKL_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_ASYMMETRIC_KEYS: u32 = 1;
pub const CONFIG_HWSPINLOCK: u32 = 1;
pub const CONFIG_SERIAL_RP2_NR_UARTS: u32 = 32;
pub const CONFIG_CACHEFILES_ERROR_INJECTION: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ_DEFAULT_ENABLE: u32 = 438;
pub const CONFIG_BACKLIGHT_DA903X_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_HALTPOLL: u32 = 1;
pub const CONFIG_KALLSYMS_ABSOLUTE_PERCPU: u32 = 1;
pub const CONFIG_INTEL_POWERCLAMP_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DEFAULT_BUF_SIZE_KB: u32 = 2048;
pub const CONFIG_CPU_IBRS_ENTRY: u32 = 1;
pub const CONFIG_NFC_ST21NFCA_I2C_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ADP5520_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_ESAI_MODULE: u32 = 1;
pub const CONFIG_IIO_INV_SENSORS_TIMESTAMP_MODULE: u32 = 1;
pub const CONFIG_REMOTE_TARGET_MODULE: u32 = 1;
pub const CONFIG_SMS_USB_DRV_MODULE: u32 = 1;
pub const CONFIG_I2C_CP2615_MODULE: u32 = 1;
pub const CONFIG_ACPI_AC: u32 = 1;
pub const CONFIG_HARDIRQS_SW_RESEND: u32 = 1;
pub const CONFIG_TLS_MODULE: u32 = 1;
pub const CONFIG_ACPI_HOTPLUG_IOAPIC: u32 = 1;
pub const CONFIG_HID_STEELSERIES_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_WRITEBUFFER: u32 = 1;
pub const CONFIG_BMI160_SPI_MODULE: u32 = 1;
pub const CONFIG_ADXL372_I2C_MODULE: u32 = 1;
pub const CONFIG_SPI_MASTER: u32 = 1;
pub const CONFIG_FB_TFT_RA8875_MODULE: u32 = 1;
pub const CONFIG_ATH12K_MODULE: u32 = 1;
pub const CONFIG_RUST_PHYLIB_ABSTRACTIONS: u32 = 1;
pub const CONFIG_USB_SERIAL_OPTICON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CHV3_CODEC_MODULE: u32 = 1;
pub const CONFIG_RTL8180_MODULE: u32 = 1;
pub const CONFIG_DS4424_MODULE: u32 = 1;
pub const CONFIG_LWTUNNEL: u32 = 1;
pub const CONFIG_MLX5_VDPA_NET_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_AT86RF230_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ARIZONA_MICSUPP_MODULE: u32 = 1;
pub const CONFIG_AD5504_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SLIMBUS_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_I2C: u32 = 1;
pub const CONFIG_DVB_TC90522_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_SGI_MODULE: u32 = 1;
pub const CONFIG_HID_CREATIVE_SB0540_MODULE: u32 = 1;
pub const CONFIG_DVB_NXT200X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM87_MODULE: u32 = 1;
pub const CONFIG_PALMAS_GPADC_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_THROTTLING: u32 = 1;
pub const CONFIG_MHI_NET_MODULE: u32 = 1;
pub const CONFIG_VT_HW_CONSOLE_BINDING: u32 = 1;
pub const CONFIG_AIX_PARTITION: u32 = 1;
pub const CONFIG_GPIO_104_IDIO_16_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_BROADCAST_MODULE: u32 = 1;
pub const CONFIG_MPLS: u32 = 1;
pub const CONFIG_NF_TABLES_NETDEV: u32 = 1;
pub const CONFIG_CHARGER_SMB347_MODULE: u32 = 1;
pub const CONFIG_NFC_S3FWRN5_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW9903_MODULE: u32 = 1;
pub const CONFIG_WFX_MODULE: u32 = 1;
pub const CONFIG_ATH9K_CHANNEL_CONTEXT: u32 = 1;
pub const CONFIG_NET_ACT_GACT_MODULE: u32 = 1;
pub const CONFIG_SLIP_MODE_SLIP6: u32 = 1;
pub const CONFIG_RTL8192E_MODULE: u32 = 1;
pub const CONFIG_HID_GYRATION_MODULE: u32 = 1;
pub const CONFIG_PA12203001_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ADP1653_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4642_MODULE: u32 = 1;
pub const CONFIG_GPIO_WHISKEY_COVE_MODULE: u32 = 1;
pub const CONFIG_SMPRO_MISC_MODULE: u32 = 1;
pub const CONFIG_SRAM: u32 = 1;
pub const CONFIG_USB_WDM_MODULE: u32 = 1;
pub const CONFIG_PATA_TOSHIBA_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBCM203X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_WM8400_MODULE: u32 = 1;
pub const CONFIG_THERMAL_HWMON: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_COMPOSITE_MODULE: u32 = 1;
pub const CONFIG_DM_CLONE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM186X_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_S5C73M3_MODULE: u32 = 1;
pub const CONFIG_RAVE_SP_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_PCA9541_MODULE: u32 = 1;
pub const CONFIG_MAX1363_MODULE: u32 = 1;
pub const CONFIG_SND_USB_HIFACE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_DVB_MODULE: u32 = 1;
pub const CONFIG_LENOVO_YMC_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_KOBIL_SCT_MODULE: u32 = 1;
pub const CONFIG_HDLC_FR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SKCIPHER: u32 = 1;
pub const CONFIG_USB_SERIAL_UPD78F0730_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_STREEBOG_MODULE: u32 = 1;
pub const CONFIG_FB_ATY128_BACKLIGHT: u32 = 1;
pub const CONFIG_USB_GSPCA_TOUPTEK_MODULE: u32 = 1;
pub const CONFIG_GENEVE_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_COMPRESSOR_DEFAULT_LZO: u32 = 1;
pub const CONFIG_XZ_DEC_X86: u32 = 1;
pub const CONFIG_MFD_CS47L90: u32 = 1;
pub const CONFIG_MTD_RAW_NAND_MODULE: u32 = 1;
pub const CONFIG_VIRT_CPU_ACCOUNTING: u32 = 1;
pub const CONFIG_MLX5_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_RMI4_SPI_MODULE: u32 = 1;
pub const CONFIG_MAC80211_LEDS: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_FINALIZE_INIT: u32 = 1;
pub const CONFIG_INPUT_JOYDEV_MODULE: u32 = 1;
pub const CONFIG_FB_MATROX_MAVEN_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_QCOM_USB_VBUS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2685_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_LKKBD_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TPROXY_MODULE: u32 = 1;
pub const CONFIG_HIBERNATE_CALLBACKS: u32 = 1;
pub const CONFIG_MEN_Z188_ADC_MODULE: u32 = 1;
pub const CONFIG_LEDS_MC13783_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_ES8336_MACH_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_DW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L56_MODULE: u32 = 1;
pub const CONFIG_IP_DCCP_MODULE: u32 = 1;
pub const CONFIG_LIBIPW_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_OHCI_MODULE: u32 = 1;
pub const CONFIG_ATH10K_USB_MODULE: u32 = 1;
pub const CONFIG_EISA: u32 = 1;
pub const CONFIG_THERMAL_EMERGENCY_POWEROFF_DELAY_MS: u32 = 0;
pub const CONFIG_CONSOLE_LOGLEVEL_QUIET: u32 = 3;
pub const CONFIG_USB_ACM_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADL_PCI9118_MODULE: u32 = 1;
pub const CONFIG_USB_RTL8150_MODULE: u32 = 1;
pub const CONFIG_NVME_CORE_MODULE: u32 = 1;
pub const CONFIG_INTEL_TURBO_MAX_3: u32 = 1;
pub const CONFIG_GPIO_MAX7300_MODULE: u32 = 1;
pub const CONFIG_USB_MSI2500_MODULE: u32 = 1;
pub const CONFIG_TI_DAC7612_MODULE: u32 = 1;
pub const CONFIG_CRC16: u32 = 1;
pub const CONFIG_BACKLIGHT_SKY81452_MODULE: u32 = 1;
pub const CONFIG_USB_NET_AX8817X_MODULE: u32 = 1;
pub const CONFIG_SND_EMU10K1_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CALIBRATE_DELAY: u32 = 1;
pub const CONFIG_DM_EBS_MODULE: u32 = 1;
pub const CONFIG_UPROBE_EVENTS: u32 = 1;
pub const CONFIG_NLS_ISO8859_6_MODULE: u32 = 1;
pub const CONFIG_NET_CLS: u32 = 1;
pub const CONFIG_ADF4350_MODULE: u32 = 1;
pub const CONFIG_DEVTMPFS_SAFE: u32 = 1;
pub const CONFIG_XFS_RT: u32 = 1;
pub const CONFIG_MAX31865_MODULE: u32 = 1;
pub const CONFIG_SI7005_MODULE: u32 = 1;
pub const CONFIG_COMEDI_S626_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM1789_I2C_MODULE: u32 = 1;
pub const CONFIG_ICE_SWITCHDEV: u32 = 1;
pub const CONFIG_AX25_MODULE: u32 = 1;
pub const CONFIG_NVME_HOST_AUTH: u32 = 1;
pub const CONFIG_AD7293_MODULE: u32 = 1;
pub const CONFIG_SND_YMFPCI_MODULE: u32 = 1;
pub const CONFIG_TMPFS: u32 = 1;
pub const CONFIG_MFD_LM3533_MODULE: u32 = 1;
pub const CONFIG_HP206C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8731_SPI_MODULE: u32 = 1;
pub const CONFIG_LEDS_TPS6105X_MODULE: u32 = 1;
pub const CONFIG_NFT_CT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_FMWLIB_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_NETERION: u32 = 1;
pub const CONFIG_CADENCE_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_RANDSTRUCT_NONE: u32 = 1;
pub const CONFIG_USB_OHCI_HCD_PLATFORM: u32 = 1;
pub const CONFIG_SND_SOC_WM8711_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_EARLY_DEBUG: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_936_MODULE: u32 = 1;
pub const CONFIG_HAMACHI_MODULE: u32 = 1;
pub const CONFIG_ET131X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2518_MODULE: u32 = 1;
pub const CONFIG_IR_ITE_CIR_MODULE: u32 = 1;
pub const CONFIG_WCN36XX_MODULE: u32 = 1;
pub const CONFIG_FPGA_REGION_MODULE: u32 = 1;
pub const CONFIG_DVB_BUDGET_MODULE: u32 = 1;
pub const CONFIG_FUTEX: u32 = 1;
pub const CONFIG_IP_VS_MH_TAB_INDEX: u32 = 12;
pub const CONFIG_COMEDI_NI_AT_A2150_MODULE: u32 = 1;
pub const CONFIG_DRM_VRAM_HELPER_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PHY_MIPI_DPHY: u32 = 1;
pub const CONFIG_COMEDI_NI_LABPC_ISA_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_HX8357D_MODULE: u32 = 1;
pub const CONFIG_SND_BCM63XX_I2S_WHISTLER_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI: u32 = 1;
pub const CONFIG_TCP_CONG_NV_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_ALS_MODULE: u32 = 1;
pub const CONFIG_UNIX_SCM: u32 = 1;
pub const CONFIG_MCP320X_MODULE: u32 = 1;
pub const CONFIG_MISDN_HFCMULTI_MODULE: u32 = 1;
pub const CONFIG_MMC_SPI_MODULE: u32 = 1;
pub const CONFIG_CONSOLE_LOGLEVEL_DEFAULT: u32 = 7;
pub const CONFIG_QCOM_HIDMA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_HI847_MODULE: u32 = 1;
pub const CONFIG_MWAVE_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_3C574_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SQ930X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2764_MODULE: u32 = 1;
pub const CONFIG_RTL8192SE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CATPT_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SPACEBALL_MODULE: u32 = 1;
pub const CONFIG_REGMAP_I2C: u32 = 1;
pub const CONFIG_AD5449_MODULE: u32 = 1;
pub const CONFIG_ZPA2326_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_FAST_MULTIPLIER: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HYCON_HY46XX_MODULE: u32 = 1;
pub const CONFIG_INPUT_MATRIXKMAP_MODULE: u32 = 1;
pub const CONFIG_ATH9K_DEBUGFS: u32 = 1;
pub const CONFIG_MFD_BCM590XX_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MSCC_SEVILLE_MODULE: u32 = 1;
pub const CONFIG_DVB_CXD2099_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_REALTEK: u32 = 1;
pub const CONFIG_VIDEO_VIVID_CEC: u32 = 1;
pub const CONFIG_MFD_SM501_GPIO: u32 = 1;
pub const CONFIG_DVB_DM1105_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAVE_NMI_SAFE_CMPXCHG: u32 = 1;
pub const CONFIG_MFD_RDC321X_MODULE: u32 = 1;
pub const CONFIG_AD5421_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_XPAD_FF: u32 = 1;
pub const CONFIG_COMMON_CLK_SI544_MODULE: u32 = 1;
pub const CONFIG_SCSI_AHA1740_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_HL_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LP8788_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_SAS_MODULE: u32 = 1;
pub const CONFIG_MT792x_LIB_MODULE: u32 = 1;
pub const CONFIG_PATA_HPT3X2N_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_MODULE: u32 = 1;
pub const CONFIG_DVB_CORE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ME_DAQ_MODULE: u32 = 1;
pub const CONFIG_SDR_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_CAN_JANZ_ICAN3_MODULE: u32 = 1;
pub const CONFIG_USB_NET2280_MODULE: u32 = 1;
pub const CONFIG_ISL29003_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_MODULE: u32 = 1;
pub const CONFIG_RTC_HCTOSYS: u32 = 1;
pub const CONFIG_I2C_OCORES_MODULE: u32 = 1;
pub const CONFIG_NAU7802_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_CAPTURE_ERROR: u32 = 1;
pub const CONFIG_SECURITY_NETWORK: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_HIFI_EP_IPC_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX77541_MODULE: u32 = 1;
pub const CONFIG_DRM_VBOXVIDEO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NZXT_SMART2_MODULE: u32 = 1;
pub const CONFIG_SERIAL_CORE_CONSOLE: u32 = 1;
pub const CONFIG_INTEL_XWAY_PHY_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_CPCI: u32 = 1;
pub const CONFIG_ACPI_CPPC_LIB: u32 = 1;
pub const CONFIG_HUGETLB_PAGE: u32 = 1;
pub const CONFIG_MTD_SM_COMMON_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_TPM: u32 = 1;
pub const CONFIG_SENSORS_XGENE_MODULE: u32 = 1;
pub const CONFIG_DVB_SMIPCIE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2888_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GUNZE_MODULE: u32 = 1;
pub const CONFIG_NFC_ST_NCI_SPI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM78_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_EMULEX: u32 = 1;
pub const CONFIG_WIZNET_W5100_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305_MODULE: u32 = 1;
pub const CONFIG_REGMAP_IRQ: u32 = 1;
pub const CONFIG_SENSORS_K10TEMP_MODULE: u32 = 1;
pub const CONFIG_USB_HID_MODULE: u32 = 1;
pub const CONFIG_LD_ORPHAN_WARN_LEVEL: &[u8; 5usize] = b"warn\0";
pub const CONFIG_DVB_USB_AF9015_MODULE: u32 = 1;
pub const CONFIG_DELL_SMBIOS_MODULE: u32 = 1;
pub const CONFIG_FRAMER_MODULE: u32 = 1;
pub const CONFIG_ICE_HWTS: u32 = 1;
pub const CONFIG_FPGA_MODULE: u32 = 1;
pub const CONFIG_MLX5_EN_IPSEC: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RV_RT5682_MACH_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_MODULE: u32 = 1;
pub const CONFIG_DRM_AMDGPU_SI: u32 = 1;
pub const CONFIG_RTL8192CU_MODULE: u32 = 1;
pub const CONFIG_ATM_DRIVERS: u32 = 1;
pub const CONFIG_MELLANOX_PLATFORM: u32 = 1;
pub const CONFIG_BLK_DEV_RBD_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HMC5843_MODULE: u32 = 1;
pub const CONFIG_SERIO_PS2MULT_MODULE: u32 = 1;
pub const CONFIG_VSOCKETS_DIAG_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS6105X_MODULE: u32 = 1;
pub const CONFIG_USER_STACKTRACE_SUPPORT: u32 = 1;
pub const CONFIG_CAN_UCAN_MODULE: u32 = 1;
pub const CONFIG_MEGARAID_MAILBOX_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_MCAST: u32 = 1;
pub const CONFIG_SLUB_DEBUG: u32 = 1;
pub const CONFIG_TYPEC_WUSB3801_MODULE: u32 = 1;
pub const CONFIG_IT8712F_WDT_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T80_WDT: u32 = 1;
pub const CONFIG_OBJAGG_MODULE: u32 = 1;
pub const CONFIG_WIZNET_W5300_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_670X_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_MD: u32 = 1;
pub const CONFIG_UCS2_STRING: u32 = 1;
pub const CONFIG_SENSEAIR_SUNRISE_CO2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS5805M_MODULE: u32 = 1;
pub const CONFIG_MMC_VUB300_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_AIRCABLE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PIM4328_MODULE: u32 = 1;
pub const CONFIG_IP_SET_BITMAP_IP_MODULE: u32 = 1;
pub const CONFIG_FIELDBUS_DEV_MODULE: u32 = 1;
pub const CONFIG_GPIO_VX855_MODULE: u32 = 1;
pub const CONFIG_MAC_EMUMOUSEBTN_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_CPS_XX_MODULE: u32 = 1;
pub const CONFIG_WQ_CPU_INTENSIVE_REPORT: u32 = 1;
pub const CONFIG_MMC_MTK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8978_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_CZ_DA7219MX98357_MACH_MODULE: u32 = 1;
pub const CONFIG_IMA_APPRAISE_MODSIG: u32 = 1;
pub const CONFIG_ANON_VMA_NAME: u32 = 1;
pub const CONFIG_BNXT_DCB: u32 = 1;
pub const CONFIG_HIST_TRIGGERS: u32 = 1;
pub const CONFIG_MTD_SBC_GXX_MODULE: u32 = 1;
pub const CONFIG_NFC_NCI_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_F_RNDIS_MODULE: u32 = 1;
pub const CONFIG_ACPI_FPDT: u32 = 1;
pub const CONFIG_NET_SCH_INGRESS_MODULE: u32 = 1;
pub const CONFIG_BCMA_MODULE: u32 = 1;
pub const CONFIG_DMADEVICES: u32 = 1;
pub const CONFIG_XENFS_MODULE: u32 = 1;
pub const CONFIG_AXP288_CHARGER_MODULE: u32 = 1;
pub const CONFIG_SCA3000_MODULE: u32 = 1;
pub const CONFIG_ATH10K_SDIO_MODULE: u32 = 1;
pub const CONFIG_CORTINA_PHY_MODULE: u32 = 1;
pub const CONFIG_SCSI_AACRAID_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_KBL_DA7219_MAX98927_MACH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AK7375_MODULE: u32 = 1;
pub const CONFIG_MISDN_HFCUSB_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_PAHOLE_VERSION: u32 = 125;
pub const CONFIG_BACKLIGHT_LM3639_MODULE: u32 = 1;
pub const CONFIG_NCN26000_PHY_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_EVENTS: u32 = 1;
pub const CONFIG_MOUSE_PS2_ELANTECH: u32 = 1;
pub const CONFIG_DEBUG_INFO_DWARF5: u32 = 1;
pub const CONFIG_MFD_DA9062_MODULE: u32 = 1;
pub const CONFIG_PINCTRL: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_CFI_CLANG: u32 = 1;
pub const CONFIG_HID_SENSOR_DEVICE_ROTATION_MODULE: u32 = 1;
pub const CONFIG_IPV6_NDISC_NODETYPE: u32 = 1;
pub const CONFIG_HFS_FS_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_EPAT_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852C_MODULE: u32 = 1;
pub const CONFIG_INTEL_VBTN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8985_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MSM6242_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_TECHNISAT_USB2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6620_MODULE: u32 = 1;
pub const CONFIG_PCI_LABEL: u32 = 1;
pub const CONFIG_CRYPTO_ARCH_HAVE_LIB_BLAKE2S: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_1251_MODULE: u32 = 1;
pub const CONFIG_USB_F_MIDI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_MODULE: u32 = 1;
pub const CONFIG_EDAC_X38_MODULE: u32 = 1;
pub const CONFIG_FANOTIFY: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MXL301RF_MODULE: u32 = 1;
pub const CONFIG_SPI_BUTTERFLY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP5x_MODULE: u32 = 1;
pub const CONFIG_HAVE_OBJTOOL_MCOUNT: u32 = 1;
pub const CONFIG_SONYPI_COMPAT: u32 = 1;
pub const CONFIG_IP_VS_PROTO_SCTP: u32 = 1;
pub const CONFIG_SP5100_TCO_MODULE: u32 = 1;
pub const CONFIG_WIL6210_DEBUGFS: u32 = 1;
pub const CONFIG_GREYBUS_PWM_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNLABEL_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_DEFAULT_BPF_JIT: u32 = 1;
pub const CONFIG_SGETMASK_SYSCALL: u32 = 1;
pub const CONFIG_AD5696_I2C_MODULE: u32 = 1;
pub const CONFIG_SATA_SIL_MODULE: u32 = 1;
pub const CONFIG_ALTERA_STAPL_MODULE: u32 = 1;
pub const CONFIG_USERFAULTFD: u32 = 1;
pub const CONFIG_CGROUP_SCHED: u32 = 1;
pub const CONFIG_SND_HDA_RECONFIG: u32 = 1;
pub const CONFIG_VIDEO_ADV7842_MODULE: u32 = 1;
pub const CONFIG_QUEUED_RWLOCKS: u32 = 1;
pub const CONFIG_SYSVIPC: u32 = 1;
pub const CONFIG_COMEDI_NI_LABPC_CS_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS250X_MODULE: u32 = 1;
pub const CONFIG_RAID6_PQ_BENCHMARK: u32 = 1;
pub const CONFIG_ARCH_HAS_GIGANTIC_PAGE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_ECM_SUBSET: u32 = 1;
pub const CONFIG_MTD_UBI_BLOCK: u32 = 1;
pub const CONFIG_HAVE_DEBUG_KMEMLEAK: u32 = 1;
pub const CONFIG_JOYSTICK_INTERACT_MODULE: u32 = 1;
pub const CONFIG_SMSC911X_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX3191X_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT282X_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10071_MODULE: u32 = 1;
pub const CONFIG_HDLC_CISCO_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_ZSTD: u32 = 1;
pub const CONFIG_MLX4_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_DVB_OR51211_MODULE: u32 = 1;
pub const CONFIG_RT2X00_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_863_MODULE: u32 = 1;
pub const CONFIG_SND_DESIGNWARE_I2S_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7X10_MODULE: u32 = 1;
pub const CONFIG_USB_G_HID_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_GPIO_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_FTP_MODULE: u32 = 1;
pub const CONFIG_PAGE_SIZE_LESS_THAN_64KB: u32 = 1;
pub const CONFIG_FPGA_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_UART_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T4_MODULE: u32 = 1;
pub const CONFIG_MODULES: u32 = 1;
pub const CONFIG_RPMSG_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_ECN_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_PHONET: u32 = 1;
pub const CONFIG_ADVANTECH_EC_WDT_MODULE: u32 = 1;
pub const CONFIG_DWC_XLGMAC_MODULE: u32 = 1;
pub const CONFIG_IFCVF_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX219_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8660_MODULE: u32 = 1;
pub const CONFIG_USB_GADGET_MODULE: u32 = 1;
pub const CONFIG_FB_IMSTT: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA506_MODULE: u32 = 1;
pub const CONFIG_CHROMEOS_PRIVACY_SCREEN_MODULE: u32 = 1;
pub const CONFIG_CAN_CC770_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_PATA_ARTOP_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_NEWTON_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_TRACKING: u32 = 1;
pub const CONFIG_HARDLOCKUP_DETECTOR: u32 = 1;
pub const CONFIG_VIDEO_CX88_DVB_MODULE: u32 = 1;
pub const CONFIG_GPIO_DA9055_MODULE: u32 = 1;
pub const CONFIG_ISL76682_MODULE: u32 = 1;
pub const CONFIG_MQ_IOSCHED_DEADLINE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_ALSA_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MXL5005S_MODULE: u32 = 1;
pub const CONFIG_INPUT_TWL4030_VIBRA_MODULE: u32 = 1;
pub const CONFIG_USB_HIDDEV: u32 = 1;
pub const CONFIG_IOMMU_IOVA: u32 = 1;
pub const CONFIG_INFINIBAND_IPOIB_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_INTEL_PMC_MODULE: u32 = 1;
pub const CONFIG_DUMMY_CONSOLE_COLUMNS: u32 = 80;
pub const CONFIG_SENSORS_APDS990X_MODULE: u32 = 1;
pub const CONFIG_USB_ETH_RNDIS: u32 = 1;
pub const CONFIG_AD7606_IFACE_PARALLEL_MODULE: u32 = 1;
pub const CONFIG_DVB_SI21XX_MODULE: u32 = 1;
pub const CONFIG_XXHASH: u32 = 1;
pub const CONFIG_PATA_WINBOND_MODULE: u32 = 1;
pub const CONFIG_ACPI_THERMAL_LIB: u32 = 1;
pub const CONFIG_SOUND_MODULE: u32 = 1;
pub const CONFIG_NFT_MASQ_MODULE: u32 = 1;
pub const CONFIG_COMEDI_RTI802_MODULE: u32 = 1;
pub const CONFIG_SPS30_MODULE: u32 = 1;
pub const CONFIG_NFT_QUOTA_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AUO_PIXCIR_MODULE: u32 = 1;
pub const CONFIG_JOLIET: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_VP7045_MODULE: u32 = 1;
pub const CONFIG_USB_NET2272_DMA: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_NUVOTON_COMMON_MODULE: u32 = 1;
pub const CONFIG_RTW88_8821C_MODULE: u32 = 1;
pub const CONFIG_SCHED_CORE: u32 = 1;
pub const CONFIG_KPROBES_ON_FTRACE: u32 = 1;
pub const CONFIG_BNX2X_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA9887_MODULE: u32 = 1;
pub const CONFIG_ADVANTECH_WDT_MODULE: u32 = 1;
pub const CONFIG_NFC_PN532_UART_MODULE: u32 = 1;
pub const CONFIG_PVPANIC_PCI_MODULE: u32 = 1;
pub const CONFIG_AD5624R_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_LEGACY_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_LUNARLAKE_MODULE: u32 = 1;
pub const CONFIG_ARCH_HIBERNATION_POSSIBLE: u32 = 1;
pub const CONFIG_SND_SOC_SI476X_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_LME2510_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_SYM_ANNOTATIONS: u32 = 1;
pub const CONFIG_PROC_CHILDREN: u32 = 1;
pub const CONFIG_PDC_ADMA_MODULE: u32 = 1;
pub const CONFIG_IA32_FEAT_CTL: u32 = 1;
pub const CONFIG_SND_VXPOCKET_MODULE: u32 = 1;
pub const CONFIG_ADIN1110_MODULE: u32 = 1;
pub const CONFIG_SND_USB_LINE6_MODULE: u32 = 1;
pub const CONFIG_UNIX: u32 = 1;
pub const CONFIG_USB_CATC_MODULE: u32 = 1;
pub const CONFIG_USB_NET_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_PCI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CADENCE_CSI2RX_MODULE: u32 = 1;
pub const CONFIG_CC_CAN_LINK: u32 = 1;
pub const CONFIG_QNX6FS_FS_MODULE: u32 = 1;
pub const CONFIG_NVSW_SN2201_MODULE: u32 = 1;
pub const CONFIG_SCSI_FDOMAIN_PCI_MODULE: u32 = 1;
pub const CONFIG_LD_IS_BFD: u32 = 1;
pub const CONFIG_AXP20X_POWER_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_DECOMP_MULTI: u32 = 1;
pub const CONFIG_NO_HZ_COMMON: u32 = 1;
pub const CONFIG_MINIX_FS_MODULE: u32 = 1;
pub const CONFIG_RCU_LAZY_DEFAULT_OFF: u32 = 1;
pub const CONFIG_DRM_MIPI_DSI: u32 = 1;
pub const CONFIG_BRCMSMAC_MODULE: u32 = 1;
pub const CONFIG_XEN_DEV_EVTCHN_MODULE: u32 = 1;
pub const CONFIG_HAVE_CLK: u32 = 1;
pub const CONFIG_CRYPTO_HASH2: u32 = 1;
pub const CONFIG_MMC_SDHCI_F_SDH30_MODULE: u32 = 1;
pub const CONFIG_CARL9170_MODULE: u32 = 1;
pub const CONFIG_LEDS_CLASS_MULTICOLOR_MODULE: u32 = 1;
pub const CONFIG_DW_EDMA_PCIE_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CONEXANT_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_VERTEXCOM: u32 = 1;
pub const CONFIG_RMI4_F54: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ICELAKE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LZ4HC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1015_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24117_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_STEP_WISE: u32 = 1;
pub const CONFIG_SND_RME9652_MODULE: u32 = 1;
pub const CONFIG_MTD_ABSENT_MODULE: u32 = 1;
pub const CONFIG_SCREEN_INFO: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_POLL_SYNC: u32 = 1;
pub const CONFIG_IMA_DEFAULT_HASH_SHA256: u32 = 1;
pub const CONFIG_TOUCHSCREEN_88PM860X_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_HOSTNAME: &[u8; 7usize] = b"(none)\0";
pub const CONFIG_COMMON_CLK_SI5351_MODULE: u32 = 1;
pub const CONFIG_NLS_KOI8_R_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7410_MODULE: u32 = 1;
pub const CONFIG_USB_GADGET_STORAGE_NUM_BUFFERS: u32 = 2;
pub const CONFIG_THUNDER_NIC_VF_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_NO_PROFILE_FN_ATTR: u32 = 1;
pub const CONFIG_IP_SET_HASH_NETPORTNET_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SONIXB_MODULE: u32 = 1;
pub const CONFIG_CAN_RX_OFFLOAD: u32 = 1;
pub const CONFIG_DVB_USB_RTL28XXU_MODULE: u32 = 1;
pub const CONFIG_DRM_ANALOGIX_DP_MODULE: u32 = 1;
pub const CONFIG_MMC_REALTEK_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_ISD200_MODULE: u32 = 1;
pub const CONFIG_MCP4821_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_POWERSAVE: u32 = 1;
pub const CONFIG_REGULATOR_RT5120_MODULE: u32 = 1;
pub const CONFIG_SEL3350_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_OV534_9_MODULE: u32 = 1;
pub const CONFIG_RIONET_MODULE: u32 = 1;
pub const CONFIG_NFS_FS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_X86_64_MODULE: u32 = 1;
pub const CONFIG_MEDIA_SUPPORT_FILTER: u32 = 1;
pub const CONFIG_USB_NET_SMSC95XX_MODULE: u32 = 1;
pub const CONFIG_CRASH_DUMP: u32 = 1;
pub const CONFIG_MEMBARRIER: u32 = 1;
pub const CONFIG_FB_SM712_MODULE: u32 = 1;
pub const CONFIG_CEC_CORE_MODULE: u32 = 1;
pub const CONFIG_MLX_WDT_MODULE: u32 = 1;
pub const CONFIG_AMD_SFH_HID_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3533_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ADDR_TRANS: u32 = 1;
pub const CONFIG_BLK_DEV_IO_TRACE: u32 = 1;
pub const CONFIG_CROS_EC_TYPEC_MODULE: u32 = 1;
pub const CONFIG_UBSAN_BOUNDS_STRICT: u32 = 1;
pub const CONFIG_XPS: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_DH895xCC_MODULE: u32 = 1;
pub const CONFIG_COMEDI_8255_PCI_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_SKBEDIT_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADV_PCI1723_MODULE: u32 = 1;
pub const CONFIG_INET_ESP_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_DEVELOP: u32 = 1;
pub const CONFIG_SGL_ALLOC: u32 = 1;
pub const CONFIG_AD7816_MODULE: u32 = 1;
pub const CONFIG_HPET_TIMER: u32 = 1;
pub const CONFIG_TSM_REPORTS_MODULE: u32 = 1;
pub const CONFIG_LCD_TDO24M_MODULE: u32 = 1;
pub const CONFIG_LZ4_DECOMPRESS: u32 = 1;
pub const CONFIG_INPUT_GPIO_BEEPER_MODULE: u32 = 1;
pub const CONFIG_NFC_HCI_MODULE: u32 = 1;
pub const CONFIG_GPIO_MAX732X_MODULE: u32 = 1;
pub const CONFIG_HSI_MODULE: u32 = 1;
pub const CONFIG_NF_TPROXY_IPV6_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_ZONES: u32 = 1;
pub const CONFIG_DP83848_PHY_MODULE: u32 = 1;
pub const CONFIG_EFI_RUNTIME_MAP: u32 = 1;
pub const CONFIG_AD5110_MODULE: u32 = 1;
pub const CONFIG_FONT_SUPPORT: u32 = 1;
pub const CONFIG_ADVISE_SYSCALLS: u32 = 1;
pub const CONFIG_MD: u32 = 1;
pub const CONFIG_CROS_EC_I2C_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ALGAPI: u32 = 1;
pub const CONFIG_CEC_PIN: u32 = 1;
pub const CONFIG_SENSORS_AAEON_MODULE: u32 = 1;
pub const CONFIG_FDDI: u32 = 1;
pub const CONFIG_IR_SERIAL_MODULE: u32 = 1;
pub const CONFIG_SENSORS_VT8231_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_CORE_SYNC: u32 = 1;
pub const CONFIG_DVB_BUDGET_CI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_KE_COUNTER_MODULE: u32 = 1;
pub const CONFIG_EDAC_I3200_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WSA884X_MODULE: u32 = 1;
pub const CONFIG_RTW88_CORE_MODULE: u32 = 1;
pub const CONFIG_CEPH_FSCACHE: u32 = 1;
pub const CONFIG_INPUT_KXTJ9_MODULE: u32 = 1;
pub const CONFIG_CAN_ESD_USB_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ADV7604_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_PHYSICAL_MASK: u32 = 1;
pub const CONFIG_SND_SEQ_MIDI_EMUL_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_ZPOOL_DEFAULT_ZBUD: u32 = 1;
pub const CONFIG_BSD_PROCESS_ACCT_V3: u32 = 1;
pub const CONFIG_DRM_I915_MAX_REQUEST_BUSYWAIT: u32 = 8000;
pub const CONFIG_MODULE_SIG_FORMAT: u32 = 1;
pub const CONFIG_SENSORS_PM6764TR_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_WIZNET: u32 = 1;
pub const CONFIG_SCSI_DMX3191D_MODULE: u32 = 1;
pub const CONFIG_FONTS: u32 = 1;
pub const CONFIG_MMC_ALCOR_MODULE: u32 = 1;
pub const CONFIG_USB_G_DBGP_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1372_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8731_I2C_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CGROUP_MODULE: u32 = 1;
pub const CONFIG_X86_USER_SHADOW_STACK: u32 = 1;
pub const CONFIG_AD2S90_MODULE: u32 = 1;
pub const CONFIG_MLXSW_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_CYPRESS_CY7C63_MODULE: u32 = 1;
pub const CONFIG_IOMMU_SVA: u32 = 1;
pub const CONFIG_OPT3001_MODULE: u32 = 1;
pub const CONFIG_EEPROM_AT25_MODULE: u32 = 1;
pub const CONFIG_SCHED_MM_CID: u32 = 1;
pub const CONFIG_SERIAL_8250_MID: u32 = 1;
pub const CONFIG_RD_BZIP2: u32 = 1;
pub const CONFIG_REGULATOR_SLG51000_MODULE: u32 = 1;
pub const CONFIG_MFD_VIPERBOARD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98373_SDW_MODULE: u32 = 1;
pub const CONFIG_WANT_DEV_COREDUMP: u32 = 1;
pub const CONFIG_INPUT_UINPUT: u32 = 1;
pub const CONFIG_SERIAL_ARC_NR_PORTS: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CHECKSUM_MODULE: u32 = 1;
pub const CONFIG_CHARGER_TPS65090_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADI_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_INTEL_MODULE: u32 = 1;
pub const CONFIG_UNWINDER_FRAME_POINTER: u32 = 1;
pub const CONFIG_SKB_EXTENSIONS: u32 = 1;
pub const CONFIG_PM_OPP: u32 = 1;
pub const CONFIG_IOSF_MBI_DEBUG: u32 = 1;
pub const CONFIG_POWER_RESET_RESTART: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_GPIO_MODULE: u32 = 1;
pub const CONFIG_RTLWIFI_USB_MODULE: u32 = 1;
pub const CONFIG_TCG_ATMEL_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MSCC_OCELOT_EXT_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_MI0283QT_MODULE: u32 = 1;
pub const CONFIG_GPIO_CDEV: u32 = 1;
pub const CONFIG_AFE4404_MODULE: u32 = 1;
pub const CONFIG_WPCM450_SOC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_SDW_MODULE: u32 = 1;
pub const CONFIG_DVB_MB86A16_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_SIMPLE_MODULE: u32 = 1;
pub const CONFIG_SND_OXYGEN_MODULE: u32 = 1;
pub const CONFIG_CC_VERSION_TEXT: &[u8; 62usize] =
    b"x86_64-linux-gnu-gcc-13 (Ubuntu 13.3.0-6ubuntu2~24.04) 13.3.0\0";
pub const CONFIG_KEYBOARD_ATKBD: u32 = 1;
pub const CONFIG_SCSI_QLA_ISCSI_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_UART_MODULE: u32 = 1;
pub const CONFIG_NVMEM_RAVE_SP_EEPROM_MODULE: u32 = 1;
pub const CONFIG_AD5446_MODULE: u32 = 1;
pub const CONFIG_X86_PLATFORM_DEVICES: u32 = 1;
pub const CONFIG_IIO_ST_MAGN_I2C_3AXIS_MODULE: u32 = 1;
pub const CONFIG_LIBNVDIMM: u32 = 1;
pub const CONFIG_NET_IP_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ADDR_TRANS_CONFIGFS: u32 = 1;
pub const CONFIG_WANXL_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_I1: u32 = 1;
pub const CONFIG_NF_NAT_MODULE: u32 = 1;
pub const CONFIG_LEDS_PWM_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2780_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_ZLIB: u32 = 1;
pub const CONFIG_W83877F_WDT_MODULE: u32 = 1;
pub const CONFIG_WAFER_WDT_MODULE: u32 = 1;
pub const CONFIG_MTD_MCHP48L640_MODULE: u32 = 1;
pub const CONFIG_BLOCK_LEGACY_AUTOLOAD: u32 = 1;
pub const CONFIG_VIDEO_UPD64031A_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_REVOCATION_KEYS: &[u8; 35usize] = b"debian/canonical-revoked-certs.pem\0";
pub const CONFIG_BATTERY_88PM860X_MODULE: u32 = 1;
pub const CONFIG_MCP3564_MODULE: u32 = 1;
pub const CONFIG_CHARGER_RT9467_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_SPI_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_INTEGRITY: u32 = 1;
pub const CONFIG_DVB_USB_AZ6027_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_OKI: u32 = 1;
pub const CONFIG_MOUSE_BCM5974_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L41_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_INTERSIL: u32 = 1;
pub const CONFIG_NTB_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_TIMESLICE_MIN: u32 = 1;
pub const CONFIG_SENSORS_INTEL_M10_BMC_HWMON_MODULE: u32 = 1;
pub const CONFIG_BATTERY_RX51_MODULE: u32 = 1;
pub const CONFIG_NFC_ST21NFCA_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_RPFILTER_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_INET: u32 = 1;
pub const CONFIG_ATLAS_EZO_SENSOR_MODULE: u32 = 1;
pub const CONFIG_NFS_COMMON: u32 = 1;
pub const CONFIG_CHR_DEV_SCH_MODULE: u32 = 1;
pub const CONFIG_SENSORS_XDPE122_MODULE: u32 = 1;
pub const CONFIG_SPI_INTEL_PCI_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_IPV6_MODULE: u32 = 1;
pub const CONFIG_REGULATOR: u32 = 1;
pub const CONFIG_SND_SOC_MSM8916_WCD_DIGITAL_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_IPV6: u32 = 1;
pub const CONFIG_FAIR_GROUP_SCHED: u32 = 1;
pub const CONFIG_SENSORS_HIH6130_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_MODULE: u32 = 1;
pub const CONFIG_HID_MACALLY_MODULE: u32 = 1;
pub const CONFIG_BATTERY_SBS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HASH: u32 = 1;
pub const CONFIG_HAVE_STACK_VALIDATION: u32 = 1;
pub const CONFIG_PSTORE_ZONE_MODULE: u32 = 1;
pub const CONFIG_AL3320A_MODULE: u32 = 1;
pub const CONFIG_DP83TG720_PHY_MODULE: u32 = 1;
pub const CONFIG_EFI_PARTITION: u32 = 1;
pub const CONFIG_PROBE_EVENTS: u32 = 1;
pub const CONFIG_SSB_PCMCIAHOST_POSSIBLE: u32 = 1;
pub const CONFIG_NETDEVSIM_MODULE: u32 = 1;
pub const CONFIG_TRACE_CLOCK: u32 = 1;
pub const CONFIG_VIDEO_OV5693_MODULE: u32 = 1;
pub const CONFIG_HID_STEAM_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_INFINEON_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_HDMI_MODULE: u32 = 1;
pub const CONFIG_BCMA_BLOCKIO: u32 = 1;
pub const CONFIG_MODULE_SIG_HASH: &[u8; 7usize] = b"sha512\0";
pub const CONFIG_TI_ADS7950_MODULE: u32 = 1;
pub const CONFIG_LOG_BUF_SHIFT: u32 = 18;
pub const CONFIG_PATA_IT8213_MODULE: u32 = 1;
pub const CONFIG_MEMORY_HOTREMOVE: u32 = 1;
pub const CONFIG_PM_NOTIFIER_ERROR_INJECT_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_CPS_GEN2_MODULE: u32 = 1;
pub const CONFIG_SND_CMIPCI_MODULE: u32 = 1;
pub const CONFIG_RTW88_USB_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ATH: u32 = 1;
pub const CONFIG_USB_RTL8153_ECM_MODULE: u32 = 1;
pub const CONFIG_ACPI_DEBUGGER_USER: u32 = 1;
pub const CONFIG_BH1750_MODULE: u32 = 1;
pub const CONFIG_HZ_1000: u32 = 1;
pub const CONFIG_NFP_NET_IPSEC: u32 = 1;
pub const CONFIG_HPET: u32 = 1;
pub const CONFIG_ACPI_WMI_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_857_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_DSCP_MODULE: u32 = 1;
pub const CONFIG_SND_EMU10K1X_MODULE: u32 = 1;
pub const CONFIG_EXTRA_FIRMWARE: &[u8; 1usize] = b"\0";
pub const CONFIG_NET_CLS_MATCHALL_MODULE: u32 = 1;
pub const CONFIG_TCG_TPM: u32 = 1;
pub const CONFIG_SND_SOC_SIMPLE_MUX_MODULE: u32 = 1;
pub const CONFIG_SPI_SLAVE_SYSTEM_CONTROL_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_8390: u32 = 1;
pub const CONFIG_MFD_WM5102: u32 = 1;
pub const CONFIG_MODULE_COMPRESS_ZSTD: u32 = 1;
pub const CONFIG_IPV6_MROUTE: u32 = 1;
pub const CONFIG_XEN_PCIDEV_BACKEND_MODULE: u32 = 1;
pub const CONFIG_PROC_EVENTS: u32 = 1;
pub const CONFIG_ACPI_VIDEO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SHT3x_MODULE: u32 = 1;
pub const CONFIG_HAVE_KCSAN_COMPILER: u32 = 1;
pub const CONFIG_VFAT_FS: u32 = 1;
pub const CONFIG_MUSB_PIO_ONLY: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_ACPI: u32 = 1;
pub const CONFIG_IIO_ST_GYRO_SPI_3AXIS_MODULE: u32 = 1;
pub const CONFIG_NF_FLOW_TABLE_INET_MODULE: u32 = 1;
pub const CONFIG_PID_NS: u32 = 1;
pub const CONFIG_SND_SOC_DMIC_MODULE: u32 = 1;
pub const CONFIG_ST_UVIS25_MODULE: u32 = 1;
pub const CONFIG_MD_RAID1_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_2200_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822B_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_IOCOST: u32 = 1;
pub const CONFIG_CRYPTO_VMAC_MODULE: u32 = 1;
pub const CONFIG_I2C_CHT_WC_MODULE: u32 = 1;
pub const CONFIG_PSI: u32 = 1;
pub const CONFIG_SENSORS_ACPI_POWER_MODULE: u32 = 1;
pub const CONFIG_KEXEC: u32 = 1;
pub const CONFIG_ACPI_CMPC_MODULE: u32 = 1;
pub const CONFIG_MEDIA_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_IIO_CONFIGFS_MODULE: u32 = 1;
pub const CONFIG_RADIO_TEF6862_MODULE: u32 = 1;
pub const CONFIG_SPI_MUX_MODULE: u32 = 1;
pub const CONFIG_CRC32_SLICEBY8: u32 = 1;
pub const CONFIG_FB_DDC_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9150_MODULE: u32 = 1;
pub const CONFIG_MT7921U_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DAS08_MODULE: u32 = 1;
pub const CONFIG_USB_LIBCOMPOSITE_MODULE: u32 = 1;
pub const CONFIG_SCSI_MPT2SAS_MODULE: u32 = 1;
pub const CONFIG_BMI323_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1761_I2C_MODULE: u32 = 1;
pub const CONFIG_HVC_XEN: u32 = 1;
pub const CONFIG_SLAB_FREELIST_HARDENED: u32 = 1;
pub const CONFIG_DPOT_DAC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WSA881X_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM3_MODULE: u32 = 1;
pub const CONFIG_XILINX_VCU_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM9713: u32 = 1;
pub const CONFIG_FPGA_MGR_ALTERA_PS_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1017_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_FQ_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_HASWELL_MACH_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_XILINX_SPI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_HDPVR_MODULE: u32 = 1;
pub const CONFIG_XEN_SCRUB_PAGES_DEFAULT: u32 = 1;
pub const CONFIG_MFD_TPS65912: u32 = 1;
pub const CONFIG_ROMFS_ON_BLOCK: u32 = 1;
pub const CONFIG_EDAC_AMD64_MODULE: u32 = 1;
pub const CONFIG_NET_SB1000_MODULE: u32 = 1;
pub const CONFIG_MT7925E_MODULE: u32 = 1;
pub const CONFIG_GPIO_ARIZONA_MODULE: u32 = 1;
pub const CONFIG_HID_NVIDIA_SHIELD_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_SR: u32 = 1;
pub const CONFIG_CPU_RMAP: u32 = 1;
pub const CONFIG_SND_HWDEP_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_MP3309C_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_SHA512: u32 = 1;
pub const CONFIG_SND_SOC_TAS2781_I2C_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_PTI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CPU: u32 = 1;
pub const CONFIG_GENERIC_IRQ_MATRIX_ALLOCATOR: u32 = 1;
pub const CONFIG_SND_LAYLA20_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_LOOP: u32 = 1;
pub const CONFIG_DVB_BT8XX_MODULE: u32 = 1;
pub const CONFIG_IPMI_HANDLER_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3642_MODULE: u32 = 1;
pub const CONFIG_B44_MODULE: u32 = 1;
pub const CONFIG_AMD_MEM_ENCRYPT: u32 = 1;
pub const CONFIG_DEFAULT_HUNG_TASK_TIMEOUT: u32 = 120;
pub const CONFIG_SYSV_FS_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI_LEGACY: u32 = 1;
pub const CONFIG_SENSORS_THMC50_MODULE: u32 = 1;
pub const CONFIG_ARCH_HIBERNATION_HEADER: u32 = 1;
pub const CONFIG_HAVE_OPTPROBES: u32 = 1;
pub const CONFIG_HAVE_FENTRY: u32 = 1;
pub const CONFIG_L2TP_ETH_MODULE: u32 = 1;
pub const CONFIG_RUST_IS_AVAILABLE: u32 = 1;
pub const CONFIG_DRM_I915_HEARTBEAT_INTERVAL: u32 = 2500;
pub const CONFIG_COMEDI_ADDI_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_I8K: u32 = 1;
pub const CONFIG_PATA_ATIIXP_MODULE: u32 = 1;
pub const CONFIG_SCSI_QLOGIC_1280_MODULE: u32 = 1;
pub const CONFIG_SPI_MEM: u32 = 1;
pub const CONFIG_DELL_SMO8800_MODULE: u32 = 1;
pub const CONFIG_HYPERV_UTILS_MODULE: u32 = 1;
pub const CONFIG_INV_MPU6050_SPI_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_IRC_MODULE: u32 = 1;
pub const CONFIG_60XX_WDT_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_SI5341_MODULE: u32 = 1;
pub const CONFIG_ACPI_HMAT: u32 = 1;
pub const CONFIG_VIDEO_ADV7393_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_XC2028_MODULE: u32 = 1;
pub const CONFIG_INPUT_MISC: u32 = 1;
pub const CONFIG_SND_COMPRESS_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_IR_NUVOTON_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SCH5627_MODULE: u32 = 1;
pub const CONFIG_ADIS16080_MODULE: u32 = 1;
pub const CONFIG_I2C_AMD756_MODULE: u32 = 1;
pub const CONFIG_ICE_MODULE: u32 = 1;
pub const CONFIG_UIO_PRUSS_MODULE: u32 = 1;
pub const CONFIG_E1000E_MODULE: u32 = 1;
pub const CONFIG_MFD_LP8788: u32 = 1;
pub const CONFIG_MS5611_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_METEORLAKE_MODULE: u32 = 1;
pub const CONFIG_DNET_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TC358743_MODULE: u32 = 1;
pub const CONFIG_INPUT_VIVALDIFMAP: u32 = 1;
pub const CONFIG_MT76x0U_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST6_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0288_MODULE: u32 = 1;
pub const CONFIG_USB_SL811_CS_MODULE: u32 = 1;
pub const CONFIG_MULTIUSER: u32 = 1;
pub const CONFIG_CROS_HPS_I2C_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCAP_MODULE: u32 = 1;
pub const CONFIG_SUSPEND: u32 = 1;
pub const CONFIG_GENERIC_VDSO_TIME_NS: u32 = 1;
pub const CONFIG_SUNRPC_XPRT_RDMA_MODULE: u32 = 1;
pub const CONFIG_CROSS_MEMORY_ATTACH: u32 = 1;
pub const CONFIG_MTD_NAND_ECC: u32 = 1;
pub const CONFIG_CRYPTO_CBC: u32 = 1;
pub const CONFIG_SENSORS_LM93_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3601X_MODULE: u32 = 1;
pub const CONFIG_BT_CMTP_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX214_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_APL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_TIGERLAKE_MODULE: u32 = 1;
pub const CONFIG_KS0108_DELAY: u32 = 2;
pub const CONFIG_VIDEO_CX88_VP3054_MODULE: u32 = 1;
pub const CONFIG_MEDIA_CONTROLLER: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_HMARK_MODULE: u32 = 1;
pub const CONFIG_INPUT_RT5120_PWRKEY_MODULE: u32 = 1;
pub const CONFIG_INPUT_MMA8450_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_BUS: u32 = 1;
pub const CONFIG_WWAN_DEBUGFS: u32 = 1;
pub const CONFIG_MRP_MODULE: u32 = 1;
pub const CONFIG_I8253_LOCK: u32 = 1;
pub const CONFIG_SMSC_SCH311X_WDT_MODULE: u32 = 1;
pub const CONFIG_AK8975_MODULE: u32 = 1;
pub const CONFIG_AIC79XX_CMDS_PER_DEVICE: u32 = 32;
pub const CONFIG_IP6_NF_MATCH_RT_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPR_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_DECOMP_SINGLE: u32 = 1;
pub const CONFIG_SENSORS_ISL68137_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_RUNTIME_UARTS: u32 = 32;
pub const CONFIG_HDC2010_MODULE: u32 = 1;
pub const CONFIG_NS83820_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_BUILD: u32 = 1;
pub const CONFIG_IDLE_INJECT: u32 = 1;
pub const CONFIG_ARCH_HAS_NONLEAF_PMD_YOUNG: u32 = 1;
pub const CONFIG_SND_SOC_RT1015P_MODULE: u32 = 1;
pub const CONFIG_CLANG_VERSION: u32 = 0;
pub const CONFIG_STEAM_FF: u32 = 1;
pub const CONFIG_TSL4531_MODULE: u32 = 1;
pub const CONFIG_CDNS_I3C_MASTER_MODULE: u32 = 1;
pub const CONFIG_KPROBES: u32 = 1;
pub const CONFIG_FS_MBCACHE: u32 = 1;
pub const CONFIG_XEN_HAVE_VPMU: u32 = 1;
pub const CONFIG_T5403_MODULE: u32 = 1;
pub const CONFIG_SENSORS_JC42_MODULE: u32 = 1;
pub const CONFIG_DS1682_MODULE: u32 = 1;
pub const CONFIG_MFD_AS3711: u32 = 1;
pub const CONFIG_GFS2_FS_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TUA9001_MODULE: u32 = 1;
pub const CONFIG_RTC_CLASS: u32 = 1;
pub const CONFIG_DVB_TUNER_DIB0070_MODULE: u32 = 1;
pub const CONFIG_DRM_MGAG200_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IPU3_CIO2_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ2515X_MODULE: u32 = 1;
pub const CONFIG_FB_MB862XX_PCI_GDC: u32 = 1;
pub const CONFIG_CRC7_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RNG_DEFAULT: u32 = 1;
pub const CONFIG_SENSORS_LTC4215_MODULE: u32 = 1;
pub const CONFIG_SLICOSS_MODULE: u32 = 1;
pub const CONFIG_KVM_AMD_MODULE: u32 = 1;
pub const CONFIG_USB_EMI26_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_ESP: u32 = 1;
pub const CONFIG_F2FS_FS_LZO: u32 = 1;
pub const CONFIG_PCNET32_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_IT913X_MODULE: u32 = 1;
pub const CONFIG_MWIFIEX_USB_MODULE: u32 = 1;
pub const CONFIG_SAMSUNG_Q10_MODULE: u32 = 1;
pub const CONFIG_TMPFS_XATTR: u32 = 1;
pub const CONFIG_EXT4_USE_FOR_EXT2: u32 = 1;
pub const CONFIG_EDAC_I82975X_MODULE: u32 = 1;
pub const CONFIG_UBUNTU_ODM_DRIVERS: u32 = 1;
pub const CONFIG_PCMCIA_NMCLAN_MODULE: u32 = 1;
pub const CONFIG_CAN_M_CAN_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_MT76x2_COMMON_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODULE: u32 = 1;
pub const CONFIG_FB_UVESA_MODULE: u32 = 1;
pub const CONFIG_XFRM_USER_COMPAT_MODULE: u32 = 1;
pub const CONFIG_INTEL_BXT_PMIC_THERMAL_MODULE: u32 = 1;
pub const CONFIG_AD5593R_MODULE: u32 = 1;
pub const CONFIG_LCD_ILI922X_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2007_MODULE: u32 = 1;
pub const CONFIG_SND_RME96_MODULE: u32 = 1;
pub const CONFIG_CAN_KVASER_USB_MODULE: u32 = 1;
pub const CONFIG_DCA_MODULE: u32 = 1;
pub const CONFIG_I2C_ALI1535_MODULE: u32 = 1;
pub const CONFIG_I2C_I801_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_FAMILY_ARP: u32 = 1;
pub const CONFIG_FB_TFT_SEPS525_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_CAFE_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_STOP_TIMEOUT: u32 = 100;
pub const CONFIG_BCM_NET_PHYLIB_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_DEFAULT_TAGS: u32 = 16;
pub const CONFIG_ATH10K_SPECTRAL: u32 = 1;
pub const CONFIG_SND_SOC_CS4234_MODULE: u32 = 1;
pub const CONFIG_W1_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_ALSA_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_VC032X_MODULE: u32 = 1;
pub const CONFIG_USB_MAX3420_UDC_MODULE: u32 = 1;
pub const CONFIG_OPENVSWITCH_GRE_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UAC1_LEGACY: u32 = 1;
pub const CONFIG_SND_SOC_PCM5102A_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS42L43_MODULE: u32 = 1;
pub const CONFIG_V4L2_FWNODE_MODULE: u32 = 1;
pub const CONFIG_IOMMU_HELPER: u32 = 1;
pub const CONFIG_DVB_ISL6421_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AU0828_RC: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_NETDEV_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1374_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_KDF800108_CTR: u32 = 1;
pub const CONFIG_SENSORS_STTS751_MODULE: u32 = 1;
pub const CONFIG_MLX5_ESWITCH: u32 = 1;
pub const CONFIG_INFINIBAND_OPA_VNIC_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_BOOTROM_MODULE: u32 = 1;
pub const CONFIG_PATA_ACPI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_TRACER: u32 = 1;
pub const CONFIG_CFG80211_USE_KERNEL_REGDB_KEYS: u32 = 1;
pub const CONFIG_INTEL_IFS_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_ILITEK_ILI9341_MODULE: u32 = 1;
pub const CONFIG_TRACE_EVENT_INJECT: u32 = 1;
pub const CONFIG_NLS_ISO8859_5_MODULE: u32 = 1;
pub const CONFIG_DRM_VGEM_MODULE: u32 = 1;
pub const CONFIG_IP_VS_WLC_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_NO_POLL: u32 = 1;
pub const CONFIG_VIDEO_AD5820_MODULE: u32 = 1;
pub const CONFIG_MT792x_USB_MODULE: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_TRACER: u32 = 1;
pub const CONFIG_GENERIC_PHY: u32 = 1;
pub const CONFIG_THERMAL_NETLINK: u32 = 1;
pub const CONFIG_MLXSW_SPECTRUM_MODULE: u32 = 1;
pub const CONFIG_CPU_ISOLATION: u32 = 1;
pub const CONFIG_NF_NAT_TFTP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_IAA_CRYPTO_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_MULTIPORT_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS_RANGE_END: u32 = 8192;
pub const CONFIG_CHARGER_MAX14577_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_GSC_PROXY_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NOR_MODULE: u32 = 1;
pub const CONFIG_STACK_VALIDATION: u32 = 1;
pub const CONFIG_CHARGER_MANAGER: u32 = 1;
pub const CONFIG_FW_LOADER_COMPRESS_XZ: u32 = 1;
pub const CONFIG_NET_SCH_NETEM_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR_AGGREGATOR_MODULE: u32 = 1;
pub const CONFIG_X86_MEM_ENCRYPT: u32 = 1;
pub const CONFIG_USB_STORAGE_REALTEK_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_DP_HELPER: u32 = 1;
pub const CONFIG_SND_SOC_AC97_CODEC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_MODULE: u32 = 1;
pub const CONFIG_LRU_GEN_ENABLED: u32 = 1;
pub const CONFIG_SND_EMU10K1_SEQ_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1307_MODULE: u32 = 1;
pub const CONFIG_I2C_SIS630_MODULE: u32 = 1;
pub const CONFIG_NFSD_V4: u32 = 1;
pub const CONFIG_I2C_SI4713_MODULE: u32 = 1;
pub const CONFIG_ZOPT2201_MODULE: u32 = 1;
pub const CONFIG_PMBUS_MODULE: u32 = 1;
pub const CONFIG_EFI_MIXED: u32 = 1;
pub const CONFIG_SENSORS_LTC2991_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_ILLINOIS_MODULE: u32 = 1;
pub const CONFIG_ZEROPLUS_FF: u32 = 1;
pub const CONFIG_BCM_NET_PHYPTP_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_REDIRECT_MODULE: u32 = 1;
pub const CONFIG_R8169_LEDS: u32 = 1;
pub const CONFIG_CRYPTO_MANAGER2: u32 = 1;
pub const CONFIG_INFINIBAND_QIB_DCA: u32 = 1;
pub const CONFIG_USB_GADGET_VBUS_DRAW: u32 = 2;
pub const CONFIG_SATA_DWC_MODULE: u32 = 1;
pub const CONFIG_NFC_MEI_PHY_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PTE_SPECIAL: u32 = 1;
pub const CONFIG_NET_VENDOR_MYRI: u32 = 1;
pub const CONFIG_KEXEC_FILE: u32 = 1;
pub const CONFIG_NF_NAT_MASQUERADE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_MICFIL_MODULE: u32 = 1;
pub const CONFIG_DRAGONRISE_FF: u32 = 1;
pub const CONFIG_CLZ_TAB: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_3M: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_EGALAX: u32 = 1;
pub const CONFIG_TYPEC_FUSB302_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SUR40_MODULE: u32 = 1;
pub const CONFIG_FUN_ETH_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_DNAT_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MP2629_MODULE: u32 = 1;
pub const CONFIG_CXL_BUS_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PCI_IOMAP: u32 = 1;
pub const CONFIG_HID_PLAYSTATION_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_LOG_MODULE: u32 = 1;
pub const CONFIG_SLUB: u32 = 1;
pub const CONFIG_X86_INTEL_MEMORY_PROTECTION_KEYS: u32 = 1;
pub const CONFIG_SENSORS_AD7418_MODULE: u32 = 1;
pub const CONFIG_MLX5_MACSEC: u32 = 1;
pub const CONFIG_NET_SCH_HHF_MODULE: u32 = 1;
pub const CONFIG_CONFIGFS_FS: u32 = 1;
pub const CONFIG_CRYPTO_TEST_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG_KEY: &[u8; 22usize] = b"certs/signing_key.pem\0";
pub const CONFIG_INTEL_IDXD_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_USB_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RV3032_MODULE: u32 = 1;
pub const CONFIG_ADXL367_I2C_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_BCJ: u32 = 1;
pub const CONFIG_USB_F_MIDI2_MODULE: u32 = 1;
pub const CONFIG_SLIP_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_LTO_CLANG_THIN: u32 = 1;
pub const CONFIG_PM_SLEEP: u32 = 1;
pub const CONFIG_F2FS_FS_XATTR: u32 = 1;
pub const CONFIG_SENSORS_FAM15H_POWER_MODULE: u32 = 1;
pub const CONFIG_I2C: u32 = 1;
pub const CONFIG_MFD_WM5110: u32 = 1;
pub const CONFIG_CRASH_HOTPLUG: u32 = 1;
pub const CONFIG_COMPAL_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_IP_VS_TWOS_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_MTD: u32 = 1;
pub const CONFIG_ZSWAP_ZPOOL_DEFAULT: &[u8; 5usize] = b"zbud\0";
pub const CONFIG_JFFS2_ZLIB: u32 = 1;
pub const CONFIG_SCSI_CHELSIO_FCOE_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_PCNET_MODULE: u32 = 1;
pub const CONFIG_EDAC_DECODE_MCE_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TC358743_CEC: u32 = 1;
pub const CONFIG_SENSORS_VT1211_MODULE: u32 = 1;
pub const CONFIG_GPIO_AMDPT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L41_I2C_MODULE: u32 = 1;
pub const CONFIG_B44_PCI: u32 = 1;
pub const CONFIG_CRYPTO_DEV_AMLOGIC_GXL_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_MKBP_PROXIMITY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_STATS: u32 = 1;
pub const CONFIG_PPP_MULTILINK: u32 = 1;
pub const CONFIG_INFINIBAND_RDMAVT_MODULE: u32 = 1;
pub const CONFIG_X86_UV: u32 = 1;
pub const CONFIG_SND_SOC_CS35L34_MODULE: u32 = 1;
pub const CONFIG_MTD_ONENAND_GENERIC_MODULE: u32 = 1;
pub const CONFIG_IPACK_BUS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_GLK_RT5682_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_MFD_OCELOT_MODULE: u32 = 1;
pub const CONFIG_MMU_GATHER_TABLE_FREE: u32 = 1;
pub const CONFIG_BINFMT_SCRIPT: u32 = 1;
pub const CONFIG_EFI_STUB: u32 = 1;
pub const CONFIG_SATA_PROMISE_MODULE: u32 = 1;
pub const CONFIG_EISA_NAMES: u32 = 1;
pub const CONFIG_KVM_WERROR: u32 = 1;
pub const CONFIG_PARPORT_1284: u32 = 1;
pub const CONFIG_MOUSE_PS2_CYPRESS: u32 = 1;
pub const CONFIG_FONT_ACORN_8x8: u32 = 1;
pub const CONFIG_SENSORS_POWR1220_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX25840_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_CFM: u32 = 1;
pub const CONFIG_INTEL_PMT_CLASS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5670_MODULE: u32 = 1;
pub const CONFIG_GENERIC_PENDING_IRQ: u32 = 1;
pub const CONFIG_INTERRUPT_CNT_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_FENCE_TIMEOUT: u32 = 10000;
pub const CONFIG_I2C_AMD756_S4882_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PC_MODULE: u32 = 1;
pub const CONFIG_BFQ_GROUP_IOSCHED: u32 = 1;
pub const CONFIG_CAVIUM_PTP_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_LOADBALANCE_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_BLKDEV: &[u8; 1usize] = b"\0";
pub const CONFIG_DVB_MN88472_MODULE: u32 = 1;
pub const CONFIG_PPS_CLIENT_GPIO_MODULE: u32 = 1;
pub const CONFIG_IIO_SW_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_X86_NEED_RELOCS: u32 = 1;
pub const CONFIG_EARLY_PRINTK_DBGP: u32 = 1;
pub const CONFIG_BMI323_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ADV7175_MODULE: u32 = 1;
pub const CONFIG_SCSI_SRP_ATTRS_MODULE: u32 = 1;
pub const CONFIG_FRAME_POINTER: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_CNL_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_IMAGIS_MODULE: u32 = 1;
pub const CONFIG_NET_IPGRE_BROADCAST: u32 = 1;
pub const CONFIG_CC_HAS_RETURN_THUNK: u32 = 1;
pub const CONFIG_BT_HIDP_MODULE: u32 = 1;
pub const CONFIG_PD6729_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L15: u32 = 1;
pub const CONFIG_KS8851_MLL_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_RC: u32 = 1;
pub const CONFIG_VIDEO_ADV7842_CEC: u32 = 1;
pub const CONFIG_MOUSE_PS2_LOGIPS2PP: u32 = 1;
pub const CONFIG_MFD_BD9571MWV_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER_HW_CONSUMER_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECDSA_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT2817_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_VANGOGH_MODULE: u32 = 1;
pub const CONFIG_SND_PCXHR_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_HX8357D_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_FORCE_PROBE: &[u8; 1usize] = b"\0";
pub const CONFIG_STMMAC_PCI_MODULE: u32 = 1;
pub const CONFIG_UFS_FS_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_GPIO_SBU_MODULE: u32 = 1;
pub const CONFIG_VM_EVENT_COUNTERS: u32 = 1;
pub const CONFIG_MEDIA_COMMON_OPTIONS: u32 = 1;
pub const CONFIG_NFC_MICROREAD_MODULE: u32 = 1;
pub const CONFIG_HID_MAYFLASH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ALVIUM_CSI2_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SX8654_MODULE: u32 = 1;
pub const CONFIG_RELAY: u32 = 1;
pub const CONFIG_AD9834_MODULE: u32 = 1;
pub const CONFIG_BATTERY_GOLDFISH_MODULE: u32 = 1;
pub const CONFIG_IWLDVM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RTQ9128_MODULE: u32 = 1;
pub const CONFIG_HAVE_MMIOTRACE_SUPPORT: u32 = 1;
pub const CONFIG_SCHED_STACK_END_CHECK: u32 = 1;
pub const CONFIG_ASUS_NB_WMI_MODULE: u32 = 1;
pub const CONFIG_RMI4_F30: u32 = 1;
pub const CONFIG_USB_GSPCA_FINEPIX_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECB: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC32X4_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_ETOMS_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SHA512_SSSE3: u32 = 1;
pub const CONFIG_ACPI_SYSTEM_POWER_STATES_SUPPORT: u32 = 1;
pub const CONFIG_REGULATOR_MAX77693_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_HDA_MODULE: u32 = 1;
pub const CONFIG_MFD_PALMAS: u32 = 1;
pub const CONFIG_WLAN_VENDOR_BROADCOM: u32 = 1;
pub const CONFIG_PM_STD_PARTITION: &[u8; 1usize] = b"\0";
pub const CONFIG_SQUASHFS_LZO: u32 = 1;
pub const CONFIG_BMI088_ACCEL_MODULE: u32 = 1;
pub const CONFIG_SND_DYNAMIC_MINORS: u32 = 1;
pub const CONFIG_FUJITSU_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_TCM_FILEIO_MODULE: u32 = 1;
pub const CONFIG_SND_PCM_IEC958: u32 = 1;
pub const CONFIG_NET_VENDOR_XIRCOM: u32 = 1;
pub const CONFIG_MAX5432_MODULE: u32 = 1;
pub const CONFIG_SCSI_STEX_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_AG6XX: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_HOP_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_CPCI_ZT5550_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_ATH3K: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_CRASH_HOTPLUG: u32 = 1;
pub const CONFIG_NF_CONNTRACK_AMANDA_MODULE: u32 = 1;
pub const CONFIG_SND_ATIIXP_MODEM_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_VDPA_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_GENERIC_MODULE: u32 = 1;
pub const CONFIG_HID_NTI_MODULE: u32 = 1;
pub const CONFIG_DEBUG_FS: u32 = 1;
pub const CONFIG_RDMA_RXE_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_NB7VPQ904M_MODULE: u32 = 1;
pub const CONFIG_FEALNX_MODULE: u32 = 1;
pub const CONFIG_ACPI_EXTLOG_MODULE: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_RNDIS: u32 = 1;
pub const CONFIG_NET_VENDOR_AMD: u32 = 1;
pub const CONFIG_HAVE_KERNEL_LZ4: u32 = 1;
pub const CONFIG_NET_PKTGEN_MODULE: u32 = 1;
pub const CONFIG_HP_WMI_MODULE: u32 = 1;
pub const CONFIG_INTEL_ISH_HID_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_DENALI_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_EDGEPORT_MODULE: u32 = 1;
pub const CONFIG_DRM_TTM_MODULE: u32 = 1;
pub const CONFIG_BASE_FULL: u32 = 1;
pub const CONFIG_SND_SOC_MAX98520_MODULE: u32 = 1;
pub const CONFIG_FB_CFB_IMAGEBLIT: u32 = 1;
pub const CONFIG_MAX5487_MODULE: u32 = 1;
pub const CONFIG_ZLIB_DEFLATE: u32 = 1;
pub const CONFIG_NFT_REJECT_INET_MODULE: u32 = 1;
pub const CONFIG_SUNRPC_MODULE: u32 = 1;
pub const CONFIG_SOLARIS_X86_PARTITION: u32 = 1;
pub const CONFIG_MLXSW_CORE_MODULE: u32 = 1;
pub const CONFIG_ARCNET_RAW_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2007_IIO: u32 = 1;
pub const CONFIG_PMIC_DA903X: u32 = 1;
pub const CONFIG_SCSI_DH_RDAC_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83795_MODULE: u32 = 1;
pub const CONFIG_XFRM_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_BATTERY_BQ27XXX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_Q54SJ108A2_MODULE: u32 = 1;
pub const CONFIG_X86_P4_CLOCKMOD_MODULE: u32 = 1;
pub const CONFIG_RPMSG_NS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1761_SPI_MODULE: u32 = 1;
pub const CONFIG_INPUT_ATI_REMOTE2_MODULE: u32 = 1;
pub const CONFIG_RPMSG_TTY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L45_I2C_MODULE: u32 = 1;
pub const CONFIG_CNIC_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_MOCK_MODULE: u32 = 1;
pub const CONFIG_ACPI_TABLE_UPGRADE: u32 = 1;
pub const CONFIG_RSI_SDIO_MODULE: u32 = 1;
pub const CONFIG_OSF_PARTITION: u32 = 1;
pub const CONFIG_HID_MALTRON_MODULE: u32 = 1;
pub const CONFIG_ARCH_USES_HIGH_VMA_FLAGS: u32 = 1;
pub const CONFIG_CACHESTAT_SYSCALL: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_AUDIO_MODULE: u32 = 1;
pub const CONFIG_RSEQ: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_864_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2856_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CY8CTMG110_MODULE: u32 = 1;
pub const CONFIG_IIO_BUFFER: u32 = 1;
pub const CONFIG_IWL3945_MODULE: u32 = 1;
pub const CONFIG_IP_VS_LBLCR_MODULE: u32 = 1;
pub const CONFIG_GPIO_SYSFS: u32 = 1;
pub const CONFIG_BE2NET_SKYHAWK: u32 = 1;
pub const CONFIG_USB_YUREX_MODULE: u32 = 1;
pub const CONFIG_XEN_BACKEND: u32 = 1;
pub const CONFIG_FW_LOADER: u32 = 1;
pub const CONFIG_REGULATOR_MT6331_MODULE: u32 = 1;
pub const CONFIG_ATH11K_SPECTRAL: u32 = 1;
pub const CONFIG_IIO_SW_DEVICE_MODULE: u32 = 1;
pub const CONFIG_USB_G_DBGP_SERIAL: u32 = 1;
pub const CONFIG_IP6_NF_NAT_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_WM8350_MODULE: u32 = 1;
pub const CONFIG_LTC2471_MODULE: u32 = 1;
pub const CONFIG_RANDOMIZE_MEMORY_PHYSICAL_PADDING: u32 = 10;
pub const CONFIG_SENSORS_ADS7828_MODULE: u32 = 1;
pub const CONFIG_KALLSYMS: u32 = 1;
pub const CONFIG_COMMON_CLK: u32 = 1;
pub const CONFIG_ICP10100_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA501_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_PCIE: u32 = 1;
pub const CONFIG_BMG160_I2C_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RV8803_MODULE: u32 = 1;
pub const CONFIG_STACKPROTECTOR_STRONG: u32 = 1;
pub const CONFIG_PCI: u32 = 1;
pub const CONFIG_RTC_HCTOSYS_DEVICE: &[u8; 5usize] = b"rtc0\0";
pub const CONFIG_NET_VENDOR_FUNGIBLE: u32 = 1;
pub const CONFIG_CONTIG_ALLOC: u32 = 1;
pub const CONFIG_STACKDEPOT_MAX_FRAMES: u32 = 64;
pub const CONFIG_CRYPTO_XTS: u32 = 1;
pub const CONFIG_SENSORS_ZL6100_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RL6231_MODULE: u32 = 1;
pub const CONFIG_PWM: u32 = 1;
pub const CONFIG_BATTERY_DS2781_MODULE: u32 = 1;
pub const CONFIG_CHARGER_PCF50633_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_RECENT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PROBE_WORK_QUEUE: u32 = 1;
pub const CONFIG_NET_VENDOR_ASIX: u32 = 1;
pub const CONFIG_DECOMPRESS_XZ: u32 = 1;
pub const CONFIG_SERIAL_DEV_CTRL_TTYPORT: u32 = 1;
pub const CONFIG_PCI_QUIRKS: u32 = 1;
pub const CONFIG_BT_BCM_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_PKTTYPE_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_USNIC_MODULE: u32 = 1;
pub const CONFIG_MII_MODULE: u32 = 1;
pub const CONFIG_LEDS_IS31FL319X_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_TCA8418_MODULE: u32 = 1;
pub const CONFIG_MD_BITMAP_FILE: u32 = 1;
pub const CONFIG_SIGNALFD: u32 = 1;
pub const CONFIG_ADXL372_SPI_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8997_MODULE: u32 = 1;
pub const CONFIG_NET_CORE: u32 = 1;
pub const CONFIG_MOUSE_PS2_ALPS: u32 = 1;
pub const CONFIG_BPF_JIT_DEFAULT_ON: u32 = 1;
pub const CONFIG_PATA_PARPORT_ON26_MODULE: u32 = 1;
pub const CONFIG_KEXEC_CORE: u32 = 1;
pub const CONFIG_HAVE_UNSTABLE_SCHED_CLOCK: u32 = 1;
pub const CONFIG_EXT4_FS: u32 = 1;
pub const CONFIG_MAC80211_DEBUGFS: u32 = 1;
pub const CONFIG_NET_SCH_DRR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT298_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4151_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_802_3_MODULE: u32 = 1;
pub const CONFIG_DP83TC811_PHY_MODULE: u32 = 1;
pub const CONFIG_DELL_SMBIOS_SMM: u32 = 1;
pub const CONFIG_CPU5_WDT_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_VMWARE_PVRDMA_MODULE: u32 = 1;
pub const CONFIG_LCD_OTM3225A_MODULE: u32 = 1;
pub const CONFIG_MEMORY_BALLOON: u32 = 1;
pub const CONFIG_DMARD06_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_65XX_MODULE: u32 = 1;
pub const CONFIG_MMC_USDHI6ROL0_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_SPI: u32 = 1;
pub const CONFIG_UNINLINE_SPIN_UNLOCK: u32 = 1;
pub const CONFIG_VIDEO_CX88_BLACKBIRD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM512x_SPI_MODULE: u32 = 1;
pub const CONFIG_HAVE_HW_BREAKPOINT: u32 = 1;
pub const CONFIG_KRETPROBES: u32 = 1;
pub const CONFIG_SND_JACK_INPUT_DEV: u32 = 1;
pub const CONFIG_SCSI_MYRS_MODULE: u32 = 1;
pub const CONFIG_MTD_LPDDR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SHA1: u32 = 1;
pub const CONFIG_MFD_MT6397_MODULE: u32 = 1;
pub const CONFIG_GPIO_104_DIO_48E_MODULE: u32 = 1;
pub const CONFIG_HID_PENMOUNT_MODULE: u32 = 1;
pub const CONFIG_IPMI_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_MD_CLUSTER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DW9714_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_JOYDUMP_MODULE: u32 = 1;
pub const CONFIG_CPU_UNRET_ENTRY: u32 = 1;
pub const CONFIG_INFINIBAND_USER_ACCESS_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MT7530_MODULE: u32 = 1;
pub const CONFIG_VMWARE_VMCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AUDIO_IIO_AUX_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T4_DCB: u32 = 1;
pub const CONFIG_BPQETHER_MODULE: u32 = 1;
pub const CONFIG_USB_ADUTUX_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_NOKIA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_UDA1342_MODULE: u32 = 1;
pub const CONFIG_HSI_BOARDINFO: u32 = 1;
pub const CONFIG_KGDB_LOW_LEVEL_TRAP: u32 = 1;
pub const CONFIG_MT7601U_MODULE: u32 = 1;
pub const CONFIG_CAN_C_CAN_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_GENERAL_HUGETLB: u32 = 1;
pub const CONFIG_SENSORS_SMSC47M192_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_VITESSE_VSC73XX_SPI_MODULE: u32 = 1;
pub const CONFIG_ADT7316_SPI_MODULE: u32 = 1;
pub const CONFIG_SPS30_I2C_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_SSD1305_MODULE: u32 = 1;
pub const CONFIG_WIREGUARD_MODULE: u32 = 1;
pub const CONFIG_NLS_KOI8_U_MODULE: u32 = 1;
pub const CONFIG_RADIO_SHARK2_MODULE: u32 = 1;
pub const CONFIG_CRC8_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_ZONED: u32 = 1;
pub const CONFIG_NVIDIA_WMI_EC_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L51_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SCH5636_MODULE: u32 = 1;
pub const CONFIG_HAVE_SAMPLE_FTRACE_DIRECT: u32 = 1;
pub const CONFIG_PKCS7_TEST_KEY_MODULE: u32 = 1;
pub const CONFIG_USB_BELKIN: u32 = 1;
pub const CONFIG_NET_DSA_QCA8K_MODULE: u32 = 1;
pub const CONFIG_SATA_PMP: u32 = 1;
pub const CONFIG_XZ_DEC: u32 = 1;
pub const CONFIG_SMS_SIANO_DEBUGFS: u32 = 1;
pub const CONFIG_IPW2100_MONITOR: u32 = 1;
pub const CONFIG_QLA3XXX_MODULE: u32 = 1;
pub const CONFIG_BPF_LSM: u32 = 1;
pub const CONFIG_CAN_VCAN_MODULE: u32 = 1;
pub const CONFIG_DPTF_POWER_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_FIRMWARE_MODULE: u32 = 1;
pub const CONFIG_SPI_MICROCHIP_CORE_MODULE: u32 = 1;
pub const CONFIG_ATH_COMMON_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_TI: u32 = 1;
pub const CONFIG_CROS_EC_LPC_MODULE: u32 = 1;
pub const CONFIG_LOCKD_V4: u32 = 1;
pub const CONFIG_DRM_XE_DISPLAY: u32 = 1;
pub const CONFIG_SENSORS_LTC2945_MODULE: u32 = 1;
pub const CONFIG_DUMMY_MODULE: u32 = 1;
pub const CONFIG_EDAC_IGEN6_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK5558_MODULE: u32 = 1;
pub const CONFIG_DEV_DAX_HMEM_DEVICES: u32 = 1;
pub const CONFIG_MFD_MADERA_I2C_MODULE: u32 = 1;
pub const CONFIG_COMEDI_TESTS_NI_ROUTES_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_AMD_AXI_MODULE: u32 = 1;
pub const CONFIG_CODA_FS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_ICL_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2431_MODULE: u32 = 1;
pub const CONFIG_ADI_AXI_ADC_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ALACRITECH: u32 = 1;
pub const CONFIG_I2C_MUX_MLXCPLD_MODULE: u32 = 1;
pub const CONFIG_LEDS_LM3530_MODULE: u32 = 1;
pub const CONFIG_DVB_TUNER_CX24113_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_MARK_T_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_EMIF_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG: u32 = 1;
pub const CONFIG_BATTERY_MAX17042_MODULE: u32 = 1;
pub const CONFIG_SCSI_ADVANSYS_MODULE: u32 = 1;
pub const CONFIG_DVB_B2C2_FLEXCOP_PCI_MODULE: u32 = 1;
pub const CONFIG_INTEL_TCC_COOLING_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IR38064_MODULE: u32 = 1;
pub const CONFIG_MT7663_USB_SDIO_COMMON_MODULE: u32 = 1;
pub const CONFIG_HAS_IOMEM: u32 = 1;
pub const CONFIG_SND_RAWMIDI_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_ACPI_IBM_MODULE: u32 = 1;
pub const CONFIG_MFD_ARIZONA_SPI_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_IPV6_MODULE: u32 = 1;
pub const CONFIG_LRU_GEN_WALKS_MMU: u32 = 1;
pub const CONFIG_LTR390_MODULE: u32 = 1;
pub const CONFIG_MOST_SND_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_WIDECHIPS_WS2401_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_SOCKET_MODULE: u32 = 1;
pub const CONFIG_TRACING_MAP: u32 = 1;
pub const CONFIG_CRYPTO_RSA: u32 = 1;
pub const CONFIG_USB_GSPCA_STK1135_MODULE: u32 = 1;
pub const CONFIG_8139TOO_8129: u32 = 1;
pub const CONFIG_SND_HDA_INPUT_BEEP_MODE: u32 = 0;
pub const CONFIG_VIRT_DRIVERS: u32 = 1;
pub const CONFIG_VALIDATE_FS_PARSER: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5514_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4222_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_SPLIT_STARTUP: u32 = 1;
pub const CONFIG_COMEDI_PCL724_MODULE: u32 = 1;
pub const CONFIG_GPIO_LJCA_MODULE: u32 = 1;
pub const CONFIG_IP_VS_OVF_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_INTEL: u32 = 1;
pub const CONFIG_IIO_TIGHTLOOP_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_IR_FINTEK_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_PROBE: u32 = 1;
pub const CONFIG_ATH6KL_USB_MODULE: u32 = 1;
pub const CONFIG_FUSION_LOGGING: u32 = 1;
pub const CONFIG_ABP060MG_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_EEM_MODULE: u32 = 1;
pub const CONFIG_BRCM_TRACING: u32 = 1;
pub const CONFIG_USB_STORAGE_SDDR09_MODULE: u32 = 1;
pub const CONFIG_GPIO_EXAR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SIG2: u32 = 1;
pub const CONFIG_HYPERV_STORAGE_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_TTL_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MCS_MODULE: u32 = 1;
pub const CONFIG_ASYNC_RAID6_RECOV_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_STA32X_MODULE: u32 = 1;
pub const CONFIG_MENZ069_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_PCI_HYPERV_INTERFACE_MODULE: u32 = 1;
pub const CONFIG_HAVE_MOVE_PUD: u32 = 1;
pub const CONFIG_SI7020_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8782_MODULE: u32 = 1;
pub const CONFIG_VIDEOMODE_HELPERS: u32 = 1;
pub const CONFIG_NET_ACT_CTINFO_MODULE: u32 = 1;
pub const CONFIG_CEPH_FS_SECURITY_LABEL: u32 = 1;
pub const CONFIG_QCOM_EMAC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ACOMP2: u32 = 1;
pub const CONFIG_VHOST_TASK: u32 = 1;
pub const CONFIG_FB_TFT_SSD1289_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV4689_MODULE: u32 = 1;
pub const CONFIG_PWM_LPSS_PLATFORM: u32 = 1;
pub const CONFIG_EDD_OFF: u32 = 1;
pub const CONFIG_GART_IOMMU: u32 = 1;
pub const CONFIG_CHARGER_RT9455_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_MAX_TAGS: u32 = 64;
pub const CONFIG_FB_CARMINE_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MTK_PMIC_MODULE: u32 = 1;
pub const CONFIG_CW1200_WLAN_SPI_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_SW_BCH: u32 = 1;
pub const CONFIG_VIDEO_OV13858_MODULE: u32 = 1;
pub const CONFIG_NFTL_MODULE: u32 = 1;
pub const CONFIG_TI_ADS131E08_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ADC_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_MRP: u32 = 1;
pub const CONFIG_PCI_MMCONFIG: u32 = 1;
pub const CONFIG_VIDEO_OV08D10_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MCDI_LOGGING: u32 = 1;
pub const CONFIG_VSOCKMON_MODULE: u32 = 1;
pub const CONFIG_PM_TRACE: u32 = 1;
pub const CONFIG_SND_SOC_STA350_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV7251_MODULE: u32 = 1;
pub const CONFIG_SCSI_AM53C974_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TRACE_MODULE: u32 = 1;
pub const CONFIG_HVC_IRQ: u32 = 1;
pub const CONFIG_HAVE_ARCH_KASAN_VMALLOC: u32 = 1;
pub const CONFIG_IAQCORE_MODULE: u32 = 1;
pub const CONFIG_IWLWIFI_DEVICE_TRACING: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CHIPONE_ICN8505_MODULE: u32 = 1;
pub const CONFIG_ARCH_CONFIGURES_CPU_MITIGATIONS: u32 = 1;
pub const CONFIG_ACPI_NFIT_MODULE: u32 = 1;
pub const CONFIG_USB_GADGETFS_MODULE: u32 = 1;
pub const CONFIG_MFD_AAEON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8810_MODULE: u32 = 1;
pub const CONFIG_SND_RME32_MODULE: u32 = 1;
pub const CONFIG_PROC_KCORE: u32 = 1;
pub const CONFIG_RETPOLINE: u32 = 1;
pub const CONFIG_RTC_DRV_X1205_MODULE: u32 = 1;
pub const CONFIG_MTD_MAP_BANK_WIDTH_1: u32 = 1;
pub const CONFIG_LPC_ICH_MODULE: u32 = 1;
pub const CONFIG_NUMA: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_FRAG_MODULE: u32 = 1;
pub const CONFIG_ADMV1014_MODULE: u32 = 1;
pub const CONFIG_HDC100X_MODULE: u32 = 1;
pub const CONFIG_LEDS_MT6323_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_CYBERJACK_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_PRIO_MODULE: u32 = 1;
pub const CONFIG_ANDROID_BINDER_DEVICES: &[u8; 1usize] = b"\0";
pub const CONFIG_JSA1212_MODULE: u32 = 1;
pub const CONFIG_SCHED_HRTICK: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EXC3000_MODULE: u32 = 1;
pub const CONFIG_SATA_ULI_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_GVT: u32 = 1;
pub const CONFIG_DVB_DRXK_MODULE: u32 = 1;
pub const CONFIG_MMA7455_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_IUU_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GO7007_USB_S2250_BOARD_MODULE: u32 = 1;
pub const CONFIG_EPOLL: u32 = 1;
pub const CONFIG_FB_MATROX_G: u32 = 1;
pub const CONFIG_SCSI_AIC79XX_MODULE: u32 = 1;
pub const CONFIG_NET_IFE_MODULE: u32 = 1;
pub const CONFIG_RADIO_MAXIRADIO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LZO: u32 = 1;
pub const CONFIG_SND_PCM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_GSC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT711_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_CANNONLAKE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HS3001_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4458_MODULE: u32 = 1;
pub const CONFIG_TCM_USER2_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DEFAULT_BUF_MAXSIZE_KB: u32 = 20480;
pub const CONFIG_BRIDGE_EBT_SNAT_MODULE: u32 = 1;
pub const CONFIG_SATA_MOBILE_LPM_POLICY: u32 = 3;
pub const CONFIG_SURFACE_ACPI_NOTIFY_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_TRACKING_USER: u32 = 1;
pub const CONFIG_TCG_TIS_ST33ZP24_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_AU8820_MODULE: u32 = 1;
pub const CONFIG_APERTURE_HELPERS: u32 = 1;
pub const CONFIG_RAPIDIO: u32 = 1;
pub const CONFIG_INFINIBAND_OCRDMA_MODULE: u32 = 1;
pub const CONFIG_LTC2496_MODULE: u32 = 1;
pub const CONFIG_DA280_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_MIDI_EVENT_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_FS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES7134_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DT3155_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_AESNI_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_SDIO_UART_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_SPI_MODULE: u32 = 1;
pub const CONFIG_KVM_COMPAT: u32 = 1;
pub const CONFIG_PARTITION_ADVANCED: u32 = 1;
pub const CONFIG_FAILOVER: u32 = 1;
pub const CONFIG_EZX_PCAP: u32 = 1;
pub const CONFIG_SENSORS_SCH56XX_COMMON_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822BS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_DCCP_MODULE: u32 = 1;
pub const CONFIG_ICPLUS_PHY_MODULE: u32 = 1;
pub const CONFIG_CEC_CH7322_MODULE: u32 = 1;
pub const CONFIG_CGROUP_HUGETLB: u32 = 1;
pub const CONFIG_UNIXWARE_DISKLABEL: u32 = 1;
pub const CONFIG_UV_SYSFS_MODULE: u32 = 1;
pub const CONFIG_SCTP_DEFAULT_COOKIE_HMAC_SHA1: u32 = 1;
pub const CONFIG_USB_U_ETHER_MODULE: u32 = 1;
pub const CONFIG_X86_NUMACHIP: u32 = 1;
pub const CONFIG_COMEDI_USBDUXFAST_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LP872X_MODULE: u32 = 1;
pub const CONFIG_EXTCON_AXP288_MODULE: u32 = 1;
pub const CONFIG_BT_BNEP_MC_FILTER: u32 = 1;
pub const CONFIG_CRYPTO_CRC32_MODULE: u32 = 1;
pub const CONFIG_SCSI_ISCSI_ATTRS_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_DENALI_MODULE: u32 = 1;
pub const CONFIG_RUST_OVERFLOW_CHECKS: u32 = 1;
pub const CONFIG_USB_SERIAL_EMPEG_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MAX7359_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_RTRS_CLIENT_MODULE: u32 = 1;
pub const CONFIG_IR_SONY_DECODER_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_852_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_IDEALTEK: u32 = 1;
pub const CONFIG_VIDEO_PVRUSB2_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_KSZ_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_COMMENT_MODULE: u32 = 1;
pub const CONFIG_NFS_SWAP: u32 = 1;
pub const CONFIG_FB_SSD1307_MODULE: u32 = 1;
pub const CONFIG_USB_ISP116X_HCD_MODULE: u32 = 1;
pub const CONFIG_RANDOMIZE_KSTACK_OFFSET_DEFAULT: u32 = 1;
pub const CONFIG_GENERIC_PTDUMP: u32 = 1;
pub const CONFIG_AMD_WBRF: u32 = 1;
pub const CONFIG_I2C_ISCH_MODULE: u32 = 1;
pub const CONFIG_USB_NET_RNDIS_HOST_MODULE: u32 = 1;
pub const CONFIG_NET: u32 = 1;
pub const CONFIG_ATARI_PARTITION: u32 = 1;
pub const CONFIG_MS5611_I2C_MODULE: u32 = 1;
pub const CONFIG_MTD_SPI_NOR_SWP_DISABLE_ON_VOLATILE: u32 = 1;
pub const CONFIG_SQUASHFS_FILE_DIRECT: u32 = 1;
pub const CONFIG_USB_OHCI_HCD_PCI: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_NPCM_MODULE: u32 = 1;
pub const CONFIG_INPUT_EVDEV: u32 = 1;
pub const CONFIG_UNACCEPTED_MEMORY: u32 = 1;
pub const CONFIG_FS_ENCRYPTION_ALGS: u32 = 1;
pub const CONFIG_INTEL_ISH_FIRMWARE_DOWNLOADER_MODULE: u32 = 1;
pub const CONFIG_SND_JACK: u32 = 1;
pub const CONFIG_LEDS_SGM3140_MODULE: u32 = 1;
pub const CONFIG_AD5933_MODULE: u32 = 1;
pub const CONFIG_IDEAPAD_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_AUTO_VAR_INIT_PATTERN: u32 = 1;
pub const CONFIG_SECURITY_PATH: u32 = 1;
pub const CONFIG_SND_SOC_CX2072X_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_DA9062_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TCPMSS_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_SSD1351_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_DMA: u32 = 1;
pub const CONFIG_LIDAR_LITE_V2_MODULE: u32 = 1;
pub const CONFIG_BMP280_SPI_MODULE: u32 = 1;
pub const CONFIG_NCSI_OEM_CMD_GET_MAC: u32 = 1;
pub const CONFIG_ACPI_SLEEP: u32 = 1;
pub const CONFIG_REGULATOR_TPS65132_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_VIRTUAL_CONSUMER_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_DSCP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_WP512_MODULE: u32 = 1;
pub const CONFIG_CFAG12864B_RATE: u32 = 20;
pub const CONFIG_C2PORT_DURAMAR_2150_MODULE: u32 = 1;
pub const CONFIG_CHARLCD_BL_FLASH: u32 = 1;
pub const CONFIG_VIRTIO_DMA_SHARED_BUFFER_MODULE: u32 = 1;
pub const CONFIG_HID_DRAGONRISE_MODULE: u32 = 1;
pub const CONFIG_X86_ESPFIX64: u32 = 1;
pub const CONFIG_CRYPTO_LIB_BLAKE2S_GENERIC: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNTRACK_MODULE: u32 = 1;
pub const CONFIG_GPIO_RDC321X_MODULE: u32 = 1;
pub const CONFIG_SERIAL_KGDB_NMI: u32 = 1;
pub const CONFIG_COMEDI_ADQ12B_MODULE: u32 = 1;
pub const CONFIG_VIDEO_BT848_MODULE: u32 = 1;
pub const CONFIG_ITCO_WDT_MODULE: u32 = 1;
pub const CONFIG_AMD_XGBE_DCB: u32 = 1;
pub const CONFIG_COMEDI_NI_LABPC_MODULE: u32 = 1;
pub const CONFIG_IR_IGUANA_MODULE: u32 = 1;
pub const CONFIG_WANT_COMPAT_NETLINK_MESSAGES: u32 = 1;
pub const CONFIG_CHARGER_LP8788_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_RATEEST_MODULE: u32 = 1;
pub const CONFIG_SPI_LOOPBACK_TEST_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_USER_HELPER: u32 = 1;
pub const CONFIG_SND_ALOOP_MODULE: u32 = 1;
pub const CONFIG_ATH9K_STATION_STATISTICS: u32 = 1;
pub const CONFIG_USB_KBD_MODULE: u32 = 1;
pub const CONFIG_CAN_CTUCANFD_MODULE: u32 = 1;
pub const CONFIG_HPFS_FS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_APTINA_PLL_MODULE: u32 = 1;
pub const CONFIG_PINMUX: u32 = 1;
pub const CONFIG_USB_LD_MODULE: u32 = 1;
pub const CONFIG_LAN743X_MODULE: u32 = 1;
pub const CONFIG_MTD_GEN_PROBE_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_HW_PTE_YOUNG: u32 = 1;
pub const CONFIG_SCSI_UFS_BSG: u32 = 1;
pub const CONFIG_SENSORS_NPCM7XX_MODULE: u32 = 1;
pub const CONFIG_QUOTA_TREE_MODULE: u32 = 1;
pub const CONFIG_FB_VIA_MODULE: u32 = 1;
pub const CONFIG_CAIF_NETDEV_MODULE: u32 = 1;
pub const CONFIG_INPUT_PCSPKR_MODULE: u32 = 1;
pub const CONFIG_IRQ_DOMAIN_HIERARCHY: u32 = 1;
pub const CONFIG_HVC_XEN_FRONTEND: u32 = 1;
pub const CONFIG_ATA_FORCE: u32 = 1;
pub const CONFIG_NETFILTER_BPF_LINK: u32 = 1;
pub const CONFIG_FPROBE: u32 = 1;
pub const CONFIG_DVB_AV7110_OSD: u32 = 1;
pub const CONFIG_DRM_MIPI_DBI_MODULE: u32 = 1;
pub const CONFIG_SERIO_PCIPS2_MODULE: u32 = 1;
pub const CONFIG_MPILIB: u32 = 1;
pub const CONFIG_USB_NET_CDCETHER_MODULE: u32 = 1;
pub const CONFIG_MMA9551_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_PXRC_MODULE: u32 = 1;
pub const CONFIG_PACKET: u32 = 1;
pub const CONFIG_BCACHEFS_SIX_OPTIMISTIC_SPIN: u32 = 1;
pub const CONFIG_MODULE_SRCVERSION_ALL: u32 = 1;
pub const CONFIG_RTC_DRV_M48T86_MODULE: u32 = 1;
pub const CONFIG_XFRM_ALGO_MODULE: u32 = 1;
pub const CONFIG_SND_SIMPLE_CARD_UTILS_MODULE: u32 = 1;
pub const CONFIG_INTEL_SKL_INT3472_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_TIMESTAMP: u32 = 1;
pub const CONFIG_ST_UVIS25_I2C_MODULE: u32 = 1;
pub const CONFIG_SPI_AMD_MODULE: u32 = 1;
pub const CONFIG_RMI4_I2C_MODULE: u32 = 1;
pub const CONFIG_BLK_ICQ: u32 = 1;
pub const CONFIG_HAVE_CLK_PREPARE: u32 = 1;
pub const CONFIG_VIDEO_CX88_MPEG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AKCIPHER2: u32 = 1;
pub const CONFIG_TAHVO_USB_MODULE: u32 = 1;
pub const CONFIG_NODES_SHIFT: u32 = 10;
pub const CONFIG_MWIFIEX_SDIO_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_IPRANGE_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOATDMA_MODULE: u32 = 1;
pub const CONFIG_MANA_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_BASIC_MODULE: u32 = 1;
pub const CONFIG_FPROBE_EVENTS: u32 = 1;
pub const CONFIG_AXP288_ADC_MODULE: u32 = 1;
pub const CONFIG_HARDLOCKUP_DETECTOR_COUNTS_HRTIMER: u32 = 1;
pub const CONFIG_ASYMMETRIC_PUBLIC_KEY_SUBTYPE: u32 = 1;
pub const CONFIG_BACKLIGHT_LM3533_MODULE: u32 = 1;
pub const CONFIG_FB_IOMEM_FOPS: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2405_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_XENON_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_GENERIC_MODULE: u32 = 1;
pub const CONFIG_AD5764_MODULE: u32 = 1;
pub const CONFIG_I2C_TINY_USB_MODULE: u32 = 1;
pub const CONFIG_X86_ANDROID_TABLETS_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_PREEMPT_TIMEOUT: u32 = 640000;
pub const CONFIG_NETROM_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_PMD_MKWRITE: u32 = 1;
pub const CONFIG_MMC35240_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_EHL_RT5660_MACH_MODULE: u32 = 1;
pub const CONFIG_FUSION_SPI_MODULE: u32 = 1;
pub const CONFIG_BTRFS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_EROFS_FS_PCPU_KTHREAD: u32 = 1;
pub const CONFIG_SND_HDA_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_OV534_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_TCA6416_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT3000_MODULE: u32 = 1;
pub const CONFIG_HTS221_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_GL861_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_GVT_KVMGT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY_OSR: u32 = 1;
pub const CONFIG_IMA_APPRAISE: u32 = 1;
pub const CONFIG_ALTERA_MSGDMA_MODULE: u32 = 1;
pub const CONFIG_DUMMY_CONSOLE_ROWS: u32 = 25;
pub const CONFIG_PINCTRL_MCP23S08_SPI_MODULE: u32 = 1;
pub const CONFIG_MFD_ARIZONA_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC23_I2C_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_TFTP_MODULE: u32 = 1;
pub const CONFIG_NFS_V3_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX6902_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX8997: u32 = 1;
pub const CONFIG_PHY_TUSB1210_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ADV7604_CEC: u32 = 1;
pub const CONFIG_DVB_USB_ANYSEE_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_949_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24110_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP102_MODULE: u32 = 1;
pub const CONFIG_NOP_TRACER: u32 = 1;
pub const CONFIG_HAVE_KVM_PFNCACHE: u32 = 1;
pub const CONFIG_LOOPBACK_TARGET_MODULE: u32 = 1;
pub const CONFIG_ISL29020_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TSL2563_MODULE: u32 = 1;
pub const CONFIG_HID_CORSAIR_MODULE: u32 = 1;
pub const CONFIG_PWM_CRC: u32 = 1;
pub const CONFIG_SND_HDA_PATCH_LOADER: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP6x_MODULE: u32 = 1;
pub const CONFIG_XEN_XENBUS_FRONTEND: u32 = 1;
pub const CONFIG_INET: u32 = 1;
pub const CONFIG_CRYPTO_PCRYPT_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_PRESS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_CB_PCIMDDA_MODULE: u32 = 1;
pub const CONFIG_IP_ROUTE_VERBOSE: u32 = 1;
pub const CONFIG_XZ_DEC_POWERPC: u32 = 1;
pub const CONFIG_USB_MAX3421_HCD_MODULE: u32 = 1;
pub const CONFIG_DVB_RTL2832_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MT7530_MMIO_MODULE: u32 = 1;
pub const CONFIG_INTEL_PCH_THERMAL_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASUS_EC_MODULE: u32 = 1;
pub const CONFIG_MCTP_TRANSPORT_I3C_MODULE: u32 = 1;
pub const CONFIG_USB_MUSB_HDRC_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_NET: u32 = 1;
pub const CONFIG_MEMORY_NOTIFIER_ERROR_INJECT_MODULE: u32 = 1;
pub const CONFIG_PECI_CPU_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SIS_I2C_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_ADDRTYPE_MODULE: u32 = 1;
pub const CONFIG_MCP4728_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_HUAWEI: u32 = 1;
pub const CONFIG_PREVENT_FIRMWARE_BUILD: u32 = 1;
pub const CONFIG_SERIAL_8250_PNP: u32 = 1;
pub const CONFIG_USB_NET_MCS7830_MODULE: u32 = 1;
pub const CONFIG_VIDEOBUF2_DVB_MODULE: u32 = 1;
pub const CONFIG_RSI_COEX: u32 = 1;
pub const CONFIG_SND_ENS1371_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_MODULE: u32 = 1;
pub const CONFIG_FREEZER: u32 = 1;
pub const CONFIG_SENSORS_I5500_MODULE: u32 = 1;
pub const CONFIG_USB_F_SUBSET_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_NET_MODULE: u32 = 1;
pub const CONFIG_HAVE_HARDLOCKUP_DETECTOR_PERF: u32 = 1;
pub const CONFIG_COMEDI_ADV_PCI1724_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2413_MODULE: u32 = 1;
pub const CONFIG_USB_TEST_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MAX11801_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8737_MODULE: u32 = 1;
pub const CONFIG_ADAPTEC_STARFIRE_MODULE: u32 = 1;
pub const CONFIG_BT_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_TTY_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_BCM590XX_MODULE: u32 = 1;
pub const CONFIG_BT_HCIVHCI_MODULE: u32 = 1;
pub const CONFIG_INPUT_CM109_MODULE: u32 = 1;
pub const CONFIG_AXP288_FUEL_GAUGE_MODULE: u32 = 1;
pub const CONFIG_PCI_DOMAINS: u32 = 1;
pub const CONFIG_WWAN_HWSIM_MODULE: u32 = 1;
pub const CONFIG_MS5637_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_88PM800_MODULE: u32 = 1;
pub const CONFIG_NFT_QUEUE_MODULE: u32 = 1;
pub const CONFIG_LCD_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_MXL111SF_MODULE: u32 = 1;
pub const CONFIG_TPS6594_ESM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IT87_MODULE: u32 = 1;
pub const CONFIG_LPC_SCH_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_ACT: u32 = 1;
pub const CONFIG_MLX90614_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5682_I2C_MODULE: u32 = 1;
pub const CONFIG_HID_BIGBEN_FF_MODULE: u32 = 1;
pub const CONFIG_REED_SOLOMON_MODULE: u32 = 1;
pub const CONFIG_SCSI_FDOMAIN_MODULE: u32 = 1;
pub const CONFIG_CIFS_DFS_UPCALL: u32 = 1;
pub const CONFIG_NET_VENDOR_CHELSIO: u32 = 1;
pub const CONFIG_LZ4HC_COMPRESS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADL_PCI6208_MODULE: u32 = 1;
pub const CONFIG_HDLC_RAW_ETH_MODULE: u32 = 1;
pub const CONFIG_COMEDI_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_PMC_BXT_MODULE: u32 = 1;
pub const CONFIG_XEN_PV_MSR_SAFE: u32 = 1;
pub const CONFIG_PINCTRL_LEWISBURG_MODULE: u32 = 1;
pub const CONFIG_EFIVAR_FS: u32 = 1;
pub const CONFIG_BRIDGE_EBT_BROUTE_MODULE: u32 = 1;
pub const CONFIG_USB_NET_SMSC75XX_MODULE: u32 = 1;
pub const CONFIG_BE2NET_MODULE: u32 = 1;
pub const CONFIG_PARPORT_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_VMAP_STACK: u32 = 1;
pub const CONFIG_SND_SOC_AMD_MACH_COMMON_MODULE: u32 = 1;
pub const CONFIG_VORTEX_MODULE: u32 = 1;
pub const CONFIG_IPVTAP_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_DECTLK_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_IPVS_MODULE: u32 = 1;
pub const CONFIG_DEV_DAX_KMEM_MODULE: u32 = 1;
pub const CONFIG_TIPC_MEDIA_UDP: u32 = 1;
pub const CONFIG_VMWARE_VMCI_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_X86_DEBUGCTLMSR: u32 = 1;
pub const CONFIG_HDLC_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_BPF_MODULE: u32 = 1;
pub const CONFIG_ATM_SOLOS_MODULE: u32 = 1;
pub const CONFIG_8139TOO_PIO: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_GLK_DA7219_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_PREPEND_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_1_IMPLEMENTATION_ID_DOMAIN: &[u8; 11usize] = b"kernel.org\0";
pub const CONFIG_BT_LE_L2CAP_ECRED: u32 = 1;
pub const CONFIG_IP_SET_MAX: u32 = 256;
pub const CONFIG_HAPPYMEAL_MODULE: u32 = 1;
pub const CONFIG_HID_WACOM_MODULE: u32 = 1;
pub const CONFIG_USB_F_ACM_MODULE: u32 = 1;
pub const CONFIG_QLCNIC_DCB: u32 = 1;
pub const CONFIG_USB_SERIAL_CP210X_MODULE: u32 = 1;
pub const CONFIG_SND_PCMCIA: u32 = 1;
pub const CONFIG_HMM_MIRROR: u32 = 1;
pub const CONFIG_NET_SCH_SFQ_MODULE: u32 = 1;
pub const CONFIG_RTC_LIB: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_POWERSAVE: u32 = 1;
pub const CONFIG_FW_LOADER_PAGED_BUF: u32 = 1;
pub const CONFIG_NET_SCH_CBS_MODULE: u32 = 1;
pub const CONFIG_CHT_WC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_NVDIMM_DAX: u32 = 1;
pub const CONFIG_MFD_RT5120_MODULE: u32 = 1;
pub const CONFIG_X86_LOCAL_APIC: u32 = 1;
pub const CONFIG_ACER_WIRELESS_MODULE: u32 = 1;
pub const CONFIG_USB_GOKU_MODULE: u32 = 1;
pub const CONFIG_USB_UEAGLEATM_MODULE: u32 = 1;
pub const CONFIG_SPI_LANTIQ_SSC_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_POLICY_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADV_PCI1760_MODULE: u32 = 1;
pub const CONFIG_MWL8K_MODULE: u32 = 1;
pub const CONFIG_EFI_EMBEDDED_FIRMWARE: u32 = 1;
pub const CONFIG_HAVE_KPROBES: u32 = 1;
pub const CONFIG_NUMA_BALANCING_DEFAULT_ENABLED: u32 = 1;
pub const CONFIG_FB_TFT_AGM1264K_FL_MODULE: u32 = 1;
pub const CONFIG_SND_DESIGNWARE_PCM: u32 = 1;
pub const CONFIG_SENSORS_LTC2992_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_SYNAPTICS_SMBUS: u32 = 1;
pub const CONFIG_INTEL_TCC: u32 = 1;
pub const CONFIG_TPS65010_MODULE: u32 = 1;
pub const CONFIG_IP_ROUTE_CLASSID: u32 = 1;
pub const CONFIG_MOUSE_SYNAPTICS_I2C_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_TEE_MODULE: u32 = 1;
pub const CONFIG_SND_USB_VARIAX_MODULE: u32 = 1;
pub const CONFIG_HPWDT_NMI_DECODING: u32 = 1;
pub const CONFIG_ENC28J60_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_TOUCHKIT: u32 = 1;
pub const CONFIG_PWM_LP3943_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_XSENS_MT_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ITM: u32 = 1;
pub const CONFIG_X86_UMIP: u32 = 1;
pub const CONFIG_CRYPTO_AES: u32 = 1;
pub const CONFIG_HAVE_GENERIC_VDSO: u32 = 1;
pub const CONFIG_BACKLIGHT_LP855X_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB7000P_MODULE: u32 = 1;
pub const CONFIG_MLX5_EN_TLS: u32 = 1;
pub const CONFIG_GPIOLIB: u32 = 1;
pub const CONFIG_SSB_MODULE: u32 = 1;
pub const CONFIG_ZONE_DEVICE: u32 = 1;
pub const CONFIG_REGULATOR_ISL6271A_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_M10_BMC_CORE_MODULE: u32 = 1;
pub const CONFIG_FUTEX_PI: u32 = 1;
pub const CONFIG_SND_SOC_WM8961_MODULE: u32 = 1;
pub const CONFIG_FB_MATROX_I2C_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_MXIC_MODULE: u32 = 1;
pub const CONFIG_BMC150_ACCEL_SPI_MODULE: u32 = 1;
pub const CONFIG_I2C_STUB_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX8997_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SPI_AVMM_MODULE: u32 = 1;
pub const CONFIG_DM_BIO_PRISON_MODULE: u32 = 1;
pub const CONFIG_TMPFS_QUOTA: u32 = 1;
pub const CONFIG_INPUT_DRV2667_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CPU_VULNERABILITIES: u32 = 1;
pub const CONFIG_VIDEO_MT9T112_MODULE: u32 = 1;
pub const CONFIG_VIDEO_EM28XX_RC_MODULE: u32 = 1;
pub const CONFIG_NFT_LIMIT_MODULE: u32 = 1;
pub const CONFIG_DA_MON_EVENTS: u32 = 1;
pub const CONFIG_HAVE_ARCH_WITHIN_STACK_FRAMES: u32 = 1;
pub const CONFIG_RADIO_TEA5764_MODULE: u32 = 1;
pub const CONFIG_AQTION_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBH25_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MCP23S08_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA1528_MODULE: u32 = 1;
pub const CONFIG_LEDS_TLC591XX_MODULE: u32 = 1;
pub const CONFIG_FB_SVGALIB_MODULE: u32 = 1;
pub const CONFIG_BMC150_MAGN_MODULE: u32 = 1;
pub const CONFIG_TI_ADC128S052_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_KABYLAKE_MODULE: u32 = 1;
pub const CONFIG_MHI_WWAN_MBIM_MODULE: u32 = 1;
pub const CONFIG_MHI_BUS_PCI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_KEY_NOTIFICATIONS: u32 = 1;
pub const CONFIG_AD2S1210_MODULE: u32 = 1;
pub const CONFIG_HID_PID: u32 = 1;
pub const CONFIG_SND_SOC_RT700_SDW_MODULE: u32 = 1;
pub const CONFIG_NV_TCO_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_QT2_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_HIRSCHMANN_HELLCREEK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM179X_MODULE: u32 = 1;
pub const CONFIG_SMSC9420_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCI_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX6639_MODULE: u32 = 1;
pub const CONFIG_ATH11K_AHB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_NAU8825_MODULE: u32 = 1;
pub const CONFIG_CHT_DC_TI_PMIC_OPREGION: u32 = 1;
pub const CONFIG_AUTOFS_FS_MODULE: u32 = 1;
pub const CONFIG_SCD30_SERIAL_MODULE: u32 = 1;
pub const CONFIG_GAMEPORT_MODULE: u32 = 1;
pub const CONFIG_ISO9660_FS_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_CT_MODULE: u32 = 1;
pub const CONFIG_SKY2_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_NAT_MODULE: u32 = 1;
pub const CONFIG_AD7793_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_H4: u32 = 1;
pub const CONFIG_LEDS_NIC78BX_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_MIDI: u32 = 1;
pub const CONFIG_RTC_DRV_DS3232_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3168A_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MC13783_MODULE: u32 = 1;
pub const CONFIG_GPIO_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_PACKING: u32 = 1;
pub const CONFIG_CROS_KBD_LED_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_DMIC_MODULE: u32 = 1;
pub const CONFIG_SND_PCM_ELD: u32 = 1;
pub const CONFIG_XEN_WDT_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_M920X_MODULE: u32 = 1;
pub const CONFIG_MLX5_SW_STEERING: u32 = 1;
pub const CONFIG_UIO_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_TLS_DEVICE_MODULE: u32 = 1;
pub const CONFIG_NVMEM_RMEM_MODULE: u32 = 1;
pub const CONFIG_HID_WALTOP_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_LM3630A_MODULE: u32 = 1;
pub const CONFIG_ADIS16136_MODULE: u32 = 1;
pub const CONFIG_GPIO_RC5T583: u32 = 1;
pub const CONFIG_VIDEO_ADV7170_MODULE: u32 = 1;
pub const CONFIG_RTW89_8852CE_MODULE: u32 = 1;
pub const CONFIG_UIO_DMEM_GENIRQ_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS5086_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_AQUANTIA: u32 = 1;
pub const CONFIG_SCSI_VIRTIO: u32 = 1;
pub const CONFIG_NF_CONNTRACK_MARK: u32 = 1;
pub const CONFIG_IDLE_PAGE_TRACKING: u32 = 1;
pub const CONFIG_MAX5522_MODULE: u32 = 1;
pub const CONFIG_INTERVAL_TREE_SPAN_ITER: u32 = 1;
pub const CONFIG_HVC_DRIVER: u32 = 1;
pub const CONFIG_BLK_DEV_PCIESSD_MTIP32XX_MODULE: u32 = 1;
pub const CONFIG_NETFILTER: u32 = 1;
pub const CONFIG_NFT_REJECT_IPV4_MODULE: u32 = 1;
pub const CONFIG_RC_LOOPBACK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_SOUNDWIRE_LINK_BASELINE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_HASHLIMIT_MODULE: u32 = 1;
pub const CONFIG_MODULE_SIG: u32 = 1;
pub const CONFIG_BRIDGE_EBT_AMONG_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT2814_MODULE: u32 = 1;
pub const CONFIG_B53_MODULE: u32 = 1;
pub const CONFIG_ATH9K_WOW: u32 = 1;
pub const CONFIG_B43_PIO: u32 = 1;
pub const CONFIG_BACKLIGHT_88PM860X_MODULE: u32 = 1;
pub const CONFIG_B43_BUSES_BCMA_AND_SSB: u32 = 1;
pub const CONFIG_ADIS16201_MODULE: u32 = 1;
pub const CONFIG_USB_R8A66597_HCD_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TWL4030_MODULE: u32 = 1;
pub const CONFIG_X86_MSR_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KASAN: u32 = 1;
pub const CONFIG_LOCK_DOWN_IN_SECURE_BOOT: u32 = 1;
pub const CONFIG_MLX90635_MODULE: u32 = 1;
pub const CONFIG_BME680_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SMSC: u32 = 1;
pub const CONFIG_UACCE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_ACCT_MODULE: u32 = 1;
pub const CONFIG_LEDS_CHT_WCOVE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_8254_MODULE: u32 = 1;
pub const CONFIG_BOSCH_BNO055_I2C_MODULE: u32 = 1;
pub const CONFIG_NFS_DISABLE_UDP_SUPPORT: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CLUSTER_MODULE: u32 = 1;
pub const CONFIG_USB_KC2190: u32 = 1;
pub const CONFIG_R6040_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_EPATC8: u32 = 1;
pub const CONFIG_TOOLS_SUPPORT_RELR: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_I2C_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_COMPRESSION: u32 = 1;
pub const CONFIG_NET_DSA_TAG_NONE_MODULE: u32 = 1;
pub const CONFIG_NSM_MODULE: u32 = 1;
pub const CONFIG_USB_MDC800_MODULE: u32 = 1;
pub const CONFIG_GPIO_AMD_FCH_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_MODULE: u32 = 1;
pub const CONFIG_VIPERBOARD_ADC_MODULE: u32 = 1;
pub const CONFIG_HWMON_VID_MODULE: u32 = 1;
pub const CONFIG_SERIO_SERPORT_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ME4000_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_950_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0297_MODULE: u32 = 1;
pub const CONFIG_DVB_TTUSB_DEC_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_ONESHOT_MODULE: u32 = 1;
pub const CONFIG_HAVE_NMI: u32 = 1;
pub const CONFIG_DRM_SSD130X_MODULE: u32 = 1;
pub const CONFIG_LIRC: u32 = 1;
pub const CONFIG_INPUT_PWM_BEEPER_MODULE: u32 = 1;
pub const CONFIG_SCSI_AIC94XX_MODULE: u32 = 1;
pub const CONFIG_BT_BNEP_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_QFQ_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA826X_MODULE: u32 = 1;
pub const CONFIG_COMEDI_MPC624_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RAM_COUNT: u32 = 16;
pub const CONFIG_NFT_REJECT_NETDEV_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_RZN1_A5PSW_MODULE: u32 = 1;
pub const CONFIG_IXGBEVF_MODULE: u32 = 1;
pub const CONFIG_SND_AC97_POWER_SAVE_DEFAULT: u32 = 0;
pub const CONFIG_TABLET_SERIAL_WACOM4_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_DEBUGFACILITIES: u32 = 1;
pub const CONFIG_DVB_NGENE_MODULE: u32 = 1;
pub const CONFIG_RD_XZ: u32 = 1;
pub const CONFIG_AUXILIARY_BUS: u32 = 1;
pub const CONFIG_IP_MROUTE: u32 = 1;
pub const CONFIG_VIDEO_MXB_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_RCU: u32 = 1;
pub const CONFIG_SYSTEM_EXTRA_CERTIFICATE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC23_MODULE: u32 = 1;
pub const CONFIG_VGA_CONSOLE: u32 = 1;
pub const CONFIG_DEVFREQ_THERMAL: u32 = 1;
pub const CONFIG_CRYPTO_ECDH_MODULE: u32 = 1;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_WITH_REGS: u32 = 1;
pub const CONFIG_NET_ACT_TUNNEL_KEY_MODULE: u32 = 1;
pub const CONFIG_RPMSG_WWAN_CTRL_MODULE: u32 = 1;
pub const CONFIG_HID_RMI_MODULE: u32 = 1;
pub const CONFIG_USB_F_UAC1_LEGACY_MODULE: u32 = 1;
pub const CONFIG_ATA_VERBOSE_ERROR: u32 = 1;
pub const CONFIG_SENSORS_PECI_CPUTEMP_MODULE: u32 = 1;
pub const CONFIG_MT76_USB_MODULE: u32 = 1;
pub const CONFIG_XEN_BLKDEV_FRONTEND: u32 = 1;
pub const CONFIG_NF_CONNTRACK_SNMP_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_NIOS_INTEL_PAC_N3000_MODULE: u32 = 1;
pub const CONFIG_UEFI_CPER_X86: u32 = 1;
pub const CONFIG_CM3232_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_AUDIO_MODULE: u32 = 1;
pub const CONFIG_SND_DRIVERS: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_SIG_FORCE: u32 = 1;
pub const CONFIG_USB_SERIAL_BELKIN_MODULE: u32 = 1;
pub const CONFIG_X86_PLATFORM_DRIVERS_HP: u32 = 1;
pub const CONFIG_W1_MASTER_DS2490_MODULE: u32 = 1;
pub const CONFIG_SPI_INTEL_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2266_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_GREEK_MODULE: u32 = 1;
pub const CONFIG_NET_FLOW_LIMIT: u32 = 1;
pub const CONFIG_XFS_FS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DME1737_MODULE: u32 = 1;
pub const CONFIG_INPUT_KEYSPAN_REMOTE_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_PAC7302_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L92: u32 = 1;
pub const CONFIG_LOCKDEP_SUPPORT: u32 = 1;
pub const CONFIG_X86_MCE_INJECT_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ELO_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_869_MODULE: u32 = 1;
pub const CONFIG_SENSORS_NCT7904_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_MPLS_MODULE: u32 = 1;
pub const CONFIG_SND_AZT3328_MODULE: u32 = 1;
pub const CONFIG_VIDEO_ML86V7667_MODULE: u32 = 1;
pub const CONFIG_SND_AC97_POWER_SAVE: u32 = 1;
pub const CONFIG_NET_SCH_CAKE_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_MASQUERADE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PALMAS_MODULE: u32 = 1;
pub const CONFIG_NFT_REDIR_MODULE: u32 = 1;
pub const CONFIG_SATA_VIA_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCMMIO_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_VERIFY_ROOTHASH_SIG_SECONDARY_KEYRING: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CURVE25519_GENERIC_MODULE: u32 = 1;
pub const CONFIG_ACPI_PROCESSOR_IDLE: u32 = 1;
pub const CONFIG_ARCH_WANT_COMPAT_IPC_PARSE_VERSION: u32 = 1;
pub const CONFIG_NO_HZ: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC: u32 = 1;
pub const CONFIG_SND_SOC_RT1308_SDW_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_HUGE_PMD_SHARE: u32 = 1;
pub const CONFIG_BMI160_MODULE: u32 = 1;
pub const CONFIG_RTW88_8723DS_MODULE: u32 = 1;
pub const CONFIG_NFT_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320ADC3XXX_MODULE: u32 = 1;
pub const CONFIG_POSIX_MQUEUE: u32 = 1;
pub const CONFIG_CC_HAS_WORKING_NOSANITIZE_ADDRESS: u32 = 1;
pub const CONFIG_TI_LMP92064_MODULE: u32 = 1;
pub const CONFIG_NOUVEAU_DEBUG: u32 = 5;
pub const CONFIG_MLX5_FPGA: u32 = 1;
pub const CONFIG_NETFILTER_INGRESS: u32 = 1;
pub const CONFIG_CRYPTO_LIB_GF128MUL: u32 = 1;
pub const CONFIG_SND_SOC_TOPOLOGY: u32 = 1;
pub const CONFIG_REGULATOR_MAX20086_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TOUCHIT213_MODULE: u32 = 1;
pub const CONFIG_KVM_GENERIC_PRIVATE_MEM: u32 = 1;
pub const CONFIG_GPIO_MADERA_MODULE: u32 = 1;
pub const CONFIG_GPIO_DWAPB_MODULE: u32 = 1;
pub const CONFIG_LTC2632_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT6190_MODULE: u32 = 1;
pub const CONFIG_TRUSTED_KEYS_TPM: u32 = 1;
pub const CONFIG_VIDEO_THP7312_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANTS_DYNAMIC_TASK_STRUCT: u32 = 1;
pub const CONFIG_FB_PM2_FIFO_DISCONNECT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_STMFTS_MODULE: u32 = 1;
pub const CONFIG_GNSS_USB_MODULE: u32 = 1;
pub const CONFIG_SND_UMP_LEGACY_RAWMIDI: u32 = 1;
pub const CONFIG_SENSORS_LM83_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_MBIM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP108_MODULE: u32 = 1;
pub const CONFIG_MT76x0E_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_SID2STR_CACHE_SIZE: u32 = 256;
pub const CONFIG_VIDEO_MT9M114_MODULE: u32 = 1;
pub const CONFIG_ACENIC_MODULE: u32 = 1;
pub const CONFIG_ARCH_MIGHT_HAVE_PC_SERIO: u32 = 1;
pub const CONFIG_PSTORE_RAM_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCM3724_MODULE: u32 = 1;
pub const CONFIG_LEDS_BLINKM_MODULE: u32 = 1;
pub const CONFIG_INPUT_PWM_VIBRA_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_STAT: u32 = 1;
pub const CONFIG_JFS_STATISTICS: u32 = 1;
pub const CONFIG_COMEDI_NI_DAQ_700_CS_MODULE: u32 = 1;
pub const CONFIG_ISCSI_IBFT_MODULE: u32 = 1;
pub const CONFIG_NET_XGRESS: u32 = 1;
pub const CONFIG_DRM_AMD_DC_SI: u32 = 1;
pub const CONFIG_SPI_PXA2XX_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_SMC91C92_MODULE: u32 = 1;
pub const CONFIG_WILC1000_HW_OOB_INTR: u32 = 1;
pub const CONFIG_BT_HCIDTL1_MODULE: u32 = 1;
pub const CONFIG_TIFM_CORE_MODULE: u32 = 1;
pub const CONFIG_XEN_PRIVCMD_MODULE: u32 = 1;
pub const CONFIG_FXAS21002C_SPI_MODULE: u32 = 1;
pub const CONFIG_TI_ADS7924_MODULE: u32 = 1;
pub const CONFIG_GENERIC_STRNCPY_FROM_USER: u32 = 1;
pub const CONFIG_VIDEO_IMX296_MODULE: u32 = 1;
pub const CONFIG_FUSION_SAS_MODULE: u32 = 1;
pub const CONFIG_ADMV8818_MODULE: u32 = 1;
pub const CONFIG_MEDIA_PLATFORM_SUPPORT: u32 = 1;
pub const CONFIG_FB_TFT_SSD1331_MODULE: u32 = 1;
pub const CONFIG_MTD_BLKDEVS_MODULE: u32 = 1;
pub const CONFIG_GPIO_KEMPLD_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA10086_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_3W_XXXX_RAID_MODULE: u32 = 1;
pub const CONFIG_HAVE_RSEQ: u32 = 1;
pub const CONFIG_MEMSTICK_R592_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_MQPRIO_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SOUNDWIRE_MBQ_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NETMAP_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_EN_DCB: u32 = 1;
pub const CONFIG_DEV_DAX_CXL_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98088_MODULE: u32 = 1;
pub const CONFIG_CONTEXT_TRACKING_IDLE: u32 = 1;
pub const CONFIG_SENSORS_EMC2305_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ILITEK_MODULE: u32 = 1;
pub const CONFIG_HID_ELAN_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VPX3220_MODULE: u32 = 1;
pub const CONFIG_APDS9802ALS_MODULE: u32 = 1;
pub const CONFIG_DVB_NXT6000_MODULE: u32 = 1;
pub const CONFIG_SPMI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_NITROX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC4286: u32 = 1;
pub const CONFIG_MANTIS_CORE_MODULE: u32 = 1;
pub const CONFIG_PATA_MARVELL_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_AESNI_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_SCTP_MODULE: u32 = 1;
pub const CONFIG_GPIO_SIOX_MODULE: u32 = 1;
pub const CONFIG_SERIO_GPIO_PS2_MODULE: u32 = 1;
pub const CONFIG_SATA_SIL24_MODULE: u32 = 1;
pub const CONFIG_RTL8723BS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1318_SDW_MODULE: u32 = 1;
pub const CONFIG_SMS_SIANO_RC: u32 = 1;
pub const CONFIG_SND_SOC_CS42L52_MODULE: u32 = 1;
pub const CONFIG_CRASH_CORE: u32 = 1;
pub const CONFIG_ISL29125_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT298_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_DEC: u32 = 1;
pub const CONFIG_MDIO_CAVIUM_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_15_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_MAGNETOMETER_3D_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EETI_MODULE: u32 = 1;
pub const CONFIG_TIPC_CRYPTO: u32 = 1;
pub const CONFIG_USB_ROLES_INTEL_XHCI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_VIA686A_MODULE: u32 = 1;
pub const CONFIG_QRTR_MHI_MODULE: u32 = 1;
pub const CONFIG_INET6_ESP_MODULE: u32 = 1;
pub const CONFIG_EARLY_PRINTK_USB_XDBC: u32 = 1;
pub const CONFIG_QRTR_MODULE: u32 = 1;
pub const CONFIG_RV_REACT_PANIC: u32 = 1;
pub const CONFIG_IP_VS_WRR_MODULE: u32 = 1;
pub const CONFIG_PCI_DOE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_SVM: u32 = 1;
pub const CONFIG_NET_NSH_MODULE: u32 = 1;
pub const CONFIG_UCSI_CCG_MODULE: u32 = 1;
pub const CONFIG_ATH5K_MODULE: u32 = 1;
pub const CONFIG_VIDEO_FB_IVTV_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_HUB_MODULE: u32 = 1;
pub const CONFIG_ACPI_BUTTON: u32 = 1;
pub const CONFIG_LEDS_LM355x_MODULE: u32 = 1;
pub const CONFIG_ILLEGAL_POINTER_VALUE: i64 = -2401263026318606336;
pub const CONFIG_CRYPTO_DEV_CCP_CRYPTO_MODULE: u32 = 1;
pub const CONFIG_GENERIC_GETTIMEOFDAY: u32 = 1;
pub const CONFIG_UIO_NETX_MODULE: u32 = 1;
pub const CONFIG_CAN_MCP251XFD_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_SET_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_CROATIAN_MODULE: u32 = 1;
pub const CONFIG_SFC_MTD: u32 = 1;
pub const CONFIG_PCS_XPCS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98090_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_PCI_RENESAS_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_MEMTEST: u32 = 1;
pub const CONFIG_TASKSTATS: u32 = 1;
pub const CONFIG_EXTCON_GPIO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_LM3560_MODULE: u32 = 1;
pub const CONFIG_ARCNET_1201_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_932_MODULE: u32 = 1;
pub const CONFIG_MCB_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_MMIO_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRC32C_INTEL: u32 = 1;
pub const CONFIG_WILC1000_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_ICELAND_MODULE: u32 = 1;
pub const CONFIG_SND_ATMEL_SOC_MODULE: u32 = 1;
pub const CONFIG_MEDIA_SUBDRV_AUTOSELECT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC200X_CORE_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ECC_SW_HAMMING: u32 = 1;
pub const CONFIG_CAN_PLX_PCI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GS1662_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8940_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5677_SPI_MODULE: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_GENERIC: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYTCR_RT5651_MACH_MODULE: u32 = 1;
pub const CONFIG_JFS_POSIX_ACL: u32 = 1;
pub const CONFIG_PPPOE_HASH_BITS: u32 = 4;
pub const CONFIG_I2C_ALI1563_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_PENSANDO: u32 = 1;
pub const CONFIG_IP6_NF_FILTER_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_DESCRIPTOR_MODULE: u32 = 1;
pub const CONFIG_SYSTEM_DATA_VERIFICATION: u32 = 1;
pub const CONFIG_CRAMFS_MTD: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_SCREEN_X: u32 = 1024;
pub const CONFIG_MDIO_REGMAP_MODULE: u32 = 1;
pub const CONFIG_EFI_ESRT: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_LEGACY_COMMON_MODULE: u32 = 1;
pub const CONFIG_NEED_DMA_MAP_STATE: u32 = 1;
pub const CONFIG_FB_TFT_ILI9340_MODULE: u32 = 1;
pub const CONFIG_IIO_TRIGGERED_EVENT_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_G762_MODULE: u32 = 1;
pub const CONFIG_IIO_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_PREALLOC_SIZE: u32 = 0;
pub const CONFIG_GARP_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_AHA152X_MODULE: u32 = 1;
pub const CONFIG_INPUT_TWL6040_VIBRA_MODULE: u32 = 1;
pub const CONFIG_RT2500USB_MODULE: u32 = 1;
pub const CONFIG_YENTA_ENE_TUNE: u32 = 1;
pub const CONFIG_RCU_LAZY: u32 = 1;
pub const CONFIG_MOUSE_PS2_LIFEBOOK: u32 = 1;
pub const CONFIG_SERIO_LIBPS2: u32 = 1;
pub const CONFIG_MFD_SMPRO_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_DRBD_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_TCP: u32 = 1;
pub const CONFIG_QED_OOO: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ACPI_MODULE: u32 = 1;
pub const CONFIG_ISCSI_BOOT_SYSFS_MODULE: u32 = 1;
pub const CONFIG_X86_CPUID_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C3XXXVF_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_RED_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW8738_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_NFACCT_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SPRD_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNBYTES_MODULE: u32 = 1;
pub const CONFIG_KDB_CONTINUE_CATASTROPHIC: u32 = 0;
pub const CONFIG_F2FS_FS_LZ4HC: u32 = 1;
pub const CONFIG_REGULATOR_RT5739_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_METRO_MODULE: u32 = 1;
pub const CONFIG_USB_PRINTER_MODULE: u32 = 1;
pub const CONFIG_FONT_8x8: u32 = 1;
pub const CONFIG_SSB_SPROM: u32 = 1;
pub const CONFIG_ACPI_PCC: u32 = 1;
pub const CONFIG_UBUNTU_HOST_MODULE: u32 = 1;
pub const CONFIG_SOUNDWIRE_AMD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD938X_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_PAC207_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_RXS_GEN3_MODULE: u32 = 1;
pub const CONFIG_MITIGATION_SPECTRE_BHI: u32 = 1;
pub const CONFIG_VIDEO_RDACM20_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ATHEROS: u32 = 1;
pub const CONFIG_USB_SERIAL_IR_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PECI_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_BARO_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RTQ2208_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_EPIA_MODULE: u32 = 1;
pub const CONFIG_SKGE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT9812_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ACT8865_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4104_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT712_SDCA_DMIC_SDW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_HDA_DSP_COMMON_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA9055_ONKEY_MODULE: u32 = 1;
pub const CONFIG_TCM_PSCSI_MODULE: u32 = 1;
pub const CONFIG_RELOCATABLE: u32 = 1;
pub const CONFIG_DMARD10_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_POLY1305_MODULE: u32 = 1;
pub const CONFIG_QUEUED_SPINLOCKS: u32 = 1;
pub const CONFIG_XOR_BLOCKS_MODULE: u32 = 1;
pub const CONFIG_ADMV1013_MODULE: u32 = 1;
pub const CONFIG_AD8801_MODULE: u32 = 1;
pub const CONFIG_HID_TWINHAN_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_1_MIGRATION: u32 = 1;
pub const CONFIG_SENSORS_NTC_THERMISTOR_MODULE: u32 = 1;
pub const CONFIG_TIME_NS: u32 = 1;
pub const CONFIG_ADF4371_MODULE: u32 = 1;
pub const CONFIG_SPI_OC_TINY_MODULE: u32 = 1;
pub const CONFIG_AS3935_MODULE: u32 = 1;
pub const CONFIG_MISDN_L1OIP_MODULE: u32 = 1;
pub const CONFIG_DVB_PT1_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SUN: u32 = 1;
pub const CONFIG_DMIID: u32 = 1;
pub const CONFIG_AS_HAS_NON_CONST_ULEB128: u32 = 1;
pub const CONFIG_ARCH_HAS_MEM_ENCRYPT: u32 = 1;
pub const CONFIG_PANIC_TIMEOUT: u32 = 0;
pub const CONFIG_AMT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX20411_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DS1621_MODULE: u32 = 1;
pub const CONFIG_ASUS_WMI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMG_PARALLEL_OUT_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_OVS: u32 = 1;
pub const CONFIG_PC104: u32 = 1;
pub const CONFIG_USB_LGM_PHY_MODULE: u32 = 1;
pub const CONFIG_MMC_TOSHIBA_PCI_MODULE: u32 = 1;
pub const CONFIG_QUOTA_NETLINK_INTERFACE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BDW_RT5677_MACH_MODULE: u32 = 1;
pub const CONFIG_INPUT_JOYSTICK: u32 = 1;
pub const CONFIG_QNX4FS_FS_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_SIMP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_RM3100_I2C_MODULE: u32 = 1;
pub const CONFIG_PSE_REGULATOR_MODULE: u32 = 1;
pub const CONFIG_USB_OXU210HP_HCD_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_MODULE: u32 = 1;
pub const CONFIG_USB_DWC2: u32 = 1;
pub const CONFIG_HID_BATTERY_STRENGTH: u32 = 1;
pub const CONFIG_PM_GENERIC_DOMAINS_SLEEP: u32 = 1;
pub const CONFIG_YAM_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS28E17_MODULE: u32 = 1;
pub const CONFIG_MACB_PCI_MODULE: u32 = 1;
pub const CONFIG_DM_VERITY_MODULE: u32 = 1;
pub const CONFIG_BT_MTKUART_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_ECN_MODULE: u32 = 1;
pub const CONFIG_PRESTERA_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_STV0680_MODULE: u32 = 1;
pub const CONFIG_ARCH_MIGHT_HAVE_PC_PARPORT: u32 = 1;
pub const CONFIG_SYSTEM_BLACKLIST_HASH_LIST: &[u8; 1usize] = b"\0";
pub const CONFIG_RESET_TI_TPS380X_MODULE: u32 = 1;
pub const CONFIG_TYPEC_TCPM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1308_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_IDTCM_MODULE: u32 = 1;
pub const CONFIG_ATH9K_PCOEM: u32 = 1;
pub const CONFIG_SND_FM801_TEA575X_BOOL: u32 = 1;
pub const CONFIG_USB_STORAGE_SDDR55_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_SECCOMP: u32 = 1;
pub const CONFIG_PPDEV_MODULE: u32 = 1;
pub const CONFIG_KVM_AMD_SEV: u32 = 1;
pub const CONFIG_USB4_NET_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4271_SPI_MODULE: u32 = 1;
pub const CONFIG_SILICOM_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_BXT_WC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_SENSORS_TPS53679_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_S6D02A1_MODULE: u32 = 1;
pub const CONFIG_BCM_VK_MODULE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_TTL_MODULE: u32 = 1;
pub const CONFIG_AMILO_RFKILL_MODULE: u32 = 1;
pub const CONFIG_STACKDEPOT: u32 = 1;
pub const CONFIG_LWTUNNEL_BPF: u32 = 1;
pub const CONFIG_CFG80211_DEFAULT_PS: u32 = 1;
pub const CONFIG_SND_SOC_WM8974_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IOMAP: u32 = 1;
pub const CONFIG_IEEE802154_FAKELB_MODULE: u32 = 1;
pub const CONFIG_USBIP_HOST_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ24190_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WACOM_W8001_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_PRESS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADL_PCI7X3X_MODULE: u32 = 1;
pub const CONFIG_DVB_PLUTO2_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_XILINX: u32 = 1;
pub const CONFIG_SQUASHFS_MOUNT_DECOMP_THREADS: u32 = 1;
pub const CONFIG_COMEDI_NI_ROUTING_MODULE: u32 = 1;
pub const CONFIG_RTL8723AE_MODULE: u32 = 1;
pub const CONFIG_DECOMPRESS_LZ4: u32 = 1;
pub const CONFIG_SND_SOC_ADAU7002_MODULE: u32 = 1;
pub const CONFIG_THUNDER_NIC_RGX_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_OSF_MODULE: u32 = 1;
pub const CONFIG_XEN_FBDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV02A10_MODULE: u32 = 1;
pub const CONFIG_GPIO_DLN2_MODULE: u32 = 1;
pub const CONFIG_DVB_AV7110_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_SRH_MODULE: u32 = 1;
pub const CONFIG_DMI_SCAN_MACHINE_NON_EFI_FALLBACK: u32 = 1;
pub const CONFIG_DVB_OR51132_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_FIRMWARE: u32 = 1;
pub const CONFIG_DL2K_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MMS114_MODULE: u32 = 1;
pub const CONFIG_VIDEO_V4L2_I2C: u32 = 1;
pub const CONFIG_SXGBE_ETH_MODULE: u32 = 1;
pub const CONFIG_MUX_ADG792A_MODULE: u32 = 1;
pub const CONFIG_UBSAN_SHIFT: u32 = 1;
pub const CONFIG_BPF_SYSCALL: u32 = 1;
pub const CONFIG_SND_SOC_CS35L45_MODULE: u32 = 1;
pub const CONFIG_SMP: u32 = 1;
pub const CONFIG_NET_VENDOR_CADENCE: u32 = 1;
pub const CONFIG_FB_KYRO_MODULE: u32 = 1;
pub const CONFIG_DVB_ZL10353_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MICROSOFT: u32 = 1;
pub const CONFIG_MFD_INTEL_LPSS_ACPI_MODULE: u32 = 1;
pub const CONFIG_TTY: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_TIME_MODULE: u32 = 1;
pub const CONFIG_CXL_ACPI_MODULE: u32 = 1;
pub const CONFIG_IP_VS_MODULE: u32 = 1;
pub const CONFIG_HAVE_KERNEL_GZIP: u32 = 1;
pub const CONFIG_VCNL4035_MODULE: u32 = 1;
pub const CONFIG_TYPEC_TCPCI_MODULE: u32 = 1;
pub const CONFIG_MT76x02_USB_MODULE: u32 = 1;
pub const CONFIG_ZSMALLOC: u32 = 1;
pub const CONFIG_I2C_MLXCPLD_MODULE: u32 = 1;
pub const CONFIG_DM_UEVENT: u32 = 1;
pub const CONFIG_CAIF_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_USB_MV_UDC_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_I825XX: u32 = 1;
pub const CONFIG_MMA7660_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SEESAW_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT286_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_XUSBATM_MODULE: u32 = 1;
pub const CONFIG_AD7091R8_MODULE: u32 = 1;
pub const CONFIG_PNP: u32 = 1;
pub const CONFIG_INTEGRITY_MACHINE_KEYRING: u32 = 1;
pub const CONFIG_RTC_DRV_RP5C01_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_MAC_MODULE: u32 = 1;
pub const CONFIG_I2C_NFORCE2_S4985_MODULE: u32 = 1;
pub const CONFIG_MLX5_BRIDGE: u32 = 1;
pub const CONFIG_IOMMU_DMA: u32 = 1;
pub const CONFIG_LTRF216A_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5682_MODULE: u32 = 1;
pub const CONFIG_THUNDER_NIC_BGX_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI_ADMIN_LEGACY: u32 = 1;
pub const CONFIG_SENSORS_NCT6775_MODULE: u32 = 1;
pub const CONFIG_YELLOWFIN_MODULE: u32 = 1;
pub const CONFIG_RCU_EXP_CPU_STALL_TIMEOUT: u32 = 0;
pub const CONFIG_TOUCHSCREEN_TPS6507X_MODULE: u32 = 1;
pub const CONFIG_DW_DMAC_CORE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_DIO200_ISA_MODULE: u32 = 1;
pub const CONFIG_QED_ISCSI: u32 = 1;
pub const CONFIG_NET_ACT_PEDIT_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_QCOM_WLED_MODULE: u32 = 1;
pub const CONFIG_GPIO_TANGIER_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_NFLOG_MODULE: u32 = 1;
pub const CONFIG_VIDEO_BT819_MODULE: u32 = 1;
pub const CONFIG_DVB_ZD1301_DEMOD_MODULE: u32 = 1;
pub const CONFIG_DA9150_GPADC_MODULE: u32 = 1;
pub const CONFIG_XFRM_OFFLOAD: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_JASTEC: u32 = 1;
pub const CONFIG_GENERIC_ALLOCATOR: u32 = 1;
pub const CONFIG_OPENVSWITCH_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1390_MODULE: u32 = 1;
pub const CONFIG_L2TP_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_DA9052_MODULE: u32 = 1;
pub const CONFIG_DVB_B2C2_FLEXCOP_USB_MODULE: u32 = 1;
pub const CONFIG_IIO_GTS_HELPER_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_IO_ACCESSORS: u32 = 1;
pub const CONFIG_CRASH_MAX_MEMORY_RANGES: u32 = 8192;
pub const CONFIG_HAVE_DYNAMIC_FTRACE_WITH_DIRECT_CALLS: u32 = 1;
pub const CONFIG_FB_SYSMEM_HELPERS_DEFERRED: u32 = 1;
pub const CONFIG_TCP_CONG_WESTWOOD_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T93_MODULE: u32 = 1;
pub const CONFIG_KALLSYMS_ALL: u32 = 1;
pub const CONFIG_ATM_FORE200E_TX_RETRY: u32 = 16;
pub const CONFIG_HID_AUREAL_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA561_MODULE: u32 = 1;
pub const CONFIG_IPMI_SSIF_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_RENOIR_MODULE: u32 = 1;
pub const CONFIG_DRM_GM12U320_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_SDIO_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_LZ4: u32 = 1;
pub const CONFIG_DEBUG_INFO_BTF_MODULES: u32 = 1;
pub const CONFIG_DLN2_ADC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3168A_I2C_MODULE: u32 = 1;
pub const CONFIG_LIBCRC32C_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MATRIX_MODULE: u32 = 1;
pub const CONFIG_RSI_USB_MODULE: u32 = 1;
pub const CONFIG_HAVE_BOOTMEM_INFO_NODE: u32 = 1;
pub const CONFIG_MFD_PCF50633_MODULE: u32 = 1;
pub const CONFIG_GENERIC_BUG: u32 = 1;
pub const CONFIG_CRYPTO_SHA256: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_PDM_MODULE: u32 = 1;
pub const CONFIG_HAVE_FTRACE_MCOUNT_RECORD: u32 = 1;
pub const CONFIG_NET_DSA_MT7530_MDIO_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GUILLEMOT_MODULE: u32 = 1;
pub const CONFIG_MLXSW_MINIMAL_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_VLAN_FILTERING: u32 = 1;
pub const CONFIG_VIDEO_AU0828_MODULE: u32 = 1;
pub const CONFIG_WL18XX_MODULE: u32 = 1;
pub const CONFIG_POSIX_TIMERS: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_MODULE: u32 = 1;
pub const CONFIG_INET_TCP_DIAG_MODULE: u32 = 1;
pub const CONFIG_HID_SONY_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_CORE_SYNC_DEAD: u32 = 1;
pub const CONFIG_VIDEO_PVRUSB2_DVB: u32 = 1;
pub const CONFIG_USB_CDNSP_GADGET: u32 = 1;
pub const CONFIG_USB_F_PRINTER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88399_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_REALTEK_PCI_MODULE: u32 = 1;
pub const CONFIG_PCI_PASID: u32 = 1;
pub const CONFIG_CRYPTO_BLOWFISH_X86_64_MODULE: u32 = 1;
pub const CONFIG_HW_CONSOLE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_NITROX_CNN55XX_MODULE: u32 = 1;
pub const CONFIG_MDIO_BITBANG_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_IPT_MODULE: u32 = 1;
pub const CONFIG_ZSMALLOC_CHAIN_SIZE: u32 = 8;
pub const CONFIG_DVB_AS102_MODULE: u32 = 1;
pub const CONFIG_BPF_STREAM_PARSER: u32 = 1;
pub const CONFIG_HAVE_KVM_IRQ_ROUTING: u32 = 1;
pub const CONFIG_LEDS_MLXCPLD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98390_MODULE: u32 = 1;
pub const CONFIG_SCSI_BNX2X_FCOE_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_GLUEBI_MODULE: u32 = 1;
pub const CONFIG_RAS: u32 = 1;
pub const CONFIG_COMMON_CLK_CDCE706_MODULE: u32 = 1;
pub const CONFIG_AD5761_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GO7007_LOADER_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DA9052_MODULE: u32 = 1;
pub const CONFIG_USB_ETH_EEM: u32 = 1;
pub const CONFIG_KEYBOARD_TWL4030_MODULE: u32 = 1;
pub const CONFIG_HYPERV_NET_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SPMI_MODULE: u32 = 1;
pub const CONFIG_SMSC_PHY_MODULE: u32 = 1;
pub const CONFIG_DEVMEM: u32 = 1;
pub const CONFIG_BATTERY_MAX1721X_MODULE: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_INTROSPECT_POLICY: u32 = 1;
pub const CONFIG_HP_ACCEL_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_FOCALTECH: u32 = 1;
pub const CONFIG_CAN_EMS_PCI_MODULE: u32 = 1;
pub const CONFIG_X86_CET: u32 = 1;
pub const CONFIG_SCSI_BNX2_ISCSI_MODULE: u32 = 1;
pub const CONFIG_OMFS_FS_MODULE: u32 = 1;
pub const CONFIG_DRM_DP_CEC: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_NUVOTON_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_ZC3XX_MODULE: u32 = 1;
pub const CONFIG_SND_ES1968_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA1: u32 = 1;
pub const CONFIG_REGULATOR_DA9062_MODULE: u32 = 1;
pub const CONFIG_SND_SPI: u32 = 1;
pub const CONFIG_EUROTECH_WDT_MODULE: u32 = 1;
pub const CONFIG_I2C_DLN2_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_MODULE: u32 = 1;
pub const CONFIG_NFT_LOG_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_ADP8870_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MTOUCH_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_IP_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT6160_MODULE: u32 = 1;
pub const CONFIG_HID_MONTEREY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT1011_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_MICROCHIP_KSZ9477_I2C_MODULE: u32 = 1;
pub const CONFIG_CGROUP_RDMA: u32 = 1;
pub const CONFIG_FB_UDL_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_CYPRESS_M8_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES8328_SPI_MODULE: u32 = 1;
pub const CONFIG_FB_NEOMAGIC_MODULE: u32 = 1;
pub const CONFIG_I2C_NVIDIA_GPU_MODULE: u32 = 1;
pub const CONFIG_HID_EZKEY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKYLAKE_FAMILY_MODULE: u32 = 1;
pub const CONFIG_KVM_SMM: u32 = 1;
pub const CONFIG_PADATA: u32 = 1;
pub const CONFIG_USB_PULSE8_CEC_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_USER_SPACE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_DVB_S5H1409_MODULE: u32 = 1;
pub const CONFIG_IPW2200_QOS: u32 = 1;
pub const CONFIG_MDIO_BCM_UNIMAC_MODULE: u32 = 1;
pub const CONFIG_SCSI_LOWLEVEL_PCMCIA: u32 = 1;
pub const CONFIG_VDPA_SIM_NET_MODULE: u32 = 1;
pub const CONFIG_ATH9K_COMMON_DEBUG: u32 = 1;
pub const CONFIG_EFI_CAPSULE_LOADER_MODULE: u32 = 1;
pub const CONFIG_JFFS2_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_INPUT_DA9052_ONKEY_MODULE: u32 = 1;
pub const CONFIG_DM_THIN_PROVISIONING_MODULE: u32 = 1;
pub const CONFIG_SURFACE_HID_CORE_MODULE: u32 = 1;
pub const CONFIG_MFD_MT6370_MODULE: u32 = 1;
pub const CONFIG_IPMI_DMI_DECODE: u32 = 1;
pub const CONFIG_HAVE_UID16: u32 = 1;
pub const CONFIG_SERIAL_NONSTANDARD: u32 = 1;
pub const CONFIG_RT61PCI_MODULE: u32 = 1;
pub const CONFIG_COMPAT_OLD_SIGACTION: u32 = 1;
pub const CONFIG_SENSORS_TPS23861_MODULE: u32 = 1;
pub const CONFIG_PATA_JMICRON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98388_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2438_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC_SERIO_MODULE: u32 = 1;
pub const CONFIG_IRQ_MSI_IOMMU: u32 = 1;
pub const CONFIG_BMA400_SPI_MODULE: u32 = 1;
pub const CONFIG_RTC_NVMEM: u32 = 1;
pub const CONFIG_JOYSTICK_XPAD_LEDS: u32 = 1;
pub const CONFIG_PSE_CONTROLLER: u32 = 1;
pub const CONFIG_SENSORS_TC74_MODULE: u32 = 1;
pub const CONFIG_MMC_CRYPTO: u32 = 1;
pub const CONFIG_TINYDRM_ILI9486_MODULE: u32 = 1;
pub const CONFIG_IPW2100_MODULE: u32 = 1;
pub const CONFIG_SCSI_PPA_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_PWM_MODULE: u32 = 1;
pub const CONFIG_BT_MRVL_MODULE: u32 = 1;
pub const CONFIG_QUOTACTL: u32 = 1;
pub const CONFIG_RTC_DRV_RX8581_MODULE: u32 = 1;
pub const CONFIG_V4L2_MEM2MEM_DEV_MODULE: u32 = 1;
pub const CONFIG_SENSORS_XDPE122_REGULATOR: u32 = 1;
pub const CONFIG_FB_SAVAGE_I2C: u32 = 1;
pub const CONFIG_PARAVIRT: u32 = 1;
pub const CONFIG_TWL4030_MADC_MODULE: u32 = 1;
pub const CONFIG_WQ_POWER_EFFICIENT_DEFAULT: u32 = 1;
pub const CONFIG_NLS_UCS2_UTILS_MODULE: u32 = 1;
pub const CONFIG_HP03_MODULE: u32 = 1;
pub const CONFIG_SFC_FALCON_MTD: u32 = 1;
pub const CONFIG_VCAP: u32 = 1;
pub const CONFIG_CRYPTO_CRYPTD_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_JASPERLAKE_MODULE: u32 = 1;
pub const CONFIG_LEGACY_VSYSCALL_XONLY: u32 = 1;
pub const CONFIG_ZSTD_COMMON: u32 = 1;
pub const CONFIG_NF_SOCKET_IPV4_MODULE: u32 = 1;
pub const CONFIG_BCACHEFS_FS_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_VITESSE_VSC73XX_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_FSIA6B_MODULE: u32 = 1;
pub const CONFIG_HAVE_IOREMAP_PROT: u32 = 1;
pub const CONFIG_CRYPTO_CHACHA20_X86_64_MODULE: u32 = 1;
pub const CONFIG_SND_PCMTEST_MODULE: u32 = 1;
pub const CONFIG_PHY_CPCAP_USB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8821_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_KASAN_GENERIC: u32 = 1;
pub const CONFIG_SENSORS_MAX15301_MODULE: u32 = 1;
pub const CONFIG_CM32181_MODULE: u32 = 1;
pub const CONFIG_DVB_STV6111_MODULE: u32 = 1;
pub const CONFIG_USBIP_VHCI_HCD_MODULE: u32 = 1;
pub const CONFIG_PATA_RZ1000_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_ADP8860_MODULE: u32 = 1;
pub const CONFIG_MAX8925_POWER_MODULE: u32 = 1;
pub const CONFIG_CAPI_TRACE: u32 = 1;
pub const CONFIG_DEBUG_KERNEL: u32 = 1;
pub const CONFIG_MTD_RAM_MODULE: u32 = 1;
pub const CONFIG_RTL8192DE_MODULE: u32 = 1;
pub const CONFIG_ACPI_TOSHIBA_MODULE: u32 = 1;
pub const CONFIG_INV_MPU6050_IIO_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_F8153X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6311_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2978_REGULATOR: u32 = 1;
pub const CONFIG_HID_GOOGLE_HAMMER_MODULE: u32 = 1;
pub const CONFIG_DM_ZONED_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TC654_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX2341X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MP2975_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_I2C_VIPERBOARD_MODULE: u32 = 1;
pub const CONFIG_CHARLCD_MODULE: u32 = 1;
pub const CONFIG_LOCALVERSION: &[u8; 1usize] = b"\0";
pub const CONFIG_FS_STACK: u32 = 1;
pub const CONFIG_REISERFS_FS_SECURITY: u32 = 1;
pub const CONFIG_DVB_STV6110x_MODULE: u32 = 1;
pub const CONFIG_PATA_IT821X_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_EFFECTIVE_AFF_MASK: u32 = 1;
pub const CONFIG_ACERHDF_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_PAGE_TABLE_CHECK: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BROADWELL_MACH_MODULE: u32 = 1;
pub const CONFIG_RADIO_ADAPTERS_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_QCOM_SPMI_MODULE: u32 = 1;
pub const CONFIG_MEMTEST: u32 = 1;
pub const CONFIG_KEYBOARD_XTKBD_MODULE: u32 = 1;
pub const CONFIG_HAVE_PCSPKR_PLATFORM: u32 = 1;
pub const CONFIG_NFS_FSCACHE: u32 = 1;
pub const CONFIG_PINCTRL_EMMITSBURG_MODULE: u32 = 1;
pub const CONFIG_MAC80211_MESH: u32 = 1;
pub const CONFIG_MMC_WBSD_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_TOPRO_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_MARS_MODULE: u32 = 1;
pub const CONFIG_CAN_RAW_MODULE: u32 = 1;
pub const CONFIG_SYMBOLIC_ERRNAME: u32 = 1;
pub const CONFIG_DRM_XE_PREEMPT_TIMEOUT_MAX: u32 = 10000000;
pub const CONFIG_AD5686_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_SI2165_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_CDEV_MODULE: u32 = 1;
pub const CONFIG_CRYPTO: u32 = 1;
pub const CONFIG_SURFACE_HOTPLUG_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_PCA954x_MODULE: u32 = 1;
pub const CONFIG_FB_MATROX_MILLENIUM: u32 = 1;
pub const CONFIG_SENSORS_EMC6W201_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_TRACER: u32 = 1;
pub const CONFIG_NET_DSA_TAG_AR9331_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CPU_DEVICES: u32 = 1;
pub const CONFIG_CRYPTO_NHPOLY1305_AVX2_MODULE: u32 = 1;
pub const CONFIG_USB_TRANCEVIBRATOR_MODULE: u32 = 1;
pub const CONFIG_SCHED_DEBUG: u32 = 1;
pub const CONFIG_GPIO_REGMAP_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SMACK_APPEND_SIGNALS: u32 = 1;
pub const CONFIG_NET_VENDOR_BROCADE: u32 = 1;
pub const CONFIG_BTRFS_FS_MODULE: u32 = 1;
pub const CONFIG_OPT4001_MODULE: u32 = 1;
pub const CONFIG_BLK_WBT_MQ: u32 = 1;
pub const CONFIG_DEFAULT_MMAP_MIN_ADDR: u32 = 65536;
pub const CONFIG_SYSTEM_TRUSTED_KEYS: &[u8; 27usize] = b"debian/canonical-certs.pem\0";
pub const CONFIG_MAX11205_MODULE: u32 = 1;
pub const CONFIG_SND_USB_6FIRE_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_INTEL_UNCORE: u32 = 1;
pub const CONFIG_SND_HDA_HWDEP: u32 = 1;
pub const CONFIG_INPUT_AD714X_I2C_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_BU21029_MODULE: u32 = 1;
pub const CONFIG_I2C_SIS96X_MODULE: u32 = 1;
pub const CONFIG_INET_RAW_DIAG_MODULE: u32 = 1;
pub const CONFIG_MMC_TIFM_SD_MODULE: u32 = 1;
pub const CONFIG_GFS2_FS_LOCKING_DLM: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18218_MODULE: u32 = 1;
pub const CONFIG_PRESTERA_PCI_MODULE: u32 = 1;
pub const CONFIG_IP_NF_IPTABLES_MODULE: u32 = 1;
pub const CONFIG_ZPA2326_SPI_MODULE: u32 = 1;
pub const CONFIG_MISC_RTSX_USB_MODULE: u32 = 1;
pub const CONFIG_LEDS_LP50XX_MODULE: u32 = 1;
pub const CONFIG_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_GPIO_F7188X_MODULE: u32 = 1;
pub const CONFIG_BT_BNEP_PROTO_FILTER: u32 = 1;
pub const CONFIG_SENSORS_DRIVETEMP_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE_WITH_REGS: u32 = 1;
pub const CONFIG_NTB_SWITCHTEC_MODULE: u32 = 1;
pub const CONFIG_PCIE_PTM: u32 = 1;
pub const CONFIG_IWLWIFI_LEDS: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_HOST: u32 = 1;
pub const CONFIG_MFD_RETU_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_QLOGIC: u32 = 1;
pub const CONFIG_SPI_GPIO_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_CPIA1_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L42_MODULE: u32 = 1;
pub const CONFIG_HSI_CHAR_MODULE: u32 = 1;
pub const CONFIG_HID_LETSKETCH_MODULE: u32 = 1;
pub const CONFIG_GCC10_NO_ARRAY_BOUNDS: u32 = 1;
pub const CONFIG_RUNTIME_TESTING_MENU: u32 = 1;
pub const CONFIG_MPLS_IPTUNNEL_MODULE: u32 = 1;
pub const CONFIG_VIDEOBUF2_DMA_CONTIG_MODULE: u32 = 1;
pub const CONFIG_TSNEP_MODULE: u32 = 1;
pub const CONFIG_USB_XHCI_HCD: u32 = 1;
pub const CONFIG_VIRTIO: u32 = 1;
pub const CONFIG_REGULATOR_TPS65910_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_RTL8_4_MODULE: u32 = 1;
pub const CONFIG_DEFAULT_CUBIC: u32 = 1;
pub const CONFIG_CAN_KVASER_PCI_MODULE: u32 = 1;
pub const CONFIG_YENTA_TI: u32 = 1;
pub const CONFIG_COMEDI_NI_660X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L32_MODULE: u32 = 1;
pub const CONFIG_MFD_SM501_MODULE: u32 = 1;
pub const CONFIG_AD7606_MODULE: u32 = 1;
pub const CONFIG_HID_SAMSUNG_MODULE: u32 = 1;
pub const CONFIG_SPI_XCOMM_MODULE: u32 = 1;
pub const CONFIG_SFC_MCDI_LOGGING: u32 = 1;
pub const CONFIG_PARMAN_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ZINITIX_MODULE: u32 = 1;
pub const CONFIG_IP_SET_LIST_SET_MODULE: u32 = 1;
pub const CONFIG_TCM_IBLOCK_MODULE: u32 = 1;
pub const CONFIG_IP_PIMSM_V2: u32 = 1;
pub const CONFIG_BACKLIGHT_ARCXCNN_MODULE: u32 = 1;
pub const CONFIG_CFS_BANDWIDTH: u32 = 1;
pub const CONFIG_MCP3911_MODULE: u32 = 1;
pub const CONFIG_WM831X_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_RTW88_MODULE: u32 = 1;
pub const CONFIG_NET_SELFTESTS: u32 = 1;
pub const CONFIG_MUX_GPIO_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_TRAILER_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CA0132_DSP: u32 = 1;
pub const CONFIG_XFRM_STATISTICS: u32 = 1;
pub const CONFIG_GPIO_GENERIC_PLATFORM: u32 = 1;
pub const CONFIG_X86_MCE_THRESHOLD: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HIMAX_HX83112B_MODULE: u32 = 1;
pub const CONFIG_MTD_SCB2_FLASH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW2804_MODULE: u32 = 1;
pub const CONFIG_VIA_RHINE_MMIO: u32 = 1;
pub const CONFIG_SMB_SERVER_SMBDIRECT: u32 = 1;
pub const CONFIG_USB_ISIGHTFW_MODULE: u32 = 1;
pub const CONFIG_JME_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CPU_CACHE_INVALIDATE_MEMREGION: u32 = 1;
pub const CONFIG_RTW88_SDIO_MODULE: u32 = 1;
pub const CONFIG_GP2AP002_MODULE: u32 = 1;
pub const CONFIG_USB_LINK_LAYER_TEST_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CMEDIA_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_SAMPLE_MODULE: u32 = 1;
pub const CONFIG_NFC_TRF7970A_MODULE: u32 = 1;
pub const CONFIG_DMA_VIRTUAL_CHANNELS: u32 = 1;
pub const CONFIG_SCSI_WD719X_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_COMPRESSOR_DEFAULT: &[u8; 4usize] = b"lzo\0";
pub const CONFIG_DVB_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_YENTA_O2: u32 = 1;
pub const CONFIG_SPS30_SERIAL_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_HRTIMER_DEFAULT: u32 = 1;
pub const CONFIG_USB_ARCH_HAS_HCD: u32 = 1;
pub const CONFIG_DVB_DIB3000MC_MODULE: u32 = 1;
pub const CONFIG_CACHEFILES_MODULE: u32 = 1;
pub const CONFIG_DVB_MXL5XX_MODULE: u32 = 1;
pub const CONFIG_STRICT_DEVMEM: u32 = 1;
pub const CONFIG_PATA_OLDPIIX_MODULE: u32 = 1;
pub const CONFIG_I2C_KEMPLD_MODULE: u32 = 1;
pub const CONFIG_NET_REDIRECT: u32 = 1;
pub const CONFIG_GENERIC_IRQ_SHOW: u32 = 1;
pub const CONFIG_CRYPTO_POLYVAL_CLMUL_NI_MODULE: u32 = 1;
pub const CONFIG_CXL_PMU_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_REPAPER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PLI1209BC_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_SI3054_MODULE: u32 = 1;
pub const CONFIG_FXOS8700_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_PCF50633_MODULE: u32 = 1;
pub const CONFIG_LCD_ILI9320_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ25980_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX8925: u32 = 1;
pub const CONFIG_NVMEM_SYSFS: u32 = 1;
pub const CONFIG_HAVE_ARCH_JUMP_LABEL_RELATIVE: u32 = 1;
pub const CONFIG_NFC_MICROREAD_I2C_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ELF_RANDOMIZE: u32 = 1;
pub const CONFIG_9P_FS_MODULE: u32 = 1;
pub const CONFIG_NETFS_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_ARG_ACCESS_API: u32 = 1;
pub const CONFIG_MD_AUTODETECT: u32 = 1;
pub const CONFIG_ASUS_WIRELESS_MODULE: u32 = 1;
pub const CONFIG_AD7766_MODULE: u32 = 1;
pub const CONFIG_PANIC_ON_OOPS_VALUE: u32 = 0;
pub const CONFIG_JOYSTICK_A3D_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SAMSUNG: u32 = 1;
pub const CONFIG_SND_SOC_CS4270_MODULE: u32 = 1;
pub const CONFIG_PLDMFW: u32 = 1;
pub const CONFIG_SENSORS_ATK0110_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ADI: u32 = 1;
pub const CONFIG_IIO_MS_SENSORS_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_FB_VIA_X_COMPATIBILITY: u32 = 1;
pub const CONFIG_ZRAM_DEF_COMP: &[u8; 8usize] = b"lzo-rle\0";
pub const CONFIG_REMOTEPROC_CDEV: u32 = 1;
pub const CONFIG_SFC_SRIOV: u32 = 1;
pub const CONFIG_RTW89_PCI_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SCCNXP: u32 = 1;
pub const CONFIG_TCP_CONG_HSTCP_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_MSG2638_MODULE: u32 = 1;
pub const CONFIG_INITRAMFS_PRESERVE_MTIME: u32 = 1;
pub const CONFIG_BATTERY_BQ27XXX_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI_MOD: u32 = 1;
pub const CONFIG_SCSI_SMARTPQI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ATMEL_MXT_T37: u32 = 1;
pub const CONFIG_SND_SOC_SSM2602_MODULE: u32 = 1;
pub const CONFIG_INPUT_88PM860X_ONKEY_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_BATT_F7188X_MODULE: u32 = 1;
pub const CONFIG_I2C_CROS_EC_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MICREL: u32 = 1;
pub const CONFIG_CRYPTO_ESSIV_MODULE: u32 = 1;
pub const CONFIG_FB_PM2_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_UPD161704_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L15: u32 = 1;
pub const CONFIG_MPLS_ROUTING_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MODULE: u32 = 1;
pub const CONFIG_F2FS_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_VIDEOBUF2_DMA_SG_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ADD_PAGES: u32 = 1;
pub const CONFIG_JOYSTICK_ZHENHUA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_STPDDC60_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_HOOK_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_IPSEC_INLINE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SPCP8X5_MODULE: u32 = 1;
pub const CONFIG_BT_HCIRSI_MODULE: u32 = 1;
pub const CONFIG_KEYS_REQUEST_CACHE: u32 = 1;
pub const CONFIG_WILC1000_SDIO_MODULE: u32 = 1;
pub const CONFIG_MAX5481_MODULE: u32 = 1;
pub const CONFIG_HID_ITE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK5386_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP4_I2C_MODULE: u32 = 1;
pub const CONFIG_INTEL_QEP_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_PROX_MODULE: u32 = 1;
pub const CONFIG_IOMMU_DEFAULT_DMA_LAZY: u32 = 1;
pub const CONFIG_RC_DECODERS: u32 = 1;
pub const CONFIG_B43_LEDS: u32 = 1;
pub const CONFIG_UBIFS_FS_XATTR: u32 = 1;
pub const CONFIG_P54_USB_MODULE: u32 = 1;
pub const CONFIG_GPIO_AGGREGATOR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ECRDSA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV01A10_MODULE: u32 = 1;
pub const CONFIG_FB_ATY_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_CYTTSP4_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_KINECT_MODULE: u32 = 1;
pub const CONFIG_NET_9P_XEN_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_DECEXT_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_WISHBONE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DAQBOARD2000_MODULE: u32 = 1;
pub const CONFIG_TPS68470_PMIC_OPREGION: u32 = 1;
pub const CONFIG_IOMMUFD_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_PINEPHONE_MODULE: u32 = 1;
pub const CONFIG_LEDS_CLASS_FLASH_MODULE: u32 = 1;
pub const CONFIG_USB_NET_HUAWEI_CDC_NCM_MODULE: u32 = 1;
pub const CONFIG_SCSI_ESAS2R_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_BEAGLEPLAY_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9V111_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CML_LP_DA7219_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX25821_ALSA_MODULE: u32 = 1;
pub const CONFIG_GPIO_PISOSR_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CRC32C: u32 = 1;
pub const CONFIG_SERIAL_CORE: u32 = 1;
pub const CONFIG_IIO_ST_SENSORS_I2C_MODULE: u32 = 1;
pub const CONFIG_FUSE_FS: u32 = 1;
pub const CONFIG_HID_SENSOR_HUMIDITY_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_IQS62X_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_SERIAL: u32 = 1;
pub const CONFIG_UID16: u32 = 1;
pub const CONFIG_DW_DMAC_MODULE: u32 = 1;
pub const CONFIG_ETHOC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ACPI_DEV_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM512x_MODULE: u32 = 1;
pub const CONFIG_ACPI_HED: u32 = 1;
pub const CONFIG_HID_MICROSOFT_MODULE: u32 = 1;
pub const CONFIG_EXFAT_DEFAULT_IOCHARSET: &[u8; 5usize] = b"utf8\0";
pub const CONFIG_RTLLIB_MODULE: u32 = 1;
pub const CONFIG_LIVEPATCH: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYT_CHT_ES8316_MACH_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_DIRTY_RING: u32 = 1;
pub const CONFIG_PCC: u32 = 1;
pub const CONFIG_RTC_DRV_S35390A_MODULE: u32 = 1;
pub const CONFIG_HAVE_KRETPROBES: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_JUMP: u32 = 1;
pub const CONFIG_SYSTEM_EXTRA_CERTIFICATE_SIZE: u32 = 4096;
pub const CONFIG_HYPERV_BALLOON_MODULE: u32 = 1;
pub const CONFIG_SCSI_IMM_MODULE: u32 = 1;
pub const CONFIG_OBJTOOL: u32 = 1;
pub const CONFIG_SENSORS_LM25066_MODULE: u32 = 1;
pub const CONFIG_ASSOCIATIVE_ARRAY: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UVC: u32 = 1;
pub const CONFIG_HSA_AMD: u32 = 1;
pub const CONFIG_AGP_VIA: u32 = 1;
pub const CONFIG_SND_SOC_RT5659_MODULE: u32 = 1;
pub const CONFIG_NF_DEFRAG_IPV6_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_CONEX_MODULE: u32 = 1;
pub const CONFIG_MICREL_PHY_MODULE: u32 = 1;
pub const CONFIG_DRM_LOAD_EDID_FIRMWARE: u32 = 1;
pub const CONFIG_VIDEO_DEV_MODULE: u32 = 1;
pub const CONFIG_SIEMENS_SIMATIC_IPC_WDT_MODULE: u32 = 1;
pub const CONFIG_KS0108_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_AUDMIX_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ZERO_CALL_USED_REGS: u32 = 1;
pub const CONFIG_CXL_MEM_MODULE: u32 = 1;
pub const CONFIG_NFS_V4_MODULE: u32 = 1;
pub const CONFIG_IONIC_MODULE: u32 = 1;
pub const CONFIG_RCU_CPU_STALL_CPUTIME: u32 = 1;
pub const CONFIG_MFD_WM831X: u32 = 1;
pub const CONFIG_PMIC_ADP5520: u32 = 1;
pub const CONFIG_RPMSG_QCOM_GLINK_RPM_MODULE: u32 = 1;
pub const CONFIG_PPP_FILTER: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE: u32 = 1;
pub const CONFIG_MSI_EC_MODULE: u32 = 1;
pub const CONFIG_MAILBOX: u32 = 1;
pub const CONFIG_VIDEO_MT9M111_MODULE: u32 = 1;
pub const CONFIG_INPUT_LEDS_MODULE: u32 = 1;
pub const CONFIG_RCU_NEED_SEGCBLIST: u32 = 1;
pub const CONFIG_RV_REACT_PRINTK: u32 = 1;
pub const CONFIG_MTD_SLRAM_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW9900_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L85: u32 = 1;
pub const CONFIG_DEBUG_WX: u32 = 1;
pub const CONFIG_MTD_ROM_MODULE: u32 = 1;
pub const CONFIG_EXTCON_USBC_TUSB320_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_HCTR2_MODULE: u32 = 1;
pub const CONFIG_XFS_SUPPORT_V4: u32 = 1;
pub const CONFIG_PATA_PDC2027X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LTC2978_MODULE: u32 = 1;
pub const CONFIG_HAS_DMA: u32 = 1;
pub const CONFIG_INTEL_IPS_MODULE: u32 = 1;
pub const CONFIG_I2C_HID_OF_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS43130_MODULE: u32 = 1;
pub const CONFIG_NF_CT_PROTO_SCTP: u32 = 1;
pub const CONFIG_EDAC: u32 = 1;
pub const CONFIG_USB_SERIAL_VISOR_MODULE: u32 = 1;
pub const CONFIG_INTEL_TPMI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX208_MODULE: u32 = 1;
pub const CONFIG_MTD_PMC551_MODULE: u32 = 1;
pub const CONFIG_BROADCOM_PHY_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCMUIO_MODULE: u32 = 1;
pub const CONFIG_KFENCE: u32 = 1;
pub const CONFIG_DVB_AS102_FE_MODULE: u32 = 1;
pub const CONFIG_PCS_MTK_LYNXI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42XX8_I2C_MODULE: u32 = 1;
pub const CONFIG_SCSI: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_PANIC: u32 = 1;
pub const CONFIG_SMPRO_ERRMON_MODULE: u32 = 1;
pub const CONFIG_DVB_CXD2841ER_MODULE: u32 = 1;
pub const CONFIG_GENWQE_PLATFORM_ERROR_RECOVERY: u32 = 0;
pub const CONFIG_FB_CFB_FILLRECT: u32 = 1;
pub const CONFIG_RT2800_LIB_MMIO_MODULE: u32 = 1;
pub const CONFIG_VIRT_WIFI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT274_MODULE: u32 = 1;
pub const CONFIG_HYPERV_MODULE: u32 = 1;
pub const CONFIG_AT76C50X_USB_MODULE: u32 = 1;
pub const CONFIG_QCOM_SPMI_IADC_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_WM8994_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_PPTP_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_GRAPH_TRACER: u32 = 1;
pub const CONFIG_HID_VIEWSONIC_MODULE: u32 = 1;
pub const CONFIG_SPI_CS42L43_MODULE: u32 = 1;
pub const CONFIG_HID_CHICONY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AS370_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_ROMAN_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_THREAD_STRUCT_WHITELIST: u32 = 1;
pub const CONFIG_HID_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_AMD_MODULE: u32 = 1;
pub const CONFIG_LEDS_TI_LMU_COMMON_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIVID_MODULE: u32 = 1;
pub const CONFIG_RMI4_SMB_MODULE: u32 = 1;
pub const CONFIG_LIBERTAS_THINFIRM_USB_MODULE: u32 = 1;
pub const CONFIG_AMD_XGBE_MODULE: u32 = 1;
pub const CONFIG_CGROUP_NET_PRIO: u32 = 1;
pub const CONFIG_RANDOMIZE_BASE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UAC1: u32 = 1;
pub const CONFIG_RTC_DRV_MAX31335_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_DUAL_ROLE: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_SIMPLE_ONDEMAND: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BXT_DA7219_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VICODEC_MODULE: u32 = 1;
pub const CONFIG_ANDROID_BINDERFS_MODULE: u32 = 1;
pub const CONFIG_TLS_DEVICE: u32 = 1;
pub const CONFIG_PWM_TWL_LED_MODULE: u32 = 1;
pub const CONFIG_SLIP_SMART: u32 = 1;
pub const CONFIG_NLS_ISO8859_9_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ZFORCE_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_BPF_MODULE: u32 = 1;
pub const CONFIG_HYPERV_IOMMU: u32 = 1;
pub const CONFIG_FIRMWARE_EDID: u32 = 1;
pub const CONFIG_SND_SERIAL_U16550_MODULE: u32 = 1;
pub const CONFIG_USB_ARMLINUX: u32 = 1;
pub const CONFIG_I2C_SMBUS_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PE_SIP_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_REALTEK_USB_MODULE: u32 = 1;
pub const CONFIG_PLATFORM_SI4713_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_GF2K_MODULE: u32 = 1;
pub const CONFIG_RTLWIFI_MODULE: u32 = 1;
pub const CONFIG_MT76_CORE_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_ST33ZP24_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BXT_RT298_MACH_MODULE: u32 = 1;
pub const CONFIG_LP8788_ADC_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_MEN_MCB_MODULE: u32 = 1;
pub const CONFIG_EDAC_GHES: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_DEFAULT_ON_MODULE: u32 = 1;
pub const CONFIG_MXM_WMI_MODULE: u32 = 1;
pub const CONFIG_FONT_8x16: u32 = 1;
pub const CONFIG_RTW89_8852AE_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MELLANOX: u32 = 1;
pub const CONFIG_MAC80211_HWSIM_MODULE: u32 = 1;
pub const CONFIG_DVB_LGDT330X_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_MANY_PORTS: u32 = 1;
pub const CONFIG_VT_CONSOLE_SLEEP: u32 = 1;
pub const CONFIG_LIBFC_MODULE: u32 = 1;
pub const CONFIG_X86_MCE_INTEL: u32 = 1;
pub const CONFIG_X86_64: u32 = 1;
pub const CONFIG_ARCH_ENABLE_MEMORY_HOTPLUG: u32 = 1;
pub const CONFIG_MEDIATEK_MT6360_ADC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_CMOS: u32 = 1;
pub const CONFIG_SENSORS_MAX16601_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_AEAD_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MT6370_MODULE: u32 = 1;
pub const CONFIG_PCI_LOCKLESS_CONFIG: u32 = 1;
pub const CONFIG_ARCH_HAS_CURRENT_STACK_POINTER: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK: u32 = 1;
pub const CONFIG_PROBE_EVENTS_BTF_ARGS: u32 = 1;
pub const CONFIG_NF_DUP_NETDEV_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98927_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM3_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_ADFS_FS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RV3029_HWMON: u32 = 1;
pub const CONFIG_TCP_CONG_BBR_MODULE: u32 = 1;
pub const CONFIG_VL53L0X_I2C_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_IRTOUCH: u32 = 1;
pub const CONFIG_PATA_AMD_MODULE: u32 = 1;
pub const CONFIG_USB_PWC_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_FRAGMENT_CACHE_SIZE: u32 = 3;
pub const CONFIG_SENSORS_AD7414_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA8290_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADV_PCI_DIO_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_PANJIT: u32 = 1;
pub const CONFIG_RT2800PCI_RT53XX: u32 = 1;
pub const CONFIG_BONDING_MODULE: u32 = 1;
pub const CONFIG_PROC_THERMAL_MMIO_RAPL_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_ACTIVATION_TRIGGER: &[u8; 11usize] = b"/sbin/init\0";
pub const CONFIG_HTS221_I2C_MODULE: u32 = 1;
pub const CONFIG_MLXSW_SPECTRUM_DCB: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18212_MODULE: u32 = 1;
pub const CONFIG_MCP3422_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_EM3027_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_CACHE_LINE_SIZE: u32 = 1;
pub const CONFIG_UIO_DFL_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_DEST_MODULE: u32 = 1;
pub const CONFIG_X86_SGX: u32 = 1;
pub const CONFIG_TSL2591_MODULE: u32 = 1;
pub const CONFIG_VHOST_VDPA_MODULE: u32 = 1;
pub const CONFIG_VEML6070_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_RC: u32 = 1;
pub const CONFIG_JBD2: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PC236_PCI_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASB100_MODULE: u32 = 1;
pub const CONFIG_PWM_DWC_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL8X0_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_ATMIO_MODULE: u32 = 1;
pub const CONFIG_PATA_NS87415_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1761_MODULE: u32 = 1;
pub const CONFIG_USBIP_CORE_MODULE: u32 = 1;
pub const CONFIG_CAN_M_CAN_TCAN4X5X_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DAC02_MODULE: u32 = 1;
pub const CONFIG_ATH10K_TRACING: u32 = 1;
pub const CONFIG_ATM_BR2684_MODULE: u32 = 1;
pub const CONFIG_SPARSEMEM_VMEMMAP: u32 = 1;
pub const CONFIG_CRYPTO_CAMELLIA_X86_64_MODULE: u32 = 1;
pub const CONFIG_INTEL_ATOMISP2_PDX86: u32 = 1;
pub const CONFIG_PINCTRL_CY8C95X0_MODULE: u32 = 1;
pub const CONFIG_IB700_WDT_MODULE: u32 = 1;
pub const CONFIG_X86_5LEVEL: u32 = 1;
pub const CONFIG_MMC_USHC_MODULE: u32 = 1;
pub const CONFIG_COMEDI_CB_PCIDAS64_MODULE: u32 = 1;
pub const CONFIG_SPI_TLE62X0_MODULE: u32 = 1;
pub const CONFIG_INET6_IPCOMP_MODULE: u32 = 1;
pub const CONFIG_SONY_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_QLCNIC_MODULE: u32 = 1;
pub const CONFIG_MEMCG_KMEM: u32 = 1;
pub const CONFIG_FB_SIS_315: u32 = 1;
pub const CONFIG_TPS6507X_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MARVELL: u32 = 1;
pub const CONFIG_PHYLIB: u32 = 1;
pub const CONFIG_SND_SOC_XILINX_SPDIF_MODULE: u32 = 1;
pub const CONFIG_IGB_DCA: u32 = 1;
pub const CONFIG_NFP_APP_FLOWER: u32 = 1;
pub const CONFIG_SENSORS_IBM_CFFPS_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_DECOMP_MULTI_PERCPU: u32 = 1;
pub const CONFIG_CRYPTO_SHA1_SSSE3_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_GPIO_MODULE: u32 = 1;
pub const CONFIG_FB_IOMEM_HELPERS_DEFERRED: u32 = 1;
pub const CONFIG_IPV6_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_IOSM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM77_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_NVIDIA: u32 = 1;
pub const CONFIG_ARCH_MEMORY_PROBE: u32 = 1;
pub const CONFIG_X86_AMD_FREQ_SENSITIVITY_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA665x_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_FRPW_MODULE: u32 = 1;
pub const CONFIG_PAHOLE_HAS_LANG_EXCLUDE: u32 = 1;
pub const CONFIG_VIDEO_SAA7164_MODULE: u32 = 1;
pub const CONFIG_NFC_MRVL_USB_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_874_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MT6351_MODULE: u32 = 1;
pub const CONFIG_LINEDISP_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_DSA_COMMON_MODULE: u32 = 1;
pub const CONFIG_ULTRIX_PARTITION: u32 = 1;
pub const CONFIG_IRQ_DOMAIN: u32 = 1;
pub const CONFIG_NET_DSA_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_BALLOON: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_CPCI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_IMA: u32 = 1;
pub const CONFIG_LSM_MMAP_MIN_ADDR: u32 = 0;
pub const CONFIG_SCSI_ARCMSR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_BD28623_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L45_SPI_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_AMD: u32 = 1;
pub const CONFIG_INTEGRITY_AUDIT: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_DIO200_MODULE: u32 = 1;
pub const CONFIG_PVPANIC: u32 = 1;
pub const CONFIG_CAN_PEAK_PCI_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_DISKONCHIP_PROBE_ADDRESS: u32 = 0;
pub const CONFIG_PPS_CLIENT_LDISC_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_DEBUG_VIRTUAL: u32 = 1;
pub const CONFIG_KEYBOARD_QT1050_MODULE: u32 = 1;
pub const CONFIG_TYPEC_RT1719_MODULE: u32 = 1;
pub const CONFIG_MTD_ONENAND_2X_PROGRAM: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT20XX_MODULE: u32 = 1;
pub const CONFIG_NET_TULIP: u32 = 1;
pub const CONFIG_IIO_HRTIMER_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_SP_CCP: u32 = 1;
pub const CONFIG_JFFS2_RTIME: u32 = 1;
pub const CONFIG_HAVE_ASM_MODVERSIONS: u32 = 1;
pub const CONFIG_BNXT_HWMON: u32 = 1;
pub const CONFIG_IPC_NS: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CHACHA20POLY1305_MODULE: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_PASSIVE: u32 = 1;
pub const CONFIG_DVB_HORUS3A_MODULE: u32 = 1;
pub const CONFIG_RMI4_F34: u32 = 1;
pub const CONFIG_MISC_FILESYSTEMS: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_BITS_MIN: u32 = 28;
pub const CONFIG_FTRACE: u32 = 1;
pub const CONFIG_IOMMUFD_DRIVER: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_PURGATORY: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_CONNLIMIT_MODULE: u32 = 1;
pub const CONFIG_ATP_MODULE: u32 = 1;
pub const CONFIG_X86_THERMAL_VECTOR: u32 = 1;
pub const CONFIG_FW_LOADER_DEBUG: u32 = 1;
pub const CONFIG_PERF_EVENTS_AMD_UNCORE_MODULE: u32 = 1;
pub const CONFIG_IP_NF_SECURITY_MODULE: u32 = 1;
pub const CONFIG_IP_NF_RAW_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_LTO_CLANG: u32 = 1;
pub const CONFIG_IP_NF_ARPFILTER_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_LP8788_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ETT_TC45USB: u32 = 1;
pub const CONFIG_INTEL_MEI_VSC_HW_MODULE: u32 = 1;
pub const CONFIG_USER_DECRYPTED_DATA: u32 = 1;
pub const CONFIG_COMPAT_32: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RPL_ACP6x_MODULE: u32 = 1;
pub const CONFIG_W1_CON: u32 = 1;
pub const CONFIG_HID_GOOGLE_STADIA_FF_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_SOCKET_MODULE: u32 = 1;
pub const CONFIG_FB_ASILIANT: u32 = 1;
pub const CONFIG_PPPOL2TP_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_TLS8204_MODULE: u32 = 1;
pub const CONFIG_REGMAP_SOUNDWIRE_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ADP5588_MODULE: u32 = 1;
pub const CONFIG_CLOCKSOURCE_WATCHDOG: u32 = 1;
pub const CONFIG_R8712U_MODULE: u32 = 1;
pub const CONFIG_HID_TOPSEED_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RC5T583_MODULE: u32 = 1;
pub const CONFIG_B43_PHY_HT: u32 = 1;
pub const CONFIG_PINCTRL_MADERA_MODULE: u32 = 1;
pub const CONFIG_INPUT_RAVE_SP_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_FB_VT8623_MODULE: u32 = 1;
pub const CONFIG_AD7606_IFACE_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_KBL_RT5663_RT5514_MAX98927_MACH_MODULE: u32 = 1;
pub const CONFIG_LEDS_DA9052_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_CIRRUS_COMMON_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_AESNI_AVX2_X86_64_MODULE: u32 = 1;
pub const CONFIG_LEDS_BRIGHTNESS_HW_CHANGED: u32 = 1;
pub const CONFIG_DECOMPRESS_BZIP2: u32 = 1;
pub const CONFIG_RTW89_8852B_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT33XX: u32 = 1;
pub const CONFIG_CORDIC_MODULE: u32 = 1;
pub const CONFIG_ATH9K_RFKILL: u32 = 1;
pub const CONFIG_COMEDI_CB_PCIDAS_MODULE: u32 = 1;
pub const CONFIG_FB_TRIDENT_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AXP20X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADM1029_MODULE: u32 = 1;
pub const CONFIG_PER_VMA_LOCK: u32 = 1;
pub const CONFIG_MHP_MEMMAP_ON_MEMORY: u32 = 1;
pub const CONFIG_IIO_ST_SENSORS_CORE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS42L43_SDW_MODULE: u32 = 1;
pub const CONFIG_KSM: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_UPROBES: u32 = 1;
pub const CONFIG_EXPORTFS_BLOCK_OPS: u32 = 1;
pub const CONFIG_DRM_DP_AUX_CHARDEV: u32 = 1;
pub const CONFIG_NET_VENDOR_STMICRO: u32 = 1;
pub const CONFIG_EDAC_I3000_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PC_FIFO: u32 = 1;
pub const CONFIG_SHUFFLE_PAGE_ALLOCATOR: u32 = 1;
pub const CONFIG_TOPSTAR_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_AGP_SIS_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_H323_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_SPARC: u32 = 1;
pub const CONFIG_V4L2_CCI_MODULE: u32 = 1;
pub const CONFIG_IMA_LSM_RULES: u32 = 1;
pub const CONFIG_JOYSTICK_TURBOGRAFX_MODULE: u32 = 1;
pub const CONFIG_ARCH_SPARSEMEM_DEFAULT: u32 = 1;
pub const CONFIG_SECURITY_APPARMOR_EXPORT_BINARY: u32 = 1;
pub const CONFIG_SND_SOC_SOF_XTENSA_MODULE: u32 = 1;
pub const CONFIG_MLXSW_PCI_MODULE: u32 = 1;
pub const CONFIG_INPUT_IQS269A_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA7280_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DMM32AT_MODULE: u32 = 1;
pub const CONFIG_MOST_MODULE: u32 = 1;
pub const CONFIG_USB_NET_QMI_WWAN_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_ROUNDROBIN_MODULE: u32 = 1;
pub const CONFIG_BOARD_TPCI200_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT5033_MODULE: u32 = 1;
pub const CONFIG_INPUT_CMA3000_MODULE: u32 = 1;
pub const CONFIG_CEC_NOTIFIER: u32 = 1;
pub const CONFIG_EDAC_IE31200_MODULE: u32 = 1;
pub const CONFIG_IR_ENE_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_S6D1121_MODULE: u32 = 1;
pub const CONFIG_ALIM1535_WDT_MODULE: u32 = 1;
pub const CONFIG_RICHTEK_RTQ6056_MODULE: u32 = 1;
pub const CONFIG_HID_HYPERV_MOUSE_MODULE: u32 = 1;
pub const CONFIG_GACT_PROB: u32 = 1;
pub const CONFIG_SERIAL_MCTRL_GPIO: u32 = 1;
pub const CONFIG_MISDN_ISAR_MODULE: u32 = 1;
pub const CONFIG_REALTEK_PHY_MODULE: u32 = 1;
pub const CONFIG_PROC_VMCORE: u32 = 1;
pub const CONFIG_HID_A4TECH_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MC44S803_MODULE: u32 = 1;
pub const CONFIG_RTC_MC146818_LIB: u32 = 1;
pub const CONFIG_KMX61_MODULE: u32 = 1;
pub const CONFIG_NFC_PN544_MEI_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_QCA: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_860_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_WDT_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPIC2810_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_GSWIP_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_I3C_MODULE: u32 = 1;
pub const CONFIG_AD799X_MODULE: u32 = 1;
pub const CONFIG_DPLL: u32 = 1;
pub const CONFIG_SND_MONA_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_ESP_MODULE: u32 = 1;
pub const CONFIG_NIU_MODULE: u32 = 1;
pub const CONFIG_AD8366_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_VMMOUSE: u32 = 1;
pub const CONFIG_IP_NF_TARGET_NETMAP_MODULE: u32 = 1;
pub const CONFIG_DST_CACHE: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA505_MODULE: u32 = 1;
pub const CONFIG_KVM_GENERIC_HARDWARE_ENABLING: u32 = 1;
pub const CONFIG_INFINIBAND_RTRS_MODULE: u32 = 1;
pub const CONFIG_NF_REJECT_IPV6_MODULE: u32 = 1;
pub const CONFIG_RCU_CPU_STALL_TIMEOUT: u32 = 60;
pub const CONFIG_FPGA_MGR_MACHXO2_SPI_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_ADP5520_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SQ905C_MODULE: u32 = 1;
pub const CONFIG_842_COMPRESS_MODULE: u32 = 1;
pub const CONFIG_SATA_VITESSE_MODULE: u32 = 1;
pub const CONFIG_POSIX_CPU_TIMERS_TASK_WORK: u32 = 1;
pub const CONFIG_SND_SOC_WCD_MBHC_MODULE: u32 = 1;
pub const CONFIG_BCACHEFS_QUOTA: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6XXX_MODULE: u32 = 1;
pub const CONFIG_CHECKPOINT_RESTORE: u32 = 1;
pub const CONFIG_PRINTER_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ISL1208_MODULE: u32 = 1;
pub const CONFIG_INTEL_TDX_GUEST: u32 = 1;
pub const CONFIG_MFD_MENF21BMC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS4265_MODULE: u32 = 1;
pub const CONFIG_SND_VERBOSE_PROCFS: u32 = 1;
pub const CONFIG_SENSORS_HMC5843_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_FIREWIRE_LIB_MODULE: u32 = 1;
pub const CONFIG_INT340X_THERMAL_MODULE: u32 = 1;
pub const CONFIG_DA9052_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2740_MODULE: u32 = 1;
pub const CONFIG_CFG80211_DEBUGFS: u32 = 1;
pub const CONFIG_TYPEC_TPS6598X_MODULE: u32 = 1;
pub const CONFIG_GNSS_MTK_SERIAL_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_BCM: u32 = 1;
pub const CONFIG_HAVE_ARCH_COMPAT_MMAP_BASES: u32 = 1;
pub const CONFIG_MAX9611_MODULE: u32 = 1;
pub const CONFIG_LAPB_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM25066_REGULATOR: u32 = 1;
pub const CONFIG_IIO_ST_GYRO_3AXIS_MODULE: u32 = 1;
pub const CONFIG_SCD30_CORE_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO_MAX_ACCEPT_ENTRY: u32 = 2048;
pub const CONFIG_IP_ROUTE_MULTIPATH: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_REGION_MODULE: u32 = 1;
pub const CONFIG_AM2315_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF2123_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBP21_MODULE: u32 = 1;
pub const CONFIG_XEN_NETDEV_FRONTEND: u32 = 1;
pub const CONFIG_DVB_TDA10048_MODULE: u32 = 1;
pub const CONFIG_INPUT_FF_MEMLESS_MODULE: u32 = 1;
pub const CONFIG_PARAVIRT_CLOCK: u32 = 1;
pub const CONFIG_TYPEC_MT6360_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_SAI_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_PRINTER: u32 = 1;
pub const CONFIG_SENSORS_W83627HF_MODULE: u32 = 1;
pub const CONFIG_CHR_DEV_SG: u32 = 1;
pub const CONFIG_USB_CDC_PHONET_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_NET_MODULE: u32 = 1;
pub const CONFIG_LLD_VERSION: u32 = 0;
pub const CONFIG_SECTION_MISMATCH_WARN_ONLY: u32 = 1;
pub const CONFIG_ROHM_BU27008_MODULE: u32 = 1;
pub const CONFIG_SND_AD1889_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SMSC_LAN9303_MDIO_MODULE: u32 = 1;
pub const CONFIG_MISC_RTSX_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_LAKEFIELD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2305_MODULE: u32 = 1;
pub const CONFIG_SSB_DRIVER_PCICORE_POSSIBLE: u32 = 1;
pub const CONFIG_MISDN_AVMFRITZ_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_EGRESS: u32 = 1;
pub const CONFIG_NET_DSA_QCA8K_LEDS_SUPPORT: u32 = 1;
pub const CONFIG_SENSORS_CORSAIR_PSU_MODULE: u32 = 1;
pub const CONFIG_MDIO_DEVICE: u32 = 1;
pub const CONFIG_SMS_SDIO_DRV_MODULE: u32 = 1;
pub const CONFIG_NFSD_PNFS: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_MRFLD_MODULE: u32 = 1;
pub const CONFIG_NEED_SG_DMA_LENGTH: u32 = 1;
pub const CONFIG_INPUT_AXP20X_PEK_MODULE: u32 = 1;
pub const CONFIG_MODPROBE_PATH: &[u8; 15usize] = b"/sbin/modprobe\0";
pub const CONFIG_SND_MPU401_MODULE: u32 = 1;
pub const CONFIG_DVB_CX24116_MODULE: u32 = 1;
pub const CONFIG_POWER_RESET: u32 = 1;
pub const CONFIG_CRYPTO_XCBC_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_ATMEL_SHA204A_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_AMANDA_MODULE: u32 = 1;
pub const CONFIG_IPW2200_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_MARK_MODULE: u32 = 1;
pub const CONFIG_DRM_DISPLAY_HELPER_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_QT2160_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7411_MODULE: u32 = 1;
pub const CONFIG_IXGBE_DCA: u32 = 1;
pub const CONFIG_VP_VDPA_MODULE: u32 = 1;
pub const CONFIG_EFI_SECRET_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_IPV6HEADER_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5647_MODULE: u32 = 1;
pub const CONFIG_MACVLAN_MODULE: u32 = 1;
pub const CONFIG_TPS6105X_MODULE: u32 = 1;
pub const CONFIG_TI_ADC084S021_MODULE: u32 = 1;
pub const CONFIG_PATA_PDC_OLD_MODULE: u32 = 1;
pub const CONFIG_L2TP_V3: u32 = 1;
pub const CONFIG_INTEL_MRFLD_PWRBTN_MODULE: u32 = 1;
pub const CONFIG_I2C_MUX_REG_MODULE: u32 = 1;
pub const CONFIG_RTL8723_COMMON_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T1_1G: u32 = 1;
pub const CONFIG_BPF_JIT: u32 = 1;
pub const CONFIG_INV_MPU6050_I2C_MODULE: u32 = 1;
pub const CONFIG_NINTENDO_FF: u32 = 1;
pub const CONFIG_IIO_INTERRUPT_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AW37503_MODULE: u32 = 1;
pub const CONFIG_I2C_HID_CORE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV13B10_MODULE: u32 = 1;
pub const CONFIG_MMCONF_FAM10H: u32 = 1;
pub const CONFIG_SENSORS_INA2XX_MODULE: u32 = 1;
pub const CONFIG_WLCORE_SDIO_MODULE: u32 = 1;
pub const CONFIG_FB_ARK_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_IFORCE_MODULE: u32 = 1;
pub const CONFIG_PCIEASPM_DEFAULT: u32 = 1;
pub const CONFIG_SND_SOC_WM8524_MODULE: u32 = 1;
pub const CONFIG_PROFILING: u32 = 1;
pub const CONFIG_PCF50633_ADC_MODULE: u32 = 1;
pub const CONFIG_INTERVAL_TREE: u32 = 1;
pub const CONFIG_FB_TFT_ST7735R_MODULE: u32 = 1;
pub const CONFIG_ARCNET_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8731_MODULE: u32 = 1;
pub const CONFIG_IOSF_MBI: u32 = 1;
pub const CONFIG_I2C_ALI15X3_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31785_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_AMAZON: u32 = 1;
pub const CONFIG_SPARSEMEM: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2805_MODULE: u32 = 1;
pub const CONFIG_BLK_MQ_STACKING: u32 = 1;
pub const CONFIG_REGULATOR_FAN53555_MODULE: u32 = 1;
pub const CONFIG_SPI_MICROCHIP_CORE_QSPI_MODULE: u32 = 1;
pub const CONFIG_NVME_FC_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_2032_MODULE: u32 = 1;
pub const CONFIG_DRM_GEM_SHMEM_HELPER: u32 = 1;
pub const CONFIG_REGULATOR_DA9210_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_FORCE_DMA_UNENCRYPTED: u32 = 1;
pub const CONFIG_HID_GLORIOUS_MODULE: u32 = 1;
pub const CONFIG_HD44780_MODULE: u32 = 1;
pub const CONFIG_INPUT_REGULATOR_HAPTIC_MODULE: u32 = 1;
pub const CONFIG_CAN_MCBA_USB_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_6LOWPAN_MODULE: u32 = 1;
pub const CONFIG_VHOST_NET_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TEA6415C_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ATMEL: u32 = 1;
pub const CONFIG_CHROMEOS_ACPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYTCR_WM5102_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_CZ_RT5645_MACH_MODULE: u32 = 1;
pub const CONFIG_DWMAC_INTEL_MODULE: u32 = 1;
pub const CONFIG_DVB_STV0900_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MULTI_INSTANTIATE_MODULE: u32 = 1;
pub const CONFIG_I2C_NFORCE2_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_DIGI_ACCELEPORT_MODULE: u32 = 1;
pub const CONFIG_USB_GL860_MODULE: u32 = 1;
pub const CONFIG_GRACE_PERIOD_MODULE: u32 = 1;
pub const CONFIG_SLHC: u32 = 1;
pub const CONFIG_NET_VENDOR_TEHUTI: u32 = 1;
pub const CONFIG_QED_RDMA: u32 = 1;
pub const CONFIG_SCSI_UFSHCD_PCI_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_LTC3589_MODULE: u32 = 1;
pub const CONFIG_SND_ALS300_MODULE: u32 = 1;
pub const CONFIG_MCTP: u32 = 1;
pub const CONFIG_ADT7316_I2C_MODULE: u32 = 1;
pub const CONFIG_ALTERA_TSE_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_GPIO_POLLED_MODULE: u32 = 1;
pub const CONFIG_HP_BIOSCFG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_DA7219_MACH_MODULE: u32 = 1;
pub const CONFIG_E1000E_HWTS: u32 = 1;
pub const CONFIG_CRYPTO_MANAGER: u32 = 1;
pub const CONFIG_PHY_SAMSUNG_USB2_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_TXE_MODULE: u32 = 1;
pub const CONFIG_SCSI_IPR_TRACE: u32 = 1;
pub const CONFIG_NET_SCH_HTB_MODULE: u32 = 1;
pub const CONFIG_EEPROM_AT24_MODULE: u32 = 1;
pub const CONFIG_UIO_SERCOS3_MODULE: u32 = 1;
pub const CONFIG_HID_CP2112_MODULE: u32 = 1;
pub const CONFIG_PPP_BSDCOMP_MODULE: u32 = 1;
pub const CONFIG_SCHED_SMT: u32 = 1;
pub const CONFIG_DVB_USB_TTUSB2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_RENOIR_MODULE: u32 = 1;
pub const CONFIG_EDAC_SUPPORT: u32 = 1;
pub const CONFIG_RT_MUTEXES: u32 = 1;
pub const CONFIG_MFD_MADERA_SPI_MODULE: u32 = 1;
pub const CONFIG_LOCK_SPIN_ON_OWNER: u32 = 1;
pub const CONFIG_KRETPROBE_ON_RETHOOK: u32 = 1;
pub const CONFIG_REGULATOR_LTC3676_MODULE: u32 = 1;
pub const CONFIG_WLCORE_MODULE: u32 = 1;
pub const CONFIG_HID_ORTEK_MODULE: u32 = 1;
pub const CONFIG_VIDEO_V4L2_TPG_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_MARK_MODULE: u32 = 1;
pub const CONFIG_NFT_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_HID_ASUS_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822CU_MODULE: u32 = 1;
pub const CONFIG_X86_AMD_PSTATE_DEFAULT_MODE: u32 = 3;
pub const CONFIG_SND_SOC_INTEL_BXT_DA7219_MAX98357A_COMMON_MODULE: u32 = 1;
pub const CONFIG_AR5523_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RNBD_CLIENT_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_AMD_BRS: u32 = 1;
pub const CONFIG_SENSORS_TMP464_MODULE: u32 = 1;
pub const CONFIG_DEVICE_PRIVATE: u32 = 1;
pub const CONFIG_INPUT_IQS7222_MODULE: u32 = 1;
pub const CONFIG_CC_NO_ARRAY_BOUNDS: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MXL5007T_MODULE: u32 = 1;
pub const CONFIG_ATH10K_CE: u32 = 1;
pub const CONFIG_CX_ECAT_MODULE: u32 = 1;
pub const CONFIG_DRM_I2C_SIL164_MODULE: u32 = 1;
pub const CONFIG_SATA_INIC162X_MODULE: u32 = 1;
pub const CONFIG_HUGETLBFS: u32 = 1;
pub const CONFIG_CHECK_SIGNATURE: u32 = 1;
pub const CONFIG_DVB_TDA10021_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX231XX_DVB_MODULE: u32 = 1;
pub const CONFIG_SLAB_MERGE_DEFAULT: u32 = 1;
pub const CONFIG_OSNOISE_TRACER: u32 = 1;
pub const CONFIG_KERNFS: u32 = 1;
pub const CONFIG_CXD2880_SPI_DRV_MODULE: u32 = 1;
pub const CONFIG_INTEL_UNCORE_FREQ_CONTROL_TPMI_MODULE: u32 = 1;
pub const CONFIG_WL1251_MODULE: u32 = 1;
pub const CONFIG_I2C_ALGOBIT_MODULE: u32 = 1;
pub const CONFIG_IPV6_SUBTREES: u32 = 1;
pub const CONFIG_MMC_BLOCK_MODULE: u32 = 1;
pub const CONFIG_BATTERY_AXP20X_MODULE: u32 = 1;
pub const CONFIG_NET_CLS_FW_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_CCP: u32 = 1;
pub const CONFIG_KVM_MODULE: u32 = 1;
pub const CONFIG_PAGE_COUNTER: u32 = 1;
pub const CONFIG_KEYBOARD_DLINK_DIR685_MODULE: u32 = 1;
pub const CONFIG_SND_SIMPLE_CARD_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2781_MODULE: u32 = 1;
pub const CONFIG_HAVE_STATIC_CALL_INLINE: u32 = 1;
pub const CONFIG_INTEL_WMI: u32 = 1;
pub const CONFIG_VIDEO_SAA7185_MODULE: u32 = 1;
pub const CONFIG_SND_PCI: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_DVB_MODULE: u32 = 1;
pub const CONFIG_ATM_FORE200E_DEBUG: u32 = 0;
pub const CONFIG_EXPERT: u32 = 1;
pub const CONFIG_TOUCHSCREEN_PCAP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT715_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_MAX_REASON: u32 = 2;
pub const CONFIG_NVME_TARGET_TCP_MODULE: u32 = 1;
pub const CONFIG_DVB_NETUP_UNIDVB_MODULE: u32 = 1;
pub const CONFIG_LEDS_RT8515_MODULE: u32 = 1;
pub const CONFIG_ATL1C_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_DIRTY_RING_TSO: u32 = 1;
pub const CONFIG_IR_SANYO_DECODER_MODULE: u32 = 1;
pub const CONFIG_SENSORS_POWERZ_MODULE: u32 = 1;
pub const CONFIG_DMAR_TABLE: u32 = 1;
pub const CONFIG_MFD_INTEL_LPSS_PCI_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_INTEL_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_RTRS_SERVER_MODULE: u32 = 1;
pub const CONFIG_SLS: u32 = 1;
pub const CONFIG_LCD_LTV350QV_MODULE: u32 = 1;
pub const CONFIG_LXT_PHY_MODULE: u32 = 1;
pub const CONFIG_CFG80211_CRDA_SUPPORT: u32 = 1;
pub const CONFIG_RTW88_8723D_MODULE: u32 = 1;
pub const CONFIG_FB_MB862XX_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV9650_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9V011_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ALC5623_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMG: u32 = 1;
pub const CONFIG_CAN_M_CAN_MODULE: u32 = 1;
pub const CONFIG_WIRELESS: u32 = 1;
pub const CONFIG_WEXT_PROC: u32 = 1;
pub const CONFIG_RPMSG_CTRL_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_MODULE: u32 = 1;
pub const CONFIG_CGROUP_MISC: u32 = 1;
pub const CONFIG_BCMA_DRIVER_PCI: u32 = 1;
pub const CONFIG_SQUASHFS: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_MODULE: u32 = 1;
pub const CONFIG_EDAC_I7CORE_MODULE: u32 = 1;
pub const CONFIG_HID_VIVALDI_MODULE: u32 = 1;
pub const CONFIG_RMNET_MODULE: u32 = 1;
pub const CONFIG_FB_N411_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_JITTERENTROPY_MEMORY_BLOCKS: u32 = 64;
pub const CONFIG_X86_IO_APIC: u32 = 1;
pub const CONFIG_ARCH_HAS_STRICT_KERNEL_RWX: u32 = 1;
pub const CONFIG_NFT_DUP_IPV6_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_AIO_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_PLAT_HOST: u32 = 1;
pub const CONFIG_SND_ALS4000_MODULE: u32 = 1;
pub const CONFIG_INTEL_PMT_CRASHLOG_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_KONICA_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_ATMEL_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_DSTR_MODULE: u32 = 1;
pub const CONFIG_LOCK_DEBUGGING_SUPPORT: u32 = 1;
pub const CONFIG_SND_SOC_WM8770_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ICS43432_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_TBF_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_BPCK6_MODULE: u32 = 1;
pub const CONFIG_I2C_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_MODULE: u32 = 1;
pub const CONFIG_PKCS7_MESSAGE_PARSER: u32 = 1;
pub const CONFIG_XILINX_PR_DECOUPLER_MODULE: u32 = 1;
pub const CONFIG_PING_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_RAVE_SP_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CH9200_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_SANE_STACKPROTECTOR: u32 = 1;
pub const CONFIG_USB_LED_TRIG: u32 = 1;
pub const CONFIG_FB_TFT_ILI9481_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TVP7002_MODULE: u32 = 1;
pub const CONFIG_IRQ_SIM: u32 = 1;
pub const CONFIG_DVB_CX22702_MODULE: u32 = 1;
pub const CONFIG_KGDB: u32 = 1;
pub const CONFIG_LTR501_MODULE: u32 = 1;
pub const CONFIG_CROS_EC_LIGHTBAR_MODULE: u32 = 1;
pub const CONFIG_SERIO_RAW_MODULE: u32 = 1;
pub const CONFIG_TASK_IO_ACCOUNTING: u32 = 1;
pub const CONFIG_MISC_RTSX_PCI_MODULE: u32 = 1;
pub const CONFIG_NF_LOG_SYSLOG_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_KTD253_MODULE: u32 = 1;
pub const CONFIG_FAT_DEFAULT_IOCHARSET: &[u8; 10usize] = b"iso8859-1\0";
pub const CONFIG_USBIP_VHCI_NR_HCS: u32 = 1;
pub const CONFIG_VIDEO_IMX258_MODULE: u32 = 1;
pub const CONFIG_ASYNC_XOR_MODULE: u32 = 1;
pub const CONFIG_HAVE_RUST: u32 = 1;
pub const CONFIG_USB_CONFIGFS_MASS_STORAGE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SST_TOPLEVEL: u32 = 1;
pub const CONFIG_ISDN_CAPI_MIDDLEWARE: u32 = 1;
pub const CONFIG_TIPC_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_ILI9163_MODULE: u32 = 1;
pub const CONFIG_DVB_STB6100_MODULE: u32 = 1;
pub const CONFIG_W83977F_WDT_MODULE: u32 = 1;
pub const CONFIG_NXP_CBTX_PHY_MODULE: u32 = 1;
pub const CONFIG_MD_RAID0_MODULE: u32 = 1;
pub const CONFIG_FRAME_WARN: u32 = 1024;
pub const CONFIG_VIDEO_MT9P031_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_AGERE: u32 = 1;
pub const CONFIG_SND_FIREFACE_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_NCM_MODULE: u32 = 1;
pub const CONFIG_UVC_COMMON_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_BAYTRAIL_MODULE: u32 = 1;
pub const CONFIG_HID_GENERIC_MODULE: u32 = 1;
pub const CONFIG_HID_MEGAWORLD_FF_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_COMMON_MODULE: u32 = 1;
pub const CONFIG_FB_SIS_300: u32 = 1;
pub const CONFIG_VIRTIO_MEM_MODULE: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_BITS: u32 = 32;
pub const CONFIG_X86_VSYSCALL_EMULATION: u32 = 1;
pub const CONFIG_DUMMY_IRQ_MODULE: u32 = 1;
pub const CONFIG_USB_DWC2_HOST: u32 = 1;
pub const CONFIG_USB_HACKRF_MODULE: u32 = 1;
pub const CONFIG_AD7303_MODULE: u32 = 1;
pub const CONFIG_HP_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DAS08_ISA_MODULE: u32 = 1;
pub const CONFIG_MTD_DATAFLASH_OTP: u32 = 1;
pub const CONFIG_HID_RETRODE_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM2_MODULE: u32 = 1;
pub const CONFIG_COMEDI_USB_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_BCM87XX_PHY_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_ETH_MODULE: u32 = 1;
pub const CONFIG_PATA_SCH_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIM2M_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_ILI9320_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1701_MODULE: u32 = 1;
pub const CONFIG_BATTERY_TWL4030_MADC_MODULE: u32 = 1;
pub const CONFIG_ZRAM_MEMORY_TRACKING: u32 = 1;
pub const CONFIG_CRYPTO_DEV_SP_PSP: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_HDAUDIO_MODULE: u32 = 1;
pub const CONFIG_INITRAMFS_SOURCE: &[u8; 1usize] = b"\0";
pub const CONFIG_VIDEO_THS7303_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW5864_MODULE: u32 = 1;
pub const CONFIG_RTL_CARDS_MODULE: u32 = 1;
pub const CONFIG_PATA_NETCELL_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PCA9450_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKL_HDA_DSP_GENERIC_MACH_MODULE: u32 = 1;
pub const CONFIG_X86_MCELOG_LEGACY: u32 = 1;
pub const CONFIG_INPUT_IMS_PCU_MODULE: u32 = 1;
pub const CONFIG_PAGE_POOL_STATS: u32 = 1;
pub const CONFIG_ARCH_MHP_MEMMAP_ON_MEMORY_ENABLE: u32 = 1;
pub const CONFIG_VIDEO_IMX319_MODULE: u32 = 1;
pub const CONFIG_DHT11_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1374_WDT: u32 = 1;
pub const CONFIG_MT7663U_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_TAS2781_I2C_MODULE: u32 = 1;
pub const CONFIG_ATM_CLIP_MODULE: u32 = 1;
pub const CONFIG_X86_CPU_RESCTRL: u32 = 1;
pub const CONFIG_TASKS_TRACE_RCU: u32 = 1;
pub const CONFIG_COMEDI_RTD520_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_SIGMATEL_MODULE: u32 = 1;
pub const CONFIG_CGROUPS: u32 = 1;
pub const CONFIG_MFD_AXP20X_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5670_MODULE: u32 = 1;
pub const CONFIG_SND_USB_CAIAQ_INPUT: u32 = 1;
pub const CONFIG_MMC: u32 = 1;
pub const CONFIG_LZO_COMPRESS: u32 = 1;
pub const CONFIG_DAX: u32 = 1;
pub const CONFIG_USB_F_PHONET_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_MAX98927_MODULE: u32 = 1;
pub const CONFIG_DRM_SSD130X_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_MODULE: u32 = 1;
pub const CONFIG_GUEST_PERF_EVENTS: u32 = 1;
pub const CONFIG_VIRTIO_INPUT_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_MMAP_RND_COMPAT_BITS: u32 = 1;
pub const CONFIG_DELL_RBTN_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_GUNZE: u32 = 1;
pub const CONFIG_PROC_CPU_RESCTRL: u32 = 1;
pub const CONFIG_CRYPTO_SEQIV: u32 = 1;
pub const CONFIG_ACPI_SPCR_TABLE: u32 = 1;
pub const CONFIG_VF610_ADC_MODULE: u32 = 1;
pub const CONFIG_NI903X_WDT_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_SRIOV: u32 = 1;
pub const CONFIG_GPIO_XRA1403_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_MODULE: u32 = 1;
pub const CONFIG_COMEDI_QUATECH_DAQP_CS_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7877_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_POWER_SAVE_DEFAULT: u32 = 1;
pub const CONFIG_TTY_PRINTK: u32 = 1;
pub const CONFIG_9P_FSCACHE: u32 = 1;
pub const CONFIG_HID_LOGITECH_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGODJX_MODULE: u32 = 1;
pub const CONFIG_ARCNET_COM90xx_MODULE: u32 = 1;
pub const CONFIG_VME_BUS: u32 = 1;
pub const CONFIG_DM_LOG_USERSPACE_MODULE: u32 = 1;
pub const CONFIG_DM_AUDIT: u32 = 1;
pub const CONFIG_JOYSTICK_GAMECON_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_RNG_MODULE: u32 = 1;
pub const CONFIG_DRM_VIRTIO_GPU_KMS: u32 = 1;
pub const CONFIG_SCSI_ENCLOSURE_MODULE: u32 = 1;
pub const CONFIG_HAVE_GCC_PLUGINS: u32 = 1;
pub const CONFIG_AMD_PMC_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_EVENTS: u32 = 1;
pub const CONFIG_REGULATOR_RT4803_MODULE: u32 = 1;
pub const CONFIG_DVB_SP887X_MODULE: u32 = 1;
pub const CONFIG_STACKTRACE: u32 = 1;
pub const CONFIG_NET_EMATCH_CANID_MODULE: u32 = 1;
pub const CONFIG_TAHVO_USB_HOST_BY_DEFAULT: u32 = 1;
pub const CONFIG_HAVE_PCI: u32 = 1;
pub const CONFIG_SENSORS_LM92_MODULE: u32 = 1;
pub const CONFIG_EXTCON: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_3120_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_LIB_MODULE: u32 = 1;
pub const CONFIG_RTW88_8821CE_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_LIBSAS_MODULE: u32 = 1;
pub const CONFIG_ISCSI_TARGET_MODULE: u32 = 1;
pub const CONFIG_MFD_INTEL_M10_BMC_SPI_MODULE: u32 = 1;
pub const CONFIG_IMA_MEASURE_PCR_IDX: u32 = 10;
pub const CONFIG_MERAKI_MX100_MODULE: u32 = 1;
pub const CONFIG_HAVE_ACPI_APEI: u32 = 1;
pub const CONFIG_RTW88_8723DU_MODULE: u32 = 1;
pub const CONFIG_ARCNET_RIM_I_MODULE: u32 = 1;
pub const CONFIG_AK8974_MODULE: u32 = 1;
pub const CONFIG_MHI_BUS_MODULE: u32 = 1;
pub const CONFIG_PATA_RADISYS_MODULE: u32 = 1;
pub const CONFIG_TOSHIBA_HAPS_MODULE: u32 = 1;
pub const CONFIG_IPV6_GRE_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_IDLETIMER_MODULE: u32 = 1;
pub const CONFIG_FB_ATY128_MODULE: u32 = 1;
pub const CONFIG_NETKIT: u32 = 1;
pub const CONFIG_GPIO_TPS65086_MODULE: u32 = 1;
pub const CONFIG_VDPA_SIM_MODULE: u32 = 1;
pub const CONFIG_VFIO_PCI_INTX: u32 = 1;
pub const CONFIG_BMG160_MODULE: u32 = 1;
pub const CONFIG_UIO_AEC_MODULE: u32 = 1;
pub const CONFIG_SCSI_PM8001_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_DEBUG_PAGEALLOC: u32 = 1;
pub const CONFIG_VIDEO_TUNER_MODULE: u32 = 1;
pub const CONFIG_IFB_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_ACCEL_3AXIS_MODULE: u32 = 1;
pub const CONFIG_USB_FUNCTIONFS_ETH: u32 = 1;
pub const CONFIG_TCS3472_MODULE: u32 = 1;
pub const CONFIG_HAS_IOPORT: u32 = 1;
pub const CONFIG_DM_MULTIPATH_HST_MODULE: u32 = 1;
pub const CONFIG_RDMA_SIW_MODULE: u32 = 1;
pub const CONFIG_LEDS_LP3944_MODULE: u32 = 1;
pub const CONFIG_SX9360_MODULE: u32 = 1;
pub const CONFIG_USB_SEVSEG_MODULE: u32 = 1;
pub const CONFIG_SND_MPU401_UART_MODULE: u32 = 1;
pub const CONFIG_IPV6_VTI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DRBG: u32 = 1;
pub const CONFIG_RTC_DRV_PCF8563_MODULE: u32 = 1;
pub const CONFIG_SND_MAX_CARDS: u32 = 32;
pub const CONFIG_PPTP_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MSI001_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_V2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SMSC47M1_MODULE: u32 = 1;
pub const CONFIG_SND_USB_US122L_MODULE: u32 = 1;
pub const CONFIG_TEST_BLACKHOLE_DEV_MODULE: u32 = 1;
pub const CONFIG_RTW89_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_CDC_COMPOSITE_MODULE: u32 = 1;
pub const CONFIG_USB_DSBR_MODULE: u32 = 1;
pub const CONFIG_MSE102X_MODULE: u32 = 1;
pub const CONFIG_ISCSI_IBFT_FIND: u32 = 1;
pub const CONFIG_KGDB_KDB: u32 = 1;
pub const CONFIG_DCB: u32 = 1;
pub const CONFIG_PCIPCWATCHDOG_MODULE: u32 = 1;
pub const CONFIG_XILLYBUS_CLASS_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ADMTEK: u32 = 1;
pub const CONFIG_SENSORS_NZXT_KRAKEN2_MODULE: u32 = 1;
pub const CONFIG_MLX5_MPFS: u32 = 1;
pub const CONFIG_CGROUP_CPUACCT: u32 = 1;
pub const CONFIG_FS_VERITY: u32 = 1;
pub const CONFIG_USB_SERIAL_OTI6858_MODULE: u32 = 1;
pub const CONFIG_GCC_NO_STRINGOP_OVERFLOW: u32 = 1;
pub const CONFIG_ADXL367_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_COMPONENT: u32 = 1;
pub const CONFIG_SERIAL_SC16IS7XX_CORE_MODULE: u32 = 1;
pub const CONFIG_MCP4531_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GO7007_USB_MODULE: u32 = 1;
pub const CONFIG_CAN_BCM_MODULE: u32 = 1;
pub const CONFIG_HAS_IOPORT_MAP: u32 = 1;
pub const CONFIG_BRCMSMAC_LEDS: u32 = 1;
pub const CONFIG_SND_SOC_ES8328_I2C_MODULE: u32 = 1;
pub const CONFIG_X86_CMPXCHG64: u32 = 1;
pub const CONFIG_VIDEO_SAA7146_VV_MODULE: u32 = 1;
pub const CONFIG_DA9062_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4375_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_RT5663_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_CS47L35: u32 = 1;
pub const CONFIG_CARL9170_HWRNG: u32 = 1;
pub const CONFIG_NLMON_MODULE: u32 = 1;
pub const CONFIG_ATH10K_PCI_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_HAVE_FAST_GUP: u32 = 1;
pub const CONFIG_VIRTIO_PCI_LIB: u32 = 1;
pub const CONFIG_NET_VENDOR_VIA: u32 = 1;
pub const CONFIG_UBIFS_FS_SECURITY: u32 = 1;
pub const CONFIG_USB_ATM_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS_HOST: u32 = 1;
pub const CONFIG_NFC_S3FWRN82_UART_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SDW_MOCKUP_MODULE: u32 = 1;
pub const CONFIG_ISA_DMA_API: u32 = 1;
pub const CONFIG_XEN_PCI_STUB: u32 = 1;
pub const CONFIG_PCMCIA_FDOMAIN_MODULE: u32 = 1;
pub const CONFIG_HZ: u32 = 1000;
pub const CONFIG_MSA311_MODULE: u32 = 1;
pub const CONFIG_INET6_ESPINTCP: u32 = 1;
pub const CONFIG_IIO_SIMPLE_DUMMY_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_SHARE_IRQ: u32 = 1;
pub const CONFIG_MT76x2U_MODULE: u32 = 1;
pub const CONFIG_DPS310_MODULE: u32 = 1;
pub const CONFIG_RUST: u32 = 1;
pub const CONFIG_HID_TOPRE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5648_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_VLAN_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_PERFMON: u32 = 1;
pub const CONFIG_IXGBE_HWMON: u32 = 1;
pub const CONFIG_HOTPLUG_CORE_SYNC_FULL: u32 = 1;
pub const CONFIG_USB_RTL8152_MODULE: u32 = 1;
pub const CONFIG_ECHO_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_UAC2: u32 = 1;
pub const CONFIG_I2C_HELPER_AUTO: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_U32_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_DIO200_PCI_MODULE: u32 = 1;
pub const CONFIG_KVM_XFER_TO_GUEST_WORK: u32 = 1;
pub const CONFIG_VIDEO_SONY_BTF_MPX_MODULE: u32 = 1;
pub const CONFIG_INTEGRITY_TRUSTED_KEYRING: u32 = 1;
pub const CONFIG_SQUASHFS_ZLIB: u32 = 1;
pub const CONFIG_FPGA_MGR_LATTICE_SYSCONFIG_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX23885_MODULE: u32 = 1;
pub const CONFIG_AGP_INTEL: u32 = 1;
pub const CONFIG_NLS_ISO8859_4_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_AD7879_I2C_MODULE: u32 = 1;
pub const CONFIG_INTEL_OAKTRAIL_MODULE: u32 = 1;
pub const CONFIG_SND_MTS64_MODULE: u32 = 1;
pub const CONFIG_EXAR_WDT_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PERICOM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31760_MODULE: u32 = 1;
pub const CONFIG_SPI_ALTERA_DFL_MODULE: u32 = 1;
pub const CONFIG_FB_BACKLIGHT_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RX8025_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_NR_UARTS: u32 = 48;
pub const CONFIG_WILCO_EC_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_STRICT_MODULE_RWX: u32 = 1;
pub const CONFIG_TCP_CONG_DCTCP_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_MAX8997_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH_IPSET_MODULE: u32 = 1;
pub const CONFIG_TSL2772_MODULE: u32 = 1;
pub const CONFIG_AD7291_MODULE: u32 = 1;
pub const CONFIG_CC_IS_GCC: u32 = 1;
pub const CONFIG_GPIO_I8255_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_SRPT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_RMD160_MODULE: u32 = 1;
pub const CONFIG_IR_IMON_MODULE: u32 = 1;
pub const CONFIG_CPU_SUP_HYGON: u32 = 1;
pub const CONFIG_BCM7XXX_PHY_MODULE: u32 = 1;
pub const CONFIG_SCD30_I2C_MODULE: u32 = 1;
pub const CONFIG_PATA_HPT366_MODULE: u32 = 1;
pub const CONFIG_DMA_OPS: u32 = 1;
pub const CONFIG_KVM_COMMON: u32 = 1;
pub const CONFIG_HID_MCP2200_MODULE: u32 = 1;
pub const CONFIG_NET_EGRESS: u32 = 1;
pub const CONFIG_SND_SOC_FSL_UTILS_MODULE: u32 = 1;
pub const CONFIG_XEN_AUTO_XLATE: u32 = 1;
pub const CONFIG_RMI4_CORE_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ARC: u32 = 1;
pub const CONFIG_SCHED_MC_PRIO: u32 = 1;
pub const CONFIG_IP_SET_HASH_MAC_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_BD663474_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ENGINE_MODULE: u32 = 1;
pub const CONFIG_GP_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_INET_AH_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ATXP1_MODULE: u32 = 1;
pub const CONFIG_RANDOMIZE_KSTACK_OFFSET: u32 = 1;
pub const CONFIG_HID_LENOVO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98373_MODULE: u32 = 1;
pub const CONFIG_HAVE_USER_RETURN_NOTIFIER: u32 = 1;
pub const CONFIG_SND_SOC_ADAU17X1_MODULE: u32 = 1;
pub const CONFIG_MTD_UBI_BEB_LIMIT: u32 = 20;
pub const CONFIG_DRM_I2C_CH7006_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_KBTAB_MODULE: u32 = 1;
pub const CONFIG_AMD_PMF_DEBUG: u32 = 1;
pub const CONFIG_PATA_PARPORT_COMM_MODULE: u32 = 1;
pub const CONFIG_UDF_FS_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1343_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYTCR_RT5640_MACH_MODULE: u32 = 1;
pub const CONFIG_IPV6_MIP6_MODULE: u32 = 1;
pub const CONFIG_MARVELL_PHY_MODULE: u32 = 1;
pub const CONFIG_NFT_SOCKET_MODULE: u32 = 1;
pub const CONFIG_HAVE_PERF_USER_STACK_DUMP: u32 = 1;
pub const CONFIG_ACPI_EC_DEBUGFS_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_SECURITY: u32 = 1;
pub const CONFIG_SENSORS_ADM1266_MODULE: u32 = 1;
pub const CONFIG_APPLE_PROPERTIES: u32 = 1;
pub const CONFIG_VXFS_FS_MODULE: u32 = 1;
pub const CONFIG_USB_CONN_GPIO_MODULE: u32 = 1;
pub const CONFIG_RMI4_F3A: u32 = 1;
pub const CONFIG_GPIO_SCH_MODULE: u32 = 1;
pub const CONFIG_CGROUP_PERF: u32 = 1;
pub const CONFIG_NLATTR: u32 = 1;
pub const CONFIG_SND_LOLA_MODULE: u32 = 1;
pub const CONFIG_ISDN_CAPI: u32 = 1;
pub const CONFIG_HOTPLUG_PCI: u32 = 1;
pub const CONFIG_IIO_ADIS_LIB_MODULE: u32 = 1;
pub const CONFIG_LOCK_DOWN_KERNEL_FORCE_NONE: u32 = 1;
pub const CONFIG_ZD1211RW_MODULE: u32 = 1;
pub const CONFIG_SRF08_MODULE: u32 = 1;
pub const CONFIG_VEML6075_MODULE: u32 = 1;
pub const CONFIG_PCI_PF_STUB_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_CUBIC: u32 = 1;
pub const CONFIG_CEPH_FS_MODULE: u32 = 1;
pub const CONFIG_MPL115_SPI_MODULE: u32 = 1;
pub const CONFIG_SGI_XP_MODULE: u32 = 1;
pub const CONFIG_SCSI_NETLINK: u32 = 1;
pub const CONFIG_BACKLIGHT_BD6107_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_ST33ZP24_I2C_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS: u32 = 8192;
pub const CONFIG_IXGBE_MODULE: u32 = 1;
pub const CONFIG_SUSPEND_FREEZER: u32 = 1;
pub const CONFIG_HAVE_EXIT_THREAD: u32 = 1;
pub const CONFIG_IIO_BUFFER_CB_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AR0521_MODULE: u32 = 1;
pub const CONFIG_GPIO_CRYSTAL_COVE: u32 = 1;
pub const CONFIG_USB_MOUSE_MODULE: u32 = 1;
pub const CONFIG_B43_SSB: u32 = 1;
pub const CONFIG_SND_SUPPORT_OLD_API: u32 = 1;
pub const CONFIG_DVB_DIB7000M_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_ENA_ETHERNET_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L35_MODULE: u32 = 1;
pub const CONFIG_NR_CPUS_RANGE_BEGIN: u32 = 8192;
pub const CONFIG_IIO_ST_ACCEL_SPI_3AXIS_MODULE: u32 = 1;
pub const CONFIG_LEDS_LT3593_MODULE: u32 = 1;
pub const CONFIG_NO_HZ_FULL: u32 = 1;
pub const CONFIG_LOGITECH_FF: u32 = 1;
pub const CONFIG_BOOTTIME_TRACING: u32 = 1;
pub const CONFIG_DVB_AF9033_MODULE: u32 = 1;
pub const CONFIG_IPV6_FOU_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_INTEL_ISHTP_ECLITE_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_RAW_MODULE: u32 = 1;
pub const CONFIG_EDAC_PND2_MODULE: u32 = 1;
pub const CONFIG_HID_KYE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6360_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_TRACKPOINT: u32 = 1;
pub const CONFIG_CRYPTO_CHACHA20_MODULE: u32 = 1;
pub const CONFIG_HID_GEMBIRD_MODULE: u32 = 1;
pub const CONFIG_MOUSE_VSXXXAA_MODULE: u32 = 1;
pub const CONFIG_IP_MROUTE_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_VEML6030_MODULE: u32 = 1;
pub const CONFIG_NFT_COMPAT_MODULE: u32 = 1;
pub const CONFIG_LEDS_PCA963X_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_SY7636A_MODULE: u32 = 1;
pub const CONFIG_DRM_NOUVEAU_BACKLIGHT: u32 = 1;
pub const CONFIG_SOFT_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_SYSFS: u32 = 1;
pub const CONFIG_CRYPTO_ARIA_GFNI_AVX512_X86_64_MODULE: u32 = 1;
pub const CONFIG_TYPEC_TCPCI_MT6370_MODULE: u32 = 1;
pub const CONFIG_IPWIRELESS_MODULE: u32 = 1;
pub const CONFIG_IP_SET_BITMAP_IPMAC_MODULE: u32 = 1;
pub const CONFIG_ISCSI_TARGET_CXGB4_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_RICOH_MODULE: u32 = 1;
pub const CONFIG_NETFS_STATS: u32 = 1;
pub const CONFIG_USB_DEFAULT_PERSIST: u32 = 1;
pub const CONFIG_ARCH_HAS_PARANOID_L1D_FLUSH: u32 = 1;
pub const CONFIG_PANEL_PARPORT: u32 = 0;
pub const CONFIG_DVB_MN88473_MODULE: u32 = 1;
pub const CONFIG_LIB80211_CRYPT_WEP_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_MODULE: u32 = 1;
pub const CONFIG_SBP_TARGET_MODULE: u32 = 1;
pub const CONFIG_DEVICE_MIGRATION: u32 = 1;
pub const CONFIG_SENSORS_W83791D_MODULE: u32 = 1;
pub const CONFIG_HID_SENSOR_CUSTOM_INTEL_HINGE_MODULE: u32 = 1;
pub const CONFIG_INPUT_TOUCHSCREEN: u32 = 1;
pub const CONFIG_RT2800USB_UNKNOWN: u32 = 1;
pub const CONFIG_RADIO_SI4713_MODULE: u32 = 1;
pub const CONFIG_DRM_PANEL_BRIDGE: u32 = 1;
pub const CONFIG_RIONET_RX_SIZE: u32 = 128;
pub const CONFIG_JAILHOUSE_GUEST: u32 = 1;
pub const CONFIG_SND_SOC_CS42L51_I2C_MODULE: u32 = 1;
pub const CONFIG_ROCKCHIP_PHY_MODULE: u32 = 1;
pub const CONFIG_USB_HUB_USB251XB_MODULE: u32 = 1;
pub const CONFIG_I2C_VIAPRO_MODULE: u32 = 1;
pub const CONFIG_FB_HYPERV_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_NW80X_MODULE: u32 = 1;
pub const CONFIG_NF_CONNTRACK_LABELS: u32 = 1;
pub const CONFIG_INFINIBAND_ERDMA_MODULE: u32 = 1;
pub const CONFIG_GPIO_ADP5520_MODULE: u32 = 1;
pub const CONFIG_ASN1_ENCODER: u32 = 1;
pub const CONFIG_RTC_DRV_RC5T583_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_AH_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_SRP_MODULE: u32 = 1;
pub const CONFIG_CARL9170_WPC: u32 = 1;
pub const CONFIG_GPIO_BD9571MWV_MODULE: u32 = 1;
pub const CONFIG_XDP_SOCKETS: u32 = 1;
pub const CONFIG_VIDEO_SAA7134_GO7007_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_VENO_MODULE: u32 = 1;
pub const CONFIG_DVB_S5H1420_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_MODULE: u32 = 1;
pub const CONFIG_AFS_FS_MODULE: u32 = 1;
pub const CONFIG_MFD_88PM800_MODULE: u32 = 1;
pub const CONFIG_SLIMBUS_MODULE: u32 = 1;
pub const CONFIG_SMC_MODULE: u32 = 1;
pub const CONFIG_COMEDI_S526_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DAS1800_MODULE: u32 = 1;
pub const CONFIG_USB_EHCI_HCD_PLATFORM: u32 = 1;
pub const CONFIG_DVB_NET: u32 = 1;
pub const CONFIG_MEDIA_CEC_RC: u32 = 1;
pub const CONFIG_BLK_DEV_BSG_COMMON: u32 = 1;
pub const CONFIG_ASN1: u32 = 1;
pub const CONFIG_BT_MTK_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_LIMIT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_AES_NI_INTEL_MODULE: u32 = 1;
pub const CONFIG_NFC_SHDLC: u32 = 1;
pub const CONFIG_CRYPTO_DEV_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_MFD_WM8998: u32 = 1;
pub const CONFIG_ULI526X_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_BU21013_MODULE: u32 = 1;
pub const CONFIG_I2C_SIMTEC_MODULE: u32 = 1;
pub const CONFIG_ROHM_BU27034_MODULE: u32 = 1;
pub const CONFIG_FB_SMSCUFX_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_NTB_TRANSPORT_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_ARM: u32 = 1;
pub const CONFIG_MAX44000_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_775_MODULE: u32 = 1;
pub const CONFIG_MFD_TI_LMU_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_EEM: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_OPTIONAL: u32 = 1;
pub const CONFIG_RTLLIB_CRYPTO_TKIP_MODULE: u32 = 1;
pub const CONFIG_QCOM_QMI_HELPERS_MODULE: u32 = 1;
pub const CONFIG_MOUSE_SERIAL_MODULE: u32 = 1;
pub const CONFIG_FB_DMAMEM_HELPERS: u32 = 1;
pub const CONFIG_CRYPTO_HASH_INFO: u32 = 1;
pub const CONFIG_INTEL_ATOMISP2_LED_MODULE: u32 = 1;
pub const CONFIG_IMA_KEXEC: u32 = 1;
pub const CONFIG_JOYSTICK_ANALOG_MODULE: u32 = 1;
pub const CONFIG_MISDN_HFCPCI_MODULE: u32 = 1;
pub const CONFIG_QED_FCOE: u32 = 1;
pub const CONFIG_HAVE_SYSCALL_TRACEPOINTS: u32 = 1;
pub const CONFIG_HAVE_ARCH_HUGE_VMALLOC: u32 = 1;
pub const CONFIG_NFC_ST_NCI_I2C_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_COMMON_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_XC4000_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_DEVGROUP_MODULE: u32 = 1;
pub const CONFIG_ACPI_BATTERY: u32 = 1;
pub const CONFIG_IO_WQ: u32 = 1;
pub const CONFIG_DECOMPRESS_ZSTD: u32 = 1;
pub const CONFIG_XEN_PV_DOM0: u32 = 1;
pub const CONFIG_SND_SOC_TAS571X_MODULE: u32 = 1;
pub const CONFIG_DVB_LGDT3305_MODULE: u32 = 1;
pub const CONFIG_CAN_HI311X_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RX6110_MODULE: u32 = 1;
pub const CONFIG_FUJITSU_TABLET_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_PRESS_SPI_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_MPR121_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_AFU_MODULE: u32 = 1;
pub const CONFIG_VIDEO_USBTV_MODULE: u32 = 1;
pub const CONFIG_EEPROM_IDT_89HPESX_MODULE: u32 = 1;
pub const CONFIG_PM_DEVFREQ: u32 = 1;
pub const CONFIG_MFD_JANZ_CMODIO_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SAA7146_MODULE: u32 = 1;
pub const CONFIG_XILINX_EMACLITE_MODULE: u32 = 1;
pub const CONFIG_MTD_COMPLEX_MAPPINGS: u32 = 1;
pub const CONFIG_MARVELL_10G_PHY_MODULE: u32 = 1;
pub const CONFIG_FB: u32 = 1;
pub const CONFIG_NET_DSA_REALTEK_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_LOG_MODULE: u32 = 1;
pub const CONFIG_X86_HAVE_PAE: u32 = 1;
pub const CONFIG_BATTERY_DA9030_MODULE: u32 = 1;
pub const CONFIG_IMA_NG_TEMPLATE: u32 = 1;
pub const CONFIG_TRACING: u32 = 1;
pub const CONFIG_IIO_SYSFS_TRIGGER_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_LMI_MODULE: u32 = 1;
pub const CONFIG_BLK_MQ_VIRTIO: u32 = 1;
pub const CONFIG_TOUCHSCREEN_S6SY761_MODULE: u32 = 1;
pub const CONFIG_IP_NF_MATCH_RPFILTER_MODULE: u32 = 1;
pub const CONFIG_IR_IMON_RAW_MODULE: u32 = 1;
pub const CONFIG_REGMAP_W1_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_865_MODULE: u32 = 1;
pub const CONFIG_TASKS_RUDE_RCU: u32 = 1;
pub const CONFIG_I2C_COMPAT: u32 = 1;
pub const CONFIG_KEYBOARD_OPENCORES_MODULE: u32 = 1;
pub const CONFIG_DRM_SCHED_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ZYDAS: u32 = 1;
pub const CONFIG_SECURITY_LOCKDOWN_LSM_EARLY: u32 = 1;
pub const CONFIG_EFI_DEV_PATH_PARSER: u32 = 1;
pub const CONFIG_REGULATOR_MT6332_MODULE: u32 = 1;
pub const CONFIG_INET_SCTP_DIAG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_BYT_CHT_DA7213_MACH_MODULE: u32 = 1;
pub const CONFIG_NFSD_V3_ACL: u32 = 1;
pub const CONFIG_SND_SOC_SSM4567_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_XRS700X_I2C_MODULE: u32 = 1;
pub const CONFIG_SDR_MAX2175_MODULE: u32 = 1;
pub const CONFIG_CALL_THUNKS: u32 = 1;
pub const CONFIG_USB_GSPCA_SPCA500_MODULE: u32 = 1;
pub const CONFIG_SPARSEMEM_VMEMMAP_ENABLE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_CPU: u32 = 1;
pub const CONFIG_PC300TOO_MODULE: u32 = 1;
pub const CONFIG_HID_ELO_MODULE: u32 = 1;
pub const CONFIG_CAN_CTUCANFD_PCI_MODULE: u32 = 1;
pub const CONFIG_ENCX24J600_MODULE: u32 = 1;
pub const CONFIG_IPVLAN_MODULE: u32 = 1;
pub const CONFIG_HALTPOLL_CPUIDLE_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC_SIG: u32 = 1;
pub const CONFIG_COMEDI_NI_LABPC_ISADMA_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RV3028_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_DA7213_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_NAT_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DS2780_MODULE: u32 = 1;
pub const CONFIG_GPIO_104_IDI_48_MODULE: u32 = 1;
pub const CONFIG_NFC_PORT100_MODULE: u32 = 1;
pub const CONFIG_FTRACE_MCOUNT_RECORD: u32 = 1;
pub const CONFIG_OCFS2_FS_STATS: u32 = 1;
pub const CONFIG_DRM_SSD130X_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PCI_MODULE: u32 = 1;
pub const CONFIG_MFD_SKY81452_MODULE: u32 = 1;
pub const CONFIG_VIRTUALIZATION: u32 = 1;
pub const CONFIG_ND_CLAIM: u32 = 1;
pub const CONFIG_MSDOS_PARTITION: u32 = 1;
pub const CONFIG_USB_CHIPIDEA_PCI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_RTI800_MODULE: u32 = 1;
pub const CONFIG_MXC4005_MODULE: u32 = 1;
pub const CONFIG_RTC_I2C_AND_SPI: u32 = 1;
pub const CONFIG_VIRT_CPU_ACCOUNTING_GEN: u32 = 1;
pub const CONFIG_MYRI10GE_DCA: u32 = 1;
pub const CONFIG_VIDEO_OV08X40_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_MODULE: u32 = 1;
pub const CONFIG_RESET_ATTACK_MITIGATION: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_NEXIO: u32 = 1;
pub const CONFIG_RT2800USB_RT33XX: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_TOPLEVEL: u32 = 1;
pub const CONFIG_SND_SOC_WM8903_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBP22_MODULE: u32 = 1;
pub const CONFIG_SENSORS_WM831X_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_INTEL: u32 = 1;
pub const CONFIG_RTC_DRV_TPS6586X_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV2659_MODULE: u32 = 1;
pub const CONFIG_HAVE_CONTEXT_TRACKING_USER_OFFSTACK: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_APOLLOLAKE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TMP421_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8804_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM186X_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT711_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_FB_RADEON_I2C: u32 = 1;
pub const CONFIG_HMEM_REPORTING: u32 = 1;
pub const CONFIG_DVB_RTL2832_SDR_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_PCIEFD_MODULE: u32 = 1;
pub const CONFIG_HAVE_POSIX_CPU_TIMERS_TASK_WORK: u32 = 1;
pub const CONFIG_USB_GSPCA_SN9C2028_MODULE: u32 = 1;
pub const CONFIG_SUNGEM_MODULE: u32 = 1;
pub const CONFIG_BLK_INLINE_ENCRYPTION_FALLBACK: u32 = 1;
pub const CONFIG_BMP280_I2C_MODULE: u32 = 1;
pub const CONFIG_IR_STREAMZAP_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CS8409_MODULE: u32 = 1;
pub const CONFIG_SAMPLE_FTRACE_DIRECT_MODULE: u32 = 1;
pub const CONFIG_SND_HDSPM_MODULE: u32 = 1;
pub const CONFIG_CAN_PEAK_PCIEC: u32 = 1;
pub const CONFIG_EFI_VARS_PSTORE_MODULE: u32 = 1;
pub const CONFIG_X86_INTEL_LPSS: u32 = 1;
pub const CONFIG_USB_SERIAL_XR_MODULE: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_LADDER: u32 = 1;
pub const CONFIG_CPU_SUP_ZHAOXIN: u32 = 1;
pub const CONFIG_ACPI_PLATFORM_PROFILE_MODULE: u32 = 1;
pub const CONFIG_LEGACY_DIRECT_IO: u32 = 1;
pub const CONFIG_IP_SET_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_PADDING_BYTES: u32 = 16;
pub const CONFIG_I2C_CCGX_UCSI_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_XIPHERA_MODULE: u32 = 1;
pub const CONFIG_THERMAL: u32 = 1;
pub const CONFIG_DVB_BUDGET_PATCH_MODULE: u32 = 1;
pub const CONFIG_SYNC_FILE: u32 = 1;
pub const CONFIG_USB_XHCI_PCI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TOUCHRIGHT_MODULE: u32 = 1;
pub const CONFIG_AMD8111_ETH_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADL_PCI8164_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ACPI_INTEL_MATCH_MODULE: u32 = 1;
pub const CONFIG_XEN_ACPI: u32 = 1;
pub const CONFIG_AMD_IOMMU: u32 = 1;
pub const CONFIG_I2C_AMD8111_MODULE: u32 = 1;
pub const CONFIG_INPUT_POWERMATE_MODULE: u32 = 1;
pub const CONFIG_OVERLAY_FS_XINO_AUTO: u32 = 1;
pub const CONFIG_NET_FC: u32 = 1;
pub const CONFIG_ACPI_WATCHDOG: u32 = 1;
pub const CONFIG_FB_S3_MODULE: u32 = 1;
pub const CONFIG_PSTORE_BLK_MODULE: u32 = 1;
pub const CONFIG_ADA4250_MODULE: u32 = 1;
pub const CONFIG_BRCMUTIL_MODULE: u32 = 1;
pub const CONFIG_USB4_MODULE: u32 = 1;
pub const CONFIG_SI1133_MODULE: u32 = 1;
pub const CONFIG_DVB_TTUSB_BUDGET_MODULE: u32 = 1;
pub const CONFIG_VETH_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF8583_MODULE: u32 = 1;
pub const CONFIG_DVB_MT312_MODULE: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_ACP63_MODULE: u32 = 1;
pub const CONFIG_MLX5_CORE_EN: u32 = 1;
pub const CONFIG_LEDS_PCA955X_GPIO: u32 = 1;
pub const CONFIG_MFD_TPS65912_I2C: u32 = 1;
pub const CONFIG_NET_VENDOR_3COM: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ROHM_BU21023_MODULE: u32 = 1;
pub const CONFIG_ATM_DUMMY_MODULE: u32 = 1;
pub const CONFIG_MAX517_MODULE: u32 = 1;
pub const CONFIG_HID_PETALYNX_MODULE: u32 = 1;
pub const CONFIG_AMD_NUMA: u32 = 1;
pub const CONFIG_MTD_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_XPOWER_PMIC_OPREGION: u32 = 1;
pub const CONFIG_FB_ATY_CT: u32 = 1;
pub const CONFIG_STACKPROTECTOR: u32 = 1;
pub const CONFIG_IRQ_BYPASS_MANAGER_MODULE: u32 = 1;
pub const CONFIG_ADXRS450_MODULE: u32 = 1;
pub const CONFIG_TLAN_MODULE: u32 = 1;
pub const CONFIG_ARCH_ENABLE_SPLIT_PMD_PTLOCK: u32 = 1;
pub const CONFIG_COMEDI_AMPLC_PCI230_MODULE: u32 = 1;
pub const CONFIG_SEV_GUEST_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM3060_SPI_MODULE: u32 = 1;
pub const CONFIG_SFC_SIENA_MTD: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_VIA_MODULE: u32 = 1;
pub const CONFIG_CMDLINE_PARTITION: u32 = 1;
pub const CONFIG_MEMSTICK_TIFM_MS_MODULE: u32 = 1;
pub const CONFIG_ATM_LANE_MODULE: u32 = 1;
pub const CONFIG_MLXSW_CORE_THERMAL: u32 = 1;
pub const CONFIG_COMMON_CLK_PWM_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_CHACHA_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83L786NG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_PCM1681_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_MIRRED_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KGDB: u32 = 1;
pub const CONFIG_ARCH_USE_QUEUED_SPINLOCKS: u32 = 1;
pub const CONFIG_IMA_DEFAULT_HASH: &[u8; 7usize] = b"sha256\0";
pub const CONFIG_SOUNDWIRE_CADENCE_MODULE: u32 = 1;
pub const CONFIG_INPUT_APANEL_MODULE: u32 = 1;
pub const CONFIG_NF_TPROXY_IPV4_MODULE: u32 = 1;
pub const CONFIG_B43_PCICORE_AUTOSELECT: u32 = 1;
pub const CONFIG_BLK_DEBUG_FS: u32 = 1;
pub const CONFIG_KEYBOARD_CYPRESS_SF_MODULE: u32 = 1;
pub const CONFIG_QLCNIC_SRIOV: u32 = 1;
pub const CONFIG_MYRI10GE_MODULE: u32 = 1;
pub const CONFIG_X86_PM_TIMER: u32 = 1;
pub const CONFIG_TI_ADC161S626_MODULE: u32 = 1;
pub const CONFIG_USB_VL600_MODULE: u32 = 1;
pub const CONFIG_VIDEO_IMX355_MODULE: u32 = 1;
pub const CONFIG_ISL29501_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_HID_SENSOR_TIME_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ZONE_DMA_SET: u32 = 1;
pub const CONFIG_ZPA2326_I2C_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_HWRNG: u32 = 1;
pub const CONFIG_NET_DSA_TAG_LAN9303_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_RT5672_MACH_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_REMBRANDT_MODULE: u32 = 1;
pub const CONFIG_ATH9K_BTCOEX_SUPPORT: u32 = 1;
pub const CONFIG_CAN_SOFTING_MODULE: u32 = 1;
pub const CONFIG_STM_DUMMY_MODULE: u32 = 1;
pub const CONFIG_WIRELESS_HOTKEY_MODULE: u32 = 1;
pub const CONFIG_AMDTEE_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_DUMMY_MODULE: u32 = 1;
pub const CONFIG_VIDEOBUF2_V4L2_MODULE: u32 = 1;
pub const CONFIG_SPI_LJCA_MODULE: u32 = 1;
pub const CONFIG_X86_DEBUG_FPU: u32 = 1;
pub const CONFIG_SCSI_MVSAS_MODULE: u32 = 1;
pub const CONFIG_CPU_FREQ_GOV_SCHEDUTIL: u32 = 1;
pub const CONFIG_ADIS16260_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_INTEL: u32 = 1;
pub const CONFIG_HAVE_SOFTIRQ_ON_OWN_STACK: u32 = 1;
pub const CONFIG_NFC_PN544_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TAS2552_MODULE: u32 = 1;
pub const CONFIG_RPS: u32 = 1;
pub const CONFIG_PACKET_DIAG_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IMG_I2S_OUT_MODULE: u32 = 1;
pub const CONFIG_DVB_AU8522_DTV_MODULE: u32 = 1;
pub const CONFIG_USB_NET_ZAURUS_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_EXAR_MODULE: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_PERFORMANCE: u32 = 1;
pub const CONFIG_INET6_XFRM_TUNNEL_MODULE: u32 = 1;
pub const CONFIG_DRM_AST_MODULE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_ST_MODULE: u32 = 1;
pub const CONFIG_NET_TEAM_MODE_RANDOM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM95241_MODULE: u32 = 1;
pub const CONFIG_CXL_PCI_MODULE: u32 = 1;
pub const CONFIG_PROC_PID_CPUSET: u32 = 1;
pub const CONFIG_CPU_IDLE_GOV_TEO: u32 = 1;
pub const CONFIG_REALTEK_AUTOPM: u32 = 1;
pub const CONFIG_IEEE802154_ADF7242_MODULE: u32 = 1;
pub const CONFIG_USB_NET_AX88179_178A_MODULE: u32 = 1;
pub const CONFIG_FB_METRONOME_MODULE: u32 = 1;
pub const CONFIG_CHARGER_LTC4162L_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_USB_MV_U3D_MODULE: u32 = 1;
pub const CONFIG_AD525X_DPOT_SPI_MODULE: u32 = 1;
pub const CONFIG_BATTERY_GAUGE_LTC2941_MODULE: u32 = 1;
pub const CONFIG_INET_ESP_OFFLOAD_MODULE: u32 = 1;
pub const CONFIG_PM_GENERIC_DOMAINS: u32 = 1;
pub const CONFIG_MICROSOFT_MANA_MODULE: u32 = 1;
pub const CONFIG_BINDGEN_VERSION_TEXT: &[u8; 15usize] = b"bindgen 0.65.1\0";
pub const CONFIG_LEGACY_PTY_COUNT: u32 = 0;
pub const CONFIG_IIO_BACKEND_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_E4000_MODULE: u32 = 1;
pub const CONFIG_PMS7003_MODULE: u32 = 1;
pub const CONFIG_INPUT_ATLAS_BTNS_MODULE: u32 = 1;
pub const CONFIG_LOAD_UEFI_KEYS: u32 = 1;
pub const CONFIG_ACQUIRE_WDT_MODULE: u32 = 1;
pub const CONFIG_PM_WAKELOCKS_LIMIT: u32 = 100;
pub const CONFIG_VIDEO_SAA6588_MODULE: u32 = 1;
pub const CONFIG_IPV6_FOU_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_DMC_TSC10: u32 = 1;
pub const CONFIG_DVB_ZL10039_MODULE: u32 = 1;
pub const CONFIG_INTEL_ATOMISP2_PM_MODULE: u32 = 1;
pub const CONFIG_MTD_MAP_BANK_WIDTH_2: u32 = 1;
pub const CONFIG_USB_AUDIO_MODULE: u32 = 1;
pub const CONFIG_NFT_REJECT_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_RDMA_MODULE: u32 = 1;
pub const CONFIG_WDTPCI_MODULE: u32 = 1;
pub const CONFIG_STX104_MODULE: u32 = 1;
pub const CONFIG_LG_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_DEBUG_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX16064_MODULE: u32 = 1;
pub const CONFIG_IP_SET_HASH_IPPORTIP_MODULE: u32 = 1;
pub const CONFIG_MLX4_EN_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_ACECAD_MODULE: u32 = 1;
pub const CONFIG_HYPERVISOR_GUEST: u32 = 1;
pub const CONFIG_SENSORS_LM70_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MAX310X: u32 = 1;
pub const CONFIG_SECURITY_SMACK_NETFILTER: u32 = 1;
pub const CONFIG_NET_EMATCH_NBYTE_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_XRS700X_MODULE: u32 = 1;
pub const CONFIG_RESET_SIMPLE: u32 = 1;
pub const CONFIG_SENSORS_BH1770_MODULE: u32 = 1;
pub const CONFIG_SIS190_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_UC1611_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MT6358_MODULE: u32 = 1;
pub const CONFIG_HID_RAZER_MODULE: u32 = 1;
pub const CONFIG_INTEL_INT0002_VGPIO_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_DMA_ENGINE: u32 = 1;
pub const CONFIG_CALL_PADDING: u32 = 1;
pub const CONFIG_FONT_TER16x32: u32 = 1;
pub const CONFIG_USB_BDC_UDC_MODULE: u32 = 1;
pub const CONFIG_TCG_NSC_MODULE: u32 = 1;
pub const CONFIG_PREFIX_SYMBOLS: u32 = 1;
pub const CONFIG_BCMA_SFLASH: u32 = 1;
pub const CONFIG_ZISOFS: u32 = 1;
pub const CONFIG_WLAN_VENDOR_MEDIATEK: u32 = 1;
pub const CONFIG_SND_SOC_ADAU1372_SPI_MODULE: u32 = 1;
pub const CONFIG_CUSE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8728_MODULE: u32 = 1;
pub const CONFIG_USB_ZERO_MODULE: u32 = 1;
pub const CONFIG_FB_SYSMEM_FOPS: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WM97XX_MODULE: u32 = 1;
pub const CONFIG_NF_TABLES_IPV4: u32 = 1;
pub const CONFIG_IP_MULTICAST: u32 = 1;
pub const CONFIG_FB_RADEON_MODULE: u32 = 1;
pub const CONFIG_DM_CACHE_SMQ_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AQUACOMPUTER_D5NEXT_MODULE: u32 = 1;
pub const CONFIG_DVB_MT352_MODULE: u32 = 1;
pub const CONFIG_RC_ATI_REMOTE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RTQ2134_MODULE: u32 = 1;
pub const CONFIG_W83627HF_WDT_MODULE: u32 = 1;
pub const CONFIG_SQUASHFS_XZ: u32 = 1;
pub const CONFIG_DRM_XE_MODULE: u32 = 1;
pub const CONFIG_FB_VOODOO1_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_EVENTS_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CX82310_ETH_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CMOS_UPDATE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_WM8804_MACH_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_CISCO: u32 = 1;
pub const CONFIG_REGULATOR_AS3711_MODULE: u32 = 1;
pub const CONFIG_EEPROM_MAX6875_MODULE: u32 = 1;
pub const CONFIG_ACPI_ALS_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5682S_MODULE: u32 = 1;
pub const CONFIG_W1_MASTER_MATROX_MODULE: u32 = 1;
pub const CONFIG_DRM_CIRRUS_QEMU_MODULE: u32 = 1;
pub const CONFIG_MAX31827_MODULE: u32 = 1;
pub const CONFIG_MOUSE_APPLETOUCH_MODULE: u32 = 1;
pub const CONFIG_INTEL_SPEED_SELECT_TPMI_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ256XX_MODULE: u32 = 1;
pub const CONFIG_HID_LOGITECH_DJ_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_PTE_DEVMAP: u32 = 1;
pub const CONFIG_MFD_DLN2_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_WCD939X_USBSS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_STK1160_MODULE: u32 = 1;
pub const CONFIG_BT_LEDS: u32 = 1;
pub const CONFIG_GIGABYTE_WMI_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DH: u32 = 1;
pub const CONFIG_FUNCTION_ERROR_INJECTION: u32 = 1;
pub const CONFIG_TICK_ONESHOT: u32 = 1;
pub const CONFIG_USB_CDNS3_PCI_WRAP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_PCI_DEV_MODULE: u32 = 1;
pub const CONFIG_FB_I740_MODULE: u32 = 1;
pub const CONFIG_XEN_PCIDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_XFS_SUPPORT_ASCII_CI: u32 = 1;
pub const CONFIG_HID_BETOP_FF_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SIERRAWIRELESS_MODULE: u32 = 1;
pub const CONFIG_INTEL_HFI_THERMAL: u32 = 1;
pub const CONFIG_CRYPTO_CTR: u32 = 1;
pub const CONFIG_SND_SOC_MAX9867_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPS6586X: u32 = 1;
pub const CONFIG_CAN_F81601_MODULE: u32 = 1;
pub const CONFIG_PCMCIA_XIRC2PS_MODULE: u32 = 1;
pub const CONFIG_COMPAT_FOR_U64_ALIGNMENT: u32 = 1;
pub const CONFIG_MTRR_SANITIZER: u32 = 1;
pub const CONFIG_GNSS_UBX_SERIAL_MODULE: u32 = 1;
pub const CONFIG_XARRAY_MULTI: u32 = 1;
pub const CONFIG_LOCK_MM_AND_FIND_VMA: u32 = 1;
pub const CONFIG_DVB_STV090x_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_RTL4_A_MODULE: u32 = 1;
pub const CONFIG_USB_CDNS3_GADGET: u32 = 1;
pub const CONFIG_CROS_EC_ISHTP_MODULE: u32 = 1;
pub const CONFIG_SCSI_HPTIOP_MODULE: u32 = 1;
pub const CONFIG_NATIONAL_PHY_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_PCICORE_AUTOSELECT: u32 = 1;
pub const CONFIG_SW_SYNC: u32 = 1;
pub const CONFIG_REGMAP_SCCB_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_LB_SS: u32 = 1;
pub const CONFIG_INTEL_VSC_MODULE: u32 = 1;
pub const CONFIG_SPI_DW_PCI_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_KEYSPAN_PDA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TW68_MODULE: u32 = 1;
pub const CONFIG_WIRELESS_EXT: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2060_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_BACKLIGHT: u32 = 1;
pub const CONFIG_SND_SOC_RT5640_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ADV_PCI1710_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_CA0110_MODULE: u32 = 1;
pub const CONFIG_GPIO_TPS65910: u32 = 1;
pub const CONFIG_NFC_ST_NCI_MODULE: u32 = 1;
pub const CONFIG_BCACHEFS_POSIX_ACL: u32 = 1;
pub const CONFIG_VIDEO_GC2145_MODULE: u32 = 1;
pub const CONFIG_MAPPING_DIRTY_HELPERS: u32 = 1;
pub const CONFIG_SND_SOC_CHV3_I2S_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV6650_MODULE: u32 = 1;
pub const CONFIG_VDPA_SIM_BLOCK_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RS5C348_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PV88080_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6357_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_FTRTC010_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX9759_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL_DSP_CONFIG_MODULE: u32 = 1;
pub const CONFIG_STM_PROTO_SYS_T_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_PCM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX31730_MODULE: u32 = 1;
pub const CONFIG_MODVERSIONS: u32 = 1;
pub const CONFIG_HW_RANDOM: u32 = 1;
pub const CONFIG_B43_PCI_AUTOSELECT: u32 = 1;
pub const CONFIG_MUTEX_SPIN_ON_OWNER: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_MACH: u32 = 1;
pub const CONFIG_PATA_LEGACY_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_AU6610_MODULE: u32 = 1;
pub const CONFIG_CM3605_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_METEORPOINT_MODULE: u32 = 1;
pub const CONFIG_SPI_LM70_LLP_MODULE: u32 = 1;
pub const CONFIG_X86_SPEEDSTEP_LIB_MODULE: u32 = 1;
pub const CONFIG_IE6XX_WDT_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_RTL: u32 = 1;
pub const CONFIG_HAVE_ARCH_USERFAULTFD_MINOR: u32 = 1;
pub const CONFIG_MP2629_ADC_MODULE: u32 = 1;
pub const CONFIG_SYS_HYPERVISOR: u32 = 1;
pub const CONFIG_DYNAMIC_SIGFRAME: u32 = 1;
pub const CONFIG_TOUCHSCREEN_WACOM_I2C_MODULE: u32 = 1;
pub const CONFIG_USB_LEDS_TRIGGER_USBPORT_MODULE: u32 = 1;
pub const CONFIG_BOOT_VESA_SUPPORT: u32 = 1;
pub const CONFIG_SENSORS_HP_WMI_MODULE: u32 = 1;
pub const CONFIG_ATM_IA_MODULE: u32 = 1;
pub const CONFIG_RETHOOK: u32 = 1;
pub const CONFIG_VIRTIO_VSOCKETS_COMMON_MODULE: u32 = 1;
pub const CONFIG_SND_VIRTUOSO_MODULE: u32 = 1;
pub const CONFIG_AMIGA_PARTITION: u32 = 1;
pub const CONFIG_EARLY_PRINTK: u32 = 1;
pub const CONFIG_SND_SOC_WM8804_I2C_MODULE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_ALSA_SUPPORT: u32 = 1;
pub const CONFIG_CGROUP_NET_CLASSID: u32 = 1;
pub const CONFIG_SENSORS_ADS7871_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_TPL0102_MODULE: u32 = 1;
pub const CONFIG_MDIO_MVUSB_MODULE: u32 = 1;
pub const CONFIG_FS_DAX: u32 = 1;
pub const CONFIG_INTEL_TH_MSU_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5677_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_737_MODULE: u32 = 1;
pub const CONFIG_HAVE_FUNCTION_GRAPH_TRACER: u32 = 1;
pub const CONFIG_HW_RANDOM_VIA_MODULE: u32 = 1;
pub const CONFIG_SUNDANCE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83781D_MODULE: u32 = 1;
pub const CONFIG_PCI_EPF_VNTB_MODULE: u32 = 1;
pub const CONFIG_I2C_DESIGNWARE_PLATFORM: u32 = 1;
pub const CONFIG_BUFFER_HEAD: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305_GENERIC_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_JOB_TIMEOUT_MIN: u32 = 1;
pub const CONFIG_CAN_SOFTING_CS_MODULE: u32 = 1;
pub const CONFIG_DP83869_PHY_MODULE: u32 = 1;
pub const CONFIG_PTE_MARKER_UFFD_WP: u32 = 1;
pub const CONFIG_HAVE_CMPXCHG_LOCAL: u32 = 1;
pub const CONFIG_NVDIMM_PFN: u32 = 1;
pub const CONFIG_AF_KCM_MODULE: u32 = 1;
pub const CONFIG_VIDEOBUF2_CORE_MODULE: u32 = 1;
pub const CONFIG_DVB_HELENE_MODULE: u32 = 1;
pub const CONFIG_SSB_DRIVER_GPIO: u32 = 1;
pub const CONFIG_I2C_LJCA_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_IPC3: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_USER_FRIENDLY_LONG_NAMES: u32 = 1;
pub const CONFIG_SMB_SERVER_CHECK_CAP_NET_ADMIN: u32 = 1;
pub const CONFIG_CRYPTO_BLAKE2B_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_SCALABLE_MODE_DEFAULT_ON: u32 = 1;
pub const CONFIG_MTD_PHYSMAP_GPIO_ADDR: u32 = 1;
pub const CONFIG_EEEPC_WMI_MODULE: u32 = 1;
pub const CONFIG_INPUT_ADXL34X_I2C_MODULE: u32 = 1;
pub const CONFIG_TREE_SRCU: u32 = 1;
pub const CONFIG_CRYPTO_NULL2: u32 = 1;
pub const CONFIG_NTFS_FS_MODULE: u32 = 1;
pub const CONFIG_VIDEO_AU0828_V4L2: u32 = 1;
pub const CONFIG_REGULATOR_MAX8998_MODULE: u32 = 1;
pub const CONFIG_ACPI_THERMAL: u32 = 1;
pub const CONFIG_SLIM_QCOM_CTRL_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_LANTIQ_GSWIP_MODULE: u32 = 1;
pub const CONFIG_DPTF_PCH_FIVR_MODULE: u32 = 1;
pub const CONFIG_SND_SEQ_UMP_CLIENT_MODULE: u32 = 1;
pub const CONFIG_RT2X00_LIB_CRYPTO: u32 = 1;
pub const CONFIG_CRYPTO_LIB_DES_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_HP_SW_MODULE: u32 = 1;
pub const CONFIG_AMD_PMF_MODULE: u32 = 1;
pub const CONFIG_HSC030PA_I2C_MODULE: u32 = 1;
pub const CONFIG_FUNCTION_ALIGNMENT_16B: u32 = 1;
pub const CONFIG_IP_SCTP_MODULE: u32 = 1;
pub const CONFIG_DVB_STB0899_MODULE: u32 = 1;
pub const CONFIG_INPUT_SOC_BUTTON_ARRAY_MODULE: u32 = 1;
pub const CONFIG_P54_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ALDERLAKE_MODULE: u32 = 1;
pub const CONFIG_INSPUR_PLATFORM_PROFILE_MODULE: u32 = 1;
pub const CONFIG_AOSONG_AGS02MA_MODULE: u32 = 1;
pub const CONFIG_ACPI_MDIO: u32 = 1;
pub const CONFIG_MARVELL_88X2222_PHY_MODULE: u32 = 1;
pub const CONFIG_LEDS_ADP5520_MODULE: u32 = 1;
pub const CONFIG_SCSI_SIM710_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_ACPI_TABLE_UPGRADE: u32 = 1;
pub const CONFIG_MADERA_IRQ_MODULE: u32 = 1;
pub const CONFIG_HUGETLB_PAGE_OPTIMIZE_VMEMMAP: u32 = 1;
pub const CONFIG_SERIAL_8250_DMA: u32 = 1;
pub const CONFIG_FUNCTION_ALIGNMENT_4B: u32 = 1;
pub const CONFIG_VIDEO_IPU3_IMGU_MODULE: u32 = 1;
pub const CONFIG_BASE_SMALL: u32 = 0;
pub const CONFIG_IWLEGACY_DEBUGFS: u32 = 1;
pub const CONFIG_INPUT_GPIO_VIBRA_MODULE: u32 = 1;
pub const CONFIG_XEN_GRANT_DEV_ALLOC_MODULE: u32 = 1;
pub const CONFIG_PM_WAKELOCKS: u32 = 1;
pub const CONFIG_COUNTER_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_ATTRS_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_AVC_STATS: u32 = 1;
pub const CONFIG_RTL8187_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L56_I2C_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CMDLINE: u32 = 1;
pub const CONFIG_X86_PMEM_LEGACY_DEVICE: u32 = 1;
pub const CONFIG_NFP_APP_ABM_NIC: u32 = 1;
pub const CONFIG_SND_SEQ_DUMMY_MODULE: u32 = 1;
pub const CONFIG_QTNFMAC_MODULE: u32 = 1;
pub const CONFIG_B43LEGACY_PCI_AUTOSELECT: u32 = 1;
pub const CONFIG_DM_RAID_MODULE: u32 = 1;
pub const CONFIG_COMPACTION: u32 = 1;
pub const CONFIG_NFS_V2_MODULE: u32 = 1;
pub const CONFIG_RTW88_DEBUG: u32 = 1;
pub const CONFIG_USB_HCD_BCMA_MODULE: u32 = 1;
pub const CONFIG_SCSI_MPT3SAS_MAX_SGE: u32 = 128;
pub const CONFIG_CAN_SJA1000_ISA_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA18271C2DD_MODULE: u32 = 1;
pub const CONFIG_USB_AIRSPY_MODULE: u32 = 1;
pub const CONFIG_ALIENWARE_WMI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_CS42L42_MACH_MODULE: u32 = 1;
pub const CONFIG_DVB_CXD2820R_MODULE: u32 = 1;
pub const CONFIG_WM8350_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_MRVL: u32 = 1;
pub const CONFIG_VIDEO_TDA7432_MODULE: u32 = 1;
pub const CONFIG_TEST_POWER_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL_NHLT: u32 = 1;
pub const CONFIG_NF_DUP_IPV6_MODULE: u32 = 1;
pub const CONFIG_RTL8723BE_MODULE: u32 = 1;
pub const CONFIG_TMP117_MODULE: u32 = 1;
pub const CONFIG_Z3FOLD_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS2404_MODULE: u32 = 1;
pub const CONFIG_DM_ERA_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_DAQ_DIO24_CS_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SONIXJ_MODULE: u32 = 1;
pub const CONFIG_MFD_CS42L43_I2C_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_UART_BAUDRATE: u32 = 115200;
pub const CONFIG_THINKPAD_ACPI_HOTKEY_POLL: u32 = 1;
pub const CONFIG_REGULATOR_MT6323_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_F81232_MODULE: u32 = 1;
pub const CONFIG_DRM_AMDGPU_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_PUNT_BIO: u32 = 1;
pub const CONFIG_ARCH_HAS_UBSAN: u32 = 1;
pub const CONFIG_VIDEO_OV7670_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1553_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HAMPSHIRE_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_TSC2005_MODULE: u32 = 1;
pub const CONFIG_PROC_FS: u32 = 1;
pub const CONFIG_MMC_CB710_MODULE: u32 = 1;
pub const CONFIG_MTD_BLOCK_MODULE: u32 = 1;
pub const CONFIG_SND_OXFW_MODULE: u32 = 1;
pub const CONFIG_MPL3115_MODULE: u32 = 1;
pub const CONFIG_ACPI_HOTPLUG_MEMORY: u32 = 1;
pub const CONFIG_VIDEOBUF2_VMALLOC_MODULE: u32 = 1;
pub const CONFIG_NFT_BRIDGE_REJECT_MODULE: u32 = 1;
pub const CONFIG_GENERIC_BUG_RELATIVE_POINTERS: u32 = 1;
pub const CONFIG_SND_SOC_WM8523_MODULE: u32 = 1;
pub const CONFIG_6LOWPAN_NHC_FRAGMENT_MODULE: u32 = 1;
pub const CONFIG_SECURITY_TOMOYO: u32 = 1;
pub const CONFIG_RC_MAP_MODULE: u32 = 1;
pub const CONFIG_WEXT_PRIV: u32 = 1;
pub const CONFIG_MMU_GATHER_RCU_TABLE_FREE: u32 = 1;
pub const CONFIG_THINKPAD_ACPI_VIDEO: u32 = 1;
pub const CONFIG_VIRTIO_MMIO: u32 = 1;
pub const CONFIG_NET_VENDOR_ROCKER: u32 = 1;
pub const CONFIG_XFRM_AH_MODULE: u32 = 1;
pub const CONFIG_SCSI_LOWLEVEL: u32 = 1;
pub const CONFIG_SND_SOC_MAX98504_MODULE: u32 = 1;
pub const CONFIG_DP83822_PHY_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DH_RFC7919_GROUPS: u32 = 1;
pub const CONFIG_SND_SOC_CS42L83_MODULE: u32 = 1;
pub const CONFIG_EFI_SOFT_RESERVE: u32 = 1;
pub const CONFIG_NVME_KEYRING_MODULE: u32 = 1;
pub const CONFIG_ROSE_MODULE: u32 = 1;
pub const CONFIG_HYPERV_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_SPI_INTEL_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_ARASAN_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_CHTDC_TI_MODULE: u32 = 1;
pub const CONFIG_INTEL_SOC_DTS_IOSF_CORE_MODULE: u32 = 1;
pub const CONFIG_INPUT_GPIO_ROTARY_ENCODER_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_AH_ESP: u32 = 1;
pub const CONFIG_MTD_QINFO_PROBE_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_POWER_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_NAU8825_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT711_SDW_MODULE: u32 = 1;
pub const CONFIG_INPUT_DRV260X_HAPTICS_MODULE: u32 = 1;
pub const CONFIG_MEMFD_CREATE: u32 = 1;
pub const CONFIG_IRQ_FORCED_THREADING: u32 = 1;
pub const CONFIG_NILFS2_FS_MODULE: u32 = 1;
pub const CONFIG_ATH9K_PCI: u32 = 1;
pub const CONFIG_GNSS_SERIAL_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_DC_FP: u32 = 1;
pub const CONFIG_TOUCHSCREEN_HIDEEP_MODULE: u32 = 1;
pub const CONFIG_EDAC_ATOMIC_SCRUB: u32 = 1;
pub const CONFIG_NFSD_FLEXFILELAYOUT: u32 = 1;
pub const CONFIG_USB_F_HID_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_3_MODULE: u32 = 1;
pub const CONFIG_RSI_91X_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_PERF_EVENTS: u32 = 1;
pub const CONFIG_FB_OPENCORES_MODULE: u32 = 1;
pub const CONFIG_XEN_SYS_HYPERVISOR: u32 = 1;
pub const CONFIG_SND_SOC_NAU8315_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MT6315_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CMAC_MODULE: u32 = 1;
pub const CONFIG_DELL_SMBIOS_WMI: u32 = 1;
pub const CONFIG_INTEL_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_LIGHT_PROX_MODULE: u32 = 1;
pub const CONFIG_MAX30100_MODULE: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_F7188X_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TDA18250_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCL816_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_MAX98357A_MODULE: u32 = 1;
pub const CONFIG_HID_PANTHERLORD_MODULE: u32 = 1;
pub const CONFIG_DRM_FBDEV_EMULATION: u32 = 1;
pub const CONFIG_MTDRAM_ERASE_SIZE: u32 = 128;
pub const CONFIG_SND_MODULE: u32 = 1;
pub const CONFIG_MTD_ICHXROM_MODULE: u32 = 1;
pub const CONFIG_UBIFS_FS_AUTHENTICATION: u32 = 1;
pub const CONFIG_SND_SOC_STI_SAS_MODULE: u32 = 1;
pub const CONFIG_SND_SST_ATOM_HIFI2_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SST_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_GYRO_I2C_3AXIS_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_TEQL_MODULE: u32 = 1;
pub const CONFIG_MEMSTICK_JMICRON_38X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MCP3021_MODULE: u32 = 1;
pub const CONFIG_IR_RC6_DECODER_MODULE: u32 = 1;
pub const CONFIG_XEN_NETDEV_BACKEND_MODULE: u32 = 1;
pub const CONFIG_LTC2485_MODULE: u32 = 1;
pub const CONFIG_MFD_LP3943_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ABB5ZES3_MODULE: u32 = 1;
pub const CONFIG_SCSI_SNIC_MODULE: u32 = 1;
pub const CONFIG_KXCJK1013_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_MCP23S08_I2C_MODULE: u32 = 1;
pub const CONFIG_MTD_OOPS_MODULE: u32 = 1;
pub const CONFIG_IWLEGACY_MODULE: u32 = 1;
pub const CONFIG_SENSORS_TPS546D24_MODULE: u32 = 1;
pub const CONFIG_SCSI_INIA100_MODULE: u32 = 1;
pub const CONFIG_S2IO_MODULE: u32 = 1;
pub const CONFIG_IP_VS_SH_MODULE: u32 = 1;
pub const CONFIG_XEN_BALLOON: u32 = 1;
pub const CONFIG_PWM_CLK_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MSP3400_MODULE: u32 = 1;
pub const CONFIG_VIDEO_BT856_MODULE: u32 = 1;
pub const CONFIG_MCTP_SERIAL_MODULE: u32 = 1;
pub const CONFIG_USB_F_OBEX_MODULE: u32 = 1;
pub const CONFIG_PLIP_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SERPENT_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_TCG_TIS_SPI_MODULE: u32 = 1;
pub const CONFIG_MC3230_MODULE: u32 = 1;
pub const CONFIG_MT7921_COMMON_MODULE: u32 = 1;
pub const CONFIG_USB_PEGASUS_MODULE: u32 = 1;
pub const CONFIG_NMI_CHECK_CPU: u32 = 1;
pub const CONFIG_IIO_ST_MAGN_3AXIS_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_UC1701_MODULE: u32 = 1;
pub const CONFIG_HI8435_MODULE: u32 = 1;
pub const CONFIG_USB_TMC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8962_MODULE: u32 = 1;
pub const CONFIG_NET_VRF_MODULE: u32 = 1;
pub const CONFIG_INPUT_E3X0_BUTTON_MODULE: u32 = 1;
pub const CONFIG_USB_G_WEBCAM_MODULE: u32 = 1;
pub const CONFIG_SBC_EPX_C3_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_ATM_HE_USE_SUNI: u32 = 1;
pub const CONFIG_PCIE_DW: u32 = 1;
pub const CONFIG_ATH9K_PCI_NO_EEPROM_MODULE: u32 = 1;
pub const CONFIG_USB_CONFIGFS_F_MIDI2: u32 = 1;
pub const CONFIG_NET_DSA_SMSC_LAN9303_MODULE: u32 = 1;
pub const CONFIG_LD_ORPHAN_WARN: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_FD_MODULE: u32 = 1;
pub const CONFIG_LCD_HX8357_MODULE: u32 = 1;
pub const CONFIG_V4L_PLATFORM_DRIVERS: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2408_READBACK: u32 = 1;
pub const CONFIG_EVM: u32 = 1;
pub const CONFIG_X9250_MODULE: u32 = 1;
pub const CONFIG_SND_PCSP_MODULE: u32 = 1;
pub const CONFIG_FB_NVIDIA_I2C: u32 = 1;
pub const CONFIG_SND_SOC_SOF_HDA_COMMON_MODULE: u32 = 1;
pub const CONFIG_RFKILL_INPUT: u32 = 1;
pub const CONFIG_NXP_TJA11XX_PHY_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_USB6501_MODULE: u32 = 1;
pub const CONFIG_RAPIDIO_MPORT_CDEV_MODULE: u32 = 1;
pub const CONFIG_FB_CIRRUS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MAX20751_MODULE: u32 = 1;
pub const CONFIG_DEV_DAX_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_NATSEMI: u32 = 1;
pub const CONFIG_USB_MUSB_DUAL_ROLE: u32 = 1;
pub const CONFIG_BLK_DEV_BSGLIB: u32 = 1;
pub const CONFIG_NET_DSA_TAG_MTK_MODULE: u32 = 1;
pub const CONFIG_IOMMU_MM_DATA: u32 = 1;
pub const CONFIG_GPIO_TPS68470_MODULE: u32 = 1;
pub const CONFIG_ATH5K_PCI: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC2580_MODULE: u32 = 1;
pub const CONFIG_AQUANTIA_PHY_MODULE: u32 = 1;
pub const CONFIG_MFD_IQS62X_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_HANWANG_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_HAPS_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822CE_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_PCI_LIB_LEGACY: u32 = 1;
pub const CONFIG_USB_F_MASS_STORAGE_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_AAT2870_MODULE: u32 = 1;
pub const CONFIG_MFD_RT4831_MODULE: u32 = 1;
pub const CONFIG_MENF21BMC_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_ATH9K_COMMON_MODULE: u32 = 1;
pub const CONFIG_NFT_XFRM_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_GOOGLE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C62XVF_MODULE: u32 = 1;
pub const CONFIG_DVB_STB6000_MODULE: u32 = 1;
pub const CONFIG_SERIAL_FSL_LINFLEXUART_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L36_MODULE: u32 = 1;
pub const CONFIG_SND_FIREWIRE_MOTU_MODULE: u32 = 1;
pub const CONFIG_FW_CS_DSP_MODULE: u32 = 1;
pub const CONFIG_COMEDI_MISC_DRIVERS: u32 = 1;
pub const CONFIG_USB_SERIAL_QCAUX_MODULE: u32 = 1;
pub const CONFIG_NFSD_BLOCKLAYOUT: u32 = 1;
pub const CONFIG_SATA_ACARD_AHCI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_MIGRATION: u32 = 1;
pub const CONFIG_NET_VENDOR_NETRONOME: u32 = 1;
pub const CONFIG_NFS_USE_KERNEL_DNS: u32 = 1;
pub const CONFIG_SENSORS_MAX31722_MODULE: u32 = 1;
pub const CONFIG_MISDN_SPEEDFAX_MODULE: u32 = 1;
pub const CONFIG_SENSORS_IBMAEM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_GIGABYTE_WATERFORCE_MODULE: u32 = 1;
pub const CONFIG_DMA_ENGINE_RAID: u32 = 1;
pub const CONFIG_ARCH_HAS_FORTIFY_SOURCE: u32 = 1;
pub const CONFIG_GCC_VERSION: u32 = 130300;
pub const CONFIG_SND_HDA_I915: u32 = 1;
pub const CONFIG_CRYPTO_LIB_POLY1305_RSIZE: u32 = 11;
pub const CONFIG_SND_SEQ_UMP: u32 = 1;
pub const CONFIG_REGULATOR_MAX77541_MODULE: u32 = 1;
pub const CONFIG_QCOM_SPMI_VADC_MODULE: u32 = 1;
pub const CONFIG_HT16K33_MODULE: u32 = 1;
pub const CONFIG_EXTCON_PTN5150_MODULE: u32 = 1;
pub const CONFIG_LATTICE_ECP3_CONFIG_MODULE: u32 = 1;
pub const CONFIG_SYSCTL: u32 = 1;
pub const CONFIG_CRYPTO_DES3_EDE_X86_64_MODULE: u32 = 1;
pub const CONFIG_CC_CAN_LINK_STATIC: u32 = 1;
pub const CONFIG_842_DECOMPRESS_MODULE: u32 = 1;
pub const CONFIG_DWC_PCIE_PMU_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MR75203_MODULE: u32 = 1;
pub const CONFIG_BCM_VK_TTY: u32 = 1;
pub const CONFIG_ARCH_HAS_GCOV_PROFILE_ALL: u32 = 1;
pub const CONFIG_SND_USB_AUDIO_USE_MEDIA_CONTROLLER: u32 = 1;
pub const CONFIG_VIDEO_TLV320AIC23B_MODULE: u32 = 1;
pub const CONFIG_KERNEL_ZSTD: u32 = 1;
pub const CONFIG_BRIDGE_IGMP_SNOOPING: u32 = 1;
pub const CONFIG_SND_SOC_SRC4XXX_I2C_MODULE: u32 = 1;
pub const CONFIG_MTD_BLOCK2MTD_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_THERM_MODULE: u32 = 1;
pub const CONFIG_CAN_SLCAN_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_EP: u32 = 1;
pub const CONFIG_SND_SOC_WM_ADSP_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_TWIDJOY_MODULE: u32 = 1;
pub const CONFIG_EL3_MODULE: u32 = 1;
pub const CONFIG_PHYS_ADDR_T_64BIT: u32 = 1;
pub const CONFIG_COMEDI_DT2815_MODULE: u32 = 1;
pub const CONFIG_TI_ADS8344_MODULE: u32 = 1;
pub const CONFIG_MHI_WWAN_CTRL_MODULE: u32 = 1;
pub const CONFIG_X86_PLATFORM_DRIVERS_DELL: u32 = 1;
pub const CONFIG_SND_SOC_RT5663_MODULE: u32 = 1;
pub const CONFIG_THREAD_INFO_IN_TASK: u32 = 1;
pub const CONFIG_DVB_M88DS3103_MODULE: u32 = 1;
pub const CONFIG_NOZOMI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCL711_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_ULPI: u32 = 1;
pub const CONFIG_SND_SOC_RT1316_SDW_MODULE: u32 = 1;
pub const CONFIG_MLX4_EN_DCB: u32 = 1;
pub const CONFIG_NET_VENDOR_LITEX: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_AUDIT_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_842_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RTMV20_MODULE: u32 = 1;
pub const CONFIG_VT6655_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_PIXCIR_MODULE: u32 = 1;
pub const CONFIG_MLX90632_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_BUS_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_ACPI_MODULE: u32 = 1;
pub const CONFIG_WM831X_BACKUP_MODULE: u32 = 1;
pub const CONFIG_ADIN1100_PHY_MODULE: u32 = 1;
pub const CONFIG_HAVE_C_RECORDMCOUNT: u32 = 1;
pub const CONFIG_SENSORS_AXI_FAN_CONTROL_MODULE: u32 = 1;
pub const CONFIG_GENERIC_MSI_IRQ: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADCXX_MODULE: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE_WITH_ARGS: u32 = 1;
pub const CONFIG_SND_CS4281_MODULE: u32 = 1;
pub const CONFIG_COMEDI_8255_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_MT2131_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DELL_SMM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_EASRC_MODULE: u32 = 1;
pub const CONFIG_HID_THINGM_MODULE: u32 = 1;
pub const CONFIG_USB_NET_KALMIA_MODULE: u32 = 1;
pub const CONFIG_ZSWAP_SHRINKER_DEFAULT_ON: u32 = 1;
pub const CONFIG_IR_TTUSBIR_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_SDIO_MODULE: u32 = 1;
pub const CONFIG_USB_NET_DM9601_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_TRACEHOOK: u32 = 1;
pub const CONFIG_RTC_DRV_WILCO_EC_MODULE: u32 = 1;
pub const CONFIG_SSB_PCIHOST: u32 = 1;
pub const CONFIG_FXAS21002C_MODULE: u32 = 1;
pub const CONFIG_RPMSG_CHAR_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_KBL_RT5663_MAX98927_MACH_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV: u32 = 1;
pub const CONFIG_IR_MCEUSB_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD938X_SDW_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_ACCEL_I2C_3AXIS_MODULE: u32 = 1;
pub const CONFIG_LDM_PARTITION: u32 = 1;
pub const CONFIG_CIFS_MODULE: u32 = 1;
pub const CONFIG_DRM_FBDEV_OVERALLOC: u32 = 100;
pub const CONFIG_SMSC37B787_WDT_MODULE: u32 = 1;
pub const CONFIG_XFRM_USER_MODULE: u32 = 1;
pub const CONFIG_BMI160_I2C_MODULE: u32 = 1;
pub const CONFIG_I3C_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_BIC_MODULE: u32 = 1;
pub const CONFIG_YAMAHA_YAS530_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_REQUEST_TIMEOUT: u32 = 20000;
pub const CONFIG_EXTCON_PALMAS_MODULE: u32 = 1;
pub const CONFIG_LEDS_PCA9532_MODULE: u32 = 1;
pub const CONFIG_TASK_DELAY_ACCT: u32 = 1;
pub const CONFIG_IR_IGORPLUGUSB_MODULE: u32 = 1;
pub const CONFIG_INPUT_PCF50633_PMU_MODULE: u32 = 1;
pub const CONFIG_INPUT_DA9063_ONKEY_MODULE: u32 = 1;
pub const CONFIG_SCSI_DH_EMC_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_NON_OVERLAPPING_ADDRESS_SPACE: u32 = 1;
pub const CONFIG_EXTCON_USB_GPIO_MODULE: u32 = 1;
pub const CONFIG_NET_NS: u32 = 1;
pub const CONFIG_USB_ISP1760_DUAL_ROLE: u32 = 1;
pub const CONFIG_SENSORS_TMP401_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX1586_MODULE: u32 = 1;
pub const CONFIG_REISERFS_FS_XATTR: u32 = 1;
pub const CONFIG_SENSORS_ADT7475_MODULE: u32 = 1;
pub const CONFIG_MEMORY: u32 = 1;
pub const CONFIG_HAVE_PERF_EVENTS: u32 = 1;
pub const CONFIG_PCMCIA_XIRCOM_MODULE: u32 = 1;
pub const CONFIG_EVM_ADD_XATTRS: u32 = 1;
pub const CONFIG_COMEDI_II_PCI20KC_MODULE: u32 = 1;
pub const CONFIG_EISA_VLB_PRIMING: u32 = 1;
pub const CONFIG_B53_SRAB_DRIVER_MODULE: u32 = 1;
pub const CONFIG_BT_HCIBTUSB_AUTOSUSPEND: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C62X_MODULE: u32 = 1;
pub const CONFIG_DVB_MANTIS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LIS3_I2C_MODULE: u32 = 1;
pub const CONFIG_GPD_POCKET_FAN_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ST_ES8336_MACH_MODULE: u32 = 1;
pub const CONFIG_RT2800PCI_RT35XX: u32 = 1;
pub const CONFIG_MTD_NAND_GPIO_MODULE: u32 = 1;
pub const CONFIG_CAN_C_CAN_MODULE: u32 = 1;
pub const CONFIG_BTT: u32 = 1;
pub const CONFIG_ATA_SFF: u32 = 1;
pub const CONFIG_LEDS_MENF21BMC_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_WALKERA0701_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LRW_MODULE: u32 = 1;
pub const CONFIG_QRTR_TUN_MODULE: u32 = 1;
pub const CONFIG_NVME_TCP_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1685_FAMILY_MODULE: u32 = 1;
pub const CONFIG_TI_ADS124S08_MODULE: u32 = 1;
pub const CONFIG_VFIO_CONTAINER: u32 = 1;
pub const CONFIG_REGULATOR_WM8350_MODULE: u32 = 1;
pub const CONFIG_IWLWIFI_OPMODE_MODULAR: u32 = 1;
pub const CONFIG_NET_EMATCH_CMP_MODULE: u32 = 1;
pub const CONFIG_UV_MMTIMER_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_T613_MODULE: u32 = 1;
pub const CONFIG_SND_VIA82XX_MODEM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8580_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DMI: u32 = 1;
pub const CONFIG_SND_MTPAV_MODULE: u32 = 1;
pub const CONFIG_PPP_ASYNC_MODULE: u32 = 1;
pub const CONFIG_MD_RAID10_MODULE: u32 = 1;
pub const CONFIG_NFSD_SCSILAYOUT: u32 = 1;
pub const CONFIG_HID_NINTENDO_MODULE: u32 = 1;
pub const CONFIG_HAVE_ALIGNED_STRUCT_PAGE: u32 = 1;
pub const CONFIG_SSB_SDIOHOST_POSSIBLE: u32 = 1;
pub const CONFIG_SENSORS_APPLESMC_MODULE: u32 = 1;
pub const CONFIG_DRM_SIMPLEDRM: u32 = 1;
pub const CONFIG_NET_VENDOR_SOLARFLARE: u32 = 1;
pub const CONFIG_CAN_GW_MODULE: u32 = 1;
pub const CONFIG_NLS_CODEPAGE_866_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ABITUGURU3_MODULE: u32 = 1;
pub const CONFIG_CRAMFS_MODULE: u32 = 1;
pub const CONFIG_RADIO_SAA7706H_MODULE: u32 = 1;
pub const CONFIG_SKGE_GENESIS: u32 = 1;
pub const CONFIG_WM831X_POWER_MODULE: u32 = 1;
pub const CONFIG_PINCTRL_SUNRISEPOINT_MODULE: u32 = 1;
pub const CONFIG_TINYDRM_ILI9341_MODULE: u32 = 1;
pub const CONFIG_LEDS_TRIGGER_TRANSIENT_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_LM8323_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_IBT: u32 = 1;
pub const CONFIG_STMMAC_ETH_MODULE: u32 = 1;
pub const CONFIG_CHELSIO_T1_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_PLAT: u32 = 1;
pub const CONFIG_BACKLIGHT_RT4831_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AIO_AIO12_8_MODULE: u32 = 1;
pub const CONFIG_NFSD_V4_SECURITY_LABEL: u32 = 1;
pub const CONFIG_QCOM_HIDMA_MGMT_MODULE: u32 = 1;
pub const CONFIG_CEPH_FS_POSIX_ACL: u32 = 1;
pub const CONFIG_BLK_DEV_PMEM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT722_SDCA_SDW_MODULE: u32 = 1;
pub const CONFIG_XFRM_ESP_MODULE: u32 = 1;
pub const CONFIG_AUDIT: u32 = 1;
pub const CONFIG_VIDEO_OV8858_MODULE: u32 = 1;
pub const CONFIG_WILCO_EC_MODULE: u32 = 1;
pub const CONFIG_CHR_DEV_ST_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_TPS65910_MODULE: u32 = 1;
pub const CONFIG_BATTERY_RT5033_MODULE: u32 = 1;
pub const CONFIG_BCH_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU: u32 = 1;
pub const CONFIG_DVB_GP8PSK_FE_MODULE: u32 = 1;
pub const CONFIG_V4L2_CCI_I2C_MODULE: u32 = 1;
pub const CONFIG_THERMAL_DEFAULT_GOV_STEP_WISE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_MODULE: u32 = 1;
pub const CONFIG_HAVE_RETHOOK: u32 = 1;
pub const CONFIG_CRYPTO_USER_API_SKCIPHER_MODULE: u32 = 1;
pub const CONFIG_SURFACE_PLATFORM_PROFILE_MODULE: u32 = 1;
pub const CONFIG_FW_ATTR_CLASS_MODULE: u32 = 1;
pub const CONFIG_SCSI_3W_SAS_MODULE: u32 = 1;
pub const CONFIG_BPF_JIT_ALWAYS_ON: u32 = 1;
pub const CONFIG_COMEDI_NI_ATMIO16D_MODULE: u32 = 1;
pub const CONFIG_TPS6594_PFSM_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MC13892_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM80_MODULE: u32 = 1;
pub const CONFIG_NET_9P_FD_MODULE: u32 = 1;
pub const CONFIG_EXTCON_FSA9480_MODULE: u32 = 1;
pub const CONFIG_LTO_NONE: u32 = 1;
pub const CONFIG_PCI_HYPERV_MODULE: u32 = 1;
pub const CONFIG_PCIEASPM: u32 = 1;
pub const CONFIG_PM_ADVANCED_DEBUG: u32 = 1;
pub const CONFIG_DEBUG_FS_ALLOW_ALL: u32 = 1;
pub const CONFIG_SND_SOC_AW87390_MODULE: u32 = 1;
pub const CONFIG_MT76_LEDS: u32 = 1;
pub const CONFIG_INTEL_IDMA64_MODULE: u32 = 1;
pub const CONFIG_VME_TSI148_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5514_MODULE: u32 = 1;
pub const CONFIG_ATA_PIIX: u32 = 1;
pub const CONFIG_B43LEGACY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WM8904_MODULE: u32 = 1;
pub const CONFIG_AIC7XXX_REG_PRETTY_PRINT: u32 = 1;
pub const CONFIG_HID_MULTITOUCH_MODULE: u32 = 1;
pub const CONFIG_ECRYPT_FS_MESSAGING: u32 = 1;
pub const CONFIG_RTW88_8821CU_MODULE: u32 = 1;
pub const CONFIG_MARVELL_88Q2XXX_PHY_MODULE: u32 = 1;
pub const CONFIG_FB_DEFERRED_IO: u32 = 1;
pub const CONFIG_SATA_AHCI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_MITE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_SSP_COMMON_MODULE: u32 = 1;
pub const CONFIG_TI_TSC2046_MODULE: u32 = 1;
pub const CONFIG_TI_ADS8688_MODULE: u32 = 1;
pub const CONFIG_SND_AMD_ASOC_RENOIR_MODULE: u32 = 1;
pub const CONFIG_RTW88_8723DE_MODULE: u32 = 1;
pub const CONFIG_SLAB_FREELIST_RANDOM: u32 = 1;
pub const CONFIG_DVB_USB_A800_MODULE: u32 = 1;
pub const CONFIG_SYSTEMPORT_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_RT5645_MACH_MODULE: u32 = 1;
pub const CONFIG_HAVE_STATIC_CALL: u32 = 1;
pub const CONFIG_XEN_BALLOON_MEMORY_HOTPLUG: u32 = 1;
pub const CONFIG_SECURITY: u32 = 1;
pub const CONFIG_REGULATOR_RAA215300_MODULE: u32 = 1;
pub const CONFIG_I2C_SI470X_MODULE: u32 = 1;
pub const CONFIG_DVB_A8293_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASC7621_MODULE: u32 = 1;
pub const CONFIG_OPTPROBES: u32 = 1;
pub const CONFIG_USB_AMD5536UDC_MODULE: u32 = 1;
pub const CONFIG_BE2NET_BE3: u32 = 1;
pub const CONFIG_IQS621_ALS_MODULE: u32 = 1;
pub const CONFIG_CHARGER_BQ2415X_MODULE: u32 = 1;
pub const CONFIG_NETXEN_NIC_MODULE: u32 = 1;
pub const CONFIG_BNX2X_SRIOV: u32 = 1;
pub const CONFIG_ACPI_NUMA: u32 = 1;
pub const CONFIG_HID_PXRC_MODULE: u32 = 1;
pub const CONFIG_BLK_CGROUP_RWSTAT: u32 = 1;
pub const CONFIG_INTERCONNECT: u32 = 1;
pub const CONFIG_ATM_TCP_MODULE: u32 = 1;
pub const CONFIG_MAX_SKB_FRAGS: u32 = 17;
pub const CONFIG_USB_GR_UDC_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CXUSB_ANALOG: u32 = 1;
pub const CONFIG_AD74413R_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_ISL9305_MODULE: u32 = 1;
pub const CONFIG_INTEL_BYTCRC_PWRSRC_MODULE: u32 = 1;
pub const CONFIG_USB_CDNSP_PCI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ELKHARTLAKE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_SPI_MODULE: u32 = 1;
pub const CONFIG_PCIE_DW_PLAT_EP: u32 = 1;
pub const CONFIG_HID_ELECOM_MODULE: u32 = 1;
pub const CONFIG_FB_TFT_PCD8544_MODULE: u32 = 1;
pub const CONFIG_SND_TIMER_MODULE: u32 = 1;
pub const CONFIG_COMEDI_ICP_MULTI_MODULE: u32 = 1;
pub const CONFIG_BATTERY_DA9150_MODULE: u32 = 1;
pub const CONFIG_KVM_MMIO: u32 = 1;
pub const CONFIG_USB_EHCI_TT_NEWSCHED: u32 = 1;
pub const CONFIG_FAT_DEFAULT_CODEPAGE: u32 = 437;
pub const CONFIG_ALTERA_FREEZE_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_TCM_FC_MODULE: u32 = 1;
pub const CONFIG_IPV6_MROUTE_MULTIPLE_TABLES: u32 = 1;
pub const CONFIG_BLK_DEV: u32 = 1;
pub const CONFIG_SND_SOC_PCM179X_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC31XX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_FSL_MQS_MODULE: u32 = 1;
pub const CONFIG_SERIO_I8042: u32 = 1;
pub const CONFIG_MAC80211_RC_DEFAULT: &[u8; 12usize] = b"minstrel_ht\0";
pub const CONFIG_NIC7018_WDT_MODULE: u32 = 1;
pub const CONFIG_FARSYNC_MODULE: u32 = 1;
pub const CONFIG_RTL8187_LEDS: u32 = 1;
pub const CONFIG_NFS_ACL_SUPPORT_MODULE: u32 = 1;
pub const CONFIG_RT2800USB_RT55XX: u32 = 1;
pub const CONFIG_CHARGER_ADP5061_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS2433_MODULE: u32 = 1;
pub const CONFIG_CHROME_PLATFORMS: u32 = 1;
pub const CONFIG_BATTERY_SAMSUNG_SDI: u32 = 1;
pub const CONFIG_ATL1_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SBRMI_MODULE: u32 = 1;
pub const CONFIG_APPLICOM_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_OMNINET_MODULE: u32 = 1;
pub const CONFIG_HDLC_PPP_MODULE: u32 = 1;
pub const CONFIG_X86_AMD_PLATFORM_DEVICE: u32 = 1;
pub const CONFIG_BRIDGE_NETFILTER_MODULE: u32 = 1;
pub const CONFIG_TCP_CONG_SCALABLE_MODULE: u32 = 1;
pub const CONFIG_DRM_XE_PREEMPT_TIMEOUT_MIN: u32 = 1;
pub const CONFIG_DVB_MB86A20S_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_ASM_GOTO_TIED_OUTPUT: u32 = 1;
pub const CONFIG_VIRTIO_IOMMU: u32 = 1;
pub const CONFIG_MLX5_SF_MANAGER: u32 = 1;
pub const CONFIG_PATA_TRIFLEX_MODULE: u32 = 1;
pub const CONFIG_LEDS_MLXREG_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCL818_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_TMDC_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_KFENCE: u32 = 1;
pub const CONFIG_MCP4922_MODULE: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_UART_MAXPORTS: u32 = 4;
pub const CONFIG_SND_SYNTH_EMUX_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OG01A1B_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_SILABS: u32 = 1;
pub const CONFIG_IOMMU_API: u32 = 1;
pub const CONFIG_GPIO_GENERIC: u32 = 1;
pub const CONFIG_USB_CDNS3_HOST: u32 = 1;
pub const CONFIG_TRACING_SUPPORT: u32 = 1;
pub const CONFIG_INET_ESPINTCP: u32 = 1;
pub const CONFIG_SND_SOC_PCM3060_MODULE: u32 = 1;
pub const CONFIG_UNIX98_PTYS: u32 = 1;
pub const CONFIG_MS_BLOCK_MODULE: u32 = 1;
pub const CONFIG_VFIO_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ASUS_WMI_MODULE: u32 = 1;
pub const CONFIG_MT76x2E_MODULE: u32 = 1;
pub const CONFIG_NFC_MICROREAD_MEI_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CONNMARK_MODULE: u32 = 1;
pub const CONFIG_MINIX_SUBPARTITION: u32 = 1;
pub const CONFIG_CHROMEOS_PSTORE_MODULE: u32 = 1;
pub const CONFIG_NET_RX_BUSY_POLL: u32 = 1;
pub const CONFIG_RADIO_WL1273_MODULE: u32 = 1;
pub const CONFIG_SENSORS_SMSC47B397_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_MICHAEL_MIC_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_SOCIONEXT: u32 = 1;
pub const CONFIG_TCP_AO: u32 = 1;
pub const CONFIG_IMA_QUEUE_EARLY_BOOT_KEYS: u32 = 1;
pub const CONFIG_CRYPTO_ANSI_CPRNG_MODULE: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX: u32 = 1;
pub const CONFIG_ZONE_DMA32: u32 = 1;
pub const CONFIG_NET_SCHED: u32 = 1;
pub const CONFIG_LCD_LMS501KF03_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_TPS65086_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CONNSECMARK_MODULE: u32 = 1;
pub const CONFIG_INPUT_ATC260X_ONKEY_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCL726_MODULE: u32 = 1;
pub const CONFIG_MFD_CS47L85: u32 = 1;
pub const CONFIG_LIQUIDIO_MODULE: u32 = 1;
pub const CONFIG_STAGING_MEDIA: u32 = 1;
pub const CONFIG_NVME_RDMA_MODULE: u32 = 1;
pub const CONFIG_ARCH_SUPPORTS_KEXEC: u32 = 1;
pub const CONFIG_DRM_PANEL: u32 = 1;
pub const CONFIG_DVB_PLL_MODULE: u32 = 1;
pub const CONFIG_PRINTK_TIME: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_AVS_MACH_MAX98373_MODULE: u32 = 1;
pub const CONFIG_AD7091R_MODULE: u32 = 1;
pub const CONFIG_PANEL_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_RT5759_MODULE: u32 = 1;
pub const CONFIG_SERIAL_JSM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_GLK_MODULE: u32 = 1;
pub const CONFIG_VIDEO_VIVID_MAX_DEVS: u32 = 64;
pub const CONFIG_RXPERF_MODULE: u32 = 1;
pub const CONFIG_INPUT_MOUSEDEV_SCREEN_Y: u32 = 768;
pub const CONFIG_SENSORS_MP5023_MODULE: u32 = 1;
pub const CONFIG_SENSORS_PECI_DIMMTEMP_MODULE: u32 = 1;
pub const CONFIG_TRACE_IRQFLAGS_NMI_SUPPORT: u32 = 1;
pub const CONFIG_TASKS_RCU_GENERIC: u32 = 1;
pub const CONFIG_SECCOMP_FILTER: u32 = 1;
pub const CONFIG_PATA_HPT37X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_RM3100_SPI_MODULE: u32 = 1;
pub const CONFIG_MPU3050_MODULE: u32 = 1;
pub const CONFIG_UIO_PCI_GENERIC_MODULE: u32 = 1;
pub const CONFIG_PPP: u32 = 1;
pub const CONFIG_RFD_FTL_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_QUOTA_MODULE: u32 = 1;
pub const CONFIG_TI_ST_MODULE: u32 = 1;
pub const CONFIG_ARCH_MAY_HAVE_PC_FDC: u32 = 1;
pub const CONFIG_SNET_VDPA_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_PIE_MODULE: u32 = 1;
pub const CONFIG_BOSCH_BNO055_SERIAL_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ATMEL_MXT_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_SENSEHAT_MODULE: u32 = 1;
pub const CONFIG_NFT_FIB_IPV4_MODULE: u32 = 1;
pub const CONFIG_CLOSURES: u32 = 1;
pub const CONFIG_HAVE_KERNEL_LZO: u32 = 1;
pub const CONFIG_ASYNC_CORE_MODULE: u32 = 1;
pub const CONFIG_INTEL_PMC_CORE_MODULE: u32 = 1;
pub const CONFIG_BUILDTIME_MCOUNT_SORT: u32 = 1;
pub const CONFIG_NET_SCH_MULTIQ_MODULE: u32 = 1;
pub const CONFIG_INET_DIAG_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_GHASH: u32 = 1;
pub const CONFIG_OCFS2_DEBUG_MASKLOG: u32 = 1;
pub const CONFIG_GENERIC_ENTRY: u32 = 1;
pub const CONFIG_SND_SOC_WM8741_MODULE: u32 = 1;
pub const CONFIG_PSTORE: u32 = 1;
pub const CONFIG_OVERLAY_FS_REDIRECT_ALWAYS_FOLLOW: u32 = 1;
pub const CONFIG_SCSI_LPFC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS53L30_MODULE: u32 = 1;
pub const CONFIG_DVB_MN88443X_MODULE: u32 = 1;
pub const CONFIG_ACPI_TABLE_LIB: u32 = 1;
pub const CONFIG_VDPA_MODULE: u32 = 1;
pub const CONFIG_SECURITY_SELINUX_SIDTAB_HASH_BITS: u32 = 9;
pub const CONFIG_IIO_ST_LSM9DS0_SPI_MODULE: u32 = 1;
pub const CONFIG_NFC_ST95HF_MODULE: u32 = 1;
pub const CONFIG_NF_NAT_FTP_MODULE: u32 = 1;
pub const CONFIG_VIDEO_RDACM21_MODULE: u32 = 1;
pub const CONFIG_MAC80211_RC_MINSTREL: u32 = 1;
pub const CONFIG_IIO_CONSUMERS_PER_TRIGGER: u32 = 2;
pub const CONFIG_NF_CT_PROTO_UDPLITE: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_ENCTYPES_AES_SHA2: u32 = 1;
pub const CONFIG_SPEAKUP_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_SYNPROXY_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_MICROCHIP_SPI_MODULE: u32 = 1;
pub const CONFIG_HANGCHECK_TIMER_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_WARRIOR_MODULE: u32 = 1;
pub const CONFIG_COMEDI_AIO_IIRO_16_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83627EHF_MODULE: u32 = 1;
pub const CONFIG_ELF_CORE: u32 = 1;
pub const CONFIG_PTP_DFL_TOD_MODULE: u32 = 1;
pub const CONFIG_DEV_COREDUMP: u32 = 1;
pub const CONFIG_NOTIFIER_ERROR_INJECTION_MODULE: u32 = 1;
pub const CONFIG_SENSORS_LM73_MODULE: u32 = 1;
pub const CONFIG_VIA_VELOCITY_MODULE: u32 = 1;
pub const CONFIG_KVM_EXTERNAL_WRITE_TRACKING: u32 = 1;
pub const CONFIG_SENSORS_PC87360_MODULE: u32 = 1;
pub const CONFIG_DVB_LNBH29_MODULE: u32 = 1;
pub const CONFIG_TEXTSEARCH: u32 = 1;
pub const CONFIG_DRM_AMDGPU_USERPTR: u32 = 1;
pub const CONFIG_VIDEO_IVTV_MODULE: u32 = 1;
pub const CONFIG_ACPI_DOCK: u32 = 1;
pub const CONFIG_SND_SOC_CS4341_MODULE: u32 = 1;
pub const CONFIG_USB_DWC3_MODULE: u32 = 1;
pub const CONFIG_KS8851_MODULE: u32 = 1;
pub const CONFIG_XEN_HAVE_PVMMU: u32 = 1;
pub const CONFIG_DYNAMIC_FTRACE_WITH_DIRECT_CALLS: u32 = 1;
pub const CONFIG_MTD_JEDECPROBE_MODULE: u32 = 1;
pub const CONFIG_TSYS01_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_ABEOZ9_MODULE: u32 = 1;
pub const CONFIG_NF_CT_NETLINK_HELPER_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ON_DEMAND_PAGING: u32 = 1;
pub const CONFIG_HAVE_CONTEXT_TRACKING_USER: u32 = 1;
pub const CONFIG_INA2XX_ADC_MODULE: u32 = 1;
pub const CONFIG_CXL_PMEM_MODULE: u32 = 1;
pub const CONFIG_EFI_TEST_MODULE: u32 = 1;
pub const CONFIG_MTD_ONENAND_VERIFY_WRITE: u32 = 1;
pub const CONFIG_INPUT_PCF8574_MODULE: u32 = 1;
pub const CONFIG_SENSIRION_SGP40_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_INTEL_SKL_MODULE: u32 = 1;
pub const CONFIG_SENSORS_MC34VR500_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MT6660_MODULE: u32 = 1;
pub const CONFIG_USB_SUPPORT: u32 = 1;
pub const CONFIG_SOFT_WATCHDOG_PRETIMEOUT: u32 = 1;
pub const CONFIG_XEN_UNPOPULATED_ALLOC: u32 = 1;
pub const CONFIG_BCM84881_PHY: u32 = 1;
pub const CONFIG_NVME_TARGET_MODULE: u32 = 1;
pub const CONFIG_I2C_SCMI_MODULE: u32 = 1;
pub const CONFIG_I2C_VIA_MODULE: u32 = 1;
pub const CONFIG_BMC150_MAGN_SPI_MODULE: u32 = 1;
pub const CONFIG_MOTORCOMM_PHY_MODULE: u32 = 1;
pub const CONFIG_INPUT_MAX8925_ONKEY_MODULE: u32 = 1;
pub const CONFIG_CC_NO_STRINGOP_OVERFLOW: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_C3XXX_MODULE: u32 = 1;
pub const CONFIG_VIRTIO_MMIO_CMDLINE_DEVICES: u32 = 1;
pub const CONFIG_SND_SOC_SOF_GEMINILAKE_MODULE: u32 = 1;
pub const CONFIG_SND_INTEL8X0M_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_WRITE_MOUNTED: u32 = 1;
pub const CONFIG_ACPI_DEBUG: u32 = 1;
pub const CONFIG_SENSORS_ACBEL_FSG032_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_PREEMPT_TIMEOUT_COMPUTE: u32 = 7500;
pub const CONFIG_MODIFY_LDT_SYSCALL: u32 = 1;
pub const CONFIG_SENSORS_ADC128D818_MODULE: u32 = 1;
pub const CONFIG_KEMPLD_WDT_MODULE: u32 = 1;
pub const CONFIG_SURFACE3_WMI_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_BQ32K_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_PAC7311_MODULE: u32 = 1;
pub const CONFIG_HID_JABRA_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_ST: u32 = 1;
pub const CONFIG_MLX5_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_MAX44009_MODULE: u32 = 1;
pub const CONFIG_COMEDI_PCMAD_MODULE: u32 = 1;
pub const CONFIG_X86_REROUTE_FOR_BROKEN_BOOT_IRQS: u32 = 1;
pub const CONFIG_VIDEO_CCS_MODULE: u32 = 1;
pub const CONFIG_VIA_WDT_MODULE: u32 = 1;
pub const CONFIG_PCP_BATCH_SCALE_MAX: u32 = 5;
pub const CONFIG_CAN_F81604_MODULE: u32 = 1;
pub const CONFIG_UCLAMP_TASK: u32 = 1;
pub const CONFIG_BLK_DEV_NVME_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_PROTO_BCDC: u32 = 1;
pub const CONFIG_MOST_COMPONENTS_MODULE: u32 = 1;
pub const CONFIG_TWL4030_CORE: u32 = 1;
pub const CONFIG_SOC_BUS: u32 = 1;
pub const CONFIG_SPI_ZYNQMP_GQSPI_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_EASYTOUCH: u32 = 1;
pub const CONFIG_SND_SOC_TAS6424_MODULE: u32 = 1;
pub const CONFIG_STAGING: u32 = 1;
pub const CONFIG_NET_VENDOR_SIS: u32 = 1;
pub const CONFIG_F2FS_FS_MODULE: u32 = 1;
pub const CONFIG_TI_ADS1100_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_EDT_FT5X06_MODULE: u32 = 1;
pub const CONFIG_FPGA_DFL_FME_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RL6347A_MODULE: u32 = 1;
pub const CONFIG_FB_RIVA_I2C: u32 = 1;
pub const CONFIG_SENSORS_LIS3LV02D_MODULE: u32 = 1;
pub const CONFIG_LEDS_MT6370_FLASH_MODULE: u32 = 1;
pub const CONFIG_CC_HAS_AUTO_VAR_INIT_ZERO_BARE: u32 = 1;
pub const CONFIG_USB_CDNS3_MODULE: u32 = 1;
pub const CONFIG_DM_MULTIPATH_IOA_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX14577_MODULE: u32 = 1;
pub const CONFIG_AD9523_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5645_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_ACP_PROBES_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_INTEL_HDMI_SILENT_STREAM: u32 = 1;
pub const CONFIG_FIREWIRE_MODULE: u32 = 1;
pub const CONFIG_MLX5_TC_SAMPLE: u32 = 1;
pub const CONFIG_BYTCRC_PMIC_OPREGION: u32 = 1;
pub const CONFIG_WIZNET_W5100_SPI_MODULE: u32 = 1;
pub const CONFIG_CHARGER_CROS_USBPD_MODULE: u32 = 1;
pub const CONFIG_ATM_MODULE: u32 = 1;
pub const CONFIG_MMIOTRACE: u32 = 1;
pub const CONFIG_MAX63XX_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_PAGE_POOL: u32 = 1;
pub const CONFIG_SURFACE_AGGREGATOR_TABLET_SWITCH_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_16550A_VARIANTS: u32 = 1;
pub const CONFIG_REGULATOR_MT6358_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_MODULE: u32 = 1;
pub const CONFIG_INIT_STACK_ALL_ZERO: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ST1232_MODULE: u32 = 1;
pub const CONFIG_SCSI_FC_ATTRS_MODULE: u32 = 1;
pub const CONFIG_VT_CONSOLE: u32 = 1;
pub const CONFIG_EDAC_SBRIDGE_MODULE: u32 = 1;
pub const CONFIG_HID_UCLOGIC_MODULE: u32 = 1;
pub const CONFIG_VFIO_MDEV_MODULE: u32 = 1;
pub const CONFIG_HW_RANDOM_VIRTIO_MODULE: u32 = 1;
pub const CONFIG_NVME_TARGET_PASSTHRU: u32 = 1;
pub const CONFIG_COMEDI_PCMCIA_DRIVERS_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_88PG86X_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI: u32 = 1;
pub const CONFIG_SND_SOC_PCM186X_MODULE: u32 = 1;
pub const CONFIG_SND_ES1968_RADIO: u32 = 1;
pub const CONFIG_MT7615E_MODULE: u32 = 1;
pub const CONFIG_LEDS_GPIO_MODULE: u32 = 1;
pub const CONFIG_SENSIRION_SGP30_MODULE: u32 = 1;
pub const CONFIG_SND_SB_COMMON_MODULE: u32 = 1;
pub const CONFIG_LED_TRIGGER_PHY: u32 = 1;
pub const CONFIG_CFG80211_WEXT_EXPORT: u32 = 1;
pub const CONFIG_SND_CS46XX_MODULE: u32 = 1;
pub const CONFIG_SCHED_INFO: u32 = 1;
pub const CONFIG_USB_GSPCA_STK014_MODULE: u32 = 1;
pub const CONFIG_MQ_IOSCHED_KYBER_MODULE: u32 = 1;
pub const CONFIG_ACPI_DEBUGGER: u32 = 1;
pub const CONFIG_IP_VS_FTP_MODULE: u32 = 1;
pub const CONFIG_AS_VERSION: u32 = 24200;
pub const CONFIG_CC_HAS_INT128: u32 = 1;
pub const CONFIG_KEYBOARD_APPLESPI_MODULE: u32 = 1;
pub const CONFIG_EFI_COCO_SECRET: u32 = 1;
pub const CONFIG_FANOTIFY_ACCESS_PERMISSIONS: u32 = 1;
pub const CONFIG_SENSORS_LM3533_MODULE: u32 = 1;
pub const CONFIG_EFI_EARLYCON: u32 = 1;
pub const CONFIG_IIO_ST_PRESS_I2C_MODULE: u32 = 1;
pub const CONFIG_STM_SOURCE_FTRACE_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_NODE_DEV_GROUP: u32 = 1;
pub const CONFIG_DRM_HYPERV_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX18_MODULE: u32 = 1;
pub const CONFIG_XILINX_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_VMWARE_PVSCSI_MODULE: u32 = 1;
pub const CONFIG_CFG80211_WEXT: u32 = 1;
pub const CONFIG_VIRTIO_VSOCKETS_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_MARVELL: u32 = 1;
pub const CONFIG_VIDEO_OV8856_MODULE: u32 = 1;
pub const CONFIG_SERIAL_SCCNXP_CONSOLE: u32 = 1;
pub const CONFIG_SMARTJOYPLUS_FF: u32 = 1;
pub const CONFIG_SND_SOC_XTFPGA_I2S_MODULE: u32 = 1;
pub const CONFIG_I2C_PARPORT_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_PHYSDEV_MODULE: u32 = 1;
pub const CONFIG_NOP_USB_XCEIV_MODULE: u32 = 1;
pub const CONFIG_RTW89_DEBUGFS: u32 = 1;
pub const CONFIG_NET_SOCK_MSG: u32 = 1;
pub const CONFIG_GPIO_DA9052_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_PCIE: u32 = 1;
pub const CONFIG_CC_OPTIMIZE_FOR_PERFORMANCE: u32 = 1;
pub const CONFIG_EXTCON_MAX77843_MODULE: u32 = 1;
pub const CONFIG_SND_VIA82XX_MODULE: u32 = 1;
pub const CONFIG_CC10001_ADC_MODULE: u32 = 1;
pub const CONFIG_NFC_PN533_MODULE: u32 = 1;
pub const CONFIG_FPGA_MGR_LATTICE_SYSCONFIG_SPI_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIBUSB_MB_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_DWLIB: u32 = 1;
pub const CONFIG_TWL6030_GPADC_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_GPIO_MODULE: u32 = 1;
pub const CONFIG_SND_DARLA20_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX77843: u32 = 1;
pub const CONFIG_SND_SOC_SOF_IPC4: u32 = 1;
pub const CONFIG_SND_SEQ_MIDI_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RAM_MODULE: u32 = 1;
pub const CONFIG_USB_F_NCM_MODULE: u32 = 1;
pub const CONFIG_SENSORS_AHT10_MODULE: u32 = 1;
pub const CONFIG_ARCH_MMAP_RND_COMPAT_BITS: u32 = 16;
pub const CONFIG_TOUCHSCREEN_AD7879_MODULE: u32 = 1;
pub const CONFIG_MMA9553_MODULE: u32 = 1;
pub const CONFIG_SENSORS_HDAPS_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_STATE_MODULE: u32 = 1;
pub const CONFIG_DVB_L64781_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_RM_TS_MODULE: u32 = 1;
pub const CONFIG_INPUT_EVBUG_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_TAG_BRCM_LEGACY_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_BCM_SF2_MODULE: u32 = 1;
pub const CONFIG_LOGIRUMBLEPAD2_FF: u32 = 1;
pub const CONFIG_SND_INDIGOIOX_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV772X_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS6586X: u32 = 1;
pub const CONFIG_SND_ASIHPI_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_XATTR: u32 = 1;
pub const CONFIG_SND_SOC_SOF_MODULE: u32 = 1;
pub const CONFIG_BSD_DISKLABEL: u32 = 1;
pub const CONFIG_RTC_DRV_M48T35_MODULE: u32 = 1;
pub const CONFIG_I2C_TAOS_EVM_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CAST_COMMON_MODULE: u32 = 1;
pub const CONFIG_COMEDI_KCOMEDILIB_MODULE: u32 = 1;
pub const CONFIG_FB_HGA_MODULE: u32 = 1;
pub const CONFIG_IIO_TRIGGERED_BUFFER_MODULE: u32 = 1;
pub const CONFIG_XEN_PVH: u32 = 1;
pub const CONFIG_RTC_DRV_PCF2127_MODULE: u32 = 1;
pub const CONFIG_USB_STORAGE_FREECOM_MODULE: u32 = 1;
pub const CONFIG_LCD_VGG2432A4_MODULE: u32 = 1;
pub const CONFIG_MFD_TPS65086_MODULE: u32 = 1;
pub const CONFIG_SCSI_BUSLOGIC_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_LOG_MODULE: u32 = 1;
pub const CONFIG_VIDEO_THS8200_MODULE: u32 = 1;
pub const CONFIG_MICROCHIP_PHY_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ADS7846_MODULE: u32 = 1;
pub const CONFIG_AD5766_MODULE: u32 = 1;
pub const CONFIG_OPENVSWITCH_VXLAN_MODULE: u32 = 1;
pub const CONFIG_FONT_6x10: u32 = 1;
pub const CONFIG_GADGET_UAC1: u32 = 1;
pub const CONFIG_IR_RC5_DECODER_MODULE: u32 = 1;
pub const CONFIG_MTD_PSTORE_MODULE: u32 = 1;
pub const CONFIG_FIREWIRE_NOSY_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_GRED_MODULE: u32 = 1;
pub const CONFIG_PCI_DIRECT: u32 = 1;
pub const CONFIG_MMC_VIA_SDMMC_MODULE: u32 = 1;
pub const CONFIG_DRM: u32 = 1;
pub const CONFIG_FUSION_MAX_SGE: u32 = 128;
pub const CONFIG_RTC_DRV_DA9055_MODULE: u32 = 1;
pub const CONFIG_DRM_XEN: u32 = 1;
pub const CONFIG_DRM_PANEL_MIPI_DBI_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_FORCE_PROBE: &[u8; 1usize] = b"\0";
pub const CONFIG_DMABUF_HEAPS_SYSTEM: u32 = 1;
pub const CONFIG_MCP4018_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_RT5682_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ADC_MODULE: u32 = 1;
pub const CONFIG_AD7150_MODULE: u32 = 1;
pub const CONFIG_MEDIA_RADIO_SUPPORT: u32 = 1;
pub const CONFIG_PCF50633_GPIO_MODULE: u32 = 1;
pub const CONFIG_HID_SEMITEK_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AW88261_MODULE: u32 = 1;
pub const CONFIG_VIDEO_S5K5BAF_MODULE: u32 = 1;
pub const CONFIG_IWL4965_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_PTP: u32 = 1;
pub const CONFIG_PCIE_DPC: u32 = 1;
pub const CONFIG_GPIO_IDIO_16_MODULE: u32 = 1;
pub const CONFIG_POSIX_MQUEUE_SYSCTL: u32 = 1;
pub const CONFIG_NVMEM_SPMI_SDAM_MODULE: u32 = 1;
pub const CONFIG_DRM_I915_TIMESLICE_DURATION: u32 = 1;
pub const CONFIG_VHOST_MENU: u32 = 1;
pub const CONFIG_RTC_DRV_MAX6900_MODULE: u32 = 1;
pub const CONFIG_ICS932S401_MODULE: u32 = 1;
pub const CONFIG_RIONET_TX_SIZE: u32 = 128;
pub const CONFIG_XILINX_GMII2RGMII_MODULE: u32 = 1;
pub const CONFIG_COMMON_CLK_TPS68470_MODULE: u32 = 1;
pub const CONFIG_GPIO_WINBOND_MODULE: u32 = 1;
pub const CONFIG_DRM_GUD_MODULE: u32 = 1;
pub const CONFIG_UDMABUF: u32 = 1;
pub const CONFIG_SENSORS_MAX1111_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_DEV_PADLOCK_AES_MODULE: u32 = 1;
pub const CONFIG_INTEL_TH_STH_MODULE: u32 = 1;
pub const CONFIG_SAMSUNG_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_BE2NET_HWMON: u32 = 1;
pub const CONFIG_USB_USS720_MODULE: u32 = 1;
pub const CONFIG_DRM_EXEC_MODULE: u32 = 1;
pub const CONFIG_DEBUG_MISC: u32 = 1;
pub const CONFIG_LEDS_DAC124S085_MODULE: u32 = 1;
pub const CONFIG_FB_CFB_COPYAREA: u32 = 1;
pub const CONFIG_USB_F_ECM_MODULE: u32 = 1;
pub const CONFIG_GPIO_IT87_MODULE: u32 = 1;
pub const CONFIG_MOUSE_GPIO_MODULE: u32 = 1;
pub const CONFIG_USB_SISUSBVGA_MODULE: u32 = 1;
pub const CONFIG_DVB_RTL2830_MODULE: u32 = 1;
pub const CONFIG_I40E_MODULE: u32 = 1;
pub const CONFIG_BRIDGE_EBT_STP_MODULE: u32 = 1;
pub const CONFIG_HAVE_KVM_IRQCHIP: u32 = 1;
pub const CONFIG_SND_SOC_MTK_BTCVSD_MODULE: u32 = 1;
pub const CONFIG_RT73USB_MODULE: u32 = 1;
pub const CONFIG_USB_ULPI_BUS_MODULE: u32 = 1;
pub const CONFIG_CROS_USBPD_NOTIFY_MODULE: u32 = 1;
pub const CONFIG_DE2104X_DSL: u32 = 0;
pub const CONFIG_BRIDGE_EBT_ARP_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_MICROSEMI: u32 = 1;
pub const CONFIG_BALLOON_COMPACTION: u32 = 1;
pub const CONFIG_BMC150_ACCEL_I2C_MODULE: u32 = 1;
pub const CONFIG_CHARGER_MAX8997_MODULE: u32 = 1;
pub const CONFIG_USB_CYTHERM_MODULE: u32 = 1;
pub const CONFIG_MFD_TWL4030_AUDIO: u32 = 1;
pub const CONFIG_HX711_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MSM8916_WCD_ANALOG_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_EUI64_MODULE: u32 = 1;
pub const CONFIG_MWIFIEX_MODULE: u32 = 1;
pub const CONFIG_HP_ILO_MODULE: u32 = 1;
pub const CONFIG_BINARY_PRINTF: u32 = 1;
pub const CONFIG_SATA_DWC_OLD_DMA: u32 = 1;
pub const CONFIG_USB_STORAGE_JUMPSHOT_MODULE: u32 = 1;
pub const CONFIG_GPIO_MC33880_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_VMW_MODULE: u32 = 1;
pub const CONFIG_NXP_C45_TJA11XX_PHY_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SGTL5000_MODULE: u32 = 1;
pub const CONFIG_INTEL_IDXD_SVM: u32 = 1;
pub const CONFIG_NET_SCH_PLUG_MODULE: u32 = 1;
pub const CONFIG_SND_GINA20_MODULE: u32 = 1;
pub const CONFIG_VFIO_GROUP: u32 = 1;
pub const CONFIG_ACPI_REV_OVERRIDE_POSSIBLE: u32 = 1;
pub const CONFIG_HAVE_PREEMPT_DYNAMIC_CALL: u32 = 1;
pub const CONFIG_AS_AVX512: u32 = 1;
pub const CONFIG_HARDLOCKUP_CHECK_TIMESTAMP: u32 = 1;
pub const CONFIG_SCHED_CLUSTER: u32 = 1;
pub const CONFIG_TRACER_MAX_TRACE: u32 = 1;
pub const CONFIG_USB_KEENE_MODULE: u32 = 1;
pub const CONFIG_ZSTD_DECOMPRESS: u32 = 1;
pub const CONFIG_SND_SOC_SIMPLE_AMPLIFIER_MODULE: u32 = 1;
pub const CONFIG_MTD_CFI_AMDSTD_MODULE: u32 = 1;
pub const CONFIG_CLK_TWL6040_MODULE: u32 = 1;
pub const CONFIG_LEDS_WM831X_STATUS_MODULE: u32 = 1;
pub const CONFIG_MT7925_COMMON_MODULE: u32 = 1;
pub const CONFIG_INTEL_IOMMU_DEFAULT_ON: u32 = 1;
pub const CONFIG_PAGE_IDLE_FLAG: u32 = 1;
pub const CONFIG_SGI_PARTITION: u32 = 1;
pub const CONFIG_INPUT_SPARSEKMAP_MODULE: u32 = 1;
pub const CONFIG_GPIO_PALMAS: u32 = 1;
pub const CONFIG_PTDUMP_CORE: u32 = 1;
pub const CONFIG_CAN_CAN327_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_RTL: u32 = 1;
pub const CONFIG_CRYPTO_TWOFISH_X86_64_3WAY_MODULE: u32 = 1;
pub const CONFIG_AS73211_MODULE: u32 = 1;
pub const CONFIG_ADIS16400_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_AUDIO_APB_CODEC_MODULE: u32 = 1;
pub const CONFIG_AIC7XXX_CMDS_PER_DEVICE: u32 = 8;
pub const CONFIG_SYSFS_SYSCALL: u32 = 1;
pub const CONFIG_WLAN_VENDOR_QUANTENNA: u32 = 1;
pub const CONFIG_RTL8192EE_MODULE: u32 = 1;
pub const CONFIG_SECURITY_INFINIBAND: u32 = 1;
pub const CONFIG_TCG_XEN_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_REALTEK_RTL8365MB_MODULE: u32 = 1;
pub const CONFIG_SND_PCM_TIMER: u32 = 1;
pub const CONFIG_DVB_STV6110_MODULE: u32 = 1;
pub const CONFIG_MPL115_I2C_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1685: u32 = 1;
pub const CONFIG_AC97_BUS_MODULE: u32 = 1;
pub const CONFIG_CW1200_MODULE: u32 = 1;
pub const CONFIG_ENVELOPE_DETECTOR_MODULE: u32 = 1;
pub const CONFIG_ARCH_HAS_SET_DIRECT_MAP: u32 = 1;
pub const CONFIG_SYSVIPC_SYSCTL: u32 = 1;
pub const CONFIG_SND_FIREWORKS_MODULE: u32 = 1;
pub const CONFIG_QEDI_MODULE: u32 = 1;
pub const CONFIG_NVME_FABRICS_MODULE: u32 = 1;
pub const CONFIG_WLAN_VENDOR_TI: u32 = 1;
pub const CONFIG_HID_NTRIG_MODULE: u32 = 1;
pub const CONFIG_IP_VS_IPV6: u32 = 1;
pub const CONFIG_X86_64_ACPI_NUMA: u32 = 1;
pub const CONFIG_DMA_SHARED_BUFFER: u32 = 1;
pub const CONFIG_RTC_SYSTOHC: u32 = 1;
pub const CONFIG_DVB_USB_NOVA_T_USB2_MODULE: u32 = 1;
pub const CONFIG_VHOST_SCSI_MODULE: u32 = 1;
pub const CONFIG_CIFS_POSIX: u32 = 1;
pub const CONFIG_AMD_XGBE_HAVE_ECC: u32 = 1;
pub const CONFIG_PATA_RDC_MODULE: u32 = 1;
pub const CONFIG_SND_PORTMAN2X4_MODULE: u32 = 1;
pub const CONFIG_USB_EPSON2888: u32 = 1;
pub const CONFIG_AF_RXRPC_IPV6: u32 = 1;
pub const CONFIG_ADIS16475_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_ZET6223_MODULE: u32 = 1;
pub const CONFIG_SND_INDIGODJ_MODULE: u32 = 1;
pub const CONFIG_SENSORS_W83L785TS_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_MXUPORT_MODULE: u32 = 1;
pub const CONFIG_W1_SLAVE_DS28E04_MODULE: u32 = 1;
pub const CONFIG_DECOMPRESS_GZIP: u32 = 1;
pub const CONFIG_SND_AW2_MODULE: u32 = 1;
pub const CONFIG_SENSORS_EMC2103_MODULE: u32 = 1;
pub const CONFIG_NLS_MAC_CELTIC_MODULE: u32 = 1;
pub const CONFIG_SND_AU8830_MODULE: u32 = 1;
pub const CONFIG_SPI_SC18IS602_MODULE: u32 = 1;
pub const CONFIG_RTLLIB_CRYPTO_WEP_MODULE: u32 = 1;
pub const CONFIG_THERMAL_GOV_POWER_ALLOCATOR: u32 = 1;
pub const CONFIG_VIRTIO_MENU: u32 = 1;
pub const CONFIG_VIRTIO_BLK: u32 = 1;
pub const CONFIG_AX88796B_PHY_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_CS_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_SJA1105_TAS: u32 = 1;
pub const CONFIG_DECOMPRESS_LZO: u32 = 1;
pub const CONFIG_CRYPTO_XXHASH_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_ARK3116_MODULE: u32 = 1;
pub const CONFIG_64BIT: u32 = 1;
pub const CONFIG_SND_MIXART_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_ATEN_MODULE: u32 = 1;
pub const CONFIG_PARPORT_PANEL_MODULE: u32 = 1;
pub const CONFIG_QUOTA: u32 = 1;
pub const CONFIG_SND_BT87X_MODULE: u32 = 1;
pub const CONFIG_IIO_CROS_EC_SENSORS_CORE_MODULE: u32 = 1;
pub const CONFIG_FW_LOADER_COMPRESS_ZSTD: u32 = 1;
pub const CONFIG_SENSORS_WM8350_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_CURVE25519_MODULE: u32 = 1;
pub const CONFIG_DM9102_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320ADCX140_MODULE: u32 = 1;
pub const CONFIG_COMEDI_NI_MIO_CS_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PARALLEL: u32 = 1;
pub const CONFIG_SND_INTEL_BYT_PREFER_SOF: u32 = 1;
pub const CONFIG_SENSORS_LINEAGE_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_COMETLAKE_MODULE: u32 = 1;
pub const CONFIG_CAN_EMS_PCMCIA_MODULE: u32 = 1;
pub const CONFIG_MLX5_SF: u32 = 1;
pub const CONFIG_SCSI_MPT2SAS_MAX_SGE: u32 = 128;
pub const CONFIG_ZBUD: u32 = 1;
pub const CONFIG_CRYPTO_DEV_QAT_420XX_MODULE: u32 = 1;
pub const CONFIG_MMC_SDHCI_PLTFM_MODULE: u32 = 1;
pub const CONFIG_I2C_CHARDEV: u32 = 1;
pub const CONFIG_KFENCE_SAMPLE_INTERVAL: u32 = 0;
pub const CONFIG_RCU_NOCB_CPU: u32 = 1;
pub const CONFIG_X86_SGX_KVM: u32 = 1;
pub const CONFIG_ADXL367_MODULE: u32 = 1;
pub const CONFIG_MFD_MADERA_MODULE: u32 = 1;
pub const CONFIG_RPMSG_QCOM_GLINK_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_FC0013_MODULE: u32 = 1;
pub const CONFIG_LLC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_NAU8825_MACH_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_NANDSIM_MODULE: u32 = 1;
pub const CONFIG_HAVE_JUMP_LABEL_HACK: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L56_SPI_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8649_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_QUEUED_RWLOCKS: u32 = 1;
pub const CONFIG_VIDEO_ADV7183_MODULE: u32 = 1;
pub const CONFIG_GENWQE_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TUNER_TEA5761_MODULE: u32 = 1;
pub const CONFIG_MFD_MC13XXX_SPI_MODULE: u32 = 1;
pub const CONFIG_SC92031_MODULE: u32 = 1;
pub const CONFIG_IDPF_MODULE: u32 = 1;
pub const CONFIG_REGMAP_MMIO: u32 = 1;
pub const CONFIG_ARCH_HAS_PKEYS: u32 = 1;
pub const CONFIG_REGULATOR_RT5190A_MODULE: u32 = 1;
pub const CONFIG_SND_TRIDENT_MODULE: u32 = 1;
pub const CONFIG_INTEL_HID_EVENT_MODULE: u32 = 1;
pub const CONFIG_GPIO_MB86S7X_MODULE: u32 = 1;
pub const CONFIG_ENERGY_MODEL: u32 = 1;
pub const CONFIG_NETWORK_SECMARK: u32 = 1;
pub const CONFIG_SND_RIPTIDE_MODULE: u32 = 1;
pub const CONFIG_MEDIA_TEST_SUPPORT: u32 = 1;
pub const CONFIG_POWER_RESET_ATC260X_MODULE: u32 = 1;
pub const CONFIG_SND_CTXFI_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS_BROADCAST: u32 = 1;
pub const CONFIG_RPCSEC_GSS_KRB5_ENCTYPES_CAMELLIA: u32 = 1;
pub const CONFIG_VIDEO_TVAUDIO_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MAX8907_MODULE: u32 = 1;
pub const CONFIG_RXKAD: u32 = 1;
pub const CONFIG_CRYPTO_SIMD_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_WCD934X_MODULE: u32 = 1;
pub const CONFIG_HID_HOLTEK_MODULE: u32 = 1;
pub const CONFIG_TYPEC_MUX_FSA4480_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_ES7241_MODULE: u32 = 1;
pub const CONFIG_POWER_SUPPLY_HWMON: u32 = 1;
pub const CONFIG_ARCH_HAS_ELFCORE_COMPAT: u32 = 1;
pub const CONFIG_DRM_PANEL_ORISETECH_OTA5601A_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_SAMSUNG_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PCI: u32 = 1;
pub const CONFIG_LIB80211_CRYPT_CCMP_MODULE: u32 = 1;
pub const CONFIG_HAVE_MIXED_BREAKPOINTS_REGS: u32 = 1;
pub const CONFIG_DA_MON_EVENTS_ID: u32 = 1;
pub const CONFIG_USB_GSPCA_DTCS033_MODULE: u32 = 1;
pub const CONFIG_SCD4X_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1672_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_MODULE: u32 = 1;
pub const CONFIG_QCOM_SPMI_ADC5_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SSU100_MODULE: u32 = 1;
pub const CONFIG_BATMAN_ADV_DAT: u32 = 1;
pub const CONFIG_MOUSE_PS2_SYNAPTICS: u32 = 1;
pub const CONFIG_DVB_USB_DIB3000MC_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L56_MODULE: u32 = 1;
pub const CONFIG_ATA_BMDMA: u32 = 1;
pub const CONFIG_NFC_SIM_MODULE: u32 = 1;
pub const CONFIG_ATALK_MODULE: u32 = 1;
pub const CONFIG_XZ_DEC_ARMTHUMB: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SOF_PCM512x_MACH_MODULE: u32 = 1;
pub const CONFIG_B43_BCMA: u32 = 1;
pub const CONFIG_SND_SOC_RT5631_MODULE: u32 = 1;
pub const CONFIG_AD7791_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_CS35L33_MODULE: u32 = 1;
pub const CONFIG_MTD_SWAP_MODULE: u32 = 1;
pub const CONFIG_USB_F_UAC1_MODULE: u32 = 1;
pub const CONFIG_DW_EDMA_MODULE: u32 = 1;
pub const CONFIG_XILINX_XDMA_MODULE: u32 = 1;
pub const CONFIG_JFFS2_CMODE_FAVOURLZO: u32 = 1;
pub const CONFIG_SND_SOC_HDAC_HDA_MODULE: u32 = 1;
pub const CONFIG_RTW89_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_MAX98363_MODULE: u32 = 1;
pub const CONFIG_MEMORY_FAILURE: u32 = 1;
pub const CONFIG_NFS_V4_1: u32 = 1;
pub const CONFIG_SKFP_MODULE: u32 = 1;
pub const CONFIG_ARCH_USE_CMPXCHG_LOCKREF: u32 = 1;
pub const CONFIG_ARCH_WANT_FRAME_POINTERS: u32 = 1;
pub const CONFIG_REGMAP: u32 = 1;
pub const CONFIG_SFC_MCDI_MON: u32 = 1;
pub const CONFIG_PATA_PARPORT_FIT2_MODULE: u32 = 1;
pub const CONFIG_6PACK_MODULE: u32 = 1;
pub const CONFIG_NLS_UTF8_MODULE: u32 = 1;
pub const CONFIG_TI_TMAG5273_MODULE: u32 = 1;
pub const CONFIG_RADIO_SI470X_MODULE: u32 = 1;
pub const CONFIG_FB_IOMEM_HELPERS: u32 = 1;
pub const CONFIG_PCIE_PME: u32 = 1;
pub const CONFIG_CIFS_SWN_UPCALL: u32 = 1;
pub const CONFIG_TINYDRM_ILI9225_MODULE: u32 = 1;
pub const CONFIG_JOYSTICK_XPAD_MODULE: u32 = 1;
pub const CONFIG_FB_ATY_BACKLIGHT: u32 = 1;
pub const CONFIG_LIBWX_MODULE: u32 = 1;
pub const CONFIG_BCMA_HOST_SOC: u32 = 1;
pub const CONFIG_PHY_PXA_28NM_USB2_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SSM2602_I2C_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_CLIENT_MODULE: u32 = 1;
pub const CONFIG_HARDENED_USERCOPY: u32 = 1;
pub const CONFIG_KS7010_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_ISERT_MODULE: u32 = 1;
pub const CONFIG_ADIS16130_MODULE: u32 = 1;
pub const CONFIG_BAYCOM_PAR_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_ACP: u32 = 1;
pub const CONFIG_HAVE_MOD_ARCH_SPECIFIC: u32 = 1;
pub const CONFIG_FB_NOTIFY: u32 = 1;
pub const CONFIG_CAN_DEV_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_WM831X_MODULE: u32 = 1;
pub const CONFIG_INPUT_YEALINK_MODULE: u32 = 1;
pub const CONFIG_BMI088_ACCEL_SPI_MODULE: u32 = 1;
pub const CONFIG_KVM_XEN: u32 = 1;
pub const CONFIG_IIO_KX022A_SPI_MODULE: u32 = 1;
pub const CONFIG_COMEDI_VMK80XX_MODULE: u32 = 1;
pub const CONFIG_INTEL_PMT_TELEMETRY_MODULE: u32 = 1;
pub const CONFIG_DVB_DIB3000MB_MODULE: u32 = 1;
pub const CONFIG_IEEE802154_CC2520_MODULE: u32 = 1;
pub const CONFIG_FW_CFG_SYSFS_MODULE: u32 = 1;
pub const CONFIG_USB_PXA27X_MODULE: u32 = 1;
pub const CONFIG_ADV_SWBUTTON_MODULE: u32 = 1;
pub const CONFIG_MFD_DA9055: u32 = 1;
pub const CONFIG_SENSORS_NCT6683_MODULE: u32 = 1;
pub const CONFIG_AD5755_MODULE: u32 = 1;
pub const CONFIG_TI_ADC081C_MODULE: u32 = 1;
pub const CONFIG_PKCS8_PRIVATE_KEY_PARSER_MODULE: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_SPKOUT_MODULE: u32 = 1;
pub const CONFIG_TYPEC_NVIDIA_ALTMODE_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_M41T80_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_I2S_MODULE: u32 = 1;
pub const CONFIG_STRICT_MODULE_RWX: u32 = 1;
pub const CONFIG_SND_SOC_XILINX_AUDIO_FORMATTER_MODULE: u32 = 1;
pub const CONFIG_VHOST_IOTLB_MODULE: u32 = 1;
pub const CONFIG_SERIAL_MEN_Z135_MODULE: u32 = 1;
pub const CONFIG_PCCARD_NONSTATIC: u32 = 1;
pub const CONFIG_VT6656_MODULE: u32 = 1;
pub const CONFIG_XEN_SCSI_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_USB_USBNET_MODULE: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_MODULE: u32 = 1;
pub const CONFIG_LEDS_SIEMENS_SIMATIC_IPC_MODULE: u32 = 1;
pub const CONFIG_NET_DEVLINK: u32 = 1;
pub const CONFIG_INTEL_SOC_PMIC_BXTWC_MODULE: u32 = 1;
pub const CONFIG_EBC_C384_WDT_MODULE: u32 = 1;
pub const CONFIG_PROC_PID_ARCH_STATUS: u32 = 1;
pub const CONFIG_CPU_SUP_CENTAUR: u32 = 1;
pub const CONFIG_SND_SOC_CS4271_MODULE: u32 = 1;
pub const CONFIG_CB710_CORE_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_PL2303_MODULE: u32 = 1;
pub const CONFIG_NET_ACT_POLICE_MODULE: u32 = 1;
pub const CONFIG_AIC79XX_DEBUG_MASK: u32 = 0;
pub const CONFIG_ASM_MODVERSIONS: u32 = 1;
pub const CONFIG_UEFI_CPER: u32 = 1;
pub const CONFIG_IMA_ARCH_POLICY: u32 = 1;
pub const CONFIG_HAVE_INTEL_TXT: u32 = 1;
pub const CONFIG_HAMRADIO: u32 = 1;
pub const CONFIG_SYSCTL_EXCEPTION_TRACE: u32 = 1;
pub const CONFIG_M62332_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_IDT821034_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_PCAP_MODULE: u32 = 1;
pub const CONFIG_SERIAL_UARTLITE_NR_UARTS: u32 = 1;
pub const CONFIG_SYSVIPC_COMPAT: u32 = 1;
pub const CONFIG_MFD_SY7636A_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCA953X_MODULE: u32 = 1;
pub const CONFIG_INPUT_XEN_KBDDEV_FRONTEND_MODULE: u32 = 1;
pub const CONFIG_HOTPLUG_PCI_SHPC: u32 = 1;
pub const CONFIG_AD7091R5_MODULE: u32 = 1;
pub const CONFIG_HINIC_MODULE: u32 = 1;
pub const CONFIG_ADIS16240_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CINERGY_T2_MODULE: u32 = 1;
pub const CONFIG_CEC_SECO_RC: u32 = 1;
pub const CONFIG_FHANDLE: u32 = 1;
pub const CONFIG_COMEDI_ADDI_APCI_3XXX_MODULE: u32 = 1;
pub const CONFIG_FS_VERITY_BUILTIN_SIGNATURES: u32 = 1;
pub const CONFIG_SERIAL_ALTERA_UART_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_ETS_MODULE: u32 = 1;
pub const CONFIG_USB_MICROTEK_MODULE: u32 = 1;
pub const CONFIG_HAVE_SAMPLE_FTRACE_DIRECT_MULTI: u32 = 1;
pub const CONFIG_PANASONIC_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_ACP_COMMON_MODULE: u32 = 1;
pub const CONFIG_INPUT_MC13783_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_HID_SMARTJOYPLUS_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_OPEN_TIMEOUT: u32 = 0;
pub const CONFIG_ATA_GENERIC: u32 = 1;
pub const CONFIG_INTEL_VSEC_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_GOODIX_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_LIB_SHA256: u32 = 1;
pub const CONFIG_NEW_LEDS: u32 = 1;
pub const CONFIG_SND_SST_ATOM_HIFI2_PLATFORM_PCI_MODULE: u32 = 1;
pub const CONFIG_SWAP: u32 = 1;
pub const CONFIG_CRC64: u32 = 1;
pub const CONFIG_MTD_MCHP23K256_MODULE: u32 = 1;
pub const CONFIG_AD5592R_BASE_MODULE: u32 = 1;
pub const CONFIG_MTD_ONENAND_MODULE: u32 = 1;
pub const CONFIG_FW_CACHE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_DEFAULT_GOV_NOOP: u32 = 1;
pub const CONFIG_B53_SPI_DRIVER_MODULE: u32 = 1;
pub const CONFIG_NFT_BRIDGE_META_MODULE: u32 = 1;
pub const CONFIG_IIO_RESCALE_MODULE: u32 = 1;
pub const CONFIG_GENERIC_ADC_BATTERY_MODULE: u32 = 1;
pub const CONFIG_MOUSE_ELAN_I2C_I2C: u32 = 1;
pub const CONFIG_RTC_DRV_DS1511_MODULE: u32 = 1;
pub const CONFIG_USB_NET_CDC_SUBSET_ENABLE_MODULE: u32 = 1;
pub const CONFIG_IP_FIB_TRIE_STATS: u32 = 1;
pub const CONFIG_CRYPTO_SHA256_SSSE3_MODULE: u32 = 1;
pub const CONFIG_ATM_FORE200E_MODULE: u32 = 1;
pub const CONFIG_VIDEO_SOLO6X10_MODULE: u32 = 1;
pub const CONFIG_MLX5_EN_RXNFC: u32 = 1;
pub const CONFIG_DMABUF_MOVE_NOTIFY: u32 = 1;
pub const CONFIG_NET_SCH_HFSC_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_RV3029C2_MODULE: u32 = 1;
pub const CONFIG_GPIO_TWL6040_MODULE: u32 = 1;
pub const CONFIG_ADIN_PHY_MODULE: u32 = 1;
pub const CONFIG_WIL6210_MODULE: u32 = 1;
pub const CONFIG_SND_ISIGHT_MODULE: u32 = 1;
pub const CONFIG_MTD_NAND_DISKONCHIP_MODULE: u32 = 1;
pub const CONFIG_INTEL_MRFLD_ADC_MODULE: u32 = 1;
pub const CONFIG_MAC80211_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKL_NAU88L25_SSM4567_MACH_MODULE: u32 = 1;
pub const CONFIG_SPI_ALTERA_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_GENERAL_TOUCH: u32 = 1;
pub const CONFIG_MEGARAID_MM_MODULE: u32 = 1;
pub const CONFIG_BME680_I2C_MODULE: u32 = 1;
pub const CONFIG_ARCH_USES_PG_UNCACHED: u32 = 1;
pub const CONFIG_CRC_CCITT: u32 = 1;
pub const CONFIG_SND_SOC_TS3A227E_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_XILINX_I2S_MODULE: u32 = 1;
pub const CONFIG_IPVLAN_L3S: u32 = 1;
pub const CONFIG_DRM_ACCEL_HABANALABS_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_CAVIUM: u32 = 1;
pub const CONFIG_GPIOLIB_IRQCHIP: u32 = 1;
pub const CONFIG_BPF_UNPRIV_DEFAULT_OFF: u32 = 1;
pub const CONFIG_DVB_TDA8261_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_EXT_CORE_MODULE: u32 = 1;
pub const CONFIG_IGBVF_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_SD: u32 = 1;
pub const CONFIG_SND_SEQ_VIRMIDI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_APOLLOLAKE_MODULE: u32 = 1;
pub const CONFIG_MFD_MAX14577: u32 = 1;
pub const CONFIG_NET_NCSI: u32 = 1;
pub const CONFIG_PHYSICAL_ALIGN: u32 = 2097152;
pub const CONFIG_SND_SOC_SOF_HDA_LINK_BASELINE_MODULE: u32 = 1;
pub const CONFIG_VIDEO_TC358746_MODULE: u32 = 1;
pub const CONFIG_ACPI_LEGACY_TABLES_LOOKUP: u32 = 1;
pub const CONFIG_INPUT_AD714X_SPI_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_NETLINK_MODULE: u32 = 1;
pub const CONFIG_VITESSE_PHY_MODULE: u32 = 1;
pub const CONFIG_MODULE_UNLOAD: u32 = 1;
pub const CONFIG_KEXEC_BZIMAGE_VERIFY_SIG: u32 = 1;
pub const CONFIG_CLOCKSOURCE_WATCHDOG_MAX_SKEW_US: u32 = 100;
pub const CONFIG_FSCACHE_STATS: u32 = 1;
pub const CONFIG_DEVFREQ_GOV_USERSPACE: u32 = 1;
pub const CONFIG_INTEL_SDSI_MODULE: u32 = 1;
pub const CONFIG_INFINIBAND_MTHCA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MAX9271_LIB_MODULE: u32 = 1;
pub const CONFIG_SYSTEM76_ACPI_MODULE: u32 = 1;
pub const CONFIG_PREEMPT_COUNT: u32 = 1;
pub const CONFIG_SENSORS_MAX6650_MODULE: u32 = 1;
pub const CONFIG_SPI_SLAVE: u32 = 1;
pub const CONFIG_USB_GSPCA_BENQ_MODULE: u32 = 1;
pub const CONFIG_NET_VENDOR_ENGLEDER: u32 = 1;
pub const CONFIG_HAVE_ACPI_APEI_NMI: u32 = 1;
pub const CONFIG_REGULATOR_TPS65023_MODULE: u32 = 1;
pub const CONFIG_BT_LE: u32 = 1;
pub const CONFIG_PINCTRL_SX150X: u32 = 1;
pub const CONFIG_SND_AC97_CODEC_MODULE: u32 = 1;
pub const CONFIG_PCI_SW_SWITCHTEC_MODULE: u32 = 1;
pub const CONFIG_ARCH_WANT_OLD_COMPAT_IPC: u32 = 1;
pub const CONFIG_RTC_DRV_CROS_EC_MODULE: u32 = 1;
pub const CONFIG_HID_U2FZERO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_DA7219_MODULE: u32 = 1;
pub const CONFIG_MOXA_SMARTIO_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AK4613_MODULE: u32 = 1;
pub const CONFIG_VIDEO_MT9V032_MODULE: u32 = 1;
pub const CONFIG_XIAOMI_WMI_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CXUSB_MODULE: u32 = 1;
pub const CONFIG_TSL2583_MODULE: u32 = 1;
pub const CONFIG_RT2500PCI_MODULE: u32 = 1;
pub const CONFIG_RWSEM_SPIN_ON_OWNER: u32 = 1;
pub const CONFIG_SENSORS_LM85_MODULE: u32 = 1;
pub const CONFIG_AD525X_DPOT_MODULE: u32 = 1;
pub const CONFIG_SND_ATIIXP_MODULE: u32 = 1;
pub const CONFIG_MEDIATEK_GE_PHY_MODULE: u32 = 1;
pub const CONFIG_VL6180_MODULE: u32 = 1;
pub const CONFIG_DIMLIB: u32 = 1;
pub const CONFIG_MEDIA_TUNER_M88RS6000T_MODULE: u32 = 1;
pub const CONFIG_TRACER_SNAPSHOT: u32 = 1;
pub const CONFIG_INFINIBAND_IPOIB_CM: u32 = 1;
pub const CONFIG_COMEDI_PARPORT_MODULE: u32 = 1;
pub const CONFIG_GPIO_PCA9570_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_LCD: u32 = 1;
pub const CONFIG_HAVE_RELIABLE_STACKTRACE: u32 = 1;
pub const CONFIG_SENSORS_MLXREG_FAN_MODULE: u32 = 1;
pub const CONFIG_HAVE_NOINSTR_HACK: u32 = 1;
pub const CONFIG_CC_HAS_ASM_GOTO_OUTPUT: u32 = 1;
pub const CONFIG_BITREVERSE: u32 = 1;
pub const CONFIG_SENSORS_LT7182S_MODULE: u32 = 1;
pub const CONFIG_DEVPORT: u32 = 1;
pub const CONFIG_IGC_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CX88_ENABLE_VP3054: u32 = 1;
pub const CONFIG_MFD_ATC260X_I2C_MODULE: u32 = 1;
pub const CONFIG_PREEMPTION: u32 = 1;
pub const CONFIG_DRM_I915_COMPRESS_ERROR: u32 = 1;
pub const CONFIG_IOSCHED_BFQ_MODULE: u32 = 1;
pub const CONFIG_MACB_USE_HWSTAMP: u32 = 1;
pub const CONFIG_SENSORS_LTC2947_I2C_MODULE: u32 = 1;
pub const CONFIG_INTEL_RST_MODULE: u32 = 1;
pub const CONFIG_X509_CERTIFICATE_PARSER: u32 = 1;
pub const CONFIG_GPIO_PCIE_IDIO_24_MODULE: u32 = 1;
pub const CONFIG_BLK_DEV_RAM_SIZE: u32 = 65536;
pub const CONFIG_USB_SERIAL_WWAN_MODULE: u32 = 1;
pub const CONFIG_VIDEO_DW9719_MODULE: u32 = 1;
pub const CONFIG_REGMAP_I3C_MODULE: u32 = 1;
pub const CONFIG_SND_ICE1724_MODULE: u32 = 1;
pub const CONFIG_MAC_PARTITION: u32 = 1;
pub const CONFIG_CONSOLE_POLL: u32 = 1;
pub const CONFIG_EARLY_PRINTK_USB: u32 = 1;
pub const CONFIG_VIDEO_OV8865_MODULE: u32 = 1;
pub const CONFIG_INTEL_MEI_PXP_MODULE: u32 = 1;
pub const CONFIG_HID_ALPS_MODULE: u32 = 1;
pub const CONFIG_IIO_ADIS_LIB_BUFFER: u32 = 1;
pub const CONFIG_SENSORS_DA9052_ADC_MODULE: u32 = 1;
pub const CONFIG_NFT_TPROXY_MODULE: u32 = 1;
pub const CONFIG_XFS_POSIX_ACL: u32 = 1;
pub const CONFIG_TTY_PRINTK_LEVEL: u32 = 6;
pub const CONFIG_PTP_1588_CLOCK_KVM_MODULE: u32 = 1;
pub const CONFIG_VFIO_PCI_CORE_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DA9034_MODULE: u32 = 1;
pub const CONFIG_RV_MON_WWNR: u32 = 1;
pub const CONFIG_IIO_ST_LSM6DSX_SPI_MODULE: u32 = 1;
pub const CONFIG_MLXREG_IO_MODULE: u32 = 1;
pub const CONFIG_INT3406_THERMAL_MODULE: u32 = 1;
pub const CONFIG_PATA_PARPORT_FRIQ_MODULE: u32 = 1;
pub const CONFIG_MSI_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_XEN_PRIVCMD_EVENTFD: u32 = 1;
pub const CONFIG_PDS_CORE_MODULE: u32 = 1;
pub const CONFIG_COMEDI_DT2801_MODULE: u32 = 1;
pub const CONFIG_BRCMFMAC_USB: u32 = 1;
pub const CONFIG_TOUCHSCREEN_DYNAPRO_MODULE: u32 = 1;
pub const CONFIG_FB_MODE_HELPERS: u32 = 1;
pub const CONFIG_UBSAN: u32 = 1;
pub const CONFIG_NLS_ISO8859_13_MODULE: u32 = 1;
pub const CONFIG_MTD_MTDRAM_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_TLV320AIC3X_I2C_MODULE: u32 = 1;
pub const CONFIG_PCI_PRI: u32 = 1;
pub const CONFIG_MT76_CONNAC_LIB_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_SM4_AESNI_AVX_X86_64_MODULE: u32 = 1;
pub const CONFIG_EXTCON_MAX77693_MODULE: u32 = 1;
pub const CONFIG_X86_L1_CACHE_SHIFT: u32 = 6;
pub const CONFIG_BATTERY_BQ27XXX_HDQ_MODULE: u32 = 1;
pub const CONFIG_X86_PAT: u32 = 1;
pub const CONFIG_USB_STORAGE_ONETOUCH_MODULE: u32 = 1;
pub const CONFIG_NLS_ISO8859_8_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_SKL_NAU88L25_MAX98357A_MACH_MODULE: u32 = 1;
pub const CONFIG_RT2400PCI_MODULE: u32 = 1;
pub const CONFIG_ICE_HWMON: u32 = 1;
pub const CONFIG_NF_CONNTRACK_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_PCF8523_MODULE: u32 = 1;
pub const CONFIG_EROFS_FS_MODULE: u32 = 1;
pub const CONFIG_HID_PICOLCD_CIR: u32 = 1;
pub const CONFIG_BACKLIGHT_PANDORA_MODULE: u32 = 1;
pub const CONFIG_COMEDI_GSC_HPDI_MODULE: u32 = 1;
pub const CONFIG_NI_XGE_MANAGEMENT_ENET_MODULE: u32 = 1;
pub const CONFIG_FB_NVIDIA_MODULE: u32 = 1;
pub const CONFIG_EFI_RUNTIME_WRAPPERS: u32 = 1;
pub const CONFIG_LCD_CLASS_DEVICE_MODULE: u32 = 1;
pub const CONFIG_MDIO_DEVRES: u32 = 1;
pub const CONFIG_LSM: &[u8; 42usize] = b"landlock,lockdown,yama,integrity,apparmor\0";
pub const CONFIG_SENSORS_OCC_MODULE: u32 = 1;
pub const CONFIG_ARCH_DMA_ADDR_T_64BIT: u32 = 1;
pub const CONFIG_FILE_LOCKING: u32 = 1;
pub const CONFIG_PATA_HPT3X3_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_XIRLINK_CIT_MODULE: u32 = 1;
pub const CONFIG_AD2S1200_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_STK17TA8_MODULE: u32 = 1;
pub const CONFIG_USB_GSPCA_SN9C20X_MODULE: u32 = 1;
pub const CONFIG_CRC64_ROCKSOFT: u32 = 1;
pub const CONFIG_RMI4_F03: u32 = 1;
pub const CONFIG_TOUCHSCREEN_USB_ELO: u32 = 1;
pub const CONFIG_TCG_TIS_I2C_CR50_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1302_MODULE: u32 = 1;
pub const CONFIG_USB_CHAOSKEY_MODULE: u32 = 1;
pub const CONFIG_GENERIC_CLOCKEVENTS_MIN_ADJUST: u32 = 1;
pub const CONFIG_TEST_BPF_MODULE: u32 = 1;
pub const CONFIG_FS_DAX_PMD: u32 = 1;
pub const CONFIG_BACKLIGHT_LV5207LP_MODULE: u32 = 1;
pub const CONFIG_KARMA_PARTITION: u32 = 1;
pub const CONFIG_FB_SM501_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_I2C_AND_SPI_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_AMD_PS_MODULE: u32 = 1;
pub const CONFIG_NETPOLL: u32 = 1;
pub const CONFIG_COMEDI_ISADMA_MODULE: u32 = 1;
pub const CONFIG_ZSWAP: u32 = 1;
pub const CONFIG_SPEAKUP_SYNTH_AUDPTR_MODULE: u32 = 1;
pub const CONFIG_MAC80211_MESSAGE_TRACING: u32 = 1;
pub const CONFIG_SENSORS_F71882FG_MODULE: u32 = 1;
pub const CONFIG_ACPI_APEI_GHES: u32 = 1;
pub const CONFIG_SND_SOC_UDA1334_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_TOPLEVEL: u32 = 1;
pub const CONFIG_PINCTRL_ICELAKE_MODULE: u32 = 1;
pub const CONFIG_SENSORS_ADT7310_MODULE: u32 = 1;
pub const CONFIG_AIO: u32 = 1;
pub const CONFIG_SERIO_ARC_PS2_MODULE: u32 = 1;
pub const CONFIG_DVB_TDA8083_MODULE: u32 = 1;
pub const CONFIG_NET_MPLS_GSO_MODULE: u32 = 1;
pub const CONFIG_NFC_FDP_I2C_MODULE: u32 = 1;
pub const CONFIG_RTC_DRV_DS1347_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_LPASS_WSA_MACRO_MODULE: u32 = 1;
pub const CONFIG_CLKEVT_I8253: u32 = 1;
pub const CONFIG_DVB_USB_AZ6007_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_USERSPACE_CONSUMER_MODULE: u32 = 1;
pub const CONFIG_NET_EMATCH: u32 = 1;
pub const CONFIG_PERF_EVENTS: u32 = 1;
pub const CONFIG_MMC_REALTEK_USB_MODULE: u32 = 1;
pub const CONFIG_GENERIC_TIME_VSYSCALL: u32 = 1;
pub const CONFIG_IP_NF_TARGET_REJECT_MODULE: u32 = 1;
pub const CONFIG_INTEL_SCU_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_REGULATOR_MP8859_MODULE: u32 = 1;
pub const CONFIG_HAVE_MOVE_PMD: u32 = 1;
pub const CONFIG_ZIIRAVE_WATCHDOG_MODULE: u32 = 1;
pub const CONFIG_NET_SCH_CHOKE_MODULE: u32 = 1;
pub const CONFIG_LTC2688_MODULE: u32 = 1;
pub const CONFIG_IOMMU_IO_PGTABLE: u32 = 1;
pub const CONFIG_GVE_MODULE: u32 = 1;
pub const CONFIG_LEDS_CLASS: u32 = 1;
pub const CONFIG_COMEDI_BOND_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_DIGITV_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_HL_MODULE: u32 = 1;
pub const CONFIG_PERF_EVENTS_INTEL_CSTATE_MODULE: u32 = 1;
pub const CONFIG_TIPC_MEDIA_IB: u32 = 1;
pub const CONFIG_VIDEO_SAA7110_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_XRS700X_MODULE: u32 = 1;
pub const CONFIG_MTD_L440GX_MODULE: u32 = 1;
pub const CONFIG_GPIO_GPIO_MM_MODULE: u32 = 1;
pub const CONFIG_INPUT_IQS626A_MODULE: u32 = 1;
pub const CONFIG_IP_VS_TAB_BITS: u32 = 12;
pub const CONFIG_COMEDI_NI_AT_AO_MODULE: u32 = 1;
pub const CONFIG_IP6_NF_MATCH_OPTS_MODULE: u32 = 1;
pub const CONFIG_SENSORS_DA9055_MODULE: u32 = 1;
pub const CONFIG_INPUT_TWL4030_PWRBUTTON_MODULE: u32 = 1;
pub const CONFIG_SCSI_SAS_HOST_SMP: u32 = 1;
pub const CONFIG_BCACHE_ASYNC_REGISTRATION: u32 = 1;
pub const CONFIG_VERSION_SIGNATURE: &[u8; 34usize] = b"Ubuntu 6.8.0-51.52-generic 6.8.12\0";
pub const CONFIG_PLAYSTATION_FF: u32 = 1;
pub const CONFIG_RTC_INTF_DEV: u32 = 1;
pub const CONFIG_SND_HDA_SCODEC_CS35L41_SPI_MODULE: u32 = 1;
pub const CONFIG_HID_SIGMAMICRO_MODULE: u32 = 1;
pub const CONFIG_SPI_SIFIVE_MODULE: u32 = 1;
pub const CONFIG_MTD_MAP_BANK_WIDTH_4: u32 = 1;
pub const CONFIG_IIO_ST_SENSORS_SPI_MODULE: u32 = 1;
pub const CONFIG_GREYBUS_SPI_MODULE: u32 = 1;
pub const CONFIG_DELL_WMI_SYSMAN_MODULE: u32 = 1;
pub const CONFIG_EISA_VIRTUAL_ROOT: u32 = 1;
pub const CONFIG_HID_SUPPORT: u32 = 1;
pub const CONFIG_DCACHE_WORD_ACCESS: u32 = 1;
pub const CONFIG_IP6_NF_TARGET_NPT_MODULE: u32 = 1;
pub const CONFIG_DVB_USB_CE6230_MODULE: u32 = 1;
pub const CONFIG_RTW88_8822BE_MODULE: u32 = 1;
pub const CONFIG_ADF4377_MODULE: u32 = 1;
pub const CONFIG_PTP_1588_CLOCK_INES_MODULE: u32 = 1;
pub const CONFIG_VIDEO_OV5675_MODULE: u32 = 1;
pub const CONFIG_USB_SERIAL_SYMBOL_MODULE: u32 = 1;
pub const CONFIG_PSTORE_COMPRESS: u32 = 1;
pub const CONFIG_CHARGER_MAX77693_MODULE: u32 = 1;
pub const CONFIG_MAGIC_SYSRQ_SERIAL_SEQUENCE: &[u8; 1usize] = b"\0";
pub const CONFIG_REGULATOR_MAX8952_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_HDMI_CODEC_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_OSF_MODULE: u32 = 1;
pub const CONFIG_MLX_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_ADIS16460_MODULE: u32 = 1;
pub const CONFIG_USB_MIDI_GADGET_MODULE: u32 = 1;
pub const CONFIG_SATA_QSTOR_MODULE: u32 = 1;
pub const CONFIG_VIDEO_GO7007_MODULE: u32 = 1;
pub const CONFIG_PATA_SIS: u32 = 1;
pub const CONFIG_MESSAGE_LOGLEVEL_DEFAULT: u32 = 4;
pub const CONFIG_GPIO_TWL4030_MODULE: u32 = 1;
pub const CONFIG_AMD_NB: u32 = 1;
pub const CONFIG_SND_VIRMIDI_MODULE: u32 = 1;
pub const CONFIG_LIB80211_CRYPT_TKIP_MODULE: u32 = 1;
pub const CONFIG_APDS9960_MODULE: u32 = 1;
pub const CONFIG_NGBE_MODULE: u32 = 1;
pub const CONFIG_LOCKUP_DETECTOR: u32 = 1;
pub const CONFIG_QSEMI_PHY_MODULE: u32 = 1;
pub const CONFIG_IP_VS_PROTO_UDP: u32 = 1;
pub const CONFIG_HSC030PA_MODULE: u32 = 1;
pub const CONFIG_VIDEO_BT866_MODULE: u32 = 1;
pub const CONFIG_VIDEO_CAMERA_SENSOR: u32 = 1;
pub const CONFIG_NLS_DEFAULT: &[u8; 5usize] = b"utf8\0";
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV_NOOP: u32 = 1;
pub const CONFIG_ACPI_CONTAINER: u32 = 1;
pub const CONFIG_SND_DMA_SGBUF: u32 = 1;
pub const CONFIG_UTS_NS: u32 = 1;
pub const CONFIG_I2C_AMD_MP2_MODULE: u32 = 1;
pub const CONFIG_NF_CT_PROTO_GRE: u32 = 1;
pub const CONFIG_SND_CTL_LED_MODULE: u32 = 1;
pub const CONFIG_VIDEO_NOMODESET: u32 = 1;
pub const CONFIG_PAGE_REPORTING: u32 = 1;
pub const CONFIG_HDMI_LPE_AUDIO_MODULE: u32 = 1;
pub const CONFIG_WMI_BMOF_MODULE: u32 = 1;
pub const CONFIG_BT_HCIUART_BCSP: u32 = 1;
pub const CONFIG_NF_CT_NETLINK_MODULE: u32 = 1;
pub const CONFIG_AHCI_DWC_MODULE: u32 = 1;
pub const CONFIG_EFS_FS_MODULE: u32 = 1;
pub const CONFIG_AUXDISPLAY: u32 = 1;
pub const CONFIG_SVC_I3C_MASTER_MODULE: u32 = 1;
pub const CONFIG_USB_NET_SR9800_MODULE: u32 = 1;
pub const CONFIG_DMA_ENGINE: u32 = 1;
pub const CONFIG_NET_EMATCH_TEXT_MODULE: u32 = 1;
pub const CONFIG_SCA3300_MODULE: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_ANALOG_MODULE: u32 = 1;
pub const CONFIG_SERIAL_8250_PCI1XXXX_MODULE: u32 = 1;
pub const CONFIG_ADIS16209_MODULE: u32 = 1;
pub const CONFIG_X86_ACPI_CPUFREQ: u32 = 1;
pub const CONFIG_HID_WIIMOTE_MODULE: u32 = 1;
pub const CONFIG_BACKLIGHT_AS3711_MODULE: u32 = 1;
pub const CONFIG_APDS9300_MODULE: u32 = 1;
pub const CONFIG_USB_MA901_MODULE: u32 = 1;
pub const CONFIG_P54_SPI_MODULE: u32 = 1;
pub const CONFIG_IAVF_MODULE: u32 = 1;
pub const CONFIG_RDS_TCP_MODULE: u32 = 1;
pub const CONFIG_HAVE_ARCH_TRANSPARENT_HUGEPAGE_PUD: u32 = 1;
pub const CONFIG_CGROUP_PIDS: u32 = 1;
pub const CONFIG_CRYPTO_AEAD2: u32 = 1;
pub const CONFIG_CRYPTO_FCRYPT_MODULE: u32 = 1;
pub const CONFIG_DEBUG_INFO: u32 = 1;
pub const CONFIG_XEN_PVHVM_GUEST: u32 = 1;
pub const CONFIG_X86_HV_CALLBACK_VECTOR: u32 = 1;
pub const CONFIG_NFC_NCI_MODULE: u32 = 1;
pub const CONFIG_TOSHIBA_BT_RFKILL_MODULE: u32 = 1;
pub const CONFIG_WATCHDOG_PRETIMEOUT_GOV_PANIC_MODULE: u32 = 1;
pub const CONFIG_MOUSE_PS2_MODULE: u32 = 1;
pub const CONFIG_NET_IPIP_MODULE: u32 = 1;
pub const CONFIG_IP_VS_SH_TAB_BITS: u32 = 8;
pub const CONFIG_USB_SERIAL_IPAQ_MODULE: u32 = 1;
pub const CONFIG_PCI_ENDPOINT: u32 = 1;
pub const CONFIG_NETFILTER_XT_MATCH_HL_MODULE: u32 = 1;
pub const CONFIG_IPU_BRIDGE_MODULE: u32 = 1;
pub const CONFIG_CHROMEOS_LAPTOP_MODULE: u32 = 1;
pub const CONFIG_DRM_AMD_SECURE_DISPLAY: u32 = 1;
pub const CONFIG_NFC_DIGITAL_MODULE: u32 = 1;
pub const CONFIG_LEDS_TCA6507_MODULE: u32 = 1;
pub const CONFIG_SND_USB_POD_MODULE: u32 = 1;
pub const CONFIG_CRYPTO_ALGAPI2: u32 = 1;
pub const CONFIG_SATA_SIS_MODULE: u32 = 1;
pub const CONFIG_PHYSICAL_START: u32 = 16777216;
pub const CONFIG_NETFILTER_XT_TARGET_LED_MODULE: u32 = 1;
pub const CONFIG_WEXT_SPY: u32 = 1;
pub const CONFIG_UBIFS_FS_LZO: u32 = 1;
pub const CONFIG_SI1145_MODULE: u32 = 1;
pub const CONFIG_USB_G_ACM_MS_MODULE: u32 = 1;
pub const CONFIG_ACPI_SBS_MODULE: u32 = 1;
pub const CONFIG_KEYBOARD_ADP5589_MODULE: u32 = 1;
pub const CONFIG_MCP41010_MODULE: u32 = 1;
pub const CONFIG_GENERIC_IRQ_RESERVATION_MODE: u32 = 1;
pub const CONFIG_FB_3DFX_MODULE: u32 = 1;
pub const CONFIG_TOUCHSCREEN_SILEAD_MODULE: u32 = 1;
pub const CONFIG_X86_PMEM_LEGACY: u32 = 1;
pub const CONFIG_HAVE_EFFICIENT_UNALIGNED_ACCESS: u32 = 1;
pub const CONFIG_RTW89_DEBUG: u32 = 1;
pub const CONFIG_INPUT: u32 = 1;
pub const CONFIG_RTW89_8852A_MODULE: u32 = 1;
pub const CONFIG_MICROCHIP_T1_PHY_MODULE: u32 = 1;
pub const CONFIG_PCI200SYN_MODULE: u32 = 1;
pub const CONFIG_PPPOATM_MODULE: u32 = 1;
pub const CONFIG_PDS_VFIO_PCI_MODULE: u32 = 1;
pub const CONFIG_INV_ICM42600_I2C_MODULE: u32 = 1;
pub const CONFIG_SENSORS_XDPE152_MODULE: u32 = 1;
pub const CONFIG_SIOX_MODULE: u32 = 1;
pub const CONFIG_SND_SOC_SOF_AMD_ACP63_MODULE: u32 = 1;
pub const CONFIG_BT_NXPUART_MODULE: u32 = 1;
pub const CONFIG_PMIC_DA9052: u32 = 1;
pub const CONFIG_PATA_OPTI_MODULE: u32 = 1;
pub const CONFIG_PROC_SYSCTL: u32 = 1;
pub const CONFIG_SND_HDA_CODEC_REALTEK_MODULE: u32 = 1;
pub const CONFIG_ATH6KL_MODULE: u32 = 1;
pub const CONFIG_FWNODE_MDIO: u32 = 1;
pub const CONFIG_HAVE_PERF_EVENTS_NMI: u32 = 1;
pub const CONFIG_SND_SOC_FSL_ASRC_MODULE: u32 = 1;
pub const CONFIG_NET_DSA_REALTEK_RTL8366RB_MODULE: u32 = 1;
pub const CONFIG_NETFILTER_XT_TARGET_CT_MODULE: u32 = 1;
pub const CONFIG_RD_LZ4: u32 = 1;
pub const CONFIG_CPU_MITIGATIONS: u32 = 1;
pub const CONFIG_MMU: u32 = 1;
pub const CONFIG_DVB_CX24123_MODULE: u32 = 1;
pub const CONFIG_RTW89_8851B_MODULE: u32 = 1;
pub const CONFIG_MEDIA_CONTROLLER_DVB: u32 = 1;
pub const CONFIG_NET_DSA_MV88E6XXX_PTP: u32 = 1;
pub const CONFIG_OCFS2_FS_MODULE: u32 = 1;
pub const CONFIG_KFENCE_NUM_OBJECTS: u32 = 255;
pub const CONFIG_ATH11K_DEBUGFS: u32 = 1;
pub const CONFIG_USB_KAWETH_MODULE: u32 = 1;
pub const CONFIG_USB_SIERRA_NET_MODULE: u32 = 1;
pub const CONFIG_AIC7XXX_RESET_DELAY_MS: u32 = 5000;
pub const CONFIG_VMWARE_BALLOON_MODULE: u32 = 1;
pub const CONFIG_LD_VERSION: u32 = 24200;
pub const CONFIG_BRIDGE_EBT_NFLOG_MODULE: u32 = 1;
pub const CONFIG_CAN_SJA1000_PLATFORM_MODULE: u32 = 1;
pub const CONFIG_HAVE_HARDLOCKUP_DETECTOR_BUDDY: u32 = 1;
pub const CONFIG_VIDEO_DW9768_MODULE: u32 = 1;
pub const CONFIG_TABLET_USB_AIPTEK_MODULE: u32 = 1;
pub const CONFIG_BNXT_SRIOV: u32 = 1;
pub const CONFIG_INTEL_SCU: u32 = 1;
pub const CONFIG_SND_SOC_INTEL_CHT_BSW_NAU8824_MACH_MODULE: u32 = 1;
pub const CONFIG_AGP: u32 = 1;
pub const CONFIG_ZPOOL: u32 = 1;
pub const CONFIG_CC_HAS_SLS: u32 = 1;
pub const CONFIG_REGULATOR_TPS6524X_MODULE: u32 = 1;
pub const CONFIG_INPUT_AD714X_MODULE: u32 = 1;
pub const CONFIG_SENSORS_GL520SM_MODULE: u32 = 1;
pub const CONFIG_E1000_MODULE: u32 = 1;
pub const CONFIG_SCSI_SYM53C8XX_MMIO: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const KASAN_ABI_VERSION: u32 = 5;
pub const __BITS_PER_LONG: u32 = 64;
pub const BITS_PER_LONG: u32 = 64;
pub const BITS_PER_LONG_LONG: u32 = 64;
pub const __FD_SETSIZE: u32 = 1024;
pub const KCSAN_ACCESS_WRITE: u32 = 1;
pub const KCSAN_ACCESS_COMPOUND: u32 = 2;
pub const KCSAN_ACCESS_ATOMIC: u32 = 4;
pub const KCSAN_ACCESS_ASSERT: u32 = 8;
pub const KCSAN_ACCESS_SCOPED: u32 = 16;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const EHWPOISON: u32 = 133;
pub const MAX_ERRNO: u32 = 4095;
pub const KERN_SOH: &[u8; 2usize] = b"\x01\0";
pub const KERN_SOH_ASCII: u8 = 1u8;
pub const KERN_EMERG: &[u8; 3usize] = b"\x010\0";
pub const KERN_ALERT: &[u8; 3usize] = b"\x011\0";
pub const KERN_CRIT: &[u8; 3usize] = b"\x012\0";
pub const KERN_ERR: &[u8; 3usize] = b"\x013\0";
pub const KERN_WARNING: &[u8; 3usize] = b"\x014\0";
pub const KERN_NOTICE: &[u8; 3usize] = b"\x015\0";
pub const KERN_INFO: &[u8; 3usize] = b"\x016\0";
pub const KERN_DEBUG: &[u8; 3usize] = b"\x017\0";
pub const KERN_DEFAULT: &[u8; 1usize] = b"\0";
pub const KERN_CONT: &[u8; 3usize] = b"\x01c\0";
pub const LOGLEVEL_SCHED: i32 = -2;
pub const LOGLEVEL_DEFAULT: i32 = -1;
pub const LOGLEVEL_EMERG: u32 = 0;
pub const LOGLEVEL_ALERT: u32 = 1;
pub const LOGLEVEL_CRIT: u32 = 2;
pub const LOGLEVEL_ERR: u32 = 3;
pub const LOGLEVEL_WARNING: u32 = 4;
pub const LOGLEVEL_NOTICE: u32 = 5;
pub const LOGLEVEL_INFO: u32 = 6;
pub const LOGLEVEL_DEBUG: u32 = 7;
pub const HAS_KERNEL_IBT: u32 = 0;
pub const ENDBR_INSN_SIZE: u32 = 0;
pub const ASM_RET: &[u8; 25usize] = b"jmp __x86_return_thunk\n\t\0";
pub const BITS_PER_BYTE: u32 = 8;
pub const HZ: u32 = 100;
pub const EXEC_PAGESIZE: u32 = 4096;
pub const NOGROUP: i32 = -1;
pub const MAXHOSTNAMELEN: u32 = 64;
pub const USER_HZ: u32 = 100;
pub const CLOCKS_PER_SEC: u32 = 100;
pub const _Q_LOCKED_OFFSET: u32 = 0;
pub const _Q_LOCKED_BITS: u32 = 8;
pub const _Q_PENDING_OFFSET: u32 = 8;
pub const _Q_PENDING_BITS: u32 = 8;
pub const _Q_TAIL_IDX_OFFSET: u32 = 16;
pub const _Q_TAIL_IDX_BITS: u32 = 2;
pub const _Q_TAIL_CPU_OFFSET: u32 = 18;
pub const _Q_TAIL_CPU_BITS: u32 = 14;
pub const _Q_TAIL_OFFSET: u32 = 16;
pub const _Q_LOCKED_VAL: u32 = 1;
pub const _Q_PENDING_VAL: u32 = 256;
pub const MAX_LOCKDEP_SUBCLASSES: u32 = 8;
pub const SPINLOCK_MAGIC: u32 = 3735899821;
pub const DEFAULT_RATELIMIT_INTERVAL: u32 = 5000;
pub const DEFAULT_RATELIMIT_BURST: u32 = 10;
pub const PRINTK_MAX_SINGLE_HEADER_LEN: u32 = 2;
pub const MESSAGE_LOGLEVEL_DEFAULT: u32 = 4;
pub const CONSOLE_LOGLEVEL_SILENT: u32 = 0;
pub const CONSOLE_LOGLEVEL_MIN: u32 = 1;
pub const CONSOLE_LOGLEVEL_DEBUG: u32 = 10;
pub const CONSOLE_LOGLEVEL_MOTORMOUTH: u32 = 15;
pub const CONSOLE_LOGLEVEL_DEFAULT: u32 = 7;
pub const CONSOLE_LOGLEVEL_QUIET: u32 = 3;
pub const DEVKMSG_STR_MAX_SIZE: u32 = 10;
pub const FW_BUG: &[u8; 17usize] = b"[Firmware Bug]: \0";
pub const FW_WARN: &[u8; 18usize] = b"[Firmware Warn]: \0";
pub const FW_INFO: &[u8; 18usize] = b"[Firmware Info]: \0";
pub const HW_ERR: &[u8; 19usize] = b"[Hardware Error]: \0";
pub const DEPRECATED: &[u8; 15usize] = b"[Deprecated]: \0";
pub const EX_DATA_REG_SHIFT: u32 = 8;
pub const EX_DATA_FLAG_SHIFT: u32 = 12;
pub const EX_DATA_IMM_SHIFT: u32 = 16;
pub const EX_TYPE_NONE: u32 = 0;
pub const EX_TYPE_DEFAULT: u32 = 1;
pub const EX_TYPE_FAULT: u32 = 2;
pub const EX_TYPE_UACCESS: u32 = 3;
pub const EX_TYPE_COPY: u32 = 4;
pub const EX_TYPE_CLEAR_FS: u32 = 5;
pub const EX_TYPE_FPU_RESTORE: u32 = 6;
pub const EX_TYPE_BPF: u32 = 7;
pub const EX_TYPE_WRMSR: u32 = 8;
pub const EX_TYPE_RDMSR: u32 = 9;
pub const EX_TYPE_WRMSR_SAFE: u32 = 10;
pub const EX_TYPE_RDMSR_SAFE: u32 = 11;
pub const EX_TYPE_WRMSR_IN_MCE: u32 = 12;
pub const EX_TYPE_RDMSR_IN_MCE: u32 = 13;
pub const EX_TYPE_DEFAULT_MCE_SAFE: u32 = 14;
pub const EX_TYPE_FAULT_MCE_SAFE: u32 = 15;
pub const EX_TYPE_POP_REG: u32 = 16;
pub const EX_TYPE_IMM_REG: u32 = 17;
pub const EX_TYPE_FAULT_SGX: u32 = 18;
pub const EX_TYPE_UCOPY_LEN: u32 = 19;
pub const EX_TYPE_ZEROPAD: u32 = 20;
pub const DEFINE_EXTABLE_TYPE_REG : & [u8 ; 533usize] = b".macro extable_type_reg type:req reg:req\n.set .Lfound, 0\n.set .Lregnr, 0\n.irp rs,rax,rcx,rdx,rbx,rsp,rbp,rsi,rdi,r8,r9,r10,r11,r12,r13,r14,r15\n.ifc \\reg, %%\\rs\n.set .Lfound, .Lfound+1\n.long \\type + (.Lregnr << 8)\n.endif\n.set .Lregnr, .Lregnr+1\n.endr\n.set .Lregnr, 0\n.irp rs,eax,ecx,edx,ebx,esp,ebp,esi,edi,r8d,r9d,r10d,r11d,r12d,r13d,r14d,r15d\n.ifc \\reg, %%\\rs\n.set .Lfound, .Lfound+1\n.long \\type + (.Lregnr << 8)\n.endif\n.set .Lregnr, .Lregnr+1\n.endr\n.if (.Lfound != 1)\n.error \"extable_type_reg: bad register argument\"\n.endif\n.endm\n\0" ;
pub const UNDEFINE_EXTABLE_TYPE_REG: &[u8; 26usize] = b".purgem extable_type_reg\n\0";
pub const BYTES_NOP1: u32 = 144;
pub const ASM_NOP_MAX: u32 = 11;
pub const JUMP_TYPE_FALSE: u32 = 0;
pub const JUMP_TYPE_TRUE: u32 = 1;
pub const JUMP_TYPE_LINKED: u32 = 2;
pub const JUMP_TYPE_MASK: u32 = 3;
pub const CLS_BITS: u32 = 6;
pub const _DPRINTK_CLASS_DFLT: u32 = 63;
pub const _DPRINTK_FLAGS_NONE: u32 = 0;
pub const _DPRINTK_FLAGS_PRINT: u32 = 1;
pub const _DPRINTK_FLAGS_INCL_MODNAME: u32 = 2;
pub const _DPRINTK_FLAGS_INCL_FUNCNAME: u32 = 4;
pub const _DPRINTK_FLAGS_INCL_LINENO: u32 = 8;
pub const _DPRINTK_FLAGS_INCL_TID: u32 = 16;
pub const _DPRINTK_FLAGS_INCL_SOURCENAME: u32 = 32;
pub const _DPRINTK_FLAGS_INCL_ANY: u32 = 62;
pub const _DPRINTK_FLAGS_DEFAULT: u32 = 0;
pub const PREEMPT_BITS: u32 = 8;
pub const SOFTIRQ_BITS: u32 = 8;
pub const HARDIRQ_BITS: u32 = 4;
pub const NMI_BITS: u32 = 4;
pub const PREEMPT_SHIFT: u32 = 0;
pub const SOFTIRQ_SHIFT: u32 = 8;
pub const HARDIRQ_SHIFT: u32 = 16;
pub const NMI_SHIFT: u32 = 20;
pub const PREEMPT_OFFSET: u32 = 1;
pub const SOFTIRQ_OFFSET: u32 = 256;
pub const HARDIRQ_OFFSET: u32 = 65536;
pub const NMI_OFFSET: u32 = 1048576;
pub const SOFTIRQ_DISABLE_OFFSET: u32 = 512;
pub const INIT_PREEMPT_COUNT: u32 = 1;
pub const NR_CPUS: u32 = 8192;
pub const MIN_THREADS_LEFT_FOR_ROOT: u32 = 4;
pub const PIDS_PER_CPU_DEFAULT: u32 = 1024;
pub const PIDS_PER_CPU_MIN: u32 = 8;
pub const PER_CPU_SHARED_ALIGNED_SECTION: &[u8; 1usize] = b"\0";
pub const PER_CPU_ALIGNED_SECTION: &[u8; 1usize] = b"\0";
pub const PER_CPU_FIRST_SECTION: &[u8; 8usize] = b"..first\0";
pub const PER_CPU_BASE_SECTION: &[u8; 14usize] = b".data..percpu\0";
pub const SI_LOAD_SHIFT: u32 = 16;
pub const L1_CACHE_SHIFT: u32 = 6;
pub const L1_CACHE_BYTES: u32 = 64;
pub const INTERNODE_CACHE_SHIFT: u32 = 6;
pub const INTERNODE_CACHE_BYTES: u32 = 64;
pub const SMP_CACHE_BYTES: u32 = 64;
pub const STATIC_CALL_SITE_TAIL: u32 = 1;
pub const STATIC_CALL_SITE_INIT: u32 = 2;
pub const STATIC_CALL_SITE_FLAGS: u32 = 3;
pub const PREEMPT_NEED_RESCHED: u32 = 2147483648;
pub const PREEMPT_ENABLED: u32 = 2147483648;
pub const PREEMPT_DISABLE_OFFSET: u32 = 1;
pub const PREEMPT_LOCK_OFFSET: u32 = 1;
pub const SOFTIRQ_LOCK_OFFSET: u32 = 513;
pub const X86_EFLAGS_CF_BIT: u32 = 0;
pub const X86_EFLAGS_FIXED_BIT: u32 = 1;
pub const X86_EFLAGS_PF_BIT: u32 = 2;
pub const X86_EFLAGS_AF_BIT: u32 = 4;
pub const X86_EFLAGS_ZF_BIT: u32 = 6;
pub const X86_EFLAGS_SF_BIT: u32 = 7;
pub const X86_EFLAGS_TF_BIT: u32 = 8;
pub const X86_EFLAGS_IF_BIT: u32 = 9;
pub const X86_EFLAGS_DF_BIT: u32 = 10;
pub const X86_EFLAGS_OF_BIT: u32 = 11;
pub const X86_EFLAGS_IOPL_BIT: u32 = 12;
pub const X86_EFLAGS_NT_BIT: u32 = 14;
pub const X86_EFLAGS_RF_BIT: u32 = 16;
pub const X86_EFLAGS_VM_BIT: u32 = 17;
pub const X86_EFLAGS_AC_BIT: u32 = 18;
pub const X86_EFLAGS_VIF_BIT: u32 = 19;
pub const X86_EFLAGS_VIP_BIT: u32 = 20;
pub const X86_EFLAGS_ID_BIT: u32 = 21;
pub const X86_CR0_PE_BIT: u32 = 0;
pub const X86_CR0_MP_BIT: u32 = 1;
pub const X86_CR0_EM_BIT: u32 = 2;
pub const X86_CR0_TS_BIT: u32 = 3;
pub const X86_CR0_ET_BIT: u32 = 4;
pub const X86_CR0_NE_BIT: u32 = 5;
pub const X86_CR0_WP_BIT: u32 = 16;
pub const X86_CR0_AM_BIT: u32 = 18;
pub const X86_CR0_NW_BIT: u32 = 29;
pub const X86_CR0_CD_BIT: u32 = 30;
pub const X86_CR0_PG_BIT: u32 = 31;
pub const X86_CR3_PWT_BIT: u32 = 3;
pub const X86_CR3_PCD_BIT: u32 = 4;
pub const X86_CR3_PCID_BITS: u32 = 12;
pub const X86_CR3_LAM_U57_BIT: u32 = 61;
pub const X86_CR3_LAM_U48_BIT: u32 = 62;
pub const X86_CR3_PCID_NOFLUSH_BIT: u32 = 63;
pub const X86_CR4_VME_BIT: u32 = 0;
pub const X86_CR4_PVI_BIT: u32 = 1;
pub const X86_CR4_TSD_BIT: u32 = 2;
pub const X86_CR4_DE_BIT: u32 = 3;
pub const X86_CR4_PSE_BIT: u32 = 4;
pub const X86_CR4_PAE_BIT: u32 = 5;
pub const X86_CR4_MCE_BIT: u32 = 6;
pub const X86_CR4_PGE_BIT: u32 = 7;
pub const X86_CR4_PCE_BIT: u32 = 8;
pub const X86_CR4_OSFXSR_BIT: u32 = 9;
pub const X86_CR4_OSXMMEXCPT_BIT: u32 = 10;
pub const X86_CR4_UMIP_BIT: u32 = 11;
pub const X86_CR4_LA57_BIT: u32 = 12;
pub const X86_CR4_VMXE_BIT: u32 = 13;
pub const X86_CR4_SMXE_BIT: u32 = 14;
pub const X86_CR4_FSGSBASE_BIT: u32 = 16;
pub const X86_CR4_PCIDE_BIT: u32 = 17;
pub const X86_CR4_OSXSAVE_BIT: u32 = 18;
pub const X86_CR4_SMEP_BIT: u32 = 20;
pub const X86_CR4_SMAP_BIT: u32 = 21;
pub const X86_CR4_PKE_BIT: u32 = 22;
pub const X86_CR4_CET_BIT: u32 = 23;
pub const X86_CR4_LAM_SUP_BIT: u32 = 28;
pub const CX86_PCR0: u32 = 32;
pub const CX86_GCR: u32 = 184;
pub const CX86_CCR0: u32 = 192;
pub const CX86_CCR1: u32 = 193;
pub const CX86_CCR2: u32 = 194;
pub const CX86_CCR3: u32 = 195;
pub const CX86_CCR4: u32 = 232;
pub const CX86_CCR5: u32 = 233;
pub const CX86_CCR6: u32 = 234;
pub const CX86_CCR7: u32 = 235;
pub const CX86_PCR1: u32 = 240;
pub const CX86_DIR0: u32 = 254;
pub const CX86_DIR1: u32 = 255;
pub const CX86_ARR_BASE: u32 = 196;
pub const CX86_RCR_BASE: u32 = 220;
pub const X86_VM_MASK: u32 = 0;
pub const CR3_PCID_MASK: u32 = 4095;
pub const X86_CR3_PTI_PCID_USER_BIT: u32 = 11;
pub const UNWIND_HINT_TYPE_UNDEFINED: u32 = 0;
pub const UNWIND_HINT_TYPE_END_OF_STACK: u32 = 1;
pub const UNWIND_HINT_TYPE_CALL: u32 = 2;
pub const UNWIND_HINT_TYPE_REGS: u32 = 3;
pub const UNWIND_HINT_TYPE_REGS_PARTIAL: u32 = 4;
pub const UNWIND_HINT_TYPE_FUNC: u32 = 5;
pub const UNWIND_HINT_TYPE_SAVE: u32 = 6;
pub const UNWIND_HINT_TYPE_RESTORE: u32 = 7;
pub const ANNOTATE_NOENDBR: &[u8; 64usize] =
    b"986: \n\t.pushsection .discard.noendbr\n\t.long 986b\n\t.popsection\n\t\0";
pub const ASM_REACHABLE: &[u8; 65usize] =
    b"998:\n\t.pushsection .discard.reachable\n\t.long 998b\n\t.popsection\n\t\0";
pub const ALT_FLAGS_SHIFT: u32 = 16;
pub const ALT_FLAG_NOT: u32 = 1;
pub const ALT_FLAG_DIRECT_CALL: u32 = 2;
pub const LOCK_PREFIX_HERE: &[u8; 70usize] =
    b".pushsection .smp_locks,\"a\"\n.balign 4\n.long 671f - .\n.popsection\n671:\0";
pub const LOCK_PREFIX: &[u8; 78usize] =
    b".pushsection .smp_locks,\"a\"\n.balign 4\n.long 671f - .\n.popsection\n671:\n\tlock; \0";
pub const ANNOTATE_IGNORE_ALTERNATIVE: &[u8; 67usize] =
    b"999:\n\t.pushsection .discard.ignore_alts\n\t.long 999b\n\t.popsection\n\t\0";
pub const ALT_CALL_INSTR: &[u8; 14usize] = b"call BUG_func\0";
pub const alt_end_marker: &[u8; 4usize] = b"663\0";
pub const alt_slen: &[u8; 10usize] = b"662b-661b\0";
pub const alt_total_slen: &[u8; 10usize] = b"663b-661b\0";
pub const NEED_3DNOW: u32 = 0;
pub const NEED_MOVBE: u32 = 0;
pub const NEED_PSE: u32 = 0;
pub const NEED_PGE: u32 = 0;
pub const REQUIRED_MASK2: u32 = 0;
pub const REQUIRED_MASK4: u32 = 0;
pub const REQUIRED_MASK5: u32 = 0;
pub const REQUIRED_MASK6: u32 = 0;
pub const REQUIRED_MASK7: u32 = 0;
pub const REQUIRED_MASK8: u32 = 0;
pub const REQUIRED_MASK9: u32 = 0;
pub const REQUIRED_MASK10: u32 = 0;
pub const REQUIRED_MASK11: u32 = 0;
pub const REQUIRED_MASK12: u32 = 0;
pub const REQUIRED_MASK13: u32 = 0;
pub const REQUIRED_MASK14: u32 = 0;
pub const REQUIRED_MASK15: u32 = 0;
pub const REQUIRED_MASK16: u32 = 0;
pub const REQUIRED_MASK17: u32 = 0;
pub const REQUIRED_MASK18: u32 = 0;
pub const REQUIRED_MASK19: u32 = 0;
pub const REQUIRED_MASK20: u32 = 0;
pub const REQUIRED_MASK21: u32 = 0;
pub const DISABLE_UMIP: u32 = 0;
pub const DISABLE_PCID: u32 = 0;
pub const DISABLE_PKU: u32 = 0;
pub const DISABLE_OSPKE: u32 = 0;
pub const DISABLE_LA57: u32 = 0;
pub const DISABLE_PTI: u32 = 0;
pub const DISABLE_RETPOLINE: u32 = 0;
pub const DISABLE_RETHUNK: u32 = 0;
pub const DISABLE_UNRET: u32 = 0;
pub const DISABLE_CALL_DEPTH_TRACKING: u32 = 0;
pub const DISABLE_LAM: u32 = 0;
pub const DISABLE_ENQCMD: u32 = 0;
pub const DISABLE_SGX: u32 = 0;
pub const DISABLE_XENPV: u32 = 0;
pub const DISABLE_TDX_GUEST: u32 = 0;
pub const DISABLE_USER_SHSTK: u32 = 0;
pub const DISABLED_MASK1: u32 = 0;
pub const DISABLED_MASK2: u32 = 0;
pub const DISABLED_MASK4: u32 = 0;
pub const DISABLED_MASK5: u32 = 0;
pub const DISABLED_MASK6: u32 = 0;
pub const DISABLED_MASK7: u32 = 0;
pub const DISABLED_MASK8: u32 = 0;
pub const DISABLED_MASK9: u32 = 0;
pub const DISABLED_MASK10: u32 = 0;
pub const DISABLED_MASK11: u32 = 0;
pub const DISABLED_MASK12: u32 = 0;
pub const DISABLED_MASK13: u32 = 0;
pub const DISABLED_MASK14: u32 = 0;
pub const DISABLED_MASK15: u32 = 0;
pub const DISABLED_MASK16: u32 = 0;
pub const DISABLED_MASK17: u32 = 0;
pub const DISABLED_MASK19: u32 = 0;
pub const DISABLED_MASK20: u32 = 0;
pub const DISABLED_MASK21: u32 = 0;
pub const NCAPINTS: u32 = 22;
pub const NBUGINTS: u32 = 2;
pub const X86_FEATURE_FPU: u32 = 0;
pub const X86_FEATURE_VME: u32 = 1;
pub const X86_FEATURE_DE: u32 = 2;
pub const X86_FEATURE_PSE: u32 = 3;
pub const X86_FEATURE_TSC: u32 = 4;
pub const X86_FEATURE_MSR: u32 = 5;
pub const X86_FEATURE_PAE: u32 = 6;
pub const X86_FEATURE_MCE: u32 = 7;
pub const X86_FEATURE_CX8: u32 = 8;
pub const X86_FEATURE_APIC: u32 = 9;
pub const X86_FEATURE_SEP: u32 = 11;
pub const X86_FEATURE_MTRR: u32 = 12;
pub const X86_FEATURE_PGE: u32 = 13;
pub const X86_FEATURE_MCA: u32 = 14;
pub const X86_FEATURE_CMOV: u32 = 15;
pub const X86_FEATURE_PAT: u32 = 16;
pub const X86_FEATURE_PSE36: u32 = 17;
pub const X86_FEATURE_PN: u32 = 18;
pub const X86_FEATURE_CLFLUSH: u32 = 19;
pub const X86_FEATURE_DS: u32 = 21;
pub const X86_FEATURE_ACPI: u32 = 22;
pub const X86_FEATURE_MMX: u32 = 23;
pub const X86_FEATURE_FXSR: u32 = 24;
pub const X86_FEATURE_XMM: u32 = 25;
pub const X86_FEATURE_XMM2: u32 = 26;
pub const X86_FEATURE_SELFSNOOP: u32 = 27;
pub const X86_FEATURE_HT: u32 = 28;
pub const X86_FEATURE_ACC: u32 = 29;
pub const X86_FEATURE_IA64: u32 = 30;
pub const X86_FEATURE_PBE: u32 = 31;
pub const X86_FEATURE_SYSCALL: u32 = 43;
pub const X86_FEATURE_MP: u32 = 51;
pub const X86_FEATURE_NX: u32 = 52;
pub const X86_FEATURE_MMXEXT: u32 = 54;
pub const X86_FEATURE_FXSR_OPT: u32 = 57;
pub const X86_FEATURE_GBPAGES: u32 = 58;
pub const X86_FEATURE_RDTSCP: u32 = 59;
pub const X86_FEATURE_LM: u32 = 61;
pub const X86_FEATURE_3DNOWEXT: u32 = 62;
pub const X86_FEATURE_3DNOW: u32 = 63;
pub const X86_FEATURE_RECOVERY: u32 = 64;
pub const X86_FEATURE_LONGRUN: u32 = 65;
pub const X86_FEATURE_LRTI: u32 = 67;
pub const X86_FEATURE_CXMMX: u32 = 96;
pub const X86_FEATURE_K6_MTRR: u32 = 97;
pub const X86_FEATURE_CYRIX_ARR: u32 = 98;
pub const X86_FEATURE_CENTAUR_MCR: u32 = 99;
pub const X86_FEATURE_K8: u32 = 100;
pub const X86_FEATURE_ZEN5: u32 = 101;
pub const X86_FEATURE_P3: u32 = 102;
pub const X86_FEATURE_P4: u32 = 103;
pub const X86_FEATURE_CONSTANT_TSC: u32 = 104;
pub const X86_FEATURE_UP: u32 = 105;
pub const X86_FEATURE_ART: u32 = 106;
pub const X86_FEATURE_ARCH_PERFMON: u32 = 107;
pub const X86_FEATURE_PEBS: u32 = 108;
pub const X86_FEATURE_BTS: u32 = 109;
pub const X86_FEATURE_SYSCALL32: u32 = 110;
pub const X86_FEATURE_SYSENTER32: u32 = 111;
pub const X86_FEATURE_REP_GOOD: u32 = 112;
pub const X86_FEATURE_AMD_LBR_V2: u32 = 113;
pub const X86_FEATURE_CLEAR_CPU_BUF: u32 = 114;
pub const X86_FEATURE_ACC_POWER: u32 = 115;
pub const X86_FEATURE_NOPL: u32 = 116;
pub const X86_FEATURE_ALWAYS: u32 = 117;
pub const X86_FEATURE_XTOPOLOGY: u32 = 118;
pub const X86_FEATURE_TSC_RELIABLE: u32 = 119;
pub const X86_FEATURE_NONSTOP_TSC: u32 = 120;
pub const X86_FEATURE_CPUID: u32 = 121;
pub const X86_FEATURE_EXTD_APICID: u32 = 122;
pub const X86_FEATURE_AMD_DCM: u32 = 123;
pub const X86_FEATURE_APERFMPERF: u32 = 124;
pub const X86_FEATURE_RAPL: u32 = 125;
pub const X86_FEATURE_NONSTOP_TSC_S3: u32 = 126;
pub const X86_FEATURE_TSC_KNOWN_FREQ: u32 = 127;
pub const X86_FEATURE_XMM3: u32 = 128;
pub const X86_FEATURE_PCLMULQDQ: u32 = 129;
pub const X86_FEATURE_DTES64: u32 = 130;
pub const X86_FEATURE_MWAIT: u32 = 131;
pub const X86_FEATURE_DSCPL: u32 = 132;
pub const X86_FEATURE_VMX: u32 = 133;
pub const X86_FEATURE_SMX: u32 = 134;
pub const X86_FEATURE_EST: u32 = 135;
pub const X86_FEATURE_TM2: u32 = 136;
pub const X86_FEATURE_SSSE3: u32 = 137;
pub const X86_FEATURE_CID: u32 = 138;
pub const X86_FEATURE_SDBG: u32 = 139;
pub const X86_FEATURE_FMA: u32 = 140;
pub const X86_FEATURE_CX16: u32 = 141;
pub const X86_FEATURE_XTPR: u32 = 142;
pub const X86_FEATURE_PDCM: u32 = 143;
pub const X86_FEATURE_PCID: u32 = 145;
pub const X86_FEATURE_DCA: u32 = 146;
pub const X86_FEATURE_XMM4_1: u32 = 147;
pub const X86_FEATURE_XMM4_2: u32 = 148;
pub const X86_FEATURE_X2APIC: u32 = 149;
pub const X86_FEATURE_MOVBE: u32 = 150;
pub const X86_FEATURE_POPCNT: u32 = 151;
pub const X86_FEATURE_TSC_DEADLINE_TIMER: u32 = 152;
pub const X86_FEATURE_AES: u32 = 153;
pub const X86_FEATURE_XSAVE: u32 = 154;
pub const X86_FEATURE_OSXSAVE: u32 = 155;
pub const X86_FEATURE_AVX: u32 = 156;
pub const X86_FEATURE_F16C: u32 = 157;
pub const X86_FEATURE_RDRAND: u32 = 158;
pub const X86_FEATURE_HYPERVISOR: u32 = 159;
pub const X86_FEATURE_XSTORE: u32 = 162;
pub const X86_FEATURE_XSTORE_EN: u32 = 163;
pub const X86_FEATURE_XCRYPT: u32 = 166;
pub const X86_FEATURE_XCRYPT_EN: u32 = 167;
pub const X86_FEATURE_ACE2: u32 = 168;
pub const X86_FEATURE_ACE2_EN: u32 = 169;
pub const X86_FEATURE_PHE: u32 = 170;
pub const X86_FEATURE_PHE_EN: u32 = 171;
pub const X86_FEATURE_PMM: u32 = 172;
pub const X86_FEATURE_PMM_EN: u32 = 173;
pub const X86_FEATURE_LAHF_LM: u32 = 192;
pub const X86_FEATURE_CMP_LEGACY: u32 = 193;
pub const X86_FEATURE_SVM: u32 = 194;
pub const X86_FEATURE_EXTAPIC: u32 = 195;
pub const X86_FEATURE_CR8_LEGACY: u32 = 196;
pub const X86_FEATURE_ABM: u32 = 197;
pub const X86_FEATURE_SSE4A: u32 = 198;
pub const X86_FEATURE_MISALIGNSSE: u32 = 199;
pub const X86_FEATURE_3DNOWPREFETCH: u32 = 200;
pub const X86_FEATURE_OSVW: u32 = 201;
pub const X86_FEATURE_IBS: u32 = 202;
pub const X86_FEATURE_XOP: u32 = 203;
pub const X86_FEATURE_SKINIT: u32 = 204;
pub const X86_FEATURE_WDT: u32 = 205;
pub const X86_FEATURE_LWP: u32 = 207;
pub const X86_FEATURE_FMA4: u32 = 208;
pub const X86_FEATURE_TCE: u32 = 209;
pub const X86_FEATURE_NODEID_MSR: u32 = 211;
pub const X86_FEATURE_TBM: u32 = 213;
pub const X86_FEATURE_TOPOEXT: u32 = 214;
pub const X86_FEATURE_PERFCTR_CORE: u32 = 215;
pub const X86_FEATURE_PERFCTR_NB: u32 = 216;
pub const X86_FEATURE_BPEXT: u32 = 218;
pub const X86_FEATURE_PTSC: u32 = 219;
pub const X86_FEATURE_PERFCTR_LLC: u32 = 220;
pub const X86_FEATURE_MWAITX: u32 = 221;
pub const X86_FEATURE_RING3MWAIT: u32 = 224;
pub const X86_FEATURE_CPUID_FAULT: u32 = 225;
pub const X86_FEATURE_CPB: u32 = 226;
pub const X86_FEATURE_EPB: u32 = 227;
pub const X86_FEATURE_CAT_L3: u32 = 228;
pub const X86_FEATURE_CAT_L2: u32 = 229;
pub const X86_FEATURE_CDP_L3: u32 = 230;
pub const X86_FEATURE_TDX_HOST_PLATFORM: u32 = 231;
pub const X86_FEATURE_HW_PSTATE: u32 = 232;
pub const X86_FEATURE_PROC_FEEDBACK: u32 = 233;
pub const X86_FEATURE_XCOMPACTED: u32 = 234;
pub const X86_FEATURE_PTI: u32 = 235;
pub const X86_FEATURE_KERNEL_IBRS: u32 = 236;
pub const X86_FEATURE_RSB_VMEXIT: u32 = 237;
pub const X86_FEATURE_INTEL_PPIN: u32 = 238;
pub const X86_FEATURE_CDP_L2: u32 = 239;
pub const X86_FEATURE_MSR_SPEC_CTRL: u32 = 240;
pub const X86_FEATURE_SSBD: u32 = 241;
pub const X86_FEATURE_MBA: u32 = 242;
pub const X86_FEATURE_RSB_CTXSW: u32 = 243;
pub const X86_FEATURE_PERFMON_V2: u32 = 244;
pub const X86_FEATURE_USE_IBPB: u32 = 245;
pub const X86_FEATURE_USE_IBRS_FW: u32 = 246;
pub const X86_FEATURE_SPEC_STORE_BYPASS_DISABLE: u32 = 247;
pub const X86_FEATURE_LS_CFG_SSBD: u32 = 248;
pub const X86_FEATURE_IBRS: u32 = 249;
pub const X86_FEATURE_IBPB: u32 = 250;
pub const X86_FEATURE_STIBP: u32 = 251;
pub const X86_FEATURE_ZEN: u32 = 252;
pub const X86_FEATURE_L1TF_PTEINV: u32 = 253;
pub const X86_FEATURE_IBRS_ENHANCED: u32 = 254;
pub const X86_FEATURE_MSR_IA32_FEAT_CTL: u32 = 255;
pub const X86_FEATURE_TPR_SHADOW: u32 = 256;
pub const X86_FEATURE_FLEXPRIORITY: u32 = 257;
pub const X86_FEATURE_EPT: u32 = 258;
pub const X86_FEATURE_VPID: u32 = 259;
pub const X86_FEATURE_VMMCALL: u32 = 271;
pub const X86_FEATURE_XENPV: u32 = 272;
pub const X86_FEATURE_EPT_AD: u32 = 273;
pub const X86_FEATURE_VMCALL: u32 = 274;
pub const X86_FEATURE_VMW_VMMCALL: u32 = 275;
pub const X86_FEATURE_PVUNLOCK: u32 = 276;
pub const X86_FEATURE_VCPUPREEMPT: u32 = 277;
pub const X86_FEATURE_TDX_GUEST: u32 = 278;
pub const X86_FEATURE_FSGSBASE: u32 = 288;
pub const X86_FEATURE_TSC_ADJUST: u32 = 289;
pub const X86_FEATURE_SGX: u32 = 290;
pub const X86_FEATURE_BMI1: u32 = 291;
pub const X86_FEATURE_HLE: u32 = 292;
pub const X86_FEATURE_AVX2: u32 = 293;
pub const X86_FEATURE_FDP_EXCPTN_ONLY: u32 = 294;
pub const X86_FEATURE_SMEP: u32 = 295;
pub const X86_FEATURE_BMI2: u32 = 296;
pub const X86_FEATURE_ERMS: u32 = 297;
pub const X86_FEATURE_INVPCID: u32 = 298;
pub const X86_FEATURE_RTM: u32 = 299;
pub const X86_FEATURE_CQM: u32 = 300;
pub const X86_FEATURE_ZERO_FCS_FDS: u32 = 301;
pub const X86_FEATURE_MPX: u32 = 302;
pub const X86_FEATURE_RDT_A: u32 = 303;
pub const X86_FEATURE_AVX512F: u32 = 304;
pub const X86_FEATURE_AVX512DQ: u32 = 305;
pub const X86_FEATURE_RDSEED: u32 = 306;
pub const X86_FEATURE_ADX: u32 = 307;
pub const X86_FEATURE_SMAP: u32 = 308;
pub const X86_FEATURE_AVX512IFMA: u32 = 309;
pub const X86_FEATURE_CLFLUSHOPT: u32 = 311;
pub const X86_FEATURE_CLWB: u32 = 312;
pub const X86_FEATURE_INTEL_PT: u32 = 313;
pub const X86_FEATURE_AVX512PF: u32 = 314;
pub const X86_FEATURE_AVX512ER: u32 = 315;
pub const X86_FEATURE_AVX512CD: u32 = 316;
pub const X86_FEATURE_SHA_NI: u32 = 317;
pub const X86_FEATURE_AVX512BW: u32 = 318;
pub const X86_FEATURE_AVX512VL: u32 = 319;
pub const X86_FEATURE_XSAVEOPT: u32 = 320;
pub const X86_FEATURE_XSAVEC: u32 = 321;
pub const X86_FEATURE_XGETBV1: u32 = 322;
pub const X86_FEATURE_XSAVES: u32 = 323;
pub const X86_FEATURE_XFD: u32 = 324;
pub const X86_FEATURE_CQM_LLC: u32 = 352;
pub const X86_FEATURE_CQM_OCCUP_LLC: u32 = 353;
pub const X86_FEATURE_CQM_MBM_TOTAL: u32 = 354;
pub const X86_FEATURE_CQM_MBM_LOCAL: u32 = 355;
pub const X86_FEATURE_FENCE_SWAPGS_USER: u32 = 356;
pub const X86_FEATURE_FENCE_SWAPGS_KERNEL: u32 = 357;
pub const X86_FEATURE_SPLIT_LOCK_DETECT: u32 = 358;
pub const X86_FEATURE_PER_THREAD_MBA: u32 = 359;
pub const X86_FEATURE_SGX1: u32 = 360;
pub const X86_FEATURE_SGX2: u32 = 361;
pub const X86_FEATURE_ENTRY_IBPB: u32 = 362;
pub const X86_FEATURE_RRSBA_CTRL: u32 = 363;
pub const X86_FEATURE_RETPOLINE: u32 = 364;
pub const X86_FEATURE_RETPOLINE_LFENCE: u32 = 365;
pub const X86_FEATURE_RETHUNK: u32 = 366;
pub const X86_FEATURE_UNRET: u32 = 367;
pub const X86_FEATURE_USE_IBPB_FW: u32 = 368;
pub const X86_FEATURE_RSB_VMEXIT_LITE: u32 = 369;
pub const X86_FEATURE_SGX_EDECCSSA: u32 = 370;
pub const X86_FEATURE_CALL_DEPTH: u32 = 371;
pub const X86_FEATURE_MSR_TSX_CTRL: u32 = 372;
pub const X86_FEATURE_SMBA: u32 = 373;
pub const X86_FEATURE_BMEC: u32 = 374;
pub const X86_FEATURE_USER_SHSTK: u32 = 375;
pub const X86_FEATURE_SRSO: u32 = 376;
pub const X86_FEATURE_SRSO_ALIAS: u32 = 377;
pub const X86_FEATURE_IBPB_ON_VMEXIT: u32 = 378;
pub const X86_FEATURE_APIC_MSRS_FENCE: u32 = 379;
pub const X86_FEATURE_ZEN2: u32 = 380;
pub const X86_FEATURE_ZEN3: u32 = 381;
pub const X86_FEATURE_ZEN4: u32 = 382;
pub const X86_FEATURE_ZEN1: u32 = 383;
pub const X86_FEATURE_AVX_VNNI: u32 = 388;
pub const X86_FEATURE_AVX512_BF16: u32 = 389;
pub const X86_FEATURE_CMPCCXADD: u32 = 391;
pub const X86_FEATURE_ARCH_PERFMON_EXT: u32 = 392;
pub const X86_FEATURE_FZRM: u32 = 394;
pub const X86_FEATURE_FSRS: u32 = 395;
pub const X86_FEATURE_FSRC: u32 = 396;
pub const X86_FEATURE_LKGS: u32 = 402;
pub const X86_FEATURE_AMX_FP16: u32 = 405;
pub const X86_FEATURE_AVX_IFMA: u32 = 407;
pub const X86_FEATURE_LAM: u32 = 410;
pub const X86_FEATURE_CLZERO: u32 = 416;
pub const X86_FEATURE_IRPERF: u32 = 417;
pub const X86_FEATURE_XSAVEERPTR: u32 = 418;
pub const X86_FEATURE_RDPRU: u32 = 420;
pub const X86_FEATURE_WBNOINVD: u32 = 425;
pub const X86_FEATURE_AMD_IBPB: u32 = 428;
pub const X86_FEATURE_AMD_IBRS: u32 = 430;
pub const X86_FEATURE_AMD_STIBP: u32 = 431;
pub const X86_FEATURE_AMD_STIBP_ALWAYS_ON: u32 = 433;
pub const X86_FEATURE_AMD_PPIN: u32 = 439;
pub const X86_FEATURE_AMD_SSBD: u32 = 440;
pub const X86_FEATURE_VIRT_SSBD: u32 = 441;
pub const X86_FEATURE_AMD_SSB_NO: u32 = 442;
pub const X86_FEATURE_CPPC: u32 = 443;
pub const X86_FEATURE_AMD_PSFD: u32 = 444;
pub const X86_FEATURE_BTC_NO: u32 = 445;
pub const X86_FEATURE_BRS: u32 = 447;
pub const X86_FEATURE_DTHERM: u32 = 448;
pub const X86_FEATURE_IDA: u32 = 449;
pub const X86_FEATURE_ARAT: u32 = 450;
pub const X86_FEATURE_PLN: u32 = 452;
pub const X86_FEATURE_PTS: u32 = 454;
pub const X86_FEATURE_HWP: u32 = 455;
pub const X86_FEATURE_HWP_NOTIFY: u32 = 456;
pub const X86_FEATURE_HWP_ACT_WINDOW: u32 = 457;
pub const X86_FEATURE_HWP_EPP: u32 = 458;
pub const X86_FEATURE_HWP_PKG_REQ: u32 = 459;
pub const X86_FEATURE_HFI: u32 = 467;
pub const X86_FEATURE_NPT: u32 = 480;
pub const X86_FEATURE_LBRV: u32 = 481;
pub const X86_FEATURE_SVML: u32 = 482;
pub const X86_FEATURE_NRIPS: u32 = 483;
pub const X86_FEATURE_TSCRATEMSR: u32 = 484;
pub const X86_FEATURE_VMCBCLEAN: u32 = 485;
pub const X86_FEATURE_FLUSHBYASID: u32 = 486;
pub const X86_FEATURE_DECODEASSISTS: u32 = 487;
pub const X86_FEATURE_PAUSEFILTER: u32 = 490;
pub const X86_FEATURE_PFTHRESHOLD: u32 = 492;
pub const X86_FEATURE_AVIC: u32 = 493;
pub const X86_FEATURE_V_VMSAVE_VMLOAD: u32 = 495;
pub const X86_FEATURE_VGIF: u32 = 496;
pub const X86_FEATURE_X2AVIC: u32 = 498;
pub const X86_FEATURE_V_SPEC_CTRL: u32 = 500;
pub const X86_FEATURE_VNMI: u32 = 505;
pub const X86_FEATURE_SVME_ADDR_CHK: u32 = 508;
pub const X86_FEATURE_AVX512VBMI: u32 = 513;
pub const X86_FEATURE_UMIP: u32 = 514;
pub const X86_FEATURE_PKU: u32 = 515;
pub const X86_FEATURE_OSPKE: u32 = 516;
pub const X86_FEATURE_WAITPKG: u32 = 517;
pub const X86_FEATURE_AVX512_VBMI2: u32 = 518;
pub const X86_FEATURE_SHSTK: u32 = 519;
pub const X86_FEATURE_GFNI: u32 = 520;
pub const X86_FEATURE_VAES: u32 = 521;
pub const X86_FEATURE_VPCLMULQDQ: u32 = 522;
pub const X86_FEATURE_AVX512_VNNI: u32 = 523;
pub const X86_FEATURE_AVX512_BITALG: u32 = 524;
pub const X86_FEATURE_TME: u32 = 525;
pub const X86_FEATURE_AVX512_VPOPCNTDQ: u32 = 526;
pub const X86_FEATURE_LA57: u32 = 528;
pub const X86_FEATURE_RDPID: u32 = 534;
pub const X86_FEATURE_BUS_LOCK_DETECT: u32 = 536;
pub const X86_FEATURE_CLDEMOTE: u32 = 537;
pub const X86_FEATURE_MOVDIRI: u32 = 539;
pub const X86_FEATURE_MOVDIR64B: u32 = 540;
pub const X86_FEATURE_ENQCMD: u32 = 541;
pub const X86_FEATURE_SGX_LC: u32 = 542;
pub const X86_FEATURE_OVERFLOW_RECOV: u32 = 544;
pub const X86_FEATURE_SUCCOR: u32 = 545;
pub const X86_FEATURE_SMCA: u32 = 547;
pub const X86_FEATURE_AVX512_4VNNIW: u32 = 578;
pub const X86_FEATURE_AVX512_4FMAPS: u32 = 579;
pub const X86_FEATURE_FSRM: u32 = 580;
pub const X86_FEATURE_AVX512_VP2INTERSECT: u32 = 584;
pub const X86_FEATURE_SRBDS_CTRL: u32 = 585;
pub const X86_FEATURE_MD_CLEAR: u32 = 586;
pub const X86_FEATURE_RTM_ALWAYS_ABORT: u32 = 587;
pub const X86_FEATURE_TSX_FORCE_ABORT: u32 = 589;
pub const X86_FEATURE_SERIALIZE: u32 = 590;
pub const X86_FEATURE_HYBRID_CPU: u32 = 591;
pub const X86_FEATURE_TSXLDTRK: u32 = 592;
pub const X86_FEATURE_PCONFIG: u32 = 594;
pub const X86_FEATURE_ARCH_LBR: u32 = 595;
pub const X86_FEATURE_IBT: u32 = 596;
pub const X86_FEATURE_AMX_BF16: u32 = 598;
pub const X86_FEATURE_AVX512_FP16: u32 = 599;
pub const X86_FEATURE_AMX_TILE: u32 = 600;
pub const X86_FEATURE_AMX_INT8: u32 = 601;
pub const X86_FEATURE_SPEC_CTRL: u32 = 602;
pub const X86_FEATURE_INTEL_STIBP: u32 = 603;
pub const X86_FEATURE_FLUSH_L1D: u32 = 604;
pub const X86_FEATURE_ARCH_CAPABILITIES: u32 = 605;
pub const X86_FEATURE_CORE_CAPABILITIES: u32 = 606;
pub const X86_FEATURE_SPEC_CTRL_SSBD: u32 = 607;
pub const X86_FEATURE_SME: u32 = 608;
pub const X86_FEATURE_SEV: u32 = 609;
pub const X86_FEATURE_VM_PAGE_FLUSH: u32 = 610;
pub const X86_FEATURE_SEV_ES: u32 = 611;
pub const X86_FEATURE_V_TSC_AUX: u32 = 617;
pub const X86_FEATURE_SME_COHERENT: u32 = 618;
pub const X86_FEATURE_DEBUG_SWAP: u32 = 622;
pub const X86_FEATURE_NO_NESTED_DATA_BP: u32 = 640;
pub const X86_FEATURE_WRMSR_XX_BASE_NS: u32 = 641;
pub const X86_FEATURE_LFENCE_RDTSC: u32 = 642;
pub const X86_FEATURE_NULL_SEL_CLR_BASE: u32 = 646;
pub const X86_FEATURE_AUTOIBRS: u32 = 648;
pub const X86_FEATURE_NO_SMM_CTL_MSR: u32 = 649;
pub const X86_FEATURE_SBPB: u32 = 667;
pub const X86_FEATURE_IBPB_BRTYPE: u32 = 668;
pub const X86_FEATURE_SRSO_NO: u32 = 669;
pub const X86_FEATURE_CLEAR_BHB_LOOP: u32 = 673;
pub const X86_FEATURE_BHI_CTRL: u32 = 674;
pub const X86_FEATURE_CLEAR_BHB_HW: u32 = 675;
pub const X86_FEATURE_CLEAR_BHB_LOOP_ON_VMEXIT: u32 = 676;
pub const MSR_EFER: u32 = 3221225600;
pub const MSR_STAR: u32 = 3221225601;
pub const MSR_LSTAR: u32 = 3221225602;
pub const MSR_CSTAR: u32 = 3221225603;
pub const MSR_SYSCALL_MASK: u32 = 3221225604;
pub const MSR_FS_BASE: u32 = 3221225728;
pub const MSR_GS_BASE: u32 = 3221225729;
pub const MSR_KERNEL_GS_BASE: u32 = 3221225730;
pub const MSR_TSC_AUX: u32 = 3221225731;
pub const _EFER_SCE: u32 = 0;
pub const _EFER_LME: u32 = 8;
pub const _EFER_LMA: u32 = 10;
pub const _EFER_NX: u32 = 11;
pub const _EFER_SVME: u32 = 12;
pub const _EFER_LMSLE: u32 = 13;
pub const _EFER_FFXSR: u32 = 14;
pub const _EFER_AUTOIBRS: u32 = 21;
pub const EFER_SCE: u32 = 1;
pub const EFER_LME: u32 = 256;
pub const EFER_LMA: u32 = 1024;
pub const EFER_NX: u32 = 2048;
pub const EFER_SVME: u32 = 4096;
pub const EFER_LMSLE: u32 = 8192;
pub const EFER_FFXSR: u32 = 16384;
pub const EFER_AUTOIBRS: u32 = 2097152;
pub const MSR_TEST_CTRL: u32 = 51;
pub const MSR_TEST_CTRL_SPLIT_LOCK_DETECT_BIT: u32 = 29;
pub const MSR_IA32_SPEC_CTRL: u32 = 72;
pub const SPEC_CTRL_STIBP_SHIFT: u32 = 1;
pub const SPEC_CTRL_SSBD_SHIFT: u32 = 2;
pub const SPEC_CTRL_RRSBA_DIS_S_SHIFT: u32 = 6;
pub const SPEC_CTRL_BHI_DIS_S_SHIFT: u32 = 10;
pub const MSR_IA32_PRED_CMD: u32 = 73;
pub const MSR_PPIN_CTL: u32 = 78;
pub const MSR_PPIN: u32 = 79;
pub const MSR_IA32_PERFCTR0: u32 = 193;
pub const MSR_IA32_PERFCTR1: u32 = 194;
pub const MSR_FSB_FREQ: u32 = 205;
pub const MSR_PLATFORM_INFO: u32 = 206;
pub const MSR_PLATFORM_INFO_CPUID_FAULT_BIT: u32 = 31;
pub const MSR_IA32_UMWAIT_CONTROL: u32 = 225;
pub const MSR_IA32_UMWAIT_CONTROL_TIME_MASK: i32 = -4;
pub const MSR_IA32_CORE_CAPS: u32 = 207;
pub const MSR_IA32_CORE_CAPS_INTEGRITY_CAPS_BIT: u32 = 2;
pub const MSR_IA32_CORE_CAPS_SPLIT_LOCK_DETECT_BIT: u32 = 5;
pub const MSR_PKG_CST_CONFIG_CONTROL: u32 = 226;
pub const NHM_C3_AUTO_DEMOTE: u32 = 33554432;
pub const NHM_C1_AUTO_DEMOTE: u32 = 67108864;
pub const ATM_LNC_C6_AUTO_DEMOTE: u32 = 33554432;
pub const SNB_C3_AUTO_UNDEMOTE: u32 = 134217728;
pub const SNB_C1_AUTO_UNDEMOTE: u32 = 268435456;
pub const MSR_MTRRcap: u32 = 254;
pub const MSR_IA32_ARCH_CAPABILITIES: u32 = 266;
pub const MSR_IA32_FLUSH_CMD: u32 = 267;
pub const MSR_IA32_BBL_CR_CTL: u32 = 281;
pub const MSR_IA32_BBL_CR_CTL3: u32 = 286;
pub const MSR_IA32_TSX_CTRL: u32 = 290;
pub const MSR_IA32_MCU_OPT_CTRL: u32 = 291;
pub const MSR_IA32_SYSENTER_CS: u32 = 372;
pub const MSR_IA32_SYSENTER_ESP: u32 = 373;
pub const MSR_IA32_SYSENTER_EIP: u32 = 374;
pub const MSR_IA32_MCG_CAP: u32 = 377;
pub const MSR_IA32_MCG_STATUS: u32 = 378;
pub const MSR_IA32_MCG_CTL: u32 = 379;
pub const MSR_ERROR_CONTROL: u32 = 383;
pub const MSR_IA32_MCG_EXT_CTL: u32 = 1232;
pub const MSR_OFFCORE_RSP_0: u32 = 422;
pub const MSR_OFFCORE_RSP_1: u32 = 423;
pub const MSR_TURBO_RATIO_LIMIT: u32 = 429;
pub const MSR_TURBO_RATIO_LIMIT1: u32 = 430;
pub const MSR_TURBO_RATIO_LIMIT2: u32 = 431;
pub const MSR_SNOOP_RSP_0: u32 = 4904;
pub const MSR_SNOOP_RSP_1: u32 = 4905;
pub const MSR_LBR_SELECT: u32 = 456;
pub const MSR_LBR_TOS: u32 = 457;
pub const MSR_IA32_POWER_CTL: u32 = 508;
pub const MSR_IA32_POWER_CTL_BIT_EE: u32 = 19;
pub const MSR_INTEGRITY_CAPS: u32 = 729;
pub const MSR_INTEGRITY_CAPS_ARRAY_BIST_BIT: u32 = 2;
pub const MSR_INTEGRITY_CAPS_PERIODIC_BIST_BIT: u32 = 4;
pub const MSR_LBR_NHM_FROM: u32 = 1664;
pub const MSR_LBR_NHM_TO: u32 = 1728;
pub const MSR_LBR_CORE_FROM: u32 = 64;
pub const MSR_LBR_CORE_TO: u32 = 96;
pub const MSR_LBR_INFO_0: u32 = 3520;
pub const LBR_INFO_CYCLES: u32 = 65535;
pub const LBR_INFO_BR_TYPE_OFFSET: u32 = 56;
pub const LBR_INFO_BR_TYPE: u64 = 1080863910568919040;
pub const LBR_INFO_BR_CNTR_OFFSET: u32 = 32;
pub const LBR_INFO_BR_CNTR_NUM: u32 = 4;
pub const LBR_INFO_BR_CNTR_BITS: u32 = 2;
pub const MSR_ARCH_LBR_CTL: u32 = 5326;
pub const ARCH_LBR_CTL_CPL_OFFSET: u32 = 1;
pub const ARCH_LBR_CTL_CPL: u32 = 6;
pub const ARCH_LBR_CTL_STACK_OFFSET: u32 = 3;
pub const ARCH_LBR_CTL_STACK: u32 = 8;
pub const ARCH_LBR_CTL_FILTER_OFFSET: u32 = 16;
pub const ARCH_LBR_CTL_FILTER: u32 = 8323072;
pub const MSR_ARCH_LBR_DEPTH: u32 = 5327;
pub const MSR_ARCH_LBR_FROM_0: u32 = 5376;
pub const MSR_ARCH_LBR_TO_0: u32 = 5632;
pub const MSR_ARCH_LBR_INFO_0: u32 = 4608;
pub const MSR_IA32_PEBS_ENABLE: u32 = 1009;
pub const MSR_PEBS_DATA_CFG: u32 = 1010;
pub const MSR_IA32_DS_AREA: u32 = 1536;
pub const MSR_IA32_PERF_CAPABILITIES: u32 = 837;
pub const PERF_CAP_METRICS_IDX: u32 = 15;
pub const PERF_CAP_PT_IDX: u32 = 16;
pub const MSR_PEBS_LD_LAT_THRESHOLD: u32 = 1014;
pub const PERF_CAP_PEBS_FORMAT: u32 = 3840;
pub const MSR_IA32_RTIT_CTL: u32 = 1392;
pub const RTIT_CTL_MTC_RANGE_OFFSET: u32 = 14;
pub const RTIT_CTL_MTC_RANGE: u32 = 245760;
pub const RTIT_CTL_CYC_THRESH_OFFSET: u32 = 19;
pub const RTIT_CTL_CYC_THRESH: u32 = 7864320;
pub const RTIT_CTL_PSB_FREQ_OFFSET: u32 = 24;
pub const RTIT_CTL_PSB_FREQ: u32 = 251658240;
pub const RTIT_CTL_ADDR0_OFFSET: u32 = 32;
pub const RTIT_CTL_ADDR0: u64 = 64424509440;
pub const RTIT_CTL_ADDR1_OFFSET: u32 = 36;
pub const RTIT_CTL_ADDR1: u64 = 1030792151040;
pub const RTIT_CTL_ADDR2_OFFSET: u32 = 40;
pub const RTIT_CTL_ADDR2: u64 = 16492674416640;
pub const RTIT_CTL_ADDR3_OFFSET: u32 = 44;
pub const RTIT_CTL_ADDR3: u64 = 263882790666240;
pub const MSR_IA32_RTIT_STATUS: u32 = 1393;
pub const RTIT_STATUS_BYTECNT_OFFSET: u32 = 32;
pub const RTIT_STATUS_BYTECNT: u64 = 562945658454016;
pub const MSR_IA32_RTIT_ADDR0_A: u32 = 1408;
pub const MSR_IA32_RTIT_ADDR0_B: u32 = 1409;
pub const MSR_IA32_RTIT_ADDR1_A: u32 = 1410;
pub const MSR_IA32_RTIT_ADDR1_B: u32 = 1411;
pub const MSR_IA32_RTIT_ADDR2_A: u32 = 1412;
pub const MSR_IA32_RTIT_ADDR2_B: u32 = 1413;
pub const MSR_IA32_RTIT_ADDR3_A: u32 = 1414;
pub const MSR_IA32_RTIT_ADDR3_B: u32 = 1415;
pub const MSR_IA32_RTIT_CR3_MATCH: u32 = 1394;
pub const MSR_IA32_RTIT_OUTPUT_BASE: u32 = 1376;
pub const MSR_IA32_RTIT_OUTPUT_MASK: u32 = 1377;
pub const MSR_MTRRfix64K_00000: u32 = 592;
pub const MSR_MTRRfix16K_80000: u32 = 600;
pub const MSR_MTRRfix16K_A0000: u32 = 601;
pub const MSR_MTRRfix4K_C0000: u32 = 616;
pub const MSR_MTRRfix4K_C8000: u32 = 617;
pub const MSR_MTRRfix4K_D0000: u32 = 618;
pub const MSR_MTRRfix4K_D8000: u32 = 619;
pub const MSR_MTRRfix4K_E0000: u32 = 620;
pub const MSR_MTRRfix4K_E8000: u32 = 621;
pub const MSR_MTRRfix4K_F0000: u32 = 622;
pub const MSR_MTRRfix4K_F8000: u32 = 623;
pub const MSR_MTRRdefType: u32 = 767;
pub const MSR_IA32_CR_PAT: u32 = 631;
pub const MSR_IA32_DEBUGCTLMSR: u32 = 473;
pub const MSR_IA32_LASTBRANCHFROMIP: u32 = 475;
pub const MSR_IA32_LASTBRANCHTOIP: u32 = 476;
pub const MSR_IA32_LASTINTFROMIP: u32 = 477;
pub const MSR_IA32_LASTINTTOIP: u32 = 478;
pub const MSR_IA32_PASID: u32 = 3475;
pub const DEBUGCTLMSR_LBR: u32 = 1;
pub const DEBUGCTLMSR_BTF_SHIFT: u32 = 1;
pub const DEBUGCTLMSR_BTF: u32 = 2;
pub const DEBUGCTLMSR_BUS_LOCK_DETECT: u32 = 4;
pub const DEBUGCTLMSR_TR: u32 = 64;
pub const DEBUGCTLMSR_BTS: u32 = 128;
pub const DEBUGCTLMSR_BTINT: u32 = 256;
pub const DEBUGCTLMSR_BTS_OFF_OS: u32 = 512;
pub const DEBUGCTLMSR_BTS_OFF_USR: u32 = 1024;
pub const DEBUGCTLMSR_FREEZE_LBRS_ON_PMI: u32 = 2048;
pub const DEBUGCTLMSR_FREEZE_PERFMON_ON_PMI: u32 = 4096;
pub const DEBUGCTLMSR_FREEZE_IN_SMM_BIT: u32 = 14;
pub const DEBUGCTLMSR_FREEZE_IN_SMM: u32 = 16384;
pub const MSR_PEBS_FRONTEND: u32 = 1015;
pub const MSR_IA32_MC0_CTL: u32 = 1024;
pub const MSR_IA32_MC0_STATUS: u32 = 1025;
pub const MSR_IA32_MC0_ADDR: u32 = 1026;
pub const MSR_IA32_MC0_MISC: u32 = 1027;
pub const MSR_PKG_C3_RESIDENCY: u32 = 1016;
pub const MSR_PKG_C6_RESIDENCY: u32 = 1017;
pub const MSR_ATOM_PKG_C6_RESIDENCY: u32 = 1018;
pub const MSR_PKG_C7_RESIDENCY: u32 = 1018;
pub const MSR_CORE_C3_RESIDENCY: u32 = 1020;
pub const MSR_CORE_C6_RESIDENCY: u32 = 1021;
pub const MSR_CORE_C7_RESIDENCY: u32 = 1022;
pub const MSR_KNL_CORE_C6_RESIDENCY: u32 = 1023;
pub const MSR_PKG_C2_RESIDENCY: u32 = 1549;
pub const MSR_PKG_C8_RESIDENCY: u32 = 1584;
pub const MSR_PKG_C9_RESIDENCY: u32 = 1585;
pub const MSR_PKG_C10_RESIDENCY: u32 = 1586;
pub const MSR_PKGC3_IRTL: u32 = 1546;
pub const MSR_PKGC6_IRTL: u32 = 1547;
pub const MSR_PKGC7_IRTL: u32 = 1548;
pub const MSR_PKGC8_IRTL: u32 = 1587;
pub const MSR_PKGC9_IRTL: u32 = 1588;
pub const MSR_PKGC10_IRTL: u32 = 1589;
pub const MSR_VR_CURRENT_CONFIG: u32 = 1537;
pub const MSR_RAPL_POWER_UNIT: u32 = 1542;
pub const MSR_PKG_POWER_LIMIT: u32 = 1552;
pub const MSR_PKG_ENERGY_STATUS: u32 = 1553;
pub const MSR_PKG_PERF_STATUS: u32 = 1555;
pub const MSR_PKG_POWER_INFO: u32 = 1556;
pub const MSR_DRAM_POWER_LIMIT: u32 = 1560;
pub const MSR_DRAM_ENERGY_STATUS: u32 = 1561;
pub const MSR_DRAM_PERF_STATUS: u32 = 1563;
pub const MSR_DRAM_POWER_INFO: u32 = 1564;
pub const MSR_PP0_POWER_LIMIT: u32 = 1592;
pub const MSR_PP0_ENERGY_STATUS: u32 = 1593;
pub const MSR_PP0_POLICY: u32 = 1594;
pub const MSR_PP0_PERF_STATUS: u32 = 1595;
pub const MSR_PP1_POWER_LIMIT: u32 = 1600;
pub const MSR_PP1_ENERGY_STATUS: u32 = 1601;
pub const MSR_PP1_POLICY: u32 = 1602;
pub const MSR_AMD_RAPL_POWER_UNIT: u32 = 3221291673;
pub const MSR_AMD_CORE_ENERGY_STATUS: u32 = 3221291674;
pub const MSR_AMD_PKG_ENERGY_STATUS: u32 = 3221291675;
pub const MSR_CONFIG_TDP_NOMINAL: u32 = 1608;
pub const MSR_CONFIG_TDP_LEVEL_1: u32 = 1609;
pub const MSR_CONFIG_TDP_LEVEL_2: u32 = 1610;
pub const MSR_CONFIG_TDP_CONTROL: u32 = 1611;
pub const MSR_TURBO_ACTIVATION_RATIO: u32 = 1612;
pub const MSR_PLATFORM_ENERGY_STATUS: u32 = 1613;
pub const MSR_SECONDARY_TURBO_RATIO_LIMIT: u32 = 1616;
pub const MSR_PKG_WEIGHTED_CORE_C0_RES: u32 = 1624;
pub const MSR_PKG_ANY_CORE_C0_RES: u32 = 1625;
pub const MSR_PKG_ANY_GFXE_C0_RES: u32 = 1626;
pub const MSR_PKG_BOTH_CORE_GFXE_C0_RES: u32 = 1627;
pub const MSR_CORE_C1_RES: u32 = 1632;
pub const MSR_MODULE_C6_RES_MS: u32 = 1636;
pub const MSR_CC6_DEMOTION_POLICY_CONFIG: u32 = 1640;
pub const MSR_MC6_DEMOTION_POLICY_CONFIG: u32 = 1641;
pub const MSR_ATOM_CORE_RATIOS: u32 = 1642;
pub const MSR_ATOM_CORE_VIDS: u32 = 1643;
pub const MSR_ATOM_CORE_TURBO_RATIOS: u32 = 1644;
pub const MSR_ATOM_CORE_TURBO_VIDS: u32 = 1645;
pub const MSR_CORE_PERF_LIMIT_REASONS: u32 = 1680;
pub const MSR_GFX_PERF_LIMIT_REASONS: u32 = 1712;
pub const MSR_RING_PERF_LIMIT_REASONS: u32 = 1713;
pub const MSR_IA32_U_CET: u32 = 1696;
pub const MSR_IA32_S_CET: u32 = 1698;
pub const MSR_IA32_PL0_SSP: u32 = 1700;
pub const MSR_IA32_PL1_SSP: u32 = 1701;
pub const MSR_IA32_PL2_SSP: u32 = 1702;
pub const MSR_IA32_PL3_SSP: u32 = 1703;
pub const MSR_IA32_INT_SSP_TAB: u32 = 1704;
pub const MSR_PPERF: u32 = 1614;
pub const MSR_PERF_LIMIT_REASONS: u32 = 1615;
pub const MSR_PM_ENABLE: u32 = 1904;
pub const MSR_HWP_CAPABILITIES: u32 = 1905;
pub const MSR_HWP_REQUEST_PKG: u32 = 1906;
pub const MSR_HWP_INTERRUPT: u32 = 1907;
pub const MSR_HWP_REQUEST: u32 = 1908;
pub const MSR_HWP_STATUS: u32 = 1911;
pub const HWP_BASE_BIT: u32 = 128;
pub const HWP_NOTIFICATIONS_BIT: u32 = 256;
pub const HWP_ACTIVITY_WINDOW_BIT: u32 = 512;
pub const HWP_ENERGY_PERF_PREFERENCE_BIT: u32 = 1024;
pub const HWP_PACKAGE_LEVEL_REQUEST_BIT: u32 = 2048;
pub const HWP_EPP_PERFORMANCE: u32 = 0;
pub const HWP_EPP_BALANCE_PERFORMANCE: u32 = 128;
pub const HWP_EPP_BALANCE_POWERSAVE: u32 = 192;
pub const HWP_EPP_POWERSAVE: u32 = 255;
pub const MSR_AMD64_MC0_MASK: u32 = 3221291076;
pub const MSR_IA32_MC0_CTL2: u32 = 640;
pub const MSR_P6_PERFCTR0: u32 = 193;
pub const MSR_P6_PERFCTR1: u32 = 194;
pub const MSR_P6_EVNTSEL0: u32 = 390;
pub const MSR_P6_EVNTSEL1: u32 = 391;
pub const MSR_KNC_PERFCTR0: u32 = 32;
pub const MSR_KNC_PERFCTR1: u32 = 33;
pub const MSR_KNC_EVNTSEL0: u32 = 40;
pub const MSR_KNC_EVNTSEL1: u32 = 41;
pub const MSR_IA32_PMC0: u32 = 1217;
pub const MSR_RELOAD_PMC0: u32 = 5313;
pub const MSR_RELOAD_FIXED_CTR0: u32 = 4873;
pub const MSR_IA32_MKTME_KEYID_PARTITIONING: u32 = 135;
pub const MSR_AMD64_PATCH_LEVEL: u32 = 139;
pub const MSR_AMD64_TSC_RATIO: u32 = 3221225732;
pub const MSR_AMD64_NB_CFG: u32 = 3221291039;
pub const MSR_AMD64_PATCH_LOADER: u32 = 3221291040;
pub const MSR_AMD_PERF_CTL: u32 = 3221291106;
pub const MSR_AMD_PERF_STATUS: u32 = 3221291107;
pub const MSR_AMD_PSTATE_DEF_BASE: u32 = 3221291108;
pub const MSR_AMD64_OSVW_ID_LENGTH: u32 = 3221291328;
pub const MSR_AMD64_OSVW_STATUS: u32 = 3221291329;
pub const MSR_AMD_PPIN_CTL: u32 = 3221291760;
pub const MSR_AMD_PPIN: u32 = 3221291761;
pub const MSR_AMD64_CPUID_FN_1: u32 = 3221295108;
pub const MSR_AMD64_LS_CFG: u32 = 3221295136;
pub const MSR_AMD64_DC_CFG: u32 = 3221295138;
pub const MSR_AMD64_TW_CFG: u32 = 3221295139;
pub const MSR_AMD64_DE_CFG: u32 = 3221295145;
pub const MSR_AMD64_DE_CFG_LFENCE_SERIALIZE_BIT: u32 = 1;
pub const MSR_AMD64_DE_CFG_ZEN2_FP_BACKUP_FIX_BIT: u32 = 9;
pub const MSR_AMD64_BU_CFG2: u32 = 3221295146;
pub const MSR_AMD64_IBSFETCHCTL: u32 = 3221295152;
pub const MSR_AMD64_IBSFETCHLINAD: u32 = 3221295153;
pub const MSR_AMD64_IBSFETCHPHYSAD: u32 = 3221295154;
pub const MSR_AMD64_IBSFETCH_REG_COUNT: u32 = 3;
pub const MSR_AMD64_IBSFETCH_REG_MASK: u32 = 7;
pub const MSR_AMD64_IBSOPCTL: u32 = 3221295155;
pub const MSR_AMD64_IBSOPRIP: u32 = 3221295156;
pub const MSR_AMD64_IBSOPDATA: u32 = 3221295157;
pub const MSR_AMD64_IBSOPDATA2: u32 = 3221295158;
pub const MSR_AMD64_IBSOPDATA3: u32 = 3221295159;
pub const MSR_AMD64_IBSDCLINAD: u32 = 3221295160;
pub const MSR_AMD64_IBSDCPHYSAD: u32 = 3221295161;
pub const MSR_AMD64_IBSOP_REG_COUNT: u32 = 7;
pub const MSR_AMD64_IBSOP_REG_MASK: u32 = 127;
pub const MSR_AMD64_IBSCTL: u32 = 3221295162;
pub const MSR_AMD64_IBSBRTARGET: u32 = 3221295163;
pub const MSR_AMD64_ICIBSEXTDCTL: u32 = 3221295164;
pub const MSR_AMD64_IBSOPDATA4: u32 = 3221295165;
pub const MSR_AMD64_IBS_REG_COUNT_MAX: u32 = 8;
pub const MSR_AMD64_SVM_AVIC_DOORBELL: u32 = 3221291291;
pub const MSR_AMD64_VM_PAGE_FLUSH: u32 = 3221291294;
pub const MSR_AMD64_SEV_ES_GHCB: u32 = 3221291312;
pub const MSR_AMD64_SEV: u32 = 3221291313;
pub const MSR_AMD64_SEV_ENABLED_BIT: u32 = 0;
pub const MSR_AMD64_SEV_ES_ENABLED_BIT: u32 = 1;
pub const MSR_AMD64_SEV_SNP_ENABLED_BIT: u32 = 2;
pub const MSR_AMD64_VIRT_SPEC_CTRL: u32 = 3221291295;
pub const MSR_AMD_CPPC_CAP1: u32 = 3221291696;
pub const MSR_AMD_CPPC_ENABLE: u32 = 3221291697;
pub const MSR_AMD_CPPC_CAP2: u32 = 3221291698;
pub const MSR_AMD_CPPC_REQ: u32 = 3221291699;
pub const MSR_AMD_CPPC_STATUS: u32 = 3221291700;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_STATUS: u32 = 3221226240;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_CTL: u32 = 3221226241;
pub const MSR_AMD64_PERF_CNTR_GLOBAL_STATUS_CLR: u32 = 3221226242;
pub const MSR_AMD64_LBR_SELECT: u32 = 3221225742;
pub const MSR_ZEN4_BP_CFG: u32 = 3221295150;
pub const MSR_ZEN4_BP_CFG_SHARED_BTB_FIX_BIT: u32 = 5;
pub const MSR_F19H_UMC_PERF_CTL: u32 = 3221293056;
pub const MSR_F19H_UMC_PERF_CTR: u32 = 3221293057;
pub const MSR_ZEN2_SPECTRAL_CHICKEN: u32 = 3221295331;
pub const MSR_F17H_IRPERF: u32 = 3221225705;
pub const MSR_F16H_L2I_PERF_CTL: u32 = 3221291568;
pub const MSR_F16H_L2I_PERF_CTR: u32 = 3221291569;
pub const MSR_F16H_DR1_ADDR_MASK: u32 = 3221295129;
pub const MSR_F16H_DR2_ADDR_MASK: u32 = 3221295130;
pub const MSR_F16H_DR3_ADDR_MASK: u32 = 3221295131;
pub const MSR_F16H_DR0_ADDR_MASK: u32 = 3221295143;
pub const MSR_F15H_CU_PWR_ACCUMULATOR: u32 = 3221291130;
pub const MSR_F15H_CU_MAX_PWR_ACCUMULATOR: u32 = 3221291131;
pub const MSR_F15H_PERF_CTL: u32 = 3221291520;
pub const MSR_F15H_PERF_CTL0: u32 = 3221291520;
pub const MSR_F15H_PERF_CTL1: u32 = 3221291522;
pub const MSR_F15H_PERF_CTL2: u32 = 3221291524;
pub const MSR_F15H_PERF_CTL3: u32 = 3221291526;
pub const MSR_F15H_PERF_CTL4: u32 = 3221291528;
pub const MSR_F15H_PERF_CTL5: u32 = 3221291530;
pub const MSR_F15H_PERF_CTR: u32 = 3221291521;
pub const MSR_F15H_PERF_CTR0: u32 = 3221291521;
pub const MSR_F15H_PERF_CTR1: u32 = 3221291523;
pub const MSR_F15H_PERF_CTR2: u32 = 3221291525;
pub const MSR_F15H_PERF_CTR3: u32 = 3221291527;
pub const MSR_F15H_PERF_CTR4: u32 = 3221291529;
pub const MSR_F15H_PERF_CTR5: u32 = 3221291531;
pub const MSR_F15H_NB_PERF_CTL: u32 = 3221291584;
pub const MSR_F15H_NB_PERF_CTR: u32 = 3221291585;
pub const MSR_F15H_PTSC: u32 = 3221291648;
pub const MSR_F15H_IC_CFG: u32 = 3221295137;
pub const MSR_F15H_EX_CFG: u32 = 3221295148;
pub const MSR_FAM10H_MMIO_CONF_BASE: u32 = 3221291096;
pub const FAM10H_MMIO_CONF_ENABLE: u32 = 1;
pub const FAM10H_MMIO_CONF_BUSRANGE_MASK: u32 = 15;
pub const FAM10H_MMIO_CONF_BUSRANGE_SHIFT: u32 = 2;
pub const FAM10H_MMIO_CONF_BASE_MASK: u32 = 268435455;
pub const FAM10H_MMIO_CONF_BASE_SHIFT: u32 = 20;
pub const MSR_FAM10H_NODE_ID: u32 = 3221295116;
pub const MSR_K8_TOP_MEM1: u32 = 3221291034;
pub const MSR_K8_TOP_MEM2: u32 = 3221291037;
pub const MSR_AMD64_SYSCFG: u32 = 3221291024;
pub const MSR_AMD64_SYSCFG_MEM_ENCRYPT_BIT: u32 = 23;
pub const MSR_K8_INT_PENDING_MSG: u32 = 3221291093;
pub const K8_INTP_C1E_ACTIVE_MASK: u32 = 402653184;
pub const MSR_K8_TSEG_ADDR: u32 = 3221291282;
pub const MSR_K8_TSEG_MASK: u32 = 3221291283;
pub const K8_MTRRFIXRANGE_DRAM_ENABLE: u32 = 262144;
pub const K8_MTRRFIXRANGE_DRAM_MODIFY: u32 = 524288;
pub const K8_MTRR_RDMEM_WRMEM_MASK: u32 = 404232216;
pub const MSR_K7_EVNTSEL0: u32 = 3221291008;
pub const MSR_K7_PERFCTR0: u32 = 3221291012;
pub const MSR_K7_EVNTSEL1: u32 = 3221291009;
pub const MSR_K7_PERFCTR1: u32 = 3221291013;
pub const MSR_K7_EVNTSEL2: u32 = 3221291010;
pub const MSR_K7_PERFCTR2: u32 = 3221291014;
pub const MSR_K7_EVNTSEL3: u32 = 3221291011;
pub const MSR_K7_PERFCTR3: u32 = 3221291015;
pub const MSR_K7_CLK_CTL: u32 = 3221291035;
pub const MSR_K7_HWCR: u32 = 3221291029;
pub const MSR_K7_HWCR_SMMLOCK_BIT: u32 = 0;
pub const MSR_K7_HWCR_IRPERF_EN_BIT: u32 = 30;
pub const MSR_K7_FID_VID_CTL: u32 = 3221291073;
pub const MSR_K7_FID_VID_STATUS: u32 = 3221291074;
pub const MSR_K6_WHCR: u32 = 3221225602;
pub const MSR_K6_UWCCR: u32 = 3221225605;
pub const MSR_K6_EPMR: u32 = 3221225606;
pub const MSR_K6_PSOR: u32 = 3221225607;
pub const MSR_K6_PFIR: u32 = 3221225608;
pub const MSR_IDT_FCR1: u32 = 263;
pub const MSR_IDT_FCR2: u32 = 264;
pub const MSR_IDT_FCR3: u32 = 265;
pub const MSR_IDT_FCR4: u32 = 266;
pub const MSR_IDT_MCR0: u32 = 272;
pub const MSR_IDT_MCR1: u32 = 273;
pub const MSR_IDT_MCR2: u32 = 274;
pub const MSR_IDT_MCR3: u32 = 275;
pub const MSR_IDT_MCR4: u32 = 276;
pub const MSR_IDT_MCR5: u32 = 277;
pub const MSR_IDT_MCR6: u32 = 278;
pub const MSR_IDT_MCR7: u32 = 279;
pub const MSR_IDT_MCR_CTRL: u32 = 288;
pub const MSR_VIA_FCR: u32 = 4359;
pub const MSR_VIA_LONGHAUL: u32 = 4362;
pub const MSR_VIA_RNG: u32 = 4363;
pub const MSR_VIA_BCR2: u32 = 4423;
pub const MSR_TMTA_LONGRUN_CTRL: u32 = 2156298256;
pub const MSR_TMTA_LONGRUN_FLAGS: u32 = 2156298257;
pub const MSR_TMTA_LRTI_READOUT: u32 = 2156298264;
pub const MSR_TMTA_LRTI_VOLT_MHZ: u32 = 2156298266;
pub const MSR_IA32_P5_MC_ADDR: u32 = 0;
pub const MSR_IA32_P5_MC_TYPE: u32 = 1;
pub const MSR_IA32_TSC: u32 = 16;
pub const MSR_IA32_PLATFORM_ID: u32 = 23;
pub const MSR_IA32_EBL_CR_POWERON: u32 = 42;
pub const MSR_EBC_FREQUENCY_ID: u32 = 44;
pub const MSR_SMI_COUNT: u32 = 52;
pub const MSR_IA32_FEAT_CTL: u32 = 58;
pub const MSR_IA32_TSC_ADJUST: u32 = 59;
pub const MSR_IA32_BNDCFGS: u32 = 3472;
pub const MSR_IA32_BNDCFGS_RSVD: u32 = 4092;
pub const MSR_IA32_XFD: u32 = 452;
pub const MSR_IA32_XFD_ERR: u32 = 453;
pub const MSR_IA32_XSS: u32 = 3488;
pub const MSR_IA32_APICBASE: u32 = 27;
pub const MSR_IA32_APICBASE_BSP: u32 = 256;
pub const MSR_IA32_APICBASE_ENABLE: u32 = 2048;
pub const MSR_IA32_APICBASE_BASE: u32 = 4294963200;
pub const MSR_IA32_UCODE_WRITE: u32 = 121;
pub const MSR_IA32_UCODE_REV: u32 = 139;
pub const MSR_IA32_SGXLEPUBKEYHASH0: u32 = 140;
pub const MSR_IA32_SGXLEPUBKEYHASH1: u32 = 141;
pub const MSR_IA32_SGXLEPUBKEYHASH2: u32 = 142;
pub const MSR_IA32_SGXLEPUBKEYHASH3: u32 = 143;
pub const MSR_IA32_SMM_MONITOR_CTL: u32 = 155;
pub const MSR_IA32_SMBASE: u32 = 158;
pub const MSR_IA32_PERF_STATUS: u32 = 408;
pub const MSR_IA32_PERF_CTL: u32 = 409;
pub const INTEL_PERF_CTL_MASK: u32 = 65535;
pub const MSR_AMD_DBG_EXTN_CFG: u32 = 3221225743;
pub const MSR_AMD_SAMP_BR_FROM: u32 = 3221291776;
pub const MSR_IA32_MPERF: u32 = 231;
pub const MSR_IA32_APERF: u32 = 232;
pub const MSR_IA32_THERM_CONTROL: u32 = 410;
pub const MSR_IA32_THERM_INTERRUPT: u32 = 411;
pub const THERM_INT_HIGH_ENABLE: u32 = 1;
pub const THERM_INT_LOW_ENABLE: u32 = 2;
pub const THERM_INT_PLN_ENABLE: u32 = 16777216;
pub const MSR_IA32_THERM_STATUS: u32 = 412;
pub const THERM_STATUS_PROCHOT: u32 = 1;
pub const THERM_STATUS_POWER_LIMIT: u32 = 1024;
pub const MSR_THERM2_CTL: u32 = 413;
pub const MSR_THERM2_CTL_TM_SELECT: u32 = 65536;
pub const MSR_IA32_MISC_ENABLE: u32 = 416;
pub const MSR_IA32_TEMPERATURE_TARGET: u32 = 418;
pub const MSR_MISC_FEATURE_CONTROL: u32 = 420;
pub const MSR_MISC_PWR_MGMT: u32 = 426;
pub const MSR_IA32_ENERGY_PERF_BIAS: u32 = 432;
pub const ENERGY_PERF_BIAS_PERFORMANCE: u32 = 0;
pub const ENERGY_PERF_BIAS_BALANCE_PERFORMANCE: u32 = 4;
pub const ENERGY_PERF_BIAS_NORMAL: u32 = 6;
pub const ENERGY_PERF_BIAS_NORMAL_POWERSAVE: u32 = 7;
pub const ENERGY_PERF_BIAS_BALANCE_POWERSAVE: u32 = 8;
pub const ENERGY_PERF_BIAS_POWERSAVE: u32 = 15;
pub const MSR_IA32_PACKAGE_THERM_STATUS: u32 = 433;
pub const PACKAGE_THERM_STATUS_PROCHOT: u32 = 1;
pub const PACKAGE_THERM_STATUS_POWER_LIMIT: u32 = 1024;
pub const PACKAGE_THERM_STATUS_HFI_UPDATED: u32 = 67108864;
pub const MSR_IA32_PACKAGE_THERM_INTERRUPT: u32 = 434;
pub const PACKAGE_THERM_INT_HIGH_ENABLE: u32 = 1;
pub const PACKAGE_THERM_INT_LOW_ENABLE: u32 = 2;
pub const PACKAGE_THERM_INT_PLN_ENABLE: u32 = 16777216;
pub const PACKAGE_THERM_INT_HFI_ENABLE: u32 = 33554432;
pub const THERM_INT_THRESHOLD0_ENABLE: u32 = 32768;
pub const THERM_SHIFT_THRESHOLD0: u32 = 8;
pub const THERM_MASK_THRESHOLD0: u32 = 32512;
pub const THERM_INT_THRESHOLD1_ENABLE: u32 = 8388608;
pub const THERM_SHIFT_THRESHOLD1: u32 = 16;
pub const THERM_MASK_THRESHOLD1: u32 = 8323072;
pub const THERM_STATUS_THRESHOLD0: u32 = 64;
pub const THERM_LOG_THRESHOLD0: u32 = 128;
pub const THERM_STATUS_THRESHOLD1: u32 = 256;
pub const THERM_LOG_THRESHOLD1: u32 = 512;
pub const MSR_IA32_MISC_ENABLE_FAST_STRING_BIT: u32 = 0;
pub const MSR_IA32_MISC_ENABLE_FAST_STRING: u32 = 1;
pub const MSR_IA32_MISC_ENABLE_TCC_BIT: u32 = 1;
pub const MSR_IA32_MISC_ENABLE_TCC: u32 = 2;
pub const MSR_IA32_MISC_ENABLE_EMON_BIT: u32 = 7;
pub const MSR_IA32_MISC_ENABLE_EMON: u32 = 128;
pub const MSR_IA32_MISC_ENABLE_BTS_UNAVAIL_BIT: u32 = 11;
pub const MSR_IA32_MISC_ENABLE_BTS_UNAVAIL: u32 = 2048;
pub const MSR_IA32_MISC_ENABLE_PEBS_UNAVAIL_BIT: u32 = 12;
pub const MSR_IA32_MISC_ENABLE_PEBS_UNAVAIL: u32 = 4096;
pub const MSR_IA32_MISC_ENABLE_ENHANCED_SPEEDSTEP_BIT: u32 = 16;
pub const MSR_IA32_MISC_ENABLE_ENHANCED_SPEEDSTEP: u32 = 65536;
pub const MSR_IA32_MISC_ENABLE_MWAIT_BIT: u32 = 18;
pub const MSR_IA32_MISC_ENABLE_MWAIT: u32 = 262144;
pub const MSR_IA32_MISC_ENABLE_LIMIT_CPUID_BIT: u32 = 22;
pub const MSR_IA32_MISC_ENABLE_LIMIT_CPUID: u32 = 4194304;
pub const MSR_IA32_MISC_ENABLE_XTPR_DISABLE_BIT: u32 = 23;
pub const MSR_IA32_MISC_ENABLE_XTPR_DISABLE: u32 = 8388608;
pub const MSR_IA32_MISC_ENABLE_XD_DISABLE_BIT: u32 = 34;
pub const MSR_IA32_MISC_ENABLE_XD_DISABLE: u64 = 17179869184;
pub const MSR_IA32_MISC_ENABLE_X87_COMPAT_BIT: u32 = 2;
pub const MSR_IA32_MISC_ENABLE_X87_COMPAT: u32 = 4;
pub const MSR_IA32_MISC_ENABLE_TM1_BIT: u32 = 3;
pub const MSR_IA32_MISC_ENABLE_TM1: u32 = 8;
pub const MSR_IA32_MISC_ENABLE_SPLIT_LOCK_DISABLE_BIT: u32 = 4;
pub const MSR_IA32_MISC_ENABLE_SPLIT_LOCK_DISABLE: u32 = 16;
pub const MSR_IA32_MISC_ENABLE_L3CACHE_DISABLE_BIT: u32 = 6;
pub const MSR_IA32_MISC_ENABLE_L3CACHE_DISABLE: u32 = 64;
pub const MSR_IA32_MISC_ENABLE_SUPPRESS_LOCK_BIT: u32 = 8;
pub const MSR_IA32_MISC_ENABLE_SUPPRESS_LOCK: u32 = 256;
pub const MSR_IA32_MISC_ENABLE_PREFETCH_DISABLE_BIT: u32 = 9;
pub const MSR_IA32_MISC_ENABLE_PREFETCH_DISABLE: u32 = 512;
pub const MSR_IA32_MISC_ENABLE_FERR_BIT: u32 = 10;
pub const MSR_IA32_MISC_ENABLE_FERR: u32 = 1024;
pub const MSR_IA32_MISC_ENABLE_FERR_MULTIPLEX_BIT: u32 = 10;
pub const MSR_IA32_MISC_ENABLE_FERR_MULTIPLEX: u32 = 1024;
pub const MSR_IA32_MISC_ENABLE_TM2_BIT: u32 = 13;
pub const MSR_IA32_MISC_ENABLE_TM2: u32 = 8192;
pub const MSR_IA32_MISC_ENABLE_ADJ_PREF_DISABLE_BIT: u32 = 19;
pub const MSR_IA32_MISC_ENABLE_ADJ_PREF_DISABLE: u32 = 524288;
pub const MSR_IA32_MISC_ENABLE_SPEEDSTEP_LOCK_BIT: u32 = 20;
pub const MSR_IA32_MISC_ENABLE_SPEEDSTEP_LOCK: u32 = 1048576;
pub const MSR_IA32_MISC_ENABLE_L1D_CONTEXT_BIT: u32 = 24;
pub const MSR_IA32_MISC_ENABLE_L1D_CONTEXT: u32 = 16777216;
pub const MSR_IA32_MISC_ENABLE_DCU_PREF_DISABLE_BIT: u32 = 37;
pub const MSR_IA32_MISC_ENABLE_DCU_PREF_DISABLE: u64 = 137438953472;
pub const MSR_IA32_MISC_ENABLE_TURBO_DISABLE_BIT: u32 = 38;
pub const MSR_IA32_MISC_ENABLE_TURBO_DISABLE: u64 = 274877906944;
pub const MSR_IA32_MISC_ENABLE_IP_PREF_DISABLE_BIT: u32 = 39;
pub const MSR_IA32_MISC_ENABLE_IP_PREF_DISABLE: u64 = 549755813888;
pub const MSR_MISC_FEATURES_ENABLES: u32 = 320;
pub const MSR_MISC_FEATURES_ENABLES_CPUID_FAULT_BIT: u32 = 0;
pub const MSR_MISC_FEATURES_ENABLES_RING3MWAIT_BIT: u32 = 1;
pub const MSR_IA32_TSC_DEADLINE: u32 = 1760;
pub const MSR_TSX_FORCE_ABORT: u32 = 271;
pub const MSR_TFA_RTM_FORCE_ABORT_BIT: u32 = 0;
pub const MSR_TFA_TSX_CPUID_CLEAR_BIT: u32 = 1;
pub const MSR_TFA_SDV_ENABLE_RTM_BIT: u32 = 2;
pub const MSR_IA32_MCG_EAX: u32 = 384;
pub const MSR_IA32_MCG_EBX: u32 = 385;
pub const MSR_IA32_MCG_ECX: u32 = 386;
pub const MSR_IA32_MCG_EDX: u32 = 387;
pub const MSR_IA32_MCG_ESI: u32 = 388;
pub const MSR_IA32_MCG_EDI: u32 = 389;
pub const MSR_IA32_MCG_EBP: u32 = 390;
pub const MSR_IA32_MCG_ESP: u32 = 391;
pub const MSR_IA32_MCG_EFLAGS: u32 = 392;
pub const MSR_IA32_MCG_EIP: u32 = 393;
pub const MSR_IA32_MCG_RESERVED: u32 = 394;
pub const MSR_P4_BPU_PERFCTR0: u32 = 768;
pub const MSR_P4_BPU_PERFCTR1: u32 = 769;
pub const MSR_P4_BPU_PERFCTR2: u32 = 770;
pub const MSR_P4_BPU_PERFCTR3: u32 = 771;
pub const MSR_P4_MS_PERFCTR0: u32 = 772;
pub const MSR_P4_MS_PERFCTR1: u32 = 773;
pub const MSR_P4_MS_PERFCTR2: u32 = 774;
pub const MSR_P4_MS_PERFCTR3: u32 = 775;
pub const MSR_P4_FLAME_PERFCTR0: u32 = 776;
pub const MSR_P4_FLAME_PERFCTR1: u32 = 777;
pub const MSR_P4_FLAME_PERFCTR2: u32 = 778;
pub const MSR_P4_FLAME_PERFCTR3: u32 = 779;
pub const MSR_P4_IQ_PERFCTR0: u32 = 780;
pub const MSR_P4_IQ_PERFCTR1: u32 = 781;
pub const MSR_P4_IQ_PERFCTR2: u32 = 782;
pub const MSR_P4_IQ_PERFCTR3: u32 = 783;
pub const MSR_P4_IQ_PERFCTR4: u32 = 784;
pub const MSR_P4_IQ_PERFCTR5: u32 = 785;
pub const MSR_P4_BPU_CCCR0: u32 = 864;
pub const MSR_P4_BPU_CCCR1: u32 = 865;
pub const MSR_P4_BPU_CCCR2: u32 = 866;
pub const MSR_P4_BPU_CCCR3: u32 = 867;
pub const MSR_P4_MS_CCCR0: u32 = 868;
pub const MSR_P4_MS_CCCR1: u32 = 869;
pub const MSR_P4_MS_CCCR2: u32 = 870;
pub const MSR_P4_MS_CCCR3: u32 = 871;
pub const MSR_P4_FLAME_CCCR0: u32 = 872;
pub const MSR_P4_FLAME_CCCR1: u32 = 873;
pub const MSR_P4_FLAME_CCCR2: u32 = 874;
pub const MSR_P4_FLAME_CCCR3: u32 = 875;
pub const MSR_P4_IQ_CCCR0: u32 = 876;
pub const MSR_P4_IQ_CCCR1: u32 = 877;
pub const MSR_P4_IQ_CCCR2: u32 = 878;
pub const MSR_P4_IQ_CCCR3: u32 = 879;
pub const MSR_P4_IQ_CCCR4: u32 = 880;
pub const MSR_P4_IQ_CCCR5: u32 = 881;
pub const MSR_P4_ALF_ESCR0: u32 = 970;
pub const MSR_P4_ALF_ESCR1: u32 = 971;
pub const MSR_P4_BPU_ESCR0: u32 = 946;
pub const MSR_P4_BPU_ESCR1: u32 = 947;
pub const MSR_P4_BSU_ESCR0: u32 = 928;
pub const MSR_P4_BSU_ESCR1: u32 = 929;
pub const MSR_P4_CRU_ESCR0: u32 = 952;
pub const MSR_P4_CRU_ESCR1: u32 = 953;
pub const MSR_P4_CRU_ESCR2: u32 = 972;
pub const MSR_P4_CRU_ESCR3: u32 = 973;
pub const MSR_P4_CRU_ESCR4: u32 = 992;
pub const MSR_P4_CRU_ESCR5: u32 = 993;
pub const MSR_P4_DAC_ESCR0: u32 = 936;
pub const MSR_P4_DAC_ESCR1: u32 = 937;
pub const MSR_P4_FIRM_ESCR0: u32 = 932;
pub const MSR_P4_FIRM_ESCR1: u32 = 933;
pub const MSR_P4_FLAME_ESCR0: u32 = 934;
pub const MSR_P4_FLAME_ESCR1: u32 = 935;
pub const MSR_P4_FSB_ESCR0: u32 = 930;
pub const MSR_P4_FSB_ESCR1: u32 = 931;
pub const MSR_P4_IQ_ESCR0: u32 = 954;
pub const MSR_P4_IQ_ESCR1: u32 = 955;
pub const MSR_P4_IS_ESCR0: u32 = 948;
pub const MSR_P4_IS_ESCR1: u32 = 949;
pub const MSR_P4_ITLB_ESCR0: u32 = 950;
pub const MSR_P4_ITLB_ESCR1: u32 = 951;
pub const MSR_P4_IX_ESCR0: u32 = 968;
pub const MSR_P4_IX_ESCR1: u32 = 969;
pub const MSR_P4_MOB_ESCR0: u32 = 938;
pub const MSR_P4_MOB_ESCR1: u32 = 939;
pub const MSR_P4_MS_ESCR0: u32 = 960;
pub const MSR_P4_MS_ESCR1: u32 = 961;
pub const MSR_P4_PMH_ESCR0: u32 = 940;
pub const MSR_P4_PMH_ESCR1: u32 = 941;
pub const MSR_P4_RAT_ESCR0: u32 = 956;
pub const MSR_P4_RAT_ESCR1: u32 = 957;
pub const MSR_P4_SAAT_ESCR0: u32 = 942;
pub const MSR_P4_SAAT_ESCR1: u32 = 943;
pub const MSR_P4_SSU_ESCR0: u32 = 958;
pub const MSR_P4_SSU_ESCR1: u32 = 959;
pub const MSR_P4_TBPU_ESCR0: u32 = 962;
pub const MSR_P4_TBPU_ESCR1: u32 = 963;
pub const MSR_P4_TC_ESCR0: u32 = 964;
pub const MSR_P4_TC_ESCR1: u32 = 965;
pub const MSR_P4_U2L_ESCR0: u32 = 944;
pub const MSR_P4_U2L_ESCR1: u32 = 945;
pub const MSR_P4_PEBS_MATRIX_VERT: u32 = 1010;
pub const MSR_CORE_PERF_FIXED_CTR0: u32 = 777;
pub const MSR_CORE_PERF_FIXED_CTR1: u32 = 778;
pub const MSR_CORE_PERF_FIXED_CTR2: u32 = 779;
pub const MSR_CORE_PERF_FIXED_CTR3: u32 = 780;
pub const MSR_CORE_PERF_FIXED_CTR_CTRL: u32 = 909;
pub const MSR_CORE_PERF_GLOBAL_STATUS: u32 = 910;
pub const MSR_CORE_PERF_GLOBAL_CTRL: u32 = 911;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL: u32 = 912;
pub const MSR_PERF_METRICS: u32 = 809;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_TRACE_TOPA_PMI_BIT: u32 = 55;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_TRACE_TOPA_PMI: u64 = 36028797018963968;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_OVF_BUF_BIT: u32 = 62;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_OVF_BUF: u64 = 4611686018427387904;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_COND_CHGD_BIT: u32 = 63;
pub const MSR_CORE_PERF_GLOBAL_OVF_CTRL_COND_CHGD: i64 = -9223372036854775808;
pub const MSR_GEODE_BUSCONT_CONF0: u32 = 6400;
pub const MSR_IA32_VMX_BASIC: u32 = 1152;
pub const MSR_IA32_VMX_PINBASED_CTLS: u32 = 1153;
pub const MSR_IA32_VMX_PROCBASED_CTLS: u32 = 1154;
pub const MSR_IA32_VMX_EXIT_CTLS: u32 = 1155;
pub const MSR_IA32_VMX_ENTRY_CTLS: u32 = 1156;
pub const MSR_IA32_VMX_MISC: u32 = 1157;
pub const MSR_IA32_VMX_CR0_FIXED0: u32 = 1158;
pub const MSR_IA32_VMX_CR0_FIXED1: u32 = 1159;
pub const MSR_IA32_VMX_CR4_FIXED0: u32 = 1160;
pub const MSR_IA32_VMX_CR4_FIXED1: u32 = 1161;
pub const MSR_IA32_VMX_VMCS_ENUM: u32 = 1162;
pub const MSR_IA32_VMX_PROCBASED_CTLS2: u32 = 1163;
pub const MSR_IA32_VMX_EPT_VPID_CAP: u32 = 1164;
pub const MSR_IA32_VMX_TRUE_PINBASED_CTLS: u32 = 1165;
pub const MSR_IA32_VMX_TRUE_PROCBASED_CTLS: u32 = 1166;
pub const MSR_IA32_VMX_TRUE_EXIT_CTLS: u32 = 1167;
pub const MSR_IA32_VMX_TRUE_ENTRY_CTLS: u32 = 1168;
pub const MSR_IA32_VMX_VMFUNC: u32 = 1169;
pub const MSR_IA32_VMX_PROCBASED_CTLS3: u32 = 1170;
pub const VMX_BASIC_VMCS_SIZE_SHIFT: u32 = 32;
pub const VMX_BASIC_TRUE_CTLS: u64 = 36028797018963968;
pub const VMX_BASIC_64: u64 = 281474976710656;
pub const VMX_BASIC_MEM_TYPE_SHIFT: u32 = 50;
pub const VMX_BASIC_MEM_TYPE_MASK: u64 = 16888498602639360;
pub const VMX_BASIC_MEM_TYPE_WB: u32 = 6;
pub const VMX_BASIC_INOUT: u64 = 18014398509481984;
pub const MSR_IA32_L3_QOS_CFG: u32 = 3201;
pub const MSR_IA32_L2_QOS_CFG: u32 = 3202;
pub const MSR_IA32_QM_EVTSEL: u32 = 3213;
pub const MSR_IA32_QM_CTR: u32 = 3214;
pub const MSR_IA32_PQR_ASSOC: u32 = 3215;
pub const MSR_IA32_L3_CBM_BASE: u32 = 3216;
pub const MSR_IA32_L2_CBM_BASE: u32 = 3344;
pub const MSR_IA32_MBA_THRTL_BASE: u32 = 3408;
pub const MSR_IA32_MBA_BW_BASE: u32 = 3221225984;
pub const MSR_IA32_SMBA_BW_BASE: u32 = 3221226112;
pub const MSR_IA32_EVT_CFG_BASE: u32 = 3221226496;
pub const MSR_IA32_VMX_MISC_INTEL_PT: u32 = 16384;
pub const MSR_IA32_VMX_MISC_VMWRITE_SHADOW_RO_FIELDS: u32 = 536870912;
pub const MSR_IA32_VMX_MISC_PREEMPTION_TIMER_SCALE: u32 = 31;
pub const MSR_VM_CR: u32 = 3221291284;
pub const MSR_VM_IGNNE: u32 = 3221291285;
pub const MSR_VM_HSAVE_PA: u32 = 3221291287;
pub const SVM_VM_CR_VALID_MASK: u32 = 31;
pub const SVM_VM_CR_SVM_LOCK_MASK: u32 = 8;
pub const SVM_VM_CR_SVM_DIS_MASK: u32 = 16;
pub const MSR_IA32_HW_FEEDBACK_PTR: u32 = 6096;
pub const MSR_IA32_HW_FEEDBACK_CONFIG: u32 = 6097;
pub const MSR_IA32_XAPIC_DISABLE_STATUS: u32 = 189;
pub const ORC_REG_UNDEFINED: u32 = 0;
pub const ORC_REG_PREV_SP: u32 = 1;
pub const ORC_REG_DX: u32 = 2;
pub const ORC_REG_DI: u32 = 3;
pub const ORC_REG_BP: u32 = 4;
pub const ORC_REG_SP: u32 = 5;
pub const ORC_REG_R10: u32 = 6;
pub const ORC_REG_R13: u32 = 7;
pub const ORC_REG_BP_INDIRECT: u32 = 8;
pub const ORC_REG_SP_INDIRECT: u32 = 9;
pub const ORC_REG_MAX: u32 = 15;
pub const ORC_TYPE_UNDEFINED: u32 = 0;
pub const ORC_TYPE_END_OF_STACK: u32 = 1;
pub const ORC_TYPE_CALL: u32 = 2;
pub const ORC_TYPE_REGS: u32 = 3;
pub const ORC_TYPE_REGS_PARTIAL: u32 = 4;
pub const RET_DEPTH_SHIFT: u32 = 5;
pub const RSB_RET_STUFF_LOOPS: u32 = 16;
pub const RET_DEPTH_INIT: i64 = -9223372036854775808;
pub const RET_DEPTH_INIT_FROM_CALL: i64 = -288230376151711744;
pub const RET_DEPTH_CREDIT: i32 = -1;
pub const KVM_STEAL_TIME_preempted: u32 = 16;
pub const pt_regs_bx: u32 = 40;
pub const pt_regs_cx: u32 = 88;
pub const pt_regs_dx: u32 = 96;
pub const pt_regs_sp: u32 = 152;
pub const pt_regs_bp: u32 = 32;
pub const pt_regs_si: u32 = 104;
pub const pt_regs_di: u32 = 112;
pub const pt_regs_r8: u32 = 72;
pub const pt_regs_r9: u32 = 64;
pub const pt_regs_r10: u32 = 56;
pub const pt_regs_r11: u32 = 48;
pub const pt_regs_r12: u32 = 24;
pub const pt_regs_r13: u32 = 16;
pub const pt_regs_r14: u32 = 8;
pub const pt_regs_r15: u32 = 0;
pub const pt_regs_flags: u32 = 144;
pub const saved_context_cr0: u32 = 200;
pub const saved_context_cr2: u32 = 208;
pub const saved_context_cr3: u32 = 216;
pub const saved_context_cr4: u32 = 224;
pub const saved_context_gdt_desc: u32 = 266;
pub const FIXED_stack_canary: u32 = 40;
pub const TASK_threadsp: u32 = 9304;
pub const TASK_stack_canary: u32 = 2472;
pub const pbe_address: u32 = 0;
pub const pbe_orig_address: u32 = 8;
pub const pbe_next: u32 = 16;
pub const IA32_SIGCONTEXT_ax: u32 = 44;
pub const IA32_SIGCONTEXT_bx: u32 = 32;
pub const IA32_SIGCONTEXT_cx: u32 = 40;
pub const IA32_SIGCONTEXT_dx: u32 = 36;
pub const IA32_SIGCONTEXT_si: u32 = 20;
pub const IA32_SIGCONTEXT_di: u32 = 16;
pub const IA32_SIGCONTEXT_bp: u32 = 24;
pub const IA32_SIGCONTEXT_sp: u32 = 28;
pub const IA32_SIGCONTEXT_ip: u32 = 56;
pub const IA32_RT_SIGFRAME_sigcontext: u32 = 164;
pub const XEN_vcpu_info_mask: u32 = 1;
pub const XEN_vcpu_info_pending: u32 = 0;
pub const XEN_vcpu_info_arch_cr2: u32 = 16;
pub const TDX_MODULE_rcx: u32 = 0;
pub const TDX_MODULE_rdx: u32 = 8;
pub const TDX_MODULE_r8: u32 = 16;
pub const TDX_MODULE_r9: u32 = 24;
pub const TDX_MODULE_r10: u32 = 32;
pub const TDX_MODULE_r11: u32 = 40;
pub const TDX_MODULE_r12: u32 = 48;
pub const TDX_MODULE_r13: u32 = 56;
pub const TDX_MODULE_r14: u32 = 64;
pub const TDX_MODULE_r15: u32 = 72;
pub const TDX_MODULE_rbx: u32 = 80;
pub const TDX_MODULE_rdi: u32 = 88;
pub const TDX_MODULE_rsi: u32 = 96;
pub const BP_scratch: u32 = 484;
pub const BP_secure_boot: u32 = 492;
pub const BP_loadflags: u32 = 529;
pub const BP_hardware_subarch: u32 = 572;
pub const BP_version: u32 = 518;
pub const BP_kernel_alignment: u32 = 560;
pub const BP_init_size: u32 = 608;
pub const BP_pref_address: u32 = 600;
pub const PTREGS_SIZE: u32 = 168;
pub const TLB_STATE_user_pcid_flush_mask: u32 = 22;
pub const CPU_ENTRY_AREA_entry_stack: u32 = 4096;
pub const SIZEOF_entry_stack: u32 = 4096;
pub const MASK_entry_stack: i32 = -4096;
pub const TSS_sp0: u32 = 4;
pub const TSS_sp1: u32 = 12;
pub const TSS_sp2: u32 = 20;
pub const X86_top_of_stack: u32 = 24;
pub const X86_current_task: u32 = 0;
pub const X86_call_depth: u32 = 16;
pub const ARIA_CTX_enc_key: u32 = 0;
pub const ARIA_CTX_dec_key: u32 = 272;
pub const ARIA_CTX_rounds: u32 = 544;
pub const RETPOLINE_THUNK_SIZE: u32 = 32;
pub const RSB_CLEAR_LOOPS: u32 = 32;
pub const ANNOTATE_RETPOLINE_SAFE: &[u8; 70usize] =
    b"999:\n\t.pushsection .discard.retpoline_safe\n\t.long 999b\n\t.popsection\n\t\0";
pub const GDT_ENTRY_BOOT_CS: u32 = 2;
pub const GDT_ENTRY_BOOT_DS: u32 = 3;
pub const GDT_ENTRY_BOOT_TSS: u32 = 4;
pub const __BOOT_CS: u32 = 16;
pub const __BOOT_DS: u32 = 24;
pub const __BOOT_TSS: u32 = 32;
pub const SEGMENT_RPL_MASK: u32 = 3;
pub const USER_SEGMENT_RPL_MASK: u32 = 2;
pub const USER_RPL: u32 = 3;
pub const SEGMENT_TI_MASK: u32 = 4;
pub const SEGMENT_LDT: u32 = 4;
pub const SEGMENT_GDT: u32 = 0;
pub const GDT_ENTRY_INVALID_SEG: u32 = 0;
pub const GDT_ENTRY_KERNEL32_CS: u32 = 1;
pub const GDT_ENTRY_KERNEL_CS: u32 = 2;
pub const GDT_ENTRY_KERNEL_DS: u32 = 3;
pub const GDT_ENTRY_DEFAULT_USER32_CS: u32 = 4;
pub const GDT_ENTRY_DEFAULT_USER_DS: u32 = 5;
pub const GDT_ENTRY_DEFAULT_USER_CS: u32 = 6;
pub const GDT_ENTRY_TSS: u32 = 8;
pub const GDT_ENTRY_LDT: u32 = 10;
pub const GDT_ENTRY_TLS_MIN: u32 = 12;
pub const GDT_ENTRY_TLS_MAX: u32 = 14;
pub const GDT_ENTRY_CPUNODE: u32 = 15;
pub const GDT_ENTRIES: u32 = 16;
pub const __KERNEL32_CS: u32 = 8;
pub const __KERNEL_CS: u32 = 16;
pub const __KERNEL_DS: u32 = 24;
pub const __USER32_CS: u32 = 35;
pub const __USER_DS: u32 = 43;
pub const __USER_CS: u32 = 51;
pub const __CPUNODE_SEG: u32 = 123;
pub const IDT_ENTRIES: u32 = 256;
pub const NUM_EXCEPTION_VECTORS: u32 = 32;
pub const EXCEPTION_ERRCODE_MASK: u32 = 537033984;
pub const GDT_SIZE: u32 = 128;
pub const GDT_ENTRY_TLS_ENTRIES: u32 = 3;
pub const TLS_SIZE: u32 = 24;
pub const VDSO_CPUNODE_BITS: u32 = 12;
pub const VDSO_CPUNODE_MASK: u32 = 4095;
pub const EARLY_IDT_HANDLER_SIZE: u32 = 9;
pub const XEN_EARLY_IDT_HANDLER_SIZE: u32 = 8;
pub const _DESC_ACCESSED: u32 = 1;
pub const _DESC_DATA_WRITABLE: u32 = 2;
pub const _DESC_CODE_READABLE: u32 = 2;
pub const _DESC_DATA_EXPAND_DOWN: u32 = 4;
pub const _DESC_CODE_CONFORMING: u32 = 4;
pub const _DESC_CODE_EXECUTABLE: u32 = 8;
pub const _DESC_S: u32 = 16;
pub const _DESC_PRESENT: u32 = 128;
pub const _DESC_LONG_CODE: u32 = 8192;
pub const _DESC_DB: u32 = 16384;
pub const _DESC_GRANULARITY_4K: u32 = 32768;
pub const _DESC_DATA: u32 = 147;
pub const _DESC_CODE: u32 = 155;
pub const DESC_DATA16: u32 = 147;
pub const DESC_CODE16: u32 = 155;
pub const DESC_DATA32: u32 = 49299;
pub const DESC_DATA32_BIOS: u32 = 16531;
pub const DESC_CODE32: u32 = 49307;
pub const DESC_CODE32_BIOS: u32 = 16539;
pub const DESC_DATA64: u32 = 49299;
pub const DESC_CODE64: u32 = 41115;
pub const BOOT_IDT_ENTRIES: u32 = 32;
pub const AR_TYPE_RODATA: u32 = 0;
pub const AR_TYPE_RWDATA: u32 = 512;
pub const AR_TYPE_RODATA_EXPDOWN: u32 = 1024;
pub const AR_TYPE_RWDATA_EXPDOWN: u32 = 1536;
pub const AR_TYPE_XOCODE: u32 = 2048;
pub const AR_TYPE_XRCODE: u32 = 2560;
pub const AR_TYPE_XOCODE_CONF: u32 = 3072;
pub const AR_TYPE_XRCODE_CONF: u32 = 3584;
pub const AR_TYPE_MASK: u32 = 3584;
pub const AR_DPL0: u32 = 0;
pub const AR_DPL3: u32 = 24576;
pub const AR_DPL_MASK: u32 = 24576;
pub const AR_A: u32 = 256;
pub const AR_S: u32 = 4096;
pub const AR_P: u32 = 32768;
pub const AR_AVL: u32 = 1048576;
pub const AR_L: u32 = 2097152;
pub const AR_DB: u32 = 4194304;
pub const AR_G: u32 = 8388608;
pub const PAGE_SHIFT: u32 = 12;
pub const HUGE_MAX_HSTATE: u32 = 2;
pub const KASAN_STACK_ORDER: u32 = 0;
pub const THREAD_SIZE_ORDER: u32 = 2;
pub const EXCEPTION_STACK_ORDER: u32 = 1;
pub const IRQ_STACK_ORDER: u32 = 2;
pub const IST_INDEX_DF: u32 = 0;
pub const IST_INDEX_NMI: u32 = 1;
pub const IST_INDEX_DB: u32 = 2;
pub const IST_INDEX_MCE: u32 = 3;
pub const IST_INDEX_VC: u32 = 4;
pub const __PHYSICAL_MASK_SHIFT: u32 = 52;
pub const KERNEL_IMAGE_SIZE: u32 = 1073741824;
pub const _PAGE_BIT_PRESENT: u32 = 0;
pub const _PAGE_BIT_RW: u32 = 1;
pub const _PAGE_BIT_USER: u32 = 2;
pub const _PAGE_BIT_PWT: u32 = 3;
pub const _PAGE_BIT_PCD: u32 = 4;
pub const _PAGE_BIT_ACCESSED: u32 = 5;
pub const _PAGE_BIT_DIRTY: u32 = 6;
pub const _PAGE_BIT_PSE: u32 = 7;
pub const _PAGE_BIT_PAT: u32 = 7;
pub const _PAGE_BIT_GLOBAL: u32 = 8;
pub const _PAGE_BIT_SOFTW1: u32 = 9;
pub const _PAGE_BIT_SOFTW2: u32 = 10;
pub const _PAGE_BIT_SOFTW3: u32 = 11;
pub const _PAGE_BIT_PAT_LARGE: u32 = 12;
pub const _PAGE_BIT_SOFTW4: u32 = 57;
pub const _PAGE_BIT_SOFTW5: u32 = 58;
pub const _PAGE_BIT_PKEY_BIT0: u32 = 59;
pub const _PAGE_BIT_PKEY_BIT1: u32 = 60;
pub const _PAGE_BIT_PKEY_BIT2: u32 = 61;
pub const _PAGE_BIT_PKEY_BIT3: u32 = 62;
pub const _PAGE_BIT_NX: u32 = 63;
pub const _PAGE_BIT_SPECIAL: u32 = 9;
pub const _PAGE_BIT_CPA_TEST: u32 = 9;
pub const _PAGE_BIT_UFFD_WP: u32 = 10;
pub const _PAGE_BIT_SOFT_DIRTY: u32 = 11;
pub const _PAGE_BIT_DEVMAP: u32 = 57;
pub const _PAGE_BIT_SAVED_DIRTY: u32 = 58;
pub const _PAGE_BIT_PROTNONE: u32 = 8;
pub const SECTION_SIZE_BITS: u32 = 27;
pub const SHARED_KERNEL_PMD: u32 = 0;
pub const PTRS_PER_PGD: u32 = 512;
pub const P4D_SHIFT: u32 = 39;
pub const MAX_PTRS_PER_P4D: u32 = 512;
pub const MAX_POSSIBLE_PHYSMEM_BITS: u32 = 52;
pub const PUD_SHIFT: u32 = 30;
pub const PTRS_PER_PUD: u32 = 512;
pub const PMD_SHIFT: u32 = 21;
pub const PTRS_PER_PMD: u32 = 512;
pub const PTRS_PER_PTE: u32 = 512;
pub const GUARD_HOLE_PGD_ENTRY: i32 = -256;
pub const LDT_PGD_ENTRY: i32 = -240;
pub const __VMALLOC_BASE_L4: i64 = -60473139527680;
pub const __VMALLOC_BASE_L5: i64 = -27021597764222976;
pub const VMALLOC_SIZE_TB_L4: u32 = 32;
pub const VMALLOC_SIZE_TB_L5: u32 = 12800;
pub const __VMEMMAP_BASE_L4: i64 = -24189255811072;
pub const __VMEMMAP_BASE_L5: i64 = -12384898975268864;
pub const EARLY_DYNAMIC_PAGE_TABLES: u32 = 64;
pub const PGD_ALLOWED_BITS: i32 = -1;
pub const PARAVIRT_CALL : & [u8 ; 94usize] = b"999:\n\t.pushsection .discard.retpoline_safe\n\t.long 999b\n\t.popsection\n\tcall *%[paravirt_opptr];\0" ;
pub const ASM_UD2: &[u8; 17usize] = b".byte 0x0f, 0x0b\0";
pub const INSN_UD2: u32 = 2831;
pub const LEN_UD2: u32 = 2;
pub const CUT_HERE: &[u8; 38usize] = b"------------[ cut here ]------------\n\0";
pub const BUGFLAG_WARNING: u32 = 1;
pub const BUGFLAG_ONCE: u32 = 2;
pub const BUGFLAG_DONE: u32 = 4;
pub const BUGFLAG_NO_CUT_HERE: u32 = 8;
pub const PANIC_CPU_INVALID: i32 = -1;
pub const TAINT_PROPRIETARY_MODULE: u32 = 0;
pub const TAINT_FORCED_MODULE: u32 = 1;
pub const TAINT_CPU_OUT_OF_SPEC: u32 = 2;
pub const TAINT_FORCED_RMMOD: u32 = 3;
pub const TAINT_MACHINE_CHECK: u32 = 4;
pub const TAINT_BAD_PAGE: u32 = 5;
pub const TAINT_USER: u32 = 6;
pub const TAINT_DIE: u32 = 7;
pub const TAINT_OVERRIDDEN_ACPI_TABLE: u32 = 8;
pub const TAINT_WARN: u32 = 9;
pub const TAINT_CRAP: u32 = 10;
pub const TAINT_FIRMWARE_WORKAROUND: u32 = 11;
pub const TAINT_OOT_MODULE: u32 = 12;
pub const TAINT_UNSIGNED_MODULE: u32 = 13;
pub const TAINT_SOFTLOCKUP: u32 = 14;
pub const TAINT_LIVEPATCH: u32 = 15;
pub const TAINT_AUX: u32 = 16;
pub const TAINT_RANDSTRUCT: u32 = 17;
pub const TAINT_TEST: u32 = 18;
pub const TAINT_FLAGS_COUNT: u32 = 19;
pub const TAINT_FLAGS_MAX: u32 = 524287;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const UINT_MAX: i32 = -1;
pub const ULONG_MAX: i32 = -1;
pub const ULLONG_MAX: i32 = -1;
pub const UINTPTR_MAX: i32 = -1;
pub const _BITOPS_LONG_SHIFT: u32 = 6;
pub const REG_IN: &[u8; 2usize] = b"D\0";
pub const REG_OUT: &[u8; 2usize] = b"a\0";
pub const BITOP_LE_SWIZZLE: u32 = 0;
pub const STACK_MAGIC: u32 = 3735928559;
pub const READ: u32 = 0;
pub const WRITE: u32 = 1;
pub const ERESTARTSYS: u32 = 512;
pub const ERESTARTNOINTR: u32 = 513;
pub const ERESTARTNOHAND: u32 = 514;
pub const ENOIOCTLCMD: u32 = 515;
pub const ERESTART_RESTARTBLOCK: u32 = 516;
pub const EPROBE_DEFER: u32 = 517;
pub const EOPENSTALE: u32 = 518;
pub const ENOPARAM: u32 = 519;
pub const EBADHANDLE: u32 = 521;
pub const ENOTSYNC: u32 = 522;
pub const EBADCOOKIE: u32 = 523;
pub const ENOTSUPP: u32 = 524;
pub const ETOOSMALL: u32 = 525;
pub const ESERVERFAULT: u32 = 526;
pub const EBADTYPE: u32 = 527;
pub const EJUKEBOX: u32 = 528;
pub const EIOCBQUEUED: u32 = 529;
pub const ERECALLCONFLICT: u32 = 530;
pub const ENOGRACE: u32 = 531;
pub const __HAVE_ARCH_MEMCPY: u32 = 1;
pub const __HAVE_ARCH_MEMCPY_FLUSHCACHE: u32 = 1;
pub const BITMAP_MEM_ALIGNMENT: u32 = 8;
pub const BITMAP_MEM_MASK: u32 = 7;
pub const __X86_CASE_B: u32 = 1;
pub const __X86_CASE_W: u32 = 2;
pub const __X86_CASE_L: u32 = 4;
pub const __X86_CASE_Q: u32 = 8;
pub const ___GFP_DMA: u32 = 1;
pub const ___GFP_HIGHMEM: u32 = 2;
pub const ___GFP_DMA32: u32 = 4;
pub const ___GFP_MOVABLE: u32 = 8;
pub const ___GFP_RECLAIMABLE: u32 = 16;
pub const ___GFP_HIGH: u32 = 32;
pub const ___GFP_IO: u32 = 64;
pub const ___GFP_FS: u32 = 128;
pub const ___GFP_ZERO: u32 = 256;
pub const ___GFP_DIRECT_RECLAIM: u32 = 1024;
pub const ___GFP_KSWAPD_RECLAIM: u32 = 2048;
pub const ___GFP_WRITE: u32 = 4096;
pub const ___GFP_NOWARN: u32 = 8192;
pub const ___GFP_RETRY_MAYFAIL: u32 = 16384;
pub const ___GFP_NOFAIL: u32 = 32768;
pub const ___GFP_NORETRY: u32 = 65536;
pub const ___GFP_MEMALLOC: u32 = 131072;
pub const ___GFP_COMP: u32 = 262144;
pub const ___GFP_NOMEMALLOC: u32 = 524288;
pub const ___GFP_HARDWALL: u32 = 1048576;
pub const ___GFP_THISNODE: u32 = 2097152;
pub const ___GFP_ACCOUNT: u32 = 4194304;
pub const ___GFP_ZEROTAGS: u32 = 8388608;
pub const ___GFP_SKIP_ZERO: u32 = 0;
pub const ___GFP_SKIP_KASAN: u32 = 0;
pub const ___GFP_NOLOCKDEP: u32 = 0;
pub const NODES_SHIFT: u32 = 10;
pub const MAX_NUMNODES: u32 = 1024;
pub const NUMA_NO_NODE: i32 = -1;
pub const NUMA_NO_MEMBLK: i32 = -1;
pub const ENCODE_FRAME_POINTER: &[u8; 20usize] = b"lea 1(%rsp), %rbp\n\t\0";
pub const PV_SAVE_ALL_CALLER_REGS: &[u8; 79usize] =
    b"push %rcx;push %rdx;push %rsi;push %rdi;push %r8;push %r9;push %r10;push %r11;\0";
pub const PV_RESTORE_ALL_CALLER_REGS: &[u8; 71usize] =
    b"pop %r11;pop %r10;pop %r9;pop %r8;pop %rdi;pop %rsi;pop %rdx;pop %rcx;\0";
pub const __HAVE_ARCH_GATE_AREA: u32 = 1;
pub const TOP_OF_KERNEL_STACK_PADDING: u32 = 0;
pub const FRAME_SIZE: u32 = 168;
pub const PTRACE_GETREGS: u32 = 12;
pub const PTRACE_SETREGS: u32 = 13;
pub const PTRACE_GETFPREGS: u32 = 14;
pub const PTRACE_SETFPREGS: u32 = 15;
pub const PTRACE_GETFPXREGS: u32 = 18;
pub const PTRACE_SETFPXREGS: u32 = 19;
pub const PTRACE_OLDSETOPTIONS: u32 = 21;
pub const PTRACE_GET_THREAD_AREA: u32 = 25;
pub const PTRACE_SET_THREAD_AREA: u32 = 26;
pub const PTRACE_ARCH_PRCTL: u32 = 30;
pub const PTRACE_SYSEMU: u32 = 31;
pub const PTRACE_SYSEMU_SINGLESTEP: u32 = 32;
pub const PTRACE_SINGLEBLOCK: u32 = 33;
pub const LDT_ENTRIES: u32 = 8192;
pub const LDT_ENTRY_SIZE: u32 = 8;
pub const MODIFY_LDT_CONTENTS_DATA: u32 = 0;
pub const MODIFY_LDT_CONTENTS_STACK: u32 = 1;
pub const MODIFY_LDT_CONTENTS_CODE: u32 = 2;
pub const NR_REG_ARGUMENTS: u32 = 6;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const X86_FXSR_MAGIC: u32 = 0;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const TRACEPOINT_DEFS_H: u32 = 1;
pub const MXCSR_DEFAULT: u32 = 8064;
pub const NVMXINTS: u32 = 5;
pub const VMX_FEATURE_INTR_EXITING: u32 = 0;
pub const VMX_FEATURE_NMI_EXITING: u32 = 3;
pub const VMX_FEATURE_VIRTUAL_NMIS: u32 = 5;
pub const VMX_FEATURE_PREEMPTION_TIMER: u32 = 6;
pub const VMX_FEATURE_POSTED_INTR: u32 = 7;
pub const VMX_FEATURE_INVVPID: u32 = 16;
pub const VMX_FEATURE_EPT_EXECUTE_ONLY: u32 = 17;
pub const VMX_FEATURE_EPT_AD: u32 = 18;
pub const VMX_FEATURE_EPT_1GB: u32 = 19;
pub const VMX_FEATURE_FLEXPRIORITY: u32 = 24;
pub const VMX_FEATURE_APICV: u32 = 25;
pub const VMX_FEATURE_EPTP_SWITCHING: u32 = 28;
pub const VMX_FEATURE_INTR_WINDOW_EXITING: u32 = 34;
pub const VMX_FEATURE_USE_TSC_OFFSETTING: u32 = 35;
pub const VMX_FEATURE_HLT_EXITING: u32 = 39;
pub const VMX_FEATURE_INVLPG_EXITING: u32 = 41;
pub const VMX_FEATURE_MWAIT_EXITING: u32 = 42;
pub const VMX_FEATURE_RDPMC_EXITING: u32 = 43;
pub const VMX_FEATURE_RDTSC_EXITING: u32 = 44;
pub const VMX_FEATURE_CR3_LOAD_EXITING: u32 = 47;
pub const VMX_FEATURE_CR3_STORE_EXITING: u32 = 48;
pub const VMX_FEATURE_TERTIARY_CONTROLS: u32 = 49;
pub const VMX_FEATURE_CR8_LOAD_EXITING: u32 = 51;
pub const VMX_FEATURE_CR8_STORE_EXITING: u32 = 52;
pub const VMX_FEATURE_VIRTUAL_TPR: u32 = 53;
pub const VMX_FEATURE_NMI_WINDOW_EXITING: u32 = 54;
pub const VMX_FEATURE_MOV_DR_EXITING: u32 = 55;
pub const VMX_FEATURE_UNCOND_IO_EXITING: u32 = 56;
pub const VMX_FEATURE_USE_IO_BITMAPS: u32 = 57;
pub const VMX_FEATURE_MONITOR_TRAP_FLAG: u32 = 59;
pub const VMX_FEATURE_USE_MSR_BITMAPS: u32 = 60;
pub const VMX_FEATURE_MONITOR_EXITING: u32 = 61;
pub const VMX_FEATURE_PAUSE_EXITING: u32 = 62;
pub const VMX_FEATURE_SEC_CONTROLS: u32 = 63;
pub const VMX_FEATURE_VIRT_APIC_ACCESSES: u32 = 64;
pub const VMX_FEATURE_EPT: u32 = 65;
pub const VMX_FEATURE_DESC_EXITING: u32 = 66;
pub const VMX_FEATURE_RDTSCP: u32 = 67;
pub const VMX_FEATURE_VIRTUAL_X2APIC: u32 = 68;
pub const VMX_FEATURE_VPID: u32 = 69;
pub const VMX_FEATURE_WBINVD_EXITING: u32 = 70;
pub const VMX_FEATURE_UNRESTRICTED_GUEST: u32 = 71;
pub const VMX_FEATURE_APIC_REGISTER_VIRT: u32 = 72;
pub const VMX_FEATURE_VIRT_INTR_DELIVERY: u32 = 73;
pub const VMX_FEATURE_PAUSE_LOOP_EXITING: u32 = 74;
pub const VMX_FEATURE_RDRAND_EXITING: u32 = 75;
pub const VMX_FEATURE_INVPCID: u32 = 76;
pub const VMX_FEATURE_VMFUNC: u32 = 77;
pub const VMX_FEATURE_SHADOW_VMCS: u32 = 78;
pub const VMX_FEATURE_ENCLS_EXITING: u32 = 79;
pub const VMX_FEATURE_RDSEED_EXITING: u32 = 80;
pub const VMX_FEATURE_PAGE_MOD_LOGGING: u32 = 81;
pub const VMX_FEATURE_EPT_VIOLATION_VE: u32 = 82;
pub const VMX_FEATURE_PT_CONCEAL_VMX: u32 = 83;
pub const VMX_FEATURE_XSAVES: u32 = 84;
pub const VMX_FEATURE_MODE_BASED_EPT_EXEC: u32 = 86;
pub const VMX_FEATURE_PT_USE_GPA: u32 = 88;
pub const VMX_FEATURE_TSC_SCALING: u32 = 89;
pub const VMX_FEATURE_USR_WAIT_PAUSE: u32 = 90;
pub const VMX_FEATURE_ENCLV_EXITING: u32 = 92;
pub const VMX_FEATURE_BUS_LOCK_DETECTION: u32 = 94;
pub const VMX_FEATURE_NOTIFY_VM_EXITING: u32 = 95;
pub const VMX_FEATURE_IPI_VIRT: u32 = 100;
pub const NET_IP_ALIGN: u32 = 0;
pub const HBP_NUM: u32 = 4;
pub const ARCH_MIN_MMSTRUCT_ALIGN: u32 = 0;
pub const X86_VENDOR_INTEL: u32 = 0;
pub const X86_VENDOR_CYRIX: u32 = 1;
pub const X86_VENDOR_AMD: u32 = 2;
pub const X86_VENDOR_UMC: u32 = 3;
pub const X86_VENDOR_CENTAUR: u32 = 5;
pub const X86_VENDOR_TRANSMETA: u32 = 7;
pub const X86_VENDOR_NSC: u32 = 8;
pub const X86_VENDOR_HYGON: u32 = 9;
pub const X86_VENDOR_ZHAOXIN: u32 = 10;
pub const X86_VENDOR_VORTEX: u32 = 11;
pub const X86_VENDOR_NUM: u32 = 12;
pub const X86_VENDOR_UNKNOWN: u32 = 255;
pub const IO_BITMAP_BITS: u32 = 65536;
pub const IO_BITMAP_BYTES: u32 = 8192;
pub const HAVE_ARCH_PICK_MMAP_LAYOUT: u32 = 1;
pub const BASE_PREFETCH: &[u8; 15usize] = b"prefetcht0 %P1\0";
pub const X86_CAP_FMT_NUM: &[u8; 6usize] = b"%d:%d\0";
pub const X86_CAP_FMT: &[u8; 3usize] = b"%s\0";
pub const MAX_CPU_FEATURES: u32 = 704;
pub const CPU_FEATURE_TYPEFMT: &[u8; 26usize] = b"x86,ven%04Xfam%04Xmod%04X\0";
pub const TIF_NOTIFY_RESUME: u32 = 1;
pub const TIF_SIGPENDING: u32 = 2;
pub const TIF_NEED_RESCHED: u32 = 3;
pub const TIF_SINGLESTEP: u32 = 4;
pub const TIF_SSBD: u32 = 5;
pub const TIF_SPEC_IB: u32 = 9;
pub const TIF_SPEC_L1D_FLUSH: u32 = 10;
pub const TIF_USER_RETURN_NOTIFY: u32 = 11;
pub const TIF_UPROBE: u32 = 12;
pub const TIF_PATCH_PENDING: u32 = 13;
pub const TIF_NEED_FPU_LOAD: u32 = 14;
pub const TIF_NOCPUID: u32 = 15;
pub const TIF_NOTSC: u32 = 16;
pub const TIF_NOTIFY_SIGNAL: u32 = 17;
pub const TIF_MEMDIE: u32 = 20;
pub const TIF_POLLING_NRFLAG: u32 = 21;
pub const TIF_IO_BITMAP: u32 = 22;
pub const TIF_SPEC_FORCE_UPDATE: u32 = 23;
pub const TIF_FORCED_TF: u32 = 24;
pub const TIF_BLOCKSTEP: u32 = 25;
pub const TIF_LAZY_MMU_UPDATES: u32 = 27;
pub const TIF_ADDR32: u32 = 29;
pub const _TIF_NOTIFY_RESUME: u32 = 2;
pub const _TIF_SIGPENDING: u32 = 4;
pub const _TIF_NEED_RESCHED: u32 = 8;
pub const _TIF_SINGLESTEP: u32 = 16;
pub const _TIF_SSBD: u32 = 32;
pub const _TIF_SPEC_IB: u32 = 512;
pub const _TIF_SPEC_L1D_FLUSH: u32 = 1024;
pub const _TIF_USER_RETURN_NOTIFY: u32 = 2048;
pub const _TIF_UPROBE: u32 = 4096;
pub const _TIF_PATCH_PENDING: u32 = 8192;
pub const _TIF_NEED_FPU_LOAD: u32 = 16384;
pub const _TIF_NOCPUID: u32 = 32768;
pub const _TIF_NOTSC: u32 = 65536;
pub const _TIF_NOTIFY_SIGNAL: u32 = 131072;
pub const _TIF_POLLING_NRFLAG: u32 = 2097152;
pub const _TIF_IO_BITMAP: u32 = 4194304;
pub const _TIF_SPEC_FORCE_UPDATE: u32 = 8388608;
pub const _TIF_FORCED_TF: u32 = 16777216;
pub const _TIF_BLOCKSTEP: u32 = 33554432;
pub const _TIF_LAZY_MMU_UPDATES: u32 = 134217728;
pub const _TIF_ADDR32: u32 = 536870912;
pub const _TIF_WORK_CTXSW_BASE: u32 = 42041376;
pub const _TIF_WORK_CTXSW: u32 = 42041888;
pub const _TIF_WORK_CTXSW_PREV: u32 = 46238240;
pub const _TIF_WORK_CTXSW_NEXT: u32 = 42041888;
pub const TS_COMPAT: u32 = 2;
pub const TS_I386_REGS_POKED: u32 = 4;
pub const PAGE_POISON: u32 = 170;
pub const RED_INACTIVE: u64 = 718624318471594843;
pub const RED_ACTIVE: i64 = -2863912482255763264;
pub const SLUB_RED_INACTIVE: u32 = 187;
pub const SLUB_RED_ACTIVE: u32 = 204;
pub const POISON_INUSE: u32 = 90;
pub const POISON_FREE: u32 = 107;
pub const POISON_END: u32 = 165;
pub const POISON_FREE_INITMEM: u32 = 204;
pub const JBD_POISON_FREE: u32 = 91;
pub const JBD2_POISON_FREE: u32 = 92;
pub const POOL_POISON_FREED: u32 = 167;
pub const POOL_POISON_ALLOCATED: u32 = 169;
pub const ATM_POISON_FREE: u32 = 18;
pub const ATM_POISON: u32 = 3735928559;
pub const MUTEX_DEBUG_INIT: u32 = 17;
pub const MUTEX_DEBUG_FREE: u32 = 34;
pub const KEY_DESTROY: u32 = 189;
pub const STARTUP_READ_APICID: u32 = 2147483648;
pub const STARTUP_PARALLEL_MASK: u32 = 4278190080;
pub const force_read_lock_recursive: u32 = 0;
pub const SINGLE_DEPTH_NESTING: u32 = 1;
pub const LOCK_SECTION_END: &[u8; 12usize] = b".previous\n\t\0";
pub const RWLOCK_MAGIC: u32 = 3736018669;
pub const SPIN_THRESHOLD: u32 = 32768;
pub const _Q_PENDING_LOOPS: u32 = 512;
pub const _QW_WAITING: u32 = 256;
pub const _QW_LOCKED: u32 = 255;
pub const _QW_WMASK: u32 = 511;
pub const _QR_SHIFT: u32 = 9;
pub const _QR_BIAS: u32 = 512;
pub const STAT_HAVE_NSEC: u32 = 1;
pub const S_IFMT: u32 = 61440;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFLNK: u32 = 40960;
pub const S_IFREG: u32 = 32768;
pub const S_IFBLK: u32 = 24576;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFIFO: u32 = 4096;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const STATX_TYPE: u32 = 1;
pub const STATX_MODE: u32 = 2;
pub const STATX_NLINK: u32 = 4;
pub const STATX_UID: u32 = 8;
pub const STATX_GID: u32 = 16;
pub const STATX_ATIME: u32 = 32;
pub const STATX_MTIME: u32 = 64;
pub const STATX_CTIME: u32 = 128;
pub const STATX_INO: u32 = 256;
pub const STATX_SIZE: u32 = 512;
pub const STATX_BLOCKS: u32 = 1024;
pub const STATX_BASIC_STATS: u32 = 2047;
pub const STATX_BTIME: u32 = 2048;
pub const STATX_MNT_ID: u32 = 4096;
pub const STATX_DIOALIGN: u32 = 8192;
pub const STATX_MNT_ID_UNIQUE: u32 = 16384;
pub const STATX__RESERVED: u32 = 2147483648;
pub const STATX_ATTR_COMPRESSED: u32 = 4;
pub const STATX_ATTR_IMMUTABLE: u32 = 16;
pub const STATX_ATTR_APPEND: u32 = 32;
pub const STATX_ATTR_NODUMP: u32 = 64;
pub const STATX_ATTR_ENCRYPTED: u32 = 2048;
pub const STATX_ATTR_AUTOMOUNT: u32 = 4096;
pub const STATX_ATTR_MOUNT_ROOT: u32 = 8192;
pub const STATX_ATTR_VERITY: u32 = 1048576;
pub const STATX_ATTR_DAX: u32 = 2097152;
pub const S_IRWXUGO: u32 = 511;
pub const S_IALLUGO: u32 = 4095;
pub const S_IRUGO: u32 = 292;
pub const S_IWUGO: u32 = 146;
pub const S_IXUGO: u32 = 73;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const MSEC_PER_SEC: u32 = 1000;
pub const USEC_PER_MSEC: u32 = 1000;
pub const NSEC_PER_USEC: u32 = 1000;
pub const NSEC_PER_MSEC: u32 = 1000000;
pub const USEC_PER_SEC: u32 = 1000000;
pub const NSEC_PER_SEC: u32 = 1000000000;
pub const PSEC_PER_SEC: u64 = 1000000000000;
pub const FSEC_PER_SEC: u64 = 1000000000000000;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_SGI_CYCLE: u32 = 10;
pub const CLOCK_TAI: u32 = 11;
pub const MAX_CLOCKS: u32 = 16;
pub const CLOCKS_MASK: u32 = 1;
pub const CLOCKS_MONO: u32 = 1;
pub const TIMER_ABSTIME: u32 = 1;
pub const PSEC_PER_NSEC: u32 = 1000;
pub const TIME_UPTIME_SEC_MAX: u32 = 946080000;
pub const NTP_API: u32 = 4;
pub const ADJ_OFFSET: u32 = 1;
pub const ADJ_FREQUENCY: u32 = 2;
pub const ADJ_MAXERROR: u32 = 4;
pub const ADJ_ESTERROR: u32 = 8;
pub const ADJ_STATUS: u32 = 16;
pub const ADJ_TIMECONST: u32 = 32;
pub const ADJ_TAI: u32 = 128;
pub const ADJ_SETOFFSET: u32 = 256;
pub const ADJ_MICRO: u32 = 4096;
pub const ADJ_NANO: u32 = 8192;
pub const ADJ_TICK: u32 = 16384;
pub const MOD_OFFSET: u32 = 1;
pub const MOD_FREQUENCY: u32 = 2;
pub const MOD_MAXERROR: u32 = 4;
pub const MOD_ESTERROR: u32 = 8;
pub const MOD_STATUS: u32 = 16;
pub const MOD_TIMECONST: u32 = 32;
pub const MOD_TAI: u32 = 128;
pub const MOD_MICRO: u32 = 4096;
pub const MOD_NANO: u32 = 8192;
pub const STA_PLL: u32 = 1;
pub const STA_PPSFREQ: u32 = 2;
pub const STA_PPSTIME: u32 = 4;
pub const STA_FLL: u32 = 8;
pub const STA_INS: u32 = 16;
pub const STA_DEL: u32 = 32;
pub const STA_UNSYNC: u32 = 64;
pub const STA_FREQHOLD: u32 = 128;
pub const STA_PPSSIGNAL: u32 = 256;
pub const STA_PPSJITTER: u32 = 512;
pub const STA_PPSWANDER: u32 = 1024;
pub const STA_PPSERROR: u32 = 2048;
pub const STA_CLOCKERR: u32 = 4096;
pub const STA_NANO: u32 = 8192;
pub const STA_MODE: u32 = 16384;
pub const STA_CLK: u32 = 32768;
pub const STA_RONLY: u32 = 65280;
pub const TIME_OK: u32 = 0;
pub const TIME_INS: u32 = 1;
pub const TIME_DEL: u32 = 2;
pub const TIME_OOP: u32 = 3;
pub const TIME_WAIT: u32 = 4;
pub const TIME_ERROR: u32 = 5;
pub const TIME_BAD: u32 = 5;
pub const ADJ_ADJTIME: u32 = 32768;
pub const ADJ_OFFSET_SINGLESHOT: u32 = 1;
pub const ADJ_OFFSET_READONLY: u32 = 8192;
pub const SHIFT_PLL: u32 = 2;
pub const SHIFT_FLL: u32 = 2;
pub const MAXTC: u32 = 10;
pub const SHIFT_USEC: u32 = 16;
pub const PPM_SCALE_INV_SHIFT: u32 = 19;
pub const MAXPHASE: u32 = 500000000;
pub const MAXFREQ: u32 = 500000;
pub const MINSEC: u32 = 256;
pub const MAXSEC: u32 = 2048;
pub const NTP_PHASE_LIMIT: u32 = 16000000;
pub const NTP_SCALE_SHIFT: u32 = 32;
pub const NTP_INTERVAL_FREQ: u32 = 1000;
pub const NTP_INTERVAL_LENGTH: u32 = 1000000;
pub const PIT_TICK_RATE: u32 = 1193182;
pub const DEFAULT_OVERFLOWUID: u32 = 65534;
pub const DEFAULT_OVERFLOWGID: u32 = 65534;
pub const DEFAULT_FS_OVERFLOWUID: u32 = 65534;
pub const DEFAULT_FS_OVERFLOWGID: u32 = 65534;
pub const KSTAT_ATTR_FS_IOC_FLAGS: u32 = 1050740;
pub const KSTAT_ATTR_VFS_FLAGS: u32 = 48;
pub const STATX_CHANGE_COOKIE: u32 = 1073741824;
pub const STATX_ATTR_CHANGE_MONOTONIC: i64 = -9223372036854775808;
pub const BUILD_ID_SIZE_MAX: u32 = 20;
pub const WQ_FLAG_EXCLUSIVE: u32 = 1;
pub const WQ_FLAG_WOKEN: u32 = 2;
pub const WQ_FLAG_CUSTOM: u32 = 4;
pub const WQ_FLAG_DONE: u32 = 8;
pub const WQ_FLAG_PRIORITY: u32 = 16;
pub const OSQ_UNLOCKED_VAL: u32 = 0;
pub const KCSAN_SEQLOCK_REGION_MAX: u32 = 1000;
pub const GRND_NONBLOCK: u32 = 1;
pub const GRND_RANDOM: u32 = 2;
pub const GRND_INSECURE: u32 = 4;
pub const PB_migratetype_bits: u32 = 3;
pub const NR_PAGEFLAGS: u32 = 26;
pub const MAX_NR_ZONES: u32 = 5;
pub const NR_CPUS_BITS: u32 = 13;
pub const SPINLOCK_SIZE: u32 = 4;
pub const LRU_GEN_WIDTH: u32 = 3;
pub const __LRU_REFS_WIDTH: u32 = 2;
pub const ZONES_SHIFT: u32 = 3;
pub const ZONES_WIDTH: u32 = 3;
pub const SECTIONS_WIDTH: u32 = 0;
pub const NODES_WIDTH: u32 = 10;
pub const KASAN_TAG_WIDTH: u32 = 0;
pub const LAST__PID_SHIFT: u32 = 8;
pub const LAST__PID_MASK: u32 = 255;
pub const LAST__CPU_SHIFT: u32 = 13;
pub const LAST__CPU_MASK: u32 = 8191;
pub const LAST_CPUPID_SHIFT: u32 = 21;
pub const LAST_CPUPID_WIDTH: u32 = 21;
pub const AT_SYSINFO_EHDR: u32 = 33;
pub const AT_VECTOR_SIZE_ARCH: u32 = 3;
pub const AT_NULL: u32 = 0;
pub const AT_IGNORE: u32 = 1;
pub const AT_EXECFD: u32 = 2;
pub const AT_PHDR: u32 = 3;
pub const AT_PHENT: u32 = 4;
pub const AT_PHNUM: u32 = 5;
pub const AT_PAGESZ: u32 = 6;
pub const AT_BASE: u32 = 7;
pub const AT_FLAGS: u32 = 8;
pub const AT_ENTRY: u32 = 9;
pub const AT_NOTELF: u32 = 10;
pub const AT_UID: u32 = 11;
pub const AT_EUID: u32 = 12;
pub const AT_GID: u32 = 13;
pub const AT_EGID: u32 = 14;
pub const AT_PLATFORM: u32 = 15;
pub const AT_HWCAP: u32 = 16;
pub const AT_CLKTCK: u32 = 17;
pub const AT_SECURE: u32 = 23;
pub const AT_BASE_PLATFORM: u32 = 24;
pub const AT_RANDOM: u32 = 25;
pub const AT_HWCAP2: u32 = 26;
pub const AT_RSEQ_FEATURE_SIZE: u32 = 27;
pub const AT_RSEQ_ALIGN: u32 = 28;
pub const AT_EXECFN: u32 = 31;
pub const AT_MINSIGSTKSZ: u32 = 51;
pub const AT_VECTOR_SIZE_BASE: u32 = 22;
pub const NUM_ACTIVE_RCU_POLL_OLDSTATE: u32 = 2;
pub const TRC_NEED_QS: u32 = 1;
pub const TRC_NEED_QS_CHECKED: u32 = 2;
pub const NUM_ACTIVE_RCU_POLL_FULL_OLDSTATE: u32 = 4;
pub const MAPLE_NODE_SLOTS: u32 = 31;
pub const MAPLE_RANGE64_SLOTS: u32 = 16;
pub const MAPLE_ARANGE64_SLOTS: u32 = 10;
pub const MAPLE_ALLOC_SLOTS: u32 = 30;
pub const MAPLE_NODE_MASK: u32 = 255;
pub const MT_FLAGS_ALLOC_RANGE: u32 = 1;
pub const MT_FLAGS_USE_RCU: u32 = 2;
pub const MT_FLAGS_HEIGHT_OFFSET: u32 = 2;
pub const MT_FLAGS_HEIGHT_MASK: u32 = 124;
pub const MT_FLAGS_LOCK_MASK: u32 = 768;
pub const MT_FLAGS_LOCK_IRQ: u32 = 256;
pub const MT_FLAGS_LOCK_BH: u32 = 512;
pub const MT_FLAGS_LOCK_EXTERN: u32 = 768;
pub const MT_FLAGS_ALLOC_WRAPPED: u32 = 2048;
pub const MAPLE_HEIGHT_MAX: u32 = 31;
pub const MAPLE_NODE_TYPE_MASK: u32 = 15;
pub const MAPLE_NODE_TYPE_SHIFT: u32 = 3;
pub const MAPLE_RESERVED_RANGE: u32 = 4096;
pub const RWSEM_UNLOCKED_VALUE: u32 = 0;
pub const RWSEM_WRITER_LOCKED: u32 = 1;
pub const UPROBE_HANDLER_REMOVE: u32 = 1;
pub const UPROBE_HANDLER_MASK: u32 = 1;
pub const MAX_URETPROBE_DEPTH: u32 = 64;
pub const TICK_NSEC: u32 = 1000000;
pub const HZ_TO_MSEC_SHR32: u32 = 31;
pub const MSEC_TO_HZ_SHR32: u32 = 31;
pub const HZ_TO_MSEC_NUM: u32 = 1;
pub const HZ_TO_MSEC_DEN: u32 = 1;
pub const MSEC_TO_HZ_NUM: u32 = 1;
pub const MSEC_TO_HZ_DEN: u32 = 1;
pub const HZ_TO_USEC_SHR32: u32 = 22;
pub const USEC_TO_HZ_SHR32: u32 = 41;
pub const HZ_TO_USEC_NUM: u32 = 1000;
pub const HZ_TO_USEC_DEN: u32 = 1;
pub const USEC_TO_HZ_NUM: u32 = 1;
pub const USEC_TO_HZ_DEN: u32 = 1000;
pub const HZ_TO_NSEC_NUM: u32 = 1000000;
pub const HZ_TO_NSEC_DEN: u32 = 1;
pub const NSEC_TO_HZ_NUM: u32 = 1;
pub const NSEC_TO_HZ_DEN: u32 = 1000000;
pub const SHIFT_HZ: u32 = 10;
pub const TICK_USEC: u32 = 1000;
pub const USER_TICK_USEC: u32 = 10000;
pub const SEC_JIFFIE_SC: u32 = 21;
pub const NSEC_JIFFIE_SC: u32 = 51;
pub const TIMESTAMP_SIZE: u32 = 30;
pub const LOW_RES_NSEC: u32 = 1000000;
pub const KTIME_LOW_RES: u32 = 1000000;
pub const TIMER_CPUMASK: u32 = 262143;
pub const TIMER_MIGRATING: u32 = 262144;
pub const TIMER_BASEMASK: u32 = 524287;
pub const TIMER_DEFERRABLE: u32 = 524288;
pub const TIMER_PINNED: u32 = 1048576;
pub const TIMER_IRQSAFE: u32 = 2097152;
pub const TIMER_INIT_FLAGS: u32 = 3670016;
pub const TIMER_ARRAYSHIFT: u32 = 22;
pub const TIMER_ARRAYMASK: u32 = 4290772992;
pub const TIMER_TRACE_FLAGMASK: u32 = 3932160;
pub const NEXT_TIMER_MAX_DELTA: u32 = 1073741823;
pub const RCU_DONE_TAIL: u32 = 0;
pub const RCU_WAIT_TAIL: u32 = 1;
pub const RCU_NEXT_READY_TAIL: u32 = 2;
pub const RCU_NEXT_TAIL: u32 = 3;
pub const RCU_CBLIST_NSEGS: u32 = 4;
pub const RCU_FANOUT: u32 = 64;
pub const RCU_FANOUT_LEAF: u32 = 16;
pub const RCU_FANOUT_1: u32 = 16;
pub const RCU_FANOUT_2: u32 = 1024;
pub const RCU_FANOUT_3: u32 = 65536;
pub const RCU_FANOUT_4: u32 = 4194304;
pub const RCU_NUM_LVLS: u32 = 3;
pub const NUM_RCU_LVL_0: u32 = 1;
pub const SRCU_SIZE_SMALL: u32 = 0;
pub const SRCU_SIZE_ALLOC: u32 = 1;
pub const SRCU_SIZE_WAIT_BARRIER: u32 = 2;
pub const SRCU_SIZE_WAIT_CALL: u32 = 3;
pub const SRCU_SIZE_WAIT_CBS1: u32 = 4;
pub const SRCU_SIZE_WAIT_CBS2: u32 = 5;
pub const SRCU_SIZE_WAIT_CBS3: u32 = 6;
pub const SRCU_SIZE_WAIT_CBS4: u32 = 7;
pub const SRCU_SIZE_BIG: u32 = 8;
pub const SRCU_STATE_IDLE: u32 = 0;
pub const SRCU_STATE_SCAN1: u32 = 1;
pub const SRCU_STATE_SCAN2: u32 = 2;
pub const SRCU_NMI_UNKNOWN: u32 = 0;
pub const SRCU_NMI_UNSAFE: u32 = 1;
pub const SRCU_NMI_SAFE: u32 = 2;
pub const NOTIFY_DONE: u32 = 0;
pub const NOTIFY_OK: u32 = 1;
pub const NOTIFY_STOP_MASK: u32 = 32768;
pub const NOTIFY_BAD: u32 = 32770;
pub const NOTIFY_STOP: u32 = 32769;
pub const NETLINK_URELEASE: u32 = 1;
pub const KBD_KEYCODE: u32 = 1;
pub const KBD_UNBOUND_KEYCODE: u32 = 2;
pub const KBD_UNICODE: u32 = 3;
pub const KBD_KEYSYM: u32 = 4;
pub const KBD_POST_KEYSYM: u32 = 5;
pub const MAX_UINSN_BYTES: u32 = 16;
pub const UPROBE_XOL_SLOT_BYTES: u32 = 128;
pub const UPROBE_SWBP_INSN: u32 = 204;
pub const UPROBE_SWBP_INSN_SIZE: u32 = 1;
pub const LINUX_MM_DEBUG_H: u32 = 1;
pub const PERCPU_MODULE_RESERVE: u32 = 8192;
pub const PCPU_MIN_ALLOC_SHIFT: u32 = 2;
pub const PCPU_MIN_ALLOC_SIZE: u32 = 4;
pub const PERCPU_DYNAMIC_SIZE_SHIFT: u32 = 12;
pub const PERCPU_DYNAMIC_EARLY_SIZE: u32 = 81920;
pub const PERCPU_DYNAMIC_RESERVE: u32 = 114688;
pub const MM_CONTEXT_UPROBE_IA32: u32 = 0;
pub const MM_CONTEXT_HAS_VSYSCALL: u32 = 1;
pub const MM_CONTEXT_LOCK_LAM: u32 = 2;
pub const MM_CONTEXT_FORCE_TAGGED_SVA: u32 = 3;
pub const AT_VECTOR_SIZE: u32 = 52;
pub const INIT_PASID: u32 = 0;
pub const ENCODE_PAGE_BITS: u32 = 3;
pub const MM_MT_FLAGS: u32 = 771;
pub const PAGEFLAGS_MASK: u32 = 67108863;
pub const PAGE_POISON_PATTERN: i32 = -1;
pub const FOLIO_PF_ANY: u32 = 0;
pub const FOLIO_PF_HEAD: u32 = 0;
pub const FOLIO_PF_ONLY_HEAD: u32 = 0;
pub const FOLIO_PF_NO_TAIL: u32 = 0;
pub const FOLIO_PF_NO_COMPOUND: u32 = 0;
pub const FOLIO_PF_SECOND: u32 = 1;
pub const MAGIC_HWPOISON: u32 = 1213681747;
pub const PAGE_MAPPING_ANON: u32 = 1;
pub const PAGE_MAPPING_MOVABLE: u32 = 2;
pub const PAGE_MAPPING_KSM: u32 = 3;
pub const PAGE_MAPPING_FLAGS: u32 = 3;
pub const PAGE_TYPE_BASE: u32 = 4026531840;
pub const PAGE_MAPCOUNT_RESERVE: i32 = -128;
pub const PG_buddy: u32 = 128;
pub const PG_offline: u32 = 256;
pub const PG_table: u32 = 512;
pub const PG_guard: u32 = 1024;
pub const PG_hugetlb: u32 = 2048;
pub const MAX_PAGE_ORDER: u32 = 10;
pub const MAX_ORDER_NR_PAGES: u32 = 1024;
pub const NR_PAGE_ORDERS: u32 = 11;
pub const PAGE_ALLOC_COSTLY_ORDER: u32 = 3;
pub const MIGRATETYPE_MASK: u32 = 7;
pub const LRU_BASE: u32 = 0;
pub const LRU_ACTIVE: u32 = 1;
pub const LRU_FILE: u32 = 2;
pub const WORKINGSET_ANON: u32 = 0;
pub const WORKINGSET_FILE: u32 = 1;
pub const ANON_AND_FILE: u32 = 2;
pub const MIN_NR_GENS: u32 = 2;
pub const MAX_NR_GENS: u32 = 4;
pub const MAX_NR_TIERS: u32 = 4;
pub const MIN_LRU_BATCH: u32 = 64;
pub const MAX_LRU_BATCH: u32 = 4096;
pub const NR_HIST_GENS: u32 = 1;
pub const NR_BLOOM_FILTERS: u32 = 2;
pub const MEMCG_NR_GENS: u32 = 3;
pub const MEMCG_NR_BINS: u32 = 8;
pub const NR_PCP_THP: u32 = 2;
pub const ASYNC_AND_SYNC: u32 = 2;
pub const ZONEID_SHIFT: u32 = 13;
pub const ZONES_MASK: u32 = 7;
pub const NODES_MASK: u32 = 1023;
pub const SECTIONS_MASK: u32 = 0;
pub const LAST_CPUPID_MASK: u32 = 2097151;
pub const KASAN_TAG_MASK: u32 = 0;
pub const ZONEID_MASK: u32 = 8191;
pub const DEF_PRIORITY: u32 = 12;
pub const MAX_ZONES_PER_ZONELIST: u32 = 5120;
pub const PA_SECTION_SHIFT: u32 = 27;
pub const PFN_SECTION_SHIFT: u32 = 15;
pub const PAGES_PER_SECTION: u32 = 32768;
pub const PAGE_SECTION_MASK: i32 = -32768;
pub const SUBSECTION_SHIFT: u32 = 21;
pub const SUBSECTION_SIZE: u32 = 2097152;
pub const PFN_SUBSECTION_SHIFT: u32 = 9;
pub const PAGES_PER_SUBSECTION: u32 = 512;
pub const PAGE_SUBSECTION_MASK: i32 = -512;
pub const SUBSECTIONS_PER_SECTION: u32 = 64;
pub const MPC_SIGNATURE: &[u8; 5usize] = b"PCMP\0";
pub const MP_PROCESSOR: u32 = 0;
pub const MP_BUS: u32 = 1;
pub const MP_IOAPIC: u32 = 2;
pub const MP_INTSRC: u32 = 3;
pub const MP_LINTSRC: u32 = 4;
pub const MP_TRANSLATION: u32 = 192;
pub const CPU_ENABLED: u32 = 1;
pub const CPU_BOOTPROCESSOR: u32 = 2;
pub const CPU_STEPPING_MASK: u32 = 15;
pub const CPU_MODEL_MASK: u32 = 240;
pub const CPU_FAMILY_MASK: u32 = 3840;
pub const BUSTYPE_EISA: &[u8; 5usize] = b"EISA\0";
pub const BUSTYPE_ISA: &[u8; 4usize] = b"ISA\0";
pub const BUSTYPE_INTERN: &[u8; 7usize] = b"INTERN\0";
pub const BUSTYPE_MCA: &[u8; 4usize] = b"MCA\0";
pub const BUSTYPE_VL: &[u8; 3usize] = b"VL\0";
pub const BUSTYPE_PCI: &[u8; 4usize] = b"PCI\0";
pub const BUSTYPE_PCMCIA: &[u8; 7usize] = b"PCMCIA\0";
pub const BUSTYPE_CBUS: &[u8; 5usize] = b"CBUS\0";
pub const BUSTYPE_CBUSII: &[u8; 7usize] = b"CBUSII\0";
pub const BUSTYPE_FUTURE: &[u8; 7usize] = b"FUTURE\0";
pub const BUSTYPE_MBI: &[u8; 4usize] = b"MBI\0";
pub const BUSTYPE_MBII: &[u8; 5usize] = b"MBII\0";
pub const BUSTYPE_MPI: &[u8; 4usize] = b"MPI\0";
pub const BUSTYPE_MPSA: &[u8; 5usize] = b"MPSA\0";
pub const BUSTYPE_NUBUS: &[u8; 6usize] = b"NUBUS\0";
pub const BUSTYPE_TC: &[u8; 3usize] = b"TC\0";
pub const BUSTYPE_VME: &[u8; 4usize] = b"VME\0";
pub const BUSTYPE_XPRESS: &[u8; 7usize] = b"XPRESS\0";
pub const MPC_APIC_USABLE: u32 = 1;
pub const MP_IRQPOL_DEFAULT: u32 = 0;
pub const MP_IRQPOL_ACTIVE_HIGH: u32 = 1;
pub const MP_IRQPOL_RESERVED: u32 = 2;
pub const MP_IRQPOL_ACTIVE_LOW: u32 = 3;
pub const MP_IRQPOL_MASK: u32 = 3;
pub const MP_IRQTRIG_DEFAULT: u32 = 0;
pub const MP_IRQTRIG_EDGE: u32 = 4;
pub const MP_IRQTRIG_RESERVED: u32 = 8;
pub const MP_IRQTRIG_LEVEL: u32 = 12;
pub const MP_IRQTRIG_MASK: u32 = 12;
pub const MP_APIC_ALL: u32 = 255;
pub const MPC_OEM_SIGNATURE: &[u8; 5usize] = b"_OEM\0";
pub const SETUP_NONE: u32 = 0;
pub const SETUP_E820_EXT: u32 = 1;
pub const SETUP_DTB: u32 = 2;
pub const SETUP_PCI: u32 = 3;
pub const SETUP_EFI: u32 = 4;
pub const SETUP_APPLE_PROPERTIES: u32 = 5;
pub const SETUP_JAILHOUSE: u32 = 6;
pub const SETUP_CC_BLOB: u32 = 7;
pub const SETUP_IMA: u32 = 8;
pub const SETUP_RNG_SEED: u32 = 9;
pub const SETUP_ENUM_MAX: u32 = 9;
pub const SETUP_INDIRECT: u32 = 2147483648;
pub const SETUP_TYPE_MAX: u32 = 2147483657;
pub const RAMDISK_IMAGE_START_MASK: u32 = 2047;
pub const RAMDISK_PROMPT_FLAG: u32 = 32768;
pub const RAMDISK_LOAD_FLAG: u32 = 16384;
pub const LOADED_HIGH: u32 = 1;
pub const KASLR_FLAG: u32 = 2;
pub const QUIET_FLAG: u32 = 32;
pub const KEEP_SEGMENTS: u32 = 64;
pub const CAN_USE_HEAP: u32 = 128;
pub const XLF_KERNEL_64: u32 = 1;
pub const XLF_CAN_BE_LOADED_ABOVE_4G: u32 = 2;
pub const XLF_EFI_HANDOVER_32: u32 = 4;
pub const XLF_EFI_HANDOVER_64: u32 = 8;
pub const XLF_EFI_KEXEC: u32 = 16;
pub const XLF_5LEVEL: u32 = 32;
pub const XLF_5LEVEL_ENABLED: u32 = 64;
pub const XLF_MEM_ENCRYPTION: u32 = 128;
pub const VIDEO_TYPE_MDA: u32 = 16;
pub const VIDEO_TYPE_CGA: u32 = 17;
pub const VIDEO_TYPE_EGAM: u32 = 32;
pub const VIDEO_TYPE_EGAC: u32 = 33;
pub const VIDEO_TYPE_VGAC: u32 = 34;
pub const VIDEO_TYPE_VLFB: u32 = 35;
pub const VIDEO_TYPE_PICA_S3: u32 = 48;
pub const VIDEO_TYPE_MIPS_G364: u32 = 49;
pub const VIDEO_TYPE_SGI: u32 = 51;
pub const VIDEO_TYPE_TGAC: u32 = 64;
pub const VIDEO_TYPE_SUN: u32 = 80;
pub const VIDEO_TYPE_SUNPCI: u32 = 81;
pub const VIDEO_TYPE_PMAC: u32 = 96;
pub const VIDEO_TYPE_EFI: u32 = 112;
pub const VIDEO_FLAGS_NOCURSOR: u32 = 1;
pub const VIDEO_CAPABILITY_SKIP_QUIRKS: u32 = 1;
pub const VIDEO_CAPABILITY_64BIT_BASE: u32 = 2;
pub const SCREEN_INFO_MAX_RESOURCES: u32 = 3;
pub const APM_STATE_READY: u32 = 0;
pub const APM_STATE_STANDBY: u32 = 1;
pub const APM_STATE_SUSPEND: u32 = 2;
pub const APM_STATE_OFF: u32 = 3;
pub const APM_STATE_BUSY: u32 = 4;
pub const APM_STATE_REJECT: u32 = 5;
pub const APM_STATE_OEM_SYS: u32 = 32;
pub const APM_STATE_OEM_DEV: u32 = 64;
pub const APM_STATE_DISABLE: u32 = 0;
pub const APM_STATE_ENABLE: u32 = 1;
pub const APM_STATE_DISENGAGE: u32 = 0;
pub const APM_STATE_ENGAGE: u32 = 1;
pub const APM_SYS_STANDBY: u32 = 1;
pub const APM_SYS_SUSPEND: u32 = 2;
pub const APM_NORMAL_RESUME: u32 = 3;
pub const APM_CRITICAL_RESUME: u32 = 4;
pub const APM_LOW_BATTERY: u32 = 5;
pub const APM_POWER_STATUS_CHANGE: u32 = 6;
pub const APM_UPDATE_TIME: u32 = 7;
pub const APM_CRITICAL_SUSPEND: u32 = 8;
pub const APM_USER_STANDBY: u32 = 9;
pub const APM_USER_SUSPEND: u32 = 10;
pub const APM_STANDBY_RESUME: u32 = 11;
pub const APM_CAPABILITY_CHANGE: u32 = 12;
pub const APM_USER_HIBERNATION: u32 = 13;
pub const APM_HIBERNATION_RESUME: u32 = 14;
pub const APM_SUCCESS: u32 = 0;
pub const APM_DISABLED: u32 = 1;
pub const APM_CONNECTED: u32 = 2;
pub const APM_NOT_CONNECTED: u32 = 3;
pub const APM_16_CONNECTED: u32 = 5;
pub const APM_16_UNSUPPORTED: u32 = 6;
pub const APM_32_CONNECTED: u32 = 7;
pub const APM_32_UNSUPPORTED: u32 = 8;
pub const APM_BAD_DEVICE: u32 = 9;
pub const APM_BAD_PARAM: u32 = 10;
pub const APM_NOT_ENGAGED: u32 = 11;
pub const APM_BAD_FUNCTION: u32 = 12;
pub const APM_RESUME_DISABLED: u32 = 13;
pub const APM_NO_ERROR: u32 = 83;
pub const APM_BAD_STATE: u32 = 96;
pub const APM_NO_EVENTS: u32 = 128;
pub const APM_NOT_PRESENT: u32 = 134;
pub const APM_DEVICE_BIOS: u32 = 0;
pub const APM_DEVICE_ALL: u32 = 1;
pub const APM_DEVICE_DISPLAY: u32 = 256;
pub const APM_DEVICE_STORAGE: u32 = 512;
pub const APM_DEVICE_PARALLEL: u32 = 768;
pub const APM_DEVICE_SERIAL: u32 = 1024;
pub const APM_DEVICE_NETWORK: u32 = 1280;
pub const APM_DEVICE_PCMCIA: u32 = 1536;
pub const APM_DEVICE_BATTERY: u32 = 32768;
pub const APM_DEVICE_OEM: u32 = 57344;
pub const APM_DEVICE_OLD_ALL: u32 = 65535;
pub const APM_DEVICE_CLASS: u32 = 255;
pub const APM_DEVICE_MASK: u32 = 65280;
pub const APM_MAX_BATTERIES: u32 = 2;
pub const APM_CAP_GLOBAL_STANDBY: u32 = 1;
pub const APM_CAP_GLOBAL_SUSPEND: u32 = 2;
pub const APM_CAP_RESUME_STANDBY_TIMER: u32 = 4;
pub const APM_CAP_RESUME_SUSPEND_TIMER: u32 = 8;
pub const APM_CAP_RESUME_STANDBY_RING: u32 = 16;
pub const APM_CAP_RESUME_SUSPEND_RING: u32 = 32;
pub const APM_CAP_RESUME_STANDBY_PCMCIA: u32 = 64;
pub const APM_CAP_RESUME_SUSPEND_PCMCIA: u32 = 128;
pub const APM_16_BIT_SUPPORT: u32 = 1;
pub const APM_32_BIT_SUPPORT: u32 = 2;
pub const APM_IDLE_SLOWS_CLOCK: u32 = 4;
pub const APM_BIOS_DISABLED: u32 = 8;
pub const APM_BIOS_DISENGAGED: u32 = 16;
pub const APM_FUNC_INST_CHECK: u32 = 21248;
pub const APM_FUNC_REAL_CONN: u32 = 21249;
pub const APM_FUNC_16BIT_CONN: u32 = 21250;
pub const APM_FUNC_32BIT_CONN: u32 = 21251;
pub const APM_FUNC_DISCONN: u32 = 21252;
pub const APM_FUNC_IDLE: u32 = 21253;
pub const APM_FUNC_BUSY: u32 = 21254;
pub const APM_FUNC_SET_STATE: u32 = 21255;
pub const APM_FUNC_ENABLE_PM: u32 = 21256;
pub const APM_FUNC_RESTORE_BIOS: u32 = 21257;
pub const APM_FUNC_GET_STATUS: u32 = 21258;
pub const APM_FUNC_GET_EVENT: u32 = 21259;
pub const APM_FUNC_GET_STATE: u32 = 21260;
pub const APM_FUNC_ENABLE_DEV_PM: u32 = 21261;
pub const APM_FUNC_VERSION: u32 = 21262;
pub const APM_FUNC_ENGAGE_PM: u32 = 21263;
pub const APM_FUNC_GET_CAP: u32 = 21264;
pub const APM_FUNC_RESUME_TIMER: u32 = 21265;
pub const APM_FUNC_RESUME_ON_RING: u32 = 21266;
pub const APM_FUNC_TIMER: u32 = 21267;
pub const APM_FUNC_DISABLE_TIMER: u32 = 0;
pub const APM_FUNC_GET_TIMER: u32 = 1;
pub const APM_FUNC_SET_TIMER: u32 = 2;
pub const APM_FUNC_DISABLE_RING: u32 = 0;
pub const APM_FUNC_ENABLE_RING: u32 = 1;
pub const APM_FUNC_GET_RING: u32 = 2;
pub const APM_FUNC_TIMER_DISABLE: u32 = 0;
pub const APM_FUNC_TIMER_ENABLE: u32 = 1;
pub const APM_FUNC_TIMER_GET: u32 = 2;
pub const EDDNR: u32 = 489;
pub const EDDBUF: u32 = 3328;
pub const EDDMAXNR: u32 = 6;
pub const EDDEXTSIZE: u32 = 8;
pub const EDDPARMSIZE: u32 = 74;
pub const CHECKEXTENSIONSPRESENT: u32 = 65;
pub const GETDEVICEPARAMETERS: u32 = 72;
pub const LEGACYGETDEVICEPARAMETERS: u32 = 8;
pub const EDDMAGIC1: u32 = 21930;
pub const EDDMAGIC2: u32 = 43605;
pub const READ_SECTORS: u32 = 2;
pub const EDD_MBR_SIG_OFFSET: u32 = 440;
pub const EDD_MBR_SIG_BUF: u32 = 656;
pub const EDD_MBR_SIG_MAX: u32 = 16;
pub const EDD_MBR_SIG_NR_BUF: u32 = 490;
pub const EDD_EXT_FIXED_DISK_ACCESS: u32 = 1;
pub const EDD_EXT_DEVICE_LOCKING_AND_EJECTING: u32 = 2;
pub const EDD_EXT_ENHANCED_DISK_DRIVE_SUPPORT: u32 = 4;
pub const EDD_EXT_64BIT_EXTENSIONS: u32 = 8;
pub const EDD_INFO_DMA_BOUNDARY_ERROR_TRANSPARENT: u32 = 1;
pub const EDD_INFO_GEOMETRY_VALID: u32 = 2;
pub const EDD_INFO_REMOVABLE: u32 = 4;
pub const EDD_INFO_WRITE_VERIFY: u32 = 8;
pub const EDD_INFO_MEDIA_CHANGE_NOTIFICATION: u32 = 16;
pub const EDD_INFO_LOCKABLE: u32 = 32;
pub const EDD_INFO_NO_MEDIA_PRESENT: u32 = 64;
pub const EDD_INFO_USE_INT13_FN50: u32 = 128;
pub const E820_MAX_ENTRIES_ZEROPAGE: u32 = 128;
pub const JAILHOUSE_SETUP_REQUIRED_VERSION: u32 = 1;
pub const IO_APIC_DEFAULT_PHYS_BASE: u32 = 4273995776;
pub const APIC_DEFAULT_PHYS_BASE: u32 = 4276092928;
pub const IO_APIC_SLOT_SIZE: u32 = 1024;
pub const APIC_DELIVERY_MODE_FIXED: u32 = 0;
pub const APIC_DELIVERY_MODE_LOWESTPRIO: u32 = 1;
pub const APIC_DELIVERY_MODE_SMI: u32 = 2;
pub const APIC_DELIVERY_MODE_NMI: u32 = 4;
pub const APIC_DELIVERY_MODE_INIT: u32 = 5;
pub const APIC_DELIVERY_MODE_EXTINT: u32 = 7;
pub const APIC_ID: u32 = 32;
pub const APIC_LVR: u32 = 48;
pub const APIC_LVR_MASK: u32 = 16711935;
pub const APIC_LVR_DIRECTED_EOI: u32 = 16777216;
pub const APIC_TASKPRI: u32 = 128;
pub const APIC_TPRI_MASK: u32 = 255;
pub const APIC_ARBPRI: u32 = 144;
pub const APIC_ARBPRI_MASK: u32 = 255;
pub const APIC_PROCPRI: u32 = 160;
pub const APIC_EOI: u32 = 176;
pub const APIC_EOI_ACK: u32 = 0;
pub const APIC_RRR: u32 = 192;
pub const APIC_LDR: u32 = 208;
pub const APIC_LDR_MASK: u32 = 4278190080;
pub const APIC_ALL_CPUS: u32 = 255;
pub const APIC_DFR: u32 = 224;
pub const APIC_DFR_CLUSTER: u32 = 268435455;
pub const APIC_DFR_FLAT: u32 = 4294967295;
pub const APIC_SPIV: u32 = 240;
pub const APIC_SPIV_DIRECTED_EOI: u32 = 4096;
pub const APIC_SPIV_FOCUS_DISABLED: u32 = 512;
pub const APIC_SPIV_APIC_ENABLED: u32 = 256;
pub const APIC_ISR: u32 = 256;
pub const APIC_ISR_NR: u32 = 8;
pub const APIC_TMR: u32 = 384;
pub const APIC_IRR: u32 = 512;
pub const APIC_ESR: u32 = 640;
pub const APIC_ESR_SEND_CS: u32 = 1;
pub const APIC_ESR_RECV_CS: u32 = 2;
pub const APIC_ESR_SEND_ACC: u32 = 4;
pub const APIC_ESR_RECV_ACC: u32 = 8;
pub const APIC_ESR_SENDILL: u32 = 32;
pub const APIC_ESR_RECVILL: u32 = 64;
pub const APIC_ESR_ILLREGA: u32 = 128;
pub const APIC_LVTCMCI: u32 = 752;
pub const APIC_ICR: u32 = 768;
pub const APIC_DEST_SELF: u32 = 262144;
pub const APIC_DEST_ALLINC: u32 = 524288;
pub const APIC_DEST_ALLBUT: u32 = 786432;
pub const APIC_ICR_RR_MASK: u32 = 196608;
pub const APIC_ICR_RR_INVALID: u32 = 0;
pub const APIC_ICR_RR_INPROG: u32 = 65536;
pub const APIC_ICR_RR_VALID: u32 = 131072;
pub const APIC_INT_LEVELTRIG: u32 = 32768;
pub const APIC_INT_ASSERT: u32 = 16384;
pub const APIC_ICR_BUSY: u32 = 4096;
pub const APIC_DEST_LOGICAL: u32 = 2048;
pub const APIC_DEST_PHYSICAL: u32 = 0;
pub const APIC_DM_FIXED: u32 = 0;
pub const APIC_DM_FIXED_MASK: u32 = 1792;
pub const APIC_DM_LOWEST: u32 = 256;
pub const APIC_DM_SMI: u32 = 512;
pub const APIC_DM_REMRD: u32 = 768;
pub const APIC_DM_NMI: u32 = 1024;
pub const APIC_DM_INIT: u32 = 1280;
pub const APIC_DM_STARTUP: u32 = 1536;
pub const APIC_DM_EXTINT: u32 = 1792;
pub const APIC_VECTOR_MASK: u32 = 255;
pub const APIC_ICR2: u32 = 784;
pub const APIC_LVTT: u32 = 800;
pub const APIC_LVTTHMR: u32 = 816;
pub const APIC_LVTPC: u32 = 832;
pub const APIC_LVT0: u32 = 848;
pub const APIC_LVT_TIMER_ONESHOT: u32 = 0;
pub const APIC_LVT_TIMER_PERIODIC: u32 = 131072;
pub const APIC_LVT_TIMER_TSCDEADLINE: u32 = 262144;
pub const APIC_LVT_MASKED: u32 = 65536;
pub const APIC_LVT_LEVEL_TRIGGER: u32 = 32768;
pub const APIC_LVT_REMOTE_IRR: u32 = 16384;
pub const APIC_INPUT_POLARITY: u32 = 8192;
pub const APIC_SEND_PENDING: u32 = 4096;
pub const APIC_MODE_MASK: u32 = 1792;
pub const APIC_MODE_FIXED: u32 = 0;
pub const APIC_MODE_NMI: u32 = 4;
pub const APIC_MODE_EXTINT: u32 = 7;
pub const APIC_LVT1: u32 = 864;
pub const APIC_LVTERR: u32 = 880;
pub const APIC_TMICT: u32 = 896;
pub const APIC_TMCCT: u32 = 912;
pub const APIC_TDCR: u32 = 992;
pub const APIC_SELF_IPI: u32 = 1008;
pub const APIC_TDR_DIV_TMBASE: u32 = 4;
pub const APIC_TDR_DIV_1: u32 = 11;
pub const APIC_TDR_DIV_2: u32 = 0;
pub const APIC_TDR_DIV_4: u32 = 1;
pub const APIC_TDR_DIV_8: u32 = 2;
pub const APIC_TDR_DIV_16: u32 = 3;
pub const APIC_TDR_DIV_32: u32 = 8;
pub const APIC_TDR_DIV_64: u32 = 9;
pub const APIC_TDR_DIV_128: u32 = 10;
pub const APIC_EFEAT: u32 = 1024;
pub const APIC_ECTRL: u32 = 1040;
pub const APIC_EILVT_NR_AMD_K8: u32 = 1;
pub const APIC_EILVT_NR_AMD_10H: u32 = 4;
pub const APIC_EILVT_NR_MAX: u32 = 4;
pub const APIC_EILVT_MSG_FIX: u32 = 0;
pub const APIC_EILVT_MSG_SMI: u32 = 2;
pub const APIC_EILVT_MSG_NMI: u32 = 4;
pub const APIC_EILVT_MSG_EXT: u32 = 7;
pub const APIC_EILVT_MASKED: u32 = 65536;
pub const APIC_BASE_MSR: u32 = 2048;
pub const APIC_X2APIC_ID_MSR: u32 = 2050;
pub const MAX_IO_APICS: u32 = 128;
pub const MAX_LOCAL_APIC: u32 = 32768;
pub const XAPIC_DEST_CPUS_SHIFT: u32 = 4;
pub const XAPIC_DEST_CPUS_MASK: u32 = 15;
pub const XAPIC_DEST_CLUSTER_MASK: u32 = 240;
pub const BAD_APICID: u32 = 65535;
pub const MAX_MP_BUSSES: u32 = 256;
pub const MAX_IRQ_SOURCES: u32 = 1024;
pub const LOCAL_DISTANCE: u32 = 10;
pub const REMOTE_DISTANCE: u32 = 20;
pub const DISTANCE_BITS: u32 = 8;
pub const RECLAIM_DISTANCE: u32 = 30;
pub const PENALTY_FOR_NODE_WITH_CPUS: u32 = 1;
pub const GFP_MOVABLE_SHIFT: u32 = 3;
pub const GFP_ZONES_SHIFT: u32 = 2;
pub const CTL_MAXNAME: u32 = 10;
pub const UMH_NO_WAIT: u32 = 0;
pub const UMH_WAIT_EXEC: u32 = 1;
pub const UMH_WAIT_PROC: u32 = 2;
pub const UMH_KILLABLE: u32 = 4;
pub const UMH_FREEZABLE: u32 = 8;
pub const KMOD_PATH_LEN: u32 = 256;
pub const IPC_CREAT: u32 = 512;
pub const IPC_EXCL: u32 = 1024;
pub const IPC_NOWAIT: u32 = 2048;
pub const IPC_DIPC: u32 = 4096;
pub const IPC_OWN: u32 = 8192;
pub const IPC_RMID: u32 = 0;
pub const IPC_SET: u32 = 1;
pub const IPC_STAT: u32 = 2;
pub const IPC_INFO: u32 = 3;
pub const IPC_OLD: u32 = 0;
pub const IPC_64: u32 = 256;
pub const SEMOP: u32 = 1;
pub const SEMGET: u32 = 2;
pub const SEMCTL: u32 = 3;
pub const SEMTIMEDOP: u32 = 4;
pub const MSGSND: u32 = 11;
pub const MSGRCV: u32 = 12;
pub const MSGGET: u32 = 13;
pub const MSGCTL: u32 = 14;
pub const SHMAT: u32 = 21;
pub const SHMDT: u32 = 22;
pub const SHMGET: u32 = 23;
pub const SHMCTL: u32 = 24;
pub const DIPC: u32 = 25;
pub const SEM_UNDO: u32 = 4096;
pub const GETPID: u32 = 11;
pub const GETVAL: u32 = 12;
pub const GETALL: u32 = 13;
pub const GETNCNT: u32 = 14;
pub const GETZCNT: u32 = 15;
pub const SETVAL: u32 = 16;
pub const SETALL: u32 = 17;
pub const SEM_STAT: u32 = 18;
pub const SEM_INFO: u32 = 19;
pub const SEM_STAT_ANY: u32 = 20;
pub const SEMMNI: u32 = 32000;
pub const SEMMSL: u32 = 32000;
pub const SEMMNS: u32 = 1024000000;
pub const SEMOPM: u32 = 500;
pub const SEMVMX: u32 = 32767;
pub const SEMAEM: u32 = 32767;
pub const SEMUME: u32 = 500;
pub const SEMMNU: u32 = 1024000000;
pub const SEMMAP: u32 = 1024000000;
pub const SEMUSZ: u32 = 20;
pub const FIOSETOWN: u32 = 35073;
pub const SIOCSPGRP: u32 = 35074;
pub const FIOGETOWN: u32 = 35075;
pub const SIOCGPGRP: u32 = 35076;
pub const SIOCATMARK: u32 = 35077;
pub const SIOCGSTAMP_OLD: u32 = 35078;
pub const SIOCGSTAMPNS_OLD: u32 = 35079;
pub const SOL_SOCKET: u32 = 1;
pub const SO_DEBUG: u32 = 1;
pub const SO_REUSEADDR: u32 = 2;
pub const SO_TYPE: u32 = 3;
pub const SO_ERROR: u32 = 4;
pub const SO_DONTROUTE: u32 = 5;
pub const SO_BROADCAST: u32 = 6;
pub const SO_SNDBUF: u32 = 7;
pub const SO_RCVBUF: u32 = 8;
pub const SO_SNDBUFFORCE: u32 = 32;
pub const SO_RCVBUFFORCE: u32 = 33;
pub const SO_KEEPALIVE: u32 = 9;
pub const SO_OOBINLINE: u32 = 10;
pub const SO_NO_CHECK: u32 = 11;
pub const SO_PRIORITY: u32 = 12;
pub const SO_LINGER: u32 = 13;
pub const SO_BSDCOMPAT: u32 = 14;
pub const SO_REUSEPORT: u32 = 15;
pub const SO_PASSCRED: u32 = 16;
pub const SO_PEERCRED: u32 = 17;
pub const SO_RCVLOWAT: u32 = 18;
pub const SO_SNDLOWAT: u32 = 19;
pub const SO_RCVTIMEO_OLD: u32 = 20;
pub const SO_SNDTIMEO_OLD: u32 = 21;
pub const SO_SECURITY_AUTHENTICATION: u32 = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: u32 = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: u32 = 24;
pub const SO_BINDTODEVICE: u32 = 25;
pub const SO_ATTACH_FILTER: u32 = 26;
pub const SO_DETACH_FILTER: u32 = 27;
pub const SO_GET_FILTER: u32 = 26;
pub const SO_PEERNAME: u32 = 28;
pub const SO_ACCEPTCONN: u32 = 30;
pub const SO_PEERSEC: u32 = 31;
pub const SO_PASSSEC: u32 = 34;
pub const SO_MARK: u32 = 36;
pub const SO_PROTOCOL: u32 = 38;
pub const SO_DOMAIN: u32 = 39;
pub const SO_RXQ_OVFL: u32 = 40;
pub const SO_WIFI_STATUS: u32 = 41;
pub const SCM_WIFI_STATUS: u32 = 41;
pub const SO_PEEK_OFF: u32 = 42;
pub const SO_NOFCS: u32 = 43;
pub const SO_LOCK_FILTER: u32 = 44;
pub const SO_SELECT_ERR_QUEUE: u32 = 45;
pub const SO_BUSY_POLL: u32 = 46;
pub const SO_MAX_PACING_RATE: u32 = 47;
pub const SO_BPF_EXTENSIONS: u32 = 48;
pub const SO_INCOMING_CPU: u32 = 49;
pub const SO_ATTACH_BPF: u32 = 50;
pub const SO_DETACH_BPF: u32 = 27;
pub const SO_ATTACH_REUSEPORT_CBPF: u32 = 51;
pub const SO_ATTACH_REUSEPORT_EBPF: u32 = 52;
pub const SO_CNX_ADVICE: u32 = 53;
pub const SCM_TIMESTAMPING_OPT_STATS: u32 = 54;
pub const SO_MEMINFO: u32 = 55;
pub const SO_INCOMING_NAPI_ID: u32 = 56;
pub const SO_COOKIE: u32 = 57;
pub const SCM_TIMESTAMPING_PKTINFO: u32 = 58;
pub const SO_PEERGROUPS: u32 = 59;
pub const SO_ZEROCOPY: u32 = 60;
pub const SO_TXTIME: u32 = 61;
pub const SCM_TXTIME: u32 = 61;
pub const SO_BINDTOIFINDEX: u32 = 62;
pub const SO_TIMESTAMP_OLD: u32 = 29;
pub const SO_TIMESTAMPNS_OLD: u32 = 35;
pub const SO_TIMESTAMPING_OLD: u32 = 37;
pub const SO_TIMESTAMP_NEW: u32 = 63;
pub const SO_TIMESTAMPNS_NEW: u32 = 64;
pub const SO_TIMESTAMPING_NEW: u32 = 65;
pub const SO_RCVTIMEO_NEW: u32 = 66;
pub const SO_SNDTIMEO_NEW: u32 = 67;
pub const SO_DETACH_REUSEPORT_BPF: u32 = 68;
pub const SO_PREFER_BUSY_POLL: u32 = 69;
pub const SO_BUSY_POLL_BUDGET: u32 = 70;
pub const SO_NETNS_COOKIE: u32 = 71;
pub const SO_BUF_LOCK: u32 = 72;
pub const SO_RESERVE_MEM: u32 = 73;
pub const SO_TXREHASH: u32 = 74;
pub const SO_RCVMARK: u32 = 75;
pub const SO_PASSPIDFD: u32 = 76;
pub const SO_PEERPIDFD: u32 = 77;
pub const SOCK_IOC_TYPE: u32 = 137;
pub const SIOCGSTAMP: u32 = 35078;
pub const SIOCGSTAMPNS: u32 = 35079;
pub const SIOCADDRT: u32 = 35083;
pub const SIOCDELRT: u32 = 35084;
pub const SIOCRTMSG: u32 = 35085;
pub const SIOCGIFNAME: u32 = 35088;
pub const SIOCSIFLINK: u32 = 35089;
pub const SIOCGIFCONF: u32 = 35090;
pub const SIOCGIFFLAGS: u32 = 35091;
pub const SIOCSIFFLAGS: u32 = 35092;
pub const SIOCGIFADDR: u32 = 35093;
pub const SIOCSIFADDR: u32 = 35094;
pub const SIOCGIFDSTADDR: u32 = 35095;
pub const SIOCSIFDSTADDR: u32 = 35096;
pub const SIOCGIFBRDADDR: u32 = 35097;
pub const SIOCSIFBRDADDR: u32 = 35098;
pub const SIOCGIFNETMASK: u32 = 35099;
pub const SIOCSIFNETMASK: u32 = 35100;
pub const SIOCGIFMETRIC: u32 = 35101;
pub const SIOCSIFMETRIC: u32 = 35102;
pub const SIOCGIFMEM: u32 = 35103;
pub const SIOCSIFMEM: u32 = 35104;
pub const SIOCGIFMTU: u32 = 35105;
pub const SIOCSIFMTU: u32 = 35106;
pub const SIOCSIFNAME: u32 = 35107;
pub const SIOCSIFHWADDR: u32 = 35108;
pub const SIOCGIFENCAP: u32 = 35109;
pub const SIOCSIFENCAP: u32 = 35110;
pub const SIOCGIFHWADDR: u32 = 35111;
pub const SIOCGIFSLAVE: u32 = 35113;
pub const SIOCSIFSLAVE: u32 = 35120;
pub const SIOCADDMULTI: u32 = 35121;
pub const SIOCDELMULTI: u32 = 35122;
pub const SIOCGIFINDEX: u32 = 35123;
pub const SIOGIFINDEX: u32 = 35123;
pub const SIOCSIFPFLAGS: u32 = 35124;
pub const SIOCGIFPFLAGS: u32 = 35125;
pub const SIOCDIFADDR: u32 = 35126;
pub const SIOCSIFHWBROADCAST: u32 = 35127;
pub const SIOCGIFCOUNT: u32 = 35128;
pub const SIOCGIFBR: u32 = 35136;
pub const SIOCSIFBR: u32 = 35137;
pub const SIOCGIFTXQLEN: u32 = 35138;
pub const SIOCSIFTXQLEN: u32 = 35139;
pub const SIOCETHTOOL: u32 = 35142;
pub const SIOCGMIIPHY: u32 = 35143;
pub const SIOCGMIIREG: u32 = 35144;
pub const SIOCSMIIREG: u32 = 35145;
pub const SIOCWANDEV: u32 = 35146;
pub const SIOCOUTQNSD: u32 = 35147;
pub const SIOCGSKNS: u32 = 35148;
pub const SIOCDARP: u32 = 35155;
pub const SIOCGARP: u32 = 35156;
pub const SIOCSARP: u32 = 35157;
pub const SIOCDRARP: u32 = 35168;
pub const SIOCGRARP: u32 = 35169;
pub const SIOCSRARP: u32 = 35170;
pub const SIOCGIFMAP: u32 = 35184;
pub const SIOCSIFMAP: u32 = 35185;
pub const SIOCADDDLCI: u32 = 35200;
pub const SIOCDELDLCI: u32 = 35201;
pub const SIOCGIFVLAN: u32 = 35202;
pub const SIOCSIFVLAN: u32 = 35203;
pub const SIOCBONDENSLAVE: u32 = 35216;
pub const SIOCBONDRELEASE: u32 = 35217;
pub const SIOCBONDSETHWADDR: u32 = 35218;
pub const SIOCBONDSLAVEINFOQUERY: u32 = 35219;
pub const SIOCBONDINFOQUERY: u32 = 35220;
pub const SIOCBONDCHANGEACTIVE: u32 = 35221;
pub const SIOCBRADDBR: u32 = 35232;
pub const SIOCBRDELBR: u32 = 35233;
pub const SIOCBRADDIF: u32 = 35234;
pub const SIOCBRDELIF: u32 = 35235;
pub const SIOCSHWTSTAMP: u32 = 35248;
pub const SIOCGHWTSTAMP: u32 = 35249;
pub const SIOCDEVPRIVATE: u32 = 35312;
pub const SIOCPROTOPRIVATE: u32 = 35296;
pub const UIO_FASTIOV: u32 = 8;
pub const UIO_MAXIOV: u32 = 1024;
pub const ITER_SOURCE: u32 = 1;
pub const ITER_DEST: u32 = 0;
pub const _K_SS_MAXSIZE: u32 = 128;
pub const SOCK_SNDBUF_LOCK: u32 = 1;
pub const SOCK_RCVBUF_LOCK: u32 = 2;
pub const SOCK_BUF_LOCK_MASK: u32 = 3;
pub const SOCK_TXREHASH_DEFAULT: u32 = 255;
pub const SOCK_TXREHASH_DISABLED: u32 = 0;
pub const SOCK_TXREHASH_ENABLED: u32 = 1;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_CREDENTIALS: u32 = 2;
pub const SCM_SECURITY: u32 = 3;
pub const SCM_PIDFD: u32 = 4;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_AX25: u32 = 3;
pub const AF_IPX: u32 = 4;
pub const AF_APPLETALK: u32 = 5;
pub const AF_NETROM: u32 = 6;
pub const AF_BRIDGE: u32 = 7;
pub const AF_ATMPVC: u32 = 8;
pub const AF_X25: u32 = 9;
pub const AF_INET6: u32 = 10;
pub const AF_ROSE: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_NETBEUI: u32 = 13;
pub const AF_SECURITY: u32 = 14;
pub const AF_KEY: u32 = 15;
pub const AF_NETLINK: u32 = 16;
pub const AF_ROUTE: u32 = 16;
pub const AF_PACKET: u32 = 17;
pub const AF_ASH: u32 = 18;
pub const AF_ECONET: u32 = 19;
pub const AF_ATMSVC: u32 = 20;
pub const AF_RDS: u32 = 21;
pub const AF_SNA: u32 = 22;
pub const AF_IRDA: u32 = 23;
pub const AF_PPPOX: u32 = 24;
pub const AF_WANPIPE: u32 = 25;
pub const AF_LLC: u32 = 26;
pub const AF_IB: u32 = 27;
pub const AF_MPLS: u32 = 28;
pub const AF_CAN: u32 = 29;
pub const AF_TIPC: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IUCV: u32 = 32;
pub const AF_RXRPC: u32 = 33;
pub const AF_ISDN: u32 = 34;
pub const AF_PHONET: u32 = 35;
pub const AF_IEEE802154: u32 = 36;
pub const AF_CAIF: u32 = 37;
pub const AF_ALG: u32 = 38;
pub const AF_NFC: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_KCM: u32 = 41;
pub const AF_QIPCRTR: u32 = 42;
pub const AF_SMC: u32 = 43;
pub const AF_XDP: u32 = 44;
pub const AF_MCTP: u32 = 45;
pub const AF_MAX: u32 = 46;
pub const PF_UNSPEC: u32 = 0;
pub const PF_UNIX: u32 = 1;
pub const PF_LOCAL: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_AX25: u32 = 3;
pub const PF_IPX: u32 = 4;
pub const PF_APPLETALK: u32 = 5;
pub const PF_NETROM: u32 = 6;
pub const PF_BRIDGE: u32 = 7;
pub const PF_ATMPVC: u32 = 8;
pub const PF_X25: u32 = 9;
pub const PF_INET6: u32 = 10;
pub const PF_ROSE: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_NETBEUI: u32 = 13;
pub const PF_SECURITY: u32 = 14;
pub const PF_KEY: u32 = 15;
pub const PF_NETLINK: u32 = 16;
pub const PF_ROUTE: u32 = 16;
pub const PF_PACKET: u32 = 17;
pub const PF_ASH: u32 = 18;
pub const PF_ECONET: u32 = 19;
pub const PF_ATMSVC: u32 = 20;
pub const PF_RDS: u32 = 21;
pub const PF_SNA: u32 = 22;
pub const PF_IRDA: u32 = 23;
pub const PF_PPPOX: u32 = 24;
pub const PF_WANPIPE: u32 = 25;
pub const PF_LLC: u32 = 26;
pub const PF_IB: u32 = 27;
pub const PF_MPLS: u32 = 28;
pub const PF_CAN: u32 = 29;
pub const PF_TIPC: u32 = 30;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_IUCV: u32 = 32;
pub const PF_RXRPC: u32 = 33;
pub const PF_ISDN: u32 = 34;
pub const PF_PHONET: u32 = 35;
pub const PF_IEEE802154: u32 = 36;
pub const PF_CAIF: u32 = 37;
pub const PF_ALG: u32 = 38;
pub const PF_NFC: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_KCM: u32 = 41;
pub const PF_QIPCRTR: u32 = 42;
pub const PF_SMC: u32 = 43;
pub const PF_XDP: u32 = 44;
pub const PF_MCTP: u32 = 45;
pub const PF_MAX: u32 = 46;
pub const SOMAXCONN: u32 = 4096;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_TRYHARD: u32 = 4;
pub const MSG_CTRUNC: u32 = 8;
pub const MSG_PROBE: u32 = 16;
pub const MSG_TRUNC: u32 = 32;
pub const MSG_DONTWAIT: u32 = 64;
pub const MSG_EOR: u32 = 128;
pub const MSG_WAITALL: u32 = 256;
pub const MSG_FIN: u32 = 512;
pub const MSG_SYN: u32 = 1024;
pub const MSG_CONFIRM: u32 = 2048;
pub const MSG_RST: u32 = 4096;
pub const MSG_ERRQUEUE: u32 = 8192;
pub const MSG_NOSIGNAL: u32 = 16384;
pub const MSG_MORE: u32 = 32768;
pub const MSG_WAITFORONE: u32 = 65536;
pub const MSG_SENDPAGE_NOPOLICY: u32 = 65536;
pub const MSG_BATCH: u32 = 262144;
pub const MSG_EOF: u32 = 512;
pub const MSG_NO_SHARED_FRAGS: u32 = 524288;
pub const MSG_SENDPAGE_DECRYPTED: u32 = 1048576;
pub const MSG_ZEROCOPY: u32 = 67108864;
pub const MSG_SPLICE_PAGES: u32 = 134217728;
pub const MSG_FASTOPEN: u32 = 536870912;
pub const MSG_CMSG_CLOEXEC: u32 = 1073741824;
pub const MSG_CMSG_COMPAT: u32 = 2147483648;
pub const MSG_INTERNAL_SENDMSG_FLAGS: u32 = 135331840;
pub const SOL_IP: u32 = 0;
pub const SOL_TCP: u32 = 6;
pub const SOL_UDP: u32 = 17;
pub const SOL_IPV6: u32 = 41;
pub const SOL_ICMPV6: u32 = 58;
pub const SOL_SCTP: u32 = 132;
pub const SOL_UDPLITE: u32 = 136;
pub const SOL_RAW: u32 = 255;
pub const SOL_IPX: u32 = 256;
pub const SOL_AX25: u32 = 257;
pub const SOL_ATALK: u32 = 258;
pub const SOL_NETROM: u32 = 259;
pub const SOL_ROSE: u32 = 260;
pub const SOL_DECNET: u32 = 261;
pub const SOL_X25: u32 = 262;
pub const SOL_PACKET: u32 = 263;
pub const SOL_ATM: u32 = 264;
pub const SOL_AAL: u32 = 265;
pub const SOL_IRDA: u32 = 266;
pub const SOL_NETBEUI: u32 = 267;
pub const SOL_LLC: u32 = 268;
pub const SOL_DCCP: u32 = 269;
pub const SOL_NETLINK: u32 = 270;
pub const SOL_TIPC: u32 = 271;
pub const SOL_RXRPC: u32 = 272;
pub const SOL_PPPOL2TP: u32 = 273;
pub const SOL_BLUETOOTH: u32 = 274;
pub const SOL_PNPIPE: u32 = 275;
pub const SOL_RDS: u32 = 276;
pub const SOL_IUCV: u32 = 277;
pub const SOL_CAIF: u32 = 278;
pub const SOL_ALG: u32 = 279;
pub const SOL_NFC: u32 = 280;
pub const SOL_KCM: u32 = 281;
pub const SOL_TLS: u32 = 282;
pub const SOL_XDP: u32 = 283;
pub const SOL_MPTCP: u32 = 284;
pub const SOL_MCTP: u32 = 285;
pub const SOL_SMC: u32 = 286;
pub const SOL_VSOCK: u32 = 287;
pub const IPX_TYPE: u32 = 1;
pub const __UAPI_DEF_IF_IFCONF: u32 = 1;
pub const __UAPI_DEF_IF_IFMAP: u32 = 1;
pub const __UAPI_DEF_IF_IFNAMSIZ: u32 = 1;
pub const __UAPI_DEF_IF_IFREQ: u32 = 1;
pub const __UAPI_DEF_IF_NET_DEVICE_FLAGS: u32 = 1;
pub const __UAPI_DEF_IF_NET_DEVICE_FLAGS_LOWER_UP_DORMANT_ECHO: u32 = 1;
pub const __UAPI_DEF_IN_ADDR: u32 = 1;
pub const __UAPI_DEF_IN_IPPROTO: u32 = 1;
pub const __UAPI_DEF_IN_PKTINFO: u32 = 1;
pub const __UAPI_DEF_IP_MREQ: u32 = 1;
pub const __UAPI_DEF_SOCKADDR_IN: u32 = 1;
pub const __UAPI_DEF_IN_CLASS: u32 = 1;
pub const __UAPI_DEF_IN6_ADDR: u32 = 1;
pub const __UAPI_DEF_IN6_ADDR_ALT: u32 = 1;
pub const __UAPI_DEF_SOCKADDR_IN6: u32 = 1;
pub const __UAPI_DEF_IPV6_MREQ: u32 = 1;
pub const __UAPI_DEF_IPPROTO_V6: u32 = 1;
pub const __UAPI_DEF_IPV6_OPTIONS: u32 = 1;
pub const __UAPI_DEF_IN6_PKTINFO: u32 = 1;
pub const __UAPI_DEF_IP6_MTUINFO: u32 = 1;
pub const __UAPI_DEF_SOCKADDR_IPX: u32 = 1;
pub const __UAPI_DEF_IPX_ROUTE_DEFINITION: u32 = 1;
pub const __UAPI_DEF_IPX_INTERFACE_DEFINITION: u32 = 1;
pub const __UAPI_DEF_IPX_CONFIG_DATA: u32 = 1;
pub const __UAPI_DEF_IPX_ROUTE_DEF: u32 = 1;
pub const __UAPI_DEF_XATTR: u32 = 1;
pub const IFNAMSIZ: u32 = 16;
pub const IFALIASZ: u32 = 256;
pub const ALTIFNAMSIZ: u32 = 128;
pub const GENERIC_HDLC_VERSION: u32 = 4;
pub const CLOCK_DEFAULT: u32 = 0;
pub const CLOCK_EXT: u32 = 1;
pub const CLOCK_INT: u32 = 2;
pub const CLOCK_TXINT: u32 = 3;
pub const CLOCK_TXFROMRX: u32 = 4;
pub const ENCODING_DEFAULT: u32 = 0;
pub const ENCODING_NRZ: u32 = 1;
pub const ENCODING_NRZI: u32 = 2;
pub const ENCODING_FM_MARK: u32 = 3;
pub const ENCODING_FM_SPACE: u32 = 4;
pub const ENCODING_MANCHESTER: u32 = 5;
pub const PARITY_DEFAULT: u32 = 0;
pub const PARITY_NONE: u32 = 1;
pub const PARITY_CRC16_PR0: u32 = 2;
pub const PARITY_CRC16_PR1: u32 = 3;
pub const PARITY_CRC16_PR0_CCITT: u32 = 4;
pub const PARITY_CRC16_PR1_CCITT: u32 = 5;
pub const PARITY_CRC32_PR0_CCITT: u32 = 6;
pub const PARITY_CRC32_PR1_CCITT: u32 = 7;
pub const LMI_DEFAULT: u32 = 0;
pub const LMI_NONE: u32 = 1;
pub const LMI_ANSI: u32 = 2;
pub const LMI_CCITT: u32 = 3;
pub const LMI_CISCO: u32 = 4;
pub const IF_GET_IFACE: u32 = 1;
pub const IF_GET_PROTO: u32 = 2;
pub const IF_IFACE_V35: u32 = 4096;
pub const IF_IFACE_V24: u32 = 4097;
pub const IF_IFACE_X21: u32 = 4098;
pub const IF_IFACE_T1: u32 = 4099;
pub const IF_IFACE_E1: u32 = 4100;
pub const IF_IFACE_SYNC_SERIAL: u32 = 4101;
pub const IF_IFACE_X21D: u32 = 4102;
pub const IF_PROTO_HDLC: u32 = 8192;
pub const IF_PROTO_PPP: u32 = 8193;
pub const IF_PROTO_CISCO: u32 = 8194;
pub const IF_PROTO_FR: u32 = 8195;
pub const IF_PROTO_FR_ADD_PVC: u32 = 8196;
pub const IF_PROTO_FR_DEL_PVC: u32 = 8197;
pub const IF_PROTO_X25: u32 = 8198;
pub const IF_PROTO_HDLC_ETH: u32 = 8199;
pub const IF_PROTO_FR_ADD_ETH_PVC: u32 = 8200;
pub const IF_PROTO_FR_DEL_ETH_PVC: u32 = 8201;
pub const IF_PROTO_FR_PVC: u32 = 8202;
pub const IF_PROTO_FR_ETH_PVC: u32 = 8203;
pub const IF_PROTO_RAW: u32 = 8204;
pub const IFHWADDRLEN: u32 = 6;
pub const MINORBITS: u32 = 20;
pub const MINORMASK: u32 = 1048575;
pub const LIST_BL_LOCKMASK: u32 = 1;
pub const GOLDEN_RATIO_32: u32 = 1640531527;
pub const GOLDEN_RATIO_64: u64 = 7046029254386353131;
pub const DNAME_INLINE_LEN: u32 = 40;
pub const DCACHE_ENTRY_TYPE: u32 = 7340032;
pub const DCACHE_MISS_TYPE: u32 = 0;
pub const DCACHE_WHITEOUT_TYPE: u32 = 1048576;
pub const DCACHE_DIRECTORY_TYPE: u32 = 2097152;
pub const DCACHE_AUTODIR_TYPE: u32 = 3145728;
pub const DCACHE_REGULAR_TYPE: u32 = 4194304;
pub const DCACHE_SPECIAL_TYPE: u32 = 5242880;
pub const DCACHE_SYMLINK_TYPE: u32 = 6291456;
pub const SHRINKER_UNIT_BITS: u32 = 64;
pub const SHRINK_STOP: i32 = -1;
pub const SHRINK_EMPTY: i32 = -2;
pub const DEFAULT_SEEKS: u32 = 2;
pub const CSIGNAL: u32 = 255;
pub const CLONE_VM: u32 = 256;
pub const CLONE_FS: u32 = 512;
pub const CLONE_FILES: u32 = 1024;
pub const CLONE_SIGHAND: u32 = 2048;
pub const CLONE_PIDFD: u32 = 4096;
pub const CLONE_PTRACE: u32 = 8192;
pub const CLONE_VFORK: u32 = 16384;
pub const CLONE_PARENT: u32 = 32768;
pub const CLONE_THREAD: u32 = 65536;
pub const CLONE_NEWNS: u32 = 131072;
pub const CLONE_SYSVSEM: u32 = 262144;
pub const CLONE_SETTLS: u32 = 524288;
pub const CLONE_PARENT_SETTID: u32 = 1048576;
pub const CLONE_CHILD_CLEARTID: u32 = 2097152;
pub const CLONE_DETACHED: u32 = 4194304;
pub const CLONE_UNTRACED: u32 = 8388608;
pub const CLONE_CHILD_SETTID: u32 = 16777216;
pub const CLONE_NEWCGROUP: u32 = 33554432;
pub const CLONE_NEWUTS: u32 = 67108864;
pub const CLONE_NEWIPC: u32 = 134217728;
pub const CLONE_NEWUSER: u32 = 268435456;
pub const CLONE_NEWPID: u32 = 536870912;
pub const CLONE_NEWNET: u32 = 1073741824;
pub const CLONE_IO: u32 = 2147483648;
pub const CLONE_CLEAR_SIGHAND: u64 = 4294967296;
pub const CLONE_INTO_CGROUP: u64 = 8589934592;
pub const CLONE_NEWTIME: u32 = 128;
pub const CLONE_ARGS_SIZE_VER0: u32 = 64;
pub const CLONE_ARGS_SIZE_VER1: u32 = 80;
pub const CLONE_ARGS_SIZE_VER2: u32 = 88;
pub const SCHED_NORMAL: u32 = 0;
pub const SCHED_FIFO: u32 = 1;
pub const SCHED_RR: u32 = 2;
pub const SCHED_BATCH: u32 = 3;
pub const SCHED_IDLE: u32 = 5;
pub const SCHED_DEADLINE: u32 = 6;
pub const SCHED_RESET_ON_FORK: u32 = 1073741824;
pub const SCHED_FLAG_RESET_ON_FORK: u32 = 1;
pub const SCHED_FLAG_RECLAIM: u32 = 2;
pub const SCHED_FLAG_DL_OVERRUN: u32 = 4;
pub const SCHED_FLAG_KEEP_POLICY: u32 = 8;
pub const SCHED_FLAG_KEEP_PARAMS: u32 = 16;
pub const SCHED_FLAG_UTIL_CLAMP_MIN: u32 = 32;
pub const SCHED_FLAG_UTIL_CLAMP_MAX: u32 = 64;
pub const SCHED_FLAG_KEEP_ALL: u32 = 24;
pub const SCHED_FLAG_UTIL_CLAMP: u32 = 96;
pub const SCHED_FLAG_ALL: u32 = 127;
pub const KMSAN_RETVAL_SIZE: u32 = 800;
pub const KMSAN_PARAM_SIZE: u32 = 800;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_BOTH: i32 = -2;
pub const RUSAGE_THREAD: u32 = 1;
pub const RLIM64_INFINITY: i32 = -1;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const _STK_LIM: u32 = 8388608;
pub const MLOCK_LIMIT: u32 = 8388608;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_NPROC: u32 = 6;
pub const RLIMIT_NOFILE: u32 = 7;
pub const RLIMIT_MEMLOCK: u32 = 8;
pub const RLIMIT_AS: u32 = 9;
pub const RLIMIT_LOCKS: u32 = 10;
pub const RLIMIT_SIGPENDING: u32 = 11;
pub const RLIMIT_MSGQUEUE: u32 = 12;
pub const RLIMIT_NICE: u32 = 13;
pub const RLIMIT_RTPRIO: u32 = 14;
pub const RLIMIT_RTTIME: u32 = 15;
pub const RLIM_NLIMITS: u32 = 16;
pub const RLIM_INFINITY: i32 = -1;
pub const LT_SAVECOUNT: u32 = 32;
pub const LT_BACKTRACEDEPTH: u32 = 12;
pub const MAX_NICE: u32 = 19;
pub const MIN_NICE: i32 = -20;
pub const NICE_WIDTH: u32 = 40;
pub const MAX_RT_PRIO: u32 = 100;
pub const MAX_PRIO: u32 = 140;
pub const DEFAULT_PRIO: u32 = 120;
pub const _NSIG: u32 = 64;
pub const _NSIG_BPW: u32 = 64;
pub const _NSIG_WORDS: u32 = 1;
pub const SA_IA32_ABI: u32 = 33554432;
pub const SA_X32_ABI: u32 = 16777216;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGBUS: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGUSR1: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGUSR2: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGSTKFLT: u32 = 16;
pub const SIGCHLD: u32 = 17;
pub const SIGCONT: u32 = 18;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGURG: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGPOLL: u32 = 29;
pub const SIGPWR: u32 = 30;
pub const SIGSYS: u32 = 31;
pub const SIGUNUSED: u32 = 31;
pub const SIGRTMIN: u32 = 32;
pub const SIGRTMAX: u32 = 64;
pub const SA_RESTORER: u32 = 67108864;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_UNSUPPORTED: u32 = 1024;
pub const SA_EXPOSE_TAGBITS: u32 = 2048;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SI_MAX_SIZE: u32 = 128;
pub const SI_USER: u32 = 0;
pub const SI_KERNEL: u32 = 128;
pub const SI_QUEUE: i32 = -1;
pub const SI_TIMER: i32 = -2;
pub const SI_MESGQ: i32 = -3;
pub const SI_ASYNCIO: i32 = -4;
pub const SI_SIGIO: i32 = -5;
pub const SI_TKILL: i32 = -6;
pub const SI_DETHREAD: i32 = -7;
pub const SI_ASYNCNL: i32 = -60;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLOPN: u32 = 2;
pub const ILL_ILLADR: u32 = 3;
pub const ILL_ILLTRP: u32 = 4;
pub const ILL_PRVOPC: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const ILL_BADIADDR: u32 = 9;
pub const __ILL_BREAK: u32 = 10;
pub const __ILL_BNDMOD: u32 = 11;
pub const NSIGILL: u32 = 11;
pub const FPE_INTDIV: u32 = 1;
pub const FPE_INTOVF: u32 = 2;
pub const FPE_FLTDIV: u32 = 3;
pub const FPE_FLTOVF: u32 = 4;
pub const FPE_FLTUND: u32 = 5;
pub const FPE_FLTRES: u32 = 6;
pub const FPE_FLTINV: u32 = 7;
pub const FPE_FLTSUB: u32 = 8;
pub const __FPE_DECOVF: u32 = 9;
pub const __FPE_DECDIV: u32 = 10;
pub const __FPE_DECERR: u32 = 11;
pub const __FPE_INVASC: u32 = 12;
pub const __FPE_INVDEC: u32 = 13;
pub const FPE_FLTUNK: u32 = 14;
pub const FPE_CONDTRAP: u32 = 15;
pub const NSIGFPE: u32 = 15;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const SEGV_BNDERR: u32 = 3;
pub const SEGV_PKUERR: u32 = 4;
pub const SEGV_ACCADI: u32 = 5;
pub const SEGV_ADIDERR: u32 = 6;
pub const SEGV_ADIPERR: u32 = 7;
pub const SEGV_MTEAERR: u32 = 8;
pub const SEGV_MTESERR: u32 = 9;
pub const SEGV_CPERR: u32 = 10;
pub const NSIGSEGV: u32 = 10;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const BUS_MCEERR_AR: u32 = 4;
pub const BUS_MCEERR_AO: u32 = 5;
pub const NSIGBUS: u32 = 5;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const TRAP_BRANCH: u32 = 3;
pub const TRAP_HWBKPT: u32 = 4;
pub const TRAP_UNK: u32 = 5;
pub const TRAP_PERF: u32 = 6;
pub const NSIGTRAP: u32 = 6;
pub const TRAP_PERF_FLAG_ASYNC: u32 = 1;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const NSIGCHLD: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const NSIGPOLL: u32 = 6;
pub const SYS_SECCOMP: u32 = 1;
pub const SYS_USER_DISPATCH: u32 = 2;
pub const NSIGSYS: u32 = 2;
pub const EMT_TAGOVF: u32 = 1;
pub const NSIGEMT: u32 = 1;
pub const SIGEV_SIGNAL: u32 = 0;
pub const SIGEV_NONE: u32 = 1;
pub const SIGEV_THREAD: u32 = 2;
pub const SIGEV_THREAD_ID: u32 = 4;
pub const SIGEV_MAX_SIZE: u32 = 64;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 2;
pub const SS_AUTODISARM: u32 = 2147483648;
pub const SS_FLAG_BITS: u32 = 2147483648;
pub const SIGQUEUE_PREALLOC: u32 = 1;
pub const SA_IMMUTABLE: u32 = 8388608;
pub const __ARCH_UAPI_SA_FLAGS: u32 = 67108864;
pub const UAPI_SA_FLAGS: u32 = 3690989575;
pub const CPUCLOCK_PERTHREAD_MASK: u32 = 4;
pub const CPUCLOCK_CLOCK_MASK: u32 = 3;
pub const CPUCLOCK_PROF: u32 = 0;
pub const CPUCLOCK_VIRT: u32 = 1;
pub const CPUCLOCK_SCHED: u32 = 2;
pub const CPUCLOCK_MAX: u32 = 3;
pub const CLOCKFD: u32 = 3;
pub const CLOCKFD_MASK: u32 = 7;
pub const MAX_DA_NAME_LEN: u32 = 24;
pub const RV_PER_TASK_MONITORS: u32 = 1;
pub const RV_PER_TASK_MONITOR_INIT: u32 = 1;
pub const KM_MAX_IDX: u32 = 16;
pub const TASK_RUNNING: u32 = 0;
pub const TASK_INTERRUPTIBLE: u32 = 1;
pub const TASK_UNINTERRUPTIBLE: u32 = 2;
pub const __TASK_STOPPED: u32 = 4;
pub const __TASK_TRACED: u32 = 8;
pub const EXIT_DEAD: u32 = 16;
pub const EXIT_ZOMBIE: u32 = 32;
pub const EXIT_TRACE: u32 = 48;
pub const TASK_PARKED: u32 = 64;
pub const TASK_DEAD: u32 = 128;
pub const TASK_WAKEKILL: u32 = 256;
pub const TASK_WAKING: u32 = 512;
pub const TASK_NOLOAD: u32 = 1024;
pub const TASK_NEW: u32 = 2048;
pub const TASK_RTLOCK_WAIT: u32 = 4096;
pub const TASK_FREEZABLE: u32 = 8192;
pub const TASK_FROZEN: u32 = 32768;
pub const TASK_STATE_MAX: u32 = 65536;
pub const TASK_ANY: u32 = 65535;
pub const TASK_KILLABLE: u32 = 258;
pub const TASK_STOPPED: u32 = 260;
pub const TASK_TRACED: u32 = 8;
pub const TASK_IDLE: u32 = 1026;
pub const TASK_NORMAL: u32 = 3;
pub const TASK_REPORT: u32 = 127;
pub const SCHED_FIXEDPOINT_SHIFT: u32 = 10;
pub const SCHED_FIXEDPOINT_SCALE: u32 = 1024;
pub const SCHED_CAPACITY_SHIFT: u32 = 10;
pub const SCHED_CAPACITY_SCALE: u32 = 1024;
pub const UTIL_EST_WEIGHT_SHIFT: u32 = 2;
pub const UTIL_AVG_UNCHANGED: u32 = 2147483648;
pub const UCLAMP_BUCKETS: u32 = 5;
pub const TASK_REPORT_IDLE: u32 = 128;
pub const TASK_REPORT_MAX: u32 = 256;
pub const PF_VCPU: u32 = 1;
pub const PF_IDLE: u32 = 2;
pub const PF_EXITING: u32 = 4;
pub const PF_POSTCOREDUMP: u32 = 8;
pub const PF_IO_WORKER: u32 = 16;
pub const PF_WQ_WORKER: u32 = 32;
pub const PF_FORKNOEXEC: u32 = 64;
pub const PF_MCE_PROCESS: u32 = 128;
pub const PF_SUPERPRIV: u32 = 256;
pub const PF_DUMPCORE: u32 = 512;
pub const PF_SIGNALED: u32 = 1024;
pub const PF_MEMALLOC: u32 = 2048;
pub const PF_NPROC_EXCEEDED: u32 = 4096;
pub const PF_USED_MATH: u32 = 8192;
pub const PF_USER_WORKER: u32 = 16384;
pub const PF_NOFREEZE: u32 = 32768;
pub const PF__HOLE__00010000: u32 = 65536;
pub const PF_KSWAPD: u32 = 131072;
pub const PF_MEMALLOC_NOFS: u32 = 262144;
pub const PF_MEMALLOC_NOIO: u32 = 524288;
pub const PF_LOCAL_THROTTLE: u32 = 1048576;
pub const PF_KTHREAD: u32 = 2097152;
pub const PF_RANDOMIZE: u32 = 4194304;
pub const PF__HOLE__00800000: u32 = 8388608;
pub const PF__HOLE__01000000: u32 = 16777216;
pub const PF__HOLE__02000000: u32 = 33554432;
pub const PF_NO_SETAFFINITY: u32 = 67108864;
pub const PF_MCE_EARLY: u32 = 134217728;
pub const PF_MEMALLOC_PIN: u32 = 268435456;
pub const PF__HOLE__20000000: u32 = 536870912;
pub const PF__HOLE__40000000: u32 = 1073741824;
pub const PF_SUSPEND_TASK: u32 = 2147483648;
pub const PFA_NO_NEW_PRIVS: u32 = 0;
pub const PFA_SPREAD_PAGE: u32 = 1;
pub const PFA_SPREAD_SLAB: u32 = 2;
pub const PFA_SPEC_SSB_DISABLE: u32 = 3;
pub const PFA_SPEC_SSB_FORCE_DISABLE: u32 = 4;
pub const PFA_SPEC_IB_DISABLE: u32 = 5;
pub const PFA_SPEC_IB_FORCE_DISABLE: u32 = 6;
pub const PFA_SPEC_SSB_NOEXEC: u32 = 7;
pub const MIGHT_RESCHED_RCU_SHIFT: u32 = 8;
pub const MIGHT_RESCHED_PREEMPT_MASK: u32 = 255;
pub const PREEMPT_LOCK_RESCHED_OFFSETS: u32 = 1;
pub const BITS_PER_XA_VALUE: u32 = 63;
pub const XA_MAX_MARKS: u32 = 3;
pub const RADIX_TREE_ENTRY_MASK: u32 = 3;
pub const RADIX_TREE_INTERNAL_NODE: u32 = 2;
pub const RADIX_TREE_MAX_TAGS: u32 = 3;
pub const _LINUX_CAPABILITY_VERSION_1: u32 = 429392688;
pub const _LINUX_CAPABILITY_U32S_1: u32 = 1;
pub const _LINUX_CAPABILITY_VERSION_2: u32 = 537333798;
pub const _LINUX_CAPABILITY_U32S_2: u32 = 2;
pub const _LINUX_CAPABILITY_VERSION_3: u32 = 537396514;
pub const _LINUX_CAPABILITY_U32S_3: u32 = 2;
pub const VFS_CAP_REVISION_MASK: u32 = 4278190080;
pub const VFS_CAP_REVISION_SHIFT: u32 = 24;
pub const VFS_CAP_FLAGS_MASK: i64 = -4278190081;
pub const VFS_CAP_FLAGS_EFFECTIVE: u32 = 1;
pub const VFS_CAP_REVISION_1: u32 = 16777216;
pub const VFS_CAP_U32_1: u32 = 1;
pub const VFS_CAP_REVISION_2: u32 = 33554432;
pub const VFS_CAP_U32_2: u32 = 2;
pub const VFS_CAP_REVISION_3: u32 = 50331648;
pub const VFS_CAP_U32_3: u32 = 2;
pub const VFS_CAP_U32: u32 = 2;
pub const VFS_CAP_REVISION: u32 = 50331648;
pub const CAP_CHOWN: u32 = 0;
pub const CAP_DAC_OVERRIDE: u32 = 1;
pub const CAP_DAC_READ_SEARCH: u32 = 2;
pub const CAP_FOWNER: u32 = 3;
pub const CAP_FSETID: u32 = 4;
pub const CAP_KILL: u32 = 5;
pub const CAP_SETGID: u32 = 6;
pub const CAP_SETUID: u32 = 7;
pub const CAP_SETPCAP: u32 = 8;
pub const CAP_LINUX_IMMUTABLE: u32 = 9;
pub const CAP_NET_BIND_SERVICE: u32 = 10;
pub const CAP_NET_BROADCAST: u32 = 11;
pub const CAP_NET_ADMIN: u32 = 12;
pub const CAP_NET_RAW: u32 = 13;
pub const CAP_IPC_LOCK: u32 = 14;
pub const CAP_IPC_OWNER: u32 = 15;
pub const CAP_SYS_MODULE: u32 = 16;
pub const CAP_SYS_RAWIO: u32 = 17;
pub const CAP_SYS_CHROOT: u32 = 18;
pub const CAP_SYS_PTRACE: u32 = 19;
pub const CAP_SYS_PACCT: u32 = 20;
pub const CAP_SYS_ADMIN: u32 = 21;
pub const CAP_SYS_BOOT: u32 = 22;
pub const CAP_SYS_NICE: u32 = 23;
pub const CAP_SYS_RESOURCE: u32 = 24;
pub const CAP_SYS_TIME: u32 = 25;
pub const CAP_SYS_TTY_CONFIG: u32 = 26;
pub const CAP_MKNOD: u32 = 27;
pub const CAP_LEASE: u32 = 28;
pub const CAP_AUDIT_WRITE: u32 = 29;
pub const CAP_AUDIT_CONTROL: u32 = 30;
pub const CAP_SETFCAP: u32 = 31;
pub const CAP_MAC_OVERRIDE: u32 = 32;
pub const CAP_MAC_ADMIN: u32 = 33;
pub const CAP_SYSLOG: u32 = 34;
pub const CAP_WAKE_ALARM: u32 = 35;
pub const CAP_BLOCK_SUSPEND: u32 = 36;
pub const CAP_AUDIT_READ: u32 = 37;
pub const CAP_PERFMON: u32 = 38;
pub const CAP_BPF: u32 = 39;
pub const CAP_CHECKPOINT_RESTORE: u32 = 40;
pub const CAP_LAST_CAP: u32 = 40;
pub const _KERNEL_CAPABILITY_VERSION: u32 = 537396514;
pub const O_ACCMODE: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_CREAT: u32 = 64;
pub const O_EXCL: u32 = 128;
pub const O_NOCTTY: u32 = 256;
pub const O_TRUNC: u32 = 512;
pub const O_APPEND: u32 = 1024;
pub const O_NONBLOCK: u32 = 2048;
pub const O_DSYNC: u32 = 4096;
pub const FASYNC: u32 = 8192;
pub const O_DIRECT: u32 = 16384;
pub const O_LARGEFILE: u32 = 32768;
pub const O_DIRECTORY: u32 = 65536;
pub const O_NOFOLLOW: u32 = 131072;
pub const O_NOATIME: u32 = 262144;
pub const O_CLOEXEC: u32 = 524288;
pub const __O_SYNC: u32 = 1048576;
pub const O_SYNC: u32 = 1052672;
pub const O_PATH: u32 = 2097152;
pub const __O_TMPFILE: u32 = 4194304;
pub const O_TMPFILE: u32 = 4259840;
pub const O_NDELAY: u32 = 2048;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const F_GETLK: u32 = 5;
pub const F_SETLK: u32 = 6;
pub const F_SETLKW: u32 = 7;
pub const F_SETOWN: u32 = 8;
pub const F_GETOWN: u32 = 9;
pub const F_SETSIG: u32 = 10;
pub const F_GETSIG: u32 = 11;
pub const F_GETLK64: u32 = 12;
pub const F_SETLK64: u32 = 13;
pub const F_SETLKW64: u32 = 14;
pub const F_SETOWN_EX: u32 = 15;
pub const F_GETOWN_EX: u32 = 16;
pub const F_GETOWNER_UIDS: u32 = 17;
pub const F_OFD_GETLK: u32 = 36;
pub const F_OFD_SETLK: u32 = 37;
pub const F_OFD_SETLKW: u32 = 38;
pub const F_OWNER_TID: u32 = 0;
pub const F_OWNER_PID: u32 = 1;
pub const F_OWNER_PGRP: u32 = 2;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 0;
pub const F_WRLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_EXLCK: u32 = 4;
pub const F_SHLCK: u32 = 8;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const LOCK_MAND: u32 = 32;
pub const LOCK_READ: u32 = 64;
pub const LOCK_WRITE: u32 = 128;
pub const LOCK_RW: u32 = 192;
pub const F_LINUX_SPECIFIC_BASE: u32 = 1024;
pub const RESOLVE_NO_XDEV: u32 = 1;
pub const RESOLVE_NO_MAGICLINKS: u32 = 2;
pub const RESOLVE_NO_SYMLINKS: u32 = 4;
pub const RESOLVE_BENEATH: u32 = 8;
pub const RESOLVE_IN_ROOT: u32 = 16;
pub const RESOLVE_CACHED: u32 = 32;
pub const F_SETLEASE: u32 = 1024;
pub const F_GETLEASE: u32 = 1025;
pub const F_CANCELLK: u32 = 1029;
pub const F_DUPFD_CLOEXEC: u32 = 1030;
pub const F_NOTIFY: u32 = 1026;
pub const F_SETPIPE_SZ: u32 = 1031;
pub const F_GETPIPE_SZ: u32 = 1032;
pub const F_ADD_SEALS: u32 = 1033;
pub const F_GET_SEALS: u32 = 1034;
pub const F_SEAL_SEAL: u32 = 1;
pub const F_SEAL_SHRINK: u32 = 2;
pub const F_SEAL_GROW: u32 = 4;
pub const F_SEAL_WRITE: u32 = 8;
pub const F_SEAL_FUTURE_WRITE: u32 = 16;
pub const F_SEAL_EXEC: u32 = 32;
pub const F_GET_RW_HINT: u32 = 1035;
pub const F_SET_RW_HINT: u32 = 1036;
pub const F_GET_FILE_RW_HINT: u32 = 1037;
pub const F_SET_FILE_RW_HINT: u32 = 1038;
pub const RWH_WRITE_LIFE_NOT_SET: u32 = 0;
pub const RWH_WRITE_LIFE_NONE: u32 = 1;
pub const RWH_WRITE_LIFE_SHORT: u32 = 2;
pub const RWH_WRITE_LIFE_MEDIUM: u32 = 3;
pub const RWH_WRITE_LIFE_LONG: u32 = 4;
pub const RWH_WRITE_LIFE_EXTREME: u32 = 5;
pub const RWF_WRITE_LIFE_NOT_SET: u32 = 0;
pub const DN_ACCESS: u32 = 1;
pub const DN_MODIFY: u32 = 2;
pub const DN_CREATE: u32 = 4;
pub const DN_DELETE: u32 = 8;
pub const DN_RENAME: u32 = 16;
pub const DN_ATTRIB: u32 = 32;
pub const DN_MULTISHOT: u32 = 2147483648;
pub const AT_FDCWD: i32 = -100;
pub const AT_SYMLINK_NOFOLLOW: u32 = 256;
pub const AT_EACCESS: u32 = 512;
pub const AT_REMOVEDIR: u32 = 512;
pub const AT_SYMLINK_FOLLOW: u32 = 1024;
pub const AT_NO_AUTOMOUNT: u32 = 2048;
pub const AT_EMPTY_PATH: u32 = 4096;
pub const AT_STATX_SYNC_TYPE: u32 = 24576;
pub const AT_STATX_SYNC_AS_STAT: u32 = 0;
pub const AT_STATX_FORCE_SYNC: u32 = 8192;
pub const AT_STATX_DONT_SYNC: u32 = 16384;
pub const AT_RECURSIVE: u32 = 32768;
pub const AT_HANDLE_FID: u32 = 512;
pub const AT_GETATTR_NOSEC: u32 = 2147483648;
pub const VALID_OPEN_FLAGS: u32 = 8388547;
pub const VALID_RESOLVE_FLAGS: u32 = 63;
pub const OPEN_HOW_SIZE_VER0: u32 = 24;
pub const OPEN_HOW_SIZE_LATEST: u32 = 24;
pub const SIGEMT_MASK: u32 = 0;
pub const JOBCTL_STOP_SIGMASK: u32 = 65535;
pub const JOBCTL_STOP_DEQUEUED_BIT: u32 = 16;
pub const JOBCTL_STOP_PENDING_BIT: u32 = 17;
pub const JOBCTL_STOP_CONSUME_BIT: u32 = 18;
pub const JOBCTL_TRAP_STOP_BIT: u32 = 19;
pub const JOBCTL_TRAP_NOTIFY_BIT: u32 = 20;
pub const JOBCTL_TRAPPING_BIT: u32 = 21;
pub const JOBCTL_LISTENING_BIT: u32 = 22;
pub const JOBCTL_TRAP_FREEZE_BIT: u32 = 23;
pub const JOBCTL_PTRACE_FROZEN_BIT: u32 = 24;
pub const JOBCTL_STOPPED_BIT: u32 = 26;
pub const JOBCTL_TRACED_BIT: u32 = 27;
pub const JOBCTL_STOP_DEQUEUED: u32 = 65536;
pub const JOBCTL_STOP_PENDING: u32 = 131072;
pub const JOBCTL_STOP_CONSUME: u32 = 262144;
pub const JOBCTL_TRAP_STOP: u32 = 524288;
pub const JOBCTL_TRAP_NOTIFY: u32 = 1048576;
pub const JOBCTL_TRAPPING: u32 = 2097152;
pub const JOBCTL_LISTENING: u32 = 4194304;
pub const JOBCTL_TRAP_FREEZE: u32 = 8388608;
pub const JOBCTL_PTRACE_FROZEN: u32 = 16777216;
pub const JOBCTL_STOPPED: u32 = 67108864;
pub const JOBCTL_TRACED: u32 = 134217728;
pub const JOBCTL_TRAP_MASK: u32 = 1572864;
pub const JOBCTL_PENDING_MASK: u32 = 1703936;
pub const __ASM_CLAC: &[u8; 21usize] = b".byte 0x0f,0x01,0xca\0";
pub const __ASM_STAC: &[u8; 21usize] = b".byte 0x0f,0x01,0xcb\0";
pub const MMU_NOTIFIER_RANGE_BLOCKABLE: u32 = 1;
pub const INVPCID_TYPE_INDIV_ADDR: u32 = 0;
pub const INVPCID_TYPE_SINGLE_CTXT: u32 = 1;
pub const INVPCID_TYPE_ALL_INCL_GLOBAL: u32 = 2;
pub const INVPCID_TYPE_ALL_NON_GLOBAL: u32 = 3;
pub const PKRU_AD_BIT: u32 = 1;
pub const PKRU_WD_BIT: u32 = 2;
pub const PKRU_BITS_PER_PKEY: u32 = 2;
pub const PFN_PTE_SHIFT: u32 = 12;
pub const FIXMAP_PMD_NUM: u32 = 2;
pub const FIXMAP_PMD_TOP: u32 = 507;
pub const VSYSCALL_ADDR: i32 = -10485760;
pub const NR_FIX_BTMAPS: u32 = 64;
pub const FIX_BTMAPS_SLOTS: u32 = 8;
pub const TOTAL_FIX_BTMAPS: u32 = 512;
pub const SWP_TYPE_BITS: u32 = 5;
pub const SWP_OFFSET_FIRST_BIT: u32 = 9;
pub const SWP_OFFSET_SHIFT: u32 = 14;
pub const HAVE_PAGE_AGP: u32 = 1;
pub const _ASM_PGTABLE_INVERT_H: u32 = 1;
pub const PTI_PGTABLE_SWITCH_BIT: u32 = 12;
pub const __HAVE_ARCH_PFN_MODIFY_ALLOWED: u32 = 1;
pub const TLB_FLUSH_ALL: i32 = -1;
pub const TLB_GENERATION_INVALID: u32 = 0;
pub const ARCH_HAS_NOCACHE_UACCESS: u32 = 1;
pub const CLONE_LEGACY_FLAGS: u32 = 4294967295;
pub const ASSOC_ARRAY_KEY_CHUNK_SIZE: u32 = 64;
pub const KEY_POS_VIEW: u32 = 16777216;
pub const KEY_POS_READ: u32 = 33554432;
pub const KEY_POS_WRITE: u32 = 67108864;
pub const KEY_POS_SEARCH: u32 = 134217728;
pub const KEY_POS_LINK: u32 = 268435456;
pub const KEY_POS_SETATTR: u32 = 536870912;
pub const KEY_POS_ALL: u32 = 1056964608;
pub const KEY_USR_VIEW: u32 = 65536;
pub const KEY_USR_READ: u32 = 131072;
pub const KEY_USR_WRITE: u32 = 262144;
pub const KEY_USR_SEARCH: u32 = 524288;
pub const KEY_USR_LINK: u32 = 1048576;
pub const KEY_USR_SETATTR: u32 = 2097152;
pub const KEY_USR_ALL: u32 = 4128768;
pub const KEY_GRP_VIEW: u32 = 256;
pub const KEY_GRP_READ: u32 = 512;
pub const KEY_GRP_WRITE: u32 = 1024;
pub const KEY_GRP_SEARCH: u32 = 2048;
pub const KEY_GRP_LINK: u32 = 4096;
pub const KEY_GRP_SETATTR: u32 = 8192;
pub const KEY_GRP_ALL: u32 = 16128;
pub const KEY_OTH_VIEW: u32 = 1;
pub const KEY_OTH_READ: u32 = 2;
pub const KEY_OTH_WRITE: u32 = 4;
pub const KEY_OTH_SEARCH: u32 = 8;
pub const KEY_OTH_LINK: u32 = 16;
pub const KEY_OTH_SETATTR: u32 = 32;
pub const KEY_OTH_ALL: u32 = 63;
pub const KEY_PERM_UNDEF: u32 = 4294967295;
pub const KEY_FLAG_DEAD: u32 = 0;
pub const KEY_FLAG_REVOKED: u32 = 1;
pub const KEY_FLAG_IN_QUOTA: u32 = 2;
pub const KEY_FLAG_USER_CONSTRUCT: u32 = 3;
pub const KEY_FLAG_ROOT_CAN_CLEAR: u32 = 4;
pub const KEY_FLAG_INVALIDATED: u32 = 5;
pub const KEY_FLAG_BUILTIN: u32 = 6;
pub const KEY_FLAG_ROOT_CAN_INVAL: u32 = 7;
pub const KEY_FLAG_KEEP: u32 = 8;
pub const KEY_FLAG_UID_KEYRING: u32 = 9;
pub const KEY_ALLOC_IN_QUOTA: u32 = 0;
pub const KEY_ALLOC_QUOTA_OVERRUN: u32 = 1;
pub const KEY_ALLOC_NOT_IN_QUOTA: u32 = 2;
pub const KEY_ALLOC_BUILT_IN: u32 = 4;
pub const KEY_ALLOC_BYPASS_RESTRICTION: u32 = 8;
pub const KEY_ALLOC_UID_KEYRING: u32 = 16;
pub const KEY_ALLOC_SET_KEEP: u32 = 32;
pub const HIGH_RES_NSEC: u32 = 1;
pub const KTIME_HIGH_RES: u32 = 1;
pub const MONOTONIC_RES_NSEC: u32 = 1;
pub const KTIME_MONOTONIC_RES: u32 = 1;
pub const HRTIMER_STATE_INACTIVE: u32 = 0;
pub const HRTIMER_STATE_ENQUEUED: u32 = 1;
pub const ALARMTIMER_STATE_INACTIVE: u32 = 0;
pub const ALARMTIMER_STATE_ENQUEUED: u32 = 1;
pub const REQUEUE_PENDING: u32 = 1;
pub const SIGNAL_STOP_STOPPED: u32 = 1;
pub const SIGNAL_STOP_CONTINUED: u32 = 2;
pub const SIGNAL_GROUP_EXIT: u32 = 4;
pub const SIGNAL_CLD_STOPPED: u32 = 16;
pub const SIGNAL_CLD_CONTINUED: u32 = 32;
pub const SIGNAL_CLD_MASK: u32 = 48;
pub const SIGNAL_UNKILLABLE: u32 = 64;
pub const SIGNAL_STOP_MASK: u32 = 51;
pub const UUID_SIZE: u32 = 16;
pub const UUID_STRING_LEN: u32 = 36;
pub const RR_TIMESLICE: u32 = 100;
pub const IOPRIO_CLASS_SHIFT: u32 = 13;
pub const IOPRIO_NR_CLASSES: u32 = 8;
pub const IOPRIO_CLASS_MASK: u32 = 7;
pub const IOPRIO_PRIO_MASK: u32 = 8191;
pub const IOPRIO_LEVEL_NR_BITS: u32 = 3;
pub const IOPRIO_NR_LEVELS: u32 = 8;
pub const IOPRIO_LEVEL_MASK: u32 = 7;
pub const IOPRIO_BE_NR: u32 = 8;
pub const IOPRIO_NORM: u32 = 4;
pub const IOPRIO_BE_NORM: u32 = 4;
pub const IOPRIO_HINT_SHIFT: u32 = 3;
pub const IOPRIO_HINT_NR_BITS: u32 = 10;
pub const IOPRIO_NR_HINTS: u32 = 1024;
pub const IOPRIO_HINT_MASK: u32 = 1023;
pub const S_DT_SHIFT: u32 = 12;
pub const S_DT_MASK: u32 = 15;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const DT_MAX: u32 = 16;
pub const FT_UNKNOWN: u32 = 0;
pub const FT_REG_FILE: u32 = 1;
pub const FT_DIR: u32 = 2;
pub const FT_CHRDEV: u32 = 3;
pub const FT_BLKDEV: u32 = 4;
pub const FT_FIFO: u32 = 5;
pub const FT_SOCK: u32 = 6;
pub const FT_SYMLINK: u32 = 7;
pub const FT_MAX: u32 = 8;
pub const MNT_NOSUID: u32 = 1;
pub const MNT_NODEV: u32 = 2;
pub const MNT_NOEXEC: u32 = 4;
pub const MNT_NOATIME: u32 = 8;
pub const MNT_NODIRATIME: u32 = 16;
pub const MNT_RELATIME: u32 = 32;
pub const MNT_READONLY: u32 = 64;
pub const MNT_NOSYMFOLLOW: u32 = 128;
pub const MNT_SHRINKABLE: u32 = 256;
pub const MNT_WRITE_HOLD: u32 = 512;
pub const MNT_SHARED: u32 = 4096;
pub const MNT_UNBINDABLE: u32 = 8192;
pub const MNT_SHARED_MASK: u32 = 8192;
pub const MNT_USER_SETTABLE_MASK: u32 = 255;
pub const MNT_ATIME_MASK: u32 = 56;
pub const MNT_INTERNAL: u32 = 16384;
pub const MNT_LOCK_ATIME: u32 = 262144;
pub const MNT_LOCK_NOEXEC: u32 = 524288;
pub const MNT_LOCK_NOSUID: u32 = 1048576;
pub const MNT_LOCK_NODEV: u32 = 2097152;
pub const MNT_LOCK_READONLY: u32 = 4194304;
pub const MNT_LOCKED: u32 = 8388608;
pub const MNT_DOOMED: u32 = 16777216;
pub const MNT_SYNC_UMOUNT: u32 = 33554432;
pub const MNT_MARKED: u32 = 67108864;
pub const MNT_UMOUNT: u32 = 134217728;
pub const MNT_ONRB: u32 = 268435456;
pub const SLAB_DEBUG_OBJECTS: u32 = 0;
pub const SLAB_FAILSLAB: u32 = 0;
pub const SLAB_KASAN: u32 = 0;
pub const KASAN_TAG_KERNEL: u32 = 255;
pub const KASAN_TAG_INVALID: u32 = 254;
pub const KASAN_TAG_MAX: u32 = 253;
pub const KASAN_TAG_MIN: u32 = 0;
pub const KMALLOC_SHIFT_HIGH: u32 = 13;
pub const KMALLOC_SHIFT_MAX: u32 = 22;
pub const KMALLOC_SHIFT_LOW: u32 = 3;
pub const KMALLOC_MAX_SIZE: u32 = 4194304;
pub const KMALLOC_MAX_CACHE_SIZE: u32 = 8192;
pub const KMALLOC_MAX_ORDER: u32 = 10;
pub const KMALLOC_MIN_SIZE: u32 = 8;
pub const RANDOM_KMALLOC_CACHES_NR: u32 = 15;
pub const INR_OPEN_CUR: u32 = 1024;
pub const INR_OPEN_MAX: u32 = 4096;
pub const BLOCK_SIZE_BITS: u32 = 10;
pub const BLOCK_SIZE: u32 = 1024;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const SEEK_DATA: u32 = 3;
pub const SEEK_HOLE: u32 = 4;
pub const SEEK_MAX: u32 = 4;
pub const RENAME_NOREPLACE: u32 = 1;
pub const RENAME_EXCHANGE: u32 = 2;
pub const RENAME_WHITEOUT: u32 = 4;
pub const FILE_DEDUPE_RANGE_SAME: u32 = 0;
pub const FILE_DEDUPE_RANGE_DIFFERS: u32 = 1;
pub const NR_FILE: u32 = 8192;
pub const FS_XFLAG_REALTIME: u32 = 1;
pub const FS_XFLAG_PREALLOC: u32 = 2;
pub const FS_XFLAG_IMMUTABLE: u32 = 8;
pub const FS_XFLAG_APPEND: u32 = 16;
pub const FS_XFLAG_SYNC: u32 = 32;
pub const FS_XFLAG_NOATIME: u32 = 64;
pub const FS_XFLAG_NODUMP: u32 = 128;
pub const FS_XFLAG_RTINHERIT: u32 = 256;
pub const FS_XFLAG_PROJINHERIT: u32 = 512;
pub const FS_XFLAG_NOSYMLINKS: u32 = 1024;
pub const FS_XFLAG_EXTSIZE: u32 = 2048;
pub const FS_XFLAG_EXTSZINHERIT: u32 = 4096;
pub const FS_XFLAG_NODEFRAG: u32 = 8192;
pub const FS_XFLAG_FILESTREAM: u32 = 16384;
pub const FS_XFLAG_DAX: u32 = 32768;
pub const FS_XFLAG_COWEXTSIZE: u32 = 65536;
pub const FS_XFLAG_HASATTR: u32 = 2147483648;
pub const BMAP_IOCTL: u32 = 1;
pub const FSLABEL_MAX: u32 = 256;
pub const FS_SECRM_FL: u32 = 1;
pub const FS_UNRM_FL: u32 = 2;
pub const FS_COMPR_FL: u32 = 4;
pub const FS_SYNC_FL: u32 = 8;
pub const FS_IMMUTABLE_FL: u32 = 16;
pub const FS_APPEND_FL: u32 = 32;
pub const FS_NODUMP_FL: u32 = 64;
pub const FS_NOATIME_FL: u32 = 128;
pub const FS_DIRTY_FL: u32 = 256;
pub const FS_COMPRBLK_FL: u32 = 512;
pub const FS_NOCOMP_FL: u32 = 1024;
pub const FS_ENCRYPT_FL: u32 = 2048;
pub const FS_BTREE_FL: u32 = 4096;
pub const FS_INDEX_FL: u32 = 4096;
pub const FS_IMAGIC_FL: u32 = 8192;
pub const FS_JOURNAL_DATA_FL: u32 = 16384;
pub const FS_NOTAIL_FL: u32 = 32768;
pub const FS_DIRSYNC_FL: u32 = 65536;
pub const FS_TOPDIR_FL: u32 = 131072;
pub const FS_HUGE_FILE_FL: u32 = 262144;
pub const FS_EXTENT_FL: u32 = 524288;
pub const FS_VERITY_FL: u32 = 1048576;
pub const FS_EA_INODE_FL: u32 = 2097152;
pub const FS_EOFBLOCKS_FL: u32 = 4194304;
pub const FS_NOCOW_FL: u32 = 8388608;
pub const FS_DAX_FL: u32 = 33554432;
pub const FS_INLINE_DATA_FL: u32 = 268435456;
pub const FS_PROJINHERIT_FL: u32 = 536870912;
pub const FS_CASEFOLD_FL: u32 = 1073741824;
pub const FS_RESERVED_FL: u32 = 2147483648;
pub const FS_FL_USER_VISIBLE: u32 = 253951;
pub const FS_FL_USER_MODIFIABLE: u32 = 229631;
pub const SYNC_FILE_RANGE_WAIT_BEFORE: u32 = 1;
pub const SYNC_FILE_RANGE_WRITE: u32 = 2;
pub const SYNC_FILE_RANGE_WAIT_AFTER: u32 = 4;
pub const SYNC_FILE_RANGE_WRITE_AND_WAIT: u32 = 7;
pub const PAGE_IS_WPALLOWED: u32 = 1;
pub const PAGE_IS_WRITTEN: u32 = 2;
pub const PAGE_IS_FILE: u32 = 4;
pub const PAGE_IS_PRESENT: u32 = 8;
pub const PAGE_IS_SWAPPED: u32 = 16;
pub const PAGE_IS_PFNZERO: u32 = 32;
pub const PAGE_IS_HUGE: u32 = 64;
pub const PAGE_IS_SOFT_DIRTY: u32 = 128;
pub const PM_SCAN_WP_MATCHING: u32 = 1;
pub const PM_SCAN_CHECK_WPASYNC: u32 = 2;
pub const MAY_EXEC: u32 = 1;
pub const MAY_WRITE: u32 = 2;
pub const MAY_READ: u32 = 4;
pub const MAY_APPEND: u32 = 8;
pub const MAY_ACCESS: u32 = 16;
pub const MAY_OPEN: u32 = 32;
pub const MAY_CHDIR: u32 = 64;
pub const MAY_NOT_BLOCK: u32 = 128;
pub const ATTR_MODE: u32 = 1;
pub const ATTR_UID: u32 = 2;
pub const ATTR_GID: u32 = 4;
pub const ATTR_SIZE: u32 = 8;
pub const ATTR_ATIME: u32 = 16;
pub const ATTR_MTIME: u32 = 32;
pub const ATTR_CTIME: u32 = 64;
pub const ATTR_ATIME_SET: u32 = 128;
pub const ATTR_MTIME_SET: u32 = 256;
pub const ATTR_FORCE: u32 = 512;
pub const ATTR_KILL_SUID: u32 = 2048;
pub const ATTR_KILL_SGID: u32 = 4096;
pub const ATTR_FILE: u32 = 8192;
pub const ATTR_KILL_PRIV: u32 = 16384;
pub const ATTR_OPEN: u32 = 32768;
pub const ATTR_TIMES_SET: u32 = 65536;
pub const ATTR_TOUCH: u32 = 131072;
pub const WHITEOUT_MODE: u32 = 0;
pub const WHITEOUT_DEV: u32 = 0;
pub const XQM_USRQUOTA: u32 = 0;
pub const XQM_GRPQUOTA: u32 = 1;
pub const XQM_PRJQUOTA: u32 = 2;
pub const XQM_MAXQUOTAS: u32 = 3;
pub const FS_DQUOT_VERSION: u32 = 1;
pub const FS_DQ_ISOFT: u32 = 1;
pub const FS_DQ_IHARD: u32 = 2;
pub const FS_DQ_BSOFT: u32 = 4;
pub const FS_DQ_BHARD: u32 = 8;
pub const FS_DQ_RTBSOFT: u32 = 16;
pub const FS_DQ_RTBHARD: u32 = 32;
pub const FS_DQ_LIMIT_MASK: u32 = 63;
pub const FS_DQ_BTIMER: u32 = 64;
pub const FS_DQ_ITIMER: u32 = 128;
pub const FS_DQ_RTBTIMER: u32 = 256;
pub const FS_DQ_TIMER_MASK: u32 = 448;
pub const FS_DQ_BWARNS: u32 = 512;
pub const FS_DQ_IWARNS: u32 = 1024;
pub const FS_DQ_RTBWARNS: u32 = 2048;
pub const FS_DQ_WARNS_MASK: u32 = 3584;
pub const FS_DQ_BCOUNT: u32 = 4096;
pub const FS_DQ_ICOUNT: u32 = 8192;
pub const FS_DQ_RTBCOUNT: u32 = 16384;
pub const FS_DQ_ACCT_MASK: u32 = 28672;
pub const FS_DQ_BIGTIME: u32 = 32768;
pub const FS_QUOTA_UDQ_ACCT: u32 = 1;
pub const FS_QUOTA_UDQ_ENFD: u32 = 2;
pub const FS_QUOTA_GDQ_ACCT: u32 = 4;
pub const FS_QUOTA_GDQ_ENFD: u32 = 8;
pub const FS_QUOTA_PDQ_ACCT: u32 = 16;
pub const FS_QUOTA_PDQ_ENFD: u32 = 32;
pub const FS_USER_QUOTA: u32 = 1;
pub const FS_PROJ_QUOTA: u32 = 2;
pub const FS_GROUP_QUOTA: u32 = 4;
pub const FS_QSTAT_VERSION: u32 = 1;
pub const FS_QSTATV_VERSION1: u32 = 1;
pub const V1_INIT_ALLOC: u32 = 1;
pub const V1_INIT_REWRITE: u32 = 1;
pub const V1_DEL_ALLOC: u32 = 0;
pub const V1_DEL_REWRITE: u32 = 2;
pub const QTREE_INIT_ALLOC: u32 = 4;
pub const QTREE_INIT_REWRITE: u32 = 2;
pub const QTREE_DEL_ALLOC: u32 = 0;
pub const QTREE_DEL_REWRITE: u32 = 6;
pub const V2_INIT_ALLOC: u32 = 4;
pub const V2_INIT_REWRITE: u32 = 2;
pub const V2_DEL_ALLOC: u32 = 0;
pub const V2_DEL_REWRITE: u32 = 6;
pub const OVERFLOW_PROJID: u32 = 65534;
pub const __DQUOT_VERSION__: &[u8; 12usize] = b"dquot_6.6.0\0";
pub const MAXQUOTAS: u32 = 3;
pub const USRQUOTA: u32 = 0;
pub const GRPQUOTA: u32 = 1;
pub const PRJQUOTA: u32 = 2;
pub const SUBCMDMASK: u32 = 255;
pub const SUBCMDSHIFT: u32 = 8;
pub const Q_SYNC: u32 = 8388609;
pub const Q_QUOTAON: u32 = 8388610;
pub const Q_QUOTAOFF: u32 = 8388611;
pub const Q_GETFMT: u32 = 8388612;
pub const Q_GETINFO: u32 = 8388613;
pub const Q_SETINFO: u32 = 8388614;
pub const Q_GETQUOTA: u32 = 8388615;
pub const Q_SETQUOTA: u32 = 8388616;
pub const Q_GETNEXTQUOTA: u32 = 8388617;
pub const QFMT_VFS_OLD: u32 = 1;
pub const QFMT_VFS_V0: u32 = 2;
pub const QFMT_OCFS2: u32 = 3;
pub const QFMT_VFS_V1: u32 = 4;
pub const QFMT_SHMEM: u32 = 5;
pub const QIF_DQBLKSIZE_BITS: u32 = 10;
pub const QIF_DQBLKSIZE: u32 = 1024;
pub const IIF_BGRACE: u32 = 1;
pub const IIF_IGRACE: u32 = 2;
pub const IIF_FLAGS: u32 = 4;
pub const IIF_ALL: u32 = 7;
pub const QUOTA_NL_NOWARN: u32 = 0;
pub const QUOTA_NL_IHARDWARN: u32 = 1;
pub const QUOTA_NL_ISOFTLONGWARN: u32 = 2;
pub const QUOTA_NL_ISOFTWARN: u32 = 3;
pub const QUOTA_NL_BHARDWARN: u32 = 4;
pub const QUOTA_NL_BSOFTLONGWARN: u32 = 5;
pub const QUOTA_NL_BSOFTWARN: u32 = 6;
pub const QUOTA_NL_IHARDBELOW: u32 = 7;
pub const QUOTA_NL_ISOFTBELOW: u32 = 8;
pub const QUOTA_NL_BHARDBELOW: u32 = 9;
pub const QUOTA_NL_BSOFTBELOW: u32 = 10;
pub const QTYPE_MASK_USR: u32 = 1;
pub const QTYPE_MASK_GRP: u32 = 2;
pub const QTYPE_MASK_PRJ: u32 = 4;
pub const DQ_MOD_B: u32 = 0;
pub const DQ_BLKS_B: u32 = 1;
pub const DQ_INODES_B: u32 = 2;
pub const DQ_FAKE_B: u32 = 3;
pub const DQ_READ_B: u32 = 4;
pub const DQ_ACTIVE_B: u32 = 5;
pub const DQ_RELEASING_B: u32 = 6;
pub const DQ_LASTSET_B: u32 = 7;
pub const QC_INO_SOFT: u32 = 1;
pub const QC_INO_HARD: u32 = 2;
pub const QC_SPC_SOFT: u32 = 4;
pub const QC_SPC_HARD: u32 = 8;
pub const QC_RT_SPC_SOFT: u32 = 16;
pub const QC_RT_SPC_HARD: u32 = 32;
pub const QC_LIMIT_MASK: u32 = 63;
pub const QC_SPC_TIMER: u32 = 64;
pub const QC_INO_TIMER: u32 = 128;
pub const QC_RT_SPC_TIMER: u32 = 256;
pub const QC_TIMER_MASK: u32 = 448;
pub const QC_SPC_WARNS: u32 = 512;
pub const QC_INO_WARNS: u32 = 1024;
pub const QC_RT_SPC_WARNS: u32 = 2048;
pub const QC_WARNS_MASK: u32 = 3584;
pub const QC_SPACE: u32 = 4096;
pub const QC_INO_COUNT: u32 = 8192;
pub const QC_RT_SPACE: u32 = 16384;
pub const QC_ACCT_MASK: u32 = 28672;
pub const QC_FLAGS: u32 = 32768;
pub const QCI_SYSFILE: u32 = 1;
pub const QCI_ROOT_SQUASH: u32 = 2;
pub const QCI_ACCT_ENABLED: u32 = 4;
pub const QCI_LIMITS_ENFORCED: u32 = 8;
pub const FILESYSTEM_MAX_STACK_DEPTH: u32 = 2;
pub const IOCB_EVENTFD: u32 = 65536;
pub const IOCB_DIRECT: u32 = 131072;
pub const IOCB_WRITE: u32 = 262144;
pub const IOCB_WAITQ: u32 = 524288;
pub const IOCB_NOIO: u32 = 1048576;
pub const IOCB_ALLOC_CACHE: u32 = 2097152;
pub const IOCB_DIO_CALLER_COMP: u32 = 4194304;
pub const IOCB_AIO_RW: u32 = 8388608;
pub const IOP_FASTPERM: u32 = 1;
pub const IOP_LOOKUP: u32 = 2;
pub const IOP_NOFOLLOW: u32 = 4;
pub const IOP_XATTR: u32 = 8;
pub const IOP_DEFAULT_READLINK: u32 = 16;
pub const MAX_NON_LFS: u32 = 2147483647;
pub const FASYNC_MAGIC: u32 = 17921;
pub const SB_ENC_STRICT_MODE_FL: u32 = 1;
pub const MNT_FORCE: u32 = 1;
pub const MNT_DETACH: u32 = 2;
pub const MNT_EXPIRE: u32 = 4;
pub const UMOUNT_NOFOLLOW: u32 = 8;
pub const UMOUNT_UNUSED: u32 = 2147483648;
pub const SB_I_CGROUPWB: u32 = 1;
pub const SB_I_NOEXEC: u32 = 2;
pub const SB_I_NODEV: u32 = 4;
pub const SB_I_STABLE_WRITES: u32 = 8;
pub const SB_I_USERNS_VISIBLE: u32 = 16;
pub const SB_I_IMA_UNVERIFIABLE_SIGNATURE: u32 = 32;
pub const SB_I_UNTRUSTED_MOUNTER: u32 = 64;
pub const SB_I_EVM_UNSUPPORTED: u32 = 128;
pub const SB_I_SKIP_SYNC: u32 = 256;
pub const SB_I_PERSB_BDI: u32 = 512;
pub const SB_I_TS_EXPIRY_WARNED: u32 = 1024;
pub const SB_I_RETIRED: u32 = 2048;
pub const SB_I_NOUMASK: u32 = 4096;
pub const NOMMU_MAP_COPY: u32 = 1;
pub const NOMMU_MAP_DIRECT: u32 = 8;
pub const REMAP_FILE_DEDUP: u32 = 1;
pub const REMAP_FILE_CAN_SHORTEN: u32 = 2;
pub const REMAP_FILE_ADVISORY: u32 = 2;
pub const COPY_FILE_SPLICE: u32 = 1;
pub const S_SYNC: u32 = 1;
pub const S_NOATIME: u32 = 2;
pub const S_APPEND: u32 = 4;
pub const S_IMMUTABLE: u32 = 8;
pub const S_DEAD: u32 = 16;
pub const S_NOQUOTA: u32 = 32;
pub const S_DIRSYNC: u32 = 64;
pub const S_NOCMTIME: u32 = 128;
pub const S_SWAPFILE: u32 = 256;
pub const S_PRIVATE: u32 = 512;
pub const S_IMA: u32 = 1024;
pub const S_AUTOMOUNT: u32 = 2048;
pub const S_NOSEC: u32 = 4096;
pub const S_DAX: u32 = 8192;
pub const S_ENCRYPTED: u32 = 16384;
pub const S_CASEFOLD: u32 = 32768;
pub const S_VERITY: u32 = 65536;
pub const S_KERNEL_FILE: u32 = 131072;
pub const I_DIRTY_SYNC: u32 = 1;
pub const I_DIRTY_DATASYNC: u32 = 2;
pub const I_DIRTY_PAGES: u32 = 4;
pub const __I_NEW: u32 = 3;
pub const I_NEW: u32 = 8;
pub const I_WILL_FREE: u32 = 16;
pub const I_FREEING: u32 = 32;
pub const I_CLEAR: u32 = 64;
pub const __I_SYNC: u32 = 7;
pub const I_SYNC: u32 = 128;
pub const I_REFERENCED: u32 = 256;
pub const __I_DIO_WAKEUP: u32 = 9;
pub const I_DIO_WAKEUP: u32 = 512;
pub const I_LINKABLE: u32 = 1024;
pub const I_DIRTY_TIME: u32 = 2048;
pub const I_WB_SWITCH: u32 = 8192;
pub const I_OVL_INUSE: u32 = 16384;
pub const I_CREATING: u32 = 32768;
pub const I_DONTCACHE: u32 = 65536;
pub const I_SYNC_QUEUED: u32 = 131072;
pub const I_PINNING_NETFS_WB: u32 = 262144;
pub const __I_LRU_ISOLATING: u32 = 19;
pub const I_LRU_ISOLATING: u32 = 524288;
pub const I_DIRTY_INODE: u32 = 3;
pub const I_DIRTY: u32 = 7;
pub const I_DIRTY_ALL: u32 = 2055;
pub const FS_REQUIRES_DEV: u32 = 1;
pub const FS_BINARY_MOUNTDATA: u32 = 2;
pub const FS_HAS_SUBTYPE: u32 = 4;
pub const FS_USERNS_MOUNT: u32 = 8;
pub const FS_DISALLOW_NOTIFY_PERM: u32 = 16;
pub const FS_ALLOW_IDMAP: u32 = 32;
pub const FS_RENAME_DOES_D_MOVE: u32 = 32768;
pub const CHRDEV_MAJOR_MAX: u32 = 512;
pub const CHRDEV_MAJOR_DYN_END: u32 = 234;
pub const CHRDEV_MAJOR_DYN_EXT_START: u32 = 511;
pub const CHRDEV_MAJOR_DYN_EXT_END: u32 = 384;
pub const IOCB_FLAG_RESFD: u32 = 1;
pub const IOCB_FLAG_IOPRIO: u32 = 2;
pub const _ASM_X86_UNISTD_H: u32 = 1;
pub const __X32_SYSCALL_BIT: u32 = 1073741824;
pub const __NR_read: u32 = 0;
pub const __NR_write: u32 = 1;
pub const __NR_open: u32 = 2;
pub const __NR_close: u32 = 3;
pub const __NR_stat: u32 = 4;
pub const __NR_fstat: u32 = 5;
pub const __NR_lstat: u32 = 6;
pub const __NR_poll: u32 = 7;
pub const __NR_lseek: u32 = 8;
pub const __NR_mmap: u32 = 9;
pub const __NR_mprotect: u32 = 10;
pub const __NR_munmap: u32 = 11;
pub const __NR_brk: u32 = 12;
pub const __NR_rt_sigaction: u32 = 13;
pub const __NR_rt_sigprocmask: u32 = 14;
pub const __NR_rt_sigreturn: u32 = 15;
pub const __NR_ioctl: u32 = 16;
pub const __NR_pread64: u32 = 17;
pub const __NR_pwrite64: u32 = 18;
pub const __NR_readv: u32 = 19;
pub const __NR_writev: u32 = 20;
pub const __NR_access: u32 = 21;
pub const __NR_pipe: u32 = 22;
pub const __NR_select: u32 = 23;
pub const __NR_sched_yield: u32 = 24;
pub const __NR_mremap: u32 = 25;
pub const __NR_msync: u32 = 26;
pub const __NR_mincore: u32 = 27;
pub const __NR_madvise: u32 = 28;
pub const __NR_shmget: u32 = 29;
pub const __NR_shmat: u32 = 30;
pub const __NR_shmctl: u32 = 31;
pub const __NR_dup: u32 = 32;
pub const __NR_dup2: u32 = 33;
pub const __NR_pause: u32 = 34;
pub const __NR_nanosleep: u32 = 35;
pub const __NR_getitimer: u32 = 36;
pub const __NR_alarm: u32 = 37;
pub const __NR_setitimer: u32 = 38;
pub const __NR_getpid: u32 = 39;
pub const __NR_sendfile: u32 = 40;
pub const __NR_socket: u32 = 41;
pub const __NR_connect: u32 = 42;
pub const __NR_accept: u32 = 43;
pub const __NR_sendto: u32 = 44;
pub const __NR_recvfrom: u32 = 45;
pub const __NR_sendmsg: u32 = 46;
pub const __NR_recvmsg: u32 = 47;
pub const __NR_shutdown: u32 = 48;
pub const __NR_bind: u32 = 49;
pub const __NR_listen: u32 = 50;
pub const __NR_getsockname: u32 = 51;
pub const __NR_getpeername: u32 = 52;
pub const __NR_socketpair: u32 = 53;
pub const __NR_setsockopt: u32 = 54;
pub const __NR_getsockopt: u32 = 55;
pub const __NR_clone: u32 = 56;
pub const __NR_fork: u32 = 57;
pub const __NR_vfork: u32 = 58;
pub const __NR_execve: u32 = 59;
pub const __NR_exit: u32 = 60;
pub const __NR_wait4: u32 = 61;
pub const __NR_kill: u32 = 62;
pub const __NR_uname: u32 = 63;
pub const __NR_semget: u32 = 64;
pub const __NR_semop: u32 = 65;
pub const __NR_semctl: u32 = 66;
pub const __NR_shmdt: u32 = 67;
pub const __NR_msgget: u32 = 68;
pub const __NR_msgsnd: u32 = 69;
pub const __NR_msgrcv: u32 = 70;
pub const __NR_msgctl: u32 = 71;
pub const __NR_fcntl: u32 = 72;
pub const __NR_flock: u32 = 73;
pub const __NR_fsync: u32 = 74;
pub const __NR_fdatasync: u32 = 75;
pub const __NR_truncate: u32 = 76;
pub const __NR_ftruncate: u32 = 77;
pub const __NR_getdents: u32 = 78;
pub const __NR_getcwd: u32 = 79;
pub const __NR_chdir: u32 = 80;
pub const __NR_fchdir: u32 = 81;
pub const __NR_rename: u32 = 82;
pub const __NR_mkdir: u32 = 83;
pub const __NR_rmdir: u32 = 84;
pub const __NR_creat: u32 = 85;
pub const __NR_link: u32 = 86;
pub const __NR_unlink: u32 = 87;
pub const __NR_symlink: u32 = 88;
pub const __NR_readlink: u32 = 89;
pub const __NR_chmod: u32 = 90;
pub const __NR_fchmod: u32 = 91;
pub const __NR_chown: u32 = 92;
pub const __NR_fchown: u32 = 93;
pub const __NR_lchown: u32 = 94;
pub const __NR_umask: u32 = 95;
pub const __NR_gettimeofday: u32 = 96;
pub const __NR_getrlimit: u32 = 97;
pub const __NR_getrusage: u32 = 98;
pub const __NR_sysinfo: u32 = 99;
pub const __NR_times: u32 = 100;
pub const __NR_ptrace: u32 = 101;
pub const __NR_getuid: u32 = 102;
pub const __NR_syslog: u32 = 103;
pub const __NR_getgid: u32 = 104;
pub const __NR_setuid: u32 = 105;
pub const __NR_setgid: u32 = 106;
pub const __NR_geteuid: u32 = 107;
pub const __NR_getegid: u32 = 108;
pub const __NR_setpgid: u32 = 109;
pub const __NR_getppid: u32 = 110;
pub const __NR_getpgrp: u32 = 111;
pub const __NR_setsid: u32 = 112;
pub const __NR_setreuid: u32 = 113;
pub const __NR_setregid: u32 = 114;
pub const __NR_getgroups: u32 = 115;
pub const __NR_setgroups: u32 = 116;
pub const __NR_setresuid: u32 = 117;
pub const __NR_getresuid: u32 = 118;
pub const __NR_setresgid: u32 = 119;
pub const __NR_getresgid: u32 = 120;
pub const __NR_getpgid: u32 = 121;
pub const __NR_setfsuid: u32 = 122;
pub const __NR_setfsgid: u32 = 123;
pub const __NR_getsid: u32 = 124;
pub const __NR_capget: u32 = 125;
pub const __NR_capset: u32 = 126;
pub const __NR_rt_sigpending: u32 = 127;
pub const __NR_rt_sigtimedwait: u32 = 128;
pub const __NR_rt_sigqueueinfo: u32 = 129;
pub const __NR_rt_sigsuspend: u32 = 130;
pub const __NR_sigaltstack: u32 = 131;
pub const __NR_utime: u32 = 132;
pub const __NR_mknod: u32 = 133;
pub const __NR_uselib: u32 = 134;
pub const __NR_personality: u32 = 135;
pub const __NR_ustat: u32 = 136;
pub const __NR_statfs: u32 = 137;
pub const __NR_fstatfs: u32 = 138;
pub const __NR_sysfs: u32 = 139;
pub const __NR_getpriority: u32 = 140;
pub const __NR_setpriority: u32 = 141;
pub const __NR_sched_setparam: u32 = 142;
pub const __NR_sched_getparam: u32 = 143;
pub const __NR_sched_setscheduler: u32 = 144;
pub const __NR_sched_getscheduler: u32 = 145;
pub const __NR_sched_get_priority_max: u32 = 146;
pub const __NR_sched_get_priority_min: u32 = 147;
pub const __NR_sched_rr_get_interval: u32 = 148;
pub const __NR_mlock: u32 = 149;
pub const __NR_munlock: u32 = 150;
pub const __NR_mlockall: u32 = 151;
pub const __NR_munlockall: u32 = 152;
pub const __NR_vhangup: u32 = 153;
pub const __NR_modify_ldt: u32 = 154;
pub const __NR_pivot_root: u32 = 155;
pub const __NR__sysctl: u32 = 156;
pub const __NR_prctl: u32 = 157;
pub const __NR_arch_prctl: u32 = 158;
pub const __NR_adjtimex: u32 = 159;
pub const __NR_setrlimit: u32 = 160;
pub const __NR_chroot: u32 = 161;
pub const __NR_sync: u32 = 162;
pub const __NR_acct: u32 = 163;
pub const __NR_settimeofday: u32 = 164;
pub const __NR_mount: u32 = 165;
pub const __NR_umount2: u32 = 166;
pub const __NR_swapon: u32 = 167;
pub const __NR_swapoff: u32 = 168;
pub const __NR_reboot: u32 = 169;
pub const __NR_sethostname: u32 = 170;
pub const __NR_setdomainname: u32 = 171;
pub const __NR_iopl: u32 = 172;
pub const __NR_ioperm: u32 = 173;
pub const __NR_create_module: u32 = 174;
pub const __NR_init_module: u32 = 175;
pub const __NR_delete_module: u32 = 176;
pub const __NR_get_kernel_syms: u32 = 177;
pub const __NR_query_module: u32 = 178;
pub const __NR_quotactl: u32 = 179;
pub const __NR_nfsservctl: u32 = 180;
pub const __NR_getpmsg: u32 = 181;
pub const __NR_putpmsg: u32 = 182;
pub const __NR_afs_syscall: u32 = 183;
pub const __NR_tuxcall: u32 = 184;
pub const __NR_security: u32 = 185;
pub const __NR_gettid: u32 = 186;
pub const __NR_readahead: u32 = 187;
pub const __NR_setxattr: u32 = 188;
pub const __NR_lsetxattr: u32 = 189;
pub const __NR_fsetxattr: u32 = 190;
pub const __NR_getxattr: u32 = 191;
pub const __NR_lgetxattr: u32 = 192;
pub const __NR_fgetxattr: u32 = 193;
pub const __NR_listxattr: u32 = 194;
pub const __NR_llistxattr: u32 = 195;
pub const __NR_flistxattr: u32 = 196;
pub const __NR_removexattr: u32 = 197;
pub const __NR_lremovexattr: u32 = 198;
pub const __NR_fremovexattr: u32 = 199;
pub const __NR_tkill: u32 = 200;
pub const __NR_time: u32 = 201;
pub const __NR_futex: u32 = 202;
pub const __NR_sched_setaffinity: u32 = 203;
pub const __NR_sched_getaffinity: u32 = 204;
pub const __NR_set_thread_area: u32 = 205;
pub const __NR_io_setup: u32 = 206;
pub const __NR_io_destroy: u32 = 207;
pub const __NR_io_getevents: u32 = 208;
pub const __NR_io_submit: u32 = 209;
pub const __NR_io_cancel: u32 = 210;
pub const __NR_get_thread_area: u32 = 211;
pub const __NR_lookup_dcookie: u32 = 212;
pub const __NR_epoll_create: u32 = 213;
pub const __NR_epoll_ctl_old: u32 = 214;
pub const __NR_epoll_wait_old: u32 = 215;
pub const __NR_remap_file_pages: u32 = 216;
pub const __NR_getdents64: u32 = 217;
pub const __NR_set_tid_address: u32 = 218;
pub const __NR_restart_syscall: u32 = 219;
pub const __NR_semtimedop: u32 = 220;
pub const __NR_fadvise64: u32 = 221;
pub const __NR_timer_create: u32 = 222;
pub const __NR_timer_settime: u32 = 223;
pub const __NR_timer_gettime: u32 = 224;
pub const __NR_timer_getoverrun: u32 = 225;
pub const __NR_timer_delete: u32 = 226;
pub const __NR_clock_settime: u32 = 227;
pub const __NR_clock_gettime: u32 = 228;
pub const __NR_clock_getres: u32 = 229;
pub const __NR_clock_nanosleep: u32 = 230;
pub const __NR_exit_group: u32 = 231;
pub const __NR_epoll_wait: u32 = 232;
pub const __NR_epoll_ctl: u32 = 233;
pub const __NR_tgkill: u32 = 234;
pub const __NR_utimes: u32 = 235;
pub const __NR_vserver: u32 = 236;
pub const __NR_mbind: u32 = 237;
pub const __NR_set_mempolicy: u32 = 238;
pub const __NR_get_mempolicy: u32 = 239;
pub const __NR_mq_open: u32 = 240;
pub const __NR_mq_unlink: u32 = 241;
pub const __NR_mq_timedsend: u32 = 242;
pub const __NR_mq_timedreceive: u32 = 243;
pub const __NR_mq_notify: u32 = 244;
pub const __NR_mq_getsetattr: u32 = 245;
pub const __NR_kexec_load: u32 = 246;
pub const __NR_waitid: u32 = 247;
pub const __NR_add_key: u32 = 248;
pub const __NR_request_key: u32 = 249;
pub const __NR_keyctl: u32 = 250;
pub const __NR_ioprio_set: u32 = 251;
pub const __NR_ioprio_get: u32 = 252;
pub const __NR_inotify_init: u32 = 253;
pub const __NR_inotify_add_watch: u32 = 254;
pub const __NR_inotify_rm_watch: u32 = 255;
pub const __NR_migrate_pages: u32 = 256;
pub const __NR_openat: u32 = 257;
pub const __NR_mkdirat: u32 = 258;
pub const __NR_mknodat: u32 = 259;
pub const __NR_fchownat: u32 = 260;
pub const __NR_futimesat: u32 = 261;
pub const __NR_newfstatat: u32 = 262;
pub const __NR_unlinkat: u32 = 263;
pub const __NR_renameat: u32 = 264;
pub const __NR_linkat: u32 = 265;
pub const __NR_symlinkat: u32 = 266;
pub const __NR_readlinkat: u32 = 267;
pub const __NR_fchmodat: u32 = 268;
pub const __NR_faccessat: u32 = 269;
pub const __NR_pselect6: u32 = 270;
pub const __NR_ppoll: u32 = 271;
pub const __NR_unshare: u32 = 272;
pub const __NR_set_robust_list: u32 = 273;
pub const __NR_get_robust_list: u32 = 274;
pub const __NR_splice: u32 = 275;
pub const __NR_tee: u32 = 276;
pub const __NR_sync_file_range: u32 = 277;
pub const __NR_vmsplice: u32 = 278;
pub const __NR_move_pages: u32 = 279;
pub const __NR_utimensat: u32 = 280;
pub const __NR_epoll_pwait: u32 = 281;
pub const __NR_signalfd: u32 = 282;
pub const __NR_timerfd_create: u32 = 283;
pub const __NR_eventfd: u32 = 284;
pub const __NR_fallocate: u32 = 285;
pub const __NR_timerfd_settime: u32 = 286;
pub const __NR_timerfd_gettime: u32 = 287;
pub const __NR_accept4: u32 = 288;
pub const __NR_signalfd4: u32 = 289;
pub const __NR_eventfd2: u32 = 290;
pub const __NR_epoll_create1: u32 = 291;
pub const __NR_dup3: u32 = 292;
pub const __NR_pipe2: u32 = 293;
pub const __NR_inotify_init1: u32 = 294;
pub const __NR_preadv: u32 = 295;
pub const __NR_pwritev: u32 = 296;
pub const __NR_rt_tgsigqueueinfo: u32 = 297;
pub const __NR_perf_event_open: u32 = 298;
pub const __NR_recvmmsg: u32 = 299;
pub const __NR_fanotify_init: u32 = 300;
pub const __NR_fanotify_mark: u32 = 301;
pub const __NR_prlimit64: u32 = 302;
pub const __NR_name_to_handle_at: u32 = 303;
pub const __NR_open_by_handle_at: u32 = 304;
pub const __NR_clock_adjtime: u32 = 305;
pub const __NR_syncfs: u32 = 306;
pub const __NR_sendmmsg: u32 = 307;
pub const __NR_setns: u32 = 308;
pub const __NR_getcpu: u32 = 309;
pub const __NR_process_vm_readv: u32 = 310;
pub const __NR_process_vm_writev: u32 = 311;
pub const __NR_kcmp: u32 = 312;
pub const __NR_finit_module: u32 = 313;
pub const __NR_sched_setattr: u32 = 314;
pub const __NR_sched_getattr: u32 = 315;
pub const __NR_renameat2: u32 = 316;
pub const __NR_seccomp: u32 = 317;
pub const __NR_getrandom: u32 = 318;
pub const __NR_memfd_create: u32 = 319;
pub const __NR_kexec_file_load: u32 = 320;
pub const __NR_bpf: u32 = 321;
pub const __NR_execveat: u32 = 322;
pub const __NR_userfaultfd: u32 = 323;
pub const __NR_membarrier: u32 = 324;
pub const __NR_mlock2: u32 = 325;
pub const __NR_copy_file_range: u32 = 326;
pub const __NR_preadv2: u32 = 327;
pub const __NR_pwritev2: u32 = 328;
pub const __NR_pkey_mprotect: u32 = 329;
pub const __NR_pkey_alloc: u32 = 330;
pub const __NR_pkey_free: u32 = 331;
pub const __NR_statx: u32 = 332;
pub const __NR_io_pgetevents: u32 = 333;
pub const __NR_rseq: u32 = 334;
pub const __NR_pidfd_send_signal: u32 = 424;
pub const __NR_io_uring_setup: u32 = 425;
pub const __NR_io_uring_enter: u32 = 426;
pub const __NR_io_uring_register: u32 = 427;
pub const __NR_open_tree: u32 = 428;
pub const __NR_move_mount: u32 = 429;
pub const __NR_fsopen: u32 = 430;
pub const __NR_fsconfig: u32 = 431;
pub const __NR_fsmount: u32 = 432;
pub const __NR_fspick: u32 = 433;
pub const __NR_pidfd_open: u32 = 434;
pub const __NR_clone3: u32 = 435;
pub const __NR_close_range: u32 = 436;
pub const __NR_openat2: u32 = 437;
pub const __NR_pidfd_getfd: u32 = 438;
pub const __NR_faccessat2: u32 = 439;
pub const __NR_process_madvise: u32 = 440;
pub const __NR_epoll_pwait2: u32 = 441;
pub const __NR_mount_setattr: u32 = 442;
pub const __NR_quotactl_fd: u32 = 443;
pub const __NR_landlock_create_ruleset: u32 = 444;
pub const __NR_landlock_add_rule: u32 = 445;
pub const __NR_landlock_restrict_self: u32 = 446;
pub const __NR_memfd_secret: u32 = 447;
pub const __NR_process_mrelease: u32 = 448;
pub const __NR_futex_waitv: u32 = 449;
pub const __NR_set_mempolicy_home_node: u32 = 450;
pub const __NR_cachestat: u32 = 451;
pub const __NR_fchmodat2: u32 = 452;
pub const __NR_map_shadow_stack: u32 = 453;
pub const __NR_futex_wake: u32 = 454;
pub const __NR_futex_wait: u32 = 455;
pub const __NR_futex_requeue: u32 = 456;
pub const __NR_statmount: u32 = 457;
pub const __NR_listmount: u32 = 458;
pub const __NR_lsm_get_self_attr: u32 = 459;
pub const __NR_lsm_set_self_attr: u32 = 460;
pub const __NR_lsm_list_modules: u32 = 461;
pub const __NR_syscalls: u32 = 462;
pub const __NR_x32_rt_sigaction: u32 = 512;
pub const __NR_x32_rt_sigreturn: u32 = 513;
pub const __NR_x32_ioctl: u32 = 514;
pub const __NR_x32_readv: u32 = 515;
pub const __NR_x32_writev: u32 = 516;
pub const __NR_x32_recvfrom: u32 = 517;
pub const __NR_x32_sendmsg: u32 = 518;
pub const __NR_x32_recvmsg: u32 = 519;
pub const __NR_x32_execve: u32 = 520;
pub const __NR_x32_ptrace: u32 = 521;
pub const __NR_x32_rt_sigpending: u32 = 522;
pub const __NR_x32_rt_sigtimedwait: u32 = 523;
pub const __NR_x32_rt_sigqueueinfo: u32 = 524;
pub const __NR_x32_sigaltstack: u32 = 525;
pub const __NR_x32_timer_create: u32 = 526;
pub const __NR_x32_mq_notify: u32 = 527;
pub const __NR_x32_kexec_load: u32 = 528;
pub const __NR_x32_waitid: u32 = 529;
pub const __NR_x32_set_robust_list: u32 = 530;
pub const __NR_x32_get_robust_list: u32 = 531;
pub const __NR_x32_vmsplice: u32 = 532;
pub const __NR_x32_move_pages: u32 = 533;
pub const __NR_x32_preadv: u32 = 534;
pub const __NR_x32_pwritev: u32 = 535;
pub const __NR_x32_rt_tgsigqueueinfo: u32 = 536;
pub const __NR_x32_recvmmsg: u32 = 537;
pub const __NR_x32_sendmmsg: u32 = 538;
pub const __NR_x32_process_vm_readv: u32 = 539;
pub const __NR_x32_process_vm_writev: u32 = 540;
pub const __NR_x32_setsockopt: u32 = 541;
pub const __NR_x32_getsockopt: u32 = 542;
pub const __NR_x32_io_setup: u32 = 543;
pub const __NR_x32_io_submit: u32 = 544;
pub const __NR_x32_execveat: u32 = 545;
pub const __NR_x32_preadv2: u32 = 546;
pub const __NR_x32_pwritev2: u32 = 547;
pub const __NR_x32_syscalls: u32 = 548;
pub const __NR_ia32_restart_syscall: u32 = 0;
pub const __NR_ia32_exit: u32 = 1;
pub const __NR_ia32_fork: u32 = 2;
pub const __NR_ia32_read: u32 = 3;
pub const __NR_ia32_write: u32 = 4;
pub const __NR_ia32_open: u32 = 5;
pub const __NR_ia32_close: u32 = 6;
pub const __NR_ia32_waitpid: u32 = 7;
pub const __NR_ia32_creat: u32 = 8;
pub const __NR_ia32_link: u32 = 9;
pub const __NR_ia32_unlink: u32 = 10;
pub const __NR_ia32_execve: u32 = 11;
pub const __NR_ia32_chdir: u32 = 12;
pub const __NR_ia32_time: u32 = 13;
pub const __NR_ia32_mknod: u32 = 14;
pub const __NR_ia32_chmod: u32 = 15;
pub const __NR_ia32_lchown: u32 = 16;
pub const __NR_ia32_break: u32 = 17;
pub const __NR_ia32_oldstat: u32 = 18;
pub const __NR_ia32_lseek: u32 = 19;
pub const __NR_ia32_getpid: u32 = 20;
pub const __NR_ia32_mount: u32 = 21;
pub const __NR_ia32_umount: u32 = 22;
pub const __NR_ia32_setuid: u32 = 23;
pub const __NR_ia32_getuid: u32 = 24;
pub const __NR_ia32_stime: u32 = 25;
pub const __NR_ia32_ptrace: u32 = 26;
pub const __NR_ia32_alarm: u32 = 27;
pub const __NR_ia32_oldfstat: u32 = 28;
pub const __NR_ia32_pause: u32 = 29;
pub const __NR_ia32_utime: u32 = 30;
pub const __NR_ia32_stty: u32 = 31;
pub const __NR_ia32_gtty: u32 = 32;
pub const __NR_ia32_access: u32 = 33;
pub const __NR_ia32_nice: u32 = 34;
pub const __NR_ia32_ftime: u32 = 35;
pub const __NR_ia32_sync: u32 = 36;
pub const __NR_ia32_kill: u32 = 37;
pub const __NR_ia32_rename: u32 = 38;
pub const __NR_ia32_mkdir: u32 = 39;
pub const __NR_ia32_rmdir: u32 = 40;
pub const __NR_ia32_dup: u32 = 41;
pub const __NR_ia32_pipe: u32 = 42;
pub const __NR_ia32_times: u32 = 43;
pub const __NR_ia32_prof: u32 = 44;
pub const __NR_ia32_brk: u32 = 45;
pub const __NR_ia32_setgid: u32 = 46;
pub const __NR_ia32_getgid: u32 = 47;
pub const __NR_ia32_signal: u32 = 48;
pub const __NR_ia32_geteuid: u32 = 49;
pub const __NR_ia32_getegid: u32 = 50;
pub const __NR_ia32_acct: u32 = 51;
pub const __NR_ia32_umount2: u32 = 52;
pub const __NR_ia32_lock: u32 = 53;
pub const __NR_ia32_ioctl: u32 = 54;
pub const __NR_ia32_fcntl: u32 = 55;
pub const __NR_ia32_mpx: u32 = 56;
pub const __NR_ia32_setpgid: u32 = 57;
pub const __NR_ia32_ulimit: u32 = 58;
pub const __NR_ia32_oldolduname: u32 = 59;
pub const __NR_ia32_umask: u32 = 60;
pub const __NR_ia32_chroot: u32 = 61;
pub const __NR_ia32_ustat: u32 = 62;
pub const __NR_ia32_dup2: u32 = 63;
pub const __NR_ia32_getppid: u32 = 64;
pub const __NR_ia32_getpgrp: u32 = 65;
pub const __NR_ia32_setsid: u32 = 66;
pub const __NR_ia32_sigaction: u32 = 67;
pub const __NR_ia32_sgetmask: u32 = 68;
pub const __NR_ia32_ssetmask: u32 = 69;
pub const __NR_ia32_setreuid: u32 = 70;
pub const __NR_ia32_setregid: u32 = 71;
pub const __NR_ia32_sigsuspend: u32 = 72;
pub const __NR_ia32_sigpending: u32 = 73;
pub const __NR_ia32_sethostname: u32 = 74;
pub const __NR_ia32_setrlimit: u32 = 75;
pub const __NR_ia32_getrlimit: u32 = 76;
pub const __NR_ia32_getrusage: u32 = 77;
pub const __NR_ia32_gettimeofday: u32 = 78;
pub const __NR_ia32_settimeofday: u32 = 79;
pub const __NR_ia32_getgroups: u32 = 80;
pub const __NR_ia32_setgroups: u32 = 81;
pub const __NR_ia32_select: u32 = 82;
pub const __NR_ia32_symlink: u32 = 83;
pub const __NR_ia32_oldlstat: u32 = 84;
pub const __NR_ia32_readlink: u32 = 85;
pub const __NR_ia32_uselib: u32 = 86;
pub const __NR_ia32_swapon: u32 = 87;
pub const __NR_ia32_reboot: u32 = 88;
pub const __NR_ia32_readdir: u32 = 89;
pub const __NR_ia32_mmap: u32 = 90;
pub const __NR_ia32_munmap: u32 = 91;
pub const __NR_ia32_truncate: u32 = 92;
pub const __NR_ia32_ftruncate: u32 = 93;
pub const __NR_ia32_fchmod: u32 = 94;
pub const __NR_ia32_fchown: u32 = 95;
pub const __NR_ia32_getpriority: u32 = 96;
pub const __NR_ia32_setpriority: u32 = 97;
pub const __NR_ia32_profil: u32 = 98;
pub const __NR_ia32_statfs: u32 = 99;
pub const __NR_ia32_fstatfs: u32 = 100;
pub const __NR_ia32_ioperm: u32 = 101;
pub const __NR_ia32_socketcall: u32 = 102;
pub const __NR_ia32_syslog: u32 = 103;
pub const __NR_ia32_setitimer: u32 = 104;
pub const __NR_ia32_getitimer: u32 = 105;
pub const __NR_ia32_stat: u32 = 106;
pub const __NR_ia32_lstat: u32 = 107;
pub const __NR_ia32_fstat: u32 = 108;
pub const __NR_ia32_olduname: u32 = 109;
pub const __NR_ia32_iopl: u32 = 110;
pub const __NR_ia32_vhangup: u32 = 111;
pub const __NR_ia32_idle: u32 = 112;
pub const __NR_ia32_vm86old: u32 = 113;
pub const __NR_ia32_wait4: u32 = 114;
pub const __NR_ia32_swapoff: u32 = 115;
pub const __NR_ia32_sysinfo: u32 = 116;
pub const __NR_ia32_ipc: u32 = 117;
pub const __NR_ia32_fsync: u32 = 118;
pub const __NR_ia32_sigreturn: u32 = 119;
pub const __NR_ia32_clone: u32 = 120;
pub const __NR_ia32_setdomainname: u32 = 121;
pub const __NR_ia32_uname: u32 = 122;
pub const __NR_ia32_modify_ldt: u32 = 123;
pub const __NR_ia32_adjtimex: u32 = 124;
pub const __NR_ia32_mprotect: u32 = 125;
pub const __NR_ia32_sigprocmask: u32 = 126;
pub const __NR_ia32_create_module: u32 = 127;
pub const __NR_ia32_init_module: u32 = 128;
pub const __NR_ia32_delete_module: u32 = 129;
pub const __NR_ia32_get_kernel_syms: u32 = 130;
pub const __NR_ia32_quotactl: u32 = 131;
pub const __NR_ia32_getpgid: u32 = 132;
pub const __NR_ia32_fchdir: u32 = 133;
pub const __NR_ia32_bdflush: u32 = 134;
pub const __NR_ia32_sysfs: u32 = 135;
pub const __NR_ia32_personality: u32 = 136;
pub const __NR_ia32_afs_syscall: u32 = 137;
pub const __NR_ia32_setfsuid: u32 = 138;
pub const __NR_ia32_setfsgid: u32 = 139;
pub const __NR_ia32__llseek: u32 = 140;
pub const __NR_ia32_getdents: u32 = 141;
pub const __NR_ia32__newselect: u32 = 142;
pub const __NR_ia32_flock: u32 = 143;
pub const __NR_ia32_msync: u32 = 144;
pub const __NR_ia32_readv: u32 = 145;
pub const __NR_ia32_writev: u32 = 146;
pub const __NR_ia32_getsid: u32 = 147;
pub const __NR_ia32_fdatasync: u32 = 148;
pub const __NR_ia32__sysctl: u32 = 149;
pub const __NR_ia32_mlock: u32 = 150;
pub const __NR_ia32_munlock: u32 = 151;
pub const __NR_ia32_mlockall: u32 = 152;
pub const __NR_ia32_munlockall: u32 = 153;
pub const __NR_ia32_sched_setparam: u32 = 154;
pub const __NR_ia32_sched_getparam: u32 = 155;
pub const __NR_ia32_sched_setscheduler: u32 = 156;
pub const __NR_ia32_sched_getscheduler: u32 = 157;
pub const __NR_ia32_sched_yield: u32 = 158;
pub const __NR_ia32_sched_get_priority_max: u32 = 159;
pub const __NR_ia32_sched_get_priority_min: u32 = 160;
pub const __NR_ia32_sched_rr_get_interval: u32 = 161;
pub const __NR_ia32_nanosleep: u32 = 162;
pub const __NR_ia32_mremap: u32 = 163;
pub const __NR_ia32_setresuid: u32 = 164;
pub const __NR_ia32_getresuid: u32 = 165;
pub const __NR_ia32_vm86: u32 = 166;
pub const __NR_ia32_query_module: u32 = 167;
pub const __NR_ia32_poll: u32 = 168;
pub const __NR_ia32_nfsservctl: u32 = 169;
pub const __NR_ia32_setresgid: u32 = 170;
pub const __NR_ia32_getresgid: u32 = 171;
pub const __NR_ia32_prctl: u32 = 172;
pub const __NR_ia32_rt_sigreturn: u32 = 173;
pub const __NR_ia32_rt_sigaction: u32 = 174;
pub const __NR_ia32_rt_sigprocmask: u32 = 175;
pub const __NR_ia32_rt_sigpending: u32 = 176;
pub const __NR_ia32_rt_sigtimedwait: u32 = 177;
pub const __NR_ia32_rt_sigqueueinfo: u32 = 178;
pub const __NR_ia32_rt_sigsuspend: u32 = 179;
pub const __NR_ia32_pread64: u32 = 180;
pub const __NR_ia32_pwrite64: u32 = 181;
pub const __NR_ia32_chown: u32 = 182;
pub const __NR_ia32_getcwd: u32 = 183;
pub const __NR_ia32_capget: u32 = 184;
pub const __NR_ia32_capset: u32 = 185;
pub const __NR_ia32_sigaltstack: u32 = 186;
pub const __NR_ia32_sendfile: u32 = 187;
pub const __NR_ia32_getpmsg: u32 = 188;
pub const __NR_ia32_putpmsg: u32 = 189;
pub const __NR_ia32_vfork: u32 = 190;
pub const __NR_ia32_ugetrlimit: u32 = 191;
pub const __NR_ia32_mmap2: u32 = 192;
pub const __NR_ia32_truncate64: u32 = 193;
pub const __NR_ia32_ftruncate64: u32 = 194;
pub const __NR_ia32_stat64: u32 = 195;
pub const __NR_ia32_lstat64: u32 = 196;
pub const __NR_ia32_fstat64: u32 = 197;
pub const __NR_ia32_lchown32: u32 = 198;
pub const __NR_ia32_getuid32: u32 = 199;
pub const __NR_ia32_getgid32: u32 = 200;
pub const __NR_ia32_geteuid32: u32 = 201;
pub const __NR_ia32_getegid32: u32 = 202;
pub const __NR_ia32_setreuid32: u32 = 203;
pub const __NR_ia32_setregid32: u32 = 204;
pub const __NR_ia32_getgroups32: u32 = 205;
pub const __NR_ia32_setgroups32: u32 = 206;
pub const __NR_ia32_fchown32: u32 = 207;
pub const __NR_ia32_setresuid32: u32 = 208;
pub const __NR_ia32_getresuid32: u32 = 209;
pub const __NR_ia32_setresgid32: u32 = 210;
pub const __NR_ia32_getresgid32: u32 = 211;
pub const __NR_ia32_chown32: u32 = 212;
pub const __NR_ia32_setuid32: u32 = 213;
pub const __NR_ia32_setgid32: u32 = 214;
pub const __NR_ia32_setfsuid32: u32 = 215;
pub const __NR_ia32_setfsgid32: u32 = 216;
pub const __NR_ia32_pivot_root: u32 = 217;
pub const __NR_ia32_mincore: u32 = 218;
pub const __NR_ia32_madvise: u32 = 219;
pub const __NR_ia32_getdents64: u32 = 220;
pub const __NR_ia32_fcntl64: u32 = 221;
pub const __NR_ia32_gettid: u32 = 224;
pub const __NR_ia32_readahead: u32 = 225;
pub const __NR_ia32_setxattr: u32 = 226;
pub const __NR_ia32_lsetxattr: u32 = 227;
pub const __NR_ia32_fsetxattr: u32 = 228;
pub const __NR_ia32_getxattr: u32 = 229;
pub const __NR_ia32_lgetxattr: u32 = 230;
pub const __NR_ia32_fgetxattr: u32 = 231;
pub const __NR_ia32_listxattr: u32 = 232;
pub const __NR_ia32_llistxattr: u32 = 233;
pub const __NR_ia32_flistxattr: u32 = 234;
pub const __NR_ia32_removexattr: u32 = 235;
pub const __NR_ia32_lremovexattr: u32 = 236;
pub const __NR_ia32_fremovexattr: u32 = 237;
pub const __NR_ia32_tkill: u32 = 238;
pub const __NR_ia32_sendfile64: u32 = 239;
pub const __NR_ia32_futex: u32 = 240;
pub const __NR_ia32_sched_setaffinity: u32 = 241;
pub const __NR_ia32_sched_getaffinity: u32 = 242;
pub const __NR_ia32_set_thread_area: u32 = 243;
pub const __NR_ia32_get_thread_area: u32 = 244;
pub const __NR_ia32_io_setup: u32 = 245;
pub const __NR_ia32_io_destroy: u32 = 246;
pub const __NR_ia32_io_getevents: u32 = 247;
pub const __NR_ia32_io_submit: u32 = 248;
pub const __NR_ia32_io_cancel: u32 = 249;
pub const __NR_ia32_fadvise64: u32 = 250;
pub const __NR_ia32_exit_group: u32 = 252;
pub const __NR_ia32_lookup_dcookie: u32 = 253;
pub const __NR_ia32_epoll_create: u32 = 254;
pub const __NR_ia32_epoll_ctl: u32 = 255;
pub const __NR_ia32_epoll_wait: u32 = 256;
pub const __NR_ia32_remap_file_pages: u32 = 257;
pub const __NR_ia32_set_tid_address: u32 = 258;
pub const __NR_ia32_timer_create: u32 = 259;
pub const __NR_ia32_timer_settime: u32 = 260;
pub const __NR_ia32_timer_gettime: u32 = 261;
pub const __NR_ia32_timer_getoverrun: u32 = 262;
pub const __NR_ia32_timer_delete: u32 = 263;
pub const __NR_ia32_clock_settime: u32 = 264;
pub const __NR_ia32_clock_gettime: u32 = 265;
pub const __NR_ia32_clock_getres: u32 = 266;
pub const __NR_ia32_clock_nanosleep: u32 = 267;
pub const __NR_ia32_statfs64: u32 = 268;
pub const __NR_ia32_fstatfs64: u32 = 269;
pub const __NR_ia32_tgkill: u32 = 270;
pub const __NR_ia32_utimes: u32 = 271;
pub const __NR_ia32_fadvise64_64: u32 = 272;
pub const __NR_ia32_vserver: u32 = 273;
pub const __NR_ia32_mbind: u32 = 274;
pub const __NR_ia32_get_mempolicy: u32 = 275;
pub const __NR_ia32_set_mempolicy: u32 = 276;
pub const __NR_ia32_mq_open: u32 = 277;
pub const __NR_ia32_mq_unlink: u32 = 278;
pub const __NR_ia32_mq_timedsend: u32 = 279;
pub const __NR_ia32_mq_timedreceive: u32 = 280;
pub const __NR_ia32_mq_notify: u32 = 281;
pub const __NR_ia32_mq_getsetattr: u32 = 282;
pub const __NR_ia32_kexec_load: u32 = 283;
pub const __NR_ia32_waitid: u32 = 284;
pub const __NR_ia32_add_key: u32 = 286;
pub const __NR_ia32_request_key: u32 = 287;
pub const __NR_ia32_keyctl: u32 = 288;
pub const __NR_ia32_ioprio_set: u32 = 289;
pub const __NR_ia32_ioprio_get: u32 = 290;
pub const __NR_ia32_inotify_init: u32 = 291;
pub const __NR_ia32_inotify_add_watch: u32 = 292;
pub const __NR_ia32_inotify_rm_watch: u32 = 293;
pub const __NR_ia32_migrate_pages: u32 = 294;
pub const __NR_ia32_openat: u32 = 295;
pub const __NR_ia32_mkdirat: u32 = 296;
pub const __NR_ia32_mknodat: u32 = 297;
pub const __NR_ia32_fchownat: u32 = 298;
pub const __NR_ia32_futimesat: u32 = 299;
pub const __NR_ia32_fstatat64: u32 = 300;
pub const __NR_ia32_unlinkat: u32 = 301;
pub const __NR_ia32_renameat: u32 = 302;
pub const __NR_ia32_linkat: u32 = 303;
pub const __NR_ia32_symlinkat: u32 = 304;
pub const __NR_ia32_readlinkat: u32 = 305;
pub const __NR_ia32_fchmodat: u32 = 306;
pub const __NR_ia32_faccessat: u32 = 307;
pub const __NR_ia32_pselect6: u32 = 308;
pub const __NR_ia32_ppoll: u32 = 309;
pub const __NR_ia32_unshare: u32 = 310;
pub const __NR_ia32_set_robust_list: u32 = 311;
pub const __NR_ia32_get_robust_list: u32 = 312;
pub const __NR_ia32_splice: u32 = 313;
pub const __NR_ia32_sync_file_range: u32 = 314;
pub const __NR_ia32_tee: u32 = 315;
pub const __NR_ia32_vmsplice: u32 = 316;
pub const __NR_ia32_move_pages: u32 = 317;
pub const __NR_ia32_getcpu: u32 = 318;
pub const __NR_ia32_epoll_pwait: u32 = 319;
pub const __NR_ia32_utimensat: u32 = 320;
pub const __NR_ia32_signalfd: u32 = 321;
pub const __NR_ia32_timerfd_create: u32 = 322;
pub const __NR_ia32_eventfd: u32 = 323;
pub const __NR_ia32_fallocate: u32 = 324;
pub const __NR_ia32_timerfd_settime: u32 = 325;
pub const __NR_ia32_timerfd_gettime: u32 = 326;
pub const __NR_ia32_signalfd4: u32 = 327;
pub const __NR_ia32_eventfd2: u32 = 328;
pub const __NR_ia32_epoll_create1: u32 = 329;
pub const __NR_ia32_dup3: u32 = 330;
pub const __NR_ia32_pipe2: u32 = 331;
pub const __NR_ia32_inotify_init1: u32 = 332;
pub const __NR_ia32_preadv: u32 = 333;
pub const __NR_ia32_pwritev: u32 = 334;
pub const __NR_ia32_rt_tgsigqueueinfo: u32 = 335;
pub const __NR_ia32_perf_event_open: u32 = 336;
pub const __NR_ia32_recvmmsg: u32 = 337;
pub const __NR_ia32_fanotify_init: u32 = 338;
pub const __NR_ia32_fanotify_mark: u32 = 339;
pub const __NR_ia32_prlimit64: u32 = 340;
pub const __NR_ia32_name_to_handle_at: u32 = 341;
pub const __NR_ia32_open_by_handle_at: u32 = 342;
pub const __NR_ia32_clock_adjtime: u32 = 343;
pub const __NR_ia32_syncfs: u32 = 344;
pub const __NR_ia32_sendmmsg: u32 = 345;
pub const __NR_ia32_setns: u32 = 346;
pub const __NR_ia32_process_vm_readv: u32 = 347;
pub const __NR_ia32_process_vm_writev: u32 = 348;
pub const __NR_ia32_kcmp: u32 = 349;
pub const __NR_ia32_finit_module: u32 = 350;
pub const __NR_ia32_sched_setattr: u32 = 351;
pub const __NR_ia32_sched_getattr: u32 = 352;
pub const __NR_ia32_renameat2: u32 = 353;
pub const __NR_ia32_seccomp: u32 = 354;
pub const __NR_ia32_getrandom: u32 = 355;
pub const __NR_ia32_memfd_create: u32 = 356;
pub const __NR_ia32_bpf: u32 = 357;
pub const __NR_ia32_execveat: u32 = 358;
pub const __NR_ia32_socket: u32 = 359;
pub const __NR_ia32_socketpair: u32 = 360;
pub const __NR_ia32_bind: u32 = 361;
pub const __NR_ia32_connect: u32 = 362;
pub const __NR_ia32_listen: u32 = 363;
pub const __NR_ia32_accept4: u32 = 364;
pub const __NR_ia32_getsockopt: u32 = 365;
pub const __NR_ia32_setsockopt: u32 = 366;
pub const __NR_ia32_getsockname: u32 = 367;
pub const __NR_ia32_getpeername: u32 = 368;
pub const __NR_ia32_sendto: u32 = 369;
pub const __NR_ia32_sendmsg: u32 = 370;
pub const __NR_ia32_recvfrom: u32 = 371;
pub const __NR_ia32_recvmsg: u32 = 372;
pub const __NR_ia32_shutdown: u32 = 373;
pub const __NR_ia32_userfaultfd: u32 = 374;
pub const __NR_ia32_membarrier: u32 = 375;
pub const __NR_ia32_mlock2: u32 = 376;
pub const __NR_ia32_copy_file_range: u32 = 377;
pub const __NR_ia32_preadv2: u32 = 378;
pub const __NR_ia32_pwritev2: u32 = 379;
pub const __NR_ia32_pkey_mprotect: u32 = 380;
pub const __NR_ia32_pkey_alloc: u32 = 381;
pub const __NR_ia32_pkey_free: u32 = 382;
pub const __NR_ia32_statx: u32 = 383;
pub const __NR_ia32_arch_prctl: u32 = 384;
pub const __NR_ia32_io_pgetevents: u32 = 385;
pub const __NR_ia32_rseq: u32 = 386;
pub const __NR_ia32_semget: u32 = 393;
pub const __NR_ia32_semctl: u32 = 394;
pub const __NR_ia32_shmget: u32 = 395;
pub const __NR_ia32_shmctl: u32 = 396;
pub const __NR_ia32_shmat: u32 = 397;
pub const __NR_ia32_shmdt: u32 = 398;
pub const __NR_ia32_msgget: u32 = 399;
pub const __NR_ia32_msgsnd: u32 = 400;
pub const __NR_ia32_msgrcv: u32 = 401;
pub const __NR_ia32_msgctl: u32 = 402;
pub const __NR_ia32_clock_gettime64: u32 = 403;
pub const __NR_ia32_clock_settime64: u32 = 404;
pub const __NR_ia32_clock_adjtime64: u32 = 405;
pub const __NR_ia32_clock_getres_time64: u32 = 406;
pub const __NR_ia32_clock_nanosleep_time64: u32 = 407;
pub const __NR_ia32_timer_gettime64: u32 = 408;
pub const __NR_ia32_timer_settime64: u32 = 409;
pub const __NR_ia32_timerfd_gettime64: u32 = 410;
pub const __NR_ia32_timerfd_settime64: u32 = 411;
pub const __NR_ia32_utimensat_time64: u32 = 412;
pub const __NR_ia32_pselect6_time64: u32 = 413;
pub const __NR_ia32_ppoll_time64: u32 = 414;
pub const __NR_ia32_io_pgetevents_time64: u32 = 416;
pub const __NR_ia32_recvmmsg_time64: u32 = 417;
pub const __NR_ia32_mq_timedsend_time64: u32 = 418;
pub const __NR_ia32_mq_timedreceive_time64: u32 = 419;
pub const __NR_ia32_semtimedop_time64: u32 = 420;
pub const __NR_ia32_rt_sigtimedwait_time64: u32 = 421;
pub const __NR_ia32_futex_time64: u32 = 422;
pub const __NR_ia32_sched_rr_get_interval_time64: u32 = 423;
pub const __NR_ia32_pidfd_send_signal: u32 = 424;
pub const __NR_ia32_io_uring_setup: u32 = 425;
pub const __NR_ia32_io_uring_enter: u32 = 426;
pub const __NR_ia32_io_uring_register: u32 = 427;
pub const __NR_ia32_open_tree: u32 = 428;
pub const __NR_ia32_move_mount: u32 = 429;
pub const __NR_ia32_fsopen: u32 = 430;
pub const __NR_ia32_fsconfig: u32 = 431;
pub const __NR_ia32_fsmount: u32 = 432;
pub const __NR_ia32_fspick: u32 = 433;
pub const __NR_ia32_pidfd_open: u32 = 434;
pub const __NR_ia32_clone3: u32 = 435;
pub const __NR_ia32_close_range: u32 = 436;
pub const __NR_ia32_openat2: u32 = 437;
pub const __NR_ia32_pidfd_getfd: u32 = 438;
pub const __NR_ia32_faccessat2: u32 = 439;
pub const __NR_ia32_process_madvise: u32 = 440;
pub const __NR_ia32_epoll_pwait2: u32 = 441;
pub const __NR_ia32_mount_setattr: u32 = 442;
pub const __NR_ia32_quotactl_fd: u32 = 443;
pub const __NR_ia32_landlock_create_ruleset: u32 = 444;
pub const __NR_ia32_landlock_add_rule: u32 = 445;
pub const __NR_ia32_landlock_restrict_self: u32 = 446;
pub const __NR_ia32_memfd_secret: u32 = 447;
pub const __NR_ia32_process_mrelease: u32 = 448;
pub const __NR_ia32_futex_waitv: u32 = 449;
pub const __NR_ia32_set_mempolicy_home_node: u32 = 450;
pub const __NR_ia32_cachestat: u32 = 451;
pub const __NR_ia32_fchmodat2: u32 = 452;
pub const __NR_ia32_map_shadow_stack: u32 = 453;
pub const __NR_ia32_futex_wake: u32 = 454;
pub const __NR_ia32_futex_wait: u32 = 455;
pub const __NR_ia32_futex_requeue: u32 = 456;
pub const __NR_ia32_statmount: u32 = 457;
pub const __NR_ia32_listmount: u32 = 458;
pub const __NR_ia32_lsm_get_self_attr: u32 = 459;
pub const __NR_ia32_lsm_set_self_attr: u32 = 460;
pub const __NR_ia32_lsm_list_modules: u32 = 461;
pub const __NR_ia32_syscalls: u32 = 462;
pub const X32_NR_syscalls: u32 = 548;
pub const IA32_NR_syscalls: u32 = 462;
pub const NR_syscalls: u32 = 462;
pub const ADFS_SUPER_MAGIC: u32 = 44533;
pub const AFFS_SUPER_MAGIC: u32 = 44543;
pub const AFS_SUPER_MAGIC: u32 = 1397113167;
pub const AUTOFS_SUPER_MAGIC: u32 = 391;
pub const CEPH_SUPER_MAGIC: u32 = 12805120;
pub const CODA_SUPER_MAGIC: u32 = 1937076805;
pub const CRAMFS_MAGIC: u32 = 684539205;
pub const CRAMFS_MAGIC_WEND: u32 = 1161678120;
pub const DEBUGFS_MAGIC: u32 = 1684170528;
pub const SECURITYFS_MAGIC: u32 = 1935894131;
pub const SELINUX_MAGIC: u32 = 4185718668;
pub const SMACK_MAGIC: u32 = 1128357203;
pub const RAMFS_MAGIC: u32 = 2240043254;
pub const TMPFS_MAGIC: u32 = 16914836;
pub const HUGETLBFS_MAGIC: u32 = 2508478710;
pub const SQUASHFS_MAGIC: u32 = 1936814952;
pub const ECRYPTFS_SUPER_MAGIC: u32 = 61791;
pub const EFS_SUPER_MAGIC: u32 = 4278867;
pub const EROFS_SUPER_MAGIC_V1: u32 = 3774210530;
pub const EXT2_SUPER_MAGIC: u32 = 61267;
pub const EXT3_SUPER_MAGIC: u32 = 61267;
pub const XENFS_SUPER_MAGIC: u32 = 2881100148;
pub const EXT4_SUPER_MAGIC: u32 = 61267;
pub const BTRFS_SUPER_MAGIC: u32 = 2435016766;
pub const NILFS_SUPER_MAGIC: u32 = 13364;
pub const F2FS_SUPER_MAGIC: u32 = 4076150800;
pub const HPFS_SUPER_MAGIC: u32 = 4187351113;
pub const ISOFS_SUPER_MAGIC: u32 = 38496;
pub const JFFS2_SUPER_MAGIC: u32 = 29366;
pub const XFS_SUPER_MAGIC: u32 = 1481003842;
pub const PSTOREFS_MAGIC: u32 = 1634035564;
pub const EFIVARFS_MAGIC: u32 = 3730735588;
pub const HOSTFS_SUPER_MAGIC: u32 = 12648430;
pub const OVERLAYFS_SUPER_MAGIC: u32 = 2035054128;
pub const FUSE_SUPER_MAGIC: u32 = 1702057286;
pub const MINIX_SUPER_MAGIC: u32 = 4991;
pub const MINIX_SUPER_MAGIC2: u32 = 5007;
pub const MINIX2_SUPER_MAGIC: u32 = 9320;
pub const MINIX2_SUPER_MAGIC2: u32 = 9336;
pub const MINIX3_SUPER_MAGIC: u32 = 19802;
pub const MSDOS_SUPER_MAGIC: u32 = 19780;
pub const EXFAT_SUPER_MAGIC: u32 = 538032816;
pub const NCP_SUPER_MAGIC: u32 = 22092;
pub const NFS_SUPER_MAGIC: u32 = 26985;
pub const OCFS2_SUPER_MAGIC: u32 = 1952539503;
pub const OPENPROM_SUPER_MAGIC: u32 = 40865;
pub const QNX4_SUPER_MAGIC: u32 = 47;
pub const QNX6_SUPER_MAGIC: u32 = 1746473250;
pub const AFS_FS_MAGIC: u32 = 1799439955;
pub const REISERFS_SUPER_MAGIC: u32 = 1382369651;
pub const REISERFS_SUPER_MAGIC_STRING: &[u8; 9usize] = b"ReIsErFs\0";
pub const REISER2FS_SUPER_MAGIC_STRING: &[u8; 10usize] = b"ReIsEr2Fs\0";
pub const REISER2FS_JR_SUPER_MAGIC_STRING: &[u8; 10usize] = b"ReIsEr3Fs\0";
pub const SMB_SUPER_MAGIC: u32 = 20859;
pub const CIFS_SUPER_MAGIC: u32 = 4283649346;
pub const SMB2_SUPER_MAGIC: u32 = 4266872130;
pub const CGROUP_SUPER_MAGIC: u32 = 2613483;
pub const CGROUP2_SUPER_MAGIC: u32 = 1667723888;
pub const RDTGROUP_SUPER_MAGIC: u32 = 124082209;
pub const STACK_END_MAGIC: u32 = 1470918301;
pub const TRACEFS_MAGIC: u32 = 1953653091;
pub const V9FS_MAGIC: u32 = 16914839;
pub const BDEVFS_MAGIC: u32 = 1650746742;
pub const DAXFS_MAGIC: u32 = 1684300152;
pub const BINFMTFS_MAGIC: u32 = 1112100429;
pub const DEVPTS_SUPER_MAGIC: u32 = 7377;
pub const BINDERFS_SUPER_MAGIC: u32 = 1819242352;
pub const FUTEXFS_SUPER_MAGIC: u32 = 195894762;
pub const PIPEFS_MAGIC: u32 = 1346981957;
pub const PROC_SUPER_MAGIC: u32 = 40864;
pub const SOCKFS_MAGIC: u32 = 1397703499;
pub const SYSFS_MAGIC: u32 = 1650812274;
pub const USBDEVICE_SUPER_MAGIC: u32 = 40866;
pub const MTD_INODE_FS_MAGIC: u32 = 288389204;
pub const ANON_INODE_FS_MAGIC: u32 = 151263540;
pub const BTRFS_TEST_MAGIC: u32 = 1936880249;
pub const NSFS_MAGIC: u32 = 1853056627;
pub const BPF_FS_MAGIC: u32 = 3405662737;
pub const AAFS_MAGIC: u32 = 1513908720;
pub const ZONEFS_MAGIC: u32 = 1515144787;
pub const UDF_SUPER_MAGIC: u32 = 352400198;
pub const DMA_BUF_MAGIC: u32 = 1145913666;
pub const DEVMEM_MAGIC: u32 = 1162691661;
pub const SECRETMEM_MAGIC: u32 = 1397048141;
pub const COMPAT_USER_HZ: u32 = 100;
pub const COMPAT_RLIM_INFINITY: u32 = 4294967295;
pub const COMPAT_OFF_T_MAX: u32 = 2147483647;
pub const _COMPAT_NSIG: u32 = 64;
pub const _COMPAT_NSIG_BPW: u32 = 32;
pub const COMPAT_UTS_MACHINE: &[u8; 7usize] = b"i686\0\0\0";
pub const COMPAT_USE_64BIT_TIME: u32 = 0;
pub const COMPAT_MINSIGSTKSZ: u32 = 2048;
pub const _COMPAT_NSIG_WORDS: u32 = 2;
pub const STAT64_HAS_BROKEN_ST_INO: u32 = 1;
pub const USER_XSTATE_FX_SW_WORDS: u32 = 6;
pub const USER_XSTATE_XCR0_WORD: u32 = 0;
pub const R_X86_64_NONE: u32 = 0;
pub const R_X86_64_64: u32 = 1;
pub const R_X86_64_PC32: u32 = 2;
pub const R_X86_64_GOT32: u32 = 3;
pub const R_X86_64_PLT32: u32 = 4;
pub const R_X86_64_COPY: u32 = 5;
pub const R_X86_64_GLOB_DAT: u32 = 6;
pub const R_X86_64_JUMP_SLOT: u32 = 7;
pub const R_X86_64_RELATIVE: u32 = 8;
pub const R_X86_64_GOTPCREL: u32 = 9;
pub const R_X86_64_32: u32 = 10;
pub const R_X86_64_32S: u32 = 11;
pub const R_X86_64_16: u32 = 12;
pub const R_X86_64_PC16: u32 = 13;
pub const R_X86_64_8: u32 = 14;
pub const R_X86_64_PC8: u32 = 15;
pub const R_X86_64_PC64: u32 = 24;
pub const COMPAT_ELF_PLATFORM: &[u8; 5usize] = b"i686\0";
pub const ELF_PLATFORM: &[u8; 7usize] = b"x86_64\0";
pub const ELF_EXEC_PAGESIZE: u32 = 4096;
pub const AT_SYSINFO: u32 = 32;
pub const ARCH_HAS_SETUP_ADDITIONAL_PAGES: u32 = 1;
pub const EM_NONE: u32 = 0;
pub const EM_M32: u32 = 1;
pub const EM_SPARC: u32 = 2;
pub const EM_386: u32 = 3;
pub const EM_68K: u32 = 4;
pub const EM_88K: u32 = 5;
pub const EM_486: u32 = 6;
pub const EM_860: u32 = 7;
pub const EM_MIPS: u32 = 8;
pub const EM_MIPS_RS3_LE: u32 = 10;
pub const EM_MIPS_RS4_BE: u32 = 10;
pub const EM_PARISC: u32 = 15;
pub const EM_SPARC32PLUS: u32 = 18;
pub const EM_PPC: u32 = 20;
pub const EM_PPC64: u32 = 21;
pub const EM_SPU: u32 = 23;
pub const EM_ARM: u32 = 40;
pub const EM_SH: u32 = 42;
pub const EM_SPARCV9: u32 = 43;
pub const EM_H8_300: u32 = 46;
pub const EM_IA_64: u32 = 50;
pub const EM_X86_64: u32 = 62;
pub const EM_S390: u32 = 22;
pub const EM_CRIS: u32 = 76;
pub const EM_M32R: u32 = 88;
pub const EM_MN10300: u32 = 89;
pub const EM_OPENRISC: u32 = 92;
pub const EM_ARCOMPACT: u32 = 93;
pub const EM_XTENSA: u32 = 94;
pub const EM_BLACKFIN: u32 = 106;
pub const EM_UNICORE: u32 = 110;
pub const EM_ALTERA_NIOS2: u32 = 113;
pub const EM_TI_C6000: u32 = 140;
pub const EM_HEXAGON: u32 = 164;
pub const EM_NDS32: u32 = 167;
pub const EM_AARCH64: u32 = 183;
pub const EM_TILEPRO: u32 = 188;
pub const EM_MICROBLAZE: u32 = 189;
pub const EM_TILEGX: u32 = 191;
pub const EM_ARCV2: u32 = 195;
pub const EM_RISCV: u32 = 243;
pub const EM_BPF: u32 = 247;
pub const EM_CSKY: u32 = 252;
pub const EM_LOONGARCH: u32 = 258;
pub const EM_FRV: u32 = 21569;
pub const EM_ALPHA: u32 = 36902;
pub const EM_CYGNUS_M32R: u32 = 36929;
pub const EM_S390_OLD: u32 = 41872;
pub const EM_CYGNUS_MN10300: u32 = 48879;
pub const PT_NULL: u32 = 0;
pub const PT_LOAD: u32 = 1;
pub const PT_DYNAMIC: u32 = 2;
pub const PT_INTERP: u32 = 3;
pub const PT_NOTE: u32 = 4;
pub const PT_SHLIB: u32 = 5;
pub const PT_PHDR: u32 = 6;
pub const PT_TLS: u32 = 7;
pub const PT_LOOS: u32 = 1610612736;
pub const PT_HIOS: u32 = 1879048191;
pub const PT_LOPROC: u32 = 1879048192;
pub const PT_HIPROC: u32 = 2147483647;
pub const PT_GNU_EH_FRAME: u32 = 1685382480;
pub const PT_GNU_STACK: u32 = 1685382481;
pub const PT_GNU_RELRO: u32 = 1685382482;
pub const PT_GNU_PROPERTY: u32 = 1685382483;
pub const PT_AARCH64_MEMTAG_MTE: u32 = 1879048194;
pub const PN_XNUM: u32 = 65535;
pub const ET_NONE: u32 = 0;
pub const ET_REL: u32 = 1;
pub const ET_EXEC: u32 = 2;
pub const ET_DYN: u32 = 3;
pub const ET_CORE: u32 = 4;
pub const ET_LOPROC: u32 = 65280;
pub const ET_HIPROC: u32 = 65535;
pub const DT_NULL: u32 = 0;
pub const DT_NEEDED: u32 = 1;
pub const DT_PLTRELSZ: u32 = 2;
pub const DT_PLTGOT: u32 = 3;
pub const DT_HASH: u32 = 4;
pub const DT_STRTAB: u32 = 5;
pub const DT_SYMTAB: u32 = 6;
pub const DT_RELA: u32 = 7;
pub const DT_RELASZ: u32 = 8;
pub const DT_RELAENT: u32 = 9;
pub const DT_STRSZ: u32 = 10;
pub const DT_SYMENT: u32 = 11;
pub const DT_INIT: u32 = 12;
pub const DT_FINI: u32 = 13;
pub const DT_SONAME: u32 = 14;
pub const DT_RPATH: u32 = 15;
pub const DT_SYMBOLIC: u32 = 16;
pub const DT_REL: u32 = 17;
pub const DT_RELSZ: u32 = 18;
pub const DT_RELENT: u32 = 19;
pub const DT_PLTREL: u32 = 20;
pub const DT_DEBUG: u32 = 21;
pub const DT_TEXTREL: u32 = 22;
pub const DT_JMPREL: u32 = 23;
pub const DT_ENCODING: u32 = 32;
pub const OLD_DT_LOOS: u32 = 1610612736;
pub const DT_LOOS: u32 = 1610612749;
pub const DT_HIOS: u32 = 1879044096;
pub const DT_VALRNGLO: u32 = 1879047424;
pub const DT_VALRNGHI: u32 = 1879047679;
pub const DT_ADDRRNGLO: u32 = 1879047680;
pub const DT_ADDRRNGHI: u32 = 1879047935;
pub const DT_VERSYM: u32 = 1879048176;
pub const DT_RELACOUNT: u32 = 1879048185;
pub const DT_RELCOUNT: u32 = 1879048186;
pub const DT_FLAGS_1: u32 = 1879048187;
pub const DT_VERDEF: u32 = 1879048188;
pub const DT_VERDEFNUM: u32 = 1879048189;
pub const DT_VERNEED: u32 = 1879048190;
pub const DT_VERNEEDNUM: u32 = 1879048191;
pub const OLD_DT_HIOS: u32 = 1879048191;
pub const DT_LOPROC: u32 = 1879048192;
pub const DT_HIPROC: u32 = 2147483647;
pub const STB_LOCAL: u32 = 0;
pub const STB_GLOBAL: u32 = 1;
pub const STB_WEAK: u32 = 2;
pub const STT_NOTYPE: u32 = 0;
pub const STT_OBJECT: u32 = 1;
pub const STT_FUNC: u32 = 2;
pub const STT_SECTION: u32 = 3;
pub const STT_FILE: u32 = 4;
pub const STT_COMMON: u32 = 5;
pub const STT_TLS: u32 = 6;
pub const EI_NIDENT: u32 = 16;
pub const PF_R: u32 = 4;
pub const PF_W: u32 = 2;
pub const PF_X: u32 = 1;
pub const SHT_NULL: u32 = 0;
pub const SHT_PROGBITS: u32 = 1;
pub const SHT_SYMTAB: u32 = 2;
pub const SHT_STRTAB: u32 = 3;
pub const SHT_RELA: u32 = 4;
pub const SHT_HASH: u32 = 5;
pub const SHT_DYNAMIC: u32 = 6;
pub const SHT_NOTE: u32 = 7;
pub const SHT_NOBITS: u32 = 8;
pub const SHT_REL: u32 = 9;
pub const SHT_SHLIB: u32 = 10;
pub const SHT_DYNSYM: u32 = 11;
pub const SHT_NUM: u32 = 12;
pub const SHT_LOPROC: u32 = 1879048192;
pub const SHT_HIPROC: u32 = 2147483647;
pub const SHT_LOUSER: u32 = 2147483648;
pub const SHT_HIUSER: u32 = 4294967295;
pub const SHF_WRITE: u32 = 1;
pub const SHF_ALLOC: u32 = 2;
pub const SHF_EXECINSTR: u32 = 4;
pub const SHF_RELA_LIVEPATCH: u32 = 1048576;
pub const SHF_RO_AFTER_INIT: u32 = 2097152;
pub const SHF_MASKPROC: u32 = 4026531840;
pub const SHN_UNDEF: u32 = 0;
pub const SHN_LORESERVE: u32 = 65280;
pub const SHN_LOPROC: u32 = 65280;
pub const SHN_HIPROC: u32 = 65311;
pub const SHN_LIVEPATCH: u32 = 65312;
pub const SHN_ABS: u32 = 65521;
pub const SHN_COMMON: u32 = 65522;
pub const SHN_HIRESERVE: u32 = 65535;
pub const EI_MAG0: u32 = 0;
pub const EI_MAG1: u32 = 1;
pub const EI_MAG2: u32 = 2;
pub const EI_MAG3: u32 = 3;
pub const EI_CLASS: u32 = 4;
pub const EI_DATA: u32 = 5;
pub const EI_VERSION: u32 = 6;
pub const EI_OSABI: u32 = 7;
pub const EI_PAD: u32 = 8;
pub const ELFMAG0: u32 = 127;
pub const ELFMAG1: u8 = 69u8;
pub const ELFMAG2: u8 = 76u8;
pub const ELFMAG3: u8 = 70u8;
pub const ELFMAG: &[u8; 5usize] = b"\x7FELF\0";
pub const SELFMAG: u32 = 4;
pub const ELFCLASSNONE: u32 = 0;
pub const ELFCLASS32: u32 = 1;
pub const ELFCLASS64: u32 = 2;
pub const ELFCLASSNUM: u32 = 3;
pub const ELFDATANONE: u32 = 0;
pub const ELFDATA2LSB: u32 = 1;
pub const ELFDATA2MSB: u32 = 2;
pub const EV_NONE: u32 = 0;
pub const EV_CURRENT: u32 = 1;
pub const EV_NUM: u32 = 2;
pub const ELFOSABI_NONE: u32 = 0;
pub const ELFOSABI_LINUX: u32 = 3;
pub const ELF_OSABI: u32 = 0;
pub const NT_PRSTATUS: u32 = 1;
pub const NT_PRFPREG: u32 = 2;
pub const NT_PRPSINFO: u32 = 3;
pub const NT_TASKSTRUCT: u32 = 4;
pub const NT_AUXV: u32 = 6;
pub const NT_SIGINFO: u32 = 1397311305;
pub const NT_FILE: u32 = 1179208773;
pub const NT_PRXFPREG: u32 = 1189489535;
pub const NT_PPC_VMX: u32 = 256;
pub const NT_PPC_SPE: u32 = 257;
pub const NT_PPC_VSX: u32 = 258;
pub const NT_PPC_TAR: u32 = 259;
pub const NT_PPC_PPR: u32 = 260;
pub const NT_PPC_DSCR: u32 = 261;
pub const NT_PPC_EBB: u32 = 262;
pub const NT_PPC_PMU: u32 = 263;
pub const NT_PPC_TM_CGPR: u32 = 264;
pub const NT_PPC_TM_CFPR: u32 = 265;
pub const NT_PPC_TM_CVMX: u32 = 266;
pub const NT_PPC_TM_CVSX: u32 = 267;
pub const NT_PPC_TM_SPR: u32 = 268;
pub const NT_PPC_TM_CTAR: u32 = 269;
pub const NT_PPC_TM_CPPR: u32 = 270;
pub const NT_PPC_TM_CDSCR: u32 = 271;
pub const NT_PPC_PKEY: u32 = 272;
pub const NT_PPC_DEXCR: u32 = 273;
pub const NT_PPC_HASHKEYR: u32 = 274;
pub const NT_386_TLS: u32 = 512;
pub const NT_386_IOPERM: u32 = 513;
pub const NT_X86_XSTATE: u32 = 514;
pub const NT_X86_SHSTK: u32 = 516;
pub const NT_S390_HIGH_GPRS: u32 = 768;
pub const NT_S390_TIMER: u32 = 769;
pub const NT_S390_TODCMP: u32 = 770;
pub const NT_S390_TODPREG: u32 = 771;
pub const NT_S390_CTRS: u32 = 772;
pub const NT_S390_PREFIX: u32 = 773;
pub const NT_S390_LAST_BREAK: u32 = 774;
pub const NT_S390_SYSTEM_CALL: u32 = 775;
pub const NT_S390_TDB: u32 = 776;
pub const NT_S390_VXRS_LOW: u32 = 777;
pub const NT_S390_VXRS_HIGH: u32 = 778;
pub const NT_S390_GS_CB: u32 = 779;
pub const NT_S390_GS_BC: u32 = 780;
pub const NT_S390_RI_CB: u32 = 781;
pub const NT_S390_PV_CPU_DATA: u32 = 782;
pub const NT_ARM_VFP: u32 = 1024;
pub const NT_ARM_TLS: u32 = 1025;
pub const NT_ARM_HW_BREAK: u32 = 1026;
pub const NT_ARM_HW_WATCH: u32 = 1027;
pub const NT_ARM_SYSTEM_CALL: u32 = 1028;
pub const NT_ARM_SVE: u32 = 1029;
pub const NT_ARM_PAC_MASK: u32 = 1030;
pub const NT_ARM_PACA_KEYS: u32 = 1031;
pub const NT_ARM_PACG_KEYS: u32 = 1032;
pub const NT_ARM_TAGGED_ADDR_CTRL: u32 = 1033;
pub const NT_ARM_PAC_ENABLED_KEYS: u32 = 1034;
pub const NT_ARM_SSVE: u32 = 1035;
pub const NT_ARM_ZA: u32 = 1036;
pub const NT_ARM_ZT: u32 = 1037;
pub const NT_ARC_V2: u32 = 1536;
pub const NT_VMCOREDD: u32 = 1792;
pub const NT_MIPS_DSP: u32 = 2048;
pub const NT_MIPS_FP_MODE: u32 = 2049;
pub const NT_MIPS_MSA: u32 = 2050;
pub const NT_RISCV_CSR: u32 = 2304;
pub const NT_RISCV_VECTOR: u32 = 2305;
pub const NT_LOONGARCH_CPUCFG: u32 = 2560;
pub const NT_LOONGARCH_CSR: u32 = 2561;
pub const NT_LOONGARCH_LSX: u32 = 2562;
pub const NT_LOONGARCH_LASX: u32 = 2563;
pub const NT_LOONGARCH_LBT: u32 = 2564;
pub const NT_LOONGARCH_HW_BREAK: u32 = 2565;
pub const NT_LOONGARCH_HW_WATCH: u32 = 2566;
pub const NT_GNU_PROPERTY_TYPE_0: u32 = 5;
pub const GNU_PROPERTY_AARCH64_FEATURE_1_AND: u32 = 3221225472;
pub const GNU_PROPERTY_AARCH64_FEATURE_1_BTI: u32 = 1;
pub const ELF32_GNU_PROPERTY_ALIGN: u32 = 4;
pub const ELF64_GNU_PROPERTY_ALIGN: u32 = 8;
pub const ELF_GNU_PROPERTY_ALIGN: u32 = 8;
pub const IDR_FREE: u32 = 0;
pub const IDA_CHUNK_SIZE: u32 = 128;
pub const KERNFS_TYPE_MASK: u32 = 15;
pub const KERNFS_FLAG_MASK: i32 = -16;
pub const KERNFS_MAX_USER_XATTRS: u32 = 128;
pub const KERNFS_USER_XATTR_SIZE_LIMIT: u32 = 131072;
pub const SYSFS_PREALLOC: u32 = 4096;
pub const UEVENT_HELPER_PATH_LEN: u32 = 256;
pub const UEVENT_NUM_ENVP: u32 = 64;
pub const UEVENT_BUFFER_SIZE: u32 = 2048;
pub const KUNIT_PARAM_DESC_SIZE: u32 = 128;
pub const KUNIT_STATUS_COMMENT_SIZE: u32 = 256;
pub const KUNIT_INDENT_LEN: u32 = 4;
pub const KUNIT_SUBTEST_INDENT: &[u8; 5usize] = b"    \0";
pub const KUNIT_SUBSUBTEST_INDENT: &[u8; 9usize] = b"        \0";
pub const STACK_DEPOT_EXTRA_BITS: u32 = 5;
pub const DEPOT_POOL_ORDER: u32 = 2;
pub const DEPOT_POOL_SIZE: u32 = 16384;
pub const DEPOT_STACK_ALIGN: u32 = 4;
pub const DEPOT_OFFSET_BITS: u32 = 10;
pub const STACK_DEPOT_FLAGS_NUM: u32 = 2;
pub const SZ_1: u32 = 1;
pub const SZ_2: u32 = 2;
pub const SZ_4: u32 = 4;
pub const SZ_8: u32 = 8;
pub const SZ_16: u32 = 16;
pub const SZ_32: u32 = 32;
pub const SZ_64: u32 = 64;
pub const SZ_128: u32 = 128;
pub const SZ_256: u32 = 256;
pub const SZ_512: u32 = 512;
pub const SZ_1K: u32 = 1024;
pub const SZ_2K: u32 = 2048;
pub const SZ_4K: u32 = 4096;
pub const SZ_8K: u32 = 8192;
pub const SZ_16K: u32 = 16384;
pub const SZ_32K: u32 = 32768;
pub const SZ_64K: u32 = 65536;
pub const SZ_128K: u32 = 131072;
pub const SZ_256K: u32 = 262144;
pub const SZ_512K: u32 = 524288;
pub const SZ_1M: u32 = 1048576;
pub const SZ_2M: u32 = 2097152;
pub const SZ_4M: u32 = 4194304;
pub const SZ_8M: u32 = 8388608;
pub const SZ_16M: u32 = 16777216;
pub const SZ_32M: u32 = 33554432;
pub const SZ_64M: u32 = 67108864;
pub const SZ_128M: u32 = 134217728;
pub const SZ_256M: u32 = 268435456;
pub const SZ_512M: u32 = 536870912;
pub const SZ_1G: u32 = 1073741824;
pub const SZ_2G: u32 = 2147483648;
pub const PMD_ORDER: u32 = 9;
pub const PUD_ORDER: u32 = 18;
pub const USER_PGTABLES_CEILING: u32 = 0;
pub const FIRST_USER_ADDRESS: u32 = 0;
pub const __PGTBL_PGD_MODIFIED: u32 = 0;
pub const __PGTBL_P4D_MODIFIED: u32 = 1;
pub const __PGTBL_PUD_MODIFIED: u32 = 2;
pub const __PGTBL_PMD_MODIFIED: u32 = 3;
pub const __PGTBL_PTE_MODIFIED: u32 = 4;
pub const MAX_PTRS_PER_PTE: u32 = 512;
pub const MAX_PTRS_PER_PMD: u32 = 512;
pub const MAX_PTRS_PER_PUD: u32 = 512;
pub const IORESOURCE_BITS: u32 = 255;
pub const IORESOURCE_TYPE_BITS: u32 = 7936;
pub const IORESOURCE_IO: u32 = 256;
pub const IORESOURCE_MEM: u32 = 512;
pub const IORESOURCE_REG: u32 = 768;
pub const IORESOURCE_IRQ: u32 = 1024;
pub const IORESOURCE_DMA: u32 = 2048;
pub const IORESOURCE_BUS: u32 = 4096;
pub const IORESOURCE_PREFETCH: u32 = 8192;
pub const IORESOURCE_READONLY: u32 = 16384;
pub const IORESOURCE_CACHEABLE: u32 = 32768;
pub const IORESOURCE_RANGELENGTH: u32 = 65536;
pub const IORESOURCE_SHADOWABLE: u32 = 131072;
pub const IORESOURCE_SIZEALIGN: u32 = 262144;
pub const IORESOURCE_STARTALIGN: u32 = 524288;
pub const IORESOURCE_MEM_64: u32 = 1048576;
pub const IORESOURCE_WINDOW: u32 = 2097152;
pub const IORESOURCE_MUXED: u32 = 4194304;
pub const IORESOURCE_EXT_TYPE_BITS: u32 = 16777216;
pub const IORESOURCE_SYSRAM: u32 = 16777216;
pub const IORESOURCE_SYSRAM_DRIVER_MANAGED: u32 = 33554432;
pub const IORESOURCE_SYSRAM_MERGEABLE: u32 = 67108864;
pub const IORESOURCE_EXCLUSIVE: u32 = 134217728;
pub const IORESOURCE_DISABLED: u32 = 268435456;
pub const IORESOURCE_UNSET: u32 = 536870912;
pub const IORESOURCE_AUTO: u32 = 1073741824;
pub const IORESOURCE_BUSY: u32 = 2147483648;
pub const IORESOURCE_SYSTEM_RAM: u32 = 16777728;
pub const IORESOURCE_IRQ_HIGHEDGE: u32 = 1;
pub const IORESOURCE_IRQ_LOWEDGE: u32 = 2;
pub const IORESOURCE_IRQ_HIGHLEVEL: u32 = 4;
pub const IORESOURCE_IRQ_LOWLEVEL: u32 = 8;
pub const IORESOURCE_IRQ_SHAREABLE: u32 = 16;
pub const IORESOURCE_IRQ_OPTIONAL: u32 = 32;
pub const IORESOURCE_IRQ_WAKECAPABLE: u32 = 64;
pub const IORESOURCE_DMA_TYPE_MASK: u32 = 3;
pub const IORESOURCE_DMA_8BIT: u32 = 0;
pub const IORESOURCE_DMA_8AND16BIT: u32 = 1;
pub const IORESOURCE_DMA_16BIT: u32 = 2;
pub const IORESOURCE_DMA_MASTER: u32 = 4;
pub const IORESOURCE_DMA_BYTE: u32 = 8;
pub const IORESOURCE_DMA_WORD: u32 = 16;
pub const IORESOURCE_DMA_SPEED_MASK: u32 = 192;
pub const IORESOURCE_DMA_COMPATIBLE: u32 = 0;
pub const IORESOURCE_DMA_TYPEA: u32 = 64;
pub const IORESOURCE_DMA_TYPEB: u32 = 128;
pub const IORESOURCE_DMA_TYPEF: u32 = 192;
pub const IORESOURCE_MEM_WRITEABLE: u32 = 1;
pub const IORESOURCE_MEM_CACHEABLE: u32 = 2;
pub const IORESOURCE_MEM_RANGELENGTH: u32 = 4;
pub const IORESOURCE_MEM_TYPE_MASK: u32 = 24;
pub const IORESOURCE_MEM_8BIT: u32 = 0;
pub const IORESOURCE_MEM_16BIT: u32 = 8;
pub const IORESOURCE_MEM_8AND16BIT: u32 = 16;
pub const IORESOURCE_MEM_32BIT: u32 = 24;
pub const IORESOURCE_MEM_SHADOWABLE: u32 = 32;
pub const IORESOURCE_MEM_EXPANSIONROM: u32 = 64;
pub const IORESOURCE_MEM_NONPOSTED: u32 = 128;
pub const IORESOURCE_IO_16BIT_ADDR: u32 = 1;
pub const IORESOURCE_IO_FIXED: u32 = 2;
pub const IORESOURCE_IO_SPARSE: u32 = 4;
pub const IORESOURCE_ROM_ENABLE: u32 = 1;
pub const IORESOURCE_ROM_SHADOW: u32 = 2;
pub const IORESOURCE_PCI_FIXED: u32 = 16;
pub const IORESOURCE_PCI_EA_BEI: u32 = 32;
pub const PGMAP_ALTMAP_VALID: u32 = 1;
pub const MAPCOUNT_ELF_CORE_MARGIN: u32 = 5;
pub const VM_NONE: u32 = 0;
pub const VM_READ: u32 = 1;
pub const VM_WRITE: u32 = 2;
pub const VM_EXEC: u32 = 4;
pub const VM_SHARED: u32 = 8;
pub const VM_MAYREAD: u32 = 16;
pub const VM_MAYWRITE: u32 = 32;
pub const VM_MAYEXEC: u32 = 64;
pub const VM_MAYSHARE: u32 = 128;
pub const VM_GROWSDOWN: u32 = 256;
pub const VM_UFFD_MISSING: u32 = 512;
pub const VM_PFNMAP: u32 = 1024;
pub const VM_UFFD_WP: u32 = 4096;
pub const VM_LOCKED: u32 = 8192;
pub const VM_IO: u32 = 16384;
pub const VM_SEQ_READ: u32 = 32768;
pub const VM_RAND_READ: u32 = 65536;
pub const VM_DONTCOPY: u32 = 131072;
pub const VM_DONTEXPAND: u32 = 262144;
pub const VM_LOCKONFAULT: u32 = 524288;
pub const VM_ACCOUNT: u32 = 1048576;
pub const VM_NORESERVE: u32 = 2097152;
pub const VM_HUGETLB: u32 = 4194304;
pub const VM_SYNC: u32 = 8388608;
pub const VM_ARCH_1: u32 = 16777216;
pub const VM_WIPEONFORK: u32 = 33554432;
pub const VM_DONTDUMP: u32 = 67108864;
pub const VM_SOFTDIRTY: u32 = 134217728;
pub const VM_MIXEDMAP: u32 = 268435456;
pub const VM_HUGEPAGE: u32 = 536870912;
pub const VM_NOHUGEPAGE: u32 = 1073741824;
pub const VM_MERGEABLE: u32 = 2147483648;
pub const VM_HIGH_ARCH_BIT_0: u32 = 32;
pub const VM_HIGH_ARCH_BIT_1: u32 = 33;
pub const VM_HIGH_ARCH_BIT_2: u32 = 34;
pub const VM_HIGH_ARCH_BIT_3: u32 = 35;
pub const VM_HIGH_ARCH_BIT_4: u32 = 36;
pub const VM_HIGH_ARCH_BIT_5: u32 = 37;
pub const VM_PKEY_SHIFT: u32 = 32;
pub const VM_PKEY_BIT4: u32 = 0;
pub const VM_PAT: u32 = 16777216;
pub const VM_MTE: u32 = 0;
pub const VM_MTE_ALLOWED: u32 = 0;
pub const VM_GROWSUP: u32 = 0;
pub const VM_UFFD_MINOR_BIT: u32 = 38;
pub const VM_DATA_FLAGS_NON_EXEC: u32 = 115;
pub const VM_DATA_FLAGS_EXEC: u32 = 119;
pub const VM_STACK: u32 = 256;
pub const VM_STACK_EARLY: u32 = 0;
pub const VM_ACCESS_FLAGS: u32 = 7;
pub const VM_SPECIAL: u32 = 268715008;
pub const VM_NO_KHUGEPAGED: u32 = 272909312;
pub const VM_INIT_DEF_MASK: u32 = 1073741824;
pub const VM_LOCKED_MASK: u32 = 532480;
pub const VM_ARCH_CLEAR: u32 = 0;
pub const SUID_DUMP_DISABLE: u32 = 0;
pub const SUID_DUMP_USER: u32 = 1;
pub const SUID_DUMP_ROOT: u32 = 2;
pub const MMF_DUMPABLE_BITS: u32 = 2;
pub const MMF_DUMPABLE_MASK: u32 = 3;
pub const MMF_DUMP_ANON_PRIVATE: u32 = 2;
pub const MMF_DUMP_ANON_SHARED: u32 = 3;
pub const MMF_DUMP_MAPPED_PRIVATE: u32 = 4;
pub const MMF_DUMP_MAPPED_SHARED: u32 = 5;
pub const MMF_DUMP_ELF_HEADERS: u32 = 6;
pub const MMF_DUMP_HUGETLB_PRIVATE: u32 = 7;
pub const MMF_DUMP_HUGETLB_SHARED: u32 = 8;
pub const MMF_DUMP_DAX_PRIVATE: u32 = 9;
pub const MMF_DUMP_DAX_SHARED: u32 = 10;
pub const MMF_DUMP_FILTER_SHIFT: u32 = 2;
pub const MMF_DUMP_FILTER_BITS: u32 = 9;
pub const MMF_DUMP_FILTER_MASK: u32 = 2044;
pub const MMF_DUMP_MASK_DEFAULT_ELF: u32 = 64;
pub const MMF_VM_MERGEABLE: u32 = 16;
pub const MMF_VM_HUGEPAGE: u32 = 17;
pub const MMF_HAS_UPROBES: u32 = 19;
pub const MMF_RECALC_UPROBES: u32 = 20;
pub const MMF_OOM_SKIP: u32 = 21;
pub const MMF_UNSTABLE: u32 = 22;
pub const MMF_HUGE_ZERO_PAGE: u32 = 23;
pub const MMF_DISABLE_THP: u32 = 24;
pub const MMF_DISABLE_THP_MASK: u32 = 16777216;
pub const MMF_OOM_REAP_QUEUED: u32 = 25;
pub const MMF_MULTIPROCESS: u32 = 26;
pub const MMF_HAS_PINNED: u32 = 27;
pub const MMF_HAS_MDWE: u32 = 28;
pub const MMF_HAS_MDWE_MASK: u32 = 268435456;
pub const MMF_HAS_MDWE_NO_INHERIT: u32 = 29;
pub const MMF_VM_MERGE_ANY: u32 = 30;
pub const MMF_VM_MERGE_ANY_MASK: u32 = 1073741824;
pub const MMF_INIT_MASK: u32 = 1358956543;
pub const HPAGE_PMD_SHIFT: u32 = 21;
pub const HPAGE_PMD_SIZE: u32 = 2097152;
pub const HPAGE_PMD_MASK: i32 = -2097152;
pub const HPAGE_PUD_SHIFT: u32 = 30;
pub const HPAGE_PUD_SIZE: u32 = 1073741824;
pub const HPAGE_PUD_MASK: i32 = -1073741824;
pub const GUP_PIN_COUNTING_BIAS: u32 = 1024;
pub const PAGE_ACCESS_TIME_MIN_BITS: u32 = 12;
pub const PAGE_ACCESS_TIME_BUCKETS: u32 = 0;
pub const PAGE_ACCESS_TIME_MASK: u32 = 2097151;
pub const ENABLE_NUMA_STAT: u32 = 1;
pub const DISABLE_NUMA_STAT: u32 = 0;
pub const MM_CP_TRY_CHANGE_WRITABLE: u32 = 1;
pub const MM_CP_PROT_NUMA: u32 = 2;
pub const MM_CP_UFFD_WP: u32 = 4;
pub const MM_CP_UFFD_WP_RESOLVE: u32 = 8;
pub const MM_CP_UFFD_WP_ALL: u32 = 12;
pub const VM_UNMAPPED_AREA_TOPDOWN: u32 = 1;
pub const VMEMMAP_RESERVE_NR: u32 = 2;
pub const ARCH_IMPLEMENTS_FLUSH_DCACHE_PAGE: u32 = 0;
pub const _HAVE_ARCH_COPY_AND_CSUM_FROM_USER: u32 = 1;
pub const _HAVE_ARCH_IPV6_CSUM: u32 = 1;
pub const PRINTK_INFO_SUBSYSTEM_LEN: u32 = 16;
pub const PRINTK_INFO_DEVICE_LEN: u32 = 48;
pub const SCHED_CPUFREQ_IOWAIT: u32 = 1;
pub const SDF_SHARED_CHILD: u32 = 1;
pub const SDF_SHARED_PARENT: u32 = 2;
pub const SDF_NEEDS_GROUPS: u32 = 4;
pub const SDTL_OVERLAP: u32 = 1;
pub const EM_MAX_POWER: u32 = 64000000;
pub const EM_MAX_NUM_CPUS: u32 = 4096;
pub const PM_EVENT_INVALID: i32 = -1;
pub const PM_EVENT_ON: u32 = 0;
pub const PM_EVENT_FREEZE: u32 = 1;
pub const PM_EVENT_SUSPEND: u32 = 2;
pub const PM_EVENT_HIBERNATE: u32 = 4;
pub const PM_EVENT_QUIESCE: u32 = 8;
pub const PM_EVENT_RESUME: u32 = 16;
pub const PM_EVENT_THAW: u32 = 32;
pub const PM_EVENT_RESTORE: u32 = 64;
pub const PM_EVENT_RECOVER: u32 = 128;
pub const PM_EVENT_USER: u32 = 256;
pub const PM_EVENT_REMOTE: u32 = 512;
pub const PM_EVENT_AUTO: u32 = 1024;
pub const PM_EVENT_SLEEP: u32 = 6;
pub const PM_EVENT_USER_SUSPEND: u32 = 258;
pub const PM_EVENT_USER_RESUME: u32 = 272;
pub const PM_EVENT_REMOTE_RESUME: u32 = 528;
pub const PM_EVENT_AUTO_SUSPEND: u32 = 1026;
pub const PM_EVENT_AUTO_RESUME: u32 = 1040;
pub const PM_EVENT_PRETHAW: u32 = 8;
pub const IO_SPACE_LIMIT: u32 = 65535;
pub const SWNODE_GRAPH_PORT_NAME_FMT: &[u8; 8usize] = b"port@%u\0";
pub const SWNODE_GRAPH_ENDPOINT_NAME_FMT: &[u8; 12usize] = b"endpoint@%u\0";
pub const NR_FWNODE_REFERENCE_ARGS: u32 = 8;
pub const PIO_INDIRECT_SIZE: u32 = 0;
pub const MMIO_UPPER_LIMIT: u32 = 65535;
pub const VM_IOREMAP: u32 = 1;
pub const VM_ALLOC: u32 = 2;
pub const VM_MAP: u32 = 4;
pub const VM_USERMAP: u32 = 8;
pub const VM_DMA_COHERENT: u32 = 16;
pub const VM_UNINITIALIZED: u32 = 32;
pub const VM_NO_GUARD: u32 = 64;
pub const VM_KASAN: u32 = 128;
pub const VM_FLUSH_RESET_PERMS: u32 = 256;
pub const VM_MAP_PUT_PAGES: u32 = 512;
pub const VM_ALLOW_HUGE_VMAP: u32 = 1024;
pub const VM_DEFER_KMEMLEAK: u32 = 0;
pub const ARCH_PAGE_TABLE_SYNC_MASK: u32 = 0;
pub const SG_CHAIN: u32 = 1;
pub const SG_END: u32 = 2;
pub const SG_PAGE_LINK_MASK: u32 = 3;
pub const SG_DMA_BUS_ADDRESS: u32 = 1;
pub const SG_DMA_SWIOTLB: u32 = 2;
pub const SG_CHUNK_SIZE: u32 = 128;
pub const SG_MAX_SEGMENTS: u32 = 2048;
pub const SG_MITER_ATOMIC: u32 = 1;
pub const SG_MITER_TO_SG: u32 = 2;
pub const SG_MITER_FROM_SG: u32 = 4;
pub const DMA_ATTR_WEAK_ORDERING: u32 = 2;
pub const DMA_ATTR_WRITE_COMBINE: u32 = 4;
pub const DMA_ATTR_NO_KERNEL_MAPPING: u32 = 16;
pub const DMA_ATTR_SKIP_CPU_SYNC: u32 = 32;
pub const DMA_ATTR_FORCE_CONTIGUOUS: u32 = 64;
pub const DMA_ATTR_ALLOC_SINGLE_PAGES: u32 = 128;
pub const DMA_ATTR_NO_WARN: u32 = 256;
pub const DMA_ATTR_PRIVILEGED: u32 = 512;
pub const IPV6_FL_A_GET: u32 = 0;
pub const IPV6_FL_A_PUT: u32 = 1;
pub const IPV6_FL_A_RENEW: u32 = 2;
pub const IPV6_FL_F_CREATE: u32 = 1;
pub const IPV6_FL_F_EXCL: u32 = 2;
pub const IPV6_FL_F_REFLECT: u32 = 4;
pub const IPV6_FL_F_REMOTE: u32 = 8;
pub const IPV6_FL_S_NONE: u32 = 0;
pub const IPV6_FL_S_EXCL: u32 = 1;
pub const IPV6_FL_S_PROCESS: u32 = 2;
pub const IPV6_FL_S_USER: u32 = 3;
pub const IPV6_FL_S_ANY: u32 = 255;
pub const IPV6_FLOWINFO_FLOWLABEL: u32 = 1048575;
pub const IPV6_FLOWINFO_PRIORITY: u32 = 267386880;
pub const IPV6_PRIORITY_UNCHARACTERIZED: u32 = 0;
pub const IPV6_PRIORITY_FILLER: u32 = 256;
pub const IPV6_PRIORITY_UNATTENDED: u32 = 512;
pub const IPV6_PRIORITY_RESERVED1: u32 = 768;
pub const IPV6_PRIORITY_BULK: u32 = 1024;
pub const IPV6_PRIORITY_RESERVED2: u32 = 1280;
pub const IPV6_PRIORITY_INTERACTIVE: u32 = 1536;
pub const IPV6_PRIORITY_CONTROL: u32 = 1792;
pub const IPV6_PRIORITY_8: u32 = 2048;
pub const IPV6_PRIORITY_9: u32 = 2304;
pub const IPV6_PRIORITY_10: u32 = 2560;
pub const IPV6_PRIORITY_11: u32 = 2816;
pub const IPV6_PRIORITY_12: u32 = 3072;
pub const IPV6_PRIORITY_13: u32 = 3328;
pub const IPV6_PRIORITY_14: u32 = 3584;
pub const IPV6_PRIORITY_15: u32 = 3840;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_MH: u32 = 135;
pub const IPV6_TLV_PAD1: u32 = 0;
pub const IPV6_TLV_PADN: u32 = 1;
pub const IPV6_TLV_ROUTERALERT: u32 = 5;
pub const IPV6_TLV_CALIPSO: u32 = 7;
pub const IPV6_TLV_IOAM: u32 = 49;
pub const IPV6_TLV_JUMBO: u32 = 194;
pub const IPV6_TLV_HAO: u32 = 201;
pub const IPV6_ADDRFORM: u32 = 1;
pub const IPV6_2292PKTINFO: u32 = 2;
pub const IPV6_2292HOPOPTS: u32 = 3;
pub const IPV6_2292DSTOPTS: u32 = 4;
pub const IPV6_2292RTHDR: u32 = 5;
pub const IPV6_2292PKTOPTIONS: u32 = 6;
pub const IPV6_CHECKSUM: u32 = 7;
pub const IPV6_2292HOPLIMIT: u32 = 8;
pub const IPV6_NEXTHOP: u32 = 9;
pub const IPV6_AUTHHDR: u32 = 10;
pub const IPV6_FLOWINFO: u32 = 11;
pub const IPV6_UNICAST_HOPS: u32 = 16;
pub const IPV6_MULTICAST_IF: u32 = 17;
pub const IPV6_MULTICAST_HOPS: u32 = 18;
pub const IPV6_MULTICAST_LOOP: u32 = 19;
pub const IPV6_ADD_MEMBERSHIP: u32 = 20;
pub const IPV6_DROP_MEMBERSHIP: u32 = 21;
pub const IPV6_ROUTER_ALERT: u32 = 22;
pub const IPV6_MTU_DISCOVER: u32 = 23;
pub const IPV6_MTU: u32 = 24;
pub const IPV6_RECVERR: u32 = 25;
pub const IPV6_V6ONLY: u32 = 26;
pub const IPV6_JOIN_ANYCAST: u32 = 27;
pub const IPV6_LEAVE_ANYCAST: u32 = 28;
pub const IPV6_MULTICAST_ALL: u32 = 29;
pub const IPV6_ROUTER_ALERT_ISOLATE: u32 = 30;
pub const IPV6_RECVERR_RFC4884: u32 = 31;
pub const IPV6_PMTUDISC_DONT: u32 = 0;
pub const IPV6_PMTUDISC_WANT: u32 = 1;
pub const IPV6_PMTUDISC_DO: u32 = 2;
pub const IPV6_PMTUDISC_PROBE: u32 = 3;
pub const IPV6_PMTUDISC_INTERFACE: u32 = 4;
pub const IPV6_PMTUDISC_OMIT: u32 = 5;
pub const IPV6_FLOWLABEL_MGR: u32 = 32;
pub const IPV6_FLOWINFO_SEND: u32 = 33;
pub const IPV6_IPSEC_POLICY: u32 = 34;
pub const IPV6_XFRM_POLICY: u32 = 35;
pub const IPV6_HDRINCL: u32 = 36;
pub const IPV6_RECVPKTINFO: u32 = 49;
pub const IPV6_PKTINFO: u32 = 50;
pub const IPV6_RECVHOPLIMIT: u32 = 51;
pub const IPV6_HOPLIMIT: u32 = 52;
pub const IPV6_RECVHOPOPTS: u32 = 53;
pub const IPV6_HOPOPTS: u32 = 54;
pub const IPV6_RTHDRDSTOPTS: u32 = 55;
pub const IPV6_RECVRTHDR: u32 = 56;
pub const IPV6_RTHDR: u32 = 57;
pub const IPV6_RECVDSTOPTS: u32 = 58;
pub const IPV6_DSTOPTS: u32 = 59;
pub const IPV6_RECVPATHMTU: u32 = 60;
pub const IPV6_PATHMTU: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_RECVTCLASS: u32 = 66;
pub const IPV6_TCLASS: u32 = 67;
pub const IPV6_AUTOFLOWLABEL: u32 = 70;
pub const IPV6_ADDR_PREFERENCES: u32 = 72;
pub const IPV6_PREFER_SRC_TMP: u32 = 1;
pub const IPV6_PREFER_SRC_PUBLIC: u32 = 2;
pub const IPV6_PREFER_SRC_PUBTMP_DEFAULT: u32 = 256;
pub const IPV6_PREFER_SRC_COA: u32 = 4;
pub const IPV6_PREFER_SRC_HOME: u32 = 1024;
pub const IPV6_PREFER_SRC_CGA: u32 = 8;
pub const IPV6_PREFER_SRC_NONCGA: u32 = 2048;
pub const IPV6_MINHOPCOUNT: u32 = 73;
pub const IPV6_ORIGDSTADDR: u32 = 74;
pub const IPV6_RECVORIGDSTADDR: u32 = 74;
pub const IPV6_TRANSPARENT: u32 = 75;
pub const IPV6_UNICAST_IF: u32 = 76;
pub const IPV6_RECVFRAGSIZE: u32 = 77;
pub const IPV6_FREEBIND: u32 = 78;
pub const SIPHASH_CONST_0: u64 = 8317987319222330741;
pub const SIPHASH_CONST_1: u64 = 7237128888997146477;
pub const SIPHASH_CONST_2: u64 = 7816392313619706465;
pub const SIPHASH_CONST_3: u64 = 8387220255154660723;
pub const HSIPHASH_CONST_0: u32 = 0;
pub const HSIPHASH_CONST_1: u32 = 0;
pub const HSIPHASH_CONST_2: u32 = 1819895653;
pub const HSIPHASH_CONST_3: u32 = 1952801890;
pub const ETH_ALEN: u32 = 6;
pub const ETH_TLEN: u32 = 2;
pub const ETH_HLEN: u32 = 14;
pub const ETH_ZLEN: u32 = 60;
pub const ETH_DATA_LEN: u32 = 1500;
pub const ETH_FRAME_LEN: u32 = 1514;
pub const ETH_FCS_LEN: u32 = 4;
pub const ETH_MIN_MTU: u32 = 68;
pub const ETH_MAX_MTU: u32 = 65535;
pub const ETH_P_LOOP: u32 = 96;
pub const ETH_P_PUP: u32 = 512;
pub const ETH_P_PUPAT: u32 = 513;
pub const ETH_P_TSN: u32 = 8944;
pub const ETH_P_ERSPAN2: u32 = 8939;
pub const ETH_P_IP: u32 = 2048;
pub const ETH_P_X25: u32 = 2053;
pub const ETH_P_ARP: u32 = 2054;
pub const ETH_P_BPQ: u32 = 2303;
pub const ETH_P_IEEEPUP: u32 = 2560;
pub const ETH_P_IEEEPUPAT: u32 = 2561;
pub const ETH_P_BATMAN: u32 = 17157;
pub const ETH_P_DEC: u32 = 24576;
pub const ETH_P_DNA_DL: u32 = 24577;
pub const ETH_P_DNA_RC: u32 = 24578;
pub const ETH_P_DNA_RT: u32 = 24579;
pub const ETH_P_LAT: u32 = 24580;
pub const ETH_P_DIAG: u32 = 24581;
pub const ETH_P_CUST: u32 = 24582;
pub const ETH_P_SCA: u32 = 24583;
pub const ETH_P_TEB: u32 = 25944;
pub const ETH_P_RARP: u32 = 32821;
pub const ETH_P_ATALK: u32 = 32923;
pub const ETH_P_AARP: u32 = 33011;
pub const ETH_P_8021Q: u32 = 33024;
pub const ETH_P_ERSPAN: u32 = 35006;
pub const ETH_P_IPX: u32 = 33079;
pub const ETH_P_IPV6: u32 = 34525;
pub const ETH_P_PAUSE: u32 = 34824;
pub const ETH_P_SLOW: u32 = 34825;
pub const ETH_P_WCCP: u32 = 34878;
pub const ETH_P_MPLS_UC: u32 = 34887;
pub const ETH_P_MPLS_MC: u32 = 34888;
pub const ETH_P_ATMMPOA: u32 = 34892;
pub const ETH_P_PPP_DISC: u32 = 34915;
pub const ETH_P_PPP_SES: u32 = 34916;
pub const ETH_P_LINK_CTL: u32 = 34924;
pub const ETH_P_ATMFATE: u32 = 34948;
pub const ETH_P_PAE: u32 = 34958;
pub const ETH_P_PROFINET: u32 = 34962;
pub const ETH_P_REALTEK: u32 = 34969;
pub const ETH_P_AOE: u32 = 34978;
pub const ETH_P_ETHERCAT: u32 = 34980;
pub const ETH_P_8021AD: u32 = 34984;
pub const ETH_P_802_EX1: u32 = 34997;
pub const ETH_P_PREAUTH: u32 = 35015;
pub const ETH_P_TIPC: u32 = 35018;
pub const ETH_P_LLDP: u32 = 35020;
pub const ETH_P_MRP: u32 = 35043;
pub const ETH_P_MACSEC: u32 = 35045;
pub const ETH_P_8021AH: u32 = 35047;
pub const ETH_P_MVRP: u32 = 35061;
pub const ETH_P_1588: u32 = 35063;
pub const ETH_P_NCSI: u32 = 35064;
pub const ETH_P_PRP: u32 = 35067;
pub const ETH_P_CFM: u32 = 35074;
pub const ETH_P_FCOE: u32 = 35078;
pub const ETH_P_IBOE: u32 = 35093;
pub const ETH_P_TDLS: u32 = 35085;
pub const ETH_P_FIP: u32 = 35092;
pub const ETH_P_80221: u32 = 35095;
pub const ETH_P_HSR: u32 = 35119;
pub const ETH_P_NSH: u32 = 35151;
pub const ETH_P_LOOPBACK: u32 = 36864;
pub const ETH_P_QINQ1: u32 = 37120;
pub const ETH_P_QINQ2: u32 = 37376;
pub const ETH_P_QINQ3: u32 = 37632;
pub const ETH_P_EDSA: u32 = 56026;
pub const ETH_P_DSA_8021Q: u32 = 56027;
pub const ETH_P_DSA_A5PSW: u32 = 57345;
pub const ETH_P_IFE: u32 = 60734;
pub const ETH_P_AF_IUCV: u32 = 64507;
pub const ETH_P_802_3_MIN: u32 = 1536;
pub const ETH_P_802_3: u32 = 1;
pub const ETH_P_AX25: u32 = 2;
pub const ETH_P_ALL: u32 = 3;
pub const ETH_P_802_2: u32 = 4;
pub const ETH_P_SNAP: u32 = 5;
pub const ETH_P_DDCMP: u32 = 6;
pub const ETH_P_WAN_PPP: u32 = 7;
pub const ETH_P_PPP_MP: u32 = 8;
pub const ETH_P_LOCALTALK: u32 = 9;
pub const ETH_P_CAN: u32 = 12;
pub const ETH_P_CANFD: u32 = 13;
pub const ETH_P_CANXL: u32 = 14;
pub const ETH_P_PPPTALK: u32 = 16;
pub const ETH_P_TR_802_2: u32 = 17;
pub const ETH_P_MOBITEX: u32 = 21;
pub const ETH_P_CONTROL: u32 = 22;
pub const ETH_P_IRDA: u32 = 23;
pub const ETH_P_ECONET: u32 = 24;
pub const ETH_P_HDLC: u32 = 25;
pub const ETH_P_ARCNET: u32 = 26;
pub const ETH_P_DSA: u32 = 27;
pub const ETH_P_TRAILER: u32 = 28;
pub const ETH_P_PHONET: u32 = 245;
pub const ETH_P_IEEE802154: u32 = 246;
pub const ETH_P_CAIF: u32 = 247;
pub const ETH_P_XDSA: u32 = 248;
pub const ETH_P_MAP: u32 = 249;
pub const ETH_P_MCTP: u32 = 250;
pub const __UAPI_DEF_ETHHDR: u32 = 1;
pub const FLOW_DIS_MPLS_MAX: u32 = 7;
pub const FLOW_DIS_TUN_OPTS_MAX: u32 = 255;
pub const FLOW_DIS_CFM_MDL_MAX: u32 = 7;
pub const FLOW_KEYS_DIGEST_LEN: u32 = 16;
pub const PACKET_HOST: u32 = 0;
pub const PACKET_BROADCAST: u32 = 1;
pub const PACKET_MULTICAST: u32 = 2;
pub const PACKET_OTHERHOST: u32 = 3;
pub const PACKET_OUTGOING: u32 = 4;
pub const PACKET_LOOPBACK: u32 = 5;
pub const PACKET_USER: u32 = 6;
pub const PACKET_KERNEL: u32 = 7;
pub const PACKET_FASTROUTE: u32 = 6;
pub const PACKET_ADD_MEMBERSHIP: u32 = 1;
pub const PACKET_DROP_MEMBERSHIP: u32 = 2;
pub const PACKET_RECV_OUTPUT: u32 = 3;
pub const PACKET_RX_RING: u32 = 5;
pub const PACKET_STATISTICS: u32 = 6;
pub const PACKET_COPY_THRESH: u32 = 7;
pub const PACKET_AUXDATA: u32 = 8;
pub const PACKET_ORIGDEV: u32 = 9;
pub const PACKET_VERSION: u32 = 10;
pub const PACKET_HDRLEN: u32 = 11;
pub const PACKET_RESERVE: u32 = 12;
pub const PACKET_TX_RING: u32 = 13;
pub const PACKET_LOSS: u32 = 14;
pub const PACKET_VNET_HDR: u32 = 15;
pub const PACKET_TX_TIMESTAMP: u32 = 16;
pub const PACKET_TIMESTAMP: u32 = 17;
pub const PACKET_FANOUT: u32 = 18;
pub const PACKET_TX_HAS_OFF: u32 = 19;
pub const PACKET_QDISC_BYPASS: u32 = 20;
pub const PACKET_ROLLOVER_STATS: u32 = 21;
pub const PACKET_FANOUT_DATA: u32 = 22;
pub const PACKET_IGNORE_OUTGOING: u32 = 23;
pub const PACKET_VNET_HDR_SZ: u32 = 24;
pub const PACKET_FANOUT_HASH: u32 = 0;
pub const PACKET_FANOUT_LB: u32 = 1;
pub const PACKET_FANOUT_CPU: u32 = 2;
pub const PACKET_FANOUT_ROLLOVER: u32 = 3;
pub const PACKET_FANOUT_RND: u32 = 4;
pub const PACKET_FANOUT_QM: u32 = 5;
pub const PACKET_FANOUT_CBPF: u32 = 6;
pub const PACKET_FANOUT_EBPF: u32 = 7;
pub const PACKET_FANOUT_FLAG_ROLLOVER: u32 = 4096;
pub const PACKET_FANOUT_FLAG_UNIQUEID: u32 = 8192;
pub const PACKET_FANOUT_FLAG_IGNORE_OUTGOING: u32 = 16384;
pub const PACKET_FANOUT_FLAG_DEFRAG: u32 = 32768;
pub const TP_STATUS_KERNEL: u32 = 0;
pub const TP_STATUS_USER: u32 = 1;
pub const TP_STATUS_COPY: u32 = 2;
pub const TP_STATUS_LOSING: u32 = 4;
pub const TP_STATUS_CSUMNOTREADY: u32 = 8;
pub const TP_STATUS_VLAN_VALID: u32 = 16;
pub const TP_STATUS_BLK_TMO: u32 = 32;
pub const TP_STATUS_VLAN_TPID_VALID: u32 = 64;
pub const TP_STATUS_CSUM_VALID: u32 = 128;
pub const TP_STATUS_GSO_TCP: u32 = 256;
pub const TP_STATUS_AVAILABLE: u32 = 0;
pub const TP_STATUS_SEND_REQUEST: u32 = 1;
pub const TP_STATUS_SENDING: u32 = 2;
pub const TP_STATUS_WRONG_FORMAT: u32 = 4;
pub const TP_STATUS_TS_SOFTWARE: u32 = 536870912;
pub const TP_STATUS_TS_SYS_HARDWARE: u32 = 1073741824;
pub const TP_STATUS_TS_RAW_HARDWARE: u32 = 2147483648;
pub const TP_FT_REQ_FILL_RXHASH: u32 = 1;
pub const TPACKET_ALIGNMENT: u32 = 16;
pub const PACKET_MR_MULTICAST: u32 = 0;
pub const PACKET_MR_PROMISC: u32 = 1;
pub const PACKET_MR_ALLMULTI: u32 = 2;
pub const PACKET_MR_UNICAST: u32 = 3;
pub const LOOPBACK_IFINDEX: u32 = 1;
pub const FLOWI_FLAG_ANYSRC: u32 = 1;
pub const FLOWI_FLAG_KNOWN_NH: u32 = 2;
pub const NF_CT_STATE_INVALID_BIT: u32 = 1;
pub const NF_CT_STATE_UNTRACKED_BIT: u32 = 64;
pub const NF_CT_EXPECT_PERMANENT: u32 = 1;
pub const NF_CT_EXPECT_INACTIVE: u32 = 2;
pub const NF_CT_EXPECT_USERSPACE: u32 = 4;
pub const NFCT_INFOMASK: u32 = 7;
pub const NFCT_PTRMASK: i32 = -8;
pub const SKB_DROP_REASON_SUBSYS_SHIFT: u32 = 16;
pub const CHECKSUM_NONE: u32 = 0;
pub const CHECKSUM_UNNECESSARY: u32 = 1;
pub const CHECKSUM_COMPLETE: u32 = 2;
pub const CHECKSUM_PARTIAL: u32 = 3;
pub const SKB_MAX_CSUM_LEVEL: u32 = 3;
pub const MAX_SKB_FRAGS: u32 = 17;
pub const GSO_BY_FRAGS: u32 = 65535;
pub const SKB_DATAREF_SHIFT: u32 = 16;
pub const SKB_DATAREF_MASK: u32 = 65535;
pub const NET_SKBUFF_DATA_USES_OFFSET: u32 = 1;
pub const CLONED_MASK: u32 = 1;
pub const PKT_TYPE_MAX: u32 = 7;
pub const SKB_MONO_DELIVERY_TIME_MASK: u32 = 1;
pub const TC_AT_INGRESS_MASK: u32 = 2;
pub const SKB_ALLOC_FCLONE: u32 = 1;
pub const SKB_ALLOC_RX: u32 = 2;
pub const SKB_ALLOC_NAPI: u32 = 4;
pub const SKB_DST_NOREF: u32 = 1;
pub const SKB_DST_PTRMASK: i32 = -2;
pub const ENCAP_TYPE_ETHER: u32 = 0;
pub const ENCAP_TYPE_IPPROTO: u32 = 1;
pub const CHECKSUM_BREAK: u32 = 76;
pub const NPROTO: u32 = 46;
pub const SYS_SOCKET: u32 = 1;
pub const SYS_BIND: u32 = 2;
pub const SYS_CONNECT: u32 = 3;
pub const SYS_LISTEN: u32 = 4;
pub const SYS_ACCEPT: u32 = 5;
pub const SYS_GETSOCKNAME: u32 = 6;
pub const SYS_GETPEERNAME: u32 = 7;
pub const SYS_SOCKETPAIR: u32 = 8;
pub const SYS_SEND: u32 = 9;
pub const SYS_RECV: u32 = 10;
pub const SYS_SENDTO: u32 = 11;
pub const SYS_RECVFROM: u32 = 12;
pub const SYS_SHUTDOWN: u32 = 13;
pub const SYS_SETSOCKOPT: u32 = 14;
pub const SYS_GETSOCKOPT: u32 = 15;
pub const SYS_SENDMSG: u32 = 16;
pub const SYS_RECVMSG: u32 = 17;
pub const SYS_ACCEPT4: u32 = 18;
pub const SYS_RECVMMSG: u32 = 19;
pub const SYS_SENDMMSG: u32 = 20;
pub const __SO_ACCEPTCON: u32 = 65536;
pub const SOCKWQ_ASYNC_NOSPACE: u32 = 0;
pub const SOCKWQ_ASYNC_WAITDATA: u32 = 1;
pub const SOCK_NOSPACE: u32 = 2;
pub const SOCK_PASSCRED: u32 = 3;
pub const SOCK_PASSSEC: u32 = 4;
pub const SOCK_SUPPORT_ZC: u32 = 5;
pub const SOCK_CUSTOM_SOCKOPT: u32 = 6;
pub const SOCK_PASSPIDFD: u32 = 7;
pub const SOCK_TYPE_MASK: u32 = 15;
pub const SOCK_CLOEXEC: u32 = 524288;
pub const SOCK_NONBLOCK: u32 = 2048;
pub const FDPUT_FPUT: u32 = 1;
pub const FDPUT_POS_UNLOCK: u32 = 2;
pub const LSM_ID_UNDEF: u32 = 0;
pub const LSM_ID_CAPABILITY: u32 = 100;
pub const LSM_ID_SELINUX: u32 = 101;
pub const LSM_ID_SMACK: u32 = 102;
pub const LSM_ID_TOMOYO: u32 = 103;
pub const LSM_ID_APPARMOR: u32 = 104;
pub const LSM_ID_YAMA: u32 = 105;
pub const LSM_ID_LOADPIN: u32 = 106;
pub const LSM_ID_SAFESETID: u32 = 107;
pub const LSM_ID_LOCKDOWN: u32 = 108;
pub const LSM_ID_BPF: u32 = 109;
pub const LSM_ID_LANDLOCK: u32 = 110;
pub const LSM_ATTR_UNDEF: u32 = 0;
pub const LSM_ATTR_CURRENT: u32 = 100;
pub const LSM_ATTR_EXEC: u32 = 101;
pub const LSM_ATTR_FSCREATE: u32 = 102;
pub const LSM_ATTR_KEYCREATE: u32 = 103;
pub const LSM_ATTR_PREV: u32 = 104;
pub const LSM_ATTR_SOCKCREATE: u32 = 105;
pub const LSM_FLAG_SINGLE: u32 = 1;
pub const CAP_OPT_NONE: u32 = 0;
pub const SECURITY_LSM_NATIVE_LABELS: u32 = 1;
pub const LSM_SETID_ID: u32 = 1;
pub const LSM_SETID_RE: u32 = 2;
pub const LSM_SETID_RES: u32 = 4;
pub const LSM_SETID_FS: u32 = 8;
pub const LSM_PRLIMIT_READ: u32 = 1;
pub const LSM_PRLIMIT_WRITE: u32 = 2;
pub const LSM_UNSAFE_SHARE: u32 = 1;
pub const LSM_UNSAFE_PTRACE: u32 = 2;
pub const LSM_UNSAFE_NO_NEW_PRIVS: u32 = 4;
pub const SCM_MAX_FD: u32 = 253;
pub const NETLINK_ROUTE: u32 = 0;
pub const NETLINK_UNUSED: u32 = 1;
pub const NETLINK_USERSOCK: u32 = 2;
pub const NETLINK_FIREWALL: u32 = 3;
pub const NETLINK_SOCK_DIAG: u32 = 4;
pub const NETLINK_NFLOG: u32 = 5;
pub const NETLINK_XFRM: u32 = 6;
pub const NETLINK_SELINUX: u32 = 7;
pub const NETLINK_ISCSI: u32 = 8;
pub const NETLINK_AUDIT: u32 = 9;
pub const NETLINK_FIB_LOOKUP: u32 = 10;
pub const NETLINK_CONNECTOR: u32 = 11;
pub const NETLINK_NETFILTER: u32 = 12;
pub const NETLINK_IP6_FW: u32 = 13;
pub const NETLINK_DNRTMSG: u32 = 14;
pub const NETLINK_KOBJECT_UEVENT: u32 = 15;
pub const NETLINK_GENERIC: u32 = 16;
pub const NETLINK_SCSITRANSPORT: u32 = 18;
pub const NETLINK_ECRYPTFS: u32 = 19;
pub const NETLINK_RDMA: u32 = 20;
pub const NETLINK_CRYPTO: u32 = 21;
pub const NETLINK_SMC: u32 = 22;
pub const NETLINK_INET_DIAG: u32 = 4;
pub const MAX_LINKS: u32 = 32;
pub const NLM_F_REQUEST: u32 = 1;
pub const NLM_F_MULTI: u32 = 2;
pub const NLM_F_ACK: u32 = 4;
pub const NLM_F_ECHO: u32 = 8;
pub const NLM_F_DUMP_INTR: u32 = 16;
pub const NLM_F_DUMP_FILTERED: u32 = 32;
pub const NLM_F_ROOT: u32 = 256;
pub const NLM_F_MATCH: u32 = 512;
pub const NLM_F_ATOMIC: u32 = 1024;
pub const NLM_F_DUMP: u32 = 768;
pub const NLM_F_REPLACE: u32 = 256;
pub const NLM_F_EXCL: u32 = 512;
pub const NLM_F_CREATE: u32 = 1024;
pub const NLM_F_APPEND: u32 = 2048;
pub const NLM_F_NONREC: u32 = 256;
pub const NLM_F_BULK: u32 = 512;
pub const NLM_F_CAPPED: u32 = 256;
pub const NLM_F_ACK_TLVS: u32 = 512;
pub const NLMSG_ALIGNTO: u32 = 4;
pub const NLMSG_NOOP: u32 = 1;
pub const NLMSG_ERROR: u32 = 2;
pub const NLMSG_DONE: u32 = 3;
pub const NLMSG_OVERRUN: u32 = 4;
pub const NLMSG_MIN_TYPE: u32 = 16;
pub const NETLINK_ADD_MEMBERSHIP: u32 = 1;
pub const NETLINK_DROP_MEMBERSHIP: u32 = 2;
pub const NETLINK_PKTINFO: u32 = 3;
pub const NETLINK_BROADCAST_ERROR: u32 = 4;
pub const NETLINK_NO_ENOBUFS: u32 = 5;
pub const NETLINK_LISTEN_ALL_NSID: u32 = 8;
pub const NETLINK_LIST_MEMBERSHIPS: u32 = 9;
pub const NETLINK_CAP_ACK: u32 = 10;
pub const NETLINK_EXT_ACK: u32 = 11;
pub const NETLINK_GET_STRICT_CHK: u32 = 12;
pub const NET_MAJOR: u32 = 36;
pub const NLA_F_NESTED: u32 = 32768;
pub const NLA_F_NET_BYTEORDER: u32 = 16384;
pub const NLA_TYPE_MASK: i32 = -49153;
pub const NLA_ALIGNTO: u32 = 4;
pub const NL_CFG_F_NONROOT_RECV: u32 = 1;
pub const NL_CFG_F_NONROOT_SEND: u32 = 2;
pub const NETLINK_MAX_COOKIE_LEN: u32 = 20;
pub const NETLINK_MAX_FMTMSG_LEN: u32 = 80;
pub const ETH_MDIO_SUPPORTS_C22: u32 = 1;
pub const ETH_MDIO_SUPPORTS_C45: u32 = 2;
pub const ETHTOOL_FWVERS_LEN: u32 = 32;
pub const ETHTOOL_BUSINFO_LEN: u32 = 32;
pub const ETHTOOL_EROMVERS_LEN: u32 = 32;
pub const SOPASS_MAX: u32 = 6;
pub const PFC_STORM_PREVENTION_AUTO: u32 = 65535;
pub const PFC_STORM_PREVENTION_DISABLE: u32 = 0;
pub const DOWNSHIFT_DEV_DEFAULT_COUNT: u32 = 255;
pub const DOWNSHIFT_DEV_DISABLE: u32 = 0;
pub const ETHTOOL_PHY_FAST_LINK_DOWN_ON: u32 = 0;
pub const ETHTOOL_PHY_FAST_LINK_DOWN_OFF: u32 = 255;
pub const ETHTOOL_PHY_EDPD_DFLT_TX_MSECS: u32 = 65535;
pub const ETHTOOL_PHY_EDPD_NO_TX: u32 = 65534;
pub const ETHTOOL_PHY_EDPD_DISABLE: u32 = 0;
pub const ETH_GSTRING_LEN: u32 = 32;
pub const ETH_RX_NFC_IP4: u32 = 1;
pub const ETHTOOL_RX_FLOW_SPEC_RING: u32 = 4294967295;
pub const ETHTOOL_RX_FLOW_SPEC_RING_VF: u64 = 1095216660480;
pub const ETHTOOL_RX_FLOW_SPEC_RING_VF_OFF: u32 = 32;
pub const ETH_RXFH_CONTEXT_ALLOC: u32 = 4294967295;
pub const ETH_RXFH_INDIR_NO_CHANGE: u32 = 4294967295;
pub const ETHTOOL_RXNTUPLE_ACTION_DROP: i32 = -1;
pub const ETHTOOL_RXNTUPLE_ACTION_CLEAR: i32 = -2;
pub const ETHTOOL_FLASH_MAX_FILENAME: u32 = 128;
pub const ETH_FW_DUMP_DISABLE: u32 = 0;
pub const MAX_NUM_QUEUE: u32 = 4096;
pub const ETHTOOL_GSET: u32 = 1;
pub const ETHTOOL_SSET: u32 = 2;
pub const ETHTOOL_GDRVINFO: u32 = 3;
pub const ETHTOOL_GREGS: u32 = 4;
pub const ETHTOOL_GWOL: u32 = 5;
pub const ETHTOOL_SWOL: u32 = 6;
pub const ETHTOOL_GMSGLVL: u32 = 7;
pub const ETHTOOL_SMSGLVL: u32 = 8;
pub const ETHTOOL_NWAY_RST: u32 = 9;
pub const ETHTOOL_GLINK: u32 = 10;
pub const ETHTOOL_GEEPROM: u32 = 11;
pub const ETHTOOL_SEEPROM: u32 = 12;
pub const ETHTOOL_GCOALESCE: u32 = 14;
pub const ETHTOOL_SCOALESCE: u32 = 15;
pub const ETHTOOL_GRINGPARAM: u32 = 16;
pub const ETHTOOL_SRINGPARAM: u32 = 17;
pub const ETHTOOL_GPAUSEPARAM: u32 = 18;
pub const ETHTOOL_SPAUSEPARAM: u32 = 19;
pub const ETHTOOL_GRXCSUM: u32 = 20;
pub const ETHTOOL_SRXCSUM: u32 = 21;
pub const ETHTOOL_GTXCSUM: u32 = 22;
pub const ETHTOOL_STXCSUM: u32 = 23;
pub const ETHTOOL_GSG: u32 = 24;
pub const ETHTOOL_SSG: u32 = 25;
pub const ETHTOOL_TEST: u32 = 26;
pub const ETHTOOL_GSTRINGS: u32 = 27;
pub const ETHTOOL_PHYS_ID: u32 = 28;
pub const ETHTOOL_GSTATS: u32 = 29;
pub const ETHTOOL_GTSO: u32 = 30;
pub const ETHTOOL_STSO: u32 = 31;
pub const ETHTOOL_GPERMADDR: u32 = 32;
pub const ETHTOOL_GUFO: u32 = 33;
pub const ETHTOOL_SUFO: u32 = 34;
pub const ETHTOOL_GGSO: u32 = 35;
pub const ETHTOOL_SGSO: u32 = 36;
pub const ETHTOOL_GFLAGS: u32 = 37;
pub const ETHTOOL_SFLAGS: u32 = 38;
pub const ETHTOOL_GPFLAGS: u32 = 39;
pub const ETHTOOL_SPFLAGS: u32 = 40;
pub const ETHTOOL_GRXFH: u32 = 41;
pub const ETHTOOL_SRXFH: u32 = 42;
pub const ETHTOOL_GGRO: u32 = 43;
pub const ETHTOOL_SGRO: u32 = 44;
pub const ETHTOOL_GRXRINGS: u32 = 45;
pub const ETHTOOL_GRXCLSRLCNT: u32 = 46;
pub const ETHTOOL_GRXCLSRULE: u32 = 47;
pub const ETHTOOL_GRXCLSRLALL: u32 = 48;
pub const ETHTOOL_SRXCLSRLDEL: u32 = 49;
pub const ETHTOOL_SRXCLSRLINS: u32 = 50;
pub const ETHTOOL_FLASHDEV: u32 = 51;
pub const ETHTOOL_RESET: u32 = 52;
pub const ETHTOOL_SRXNTUPLE: u32 = 53;
pub const ETHTOOL_GRXNTUPLE: u32 = 54;
pub const ETHTOOL_GSSET_INFO: u32 = 55;
pub const ETHTOOL_GRXFHINDIR: u32 = 56;
pub const ETHTOOL_SRXFHINDIR: u32 = 57;
pub const ETHTOOL_GFEATURES: u32 = 58;
pub const ETHTOOL_SFEATURES: u32 = 59;
pub const ETHTOOL_GCHANNELS: u32 = 60;
pub const ETHTOOL_SCHANNELS: u32 = 61;
pub const ETHTOOL_SET_DUMP: u32 = 62;
pub const ETHTOOL_GET_DUMP_FLAG: u32 = 63;
pub const ETHTOOL_GET_DUMP_DATA: u32 = 64;
pub const ETHTOOL_GET_TS_INFO: u32 = 65;
pub const ETHTOOL_GMODULEINFO: u32 = 66;
pub const ETHTOOL_GMODULEEEPROM: u32 = 67;
pub const ETHTOOL_GEEE: u32 = 68;
pub const ETHTOOL_SEEE: u32 = 69;
pub const ETHTOOL_GRSSH: u32 = 70;
pub const ETHTOOL_SRSSH: u32 = 71;
pub const ETHTOOL_GTUNABLE: u32 = 72;
pub const ETHTOOL_STUNABLE: u32 = 73;
pub const ETHTOOL_GPHYSTATS: u32 = 74;
pub const ETHTOOL_PERQUEUE: u32 = 75;
pub const ETHTOOL_GLINKSETTINGS: u32 = 76;
pub const ETHTOOL_SLINKSETTINGS: u32 = 77;
pub const ETHTOOL_PHY_GTUNABLE: u32 = 78;
pub const ETHTOOL_PHY_STUNABLE: u32 = 79;
pub const ETHTOOL_GFECPARAM: u32 = 80;
pub const ETHTOOL_SFECPARAM: u32 = 81;
pub const SPARC_ETH_GSET: u32 = 1;
pub const SPARC_ETH_SSET: u32 = 2;
pub const SPEED_10: u32 = 10;
pub const SPEED_100: u32 = 100;
pub const SPEED_1000: u32 = 1000;
pub const SPEED_2500: u32 = 2500;
pub const SPEED_5000: u32 = 5000;
pub const SPEED_10000: u32 = 10000;
pub const SPEED_14000: u32 = 14000;
pub const SPEED_20000: u32 = 20000;
pub const SPEED_25000: u32 = 25000;
pub const SPEED_40000: u32 = 40000;
pub const SPEED_50000: u32 = 50000;
pub const SPEED_56000: u32 = 56000;
pub const SPEED_100000: u32 = 100000;
pub const SPEED_200000: u32 = 200000;
pub const SPEED_400000: u32 = 400000;
pub const SPEED_800000: u32 = 800000;
pub const SPEED_UNKNOWN: i32 = -1;
pub const DUPLEX_HALF: u32 = 0;
pub const DUPLEX_FULL: u32 = 1;
pub const DUPLEX_UNKNOWN: u32 = 255;
pub const MASTER_SLAVE_CFG_UNSUPPORTED: u32 = 0;
pub const MASTER_SLAVE_CFG_UNKNOWN: u32 = 1;
pub const MASTER_SLAVE_CFG_MASTER_PREFERRED: u32 = 2;
pub const MASTER_SLAVE_CFG_SLAVE_PREFERRED: u32 = 3;
pub const MASTER_SLAVE_CFG_MASTER_FORCE: u32 = 4;
pub const MASTER_SLAVE_CFG_SLAVE_FORCE: u32 = 5;
pub const MASTER_SLAVE_STATE_UNSUPPORTED: u32 = 0;
pub const MASTER_SLAVE_STATE_UNKNOWN: u32 = 1;
pub const MASTER_SLAVE_STATE_MASTER: u32 = 2;
pub const MASTER_SLAVE_STATE_SLAVE: u32 = 3;
pub const MASTER_SLAVE_STATE_ERR: u32 = 4;
pub const RATE_MATCH_NONE: u32 = 0;
pub const RATE_MATCH_PAUSE: u32 = 1;
pub const RATE_MATCH_CRS: u32 = 2;
pub const RATE_MATCH_OPEN_LOOP: u32 = 3;
pub const PORT_TP: u32 = 0;
pub const PORT_AUI: u32 = 1;
pub const PORT_MII: u32 = 2;
pub const PORT_FIBRE: u32 = 3;
pub const PORT_BNC: u32 = 4;
pub const PORT_DA: u32 = 5;
pub const PORT_NONE: u32 = 239;
pub const PORT_OTHER: u32 = 255;
pub const XCVR_INTERNAL: u32 = 0;
pub const XCVR_EXTERNAL: u32 = 1;
pub const XCVR_DUMMY1: u32 = 2;
pub const XCVR_DUMMY2: u32 = 3;
pub const XCVR_DUMMY3: u32 = 4;
pub const AUTONEG_DISABLE: u32 = 0;
pub const AUTONEG_ENABLE: u32 = 1;
pub const ETH_TP_MDI_INVALID: u32 = 0;
pub const ETH_TP_MDI: u32 = 1;
pub const ETH_TP_MDI_X: u32 = 2;
pub const ETH_TP_MDI_AUTO: u32 = 3;
pub const WAKE_PHY: u32 = 1;
pub const WAKE_UCAST: u32 = 2;
pub const WAKE_MCAST: u32 = 4;
pub const WAKE_BCAST: u32 = 8;
pub const WAKE_ARP: u32 = 16;
pub const WAKE_MAGIC: u32 = 32;
pub const WAKE_MAGICSECURE: u32 = 64;
pub const WAKE_FILTER: u32 = 128;
pub const WOL_MODE_COUNT: u32 = 8;
pub const RXH_XFRM_SYM_XOR: u32 = 1;
pub const RXH_XFRM_NO_CHANGE: u32 = 255;
pub const TCP_V4_FLOW: u32 = 1;
pub const UDP_V4_FLOW: u32 = 2;
pub const SCTP_V4_FLOW: u32 = 3;
pub const AH_ESP_V4_FLOW: u32 = 4;
pub const TCP_V6_FLOW: u32 = 5;
pub const UDP_V6_FLOW: u32 = 6;
pub const SCTP_V6_FLOW: u32 = 7;
pub const AH_ESP_V6_FLOW: u32 = 8;
pub const AH_V4_FLOW: u32 = 9;
pub const ESP_V4_FLOW: u32 = 10;
pub const AH_V6_FLOW: u32 = 11;
pub const ESP_V6_FLOW: u32 = 12;
pub const IPV4_USER_FLOW: u32 = 13;
pub const IP_USER_FLOW: u32 = 13;
pub const IPV6_USER_FLOW: u32 = 14;
pub const IPV4_FLOW: u32 = 16;
pub const IPV6_FLOW: u32 = 17;
pub const ETHER_FLOW: u32 = 18;
pub const FLOW_EXT: u32 = 2147483648;
pub const FLOW_MAC_EXT: u32 = 1073741824;
pub const FLOW_RSS: u32 = 536870912;
pub const RXH_L2DA: u32 = 2;
pub const RXH_VLAN: u32 = 4;
pub const RXH_L3_PROTO: u32 = 8;
pub const RXH_IP_SRC: u32 = 16;
pub const RXH_IP_DST: u32 = 32;
pub const RXH_L4_B_0_1: u32 = 64;
pub const RXH_L4_B_2_3: u32 = 128;
pub const RXH_DISCARD: u32 = 2147483648;
pub const RX_CLS_FLOW_DISC: i32 = -1;
pub const RX_CLS_FLOW_WAKE: i32 = -2;
pub const RX_CLS_LOC_SPECIAL: u32 = 2147483648;
pub const RX_CLS_LOC_ANY: u32 = 4294967295;
pub const RX_CLS_LOC_FIRST: u32 = 4294967294;
pub const RX_CLS_LOC_LAST: u32 = 4294967293;
pub const ETH_MODULE_SFF_8079: u32 = 1;
pub const ETH_MODULE_SFF_8079_LEN: u32 = 256;
pub const ETH_MODULE_SFF_8472: u32 = 2;
pub const ETH_MODULE_SFF_8472_LEN: u32 = 512;
pub const ETH_MODULE_SFF_8636: u32 = 3;
pub const ETH_MODULE_SFF_8636_LEN: u32 = 256;
pub const ETH_MODULE_SFF_8436: u32 = 4;
pub const ETH_MODULE_SFF_8436_LEN: u32 = 256;
pub const ETH_MODULE_SFF_8636_MAX_LEN: u32 = 640;
pub const ETH_MODULE_SFF_8436_MAX_LEN: u32 = 640;
pub const ETH_RESET_SHARED_SHIFT: u32 = 16;
pub const ETH_RSS_HASH_UNKNOWN: u32 = 0;
pub const ETH_RSS_HASH_NO_CHANGE: u32 = 0;
pub const ETHTOOL_STAT_NOT_SET: i32 = -1;
pub const ETHTOOL_MAX_LANES: u32 = 8;
pub const ETHTOOL_RMON_HIST_MAX: u32 = 10;
pub const ETH_MODULE_EEPROM_PAGE_LEN: u32 = 128;
pub const ETH_MODULE_MAX_I2C_ADDRESS: u32 = 127;
pub const MII_BMCR: u32 = 0;
pub const MII_BMSR: u32 = 1;
pub const MII_PHYSID1: u32 = 2;
pub const MII_PHYSID2: u32 = 3;
pub const MII_ADVERTISE: u32 = 4;
pub const MII_LPA: u32 = 5;
pub const MII_EXPANSION: u32 = 6;
pub const MII_CTRL1000: u32 = 9;
pub const MII_STAT1000: u32 = 10;
pub const MII_MMD_CTRL: u32 = 13;
pub const MII_MMD_DATA: u32 = 14;
pub const MII_ESTATUS: u32 = 15;
pub const MII_DCOUNTER: u32 = 18;
pub const MII_FCSCOUNTER: u32 = 19;
pub const MII_NWAYTEST: u32 = 20;
pub const MII_RERRCOUNTER: u32 = 21;
pub const MII_SREVISION: u32 = 22;
pub const MII_RESV1: u32 = 23;
pub const MII_LBRERROR: u32 = 24;
pub const MII_PHYADDR: u32 = 25;
pub const MII_RESV2: u32 = 26;
pub const MII_TPISTATUS: u32 = 27;
pub const MII_NCONFIG: u32 = 28;
pub const BMCR_RESV: u32 = 63;
pub const BMCR_SPEED1000: u32 = 64;
pub const BMCR_CTST: u32 = 128;
pub const BMCR_FULLDPLX: u32 = 256;
pub const BMCR_ANRESTART: u32 = 512;
pub const BMCR_ISOLATE: u32 = 1024;
pub const BMCR_PDOWN: u32 = 2048;
pub const BMCR_ANENABLE: u32 = 4096;
pub const BMCR_SPEED100: u32 = 8192;
pub const BMCR_LOOPBACK: u32 = 16384;
pub const BMCR_RESET: u32 = 32768;
pub const BMCR_SPEED10: u32 = 0;
pub const BMSR_ERCAP: u32 = 1;
pub const BMSR_JCD: u32 = 2;
pub const BMSR_LSTATUS: u32 = 4;
pub const BMSR_ANEGCAPABLE: u32 = 8;
pub const BMSR_RFAULT: u32 = 16;
pub const BMSR_ANEGCOMPLETE: u32 = 32;
pub const BMSR_RESV: u32 = 192;
pub const BMSR_ESTATEN: u32 = 256;
pub const BMSR_100HALF2: u32 = 512;
pub const BMSR_100FULL2: u32 = 1024;
pub const BMSR_10HALF: u32 = 2048;
pub const BMSR_10FULL: u32 = 4096;
pub const BMSR_100HALF: u32 = 8192;
pub const BMSR_100FULL: u32 = 16384;
pub const BMSR_100BASE4: u32 = 32768;
pub const ADVERTISE_SLCT: u32 = 31;
pub const ADVERTISE_CSMA: u32 = 1;
pub const ADVERTISE_10HALF: u32 = 32;
pub const ADVERTISE_1000XFULL: u32 = 32;
pub const ADVERTISE_10FULL: u32 = 64;
pub const ADVERTISE_1000XHALF: u32 = 64;
pub const ADVERTISE_100HALF: u32 = 128;
pub const ADVERTISE_1000XPAUSE: u32 = 128;
pub const ADVERTISE_100FULL: u32 = 256;
pub const ADVERTISE_1000XPSE_ASYM: u32 = 256;
pub const ADVERTISE_100BASE4: u32 = 512;
pub const ADVERTISE_PAUSE_CAP: u32 = 1024;
pub const ADVERTISE_PAUSE_ASYM: u32 = 2048;
pub const ADVERTISE_RESV: u32 = 4096;
pub const ADVERTISE_RFAULT: u32 = 8192;
pub const ADVERTISE_LPACK: u32 = 16384;
pub const ADVERTISE_NPAGE: u32 = 32768;
pub const ADVERTISE_FULL: u32 = 321;
pub const ADVERTISE_ALL: u32 = 480;
pub const LPA_SLCT: u32 = 31;
pub const LPA_10HALF: u32 = 32;
pub const LPA_1000XFULL: u32 = 32;
pub const LPA_10FULL: u32 = 64;
pub const LPA_1000XHALF: u32 = 64;
pub const LPA_100HALF: u32 = 128;
pub const LPA_1000XPAUSE: u32 = 128;
pub const LPA_100FULL: u32 = 256;
pub const LPA_1000XPAUSE_ASYM: u32 = 256;
pub const LPA_100BASE4: u32 = 512;
pub const LPA_PAUSE_CAP: u32 = 1024;
pub const LPA_PAUSE_ASYM: u32 = 2048;
pub const LPA_RESV: u32 = 4096;
pub const LPA_RFAULT: u32 = 8192;
pub const LPA_LPACK: u32 = 16384;
pub const LPA_NPAGE: u32 = 32768;
pub const LPA_DUPLEX: u32 = 320;
pub const LPA_100: u32 = 896;
pub const EXPANSION_NWAY: u32 = 1;
pub const EXPANSION_LCWP: u32 = 2;
pub const EXPANSION_ENABLENPAGE: u32 = 4;
pub const EXPANSION_NPCAPABLE: u32 = 8;
pub const EXPANSION_MFAULTS: u32 = 16;
pub const EXPANSION_RESV: u32 = 65504;
pub const ESTATUS_1000_XFULL: u32 = 32768;
pub const ESTATUS_1000_XHALF: u32 = 16384;
pub const ESTATUS_1000_TFULL: u32 = 8192;
pub const ESTATUS_1000_THALF: u32 = 4096;
pub const NWAYTEST_RESV1: u32 = 255;
pub const NWAYTEST_LOOPBACK: u32 = 256;
pub const NWAYTEST_RESV2: u32 = 65024;
pub const ADVERTISE_SGMII: u32 = 1;
pub const LPA_SGMII: u32 = 1;
pub const LPA_SGMII_SPD_MASK: u32 = 3072;
pub const LPA_SGMII_FULL_DUPLEX: u32 = 4096;
pub const LPA_SGMII_DPX_SPD_MASK: u32 = 7168;
pub const LPA_SGMII_10: u32 = 0;
pub const LPA_SGMII_10HALF: u32 = 0;
pub const LPA_SGMII_10FULL: u32 = 4096;
pub const LPA_SGMII_100: u32 = 1024;
pub const LPA_SGMII_100HALF: u32 = 1024;
pub const LPA_SGMII_100FULL: u32 = 5120;
pub const LPA_SGMII_1000: u32 = 2048;
pub const LPA_SGMII_1000HALF: u32 = 2048;
pub const LPA_SGMII_1000FULL: u32 = 6144;
pub const LPA_SGMII_LINK: u32 = 32768;
pub const ADVERTISE_1000FULL: u32 = 512;
pub const ADVERTISE_1000HALF: u32 = 256;
pub const CTL1000_PREFER_MASTER: u32 = 1024;
pub const CTL1000_AS_MASTER: u32 = 2048;
pub const CTL1000_ENABLE_MASTER: u32 = 4096;
pub const LPA_1000MSFAIL: u32 = 32768;
pub const LPA_1000MSRES: u32 = 16384;
pub const LPA_1000LOCALRXOK: u32 = 8192;
pub const LPA_1000REMRXOK: u32 = 4096;
pub const LPA_1000FULL: u32 = 2048;
pub const LPA_1000HALF: u32 = 1024;
pub const FLOW_CTRL_TX: u32 = 1;
pub const FLOW_CTRL_RX: u32 = 2;
pub const MII_MMD_CTRL_DEVAD_MASK: u32 = 31;
pub const MII_MMD_CTRL_ADDR: u32 = 0;
pub const MII_MMD_CTRL_NOINCR: u32 = 16384;
pub const MII_MMD_CTRL_INCR_RDWT: u32 = 32768;
pub const MII_MMD_CTRL_INCR_ON_WT: u32 = 49152;
pub const MDIO_MMD_PMAPMD: u32 = 1;
pub const MDIO_MMD_WIS: u32 = 2;
pub const MDIO_MMD_PCS: u32 = 3;
pub const MDIO_MMD_PHYXS: u32 = 4;
pub const MDIO_MMD_DTEXS: u32 = 5;
pub const MDIO_MMD_TC: u32 = 6;
pub const MDIO_MMD_AN: u32 = 7;
pub const MDIO_MMD_C22EXT: u32 = 29;
pub const MDIO_MMD_VEND1: u32 = 30;
pub const MDIO_MMD_VEND2: u32 = 31;
pub const MDIO_CTRL1: u32 = 0;
pub const MDIO_STAT1: u32 = 1;
pub const MDIO_DEVID1: u32 = 2;
pub const MDIO_DEVID2: u32 = 3;
pub const MDIO_SPEED: u32 = 4;
pub const MDIO_DEVS1: u32 = 5;
pub const MDIO_DEVS2: u32 = 6;
pub const MDIO_CTRL2: u32 = 7;
pub const MDIO_STAT2: u32 = 8;
pub const MDIO_PMA_TXDIS: u32 = 9;
pub const MDIO_PMA_RXDET: u32 = 10;
pub const MDIO_PMA_EXTABLE: u32 = 11;
pub const MDIO_PKGID1: u32 = 14;
pub const MDIO_PKGID2: u32 = 15;
pub const MDIO_AN_ADVERTISE: u32 = 16;
pub const MDIO_AN_LPA: u32 = 19;
pub const MDIO_PCS_EEE_ABLE: u32 = 20;
pub const MDIO_PCS_EEE_ABLE2: u32 = 21;
pub const MDIO_PMA_NG_EXTABLE: u32 = 21;
pub const MDIO_PCS_EEE_WK_ERR: u32 = 22;
pub const MDIO_PHYXS_LNSTAT: u32 = 24;
pub const MDIO_AN_EEE_ADV: u32 = 60;
pub const MDIO_AN_EEE_LPABLE: u32 = 61;
pub const MDIO_AN_EEE_ADV2: u32 = 62;
pub const MDIO_AN_EEE_LPABLE2: u32 = 63;
pub const MDIO_AN_CTRL2: u32 = 64;
pub const MDIO_PMA_10GBT_SWAPPOL: u32 = 130;
pub const MDIO_PMA_10GBT_TXPWR: u32 = 131;
pub const MDIO_PMA_10GBT_SNR: u32 = 133;
pub const MDIO_PMA_10GBR_FSRT_CSR: u32 = 147;
pub const MDIO_PMA_10GBR_FECABLE: u32 = 170;
pub const MDIO_PCS_10GBX_STAT1: u32 = 24;
pub const MDIO_PCS_10GBRT_STAT1: u32 = 32;
pub const MDIO_PCS_10GBRT_STAT2: u32 = 33;
pub const MDIO_AN_10GBT_CTRL: u32 = 32;
pub const MDIO_AN_10GBT_STAT: u32 = 33;
pub const MDIO_B10L_PMA_CTRL: u32 = 2294;
pub const MDIO_PMA_10T1L_STAT: u32 = 2295;
pub const MDIO_PCS_10T1L_CTRL: u32 = 2278;
pub const MDIO_PMA_PMD_BT1: u32 = 18;
pub const MDIO_AN_T1_CTRL: u32 = 512;
pub const MDIO_AN_T1_STAT: u32 = 513;
pub const MDIO_AN_T1_ADV_L: u32 = 514;
pub const MDIO_AN_T1_ADV_M: u32 = 515;
pub const MDIO_AN_T1_ADV_H: u32 = 516;
pub const MDIO_AN_T1_LP_L: u32 = 517;
pub const MDIO_AN_T1_LP_M: u32 = 518;
pub const MDIO_AN_T1_LP_H: u32 = 519;
pub const MDIO_AN_10BT1_AN_CTRL: u32 = 526;
pub const MDIO_AN_10BT1_AN_STAT: u32 = 527;
pub const MDIO_PMA_PMD_BT1_CTRL: u32 = 2100;
pub const MDIO_PCS_1000BT1_CTRL: u32 = 2304;
pub const MDIO_PCS_1000BT1_STAT: u32 = 2305;
pub const MDIO_PMA_LASI_RXCTRL: u32 = 36864;
pub const MDIO_PMA_LASI_TXCTRL: u32 = 36865;
pub const MDIO_PMA_LASI_CTRL: u32 = 36866;
pub const MDIO_PMA_LASI_RXSTAT: u32 = 36867;
pub const MDIO_PMA_LASI_TXSTAT: u32 = 36868;
pub const MDIO_PMA_LASI_STAT: u32 = 36869;
pub const MDIO_CTRL1_SPEEDSELEXT: u32 = 8256;
pub const MDIO_CTRL1_SPEEDSEL: u32 = 8316;
pub const MDIO_CTRL1_FULLDPLX: u32 = 256;
pub const MDIO_CTRL1_LPOWER: u32 = 2048;
pub const MDIO_CTRL1_RESET: u32 = 32768;
pub const MDIO_PMA_CTRL1_LOOPBACK: u32 = 1;
pub const MDIO_PMA_CTRL1_SPEED1000: u32 = 64;
pub const MDIO_PMA_CTRL1_SPEED100: u32 = 8192;
pub const MDIO_PCS_CTRL1_LOOPBACK: u32 = 16384;
pub const MDIO_PHYXS_CTRL1_LOOPBACK: u32 = 16384;
pub const MDIO_AN_CTRL1_RESTART: u32 = 512;
pub const MDIO_AN_CTRL1_ENABLE: u32 = 4096;
pub const MDIO_AN_CTRL1_XNP: u32 = 8192;
pub const MDIO_PCS_CTRL1_CLKSTOP_EN: u32 = 1024;
pub const MDIO_CTRL1_SPEED10G: u32 = 8256;
pub const MDIO_CTRL1_SPEED10P2B: u32 = 8260;
pub const MDIO_CTRL1_SPEED2_5G: u32 = 8280;
pub const MDIO_CTRL1_SPEED5G: u32 = 8284;
pub const MDIO_STAT1_LPOWERABLE: u32 = 2;
pub const MDIO_STAT1_LSTATUS: u32 = 4;
pub const MDIO_STAT1_FAULT: u32 = 128;
pub const MDIO_AN_STAT1_LPABLE: u32 = 1;
pub const MDIO_AN_STAT1_ABLE: u32 = 8;
pub const MDIO_AN_STAT1_RFAULT: u32 = 16;
pub const MDIO_AN_STAT1_COMPLETE: u32 = 32;
pub const MDIO_AN_STAT1_PAGE: u32 = 64;
pub const MDIO_AN_STAT1_XNP: u32 = 128;
pub const MDIO_SPEED_10G: u32 = 1;
pub const MDIO_PMA_SPEED_2B: u32 = 2;
pub const MDIO_PMA_SPEED_10P: u32 = 4;
pub const MDIO_PMA_SPEED_1000: u32 = 16;
pub const MDIO_PMA_SPEED_100: u32 = 32;
pub const MDIO_PMA_SPEED_10: u32 = 64;
pub const MDIO_PCS_SPEED_10P2B: u32 = 2;
pub const MDIO_PCS_SPEED_2_5G: u32 = 64;
pub const MDIO_PCS_SPEED_5G: u32 = 128;
pub const MDIO_PMA_CTRL2_TYPE: u32 = 15;
pub const MDIO_PMA_CTRL2_10GBCX4: u32 = 0;
pub const MDIO_PMA_CTRL2_10GBEW: u32 = 1;
pub const MDIO_PMA_CTRL2_10GBLW: u32 = 2;
pub const MDIO_PMA_CTRL2_10GBSW: u32 = 3;
pub const MDIO_PMA_CTRL2_10GBLX4: u32 = 4;
pub const MDIO_PMA_CTRL2_10GBER: u32 = 5;
pub const MDIO_PMA_CTRL2_10GBLR: u32 = 6;
pub const MDIO_PMA_CTRL2_10GBSR: u32 = 7;
pub const MDIO_PMA_CTRL2_10GBLRM: u32 = 8;
pub const MDIO_PMA_CTRL2_10GBT: u32 = 9;
pub const MDIO_PMA_CTRL2_10GBKX4: u32 = 10;
pub const MDIO_PMA_CTRL2_10GBKR: u32 = 11;
pub const MDIO_PMA_CTRL2_1000BT: u32 = 12;
pub const MDIO_PMA_CTRL2_1000BKX: u32 = 13;
pub const MDIO_PMA_CTRL2_100BTX: u32 = 14;
pub const MDIO_PMA_CTRL2_10BT: u32 = 15;
pub const MDIO_PMA_CTRL2_2_5GBT: u32 = 48;
pub const MDIO_PMA_CTRL2_5GBT: u32 = 49;
pub const MDIO_PMA_CTRL2_BASET1: u32 = 61;
pub const MDIO_PCS_CTRL2_TYPE: u32 = 3;
pub const MDIO_PCS_CTRL2_10GBR: u32 = 0;
pub const MDIO_PCS_CTRL2_10GBX: u32 = 1;
pub const MDIO_PCS_CTRL2_10GBW: u32 = 2;
pub const MDIO_PCS_CTRL2_10GBT: u32 = 3;
pub const MDIO_STAT2_RXFAULT: u32 = 1024;
pub const MDIO_STAT2_TXFAULT: u32 = 2048;
pub const MDIO_STAT2_DEVPRST: u32 = 49152;
pub const MDIO_STAT2_DEVPRST_VAL: u32 = 32768;
pub const MDIO_PMA_STAT2_LBABLE: u32 = 1;
pub const MDIO_PMA_STAT2_10GBEW: u32 = 2;
pub const MDIO_PMA_STAT2_10GBLW: u32 = 4;
pub const MDIO_PMA_STAT2_10GBSW: u32 = 8;
pub const MDIO_PMA_STAT2_10GBLX4: u32 = 16;
pub const MDIO_PMA_STAT2_10GBER: u32 = 32;
pub const MDIO_PMA_STAT2_10GBLR: u32 = 64;
pub const MDIO_PMA_STAT2_10GBSR: u32 = 128;
pub const MDIO_PMD_STAT2_TXDISAB: u32 = 256;
pub const MDIO_PMA_STAT2_EXTABLE: u32 = 512;
pub const MDIO_PMA_STAT2_RXFLTABLE: u32 = 4096;
pub const MDIO_PMA_STAT2_TXFLTABLE: u32 = 8192;
pub const MDIO_PCS_STAT2_10GBR: u32 = 1;
pub const MDIO_PCS_STAT2_10GBX: u32 = 2;
pub const MDIO_PCS_STAT2_10GBW: u32 = 4;
pub const MDIO_PCS_STAT2_RXFLTABLE: u32 = 4096;
pub const MDIO_PCS_STAT2_TXFLTABLE: u32 = 8192;
pub const MDIO_PMD_TXDIS_GLOBAL: u32 = 1;
pub const MDIO_PMD_TXDIS_0: u32 = 2;
pub const MDIO_PMD_TXDIS_1: u32 = 4;
pub const MDIO_PMD_TXDIS_2: u32 = 8;
pub const MDIO_PMD_TXDIS_3: u32 = 16;
pub const MDIO_PMD_RXDET_GLOBAL: u32 = 1;
pub const MDIO_PMD_RXDET_0: u32 = 2;
pub const MDIO_PMD_RXDET_1: u32 = 4;
pub const MDIO_PMD_RXDET_2: u32 = 8;
pub const MDIO_PMD_RXDET_3: u32 = 16;
pub const MDIO_PMA_EXTABLE_10GCX4: u32 = 1;
pub const MDIO_PMA_EXTABLE_10GBLRM: u32 = 2;
pub const MDIO_PMA_EXTABLE_10GBT: u32 = 4;
pub const MDIO_PMA_EXTABLE_10GBKX4: u32 = 8;
pub const MDIO_PMA_EXTABLE_10GBKR: u32 = 16;
pub const MDIO_PMA_EXTABLE_1000BT: u32 = 32;
pub const MDIO_PMA_EXTABLE_1000BKX: u32 = 64;
pub const MDIO_PMA_EXTABLE_100BTX: u32 = 128;
pub const MDIO_PMA_EXTABLE_10BT: u32 = 256;
pub const MDIO_PMA_EXTABLE_BT1: u32 = 2048;
pub const MDIO_PMA_EXTABLE_NBT: u32 = 16384;
pub const MDIO_PHYXS_LNSTAT_SYNC0: u32 = 1;
pub const MDIO_PHYXS_LNSTAT_SYNC1: u32 = 2;
pub const MDIO_PHYXS_LNSTAT_SYNC2: u32 = 4;
pub const MDIO_PHYXS_LNSTAT_SYNC3: u32 = 8;
pub const MDIO_PHYXS_LNSTAT_ALIGN: u32 = 4096;
pub const MDIO_PMA_10GBT_SWAPPOL_ABNX: u32 = 1;
pub const MDIO_PMA_10GBT_SWAPPOL_CDNX: u32 = 2;
pub const MDIO_PMA_10GBT_SWAPPOL_AREV: u32 = 256;
pub const MDIO_PMA_10GBT_SWAPPOL_BREV: u32 = 512;
pub const MDIO_PMA_10GBT_SWAPPOL_CREV: u32 = 1024;
pub const MDIO_PMA_10GBT_SWAPPOL_DREV: u32 = 2048;
pub const MDIO_PMA_10GBT_TXPWR_SHORT: u32 = 1;
pub const MDIO_PMA_10GBT_SNR_BIAS: u32 = 32768;
pub const MDIO_PMA_10GBT_SNR_MAX: u32 = 127;
pub const MDIO_PMA_10GBR_FECABLE_ABLE: u32 = 1;
pub const MDIO_PMA_10GBR_FECABLE_ERRABLE: u32 = 2;
pub const MDIO_PMA_10GBR_FSRT_ENABLE: u32 = 1;
pub const MDIO_PCS_10GBRT_STAT1_BLKLK: u32 = 1;
pub const MDIO_PCS_10GBRT_STAT2_ERR: u32 = 255;
pub const MDIO_PCS_10GBRT_STAT2_BER: u32 = 16128;
pub const MDIO_AN_10GBT_CTRL_ADVFSRT2_5G: u32 = 32;
pub const MDIO_AN_10GBT_CTRL_ADV2_5G: u32 = 128;
pub const MDIO_AN_10GBT_CTRL_ADV5G: u32 = 256;
pub const MDIO_AN_10GBT_CTRL_ADV10G: u32 = 4096;
pub const MDIO_AN_10GBT_STAT_LP2_5G: u32 = 32;
pub const MDIO_AN_10GBT_STAT_LP5G: u32 = 64;
pub const MDIO_AN_10GBT_STAT_LPTRR: u32 = 512;
pub const MDIO_AN_10GBT_STAT_LPLTABLE: u32 = 1024;
pub const MDIO_AN_10GBT_STAT_LP10G: u32 = 2048;
pub const MDIO_AN_10GBT_STAT_REMOK: u32 = 4096;
pub const MDIO_AN_10GBT_STAT_LOCOK: u32 = 8192;
pub const MDIO_AN_10GBT_STAT_MS: u32 = 16384;
pub const MDIO_AN_10GBT_STAT_MSFLT: u32 = 32768;
pub const MDIO_PMA_10T1L_CTRL_LB_EN: u32 = 1;
pub const MDIO_PMA_10T1L_CTRL_EEE_EN: u32 = 1024;
pub const MDIO_PMA_10T1L_CTRL_LOW_POWER: u32 = 2048;
pub const MDIO_PMA_10T1L_CTRL_2V4_EN: u32 = 4096;
pub const MDIO_PMA_10T1L_CTRL_TX_DIS: u32 = 16384;
pub const MDIO_PMA_10T1L_CTRL_PMA_RST: u32 = 32768;
pub const MDIO_PMA_10T1L_STAT_LINK: u32 = 1;
pub const MDIO_PMA_10T1L_STAT_FAULT: u32 = 2;
pub const MDIO_PMA_10T1L_STAT_POLARITY: u32 = 4;
pub const MDIO_PMA_10T1L_STAT_RECV_FAULT: u32 = 512;
pub const MDIO_PMA_10T1L_STAT_EEE: u32 = 1024;
pub const MDIO_PMA_10T1L_STAT_LOW_POWER: u32 = 2048;
pub const MDIO_PMA_10T1L_STAT_2V4_ABLE: u32 = 4096;
pub const MDIO_PMA_10T1L_STAT_LB_ABLE: u32 = 8192;
pub const MDIO_PCS_10T1L_CTRL_LB: u32 = 16384;
pub const MDIO_PCS_10T1L_CTRL_RESET: u32 = 32768;
pub const MDIO_PMA_PMD_BT1_B100_ABLE: u32 = 1;
pub const MDIO_PMA_PMD_BT1_B1000_ABLE: u32 = 2;
pub const MDIO_PMA_PMD_BT1_B10L_ABLE: u32 = 4;
pub const MDIO_AN_T1_ADV_L_PAUSE_CAP: u32 = 1024;
pub const MDIO_AN_T1_ADV_L_PAUSE_ASYM: u32 = 2048;
pub const MDIO_AN_T1_ADV_L_FORCE_MS: u32 = 4096;
pub const MDIO_AN_T1_ADV_L_REMOTE_FAULT: u32 = 8192;
pub const MDIO_AN_T1_ADV_L_ACK: u32 = 16384;
pub const MDIO_AN_T1_ADV_L_NEXT_PAGE_REQ: u32 = 32768;
pub const MDIO_AN_T1_ADV_M_B10L: u32 = 16384;
pub const MDIO_AN_T1_ADV_M_MST: u32 = 16;
pub const MDIO_AN_T1_ADV_H_10L_TX_HI_REQ: u32 = 4096;
pub const MDIO_AN_T1_ADV_H_10L_TX_HI: u32 = 8192;
pub const MDIO_AN_T1_LP_L_PAUSE_CAP: u32 = 1024;
pub const MDIO_AN_T1_LP_L_PAUSE_ASYM: u32 = 2048;
pub const MDIO_AN_T1_LP_L_FORCE_MS: u32 = 4096;
pub const MDIO_AN_T1_LP_L_REMOTE_FAULT: u32 = 8192;
pub const MDIO_AN_T1_LP_L_ACK: u32 = 16384;
pub const MDIO_AN_T1_LP_L_NEXT_PAGE_REQ: u32 = 32768;
pub const MDIO_AN_T1_LP_M_MST: u32 = 16;
pub const MDIO_AN_T1_LP_M_B10L: u32 = 16384;
pub const MDIO_AN_T1_LP_H_10L_TX_HI_REQ: u32 = 4096;
pub const MDIO_AN_T1_LP_H_10L_TX_HI: u32 = 8192;
pub const MDIO_AN_10BT1_AN_CTRL_ADV_EEE_T1L: u32 = 16384;
pub const MDIO_AN_10BT1_AN_STAT_LPA_EEE_T1L: u32 = 16384;
pub const MDIO_PMA_PMD_BT1_CTRL_STRAP: u32 = 15;
pub const MDIO_PMA_PMD_BT1_CTRL_STRAP_B1000: u32 = 1;
pub const MDIO_PMA_PMD_BT1_CTRL_CFG_MST: u32 = 16384;
pub const MDIO_PCS_1000BT1_CTRL_LOW_POWER: u32 = 2048;
pub const MDIO_PCS_1000BT1_CTRL_DISABLE_TX: u32 = 16384;
pub const MDIO_PCS_1000BT1_CTRL_RESET: u32 = 32768;
pub const MDIO_PCS_1000BT1_STAT_LINK: u32 = 4;
pub const MDIO_PCS_1000BT1_STAT_FAULT: u32 = 128;
pub const MDIO_AN_EEE_ADV_100TX: u32 = 2;
pub const MDIO_AN_EEE_ADV_1000T: u32 = 4;
pub const MDIO_EEE_100TX: u32 = 2;
pub const MDIO_EEE_1000T: u32 = 4;
pub const MDIO_EEE_10GT: u32 = 8;
pub const MDIO_EEE_1000KX: u32 = 16;
pub const MDIO_EEE_10GKX4: u32 = 32;
pub const MDIO_EEE_10GKR: u32 = 64;
pub const MDIO_EEE_40GR_FW: u32 = 256;
pub const MDIO_EEE_40GR_DS: u32 = 512;
pub const MDIO_EEE_100GR_FW: u32 = 4096;
pub const MDIO_EEE_100GR_DS: u32 = 8192;
pub const MDIO_EEE_2_5GT: u32 = 1;
pub const MDIO_EEE_5GT: u32 = 2;
pub const MDIO_AN_THP_BP2_5GT: u32 = 8;
pub const MDIO_PMA_NG_EXTABLE_2_5GBT: u32 = 1;
pub const MDIO_PMA_NG_EXTABLE_5GBT: u32 = 2;
pub const MDIO_PMA_LASI_RX_PHYXSLFLT: u32 = 1;
pub const MDIO_PMA_LASI_RX_PCSLFLT: u32 = 8;
pub const MDIO_PMA_LASI_RX_PMALFLT: u32 = 16;
pub const MDIO_PMA_LASI_RX_OPTICPOWERFLT: u32 = 32;
pub const MDIO_PMA_LASI_RX_WISLFLT: u32 = 512;
pub const MDIO_PMA_LASI_TX_PHYXSLFLT: u32 = 1;
pub const MDIO_PMA_LASI_TX_PCSLFLT: u32 = 8;
pub const MDIO_PMA_LASI_TX_PMALFLT: u32 = 16;
pub const MDIO_PMA_LASI_TX_LASERPOWERFLT: u32 = 128;
pub const MDIO_PMA_LASI_TX_LASERTEMPFLT: u32 = 256;
pub const MDIO_PMA_LASI_TX_LASERBICURRFLT: u32 = 512;
pub const MDIO_PMA_LASI_LSALARM: u32 = 1;
pub const MDIO_PMA_LASI_TXALARM: u32 = 2;
pub const MDIO_PMA_LASI_RXALARM: u32 = 4;
pub const MDIO_PHY_ID_C45: u32 = 32768;
pub const MDIO_PHY_ID_PRTAD: u32 = 992;
pub const MDIO_PHY_ID_DEVAD: u32 = 31;
pub const MDIO_PHY_ID_C45_MASK: u32 = 33791;
pub const MDIO_USXGMII_EEE_CLK_STP: u32 = 128;
pub const MDIO_USXGMII_EEE: u32 = 256;
pub const MDIO_USXGMII_SPD_MASK: u32 = 3584;
pub const MDIO_USXGMII_FULL_DUPLEX: u32 = 4096;
pub const MDIO_USXGMII_DPX_SPD_MASK: u32 = 7680;
pub const MDIO_USXGMII_10: u32 = 0;
pub const MDIO_USXGMII_10HALF: u32 = 0;
pub const MDIO_USXGMII_10FULL: u32 = 4096;
pub const MDIO_USXGMII_100: u32 = 512;
pub const MDIO_USXGMII_100HALF: u32 = 512;
pub const MDIO_USXGMII_100FULL: u32 = 4608;
pub const MDIO_USXGMII_1000: u32 = 1024;
pub const MDIO_USXGMII_1000HALF: u32 = 1024;
pub const MDIO_USXGMII_1000FULL: u32 = 5120;
pub const MDIO_USXGMII_10G: u32 = 1536;
pub const MDIO_USXGMII_10GHALF: u32 = 1536;
pub const MDIO_USXGMII_10GFULL: u32 = 5632;
pub const MDIO_USXGMII_2500: u32 = 2048;
pub const MDIO_USXGMII_2500HALF: u32 = 2048;
pub const MDIO_USXGMII_2500FULL: u32 = 6144;
pub const MDIO_USXGMII_5000: u32 = 2560;
pub const MDIO_USXGMII_5000HALF: u32 = 2560;
pub const MDIO_USXGMII_5000FULL: u32 = 6656;
pub const MDIO_USXGMII_LINK: u32 = 32768;
pub const PCI_ANY_ID: i32 = -1;
pub const IEEE1394_MATCH_VENDOR_ID: u32 = 1;
pub const IEEE1394_MATCH_MODEL_ID: u32 = 2;
pub const IEEE1394_MATCH_SPECIFIER_ID: u32 = 4;
pub const IEEE1394_MATCH_VERSION: u32 = 8;
pub const USB_DEVICE_ID_MATCH_VENDOR: u32 = 1;
pub const USB_DEVICE_ID_MATCH_PRODUCT: u32 = 2;
pub const USB_DEVICE_ID_MATCH_DEV_LO: u32 = 4;
pub const USB_DEVICE_ID_MATCH_DEV_HI: u32 = 8;
pub const USB_DEVICE_ID_MATCH_DEV_CLASS: u32 = 16;
pub const USB_DEVICE_ID_MATCH_DEV_SUBCLASS: u32 = 32;
pub const USB_DEVICE_ID_MATCH_DEV_PROTOCOL: u32 = 64;
pub const USB_DEVICE_ID_MATCH_INT_CLASS: u32 = 128;
pub const USB_DEVICE_ID_MATCH_INT_SUBCLASS: u32 = 256;
pub const USB_DEVICE_ID_MATCH_INT_PROTOCOL: u32 = 512;
pub const USB_DEVICE_ID_MATCH_INT_NUMBER: u32 = 1024;
pub const HID_ANY_ID: i32 = -1;
pub const HID_BUS_ANY: u32 = 65535;
pub const HID_GROUP_ANY: u32 = 0;
pub const CCW_DEVICE_ID_MATCH_CU_TYPE: u32 = 1;
pub const CCW_DEVICE_ID_MATCH_CU_MODEL: u32 = 2;
pub const CCW_DEVICE_ID_MATCH_DEVICE_TYPE: u32 = 4;
pub const CCW_DEVICE_ID_MATCH_DEVICE_MODEL: u32 = 8;
pub const AP_DEVICE_ID_MATCH_CARD_TYPE: u32 = 1;
pub const AP_DEVICE_ID_MATCH_QUEUE_TYPE: u32 = 2;
pub const ACPI_ID_LEN: u32 = 16;
pub const PNP_ID_LEN: u32 = 8;
pub const PNP_MAX_DEVICES: u32 = 8;
pub const SERIO_ANY: u32 = 255;
pub const PCMCIA_DEV_ID_MATCH_MANF_ID: u32 = 1;
pub const PCMCIA_DEV_ID_MATCH_CARD_ID: u32 = 2;
pub const PCMCIA_DEV_ID_MATCH_FUNC_ID: u32 = 4;
pub const PCMCIA_DEV_ID_MATCH_FUNCTION: u32 = 8;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID1: u32 = 16;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID2: u32 = 32;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID3: u32 = 64;
pub const PCMCIA_DEV_ID_MATCH_PROD_ID4: u32 = 128;
pub const PCMCIA_DEV_ID_MATCH_DEVICE_NO: u32 = 256;
pub const PCMCIA_DEV_ID_MATCH_FAKE_CIS: u32 = 512;
pub const PCMCIA_DEV_ID_MATCH_ANONYMOUS: u32 = 1024;
pub const INPUT_DEVICE_ID_EV_MAX: u32 = 31;
pub const INPUT_DEVICE_ID_KEY_MIN_INTERESTING: u32 = 113;
pub const INPUT_DEVICE_ID_KEY_MAX: u32 = 767;
pub const INPUT_DEVICE_ID_REL_MAX: u32 = 15;
pub const INPUT_DEVICE_ID_ABS_MAX: u32 = 63;
pub const INPUT_DEVICE_ID_MSC_MAX: u32 = 7;
pub const INPUT_DEVICE_ID_LED_MAX: u32 = 15;
pub const INPUT_DEVICE_ID_SND_MAX: u32 = 7;
pub const INPUT_DEVICE_ID_FF_MAX: u32 = 127;
pub const INPUT_DEVICE_ID_SW_MAX: u32 = 16;
pub const INPUT_DEVICE_ID_PROP_MAX: u32 = 31;
pub const INPUT_DEVICE_ID_MATCH_BUS: u32 = 1;
pub const INPUT_DEVICE_ID_MATCH_VENDOR: u32 = 2;
pub const INPUT_DEVICE_ID_MATCH_PRODUCT: u32 = 4;
pub const INPUT_DEVICE_ID_MATCH_VERSION: u32 = 8;
pub const INPUT_DEVICE_ID_MATCH_EVBIT: u32 = 16;
pub const INPUT_DEVICE_ID_MATCH_KEYBIT: u32 = 32;
pub const INPUT_DEVICE_ID_MATCH_RELBIT: u32 = 64;
pub const INPUT_DEVICE_ID_MATCH_ABSBIT: u32 = 128;
pub const INPUT_DEVICE_ID_MATCH_MSCIT: u32 = 256;
pub const INPUT_DEVICE_ID_MATCH_LEDBIT: u32 = 512;
pub const INPUT_DEVICE_ID_MATCH_SNDBIT: u32 = 1024;
pub const INPUT_DEVICE_ID_MATCH_FFBIT: u32 = 2048;
pub const INPUT_DEVICE_ID_MATCH_SWBIT: u32 = 4096;
pub const INPUT_DEVICE_ID_MATCH_PROPBIT: u32 = 8192;
pub const EISA_SIG_LEN: u32 = 8;
pub const EISA_DEVICE_MODALIAS_FMT: &[u8; 9usize] = b"eisa:s%s\0";
pub const PA_HWTYPE_ANY_ID: u32 = 255;
pub const PA_HVERSION_REV_ANY_ID: u32 = 255;
pub const PA_HVERSION_ANY_ID: u32 = 65535;
pub const PA_SVERSION_ANY_ID: u32 = 4294967295;
pub const SDIO_ANY_ID: i32 = -1;
pub const SSB_ANY_VENDOR: u32 = 65535;
pub const SSB_ANY_ID: u32 = 65535;
pub const SSB_ANY_REV: u32 = 255;
pub const BCMA_ANY_MANUF: u32 = 65535;
pub const BCMA_ANY_ID: u32 = 65535;
pub const BCMA_ANY_REV: u32 = 255;
pub const BCMA_ANY_CLASS: u32 = 255;
pub const VIRTIO_DEV_ANY_ID: u32 = 4294967295;
pub const RPMSG_NAME_SIZE: u32 = 32;
pub const RPMSG_DEVICE_MODALIAS_FMT: &[u8; 9usize] = b"rpmsg:%s\0";
pub const I2C_NAME_SIZE: u32 = 20;
pub const I2C_MODULE_PREFIX: &[u8; 5usize] = b"i2c:\0";
pub const PCI_EPF_NAME_SIZE: u32 = 20;
pub const PCI_EPF_MODULE_PREFIX: &[u8; 9usize] = b"pci_epf:\0";
pub const I3C_MATCH_DCR: u32 = 1;
pub const I3C_MATCH_MANUF: u32 = 2;
pub const I3C_MATCH_PART: u32 = 4;
pub const I3C_MATCH_EXTRA_INFO: u32 = 8;
pub const SPI_NAME_SIZE: u32 = 32;
pub const SPI_MODULE_PREFIX: &[u8; 5usize] = b"spi:\0";
pub const SLIMBUS_NAME_SIZE: u32 = 32;
pub const SLIMBUS_MODULE_PREFIX: &[u8; 6usize] = b"slim:\0";
pub const APR_NAME_SIZE: u32 = 32;
pub const APR_MODULE_PREFIX: &[u8; 5usize] = b"apr:\0";
pub const SPMI_NAME_SIZE: u32 = 32;
pub const SPMI_MODULE_PREFIX: &[u8; 6usize] = b"spmi:\0";
pub const PLATFORM_NAME_SIZE: u32 = 20;
pub const PLATFORM_MODULE_PREFIX: &[u8; 10usize] = b"platform:\0";
pub const MDIO_NAME_SIZE: u32 = 32;
pub const MDIO_MODULE_PREFIX: &[u8; 6usize] = b"mdio:\0";
pub const MDIO_ID_FMT: &[u8; 65usize] =
    b"%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u\0";
pub const ZORRO_WILDCARD: u32 = 4294967295;
pub const ZORRO_DEVICE_MODALIAS_FMT: &[u8; 12usize] = b"zorro:i%08X\0";
pub const ISAPNP_ANY_ID: u32 = 65535;
pub const X86_VENDOR_ANY: u32 = 65535;
pub const X86_FAMILY_ANY: u32 = 0;
pub const X86_MODEL_ANY: u32 = 0;
pub const X86_STEPPING_ANY: u32 = 0;
pub const X86_FEATURE_ANY: u32 = 0;
pub const IPACK_ANY_FORMAT: u32 = 255;
pub const IPACK_ANY_ID: i32 = -1;
pub const MEI_CL_MODULE_PREFIX: &[u8; 5usize] = b"mei:\0";
pub const MEI_CL_NAME_SIZE: u32 = 32;
pub const MEI_CL_VERSION_ANY: u32 = 255;
pub const RIO_ANY_ID: u32 = 65535;
pub const TBSVC_MATCH_PROTOCOL_KEY: u32 = 1;
pub const TBSVC_MATCH_PROTOCOL_ID: u32 = 2;
pub const TBSVC_MATCH_PROTOCOL_VERSION: u32 = 4;
pub const TBSVC_MATCH_PROTOCOL_REVISION: u32 = 8;
pub const TYPEC_ANY_MODE: u32 = 7;
pub const WMI_MODULE_PREFIX: &[u8; 5usize] = b"wmi:\0";
pub const MHI_DEVICE_MODALIAS_FMT: &[u8; 7usize] = b"mhi:%s\0";
pub const MHI_NAME_SIZE: u32 = 32;
pub const MHI_EP_DEVICE_MODALIAS_FMT: &[u8; 10usize] = b"mhi_ep:%s\0";
pub const AUXILIARY_NAME_SIZE: u32 = 32;
pub const AUXILIARY_MODULE_PREFIX: &[u8; 11usize] = b"auxiliary:\0";
pub const SSAM_MATCH_TARGET: u32 = 1;
pub const SSAM_MATCH_INSTANCE: u32 = 2;
pub const SSAM_MATCH_FUNCTION: u32 = 4;
pub const ISHTP_MODULE_PREFIX: &[u8; 7usize] = b"ishtp:\0";
pub const CDX_ANY_ID: u32 = 65535;
pub const MDIO_DEVICE_FLAG_PHY: u32 = 1;
pub const MDIO_PRTAD_NONE: i32 = -1;
pub const MDIO_DEVAD_NONE: i32 = -1;
pub const MDIO_SUPPORTS_C22: u32 = 1;
pub const MDIO_SUPPORTS_C45: u32 = 2;
pub const MDIO_EMULATE_C22: u32 = 4;
pub const LEDS_TRIG_TYPE_EDGE: u32 = 0;
pub const LEDS_TRIG_TYPE_LEVEL: u32 = 1;
pub const LEDS_BOOST_OFF: u32 = 0;
pub const LEDS_BOOST_ADAPTIVE: u32 = 1;
pub const LEDS_BOOST_FIXED: u32 = 2;
pub const LED_COLOR_ID_WHITE: u32 = 0;
pub const LED_COLOR_ID_RED: u32 = 1;
pub const LED_COLOR_ID_GREEN: u32 = 2;
pub const LED_COLOR_ID_BLUE: u32 = 3;
pub const LED_COLOR_ID_AMBER: u32 = 4;
pub const LED_COLOR_ID_VIOLET: u32 = 5;
pub const LED_COLOR_ID_YELLOW: u32 = 6;
pub const LED_COLOR_ID_IR: u32 = 7;
pub const LED_COLOR_ID_MULTI: u32 = 8;
pub const LED_COLOR_ID_RGB: u32 = 9;
pub const LED_COLOR_ID_PURPLE: u32 = 10;
pub const LED_COLOR_ID_ORANGE: u32 = 11;
pub const LED_COLOR_ID_PINK: u32 = 12;
pub const LED_COLOR_ID_CYAN: u32 = 13;
pub const LED_COLOR_ID_LIME: u32 = 14;
pub const LED_COLOR_ID_MAX: u32 = 15;
pub const LED_FUNCTION_CAPSLOCK: &[u8; 9usize] = b"capslock\0";
pub const LED_FUNCTION_SCROLLLOCK: &[u8; 11usize] = b"scrolllock\0";
pub const LED_FUNCTION_NUMLOCK: &[u8; 8usize] = b"numlock\0";
pub const LED_FUNCTION_KBD_BACKLIGHT: &[u8; 14usize] = b"kbd_backlight\0";
pub const LED_FUNCTION_POWER: &[u8; 6usize] = b"power\0";
pub const LED_FUNCTION_DISK: &[u8; 5usize] = b"disk\0";
pub const LED_FUNCTION_CHARGING: &[u8; 9usize] = b"charging\0";
pub const LED_FUNCTION_STATUS: &[u8; 7usize] = b"status\0";
pub const LED_FUNCTION_MICMUTE: &[u8; 8usize] = b"micmute\0";
pub const LED_FUNCTION_MUTE: &[u8; 5usize] = b"mute\0";
pub const LED_FUNCTION_PLAYER1: &[u8; 9usize] = b"player-1\0";
pub const LED_FUNCTION_PLAYER2: &[u8; 9usize] = b"player-2\0";
pub const LED_FUNCTION_PLAYER3: &[u8; 9usize] = b"player-3\0";
pub const LED_FUNCTION_PLAYER4: &[u8; 9usize] = b"player-4\0";
pub const LED_FUNCTION_PLAYER5: &[u8; 9usize] = b"player-5\0";
pub const LED_FUNCTION_ACTIVITY: &[u8; 9usize] = b"activity\0";
pub const LED_FUNCTION_ALARM: &[u8; 6usize] = b"alarm\0";
pub const LED_FUNCTION_BACKLIGHT: &[u8; 10usize] = b"backlight\0";
pub const LED_FUNCTION_BLUETOOTH: &[u8; 10usize] = b"bluetooth\0";
pub const LED_FUNCTION_BOOT: &[u8; 5usize] = b"boot\0";
pub const LED_FUNCTION_CPU: &[u8; 4usize] = b"cpu\0";
pub const LED_FUNCTION_DEBUG: &[u8; 6usize] = b"debug\0";
pub const LED_FUNCTION_DISK_ACTIVITY: &[u8; 14usize] = b"disk-activity\0";
pub const LED_FUNCTION_DISK_ERR: &[u8; 9usize] = b"disk-err\0";
pub const LED_FUNCTION_DISK_READ: &[u8; 10usize] = b"disk-read\0";
pub const LED_FUNCTION_DISK_WRITE: &[u8; 11usize] = b"disk-write\0";
pub const LED_FUNCTION_FAULT: &[u8; 6usize] = b"fault\0";
pub const LED_FUNCTION_FLASH: &[u8; 6usize] = b"flash\0";
pub const LED_FUNCTION_HEARTBEAT: &[u8; 10usize] = b"heartbeat\0";
pub const LED_FUNCTION_INDICATOR: &[u8; 10usize] = b"indicator\0";
pub const LED_FUNCTION_LAN: &[u8; 4usize] = b"lan\0";
pub const LED_FUNCTION_MAIL: &[u8; 5usize] = b"mail\0";
pub const LED_FUNCTION_MTD: &[u8; 4usize] = b"mtd\0";
pub const LED_FUNCTION_PANIC: &[u8; 6usize] = b"panic\0";
pub const LED_FUNCTION_PROGRAMMING: &[u8; 12usize] = b"programming\0";
pub const LED_FUNCTION_RX: &[u8; 3usize] = b"rx\0";
pub const LED_FUNCTION_SD: &[u8; 3usize] = b"sd\0";
pub const LED_FUNCTION_STANDBY: &[u8; 8usize] = b"standby\0";
pub const LED_FUNCTION_TORCH: &[u8; 6usize] = b"torch\0";
pub const LED_FUNCTION_TX: &[u8; 3usize] = b"tx\0";
pub const LED_FUNCTION_USB: &[u8; 4usize] = b"usb\0";
pub const LED_FUNCTION_WAN: &[u8; 4usize] = b"wan\0";
pub const LED_FUNCTION_WLAN: &[u8; 5usize] = b"wlan\0";
pub const LED_FUNCTION_WPS: &[u8; 4usize] = b"wps\0";
pub const LED_BLINK_SW: u32 = 0;
pub const LED_BLINK_ONESHOT: u32 = 1;
pub const LED_BLINK_ONESHOT_STOP: u32 = 2;
pub const LED_BLINK_INVERT: u32 = 3;
pub const LED_BLINK_BRIGHTNESS_CHANGE: u32 = 4;
pub const LED_BLINK_DISABLE: u32 = 5;
pub const LED_SET_BRIGHTNESS_OFF: u32 = 6;
pub const LED_SET_BRIGHTNESS: u32 = 7;
pub const LED_SET_BLINK: u32 = 8;
pub const TRIG_NAME_MAX: u32 = 50;
pub const GPIO_LED_NO_BLINK_LOW: u32 = 0;
pub const GPIO_LED_NO_BLINK_HIGH: u32 = 1;
pub const GPIO_LED_BLINK: u32 = 2;
pub const MAX_UDELAY_MS: u32 = 5;
pub const PHY_POLL: i32 = -1;
pub const PHY_MAC_INTERRUPT: i32 = -2;
pub const PHY_IS_INTERNAL: u32 = 1;
pub const PHY_RST_AFTER_CLK_EN: u32 = 2;
pub const PHY_POLL_CABLE_TEST: u32 = 4;
pub const PHY_ALWAYS_CALL_SUSPEND: u32 = 8;
pub const MDIO_DEVICE_IS_PHY: u32 = 2147483648;
pub const PHY_INIT_TIMEOUT: u32 = 100000;
pub const PHY_FORCE_TIMEOUT: u32 = 10;
pub const PHY_MAX_ADDR: u32 = 32;
pub const PHY_ID_FMT: &[u8; 8usize] = b"%s:%02x\0";
pub const MII_BUS_ID_SIZE: u32 = 61;
pub const PHY_SHARED_F_INIT_DONE: u32 = 0;
pub const PHY_SHARED_F_PROBE_DONE: u32 = 1;
pub const MDIO_MMD_NUM: u32 = 32;
pub const PHY_F_NO_IRQ: u32 = 2147483648;
pub const PHY_PAIR_ALL: i32 = -1;
pub const PHY_ANY_ID: &[u8; 14usize] = b"MATCH ANY PHY\0";
pub const PHY_ANY_UID: u32 = 4294967295;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ftrace_branch_data {
    pub func: *const core::ffi::c_char,
    pub file: *const core::ffi::c_char,
    pub line: core::ffi::c_uint,
    pub __bindgen_anon_1: ftrace_branch_data__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ftrace_branch_data__bindgen_ty_1 {
    pub __bindgen_anon_1: ftrace_branch_data__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: ftrace_branch_data__bindgen_ty_1__bindgen_ty_2,
    pub miss_hit: [core::ffi::c_ulong; 2usize],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct ftrace_branch_data__bindgen_ty_1__bindgen_ty_1 {
    pub correct: core::ffi::c_ulong,
    pub incorrect: core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct ftrace_branch_data__bindgen_ty_1__bindgen_ty_2 {
    pub miss: core::ffi::c_ulong,
    pub hit: core::ffi::c_ulong,
}
impl Default for ftrace_branch_data__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ftrace_branch_data {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ftrace_likely_data {
    pub data: ftrace_branch_data,
    pub constant: core::ffi::c_ulong,
}
impl Default for ftrace_likely_data {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn ftrace_likely_update(
        f: *mut ftrace_likely_data,
        val: core::ffi::c_int,
        expect: core::ffi::c_int,
        is_constant: core::ffi::c_int,
    );
}
pub type __s8 = core::ffi::c_schar;
pub type __u8 = core::ffi::c_uchar;
pub type __s16 = core::ffi::c_short;
pub type __u16 = core::ffi::c_ushort;
pub type __s32 = core::ffi::c_int;
pub type __u32 = core::ffi::c_uint;
pub type __s64 = core::ffi::c_longlong;
pub type __u64 = core::ffi::c_ulonglong;
pub type s8 = __s8;
pub type u8_ = __u8;
pub type s16 = __s16;
pub type u16_ = __u16;
pub type s32 = __s32;
pub type u32_ = __u32;
pub type s64 = __s64;
pub type u64_ = __u64;
pub const false_: _bindgen_ty_1 = 0;
pub const true_: _bindgen_ty_1 = 1;
pub type _bindgen_ty_1 = core::ffi::c_uint;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [core::ffi::c_ulong; 16usize],
}
pub type __kernel_sighandler_t =
    ::core::option::Option<unsafe extern "C" fn(arg1: core::ffi::c_int)>;
pub type __kernel_key_t = core::ffi::c_int;
pub type __kernel_mqd_t = core::ffi::c_int;
pub type __kernel_old_uid_t = core::ffi::c_ushort;
pub type __kernel_old_gid_t = core::ffi::c_ushort;
pub type __kernel_old_dev_t = core::ffi::c_ulong;
pub type __kernel_long_t = core::ffi::c_long;
pub type __kernel_ulong_t = core::ffi::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = core::ffi::c_uint;
pub type __kernel_pid_t = core::ffi::c_int;
pub type __kernel_ipc_pid_t = core::ffi::c_int;
pub type __kernel_uid_t = core::ffi::c_uint;
pub type __kernel_gid_t = core::ffi::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = core::ffi::c_int;
pub type __kernel_uid32_t = core::ffi::c_uint;
pub type __kernel_gid32_t = core::ffi::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [core::ffi::c_int; 2usize],
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = core::ffi::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time64_t = core::ffi::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = core::ffi::c_int;
pub type __kernel_clockid_t = core::ffi::c_int;
pub type __kernel_caddr_t = *mut core::ffi::c_char;
pub type __kernel_uid16_t = core::ffi::c_ushort;
pub type __kernel_gid16_t = core::ffi::c_ushort;
pub type __s128 = i128;
pub type __u128 = u128;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = core::ffi::c_uint;
pub type s128 = __s128;
pub type u128_ = __u128;
pub type __kernel_dev_t = u32_;
pub type fd_set = __kernel_fd_set;
pub type dev_t = __kernel_dev_t;
pub type ino_t = __kernel_ulong_t;
pub type mode_t = __kernel_mode_t;
pub type umode_t = core::ffi::c_ushort;
pub type nlink_t = u32_;
pub type off_t = __kernel_off_t;
pub type pid_t = __kernel_pid_t;
pub type daddr_t = __kernel_daddr_t;
pub type key_t = __kernel_key_t;
pub type suseconds_t = __kernel_suseconds_t;
pub type timer_t = __kernel_timer_t;
pub type clockid_t = __kernel_clockid_t;
pub type mqd_t = __kernel_mqd_t;
pub type bool_ = bool;
pub type uid_t = __kernel_uid32_t;
pub type gid_t = __kernel_gid32_t;
pub type uid16_t = __kernel_uid16_t;
pub type gid16_t = __kernel_gid16_t;
pub type old_uid_t = __kernel_old_uid_t;
pub type old_gid_t = __kernel_old_gid_t;
pub type loff_t = __kernel_loff_t;
pub type clock_t = __kernel_clock_t;
pub type caddr_t = __kernel_caddr_t;
pub type u_char = core::ffi::c_uchar;
pub type u_short = core::ffi::c_ushort;
pub type u_int = core::ffi::c_uint;
pub type u_long = core::ffi::c_ulong;
pub type unchar = core::ffi::c_uchar;
pub type ushort = core::ffi::c_ushort;
pub type uint = core::ffi::c_uint;
pub type ulong = core::ffi::c_ulong;
pub type u_int8_t = u8_;
pub type u_int16_t = u16_;
pub type u_int32_t = u32_;
pub type u_int64_t = u64_;
pub type ktime_t = s64;
pub type sector_t = u64_;
pub type blkcnt_t = u64_;
pub type dma_addr_t = u64_;
pub type gfp_t = core::ffi::c_uint;
pub type slab_flags_t = core::ffi::c_uint;
pub type fmode_t = core::ffi::c_uint;
pub type phys_addr_t = u64_;
pub type resource_size_t = phys_addr_t;
pub type irq_hw_number_t = core::ffi::c_ulong;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct atomic_t {
    pub counter: core::ffi::c_int,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct atomic64_t {
    pub counter: s64,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct rcuref_t {
    pub refcnt: atomic_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct list_head {
    pub next: *mut list_head,
    pub prev: *mut list_head,
}
impl Default for list_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hlist_head {
    pub first: *mut hlist_node,
}
impl Default for hlist_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hlist_node {
    pub next: *mut hlist_node,
    pub pprev: *mut *mut hlist_node,
}
impl Default for hlist_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct ustat {
    pub f_tfree: __kernel_daddr_t,
    pub f_tinode: core::ffi::c_ulong,
    pub f_fname: [core::ffi::c_char; 6usize],
    pub f_fpack: [core::ffi::c_char; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct callback_head {
    pub next: *mut callback_head,
    pub func: ::core::option::Option<unsafe extern "C" fn(head: *mut callback_head)>,
}
impl Default for callback_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type rcu_callback_t = ::core::option::Option<unsafe extern "C" fn(head: *mut callback_head)>;
pub type call_rcu_func_t =
    ::core::option::Option<unsafe extern "C" fn(head: *mut callback_head, func: rcu_callback_t)>;
pub type swap_r_func_t = ::core::option::Option<
    unsafe extern "C" fn(
        a: *mut core::ffi::c_void,
        b: *mut core::ffi::c_void,
        size: core::ffi::c_int,
        priv_: *const core::ffi::c_void,
    ),
>;
pub type swap_func_t = ::core::option::Option<
    unsafe extern "C" fn(
        a: *mut core::ffi::c_void,
        b: *mut core::ffi::c_void,
        size: core::ffi::c_int,
    ),
>;
pub type cmp_r_func_t = ::core::option::Option<
    unsafe extern "C" fn(
        a: *const core::ffi::c_void,
        b: *const core::ffi::c_void,
        priv_: *const core::ffi::c_void,
    ) -> core::ffi::c_int,
>;
pub type cmp_func_t = ::core::option::Option<
    unsafe extern "C" fn(
        a: *const core::ffi::c_void,
        b: *const core::ffi::c_void,
    ) -> core::ffi::c_int,
>;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kcsan_scoped_access {}
pub type va_list = __builtin_va_list;
pub type initcall_t = ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_int>;
pub type exitcall_t = ::core::option::Option<unsafe extern "C" fn()>;
pub type initcall_entry_t = core::ffi::c_int;
extern "C" {
    pub static mut __con_initcall_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __con_initcall_end: [initcall_entry_t; 0usize];
}
pub type ctor_fn_t = ::core::option::Option<unsafe extern "C" fn()>;
extern "C" {
    pub fn do_one_initcall(fn_: initcall_t) -> core::ffi::c_int;
}
extern "C" {
    pub static mut boot_command_line: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static mut saved_command_line: *mut core::ffi::c_char;
}
extern "C" {
    pub static mut saved_command_line_len: core::ffi::c_uint;
}
extern "C" {
    pub static mut reset_devices: core::ffi::c_uint;
}
extern "C" {
    pub fn setup_arch(arg1: *mut *mut core::ffi::c_char);
}
extern "C" {
    pub fn prepare_namespace();
}
extern "C" {
    pub fn init_rootfs();
}
extern "C" {
    pub fn init_IRQ();
}
extern "C" {
    pub fn time_init();
}
extern "C" {
    pub fn poking_init();
}
extern "C" {
    pub fn pgtable_cache_init();
}
extern "C" {
    pub static mut __initcall_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall0_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall1_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall2_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall3_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall4_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall5_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall6_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall7_start: [initcall_entry_t; 0usize];
}
extern "C" {
    pub static mut __initcall_end: [initcall_entry_t; 0usize];
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct file_system_type {
    pub name: *const core::ffi::c_char,
    pub fs_flags: core::ffi::c_int,
    pub init_fs_context:
        ::core::option::Option<unsafe extern "C" fn(arg1: *mut fs_context) -> core::ffi::c_int>,
    pub parameters: *const fs_parameter_spec,
    pub mount: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file_system_type,
            arg2: core::ffi::c_int,
            arg3: *const core::ffi::c_char,
            arg4: *mut core::ffi::c_void,
        ) -> *mut dentry,
    >,
    pub kill_sb: ::core::option::Option<unsafe extern "C" fn(arg1: *mut super_block)>,
    pub owner: *mut module,
    pub next: *mut file_system_type,
    pub fs_supers: hlist_head,
    pub s_lock_key: lock_class_key,
    pub s_umount_key: lock_class_key,
    pub s_vfs_rename_key: lock_class_key,
    pub s_writers_key: [lock_class_key; 3usize],
    pub i_lock_key: lock_class_key,
    pub i_mutex_key: lock_class_key,
    pub invalidate_lock_key: lock_class_key,
    pub i_mutex_dir_key: lock_class_key,
}
impl Default for file_system_type {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut rootfs_fs_type: file_system_type;
}
extern "C" {
    pub static mut rodata_enabled: bool_;
}
extern "C" {
    pub fn mark_rodata_ro();
}
extern "C" {
    pub static mut late_time_init: ::core::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub static mut initcall_debug: bool_;
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct module {
    pub state: module_state,
    pub list: list_head,
    pub name: [core::ffi::c_char; 56usize],
    pub mkobj: module_kobject,
    pub modinfo_attrs: *mut module_attribute,
    pub version: *const core::ffi::c_char,
    pub srcversion: *const core::ffi::c_char,
    pub holders_dir: *mut kobject,
    pub syms: *mut kernel_symbol,
    pub crcs: *const s32,
    pub num_syms: core::ffi::c_uint,
    pub param_lock: mutex,
    pub kp: *mut kernel_param,
    pub num_kp: core::ffi::c_uint,
    pub num_gpl_syms: core::ffi::c_uint,
    pub gpl_syms: *const kernel_symbol,
    pub gpl_crcs: *const s32,
    pub using_gplonly_symbols: bool_,
    pub sig_ok: bool_,
    pub async_probe_requested: bool_,
    pub num_exentries: core::ffi::c_uint,
    pub extable: *mut exception_table_entry,
    pub init: ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_int>,
    pub mem: [module_memory; 7usize],
    pub arch: mod_arch_specific,
    pub taints: core::ffi::c_ulong,
    pub num_bugs: core::ffi::c_uint,
    pub bug_list: list_head,
    pub bug_table: *mut bug_entry,
    pub kallsyms: *mut mod_kallsyms,
    pub core_kallsyms: mod_kallsyms,
    pub sect_attrs: *mut module_sect_attrs,
    pub notes_attrs: *mut module_notes_attrs,
    pub args: *mut core::ffi::c_char,
    pub percpu: *mut core::ffi::c_void,
    pub percpu_size: core::ffi::c_uint,
    pub noinstr_text_start: *mut core::ffi::c_void,
    pub noinstr_text_size: core::ffi::c_uint,
    pub num_tracepoints: core::ffi::c_uint,
    pub tracepoints_ptrs: *const core::ffi::c_int,
    pub num_srcu_structs: core::ffi::c_uint,
    pub srcu_struct_ptrs: *mut *mut srcu_struct,
    pub num_bpf_raw_events: core::ffi::c_uint,
    pub bpf_raw_events: *mut bpf_raw_event_map,
    pub btf_data_size: core::ffi::c_uint,
    pub btf_data: *mut core::ffi::c_void,
    pub jump_entries: *mut jump_entry,
    pub num_jump_entries: core::ffi::c_uint,
    pub num_trace_bprintk_fmt: core::ffi::c_uint,
    pub trace_bprintk_fmt_start: *mut *const core::ffi::c_char,
    pub trace_events: *mut *mut trace_event_call,
    pub num_trace_events: core::ffi::c_uint,
    pub trace_evals: *mut *mut trace_eval_map,
    pub num_trace_evals: core::ffi::c_uint,
    pub num_ftrace_callsites: core::ffi::c_uint,
    pub ftrace_callsites: *mut core::ffi::c_ulong,
    pub kprobes_text_start: *mut core::ffi::c_void,
    pub kprobes_text_size: core::ffi::c_uint,
    pub kprobe_blacklist: *mut core::ffi::c_ulong,
    pub num_kprobe_blacklist: core::ffi::c_uint,
    pub num_static_call_sites: core::ffi::c_int,
    pub static_call_sites: *mut static_call_site,
    pub klp: bool_,
    pub klp_alive: bool_,
    pub klp_info: *mut klp_modinfo,
    pub source_list: list_head,
    pub target_list: list_head,
    pub exit: ::core::option::Option<unsafe extern "C" fn()>,
    pub refcnt: atomic_t,
    pub ei_funcs: *mut error_injection_entry,
    pub num_ei_funcs: core::ffi::c_uint,
    pub dyndbg_info: _ddebug_info,
}
impl Default for module {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut __this_module: module;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct qspinlock {
    pub __bindgen_anon_1: qspinlock__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union qspinlock__bindgen_ty_1 {
    pub val: atomic_t,
    pub __bindgen_anon_1: qspinlock__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: qspinlock__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct qspinlock__bindgen_ty_1__bindgen_ty_1 {
    pub locked: u8_,
    pub pending: u8_,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct qspinlock__bindgen_ty_1__bindgen_ty_2 {
    pub locked_pending: u16_,
    pub tail: u16_,
}
impl Default for qspinlock__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for qspinlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type arch_spinlock_t = qspinlock;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct qrwlock {
    pub __bindgen_anon_1: qrwlock__bindgen_ty_1,
    pub wait_lock: arch_spinlock_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union qrwlock__bindgen_ty_1 {
    pub cnts: atomic_t,
    pub __bindgen_anon_1: qrwlock__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct qrwlock__bindgen_ty_1__bindgen_ty_1 {
    pub wlocked: u8_,
    pub __lstate: [u8_; 3usize],
}
impl Default for qrwlock__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for qrwlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type arch_rwlock_t = qrwlock;
pub const lockdep_wait_type_LD_WAIT_INV: lockdep_wait_type = 0;
pub const lockdep_wait_type_LD_WAIT_FREE: lockdep_wait_type = 1;
pub const lockdep_wait_type_LD_WAIT_SPIN: lockdep_wait_type = 2;
pub const lockdep_wait_type_LD_WAIT_CONFIG: lockdep_wait_type = 2;
pub const lockdep_wait_type_LD_WAIT_SLEEP: lockdep_wait_type = 3;
pub const lockdep_wait_type_LD_WAIT_MAX: lockdep_wait_type = 4;
pub type lockdep_wait_type = core::ffi::c_uint;
pub const lockdep_lock_type_LD_LOCK_NORMAL: lockdep_lock_type = 0;
pub const lockdep_lock_type_LD_LOCK_PERCPU: lockdep_lock_type = 1;
pub const lockdep_lock_type_LD_LOCK_WAIT_OVERRIDE: lockdep_lock_type = 2;
pub const lockdep_lock_type_LD_LOCK_MAX: lockdep_lock_type = 3;
pub type lockdep_lock_type = core::ffi::c_uint;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct lock_class_key {}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct lockdep_map {}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pin_cookie {}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct raw_spinlock {
    pub raw_lock: arch_spinlock_t,
}
impl Default for raw_spinlock {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type raw_spinlock_t = raw_spinlock;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ratelimit_state {
    pub lock: raw_spinlock_t,
    pub interval: core::ffi::c_int,
    pub burst: core::ffi::c_int,
    pub printed: core::ffi::c_int,
    pub missed: core::ffi::c_int,
    pub begin: core::ffi::c_ulong,
    pub flags: core::ffi::c_ulong,
}
impl Default for ratelimit_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn ___ratelimit(
        rs: *mut ratelimit_state,
        func: *const core::ffi::c_char,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub static linux_banner: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static linux_proc_banner: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static mut oops_in_progress: core::ffi::c_int;
}
extern "C" {
    pub static mut console_printk: [core::ffi::c_int; 0usize];
}
extern "C" {
    pub fn console_verbose();
}
extern "C" {
    pub static mut devkmsg_log_str: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static mut suppress_printk: core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct va_format {
    pub fmt: *const core::ffi::c_char,
    pub va: *mut va_list,
}
impl Default for va_format {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn early_printk(fmt: *const core::ffi::c_char, ...);
}
extern "C" {
    pub fn vprintk_emit(
        facility: core::ffi::c_int,
        level: core::ffi::c_int,
        dev_info: *const dev_printk_info,
        fmt: *const core::ffi::c_char,
        args: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn vprintk(fmt: *const core::ffi::c_char, args: *mut __va_list_tag) -> core::ffi::c_int;
}
extern "C" {
    pub fn _printk(fmt: *const core::ffi::c_char, ...) -> core::ffi::c_int;
}
extern "C" {
    pub fn _printk_deferred(fmt: *const core::ffi::c_char, ...) -> core::ffi::c_int;
}
extern "C" {
    pub fn __printk_safe_enter();
}
extern "C" {
    pub fn __printk_safe_exit();
}
extern "C" {
    pub fn __printk_ratelimit(func: *const core::ffi::c_char) -> core::ffi::c_int;
}
extern "C" {
    pub fn printk_timed_ratelimit(
        caller_jiffies: *mut core::ffi::c_ulong,
        interval_msec: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub static mut printk_delay_msec: core::ffi::c_int;
}
extern "C" {
    pub static mut dmesg_restrict: core::ffi::c_int;
}
extern "C" {
    pub fn wake_up_klogd();
}
extern "C" {
    pub fn log_buf_addr_get() -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn log_buf_len_get() -> u32_;
}
extern "C" {
    pub fn log_buf_vmcoreinfo_setup();
}
extern "C" {
    pub fn setup_log_buf(early: core::ffi::c_int);
}
extern "C" {
    pub fn dump_stack_set_arch_desc(fmt: *const core::ffi::c_char, ...);
}
extern "C" {
    pub fn dump_stack_print_info(log_lvl: *const core::ffi::c_char);
}
extern "C" {
    pub fn show_regs_print_info(log_lvl: *const core::ffi::c_char);
}
extern "C" {
    pub fn dump_stack_lvl(log_lvl: *const core::ffi::c_char);
}
extern "C" {
    pub fn dump_stack();
}
extern "C" {
    pub fn printk_trigger_flush();
}
extern "C" {
    pub fn this_cpu_in_panic() -> bool_;
}
extern "C" {
    pub fn __printk_cpu_sync_try_get() -> core::ffi::c_int;
}
extern "C" {
    pub fn __printk_cpu_sync_wait();
}
extern "C" {
    pub fn __printk_cpu_sync_put();
}
extern "C" {
    pub static mut kptr_restrict: core::ffi::c_int;
}
extern "C" {
    pub static mut static_key_initialized: bool_;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct static_key {
    pub enabled: atomic_t,
    pub __bindgen_anon_1: static_key__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union static_key__bindgen_ty_1 {
    pub type_: core::ffi::c_ulong,
    pub entries: *mut jump_entry,
    pub next: *mut static_key_mod,
}
impl Default for static_key__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for static_key {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}rsp"]
    pub static mut current_stack_pointer: core::ffi::c_ulong;
}
extern "C" {
    pub static x86_nops: [*const core::ffi::c_uchar; 0usize];
}
extern "C" {
    pub fn arch_jump_entry_size(entry: *mut jump_entry) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct jump_entry {
    pub code: s32,
    pub target: s32,
    pub key: core::ffi::c_long,
}
pub const jump_label_type_JUMP_LABEL_NOP: jump_label_type = 0;
pub const jump_label_type_JUMP_LABEL_JMP: jump_label_type = 1;
pub type jump_label_type = core::ffi::c_uint;
extern "C" {
    pub static mut __start___jump_table: [jump_entry; 0usize];
}
extern "C" {
    pub static mut __stop___jump_table: [jump_entry; 0usize];
}
extern "C" {
    pub fn jump_label_init();
}
extern "C" {
    pub fn jump_label_lock();
}
extern "C" {
    pub fn jump_label_unlock();
}
extern "C" {
    pub fn arch_jump_label_transform(entry: *mut jump_entry, type_: jump_label_type);
}
extern "C" {
    pub fn arch_jump_label_transform_queue(entry: *mut jump_entry, type_: jump_label_type)
        -> bool_;
}
extern "C" {
    pub fn arch_jump_label_transform_apply();
}
extern "C" {
    pub fn jump_label_text_reserved(
        start: *mut core::ffi::c_void,
        end: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn static_key_slow_inc(key: *mut static_key) -> bool_;
}
extern "C" {
    pub fn static_key_fast_inc_not_disabled(key: *mut static_key) -> bool_;
}
extern "C" {
    pub fn static_key_slow_dec(key: *mut static_key);
}
extern "C" {
    pub fn static_key_slow_inc_cpuslocked(key: *mut static_key) -> bool_;
}
extern "C" {
    pub fn static_key_slow_dec_cpuslocked(key: *mut static_key);
}
extern "C" {
    pub fn static_key_count(key: *mut static_key) -> core::ffi::c_int;
}
extern "C" {
    pub fn static_key_enable(key: *mut static_key);
}
extern "C" {
    pub fn static_key_disable(key: *mut static_key);
}
extern "C" {
    pub fn static_key_enable_cpuslocked(key: *mut static_key);
}
extern "C" {
    pub fn static_key_disable_cpuslocked(key: *mut static_key);
}
extern "C" {
    pub fn jump_label_init_type(entry: *mut jump_entry) -> jump_label_type;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct static_key_true {
    pub key: static_key,
}
impl Default for static_key_true {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct static_key_false {
    pub key: static_key,
}
impl Default for static_key_false {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn ____wrong_branch_error() -> bool_;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ddebug {
    pub modname: *const core::ffi::c_char,
    pub function: *const core::ffi::c_char,
    pub filename: *const core::ffi::c_char,
    pub format: *const core::ffi::c_char,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub key: _ddebug__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _ddebug__bindgen_ty_1 {
    pub dd_key_true: static_key_true,
    pub dd_key_false: static_key_false,
}
impl Default for _ddebug__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for _ddebug {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl _ddebug {
    #[inline]
    pub fn lineno(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 18u8) as u32) }
    }
    #[inline]
    pub fn set_lineno(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 18u8, val as u64)
        }
    }
    #[inline]
    pub fn class_id(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_class_id(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lineno: core::ffi::c_uint,
        class_id: core::ffi::c_uint,
        flags: core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 18u8, {
            let lineno: u32 = unsafe { ::core::mem::transmute(lineno) };
            lineno as u64
        });
        __bindgen_bitfield_unit.set(18usize, 6u8, {
            let class_id: u32 = unsafe { ::core::mem::transmute(class_id) };
            class_id as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let flags: u32 = unsafe { ::core::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const class_map_type_DD_CLASS_TYPE_DISJOINT_BITS: class_map_type = 0;
pub const class_map_type_DD_CLASS_TYPE_LEVEL_NUM: class_map_type = 1;
pub const class_map_type_DD_CLASS_TYPE_DISJOINT_NAMES: class_map_type = 2;
pub const class_map_type_DD_CLASS_TYPE_LEVEL_NAMES: class_map_type = 3;
pub type class_map_type = core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ddebug_class_map {
    pub link: list_head,
    pub mod_: *mut module,
    pub mod_name: *const core::ffi::c_char,
    pub class_names: *mut *const core::ffi::c_char,
    pub length: core::ffi::c_int,
    pub base: core::ffi::c_int,
    pub map_type: class_map_type,
}
impl Default for ddebug_class_map {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ddebug_info {
    pub descs: *mut _ddebug,
    pub classes: *mut ddebug_class_map,
    pub num_descs: core::ffi::c_uint,
    pub num_classes: core::ffi::c_uint,
}
impl Default for _ddebug_info {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ddebug_class_param {
    pub __bindgen_anon_1: ddebug_class_param__bindgen_ty_1,
    pub flags: [core::ffi::c_char; 8usize],
    pub map: *const ddebug_class_map,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ddebug_class_param__bindgen_ty_1 {
    pub bits: *mut core::ffi::c_ulong,
    pub lvl: *mut core::ffi::c_uint,
}
impl Default for ddebug_class_param__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for ddebug_class_param {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn __dynamic_pr_debug(descriptor: *mut _ddebug, fmt: *const core::ffi::c_char, ...);
}
extern "C" {
    pub fn __dynamic_dev_dbg(
        descriptor: *mut _ddebug,
        dev: *const device,
        fmt: *const core::ffi::c_char,
        ...
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct net_device {
    _unused: [u8; 0],
}
extern "C" {
    pub fn __dynamic_netdev_dbg(
        descriptor: *mut _ddebug,
        dev: *const net_device,
        fmt: *const core::ffi::c_char,
        ...
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ib_device {
    _unused: [u8; 0],
}
extern "C" {
    pub fn __dynamic_ibdev_dbg(
        descriptor: *mut _ddebug,
        ibdev: *const ib_device,
        fmt: *const core::ffi::c_char,
        ...
    );
}
extern "C" {
    pub fn ddebug_dyndbg_module_param_cb(
        param: *mut core::ffi::c_char,
        val: *mut core::ffi::c_char,
        modname: *const core::ffi::c_char,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn param_set_dyndbg_classes(
        instr: *const core::ffi::c_char,
        kp: *const kernel_param,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn param_get_dyndbg_classes(
        buffer: *mut core::ffi::c_char,
        kp: *const kernel_param,
    ) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kernel_param_ops {
    pub flags: core::ffi::c_uint,
    pub set: ::core::option::Option<
        unsafe extern "C" fn(
            val: *const core::ffi::c_char,
            kp: *const kernel_param,
        ) -> core::ffi::c_int,
    >,
    pub get: ::core::option::Option<
        unsafe extern "C" fn(
            buffer: *mut core::ffi::c_char,
            kp: *const kernel_param,
        ) -> core::ffi::c_int,
    >,
    pub free: ::core::option::Option<unsafe extern "C" fn(arg: *mut core::ffi::c_void)>,
}
extern "C" {
    pub static param_ops_dyndbg_classes: kernel_param_ops;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct file_operations {
    pub owner: *mut module,
    pub llseek: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut file, arg2: loff_t, arg3: core::ffi::c_int) -> loff_t,
    >,
    pub read: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: *mut core::ffi::c_char,
            arg3: usize,
            arg4: *mut loff_t,
        ) -> isize,
    >,
    pub write: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: *const core::ffi::c_char,
            arg3: usize,
            arg4: *mut loff_t,
        ) -> isize,
    >,
    pub read_iter: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut kiocb, arg2: *mut iov_iter) -> isize,
    >,
    pub write_iter: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut kiocb, arg2: *mut iov_iter) -> isize,
    >,
    pub iopoll: ::core::option::Option<
        unsafe extern "C" fn(
            kiocb: *mut kiocb,
            arg1: *mut io_comp_batch,
            flags: core::ffi::c_uint,
        ) -> core::ffi::c_int,
    >,
    pub iterate_shared: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut file, arg2: *mut dir_context) -> core::ffi::c_int,
    >,
    pub poll: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut file, arg2: *mut poll_table_struct) -> __poll_t,
    >,
    pub unlocked_ioctl: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: core::ffi::c_uint,
            arg3: core::ffi::c_ulong,
        ) -> core::ffi::c_long,
    >,
    pub compat_ioctl: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: core::ffi::c_uint,
            arg3: core::ffi::c_ulong,
        ) -> core::ffi::c_long,
    >,
    pub mmap: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut file, arg2: *mut vm_area_struct) -> core::ffi::c_int,
    >,
    pub mmap_supported_flags: core::ffi::c_ulong,
    pub open: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut inode, arg2: *mut file) -> core::ffi::c_int,
    >,
    pub flush: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut file, id: fl_owner_t) -> core::ffi::c_int,
    >,
    pub release: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut inode, arg2: *mut file) -> core::ffi::c_int,
    >,
    pub fsync: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: loff_t,
            arg3: loff_t,
            datasync: core::ffi::c_int,
        ) -> core::ffi::c_int,
    >,
    pub fasync: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: core::ffi::c_int,
            arg2: *mut file,
            arg3: core::ffi::c_int,
        ) -> core::ffi::c_int,
    >,
    pub lock: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: core::ffi::c_int,
            arg3: *mut file_lock,
        ) -> core::ffi::c_int,
    >,
    pub get_unmapped_area: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: core::ffi::c_ulong,
            arg3: core::ffi::c_ulong,
            arg4: core::ffi::c_ulong,
            arg5: core::ffi::c_ulong,
        ) -> core::ffi::c_ulong,
    >,
    pub check_flags:
        ::core::option::Option<unsafe extern "C" fn(arg1: core::ffi::c_int) -> core::ffi::c_int>,
    pub flock: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: core::ffi::c_int,
            arg3: *mut file_lock,
        ) -> core::ffi::c_int,
    >,
    pub splice_write: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_inode_info,
            arg2: *mut file,
            arg3: *mut loff_t,
            arg4: usize,
            arg5: core::ffi::c_uint,
        ) -> isize,
    >,
    pub splice_read: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: *mut loff_t,
            arg3: *mut pipe_inode_info,
            arg4: usize,
            arg5: core::ffi::c_uint,
        ) -> isize,
    >,
    pub splice_eof: ::core::option::Option<unsafe extern "C" fn(file: *mut file)>,
    pub setlease: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: core::ffi::c_int,
            arg3: *mut *mut file_lock,
            arg4: *mut *mut core::ffi::c_void,
        ) -> core::ffi::c_int,
    >,
    pub fallocate: ::core::option::Option<
        unsafe extern "C" fn(
            file: *mut file,
            mode: core::ffi::c_int,
            offset: loff_t,
            len: loff_t,
        ) -> core::ffi::c_long,
    >,
    pub show_fdinfo: ::core::option::Option<unsafe extern "C" fn(m: *mut seq_file, f: *mut file)>,
    pub copy_file_range: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: loff_t,
            arg3: *mut file,
            arg4: loff_t,
            arg5: usize,
            arg6: core::ffi::c_uint,
        ) -> isize,
    >,
    pub remap_file_range: ::core::option::Option<
        unsafe extern "C" fn(
            file_in: *mut file,
            pos_in: loff_t,
            file_out: *mut file,
            pos_out: loff_t,
            len: loff_t,
            remap_flags: core::ffi::c_uint,
        ) -> loff_t,
    >,
    pub fadvise: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut file,
            arg2: loff_t,
            arg3: loff_t,
            arg4: core::ffi::c_int,
        ) -> core::ffi::c_int,
    >,
    pub uring_cmd: ::core::option::Option<
        unsafe extern "C" fn(
            ioucmd: *mut io_uring_cmd,
            issue_flags: core::ffi::c_uint,
        ) -> core::ffi::c_int,
    >,
    pub uring_cmd_iopoll: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut io_uring_cmd,
            arg2: *mut io_comp_batch,
            poll_flags: core::ffi::c_uint,
        ) -> core::ffi::c_int,
    >,
}
impl Default for file_operations {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static kmsg_fops: file_operations;
}
pub const DUMP_PREFIX_NONE: _bindgen_ty_2 = 0;
pub const DUMP_PREFIX_ADDRESS: _bindgen_ty_2 = 1;
pub const DUMP_PREFIX_OFFSET: _bindgen_ty_2 = 2;
pub type _bindgen_ty_2 = core::ffi::c_uint;
extern "C" {
    pub fn hex_dump_to_buffer(
        buf: *const core::ffi::c_void,
        len: usize,
        rowsize: core::ffi::c_int,
        groupsize: core::ffi::c_int,
        linebuf: *mut core::ffi::c_char,
        linebuflen: usize,
        ascii: bool_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn print_hex_dump(
        level: *const core::ffi::c_char,
        prefix_str: *const core::ffi::c_char,
        prefix_type: core::ffi::c_int,
        rowsize: core::ffi::c_int,
        groupsize: core::ffi::c_int,
        buf: *const core::ffi::c_void,
        len: usize,
        ascii: bool_,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct string_stream {
    _unused: [u8; 0],
}
pub const kunit_assert_type_KUNIT_ASSERTION: kunit_assert_type = 0;
pub const kunit_assert_type_KUNIT_EXPECTATION: kunit_assert_type = 1;
pub type kunit_assert_type = core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_loc {
    pub line: core::ffi::c_int,
    pub file: *const core::ffi::c_char,
}
impl Default for kunit_loc {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kunit_assert {}
pub type assert_format_t = ::core::option::Option<
    unsafe extern "C" fn(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    ),
>;
extern "C" {
    pub fn kunit_assert_prologue(
        loc: *const kunit_loc,
        type_: kunit_assert_type,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kunit_fail_assert {
    pub assert: kunit_assert,
}
extern "C" {
    pub fn kunit_fail_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_unary_assert {
    pub assert: kunit_assert,
    pub condition: *const core::ffi::c_char,
    pub expected_true: bool_,
}
impl Default for kunit_unary_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn kunit_unary_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_ptr_not_err_assert {
    pub assert: kunit_assert,
    pub text: *const core::ffi::c_char,
    pub value: *const core::ffi::c_void,
}
impl Default for kunit_ptr_not_err_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn kunit_ptr_not_err_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_binary_assert_text {
    pub operation: *const core::ffi::c_char,
    pub left_text: *const core::ffi::c_char,
    pub right_text: *const core::ffi::c_char,
}
impl Default for kunit_binary_assert_text {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_binary_assert {
    pub assert: kunit_assert,
    pub text: *const kunit_binary_assert_text,
    pub left_value: core::ffi::c_longlong,
    pub right_value: core::ffi::c_longlong,
}
impl Default for kunit_binary_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn kunit_binary_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_binary_ptr_assert {
    pub assert: kunit_assert,
    pub text: *const kunit_binary_assert_text,
    pub left_value: *const core::ffi::c_void,
    pub right_value: *const core::ffi::c_void,
}
impl Default for kunit_binary_ptr_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn kunit_binary_ptr_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_binary_str_assert {
    pub assert: kunit_assert,
    pub text: *const kunit_binary_assert_text,
    pub left_value: *const core::ffi::c_char,
    pub right_value: *const core::ffi::c_char,
}
impl Default for kunit_binary_str_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn kunit_binary_str_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kunit_mem_assert {
    pub assert: kunit_assert,
    pub text: *const kunit_binary_assert_text,
    pub left_value: *const core::ffi::c_void,
    pub right_value: *const core::ffi::c_void,
    pub size: usize,
}
impl Default for kunit_mem_assert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn kunit_mem_assert_format(
        assert: *const kunit_assert,
        message: *const va_format,
        stream: *mut string_stream,
    );
}
pub type kunit_try_catch_func_t =
    ::core::option::Option<unsafe extern "C" fn(arg1: *mut core::ffi::c_void)>;
#[repr(C)]
#[repr(align(8))]
#[derive(Default, Copy, Clone)]
pub struct kunit_try_catch {
    pub _bindgen_opaque_blob: [u64; 6usize],
}
extern "C" {
    pub fn kunit_try_catch_run(try_catch: *mut kunit_try_catch, context: *mut core::ffi::c_void);
}
extern "C" {
    pub fn kunit_try_catch_throw(try_catch: *mut kunit_try_catch) -> !;
}
extern "C" {
    pub fn __bad_size_call_parameter();
}
extern "C" {
    pub static mut __per_cpu_offset: [core::ffi::c_ulong; 8192usize];
}
extern "C" {
    pub fn setup_per_cpu_areas();
}
extern "C" {
    pub static mut this_cpu_off: core::ffi::c_ulong;
}
#[repr(C)]
#[derive(Default)]
pub struct sysinfo {
    pub uptime: __kernel_long_t,
    pub loads: [__kernel_ulong_t; 3usize],
    pub totalram: __kernel_ulong_t,
    pub freeram: __kernel_ulong_t,
    pub sharedram: __kernel_ulong_t,
    pub bufferram: __kernel_ulong_t,
    pub totalswap: __kernel_ulong_t,
    pub freeswap: __kernel_ulong_t,
    pub procs: __u16,
    pub pad: __u16,
    pub totalhigh: __kernel_ulong_t,
    pub freehigh: __kernel_ulong_t,
    pub mem_unit: __u32,
    pub _f: __IncompleteArrayField<core::ffi::c_char>,
}
#[repr(C)]
#[repr(align(64))]
pub struct cacheline_padding {
    pub x: __IncompleteArrayField<core::ffi::c_char>,
}
impl Default for cacheline_padding {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pcpu_hot {
    pub __bindgen_anon_1: pcpu_hot__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pcpu_hot__bindgen_ty_1 {
    pub __bindgen_anon_1: pcpu_hot__bindgen_ty_1__bindgen_ty_1,
    pub pad: [u8_; 64usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pcpu_hot__bindgen_ty_1__bindgen_ty_1 {
    pub current_task: *mut task_struct,
    pub preempt_count: core::ffi::c_int,
    pub cpu_number: core::ffi::c_int,
    pub call_depth: u64_,
    pub top_of_stack: core::ffi::c_ulong,
    pub hardirq_stack_ptr: *mut core::ffi::c_void,
    pub softirq_pending: u16_,
    pub hardirq_stack_inuse: bool_,
}
impl Default for pcpu_hot__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for pcpu_hot__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for pcpu_hot {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut pcpu_hot: pcpu_hot;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct static_call_site {
    pub addr: s32,
    pub key: s32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct static_call_key {
    pub func: *mut core::ffi::c_void,
    pub __bindgen_anon_1: static_call_key__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union static_call_key__bindgen_ty_1 {
    pub type_: core::ffi::c_ulong,
    pub mods: *mut static_call_mod,
    pub sites: *mut static_call_site,
}
impl Default for static_call_key__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for static_call_key {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn preempt_schedule();
}
extern "C" {
    pub fn preempt_schedule_thunk();
}
extern "C" {
    pub fn preempt_schedule_notrace();
}
extern "C" {
    pub fn preempt_schedule_notrace_thunk();
}
extern "C" {
    pub static mut __SCK__preempt_schedule: static_call_key;
}
extern "C" {
    pub fn __SCT__preempt_schedule();
}
extern "C" {
    pub static mut __SCK__preempt_schedule_notrace: static_call_key;
}
extern "C" {
    pub fn __SCT__preempt_schedule_notrace();
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct preempt_ops {
    pub sched_in: ::core::option::Option<
        unsafe extern "C" fn(notifier: *mut preempt_notifier, cpu: core::ffi::c_int),
    >,
    pub sched_out: ::core::option::Option<
        unsafe extern "C" fn(notifier: *mut preempt_notifier, next: *mut task_struct),
    >,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct preempt_notifier {
    pub link: hlist_node,
    pub ops: *mut preempt_ops,
}
impl Default for preempt_notifier {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn preempt_notifier_inc();
}
extern "C" {
    pub fn preempt_notifier_dec();
}
extern "C" {
    pub fn preempt_notifier_register(notifier: *mut preempt_notifier);
}
extern "C" {
    pub fn preempt_notifier_unregister(notifier: *mut preempt_notifier);
}
extern "C" {
    pub fn migrate_disable();
}
extern "C" {
    pub fn migrate_enable();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_preempt_t {
    pub lock: *mut core::ffi::c_void,
}
impl Default for class_preempt_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_preempt_notrace_t {
    pub lock: *mut core::ffi::c_void,
}
impl Default for class_preempt_notrace_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_migrate_t {
    pub lock: *mut core::ffi::c_void,
}
impl Default for class_migrate_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn preempt_model_none() -> bool_;
}
extern "C" {
    pub fn preempt_model_voluntary() -> bool_;
}
extern "C" {
    pub fn preempt_model_full() -> bool_;
}
pub const cc_attr_CC_ATTR_MEM_ENCRYPT: cc_attr = 0;
pub const cc_attr_CC_ATTR_HOST_MEM_ENCRYPT: cc_attr = 1;
pub const cc_attr_CC_ATTR_GUEST_MEM_ENCRYPT: cc_attr = 2;
pub const cc_attr_CC_ATTR_GUEST_STATE_ENCRYPT: cc_attr = 3;
pub const cc_attr_CC_ATTR_GUEST_UNROLL_STRING_IO: cc_attr = 4;
pub const cc_attr_CC_ATTR_GUEST_SEV_SNP: cc_attr = 5;
pub const cc_attr_CC_ATTR_HOTPLUG_DISABLED: cc_attr = 6;
pub type cc_attr = core::ffi::c_uint;
extern "C" {
    pub fn cc_platform_has(attr: cc_attr) -> bool_;
}
extern "C" {
    pub fn mem_encrypt_init();
}
extern "C" {
    pub fn mem_encrypt_setup_arch();
}
extern "C" {
    pub static mut sme_me_mask: u64_;
}
extern "C" {
    pub static mut sev_status: u64_;
}
extern "C" {
    pub fn sme_encrypt_execute(
        encrypted_kernel_vaddr: core::ffi::c_ulong,
        decrypted_kernel_vaddr: core::ffi::c_ulong,
        kernel_len: core::ffi::c_ulong,
        encryption_wa: core::ffi::c_ulong,
        encryption_pgd: core::ffi::c_ulong,
    );
}
extern "C" {
    pub fn sme_early_encrypt(paddr: resource_size_t, size: core::ffi::c_ulong);
}
extern "C" {
    pub fn sme_early_decrypt(paddr: resource_size_t, size: core::ffi::c_ulong);
}
extern "C" {
    pub fn sme_map_bootdata(real_mode_data: *mut core::ffi::c_char);
}
extern "C" {
    pub fn sme_unmap_bootdata(real_mode_data: *mut core::ffi::c_char);
}
extern "C" {
    pub fn sme_early_init();
}
extern "C" {
    pub fn sme_encrypt_kernel(bp: *mut boot_params);
}
extern "C" {
    pub fn sme_enable(bp: *mut boot_params);
}
extern "C" {
    pub fn early_set_memory_decrypted(
        vaddr: core::ffi::c_ulong,
        size: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn early_set_memory_encrypted(
        vaddr: core::ffi::c_ulong,
        size: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn early_set_mem_enc_dec_hypercall(
        vaddr: core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        enc: bool_,
    );
}
extern "C" {
    pub fn mem_encrypt_free_decrypted_mem();
}
extern "C" {
    pub fn sev_es_init_vc_handling();
}
extern "C" {
    pub fn add_encrypt_protection_map();
}
extern "C" {
    pub static mut __start_bss_decrypted: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static mut __end_bss_decrypted: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static mut __start_bss_decrypted_unused: [core::ffi::c_char; 0usize];
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct unwind_hint {
    pub ip: u32_,
    pub sp_offset: s16,
    pub sp_reg: u8_,
    pub type_: u8_,
    pub signal: u8_,
}
#[repr(C)]
#[repr(align(1))]
#[derive(Default, Copy, Clone)]
pub struct alt_instr {
    pub _bindgen_opaque_blob: [u8; 14usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union alt_instr__bindgen_ty_1 {
    pub __bindgen_anon_1: alt_instr__bindgen_ty_1__bindgen_ty_1,
    pub ft_flags: u32_,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct alt_instr__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl alt_instr__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn cpuid(&self) -> u32_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cpuid(&mut self, val: u32_) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> u32_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: u32_) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(cpuid: u32_, flags: u32_) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let cpuid: u32 = unsafe { ::core::mem::transmute(cpuid) };
            cpuid as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let flags: u32 = unsafe { ::core::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for alt_instr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut __alt_instructions: [alt_instr; 0usize];
}
extern "C" {
    pub static mut __alt_instructions_end: [alt_instr; 0usize];
}
extern "C" {
    pub static mut alternatives_patched: core::ffi::c_int;
}
extern "C" {
    pub fn alternative_instructions();
}
extern "C" {
    pub fn apply_alternatives(start: *mut alt_instr, end: *mut alt_instr);
}
extern "C" {
    pub fn apply_retpolines(start: *mut s32, end: *mut s32);
}
extern "C" {
    pub fn apply_returns(start: *mut s32, end: *mut s32);
}
extern "C" {
    pub fn apply_seal_endbr(start: *mut s32, end: *mut s32);
}
extern "C" {
    pub fn apply_fineibt(
        start_retpoline: *mut s32,
        end_retpoine: *mut s32,
        start_cfi: *mut s32,
        end_cfi: *mut s32,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct callthunk_sites {
    pub call_start: *mut s32,
    pub call_end: *mut s32,
    pub alt_start: *mut alt_instr,
    pub alt_end: *mut alt_instr,
}
impl Default for callthunk_sites {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn callthunks_patch_builtin_calls();
}
extern "C" {
    pub fn callthunks_patch_module_calls(sites: *mut callthunk_sites, mod_: *mut module);
}
extern "C" {
    pub fn callthunks_translate_call_dest(dest: *mut core::ffi::c_void) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn x86_call_depth_emit_accounting(
        pprog: *mut *mut u8_,
        func: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn alternatives_smp_module_add(
        mod_: *mut module,
        name: *mut core::ffi::c_char,
        locks: *mut core::ffi::c_void,
        locks_end: *mut core::ffi::c_void,
        text: *mut core::ffi::c_void,
        text_end: *mut core::ffi::c_void,
    );
}
extern "C" {
    pub fn alternatives_smp_module_del(mod_: *mut module);
}
extern "C" {
    pub fn alternatives_enable_smp();
}
extern "C" {
    pub fn alternatives_text_reserved(
        start: *mut core::ffi::c_void,
        end: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub static mut skip_smp_alternatives: bool_;
}
extern "C" {
    pub fn BUG_func();
}
extern "C" {
    pub fn nop_func();
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct orc_entry {
    pub sp_offset: s16,
    pub bp_offset: s16,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
impl orc_entry {
    #[inline]
    pub fn sp_reg(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_sp_reg(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_reg(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_bp_reg(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn signal(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_signal(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sp_reg: core::ffi::c_uint,
        bp_reg: core::ffi::c_uint,
        type_: core::ffi::c_uint,
        signal: core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let sp_reg: u32 = unsafe { ::core::mem::transmute(sp_reg) };
            sp_reg as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let bp_reg: u32 = unsafe { ::core::mem::transmute(bp_reg) };
            bp_reg as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let signal: u32 = unsafe { ::core::mem::transmute(signal) };
            signal as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type retpoline_thunk_t = [u8_; 32usize];
extern "C" {
    pub static mut __x86_indirect_thunk_array: [retpoline_thunk_t; 0usize];
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_array: [retpoline_thunk_t; 0usize];
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_array: [retpoline_thunk_t; 0usize];
}
extern "C" {
    pub fn __x86_return_thunk();
}
extern "C" {
    pub fn retbleed_return_thunk();
}
extern "C" {
    pub fn srso_alias_untrain_ret();
}
extern "C" {
    pub fn srso_return_thunk();
}
extern "C" {
    pub fn srso_alias_return_thunk();
}
extern "C" {
    pub fn entry_untrain_ret();
}
extern "C" {
    pub fn entry_ibpb();
}
extern "C" {
    pub fn clear_bhb_loop();
}
extern "C" {
    pub static mut x86_return_thunk: ::core::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub fn call_depth_return_thunk();
}
extern "C" {
    pub static mut __x86_indirect_thunk_rax: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rcx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rdx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rbx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rsp: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rbp: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rsi: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_rdi: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r8: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r9: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r10: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r11: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r12: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r13: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r14: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_thunk_r15: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rax: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rcx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rdx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rbx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rsp: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rbp: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rsi: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_rdi: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r8: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r9: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r10: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r11: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r12: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r13: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r14: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_call_thunk_r15: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rax: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rcx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rdx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rbx: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rsp: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rbp: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rsi: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_rdi: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r8: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r9: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r10: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r11: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r12: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r13: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r14: retpoline_thunk_t;
}
extern "C" {
    pub static mut __x86_indirect_jump_thunk_r15: retpoline_thunk_t;
}
pub const spectre_v2_mitigation_SPECTRE_V2_NONE: spectre_v2_mitigation = 0;
pub const spectre_v2_mitigation_SPECTRE_V2_RETPOLINE: spectre_v2_mitigation = 1;
pub const spectre_v2_mitigation_SPECTRE_V2_LFENCE: spectre_v2_mitigation = 2;
pub const spectre_v2_mitigation_SPECTRE_V2_EIBRS: spectre_v2_mitigation = 3;
pub const spectre_v2_mitigation_SPECTRE_V2_EIBRS_RETPOLINE: spectre_v2_mitigation = 4;
pub const spectre_v2_mitigation_SPECTRE_V2_EIBRS_LFENCE: spectre_v2_mitigation = 5;
pub const spectre_v2_mitigation_SPECTRE_V2_IBRS: spectre_v2_mitigation = 6;
pub type spectre_v2_mitigation = core::ffi::c_uint;
pub const spectre_v2_user_mitigation_SPECTRE_V2_USER_NONE: spectre_v2_user_mitigation = 0;
pub const spectre_v2_user_mitigation_SPECTRE_V2_USER_STRICT: spectre_v2_user_mitigation = 1;
pub const spectre_v2_user_mitigation_SPECTRE_V2_USER_STRICT_PREFERRED: spectre_v2_user_mitigation =
    2;
pub const spectre_v2_user_mitigation_SPECTRE_V2_USER_PRCTL: spectre_v2_user_mitigation = 3;
pub const spectre_v2_user_mitigation_SPECTRE_V2_USER_SECCOMP: spectre_v2_user_mitigation = 4;
pub type spectre_v2_user_mitigation = core::ffi::c_uint;
pub const ssb_mitigation_SPEC_STORE_BYPASS_NONE: ssb_mitigation = 0;
pub const ssb_mitigation_SPEC_STORE_BYPASS_DISABLE: ssb_mitigation = 1;
pub const ssb_mitigation_SPEC_STORE_BYPASS_PRCTL: ssb_mitigation = 2;
pub const ssb_mitigation_SPEC_STORE_BYPASS_SECCOMP: ssb_mitigation = 3;
pub type ssb_mitigation = core::ffi::c_uint;
extern "C" {
    pub static mut x86_pred_cmd: u64_;
}
extern "C" {
    pub static mut x86_spec_ctrl_base: u64_;
}
extern "C" {
    pub static mut x86_spec_ctrl_current: core::ffi::c_ulonglong;
}
extern "C" {
    pub fn update_spec_ctrl_cond(val: u64_);
}
extern "C" {
    pub fn spec_ctrl_current() -> u64_;
}
extern "C" {
    pub static mut switch_to_cond_stibp: static_key_false;
}
extern "C" {
    pub static mut switch_mm_cond_ibpb: static_key_false;
}
extern "C" {
    pub static mut switch_mm_always_ibpb: static_key_false;
}
extern "C" {
    pub static mut mds_idle_clear: static_key_false;
}
extern "C" {
    pub static mut switch_mm_cond_l1d_flush: static_key_false;
}
extern "C" {
    pub static mut mmio_stale_data_clear: static_key_false;
}
extern "C" {
    pub static mut mds_verw_sel: u16_;
}
extern "C" {
    pub static mut early_idt_handler_array: [[core::ffi::c_char; 9usize]; 32usize];
}
extern "C" {
    pub fn early_ignore_irq();
}
extern "C" {
    pub static mut xen_early_idt_handler_array: [[core::ffi::c_char; 8usize]; 32usize];
}
#[repr(C)]
#[repr(align(1))]
#[derive(Default, Copy, Clone)]
pub struct desc_struct {
    pub _bindgen_opaque_blob: [u8; 8usize],
}
pub const GATE_INTERRUPT: _bindgen_ty_3 = 14;
pub const GATE_TRAP: _bindgen_ty_3 = 15;
pub const GATE_CALL: _bindgen_ty_3 = 12;
pub const GATE_TASK: _bindgen_ty_3 = 5;
pub type _bindgen_ty_3 = core::ffi::c_uint;
pub const DESC_TSS: _bindgen_ty_4 = 9;
pub const DESC_LDT: _bindgen_ty_4 = 2;
pub const DESCTYPE_S: _bindgen_ty_4 = 16;
pub type _bindgen_ty_4 = core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct ldttss_desc {
    pub limit0: u16_,
    pub base0: u16_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub base3: u32_,
    pub zero1: u32_,
}
impl ldttss_desc {
    #[inline]
    pub fn base1(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u16) }
    }
    #[inline]
    pub fn set_base1(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 5u8) as u16) }
    }
    #[inline]
    pub fn set_type(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn dpl(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_dpl(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn p(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_p(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn limit1(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 4u8) as u16) }
    }
    #[inline]
    pub fn set_limit1(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn zero0(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(20usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set_zero0(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(20usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn g(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_g(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn base2(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u16) }
    }
    #[inline]
    pub fn set_base2(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        base1: u16_,
        type_: u16_,
        dpl: u16_,
        p: u16_,
        limit1: u16_,
        zero0: u16_,
        g: u16_,
        base2: u16_,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let base1: u16 = unsafe { ::core::mem::transmute(base1) };
            base1 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 5u8, {
            let type_: u16 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(13usize, 2u8, {
            let dpl: u16 = unsafe { ::core::mem::transmute(dpl) };
            dpl as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let p: u16 = unsafe { ::core::mem::transmute(p) };
            p as u64
        });
        __bindgen_bitfield_unit.set(16usize, 4u8, {
            let limit1: u16 = unsafe { ::core::mem::transmute(limit1) };
            limit1 as u64
        });
        __bindgen_bitfield_unit.set(20usize, 3u8, {
            let zero0: u16 = unsafe { ::core::mem::transmute(zero0) };
            zero0 as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let g: u16 = unsafe { ::core::mem::transmute(g) };
            g as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let base2: u16 = unsafe { ::core::mem::transmute(base2) };
            base2 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ldt_desc = ldttss_desc;
pub type tss_desc = ldttss_desc;
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct idt_bits {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
impl idt_bits {
    #[inline]
    pub fn ist(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set_ist(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn zero(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 5u8) as u16) }
    }
    #[inline]
    pub fn set_zero(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 5u8) as u16) }
    }
    #[inline]
    pub fn set_type(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn dpl(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_dpl(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn p(&self) -> u16_ {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_p(&mut self, val: u16_) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ist: u16_,
        zero: u16_,
        type_: u16_,
        dpl: u16_,
        p: u16_,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let ist: u16 = unsafe { ::core::mem::transmute(ist) };
            ist as u64
        });
        __bindgen_bitfield_unit.set(3usize, 5u8, {
            let zero: u16 = unsafe { ::core::mem::transmute(zero) };
            zero as u64
        });
        __bindgen_bitfield_unit.set(8usize, 5u8, {
            let type_: u16 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(13usize, 2u8, {
            let dpl: u16 = unsafe { ::core::mem::transmute(dpl) };
            dpl as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let p: u16 = unsafe { ::core::mem::transmute(p) };
            p as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct idt_data {
    pub vector: core::ffi::c_uint,
    pub segment: core::ffi::c_uint,
    pub bits: idt_bits,
    pub addr: *const core::ffi::c_void,
}
impl Default for idt_data {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct gate_struct {
    pub offset_low: u16_,
    pub segment: u16_,
    pub bits: idt_bits,
    pub offset_middle: u16_,
    pub offset_high: u32_,
    pub reserved: u32_,
}
pub type gate_desc = gate_struct;
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct desc_ptr {
    pub size: core::ffi::c_ushort,
    pub address: core::ffi::c_ulong,
}
extern "C" {
    pub fn kaslr_get_random_long(purpose: *const core::ffi::c_char) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn kernel_randomize_memory();
}
extern "C" {
    pub fn init_trampoline_kaslr();
}
extern "C" {
    pub static mut physical_mask: phys_addr_t;
}
extern "C" {
    pub fn devmem_is_allowed(pagenr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub static mut max_low_pfn_mapped: core::ffi::c_ulong;
}
extern "C" {
    pub static mut max_pfn_mapped: core::ffi::c_ulong;
}
extern "C" {
    pub fn pfn_range_is_mapped(start_pfn: core::ffi::c_ulong, end_pfn: core::ffi::c_ulong)
        -> bool_;
}
extern "C" {
    pub fn initmem_init();
}
pub const page_cache_mode__PAGE_CACHE_MODE_WB: page_cache_mode = 0;
pub const page_cache_mode__PAGE_CACHE_MODE_WC: page_cache_mode = 1;
pub const page_cache_mode__PAGE_CACHE_MODE_UC_MINUS: page_cache_mode = 2;
pub const page_cache_mode__PAGE_CACHE_MODE_UC: page_cache_mode = 3;
pub const page_cache_mode__PAGE_CACHE_MODE_WT: page_cache_mode = 4;
pub const page_cache_mode__PAGE_CACHE_MODE_WP: page_cache_mode = 5;
pub const page_cache_mode__PAGE_CACHE_MODE_NUM: page_cache_mode = 8;
pub type page_cache_mode = core::ffi::c_uint;
extern "C" {
    pub fn phys_to_target_node(start: phys_addr_t) -> core::ffi::c_int;
}
extern "C" {
    pub fn memory_add_physaddr_to_nid(start: u64_) -> core::ffi::c_int;
}
pub type pteval_t = core::ffi::c_ulong;
pub type pmdval_t = core::ffi::c_ulong;
pub type pudval_t = core::ffi::c_ulong;
pub type p4dval_t = core::ffi::c_ulong;
pub type pgdval_t = core::ffi::c_ulong;
pub type pgprotval_t = core::ffi::c_ulong;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pte_t {
    pub pte: pteval_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pmd_t {
    pub pmd: pmdval_t,
}
extern "C" {
    pub static mut __pgtable_l5_enabled: core::ffi::c_uint;
}
extern "C" {
    pub static mut pgdir_shift: core::ffi::c_uint;
}
extern "C" {
    pub static mut ptrs_per_p4d: core::ffi::c_uint;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pgprot {
    pub pgprot: pgprotval_t,
}
pub type pgprot_t = pgprot;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pgd_t {
    pub pgd: pgdval_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct p4d_t {
    pub p4d: p4dval_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pud_t {
    pub pud: pudval_t,
}
extern "C" {
    pub fn cachemode2protval(pcm: page_cache_mode) -> core::ffi::c_ulong;
}
pub type pgtable_t = *mut page;
extern "C" {
    pub static mut __supported_pte_mask: pteval_t;
}
extern "C" {
    pub static mut __default_kernel_pte_mask: pteval_t;
}
extern "C" {
    pub fn set_nx();
}
extern "C" {
    pub static mut nx_enabled: core::ffi::c_int;
}
extern "C" {
    pub fn pgprot_writecombine(prot: pgprot_t) -> pgprot_t;
}
extern "C" {
    pub fn pgprot_writethrough(prot: pgprot_t) -> pgprot_t;
}
extern "C" {
    pub fn phys_mem_access_prot(
        file: *mut file,
        pfn: core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        vma_prot: pgprot_t,
    ) -> pgprot_t;
}
extern "C" {
    pub fn set_pte_vaddr(vaddr: core::ffi::c_ulong, pte: pte_t);
}
pub const pg_level_PG_LEVEL_NONE: pg_level = 0;
pub const pg_level_PG_LEVEL_4K: pg_level = 1;
pub const pg_level_PG_LEVEL_2M: pg_level = 2;
pub const pg_level_PG_LEVEL_1G: pg_level = 3;
pub const pg_level_PG_LEVEL_512G: pg_level = 4;
pub const pg_level_PG_LEVEL_NUM: pg_level = 5;
pub type pg_level = core::ffi::c_uint;
extern "C" {
    pub fn update_page_count(level: core::ffi::c_int, pages: core::ffi::c_ulong);
}
extern "C" {
    pub fn lookup_address(address: core::ffi::c_ulong, level: *mut core::ffi::c_uint)
        -> *mut pte_t;
}
extern "C" {
    pub fn lookup_address_in_pgd(
        pgd: *mut pgd_t,
        address: core::ffi::c_ulong,
        level: *mut core::ffi::c_uint,
    ) -> *mut pte_t;
}
extern "C" {
    pub fn lookup_address_in_pgd_attr(
        pgd: *mut pgd_t,
        address: core::ffi::c_ulong,
        level: *mut core::ffi::c_uint,
        nx: *mut bool_,
        rw: *mut bool_,
    ) -> *mut pte_t;
}
extern "C" {
    pub fn lookup_pmd_address(address: core::ffi::c_ulong) -> *mut pmd_t;
}
extern "C" {
    pub fn slow_virt_to_phys(__address: *mut core::ffi::c_void) -> phys_addr_t;
}
extern "C" {
    pub fn kernel_map_pages_in_pgd(
        pgd: *mut pgd_t,
        pfn: u64_,
        address: core::ffi::c_ulong,
        numpages: core::ffi::c_uint,
        page_flags: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kernel_unmap_pages_in_pgd(
        pgd: *mut pgd_t,
        address: core::ffi::c_ulong,
        numpages: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct flush_tlb_info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mmu_gather {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct paravirt_callee_save {
    pub func: *mut core::ffi::c_void,
}
impl Default for paravirt_callee_save {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pv_info {
    pub extra_user_64bit_cs: u16_,
    pub name: *const core::ffi::c_char,
}
impl Default for pv_info {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pv_lazy_ops {
    pub enter: ::core::option::Option<unsafe extern "C" fn()>,
    pub leave: ::core::option::Option<unsafe extern "C" fn()>,
    pub flush: ::core::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pv_cpu_ops {
    pub io_delay: ::core::option::Option<unsafe extern "C" fn()>,
    pub get_debugreg:
        ::core::option::Option<unsafe extern "C" fn(regno: core::ffi::c_int) -> core::ffi::c_ulong>,
    pub set_debugreg: ::core::option::Option<
        unsafe extern "C" fn(regno: core::ffi::c_int, value: core::ffi::c_ulong),
    >,
    pub read_cr0: ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_ulong>,
    pub write_cr0: ::core::option::Option<unsafe extern "C" fn(arg1: core::ffi::c_ulong)>,
    pub write_cr4: ::core::option::Option<unsafe extern "C" fn(arg1: core::ffi::c_ulong)>,
    pub load_tr_desc: ::core::option::Option<unsafe extern "C" fn()>,
    pub load_gdt: ::core::option::Option<unsafe extern "C" fn(arg1: *const desc_ptr)>,
    pub load_idt: ::core::option::Option<unsafe extern "C" fn(arg1: *const desc_ptr)>,
    pub set_ldt: ::core::option::Option<
        unsafe extern "C" fn(desc: *const core::ffi::c_void, entries: core::ffi::c_uint),
    >,
    pub store_tr: ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_ulong>,
    pub load_tls:
        ::core::option::Option<unsafe extern "C" fn(t: *mut thread_struct, cpu: core::ffi::c_uint)>,
    pub load_gs_index: ::core::option::Option<unsafe extern "C" fn(idx: core::ffi::c_uint)>,
    pub write_ldt_entry: ::core::option::Option<
        unsafe extern "C" fn(
            ldt: *mut desc_struct,
            entrynum: core::ffi::c_int,
            desc: *const core::ffi::c_void,
        ),
    >,
    pub write_gdt_entry: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut desc_struct,
            entrynum: core::ffi::c_int,
            desc: *const core::ffi::c_void,
            size: core::ffi::c_int,
        ),
    >,
    pub write_idt_entry: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut gate_desc,
            entrynum: core::ffi::c_int,
            gate: *const gate_desc,
        ),
    >,
    pub alloc_ldt: ::core::option::Option<
        unsafe extern "C" fn(ldt: *mut desc_struct, entries: core::ffi::c_uint),
    >,
    pub free_ldt: ::core::option::Option<
        unsafe extern "C" fn(ldt: *mut desc_struct, entries: core::ffi::c_uint),
    >,
    pub load_sp0: ::core::option::Option<unsafe extern "C" fn(sp0: core::ffi::c_ulong)>,
    pub invalidate_io_bitmap: ::core::option::Option<unsafe extern "C" fn()>,
    pub update_io_bitmap: ::core::option::Option<unsafe extern "C" fn()>,
    pub wbinvd: ::core::option::Option<unsafe extern "C" fn()>,
    pub cpuid: ::core::option::Option<
        unsafe extern "C" fn(
            eax: *mut core::ffi::c_uint,
            ebx: *mut core::ffi::c_uint,
            ecx: *mut core::ffi::c_uint,
            edx: *mut core::ffi::c_uint,
        ),
    >,
    pub read_msr: ::core::option::Option<unsafe extern "C" fn(msr: core::ffi::c_uint) -> u64_>,
    pub write_msr: ::core::option::Option<
        unsafe extern "C" fn(
            msr: core::ffi::c_uint,
            low: core::ffi::c_uint,
            high: core::ffi::c_uint,
        ),
    >,
    pub read_msr_safe: ::core::option::Option<
        unsafe extern "C" fn(msr: core::ffi::c_uint, err: *mut core::ffi::c_int) -> u64_,
    >,
    pub write_msr_safe: ::core::option::Option<
        unsafe extern "C" fn(
            msr: core::ffi::c_uint,
            low: core::ffi::c_uint,
            high: core::ffi::c_uint,
        ) -> core::ffi::c_int,
    >,
    pub read_pmc: ::core::option::Option<unsafe extern "C" fn(counter: core::ffi::c_int) -> u64_>,
    pub start_context_switch: ::core::option::Option<unsafe extern "C" fn(prev: *mut task_struct)>,
    pub end_context_switch: ::core::option::Option<unsafe extern "C" fn(next: *mut task_struct)>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pv_irq_ops {
    pub save_fl: paravirt_callee_save,
    pub irq_disable: paravirt_callee_save,
    pub irq_enable: paravirt_callee_save,
    pub safe_halt: ::core::option::Option<unsafe extern "C" fn()>,
    pub halt: ::core::option::Option<unsafe extern "C" fn()>,
}
impl Default for pv_irq_ops {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pv_mmu_ops {
    pub flush_tlb_user: ::core::option::Option<unsafe extern "C" fn()>,
    pub flush_tlb_kernel: ::core::option::Option<unsafe extern "C" fn()>,
    pub flush_tlb_one_user: ::core::option::Option<unsafe extern "C" fn(addr: core::ffi::c_ulong)>,
    pub flush_tlb_multi: ::core::option::Option<
        unsafe extern "C" fn(cpus: *const cpumask, info: *const flush_tlb_info),
    >,
    pub tlb_remove_table: ::core::option::Option<
        unsafe extern "C" fn(tlb: *mut mmu_gather, table: *mut core::ffi::c_void),
    >,
    pub exit_mmap: ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct)>,
    pub notify_page_enc_status_changed: ::core::option::Option<
        unsafe extern "C" fn(pfn: core::ffi::c_ulong, npages: core::ffi::c_int, enc: bool_),
    >,
    pub read_cr2: paravirt_callee_save,
    pub write_cr2: ::core::option::Option<unsafe extern "C" fn(arg1: core::ffi::c_ulong)>,
    pub read_cr3: ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_ulong>,
    pub write_cr3: ::core::option::Option<unsafe extern "C" fn(arg1: core::ffi::c_ulong)>,
    pub enter_mmap: ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct)>,
    pub pgd_alloc:
        ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct) -> core::ffi::c_int>,
    pub pgd_free: ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct, pgd: *mut pgd_t)>,
    pub alloc_pte:
        ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct, pfn: core::ffi::c_ulong)>,
    pub alloc_pmd:
        ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct, pfn: core::ffi::c_ulong)>,
    pub alloc_pud:
        ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct, pfn: core::ffi::c_ulong)>,
    pub alloc_p4d:
        ::core::option::Option<unsafe extern "C" fn(mm: *mut mm_struct, pfn: core::ffi::c_ulong)>,
    pub release_pte: ::core::option::Option<unsafe extern "C" fn(pfn: core::ffi::c_ulong)>,
    pub release_pmd: ::core::option::Option<unsafe extern "C" fn(pfn: core::ffi::c_ulong)>,
    pub release_pud: ::core::option::Option<unsafe extern "C" fn(pfn: core::ffi::c_ulong)>,
    pub release_p4d: ::core::option::Option<unsafe extern "C" fn(pfn: core::ffi::c_ulong)>,
    pub set_pte: ::core::option::Option<unsafe extern "C" fn(ptep: *mut pte_t, pteval: pte_t)>,
    pub set_pmd: ::core::option::Option<unsafe extern "C" fn(pmdp: *mut pmd_t, pmdval: pmd_t)>,
    pub ptep_modify_prot_start: ::core::option::Option<
        unsafe extern "C" fn(
            vma: *mut vm_area_struct,
            addr: core::ffi::c_ulong,
            ptep: *mut pte_t,
        ) -> pte_t,
    >,
    pub ptep_modify_prot_commit: ::core::option::Option<
        unsafe extern "C" fn(
            vma: *mut vm_area_struct,
            addr: core::ffi::c_ulong,
            ptep: *mut pte_t,
            pte: pte_t,
        ),
    >,
    pub pte_val: paravirt_callee_save,
    pub make_pte: paravirt_callee_save,
    pub pgd_val: paravirt_callee_save,
    pub make_pgd: paravirt_callee_save,
    pub set_pud: ::core::option::Option<unsafe extern "C" fn(pudp: *mut pud_t, pudval: pud_t)>,
    pub pmd_val: paravirt_callee_save,
    pub make_pmd: paravirt_callee_save,
    pub pud_val: paravirt_callee_save,
    pub make_pud: paravirt_callee_save,
    pub set_p4d: ::core::option::Option<unsafe extern "C" fn(p4dp: *mut p4d_t, p4dval: p4d_t)>,
    pub p4d_val: paravirt_callee_save,
    pub make_p4d: paravirt_callee_save,
    pub set_pgd: ::core::option::Option<unsafe extern "C" fn(pgdp: *mut pgd_t, pgdval: pgd_t)>,
    pub lazy_mode: pv_lazy_ops,
    pub set_fixmap: ::core::option::Option<
        unsafe extern "C" fn(idx: core::ffi::c_uint, phys: phys_addr_t, flags: pgprot_t),
    >,
}
impl Default for pv_mmu_ops {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct arch_spinlock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pv_lock_ops {
    pub queued_spin_lock_slowpath:
        ::core::option::Option<unsafe extern "C" fn(lock: *mut qspinlock, val: u32_)>,
    pub queued_spin_unlock: paravirt_callee_save,
    pub wait: ::core::option::Option<unsafe extern "C" fn(ptr: *mut u8_, val: u8_)>,
    pub kick: ::core::option::Option<unsafe extern "C" fn(cpu: core::ffi::c_int)>,
    pub vcpu_is_preempted: paravirt_callee_save,
}
impl Default for pv_lock_ops {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct paravirt_patch_template {
    pub cpu: pv_cpu_ops,
    pub irq: pv_irq_ops,
    pub mmu: pv_mmu_ops,
    pub lock: pv_lock_ops,
}
impl Default for paravirt_patch_template {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut pv_info: pv_info;
}
extern "C" {
    pub static mut pv_ops: paravirt_patch_template;
}
extern "C" {
    pub fn paravirt_disable_iospace() -> core::ffi::c_int;
}
extern "C" {
    pub fn paravirt_ret0() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _paravirt_ident_64(arg1: u64_) -> u64_;
}
extern "C" {
    pub fn pv_native_save_fl() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn pv_native_irq_disable();
}
extern "C" {
    pub fn pv_native_irq_enable();
}
extern "C" {
    pub fn pv_native_read_cr2() -> core::ffi::c_ulong;
}
extern "C" {
    pub static mut panic_blink:
        ::core::option::Option<unsafe extern "C" fn(state: core::ffi::c_int) -> core::ffi::c_long>;
}
extern "C" {
    pub fn panic(fmt: *const core::ffi::c_char, ...) -> !;
}
extern "C" {
    pub fn nmi_panic(regs: *mut pt_regs, msg: *const core::ffi::c_char);
}
extern "C" {
    pub fn check_panic_on_warn(origin: *const core::ffi::c_char);
}
extern "C" {
    pub fn oops_enter();
}
extern "C" {
    pub fn oops_exit();
}
extern "C" {
    pub fn oops_may_print() -> bool_;
}
extern "C" {
    pub static mut panic_timeout: core::ffi::c_int;
}
extern "C" {
    pub static mut panic_print: core::ffi::c_ulong;
}
extern "C" {
    pub static mut panic_on_oops: core::ffi::c_int;
}
extern "C" {
    pub static mut panic_on_unrecovered_nmi: core::ffi::c_int;
}
extern "C" {
    pub static mut panic_on_io_nmi: core::ffi::c_int;
}
extern "C" {
    pub static mut panic_on_warn: core::ffi::c_int;
}
extern "C" {
    pub static mut panic_on_taint: core::ffi::c_ulong;
}
extern "C" {
    pub static mut panic_on_taint_nousertaint: bool_;
}
extern "C" {
    pub static mut sysctl_panic_on_rcu_stall: core::ffi::c_int;
}
extern "C" {
    pub static mut sysctl_max_rcu_stall_to_panic: core::ffi::c_int;
}
extern "C" {
    pub static mut sysctl_panic_on_stackoverflow: core::ffi::c_int;
}
extern "C" {
    pub static mut crash_kexec_post_notifiers: bool_;
}
extern "C" {
    pub fn __stack_chk_fail();
}
extern "C" {
    pub fn abort() -> !;
}
extern "C" {
    pub static mut panic_cpu: atomic_t;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct taint_flag {
    pub c_true: core::ffi::c_char,
    pub c_false: core::ffi::c_char,
    pub module: bool_,
}
extern "C" {
    pub static taint_flags: [taint_flag; 19usize];
}
pub const lockdep_ok_LOCKDEP_STILL_OK: lockdep_ok = 0;
pub const lockdep_ok_LOCKDEP_NOW_UNRELIABLE: lockdep_ok = 1;
pub type lockdep_ok = core::ffi::c_uint;
extern "C" {
    pub fn print_tainted() -> *const core::ffi::c_char;
}
extern "C" {
    pub fn add_taint(flag: core::ffi::c_uint, arg1: lockdep_ok);
}
extern "C" {
    pub fn test_taint(flag: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub fn get_taint() -> core::ffi::c_ulong;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct warn_args {
    _unused: [u8; 0],
}
extern "C" {
    pub fn __warn(
        file: *const core::ffi::c_char,
        line: core::ffi::c_int,
        caller: *mut core::ffi::c_void,
        taint: core::ffi::c_uint,
        regs: *mut pt_regs,
        args: *mut warn_args,
    );
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct bug_entry {
    pub bug_addr_disp: core::ffi::c_int,
    pub file_disp: core::ffi::c_int,
    pub line: core::ffi::c_ushort,
    pub flags: core::ffi::c_ushort,
}
extern "C" {
    pub fn warn_slowpath_fmt(
        file: *const core::ffi::c_char,
        line: core::ffi::c_int,
        taint: core::ffi::c_uint,
        fmt: *const core::ffi::c_char,
        ...
    );
}
extern "C" {
    pub fn __warn_printk(fmt: *const core::ffi::c_char, ...);
}
pub const bug_trap_type_BUG_TRAP_TYPE_NONE: bug_trap_type = 0;
pub const bug_trap_type_BUG_TRAP_TYPE_WARN: bug_trap_type = 1;
pub const bug_trap_type_BUG_TRAP_TYPE_BUG: bug_trap_type = 2;
pub type bug_trap_type = core::ffi::c_uint;
extern "C" {
    pub fn bug_get_file_line(
        bug: *mut bug_entry,
        file: *mut *const core::ffi::c_char,
        line: *mut core::ffi::c_uint,
    );
}
extern "C" {
    pub fn find_bug(bugaddr: core::ffi::c_ulong) -> *mut bug_entry;
}
extern "C" {
    pub fn report_bug(bug_addr: core::ffi::c_ulong, regs: *mut pt_regs) -> bug_trap_type;
}
extern "C" {
    pub fn is_valid_bugaddr(addr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub fn generic_bug_clear_once();
}
extern "C" {
    pub fn __sw_hweight8(w: core::ffi::c_uint) -> core::ffi::c_uint;
}
extern "C" {
    pub fn __sw_hweight16(w: core::ffi::c_uint) -> core::ffi::c_uint;
}
extern "C" {
    pub fn __sw_hweight32(w: core::ffi::c_uint) -> core::ffi::c_uint;
}
extern "C" {
    pub fn __sw_hweight64(w: __u64) -> core::ffi::c_ulong;
}
extern "C" {
    pub static hex_asc: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub static hex_asc_upper: [core::ffi::c_char; 0usize];
}
extern "C" {
    pub fn hex_to_bin(ch: core::ffi::c_uchar) -> core::ffi::c_int;
}
extern "C" {
    pub fn hex2bin(dst: *mut u8_, src: *const core::ffi::c_char, count: usize) -> core::ffi::c_int;
}
extern "C" {
    pub fn bin2hex(
        dst: *mut core::ffi::c_char,
        src: *const core::ffi::c_void,
        count: usize,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn mac_pton(s: *const core::ffi::c_char, mac: *mut u8_) -> bool_;
}
extern "C" {
    pub fn _kstrtoul(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn _kstrtol(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_long,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoull(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_ulonglong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoll(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_longlong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtouint(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_uint,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoint(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtou16(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut u16_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtos16(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut s16,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtou8(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut u8_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtos8(
        s: *const core::ffi::c_char,
        base: core::ffi::c_uint,
        res: *mut s8,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtobool(s: *const core::ffi::c_char, res: *mut bool_) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoull_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_ulonglong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoll_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_longlong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoul_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtol_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_long,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtouint_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_uint,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtoint_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtou16_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut u16_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtos16_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut s16,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtou8_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut u8_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtos8_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        base: core::ffi::c_uint,
        res: *mut s8,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kstrtobool_from_user(
        s: *const core::ffi::c_char,
        count: usize,
        res: *mut bool_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn simple_strtoul(
        arg1: *const core::ffi::c_char,
        arg2: *mut *mut core::ffi::c_char,
        arg3: core::ffi::c_uint,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn simple_strtol(
        arg1: *const core::ffi::c_char,
        arg2: *mut *mut core::ffi::c_char,
        arg3: core::ffi::c_uint,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn simple_strtoull(
        arg1: *const core::ffi::c_char,
        arg2: *mut *mut core::ffi::c_char,
        arg3: core::ffi::c_uint,
    ) -> core::ffi::c_ulonglong;
}
extern "C" {
    pub fn simple_strtoll(
        arg1: *const core::ffi::c_char,
        arg2: *mut *mut core::ffi::c_char,
        arg3: core::ffi::c_uint,
    ) -> core::ffi::c_longlong;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct s16_fract {
    pub numerator: __s16,
    pub denominator: __s16,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct u16_fract {
    pub numerator: __u16,
    pub denominator: __u16,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct s32_fract {
    pub numerator: __s32,
    pub denominator: __s32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct u32_fract {
    pub numerator: __u32,
    pub denominator: __u32,
}
extern "C" {
    pub fn int_pow(base: u64_, exp: core::ffi::c_uint) -> u64_;
}
extern "C" {
    pub fn int_sqrt(arg1: core::ffi::c_ulong) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn num_to_str(
        buf: *mut core::ffi::c_char,
        size: core::ffi::c_int,
        num: core::ffi::c_ulonglong,
        width: core::ffi::c_uint,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn sprintf(
        buf: *mut core::ffi::c_char,
        fmt: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn vsprintf(
        buf: *mut core::ffi::c_char,
        arg1: *const core::ffi::c_char,
        arg2: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn snprintf(
        buf: *mut core::ffi::c_char,
        size: core::ffi::c_ulong,
        fmt: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn vsnprintf(
        buf: *mut core::ffi::c_char,
        size: core::ffi::c_ulong,
        fmt: *const core::ffi::c_char,
        args: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn scnprintf(
        buf: *mut core::ffi::c_char,
        size: usize,
        fmt: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn vscnprintf(
        buf: *mut core::ffi::c_char,
        size: usize,
        fmt: *const core::ffi::c_char,
        args: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kasprintf(gfp: gfp_t, fmt: *const core::ffi::c_char, ...) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn kvasprintf(
        gfp: gfp_t,
        fmt: *const core::ffi::c_char,
        args: *mut __va_list_tag,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn kvasprintf_const(
        gfp: gfp_t,
        fmt: *const core::ffi::c_char,
        args: *mut __va_list_tag,
    ) -> *const core::ffi::c_char;
}
extern "C" {
    pub fn sscanf(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn vsscanf(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub static mut no_hash_pointers: bool_;
}
extern "C" {
    pub fn no_hash_pointers_enable(str_: *mut core::ffi::c_char) -> core::ffi::c_int;
}
extern "C" {
    pub fn __cond_resched() -> core::ffi::c_int;
}
extern "C" {
    pub static mut __SCK__might_resched: static_call_key;
}
extern "C" {
    pub fn __SCT__might_resched() -> core::ffi::c_int;
}
extern "C" {
    pub fn do_exit(error_code: core::ffi::c_long) -> !;
}
extern "C" {
    pub fn get_option(
        str_: *mut *mut core::ffi::c_char,
        pint: *mut core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn get_options(
        str_: *const core::ffi::c_char,
        nints: core::ffi::c_int,
        ints: *mut core::ffi::c_int,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn memparse(
        ptr: *const core::ffi::c_char,
        retptr: *mut *mut core::ffi::c_char,
    ) -> core::ffi::c_ulonglong;
}
extern "C" {
    pub fn parse_option_str(
        str_: *const core::ffi::c_char,
        option: *const core::ffi::c_char,
    ) -> bool_;
}
extern "C" {
    pub fn next_arg(
        args: *mut core::ffi::c_char,
        param: *mut *mut core::ffi::c_char,
        val: *mut *mut core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn core_kernel_text(addr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub fn __kernel_text_address(addr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub fn kernel_text_address(addr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub fn func_ptr_is_kernel_text(ptr: *mut core::ffi::c_void) -> core::ffi::c_int;
}
extern "C" {
    pub fn bust_spinlocks(yes: core::ffi::c_int);
}
extern "C" {
    pub static mut root_mountflags: core::ffi::c_int;
}
extern "C" {
    pub static mut early_boot_irqs_disabled: bool_;
}
pub const system_states_SYSTEM_BOOTING: system_states = 0;
pub const system_states_SYSTEM_SCHEDULING: system_states = 1;
pub const system_states_SYSTEM_FREEING_INITMEM: system_states = 2;
pub const system_states_SYSTEM_RUNNING: system_states = 3;
pub const system_states_SYSTEM_HALT: system_states = 4;
pub const system_states_SYSTEM_POWER_OFF: system_states = 5;
pub const system_states_SYSTEM_RESTART: system_states = 6;
pub const system_states_SYSTEM_SUSPEND: system_states = 7;
pub type system_states = core::ffi::c_uint;
extern "C" {
    pub static mut system_state: system_states;
}
pub const ftrace_dump_mode_DUMP_NONE: ftrace_dump_mode = 0;
pub const ftrace_dump_mode_DUMP_ALL: ftrace_dump_mode = 1;
pub const ftrace_dump_mode_DUMP_ORIG: ftrace_dump_mode = 2;
pub type ftrace_dump_mode = core::ffi::c_uint;
extern "C" {
    pub fn tracing_on();
}
extern "C" {
    pub fn tracing_off();
}
extern "C" {
    pub fn tracing_is_on() -> core::ffi::c_int;
}
extern "C" {
    pub fn tracing_snapshot();
}
extern "C" {
    pub fn tracing_snapshot_alloc();
}
extern "C" {
    pub fn tracing_start();
}
extern "C" {
    pub fn tracing_stop();
}
extern "C" {
    pub fn __trace_bprintk(
        ip: core::ffi::c_ulong,
        fmt: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __trace_printk(
        ip: core::ffi::c_ulong,
        fmt: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __trace_bputs(
        ip: core::ffi::c_ulong,
        str_: *const core::ffi::c_char,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __trace_puts(
        ip: core::ffi::c_ulong,
        str_: *const core::ffi::c_char,
        size: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn trace_dump_stack(skip: core::ffi::c_int);
}
extern "C" {
    pub fn __ftrace_vbprintk(
        ip: core::ffi::c_ulong,
        fmt: *const core::ffi::c_char,
        ap: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __ftrace_vprintk(
        ip: core::ffi::c_ulong,
        fmt: *const core::ffi::c_char,
        ap: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn ftrace_dump(oops_dump_mode: ftrace_dump_mode);
}
extern "C" {
    pub fn _find_next_bit(
        addr1: *const core::ffi::c_ulong,
        nbits: core::ffi::c_ulong,
        start: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_next_and_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_ulong,
        start: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_next_andnot_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_ulong,
        start: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_next_or_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_ulong,
        start: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_next_zero_bit(
        addr: *const core::ffi::c_ulong,
        nbits: core::ffi::c_ulong,
        start: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_first_bit(
        addr: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn __find_nth_bit(
        addr: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        n: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn __find_nth_and_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        n: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn __find_nth_andnot_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        n: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn __find_nth_and_andnot_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        addr3: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        n: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_first_and_bit(
        addr1: *const core::ffi::c_ulong,
        addr2: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_first_zero_bit(
        addr: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _find_last_bit(
        addr: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn find_next_clump8(
        clump: *mut core::ffi::c_ulong,
        addr: *const core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        offset: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn strndup_user(
        arg1: *const core::ffi::c_char,
        arg2: core::ffi::c_long,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn memdup_user(arg1: *const core::ffi::c_void, arg2: usize) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn vmemdup_user(arg1: *const core::ffi::c_void, arg2: usize) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn memdup_user_nul(arg1: *const core::ffi::c_void, arg2: usize) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn memcpy(
        to: *mut core::ffi::c_void,
        from: *const core::ffi::c_void,
        len: core::ffi::c_ulong,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn __memcpy(
        to: *mut core::ffi::c_void,
        from: *const core::ffi::c_void,
        len: usize,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn memset(
        s: *mut core::ffi::c_void,
        c: core::ffi::c_int,
        n: core::ffi::c_ulong,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn __memset(
        s: *mut core::ffi::c_void,
        c: core::ffi::c_int,
        n: usize,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn memmove(
        dest: *mut core::ffi::c_void,
        src: *const core::ffi::c_void,
        count: core::ffi::c_ulong,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn __memmove(
        dest: *mut core::ffi::c_void,
        src: *const core::ffi::c_void,
        count: usize,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn memcmp(
        cs: *const core::ffi::c_void,
        ct: *const core::ffi::c_void,
        count: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn strlen(s: *const core::ffi::c_char) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn strcpy(
        dest: *mut core::ffi::c_char,
        src: *const core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strcat(
        dest: *mut core::ffi::c_char,
        src: *const core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strcmp(cs: *const core::ffi::c_char, ct: *const core::ffi::c_char) -> core::ffi::c_int;
}
extern "C" {
    pub fn __memcpy_flushcache(
        dst: *mut core::ffi::c_void,
        src: *const core::ffi::c_void,
        cnt: usize,
    );
}
extern "C" {
    pub fn strncpy(
        arg1: *mut core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: core::ffi::c_ulong,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strscpy(
        arg1: *mut core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: usize,
    ) -> isize;
}
extern "C" {
    pub fn strscpy_pad(
        dest: *mut core::ffi::c_char,
        src: *const core::ffi::c_char,
        count: usize,
    ) -> isize;
}
extern "C" {
    pub fn strncat(
        arg1: *mut core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: core::ffi::c_ulong,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strlcat(
        arg1: *mut core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: __kernel_size_t,
    ) -> usize;
}
extern "C" {
    pub fn strncmp(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn strcasecmp(
        s1: *const core::ffi::c_char,
        s2: *const core::ffi::c_char,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn strncasecmp(
        s1: *const core::ffi::c_char,
        s2: *const core::ffi::c_char,
        n: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn strchr(arg1: *const core::ffi::c_char, arg2: core::ffi::c_int)
        -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strchrnul(
        arg1: *const core::ffi::c_char,
        arg2: core::ffi::c_int,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strnchrnul(
        arg1: *const core::ffi::c_char,
        arg2: usize,
        arg3: core::ffi::c_int,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strnchr(
        arg1: *const core::ffi::c_char,
        arg2: usize,
        arg3: core::ffi::c_int,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strrchr(
        arg1: *const core::ffi::c_char,
        arg2: core::ffi::c_int,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn skip_spaces(arg1: *const core::ffi::c_char) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strim(arg1: *mut core::ffi::c_char) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strstr(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strnstr(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
        arg3: usize,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strnlen(arg1: *const core::ffi::c_char, arg2: __kernel_size_t) -> __kernel_size_t;
}
extern "C" {
    pub fn strpbrk(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strsep(
        arg1: *mut *mut core::ffi::c_char,
        arg2: *const core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn strspn(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn strcspn(
        arg1: *const core::ffi::c_char,
        arg2: *const core::ffi::c_char,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn __memcat_p(
        a: *mut *mut core::ffi::c_void,
        b: *mut *mut core::ffi::c_void,
    ) -> *mut *mut core::ffi::c_void;
}
extern "C" {
    pub fn memscan(
        arg1: *mut core::ffi::c_void,
        arg2: core::ffi::c_int,
        arg3: __kernel_size_t,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn bcmp(
        arg1: *const core::ffi::c_void,
        arg2: *const core::ffi::c_void,
        arg3: core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn memchr(
        arg1: *const core::ffi::c_void,
        arg2: core::ffi::c_int,
        arg3: core::ffi::c_ulong,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn memchr_inv(
        s: *const core::ffi::c_void,
        c: core::ffi::c_int,
        n: usize,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn strreplace(
        str_: *mut core::ffi::c_char,
        old: core::ffi::c_char,
        new: core::ffi::c_char,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn kfree_const(x: *const core::ffi::c_void);
}
extern "C" {
    pub fn kstrdup(s: *const core::ffi::c_char, gfp: gfp_t) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn kstrdup_const(s: *const core::ffi::c_char, gfp: gfp_t) -> *const core::ffi::c_char;
}
extern "C" {
    pub fn kstrndup(s: *const core::ffi::c_char, len: usize, gfp: gfp_t) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn kmemdup(src: *const core::ffi::c_void, len: usize, gfp: gfp_t)
        -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn kvmemdup(
        src: *const core::ffi::c_void,
        len: usize,
        gfp: gfp_t,
    ) -> *mut core::ffi::c_void;
}
extern "C" {
    pub fn kmemdup_nul(
        s: *const core::ffi::c_char,
        len: usize,
        gfp: gfp_t,
    ) -> *mut core::ffi::c_char;
}
extern "C" {
    pub fn argv_split(
        gfp: gfp_t,
        str_: *const core::ffi::c_char,
        argcp: *mut core::ffi::c_int,
    ) -> *mut *mut core::ffi::c_char;
}
extern "C" {
    pub fn argv_free(argv: *mut *mut core::ffi::c_char);
}
extern "C" {
    pub fn sysfs_streq(s1: *const core::ffi::c_char, s2: *const core::ffi::c_char) -> bool_;
}
extern "C" {
    pub fn match_string(
        array: *const *const core::ffi::c_char,
        n: usize,
        string: *const core::ffi::c_char,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __sysfs_match_string(
        array: *const *const core::ffi::c_char,
        n: usize,
        s: *const core::ffi::c_char,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn vbin_printf(
        bin_buf: *mut u32_,
        size: usize,
        fmt: *const core::ffi::c_char,
        args: *mut __va_list_tag,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bstr_printf(
        buf: *mut core::ffi::c_char,
        size: usize,
        fmt: *const core::ffi::c_char,
        bin_buf: *const u32_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bprintf(
        bin_buf: *mut u32_,
        size: usize,
        fmt: *const core::ffi::c_char,
        ...
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn memory_read_from_buffer(
        to: *mut core::ffi::c_void,
        count: usize,
        ppos: *mut loff_t,
        from: *const core::ffi::c_void,
        available: usize,
    ) -> isize;
}
extern "C" {
    pub fn ptr_to_hashval(
        ptr: *const core::ffi::c_void,
        hashval_out: *mut core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn memweight(ptr: *const core::ffi::c_void, bytes: usize) -> usize;
}
extern "C" {
    pub fn fortify_panic(name: *const core::ffi::c_char) -> !;
}
extern "C" {
    pub fn __read_overflow();
}
extern "C" {
    pub fn __read_overflow2();
}
extern "C" {
    pub fn __read_overflow2_field(avail: usize, wanted: usize);
}
extern "C" {
    pub fn __write_overflow();
}
extern "C" {
    pub fn __write_overflow_field(avail: usize, wanted: usize);
}
extern "C" {
    pub fn memcpy_and_pad(
        dest: *mut core::ffi::c_void,
        dest_len: usize,
        src: *const core::ffi::c_void,
        count: usize,
        pad: core::ffi::c_int,
    );
}
extern "C" {
    pub fn bitmap_parse_user(
        ubuf: *const core::ffi::c_char,
        ulen: core::ffi::c_uint,
        dst: *mut core::ffi::c_ulong,
        nbits: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_print_to_pagebuf(
        list: bool_,
        buf: *mut core::ffi::c_char,
        maskp: *const core::ffi::c_ulong,
        nmaskbits: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_print_bitmask_to_buf(
        buf: *mut core::ffi::c_char,
        maskp: *const core::ffi::c_ulong,
        nmaskbits: core::ffi::c_int,
        off: loff_t,
        count: usize,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_print_list_to_buf(
        buf: *mut core::ffi::c_char,
        maskp: *const core::ffi::c_ulong,
        nmaskbits: core::ffi::c_int,
        off: loff_t,
        count: usize,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_parse(
        buf: *const core::ffi::c_char,
        buflen: core::ffi::c_uint,
        dst: *mut core::ffi::c_ulong,
        nbits: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_parselist(
        buf: *const core::ffi::c_char,
        maskp: *mut core::ffi::c_ulong,
        nmaskbits: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_parselist_user(
        ubuf: *const core::ffi::c_char,
        ulen: core::ffi::c_uint,
        dst: *mut core::ffi::c_ulong,
        nbits: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_alloc(nbits: core::ffi::c_uint, flags: gfp_t) -> *mut core::ffi::c_ulong;
}
extern "C" {
    pub fn bitmap_zalloc(nbits: core::ffi::c_uint, flags: gfp_t) -> *mut core::ffi::c_ulong;
}
extern "C" {
    pub fn bitmap_alloc_node(
        nbits: core::ffi::c_uint,
        flags: gfp_t,
        node: core::ffi::c_int,
    ) -> *mut core::ffi::c_ulong;
}
extern "C" {
    pub fn bitmap_zalloc_node(
        nbits: core::ffi::c_uint,
        flags: gfp_t,
        node: core::ffi::c_int,
    ) -> *mut core::ffi::c_ulong;
}
extern "C" {
    pub fn bitmap_free(bitmap: *const core::ffi::c_ulong);
}
extern "C" {
    pub fn devm_bitmap_alloc(
        dev: *mut device,
        nbits: core::ffi::c_uint,
        flags: gfp_t,
    ) -> *mut core::ffi::c_ulong;
}
extern "C" {
    pub fn devm_bitmap_zalloc(
        dev: *mut device,
        nbits: core::ffi::c_uint,
        flags: gfp_t,
    ) -> *mut core::ffi::c_ulong;
}
extern "C" {
    pub fn __bitmap_equal(
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub fn __bitmap_or_equal(
        src1: *const core::ffi::c_ulong,
        src2: *const core::ffi::c_ulong,
        src3: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub fn __bitmap_complement(
        dst: *mut core::ffi::c_ulong,
        src: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __bitmap_shift_right(
        dst: *mut core::ffi::c_ulong,
        src: *const core::ffi::c_ulong,
        shift: core::ffi::c_uint,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __bitmap_shift_left(
        dst: *mut core::ffi::c_ulong,
        src: *const core::ffi::c_ulong,
        shift: core::ffi::c_uint,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn bitmap_cut(
        dst: *mut core::ffi::c_ulong,
        src: *const core::ffi::c_ulong,
        first: core::ffi::c_uint,
        cut: core::ffi::c_uint,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __bitmap_and(
        dst: *mut core::ffi::c_ulong,
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub fn __bitmap_or(
        dst: *mut core::ffi::c_ulong,
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __bitmap_xor(
        dst: *mut core::ffi::c_ulong,
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __bitmap_andnot(
        dst: *mut core::ffi::c_ulong,
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub fn __bitmap_replace(
        dst: *mut core::ffi::c_ulong,
        old: *const core::ffi::c_ulong,
        new: *const core::ffi::c_ulong,
        mask: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __bitmap_intersects(
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub fn __bitmap_subset(
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> bool_;
}
extern "C" {
    pub fn __bitmap_weight(
        bitmap: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> core::ffi::c_uint;
}
extern "C" {
    pub fn __bitmap_weight_and(
        bitmap1: *const core::ffi::c_ulong,
        bitmap2: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    ) -> core::ffi::c_uint;
}
extern "C" {
    pub fn __bitmap_set(
        map: *mut core::ffi::c_ulong,
        start: core::ffi::c_uint,
        len: core::ffi::c_int,
    );
}
extern "C" {
    pub fn __bitmap_clear(
        map: *mut core::ffi::c_ulong,
        start: core::ffi::c_uint,
        len: core::ffi::c_int,
    );
}
extern "C" {
    pub fn bitmap_find_next_zero_area_off(
        map: *mut core::ffi::c_ulong,
        size: core::ffi::c_ulong,
        start: core::ffi::c_ulong,
        nr: core::ffi::c_uint,
        align_mask: core::ffi::c_ulong,
        align_offset: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn bitmap_remap(
        dst: *mut core::ffi::c_ulong,
        src: *const core::ffi::c_ulong,
        old: *const core::ffi::c_ulong,
        new: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn bitmap_bitremap(
        oldbit: core::ffi::c_int,
        old: *const core::ffi::c_ulong,
        new: *const core::ffi::c_ulong,
        bits: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn bitmap_onto(
        dst: *mut core::ffi::c_ulong,
        orig: *const core::ffi::c_ulong,
        relmap: *const core::ffi::c_ulong,
        bits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn bitmap_fold(
        dst: *mut core::ffi::c_ulong,
        orig: *const core::ffi::c_ulong,
        sz: core::ffi::c_uint,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn bitmap_from_arr32(
        bitmap: *mut core::ffi::c_ulong,
        buf: *const u32_,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn bitmap_to_arr32(
        buf: *mut u32_,
        bitmap: *const core::ffi::c_ulong,
        nbits: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn __xchg_wrong_size();
}
extern "C" {
    pub fn __cmpxchg_wrong_size();
}
extern "C" {
    pub fn __xadd_wrong_size();
}
extern "C" {
    pub fn __add_wrong_size();
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub union __u128_halves {
    pub full: u128_,
    pub __bindgen_anon_1: __u128_halves__bindgen_ty_1,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __u128_halves__bindgen_ty_1 {
    pub low: u64_,
    pub high: u64_,
}
impl Default for __u128_halves {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type atomic_long_t = atomic64_t;
extern "C" {
    pub fn numa_nearest_node(node: core::ffi::c_int, state: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub fn numa_fill_memblks(start: u64_, end: u64_) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct attribute_group {
    pub name: *const core::ffi::c_char,
    pub is_visible: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut kobject,
            arg2: *mut attribute,
            arg3: core::ffi::c_int,
        ) -> umode_t,
    >,
    pub is_bin_visible: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut kobject,
            arg2: *mut bin_attribute,
            arg3: core::ffi::c_int,
        ) -> umode_t,
    >,
    pub attrs: *mut *mut attribute,
    pub bin_attrs: *mut *mut bin_attribute,
}
impl Default for attribute_group {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static arch_node_dev_group: attribute_group;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cpumask {
    pub bits: [core::ffi::c_ulong; 128usize],
}
impl Default for cpumask {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type cpumask_t = cpumask;
extern "C" {
    pub static mut nr_cpu_ids: core::ffi::c_uint;
}
extern "C" {
    pub static mut __cpu_possible_mask: cpumask;
}
extern "C" {
    pub static mut __cpu_online_mask: cpumask;
}
extern "C" {
    pub static mut __cpu_present_mask: cpumask;
}
extern "C" {
    pub static mut __cpu_active_mask: cpumask;
}
extern "C" {
    pub static mut __cpu_dying_mask: cpumask;
}
extern "C" {
    pub static mut __num_online_cpus: atomic_t;
}
extern "C" {
    pub static mut cpus_booted_once_mask: cpumask_t;
}
extern "C" {
    pub fn cpumask_local_spread(i: core::ffi::c_uint, node: core::ffi::c_int) -> core::ffi::c_uint;
}
extern "C" {
    pub fn cpumask_any_and_distribute(
        src1p: *const cpumask,
        src2p: *const cpumask,
    ) -> core::ffi::c_uint;
}
extern "C" {
    pub fn cpumask_any_distribute(srcp: *const cpumask) -> core::ffi::c_uint;
}
extern "C" {
    pub fn cpumask_next_wrap(
        n: core::ffi::c_int,
        mask: *const cpumask,
        start: core::ffi::c_int,
        wrap: bool_,
    ) -> core::ffi::c_uint;
}
pub type cpumask_var_t = *mut cpumask;
extern "C" {
    pub fn alloc_cpumask_var_node(
        mask: *mut cpumask_var_t,
        flags: gfp_t,
        node: core::ffi::c_int,
    ) -> bool_;
}
extern "C" {
    pub fn alloc_bootmem_cpumask_var(mask: *mut cpumask_var_t);
}
extern "C" {
    pub fn free_cpumask_var(mask: cpumask_var_t);
}
extern "C" {
    pub fn free_bootmem_cpumask_var(mask: cpumask_var_t);
}
extern "C" {
    pub static cpu_all_bits: [core::ffi::c_ulong; 128usize];
}
extern "C" {
    pub fn init_cpu_present(src: *const cpumask);
}
extern "C" {
    pub fn init_cpu_possible(src: *const cpumask);
}
extern "C" {
    pub fn init_cpu_online(src: *const cpumask);
}
extern "C" {
    pub fn set_cpu_online(cpu: core::ffi::c_uint, online: bool_);
}
extern "C" {
    pub static mut cpu_bit_bitmap: [[core::ffi::c_ulong; 128usize]; 65usize];
}
extern "C" {
    pub fn dummy_steal_clock(cpu: core::ffi::c_int) -> u64_;
}
extern "C" {
    pub fn dummy_sched_clock() -> u64_;
}
extern "C" {
    pub static mut __SCK__pv_steal_clock: static_call_key;
}
extern "C" {
    pub fn __SCT__pv_steal_clock(arg1: core::ffi::c_int) -> u64_;
}
extern "C" {
    pub static mut __SCK__pv_sched_clock: static_call_key;
}
extern "C" {
    pub fn __SCT__pv_sched_clock() -> u64_;
}
extern "C" {
    pub fn paravirt_set_sched_clock(func: ::core::option::Option<unsafe extern "C" fn() -> u64_>);
}
extern "C" {
    pub static mut paravirt_steal_enabled: static_key;
}
extern "C" {
    pub static mut paravirt_steal_rq_enabled: static_key;
}
extern "C" {
    pub fn __native_queued_spin_unlock(lock: *mut qspinlock);
}
extern "C" {
    pub fn pv_is_native_spin_unlock() -> bool_;
}
extern "C" {
    pub fn __native_vcpu_is_preempted(cpu: core::ffi::c_long) -> bool_;
}
extern "C" {
    pub fn pv_is_native_vcpu_is_preempted() -> bool_;
}
extern "C" {
    pub fn paravirt_set_cap();
}
extern "C" {
    pub fn native_flush_tlb_local();
}
extern "C" {
    pub fn native_flush_tlb_global();
}
extern "C" {
    pub fn native_flush_tlb_one_user(addr: core::ffi::c_ulong);
}
extern "C" {
    pub fn native_flush_tlb_multi(cpumask: *const cpumask, info: *const flush_tlb_info);
}
extern "C" {
    pub fn pv_native_wbinvd();
}
extern "C" {
    pub fn __raw_callee_save___native_queued_spin_unlock(lock: *mut qspinlock);
}
extern "C" {
    pub fn __raw_callee_save___native_vcpu_is_preempted(cpu: core::ffi::c_long) -> bool_;
}
extern "C" {
    pub fn default_banner();
}
extern "C" {
    pub fn native_pv_lock_init();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_irq_t {
    pub lock: *mut core::ffi::c_void,
}
impl Default for class_irq_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_irqsave_t {
    pub lock: *mut core::ffi::c_void,
    pub flags: core::ffi::c_ulong,
}
impl Default for class_irqsave_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct timespec {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pollfd {
    _unused: [u8; 0],
}
pub const timespec_type_TT_NONE: timespec_type = 0;
pub const timespec_type_TT_NATIVE: timespec_type = 1;
pub const timespec_type_TT_COMPAT: timespec_type = 2;
pub type timespec_type = core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct restart_block {
    pub arch_data: core::ffi::c_ulong,
    pub fn_:
        ::core::option::Option<unsafe extern "C" fn(arg1: *mut restart_block) -> core::ffi::c_long>,
    pub __bindgen_anon_1: restart_block__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union restart_block__bindgen_ty_1 {
    pub futex: restart_block__bindgen_ty_1__bindgen_ty_1,
    pub nanosleep: restart_block__bindgen_ty_1__bindgen_ty_2,
    pub poll: restart_block__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct restart_block__bindgen_ty_1__bindgen_ty_1 {
    pub uaddr: *mut u32_,
    pub val: u32_,
    pub flags: u32_,
    pub bitset: u32_,
    pub time: u64_,
    pub uaddr2: *mut u32_,
}
impl Default for restart_block__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct restart_block__bindgen_ty_1__bindgen_ty_2 {
    pub clockid: clockid_t,
    pub type_: timespec_type,
    pub __bindgen_anon_1: restart_block__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
    pub expires: u64_,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union restart_block__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    pub rmtp: *mut __kernel_timespec,
    pub compat_rmtp: *mut old_timespec32,
}
impl Default for restart_block__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for restart_block__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct restart_block__bindgen_ty_1__bindgen_ty_3 {
    pub ufds: *mut pollfd,
    pub nfds: core::ffi::c_int,
    pub has_timeout: core::ffi::c_int,
    pub tv_sec: core::ffi::c_ulong,
    pub tv_nsec: core::ffi::c_ulong,
}
impl Default for restart_block__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for restart_block__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for restart_block {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn do_no_restart_syscall(parm: *mut restart_block) -> core::ffi::c_long;
}
pub const BAD_STACK: _bindgen_ty_5 = -1;
pub const NOT_STACK: _bindgen_ty_5 = 0;
pub const GOOD_FRAME: _bindgen_ty_5 = 1;
pub const GOOD_STACK: _bindgen_ty_5 = 2;
pub type _bindgen_ty_5 = core::ffi::c_int;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SECCOMP: syscall_work_bit = 0;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SYSCALL_TRACEPOINT: syscall_work_bit = 1;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SYSCALL_TRACE: syscall_work_bit = 2;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SYSCALL_EMU: syscall_work_bit = 3;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SYSCALL_AUDIT: syscall_work_bit = 4;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SYSCALL_USER_DISPATCH: syscall_work_bit = 5;
pub const syscall_work_bit_SYSCALL_WORK_BIT_SYSCALL_EXIT_TRAP: syscall_work_bit = 6;
pub type syscall_work_bit = core::ffi::c_uint;
extern "C" {
    pub static mut max_pfn: core::ffi::c_ulong;
}
extern "C" {
    pub static mut phys_base: core::ffi::c_ulong;
}
extern "C" {
    pub static mut page_offset_base: core::ffi::c_ulong;
}
extern "C" {
    pub static mut vmalloc_base: core::ffi::c_ulong;
}
extern "C" {
    pub static mut vmemmap_base: core::ffi::c_ulong;
}
extern "C" {
    pub static mut physmem_end: core::ffi::c_ulong;
}
extern "C" {
    pub fn clear_page_orig(page: *mut core::ffi::c_void);
}
extern "C" {
    pub fn clear_page_rep(page: *mut core::ffi::c_void);
}
extern "C" {
    pub fn clear_page_erms(page: *mut core::ffi::c_void);
}
extern "C" {
    pub fn copy_page(to: *mut core::ffi::c_void, from: *mut core::ffi::c_void);
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct range {
    pub start: u64_,
    pub end: u64_,
}
extern "C" {
    pub fn add_range(
        range: *mut range,
        az: core::ffi::c_int,
        nr_range: core::ffi::c_int,
        start: u64_,
        end: u64_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn add_range_with_merge(
        range: *mut range,
        az: core::ffi::c_int,
        nr_range: core::ffi::c_int,
        start: u64_,
        end: u64_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn subtract_range(range: *mut range, az: core::ffi::c_int, start: u64_, end: u64_);
}
extern "C" {
    pub fn clean_sort_range(range: *mut range, az: core::ffi::c_int) -> core::ffi::c_int;
}
extern "C" {
    pub fn sort_range(range: *mut range, nr_range: core::ffi::c_int);
}
extern "C" {
    pub static mut pfn_mapped: [range; 0usize];
}
extern "C" {
    pub static mut nr_pfn_mapped: core::ffi::c_int;
}
extern "C" {
    pub fn __virt_addr_valid(kaddr: core::ffi::c_ulong) -> bool_;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pfn_t {
    pub val: u64_,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct io_bitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vm86 {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct pt_regs {
    pub r15: core::ffi::c_ulong,
    pub r14: core::ffi::c_ulong,
    pub r13: core::ffi::c_ulong,
    pub r12: core::ffi::c_ulong,
    pub bp: core::ffi::c_ulong,
    pub bx: core::ffi::c_ulong,
    pub r11: core::ffi::c_ulong,
    pub r10: core::ffi::c_ulong,
    pub r9: core::ffi::c_ulong,
    pub r8: core::ffi::c_ulong,
    pub ax: core::ffi::c_ulong,
    pub cx: core::ffi::c_ulong,
    pub dx: core::ffi::c_ulong,
    pub si: core::ffi::c_ulong,
    pub di: core::ffi::c_ulong,
    pub orig_ax: core::ffi::c_ulong,
    pub ip: core::ffi::c_ulong,
    pub cs: core::ffi::c_ulong,
    pub flags: core::ffi::c_ulong,
    pub sp: core::ffi::c_ulong,
    pub ss: core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct user_desc {
    pub entry_number: core::ffi::c_uint,
    pub base_addr: core::ffi::c_uint,
    pub limit: core::ffi::c_uint,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl user_desc {
    #[inline]
    pub fn seg_32bit(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_seg_32bit(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn contents(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_contents(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn read_exec_only(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_exec_only(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn limit_in_pages(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_limit_in_pages(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn seg_not_present(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_seg_not_present(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn useable(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_useable(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lm(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_lm(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        seg_32bit: core::ffi::c_uint,
        contents: core::ffi::c_uint,
        read_exec_only: core::ffi::c_uint,
        limit_in_pages: core::ffi::c_uint,
        seg_not_present: core::ffi::c_uint,
        useable: core::ffi::c_uint,
        lm: core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let seg_32bit: u32 = unsafe { ::core::mem::transmute(seg_32bit) };
            seg_32bit as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let contents: u32 = unsafe { ::core::mem::transmute(contents) };
            contents as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let read_exec_only: u32 = unsafe { ::core::mem::transmute(read_exec_only) };
            read_exec_only as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let limit_in_pages: u32 = unsafe { ::core::mem::transmute(limit_in_pages) };
            limit_in_pages as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let seg_not_present: u32 = unsafe { ::core::mem::transmute(seg_not_present) };
            seg_not_present as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let useable: u32 = unsafe { ::core::mem::transmute(useable) };
            useable as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let lm: u32 = unsafe { ::core::mem::transmute(lm) };
            lm as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn syscall_init();
}
extern "C" {
    pub fn entry_SYSCALL_64();
}
extern "C" {
    pub fn entry_SYSCALL_64_safe_stack();
}
extern "C" {
    pub fn entry_SYSRETQ_unsafe_stack();
}
extern "C" {
    pub fn entry_SYSRETQ_end();
}
extern "C" {
    pub fn do_arch_prctl_64(
        task: *mut task_struct,
        option: core::ffi::c_int,
        arg2: core::ffi::c_ulong,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn entry_SYSENTER_compat();
}
extern "C" {
    pub fn __end_entry_SYSENTER_compat();
}
extern "C" {
    pub fn entry_SYSCALL_compat();
}
extern "C" {
    pub fn entry_SYSCALL_compat_safe_stack();
}
extern "C" {
    pub fn entry_SYSRETL_compat_unsafe_stack();
}
extern "C" {
    pub fn entry_SYSRETL_compat_end();
}
extern "C" {
    pub fn x86_configure_nx();
}
extern "C" {
    pub static mut reboot_force: core::ffi::c_int;
}
extern "C" {
    pub fn do_arch_prctl_common(
        option: core::ffi::c_int,
        arg2: core::ffi::c_ulong,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn profile_pc(regs: *mut pt_regs) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn convert_ip_to_linear(child: *mut task_struct, regs: *mut pt_regs) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn send_sigtrap(
        regs: *mut pt_regs,
        error_code: core::ffi::c_int,
        si_code: core::ffi::c_int,
    );
}
extern "C" {
    pub fn regs_query_register_offset(name: *const core::ffi::c_char) -> core::ffi::c_int;
}
extern "C" {
    pub fn regs_query_register_name(offset: core::ffi::c_uint) -> *const core::ffi::c_char;
}
extern "C" {
    pub fn copy_from_kernel_nofault(
        dst: *mut core::ffi::c_void,
        src: *const core::ffi::c_void,
        size: usize,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn do_get_thread_area(
        p: *mut task_struct,
        idx: core::ffi::c_int,
        info: *mut user_desc,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn do_set_thread_area(
        p: *mut task_struct,
        idx: core::ffi::c_int,
        info: *mut user_desc,
        can_allocate: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct math_emu_info {
    pub ___orig_eip: core::ffi::c_long,
    pub regs: *mut pt_regs,
}
impl Default for math_emu_info {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct _fpx_sw_bytes {
    pub magic1: __u32,
    pub extended_size: __u32,
    pub xfeatures: __u64,
    pub xstate_size: __u32,
    pub padding: [__u32; 7usize],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct _fpreg {
    pub significand: [__u16; 4usize],
    pub exponent: __u16,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct _fpxreg {
    pub significand: [__u16; 4usize],
    pub exponent: __u16,
    pub padding: [__u16; 3usize],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct _xmmreg {
    pub element: [__u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _fpstate_32 {
    pub cw: __u32,
    pub sw: __u32,
    pub tag: __u32,
    pub ipoff: __u32,
    pub cssel: __u32,
    pub dataoff: __u32,
    pub datasel: __u32,
    pub _st: [_fpreg; 8usize],
    pub status: __u16,
    pub magic: __u16,
    pub _fxsr_env: [__u32; 6usize],
    pub mxcsr: __u32,
    pub reserved: __u32,
    pub _fxsr_st: [_fpxreg; 8usize],
    pub _xmm: [_xmmreg; 8usize],
    pub __bindgen_anon_1: _fpstate_32__bindgen_ty_1,
    pub __bindgen_anon_2: _fpstate_32__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _fpstate_32__bindgen_ty_1 {
    pub padding1: [__u32; 44usize],
    pub padding: [__u32; 44usize],
}
impl Default for _fpstate_32__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _fpstate_32__bindgen_ty_2 {
    pub padding2: [__u32; 12usize],
    pub sw_reserved: _fpx_sw_bytes,
}
impl Default for _fpstate_32__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for _fpstate_32 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _fpstate_64 {
    pub cwd: __u16,
    pub swd: __u16,
    pub twd: __u16,
    pub fop: __u16,
    pub rip: __u64,
    pub rdp: __u64,
    pub mxcsr: __u32,
    pub mxcsr_mask: __u32,
    pub st_space: [__u32; 32usize],
    pub xmm_space: [__u32; 64usize],
    pub reserved2: [__u32; 12usize],
    pub __bindgen_anon_1: _fpstate_64__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _fpstate_64__bindgen_ty_1 {
    pub reserved3: [__u32; 12usize],
    pub sw_reserved: _fpx_sw_bytes,
}
impl Default for _fpstate_64__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for _fpstate_64 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct _header {
    pub xfeatures: __u64,
    pub reserved1: [__u64; 2usize],
    pub reserved2: [__u64; 5usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ymmh_state {
    pub ymmh_space: [__u32; 64usize],
}
impl Default for _ymmh_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _xstate {
    pub fpstate: _fpstate_64,
    pub xstate_hdr: _header,
    pub ymmh: _ymmh_state,
}
impl Default for _xstate {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct sigcontext_32 {
    pub gs: __u16,
    pub __gsh: __u16,
    pub fs: __u16,
    pub __fsh: __u16,
    pub es: __u16,
    pub __esh: __u16,
    pub ds: __u16,
    pub __dsh: __u16,
    pub di: __u32,
    pub si: __u32,
    pub bp: __u32,
    pub sp: __u32,
    pub bx: __u32,
    pub dx: __u32,
    pub cx: __u32,
    pub ax: __u32,
    pub trapno: __u32,
    pub err: __u32,
    pub ip: __u32,
    pub cs: __u16,
    pub __csh: __u16,
    pub flags: __u32,
    pub sp_at_signal: __u32,
    pub ss: __u16,
    pub __ssh: __u16,
    pub fpstate: __u32,
    pub oldmask: __u32,
    pub cr2: __u32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct sigcontext_64 {
    pub r8: __u64,
    pub r9: __u64,
    pub r10: __u64,
    pub r11: __u64,
    pub r12: __u64,
    pub r13: __u64,
    pub r14: __u64,
    pub r15: __u64,
    pub di: __u64,
    pub si: __u64,
    pub bp: __u64,
    pub bx: __u64,
    pub dx: __u64,
    pub ax: __u64,
    pub cx: __u64,
    pub sp: __u64,
    pub ip: __u64,
    pub flags: __u64,
    pub cs: __u16,
    pub gs: __u16,
    pub fs: __u16,
    pub ss: __u16,
    pub err: __u64,
    pub trapno: __u64,
    pub oldmask: __u64,
    pub cr2: __u64,
    pub fpstate: __u64,
    pub reserved1: [__u64; 8usize],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct cpuid_regs {
    pub eax: u32_,
    pub ebx: u32_,
    pub ecx: u32_,
    pub edx: u32_,
}
pub const cpuid_regs_idx_CPUID_EAX: cpuid_regs_idx = 0;
pub const cpuid_regs_idx_CPUID_EBX: cpuid_regs_idx = 1;
pub const cpuid_regs_idx_CPUID_ECX: cpuid_regs_idx = 2;
pub const cpuid_regs_idx_CPUID_EDX: cpuid_regs_idx = 3;
pub type cpuid_regs_idx = core::ffi::c_uint;
extern "C" {
    pub fn setup_cpu_local_masks();
}
extern "C" {
    pub static mut __invalid_size_argument_for_IOC: core::ffi::c_uint;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct msr {
    pub __bindgen_anon_1: msr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union msr__bindgen_ty_1 {
    pub __bindgen_anon_1: msr__bindgen_ty_1__bindgen_ty_1,
    pub q: u64_,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct msr__bindgen_ty_1__bindgen_ty_1 {
    pub l: u32_,
    pub h: u32_,
}
impl Default for msr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for msr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct msr_info {
    pub msr_no: u32_,
    pub reg: msr,
    pub msrs: *mut msr,
    pub err: core::ffi::c_int,
}
impl Default for msr_info {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct msr_regs_info {
    pub regs: *mut u32_,
    pub err: core::ffi::c_int,
}
impl Default for msr_regs_info {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct saved_msr {
    pub valid: bool_,
    pub info: msr_info,
}
impl Default for saved_msr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct saved_msrs {
    pub num: core::ffi::c_uint,
    pub array: *mut saved_msr,
}
impl Default for saved_msrs {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct trace_print_flags {
    pub mask: core::ffi::c_ulong,
    pub name: *const core::ffi::c_char,
}
impl Default for trace_print_flags {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct trace_print_flags_u64 {
    pub mask: core::ffi::c_ulonglong,
    pub name: *const core::ffi::c_char,
}
impl Default for trace_print_flags_u64 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tracepoint_func {
    pub func: *mut core::ffi::c_void,
    pub data: *mut core::ffi::c_void,
    pub prio: core::ffi::c_int,
}
impl Default for tracepoint_func {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tracepoint {
    pub name: *const core::ffi::c_char,
    pub key: static_key,
    pub static_call_key: *mut static_call_key,
    pub static_call_tramp: *mut core::ffi::c_void,
    pub iterator: *mut core::ffi::c_void,
    pub probestub: *mut core::ffi::c_void,
    pub regfunc: ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_int>,
    pub unregfunc: ::core::option::Option<unsafe extern "C" fn()>,
    pub funcs: *mut tracepoint_func,
}
impl Default for tracepoint {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type tracepoint_ptr_t = core::ffi::c_int;
#[repr(C)]
#[repr(align(32))]
#[derive(Copy, Clone)]
pub struct bpf_raw_event_map {
    pub tp: *mut tracepoint,
    pub bpf_func: *mut core::ffi::c_void,
    pub num_args: u32_,
    pub writable_size: u32_,
}
impl Default for bpf_raw_event_map {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut __tracepoint_read_msr: tracepoint;
}
extern "C" {
    pub static mut __tracepoint_write_msr: tracepoint;
}
extern "C" {
    pub static mut __tracepoint_rdpmc: tracepoint;
}
extern "C" {
    pub fn do_trace_write_msr(msr: core::ffi::c_uint, val: u64_, failed: core::ffi::c_int);
}
extern "C" {
    pub fn do_trace_read_msr(msr: core::ffi::c_uint, val: u64_, failed: core::ffi::c_int);
}
extern "C" {
    pub fn do_trace_rdpmc(msr: core::ffi::c_uint, val: u64_, failed: core::ffi::c_int);
}
extern "C" {
    pub fn rdmsr_safe_regs(regs: *mut u32_) -> core::ffi::c_int;
}
extern "C" {
    pub fn wrmsr_safe_regs(regs: *mut u32_) -> core::ffi::c_int;
}
extern "C" {
    pub fn msrs_alloc() -> *mut msr;
}
extern "C" {
    pub fn msrs_free(msrs: *mut msr);
}
extern "C" {
    pub fn msr_set_bit(msr: u32_, bit: u8_) -> core::ffi::c_int;
}
extern "C" {
    pub fn msr_clear_bit(msr: u32_, bit: u8_) -> core::ffi::c_int;
}
extern "C" {
    pub fn rdmsr_on_cpu(
        cpu: core::ffi::c_uint,
        msr_no: u32_,
        l: *mut u32_,
        h: *mut u32_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn wrmsr_on_cpu(cpu: core::ffi::c_uint, msr_no: u32_, l: u32_, h: u32_)
        -> core::ffi::c_int;
}
extern "C" {
    pub fn rdmsrl_on_cpu(cpu: core::ffi::c_uint, msr_no: u32_, q: *mut u64_) -> core::ffi::c_int;
}
extern "C" {
    pub fn wrmsrl_on_cpu(cpu: core::ffi::c_uint, msr_no: u32_, q: u64_) -> core::ffi::c_int;
}
extern "C" {
    pub fn rdmsr_on_cpus(mask: *const cpumask, msr_no: u32_, msrs: *mut msr);
}
extern "C" {
    pub fn wrmsr_on_cpus(mask: *const cpumask, msr_no: u32_, msrs: *mut msr);
}
extern "C" {
    pub fn rdmsr_safe_on_cpu(
        cpu: core::ffi::c_uint,
        msr_no: u32_,
        l: *mut u32_,
        h: *mut u32_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn wrmsr_safe_on_cpu(
        cpu: core::ffi::c_uint,
        msr_no: u32_,
        l: u32_,
        h: u32_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn rdmsrl_safe_on_cpu(
        cpu: core::ffi::c_uint,
        msr_no: u32_,
        q: *mut u64_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn wrmsrl_safe_on_cpu(cpu: core::ffi::c_uint, msr_no: u32_, q: u64_) -> core::ffi::c_int;
}
extern "C" {
    pub fn rdmsr_safe_regs_on_cpu(cpu: core::ffi::c_uint, regs: *mut u32_) -> core::ffi::c_int;
}
extern "C" {
    pub fn wrmsr_safe_regs_on_cpu(cpu: core::ffi::c_uint, regs: *mut u32_) -> core::ffi::c_int;
}
extern "C" {
    pub fn native_write_cr0(val: core::ffi::c_ulong);
}
extern "C" {
    pub fn native_write_cr4(val: core::ffi::c_ulong);
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct fregs_state {
    pub cwd: u32_,
    pub swd: u32_,
    pub twd: u32_,
    pub fip: u32_,
    pub fcs: u32_,
    pub foo: u32_,
    pub fos: u32_,
    pub st_space: [u32_; 20usize],
    pub status: u32_,
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct fxregs_state {
    pub cwd: u16_,
    pub swd: u16_,
    pub twd: u16_,
    pub fop: u16_,
    pub __bindgen_anon_1: fxregs_state__bindgen_ty_1,
    pub mxcsr: u32_,
    pub mxcsr_mask: u32_,
    pub st_space: [u32_; 32usize],
    pub xmm_space: [u32_; 64usize],
    pub padding: [u32_; 12usize],
    pub __bindgen_anon_2: fxregs_state__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union fxregs_state__bindgen_ty_1 {
    pub __bindgen_anon_1: fxregs_state__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: fxregs_state__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct fxregs_state__bindgen_ty_1__bindgen_ty_1 {
    pub rip: u64_,
    pub rdp: u64_,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct fxregs_state__bindgen_ty_1__bindgen_ty_2 {
    pub fip: u32_,
    pub fcs: u32_,
    pub foo: u32_,
    pub fos: u32_,
}
impl Default for fxregs_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union fxregs_state__bindgen_ty_2 {
    pub padding1: [u32_; 12usize],
    pub sw_reserved: [u32_; 12usize],
}
impl Default for fxregs_state__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for fxregs_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct swregs_state {
    pub cwd: u32_,
    pub swd: u32_,
    pub twd: u32_,
    pub fip: u32_,
    pub fcs: u32_,
    pub foo: u32_,
    pub fos: u32_,
    pub st_space: [u32_; 20usize],
    pub ftop: u8_,
    pub changed: u8_,
    pub lookahead: u8_,
    pub no_update: u8_,
    pub rm: u8_,
    pub alimit: u8_,
    pub info: *mut math_emu_info,
    pub entry_eip: u32_,
}
impl Default for swregs_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const xfeature_XFEATURE_FP: xfeature = 0;
pub const xfeature_XFEATURE_SSE: xfeature = 1;
pub const xfeature_XFEATURE_YMM: xfeature = 2;
pub const xfeature_XFEATURE_BNDREGS: xfeature = 3;
pub const xfeature_XFEATURE_BNDCSR: xfeature = 4;
pub const xfeature_XFEATURE_OPMASK: xfeature = 5;
pub const xfeature_XFEATURE_ZMM_Hi256: xfeature = 6;
pub const xfeature_XFEATURE_Hi16_ZMM: xfeature = 7;
pub const xfeature_XFEATURE_PT_UNIMPLEMENTED_SO_FAR: xfeature = 8;
pub const xfeature_XFEATURE_PKRU: xfeature = 9;
pub const xfeature_XFEATURE_PASID: xfeature = 10;
pub const xfeature_XFEATURE_CET_USER: xfeature = 11;
pub const xfeature_XFEATURE_CET_KERNEL_UNUSED: xfeature = 12;
pub const xfeature_XFEATURE_RSRVD_COMP_13: xfeature = 13;
pub const xfeature_XFEATURE_RSRVD_COMP_14: xfeature = 14;
pub const xfeature_XFEATURE_LBR: xfeature = 15;
pub const xfeature_XFEATURE_RSRVD_COMP_16: xfeature = 16;
pub const xfeature_XFEATURE_XTILE_CFG: xfeature = 17;
pub const xfeature_XFEATURE_XTILE_DATA: xfeature = 18;
pub const xfeature_XFEATURE_MAX: xfeature = 19;
pub type xfeature = core::ffi::c_uint;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct reg_128_bit {
    pub regbytes: [u8_; 16usize],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct reg_256_bit {
    pub regbytes: [u8_; 32usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct reg_512_bit {
    pub regbytes: [u8_; 64usize],
}
impl Default for reg_512_bit {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct reg_1024_byte {
    pub regbytes: [u8_; 1024usize],
}
impl Default for reg_1024_byte {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct ymmh_struct {
    pub hi_ymm: [reg_128_bit; 16usize],
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct mpx_bndreg {
    pub lower_bound: u64_,
    pub upper_bound: u64_,
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct mpx_bndreg_state {
    pub bndreg: [mpx_bndreg; 4usize],
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct mpx_bndcsr {
    pub bndcfgu: u64_,
    pub bndstatus: u64_,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct mpx_bndcsr_state {
    pub __bindgen_anon_1: mpx_bndcsr_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mpx_bndcsr_state__bindgen_ty_1 {
    pub bndcsr: mpx_bndcsr,
    pub pad_to_64_bytes: [u8_; 64usize],
}
impl Default for mpx_bndcsr_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for mpx_bndcsr_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct avx_512_opmask_state {
    pub opmask_reg: [u64_; 8usize],
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct avx_512_zmm_uppers_state {
    pub zmm_upper: [reg_256_bit; 16usize],
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct avx_512_hi16_state {
    pub hi16_zmm: [reg_512_bit; 16usize],
}
impl Default for avx_512_hi16_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct pkru_state {
    pub pkru: u32_,
    pub pad: u32_,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct cet_user_state {
    pub user_cet: u64_,
    pub user_ssp: u64_,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct lbr_entry {
    pub from: u64_,
    pub to: u64_,
    pub info: u64_,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Default, Copy, Clone)]
pub struct arch_lbr_state {
    pub _bindgen_opaque_blob: [u64; 5usize],
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct xtile_cfg {
    pub tcfg: [u64_; 8usize],
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct xtile_data {
    pub tmm: reg_1024_byte,
}
impl Default for xtile_data {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct ia32_pasid_state {
    pub pasid: u64_,
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct xstate_header {
    pub xfeatures: u64_,
    pub xcomp_bv: u64_,
    pub reserved: [u64_; 6usize],
}
#[repr(C)]
#[repr(align(64))]
pub struct xregs_state {
    pub _bindgen_opaque_blob: [u8; 576usize],
}
impl Default for xregs_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
pub struct fpregs_state {
    pub fsave: __BindgenUnionField<fregs_state>,
    pub fxsave: __BindgenUnionField<fxregs_state>,
    pub soft: __BindgenUnionField<swregs_state>,
    pub xsave: __BindgenUnionField<xregs_state>,
    pub __padding: __BindgenUnionField<[u8_; 4096usize]>,
    pub bindgen_union_field: [u8; 4096usize],
}
impl Default for fpregs_state {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
pub struct fpstate {
    pub size: core::ffi::c_uint,
    pub user_size: core::ffi::c_uint,
    pub xfeatures: u64_,
    pub user_xfeatures: u64_,
    pub xfd: u64_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u64; 3usize],
    pub regs: fpregs_state,
}
impl Default for fpstate {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl fpstate {
    #[inline]
    pub fn is_valloc(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_valloc(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_guest(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_guest(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_confidential(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_confidential(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn in_use(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_in_use(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_valloc: core::ffi::c_uint,
        is_guest: core::ffi::c_uint,
        is_confidential: core::ffi::c_uint,
        in_use: core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_valloc: u32 = unsafe { ::core::mem::transmute(is_valloc) };
            is_valloc as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_guest: u32 = unsafe { ::core::mem::transmute(is_guest) };
            is_guest as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_confidential: u32 = unsafe { ::core::mem::transmute(is_confidential) };
            is_confidential as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let in_use: u32 = unsafe { ::core::mem::transmute(in_use) };
            in_use as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct fpu_state_perm {
    pub __state_perm: u64_,
    pub __state_size: core::ffi::c_uint,
    pub __user_state_size: core::ffi::c_uint,
}
#[repr(C)]
#[repr(align(64))]
pub struct fpu {
    pub last_cpu: core::ffi::c_uint,
    pub avx512_timestamp: core::ffi::c_ulong,
    pub fpstate: *mut fpstate,
    pub __task_fpstate: *mut fpstate,
    pub perm: fpu_state_perm,
    pub guest_perm: fpu_state_perm,
    pub __fpstate: fpstate,
}
impl Default for fpu {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fpu_guest {
    pub xfeatures: u64_,
    pub perm: u64_,
    pub xfd_err: u64_,
    pub uabi_size: core::ffi::c_uint,
    pub fpstate: *mut fpstate,
}
impl Default for fpu_guest {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct fpu_state_config {
    pub max_size: core::ffi::c_uint,
    pub default_size: core::ffi::c_uint,
    pub max_features: u64_,
    pub default_features: u64_,
    pub legacy_features: u64_,
    pub independent_features: u64_,
}
extern "C" {
    pub static mut fpu_kernel_cfg: fpu_state_config;
}
extern "C" {
    pub static mut fpu_user_cfg: fpu_state_config;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct getcpu_cache {
    _unused: [u8; 0],
}
extern "C" {
    pub fn __vdso_getcpu(
        cpu: *mut core::ffi::c_uint,
        node: *mut core::ffi::c_uint,
        unused: *mut getcpu_cache,
    ) -> core::ffi::c_long;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct thread_shstk {
    pub base: u64_,
    pub size: u64_,
}
extern "C" {
    pub fn shstk_prctl(
        task: *mut task_struct,
        option: core::ffi::c_int,
        arg2: core::ffi::c_ulong,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn reset_thread_features();
}
extern "C" {
    pub fn shstk_alloc_thread_stack(
        p: *mut task_struct,
        clone_flags: core::ffi::c_ulong,
        stack_size: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn shstk_free(p: *mut task_struct);
}
extern "C" {
    pub fn setup_signal_shadow_stack(ksig: *mut ksignal) -> core::ffi::c_int;
}
extern "C" {
    pub fn restore_signal_shadow_stack() -> core::ffi::c_int;
}
extern "C" {
    pub fn shstk_update_last_frame(val: core::ffi::c_ulong) -> core::ffi::c_int;
}
pub const UNAME26: _bindgen_ty_6 = 131072;
pub const ADDR_NO_RANDOMIZE: _bindgen_ty_6 = 262144;
pub const FDPIC_FUNCPTRS: _bindgen_ty_6 = 524288;
pub const MMAP_PAGE_ZERO: _bindgen_ty_6 = 1048576;
pub const ADDR_COMPAT_LAYOUT: _bindgen_ty_6 = 2097152;
pub const READ_IMPLIES_EXEC: _bindgen_ty_6 = 4194304;
pub const ADDR_LIMIT_32BIT: _bindgen_ty_6 = 8388608;
pub const SHORT_INODE: _bindgen_ty_6 = 16777216;
pub const WHOLE_SECONDS: _bindgen_ty_6 = 33554432;
pub const STICKY_TIMEOUTS: _bindgen_ty_6 = 67108864;
pub const ADDR_LIMIT_3GB: _bindgen_ty_6 = 134217728;
pub type _bindgen_ty_6 = core::ffi::c_uint;
pub const PER_LINUX: _bindgen_ty_7 = 0;
pub const PER_LINUX_32BIT: _bindgen_ty_7 = 8388608;
pub const PER_LINUX_FDPIC: _bindgen_ty_7 = 524288;
pub const PER_SVR4: _bindgen_ty_7 = 68157441;
pub const PER_SVR3: _bindgen_ty_7 = 83886082;
pub const PER_SCOSVR3: _bindgen_ty_7 = 117440515;
pub const PER_OSR5: _bindgen_ty_7 = 100663299;
pub const PER_WYSEV386: _bindgen_ty_7 = 83886084;
pub const PER_ISCR4: _bindgen_ty_7 = 67108869;
pub const PER_BSD: _bindgen_ty_7 = 6;
pub const PER_SUNOS: _bindgen_ty_7 = 67108870;
pub const PER_XENIX: _bindgen_ty_7 = 83886087;
pub const PER_LINUX32: _bindgen_ty_7 = 8;
pub const PER_LINUX32_3GB: _bindgen_ty_7 = 134217736;
pub const PER_IRIX32: _bindgen_ty_7 = 67108873;
pub const PER_IRIXN32: _bindgen_ty_7 = 67108874;
pub const PER_IRIX64: _bindgen_ty_7 = 67108875;
pub const PER_RISCOS: _bindgen_ty_7 = 12;
pub const PER_SOLARIS: _bindgen_ty_7 = 67108877;
pub const PER_UW7: _bindgen_ty_7 = 68157454;
pub const PER_OSF4: _bindgen_ty_7 = 15;
pub const PER_HPUX: _bindgen_ty_7 = 16;
pub const PER_MASK: _bindgen_ty_7 = 255;
pub type _bindgen_ty_7 = core::ffi::c_uint;
extern "C" {
    pub fn iter_div_u64_rem(dividend: u64_, divisor: u32_, remainder: *mut u64_) -> u32_;
}
pub const tlb_infos_ENTRIES: tlb_infos = 0;
pub const tlb_infos_NR_INFO: tlb_infos = 1;
pub type tlb_infos = core::ffi::c_uint;
extern "C" {
    pub static mut tlb_lli_4k: [u16_; 1usize];
}
extern "C" {
    pub static mut tlb_lli_2m: [u16_; 1usize];
}
extern "C" {
    pub static mut tlb_lli_4m: [u16_; 1usize];
}
extern "C" {
    pub static mut tlb_lld_4k: [u16_; 1usize];
}
extern "C" {
    pub static mut tlb_lld_2m: [u16_; 1usize];
}
extern "C" {
    pub static mut tlb_lld_4m: [u16_; 1usize];
}
extern "C" {
    pub static mut tlb_lld_1g: [u16_; 1usize];
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct cpuinfo_topology {
    pub apicid: u32_,
    pub initial_apicid: u32_,
    pub pkg_id: u32_,
    pub die_id: u32_,
    pub cu_id: u32_,
    pub core_id: u32_,
    pub logical_pkg_id: u32_,
    pub logical_die_id: u32_,
    pub llc_id: u32_,
    pub l2c_id: u32_,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cpuinfo_x86 {
    pub __bindgen_anon_1: cpuinfo_x86__bindgen_ty_1,
    pub x86_stepping: __u8,
    pub x86_tlbsize: core::ffi::c_int,
    pub vmx_capability: [__u32; 5usize],
    pub x86_virt_bits: __u8,
    pub x86_phys_bits: __u8,
    pub x86_coreid_bits: __u8,
    pub extended_cpuid_level: __u32,
    pub cpuid_level: core::ffi::c_int,
    pub __bindgen_anon_2: cpuinfo_x86__bindgen_ty_2,
    pub x86_vendor_id: [core::ffi::c_char; 16usize],
    pub x86_model_id: [core::ffi::c_char; 64usize],
    pub topo: cpuinfo_topology,
    pub x86_cache_size: core::ffi::c_uint,
    pub x86_cache_alignment: core::ffi::c_int,
    pub x86_cache_max_rmid: core::ffi::c_int,
    pub x86_cache_occ_scale: core::ffi::c_int,
    pub x86_cache_mbm_width_offset: core::ffi::c_int,
    pub x86_power: core::ffi::c_int,
    pub loops_per_jiffy: core::ffi::c_ulong,
    pub ppin: u64_,
    pub x86_max_cores: u16_,
    pub x86_clflush_size: u16_,
    pub booted_cores: u16_,
    pub cpu_index: u16_,
    pub smt_active: bool_,
    pub microcode: u32_,
    pub x86_cache_bits: u8_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u16; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpuinfo_x86__bindgen_ty_1 {
    pub __bindgen_anon_1: cpuinfo_x86__bindgen_ty_1__bindgen_ty_1,
    pub x86_vfm: __u32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct cpuinfo_x86__bindgen_ty_1__bindgen_ty_1 {
    pub x86_model: __u8,
    pub x86: __u8,
    pub x86_vendor: __u8,
    pub x86_reserved: __u8,
}
impl Default for cpuinfo_x86__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpuinfo_x86__bindgen_ty_2 {
    pub x86_capability: [__u32; 24usize],
    pub x86_capability_alignment: core::ffi::c_ulong,
}
impl Default for cpuinfo_x86__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for cpuinfo_x86 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl cpuinfo_x86 {
    #[inline]
    pub fn initialized(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_initialized(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(initialized: core::ffi::c_uint) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let initialized: u32 = unsafe { ::core::mem::transmute(initialized) };
            initialized as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub static mut boot_cpu_data: cpuinfo_x86;
}
extern "C" {
    pub static mut new_cpu_data: cpuinfo_x86;
}
extern "C" {
    pub static mut cpu_caps_cleared: [__u32; 24usize];
}
extern "C" {
    pub static mut cpu_caps_set: [__u32; 24usize];
}
extern "C" {
    pub static mut cpu_info: cpuinfo_x86;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct seq_operations {
    _unused: [u8; 0],
}
extern "C" {
    pub static cpuinfo_op: seq_operations;
}
extern "C" {
    pub fn cpu_detect(c: *mut cpuinfo_x86);
}
extern "C" {
    pub fn early_cpu_init();
}
extern "C" {
    pub fn identify_secondary_cpu(arg1: *mut cpuinfo_x86);
}
extern "C" {
    pub fn print_cpu_info(arg1: *mut cpuinfo_x86);
}
extern "C" {
    pub fn print_cpu_msr(arg1: *mut cpuinfo_x86);
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct x86_hw_tss {
    pub reserved1: u32_,
    pub sp0: u64_,
    pub sp1: u64_,
    pub sp2: u64_,
    pub reserved2: u64_,
    pub ist: [u64_; 7usize],
    pub reserved3: u32_,
    pub reserved4: u32_,
    pub reserved5: u16_,
    pub io_bitmap_base: u16_,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct entry_stack {
    pub stack: [core::ffi::c_char; 4096usize],
}
impl Default for entry_stack {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(4096))]
#[derive(Copy, Clone)]
pub struct entry_stack_page {
    pub stack: entry_stack,
}
impl Default for entry_stack_page {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_io_bitmap {
    pub prev_sequence: u64_,
    pub prev_max: core::ffi::c_uint,
    pub bitmap: [core::ffi::c_ulong; 1025usize],
    pub mapall: [core::ffi::c_ulong; 1025usize],
}
impl Default for x86_io_bitmap {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(4096))]
#[derive(Copy, Clone)]
pub struct tss_struct {
    pub x86_tss: x86_hw_tss,
    pub io_bitmap: x86_io_bitmap,
}
impl Default for tss_struct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut cpu_tss_rw: tss_struct;
}
#[repr(C)]
#[repr(align(16384))]
#[derive(Copy, Clone)]
pub struct irq_stack {
    pub stack: [core::ffi::c_char; 16384usize],
}
impl Default for irq_stack {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fixed_percpu_data {
    pub gs_base: [core::ffi::c_char; 40usize],
    pub stack_canary: core::ffi::c_ulong,
}
impl Default for fixed_percpu_data {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut fixed_percpu_data: fixed_percpu_data;
}
extern "C" {
    pub static mut init_per_cpu__fixed_percpu_data: fixed_percpu_data;
}
extern "C" {
    pub fn entry_SYSCALL32_ignore();
}
extern "C" {
    pub fn current_save_fsgs();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct perf_event {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(64))]
pub struct thread_struct {
    pub tls_array: [desc_struct; 3usize],
    pub sp: core::ffi::c_ulong,
    pub es: core::ffi::c_ushort,
    pub ds: core::ffi::c_ushort,
    pub fsindex: core::ffi::c_ushort,
    pub gsindex: core::ffi::c_ushort,
    pub fsbase: core::ffi::c_ulong,
    pub gsbase: core::ffi::c_ulong,
    pub ptrace_bps: [*mut perf_event; 4usize],
    pub virtual_dr6: core::ffi::c_ulong,
    pub ptrace_dr7: core::ffi::c_ulong,
    pub cr2: core::ffi::c_ulong,
    pub trap_nr: core::ffi::c_ulong,
    pub error_code: core::ffi::c_ulong,
    pub io_bitmap: *mut io_bitmap,
    pub iopl_emul: core::ffi::c_ulong,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub pkru: u32_,
    pub features: core::ffi::c_ulong,
    pub features_locked: core::ffi::c_ulong,
    pub shstk: thread_shstk,
    pub __bindgen_padding_0: u64,
    pub fpu: fpu,
}
impl Default for thread_struct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl thread_struct {
    #[inline]
    pub fn iopl_warn(&self) -> core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_iopl_warn(&mut self, val: core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(iopl_warn: core::ffi::c_uint) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let iopl_warn: u32 = unsafe { ::core::mem::transmute(iopl_warn) };
            iopl_warn as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn fpu_thread_struct_whitelist(
        offset: *mut core::ffi::c_ulong,
        size: *mut core::ffi::c_ulong,
    );
}
extern "C" {
    pub fn __get_wchan(p: *mut task_struct) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn select_idle_routine(c: *const cpuinfo_x86);
}
extern "C" {
    pub fn amd_e400_c1e_apic_setup();
}
extern "C" {
    pub static mut boot_option_idle_override: core::ffi::c_ulong;
}
pub const idle_boot_override_IDLE_NO_OVERRIDE: idle_boot_override = 0;
pub const idle_boot_override_IDLE_HALT: idle_boot_override = 1;
pub const idle_boot_override_IDLE_NOMWAIT: idle_boot_override = 2;
pub const idle_boot_override_IDLE_POLL: idle_boot_override = 3;
pub type idle_boot_override = core::ffi::c_uint;
extern "C" {
    pub fn enable_sep_cpu();
}
extern "C" {
    pub static mut early_gdt_descr: desc_ptr;
}
extern "C" {
    pub fn switch_gdt_and_percpu_base(arg1: core::ffi::c_int);
}
extern "C" {
    pub fn load_direct_gdt(arg1: core::ffi::c_int);
}
extern "C" {
    pub fn load_fixmap_gdt(arg1: core::ffi::c_int);
}
extern "C" {
    pub fn cpu_init();
}
extern "C" {
    pub fn cpu_init_exception_handling();
}
extern "C" {
    pub fn cr4_init();
}
extern "C" {
    pub fn set_task_blockstep(task: *mut task_struct, on: bool_);
}
extern "C" {
    pub static mut bootloader_type: core::ffi::c_int;
}
extern "C" {
    pub static mut bootloader_version: core::ffi::c_int;
}
extern "C" {
    pub static mut ignore_fpu_irq: core::ffi::c_char;
}
extern "C" {
    pub static mut __end_init_task: [core::ffi::c_ulong; 0usize];
}
extern "C" {
    pub fn KSTK_ESP(task: *mut task_struct) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn start_thread(regs: *mut pt_regs, new_ip: core::ffi::c_ulong, new_sp: core::ffi::c_ulong);
}
extern "C" {
    pub fn get_tsc_mode(adr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub fn set_tsc_mode(val: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub static mut msr_misc_features_shadow: core::ffi::c_ulonglong;
}
extern "C" {
    pub fn amd_get_nodes_per_socket() -> u32_;
}
extern "C" {
    pub fn amd_get_highest_perf() -> u32_;
}
extern "C" {
    pub fn amd_clear_divider();
}
extern "C" {
    pub fn amd_check_microcode();
}
extern "C" {
    pub fn arch_align_stack(sp: core::ffi::c_ulong) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn free_init_pages(
        what: *const core::ffi::c_char,
        begin: core::ffi::c_ulong,
        end: core::ffi::c_ulong,
    );
}
extern "C" {
    pub fn free_kernel_image_pages(
        what: *const core::ffi::c_char,
        begin: *mut core::ffi::c_void,
        end: *mut core::ffi::c_void,
    );
}
extern "C" {
    pub fn default_idle();
}
extern "C" {
    pub fn xen_set_default_idle() -> bool_;
}
extern "C" {
    pub fn stop_this_cpu(dummy: *mut core::ffi::c_void) -> !;
}
extern "C" {
    pub fn microcode_check(prev_info: *mut cpuinfo_x86);
}
extern "C" {
    pub fn store_cpu_caps(info: *mut cpuinfo_x86);
}
pub const l1tf_mitigations_L1TF_MITIGATION_OFF: l1tf_mitigations = 0;
pub const l1tf_mitigations_L1TF_MITIGATION_FLUSH_NOWARN: l1tf_mitigations = 1;
pub const l1tf_mitigations_L1TF_MITIGATION_FLUSH: l1tf_mitigations = 2;
pub const l1tf_mitigations_L1TF_MITIGATION_FLUSH_NOSMT: l1tf_mitigations = 3;
pub const l1tf_mitigations_L1TF_MITIGATION_FULL: l1tf_mitigations = 4;
pub const l1tf_mitigations_L1TF_MITIGATION_FULL_FORCE: l1tf_mitigations = 5;
pub type l1tf_mitigations = core::ffi::c_uint;
extern "C" {
    pub static mut l1tf_mitigation: l1tf_mitigations;
}
pub const mds_mitigations_MDS_MITIGATION_OFF: mds_mitigations = 0;
pub const mds_mitigations_MDS_MITIGATION_FULL: mds_mitigations = 1;
pub const mds_mitigations_MDS_MITIGATION_VMWERV: mds_mitigations = 2;
pub type mds_mitigations = core::ffi::c_uint;
extern "C" {
    pub fn gds_ucode_mitigated() -> bool_;
}
pub const cpuid_leafs_CPUID_1_EDX: cpuid_leafs = 0;
pub const cpuid_leafs_CPUID_8000_0001_EDX: cpuid_leafs = 1;
pub const cpuid_leafs_CPUID_8086_0001_EDX: cpuid_leafs = 2;
pub const cpuid_leafs_CPUID_LNX_1: cpuid_leafs = 3;
pub const cpuid_leafs_CPUID_1_ECX: cpuid_leafs = 4;
pub const cpuid_leafs_CPUID_C000_0001_EDX: cpuid_leafs = 5;
pub const cpuid_leafs_CPUID_8000_0001_ECX: cpuid_leafs = 6;
pub const cpuid_leafs_CPUID_LNX_2: cpuid_leafs = 7;
pub const cpuid_leafs_CPUID_LNX_3: cpuid_leafs = 8;
pub const cpuid_leafs_CPUID_7_0_EBX: cpuid_leafs = 9;
pub const cpuid_leafs_CPUID_D_1_EAX: cpuid_leafs = 10;
pub const cpuid_leafs_CPUID_LNX_4: cpuid_leafs = 11;
pub const cpuid_leafs_CPUID_7_1_EAX: cpuid_leafs = 12;
pub const cpuid_leafs_CPUID_8000_0008_EBX: cpuid_leafs = 13;
pub const cpuid_leafs_CPUID_6_EAX: cpuid_leafs = 14;
pub const cpuid_leafs_CPUID_8000_000A_EDX: cpuid_leafs = 15;
pub const cpuid_leafs_CPUID_7_ECX: cpuid_leafs = 16;
pub const cpuid_leafs_CPUID_8000_0007_EBX: cpuid_leafs = 17;
pub const cpuid_leafs_CPUID_7_EDX: cpuid_leafs = 18;
pub const cpuid_leafs_CPUID_8000_001F_EAX: cpuid_leafs = 19;
pub const cpuid_leafs_CPUID_8000_0021_EAX: cpuid_leafs = 20;
pub const cpuid_leafs_CPUID_LNX_5: cpuid_leafs = 21;
pub const cpuid_leafs_NR_CPUID_WORDS: cpuid_leafs = 22;
pub type cpuid_leafs = core::ffi::c_uint;
extern "C" {
    pub static x86_cap_flags: [*const core::ffi::c_char; 704usize];
}
extern "C" {
    pub static x86_power_flags: [*const core::ffi::c_char; 32usize];
}
extern "C" {
    pub static x86_bug_flags: [*const core::ffi::c_char; 64usize];
}
extern "C" {
    pub fn setup_clear_cpu_cap(bit: core::ffi::c_uint);
}
extern "C" {
    pub fn clear_cpu_cap(c: *mut cpuinfo_x86, bit: core::ffi::c_uint);
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct thread_info {
    pub flags: core::ffi::c_ulong,
    pub syscall_work: core::ffi::c_ulong,
    pub status: u32_,
    pub cpu: u32_,
}
extern "C" {
    pub fn arch_setup_new_exec();
}
extern "C" {
    pub fn __check_object_size(
        ptr: *const core::ffi::c_void,
        n: core::ffi::c_ulong,
        to_user: bool_,
    );
}
extern "C" {
    pub fn __bad_copy_from();
}
extern "C" {
    pub fn __bad_copy_to();
}
extern "C" {
    pub fn __copy_overflow(size: core::ffi::c_int, count: core::ffi::c_ulong);
}
extern "C" {
    pub fn arch_task_cache_init();
}
extern "C" {
    pub fn arch_release_task_struct(tsk: *mut task_struct);
}
extern "C" {
    pub fn arch_dup_task_struct(dst: *mut task_struct, src: *mut task_struct) -> core::ffi::c_int;
}
extern "C" {
    pub fn _local_bh_enable();
}
extern "C" {
    pub fn __local_bh_enable_ip(ip: core::ffi::c_ulong, cnt: core::ffi::c_uint);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct llist_head {
    pub first: *mut llist_node,
}
impl Default for llist_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct llist_node {
    pub next: *mut llist_node,
}
impl Default for llist_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn llist_add_batch(
        new_first: *mut llist_node,
        new_last: *mut llist_node,
        head: *mut llist_head,
    ) -> bool_;
}
extern "C" {
    pub fn llist_del_first(head: *mut llist_head) -> *mut llist_node;
}
extern "C" {
    pub fn llist_del_first_this(head: *mut llist_head, this: *mut llist_node) -> bool_;
}
extern "C" {
    pub fn llist_reverse_order(head: *mut llist_node) -> *mut llist_node;
}
pub const CSD_FLAG_LOCK: _bindgen_ty_8 = 1;
pub const IRQ_WORK_PENDING: _bindgen_ty_8 = 1;
pub const IRQ_WORK_BUSY: _bindgen_ty_8 = 2;
pub const IRQ_WORK_LAZY: _bindgen_ty_8 = 4;
pub const IRQ_WORK_HARD_IRQ: _bindgen_ty_8 = 8;
pub const IRQ_WORK_CLAIMED: _bindgen_ty_8 = 3;
pub const CSD_TYPE_ASYNC: _bindgen_ty_8 = 0;
pub const CSD_TYPE_SYNC: _bindgen_ty_8 = 16;
pub const CSD_TYPE_IRQ_WORK: _bindgen_ty_8 = 32;
pub const CSD_TYPE_TTWU: _bindgen_ty_8 = 48;
pub const CSD_FLAG_TYPE_MASK: _bindgen_ty_8 = 240;
pub type _bindgen_ty_8 = core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __call_single_node {
    pub llist: llist_node,
    pub __bindgen_anon_1: __call_single_node__bindgen_ty_1,
    pub src: u16_,
    pub dst: u16_,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __call_single_node__bindgen_ty_1 {
    pub u_flags: core::ffi::c_uint,
    pub a_flags: atomic_t,
}
impl Default for __call_single_node__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for __call_single_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type smp_call_func_t =
    ::core::option::Option<unsafe extern "C" fn(info: *mut core::ffi::c_void)>;
pub type smp_cond_func_t = ::core::option::Option<
    unsafe extern "C" fn(cpu: core::ffi::c_int, info: *mut core::ffi::c_void) -> bool_,
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __call_single_data {
    pub node: __call_single_node,
    pub func: smp_call_func_t,
    pub info: *mut core::ffi::c_void,
}
impl Default for __call_single_data {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type call_single_data_t = __call_single_data;
extern "C" {
    pub fn __smp_call_single_queue(cpu: core::ffi::c_int, node: *mut llist_node);
}
extern "C" {
    pub static mut total_cpus: core::ffi::c_uint;
}
extern "C" {
    pub fn smp_call_function_single(
        cpuid: core::ffi::c_int,
        func: smp_call_func_t,
        info: *mut core::ffi::c_void,
        wait: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn on_each_cpu_cond_mask(
        cond_func: smp_cond_func_t,
        func: smp_call_func_t,
        info: *mut core::ffi::c_void,
        wait: bool_,
        mask: *const cpumask,
    );
}
extern "C" {
    pub fn smp_call_function_single_async(
        cpu: core::ffi::c_int,
        csd: *mut call_single_data_t,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn panic_smp_self_stop() -> !;
}
extern "C" {
    pub fn nmi_panic_self_stop(regs: *mut pt_regs) -> !;
}
extern "C" {
    pub fn crash_smp_send_stop();
}
extern "C" {
    pub static mut smp_num_siblings: core::ffi::c_int;
}
extern "C" {
    pub static mut num_processors: core::ffi::c_uint;
}
extern "C" {
    pub static mut cpu_sibling_map: *mut cpumask;
}
extern "C" {
    pub static mut cpu_core_map: *mut cpumask;
}
extern "C" {
    pub static mut cpu_die_map: *mut cpumask;
}
extern "C" {
    pub static mut cpu_llc_shared_map: *mut cpumask;
}
extern "C" {
    pub static mut cpu_l2c_shared_map: *mut cpumask;
}
extern "C" {
    pub static mut x86_cpu_to_apicid: core::ffi::c_uint;
}
extern "C" {
    pub static mut x86_cpu_to_apicid_early_ptr: *mut core::ffi::c_uint;
}
extern "C" {
    pub static mut x86_cpu_to_apicid_early_map: [core::ffi::c_uint; 0usize];
}
extern "C" {
    pub static mut x86_cpu_to_acpiid: core::ffi::c_uint;
}
extern "C" {
    pub static mut x86_cpu_to_acpiid_early_ptr: *mut core::ffi::c_uint;
}
extern "C" {
    pub static mut x86_cpu_to_acpiid_early_map: [core::ffi::c_uint; 0usize];
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct smp_ops {
    pub smp_prepare_boot_cpu: ::core::option::Option<unsafe extern "C" fn()>,
    pub smp_prepare_cpus: ::core::option::Option<unsafe extern "C" fn(max_cpus: core::ffi::c_uint)>,
    pub smp_cpus_done: ::core::option::Option<unsafe extern "C" fn(max_cpus: core::ffi::c_uint)>,
    pub stop_other_cpus: ::core::option::Option<unsafe extern "C" fn(wait: core::ffi::c_int)>,
    pub crash_stop_other_cpus: ::core::option::Option<unsafe extern "C" fn()>,
    pub smp_send_reschedule: ::core::option::Option<unsafe extern "C" fn(cpu: core::ffi::c_int)>,
    pub cleanup_dead_cpu: ::core::option::Option<unsafe extern "C" fn(cpu: core::ffi::c_uint)>,
    pub poll_sync_state: ::core::option::Option<unsafe extern "C" fn()>,
    pub kick_ap_alive: ::core::option::Option<
        unsafe extern "C" fn(cpu: core::ffi::c_uint, tidle: *mut task_struct) -> core::ffi::c_int,
    >,
    pub cpu_disable: ::core::option::Option<unsafe extern "C" fn() -> core::ffi::c_int>,
    pub cpu_die: ::core::option::Option<unsafe extern "C" fn(cpu: core::ffi::c_uint)>,
    pub play_dead: ::core::option::Option<unsafe extern "C" fn()>,
    pub send_call_func_ipi: ::core::option::Option<unsafe extern "C" fn(mask: *const cpumask)>,
    pub send_call_func_single_ipi:
        ::core::option::Option<unsafe extern "C" fn(cpu: core::ffi::c_int)>,
}
extern "C" {
    pub fn set_cpu_sibling_map(cpu: core::ffi::c_int);
}
extern "C" {
    pub static mut smp_ops: smp_ops;
}
extern "C" {
    pub fn cpu_disable_common();
}
extern "C" {
    pub fn native_smp_prepare_boot_cpu();
}
extern "C" {
    pub fn smp_prepare_cpus_common();
}
extern "C" {
    pub fn native_smp_prepare_cpus(max_cpus: core::ffi::c_uint);
}
extern "C" {
    pub fn calculate_max_logical_packages();
}
extern "C" {
    pub fn native_smp_cpus_done(max_cpus: core::ffi::c_uint);
}
extern "C" {
    pub fn common_cpu_up(cpunum: core::ffi::c_uint, tidle: *mut task_struct) -> core::ffi::c_int;
}
extern "C" {
    pub fn native_kick_ap(cpu: core::ffi::c_uint, tidle: *mut task_struct) -> core::ffi::c_int;
}
extern "C" {
    pub fn native_cpu_disable() -> core::ffi::c_int;
}
extern "C" {
    pub fn hlt_play_dead() -> !;
}
extern "C" {
    pub fn native_play_dead();
}
extern "C" {
    pub fn play_dead_common();
}
extern "C" {
    pub fn wbinvd_on_cpu(cpu: core::ffi::c_int);
}
extern "C" {
    pub fn wbinvd_on_all_cpus() -> core::ffi::c_int;
}
extern "C" {
    pub fn smp_kick_mwait_play_dead();
}
extern "C" {
    pub fn native_smp_send_reschedule(cpu: core::ffi::c_int);
}
extern "C" {
    pub fn native_send_call_func_ipi(mask: *const cpumask);
}
extern "C" {
    pub fn native_send_call_func_single_ipi(cpu: core::ffi::c_int);
}
extern "C" {
    pub fn smp_store_cpu_info(id: core::ffi::c_int);
}
extern "C" {
    pub fn smp_reboot_interrupt();
}
extern "C" {
    pub fn smp_reschedule_interrupt(regs: *mut pt_regs);
}
extern "C" {
    pub fn smp_call_function_interrupt(regs: *mut pt_regs);
}
extern "C" {
    pub fn smp_call_function_single_interrupt(r: *mut pt_regs);
}
extern "C" {
    pub static mut disabled_cpus: core::ffi::c_uint;
}
extern "C" {
    pub static mut smpboot_control: core::ffi::c_uint;
}
extern "C" {
    pub static mut apic_mmio_base: core::ffi::c_ulong;
}
extern "C" {
    pub fn __cpu_up(cpunum: core::ffi::c_uint, tidle: *mut task_struct) -> core::ffi::c_int;
}
extern "C" {
    pub fn smp_call_function(
        func: smp_call_func_t,
        info: *mut core::ffi::c_void,
        wait: core::ffi::c_int,
    );
}
extern "C" {
    pub fn smp_call_function_many(
        mask: *const cpumask,
        func: smp_call_func_t,
        info: *mut core::ffi::c_void,
        wait: bool_,
    );
}
extern "C" {
    pub fn smp_call_function_any(
        mask: *const cpumask,
        func: smp_call_func_t,
        info: *mut core::ffi::c_void,
        wait: core::ffi::c_int,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn kick_all_cpus_sync();
}
extern "C" {
    pub fn wake_up_all_idle_cpus();
}
extern "C" {
    pub fn call_function_init();
}
extern "C" {
    pub fn generic_smp_call_function_single_interrupt();
}
extern "C" {
    pub static mut setup_max_cpus: core::ffi::c_uint;
}
extern "C" {
    pub fn setup_nr_cpu_ids();
}
extern "C" {
    pub fn smp_init();
}
extern "C" {
    pub static mut __boot_cpu_id: core::ffi::c_int;
}
extern "C" {
    pub fn arch_disable_smp_support();
}
extern "C" {
    pub fn arch_thaw_secondary_cpus_begin();
}
extern "C" {
    pub fn arch_thaw_secondary_cpus_end();
}
extern "C" {
    pub fn smp_setup_processor_id();
}
extern "C" {
    pub fn smp_call_on_cpu(
        cpu: core::ffi::c_uint,
        func: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut core::ffi::c_void) -> core::ffi::c_int,
        >,
        par: *mut core::ffi::c_void,
        phys: bool_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn smpcfd_prepare_cpu(cpu: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub fn smpcfd_dead_cpu(cpu: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub fn smpcfd_dying_cpu(cpu: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub fn lock_is_held(arg1: *const core::ffi::c_void) -> core::ffi::c_int;
}
extern "C" {
    pub fn lockdep_is_held(arg1: *const core::ffi::c_void) -> core::ffi::c_int;
}
pub const xhlock_context_t_XHLOCK_HARD: xhlock_context_t = 0;
pub const xhlock_context_t_XHLOCK_SOFT: xhlock_context_t = 1;
pub const xhlock_context_t_XHLOCK_CTX_NR: xhlock_context_t = 2;
pub type xhlock_context_t = core::ffi::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct spinlock {
    pub _bindgen_opaque_blob: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union spinlock__bindgen_ty_1 {
    pub rlock: raw_spinlock,
}
impl Default for spinlock__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type spinlock_t = spinlock;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rwlock_t {
    pub raw_lock: arch_rwlock_t,
}
impl Default for rwlock_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn native_queued_spin_lock_slowpath(lock: *mut qspinlock, val: u32_);
}
extern "C" {
    pub fn __pv_init_lock_hash();
}
extern "C" {
    pub fn __pv_queued_spin_lock_slowpath(lock: *mut qspinlock, val: u32_);
}
extern "C" {
    pub fn __raw_callee_save___pv_queued_spin_unlock(lock: *mut qspinlock);
}
extern "C" {
    pub static mut nopvspin: bool_;
}
extern "C" {
    pub static mut virt_spin_lock_key: static_key_false;
}
extern "C" {
    pub fn queued_read_lock_slowpath(lock: *mut qrwlock);
}
extern "C" {
    pub fn queued_write_lock_slowpath(lock: *mut qrwlock);
}
extern "C" {
    pub fn in_lock_functions(addr: core::ffi::c_ulong) -> core::ffi::c_int;
}
extern "C" {
    pub fn _raw_spin_lock(lock: *mut raw_spinlock_t);
}
extern "C" {
    pub fn _raw_spin_lock_nested(lock: *mut raw_spinlock_t, subclass: core::ffi::c_int);
}
extern "C" {
    pub fn _raw_spin_lock_nest_lock(lock: *mut raw_spinlock_t, map: *mut lockdep_map);
}
extern "C" {
    pub fn _raw_spin_lock_bh(lock: *mut raw_spinlock_t);
}
extern "C" {
    pub fn _raw_spin_lock_irq(lock: *mut raw_spinlock_t);
}
extern "C" {
    pub fn _raw_spin_lock_irqsave(lock: *mut raw_spinlock_t) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _raw_spin_lock_irqsave_nested(
        lock: *mut raw_spinlock_t,
        subclass: core::ffi::c_int,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _raw_spin_trylock(lock: *mut raw_spinlock_t) -> core::ffi::c_int;
}
extern "C" {
    pub fn _raw_spin_trylock_bh(lock: *mut raw_spinlock_t) -> core::ffi::c_int;
}
extern "C" {
    pub fn _raw_spin_unlock(lock: *mut raw_spinlock_t);
}
extern "C" {
    pub fn _raw_spin_unlock_bh(lock: *mut raw_spinlock_t);
}
extern "C" {
    pub fn _raw_spin_unlock_irq(lock: *mut raw_spinlock_t);
}
extern "C" {
    pub fn _raw_spin_unlock_irqrestore(lock: *mut raw_spinlock_t, flags: core::ffi::c_ulong);
}
extern "C" {
    pub fn _raw_read_lock(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_lock(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_lock_nested(lock: *mut rwlock_t, subclass: core::ffi::c_int);
}
extern "C" {
    pub fn _raw_read_lock_bh(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_lock_bh(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_read_lock_irq(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_lock_irq(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_read_lock_irqsave(lock: *mut rwlock_t) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _raw_write_lock_irqsave(lock: *mut rwlock_t) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn _raw_read_trylock(lock: *mut rwlock_t) -> core::ffi::c_int;
}
extern "C" {
    pub fn _raw_write_trylock(lock: *mut rwlock_t) -> core::ffi::c_int;
}
extern "C" {
    pub fn _raw_read_unlock(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_unlock(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_read_unlock_bh(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_unlock_bh(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_read_unlock_irq(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_write_unlock_irq(lock: *mut rwlock_t);
}
extern "C" {
    pub fn _raw_read_unlock_irqrestore(lock: *mut rwlock_t, flags: core::ffi::c_ulong);
}
extern "C" {
    pub fn _raw_write_unlock_irqrestore(lock: *mut rwlock_t, flags: core::ffi::c_ulong);
}
extern "C" {
    pub fn _atomic_dec_and_lock(atomic: *mut atomic_t, lock: *mut spinlock_t) -> core::ffi::c_int;
}
extern "C" {
    pub fn _atomic_dec_and_lock_irqsave(
        atomic: *mut atomic_t,
        lock: *mut spinlock_t,
        flags: *mut core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn _atomic_dec_and_raw_lock(
        atomic: *mut atomic_t,
        lock: *mut raw_spinlock_t,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn _atomic_dec_and_raw_lock_irqsave(
        atomic: *mut atomic_t,
        lock: *mut raw_spinlock_t,
        flags: *mut core::ffi::c_ulong,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __alloc_bucket_spinlocks(
        locks: *mut *mut spinlock_t,
        lock_mask: *mut core::ffi::c_uint,
        max_size: usize,
        cpu_mult: core::ffi::c_uint,
        gfp: gfp_t,
        name: *const core::ffi::c_char,
        key: *mut lock_class_key,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn free_bucket_spinlocks(locks: *mut spinlock_t);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_raw_spinlock_t {
    pub lock: *mut raw_spinlock_t,
}
impl Default for class_raw_spinlock_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type class_raw_spinlock_try_t = class_raw_spinlock_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_raw_spinlock_nested_t {
    pub lock: *mut raw_spinlock_t,
}
impl Default for class_raw_spinlock_nested_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_raw_spinlock_irq_t {
    pub lock: *mut raw_spinlock_t,
}
impl Default for class_raw_spinlock_irq_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type class_raw_spinlock_irq_try_t = class_raw_spinlock_irq_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_raw_spinlock_irqsave_t {
    pub lock: *mut raw_spinlock_t,
    pub flags: core::ffi::c_ulong,
}
impl Default for class_raw_spinlock_irqsave_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type class_raw_spinlock_irqsave_try_t = class_raw_spinlock_irqsave_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_spinlock_t {
    pub lock: *mut spinlock_t,
}
impl Default for class_spinlock_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type class_spinlock_try_t = class_spinlock_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_spinlock_irq_t {
    pub lock: *mut spinlock_t,
}
impl Default for class_spinlock_irq_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type class_spinlock_irq_try_t = class_spinlock_irq_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_spinlock_irqsave_t {
    pub lock: *mut spinlock_t,
    pub flags: core::ffi::c_ulong,
}
impl Default for class_spinlock_irqsave_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type class_spinlock_irqsave_try_t = class_spinlock_irqsave_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_read_lock_t {
    pub lock: *mut rwlock_t,
}
impl Default for class_read_lock_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_read_lock_irq_t {
    pub lock: *mut rwlock_t,
}
impl Default for class_read_lock_irq_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_read_lock_irqsave_t {
    pub lock: *mut rwlock_t,
    pub flags: core::ffi::c_ulong,
}
impl Default for class_read_lock_irqsave_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_write_lock_t {
    pub lock: *mut rwlock_t,
}
impl Default for class_write_lock_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_write_lock_irq_t {
    pub lock: *mut rwlock_t,
}
impl Default for class_write_lock_irq_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct class_write_lock_irqsave_t {
    pub lock: *mut rwlock_t,
    pub flags: core::ffi::c_ulong,
}
impl Default for class_write_lock_irqsave_t {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct refcount_struct {
    pub refs: atomic_t,
}
pub type refcount_t = refcount_struct;
pub const refcount_saturation_type_REFCOUNT_ADD_NOT_ZERO_OVF: refcount_saturation_type = 0;
pub const refcount_saturation_type_REFCOUNT_ADD_OVF: refcount_saturation_type = 1;
pub const refcount_saturation_type_REFCOUNT_ADD_UAF: refcount_saturation_type = 2;
pub const refcount_saturation_type_REFCOUNT_SUB_UAF: refcount_saturation_type = 3;
pub const refcount_saturation_type_REFCOUNT_DEC_LEAK: refcount_saturation_type = 4;
pub type refcount_saturation_type = core::ffi::c_uint;
extern "C" {
    pub fn refcount_warn_saturate(r: *mut refcount_t, t: refcount_saturation_type);
}
extern "C" {
    pub fn refcount_dec_if_one(r: *mut refcount_t) -> bool_;
}
extern "C" {
    pub fn refcount_dec_not_one(r: *mut refcount_t) -> bool_;
}
extern "C" {
    pub fn refcount_dec_and_mutex_lock(r: *mut refcount_t, lock: *mut mutex) -> bool_;
}
extern "C" {
    pub fn refcount_dec_and_lock(r: *mut refcount_t, lock: *mut spinlock_t) -> bool_;
}
extern "C" {
    pub fn refcount_dec_and_lock_irqsave(
        r: *mut refcount_t,
        lock: *mut spinlock_t,
        flags: *mut core::ffi::c_ulong,
    ) -> bool_;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kref {
    pub refcount: refcount_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct stat {
    pub st_dev: __kernel_ulong_t,
    pub st_ino: __kernel_ulong_t,
    pub st_nlink: __kernel_ulong_t,
    pub st_mode: core::ffi::c_uint,
    pub st_uid: core::ffi::c_uint,
    pub st_gid: core::ffi::c_uint,
    pub __pad0: core::ffi::c_uint,
    pub st_rdev: __kernel_ulong_t,
    pub st_size: __kernel_long_t,
    pub st_blksize: __kernel_long_t,
    pub st_blocks: __kernel_long_t,
    pub st_atime: __kernel_ulong_t,
    pub st_atime_nsec: __kernel_ulong_t,
    pub st_mtime: __kernel_ulong_t,
    pub st_mtime_nsec: __kernel_ulong_t,
    pub st_ctime: __kernel_ulong_t,
    pub st_ctime_nsec: __kernel_ulong_t,
    pub __unused: [__kernel_long_t; 3usize],
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __old_kernel_stat {
    pub st_dev: core::ffi::c_ushort,
    pub st_ino: core::ffi::c_ushort,
    pub st_mode: core::ffi::c_ushort,
    pub st_nlink: core::ffi::c_ushort,
    pub st_uid: core::ffi::c_ushort,
    pub st_gid: core::ffi::c_ushort,
    pub st_rdev: core::ffi::c_ushort,
    pub st_size: core::ffi::c_uint,
    pub st_atime: core::ffi::c_uint,
    pub st_mtime: core::ffi::c_uint,
    pub st_ctime: core::ffi::c_uint,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct statx_timestamp {
    pub tv_sec: __s64,
    pub tv_nsec: __u32,
    pub __reserved: __s32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct statx {
    pub stx_mask: __u32,
    pub stx_blksize: __u32,
    pub stx_attributes: __u64,
    pub stx_nlink: __u32,
    pub stx_uid: __u32,
    pub stx_gid: __u32,
    pub stx_mode: __u16,
    pub __spare0: [__u16; 1usize],
    pub stx_ino: __u64,
    pub stx_size: __u64,
    pub stx_blocks: __u64,
    pub stx_attributes_mask: __u64,
    pub stx_atime: statx_timestamp,
    pub stx_btime: statx_timestamp,
    pub stx_ctime: statx_timestamp,
    pub stx_mtime: statx_timestamp,
    pub stx_rdev_major: __u32,
    pub stx_rdev_minor: __u32,
    pub stx_dev_major: __u32,
    pub stx_dev_minor: __u32,
    pub stx_mnt_id: __u64,
    pub stx_dio_mem_align: __u32,
    pub stx_dio_offset_align: __u32,
    pub __spare3: [__u64; 12usize],
}
pub type time64_t = __s64;
pub type timeu64_t = __u64;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_timespec {
    pub tv_sec: __kernel_time64_t,
    pub tv_nsec: core::ffi::c_longlong,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_itimerspec {
    pub it_interval: __kernel_timespec,
    pub it_value: __kernel_timespec,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_old_timeval {
    pub tv_sec: __kernel_long_t,
    pub tv_usec: __kernel_long_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_old_timespec {
    pub tv_sec: __kernel_old_time_t,
    pub tv_nsec: core::ffi::c_long,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_old_itimerval {
    pub it_interval: __kernel_old_timeval,
    pub it_value: __kernel_old_timeval,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_sock_timeval {
    pub tv_sec: __s64,
    pub tv_usec: __s64,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: core::ffi::c_int,
    pub tz_dsttime: core::ffi::c_int,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct timespec64 {
    pub tv_sec: time64_t,
    pub tv_nsec: core::ffi::c_long,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct itimerspec64 {
    pub it_interval: timespec64,
    pub it_value: timespec64,
}
extern "C" {
    pub fn set_normalized_timespec64(ts: *mut timespec64, sec: time64_t, nsec: s64);
}
extern "C" {
    pub fn ns_to_timespec64(nsec: s64) -> timespec64;
}
extern "C" {
    pub fn timespec64_add_safe(lhs: timespec64, rhs: timespec64) -> timespec64;
}
extern "C" {
    pub static mut sys_tz: timezone;
}
extern "C" {
    pub fn get_timespec64(ts: *mut timespec64, uts: *const __kernel_timespec) -> core::ffi::c_int;
}
extern "C" {
    pub fn put_timespec64(ts: *const timespec64, uts: *mut __kernel_timespec) -> core::ffi::c_int;
}
extern "C" {
    pub fn get_itimerspec64(
        it: *mut itimerspec64,
        uit: *const __kernel_itimerspec,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn put_itimerspec64(
        it: *const itimerspec64,
        uit: *mut __kernel_itimerspec,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn mktime64(
        year: core::ffi::c_uint,
        mon: core::ffi::c_uint,
        day: core::ffi::c_uint,
        hour: core::ffi::c_uint,
        min: core::ffi::c_uint,
        sec: core::ffi::c_uint,
    ) -> time64_t;
}
extern "C" {
    pub fn clear_itimer();
}
extern "C" {
    pub fn do_utimes(
        dfd: core::ffi::c_int,
        filename: *const core::ffi::c_char,
        times: *mut timespec64,
        flags: core::ffi::c_int,
    ) -> core::ffi::c_long;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct tm {
    pub tm_sec: core::ffi::c_int,
    pub tm_min: core::ffi::c_int,
    pub tm_hour: core::ffi::c_int,
    pub tm_mday: core::ffi::c_int,
    pub tm_mon: core::ffi::c_int,
    pub tm_year: core::ffi::c_long,
    pub tm_wday: core::ffi::c_int,
    pub tm_yday: core::ffi::c_int,
}
extern "C" {
    pub fn time64_to_tm(totalsecs: time64_t, offset: core::ffi::c_int, result: *mut tm);
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct __kernel_timex_timeval {
    pub tv_sec: __kernel_time64_t,
    pub tv_usec: core::ffi::c_longlong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __kernel_timex {
    pub modes: core::ffi::c_uint,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub offset: core::ffi::c_longlong,
    pub freq: core::ffi::c_longlong,
    pub maxerror: core::ffi::c_longlong,
    pub esterror: core::ffi::c_longlong,
    pub status: core::ffi::c_int,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub constant: core::ffi::c_longlong,
    pub precision: core::ffi::c_longlong,
    pub tolerance: core::ffi::c_longlong,
    pub time: __kernel_timex_timeval,
    pub tick: core::ffi::c_longlong,
    pub ppsfreq: core::ffi::c_longlong,
    pub jitter: core::ffi::c_longlong,
    pub shift: core::ffi::c_int,
    pub _bitfield_align_3: [u8; 0],
    pub _bitfield_3: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub stabil: core::ffi::c_longlong,
    pub jitcnt: core::ffi::c_longlong,
    pub calcnt: core::ffi::c_longlong,
    pub errcnt: core::ffi::c_longlong,
    pub stbcnt: core::ffi::c_longlong,
    pub tai: core::ffi::c_int,
    pub _bitfield_align_4: [u8; 0],
    pub _bitfield_4: __BindgenBitfieldUnit<[u8; 44usize]>,
}
impl Default for __kernel_timex {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl __kernel_timex {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn new_bitfield_2() -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn new_bitfield_3() -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn random_get_entropy_fallback() -> core::ffi::c_ulong;
}
pub type cycles_t = core::ffi::c_ulonglong;
extern "C" {
    pub static mut cpu_khz: core::ffi::c_uint;
}
extern "C" {
    pub static mut tsc_khz: core::ffi::c_uint;
}
extern "C" {
    pub fn disable_TSC();
}
extern "C" {
    pub fn convert_art_to_tsc(art: u64_) -> system_counterval_t;
}
extern "C" {
    pub fn convert_art_ns_to_tsc(art_ns: u64_) -> system_counterval_t;
}
extern "C" {
    pub fn tsc_early_init();
}
extern "C" {
    pub fn tsc_init();
}
extern "C" {
    pub fn mark_tsc_unstable(reason: *mut core::ffi::c_char);
}
extern "C" {
    pub fn unsynchronized_tsc() -> core::ffi::c_int;
}
extern "C" {
    pub fn check_tsc_unstable() -> core::ffi::c_int;
}
extern "C" {
    pub fn mark_tsc_async_resets(reason: *mut core::ffi::c_char);
}
extern "C" {
    pub fn native_calibrate_cpu_early() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn native_calibrate_tsc() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn native_sched_clock_from_tsc(tsc: u64_) -> core::ffi::c_ulonglong;
}
extern "C" {
    pub static mut tsc_clocksource_reliable: core::ffi::c_int;
}
extern "C" {
    pub static mut tsc_async_resets: bool_;
}
extern "C" {
    pub fn tsc_store_and_check_tsc_adjust(bootcpu: bool_) -> bool_;
}
extern "C" {
    pub fn tsc_verify_tsc_adjust(resume: bool_);
}
extern "C" {
    pub fn check_tsc_sync_target();
}
extern "C" {
    pub fn notsc_setup(arg1: *mut core::ffi::c_char) -> core::ffi::c_int;
}
extern "C" {
    pub fn tsc_save_sched_clock_state();
}
extern "C" {
    pub fn tsc_restore_sched_clock_state();
}
extern "C" {
    pub fn cpu_khz_from_msr() -> core::ffi::c_ulong;
}
extern "C" {
    pub static mut tick_usec: core::ffi::c_ulong;
}
extern "C" {
    pub static mut tick_nsec: core::ffi::c_ulong;
}
extern "C" {
    pub fn do_adjtimex(arg1: *mut __kernel_timex) -> core::ffi::c_int;
}
extern "C" {
    pub fn do_clock_adjtime(which_clock: clockid_t, ktx: *mut __kernel_timex) -> core::ffi::c_int;
}
extern "C" {
    pub fn hardpps(arg1: *const timespec64, arg2: *const timespec64);
}
extern "C" {
    pub fn read_current_timer(timer_val: *mut core::ffi::c_ulong) -> core::ffi::c_int;
}
pub type old_time32_t = s32;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct old_timespec32 {
    pub tv_sec: old_time32_t,
    pub tv_nsec: s32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct old_timeval32 {
    pub tv_sec: old_time32_t,
    pub tv_usec: s32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct old_itimerspec32 {
    pub it_interval: old_timespec32,
    pub it_value: old_timespec32,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct old_utimbuf32 {
    pub actime: old_time32_t,
    pub modtime: old_time32_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct old_timex32 {
    pub modes: u32_,
    pub offset: s32,
    pub freq: s32,
    pub maxerror: s32,
    pub esterror: s32,
    pub status: s32,
    pub constant: s32,
    pub precision: s32,
    pub tolerance: s32,
    pub time: old_timeval32,
    pub tick: s32,
    pub ppsfreq: s32,
    pub jitter: s32,
    pub shift: s32,
    pub stabil: s32,
    pub jitcnt: s32,
    pub calcnt: s32,
    pub errcnt: s32,
    pub stbcnt: s32,
    pub tai: s32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 44usize]>,
}
impl Default for old_timex32 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn get_old_timespec32(
        arg1: *mut timespec64,
        arg2: *const core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn put_old_timespec32(
        arg1: *const timespec64,
        arg2: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn get_old_itimerspec32(
        its: *mut itimerspec64,
        uits: *const old_itimerspec32,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn put_old_itimerspec32(
        its: *const itimerspec64,
        uits: *mut old_itimerspec32,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn get_old_timex32(arg1: *mut __kernel_timex, arg2: *const old_timex32)
        -> core::ffi::c_int;
}
extern "C" {
    pub fn put_old_timex32(arg1: *mut old_timex32, arg2: *const __kernel_timex)
        -> core::ffi::c_int;
}
extern "C" {
    pub fn ns_to_kernel_old_timeval(nsec: s64) -> __kernel_old_timeval;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct timens_offset {
    pub sec: s64,
    pub nsec: u64_,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kuid_t {
    pub val: uid_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kgid_t {
    pub val: gid_t,
}
extern "C" {
    pub static mut overflowuid: core::ffi::c_int;
}
extern "C" {
    pub static mut overflowgid: core::ffi::c_int;
}
extern "C" {
    pub fn __bad_uid();
}
extern "C" {
    pub fn __bad_gid();
}
extern "C" {
    pub static mut fs_overflowuid: core::ffi::c_int;
}
extern "C" {
    pub static mut fs_overflowgid: core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct user_namespace {
    _unused: [u8; 0],
}
extern "C" {
    pub static mut init_user_ns: user_namespace;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct uid_gid_map {
    _unused: [u8; 0],
}
extern "C" {
    pub fn make_kuid(from: *mut user_namespace, uid: uid_t) -> kuid_t;
}
extern "C" {
    pub fn make_kgid(from: *mut user_namespace, gid: gid_t) -> kgid_t;
}
extern "C" {
    pub fn from_kuid(to: *mut user_namespace, uid: kuid_t) -> uid_t;
}
extern "C" {
    pub fn from_kgid(to: *mut user_namespace, gid: kgid_t) -> gid_t;
}
extern "C" {
    pub fn from_kuid_munged(to: *mut user_namespace, uid: kuid_t) -> uid_t;
}
extern "C" {
    pub fn from_kgid_munged(to: *mut user_namespace, gid: kgid_t) -> gid_t;
}
extern "C" {
    pub fn map_id_down(map: *mut uid_gid_map, id: u32_) -> u32_;
}
extern "C" {
    pub fn map_id_up(map: *mut uid_gid_map, id: u32_) -> u32_;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct kstat {
    pub result_mask: u32_,
    pub mode: umode_t,
    pub nlink: core::ffi::c_uint,
    pub blksize: u32,
    pub attributes: u64_,
    pub attributes_mask: u64_,
    pub ino: u64_,
    pub dev: dev_t,
    pub rdev: dev_t,
    pub uid: kuid_t,
    pub gid: kgid_t,
    pub size: loff_t,
    pub atime: timespec64,
    pub mtime: timespec64,
    pub ctime: timespec64,
    pub btime: timespec64,
    pub blocks: u64_,
    pub mnt_id: u64_,
    pub dio_mem_align: u32_,
    pub dio_offset_align: u32_,
    pub change_cookie: u64_,
}
extern "C" {
    pub fn build_id_parse(
        vma: *mut vm_area_struct,
        build_id: *mut core::ffi::c_uchar,
        size: *mut __u32,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn build_id_parse_buf(
        buf: *const core::ffi::c_void,
        build_id: *mut core::ffi::c_uchar,
        buf_size: u32_,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub static mut vmlinux_build_id: [core::ffi::c_uchar; 20usize];
}
extern "C" {
    pub fn init_vmlinux_build_id();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hlist_nulls_head {
    pub first: *mut hlist_nulls_node,
}
impl Default for hlist_nulls_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hlist_nulls_node {
    pub next: *mut hlist_nulls_node,
    pub pprev: *mut *mut hlist_nulls_node,
}
impl Default for hlist_nulls_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type wait_queue_entry_t = wait_queue_entry;
pub type wait_queue_func_t = ::core::option::Option<
    unsafe extern "C" fn(
        wq_entry: *mut wait_queue_entry,
        mode: core::ffi::c_uint,
        flags: core::ffi::c_int,
        key: *mut core::ffi::c_void,
    ) -> core::ffi::c_int,
>;
extern "C" {
    pub fn default_wake_function(
        wq_entry: *mut wait_queue_entry,
        mode: core::ffi::c_uint,
        flags: core::ffi::c_int,
        key: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct wait_queue_entry {
    pub flags: core::ffi::c_uint,
    pub private: *mut core::ffi::c_void,
    pub func: wait_queue_func_t,
    pub entry: list_head,
}
impl Default for wait_queue_entry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct wait_queue_head {
    pub lock: spinlock_t,
    pub head: list_head,
}
impl Default for wait_queue_head {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type wait_queue_head_t = wait_queue_head;
extern "C" {
    pub fn __init_waitqueue_head(
        wq_head: *mut wait_queue_head,
        name: *const core::ffi::c_char,
        arg1: *mut lock_class_key,
    );
}
extern "C" {
    pub fn add_wait_queue(wq_head: *mut wait_queue_head, wq_entry: *mut wait_queue_entry);
}
extern "C" {
    pub fn add_wait_queue_exclusive(wq_head: *mut wait_queue_head, wq_entry: *mut wait_queue_entry);
}
extern "C" {
    pub fn add_wait_queue_priority(wq_head: *mut wait_queue_head, wq_entry: *mut wait_queue_entry);
}
extern "C" {
    pub fn remove_wait_queue(wq_head: *mut wait_queue_head, wq_entry: *mut wait_queue_entry);
}
extern "C" {
    pub fn __wake_up(
        wq_head: *mut wait_queue_head,
        mode: core::ffi::c_uint,
        nr: core::ffi::c_int,
        key: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn __wake_up_on_current_cpu(
        wq_head: *mut wait_queue_head,
        mode: core::ffi::c_uint,
        key: *mut core::ffi::c_void,
    );
}
extern "C" {
    pub fn __wake_up_locked_key(
        wq_head: *mut wait_queue_head,
        mode: core::ffi::c_uint,
        key: *mut core::ffi::c_void,
    );
}
extern "C" {
    pub fn __wake_up_sync_key(
        wq_head: *mut wait_queue_head,
        mode: core::ffi::c_uint,
        key: *mut core::ffi::c_void,
    );
}
extern "C" {
    pub fn __wake_up_locked_sync_key(
        wq_head: *mut wait_queue_head,
        mode: core::ffi::c_uint,
        key: *mut core::ffi::c_void,
    );
}
extern "C" {
    pub fn __wake_up_locked(
        wq_head: *mut wait_queue_head,
        mode: core::ffi::c_uint,
        nr: core::ffi::c_int,
    );
}
extern "C" {
    pub fn __wake_up_sync(wq_head: *mut wait_queue_head, mode: core::ffi::c_uint);
}
extern "C" {
    pub fn __wake_up_pollfree(wq_head: *mut wait_queue_head);
}
extern "C" {
    pub fn init_wait_entry(wq_entry: *mut wait_queue_entry, flags: core::ffi::c_int);
}
extern "C" {
    pub fn do_wait_intr(
        arg1: *mut wait_queue_head_t,
        arg2: *mut wait_queue_entry_t,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn do_wait_intr_irq(
        arg1: *mut wait_queue_head_t,
        arg2: *mut wait_queue_entry_t,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn prepare_to_wait(
        wq_head: *mut wait_queue_head,
        wq_entry: *mut wait_queue_entry,
        state: core::ffi::c_int,
    );
}
extern "C" {
    pub fn prepare_to_wait_exclusive(
        wq_head: *mut wait_queue_head,
        wq_entry: *mut wait_queue_entry,
        state: core::ffi::c_int,
    ) -> bool_;
}
extern "C" {
    pub fn prepare_to_wait_event(
        wq_head: *mut wait_queue_head,
        wq_entry: *mut wait_queue_entry,
        state: core::ffi::c_int,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn finish_wait(wq_head: *mut wait_queue_head, wq_entry: *mut wait_queue_entry);
}
extern "C" {
    pub fn wait_woken(
        wq_entry: *mut wait_queue_entry,
        mode: core::ffi::c_uint,
        timeout: core::ffi::c_long,
    ) -> core::ffi::c_long;
}
extern "C" {
    pub fn woken_wake_function(
        wq_entry: *mut wait_queue_entry,
        mode: core::ffi::c_uint,
        sync: core::ffi::c_int,
        key: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
extern "C" {
    pub fn autoremove_wake_function(
        wq_entry: *mut wait_queue_entry,
        mode: core::ffi::c_uint,
        sync: core::ffi::c_int,
        key: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
pub type task_call_f = ::core::option::Option<
    unsafe extern "C" fn(p: *mut task_struct, arg: *mut core::ffi::c_void) -> core::ffi::c_int,
>;
extern "C" {
    pub fn task_call_func(
        p: *mut task_struct,
        func: task_call_f,
        arg: *mut core::ffi::c_void,
    ) -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct optimistic_spin_queue {
    pub tail: atomic_t,
}
extern "C" {
    pub fn osq_lock(lock: *mut optimistic_spin_queue) -> bool_;
}
extern "C" {
    pub fn osq_unlock(lock: *mut optimistic_spin_queue);
}
extern "C" {
    pub static mut debug_locks: core::ffi::c_int;
}
extern "C" {
    pub static mut debug_locks_silent: core::ffi::c_int;
}
extern "C" {
    pub fn debug_locks_off() -> core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mutex {
    pub owner: atomic_long_t,
    pub wait_lock: raw_spinlock_t,
    pub osq: optimistic_spin_queue,
    pub wait_list: list_head,
}
impl Default for mutex {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn __mutex_init(lock: *mut mutex, name: *const core::ffi::c_char, key: *mut lock_class_key);
}
extern "C" {
    pub fn mutex_is_locked(lock: *mut mutex) -> bool_;
}
extern "C" {
    pub fn mutex_lock(lock: *mut mutex);
}
extern "C" {
    pub fn mutex_lock_interruptible(lock: *mut mutex) -> core::ffi::c_int;
}
extern "C" {
    pub fn mutex_lock_killable(lock: *mut mutex) -> core::ffi::c_int;
}
extern "C" {
    pub fn mutex_lock_io(lock: *mut mutex);
}
extern "C" {
    pub fn mutex_trylock(lock: *mut mutex) -> core::ffi::c_int;
}
extern "C" {
    pub fn mutex_unlock(lock: *mut mutex);
}
extern "C" {
    pub fn atomic_dec_and_mutex_lock(cnt: *mut atomic_t, lock: *mut mutex) -> core::ffi::c_int;
}
pub type class_mutex_t = *mut mutex;
pub type class_mutex_try_t = class_mutex_t;
pub type class_mutex_intr_t = class_mutex_t;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqcount {
    pub sequence: core::ffi::c_uint,
}
pub type seqcount_t = seqcount;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqcount_raw_spinlock {
    pub seqcount: seqcount_t,
}
pub type seqcount_raw_spinlock_t = seqcount_raw_spinlock;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqcount_spinlock {
    pub seqcount: seqcount_t,
}
pub type seqcount_spinlock_t = seqcount_spinlock;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqcount_rwlock {
    pub seqcount: seqcount_t,
}
pub type seqcount_rwlock_t = seqcount_rwlock;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqcount_mutex {
    pub seqcount: seqcount_t,
}
pub type seqcount_mutex_t = seqcount_mutex;
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqlock_t {
    pub seqcount: seqcount_spinlock_t,
    pub lock: spinlock_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct seqcount_latch_t {
    pub seqcount: seqcount_t,
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct nodemask_t {
    pub bits: [core::ffi::c_ulong; 16usize],
}
extern "C" {
    pub static mut nr_irqs: core::ffi::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct irq_desc {
    _unused: [u8; 0],
}
extern "C" {
    pub fn irq_to_desc(irq: core::ffi::c_uint) -> *mut irq_desc;
}
extern "C" {
    pub fn irq_get_next_irq(offset: core::ffi::c_uint) -> core::ffi::c_uint;
}
#[repr(C)]
#[derive(Default)]
pub struct rand_pool_info {
    pub entropy_count: core::ffi::c_int,
    pub buf_size: core::ffi::c_int,
    pub buf: __IncompleteArrayField<__u32>,
}
extern "C" {
    pub fn add_device_randomness(buf: *const core::ffi::c_void, len: usize);
}
extern "C" {
    pub fn add_bootloader_randomness(buf: *const core::ffi::c_void, len: usize);
}
extern "C" {
    pub fn add_input_randomness(
        type_: core::ffi::c_uint,
        code: core::ffi::c_uint,
        value: core::ffi::c_uint,
    );
}
extern "C" {
    pub fn add_interrupt_randomness(irq: core::ffi::c_int);
}
extern "C" {
    pub fn add_hwgenerator_randomness(
        buf: *const core::ffi::c_void,
        len: usize,
        entropy: usize,
        sleep_after: bool_,
    );
}
extern "C" {
    pub fn add_vmfork_randomness(unique_vm_id: *const core::ffi::c_void, len: usize);
}
extern "C" {
    pub fn register_random_vmfork_notifier(nb: *mut notifier_block) -> core::ffi::c_int;
}
extern "C" {
    pub fn unregister_random_vmfork_notifier(nb: *mut notifier_block) -> core::ffi::c_int;
}
extern "C" {
    pub fn get_random_bytes(buf: *mut core::ffi::c_void, len: usize);
}
extern "C" {
    pub fn get_random_u8() -> u8_;
}
extern "C" {
    pub fn get_random_u16() -> u16_;
}
extern "C" {
    pub fn get_random_u32() -> u32_;
}
extern "C" {
    pub fn get_random_u64() -> u64_;
}
extern "C" {
    pub fn __get_random_u32_below(ceil: u32_) -> u32_;
}
extern "C" {
    pub fn random_init_early(command_line: *const core::ffi::c_char);
}
extern "C" {
    pub fn random_init();
}
extern "C" {
    pub fn rng_is_initialized() -> bool_;
}
extern "C" {
    pub fn wait_for_random_bytes() -> core::ffi::c_int;
}
extern "C" {
    pub fn execute_with_initialized_rng(nb: *mut notifier_block) -> core::ffi::c_int;
}
extern "C" {
    pub fn __do_once_start(done: *mut bool_, flags: *mut core::ffi::c_ulong) -> bool_;
}
extern "C" {
    pub fn __do_once_done(
        done: *mut bool_,
        once_key: *mut static_key_true,
        flags: *mut core::ffi::c_ulong,
        mod_: *mut module,
    );
}
extern "C" {
    pub fn __do_once_sleepable_start(done: *mut bool_) -> bool_;
}
extern "C" {
    pub fn __do_once_sleepable_done(
        done: *mut bool_,
        once_key: *mut static_key_true,
        mod_: *mut module,
    );
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct rnd_state {
    pub s1: __u32,
    pub s2: __u32,
    pub s3: __u32,
    pub s4: __u32,
}
extern "C" {
    pub fn prandom_u32_state(state: *mut rnd_state) -> u32_;
}
extern "C" {
    pub fn prandom_bytes_state(state: *mut rnd_state, buf: *mut core::ffi::c_void, nbytes: usize);
}
extern "C" {
    pub fn prandom_seed_full_state(pcpu_state: *mut rnd_state);
}
extern "C" {
    pub fn random_prepare_cpu(cpu: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub fn random_online_cpu(cpu: core::ffi::c_uint) -> core::ffi::c_int;
}
extern "C" {
    pub static mut _unused_nodemask_arg_: nodemask_t;
}
pub const node_states_N_POSSIBLE: node_states = 0;
pub const node_states_N_ONLINE: node_states = 1;
pub const node_states_N_NORMAL_MEMORY: node_states = 2;
pub const node_states_N_HIGH_MEMORY: node_states = 2;
pub const node_states_N_MEMORY: node_states = 3;
pub const node_states_N_CPU: node_states = 4;
pub const node_states_N_GENERIC_INITIATOR: node_states = 5;
pub const node_states_NR_NODE_STATES: node_states = 6;
pub type node_states = core::ffi::c_uint;
extern "C" {
    pub static mut node_states: [nodemask_t; 6usize];
}
extern "C" {
    pub static mut nr_node_ids: core::ffi::c_uint;
}
extern "C" {
    pub static mut nr_online_nodes: core::ffi::c_uint;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct nodemask_scratch {
    pub mask1: nodemask_t,
    pub mask2: nodemask_t,
}
pub const pageblock_bits_PB_migrate: pageblock_bits = 0;
pub const pageblock_bits_PB_migrate_end: pageblock_bits = 2;
pub const pageblock_bits_PB_migrate_skip: pageblock_bits = 3;
pub const pageblock_bits_NR_PAGEBLOCK_BITS: pageblock_bits = 4;
pub type pageblock_bits = core::ffi::c_uint;
extern "C" {
    pub fn get_pfnblock_flags_mask(
        page: *const page,
        pfn: core::ffi::c_ulong,
        mask: core::ffi::c_ulong,
    ) -> core::ffi::c_ulong;
}
extern "C" {
    pub fn set_pfnblock_flags_mask(
        page: *mut page,
        flags: core::ffi::c_ulong,
        pfn: core::ffi::c_ulong,
        mask: core::ffi::c_ulong,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct arch_tlbflush_unmap_batch {
    pub cpumask: cpumask,
}
impl Default for arch_tlbflush_unmap_batch {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MM_FILEPAGES: _bindgen_ty_9 = 0;
pub const MM_ANONPAGES: _bindgen_ty_9 = 1;
pub const MM_SWAPENTS: _bindgen_ty_9 = 2;
pub const MM_SHMEMPAGES: _bindgen_ty_9 = 3;
pub const NR_MM_COUNTERS: _bindgen_ty_9 = 4;
pub type _bindgen_ty_9 = core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct page_frag {
    pub page: *mut page,
    pub offset: __u32,
    pub size: __u32,
}
impl Default for page_frag {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tlbflush_unmap_batch {
    pub arch: arch_tlbflush_unmap_batch,
    pub flush_required: bool_,
    pub writable: bool_,
}
impl Default for tlbflush_unmap_batch {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_node {
    pub __rb_parent_color: core::ffi::c_ulong,
    pub rb_right: *mut rb_node,
    pub rb_left: *mut rb_node,
}
impl Default for rb_node {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_root {
    pub rb_node: *mut rb_node,
}
impl Default for rb_root {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rb_root_cached {
    pub rb_root: rb_root,
    pub rb_leftmost: *mut rb_node,
}
impl Default for rb_root_cached {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn ct_irq_enter();
}
extern "C" {
    pub fn ct_irq_exit();
}
extern "C" {
    pub fn ct_irq_enter_irqson();
}
extern "C" {
    pub fn ct_irq_exit_irqson();
}
extern "C" {
    pub fn ct_nmi_enter();
}
extern "C" {
    pub fn ct_nmi_exit();
}
extern "C" {
    pub fn call_rcu(head: *mut callback_head, func: rcu_callback_t);
}
extern "C" {
    pub fn rcu_barrier_tasks();
}
extern "C" {
    pub fn rcu_barrier_tasks_rude();
}
extern "C" {
    pub fn synchronize_rcu();
}
extern "C" {
    pub fn get_completed_synchronize_rcu() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn get_completed_synchronize_rcu_full(rgosp: *mut rcu_gp_oldstate);
}
extern "C" {
    pub fn __rcu_read_lock();
}
extern "C" {
    pub fn __rcu_read_unlock();
}
extern "C" {
    pub fn call_rcu_hurry(head: *mut callback_head, func: rcu_callback_t);
}
extern "C" {
    pub fn rcu_init();
}
extern "C" {
    pub static mut rcu_scheduler_active: core::ffi::c_int;
}
extern "C" {
    pub fn rcu_sched_clock_irq(user: core::ffi::c_int);
}
extern "C" {
    pub fn rcu_init_tasks_generic();
}
extern "C" {
    pub fn rcu_sysrq_start();
}
extern "C" {
    pub fn rcu_sysrq_end();
}
extern "C" {
    pub fn rcu_init_nohz();
}
extern "C" {
    pub fn rcu_nocb_cpu_offload(cpu: core::ffi::c_int) -> core::ffi::c_int;
}
extern "C" {
    pub fn rcu_nocb_cpu_deoffload(cpu: core::ffi::c_int) -> core::ffi::c_int;
}
extern "C" {
    pub fn rcu_nocb_flush_deferred_wakeup();
}
extern "C" {
    pub fn call_rcu_tasks(head: *mut callback_head, func: rcu_callback_t);
}
extern "C" {
    pub fn synchronize_rcu_tasks();
}
extern "C" {
    pub fn rcu_trc_cmpxchg_need_qs(t: *mut task_struct, old: u8_, new: u8_) -> u8_;
}
extern "C" {
    pub fn rcu_tasks_trace_qs_blkd(t: *mut task_struct);
}
extern "C" {
    pub fn call_rcu_tasks_rude(head: *mut callback_head, func: rcu_callback_t);
}
extern "C" {
    pub fn synchronize_rcu_tasks_rude();
}
extern "C" {
    pub fn exit_tasks_rcu_start();
}
extern "C" {
    pub fn exit_tasks_rcu_stop();
}
extern "C" {
    pub fn exit_tasks_rcu_finish();
}
extern "C" {
    pub fn rcu_softirq_qs();
}
extern "C" {
    pub fn rcu_note_context_switch(preempt: bool_);
}
extern "C" {
    pub fn rcu_needs_cpu() -> core::ffi::c_int;
}
extern "C" {
    pub fn rcu_cpu_stall_reset();
}
extern "C" {
    pub fn rcu_request_urgent_qs_task(t: *mut task_struct);
}
extern "C" {
    pub fn synchronize_rcu_expedited();
}
extern "C" {
    pub fn kvfree_call_rcu(head: *mut callback_head, ptr: *mut core::ffi::c_void);
}
extern "C" {
    pub fn rcu_barrier();
}
extern "C" {
    pub fn rcu_momentary_dyntick_idle();
}
extern "C" {
    pub fn kfree_rcu_scheduler_running();
}
extern "C" {
    pub fn rcu_gp_might_be_stalled() -> bool_;
}
#[repr(C)]
#[derive(Default, Copy, Clone)]
pub struct rcu_gp_oldstate {
    pub rgos_norm: core::ffi::c_ulong,
    pub rgos_exp: core::ffi::c_ulong,
}
extern "C" {
    pub fn start_poll_synchronize_rcu_expedited() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn start_poll_synchronize_rcu_expedited_full(rgosp: *mut rcu_gp_oldstate);
}
extern "C" {
    pub fn cond_synchronize_rcu_expedited(oldstate: core::ffi::c_ulong);
}
extern "C" {
    pub fn cond_synchronize_rcu_expedited_full(rgosp: *mut rcu_gp_oldstate);
}
extern "C" {
    pub fn get_state_synchronize_rcu() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn get_state_synchronize_rcu_full(rgosp: *mut rcu_gp_oldstate);
}
extern "C" {
    pub fn start_poll_synchronize_rcu() -> core::ffi::c_ulong;
}
extern "C" {
    pub fn start_poll_synchronize_rcu_full(rgosp: *mut rcu_gp_oldstate);
}
extern "C" {
    pub fn poll_state_synchronize_rcu(oldstate: core::ffi::c_ulong) -> bool_;
}
extern "C" {
    pub fn poll_state_synchronize_rcu_full(rgosp: *mut rcu_gp_oldstate) -> bool_;
}
extern "C" {
    pub fn cond_synchronize_rcu(oldstate: core::ffi::c_ulong);
}
extern "C" {
    pub fn cond_synchronize_rcu_full(rgosp: *mut rcu_gp_oldstate);
}
extern "C" {
    pub fn rcu_preempt_deferred_qs(t: *mut task_struct);
}
extern "C" {
    pub fn exit_rcu();
}
extern "C" 