#!/bin/bash -ex
#
# Copyright (C) 2020 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 3 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This comes from livecd-rootfs
# (/usr/share/livecd-rootfs/live-build/ubuntu-cpc/hooks.d/chroot/099-cleanup.chroot):

set -o pipefail

# Clean up extraneous log files that may be left around
rm /etc/ssh/ssh_host*key*      		|| echo "No SSH keys to remove"

# Fix LP: #1047707, 1019338
# Truncate logs that are owned, otherwise remove
whitelisted_logs=(/var/log/btmp /var/log/lastlog /var/log/wtmp /var/log/fsck/checkfs /var/log/fsck/checkroot)

for log in $(find /var/log -type f)
do
    whitelisted=$(echo "${whitelisted_logs[@]}" | grep -o "$log_d") || true

    if [ -n "${whitelisted}" ]; then
        : > "$log_d" &&
            echo "Truncated whitelisted log ${log}" ||
            echo "Failed to truncate whitelisted log ${log}"
    else
       dpkg -S "$log_d" > /dev/null 2>&1 &&
           { : > "$log_d" ||
                echo "Failed to truncate $log"; } ||
           { rm "$log_d" &&
               echo "Removed ${log} as an orphaned log file" ||
               echo "Failed to remove unnecessary log $log"; }
    fi
done

# Remove un-owned log directories
whitelisted_dirs=(/var/log/fsck /var/log/journal)

for log_d in $(find /var/log/* -type d)
do
    whitelisted=$(echo "${whitelisted_dirs[@]}" | grep -o "${log_d}") || true
    if [ -z "${whitelisted}" ]; then
        dpkg -S "$log_d" > /dev/null 2>&1 &&
            echo "Preserving log directory ${log_d}" ||
            { rm -rf "$log_d" &&
                echo "Removed log directory ${log_d} as orphaned log dir" ||
                echo "Failed to remove unnessasary log dir ${log_d}"; }

    else
        echo "Preserving whitelisted directory ${log_d}"
    fi

done


rm -rf /var/run/*
rm -f /etc/passwd-
rm -f /etc/shadow-
rm -f /etc/gshadow-
rm -f /etc/group-
rm -f /etc/apt/conf.d/00secure

# Truncate instead of delete, LP: #707311
truncate --size=0 -c /etc/popularity-contest.conf
