import dis, sys

from pygdb import mi

g = mi.Gdb(pid=int(sys.argv[1]))
thread_ids = g.thread_list_ids().wait().thread_ids.thread_id

def local_named(locals, name):
    for d in locals:
        if d.name == name:
            return d.value

def evaluate_int(expr):
    value = g.data_evaluate_expression('(int)&(((PyStringObject*)(0))->ob_size)')
    return int(value.wait().value)

class FakeCode(object):
    def __init__(self, co_firstlineno, co_lnotab):
        self.co_firstlineno = co_firstlineno
        self.co_lnotab = co_lnotab

offset = evaluate_int('(int)&(((PyStringObject*)(0))->ob_size)')
int_size = 8 # 64 bit dependency!

def get_string(address_expr):
    size = g.data_read_memory(
        address_expr, 'd', int_size, 1, 1, byte_offset=offset).wait()
    size = int(size.memory[0].data[0])
    if not size: return ''
    s = g.data_read_memory(
        '(char*)((PyStringObject*)%s)->ob_sval' % address_expr, 's', 1, 1, size).wait()
    chars = map(int, s.memory[0].data)
    return ''.join(map(chr, chars))

def lineno():
    firstline = evaluate_int('co->co_firstlineno')
    lnotab = get_string('co->co_lnotab')
    lasti = evaluate_int('f->f_lasti')
    c = FakeCode(firstline, lnotab)
    for addr, lineno in dis.findlinestarts(c):
        if lasti >= addr:
            return lineno

for thread_id in thread_ids:
    print "Thread", thread_id
    g.thread_select(thread_id)
    frames = g.stack_list_frames().wait().stack
    for frame in frames:
        if frame.frame.func == 'PyEval_EvalFrameEx':
            g.stack_select_frame(frame.frame.level)
            print '%s (%s): %s' % (
                get_string('co->co_filename'), lineno(), get_string('co->co_name'))
    print
