/*
 Isomorphic SmartClient web presentation layer
 Online documentation data
 Copyright 2000-2008 Isomorphic Software, Inc. All rights reserved.
*/


var docItems = {
    "method:Layout.getMember":{
        ref:"method:Layout.getMember",
        flags:"",
        description:"\n Given a numerical index or a member ID, return a pointer to the appropriate member.\n <p>\n If passed a member Canvas, just returns it.\n\n",
        name:"getMember",
        seeAlso:[
            {ref:"method:Layout.getMemberNumber", description:null}
        ],
        params:[
            {description:"identifier for the required member", optional:false, name:"memberID",
             defaultValue:null, type:"string | number | Canvas"}
        ],
        returns:{description:"member widget", type:"Canvas"},
        type:"method",
        definingClass:"class:Layout"
    },
    "attr:ComboBoxItem.pickListProperties":{
        ref:"attr:ComboBoxItem.pickListProperties",
        flags:"IRA",
        description:"If specified this properties block will be applied to the pickList created for this\n Form Item.",
        name:"pickListProperties",
        seeAlso:[],
        valueType:"object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:ColorPicker.autoCenterOnShow":{
        ref:"attr:ColorPicker.autoCenterOnShow",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:ColorPicker.autoPosition')} is false, this property controls whether to automatically center the\n colorPicker every time it is reshown with the show() method.",
        name:"autoCenterOnShow",
        seeAlso:[
            {ref:"attr:ColorPicker.autoPosition", description:null}
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "method:UploadItem.setValue":{
        ref:"method:UploadItem.setValue",
        flags:"",
        description:" Attempting to set the value for an upload form item is disallowed for security reasons.\n Therefore this method will just log a warning, and not modify the value of the item.\n",
        name:"setValue",
        seeAlso:[],
        type:"method",
        definingClass:"class:UploadItem"
    },
    "attr:TileLayout.expandMargins":{
        ref:"attr:TileLayout.expandMargins",
        flags:"IR",
        description:"With ${isc.DocUtils.linkForRef('type:LayoutPolicy')}:\"fit\", should margins be expanded so that tiles fill the\n available space in the TileLayout on the breadth axis?",
        name:"expandMargins",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:["layoutMargin"]
    },
    "method:ResultSet.sortByProperty":{
        ref:"method:ResultSet.sortByProperty",
        flags:"",
        description:" Sort this ResultSet by a property of each record.\n <P>\n Sorting is performed on the client for a ResultSet that has a full cache for the current\n filter criteria.  Otherwise, sorting is performed by the server, and changing the sort order\n will invalidate the cache.\n <P>\n <b>NOTE:</b> normalizers are not supported by ResultSets in \"paged\" mode, although valueMaps\n in the DataSource are respected by the SQLDataSource.\n\n",
        name:"sortByProperty",
        seeAlso:[],
        params:[
            {description:"name of the property to sort by", optional:false, name:"property",
             defaultValue:null, type:"string"},
            {description:"true == sort ascending, false == sort descending", optional:false, name:"up",
             defaultValue:null, type:"boolean"},
            {description:"May be specified as a function, with signature \n              <code>normalize(item, propertyName, context)</code>, where <code>item</code> is\n              a pointer to the item in the array, <code>propertyName</code> is the \n              property by which the array is being sorted, and <code>context</code> is the\n              arbitrary context passed into this method. Normalizer function should return\n              the value normalized for sorting.<br>\n              May also be specified as a ValueMap which maps property values to sortable values.",
             optional:true, name:"normalizer", defaultValue:null, type:"function or ValueMap"},
            {description:"Callers may pass an arbitrary context into the sort method, which                          will then be made available to the normalizer function",
             optional:true, name:"context", defaultValue:null, type:"any"}
        ],
        returns:{description:"the list itself", type:"List"},
        type:"method",
        definingClass:"class:ResultSet",
        groups:["sorting"]
    },
    "attr:Calendar.chosenDate":{
        ref:"attr:Calendar.chosenDate",
        flags:"IR",
        description:"The date for which events are displayed in the day, week, and month tabs of the calendar.\n Default is today.",
        name:"chosenDate",
        setter:["setChosenDate"],
        seeAlso:[],
        valueType:"Date",
        defaultValue:"'Today'",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["date"]
    },
    "method:ListGrid.getDragTrackerIcon":{
        ref:"method:ListGrid.getDragTrackerIcon",
        flags:"",
        description:" Return an icon to display as a drag tracker when the user drags some record.<br>\n Default implementation: \n If ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')} is specified for the title field of this grid \n (see ${isc.DocUtils.linkForRef('method:ListGrid.getTitleField')}), the appropriate value icon will be displayed.\n If no appropriate valueIcon can be found, the icon will be derived from\n ${isc.DocUtils.linkForRef('attr:ListGrid.trackerImage')}.<br>\n If multiple records are selected, only the first record is examined for valueIcons.\n <p>\n Note: Only called if ${isc.DocUtils.linkForRef('attr:ListGrid.dragTrackerMode')} is set to <code>\"icon\"</code>. \n",
        name:"getDragTrackerIcon",
        seeAlso:[],
        params:[
            {description:"Records being dragged", optional:false, name:"records", defaultValue:null,
             type:"Array of ListGridRecord"}
        ],
        returns:{description:"Image URL of icon to display", type:"string"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["dragTracker"]
    },
    "attr:FormItem.startRow":{
        ref:"attr:FormItem.startRow",
        flags:"IRW",
        description:"Whether this item should always start a new row in the form layout.",
        name:"startRow",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["formLayout"]
    },
    "attr:ToolbarItem.buttonProperties":{
        ref:"attr:ToolbarItem.buttonProperties",
        flags:"IRA",
        description:"Default properties for this toolbar's buttons.",
        name:"buttonProperties",
        seeAlso:[],
        valueType:"object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ToolbarItem"
    },
    "method:ListGrid.freezeField":{
        ref:"method:ListGrid.freezeField",
        flags:"",
        description:" Freeze the indicated field, so that it remains in place and visible when horizontal\n scrolling occurs.\n\n",
        name:"freezeField",
        seeAlso:[],
        params:[
            {description:null, optional:false, name:"field", defaultValue:null,
             type:"ListGridField or colNum or ListGridField.name"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["frozenFields"]
    },
    "classAttr:Validator.mustBeLongerThan":{
        ref:"classAttr:Validator.mustBeLongerThan",
        flags:"IRA",
        description:"Default error message to display when standard <code>lengthRange</code> type validator\n returns false becaues the value passed in has fewer than <code>validator.min</code> characters.\n This is a dynamic string - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        name:"mustBeLongerThan",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Must be more than ${min} characters\"",
        type:"classAttr",
        definingClass:"class:Validator",
        groups:["i18nMessages"]
    },
    "method:ColorPicker.getOpacity":{
        ref:"method:ColorPicker.getOpacity",
        flags:"",
        description:" Returns the opacity of the currently-selected color, as an integer from 0-100. If \n opacity is switched off, this is always 100.\n",
        name:"getOpacity",
        seeAlso:[],
        returns:{description:"opacity value", type:"int"},
        type:"method",
        definingClass:"class:ColorPicker"
    },
    "attr:MenuItem.iconWidth":{
        ref:"attr:MenuItem.iconWidth",
        flags:"IR",
        description:"The width applied to this item's icon.  The default of <code>16</code> can be changed\n for all MenuItems by overriding ${isc.DocUtils.linkForRef('attr:Menu.iconWidth')}.",
        name:"iconWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"object:MenuItem",
        groups:["menuIcons"]
    },
    "method:Button.getTitle":{
        ref:"method:Button.getTitle",
        flags:"A",
        description:" Return the title - text/HTML drawn inside the component.\n <p>\n Default is to simply return this.title.\n",
        name:"getTitle",
        seeAlso:[],
        returns:{description:"HTML for the title", type:"string"},
        type:"method",
        definingClass:"class:Button"
    },
    "classMethod:XMLTools.loadXML":{
        ref:"classMethod:XMLTools.loadXML",
        flags:"",
        description:" Load an XML document from the origin server or from a foreign server by relaying through the\n origin server.  An asynchronous callback provides both the XML document and raw text of the\n response.\n <P>\n Relaying through the origin server requires that the ISC HttpProxyServlet be installed and\n accessible.\n \n",
        name:"loadXML",
        seeAlso:[],
        params:[
            {description:"URL to load the schema from", optional:false, name:"URL", defaultValue:null,
             type:"URL"},
            {description:"callback to fire when the XML is loaded.  Signature is                             callback(xmlDoc, xmlText)",
             optional:false, name:"callback", defaultValue:null, type:"callback"},
            {description:"additional properties to set on the RPCRequest                                         that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"RPCRequest"}
        ],
        type:"classMethod",
        definingClass:"class:XMLTools"
    },
    "attr:Img.src":{
        ref:"attr:Img.src",
        flags:"IRW",
        description:"The base filename for the image.\n <P>\n If <code>img.state</code> is set, it's value will be appended to the URL before the\n file extension.  \n <P>\n For example, given an <code>src</code> of \"findIcon.gif\" and a state of\n \"Disabled\", the resulting image name would be \"findIcon_Disabled.gif\".  Compound states\n such as \"Selected\", \"Focused\" and \"Over\" or \"Down\" will have an intervening underscore,\n resulting in, for example, <code>\"findIcon_Selected_Down.gif\"</code>.",
        name:"src",
        setter:["setSrc"],
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"blank.gif\"",
        type:"attr",
        definingClass:"class:Img",
        groups:["appearance"]
    },
    "attr:ImgButton.iconAlign":{
        ref:"attr:ImgButton.iconAlign",
        flags:"IR",
        description:"If this button is showing an icon should it be right or left aligned?",
        name:"iconAlign",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["buttonIcon"]
    },
    "attr:DynamicForm.showInlineErrors":{
        ref:"attr:DynamicForm.showInlineErrors",
        flags:"IRW",
        description:"If true, field errors are written into the form next to the item(s) where the errors\n occurred.  Errors may appear as text or just an icon (via ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}:false}.\n <P>\n If false, errors are written at the top of the form.\n <P>\n To do some other kind of error display, override ${isc.DocUtils.linkForRef('method:DynamicForm.showErrors')}.",
        name:"showInlineErrors",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["validation"]
    },
    "attr:Hilite.title":{
        ref:"attr:Hilite.title",
        flags:"IRW",
        description:"User-visible title for this hilite.  Used for interfaces such as menus that can enable or\n disable hilites.",
        name:"title",
        seeAlso:[],
        valueType:"String",
        defaultValue:"false",
        type:"attr",
        definingClass:"object:Hilite"
    },
    "method:DynamicForm.setError":{
        ref:"method:DynamicForm.setError",
        deprecated:"This method has been deprecated as of SmartClient release 5.7.  Use ${isc.DocUtils.linkForRef('method:DynamicForm.addFieldErrors')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setFieldErrors')} instead",
        flags:"A",
        description:"          Sets error message(s) for the specified itemName to the error string or array of\n          strings. You must call form.markForRedraw() to display the new error message(s).<br>\n          <b>Note:</b> you can call this multiple times for an individual itemName\n			 which will result in an array of errors being remembered.\n\n",
        name:"setError",
        seeAlso:[],
        params:[
            {description:"name of the item to set", optional:false, name:"itemName", defaultValue:null,
             type:"string"},
            {description:"error message string or array of strings", optional:false,
             name:"errorMessage", defaultValue:null, type:"string|array"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["errors"]
    },
    "attr:TreeGrid.showRoot":{
        ref:"attr:TreeGrid.showRoot",
        flags:"IR",
        description:"Specifies whether the root node should be displayed in the treeGrid.\n <P>\n This property is only available for \"children\" modelType trees, hence is not allowed for\n trees that load data from the server dynamically via ${isc.DocUtils.linkForRef('method:TreeGrid.fetchData')}.  \n <P>\n To get the equivalent of a visible \"root\" node in a tree that loads data dynamically,\n add a singular, top-level parent to the data.  However, note that this top-level parent\n will technically be the only child of root, and the implicit root object will be\n returned by ${isc.DocUtils.linkForRef('method:Tree.getRoot','this.data.getRoot()')}.",
        name:"showRoot",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeField"]
    },
    "method:ListGrid.setData":{
        ref:"method:ListGrid.setData",
        flags:"",
        description:" Initialize the data object with the given array. Observes methods of the data object\n so that when the data changes, the listGrid will redraw automatically.\n",
        name:"setData",
        seeAlso:[],
        params:[
            {description:"data to show in the list", optional:false, name:"newData", defaultValue:null,
             type:"List of ListGridRecord"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["data"]
    },
    "attr:ComboBoxItem.showAllOptions":{
        ref:"attr:ComboBoxItem.showAllOptions",
        flags:"IR",
        description:"If true, even non-matching options will be shown, with configurable \n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.separatorRows','separator rows')} in between.  Not valid for\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.optionDataSource','databound pickLists')}.",
        name:"showAllOptions",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "method:FilterBuilder.getCriteria":{
        ref:"method:FilterBuilder.getCriteria",
        flags:"",
        description:" Get the criteria entered by the user.\n \n",
        name:"getCriteria",
        seeAlso:[],
        returns:{description:null, type:"AdvancedCriteria"},
        type:"method",
        definingClass:"class:FilterBuilder"
    },
    "classAttr:GroupingMessages.upcomingTomorrowTitle":{
        ref:"classAttr:GroupingMessages.upcomingTomorrowTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs tomorrow,\n relative to the current date.",
        name:"upcomingTomorrowTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Tomorrow\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:["i18nMessages"]
    },
    "method:Canvas.getScrollTop":{
        ref:"method:Canvas.getScrollTop",
        flags:"A",
        description:" Get the number of pixels this Canvas is scrolled from its top edge.\n",
        name:"getScrollTop",
        seeAlso:[],
        returns:{description:"scrollTop", type:"number"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning", "scrolling"]
    },
    "attr:ListGrid.dataPageSize":{
        ref:"attr:ListGrid.dataPageSize",
        flags:"IRW",
        description:"When using data paging, how many records to fetch at a time.  The value of this\n attribute is passed on to the auto-constructed ${isc.DocUtils.linkForRef('class:ResultSet')} object for this\n component.  In effect, this gives you control over the ${isc.DocUtils.linkForRef('attr:ResultSet.resultSize')}\n attribute for this component.\n <P>\n <b>Note</b> that regardless of the <code>dataPageSize</code> setting, a component will always fetch\n all of data that it needs to draw.  Settings such as\n ${isc.DocUtils.linkForRef('attr:ListGrid.showAllRecords','showAllRecords:true')},\n ${isc.DocUtils.linkForRef('attr:ListGrid.drawAllMaxCells','drawAllMaxCells')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.drawAheadRatio','drawAheadRatio')} can cause more rows than the configured\n <code>dataPageSize</code> to be fetched.",
        name:"dataPageSize",
        seeAlso:[
            {ref:"attr:ResultSet.resultSize", description:null}
        ],
        valueType:"integer",
        defaultValue:"75",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('databoundFetch')}"],
        definingClass:"class:ListGrid",
        groups:["performance"]
    },
    "group:ancestry":{
        ref:"group:ancestry",
        refs:["type:DisplayNodeType"],
        description:"Parent/child relationships",
        name:"ancestry",
        seeAlso:[],
        type:"group"
    },
    "classMethod:Log.echoLeaf":{
        ref:"classMethod:Log.echoLeaf",
        flags:"",
        description:" Return a very short (generally less than 40 characters) string representation of any object,\n suitable for viewing by a developer for debugging purposes.\n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.echoLeaf\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n\n",
        name:"echoLeaf",
        seeAlso:[
            {ref:"method:Class.echo", description:null}
        ],
        params:[
            {description:"object to echo", optional:false, name:"obj", defaultValue:null, type:"any"}
        ],
        returns:{description:"a short string representation of the object", type:"string"},
        type:"classMethod",
        definingClass:"class:Log",
        groups:["debug"]
    },
    "method:DetailViewer.exportData":{
        ref:"method:DetailViewer.exportData",
        flags:"",
        description:" Uses a \"fetch\" operation on the current ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dataSource','DataSource')} to \n retrieve data that matches the current filter and sort criteria for this component, then \n exports the resulting data to a file or window in the requested format.\n <P>\n For more information on exporting data, see ${isc.DocUtils.linkForRef('method:DataSource.exportData')}.\n\n",
        name:"exportData",
        seeAlso:[],
        params:[
            {description:"additional properties to set on the DSRequest                                            that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        definingClass:"class:DetailViewer",
        groups:["dataBoundComponentMethods"]
    },
    "group:menuBasic":{
        ref:"group:menuBasic",
        refs:["method:MenuItem.action", "attr:MenuItem.title", "attr:MenuItem.submenu", 
         "attr:MenuItem.isSeparator","attr:MenuItem.enabled"],
        name:"menuBasic",
        seeAlso:[],
        type:"group"
    },
    "method:GridRenderer.getRowHeight":{
        ref:"method:GridRenderer.getRowHeight",
        flags:"",
        description:" Return the height this row should be.  Default is this.cellHeight. If\n ${isc.DocUtils.linkForRef('attr:GridRenderer.fixedRowHeights')} is false, the row may be rendered taller than this\n specified size.\n\n",
        name:"getRowHeight",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number", optional:false, name:"rowNum", defaultValue:null, type:"number"}
        ],
        returns:{description:"height in pixels", type:"number"},
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "attr:PickList.filterLocally":{
        ref:"attr:PickList.filterLocally",
        flags:"IRA",
        description:"If <code>filterLocally</code> is set for this item, and this item is showing options \n from a dataSource, fetch the entire set of options from the server, and use these values\n to map the item value to the appropriate display value. Also use <code>\"local\"</code>\n type filtering on drop down list of options.\n <P>\n This means data will only be fetched once from the server, and then filtered on the\n client.",
        name:"filterLocally",
        seeAlso:[
            {ref:"attr:FormItem.filterLocally", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"interface:PickList"
    },
    "attr:RestDataSource.fetchDataURL":{
        ref:"attr:RestDataSource.fetchDataURL",
        flags:"IR",
        description:"Custom dataURL for fetch type operations",
        name:"fetchDataURL",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RestDataSource"
    },
    "type:TileLayoutPolicy":{
        ref:"type:TileLayoutPolicy",
        values:[
            {description:"Each line has the same number of tiles, based on ${isc.DocUtils.linkForRef('attr:TileLayout.tilesPerLine')} if set, otherwise,\n based on fitting as many tiles per line as possible consistent with\n ${isc.DocUtils.linkForRef('attr:TileLayout.tileSize','tileSize')} and ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin')}. \n <P>\n Tiles that do not specify a size will be sized to fill available space.",
             value:"\"fit\""},
            {description:"Tiles are laid out with varying numbers of tiles per line according to each tile's size,\n the ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin','tileMargin')}, and the available space.\n <P>\n Tiles are never resized by the TileLayout and ${isc.DocUtils.linkForRef('attr:TileLayout.tileSize')} is ignored.",
             value:"\"flow\""}
        ],
        description:"Policy for laying out tiles. \n <P>\n Because a TileLayout can be either horizontally or vertically oriented, the general term\n \"line\" is used to mean either a row or column of tiles. \n <P>\n <b>NOTE</b>: for typical form layouts (a variety of input fields and buttons in a\n tabular layout with col-spanning and row-spanning support), use a ${isc.DocUtils.linkForRef('class:DynamicForm')} and\n see the ${isc.DocUtils.linkForRef('group:formLayout')} topic.",
        name:"TileLayoutPolicy",
        seeAlso:[],
        type:"type"
    },
    "attr:ListGrid.sortDirection":{
        flags:"IRW",
        type:"attr",
        ref:"attr:ListGrid.sortDirection",
        description:"Sorting direction of this ListGrid. If specified when the ListGrid is initialized,\n this property will be the default sorting direction for the ${isc.DocUtils.linkForRef('attr:ListGrid.sortField')}.\n May be overridden by specifying ${isc.DocUtils.linkForRef('attr:ListGridField.sortDirection')}.\n <P>\n After initialization, this property will be updated on ${isc.DocUtils.linkForRef('method:ListGrid.sort')} to reflect\n the current sort direction of the grid.",
        name:"sortDirection",
        setter:["listGrid.sort"],
        valueType:"SortDirection",
        seeAlso:[
            {ref:"type:SortDirection", description:null}
        ],
        examples:["${isc.DocUtils.linkForExampleId('sort')}"],
        defaultValue:"Array.ASCENDING",
        groups:["sorting"],
        definingClass:"class:ListGrid"
    },
    "attr:ResultTree.disableCacheSync":{
        ref:"attr:ResultTree.disableCacheSync",
        flags:"IRA",
        description:"By default when the data of this ResultSet's dataSource is modified, the ResultSet will\n be updated to display these changes.\n Set this flag to true to disable this behavior.",
        name:"disableCacheSync",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ResultTree",
        groups:["cacheSync"]
    },
    "method:ListGrid.getEditValues":{
        ref:"method:ListGrid.getEditValues",
        flags:"",
        description:" Returns the current set of unsaved edits for a given row being edited.\n\n",
        name:"getEditValues",
        seeAlso:[],
        params:[
            {description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
             optional:false, name:"valuesID", defaultValue:null, type:"number | Object"}
        ],
        returns:{description:"Current editValues object for the row.  This contains the current                     edit values in {fieldName1:value1, fieldName2:value2} format.",
         type:"object"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "classAttr:ValidatorTypes.lengthRange":{
        ref:"classAttr:ValidatorTypes.lengthRange",
        flags:"IR",
        description:"This validator type applies to string values only.  If the value is a string value\n  validation will fail if the strings length falls outside the range specified by \n  <code>validator.max</code> and <code>validator.min</code>.<br>\n  Note that non-string values will always pass validation by this validator type.<br>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        name:"lengthRange",
        seeAlso:[],
        valueType:"validatorDefinition",
        defaultValue:"object",
        type:"classAttr",
        definingClass:"class:ValidatorTypes"
    },
    "attr:OperationBinding.operationType":{
        ref:"attr:OperationBinding.operationType",
        flags:"IR",
        description:"Which operationType this operationBinding is for.  This property is only settable on an operationBinding, not\n a DataSource as a whole.",
        name:"operationType",
        seeAlso:[],
        valueType:"DSOperationType",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:["clientDataIntegration"]
    },
    "attr:RPCRequest.useXmlHttpRequest":{
        ref:"attr:RPCRequest.useXmlHttpRequest",
        deprecated:"As of SmartClient 5.5, use ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.  If you specify a value for this property, it will take precedence over ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.",
        flags:"IRWA",
        description:"Selects the default http transport for this RPCRequest.  If set to true, this request will use\n XMLHttpRequest for the transport to the server.  If set to false it will use a hidden frame.  If\n left unset, the transport mechanism is determined from the RPCManager default set in \n ${isc.DocUtils.linkForRef('classAttr:RPCManager.useXmlHttpRequest')}\n <p>\n If you're using queueing, note that all requests in the queue must use the same transport.\n If you attempt to send a request via a different transport than those that are currently on\n the queue, it will be sent to the server separately, ahead of the queue, and a warning will\n be logged to the Developer Console.\n <p>\n If you specify <code>true</code> for this attribute and XMLHttp is not available, a warning\n will be logged to the Developer Console and RPCManager will attempt to use the frames\n transport for this request.  Note that some features like\n ${isc.DocUtils.linkForRef('attr:RPCRequest.serverOutputAsString')} requre the XMLHttp transport and will not work if the\n XMLHttp transport is unavailable (this can happen if the end user is using Internet Explorer\n and has disabled ActiveX).  You can query the availability of XMLHttp by calling\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.xmlHttpRequestAvailable')}",
        name:"useXmlHttpRequest",
        seeAlso:[
            {ref:"classAttr:RPCManager.useXmlHttpRequest", description:null},
            {ref:"classMethod:RPCManager.xmlHttpRequestAvailable", description:null}
        ],
        valueType:"boolean",
        defaultValue:"RPCManager.useXmlHttpRequest",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "method:Canvas.getHoverHTML":{
        ref:"method:Canvas.getHoverHTML",
        flags:"",
        description:" If <code>this.showHover</code> is true, when the user holds the mouse over this Canvas for\n long enough to trigger a hover event, a hover canvas is shown by default. This method returns\n the contents of that hover canvas. Default implementation returns <code>this.prompt</code> -\n override for custom hover HTML. Note that returning <code>null</code> or an empty string will\n suppress the hover canvas altogether.\n",
        name:"getHoverHTML",
        seeAlso:[
            {ref:"attr:Canvas.showHover", description:null}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["hovers"]
    },
    "method:Calendar.getCurrentViewName":{
        ref:"method:Calendar.getCurrentViewName",
        flags:"",
        description:" Get the name of the visible view. Either 'day', 'week', or 'month'.\n\n",
        name:"getCurrentViewName",
        seeAlso:[],
        returns:{description:"The name of the visible view.", type:"string"},
        type:"method",
        definingClass:"class:Calendar"
    },
    "attr:ListGridField.suppressValueIcon":{
        ref:"attr:ListGridField.suppressValueIcon",
        flags:"IRW",
        description:"If this field has a valueIcons property specified, setting this property to true will \n prevent the valueIcon being written out into this field's cells.",
        name:"suppressValueIcon",
        seeAlso:[
            {ref:"attr:ListGridField.valueIcons", description:null},
            {ref:"attr:ListGridField.showValueIconOnly", description:null}
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "attr:ResultSet.dropCacheOnUpdate":{
        ref:"attr:ResultSet.dropCacheOnUpdate",
        flags:"IRA",
        description:"Whether to discard all cached rows when a modification operation (add, update, remove)\n occurs on the ResultSet's DataSource.\n <P>\n A ResultSet that has a complete cache for the current filter criteria can potentially\n incorporate a newly created or updated row based on the data that the server returns\n when a modification operation completes.  However this is not always possible for\n ResultSets that show some types of joins, or when the server cannot easily return update\n data.  In this case set <code>dropCacheOnUpdate</code> to cause the cache to be\n discarded when an update occurs.\n <P>\n <code>dropCacheOnUpdate</code> can be set either directly on a ResultSet, or on a\n DataSource in order to affect all ResultSets on that DataSource.",
        name:"dropCacheOnUpdate",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ResultSet",
        groups:["cacheSync"]
    },
    "method:DatabaseBrowser.getResults":{
        ref:"method:DatabaseBrowser.getResults",
        flags:"",
        description:" \n",
        name:"getResults",
        seeAlso:[],
        type:"method",
        definingClass:"class:DatabaseBrowser"
    },
    "group:validtion":{
        ref:"group:validtion",
        refs:["method:ListGrid.clearRowErrors"],
        name:"validtion",
        seeAlso:[],
        type:"group"
    },
    "attr:TreeNode.parentId":{
        ref:"attr:TreeNode.parentId",
        flags:"IR",
        description:"For trees with modelType \"parent\", this property specifies unique parent ID of this node.\n The unique ID of a node, together with the unique ID of its parent is used by\n ${isc.DocUtils.linkForRef('method:Tree.linkNodes')} to link a list of nodes into a tree.\n <p>\n Note: the name of this property can be changed by setting ${isc.DocUtils.linkForRef('attr:Tree.parentIdField')}.",
        name:"parentId",
        seeAlso:[
            {ref:"attr:TreeNode.id", description:null},
            {ref:"method:Tree.linkNodes", description:null},
            {ref:"attr:Tree.modelType", description:null},
            {ref:"attr:Tree.parentIdField", description:null}
        ],
        valueType:"String or Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:TreeNode"
    },
    "attr:ListGrid.freezeFieldText":{
        ref:"attr:ListGrid.freezeFieldText",
        flags:"IRWA",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid and\n ${isc.DocUtils.linkForRef('attr:ListGrid.canFreezeFields','this.canFreezeFields')} is true, this string will be shown as the\n title for the menu item to freeze a currently unfrozen field.\n <P>\n This is a dynamic string - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>viewer</code> available as a variable mapped to\n the ListGrid instance, and <code>field</code> as a variable pointing to the ListGrid field.\n <P>\n Default value returns \"Freeze \" + the field's summary title.",
        name:"freezeFieldText",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Freeze \\${viewer.getSummaryTitle(field)}\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["i18nMessages"]
    },
    "classMethod:Page.getScreenWidth":{
        ref:"classMethod:Page.getScreenWidth",
        flags:"",
        description:"		Get the width of the user's screen, in pixels.\n",
        name:"getScreenWidth",
        seeAlso:[],
        type:"classMethod",
        definingClass:"class:Page"
    },
    "method:ColorPicker.setSaturation":{
        ref:"method:ColorPicker.setSaturation",
        flags:"",
        description:" Sets the Saturation of the selected color\n",
        name:"setSaturation",
        seeAlso:[
            {ref:"method:ColorPicker.getSaturation", description:null}
        ],
        params:[
            {description:"An integer between 0 and 240", optional:false, name:"newValue",
             defaultValue:null, type:"Number"}
        ],
        type:"method",
        definingClass:"class:ColorPicker"
    },
    "attr:Scrollbar.skinImgDir":{
        ref:"attr:Scrollbar.skinImgDir",
        flags:"IRA",
        description:"Where are the skin images for the Scrollbar.  This is local to the ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','overall skin directory')}.",
        name:"skinImgDir",
        seeAlso:[],
        valueType:"URL",
        defaultValue:"\"images/Scrollbar/\"",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:["images"]
    },
    "attr:GridRenderer.showAllRows":{
        ref:"attr:GridRenderer.showAllRows",
        flags:"IRA",
        description:"Whether all rows should be drawn all at once, or only rows visible in the viewport.<br><br>\n\n Drawing all rows causes longer initial rendering time, but allows smoother vertical scrolling.\n With a very large number of rows, showAllRows will become too slow.",
        name:"showAllRows",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["performance"]
    },
    "attr:Canvas.edgeCenterBackgroundColor":{
        ref:"attr:Canvas.edgeCenterBackgroundColor",
        flags:"IR",
        description:"Background color for the center section only.  Can be used as a surrogate background\n color for the decorated Canvas, if the Canvas is set to partially overlap the edges and\n hence can't show a background color itself without occluding media.",
        name:"edgeCenterBackgroundColor",
        seeAlso:[],
        valueType:"Color",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["imageEdges"]
    },
    "attr:TabSet.tabBarThickness":{
        ref:"attr:TabSet.tabBarThickness",
        flags:"IRW",
        description:"Thickness of tabBar, applies to either orientation (specifies height for horizontal,\n width for vertical orientation).  Note that overriding this value for TabSets that are\n skinned with images generally means providing new media for the borders.",
        name:"tabBarThickness",
        seeAlso:[],
        valueType:"number",
        defaultValue:"21",
        type:"attr",
        definingClass:"class:TabSet",
        groups:["tabBar"]
    },
    "method:Tree.getParent":{
        ref:"method:Tree.getParent",
        flags:"",
        description:"\n Returns the parent of this node.\n\n",
        name:"getParent",
        seeAlso:[],
        params:[
            {description:"node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"parent of this node", type:"node"},
        type:"method",
        definingClass:"class:Tree"
    },
    "method:Class.logError":{
        ref:"method:Class.logError",
        flags:"",
        description:" Log a message at \"error\" priority\n \n",
        name:"logError",
        seeAlso:[
            {ref:"classMethod:Log.logDebug", description:"for usage info"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"method",
        definingClass:"class:Class"
    },
    "attr:FormItem.iconPrompt":{
        ref:"attr:FormItem.iconPrompt",
        flags:"IRWA",
        description:"Default prompt (and tooltip-text) for icons.",
        name:"iconPrompt",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"\"",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["formIcons"]
    },
    "method:Canvas.mouseOut":{
        ref:"method:Canvas.mouseOut",
        flags:"A",
        description:"\n Executed when the mouse leaves this widget.  No default implementation.\n\n",
        name:"mouseOut",
        seeAlso:[],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('customMouseEvents')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:StatefulCanvas.setAutoFit":{
        ref:"method:StatefulCanvas.setAutoFit",
        flags:"",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        name:"setAutoFit",
        seeAlso:[],
        params:[
            {description:"New autoFit setting.", optional:false, name:"autoFit", defaultValue:null,
             type:"boolean"}
        ],
        type:"method",
        definingClass:"class:StatefulCanvas"
    },
    "attr:DynamicForm.cancelParamValue":{
        ref:"attr:DynamicForm.cancelParamValue",
        flags:"IRW",
        description:"The value of the special field sent to the server as part of ${isc.DocUtils.linkForRef('method:DynamicForm.cancel')}",
        name:"cancelParamValue",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"cancel\"",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "attr:FormItem.showDisabled":{
        ref:"attr:FormItem.showDisabled",
        flags:"IRWA",
        description:"When this item is disabled, should it be re-styled to indicate its disabled state?",
        name:"showDisabled",
        seeAlso:[
            {ref:"attr:FormItem.cellStyle", description:null}
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["appearance"]
    },
    "method:Layout.setLayoutMargin":{
        ref:"method:Layout.setLayoutMargin",
        flags:"",
        description:" Method to force a reflow of the layout after directly assigning a value to any of the\n layout*Margin properties. Takes no arguments.\n\n",
        name:"setLayoutMargin",
        seeAlso:[],
        type:"method",
        definingClass:"class:Layout",
        groups:["layoutMargin"]
    },
    "method:Selection.deselectAll":{
        ref:"method:Selection.deselectAll",
        flags:"",
        description:"			Deselect ALL records of the list\n",
        name:"deselectAll",
        seeAlso:[],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:Selection",
        groups:["selection"]
    },
    "attr:Calendar.dayHeaderBaseStyle":{
        ref:"attr:Calendar.dayHeaderBaseStyle",
        flags:"IRW",
        description:"The base name for the CSS class applied to the day headers of the month view.\n This style will have \"Dark\", \"Over\", \"Selected\", or \"Disabled\"\n appended to it according to the state of the cell.",
        name:"dayHeaderBaseStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"calMonthDayHeader\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["appearance"]
    },
    "method:FilterBuilder.filterChanged":{
        ref:"method:FilterBuilder.filterChanged",
        flags:"",
        description:" Handler fired when there is a change() event fired on any FormItem within the \n filterBuilder. \n\n",
        name:"filterChanged",
        seeAlso:[],
        type:"method",
        definingClass:"class:FilterBuilder"
    },
    "attr:ListGrid.ungroupText":{
        ref:"attr:ListGrid.ungroupText",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.isGrouped','this.isGrouped')} is true, this\n attribute will be shown as the title for the menu item to ungroup the grid.",
        name:"ungroupText",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Ungroup\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["i18nMessages"]
    },
    "group:shadow":{
        ref:"group:shadow",
        refs:["method:Canvas.setShowShadow", "attr:Canvas.showShadow", "attr:Canvas.shadowDepth", 
         "attr:Canvas.shadowOffset","attr:Canvas.shadowSoftness", "attr:Canvas.shadowImage"],
        name:"shadow",
        seeAlso:[],
        type:"group"
    },
    "attr:DataSource.showLocalFieldsOnly":{
        ref:"attr:DataSource.showLocalFieldsOnly",
        flags:"IR",
        description:"For a DataSource that inherits ${isc.DocUtils.linkForRef('attr:DataSource.fields')} from another DataSource \n (via ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')}), indicates that only the fields listed in this DataSource\n should be shown.  All other inherited parent fields will be marked \"hidden:true\".",
        name:"showLocalFieldsOnly",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSource",
        groups:["fields"]
    },
    "classMethod:Log.logWarn":{
        ref:"classMethod:Log.logWarn",
        flags:"",
        description:" Log a message at \"warn\" priority\n \n",
        name:"logWarn",
        seeAlso:[
            {ref:"classMethod:Log.logDebug", description:"for usage info"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:ListGrid.booleanImageHeight":{
        ref:"attr:ListGrid.booleanImageHeight",
        flags:"IRWA",
        description:"Height for the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} and the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')}\n Note: If ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} is unset, the ${isc.DocUtils.linkForRef('attr:CheckboxItem.checkedImage')}\n will be used to indicate a true value in a boolean field. In this case this property is\n ignored in favor of ${isc.DocUtils.linkForRef('attr:CheckboxItem.valueIconHeight')}.",
        name:"booleanImageHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["imageColumns"]
    },
    "method:ImgButton.setIcon":{
        ref:"method:ImgButton.setIcon",
        flags:"",
        description:" Change the icon being shown next to the title text.\n",
        name:"setIcon",
        seeAlso:[],
        params:[
            {description:"URL of new icon", optional:false, name:"icon", defaultValue:null, type:"URL"}
        ],
        type:"method",
        definingClass:"class:ImgButton",
        groups:["buttonIcon"]
    },
    "type:PromptStyle":{
        ref:"type:PromptStyle",
        values:[
            {description:"Displays a centered modal prompt with text specified by                 ${isc.DocUtils.linkForRef('attr:RPCRequest.prompt')}",
             value:"\"dialog\""},
            {description:"Changes the current cursor to the style specified by                 ${isc.DocUtils.linkForRef('attr:RPCRequest.promptCursor')}",
             value:"\"cursor\""}
        ],
        description:null,
        name:"PromptStyle",
        seeAlso:[],
        type:"type"
    },
    "attr:SelectItem.optionDataSource":{
        ref:"attr:SelectItem.optionDataSource",
        flags:"IRA",
        description:"If set, this FormItem will derive data to show in the PickList by fetching records from\n the specified <code>optionDataSource</code>.  The fetched data will be used as a\n ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')} by extracting the\n ${isc.DocUtils.linkForRef('attr:FormItem.valueField','valueField')} and ${isc.DocUtils.linkForRef('attr:FormItem.displayField','displayField')} in\n the loaded records, to derive one valueMap entry per record loaded from the\n optionDataSource.  Multiple fields from the fetched data may be shown in the pickList by\n setting ${isc.DocUtils.linkForRef('attr:SelectItem.pickListFields')}.\n <P>\n The data will be retrieved via a \"fetch\" operation on the DataSource, passing the \n ${isc.DocUtils.linkForRef('attr:PickList.pickListCriteria')} (if set) as criteria, and passing\n ${isc.DocUtils.linkForRef('attr:SelectItem.optionFilterContext')} (if set) as DSRequest properties.\n <P>\n The fetch will be triggered when the pickList is first shown, or, you can set\n ${isc.DocUtils.linkForRef('attr:SelectItem.autoFetchData','autoFetchData:true')} to fetch when the FormItem is\n first drawn.  \n <P>\n Note that providing an initial value when\n ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues','fetchMissingValues')} is enabled, or enabling\n ${isc.DocUtils.linkForRef('attr:SelectItem.defaultToFirstOption','defaultToFirstOption')}, can also cause a fetch to\n be initiated immediately upon form creation.  You can also call ${isc.DocUtils.linkForRef('method:PickList.fetchData')}\n at any time to manually trigger a fetch.\n <P>\n Data paging is automatically enabled if the optionDataSource supports it.  As the\n pickList is scrolled by the user, requests for additional data will be automatically\n issued.\n <P>\n For a pickList attached to a ComboBoxItem, new fetches are issued as the user types,\n with criteria set as described under ${isc.DocUtils.linkForRef('method:ComboBoxItem.getPickListFilterCriteria')}.\n If your dataSource is not capable of filtering results by search criteria (eg the\n dataSource is backed by an XML flat file), you can set ${isc.DocUtils.linkForRef('attr:SelectItem.filterLocally')} to have the\n entire dataset loaded up front and filtering performed in the browser.  This disables\n data paging.\n <P>\n Note that if a normal, static ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')} is <b>also</b> specified\n for the field (either directly in the form item or as part of the field definition in\n the dataSource), it will be preferred to the data derived from the optionDataSource for\n whatever mappings are present.",
        name:"optionDataSource",
        seeAlso:[],
        valueType:"DataSource | String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SelectItem"
    },
    "class:XJSONDataSource":{
        methods:[],
        ref:"class:XJSONDataSource",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Data Binding"],
        attrs:[],
        description:"A DataSource preconfigured to use the ${isc.DocUtils.linkForRef('type:RPCTransport','\"scriptInclude\"')} transport\n for cross-domain calls to JSON services, such as those provided\n by <a href='http://developer.yahoo.net/common/json.html#callbackparam' onclick=\"window.open('http://developer.yahoo.net/common/json.html#callbackparam');return false;\">Yahoo</a>.\n <P>\n To use this DataSource, provide the URL of the service as ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')}, and\n provide ${isc.DocUtils.linkForRef('attr:DataSource.fields','fields')} that describe the structure of the part of the\n returned data that you would like to use.\n <P>\n ${isc.DocUtils.linkForRef('attr:DataSource.recordXPath')} and ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath')} can be used to extract\n data from the structure returned by the service.\n <P>\n This XJSONDataSource is really a subclass of DataSource with just a few property settings:\n <pre>\n    dataFormat : \"json\",\n    dataTransport : \"scriptInclude\"\n    callbackParam : \"callback\"\n </pre>\n <P>\n NOTE: if you use this DataSource to contact Yahoo web services, remember to include\n output=json in the dataURL, as well as a\n <a href='http://developer.yahoo.net/' onclick=\"window.open('http://developer.yahoo.net/');return false;\">Yahoo developer ID</a>.",
        name:"XJSONDataSource",
        seeAlso:[],
        type:"class",
        examples:["${isc.DocUtils.linkForExampleId('jsonYahooWebServices')}"]
    },
    "method:DetailViewer.getCellCSSText":{
        ref:"method:DetailViewer.getCellCSSText",
        flags:"",
        description:" Return CSS text for styling this cell, which will be applied in addition to the CSS class\n for the cell, as overrides.\n <p>\n \"CSS text\" means semicolon-separated style settings, suitable for inclusion in a CSS\n stylesheet or in a STYLE attribute of an HTML element.\n\n",
        name:"getCellCSSText",
        seeAlso:[],
        params:[
            {description:"actual value of this cell", optional:false, name:"value", defaultValue:null,
             type:"any"},
            {description:"field object for this cell", optional:false, name:"field", defaultValue:null,
             type:"DetailViewerField"},
            {description:"record object for this cell", optional:false, name:"record",
             defaultValue:null, type:"Record"},
            {description:"the viewer instance to which this cell belongs", optional:false,
             name:"viewer", defaultValue:null, type:"DetailViewer"}
        ],
        returns:{description:"CSS text to add to this cell", type:"CSSText"},
        type:"method",
        definingClass:"class:DetailViewer",
        groups:["apperance"]
    },
    "attr:RadioGroupItem.vertical":{
        ref:"attr:RadioGroupItem.vertical",
        flags:"IRW",
        description:"True == display options vertically, false == display in a single row",
        name:"vertical",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RadioGroupItem",
        groups:["appearance"]
    },
    "attr:HibernateBrowser.excludeSubstring":{
        ref:"attr:HibernateBrowser.excludeSubstring",
        flags:"IR",
        description:"If set, specifies a substring which must NOT exist in an entity name for it to be included in\n this HibernateBrowser.  If this property is set to a List of strings, entity names are\n excluded if they match any one of the strings.  The comparison is case-insensitive.\n <p>\n For example, <code>excludeSubstring: [\"Order\", \"inv\"]</code> would exclude all the following \n entity names: \"ORDERS\", \"Inventory\", \"client_invoicing\"\n <p>\n Note that if you specify both include and exclude criteria and they conflict (ie,\n according to the criteria you set, an entity should be both included and excluded), \n exclude wins.",
        name:"excludeSubstring",
        seeAlso:[],
        valueType:"String | List of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:HibernateBrowser"
    },
    "attr:ListGrid.listEndEditAction":{
        ref:"attr:ListGrid.listEndEditAction",
        flags:"IRW",
        description:"If the user is editing the last record in this listGrid, and attempts to navigate \n beyond the last row either by tabbing off the last editable field, or using the down\n arrow key, this property determines what action to take:<ul>\n <li>\"next\": start editing a new record at the end of the list.\n <li>\"done\": hide the editor\n <li>\"stop\": leave focus in the cell being edited\n </ul>",
        name:"listEndEditAction",
        seeAlso:[],
        valueType:"RowEndEditAction",
        defaultValue:"\"stop\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('enterNewRows')}"],
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "method:TreeGrid.folderClosed":{
        ref:"method:TreeGrid.folderClosed",
        flags:"",
        description:"\n This method is called when a folder is closed either via the user manipulating the\n expand/collapse control in the UI or via ${isc.DocUtils.linkForRef('method:TreeGrid.closeFolder')}.  You can return\n <code>false</code> to cancel the close.\n\n",
        name:"folderClosed",
        seeAlso:[],
        params:[
            {description:"the folder (record) that is being closed", optional:false, name:"node",
             defaultValue:null, type:"TreeNode"}
        ],
        returns:{description:"false to cancel the close, true to all it to proceed", type:"boolean"},
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:DataSource.getTypeOperators":{
        ref:"method:DataSource.getTypeOperators",
        flags:"",
        description:" Get the list of ${isc.DocUtils.linkForRef('type:OperatorId')}s available on this DataSource for the given ${isc.DocUtils.linkForRef('type:FieldType')}.\n <P>\n If ${isc.DocUtils.linkForRef('method:DataSource.setTypeOperators')} has been called for this DataSource and Fieldtype, returns that\n list, otherwise, returns the set of valid operators for the ${isc.DocUtils.linkForRef('type:FieldType')} as specified by \n ${isc.DocUtils.linkForRef('attr:SimpleType.validOperators')}, otherwise, the system-wide set of valid operators for the\n type as registered via ${isc.DocUtils.linkForRef('classMethod:DataSource.addSearchOperator')}.\n \n",
        name:"getTypeOperators",
        seeAlso:[],
        params:[
            {description:null, optional:false, name:"typeName", defaultValue:null, type:"FieldType"}
        ],
        returns:{description:"available Operators", type:"Array of OperatorId"},
        type:"method",
        definingClass:"class:DataSource",
        groups:["advancedFilter"]
    },
    "attr:TabSet.showPaneContainerEdges":{
        ref:"attr:TabSet.showPaneContainerEdges",
        flags:"IRWA",
        description:"Should the paneContainer for this tabset show ${isc.DocUtils.linkForRef('attr:Canvas.showEdges','edges')}.",
        name:"showPaneContainerEdges",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "method:List.first":{
        ref:"method:List.first",
        flags:"",
        description:" Return the first item in this list\n\n",
        name:"first",
        seeAlso:[],
        returns:{description:"first item in the list", type:"any"},
        type:"method",
        definingClass:"interface:List",
        groups:["access"]
    },
    "classMethod:RPCManager.clearTransaction":{
        ref:"classMethod:RPCManager.clearTransaction",
        flags:"A",
        description:" Erase all client-side record of a transaction, such that any response from the server\n will be ignored.\n <P>\n A transaction means a batch of one or more RPCRequests that have already been sent to\n the server via ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendQueue')}.\n\n",
        name:"clearTransaction",
        seeAlso:[
            {ref:"group:relogin", description:null}
        ],
        params:[
            {description:"id of the transaction to be cleared", optional:false, name:"transactionNum",
             defaultValue:null, type:"id"}
        ],
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "method:ListGrid.focusInFilterEditor":{
        ref:"method:ListGrid.focusInFilterEditor",
        flags:"",
        description:" If the filter editor (${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')}) is visible for this grid, \n this method will explictly put focus into the specified field in the filter editor.\n",
        name:"focusInFilterEditor",
        seeAlso:[],
        params:[
            {description:"Name of the field to put focus into. If unspecified focus will go                             to the first field in the editor",
             optional:true, name:"fieldName", defaultValue:null, type:"String"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["filterEditor"]
    },
    "method:ListGrid.unsort":{
        ref:"method:ListGrid.unsort",
        flags:"",
        description:" Turn sorting off, typically because data has changed and is no longer sorted.\n <p>\n Calling <code>unsort()</code> disables visual indication of which column is the sort column,\n and calls <code>unsort()</code> on the underlying dataset.\n <P>\n Note that a grid viewing a paged dataset may not be able to support <code>unsort()</code>\n because the sort order is what establishes the row numbering that allows data to be\n fetched in batches.\n <P>\n <code>unsort()</code> is automatically called when records are dropped or value of the\n sorted column is changed.\n\n",
        name:"unsort",
        seeAlso:[],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["sorting"]
    },
    "attr:DynamicForm.wrapItemTitles":{
        ref:"attr:DynamicForm.wrapItemTitles",
        flags:"IRW",
        description:"Whether titles for form items should wrap.  If not specified, titles will wrap by\n default.  Can be overridden for individual items via ${isc.DocUtils.linkForRef('attr:FormItem.wrapTitle')}",
        name:"wrapItemTitles",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["formTitles"]
    },
    "group:allowedOperations":{
        ref:"group:allowedOperations",
        title:"allowed operations",
        refs:["attr:Calendar.canCreateEvents", "attr:Calendar.canEditEvents", 
         "attr:Calendar.canDeleteEvents"],
        description:null,
        name:"allowedOperations",
        seeAlso:[],
        type:"group"
    },
    "classMethod:Class.logFatal":{
        ref:"classMethod:Class.logFatal",
        flags:"",
        description:" Log a message at \"fatal\" priority\n \n",
        name:"logFatal",
        seeAlso:[
            {ref:"classMethod:Log.logDebug", description:"for usage info"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "type:ObjectLiteral":{
        ref:"type:ObjectLiteral",
        description:"An \"Object literal\" is JavaScript shorthand for defining a JavaScript Object with a set\n of properties.  For example, code like this:\n <pre>\n    var request = {\n        actionURL : \"/foo.do\",\n        showPrompt:false\n    };</pre>\n .. is equivalent to ..\n <pre>\n    var request = new Object();\n    request.actionURL = \"/foo.do\";\n    request.showPrompt = false;</pre>\n In situations where a set of ${isc.DocUtils.linkForRef('type:Properties','properties')} may be passed to a\n method, the Object literal notation is much more compact.  For example:\n <pre>\n    isc.RPCManager.sendRequest({\n        actionURL : \"/foo.do\",\n        showPrompt:false\n    });</pre>\n <b>NOTE:</b> if you have a 'trailing comma' in an object literal, like so:\n <pre>\n    var request = {\n        actionURL : \"/foo.do\",\n        showPrompt:false, // TRAILING COMMA\n    };</pre>\n This is considered a syntax error by Internet Explorer, but not by Firefox.  This is by\n far the #1 cause of Internet Explorer-specific errors that do not occur in other\n browsers.  Pay special attention to this error, and, if you can, install the\n JSSyntaxScannerFilter into your development environment (as described in the\n ${isc.DocUtils.linkForRef('group:iscInstall','deployment instructions')}).",
        name:"ObjectLiteral",
        seeAlso:[],
        type:"type"
    },
    "attr:GridRenderer.emptyMessageStyle":{
        ref:"attr:GridRenderer.emptyMessageStyle",
        flags:"IRW",
        description:"The CSS style name applied to the emptyMessage string if displayed.",
        name:"emptyMessageStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["emptyMessage"]
    },
    "attr:CubeGrid.dataSource":{
        ref:"attr:CubeGrid.dataSource",
        flags:"IR",
        description:"Name of the DataSource to use to fetch CubeGrid data.\n <p>\n The DataSource should have a field named after each facetId.  The CubeGrid will submit\n requests for data as DataSource \"fetch\" operations that request \n ${isc.DocUtils.linkForRef('object:CellRecord','cellRecords')} only for currently visible area\n (including ${isc.DocUtils.linkForRef('attr:ListGrid.drawAheadRatio','drawAheadRatio')}).  The ${isc.DocUtils.linkForRef('type:Criteria')} passed\n in each fetch operation will be a ${isc.DocUtils.linkForRef('type:FacetValueMap')} that corresponds to a rectangular\n swath of cells the CubeGrid needs data for, for example:<pre>\n      { region:\"west\", product:[\"chair\", \"table\"], timePeriod:\"Q1 2004\" }\n </pre>\n Note that in the criteria above, the Array value for the \"product\" facet indicates the\n CubeGrid needs cellRecords for both the \"chair\" and \"table\" facetValues.\n <P>\n ${isc.DocUtils.linkForRef('attr:CubeGrid.fixedFacetValues')}, if any, are always sent in each \"fetch\" operation.\n <P>\n Scrolling, expanding/collapsing tree facets, pivoting, and changing the currently\n visibile facets may all trigger data requests.\n <P>\n The CubeGrid will generally attempt to fetch a minimal set of data to fill the viewport,\n sending multiple fetch operations in a batch (via ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','queueing')})\n which minimally describe newly revealed areas without specifying each individual cell.\n The CubeGrid will automatically handle being provided <i>more</i> data than was asked\n for, so server-side fetch-ahead policies can be implemented without any client-side\n customization.\n <P>\n Note that the ${isc.DocUtils.linkForRef('attr:DataSource.serverType','SQL connector')} shipped with the SmartClient\n SDK is capable of responding to the CubeGrid's data requests without writing any custom\n server code.",
        name:"dataSource",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "attr:ListGrid.fetchDelay":{
        ref:"attr:ListGrid.fetchDelay",
        flags:"IRWA",
        description:"If we're showing the filterEditor (${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is true), and we're\n re-filtering on every keypress (${isc.DocUtils.linkForRef('attr:ListGrid.filterOnKeypress')} is true), this \n property is the delay in milliseconds between the user changing the filter and the \n filter request being kicked off. If multiple changes are made to the filter \n within this fetch delay, only the most recent will actually cause a re-filter",
        name:"fetchDelay",
        seeAlso:[],
        valueType:"number",
        defaultValue:"300",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["filterEditor"]
    },
    "method:TileGrid.setFieldState":{
        ref:"method:TileGrid.setFieldState",
        flags:"",
        description:" Sets some presentation properties (visibility, width, userFormula and userSummary) of the \n grid fields based on the ${isc.DocUtils.linkForRef('type:listGridFieldState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to ${isc.DocUtils.linkForRef('method:TileGrid.getFieldState')}.\n\n",
        name:"setFieldState",
        seeAlso:[
            {ref:"method:TileGrid.getFieldState", description:null}
        ],
        params:[
            {description:"state to apply to the grid's fields.", optional:false, name:"fieldState",
             defaultValue:null, type:"listGridFieldState"}
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:["viewState"]
    },
    "classMethod:Log.setPriority":{
        ref:"classMethod:Log.setPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for this log category.\n <P>\n After calling setPriority, any messages logged to the given category whose priority is\n below the specified priority will not appear in the Log.\n\n",
        name:"setPriority",
        seeAlso:[
            {ref:"classMethod:Log.isEnabledFor",
             description:"to check whether a category would allow a log at a given priority"}
        ],
        params:[
            {description:"category name", optional:false, name:"category", defaultValue:null,
             type:"String"},
            {description:"priority level to set", optional:false, name:"priority", defaultValue:null,
             type:"LogPriority"},
            {description:"Optional ISC class or instance - if passed the priority will be set for logging \n      occurring on the class or instance only.",
             optional:true, name:"object", defaultValue:null, type:"Class or Instance object"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:Menu.submenuImage":{
        ref:"attr:Menu.submenuImage",
        flags:"IRWA",
        description:"Default image to use for the submenu indicator. Valid src, width and height must be\n specified. See ${isc.DocUtils.linkForRef('object:ImgProperties')} for format.<br>\n If ${isc.DocUtils.linkForRef('attr:Menu.submenuDirection')} is set to <code>\"left\"</code>, the image src will have\n the suffix <code>\"_left\"</code> appended to it.",
        name:"submenuImage",
        seeAlso:[],
        valueType:"ImgProperties",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:Menu"
    },
    "method:Canvas.resizeBy":{
        ref:"method:Canvas.resizeBy",
        flags:"",
        description:"			Resizes the widget, adding deltaX to its width and deltaY to its height (moves the right\n          and/or bottom sides of the widget).\n",
        name:"resizeBy",
        seeAlso:[],
        params:[
            {description:"amount to resize horizontally (may be negative)", optional:true,
             name:"deltaX", defaultValue:null, type:"number"},
            {description:"amount to resize vertically (may be negative)", optional:true, name:"deltaY",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"whether the component actually changed size", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('resize')}"],
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "method:Array.first":{
        ref:"method:Array.first",
        flags:"",
        description:" Return the first item in this list\n\n",
        name:"first",
        seeAlso:[],
        returns:{description:"first item in the list", type:"any"},
        type:"method",
        definingClass:"object:Array",
        groups:["access"]
    },
    "attr:RestDataSource.removeDataURL":{
        ref:"attr:RestDataSource.removeDataURL",
        flags:"IR",
        description:"dataURL for fetch type operations",
        name:"removeDataURL",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RestDataSource"
    },
    "attr:FormItem.suppressValueIcon":{
        ref:"attr:FormItem.suppressValueIcon",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.valueIcons')} is set, this property may be set to prevent the value\n icons from showing up next to the form items value",
        name:"suppressValueIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["valueIcons"]
    },
    "attr:RPCRequest.serverOutputAsString":{
        ref:"attr:RPCRequest.serverOutputAsString",
        flags:"IRWA",
        description:"Setting this flag makes the body of the HTTP response available as a String in the\n ${isc.DocUtils.linkForRef('attr:RPCRequest.callback')} as ${isc.DocUtils.linkForRef('attr:RPCResponse.data')}.  This is typically only useful if you\n are sending a request that will <b>not</b> be received by the SmartClient Java Server,\n however in that case, set ${isc.DocUtils.linkForRef('attr:RPCRequest.useSimpleHttp')}:true instead, which implies\n <code>serverOutputAsString:true</code>.\n <P>\n <code>serverOutputAsString:true</code> allows you to, for example, load the contents of\n static files off your webserver into a string for processing on the client with no server\n support.  The ${isc.DocUtils.linkForRef('attr:RPCRequest.actionURL')} must be in the same domain as the current page for\n this to work.\n <p>\n This feature relies on the XMLHttpRequest object which can be disabled by end-users in some\n supported browsers.  See ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information.\n <p>\n Generally this API is used for either ${isc.DocUtils.linkForRef('group:nonJavaBackend','non-Java backends')} \n or for advanced usage such as content that requires processing before it can be used in\n SmartClient components (such as client-side web scraping).  Note that SmartClient provides\n higher-level APIs for loading common types of data, see eg ${isc.DocUtils.linkForRef('class:HTMLFlow')} for HTML content,\n ${isc.DocUtils.linkForRef('class:ViewLoader')} for loading SmartClient components, ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXML')} for loading\n XML, ${isc.DocUtils.linkForRef('attr:RPCRequest.evalResult')} for loading <a href='http://www.json.org/' onclick=\"window.open('http://www.json.org/');return false;\">JSON</a>, and\n ${isc.DocUtils.linkForRef('class:DataSource')} for loading structured data in various formats.",
        name:"serverOutputAsString",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "attr:ComboBoxItem.filterWithValue":{
        ref:"attr:ComboBoxItem.filterWithValue",
        flags:"RA",
        description:"Read-only property set by the ComboBoxItem to indicate whether we should use the \n current typed-in value as part of the filter criteria returned by \n ${isc.DocUtils.linkForRef('method:ComboBoxItem.getPickListFilterCriteria')}.  You can check this flag in order to\n mimic the ComboBoxItem's default behavior if you provide a custom implementation of\n <code>getPickListFilterCriteria()</code>.",
        name:"filterWithValue",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "method:Canvas.disable":{
        ref:"method:Canvas.disable",
        flags:"",
        description:" Disables this widget and any children and peers of this widget.\n",
        name:"disable",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas",
        groups:["enable"]
    },
    "object:groupNode":{
        methods:[],
        ref:"object:groupNode",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Grids/ListGrid"],
        attrs:["attr:groupNode.groupMembers", "attr:groupNode.groupTitle", "attr:groupNode.groupValue"],
        description:"An auto-generated subclass of ${isc.DocUtils.linkForRef('object:TreeNode')} representing the group nodes\n in a grouped listgrid.",
        name:"groupNode",
        seeAlso:[
            {ref:"method:ListGrid.groupBy", description:null}
        ],
        type:"object",
        groups:["grouping"]
    },
    "attr:FormulaBuilder.titleField":{
        ref:"attr:FormulaBuilder.titleField",
        flags:"IR",
        description:"TextItem that allows users to set the title for this field.",
        name:"titleField",
        seeAlso:[],
        valueType:"AutoChild TextItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["formulaFields"]
    },
    "classAttr:RPCManager.defaultPrompt":{
        ref:"classAttr:RPCManager.defaultPrompt",
        flags:"IRW",
        description:"If showPrompt is enabled for a given transaction, this is the defaultPrompt to be shown\n to the user in a modal dialog while the transaction occurs.\n May be overridden at the request level via ${isc.DocUtils.linkForRef('attr:RPCRequest.prompt')}.<br>\n More targetted default prompts are also supported for certain code-paths. See the following \n set of properties for details:<ul>\n <li>${isc.DocUtils.linkForRef('classAttr:RPCManager.removeDataPrompt')}</li>\n <li>${isc.DocUtils.linkForRef('classAttr:RPCManager.saveDataPrompt')}</li>\n <li>${isc.DocUtils.linkForRef('classAttr:RPCManager.fetchDataPrompt')}</li>\n </ul>",
        name:"defaultPrompt",
        seeAlso:[
            {ref:"classAttr:RPCManager.showPrompt", description:null},
            {ref:"classAttr:RPCManager.promptStyle", description:null},
            {ref:"classAttr:RPCManager.promptCursor", description:null},
            {ref:"attr:RPCRequest.showPrompt", description:null},
            {ref:"attr:RPCRequest.prompt", description:null},
            {ref:"attr:RPCRequest.promptStyle", description:null},
            {ref:"attr:RPCRequest.promptCursor", description:null}
        ],
        valueType:"string",
        defaultValue:"\"Contacting Server...\"",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:["rpcPrompt", "i18nMessages"]
    },
    "group:mouseEvents":{
        ref:"group:mouseEvents",
        refs:["classMethod:EventHandler.getTarget", "classMethod:EventHandler.getDragTarget", 
         "classMethod:EventHandler.getX","classMethod:EventHandler.getY", "classMethod:EventHandler.leftButtonDown", 
         "classMethod:EventHandler.rightButtonDown"],
        name:"mouseEvents",
        seeAlso:[],
        type:"group"
    },
    "attr:SummaryBuilder.showHelpIcon":{
        ref:"attr:SummaryBuilder.showHelpIcon",
        flags:"IR",
        description:"Whether to show the help icon that appears after the ${isc.DocUtils.linkForRef('attr:SummaryBuilder.formulaField')}.",
        name:"showHelpIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:["summaryFields"]
    },
    "attr:Splitbar.vSrc":{
        ref:"attr:Splitbar.vSrc",
        flags:"IR",
        description:"Base URL for the image if ${isc.DocUtils.linkForRef('attr:StretchImg.vertical')} is true and \n ${isc.DocUtils.linkForRef('attr:StretchImg.src')} is unset.",
        name:"vSrc",
        seeAlso:[
            {ref:"attr:StretchImg.src", description:null},
            {ref:"attr:StretchImg.vSrc", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Splitbar",
        groups:["appearance"]
    },
    "attr:TileLayout.tileVMargin":{
        ref:"attr:TileLayout.tileVMargin",
        flags:"IR",
        description:"Vertical margin in between tiles.  See ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin')}.",
        name:"tileVMargin",
        setter:["setTileVMargin"],
        seeAlso:[],
        valueType:"int",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:["layoutMargin"]
    },
    "method:StatefulCanvas.deselect":{
        ref:"method:StatefulCanvas.deselect",
        flags:"",
        description:" Deselect this object.\n",
        name:"deselect",
        seeAlso:[],
        type:"method",
        definingClass:"class:StatefulCanvas",
        groups:["state"]
    },
    "method:CubeGrid.deselectFacetValue":{
        ref:"method:CubeGrid.deselectFacetValue",
        flags:"",
        description:"\n  deselect the header for a given facet value\n\n  <br><i>methodType</i> action\n",
        name:"deselectFacetValue",
        seeAlso:[],
        params:[
            {description:"ID of facet", optional:false, name:"facetId", defaultValue:null, type:"string"},
            {description:"ID of facetValue to select", optional:false, name:"facetValueId",
             defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "method:TabSet.tabIconClick":{
        ref:"method:TabSet.tabIconClick",
        flags:"",
        description:" Method fired when the user clicks the icon for a tab, as specified via ${isc.DocUtils.linkForRef('attr:Tab.icon')}.\n <P>\n Default behavior will fire <code>icon.click()</code> if specified, with two parameters\n <code>tab</code> (a pointer to the tab object and <code>tabSet</code> a pointer to the tabSet\n instance.\n",
        name:"tabIconClick",
        seeAlso:[],
        params:[
            {description:"with click handler being fired", optional:false, name:"tab",
             defaultValue:null, type:"Tab"}
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "method:DynamicForm.itemChanged":{
        ref:"method:DynamicForm.itemChanged",
        flags:"",
        description:" Handler fired when there is a changed() event fired on a FormItem within this form.\n <P>\n Fires after the change() handler on the FormItem itself, and only if the item did not\n cancel the change event and chooses to allow it to propagate to the form as a whole. \n\n",
        name:"itemChanged",
        seeAlso:[],
        params:[
            {description:"the FormItem where the change event occurred", optional:false, name:"item",
             defaultValue:null, type:"FormItem"},
            {description:"new value for the FormItem", optional:false, name:"newValue",
             defaultValue:null, type:"any"}
        ],
        type:"method",
        definingClass:"class:DynamicForm"
    },
    "attr:ColorPicker.crosshairImageURL":{
        ref:"attr:ColorPicker.crosshairImageURL",
        flags:"IR",
        description:"The location of the crosshair image file",
        name:"crosshairImageURL",
        seeAlso:[],
        valueType:"text",
        defaultValue:"\"[SKIN]ColorPicker/crosshair.png\"",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "attr:TextAreaItem.height":{
        ref:"attr:TextAreaItem.height",
        flags:"IRW",
        description:"default height of this item",
        name:"height",
        seeAlso:[],
        valueType:"number",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:TextAreaItem",
        groups:["appearance"]
    },
    "method:ColumnTree.getColumnProperties":{
        ref:"method:ColumnTree.getColumnProperties",
        flags:"A",
        description:" Additional properties to apply to the ListGrid that will show the indicated column.\n Returns nothing by default. This method can be overrideen to allow, for example, different \n styling, icons, or row heights per column.\n",
        name:"getColumnProperties",
        seeAlso:[],
        params:[
            {description:"parent node for the nodes to be shown in the column", optional:false,
             name:"node", defaultValue:null, type:"TreeNode"},
            {description:"index of the column", optional:false, name:"colNum", defaultValue:null,
             type:"int"}
        ],
        returns:{description:"properties to be applied to the column", type:"ListGrid Properties"},
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:RichTextItem.startRow":{
        ref:"attr:RichTextItem.startRow",
        flags:"IRW",
        description:"By default RichTextItems take up an entire row",
        name:"startRow",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RichTextItem"
    },
    "attr:FacetValue.isMinimizeValue":{
        ref:"attr:FacetValue.isMinimizeValue",
        flags:"IR",
        description:"Used to determine which facetValue is to be shown when the facet is minimized.\n <P>\n See ${isc.DocUtils.linkForRef('attr:CubeGrid.canMinimizeFacets')}.",
        name:"isMinimizeValue",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "method:GridRenderer.setColumnWidths":{
        ref:"method:GridRenderer.setColumnWidths",
        flags:"",
        description:"\n Sets the width of all columns in the grid.\n\n",
        name:"setColumnWidths",
        seeAlso:[],
        params:[
            {description:"array of new widths - one for each column.", optional:false,
             name:"newWidths", defaultValue:null, type:"Array"}
        ],
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "attr:DataSource.inheritsFrom":{
        ref:"attr:DataSource.inheritsFrom",
        flags:"IR",
        description:"ID of another DataSource this DataSource inherits its ${isc.DocUtils.linkForRef('attr:DataSource.fields')} from.\n <P>\n Local fields (fields defined in this DataSource) are added to inherited fields \n to form the full set of fields.  Fields with the same name are merged in the same way\n that ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields','databound component fields')} are merged with\n DataSource fields.\n <P>\n The default order of the combined fields is new local fields first (including any fields\n present in the parent DataSource which the local DataSource re-declares), then parent\n fields.  You can set ${isc.DocUtils.linkForRef('attr:DataSource.useParentFieldOrder')} to instead use the parent's field\n order, with new local fields appearing last.  You can set ${isc.DocUtils.linkForRef('attr:DataSource.showLocalFieldsOnly')} to\n have all non-local fields hidden.\n <P>\n Note that <b>only fields are inherited</b> - other properties such as dataURL and\n dataFormat are not.  You can use ordinary inheritance, that is, creating a subclass of\n DataSource, in order to share properties such as dataURL across a series of DataSources\n that also inherit fields from each other via <code>inheritsFrom</code>.\n <P>\n This feature can be used for:\n <ul>\n <li>creating a customized view (eg, only certain fields shown) which will be used by\n multiple ${isc.DocUtils.linkForRef('interface:DataBoundComponent','databound components')}.\n <li>adding presentation-specific attributes to metadata that has been automatically\n derived from ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema','XML Schema')} or other metadata formats\n <li>modelling object subclassing and extension in server-side code and storage systems\n <li>modelling relational database joins, and the equivalents in other systems\n <li>creating hooks for others to customize your application in a maintainable way.  For\n example, if you have a dataSource \"employee\", you can create a dataSource\n \"customizedEmployee\" which inherits from \"employee\" but does not initially define any\n fields, and bind all ${isc.DocUtils.linkForRef('interface:DataBoundComponent','databound components')} to\n \"customizedEmployee\".  Customizations of fields (including appearance changes, field\n order, new fields, hiding of fields, and custom validation rules) can be added to\n \"customizedEmployee\", so that they are kept separtely from the original field data and\n have the best possible chance of working with future versions of the \"employee\"\n dataSource.\n </ul>",
        name:"inheritsFrom",
        seeAlso:[],
        valueType:"DataSource ID",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('schemaChaining')}"],
        definingClass:"class:DataSource",
        groups:["fields"]
    },
    "method:DynamicForm.saveData":{
        ref:"method:DynamicForm.saveData",
        flags:"",
        description:"\n Validate and then save the form's current values to the ${isc.DocUtils.linkForRef('class:DataSource')} this form is\n bound to.\n <p>\n If client-side validators are defined, they are executed first, and if any errors are\n found the save is aborted and the form will show the errors.\n <p>\n If client-side validation passes, a ${isc.DocUtils.linkForRef('class:DSRequest')} will be sent, exactly as though\n ${isc.DocUtils.linkForRef('method:DataSource.addData')} or ${isc.DocUtils.linkForRef('method:DataSource.updateData')} had been called with \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','the form's values')} as data.  The\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType')} will be either \"update\" or \"add\", depending on the\n current ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOperationType')}.\n <P>\n On either a client-side or server-side validation failure, validation errors will be\n displayed in the form.  Visible items within a DynamicForms will be redrawn to display\n errors. Validation failure occuring on hidden items, or DataSource fields with no \n associated form items may be handled via ${isc.DocUtils.linkForRef('method:DynamicForm.handleHiddenValidationErrors')}\n or ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')}.\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.validationURL','validationURL')} can be set to do validation against a\n different URL from where the form will ultimately save, as part of an incremental\n upgrade strategy for Struts and Struts-like applications.\n\n",
        name:"saveData",
        seeAlso:[],
        params:[
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on the DSRequest                                            that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('addOperation')}"],
        definingClass:"class:DynamicForm",
        groups:["dataBoundComponentMethods"]
    },
    "method:SectionStack.setSectionTitle":{
        ref:"method:SectionStack.setSectionTitle",
        flags:"",
        description:" Changes the title of a SectionHeader.\n\n",
        name:"setSectionTitle",
        seeAlso:[],
        params:[
            {description:"ID or index of the section whose title you want to change", optional:false,
             name:"section", defaultValue:null, type:"String or Number"},
            {description:"new title for the SectionHeader", optional:false, name:"newTitle",
             defaultValue:null, type:"String"}
        ],
        type:"method",
        definingClass:"class:SectionStack"
    },
    "attr:ServerObject.lookupStyle":{
        ref:"attr:ServerObject.lookupStyle",
        flags:"IR",
        description:"Specifies the mechanism for locating the class instance on which to invoke the method.\n Valid values are as follows:\n <ul>\n <li>\"spring\": For use with the <a href='http://springframework.com' onclick=\"window.open('http://springframework.com');return false;\">Spring framework</a>.\n ${isc.DocUtils.linkForRef('attr:ServerObject.bean')} contains the name of the bean to invoke.  Which application context\n is used can be configured via web.xml (see the example web.xml in the SDK).\n <li>\"new\": A new instance of the class specified by ${isc.DocUtils.linkForRef('attr:ServerObject.className')} will be\n created and the DMI method will be invoked on that instance (unless the specified method is\n static, in which case no instance is created, but the class specified by\n ${isc.DocUtils.linkForRef('attr:ServerObject.className')} is still used).\n <li>\"factory\": A custom factory provides the class instance on which the DMI method is to be\n invoked.  In this case, ${isc.DocUtils.linkForRef('attr:ServerObject.className')} specifies the className of the factory\n that will provide the instance on which the DMI method is to be invoked.  The class\n specified by ${isc.DocUtils.linkForRef('attr:ServerObject.className')} must provide exactly one method named\n <code>create</code> that must return the class instance on which you wish the DMI method to\n be invoked.  Like the DMI methods, the <code>create</code> can request a standard set of\n values as arguments.  See ${isc.DocUtils.linkForRef('class:DMI')} for a list of available values.\n <li> \"attribute\": The instance on which the DMI method is to be invoked is looked up in the\n scope defined by ${isc.DocUtils.linkForRef('attr:ServerObject.attributeScope')} via the attribute name specified in\n ${isc.DocUtils.linkForRef('attr:ServerObject.attributeName')}.\n </ul>",
        name:"lookupStyle",
        seeAlso:[
            {ref:"attr:ServerObject.className", description:null},
            {ref:"attr:ServerObject.attributeName", description:null},
            {ref:"attr:ServerObject.attributeScope", description:null}
        ],
        valueType:"\"new\"|\"factory\"|\"attribute\"|\"spring\"",
        defaultValue:"\"new\"",
        type:"attr",
        definingClass:"class:ServerObject"
    },
    "attr:RPCRequest.httpHeaders":{
        ref:"attr:RPCRequest.httpHeaders",
        flags:"IRW",
        description:"HTTP headers to send, as a Object mapping Header name -> Header value, eg<br>\n { \"Content-Type\" : \"text/xml\" }\n <P>\n Valid with the xmlHttpRequest ${isc.DocUtils.linkForRef('attr:RPCRequest.transport','transport')} only.",
        name:"httpHeaders",
        seeAlso:[],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "attr:ListGridField.validators":{
        ref:"attr:ListGridField.validators",
        flags:"IRW",
        description:"Array of ${isc.DocUtils.linkForRef('class:Validator')} objects for this field.  When the user edits cells in\n this field, these validators will be applied to the edited value.<br>\n Note: for databound listGrids, this property may be specified on the \n ${isc.DocUtils.linkForRef('class:DataSourceField')}, enabling both client and server side validation.",
        name:"validators",
        seeAlso:[
            {ref:"class:Validator", description:null},
            {ref:"attr:ListGridField.required", description:null}
        ],
        valueType:"array of Validator",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dataValidation')}"],
        definingClass:"object:ListGridField",
        groups:["gridValidation"]
    },
    "method:ListGrid.cellContextClick":{
        ref:"method:ListGrid.cellContextClick",
        flags:"",
        description:" Called when a cell receives a contextclick event.\n\n",
        name:"cellContextClick",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('cellClicks')}"],
        definingClass:"class:ListGrid",
        groups:["events"]
    },
    "group:eclipseIntegration":{
        ref:"group:eclipseIntegration",
        title:"Eclipse Integration",
        refs:[],
        description:"If you're developing with Eclipse, you can use the SmartClient personality for Eclipse ATF\n    (<a href='http://eclipse.org/atf' onclick=\"window.open('http://eclipse.org/atf');return false;\">Ajax Toolkit Framework</a>).  Here's how to set it up:\n    <p>\n    1. If you haven't already, download and install ATF from \n      <a href='http://www.eclipse.org/atf/downloads/index.php' onclick=\"window.open('http://www.eclipse.org/atf/downloads/index.php');return false;\">http://www.eclipse.org/atf/downloads/index.php</a>.\n      The SmartClient personality has been tested against the ATF 0.1 Milestone Build, but is\n      also known to work with later releases.<p>\n    2. Download the SmartClient personality: \n        <a href='http://smartclient.com/product/SmartClient_ATF_Personality_1.0.zip' onclick=\"window.open('http://smartclient.com/product/SmartClient_ATF_Personality_1.0.zip');return false;\">SmartClient_ATF_Personality_1.0.zip</a><p>\n    3. Unzip the above archive into your eclipse installation directory.  This will create\n    three directories under the plugins directory: <i>com.smartClient.core_1.0.0,\n    com.smartClient.runtime_1.0.0, com.smartClient.ui_1.0.0</i>.<p>\n    4. For the next step, you will need to have downloaded and unzipped a copy of the\n    SmartClient Evaluation SDK, available from\n    <a href='http://smartclient.com/product/download.jsp' onclick=\"window.open('http://smartclient.com/product/download.jsp');return false;\">http://smartclient.com/product/download.jsp</a>.  You can of course also use\n    any other licensed copy of SmartClient.  From the SDK, copy the <i>isomorphic</i>\n    directory from smartclientRuntime into the\n    <i>eclipse/plugins/com.smartClient.runtime_1.0.0/resources</i> directory.\n    <p>\n    You're all set.  When you next start Eclipse, you'll be able to select ATF->SmartClient as\n    a new Project Facet during project creation or add it as a facet to an existing project.\n    You can then create new SmartClient Applications by right-clicking on your project and\n    selecting New->Other->SmartClient->SmartClient Application.  And you'll be able to use the\n    provided snippets to quickly create components.  If you have any problems, please post to\n    the <a href='http://forums.smartclient.com' onclick=\"window.open('http://forums.smartclient.com');return false;\">forums</a>.",
        name:"eclipseIntegration",
        seeAlso:[],
        type:"group"
    },
    "attr:HeaderSpan.valign":{
        ref:"attr:HeaderSpan.valign",
        flags:"IR",
        description:"Vertical alignment of the title of this headerSpan.\n <P>\n Defaults to listGrid.headerSpanVAlign if unset.",
        name:"valign",
        seeAlso:[],
        valueType:"vAlign",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:HeaderSpan",
        groups:["headerSpan"]
    },
    "attr:DynamicForm.saveOnEnter":{
        ref:"attr:DynamicForm.saveOnEnter",
        flags:"IRW",
        description:"If <code>true</code>, when the user hits the Enter key while focussed in a text-item in\n this form, we automatically submit the form to the server using the \n ${isc.DocUtils.linkForRef('method:DynamicForm.submit')} method.",
        name:"saveOnEnter",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["submitting"]
    },
    "method:SectionItem.expandSection":{
        ref:"method:SectionItem.expandSection",
        flags:"",
        description:" Expands a section, showing all the items contained within the section.\n",
        name:"expandSection",
        seeAlso:[],
        type:"method",
        definingClass:"class:SectionItem"
    },
    "method:ListGrid.setCriteria":{
        ref:"method:ListGrid.setCriteria",
        flags:"",
        description:" Sets this component's filter criteria.\n Default implementation calls this.data.setCriteria()\n",
        name:"setCriteria",
        seeAlso:[],
        params:[
            {description:"new criteria to show", optional:false, name:"", defaultValue:null,
             type:"Criteria or AdvancedCriteria"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["dataBoundComponentMethods"]
    },
    "type:XMLElement":{
        ref:"type:XMLElement",
        description:"An XMLElement represents one complete XML tag, including any subelements contained between\n the start and end tags.\n <P>\n XMLElement is a native object supplied directly by the browser.  The SmartClient-supported\n interfaces for this object include methods that take an XMLElement as an argument (such as\n ${isc.DocUtils.linkForRef('classMethod:XMLTools.selectNodes')}).  If you want to retrieve XML data and display it in a\n SmartClient component, read about ${isc.DocUtils.linkForRef('group:clientDataIntegration','XML Data Binding')}.  To\n extract data as JavaScript Objects from XML, see ${isc.DocUtils.linkForRef('classMethod:XMLTools.toJS')}.  Direct\n manipulation of XMLElements objects is subject to cross-browser inconsistencies, bugs,\n memory leaks and performance issues.",
        name:"XMLElement",
        seeAlso:[],
        type:"type"
    },
    "attr:DataSourceField.rootValue":{
        ref:"attr:DataSourceField.rootValue",
        flags:"IR",
        description:"For a field that is a foreignKey establishing a tree relationship, what value indicates a\n root-level node.  Defaults to null.\n <P>\n Note that the rootValue may be overridden on a specific ResultTree instance by setting\n ${isc.DocUtils.linkForRef('attr:ResultTree.rootNode')}, or if the ResultTree is auto-generated by a ${isc.DocUtils.linkForRef('class:TreeGrid')},\n by setting ${isc.DocUtils.linkForRef('attr:TreeGrid.treeRootValue')}. This allows a component to navigate a subtree of\n the hierarchical data from this dataSource starting at a particular node.",
        name:"rootValue",
        seeAlso:[],
        valueType:"any",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('treeLoadXML')}"],
        definingClass:"class:DataSourceField",
        groups:["dataSourceRelations"]
    },
    "attr:Canvas.canDrop":{
        ref:"attr:Canvas.canDrop",
        flags:"IRWA",
        description:"Indicates that this object can be dropped on top of other widgets. Only valid if \n      canDrag or canDragReposition is true.",
        name:"canDrop",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dragCreate')}"],
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "classMethod:Page.goBack":{
        ref:"classMethod:Page.goBack",
        flags:"",
        description:" Go back in the browser's history.<br><br>\n\n If the history is empty and the window.opener is set, we assume we're a child window and just\n close the window.\n\n",
        name:"goBack",
        seeAlso:[],
        type:"classMethod",
        definingClass:"class:Page"
    },
    "attr:ColorPicker.modeToggleButton":{
        ref:"attr:ColorPicker.modeToggleButton",
        flags:"R",
        description:"\"More\"/\"Less\" button for the ColorPicker",
        name:"modeToggleButton",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "attr:ListGrid.showEmptyMessage":{
        ref:"attr:ListGrid.showEmptyMessage",
        flags:"IRW",
        description:"Indicates whether the text of the emptyMessage property should be displayed if no data is\n available.",
        name:"showEmptyMessage",
        seeAlso:[
            {ref:"attr:ListGrid.emptyMessage", description:null}
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('emptyGrid')}"],
        definingClass:"class:ListGrid",
        groups:["emptyMessage"]
    },
    "class:DSResponse":{
        methods:[],
        ref:"class:DSResponse",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Data Binding"],
        attrs:["attr:DSResponse.clientContext", "attr:DSResponse.data", "attr:DSResponse.status", 
         "attr:DSResponse.errors","attr:DSResponse.startRow", "attr:DSResponse.endRow", "attr:DSResponse.totalRows", 
         "attr:DSResponse.invalidateCache"],
        description:"Response sent by the server in response to a ${isc.DocUtils.linkForRef('class:DSRequest','DataSource request')}.  Contains\n all the properties available on the basic ${isc.DocUtils.linkForRef('class:RPCResponse')}, in addition to the\n properties listed here.",
        name:"DSResponse",
        seeAlso:[],
        type:"class"
    },
    "group:dataType":{
        ref:"group:dataType",
        refs:["attr:DataSourceField.required", "attr:DataSourceField.valueMap", 
         "attr:DataSourceField.validators","attr:DataSourceField.length", "attr:SimpleType.valueMap"],
        name:"dataType",
        seeAlso:[],
        type:"group"
    },
    "attr:TabSet.rightEdgeSizes":{
        ref:"attr:TabSet.rightEdgeSizes",
        flags:"IR",
        description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n and ${isc.DocUtils.linkForRef('attr:TabSet.symmetricEdges')} is set to false, the <code>leftEdgeSizes</code>, \n <code>rightEdgeSizes</code>, <code>topEdgeSizes</code> and <code>bottomEdgeSizes</code> \n propertes allow the sizes of edges for the paneContainer to be customized depending on\n the ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.\n <P>\n The attribute should be specified an ${isc.DocUtils.linkForRef('type:EdgeSizes','edgeSizes map')}, specifying the\n desired edge sizes where for the appropriate ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.",
        name:"rightEdgeSizes",
        seeAlso:[],
        valueType:"EdgeSizes",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "attr:MenuButton.title":{
        ref:"attr:MenuButton.title",
        flags:"IRW",
        description:"Default title for the button.",
        name:"title",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Show Menu\"",
        type:"attr",
        definingClass:"class:MenuButton",
        groups:["i18nMessages"]
    },
    "group:defaults":{
        ref:"group:defaults",
        refs:[],
        name:"defaults",
        seeAlso:[],
        type:"group"
    },
    "method:ActiveXControl.getPluginHandle":{
        ref:"method:ActiveXControl.getPluginHandle",
        flags:"",
        description:"  Returns a handle to the element for this ISC ActiveX control object.\n\n",
        name:"getPluginHandle",
        seeAlso:[],
        type:"method",
        definingClass:"class:ActiveXControl"
    },
    "classAttr:Operators.iStartsWithTitle":{
        ref:"classAttr:Operators.iStartsWithTitle",
        flags:"IR",
        description:"Title for the \"iStartsWith\" operator",
        name:"iStartsWithTitle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"starts with\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:["i18nMessages"]
    },
    "classMethod:Class.echoLeaf":{
        ref:"classMethod:Class.echoLeaf",
        flags:"",
        description:" Return a very short (generally less than 40 characters) string representation of any object,\n suitable for viewing by a developer for debugging purposes.\n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.echoLeaf\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n\n",
        name:"echoLeaf",
        seeAlso:[
            {ref:"method:Class.echo", description:null}
        ],
        params:[
            {description:"object to echo", optional:false, name:"obj", defaultValue:null, type:"any"}
        ],
        returns:{description:"a short string representation of the object", type:"string"},
        type:"classMethod",
        definingClass:"class:Class",
        groups:["debug"]
    },
    "classMethod:Page.getAppDir":{
        ref:"classMethod:Page.getAppDir",
        flags:"",
        description:" Returns the base URL of the application, which is the page URL minus the last non-directory \n path component.  For example, if the page is loaded from\n <code>http://foo.com/bar/zoo.jsp</code>, appDir will be <code>http://foo.com/bar/</code>.\n <P>\n If other page-wide URLs such as ${isc.DocUtils.linkForRef('classMethod:Page.setIsomorphicDir')} are specified as\n relative paths, they are considered relative to this URL.\n\n",
        name:"getAppDir",
        seeAlso:[],
        returns:{description:"URL for page-specific files.", type:"string"},
        type:"classMethod",
        definingClass:"class:Page",
        groups:["files"]
    },
    "attr:Layout.members":{
        ref:"attr:Layout.members",
        flags:"IRW",
        getter:["getMembers"],
        description:"An array of canvases that will be contained within this layout. You can set the\n following properties on these canvases (in addition to the standard component\n properties):\n <ul>\n  <li>layoutAlign--specifies the member's alignment along the breadth axis; valid\n  values are \"top\", \"center\" and \"bottom\" for a horizontal layout and \"left\", \"center\"\n  and \"right\" for a vertical layout (see ${isc.DocUtils.linkForRef('attr:Layout.defaultLayoutAlign')} for default\n  implementation.)\n  <li>showResizeBar--set to true to show a resize bar (default is false)\n </ul>\n Height and width settings found on members are interpreted by the Layout according to\n the ${isc.DocUtils.linkForRef('attr:Layout.vPolicy','layout policy')}.",
        name:"members",
        seeAlso:[],
        valueType:"Array of Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout"
    },
    "attr:ListGridRecord.canAcceptDrop":{
        ref:"attr:ListGridRecord.canAcceptDrop",
        flags:"IR",
        description:"When set to <code>false</code>, other records cannot be dropped on (i.e., inserted\n via drag and drop) immediately before this record.",
        name:"canAcceptDrop",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord"
    },
    "attr:TreeGrid.animateFolderSpeed":{
        ref:"attr:TreeGrid.animateFolderSpeed",
        flags:"IRW",
        description:"When animating folder opening / closing, this property designates the speed of the\n animation in pixels shown (or hidden) per second. Takes presidence over the \n ${isc.DocUtils.linkForRef('attr:TreeGrid.animateFolderTime')} property, which allows the developer to specify a\n duration for the animation rather than a speed.",
        name:"animateFolderSpeed",
        seeAlso:[
            {ref:"attr:TreeGrid.animateFolderTime", description:null}
        ],
        valueType:"number",
        defaultValue:"1000",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('animateTree')}"],
        definingClass:"class:TreeGrid",
        groups:["animation"]
    },
    "method:ListGrid.resizeField":{
        ref:"method:ListGrid.resizeField",
        flags:"A",
        description:" Resize a particular field to a new width.\n\n",
        name:"resizeField",
        seeAlso:[],
        params:[
            {description:"Number of the field to resize", optional:false, name:"fieldNum",
             defaultValue:null, type:"number"},
            {description:"New width of the field", optional:false, name:"newWidth", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:Flashlet.classID":{
        ref:"attr:Flashlet.classID",
        flags:"IR",
        description:"This attribute specifies the clsid of the outer &lt;object&gt; tag.\n  <p>\n  The default classID is: \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"\n  <p>",
        name:"classID",
        seeAlso:[],
        valueType:"string",
        defaultValue:"see below",
        type:"attr",
        definingClass:"class:Flashlet"
    },
    "classAttr:RPCResponse.STATUS_LOGIN_REQUIRED":{
        ref:"classAttr:RPCResponse.STATUS_LOGIN_REQUIRED",
        flags:"R",
        description:"Indicates that a login is required before this RPCRequest can proceed.\n <P>\n Applications do not directly set this status code, instead, to trigger the relogin flow,\n return the loginRequiredMarker in the response sent by your server when login is\n required.  See the ${isc.DocUtils.linkForRef('group:relogin','Relogin Overview')} for details.",
        name:"STATUS_LOGIN_REQUIRED",
        seeAlso:[
            {ref:"class:RPCRequest", description:null}
        ],
        valueType:"integer",
        defaultValue:"-7",
        type:"classAttr",
        definingClass:"class:RPCResponse",
        groups:["statusCodes"]
    },
    "attr:ColorItem.pickerIconSrc":{
        ref:"attr:ColorItem.pickerIconSrc",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon')} is true for this item, this property governs the\n src of the picker icon image to be displayed.",
        name:"pickerIconSrc",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]/DynamicForm/ColorPicker_icon.png\"",
        type:"attr",
        definingClass:"class:ColorItem"
    },
    "class:FilterBuilder":{
        methods:["method:FilterBuilder.removeClause", "method:FilterBuilder.setTopOperator", 
         "method:FilterBuilder.getFieldOperators","method:FilterBuilder.getValueFieldProperties", "method:FilterBuilder.getCriteria", 
         "method:FilterBuilder.setCriteria","method:FilterBuilder.clearCriteria", "method:FilterBuilder.addCriterion", 
         "method:FilterBuilder.search","method:FilterBuilder.filterChanged"],
        ref:"class:FilterBuilder",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Forms"],
        attrs:["attr:FilterBuilder.dataSource", "attr:FilterBuilder.criteria", 
         "attr:FilterBuilder.saveOnExit","attr:FilterBuilder.showFieldTitles", "attr:FilterBuilder.showRemoveButton", 
         "attr:FilterBuilder.removeButtonPrompt","attr:FilterBuilder.removeButton", "attr:FilterBuilder.showAddButton", 
         "attr:FilterBuilder.addButtonPrompt","attr:FilterBuilder.addButton", "attr:FilterBuilder.allowEmpty", 
         "attr:FilterBuilder.topOperator","attr:FilterBuilder.radioOptions", "attr:FilterBuilder.topOperatorAppearance", 
         "attr:FilterBuilder.radioOperatorForm","attr:FilterBuilder.topOperatorForm", "attr:FilterBuilder.defaultSubClauseOperator", 
         "attr:FilterBuilder.clauseStack","attr:FilterBuilder.rangeSeparator", "attr:FilterBuilder.showSubClauseButton", 
         "attr:FilterBuilder.subClauseButtonTitle","attr:FilterBuilder.subClauseButtonPrompt", "attr:FilterBuilder.subClauseButton", 
         "attr:FilterBuilder.bracket"],
        description:"A form that allows the user to input advanced search criteria, including operators on\n field values such as \"less than\", and sub-clauses using \"AND\" and \"OR\" operators.\n <P>\n A FilterBuilder produces an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object, which the ${isc.DocUtils.linkForRef('class:DataSource')}\n subsystem can use to filter datasets, including the ability to perform such filtering within\n the browser for datasets that are completely loaded.",
        name:"FilterBuilder",
        seeAlso:[],
        type:"class"
    },
    "classMethod:RPCManager.queueSent":{
        ref:"classMethod:RPCManager.queueSent",
        flags:"",
        description:"\n This method is called by the RPCManager every time it sends a queue of requests to the \n server (note that if you not using queuing, the system simply sends queues containing\n just one request, so this API is valid regardless).<p>\n There is no default implementation of this method; it is simply an override point.  \n It is intended to be used by user code that needs to be notified when SmartClient sends \n requests to the server.  Note that the list of ${isc.DocUtils.linkForRef('class:RPCRequest')}s passed to this\n method is strictly <b>read-only</b>.\n\n",
        name:"queueSent",
        seeAlso:[],
        params:[
            {description:"The queue of ${isc.DocUtils.linkForRef('class:RPCRequest')}s that was sent",
             optional:false, name:"requests", defaultValue:null, type:"List of RPCRequest"}
        ],
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "classMethod:Class.setLogPriority":{
        ref:"classMethod:Class.setLogPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for some log category, when logged on\n this Class or Instance object.<br>\n If called with no category, this priority will be applied to every logged message on this\n object<br>\n To set the visible log priority for some category across the entire page, use\n <code>isc.Log.setPriority()</code> instead.\n",
        name:"setLogPriority",
        seeAlso:[
            {ref:"classMethod:Log.setPriority", description:null}
        ],
        params:[
            {description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
             optional:false, name:"category", defaultValue:null, type:"string"},
            {description:"priority level", optional:false, name:"priority", defaultValue:null,
             type:"LogPriority"}
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "attr:DataSourceField.inapplicable":{
        ref:"attr:DataSourceField.inapplicable",
        flags:"IR",
        description:"For use in ${isc.DocUtils.linkForRef('group:componentSchema')}, a field ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','inherited')} from\n another schema can be redeclared with this property set in order to indicate that the\n property should not be used.\n <P>\n This is primarily used to influence ${isc.DocUtils.linkForRef('group:visualBuilder')}.  For simple type properties,\n this avoids the property appearing in the Component Editor.  \n <P>\n For fields that hold subcomponents, this prevents inappropriate drag and drop.  For example,\n a custom class called <code>MyDialog</code> may automatically create a series of children,\n and not allow arbitrary other children to be added.  In this case, the inherited property\n ${isc.DocUtils.linkForRef('attr:Canvas.children')} should be marked inapplicable in order to prevent arbitrary\n components being dropped onto a <code>MyDialog</code> instance.",
        name:"inapplicable",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["componentSchema"]
    },
    "group:title":{
        ref:"group:title",
        refs:["method:DataSource.getAutoTitle", "classMethod:DataSource.getAutoTitle", 
         "attr:FormItem.showTitle","attr:FormItem.titleOrientation", "attr:FormItem.titleAlign", "attr:FormItem.wrapTitle", 
         "attr:FormItem.titleStyle","attr:FormItem.titleClassName", "attr:FormItem.titleErrorClassName"],
        name:"title",
        seeAlso:[],
        type:"group"
    },
    "classMethod:RPCManager.xmlHttpRequestAvailable":{
        ref:"classMethod:RPCManager.xmlHttpRequestAvailable",
        flags:"",
        description:"\n Returns true if the XMLHttpRequest object is available, false otherwise.  See\n ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information on when XMLHttpRequest parser may\n not available and what features are\n impacted as a result.\n\n",
        name:"xmlHttpRequestAvailable",
        seeAlso:[],
        returns:{description:"true if XMLHttpRequest is available, false otherwise.", type:"boolean"},
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "method:ListGrid.setHeaderSpanTitle":{
        ref:"method:ListGrid.setHeaderSpanTitle",
        flags:"",
        description:" Update the title of a ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpan')} dynamically.\n\n",
        name:"setHeaderSpanTitle",
        seeAlso:[],
        params:[
            {description:"name of the headerSpan, as specified via ${isc.DocUtils.linkForRef('attr:HeaderSpan.name')}.",
             optional:false, name:"name", defaultValue:null, type:"String"},
            {description:"new title for the headerSpan", optional:false, name:"newTitle",
             defaultValue:null, type:"String"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["headerSpan"]
    },
    "attr:TileLayout.dragDataAction":{
        ref:"attr:TileLayout.dragDataAction",
        flags:"IRW",
        description:"Indicates what to do with data dragged into another DataBoundComponent. See\n          DragDataAction type for details.",
        name:"dragDataAction",
        seeAlso:[],
        valueType:"DragDataAction",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('gridsDragMove')}", 
         "${isc.DocUtils.linkForExampleId('gridsDragCopy')}"],
        definingClass:"class:TileLayout",
        groups:["dragging"]
    },
    "method:CubeGrid.removeFacet":{
        ref:"method:CubeGrid.removeFacet",
        flags:"",
        description:"\n Remove a facet from the current view, using a fixed value from that facet.  For example, remove\n the \"months\" facet from the view, collapsing to just January, or total for all months.\n\n",
        name:"removeFacet",
        seeAlso:[
            {ref:"method:CubeGrid.addFacet", description:null},
            {ref:"attr:CubeGrid.fixedFacetValues", description:null}
        ],
        params:[
            {description:"facetId to remove", optional:false, name:"facetId", defaultValue:null,
             type:"id"},
            {description:"New fixed value for the facet, to be added to cubeGrid.fixedFacetValues.  Default is the\n     rollup value for the facet.",
             optional:true, name:"fixedFacetValueId", defaultValue:null, type:"id"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["facetLayout"]
    },
    "type:clickMaskMode":{
        ref:"type:clickMaskMode",
        values:[
            {description:"When the mask recieves a click, it will fire its click action,                   and cancel the event, leaving the clickMask up.",
             value:"\"hard\""},
            {description:"When the mask recieves a click, it will fire its click action,                   then dismiss the clickMask and allow the event to proceed to its target.",
             value:"\"soft\""}
        ],
        description:"Passed as a parameter to ${isc.DocUtils.linkForRef('method:Canvas.showClickMask')} to determine the masks behavior\n when clicked.",
        name:"clickMaskMode",
        seeAlso:[],
        type:"type",
        groups:["clickMask"]
    },
    "attr:Calendar.data":{
        ref:"attr:Calendar.data",
        flags:"IRW",
        description:"A List of CalendarEvent objects, specifying the data to be used to populate the\n calendar.  \n <p>\n This property will typically not be explicitly specified for databound Calendars, where\n the data is returned from the server via databound component methods such as\n ${isc.DocUtils.linkForRef('method:Calendar.fetchData')}. In this case the data objects will be set to a \n ${isc.DocUtils.linkForRef('class:ResultSet','resultSet')} rather than a simple array.",
        name:"data",
        setter:["setData"],
        seeAlso:[
            {ref:"object:CalendarEvent", description:null}
        ],
        valueType:"List of CalendarEvent",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["data"]
    },
    "attr:WSRequest.data":{
        ref:"attr:WSRequest.data",
        flags:"IR",
        description:"Data to be serialized to XML to form the SOAP body.",
        name:"data",
        seeAlso:[],
        valueType:"any",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:WSRequest"
    },
    "type:Encoding":{
        ref:"type:Encoding",
        values:[
            {description:"normal form encoding (\"application/x-www-form-urlencoded\")",
             value:"DynamicForm.NORMAL"},
            {description:"form encoding for forms with INPUT file elements, that is, forms                              that upload files (\"multipart/form-data\")",
             value:"DynamicForm.MULTIPART"}
        ],
        description:"Form encodying types - these translate to Form ENCTYPE parameters.",
        name:"Encoding",
        seeAlso:[],
        type:"type",
        groups:["submitting"]
    },
    "attr:Canvas.accessKey":{
        ref:"attr:Canvas.accessKey",
        flags:"IRWA",
        description:"If specified this governs the accessKey for the widget.\n This should be set to a character - when a user hits Alt+[accessKey], or in Mozilla\n Firefox 2.0 and above, Shift+Alt+[accessKey], focus will be given to the widget in\n question.",
        name:"accessKey",
        setter:["setAccessKey"],
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["focus"]
    },
    "method:ListGrid.getRowErrors":{
        ref:"method:ListGrid.getRowErrors",
        flags:"",
        description:"  Returns any currently stored validation errors for this row in the following format:<br>\n  &nbsp;&nbsp;<code>{fieldName:[array of error messages], ...}</code>\n",
        name:"getRowErrors",
        seeAlso:[
            {ref:"method:ListGrid.getCellErrors", description:null}
        ],
        params:[
            {description:"index of row to check for validation errors.", optional:false, name:"rowNum",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"object showing validation error arrays by field for the row passed in                       - if no validation errors stored for the row, null is returned.",
         type:"object"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["gridValidation"]
    },
    "attr:DataBoundComponent.showComplexFields":{
        ref:"attr:DataBoundComponent.showComplexFields",
        flags:"IRWA",
        description:"Whether to show fields of non-atomic types when a DataBoundComponent is given a\n DataSource but no <code>component.fields</code>.\n <p>\n If true, the component will show fields that declare a complex type, for example, a\n field 'shippingAddress' that declares type 'Address', where 'Address' is the ID of a\n DataSource that declares the fields of a shipping address (city, street name, etc).\n <P>\n Such fields may need custom formatters or editors in order to create a usable interface,\n for example, an Address field in a ListGrid might use a custom formatter to combine the\n relevant fields of an address into one column, and might use a pop-up dialog for\n editing.",
        name:"showComplexFields",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["databinding"]
    },
    "method:Class.setDefaultLogPriority":{
        ref:"method:Class.setDefaultLogPriority",
        flags:"",
        description:" Set the default priority of logging for messages logged on this Class or Instance object.\n All categories for which there is no explicit, instance level logging priority set will\n log at this level on this object.<br>  \n To set the default visible log priority across the entire page, use\n <code>isc.Log.setDefaultPriority()</code> instead.\n",
        name:"setDefaultLogPriority",
        seeAlso:[
            {ref:"classMethod:Log.setPriority", description:null}
        ],
        params:[
            {description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
             optional:false, name:"category", defaultValue:null, type:"string"},
            {description:"priority level", optional:false, name:"priority", defaultValue:null,
             type:"LogPriority"}
        ],
        type:"method",
        definingClass:"class:Class"
    },
    "method:PickList.getValueFieldName":{
        ref:"method:PickList.getValueFieldName",
        flags:"",
        description:" Getter method to retrieve the ${isc.DocUtils.linkForRef('attr:FormItem.valueField')} for this item.\n If unset, default behavior will return the ${isc.DocUtils.linkForRef('attr:FormItem.name')} of this field.\n",
        name:"getValueFieldName",
        seeAlso:[],
        returns:{description:"fieldName to use a \"value field\" in records from this items               ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')}",
         type:"string"},
        type:"method",
        definingClass:"interface:PickList",
        groups:["display_values"]
    },
    "method:SelectItem.defaultDynamicValue":{
        ref:"method:SelectItem.defaultDynamicValue",
        flags:"A",
        description:" Expression evaluated to determine the ${isc.DocUtils.linkForRef('attr:SelectItem.defaultValue')} when no value is\n provided for this item. To default to the first option use\n ${isc.DocUtils.linkForRef('attr:SelectItem.defaultToFirstOption')} instead.\n",
        name:"defaultDynamicValue",
        seeAlso:[],
        type:"method",
        definingClass:"class:SelectItem"
    },
    "method:DynamicForm.setAction":{
        ref:"method:DynamicForm.setAction",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:DynamicForm.action','action')} for this form.\n",
        name:"setAction",
        seeAlso:[],
        params:[
            {description:"New action URL", optional:false, name:"action", defaultValue:null, type:"URL"}
        ],
        type:"method",
        definingClass:"class:DynamicForm"
    },
    "classAttr:GroupingMessages.upcomingBeforeTitle":{
        ref:"classAttr:GroupingMessages.upcomingBeforeTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs before\n the current date.",
        name:"upcomingBeforeTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Before\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:["i18nMessages"]
    },
    "method:ListGrid.chartColumn":{
        ref:"method:ListGrid.chartColumn",
        flags:"",
        description:" Chart a single column of data, with each cell value labelled by a value from another\n column.\n\n",
        name:"chartColumn",
        seeAlso:[],
        params:[
            {description:"name of the ListGridField to use as a data", optional:false,
             name:"dataColumn", defaultValue:null, type:"String"},
            {description:"name of the ListGridField to use as labels for data", optional:false,
             name:"labelColumn", defaultValue:null, type:"String"},
            {description:"properties to pass to the created chart", optional:true,
             name:"chartProperties", defaultValue:null, type:"Chart Properties"}
        ],
        returns:{description:"created Chart instance", type:"Chart"},
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:ListGrid.isSeparatorProperty":{
        ref:"attr:ListGrid.isSeparatorProperty",
        flags:"IRW",
        description:"If <code>record[this.isSeparatorProperty]</code> is set for some record, the \n record will be displayed as a simple separator row.",
        name:"isSeparatorProperty",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"isSeparator\"",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:Number.stringify":{
        ref:"method:Number.stringify",
        flags:"",
        description:"\n Return this number as a string padded out to digits length.\n\n",
        name:"stringify",
        seeAlso:[],
        params:[
            {description:"Number of digits to pad to.  (Default is 2)", optional:true, name:"digits",
             defaultValue:"2", type:"number"}
        ],
        returns:{description:"Padded string version of the number", type:"string"},
        type:"method",
        examples:["var str = myNumberVar.stringify(2);"],
        definingClass:"object:Number",
        groups:["stringProcessing"]
    },
    "attr:TreeGrid.customIconProperty":{
        ref:"attr:TreeGrid.customIconProperty",
        flags:"IRW",
        description:"This property allows the developer to customize the icon displayed next to a node.\n Set <code>node[grid.customIconProperty]</code> to the URL of the desired icon to display and\n it will be shown instead of the standard ${isc.DocUtils.linkForRef('attr:TreeGrid.nodeIcon')} for this node.<br>\n Note that if ${isc.DocUtils.linkForRef('attr:TreeGrid.showCustomIconOpen')} and/or ${isc.DocUtils.linkForRef('attr:TreeGrid.showCustomIconDrop')} \n is true for this grid, customized icons for folder nodes will be appended with the \n ${isc.DocUtils.linkForRef('attr:TreeGrid.dropIconSuffix')} or ${isc.DocUtils.linkForRef('attr:TreeGrid.openIconSuffix')} suffixes on state change \n as with the standard ${isc.DocUtils.linkForRef('attr:TreeGrid.folderIcon')} for this treeGrid.  Also note that for\n custom folder icons, the ${isc.DocUtils.linkForRef('attr:TreeGrid.closedIconSuffix')} will never be appened.",
        name:"customIconProperty",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"icon\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "attr:HeaderSpan.height":{
        ref:"attr:HeaderSpan.height",
        flags:"IR",
        description:"Height of this headerSpan.  Defaults to ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpanHeight')}.",
        name:"height",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:HeaderSpan",
        groups:["headerSpan"]
    },
    "attr:TabSet.closeTabIconSize":{
        ref:"attr:TabSet.closeTabIconSize",
        flags:"IR",
        description:"Size in pixels of the icon for closing tabs, displayed when ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')} is true.",
        name:"closeTabIconSize",
        seeAlso:[],
        valueType:"int",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "method:Img.setSrc":{
        ref:"method:Img.setSrc",
        flags:"",
        description:" Changes the URL of this image and redraws it.\n <P>\n Does nothing if the src has not changed - if <code>src</code> has not changed but other\n state has changed such that the image needs updating, call ${isc.DocUtils.linkForRef('method:Img.resetSrc')} instead.\n\n",
        name:"setSrc",
        seeAlso:[],
        params:[
            {description:"new URL for the image", optional:false, name:"URL", defaultValue:null,
             type:"URL"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('loadImages')}"],
        definingClass:"class:Img",
        groups:["appearance"]
    },
    "type:OperatorId":{
        ref:"type:OperatorId",
        values:[
            {description:"exactly equal to", value:"\"equals\""},
            {description:"not equal to", value:"\"notEqual\""},
            {description:"Greater than", value:"\"greaterThan\""},
            {description:"Less than", value:"\"lessThan\""},
            {description:"Greater than or equal to", value:"\"greaterOrEqual\""},
            {description:"Less than or equal to", value:"\"lessOrEqual\""},
            {description:"Contains as sub-string (match case)", value:"\"contains\""},
            {description:"Starts with (match case)", value:"\"startsWith\""},
            {description:"Ends with (match case)", value:"\"endsWith\""},
            {description:"Contains as sub-string (case insensitive)", value:"\"iContains\""},
            {description:"Starts with (case insensitive)", value:"\"iStartsWith\""},
            {description:"Ends with (case insensitive)", value:"\"iEndsWith\""},
            {description:"Does not contain as sub-string (match case)", value:"\"notContains\""},
            {description:"Does not start with (match case)", value:"\"notStartsWith\""},
            {description:"Does not end with (match case)", value:"\"notEndsWith\""},
            {description:"Does not contain as sub-string (case insensitive)",
             value:"\"iNotContains\""},
            {description:"Does not start with (case insensitive)", value:"\"iNotStartsWith\""},
            {description:"Does not end with (case insensitive)", value:"\"iNotEndsWith\""},
            {description:"Regular expression match", value:"\"regexp\""},
            {description:"Regular expression match (case insensitive)", value:"\"iregexp\""},
            {description:"value is null", value:"\"isNull\""},
            {description:"value is non-null.  Note empty string (\"\") is non-null",
             value:"\"notNull\""},
            {description:"value is in a set of values.  Specify criterion.value as an Array",
             value:"\"inSet\""},
            {description:"value is not in a set of values.  Specify criterion.value as an Array",
             value:"\"notInSet\""},
            {description:"matches another field (specify fieldName as criterion.value)",
             value:"\"equalsField\""},
            {description:"does not match another field (specified fieldName as criterion.value)",
             value:"\"notEqualField\""},
            {description:"all subcriteria (criterion.criteria) are true", value:"\"and\""},
            {description:"all subcriteria (criterion.criteria) are false", value:"\"not\""},
            {description:"at least one subcriteria (criterion.criteria) is true", value:"\"or\""},
            {description:"shortcut for \"greaterThan\" + \"lessThan\" + \"and\".  Specify criterion.start         and criterion.end",
             value:"\"between\""},
            {description:"shortcut for \"greaterOrEqual\" + \"lessOrEqual\" + \"and\".  Specify         criterion.start and criterion.end",
             value:"\"betweenInclusive\""}
        ],
        treeLocation:["Client Reference/Data Binding/DataSource"],
        description:"An operator is used as part of a ${isc.DocUtils.linkForRef('object:Criterion')} when specifying ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.\n <P>\n This list of operators indicates the set of operators built into SmartClient DataSources,\n which can be used for both client and server-side filtering.   You can extend the list of\n operators with ${isc.DocUtils.linkForRef('method:DataSource.addSearchOperator')}.",
        name:"OperatorId",
        seeAlso:[],
        type:"type",
        groups:["advancedFilter"]
    },
    "attr:DataBoundComponent.addFormulaFieldText":{
        ref:"attr:DataBoundComponent.addFormulaFieldText",
        flags:"IRW",
        description:"Text for a menu item allowing users to add a formula field",
        name:"addFormulaFieldText",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"Add formula column...\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["i18nMessages"]
    },
    "attr:FormItem.align":{
        ref:"attr:FormItem.align",
        flags:"IRW",
        description:"Alignment of this item in its cell. Note that the alignment of content within this item\n can be separately controlled via ${isc.DocUtils.linkForRef('attr:FormItem.textAlign')} (typically only applies to items\n showing a \"textBox\", such as ${isc.DocUtils.linkForRef('class:TextItem','textItems')} or ${isc.DocUtils.linkForRef('class:SelectItem','selectItems')}).",
        name:"align",
        seeAlso:[],
        valueType:"Alignment",
        defaultValue:"Canvas.LEFT",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["appearance"]
    },
    "method:FormItem.change":{
        ref:"method:FormItem.change",
        flags:"",
        description:" Called when a FormItem's value is about to change as the result of user interaction.  This\n method fires after the user performed an action that would change the value of this field,\n but before the element itself is changed.  \n <P>\n Returning false cancels the change.  Note that if what you want to do is\n <b>transform</b> the user's input, for example, automatically change separator\n characters to a standard separator character, you should implement\n ${isc.DocUtils.linkForRef('method:FormItem.transformInput','transformInput')} rather than using a combination of\n change() and setValue() to accomplish the same thing.  Returning false from\n <code>change</code> is intended for rejecting input entirely, such as typing invalid\n characters.\n <p>\n Note that if you ask the form for the current value in this handler, you will get the old\n value because the change has not yet been commited.  The new value is available as a\n parameter to this method.\n\n",
        name:"change",
        seeAlso:[],
        params:[
            {description:"the managing DynamicForm instance", optional:false, name:"form",
             defaultValue:null, type:"DynamicForm"},
            {description:"the form item itself (also available as \"this\")", optional:false,
             name:"item", defaultValue:null, type:"FormItem"},
            {description:"The new value of the form item", optional:false, name:"value",
             defaultValue:null, type:"any"},
            {description:"The previous value of the form item", optional:false, name:"oldValue",
             defaultValue:null, type:"any"}
        ],
        returns:{description:"In your handler, return false to cancel the change, true to allow the change",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('fieldEnableDisable')}"],
        definingClass:"class:FormItem",
        groups:["eventHandling"]
    },
    "method:Date.getWeek":{
        ref:"method:Date.getWeek",
        flags:"",
        description:"      Returns an integer containing the week number\n",
        name:"getWeek",
        seeAlso:[],
        returns:{description:"week number, starting with 1", type:"integer"},
        type:"method",
        definingClass:"class:Date",
        groups:["dateFormatting"]
    },
    "attr:BlurbItem.clipValue":{
        ref:"attr:BlurbItem.clipValue",
        flags:"IRW",
        description:"If true, text that exceeds the specified size of the form item will be clipped",
        name:"clipValue",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:BlurbItem",
        groups:["appearance"]
    },
    "method:Tree.openAll":{
        ref:"method:Tree.openAll",
        flags:"",
        description:"\n Open all nodes under a particular node.\n\n",
        name:"openAll",
        seeAlso:[],
        params:[
            {description:"node from which to open folders (if not specified, the root                              node is used)",
             optional:true, name:"node", defaultValue:null, type:"TreeNode"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('parentLinking')}"],
        definingClass:"class:Tree"
    },
    "method:Dialog.closeClick":{
        ref:"method:Dialog.closeClick",
        flags:"",
        description:" Handles a click on the close button of this window. The default implementation\n hides the window and returns false to cancel bubbling.  Override this method if you want\n other actions to be taken.\n",
        name:"closeClick",
        seeAlso:[],
        type:"method",
        definingClass:"class:Dialog",
        groups:["buttons"]
    },
    "attr:Canvas.disabledCursor":{
        ref:"attr:Canvas.disabledCursor",
        flags:"IRWA",
        description:"Specifies the cursor image to display when the mouse pointer is\n      over this widget if this widget is disabled. It corresponds to the CSS cursor \n      attribute. See Cursor type for different cursors.",
        name:"disabledCursor",
        seeAlso:[],
        valueType:"Cursor",
        defaultValue:"Canvas.DEFAULT",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["cues"]
    },
    "group:CompoundFormItem_skinning":{
        ref:"group:CompoundFormItem_skinning",
        refs:[],
        description:"When skinning basic FormItems like SelectItem and TextItem, consider that compound form\n items like DateItem and ComboBox reuse simpler items like SelectItem and TextItem, so adding\n a border to SelectItem would also apply a border to each select item within DateItem.<br>\n To avoid such side-effects, if you want to add styling to all SelectItems used in your \n application, you can create an application-specific subclass like MySelectItem and apply \n properties there.<br>",
        name:"CompoundFormItem_skinning",
        seeAlso:[],
        type:"group"
    },
    "method:Calendar.addEvent":{
        ref:"method:Calendar.addEvent",
        flags:"",
        description:" Create a new event in this calendar instance.\n\n",
        name:"addEvent",
        seeAlso:[],
        params:[
            {description:"start date of event", optional:false, name:"startDate", defaultValue:null,
             type:"Date"},
            {description:"end date of event", optional:false, name:"endDate", defaultValue:null,
             type:"Date"},
            {description:"name of event", optional:false, name:"name", defaultValue:null, type:"String"},
            {description:"description of event", optional:false, name:"description", defaultValue:null,
             type:"String"},
            {description:"new values of additional fields to be updated", optional:false,
             name:"otherFields", defaultValue:null, type:"Object"}
        ],
        type:"method",
        definingClass:"class:Calendar"
    },
    "attr:DynamicForm.showErrorIcons":{
        ref:"attr:DynamicForm.showErrorIcons",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed next to form items when ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors')} is true.\n These properties are boolean values, and can be set on a DynamicForm to control the \n behavior form-wide, or set on individual FormItems.\n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implemenation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).  \n <P>\n In addition to this, <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')} for a \n discussion for how error styling is calculated.",
        name:"showErrorIcons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["validation"]
    },
    "method:Array.sortByProperty":{
        ref:"method:Array.sortByProperty",
        flags:"",
        description:" Sort a list of objects by a given property of each item.\n <P>\n The optional normalizer, if passed as a function, is called for each item in the List, and\n should return whatever value should be used for sorting, which does not have to agree with\n the property value. By passing a normalizer function you can achieve any kind of sorting\n you'd like, including sorting by multiple properties.\n <P>\n NOTE: string sort is case INsensitive by default\n\n",
        name:"sortByProperty",
        seeAlso:[],
        params:[
            {description:"name of the property to sort by", optional:false, name:"property",
             defaultValue:null, type:"string"},
            {description:"true == sort ascending, false == sort descending", optional:false, name:"up",
             defaultValue:null, type:"boolean"},
            {description:"May be specified as a function, with signature \n              <code>normalize(item, propertyName, context)</code>, where <code>item</code> is\n              a pointer to the item in the array, <code>propertyName</code> is the \n              property by which the array is being sorted, and <code>context</code> is the\n              arbitrary context passed into this method. Normalizer function should return\n              the value normalized for sorting.<br>\n              May also be specified as a ValueMap which maps property values to sortable values.",
             optional:true, name:"normalizer", defaultValue:null, type:"function or ValueMap"},
            {description:"Callers may pass an arbitrary context into the sort method, which                          will then be made available to the normalizer function",
             optional:true, name:"context", defaultValue:null, type:"any"}
        ],
        returns:{description:"the list itself", type:"List"},
        type:"method",
        definingClass:"object:Array",
        groups:["sorting"]
    },
    "classAttr:Validator.mustBeShorterThan":{
        ref:"classAttr:Validator.mustBeShorterThan",
        flags:"IRA",
        description:"Default error message to display when standard <code>lengthRange</code> type validator\n returns false becaues the value passed in has more than <code>validator.max</code> characters.\n This is a dynamic string - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        name:"mustBeShorterThan",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Must be less than ${max} characters\"",
        type:"classAttr",
        definingClass:"class:Validator",
        groups:["i18nMessages"]
    },
    "type:DragDataAction":{
        ref:"type:DragDataAction",
        values:[
            {description:"Don't do anything, resulting in the same data being in both lists.",
             value:"\"none\""},
            {description:"Copy the data leaving the original in our list.", value:"Canvas.COPY"},
            {description:"Remove the data from this list so it can be moved into the other list.",
             value:"Canvas.MOVE"}
        ],
        description:"What do we do with data that's been dropped into another list?",
        name:"DragDataAction",
        seeAlso:[],
        type:"type",
        groups:["drag"]
    },
    "method:ResultSet.invalidateCache":{
        ref:"method:ResultSet.invalidateCache",
        flags:"A",
        description:" Manually invalidate this ResultSet's cache.\n <P>\n Generally a ResultSet will observe and incorporate updates to the DataSource that provides it's\n records, but when this is not possible, <code>invalidateCache()</code> allows manual cache\n invalidation.\n <P>\n <code>invalidateCache()</code> fires <code>dataChanged()</code>, which may cause components which\n as using this ResultSet to request new data for display, triggering server fetches.\n",
        name:"invalidateCache",
        seeAlso:[],
        type:"method",
        definingClass:"class:ResultSet"
    },
    "method:Menu.showContextMenu":{
        ref:"method:Menu.showContextMenu",
        flags:"",
        description:" Show this menu as a context menu, that is, immediately adjacent to the current mouse position.\n\n",
        name:"showContextMenu",
        seeAlso:[],
        returns:{description:"false == stop processing this event", type:"boolean"},
        type:"method",
        definingClass:"class:Menu",
        groups:["visibility"]
    },
    "attr:FormulaBuilder.helpTextIntro":{
        ref:"attr:FormulaBuilder.helpTextIntro",
        flags:"IR",
        description:"Text that appears in the hover from the ${isc.DocUtils.linkForRef('attr:FormulaBuilder.helpIcon')}, as a pre-amble to the list of\n available functions.",
        name:"helpTextIntro",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"For basic arithmetic, type in symbols (+-/%) directly.<P>The following functions are also available:\"",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["i18nMessages"]
    },
    "attr:TileGrid.autoFetchData":{
        ref:"attr:TileGrid.autoFetchData",
        flags:"IR",
        description:"If true, when this component is first drawn, automatically call <code>this.fetchData()</code>\n or <code>this.filterData()</code> depending on ${isc.DocUtils.linkForRef('attr:TileGrid.autoFetchAsFilter')}.\n Criteria for this fetch may be picked up from ${isc.DocUtils.linkForRef('attr:TileGrid.initialCriteria')}.",
        name:"autoFetchData",
        seeAlso:[
            {ref:"method:TileGrid.fetchData", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('fetchOperation')}"],
        definingClass:"class:TileGrid",
        groups:["databinding"]
    },
    "attr:Window.hiliteHeaderSrc":{
        ref:"attr:Window.hiliteHeaderSrc",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:Window.showHeaderBackground')} is true, this governs the URL of the image to \n use in the header's highlighted state when the window is ${isc.DocUtils.linkForRef('method:Window.flash','flashed')}",
        name:"hiliteHeaderSrc",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]Window/headerGradient_hilite.gif\" | null",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "header"]
    },
    "attr:GridRenderer.showHover":{
        ref:"attr:GridRenderer.showHover",
        flags:"RW",
        description:"If true, and canHover is also true, when the user hovers over a cell, hover text will pop up\n next to the mouse.  The contents of the hover is determined by ${isc.DocUtils.linkForRef('method:GridRenderer.cellHoverHTML')}.",
        name:"showHover",
        seeAlso:[
            {ref:"attr:GridRenderer.canHover", description:null},
            {ref:"method:GridRenderer.cellHoverHTML", description:null}
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "method:GridRenderer.cellContextClick":{
        ref:"method:GridRenderer.cellContextClick",
        flags:"A",
        description:" Called when a cell receives a contextclick event.\n\n",
        name:"cellContextClick",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "class:ValidatorTypes":{
        methods:[],
        ref:"class:ValidatorTypes",
        classAttrs:["classAttr:ValidatorTypes.isBoolean", "classAttr:ValidatorTypes.isString", 
         "classAttr:ValidatorTypes.isInteger","classAttr:ValidatorTypes.isFloat", "classAttr:ValidatorTypes.requiredIf", 
         "classAttr:ValidatorTypes.matchesField","classAttr:ValidatorTypes.isOneOf", "classAttr:ValidatorTypes.integerRange", 
         "classAttr:ValidatorTypes.lengthRange","classAttr:ValidatorTypes.contains", "classAttr:ValidatorTypes.doesntContain", 
         "classAttr:ValidatorTypes.substringCount","classAttr:ValidatorTypes.regexp", "classAttr:ValidatorTypes.mask", 
         "classAttr:ValidatorTypes.dateRange","classAttr:ValidatorTypes.floatRange", "classAttr:ValidatorTypes.floatPrecision"],
        classMethods:[],
        treeLocation:["Client Reference/Forms/Validator"],
        attrs:[],
        description:"The set of standard validator types available on all fields.<br>\n  To make use of some standard validator type for a field in a DataSource, or \n  DynamicForm instance, specify the <code>validators</code> property to an array \n  containing a validator definition where the <code>type</code> property is set to \n  the appropriate type.  \n  A custom error message can be specified for any validator type by setting the\n  <code>errorMessage</code> property on the validator definition object, and some\n  validator types make use of additional properties on the validator definition \n  object such as <code>max</code> or <code>min</code>.<br>\n  For example, to make use of the <code>integerRange</code> validator type:<br><br><code>\n  &nbsp;&nbsp;field:{<br>\n  &nbsp;&nbsp;&nbsp;&nbsp;validators:[<br>\n  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{type:\"integerRange\", min:1, max:100}<br>\n  &nbsp;&nbsp;&nbsp;&nbsp;]<br>\n  &nbsp;&nbsp;}\n  </code><br><br>",
        name:"ValidatorTypes",
        seeAlso:[],
        type:"class"
    },
    "method:GridRenderer.cellSelectionChanged":{
        ref:"method:GridRenderer.cellSelectionChanged",
        flags:"A",
        description:" Called when (cell-based) selection changes within this grid.\n\n",
        name:"cellSelectionChanged",
        seeAlso:[],
        params:[
            {description:"Array of cells whos selected state was modified.", optional:false,
             name:"cellList", defaultValue:null, type:"array"}
        ],
        returns:{description:"Returning false will prevent the GridRenderer styling from being updated                      to reflect the selection change.",
         type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["selection"]
    },
    "method:GridRenderer.rowHover":{
        ref:"method:GridRenderer.rowHover",
        flags:"A",
        description:" Called when the mouse hovers over a row if this.canHover is true. \n  Returning false will suppress the hover text from being shown if this.showHover is true.\n\n",
        name:"rowHover",
        seeAlso:[
            {ref:"attr:GridRenderer.canHover", description:null}
        ],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event (default behavior of showing the hover)",
         type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "attr:FilterBuilder.rangeSeparator":{
        ref:"attr:FilterBuilder.rangeSeparator",
        flags:"IR",
        description:"For operators that check that a value is within a range, text to show between the start and\n end input fields for specifying the limits of the range.",
        name:"rangeSeparator",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"and\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:["i18nMessages"]
    },
    "attr:ListGrid.shrinkForFreeze":{
        ref:"attr:ListGrid.shrinkForFreeze",
        flags:"IRWA",
        description:"If this list grid is showing any ${isc.DocUtils.linkForRef('attr:ListGridField.frozen','frozen')} fields, and a horizontal\n scrollbar is visible at the bottom of the liquid columns, should an equivalent scrollbar gap\n be left visible below the frozen columns?<br>\n Note that if set to <code>true</code> any backgroundColor or border applied to the ListGrid\n will show up below the bottom row of the frozen column(s).",
        name:"shrinkForFreeze",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["frozenFields"]
    },
    "attr:ListGridField.frozen":{
        ref:"attr:ListGridField.frozen",
        flags:"IR",
        description:"Whether this field should be \"frozen\" for the purposes of horizontal scrolling.  See\n ${isc.DocUtils.linkForRef('group:frozenFields')}.",
        name:"frozen",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["frozenFields"]
    },
    "method:Date.getShortMonthName":{
        ref:"method:Date.getShortMonthName",
        flags:"",
        description:" Return the abbreviated (up to 3 chars) name of the month for this date (Jan, Feb, etc)\n To modify the value returned by this method, set ${isc.DocUtils.linkForRef('classAttr:Date.shortMonthNames')}\n",
        name:"getShortMonthName",
        seeAlso:[],
        params:[
            {description:"Number of characters to return (Defaults to 3, can't be                                  longer than 3)",
             optional:false, name:"length", defaultValue:null, type:"number"}
        ],
        returns:{description:"Abbreviated month name (3 character string)", type:"string"},
        type:"method",
        definingClass:"class:Date",
        groups:["dateFormatting"]
    },
    "method:Canvas.setBackgroundImage":{
        ref:"method:Canvas.setBackgroundImage",
        flags:"",
        description:"			Sets the background to an image file given by newImage. This URL should be given as a\n          string relative to the image directory for the page (./images by default).\n",
        name:"setBackgroundImage",
        seeAlso:[],
        params:[
            {description:"new URL (local to Page image directory) for background image",
             optional:false, name:"newImage", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["appearance"]
    },
    "method:Canvas.setPadding":{
        ref:"method:Canvas.setPadding",
        flags:"",
        description:" Set the CSS padding of this component, in pixels.  Padding provides space between the border\n and the component's contents.\n <P>\n This property sets the same thickness of padding on every side.  Differing per-side\n padding can be set in a CSS style and applied via ${isc.DocUtils.linkForRef('attr:Canvas.styleName')}.\n <P>\n",
        name:"setPadding",
        seeAlso:[],
        params:[
            {description:"new padding in pixels", optional:false, name:"newPadding", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["appearance"]
    },
    "method:StretchImgButton.setAutoFit":{
        ref:"method:StretchImgButton.setAutoFit",
        flags:"",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        name:"setAutoFit",
        seeAlso:[],
        params:[
            {description:"New autoFit setting.", optional:false, name:"autoFit", defaultValue:null,
             type:"boolean"}
        ],
        type:"method",
        definingClass:"class:StretchImgButton"
    },
    "attr:ListGrid.titleField":{
        ref:"attr:ListGrid.titleField",
        flags:"IRW",
        getter:["getTitleField"],
        description:"Best field to use for a user-visible title for an individual record from this grid.\n If ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')} is non null, this property may be specified on the \n dataSource instead.\n <p>\n If not explicitly set, titleField looks for fields named \"title\", \"name\", and \"id\" \n in that order.  If a field exists with one of those names, it becomes the titleField.  \n If not, then the first field is designated as the titleField.",
        name:"titleField",
        seeAlso:[],
        valueType:"string",
        defaultValue:"see below",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:DynamicForm.hiliteRequiredFields":{
        ref:"attr:DynamicForm.hiliteRequiredFields",
        flags:"IRW",
        description:"Indicates whether the titles of required items in this form should use the special\n prefix and suffix specified by the next two properties, instead of the standard\n prefix and suffix.",
        name:"hiliteRequiredFields",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["formTitles"]
    },
    "method:ListGrid.rowHasChanges":{
        ref:"method:ListGrid.rowHasChanges",
        flags:"",
        description:" If this listGrid can be edited, this method will return true if the row passed in has been\n edited, but the edits have not yet been saved to the ListGrid's data object.\n",
        name:"rowHasChanges",
        seeAlso:[],
        params:[
            {description:"index of row to check for changes", optional:false, name:"rowNum",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"true if the row has changes.", type:"boolean"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "attr:ListGridField.align":{
        ref:"attr:ListGridField.align",
        flags:"IRW",
        description:"Horizontal alignment for field's column header: \"left\", \"right\"\n or \"center\". Applied to the column header title and cells by default. A separate\n alignment for cells can be specified via ${isc.DocUtils.linkForRef('attr:ListGridField.cellAlign')}.<br>\n If null, values are left-aligned. If this field is editable, the\n alignment of cells in the body will also be reflected in any editors for the field.",
        name:"align",
        seeAlso:[],
        valueType:"Alignment",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["appearance"]
    },
    "attr:Canvas.mouseStillDownDelay":{
        ref:"attr:Canvas.mouseStillDownDelay",
        flags:"IRWA",
        description:"Amount of time (in msec) between 'mouseStillDown' events for this object",
        name:"mouseStillDownDelay",
        seeAlso:[],
        valueType:"number",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["events"]
    },
    "attr:FacetValue.title":{
        ref:"attr:FacetValue.title",
        flags:"IRW",
        description:"user-visible title of this facetValue.  Shown on the field header.",
        name:"title",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "attr:ListGrid.canReorderRecords":{
        ref:"attr:ListGrid.canReorderRecords",
        flags:"IRW",
        description:"Indicates whether records can be reordered by dragging within this listGrid.",
        name:"canReorderRecords",
        seeAlso:[
            {ref:"attr:ListGridRecord.canDrag", description:null},
            {ref:"attr:ListGridRecord.canAcceptDrop", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dragListMove')}", 
         "${isc.DocUtils.linkForExampleId('gridsDragReorder')}"],
        definingClass:"class:ListGrid",
        groups:["dragging"]
    },
    "attr:DateChooser.baseWeekdayStyle":{
        ref:"attr:DateChooser.baseWeekdayStyle",
        flags:"IRW",
        description:"Base css style applied to weekdays. Will have \"Over\", \"Selected\" and \"Down\"\n suffix appended as the user interacts with buttons.  Defaults to ${isc.DocUtils.linkForRef('attr:DateChooser.baseButtonStyle')}.",
        name:"baseWeekdayStyle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:DataSourceField.foreignKey":{
        ref:"attr:DataSourceField.foreignKey",
        flags:"IR",
        description:"Declares that this field holds values that can be matched to values from another DataSource\n field, to create a relationship between records from different DataSources or even records\n within the same DataSource.\n <p>\n The format of <code>foreignKey</code> is\n <code>&lt;dataSourceId&gt;.&lt;fieldName&gt;</code>.<br>\n For a foreignKey within the same dataSource, you can omit the <code>dataSourceId</code>\n and just specify <code>&lt;fieldName&gt;</code>.<br>\n For example, to create a tree relationship within a DataSource:\n <pre>\n   DataSource.create({\n     ID:\"supplyItem\",\n     fields : [\n       {name:\"itemId\", type:\"sequence\", primaryKey:true},\n       {name:\"parentId\", type:\"integer\", foreignKey:\"itemId\"},\n       ...\n     ]\n   });\n </pre>\n <P>\n <code>foreignKey</code> declarations also allow other automatic behaviors by\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')}, such as ${isc.DocUtils.linkForRef('method:ListGrid.fetchRelatedData')}.",
        name:"foreignKey",
        seeAlso:[],
        valueType:"String",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["dataSourceRelations"]
    },
    "attr:MenuItem.isSeparator":{
        ref:"attr:MenuItem.isSeparator",
        flags:"IR",
        description:"When set to <code>true</code>, this menu item shows a horizontal separator instead of\n the ${isc.DocUtils.linkForRef('attr:MenuItem.title')} text.  Typically specified as the only property of a menu item,\n since the separator will not respond to mouse events.",
        name:"isSeparator",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('fullMenu')}"],
        definingClass:"object:MenuItem",
        groups:["menuBasic"]
    },
    "attr:ColorPicker.opacitySliderLabel":{
        ref:"attr:ColorPicker.opacitySliderLabel",
        flags:"IR",
        description:"The label shown next to the opacity slider. Ignored if \n ${isc.DocUtils.linkForRef('attr:ColorPicker.supportsTransparency')} is false.",
        name:"opacitySliderLabel",
        seeAlso:[],
        valueType:"text",
        defaultValue:"\"Opacity\"",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "attr:ListGrid.autoFitMaxWidth":{
        ref:"attr:ListGrid.autoFitMaxWidth",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"horizontal\"</code> or <code>\"both\"</code>\n this property provides an upper limit on how far the ListGrid will expand horizontally to\n accomodate its content. \n If content exceeds this width, scrollbars will be introduced as usual.  \n In addition to this property, ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxColumns')} allows you to limit \n horizontal expansion based on the number of columns to be rendered.",
        name:"autoFitMaxWidth",
        setter:["setAutoFitMaxWidth"],
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["autoFitData"]
    },
    "method:TabSet.getTabPane":{
        ref:"method:TabSet.getTabPane",
        flags:"",
        description:" Returns the pane for a given tab.\n\n",
        name:"getTabPane",
        seeAlso:[],
        params:[
            {description:null, optional:false, name:"tab", defaultValue:null,
             type:"object | number | ID | Tab"}
        ],
        returns:{description:"the tab pane", type:"Canvas"},
        type:"method",
        definingClass:"class:TabSet"
    },
    "object:Browser":{
        methods:[],
        ref:"object:Browser",
        classAttrs:["classAttr:Browser.isSupported"],
        classMethods:[],
        treeLocation:["Client Reference/Foundation"],
        attrs:[],
        description:"Object containing flags indicating basic attributes of the browser.",
        name:"Browser",
        seeAlso:[],
        type:"object"
    },
    "method:GridRenderer.cellOut":{
        ref:"method:GridRenderer.cellOut",
        flags:"A",
        description:" Called when the mouse pointer leaves a cell\n\n",
        name:"cellOut",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "method:DataSource.applyFilter":{
        ref:"method:DataSource.applyFilter",
        flags:"",
        description:" Returns records in the passed Array that match the provided filter\n ${isc.DocUtils.linkForRef('type:Criteria','criteria')}.\n <P>\n By default:\n <ul>\n <li> any criteria that do not correspond to a DataSource field are ignored\n <li> any null or empty string criteria are ignored\n <li> all other criteria are passed to ${isc.DocUtils.linkForRef('method:DataSource.fieldMatchesFilter')}\n </ul>\n This method is called by ${isc.DocUtils.linkForRef('method:ResultSet.applyFilter')} to provide filtering when a\n ResultSet has a complete cache and filtering can be performed client-side.  You may want\n to override this method in order to mimic the filtering behavior that your server performs.\n\n",
        name:"applyFilter",
        seeAlso:[],
        params:[
            {description:"the list of rows", optional:false, name:"data", defaultValue:null,
             type:"Array"},
            {description:"the filter criteria", optional:false, name:"criteria", defaultValue:null,
             type:"Criteria"},
            {description:"optional dataSource request properties", optional:true,
             name:"requestProperties", defaultValue:null, type:"DSRequest Properties"}
        ],
        returns:{description:"the list of matching rows", type:"Array"},
        type:"method",
        definingClass:"class:DataSource"
    },
    "object:Array":{
        methods:["method:Array.get", "method:Array.getLength", "method:Array.isEmpty", "method:Array.first", 
         "method:Array.last","method:Array.indexOf", "method:Array.lastIndexOf", "method:Array.contains", 
         "method:Array.containsAll","method:Array.intersect", "method:Array.equals", "method:Array.getItems", 
         "method:Array.getRange","method:Array.duplicate", "method:Array.set", "method:Array.addAt", 
         "method:Array.removeAt","method:Array.add", "method:Array.addList", "method:Array.setLength", 
         "method:Array.addListAt","method:Array.remove", "method:Array.removeList", "method:Array.dataChanged", 
         "method:Array.getProperty","method:Array.getValueMap", "method:Array.map", "method:Array.setProperty", 
         "method:Array.clearProperty","method:Array.getUniqueItems", "method:Array.findIndex", "method:Array.findNextIndex", 
         "method:Array.find","method:Array.containsProperty", "method:Array.findAll", "method:Array.slide", 
         "method:Array.slideRange","method:Array.makeIndex", "method:Array.sortByProperty", "method:Array.unsort", 
         "method:Array.max","method:Array.min", "method:Array.sum", "method:Array.and", "method:Array.or"],
        ref:"object:Array",
        classAttrs:["classAttr:Array.LOADING", "classAttr:Array.CASE_INSENSITIVE", 
         "classAttr:Array.DATE_VALUES","classAttr:Array.DATETIME_VALUES"],
        classMethods:["classMethod:Array.isLoading", "classMethod:Array.compareAscending", 
         "classMethod:Array.compareDescending"],
        treeLocation:["Client Reference/System"],
        attrs:[],
        description:"Generic extensions to JavaScript Arrays.  You can call these on any Array.\n <P>\n JavaScript's native Array is retrofitted to support the <code>List</code> API.",
        name:"Array",
        implementsInterfaces:["List"],
        seeAlso:[
            {ref:"interface:List", description:null}
        ],
        type:"object"
    },
    "method:Button.deselect":{
        ref:"method:Button.deselect",
        flags:"",
        description:" Select this object.\n",
        name:"deselect",
        seeAlso:[],
        type:"method",
        definingClass:"class:Button",
        groups:["state"]
    },
    "attr:DataBoundComponent.showHiddenFields":{
        ref:"attr:DataBoundComponent.showHiddenFields",
        flags:"IRW",
        description:"Whether to show fields marked <code>hidden:true</code> when a DataBoundComponent is given a\n DataSource but no <code>component.fields</code>.\n <p>\n The <code>hidden</code> property is used on DataSource fields to mark fields that are\n never of meaning to an end user.",
        name:"showHiddenFields",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["databinding"]
    },
    "attr:BlurbItem.textBoxStyle":{
        ref:"attr:BlurbItem.textBoxStyle",
        flags:"IRW",
        description:"Base css style for this item.",
        name:"textBoxStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"staticTextItem\"",
        type:"attr",
        definingClass:"class:BlurbItem",
        groups:["appearance"]
    },
    "method:Window.setTitle":{
        ref:"method:Window.setTitle",
        flags:"",
        description:"          Sets the title text that appears in the window header; the header will be redrawn\n          if necessary.\n",
        name:"setTitle",
        seeAlso:[],
        params:[
            {description:"new title", optional:false, name:"newTitle", defaultValue:"null",
             type:"string"}
        ],
        type:"method",
        definingClass:"class:Window",
        groups:["header"]
    },
    "attr:DateChooser.monthMenuStyle":{
        ref:"attr:DateChooser.monthMenuStyle",
        flags:"IR",
        description:"Style for the pop-up year menu.",
        name:"monthMenuStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"dateChooserMonthMenu\"",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:ListGrid.generateDoubleClickOnSpace":{
        ref:"attr:ListGrid.generateDoubleClickOnSpace",
        flags:"IRWA",
        description:"If true, when the user navigates to a cell using arrow keys and hits Space, \n the cell will respond to a double click event.",
        name:"generateDoubleClickOnSpace",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:TreeGrid.toggleFolder":{
        ref:"method:TreeGrid.toggleFolder",
        flags:"",
        description:"          Opens the folder specified by node if it's closed, and closes it if it's open.\n          TreeGrid will redraw if there's a change in the folder's open/closed state.\n\n",
        name:"toggleFolder",
        seeAlso:[],
        params:[
            {description:"node to toggle", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:TreeGrid.folderClick":{
        ref:"method:TreeGrid.folderClick",
        flags:"",
        description:"\n This method is called when a folder record is clicked on.\n\n",
        name:"folderClick",
        seeAlso:[
            {ref:"method:TreeGrid.nodeClick", description:null}
        ],
        params:[
            {description:"The TreeGrid on which folderClick() occurred.", optional:false,
             name:"viewer", defaultValue:null, type:"TreeGrid"},
            {description:"The folder (record) that was clicked", optional:false, name:"folder",
             defaultValue:null, type:"TreeNode"},
            {description:"Index of the row where the click occurred.", optional:false,
             name:"recordNum", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "attr:StatefulCanvas.align":{
        ref:"attr:StatefulCanvas.align",
        flags:"IRW",
        description:"Horizontal alignment of this component's title.",
        name:"align",
        seeAlso:[],
        valueType:"Alignment",
        defaultValue:"Canvas.CENTER",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:["appearance"]
    },
    "object:TreeGridField":{
        methods:[],
        ref:"object:TreeGridField",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Grids/TreeGrid"],
        attrs:["attr:TreeGridField.treeField"],
        description:"An object literal with a particular set of properties used to configure the display of\n and interaction with the columns of a ${isc.DocUtils.linkForRef('class:TreeGrid')}.\n ${isc.DocUtils.linkForRef('class:TreeGrid')} is a subclass of ${isc.DocUtils.linkForRef('class:ListGrid')} and as a result, for all fields except\n the field containing the ${isc.DocUtils.linkForRef('class:Tree')} itself (specified by\n ${isc.DocUtils.linkForRef('attr:TreeGridField.treeField')}, all properties settable on\n ${isc.DocUtils.linkForRef('object:ListGridField')} apply to TreeGridField as well.\n <p>\n This class documents just those properties that are specific to TreeGridFields - see\n ${isc.DocUtils.linkForRef('object:ListGridField')} for the set of inherited properties.",
        name:"TreeGridField",
        seeAlso:[
            {ref:"object:ListGridField", description:null},
            {ref:"attr:TreeGrid.fields", description:null},
            {ref:"method:ListGrid.setFields", description:null}
        ],
        type:"object"
    },
    "attr:DSResponse.endRow":{
        ref:"attr:DSResponse.endRow",
        flags:"R",
        description:"End row of returned server results, when using paged result fetching\n <p>\n Note that startRow and endRow are zero-based - the first record is row zero.",
        name:"endRow",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSResponse",
        groups:["paging"]
    },
    "attr:ListGridRecord.linkText":{
        ref:"attr:ListGridRecord.linkText",
        flags:"IRW",
        description:"The HTML to display in this row for fields with fieldType set to link. This overrides\n  ${isc.DocUtils.linkForRef('attr:ListGridField.linkText')}.",
        name:"linkText",
        seeAlso:[
            {ref:"type:ListGridFieldType", description:null},
            {ref:"type:FieldType", description:null},
            {ref:"attr:ListGridField.linkText", description:null},
            {ref:"attr:ListGrid.linkTextProperty", description:null}
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord",
        groups:["display_values"]
    },
    "attr:FormItem.height":{
        ref:"attr:FormItem.height",
        flags:"IRW",
        description:"Default height of this item.",
        name:"height",
        seeAlso:[],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('formLayoutFilling')}"],
        definingClass:"class:FormItem",
        groups:["formLayout"]
    },
    "method:DataBoundComponent.deselectAllRecords":{
        ref:"method:DataBoundComponent.deselectAllRecords",
        flags:"",
        description:"\n Deselect all records\n\n",
        name:"deselectAllRecords",
        seeAlso:[],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["selection"]
    },
    "attr:TreeGrid.connectorImage":{
        ref:"attr:TreeGrid.connectorImage",
        flags:"IR",
        description:"The base filename for connector icons shown when ${isc.DocUtils.linkForRef('attr:TreeGrid.showConnectors')} is true.\n Connector icons are rendered into the title field of each row and show the dotted\n hierarchy lines between siblings of the same parent node. For each node, a connector icon\n may be shown:<ul>\n <li>As an opener icon for folder nodes, next to the folder icon</li>\n <li>In place of an opener icon for leaf nodes, next to the leaf icon</li>\n <li>As a standalone vertical continuation line in the indent to the left of the node, to show\n     a connection between some ancestor node's siblings (only relevant if\n     ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} is true).</li>\n </ul>\n Note that ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} governs whether connector lines will be\n displayed for all indent levels, or just for the innermost level of the tree.\n <P>\n The filenames for these icons are assembled from this base filename and the state of the\n node.  Assuming the connectorImage is set to <code>{baseName}.{extension}</code>, the\n full set of images to be displayed will be:\n <P>\n <code>{baseName}_ancestor[_rtl].{extension}</code> if ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')}\n  is true, this is the URL for the vertical continuation image to be displayed at the\n  appropriate indent levels for ancestor nodes with subsequent children.\n <P>\n For nodes with no children:\n <ul>\n <li><code>{baseName}_single[_rtl].{extension}</code>: Shown when there is no connector line\n  attached to the parent or previous sibling, and no connector line to the next sibling. For\n  ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors','showFullConnectors:true')} trees, there will always be a\n  connector leading to the parent or previous sibling if its present in the tree so this\n  icon can only be displayed for the first row.</li>\n <li><code>{baseName}_start[_rtl].{extension}</code>:  Shown when the there is no connector\n  line attached to the parent or previous sibling, but there is a connector to the next\n  sibling. As with <code>_single</code> this will only ever be used for the first row if\n  ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} is true</li>\n <li><code>{baseName}_end[_rtl].{extension}</code>:  Shown if we are not showing a connector \n  line attached to the next sibling of this node (but are showing a connection to the previous\n  sibling or parent).</li>\n <li><code>{baseName}_middle[_rtl].{extension}</code>:  Shown where the we have a connector\n  line leading to both the previous sibling (or parent) and the next sibling.\n </ul>\n For folders with children. Note that if ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} is false, open\n folders will never show a connector to subsequent siblings:\n <ul>\n <li><code>{baseName}_opened_single[_rtl].{extension}</code> opened folder node with \n  children when no connector line is shown attaching to either the folder's previous sibling\n  or parent, or to any subsequent siblings.</li>\n <li><code>{baseName}_opened_start[_rtl].{extension}</code>:  opened folder with children\n  when the there is no connector line attached to the parent or previous sibling, but there \n  is a connector to the next sibling.</li>\n <li><code>{baseName}_opened_end[_rtl].{extension}</code>:  opened folder with children \n  if we are not showing a connector line attached to the next sibling of this node (but are\n  showing a connection to the previous sibling or parent).</li>\n <li><code>{baseName}_opened_middle[_rtl].{extension}</code>: opened folder with children \n  where the we have a connector line leading to both the previous sibling (or parent) and the\n  next sibling.\n </ul>\n <ul>\n <li><code>{baseName}_closed_single[_rtl].{extension}</code> closed folder node with \n  children when no connector line is shown attaching to either the folder's previous sibling\n  or parent, or to any subsequent siblings.</li>\n <li><code>{baseName}_closed_start[_rtl].{extension}</code>:  closed folder with children\n  when the there is no connector line attached to the parent or previous sibling, but there \n  is a connector to the next sibling.</li>\n <li><code>{baseName}_closed_end[_rtl].{extension}</code>:  closed folder with children \n  if we are not showing a connector line attached to the next sibling of this node (but are\n  showing a connection to the previous sibling or parent).</li>\n <li><code>{baseName}_closed_middle[_rtl].{extension}</code>: closed folder with children \n  where the we have a connector line leading to both the previous sibling (or parent) and the\n  next sibling.\n </ul>\n (Note '[_rtl]' means that \"_rtl\" will be attached if isRTL() is true for this widget).",
        name:"connectorImage",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]connector.gif\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "attr:DataSourceField.javaKeyClass":{
        ref:"attr:DataSourceField.javaKeyClass",
        flags:"IR",
        description:"See ${isc.DocUtils.linkForRef('attr:DataSourceField.javaClass')} - when auto-populating of Java Beans / POJOs based on \n inbound DSRequest data, for a field of Map type, <code>javaKeyClass</code> can be used to\n specify a particular concrete class for the map keys.  If not specified, and a concrete\n type cannot be discovered using Java Reflection, <code>java.lang.Object</code> is used.\n\n Note that <code>javaKeyClass</code> take precedence over generics if both are used.",
        name:"javaKeyClass",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField"
    },
    "method:TreeGrid.getSelectedPaths":{
        ref:"method:TreeGrid.getSelectedPaths",
        flags:"",
        description:" Returns a snapshot of the current selection within this treeGrid as \n a ${isc.DocUtils.linkForRef('type:listGridSelectedState')} object.<br>\n This object can be passed to ${isc.DocUtils.linkForRef('method:TreeGrid.setSelectedPaths')} to reset this grid's selection\n the current state (assuming the same data is present in the grid).<br>\n",
        name:"getSelectedPaths",
        seeAlso:[
            {ref:"method:TreeGrid.setSelectedPaths", description:null}
        ],
        returns:{description:"current state of this grid's selection", type:"listGridSelectedState"},
        type:"method",
        definingClass:"class:TreeGrid",
        groups:["viewState"]
    },
    "group:loadXMLSchemaTag":{
        ref:"group:loadXMLSchemaTag",
        title:"&lt;isomorphic:loadXMLSchema&gt;",
        treeLocation:["Java Server Reference/SmartClient JSP Tags"],
        refs:[],
        description:"<i>produces:</i> JavaScript\n <p>\n Load an XML Schema (.xsd) file and create a ${isc.DocUtils.linkForRef('class:SchemaSet')} object representing the loaded\n definitions. This tag works just like ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema')}, except it's\n synchronous and the result is server-cacheable.\n <p>\n Note that this JSP tag must be surrounded by &lt;SCRIPT&gt; tags in the JSP because it\n generates JavaScript code.  Like other tags that generate JavaScript code, this tag can be\n used in a JSP that is included from your main page in order to create separate\n cacheability.  For example:<pre>\n     &lt;SCRIPT SRC=\"myXMLSchemaDefinitions.jsp\"&gt;&lt;/SCRIPT&gt;\n </pre>\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>url</b><br>\n <i>value format</i>: URL or URI\n <i>default value</i>: NONE\n <p>\n This attribute specifies the URL or URI of the XML Schema file to fetch and translate.  This\n can be either a remote URL - e.g: <code>http://host:port/schemaFile.xsd</code> or a relative\n or absolute URI to a file local to this container - e.g: <code>/some/schemaFile.xsd</code>\n or <code>../some/schemaFile.xsd</code>.  If the url is a remote URL, then an HTTP request\n will be made for the file.  If it is local, it will be fetched from disk using standard\n Servlet APIs (<code>ServletContext.getResourceAsStream()</code>).\n <p>\n <b>cache</b><br>\n <i>value format</i>: Integer (number of seconds to cache result)\n <i>default value</i>: 3600 (1 hour)\n <p>\n This attribute specifies the number of seconds for which the fetched XML Schema is cacheable\n on the server.  Fetching a XML Schema file from a remote server can cause a significant\n delay in JSP processing, and XML Schema files rarely change outside of a development\n environment.  Set this value to zero to disable caching.",
        name:"loadXMLSchemaTag",
        seeAlso:[
            {ref:"classMethod:XMLTools.loadXMLSchema", description:null}
        ],
        type:"group",
        requiresModules:["SCServer"]
    },
    "attr:DynamicForm.requiredTitlePrefix":{
        ref:"attr:DynamicForm.requiredTitlePrefix",
        flags:"IRW",
        description:"The string prepended to the title of every required item in this form if\n highlightRequiredFields is true.",
        name:"requiredTitlePrefix",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"<B>\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["formTitles"]
    },
    "attr:ColorPicker.colorArray":{
        ref:"attr:ColorPicker.colorArray",
        flags:"IR",
        description:"Array containing 40 HTML color strings, which will be shown as the basic color \n selection boxes.",
        name:"colorArray",
        seeAlso:[],
        valueType:"array",
        defaultValue:"[...]",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "group:facetExpansion":{
        ref:"group:facetExpansion",
        refs:["attr:CubeGrid.canCollapseFacets", "attr:CubeGrid.canMinimizeFacets"],
        description:null,
        name:"facetExpansion",
        seeAlso:[],
        type:"group"
    },
    "method:WebService.callOperation":{
        ref:"method:WebService.callOperation",
        flags:"",
        description:" Invoke a web service operation.\n <P>\n The <code>data</code> parameter will be serialized to XML to form the input message for\n the operation, as described by ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')}.  Namespacing,\n element ordering, and SOAP encoding rules are automatically followed.  If the web\n service you are trying to contact requires a complicated nested structure, consider\n using ${isc.DocUtils.linkForRef('attr:WSRequest.useFlatFields')} to simplify the required JavaScript input data.\n <P>\n The <code>resultType</code> selects what part of the message should be decoded to\n JavaScript and made available as the \"data\" variable in the callback.  The\n <code>resultType</code> parameter can be either:\n <ul>\n <li> an XPath.  \"data\" will be always be an Array, containing the selected elements as\n decoded by ${isc.DocUtils.linkForRef('classMethod:XMLTools.toJS')}.  All properties will have String value.\n <li> the name of an XML Schema type found somewhere in the response.  You can use the\n WSDL tab of the Developer Console to analyze the WSDL file for an appropriate type name.\n \"data\" will be an Array, containing the decoded elements as decoded by\n ${isc.DocUtils.linkForRef('method:DataSource.recordsFromXML')}.  In this case, since the XML Schema type of the\n selected data is known, properties will have correct type (eg \"date\" fields will\n have JavaScript Date objects)\n <li> null.  \"data\" will an Object representing the entire &lt;SOAP:Body&gt; as decoded\n to JavaScript.  As above, properties will have correct type.\n </ul>\n In the callback, you also receive the XML document returned by the web service as\n \"xmlDoc\".\n <P>\n NOTE: <code>callOperation()</code> is appropriate for simple operations that do not\n involve DataBound Components, such as logging into a web service, or retrieving simple\n String data.  <code>callOperation()</code> can also be used to retrieve small, read-only\n datasets such as the option list for a SelectItem, but only if the dataset is guaranteed\n to remain small enough for paging to be unnecessary.  For any larger datasets or\n anything that will be edited, DataSource integration is more appropriate.\n\n",
        name:"callOperation",
        seeAlso:[],
        params:[
            {description:"Name of the operation to invoke", optional:false, name:"operationName",
             defaultValue:null, type:"String"},
            {description:"data to serialize as XML to form the inbound message of                                  the operation",
             optional:false, name:"data", defaultValue:null, type:"Object"},
            {description:"Type, Element name, or XPath that                                  should be selected from the result",
             optional:false, name:"resultType", defaultValue:null, type:"Type or ElementName or XPath"},
            {description:"Callback to invoke on completion.  Signature                                  callback(data, xmlDoc, rpcResponse, wsRequest)",
             optional:false, name:"callback", defaultValue:null, type:"Callback"},
            {description:"Additional properties for the WSRequest, such                                      as HTTPHeaders",
             optional:false, name:"requestProperties", defaultValue:null, type:"WSRequest Properties"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('wsdlOperation')}"],
        definingClass:"class:WebService",
        groups:["webService"]
    },
    "method:FormItem.enable":{
        ref:"method:FormItem.enable",
        flags:"",
        description:" Set this item to be enabled at runtime.\n",
        name:"enable",
        seeAlso:[
            {ref:"attr:FormItem.disabled", description:null}
        ],
        type:"method",
        definingClass:"class:FormItem",
        groups:["enable"]
    },
    "method:ListGrid.getFilterEditorValueMap":{
        ref:"method:ListGrid.getFilterEditorValueMap",
        flags:"A",
        description:"\n  If we're showing the filter (query-by-example) row for this ListGrid, this method is\n  used to determine the valueMap to display in the filter row for this field.\n  Default implementation will return the field.filterEditorValueMap if specified, or\n  field.valueMap.\n\n",
        name:"getFilterEditorValueMap",
        seeAlso:[],
        params:[
            {description:"field definition field for which we need a valueMap", optional:false,
             name:"field", defaultValue:null, type:"ListGridField"}
        ],
        returns:{description:"ValueMap for the edit field (or null if no valueMap required)", type:"ValueMap"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["filterEditor"]
    },
    "attr:TabBar.breadth":{
        ref:"attr:TabBar.breadth",
        flags:"IRW",
        description:"Breadth of the tabBar (including baseline breadth)",
        name:"breadth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"21",
        type:"attr",
        definingClass:"class:TabBar"
    },
    "method:ColumnTree.getColumn":{
        ref:"method:ColumnTree.getColumn",
        flags:"A",
        description:" Advanced API - get the ListGrid representing the indicated column.\n",
        name:"getColumn",
        seeAlso:[],
        params:[
            {description:"column number, or parent node of the nodes shown in the column",
             optional:false, name:"column", defaultValue:null, type:"int or TreeNode"}
        ],
        returns:{description:"ListGrid that renders the indicated column, or null if column is not shown",
         type:"ListGrid"},
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:TileGrid.tile":{
        ref:"attr:TileGrid.tile",
        flags:"IR",
        getter:["getTile"],
        description:"A TileGrid automatically creates one tile per record in the dataset, via the\n ${isc.DocUtils.linkForRef('type:AutoChild')} pattern.\n <P>\n By default, the ${isc.DocUtils.linkForRef('class:SimpleTile')} class will be used, and will contain content as rendered\n by a ${isc.DocUtils.linkForRef('class:DetailViewer')}, based on the provided ${isc.DocUtils.linkForRef('attr:TileGrid.fields')} (or on the default\n set of fields).\n <P>\n To create a completely different appearance, override ${isc.DocUtils.linkForRef('attr:TileGrid.tileConstructor')} with the name\n of the custom SmartClient class to use for each tile.  For example, subclass\n ${isc.DocUtils.linkForRef('class:SimpleTile')} and override ${isc.DocUtils.linkForRef('method:Canvas.getInnerHTML','getInnerHTML()')}, returning custom\n HTML for each tile.\n <pre>\n     isc.defineClass(\"MyCustomTile\", \"SimpleTile\").addProperties({\n        getInnerHTML : function () {\n           return this.Super(\"getInnerHTML\", arguments) +\n                this.getRecord().width + \" x \" + this.getRecord().height;\n        }\n     });\n\n     isc.TileGrid.create({\n        tileConstructor:\"MyCustomTile\"\n     });\n </pre>\n <P>\n Note that you can also override tile behaviors on a per-record basis, via\n ${isc.DocUtils.linkForRef('attr:TileRecord.tileConstructor')} and ${isc.DocUtils.linkForRef('attr:TileRecord.tileProperties')}.",
        name:"tile",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TileGrid"
    },
    "attr:Label.contents":{
        ref:"attr:Label.contents",
        flags:"IRW",
        description:"The contents of a canvas or label widget. Any HTML string is acceptable.",
        name:"contents",
        setter:["setContents"],
        seeAlso:[
            {ref:"attr:Label.dynamicContents", description:null}
        ],
        valueType:"string",
        defaultValue:"\"&nbsp;\"",
        type:"attr",
        definingClass:"class:Label",
        groups:["contents"]
    },
    "method:Canvas.setShowResizeBar":{
        ref:"method:Canvas.setShowResizeBar",
        flags:"",
        description:" When this Canvas is included as a member in a Layout, dynamically updates whether a \n resizeBar should be shown after this member in the layout, to allow it to be resized.\n",
        name:"setShowResizeBar",
        seeAlso:[],
        params:[
            {description:"setting for this.showResizeBar", optional:false, name:"show",
             defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["layoutMember"]
    },
    "method:CubeGrid.selectAllFacetValues":{
        ref:"method:CubeGrid.selectAllFacetValues",
        flags:"",
        description:"\n select/deselect all headers in a headerBar (specified by facetId) or\n all headerBars (if no facetId)\n\n  <br><i>methodType</i> action\n",
        name:"selectAllFacetValues",
        seeAlso:[],
        params:[
            {description:"ID of facet - if null, selects all headerbars' headers", optional:true,
             name:"facetId", defaultValue:null, type:"string"},
            {description:"new selection state - if null defaults to true", optional:true,
             name:"newState", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "attr:ListGridField.valueIconSize":{
        ref:"attr:ListGridField.valueIconSize",
        flags:"IRW",
        description:"Default width and height of value icons in this field.\n Takes precidence over valueIconWidth, valueIconHeight and valueIconSize specified at\n the ListGrid level.\n Can be overridden via ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')} and {ListGridField.valueIconHeight}",
        name:"valueIconSize",
        seeAlso:[
            {ref:"attr:ListGrid.valueIconSize", description:null},
            {ref:"attr:ListGridField.valueIconWidth", description:null},
            {ref:"attr:ListGridField.valueIconHeight", description:null}
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "attr:CalendarEvent.startDate":{
        ref:"attr:CalendarEvent.startDate",
        flags:"IRW",
        description:"Date object which represents the start date of a ${isc.DocUtils.linkForRef('object:CalendarEvent')}\n The name of this field within the CalendarEvent can be changed via \n ${isc.DocUtils.linkForRef('attr:Calendar.startDateField')}",
        name:"startDate",
        seeAlso:[],
        valueType:"Date",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:CalendarEvent"
    },
    "method:TreeGrid.recordDoubleClick":{
        ref:"method:TreeGrid.recordDoubleClick",
        flags:"",
        description:"\n Handle a doubleClick on a tree node - override of ListGrid stringMethod of same name.  If\n the node is a folder, this implementation calls ${isc.DocUtils.linkForRef('method:TreeGrid.toggleFolder')} on it.  If\n the node is a leaf, calls ${isc.DocUtils.linkForRef('method:TreeGrid.openLeaf')} on it.\n \n",
        name:"recordDoubleClick",
        seeAlso:[
            {ref:"method:ListGrid.recordDoubleClick", description:null}
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:TreeGrid.folderDrop":{
        ref:"method:TreeGrid.folderDrop",
        flags:"A",
        description:"\n This method processes the drop on a folder in the TreeGrid.  The default implementation\n works as follows:\n <P>\n If the nodes originate in this tree and the ${isc.DocUtils.linkForRef('attr:TreeGrid.dragDataAction')} is \"none\" or\n \"move\", then the nodes are simply reordered in this TreeGrid.  Otherwise (if\n ${isc.DocUtils.linkForRef('attr:TreeGrid.dragDataAction')} is \"copy\" or \"none\"), this method calls\n ${isc.DocUtils.linkForRef('method:ListGrid.transferDragData')} on the <code>sourceWidget</code> and adds the returned\n rows to this TreeGrid.\n <P>\n In either case, the new row(s) appear in the <code>folder</code> at the <code>index</code>\n specified by the arguments of the same name.\n <P>\n For dataBound treeGrids, folderDrop() will initiate ${isc.DocUtils.linkForRef('class:DSRequest','DataSource requests')}\n to update remote datasets.  For nodes moved within the tree, an \"update\" operation will\n be submitted to update the ${isc.DocUtils.linkForRef('attr:Tree.parentIdField','parentId')} field of the moved node(s). \n For nodes added to a tree, \"add\" DataSource requests will be submitted with the dropped\n node(s) as dsRequest.data.  For all drops onto databound treeGrids from other databound \n components, if ${isc.DocUtils.linkForRef('attr:DataBoundComponent.addDropValues','addDropValues')} is true, \n ${isc.DocUtils.linkForRef('method:DataBoundComponent.getDropValues','getDropValues')} will be called for every item \n being dropped.\n <P>\n As a special case, if the <code>sourceWidget</code> is also databound, and a \n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} relationship is declared from the\n <code>sourceWidget</code>'s DataSource to this TreeGrid's DataSource, the interaction will\n be treated as a \"drag recategorization\" use case such as files being placed in folders,\n employees being assigned to teams, etc.  \"update\" DSRequests will be submitted that\n change the foreignKey field in the dropped records to point to the tree folder that was the\n target of the drop.  In this case no change will be made to the Tree data as such, only to\n the dropped records. \n\n",
        name:"folderDrop",
        seeAlso:[],
        params:[
            {description:"List of nodes being dropped", optional:false, name:"nodes", defaultValue:null,
             type:"List of TreeNode"},
            {description:"The folder being dropped on", optional:false, name:"folder",
             defaultValue:null, type:"TreeNode"},
            {description:"Within the folder being dropped on, the index at which the drop is                        occurring.  Only passed if ${isc.DocUtils.linkForRef('attr:TreeGrid.canReorderRecords')} is true.",
             optional:false, name:"index", defaultValue:null, type:"integer"},
            {description:"The component that is the source of the nodes (where the nodes                              were dragged from).",
             optional:false, name:"sourceWidget", defaultValue:null, type:"Canvas"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('treeDropEvents')}"],
        definingClass:"class:TreeGrid"
    },
    "method:ListGrid.getSelection":{
        ref:"method:ListGrid.getSelection",
        flags:"",
        description:" Returns all selected records, as an Array.\n\n",
        name:"getSelection",
        seeAlso:[],
        returns:{description:"list of records, empty list if nothing selected",
         type:"Array of ListGridRecord"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('databoundRemove')}"],
        definingClass:"class:ListGrid",
        groups:["selection"]
    },
    "method:DateChooser.getData":{
        ref:"method:DateChooser.getData",
        flags:"",
        description:" Get the current value of the picker.\n <P>\n See ${isc.DocUtils.linkForRef('method:DateChooser.dataChanged')} for how to respond to the user picking a date.\n\n",
        name:"getData",
        seeAlso:[],
        returns:{description:"current date", type:"Date"},
        type:"method",
        definingClass:"class:DateChooser"
    },
    "attr:CubeGrid.alternateRecordStyles":{
        ref:"attr:CubeGrid.alternateRecordStyles",
        flags:"IRW",
        description:"Whether alternating rows should be drawn in alternating styles, in order to create a \"ledger\"\n effect for easier reading.  If enabled, the cell style for alternate rows will have \"Dark\"\n appended to it.",
        name:"alternateRecordStyles",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["appearance"]
    },
    "attr:OperationBinding.lineBreakStyle":{
        ref:"attr:OperationBinding.lineBreakStyle",
        flags:"IR",
        description:"The style of line-breaks to use in the exported output.  See ${isc.DocUtils.linkForRef('type:LineBreakStyle')} for\n more information.",
        name:"lineBreakStyle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding"
    },
    "group:iscServer":{
        ref:"group:iscServer",
        title:"SmartClient Server Summary",
        treeLocation:["Java Server Reference"],
        refs:[],
        description:"The SmartClient Server is a set of Java libraries, servlets and tools that provide the key\n server-side components needed to build a complete application in the modern web\n architecture.\n <P>\n The SmartClient Server can be ${isc.DocUtils.linkForRef('group:iscInstall','integrated')} into any pre-existing Java\n application, and is designed to rapidly connect SmartClient visual components to\n pre-existing Java business logic or persistence engines.  SmartClient's Ajax request\n processing facilities can be easily integrated into Struts Actions,\n ${isc.DocUtils.linkForRef('group:springIntegration','Spring controllers')}, or custom servlets and JSPs.\n <P>\n Alternatively, the SmartClient Server provides a complete SQL and Hibernate-based\n persistence engine for new applications, with out-of-the-box servlets for processing Ajax\n data requests.\n <P>\n The SmartClient Server is optional, and SmartClient's client-side Ajax engine can be\n integrated with any server that provides HTTP access, using XML, JSON, SOAP or proprietary\n data protocols.  However any server in a modern web application will be required to provide\n most or all of the features of the SmartClient Server (described below), and the SmartClient\n Server represents a best-of-breed implementation of these facilities with a long history of\n high-volume production deployments.\n <P>\n <h4>Server enforcement of ${isc.DocUtils.linkForRef('class:Validator','Validators')}</h4>\n <P>\n Data passed from the browser can be automatically validated by the SmartClient Server.\n In contrast, when using ${isc.DocUtils.linkForRef('group:clientDataIntegration','client-side integration')},\n data arrives as HTTP params or XML messages, and you must parse values into the correct\n types (eg java.util.Date) and validate them, or use a server framework that does so.\n <P>\n <h4>High Speed Data Delivery / Data Compression</h4>\n <P>\n The SmartClient Server delivers data to and from the browser using a proprietary, maximally\n efficient protocol, providing simple Java APIs for sending and receiving data.\n <P>\n SmartClient's data protocol is:\n <ul>\n <li> automatically compressed: provides 6-8x improvement in bandwidth utilization\n <li> efficient on the server: high speed data serialization for any Java Object\n <li> efficient in the browser: faster than ordinary XML or JSON data delivery\n <li> minimal: facilities for ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields','trimming')} and\n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','extracting')} only the data you want the browser to see\n </ul>\n <P>\n <h4>Transparent upload support</h4>\n <P>\n SmartClient provides special client and server-side support for ${isc.DocUtils.linkForRef('group:upload','file\n upload')}, which allows single and multiple-file HTTP uploads to be performed as a background\n Ajax request without reloading the page or launching sub-windows.\n <P>\n Uploaded files arrive at the SmartClient server as Java InputStreams accessible from the\n DSRequest object, and can optionally be automatically stored via SmartClient's SQL\n subsystem.\n <P>\n <h4>Transparent Queuing / \"Batch\" Operations</h4>\n <P>\n Any request transmitted to the SmartClient Server can be combined into a \"queue\" transmitted\n as a single HTTP request, with in-order execution for all queued operations. \n ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','startQueue()')} starts a queue and\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendQueue','sendQueue()')} transmits it; queueing is transparent to the code\n that initiates the individual requests.  This enables:\n <ul>\n <li> re-use of data access operations across different screens\n <li> easy implementation of transaction boundaries\n <li> simplified saving and loading of screens with complex, master-detail views\n <li> guaranteed in-order processing of operations\n <li> more efficient network usage\n </ul>\n <P>\n <h4>Visual Builder</h4>\n <P>\n ${isc.DocUtils.linkForRef('group:visualBuilder','Visual Builder')} is included with the SmartClient Server, and uses\n server features such as automatic SQL binding to provide a rapid prototyping environment.\n <P>\n <h4>Automatic Bi-directional Java &lt; - &gt; JavaScript serialization and translation</h4>\n <P>\n Provides a powerful, type-safe ${isc.DocUtils.linkForRef('attr:RPCRequest.data','data transmission mechanism')} for moving\n data between a Java server and the browser. \n <P>\n Any Java objects, including Java Beans, POJOs, Java Collections, XML DOMs and all Java\n primitives, with any level of nesting, can be automatically serialized and delivered as\n JavaScript Objects to the SmartClient client-side components.\n <P>\n JavaScript Objects existing in the browser can likewise be automatically transmitted to a\n Java Server and translated to Java Objects, with any level of nesting and automatic\n preservation of primitive types.\n <P>\n <h4>SQL and Hibernate connectors</h4>\n <P>\n DataSource of serverType:\"sql\" or serverType:\"hibernate\" can generate and execute queries\n against popular SQL engines or against the Hibernate ORM system, providing SmartClient's\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}s with the four standard CRUD operations (create, retrieve, update,\n delete) without writing any server-side code.  For rapid prototyping, these DataSources can\n even generate SQL tables based on the DataSource declaration, using the\n ${isc.DocUtils.linkForRef('group:adminConsole')} visual tool.\n <P>\n Server-side APIs allow server-side modification of the request before it is executed (for\n example, to enforce security) and post-processing of the request after execution (for\n example, to provide calculated values).\n <P>\n Both serverType:\"sql\" and serverType:\"hibernate\" support the field-operator-value queries\n that can be generated by using the ${isc.DocUtils.linkForRef('class:FilterBuilder')} component (see\n ${isc.DocUtils.linkForExampleId('filterBuilderBracket', 'example')}).\n <P>\n <h4>Rich, Standardized Request / Response protocol</h4>\n <P>\n The SmartClient Server provides a standardized request and response protocol designed for\n data-oriented \"CRUD\" operations (create, retrieve, update, delete).\n <P>\n This standardized protocol automatically handles ${isc.DocUtils.linkForRef('class:DSRequest','request metadata')} (paging\n parameters, requested sort order, original values of data being modified) and\n ${isc.DocUtils.linkForRef('class:DSResponse','response metadata')} (error handling, cache management, session expiration etc).\n <P>\n Similar to the impact of Struts on early web applications, this standardized protocol avoids\n developers in different groups inventing their own incompatible and redundant\n request/response protocols, and allows developers to more easily learn code they didn't\n author.\n <P>\n <h4>Bi-directional XPath binding to Java Objects</h4>\n <P>\n Most UI designs do not directly reflect the underlying Object model and so some degree of\n translation is necessary in order to populate UI components with data and apply user changes\n to the Java Object model.  This is often accomplished with brittle, difficult to understand\n data translation code sprinkled throughout the system, done in a different way for every\n screen or component.\n <P>\n SmartClient provides a standard, ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','XPath-based approach')} to\n adapting any Java-based Object model to the requirements of the UI design.  Data relevant to\n the application UI is centrally extracted in the server-side ${isc.DocUtils.linkForRef('class:DataSource')} layer, so\n that all UI components have a consistent, unified view of the data model for both loading\n <b>and</b> saving data.\n <P>\n <h4>Broadest possible browser support</h4>\n <P>\n The SmartClient Server can compensate for facilities \n ${isc.DocUtils.linkForRef('group:platformDependencies','missing or disabled in certain browsers')},\n including ActiveX being disabled in IE6 and missing XML support in some versions\n of Apple's Safari browser.\n <P>\n <h4>Transparent Proxying</h4>\n <P>\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendProxied','Proxying')} allows SmartClient applications to access web\n services, RSS feeds, HTML content and other data services in a secure manner regardless of\n where they are located: across the enterprise or publicly available.\n <P>\n <h4>Optional ${isc.DocUtils.linkForRef('group:networkPerformance','Network Performance')} Module</h4>\n <P>\n Provides:\n <ul>\n <li> compressed delivery of SmartClient runtime, application logic and other assets such as CSS\n <li> ${isc.DocUtils.linkForRef('class:FileLoader','background download')} of SmartClient and other assets for zero\n user-perceived load time\n <li> on-the-fly stripping, combining and obfuscation of JavaScript (application code and data)\n <li> browser cache control\n </ul>\n <P>\n <h4>Optional Messaging Module (aka server push)</h4>\n <P>\n The ${isc.DocUtils.linkForDocNode('messaging', 'Messaging')} module allows the server to \"push\" messages to the client, without\n client polling, for real-time monitoring/dashboarding applications.",
        name:"iscServer",
        seeAlso:[],
        type:"group"
    },
    "method:Class.map":{
        ref:"method:Class.map",
        flags:"",
        description:"\n Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.\n\n",
        name:"map",
        seeAlso:[],
        params:[
            {description:"Name of the method on this instance which should be called on each element of the Array",
             optional:false, name:"methodName", defaultValue:null, type:"string"},
            {description:"Array of items to call the method on", optional:false, name:"items",
             defaultValue:null, type:"Array"}
        ],
        returns:{description:"Array of results, one per element in the passed \"items\" Array", type:"Array"},
        type:"method",
        definingClass:"class:Class"
    },
    "method:TileLayout.setTileMargin":{
        ref:"method:TileLayout.setTileMargin",
        flags:"",
        description:" sets the width of tiles\n",
        name:"setTileMargin",
        seeAlso:[],
        params:[
            {description:"margin", optional:false, name:"", defaultValue:null, type:"Integer"}
        ],
        type:"method",
        definingClass:"class:TileLayout",
        groups:["tileLayout"]
    },
    "type:ListGridFieldType":{
        ref:"type:ListGridFieldType",
        values:[
            {description:"Simple text rendering for view.  For editing a text entry field is shown. If the length of the field (as specified by the ${isc.DocUtils.linkForRef('attr:DataSourceField.length')}\n attribute) is larger than the value specified by ${isc.DocUtils.linkForRef('attr:ListGrid.longTextEditorThreshold')}, a\n text input icon is shown that, when clicked on (or field is focused in) opens a larger\n editor that expands outside the boundaries of the cell (textarea by default, but\n overrideable via ${isc.DocUtils.linkForRef('attr:ListGrid.longTextEditorType')}).",
             value:"\"text\""},
            {description:"For viewing and editing a checkbox is shown with a check mark for the <code>true</code> value and no check mark for the <code>false</code> value.  See\n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} for customization.",
             value:"\"boolean\""},
            {description:"Same as <code>text</code>.  Consider setting ${isc.DocUtils.linkForRef('attr:ListGridField.editorType','editorType')} to use a ${isc.DocUtils.linkForRef('class:SpinnerItem')}.",
             value:"\"integer\""},
            {description:"Same as <code>text</code>.  Consider setting ${isc.DocUtils.linkForRef('attr:ListGridField.editorType','editorType')} to use a ${isc.DocUtils.linkForRef('class:SpinnerItem')}.",
             value:"\"float\""},
            {description:"Expected to contain <code>Date</code> type data. Dates will be formatted using\n ${isc.DocUtils.linkForRef('attr:ListGridField.displayFormat')} if specified, otherwise ${isc.DocUtils.linkForRef('attr:ListGrid.dateFormatter')}.\n If both these attributes are unset, dates are formatted using the standard \n ${isc.DocUtils.linkForRef('classMethod:Date.setShortDisplayFormat','short display format')} for dates.\n <P>\n For editing, by default a ${isc.DocUtils.linkForRef('class:DateItem')} is used with ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} set\n to true, providing textual date entry plus a pop-up date picker. The\n ${isc.DocUtils.linkForRef('attr:DateItem.displayFormat','displayFormat')} and ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')}\n for the editor will be picked up from the ListGridField, if specified.",
             value:"\"date\""},
            {description:"Expected to contain Time data encoded in javascript <code>Date</code> objects.\n Times will be formatted using ${isc.DocUtils.linkForRef('attr:ListGridField.displayFormat')} if specified, \n otherwise ${isc.DocUtils.linkForRef('attr:ListGrid.timeFormatter')}.\n <P>\n If both these attributes are unset, times are formatted using the standard \n ${isc.DocUtils.linkForRef('classAttr:Time.shortDisplayFormat','short display format')} for times.\n <P>\n For editing, by default a ${isc.DocUtils.linkForRef('class:TimeItem')} is used. The\n ${isc.DocUtils.linkForRef('attr:TimeItem.displayFormat','displayFormat')} for the editor will be picked up from \n the ListGridField, if specified.",
             value:"\"time\""},
            {description:"Same as <code>text</code>", value:"\"sequence\""},
            {description:"Renders a clickable html link (using an HTML anchor tag: &lt;A&gt;). The target URL is the value of the field, which is also the default display value.  You\n can override the display value by setting ${isc.DocUtils.linkForRef('attr:ListGridRecord.linkText')} or\n ${isc.DocUtils.linkForRef('attr:ListGridField.linkText')}.\n <P>\n Clicking the link opens the URL in a new window by default.  To change this behavior,\n you can set <code>field.target</code>, which works indentically to the \"target\"\n attribute on an HTML anchor (&lt;A&gt;) tag.  See ${isc.DocUtils.linkForRef('attr:ListGridField.target')} for more\n information.\n <P>\n In inline edit mode, this type works like a text field.\n <P>\n To create a link not covered by this feature, consider using\n ${isc.DocUtils.linkForRef('method:ListGridField.formatCellValue')} along with ${isc.DocUtils.linkForRef('method:Canvas.linkHTML')}, or simply\n ${isc.DocUtils.linkForRef('method:ListGrid.getCellStyle','styling the field')} to look like a link, and providing\n interactivity via ${isc.DocUtils.linkForRef('method:ListGridField.recordClick','field.recordClick()')}.",
             value:"\"link\""},
            {description:"Renders a different image in each row based on the value of the field.  If this URL is not absolute, it is assumed to be relative to\n ${isc.DocUtils.linkForRef('attr:ListGridField.imageURLPrefix')} if specified. The size of the image is controlled by\n ${isc.DocUtils.linkForRef('attr:ListGridField.imageSize')}, ${isc.DocUtils.linkForRef('attr:ListGridField.imageWidth')},\n ${isc.DocUtils.linkForRef('attr:ListGridField.imageHeight')} (and by the similarly-named global default\n attributes on the ListGrid itself).\n <P>\n You can also specify the following attributes on the field: <code>activeAreaHTML</code>, and\n <code>extraStuff</code> - these are passed to ${isc.DocUtils.linkForRef('method:Canvas.imgHTML')} to generate the\n final URL.\n <P>\n Note if you want to display icons <b>in addition to</b> the normal cell value, you\n can use ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons','valueIcons')} instead.",
             value:"\"image\""},
            {description:"Shows ${isc.DocUtils.linkForRef('attr:ListGridField.icon','field.icon')} in every cell, and also in the header.  Useful for a field that is used as a button, for example, launches a detail\n window or removes a row.  Implement a ${isc.DocUtils.linkForRef('method:ListGridField.recordClick','field.recordClick')}\n to define a behavior for the button.\n <P>\n NOTE: for a field that shows different icons depending on the field value, see\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')}.\n <P>\n <code>type:\"icon\"</code> also defaults to a small field width, accomodating just the icon\n with padding, and to a blank header title, so that the header shows the icon only.  \n <P>\n ${isc.DocUtils.linkForRef('attr:ListGridField.iconWidth','field.iconWidth')} and related properties configure\n the size of the icon both in the header and in body cells.\n <P> \n If you want the icon to appear only in body cells and not in the header, set\n ${isc.DocUtils.linkForRef('attr:ListGridField.cellIcon','field.cellIcon')} instead, leaving field.icon null.",
             value:"\"icon\""},
            {description:"For viewing, the grid renders a 'view' icon (looking glass) followed by a 'download' icon and then the name of the file is displayed in text.  If the user clicks the\n 'view' icon, a new browser window is opened and the file is streamed to that browser\n instance, using ${isc.DocUtils.linkForRef('method:DataSource.viewFile')}.  For images and other file types with\n known handlers, the content is typically displayed inline - otherwise the browser will\n ask the user how to handle the content.  If the download icon is clicked,\n ${isc.DocUtils.linkForRef('method:DataSource.downloadFile')} is used to cause the browser to show a \"save\" dialog.\n There is no inline editing mode for this field type.",
             value:"\"binary\""},
            {description:"Same as <code>binary</code>", value:"\"imageFile\""}
        ],
        description:"ListGrids format data for viewing and editing based on the <i>type</i> attribute of the\n field.  This table describes how the ListGrid deals with the various built-in types.",
        name:"ListGridFieldType",
        seeAlso:[
            {ref:"attr:ListGridField.type", description:null},
            {ref:"type:FieldType", description:null}
        ],
        type:"type",
        examples:["${isc.DocUtils.linkForExampleId('gridsDataTypes')}"]
    },
    "attr:SimpleType.name":{
        ref:"attr:SimpleType.name",
        flags:"IR",
        description:"Name of the type, used to refer to the type from ${isc.DocUtils.linkForRef('attr:DataSourceField.name','field.name')}.",
        name:"name",
        seeAlso:[],
        valueType:"identifier",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SimpleType"
    },
    "attr:ImgSplitbar.canDrag":{
        ref:"attr:ImgSplitbar.canDrag",
        flags:"IRW",
        description:"<code>canDrag</code> set to true to allow dragging of the split bar. Dragging the\n Splitbar will resize it's ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}",
        name:"canDrag",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ImgSplitbar"
    },
    "attr:ImgTab.align":{
        ref:"attr:ImgTab.align",
        flags:"IRW",
        description:"Alignment of title text",
        name:"align",
        seeAlso:[],
        valueType:"Alignment",
        defaultValue:"Canvas.CENTER",
        type:"attr",
        definingClass:"class:ImgTab",
        groups:["positioning"]
    },
    "method:SectionItem.collapseSection":{
        ref:"method:SectionItem.collapseSection",
        flags:"",
        description:" Collapse a sectionItem, and hide all the items within the section (not including\n the header).\n",
        name:"collapseSection",
        seeAlso:[],
        type:"method",
        definingClass:"class:SectionItem"
    },
    "method:GridRenderer.getCellStyle":{
        ref:"method:GridRenderer.getCellStyle",
        flags:"",
        description:" Return the CSS class for a cell. By default this method has the following implementation:<br>\n - return any custom style for the record (see ${isc.DocUtils.linkForRef('attr:GridRenderer.recordCustomStyleProperty')}) \n   if defined.<br>\n - create a style name based on the result of ${isc.DocUtils.linkForRef('method:GridRenderer.getBaseStyle')} and the \n   state of the record.<br>\n The state of the record is indicated by adding a suffix to the base style.\n There are four independant boolean states, which are combined in the order given:\n <ol>\n <li>\"Disabled\" : whether the cell is disabled; enable by setting the \"enabled\" flag on record\n     returned by getCellRecord\n <li>\"Selected\" : whether cell is selected; enable by passing a Selection object as \"selection\"\n <li>\"Over\" : mouse is over this cell; enable with showRollovers\n <li>\"Dark\" : alternating color bands; enable with alternateRowStyles\n </ol>\n For example, with a baseStyle of \"myCell\", a cell which is selected, which the mouse is over,\n and which is in a dark-colored band will get a styleName of myCellSelectedOverDark.\n <p>\n Cell Styles customizable by:\n <ul>\n <li>attaching a custom style to a record by setting \n    <code>record[this.recordCustomStyleProperty]</code> to some valid CSS style name.  \n <li>modifying the base style returned by getBaseStyle() [see that method for further \n     documentation on this]\n <li>overriding this function\n </ul>\n\n",
        name:"getCellStyle",
        seeAlso:[],
        params:[
            {description:"record object for this row and column", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"number of the row", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"number of the column", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"CSS style for this cell", type:"CSSStyleName"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["appearance"]
    },
    "group:menuKeys":{
        ref:"group:menuKeys",
        refs:["attr:MenuItem.keys", "attr:MenuItem.keyTitle"],
        name:"menuKeys",
        seeAlso:[],
        type:"group"
    },
    "method:Canvas.setDragTracker":{
        ref:"method:Canvas.setDragTracker",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:Canvas.dragAppearance')} is set to <code>\"tracker\"</code>, this method will be called\n (if defined), when the user starts to drag this widget. It is an opportunity to update the\n drag tracker to display something relative to this canvas.  Typical implementation will\n be to call ${isc.DocUtils.linkForRef('classMethod:EventHandler.setDragTracker')}, passing in the desired custom tracker HTML \n as a string\n",
        name:"setDragTracker",
        seeAlso:[],
        returns:{description:"Return false to suppress bubbling, and prevent <code>setDragTracker()</code>                      from being called on this widget's ancestors.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('dragTracker')}"],
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "classMethod:Date.create":{
        ref:"classMethod:Date.create",
        flags:"",
        description:"  Create a new <code>Date</code> object - synonym for <code>new Date(arguments)</code>\n",
        name:"create",
        seeAlso:[],
        returns:{description:"Date object", type:"Date"},
        type:"classMethod",
        definingClass:"class:Date"
    },
    "classMethod:RPCManager.startQueue":{
        ref:"classMethod:RPCManager.startQueue",
        flags:"",
        description:"\n Start queuing requests.  When queuing requests, an HTTP request will not be sent to\n the server until RPCManager.sendQueue() is called.\n <p>\n All requests in a given queue must go to the same actionURL and use the same transport\n (XMLHttp or frames).  If a request specifies a different actionURL or transport than\n that of the requests currently on the queue, it will be sent to the server separately,\n ahead of the queue, and a warning will be logged to the Developer Console.\n <p>\n Note that the server must process all requests sent as part of the queue before any\n response is sent to the client.  You should avoid batching a request that will take a\n long time to process on the server with any other requests because it will delay the\n response of all requests in the queue.\n\n",
        name:"startQueue",
        seeAlso:[
            {ref:"classMethod:RPCManager.sendQueue", description:null}
        ],
        params:[
            {description:"whether queuing should be enabled, default true.  Passing false                      will disable queuing but not send the queue yet, so that any\n                      queued requests will be sent along with the next\n                      send()/sendRequest()",
             optional:true, name:"shouldQueue", defaultValue:null, type:null}
        ],
        returns:{description:"whether queuing was already enabled before we called", type:"boolean"},
        type:"classMethod",
        definingClass:"class:RPCManager",
        requiresModules:["SCServer"]
    },
    "attr:Canvas.snapResizeToGrid":{
        ref:"attr:Canvas.snapResizeToGrid",
        flags:"IRW",
        description:"Causes this canvas to snap to its parent's grid when resizing.\n Note that this value defaults to the Canvas's \n ${isc.DocUtils.linkForRef('attr:Canvas.snapToGrid','snapToGrid')} value if undefined.",
        name:"snapResizeToGrid",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "method:JSONEncoder.encodeDate":{
        ref:"method:JSONEncoder.encodeDate",
        flags:"",
        description:" Encode a JavaScript Date value.\n <P>\n By default, follows the ${isc.DocUtils.linkForRef('attr:JSONEncoder.dateFormat')} setting.  Override to do custom\n encoding.\n \n",
        name:"encodeDate",
        seeAlso:[],
        params:[
            {description:"JavaScript date object to be serialized", optional:false, name:"theDate",
             defaultValue:null, type:"Date"}
        ],
        returns:{description:"value to be included in result.  <b>If this value is intended to appear                  as a String it should include quotes (\")</b>",
         type:"String"},
        type:"method",
        definingClass:"class:JSONEncoder"
    },
    "attr:FormItem.showIcons":{
        ref:"attr:FormItem.showIcons",
        flags:"IRWA",
        description:"Set to false to suppress writing out any ${isc.DocUtils.linkForRef('attr:FormItem.icons')} for this item.",
        name:"showIcons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["formIcons"]
    },
    "attr:ServerObject.ID":{
        ref:"attr:ServerObject.ID",
        flags:"IR",
        description:"You can optionally specify an ID on the ServerObject config block - in which case you can\n use that value as the \"className\" argument when calling ${isc.DocUtils.linkForRef('classMethod:DMI.call')}.  This allows you to\n hide the name of the server-side class used as the factory or implementer of the DMI from\n the browser as a security precaution.",
        name:"ID",
        seeAlso:[
            {ref:"attr:ServerObject.className", description:null},
            {ref:"classMethod:DMI.call", description:null}
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ServerObject"
    },
    "attr:DataSource.enumTranslateStrategy":{
        ref:"attr:DataSource.enumTranslateStrategy",
        flags:"IA",
        description:"Sets the strategy this DataSource uses to translate Java enumerated types (objects of type\n enum) to and from Javascript.\n \n This property is only applicable if you are using the SmartClient server",
        name:"enumTranslateStrategy",
        seeAlso:[],
        valueType:"EnumTranslateStrategy",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSource"
    },
    "attr:StretchImgButton.iconSize":{
        ref:"attr:StretchImgButton.iconSize",
        flags:"IR",
        description:"Size in pixels of the icon image.\n <P>\n The <code>iconWidth</code> and <code>iconHeight</code> properties can be used to\n configure width and height separately.",
        name:"iconSize",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["buttonIcon"]
    },
    "attr:ColorPicker.modeToggleButtonConstructor":{
        ref:"attr:ColorPicker.modeToggleButtonConstructor",
        flags:"IRWA",
        description:"The class of the mode toggle button. It is intended that you use either IButton or \n      Button - other classes are unlikely to work correctly.",
        name:"modeToggleButtonConstructor",
        seeAlso:[],
        valueType:"Class",
        defaultValue:"IButton",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "group:toolbar":{
        ref:"group:toolbar",
        refs:["attr:Dialog.showToolbar"],
        name:"toolbar",
        seeAlso:[],
        type:"group"
    },
    "method:TreeGrid.getNodeTitle":{
        ref:"method:TreeGrid.getNodeTitle",
        flags:"",
        description:"\n Returns the title to show for a node in the tree column.  If the field specifies the\n <code>name</code> attribute, then the current <code>node[field.name]</code> is returned.\n Otherwise, the result of calling ${isc.DocUtils.linkForRef('method:Tree.getTitle')} on the node is called.\n <br><br>\n You can override this method to return a custom title for node titles in the tree column.\n\n",
        name:"getNodeTitle",
        seeAlso:[
            {ref:"method:Tree.getTitle", description:null}
        ],
        params:[
            {description:"The node for which the title is being requested.", optional:false,
             name:"node", defaultValue:null, type:"TreeNode"},
            {description:"The index of the node.", optional:false, name:"recordNum", defaultValue:null,
             type:"Number"},
            {description:"The field for which the title is being requested.", optional:false,
             name:"field", defaultValue:null, type:"DSField"}
        ],
        returns:{description:"the title to display.", type:"HTML"},
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "classMethod:Validator.addValidators":{
        ref:"classMethod:Validator.addValidators",
        flags:"A",
        description:"  Add several new validator types at once, as though ${isc.DocUtils.linkForRef('classMethod:Validator.addValidator')} were called\n  several times.\n \n",
        name:"addValidators",
        seeAlso:[
            {ref:"classMethod:Validator.addValidator", description:null}
        ],
        params:[
            {description:"Set of validators to add.  This parameter should      be a JavaScript object where the property names are validator type names, and the\n      property values are condition functions or expressions, for example:<br>\n      &nbsp;&nbsp;&nbsp;<code>{type1:condition1, type2:condition2}</code><br>.",
             optional:false, name:"newValidators", defaultValue:null, type:"object"}
        ],
        type:"classMethod",
        definingClass:"class:Validator",
        groups:["validation"]
    },
    "method:TreeGrid.getExtraIcon":{
        ref:"method:TreeGrid.getExtraIcon",
        flags:"A",
        description:" Get an additional icon to show between the open icon and folder/node icon for a particular \n node.\n\n",
        name:"getExtraIcon",
        seeAlso:[],
        params:[
            {description:"tree node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"URL for the extra icon (null if none required)", type:"URL"},
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:Selection.deselectRange":{
        ref:"method:Selection.deselectRange",
        flags:"",
        description:"			Deselect range of records from <code>start</code> to <code>end</code>, non-inclusive\n\n",
        name:"deselectRange",
        seeAlso:[],
        params:[
            {description:"start index to select", optional:false, name:"start", defaultValue:null,
             type:"number"},
            {description:"end index (non-inclusive)", optional:false, name:"end", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:Selection",
        groups:["selection"]
    },
    "attr:ColumnTree.folderIcon":{
        ref:"attr:ColumnTree.folderIcon",
        flags:"IRW",
        description:"The URL of the base icon for all folder nodes in this columnTree. Note that this URL will\n have ${isc.DocUtils.linkForRef('attr:ColumnTree.openIconSuffix')} or ${isc.DocUtils.linkForRef('attr:ColumnTree.closedIconSuffix')} appended to \n indicate state changes if appropriate - see documentation on  ${isc.DocUtils.linkForRef('attr:ColumnTree.showOpenIcons')}",
        name:"folderIcon",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]folder.gif\"",
        type:"attr",
        definingClass:"class:ColumnTree",
        groups:["treeIcons"]
    },
    "attr:ListGrid.fastCellUpdates":{
        ref:"attr:ListGrid.fastCellUpdates",
        flags:"I",
        description:"Whether to speed up dynamic styling at the expense of slightly slower drawing.\n <P>\n <code>fastCellUpdates</code> speeds up the dynamic styling system used by rollovers,\n selections, and custom styling that calls ${isc.DocUtils.linkForRef('method:GridRenderer.refreshCellStyle')}, at\n the cost of slightly slower draw() and redraw() times.",
        name:"fastCellUpdates",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["performance"]
    },
    "classAttr:ValidatorTypes.floatPrecision":{
        ref:"classAttr:ValidatorTypes.floatPrecision",
        flags:"IR",
        description:"Tests whether the value for this field is a floating point number with the \n  appropriate number of decimal places - specified in <code>validator.precision</code>\n  If the value is of higher precision, if <code>validator.roundToPrecision</code> \n  is specified, the value will be rounded to the specified number of decimal places\n  and validation will pass, otherwise validation will fail.",
        name:"floatPrecision",
        seeAlso:[],
        valueType:"validatorDefinition",
        defaultValue:"object",
        type:"classAttr",
        definingClass:"class:ValidatorTypes"
    },
    "attr:ListGrid.fieldVisibilitySubmenuTitle":{
        ref:"attr:ListGrid.fieldVisibilitySubmenuTitle",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields','this.canPickFields')} is true, this\n attribute will be shown as the title for the menu item which contains a submenu with items \n allowing the user to show and hide fields in the grid.",
        name:"fieldVisibilitySubmenuTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Columns\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["i18nMessages"]
    },
    "attr:Window.headerSrc":{
        ref:"attr:Window.headerSrc",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:Window.showHeaderBackground')} is <code>true</code>, this property provides\n the URL of the background image for the header.",
        name:"headerSrc",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]Window/headerGradient.gif\" | null",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "header"]
    },
    "attr:DSRequest.exportFields":{
        ref:"attr:DSRequest.exportFields",
        flags:"IR",
        description:"The list of field-names to export.  If provided, the field-list in the exported output is \n limited and sorted as per the list.\n <P>\n If exportFields is not provided, the exported output includes all visible fields \n from the DataSource (field.hidden=false), sorted in the order they're defined.",
        name:"exportFields",
        seeAlso:[],
        valueType:"Array",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "method:Array.clearProperty":{
        ref:"method:Array.clearProperty",
        flags:"",
        description:" Delete property in each item in this array.\n",
        name:"clearProperty",
        seeAlso:[],
        params:[
            {description:"name of the property to clear", optional:false, name:"property",
             defaultValue:null, type:"string"}
        ],
        returns:{description:"returns true if any of the properties in the array had a value for the     specified property.",
         type:"boolean"},
        type:"method",
        definingClass:"object:Array",
        groups:["iteration"]
    },
    "attr:FacetValue.width":{
        ref:"attr:FacetValue.width",
        flags:"IR",
        description:"Width of the cube grid facet value in pixels",
        name:"width",
        seeAlso:[],
        valueType:"number",
        defaultValue:"facet.width",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "attr:ListGrid.isGrouped":{
        ref:"attr:ListGrid.isGrouped",
        flags:"R",
        description:"True if this listgrid is grouped, false otherwise",
        name:"isGrouped",
        seeAlso:[
            {ref:"method:ListGrid.groupBy", description:null}
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["grouping"]
    },
    "attr:TabSet.tabBarPosition":{
        ref:"attr:TabSet.tabBarPosition",
        flags:"IR",
        description:"Which side of the TabSet the TabBar should appear on.",
        name:"tabBarPosition",
        seeAlso:[],
        valueType:"Side",
        defaultValue:"Canvas.TOP",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('tabsOrientation')}"],
        definingClass:"class:TabSet",
        groups:["tabBar"]
    },
    "attr:ListGrid.leaveScrollbarGap":{
        ref:"attr:ListGrid.leaveScrollbarGap",
        flags:"IRW",
        description:"Whether to leave a gap for the vertical scrollbar, even when it's not present.\n <P>\n Note that if leaveScrollbarGap is false and vertical scrolling is introduced, fields\n will be resized to fit the smaller body area if possible, in order to avoid horizontal\n scrolling also being required.",
        name:"leaveScrollbarGap",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('autofitRows')}"],
        definingClass:"class:ListGrid",
        groups:["appearance"]
    },
    "attr:Tree.pathDelim":{
        ref:"attr:Tree.pathDelim",
        flags:"IRWA",
        description:"Specifies the delimiter between node names.  The pathDelim is used to construct a unique\n path to each node. A path can be obtained for any node by calling\n ${isc.DocUtils.linkForRef('method:Tree.getPath')} and can be used to find any node in the tree by calling\n ${isc.DocUtils.linkForRef('method:Tree.find')}.  Note that you can also hand-construct a path - in other words\n you are not required to call ${isc.DocUtils.linkForRef('method:Tree.getPath')} in order to later use\n ${isc.DocUtils.linkForRef('method:Tree.find')} to retrieve it.\n <br><br>\n The pathDelim can be any character or sequence of characters, but must be a unique string\n with respect to the text that can appear in the ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} that's used\n for naming the nodes.  So for example, if you have the following tree:\n <pre>\n one\n   two\n     three/four\n </pre>\n Then you will be unable to find the <code>three/four</code> node using\n ${isc.DocUtils.linkForRef('method:Tree.find')} if your tree is using the default pathDelim of /.\n In such a case, you can use a different pathDelim for the tree.  For example if you used |\n for the path delim, then you can find the <code>three/four</code> node in the tree above by\n calling <code>tree.find(\"one|two|three/four\")</code>.\n <br><br>\n The pathDelim is used only by ${isc.DocUtils.linkForRef('method:Tree.getPath')} and ${isc.DocUtils.linkForRef('method:Tree.find')} and\n does not affect any aspect of the tree structure or other forms of tree navigation (such as\n via ${isc.DocUtils.linkForRef('method:Tree.getChildren')}).",
        name:"pathDelim",
        seeAlso:[
            {ref:"attr:Tree.nameProperty", description:null},
            {ref:"method:Tree.find", description:null}
        ],
        valueType:"string",
        defaultValue:"\"/\"",
        type:"attr",
        definingClass:"class:Tree"
    },
    "attr:ComboBoxItem.completeOnTab":{
        ref:"attr:ComboBoxItem.completeOnTab",
        flags:"IRW",
        description:"If true, when the pickList is showing, the user can select the current value by hitting\n the <code>Tab</code> key.",
        name:"completeOnTab",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "method:FormItem.blurItem":{
        ref:"method:FormItem.blurItem",
        flags:"",
        description:"			Takes focus from this form item's focusable element.\n",
        name:"blurItem",
        seeAlso:[],
        type:"method",
        definingClass:"class:FormItem",
        groups:["eventHandling", "focus"]
    },
    "attr:TabSet.symmetricEdges":{
        ref:"attr:TabSet.symmetricEdges",
        flags:"IR",
        description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n this property determines whether the same edge media will be used regardless of the tab\n bar position, or whether different media should be used (necessary if the edge appearance is\n not symmetrical on all sides).\n <P>\n If this property is set to false the paneContainer edge image URLs will be prefixed with\n the tabBarPosition of the tabSet - for example <code>\"[SKIN]edge_top_T.gif\"</code> rather\n than just <code>\"[SKIN]edge_T.gif\"</code>.\n <P>\n When <code>symmetricEdges</code> is false, custom edge sizes for the pane container may be\n specified via ${isc.DocUtils.linkForRef('attr:TabSet.topEdgeSizes')} et al, and custom edge offsets via \n ${isc.DocUtils.linkForRef('attr:TabSet.topEdgeOffsets')} et al.",
        name:"symmetricEdges",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "attr:TileLayout.autoWrapLines":{
        ref:"attr:TileLayout.autoWrapLines",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('type:LayoutPolicy')} is \"flow\", should we automatically start a new line when there's\n not enough room to fit the next tile on the same line?\n <P>\n If set to false, a new line will only be started if a tile specifies tile.startLine or\n tile.endLine.",
        name:"autoWrapLines",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:["layoutPolicy"]
    },
    "attr:DataSourceField.multiple":{
        ref:"attr:DataSourceField.multiple",
        flags:"IR",
        description:"Indicates that this field should always be Array-valued.  If the value derived from\n ${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','XML or JSON data')} is singular, it will be wrapped in an Array.\n <P>\n Specifically for XML serialization and deserialization, <code>multiple:true</code> behaves\n similarly to the \n <a href='http://www.google.com/search?hl=en&q=soap+array' onclick=\"window.open('http://www.google.com/search?hl=en&q=soap+array');return false;\">SOAP array idiom</a>, that is,\n there will be a \"wrapper element\" named after the field name, whose contents will be several\n elements of the specified ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field.type')}.  \n <P>\n For example, ${isc.DocUtils.linkForRef('attr:Layout.members')} is declared with <code>type:\"Canvas\",\n multiple:true</code>.  The correct XML format is thus:\n <pre>\n &lt;VLayout&gt;\n     &lt;members&gt;\n         &lt;Canvas ID=\"myCanvas\" ... /&gt;\n         &lt;ListGrid ID=\"myGrid\" .../&gt;\n         &lt;Toolstrip ID=\"myToolStrip\" ... /&gt;\n     &lt;/members&gt;\n &lt;/VLayout&gt;\n </pre>",
        name:"multiple",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["xmlSerialize", "componentSchema"]
    },
    "attr:ListGrid.canDragRecordsOut":{
        ref:"attr:ListGrid.canDragRecordsOut",
        flags:"IRW",
        description:"Indicates whether records can be dragged from this listGrid and dropped elsewhere.",
        name:"canDragRecordsOut",
        seeAlso:[
            {ref:"attr:ListGridRecord.canDrag", description:null},
            {ref:"attr:ListGridRecord.canAcceptDrop", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dragListMove')}"],
        definingClass:"class:ListGrid",
        groups:["dragging"]
    },
    "attr:RichTextEditor.controlGroups":{
        ref:"attr:RichTextEditor.controlGroups",
        flags:"IRA",
        description:"An array of control group names (strings) specifying which groups of controls should \n  be included in the editor toolbar.<br>\n  For each control group name, this[controlGroupName] should be defined as an array of \n  ${isc.DocUtils.linkForRef('type:ControlName')}s, allowing the controlGroup to be customized.",
        name:"controlGroups",
        seeAlso:[],
        valueType:"array",
        defaultValue:"[\"fontControls\", \"formatControls\", \"styleControls\", \"colorControls\"]",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('RichTextEditor')}"],
        definingClass:"class:RichTextEditor"
    },
    "classMethod:Page.unregisterKey":{
        ref:"classMethod:Page.unregisterKey",
        flags:"",
        description:" Clears an action registered to fire on a specific a keyPress event via the ${isc.DocUtils.linkForRef('classMethod:Page.registerKey')}\n method. \n",
        name:"unregisterKey",
        seeAlso:[
            {ref:"classMethod:Page.registerKey", description:null}
        ],
        params:[
            {description:"Name of key to clear registry enties for.", optional:false, name:"actionID",
             defaultValue:null, type:"KeyName"},
            {description:"target specified when the action was registered for the key.",
             optional:true, name:"target", defaultValue:null, type:"object"}
        ],
        type:"classMethod",
        definingClass:"class:Page",
        groups:["KeyRegistry"]
    },
    "attr:ListGrid.recordEnabledProperty":{
        ref:"attr:ListGrid.recordEnabledProperty",
        flags:"IR",
        description:"Property name on a record that will be checked to determine whether a record is enabled.\n <P>\n Setting this property on a record will effect the visual style and interactivity of\n the record.  If set to <code>false</code> the record (row in a ${isc.DocUtils.linkForRef('class:ListGrid')} or\n ${isc.DocUtils.linkForRef('class:TreeGrid')}) will not highlight when the mouse moves over it, nor will it respond to\n mouse clicks.",
        name:"recordEnabledProperty",
        seeAlso:[
            {ref:"attr:ListGridRecord.enabled", description:null}
        ],
        valueType:"string",
        defaultValue:"\"enabled\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('disabledRows')}"],
        definingClass:"class:ListGrid"
    },
    "attr:Window.modalMask":{
        ref:"attr:Window.modalMask",
        flags:"R",
        description:"A ScreenSpan instance used to darken the rest of a page when a modal window is\n active. To use, set ${isc.DocUtils.linkForRef('attr:Window.showModalMask')} to true, add a CSS style \n \"modalMask\" to the active skin (generally with background-color set), \n and adjust ${isc.DocUtils.linkForRef('attr:Window.modalMaskOpacity')}.",
        name:"modalMask",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window",
        groups:["modal", "appearance"]
    },
    "class:ValuesManager":{
        exampleConfig:"ValuesManager.xml",
        methods:["method:ValuesManager.editNewRecord", "method:ValuesManager.editRecord", 
         "method:ValuesManager.setSaveOperationType","method:ValuesManager.isNewRecord", "method:ValuesManager.getSaveOperationType", 
         "method:ValuesManager.editSelectedData","method:ValuesManager.saveData", "method:ValuesManager.submit", 
         "method:ValuesManager.cancel","method:ValuesManager.filterData", "method:ValuesManager.fetchData", 
         "method:ValuesManager.setDataSource","method:ValuesManager.getDataSource", "method:ValuesManager.validate", 
         "method:ValuesManager.getValidatedValues","method:ValuesManager.setErrors", "method:ValuesManager.addFieldErrors", 
         "method:ValuesManager.setFieldErrors","method:ValuesManager.clearErrors", "method:ValuesManager.clearFieldErrors", 
         "method:ValuesManager.getErrors","method:ValuesManager.getFieldErrors", "method:ValuesManager.hasErrors", 
         "method:ValuesManager.hasFieldErrors","method:ValuesManager.showErrors", "method:ValuesManager.showFieldErrors", 
         "method:ValuesManager.getValues","method:ValuesManager.setValues", "method:ValuesManager.clearValues", 
         "method:ValuesManager.getMemberValues","method:ValuesManager.setMemberValues", "method:ValuesManager.rememberValues", 
         "method:ValuesManager.resetValues","method:ValuesManager.valuesHaveChanged", "method:ValuesManager.getValue", 
         "method:ValuesManager.setValue","method:ValuesManager.addMember", "method:ValuesManager.addMembers", 
         "method:ValuesManager.removeMember","method:ValuesManager.removeMembers", "method:ValuesManager.getMembers", 
         "method:ValuesManager.getMember","method:ValuesManager.getMemberForField", "method:ValuesManager.getItem", 
         "method:ValuesManager.handleHiddenValidationErrors"],
        type:"class",
        ref:"class:ValuesManager",
        classAttrs:[],
        treeLocation:["Client Reference/Forms"],
        classMethods:[],
        description:"The ValuesManager manages data from multiple member forms.\n <P>\n If a single logical form needs to be separated into multiple DynamicForm instances for\n Layout purposes (for example, spanning one logical form across multiple Tabs), a\n ValuesManager can be used to make the forms act as one logical form, supporting all\n value-related APIs otherwise called on DynamicForm directly.\n <P>\n A ValuesManager has no visual representation - it is strictly a logical entity, and the\n member forms provide the user interface.  You can initialize a ValuesManager with a set of\n member forms (by setting ${isc.DocUtils.linkForRef('attr:ValuesManager.members')} at init) or add and remove member\n forms dynamically.\n <P>\n Calling ${isc.DocUtils.linkForRef('method:ValuesManager.setValues')} on a ValuesManager will automatically route new\n field values to whichever member form is showing an editor for that field.  Likewise,\n calling ${isc.DocUtils.linkForRef('method:ValuesManager.validate')} will validate all member forms, and\n ${isc.DocUtils.linkForRef('method:ValuesManager.saveData')} will initiate a save operation which aggregates values from\n all member forms.\n <P>\n Like a DynamicForm, a ValuesManager can be databound by setting\n ${isc.DocUtils.linkForRef('attr:ValuesManager.dataSource')}.  In this case all member forms must also be bound to the\n same DataSource.\n <P>\n In general, when working with a ValuesManager and its member forms, call APIs on the\n ValuesManager whenever you are dealing with values that span multiple forms, and only call\n APIs on member forms that are specific to that form or its fields.\n <P>\n Note that, just as a DynamicForm can track values that are not shown in any FormItem, a\n ValuesManager may track values for which there is no FormItem in any member form.  However,\n when using a ValuesManager these extra values are only allowed on the ValuesManager itself.\n Member forms will not track values for which they do not have FormItems.",
        attrs:["attr:ValuesManager.saveOperationType", "attr:ValuesManager.dataSource", 
         "attr:ValuesManager.members","attr:ValuesManager.unknownErrorMessage", "attr:ValuesManager.disableValidation"],
        name:"ValuesManager",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('formSplitting')}"]
    },
    "attr:ListGrid.unfreezeFieldText":{
        ref:"attr:ListGrid.unfreezeFieldText",
        flags:"IRWA",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid and\n ${isc.DocUtils.linkForRef('attr:ListGrid.canFreezeFields','this.canFreezeFields')} is true, this string will be shown as the\n title for the menu item to unfreeze a currently frozen field.\n <P>\n This is a dynamic string - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>viewer</code> available as a variable mapped to\n the ListGrid instance, and <code>field</code> as a variable pointing to the ListGrid field.\n <P>\n Default value returns \"Unfreeze \" + the field's summary title.",
        name:"unfreezeFieldText",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Unfreeze \\${viewer.getSummaryTitle(field)}\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["i18nMessages"]
    },
    "method:ListGridField.getEditorValueMap":{
        ref:"method:ListGridField.getEditorValueMap",
        flags:"",
        description:" Optional stringMethod to get a ${isc.DocUtils.linkForRef('attr:ListGridField.valueMap')} for a specific field.\n If present this method will be called from ${isc.DocUtils.linkForRef('method:ListGrid.getEditorValueMap')} and the resulting\n valueMap will be used instead of any static specified valueMap for the field.\n",
        name:"getEditorValueMap",
        seeAlso:[],
        params:[
            {description:"Field values for record being edited. Note that this will include                        the current edit values for fields that have not yet been saved.\n                        May be null, if editing a new record.",
             optional:false, name:"values", defaultValue:null, type:"object"},
            {description:"pointer to the listGridField", optional:false, name:"field",
             defaultValue:null, type:"ListGridField"},
            {description:"pointer back to this ListGrid instance.", optional:false, name:"grid",
             defaultValue:null, type:"ListGrid"}
        ],
        returns:{description:"ValueMap for the field (or null if no valueMap required)", type:"valueMap"},
        type:"method",
        definingClass:"object:ListGridField"
    },
    "method:Array.setLength":{
        ref:"method:Array.setLength",
        flags:"",
        description:" Set the length of this list.\n <P>\n If the length of the list is shortened, any elements past the new length of the list are removed.\n If the length is increased, all positions past the old length have the value\n <code>undefined</code>.\n\n",
        name:"setLength",
        seeAlso:[],
        params:[
            {description:"new length", optional:false, name:"length", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"object:Array",
        groups:["modification"]
    },
    "method:ListGridField.cellChanged":{
        ref:"method:ListGridField.cellChanged",
        flags:"",
        description:"  Callback fired when field changes value as the result of a cell edit.  Fired only on\n  successful save of edit, when the new value doesn't match the value before editing.<br>\n  <p>\n  Same signature as ${isc.DocUtils.linkForRef('method:ListGrid.cellChanged')}, but defined on a per-field basis.\n\n",
        name:"cellChanged",
        seeAlso:[
            {ref:"method:ListGrid.cellChanged", description:null}
        ],
        type:"method",
        definingClass:"object:ListGridField",
        groups:["editing"]
    },
    "method:FormItem.itemHoverHTML":{
        ref:"method:FormItem.itemHoverHTML",
        flags:"A",
        description:"  If defined, this method should return the HTML to display in a hover canvas when the \n  user holds the mousepointer over this item.  Return null to suppress the hover \n  canvas altogether.<br>\n  If not defined, <code>dynamicForm.itemHoverHTML()</code> will be evaluated to \n  determine hover content instead.\n\n",
        name:"itemHoverHTML",
        seeAlso:[
            {ref:"attr:FormItem.prompt", description:null},
            {ref:"method:FormItem.itemHover", description:null},
            {ref:"method:FormItem.titleHoverHTML", description:null}
        ],
        params:[
            {description:"Pointer to this item", optional:false, name:"item", defaultValue:null,
             type:"FormItem"},
            {description:"This items form", optional:false, name:"form", defaultValue:null,
             type:"DynamicForm"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('itemHoverHTML')}"],
        definingClass:"class:FormItem",
        groups:["Hovers"]
    },
    "method:StretchImg.setState":{
        ref:"method:StretchImg.setState",
        flags:"",
        description:" Set the specified image's state to newState and update the displayed image given by\n whichPart, or set the state for all images to newState and update the displayed images\n if whichPart is not provided.\n",
        name:"setState",
        seeAlso:[],
        params:[
            {description:"name for the new state (\"off\", \"down\", etc)", optional:false,
             name:"newState", defaultValue:null, type:"string"},
            {description:"name of the piece to set (\"start\", \"stretch\" or \"end\")											if not specified, sets them all",
             optional:true, name:"whichPart", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:StretchImg",
        groups:["appearance"]
    },
    "method:ResultTree.dataArrived":{
        ref:"method:ResultTree.dataArrived",
        flags:"",
        description:" This callback fires whenever the resultTree receives new nodes from the server, after\n the new nodes have been integrated into the tree.\n \n",
        name:"dataArrived",
        seeAlso:[],
        params:[
            {description:"The parentNode for which children were just loaded", optional:false,
             name:"parentNode", defaultValue:null, type:"TreeNode"}
        ],
        type:"method",
        definingClass:"class:ResultTree"
    },
    "attr:Hilite.criteria":{
        ref:"attr:Hilite.criteria",
        flags:"IR",
        description:"Criteria defining what records this hilite should apply to.",
        name:"criteria",
        seeAlso:[],
        valueType:"Criteria or AdvancedCriteria",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Hilite"
    },
    "classMethod:Class.setProperties":{
        ref:"classMethod:Class.setProperties",
        flags:"",
        description:"	Apply a set of properties to a class object, calling the appropriate setter class methods if\n	any are found.\n\n",
        name:"setProperties",
        seeAlso:[],
        params:[
            {description:"objects with properties to add (think named parameters).										all the properties of each argument will be applied one after another\n										so later properties will override",
             optional:true, name:"arguments 0-N", defaultValue:null, type:"object"}
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "attr:DynamicForm.method":{
        ref:"attr:DynamicForm.method",
        flags:"IRW",
        description:"The mechanism by which form data is sent to the action URL. See FormMethod type\n for details.\n <p>\n <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data\n directly to a URL.  Normal server contact is through \n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')}.",
        name:"method",
        seeAlso:[],
        valueType:"FormMethod",
        defaultValue:"DynamicForm.POST",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["submitting"]
    },
    "classMethod:RPCManager.resendTransaction":{
        ref:"classMethod:RPCManager.resendTransaction",
        flags:"A",
        description:" Resend a suspended transaction to the server.  See ${isc.DocUtils.linkForRef('classMethod:RPCManager.suspendTransaction')} for\n context.  \n <P>\n Note that the transaction must have been previously suspended, and in particular\n suspended validly according to the rules described in the docs for\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.suspendTransaction')}, or undefined results will occur.\n <P>\n You can resend <b>all</b> suspended transactions by calling\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.resendTransaction')} with no arguments.\n\n",
        name:"resendTransaction",
        seeAlso:[
            {ref:"group:relogin", description:null}
        ],
        params:[
            {description:"id of the transaction to be re-sent, or null to resend all                              suspended transactions",
             optional:true, name:"transactionNum", defaultValue:null, type:"id"}
        ],
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "attr:DetailViewer.data":{
        ref:"attr:DetailViewer.data",
        flags:"IRW",
        description:"A single record object or an array of them, specifying data. Note that DetailViewers do\n not observe changes to the data array (in other words they will not automatically\n re-draw when the data provided via this property is altered).",
        name:"data",
        setter:["setData"],
        seeAlso:[],
        valueType:"Array of DetailViewerRecord",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:["basics"]
    },
    "attr:FormItemIcon.neverDisable":{
        ref:"attr:FormItemIcon.neverDisable",
        flags:"IRWA",
        description:"If <code>icon.neverDisable</code> is true, when this form item is disabled, the \n  icon will remain enabled. \n  Note that disabling the entire form will disable all items, together with their \n  icons including those marked as neverDisable - this property only has an effect \n  if the form is enabled and a specific item is disabled within it.",
        name:"neverDisable",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:FormItemIcon",
        groups:["formIcons"]
    },
    "method:ActiveXControl.getPluginID":{
        ref:"method:ActiveXControl.getPluginID",
        flags:"",
        description:"  Returns the ID for this ISC ActiveX control object.\n  If the <code>id</code> property was specified for the object, that will be used, otherwise \n  the ID will be auto-generated.\n",
        name:"getPluginID",
        seeAlso:[],
        type:"method",
        definingClass:"class:ActiveXControl"
    },
    "classAttr:RPCManager.defaultTransport":{
        ref:"classAttr:RPCManager.defaultTransport",
        flags:"IRW",
        description:"Selects the transport use for RPC requests by default.  You can override this setting on\n a per-request basis by setting ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.",
        name:"defaultTransport",
        seeAlso:[
            {ref:"attr:RPCRequest.transport", description:null}
        ],
        valueType:"RPCTransport",
        defaultValue:"\"xmlHttpRequest\"",
        type:"classAttr",
        definingClass:"class:RPCManager"
    },
    "class:ImgSplitbar":{
        methods:[],
        ref:"class:ImgSplitbar",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Layout"],
        attrs:["attr:ImgSplitbar.target", "attr:ImgSplitbar.vertical", "attr:ImgSplitbar.canDrag", 
         "attr:ImgSplitbar.canCollapse","attr:ImgSplitbar.skinImgDir", "attr:ImgSplitbar.src", "attr:ImgSplitbar.hSrc", 
         "attr:ImgSplitbar.vSrc"],
        description:"Subclass of the ${isc.DocUtils.linkForRef('class:Img')} class. As with the ${isc.DocUtils.linkForRef('class:Splitbar')} class, \n  widgets of this class can be displayed as a resize-bar for widgets \n  in Layouts where showResizeBar is set to true. Provides a different appearance from\n  the <code>Splitbar</code> class.<br>\n  To specify the resizeBar class for some layout, use the ${isc.DocUtils.linkForRef('attr:Layout.resizeBarClass')}\n  property.",
        name:"ImgSplitbar",
        seeAlso:[
            {ref:"class:Layout", description:null},
            {ref:"class:Splitbar", description:null}
        ],
        type:"class"
    },
    "method:ValuesManager.getDataSource":{
        ref:"method:ValuesManager.getDataSource",
        flags:"A",
        description:" Returns the dataSource for this valuesManager.  Will return null if this is not a \n data-bound valuesManager instance.\n",
        name:"getDataSource",
        seeAlso:[],
        returns:{description:"Datasource object for this valuesManager.", type:"DataSource"},
        type:"method",
        definingClass:"class:ValuesManager"
    },
    "method:GridRenderer.getCellValue":{
        ref:"method:GridRenderer.getCellValue",
        flags:"",
        description:" Return the HTML to display in this cell.  Implementing this is required to get a non-empty\n grid.\n\n",
        name:"getCellValue",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"HTML to display in this cell", type:"string"},
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "classMethod:Validator.addValidator":{
        ref:"classMethod:Validator.addValidator",
        flags:"A",
        description:" Add a new validator type that can be specified as ${isc.DocUtils.linkForRef('attr:Validator.type')} anywhere\n validators are declared, such as ${isc.DocUtils.linkForRef('attr:DataSourceField.validators')} or\n ${isc.DocUtils.linkForRef('attr:FormItem.validators')}.\n <br>\n The <code>condition</code> argument should be a method of the same signature as\n ${isc.DocUtils.linkForRef('method:Validator.condition')}.\n\n",
        name:"addValidator",
        seeAlso:[
            {ref:"classMethod:Validator.addValidators", description:null}
        ],
        params:[
            {description:"type name for the new validator", optional:false, name:"type",
             defaultValue:null, type:"String"},
            {description:"function or expression to evaluate to determine whether                                 validation was successful",
             optional:false, name:"condition", defaultValue:null, type:"StringMethod"}
        ],
        type:"classMethod",
        definingClass:"class:Validator",
        groups:["validation"]
    },
    "attr:SelectItem.defaultToFirstOption":{
        ref:"attr:SelectItem.defaultToFirstOption",
        flags:"IRW",
        description:"Select the first option as the default value for this SelectItem. \n <P>\n If options are derived from a dataSource, the first value returned by the server will be\n used, otherwise the first value in the valueMap.  Note that setting this property to\n true will trigger a fetch at soon as the form is created, because the form will try to\n establish a default value at that time.\n <P>\n If enabled, this setting overrides ${isc.DocUtils.linkForRef('attr:SelectItem.defaultValue')} and\n ${isc.DocUtils.linkForRef('method:SelectItem.defaultDynamicValue')}.",
        name:"defaultToFirstOption",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:SelectItem"
    },
    "method:ListGrid.showField":{
        ref:"method:ListGrid.showField",
        flags:"",
        description:" Force a field to be shown.<br><br>\n\n NOTE: If a field.showIf expression exists, it will be destroyed.\n\n",
        name:"showField",
        seeAlso:[],
        params:[
            {description:"field to show", optional:false, name:"field", defaultValue:null,
             type:"field name or ListGridField"},
            {description:"If passed, don't resize non-explicitly sized columns                                       to fill the available space.",
             optional:true, name:"suppressRelayout", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('columnOrder')}"],
        definingClass:"class:ListGrid"
    },
    "attr:ImgButton.autoFit":{
        ref:"attr:ImgButton.autoFit",
        flags:"IRW",
        description:"If true, ignore the specified size of this widget and always size just large\n enough to accomodate the title.  If <code>setWidth()</code> is explicitly called on an\n autoFit:true button, autoFit will be reset to <code>false</code>.\n <P>\n Note that for StretchImgButton instances, autoFit will occur horizontally only, as \n unpredictable vertical sizing is likely to distort the media. If you do want vertical \n auto-fit, this can be achieved by simply setting a small height, and having \n overflow:\"visible\"",
        name:"autoFit",
        setter:["setAutoFit"],
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["sizing"]
    },
    "classMethod:Log.clearPriority":{
        ref:"classMethod:Log.clearPriority",
        flags:"",
        description:" Clear the priority setting for a particular category, so that the category's effective\n priority returns to <code>Log.defaultPriority</code><br>\n If the optional second parameter is passed, the specific priority setting for the \n category on that object will be cleared, so logs in that category on that object will\n be logged at the global priority level for the category.\n\n",
        name:"clearPriority",
        seeAlso:[],
        params:[
            {description:"category name", optional:false, name:"category", defaultValue:null,
             type:"String"},
            {description:"Optional instance or class object - if passed                                        clear logging priority for the appropriate category\n                                        on that object.",
             optional:true, name:"object", defaultValue:null, type:"Class or Instance object"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:SectionHeader.icon":{
        ref:"attr:SectionHeader.icon",
        flags:"IRA",
        description:"Base filename of the icon that represents open and closed states. The default settings\n also change the icon for disabled sections, so a total of four images are required\n (opened, closed, Disabled_opened, Disabled_closed).",
        name:"icon",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]SectionHeader/opener.gif\"",
        type:"attr",
        definingClass:"class:SectionHeader"
    },
    "attr:TestFunctionResult.failedExecution":{
        ref:"attr:TestFunctionResult.failedExecution",
        flags:"IRW",
        description:"Set to true if callng the formula or summary format resulted in a JavaScript Error.\n This would generally indicate a reference to non-existant data values.  See \n ${isc.DocUtils.linkForRef('attr:TestFunctionResult.failedGeneration')} for other types of failure.\n <P>\n When set to true, ${isc.DocUtils.linkForRef('attr:TestFunctionResult.errorText')} contains the exception message.",
        name:"failedExecution",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"object:TestFunctionResult",
        groups:["formulaFields"]
    },
    "method:ListGrid.headerClick":{
        ref:"method:ListGrid.headerClick",
        flags:"A",
        description:" Handle a click in the list header.\n <P>\n By default, calls ${isc.DocUtils.linkForRef('method:ListGrid.sort')} to sort by the field that was clicked, or to reverse the\n direction of sorting if already sorted by that field.\n\n",
        name:"headerClick",
        seeAlso:[],
        params:[
            {description:"field number for the header that was clicked", optional:false,
             name:"fieldNum", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["sorting", "events", "gridHeader"]
    },
    "method:DetailViewer.formatCellValue":{
        ref:"method:DetailViewer.formatCellValue",
        flags:"",
        description:" Optional method to format the value to display for cells in this DetailViewer.\n Note that if ${isc.DocUtils.linkForRef('method:DetailViewerField.formatCellValue')} is specified this method will not\n be called for cells within that field.\n",
        name:"formatCellValue",
        seeAlso:[],
        params:[
            {description:"the raw value of the cell (may be formatted by   ${isc.DocUtils.linkForRef('method:DetailViewerField.formatCellValue')}",
             optional:false, name:"value", defaultValue:null, type:"string"},
            {description:"the record being displayed", optional:false, name:"record", defaultValue:null,
             type:"detailViewerRecord"},
            {description:"the field being displayed", optional:false, name:"field", defaultValue:null,
             type:"detailViewerField"}
        ],
        type:"method",
        definingClass:"class:DetailViewer",
        groups:["i18nMessages"]
    },
    "attr:PickList.pickListWidth":{
        ref:"attr:PickList.pickListWidth",
        flags:"IRW",
        description:"Default width to show the pickList.\n If not specified, the width of this form item's element will be used instead.",
        name:"pickListWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('listComboBox')}"],
        definingClass:"interface:PickList"
    },
    "method:TileGrid.recordClick":{
        ref:"method:TileGrid.recordClick",
        flags:"",
        description:" Executed when the tileGrid receives a 'click' event on a\n tile. The default implementation does nothing -- override to perform some action\n when any record is clicked.<br>\n A record event handler can be specified either as\n a function to execute, or as a string of script to evaluate. If the handler is defined\n as a string of script, all the parameters below will be available as variables for use\n in the script.<br>\n If you want to cancel the click based on the parameters, return false. Otherwise, return \n true so that the click event be registered with the tile.\n\n",
        name:"recordClick",
        seeAlso:[],
        params:[
            {description:"the TileGrid itself", optional:false, name:"viewer", defaultValue:null,
             type:"TileGrid"},
            {description:"the tile that was clicked on", optional:false, name:"tile", defaultValue:null,
             type:"Canvas"},
            {description:"the record that was clicked on", optional:false, name:"record",
             defaultValue:null, type:"TileRecord"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('tilingEditing')}"],
        definingClass:"class:TileGrid",
        groups:["events"]
    },
    "method:DataSource.addData":{
        ref:"method:DataSource.addData",
        flags:"",
        description:" Perform an \"add\" DataSource operation against this DataSource, to create a new DataSource\n record.\n\n",
        name:"addData",
        seeAlso:[],
        params:[
            {description:"new record", optional:false, name:"newRecord", defaultValue:null,
             type:"Record"},
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on                                                       the DSRequest that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest Properties"}
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:["operations"]
    },
    "attr:Label.showDownIcon":{
        ref:"attr:Label.showDownIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the mouse goes\n down on the button.",
        name:"showDownIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Label",
        groups:["buttonIcon"]
    },
    "method:ListGrid.selectRecord":{
        ref:"method:ListGrid.selectRecord",
        flags:"",
        description:" Select/deselect a ${isc.DocUtils.linkForRef('object:Record')} passed in explicitly, or by index.\n <P>\n Note that this method selects records unconditionally, allowing multiple selected \n records, even when ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType')} is \"single\".  To enforce mutually-exclusive \n record-selection, use ${isc.DocUtils.linkForRef('method:ListGrid.selectSingleRecord')}.\n",
        name:"selectRecord",
        seeAlso:[],
        params:[
            {description:"record (or row number) to select", optional:false, name:"record",
             defaultValue:null, type:"Record | number"},
            {description:"new selection state (if null, defaults to true)", optional:true,
             name:"newState", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["selection"]
    },
    "classMethod:FileLoader.loadJSFiles":{
        ref:"classMethod:FileLoader.loadJSFiles",
        flags:"",
        description:"\n Loads the specified JS files into the context of the current page.\n\n",
        name:"loadJSFiles",
        seeAlso:[],
        params:[
            {description:"List of URLs pointing to JS files to load.  This can either be a                                string with comma separated URLs or an Array of URLs.",
             optional:false, name:"URLs", defaultValue:null, type:"String or Array"},
            {description:"Optional code to execute when the last of the specified URLs                                      has completed loading.",
             optional:true, name:"onload", defaultValue:null, type:"String or Function"}
        ],
        type:"classMethod",
        definingClass:"class:FileLoader"
    },
    "class:ImgTab":{
        methods:[],
        ref:"class:ImgTab",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Foundation"],
        attrs:["attr:ImgTab.capSize", "attr:ImgTab.skinImgDir", "attr:ImgTab.baseStyle", 
         "attr:ImgTab.titleStyle","attr:ImgTab.src", "attr:ImgTab.showRollOver", "attr:ImgTab.showFocus", 
         "attr:ImgTab.showFocused","attr:ImgTab.align"],
        description:"Specialized StretchImgButton used by TabSet/TabBar for tabs",
        name:"ImgTab",
        seeAlso:[],
        type:"class"
    },
    "attr:OperationBinding.exportAs":{
        ref:"attr:OperationBinding.exportAs",
        flags:"IR",
        description:"The format in which the data should be exported.  See ${isc.DocUtils.linkForRef('type:ExportFormat')} for more \n information.",
        name:"exportAs",
        seeAlso:[],
        valueType:"ExportFormat",
        defaultValue:"\"csv\"",
        type:"attr",
        definingClass:"class:OperationBinding"
    },
    "attr:DataSourceField.group":{
        ref:"attr:DataSourceField.group",
        flags:"IR",
        description:"For use in ${isc.DocUtils.linkForRef('group:componentSchema')}, indicates what group to place the property in when\n editing in Visual Builder.",
        name:"group",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["componentSchema"]
    },
    "method:FormItem.click":{
        ref:"method:FormItem.click",
        flags:"",
        description:" Called when this FormItem is clicked on.\n <P>\n Note: <code>click()</code> is available on StaticTextItem, BlurbItems, ButtonItem, and\n derivatives.  Other form items (such as HiddenItem) do not support <code>click()</code>.\n\n",
        name:"click",
        seeAlso:[],
        params:[
            {description:"the managing DynamicForm instance", optional:false, name:"form",
             defaultValue:null, type:"DynamicForm"},
            {description:"the form item itself (also available as \"this\")", optional:false,
             name:"item", defaultValue:null, type:"FormItem"}
        ],
        type:"method",
        definingClass:"class:FormItem",
        groups:["eventHandling"]
    },
    "method:ColumnTree.getRecord":{
        ref:"method:ColumnTree.getRecord",
        flags:"",
        description:" Retrieve a record by index.  \n <P>\n If <code>colNum</code> is passed, returns the record found in that column at that index,\n or null if the column doesn't exist or the index is too high.\n <P>\n With no <code>colNum</code> parameter, a record's index is it's position counting from the\n first record of the first column and including all records in each column. Note that both\n index and colNum are zero-based - so the first column is column 0, not column 1.\n \n",
        name:"getRecord",
        seeAlso:[],
        params:[
            {description:"index of record to return.", optional:false, name:"index", defaultValue:null,
             type:"integer"},
            {description:"optional index of the column", optional:true, name:"colNum",
             defaultValue:null, type:"integer"}
        ],
        returns:{description:"node at the specified index", type:"TreeNode"},
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "group:eventBubbling":{
        ref:"group:eventBubbling",
        refs:[],
        name:"eventBubbling",
        seeAlso:[],
        type:"group"
    },
    "attr:FormItemIcon.width":{
        ref:"attr:FormItemIcon.width",
        flags:"IRW",
        description:"If set, this property determines the width of this icon in px.\n      If unset the form item's <code>iconWidth</code> property will be used instead.",
        name:"width",
        seeAlso:[
            {ref:"attr:FormItem.iconWidth", description:null}
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:FormItemIcon",
        groups:["formIcons"]
    },
    "attr:Scrollbar.trackEndWidth":{
        ref:"attr:Scrollbar.trackEndWidth",
        flags:"IRA",
        description:"The minimum pixel width of the track end segments (if enabled with showTrackEnds).",
        name:"trackEndWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"12",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:["track"]
    },
    "attr:ImgButton.state":{
        flags:"IRWA",
        getter:["getState"],
        type:"attr",
        ref:"attr:ImgButton.state",
        description:"Current \"state\" of this widget. StatefulCanvases will have a different appearance based\n on their current state. By default this is handled by changing the css className applied to\n the StatefulCanvas - see ${isc.DocUtils.linkForRef('attr:StatefulCanvas.baseStyle')} for a description of how this is\n done.<P>\n For ${isc.DocUtils.linkForRef('class:Img')} or ${isc.DocUtils.linkForRef('class:StretchImg')} based subclasses of StatefulCanvas, the \n appearance may also be updated by changing the src of the rendered image. See\n ${isc.DocUtils.linkForRef('attr:Img.src')} and ${isc.DocUtils.linkForRef('attr:StretchImgButton.src')} for a description of how the URL \n is modified to reflect the state of the widget in this case.",
        name:"state",
        setter:["setState"],
        valueType:"State",
        seeAlso:[
            {ref:"type:State", description:null},
            {ref:"group:state", description:null}
        ],
        defaultValue:"\"\"",
        groups:["state"],
        definingClass:"class:ImgButton"
    },
    "method:ValuesManager.saveData":{
        ref:"method:ValuesManager.saveData",
        flags:"",
        description:"\n Validate and then save the form's current values to the ${isc.DocUtils.linkForRef('class:DataSource')} this form is\n bound to.\n <p>\n If client-side validators are defined, they are executed first, and if any errors are\n found the save is aborted and the form will show the errors.\n <p>\n If client-side validation passes, a ${isc.DocUtils.linkForRef('class:DSRequest')} will be sent, exactly as though\n ${isc.DocUtils.linkForRef('method:DataSource.addData')} or ${isc.DocUtils.linkForRef('method:DataSource.updateData')} had been called with \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','the form's values')} as data.  The\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType')} will be either \"update\" or \"add\", depending on the\n current ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOperationType')}.\n <P>\n On either a client-side or server-side validation failure, validation errors will be\n displayed in the form.  Visible items within a DynamicForms will be redrawn to display\n errors. Validation failure occuring on hidden items, or DataSource fields with no \n associated form items may be handled via ${isc.DocUtils.linkForRef('method:DynamicForm.handleHiddenValidationErrors')}\n or ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')}.\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.validationURL','validationURL')} can be set to do validation against a\n different URL from where the form will ultimately save, as part of an incremental\n upgrade strategy for Struts and Struts-like applications.\n\n",
        name:"saveData",
        seeAlso:[],
        params:[
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on the DSRequest                                            that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('addOperation')}"],
        definingClass:"class:ValuesManager",
        groups:["dataBoundComponentMethods"]
    },
    "group:formIcons":{
        ref:"group:formIcons",
        refs:["method:FormItemIcon.click", "method:FormItemIcon.keyPress", "method:FormItem.iconClick", 
         "method:FormItem.iconKeyPress","object:FormItemIcon", "attr:FormItem.icons", "attr:FormItem.defaultIconSrc", 
         "attr:FormItem.showOverIcons","attr:FormItem.showFocusedIcons", "attr:FormItem.iconVAlign", "attr:FormItem.iconHeight", 
         "attr:FormItem.iconWidth","attr:FormItem.iconPrompt", "attr:FormItem.showIcons", "attr:FormItemIcon.src", 
         "attr:FormItemIcon.showOver","attr:FormItemIcon.showFocused", "attr:FormItemIcon.showFocusedWithItem", 
         "attr:FormItemIcon.neverDisable","attr:FormItemIcon.width", "attr:FormItemIcon.height", "attr:FormItemIcon.prompt", 
         "attr:TextAreaItem.iconVAlign"],
        name:"formIcons",
        seeAlso:[],
        type:"group"
    },
    "type:SCClassName":{
        ref:"type:SCClassName",
        description:"Name of a SmartClient Class, that is, a Class that has been created via\n ${isc.DocUtils.linkForRef('classMethod:isc.defineClass')}, including Classes built into SmartClient, such as \"ListGrid\".",
        name:"SCClassName",
        seeAlso:[],
        type:"type"
    },
    "method:Progressbar.getLength":{
        ref:"method:Progressbar.getLength",
        flags:"",
        description:" Returns the current width of a horizontal progressbar, or height of a vertical progressbar.\n\n",
        name:"getLength",
        seeAlso:[],
        returns:{description:"the length of the progressbar", type:"number"},
        type:"method",
        definingClass:"class:Progressbar"
    },
    "attr:TabBar.baseLineCapSize":{
        ref:"attr:TabBar.baseLineCapSize",
        flags:"IR",
        description:"Set ${isc.DocUtils.linkForRef('attr:StretchImg.capSize')} for the ${isc.DocUtils.linkForRef('group:baseLine')} stretchImg.",
        name:"baseLineCapSize",
        seeAlso:[],
        valueType:"number",
        defaultValue:"2",
        type:"attr",
        definingClass:"class:TabBar",
        groups:["baseLine"]
    },
    "attr:StretchImgButton.showSelectedIcon":{
        ref:"attr:StretchImgButton.showSelectedIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the button\n becomes selected.",
        name:"showSelectedIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["buttonIcon"]
    },
    "attr:DetailViewerField.type":{
        ref:"attr:DetailViewerField.type",
        flags:"IR",
        description:"Specifies the type of this DetailViewerField.  By default (value is <code>null</code>)\n the field shows a field title on the left and the field value on the right.  There are\n two special values for this attribute:\n <ul>\n <li>\"header\" - If you specify type \"header\", the field spans both the field name and\n field value columns and contains text defined in the ${isc.DocUtils.linkForRef('attr:DetailViewerField.value')}\n attribute with the style specifed by ${isc.DocUtils.linkForRef('attr:DetailViewer.headerStyle')}.  You can use this\n field type as a titled separator.\n <li>\"separator\" - If you specify type \"separator\", the field spans both the field name\n and the field value columns with no text, and is styled using the style specified via\n ${isc.DocUtils.linkForRef('attr:DetailViewer.separatorStyle')}.  The height of the separator field can be controlled\n via ${isc.DocUtils.linkForRef('attr:DetailViewerField.height')}.\n <li>\"image\" For viewing, a thumbnail image is rendered in the field.  The URL of the\n image is the value of the field, and should be absolute. The size of the image is\n controlled by ${isc.DocUtils.linkForRef('attr:DetailViewerField.imageSize')},\n ${isc.DocUtils.linkForRef('attr:DetailViewerField.imageWidth')}, ${isc.DocUtils.linkForRef('attr:DetailViewerField.imageHeight')}\n </ul>",
        name:"type",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField"
    },
    "method:TabSet.scrollBack":{
        ref:"method:TabSet.scrollBack",
        flags:"",
        description:" If there is not enough space to display all the tabs in this tabSet, this method will \n scroll the previous tab (that first tab that is clipped at the beginning of the tab-bar) \n into view.\n",
        name:"scrollBack",
        seeAlso:[],
        type:"method",
        definingClass:"class:TabSet"
    },
    "classAttr:ValidatorTypes.isOneOf":{
        ref:"classAttr:ValidatorTypes.isOneOf",
        flags:"IR",
        description:"Tests whether the value for this field matches any value from an arbitrary\n list of acceptable values.  The set of acceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. If validator.list is not supplied, the valueMap for the field will be used.\n If there is no valueMap, not providing validator.list is an error.",
        name:"isOneOf",
        seeAlso:[],
        valueType:"validatorDefinition",
        defaultValue:"object",
        type:"classAttr",
        definingClass:"class:ValidatorTypes"
    },
    "attr:ListGrid.loadingMessage":{
        ref:"attr:ListGrid.loadingMessage",
        flags:"IR",
        description:"If you have a databound listGrid and you scroll out of the currently loaded dataset, by\n default you will see blank rows until the server returns the data for those rows.  The\n loadingMessage attribute allows you to specify arbitrary html that will be shown in each\n such \"blank\" record while the data for that record is loading.",
        name:"loadingMessage",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"\\&nbsp;\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["emptyMessage", "i18nMessages"]
    },
    "method:Button.setBaseStyle":{
        ref:"method:Button.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[],
        params:[
            {description:"new base style", optional:false, name:"style", defaultValue:null,
             type:"className"}
        ],
        type:"method",
        definingClass:"class:Button"
    },
    "method:Array.max":{
        ref:"method:Array.max",
        flags:"",
        description:"\n 			Returns the largest number in the array, skipping non-numeric values.\n\n			If the start and/or end are given, searches the specified subset of the list.\n\n",
        name:"max",
        seeAlso:[],
        params:[
            {description:"optional start index (default is 0)", optional:true, name:"start",
             defaultValue:null, type:"number"},
            {description:"optional end index (default is list.length)", optional:true, name:"end",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"maximum of all items in the list, or null if all values are non-numeric",
         type:"number"},
        type:"method",
        definingClass:"object:Array",
        groups:["arrayMath"]
    },
    "method:Array.getUniqueItems":{
        ref:"method:Array.getUniqueItems",
        flags:"",
        description:" Return a list of each unique item in this list exactly once.\n <P>\n Returns in the same order they were found in the list.\n <P>\n Usage example:<br>\n &nbsp;&nbsp;&nbsp;&nbsp;uniqueList = myArray.getProperty(\"foo\").getUniqueItems();\n\n",
        name:"getUniqueItems",
        seeAlso:[],
        returns:{description:"list of each unique item in the list", type:"array"},
        type:"method",
        definingClass:"object:Array",
        groups:["subset"]
    },
    "method:CubeGrid.facetRemoved":{
        ref:"method:CubeGrid.facetRemoved",
        flags:"",
        description:" Notification fired when a facet is removed.\n \n",
        name:"facetRemoved",
        seeAlso:[
            {ref:"method:CubeGrid.facetAdded", description:"<br><i>methodType</i>  handler"}
        ],
        params:[
            {description:"facetId that was removed", optional:false, name:"facetId", defaultValue:null,
             type:"id"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["facetLayout"]
    },
    "method:Array.map":{
        ref:"method:Array.map",
        flags:"",
        description:" Return an array where the value of item <code>i</code> is the result of calling the provided\n function on item <code>i</code> in this array.\n <P>\n The function to call can either be provided directly as a function object, in which case it\n is invoked with the item as the first argument, or can be provided as the String name of a\n method present on each item, which will be invoked.  In the latter case, if any item is null\n or lacks the named method, null will be returned for that item.\n <P>\n Examples:<PRE>\n    // line up widgets at 20 pixels from page edge\n    [widget1, widget2].map(\"setPageLeft\", 20);\n\n    // find furthest right widget\n    [widget1, widget2].map(\"getPageRight\").max();\n </PRE>\n \n",
        name:"map",
        seeAlso:[],
        params:[
            {description:"function object, or name of method", optional:false, name:"method",
             defaultValue:null, type:"string or function"},
            {description:"arguments to pass to the function or method                                           invoked on each item",
             optional:true, name:"(arguments 1-N)", defaultValue:null, type:"any"}
        ],
        returns:{description:"array of returned values", type:"array"},
        type:"method",
        definingClass:"object:Array",
        groups:["iteration"]
    },
    "method:Canvas.getSnapTo":{
        ref:"method:Canvas.getSnapTo",
        flags:"",
        description:" Return the snapTo value of this object\n\n",
        name:"getSnapTo",
        seeAlso:[],
        returns:{description:"snapTo", type:"string"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "type:Object":{
        ref:"type:Object",
        description:"An ordinary JavaScript as obtained by \"new Object()\" or via \n ${isc.DocUtils.linkForRef('type:ObjectLiteral','Object Literal')} syntax.\n <P>\n Methods that return Objects or take Objects as parameters make use of the ability of a\n JavaScript Object to contain an arbitrary set of named properties, without requiring\n declaration in advance.  This capability makes it possible to use a JavaScript Object much\n like a HashMap in Java or .NET, but without the need to call get() or set() to create and\n retrieve properties.\n <P>\n For example if you created an Object using ${isc.DocUtils.linkForRef('type:ObjectLiteral','Object Literal')} syntax\n like so:\n <pre>\n    var request = {\n        actionURL : \"/foo.do\",\n        showPrompt:false\n    };\n </pre>\n You could then access it's properties like so:\n <pre>\n    var myActionURL = request.actionURL;\n    var myShowPrompt = request.showPrompt;\n </pre>\n .. and you could assign new values to those properties like so:\n <pre>\n    request.actionURL = \"<i>newActionURL</i>\";\n    request.showPrompt = <i>newShowPromptSetting</i>;\n </pre>\n Note that while JavaScript allows you to get and set properties in this way on any Object,\n SmartClient components require that if a setter or getter exists, it must be called, or no\n action will occur.  For example, if you had a ${isc.DocUtils.linkForRef('class:ListGrid')} and you wanted to change the\n ${isc.DocUtils.linkForRef('attr:ListGrid.showHeader','showHeader')} property:\n <pre>\n     myListGrid.setShowHeader(false); // correct\n     myListGrid.showHeader = false; // incorrect (nothing happens)\n </pre>\n All documented attributes have ${isc.DocUtils.linkForRef('group:flags','flags')} (eg IRW) that indicate when direct\n property access is allowed or not.",
        name:"Object",
        seeAlso:[],
        type:"type"
    },
    "classMethod:Hover.show":{
        ref:"classMethod:Hover.show",
        flags:"",
        description:" Displays a standard Hover canvas containing the specified HTML content.<br>\n This method may also be called to modify the content of the hover if it is already showing.\n Call ${isc.DocUtils.linkForRef('classMethod:Hover.hide')} to hide the canvas again.<br>\n A common use case for calling this method is to asynchronously fetch detail data from the\n server about some component, and display it in the Hover canvas when the data is returned.\n Note that in this case you will typically need to verify that the user is still hovering \n over the component in question before calling Hover.show() - if the user has moved the mouse \n off the component, the information will not apply to whatever is now under the mouse. \n Suggested approaches for handling this are to either use a ${isc.DocUtils.linkForRef('method:Canvas.mouseOut')} handler\n to track when the user moves off the component, or checking ${isc.DocUtils.linkForRef('classMethod:EventHandler.getTarget')}\n as part of the asynchronous callback\n <p>\n The default Hover canvas position will be based on the mouse pointer position, adjusted by\n ${isc.DocUtils.linkForRef('classAttr:Hover.leftOffset')} and ${isc.DocUtils.linkForRef('classAttr:Hover.topOffset')}. If this position would render the\n Hover canvas partially clipped, it will be automatically modified to ensure the Hover \n is entirely visible.\n",
        name:"show",
        seeAlso:[],
        params:[
            {description:"contents for the hover", optional:false, name:"contents", defaultValue:null,
             type:"html"},
            {description:"object containing attributes for managing the hover canvas'   appearance. Valid properties include:<ul>\n  <li>left, top, width, height\n  <li>baseStyle\n  <li>opacity\n  <li>wrap\n  <li>moveWithMouse [overrides ${isc.DocUtils.linkForRef('classAttr:Hover.moveWithMouse')}]\n </ul>",
             optional:false, name:"properties", defaultValue:null, type:"object"}
        ],
        type:"classMethod",
        definingClass:"class:Hover"
    },
    "attr:MenuButton.showMenuButtonImage":{
        ref:"attr:MenuButton.showMenuButtonImage",
        flags:"IR",
        description:"show menu button image (up / down arrowhead) for this menu button",
        name:"showMenuButtonImage",
        setter:["setShowMenuButtonImage"],
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:MenuButton"
    },
    "method:ListGrid.cellClick":{
        ref:"method:ListGrid.cellClick",
        flags:"",
        description:" Called when a cell receives a click event.\n\n",
        name:"cellClick",
        seeAlso:[],
        params:[
            {description:"Record object returned from getCellRecord()", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('cellClicks')}"],
        definingClass:"class:ListGrid",
        groups:["events"]
    },
    "method:Canvas.resized":{
        ref:"method:Canvas.resized",
        flags:"",
        description:"  Observable method called whenever a Canvas changes size. Note that if this canvas is\n ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow:\"visible\"')}, and is waiting for a queued redraw (see \n ${isc.DocUtils.linkForRef('method:Canvas.isDirty')}), the value for ${isc.DocUtils.linkForRef('method:Canvas.getVisibleWidth')} and\n ${isc.DocUtils.linkForRef('method:Canvas.getVisibleHeight')} will be unreliable until <code>redraw()</code> fires.\n",
        name:"resized",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas"
    },
    "method:Date.setFormatter":{
        ref:"method:Date.setFormatter",
        deprecated:"As of SmartClient 5.5 use the static methods              ${isc.DocUtils.linkForRef('classMethod:Date.setNormalDisplayFormat')} and \n              ${isc.DocUtils.linkForRef('classMethod:Date.setShortDisplayFormat')} to set default formatters for all dates",
        flags:"",
        description:"  Set the formatter for this date object to the method name passed in.  After this call\n  wherever appropriate SmartClient components will use this formatter function to return \n  the date as a string.\n",
        name:"setFormatter",
        seeAlso:[],
        params:[
            {description:"name of a date formatter method on this Date", optional:false,
             name:"functionName", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:Date",
        groups:["dateFormatting"]
    },
    "attr:Slider.value":{
        ref:"attr:Slider.value",
        flags:"IRW",
        getter:["getValue"],
        description:"The slider value. This value should lie between the minValue and maxValue and increases as\n the thumb is moved up (for a vertical slider) or right (for a horizontal slider) unless\n flipValues is set to true.",
        name:"value",
        setter:["setValue"],
        seeAlso:[
            {ref:"attr:Slider.minValue", description:null},
            {ref:"attr:Slider.maxValue", description:null},
            {ref:"attr:Slider.flipValues", description:null},
            {ref:"attr:Slider.showValue", description:null}
        ],
        valueType:"float",
        defaultValue:"1",
        type:"attr",
        definingClass:"class:Slider"
    },
    "method:Canvas.scrollByPercent":{
        ref:"method:Canvas.scrollByPercent",
        flags:"",
        description:"  Scroll this widget by some percentage of scroll size in either (or both) direction(s).\n\n",
        name:"scrollByPercent",
        seeAlso:[],
        params:[
            {description:"Percentage to scroll horizontally. Will accept either                                      a numeric percent value, or a string like \"10%\".",
             optional:false, name:"dX", defaultValue:null, type:"number | string"},
            {description:"Percentage to scroll horizontally. Will accept either                                      a numeric percent value, or a string like \"10%\".",
             optional:false, name:"dY", defaultValue:null, type:"number | string"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["scrolling"]
    },
    "attr:FacetValue.collapsed":{
        ref:"attr:FacetValue.collapsed",
        flags:"IR",
        description:"For tree facets, initial collapse state for this node.  Defaults to facet.collapsed",
        name:"collapsed",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"facet.collapsed",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "method:Canvas.getVSnapOrigin":{
        ref:"method:Canvas.getVSnapOrigin",
        flags:"",
        description:" Get an offset to be used when calculating snap positioning. Returns 0 by default.\n\n",
        name:"getVSnapOrigin",
        seeAlso:[
            {ref:"method:Canvas.getVSnapPosition", description:null}
        ],
        params:[
            {description:"the child that is being snapped", optional:true, name:"snapChild",
             defaultValue:null, type:"Canvas"}
        ],
        returns:{description:"The offset to use when snapping", type:"integer"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "attr:MenuItem.enabled":{
        ref:"attr:MenuItem.enabled",
        flags:"IR",
        description:"Affects the visual style and interactivity of the menu item.  If set to\n <code>false</code>, the menu item will not respond to mouse rollovers or clicks.\n <p>\n If you need to set this state dynamically, use ${isc.DocUtils.linkForRef('method:MenuItem.enableIf')} instead.",
        name:"enabled",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"object:MenuItem",
        groups:["menuBasic"]
    },
    "attr:Canvas.hoverDelay":{
        ref:"attr:Canvas.hoverDelay",
        flags:"IRW",
        description:"If <code>this.canHover</code> is true, how long should the mouse be kept over this\n widget before the hover event is fired",
        name:"hoverDelay",
        seeAlso:[
            {ref:"attr:Canvas.canHover", description:null},
            {ref:"method:Canvas.hover", description:null}
        ],
        valueType:"number",
        defaultValue:"300",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["hovers"]
    },
    "method:ResultSet.find":{
        ref:"method:ResultSet.find",
        flags:"",
        description:" Like ${isc.DocUtils.linkForRef('method:List.find')}.  Checks only loaded rows and will not trigger a fetch.\n",
        name:"find",
        seeAlso:[],
        params:[
            {description:"property to match, or if an Object is passed, set of                                        properties and values to match",
             optional:false, name:"propertyName", defaultValue:null, type:"String or Object"},
            {description:"value to compare against (if propertyName is a string)", optional:true,
             name:"value", defaultValue:null, type:"any"}
        ],
        returns:{description:"first matching object or null if not found", type:"Object"},
        type:"method",
        definingClass:"class:ResultSet",
        groups:["access", "find"]
    },
    "attr:FormItem.form":{
        ref:"attr:FormItem.form",
        flags:"R",
        description:"A Read-Only pointer to this formItem's DynamicForm widget.",
        name:"form",
        seeAlso:[],
        valueType:"DynamicForm",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "attr:DataBoundComponent.dragDataAction":{
        ref:"attr:DataBoundComponent.dragDataAction",
        flags:"IRW",
        description:"Indicates what to do with data dragged into another DataBoundComponent. See\n          DragDataAction type for details.",
        name:"dragDataAction",
        seeAlso:[],
        valueType:"DragDataAction",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('gridsDragMove')}", 
         "${isc.DocUtils.linkForExampleId('gridsDragCopy')}"],
        definingClass:"interface:DataBoundComponent",
        groups:["dragging"]
    },
    "method:DataBoundComponent.deselectRecords":{
        ref:"method:DataBoundComponent.deselectRecords",
        flags:"",
        description:"\n Deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n <P>\n Synonym for <code>selectRecords(records, false)</code>\n\n",
        name:"deselectRecords",
        seeAlso:[],
        params:[
            {description:"records (or row numbers) to deselect", optional:false, name:"records",
             defaultValue:null, type:"Array of Record | numbers"}
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["selection"]
    },
    "classAttr:Operators.greaterThanTitle":{
        ref:"classAttr:Operators.greaterThanTitle",
        flags:"IR",
        description:"Title for the \"greaterThan\" operator",
        name:"greaterThanTitle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"greater than\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:["i18nMessages"]
    },
    "object:AdvancedCriteria":{
        methods:[],
        type:"object",
        inheritsFrom:"Criterion",
        ref:"object:AdvancedCriteria",
        classAttrs:[],
        treeLocation:["Client Reference/Data Binding/DataSource"],
        classMethods:[],
        description:"AdvancedCriteria is a format for representing search criteria which may include\n operators on field values such as \"less than\", or may include sub-clauses such as several \n criteria applied to fields joined by an \"OR\" operator.\n <P>\n SmartClient DataSources can use AdvancedCriteria to search a list of ${isc.DocUtils.linkForRef('object:Record')}s, and\n the SmartClient Java Server can translate AdvancedCriteria to either SQL or Hibernate\n queries (<b>Note:</b> The server-side AdvancedCriteria handling feature is only available \n with an <b>Enterprise</b> license; the Pro license is limited to ordinary criteria handling\n on the server side).<p>\n If the entire dataset is cached locally, SmartClient can perform AdvancedCriteria filtering \n on the client, avoiding a server call.\n <P>\n An AdvancedCriteria is an ordinary JavaScript object which can be created directly\n with JavaScript literal notation.  For example:\n <pre>\n var advancedCriteria = {\n        _constructor:\"AdvancedCriteria\",\n        operator:\"and\",\n        criteria:[\n            // this is a Criterion\n            { fieldName:\"salary\", operator:\"lessThan\", value:\"80000\" },\n            { operator:\"or\", criteria:[\n                  { fieldName:\"title\", operator:\"iContains\", value:\"Manager\" },\n                  { fieldName:\"reports\", operator:\"notNull\" }\n              ]  \n            }\n        ]\n    }\n </pre>\n An AdvancedCriteria is in effect a ${isc.DocUtils.linkForRef('object:Criterion')} that has been marked with \n _constructor:\"AdvancedCriteria\" to mark it as complete criteria.\n <P>\n When passed to the SmartClient Server, AdvancedCriteria are automatically translated\n to Java Objects, identically to other JavaScript data, by the rules given under \n ${isc.DocUtils.linkForRef('attr:RPCRequest.data')}.\n <P>\n Other servers may receive AdvancedCriteria in the most convenient format, for example,\n a ${isc.DocUtils.linkForRef('method:DataSource.transformRequest')} might translate AdvancedCriteria directly into\n a SQL-like language, or serialize to XML using ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')}.",
        attrs:[],
        name:"AdvancedCriteria",
        seeAlso:[],
        groups:["advancedFilter"]
    },
    "attr:StretchImgButton.title":{
        flags:"IRW",
        getter:["getTitle"],
        type:"attr",
        ref:"attr:StretchImgButton.title",
        description:"The text title to display in this button.",
        name:"title",
        setter:["setTitle"],
        valueType:"string",
        seeAlso:[],
        defaultValue:"varies",
        groups:["basics"],
        definingClass:"class:StretchImgButton"
    },
    "method:HTMLFlow.setContentsURL":{
        ref:"method:HTMLFlow.setContentsURL",
        flags:"",
        description:" Change the URL this component loads content from.  Triggers a fetch for content from the new\n URL.\n <p>\n Can also be called with no arguments to reload content from the existing ${isc.DocUtils.linkForRef('attr:HTMLFlow.contentsURL')}.\n <P>\n This feature relies on the XMLHttpRequest object which can be disabled by end-users in some\n supported browsers.  See ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information.\n\n",
        name:"setContentsURL",
        seeAlso:[],
        params:[
            {description:"URL to retrieve contents from", optional:true, name:"url", defaultValue:null,
             type:"URL"},
            {description:"Parameters to send to the contentsURL.  Merged with                            <code>component.contentsURLParams</code> if both are set.",
             optional:true, name:"params", defaultValue:null, type:"Object"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('loadHtmlPages')}"],
        definingClass:"class:HTMLFlow",
        groups:["contentLoading"]
    },
    "attr:ToolStripResizer.skinImgDir":{
        ref:"attr:ToolStripResizer.skinImgDir",
        flags:"IR",
        description:"Path to resizer image.",
        name:"skinImgDir",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"images/ToolStrip/\"",
        type:"attr",
        definingClass:"class:ToolStripResizer"
    },
    "attr:Canvas.scrollbarSize":{
        ref:"attr:Canvas.scrollbarSize",
        flags:"IRWA",
        getter:["getScrollbarSize"],
        description:"How thick should we make the scrollbars for this canvas.<br>\n			NOTE: has no effect if showCustomScrollbars is false.",
        name:"scrollbarSize",
        seeAlso:[
            {ref:"method:Canvas.getScrollbarSize", description:null}
        ],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["scrolling"]
    },
    "method:FormItem.setLeft":{
        ref:"method:FormItem.setLeft",
        flags:"A",
        description:" For a form with ${isc.DocUtils.linkForRef('attr:DynamicForm.itemLayout','itemLayout')}:\"absolute\" only, set the left\n coordinate of this form item.\n <P>\n Causes the form to redraw.\n",
        name:"setLeft",
        seeAlso:[],
        type:"method",
        definingClass:"class:FormItem"
    },
    "classAttr:Dialog.LOGIN_TITLE":{
        ref:"classAttr:Dialog.LOGIN_TITLE",
        flags:"IRW",
        description:"Default title for the dialog displayed by ${isc.DocUtils.linkForRef('classMethod:isc.showLoginDialog')}.\n A custom title can alternatively be specified as the <code>title</code> attribute of the \n <code>properties</code> parameter passed to that method.",
        name:"LOGIN_TITLE",
        seeAlso:[],
        valueType:"HTML",
        defaultValue:"\"Please log in\"",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:["i18nMessages"]
    },
    "classMethod:RPCManager.sendRequest":{
        ref:"classMethod:RPCManager.sendRequest",
        flags:"",
        description:"\n Send the passed <code>RPCRequest</code> to the server.  If queuing is in effect, this queues\n the request instead.\n\n",
        name:"sendRequest",
        seeAlso:[],
        params:[
            {description:"RPCRequest to send to the server", optional:false, name:"rpcRequest",
             defaultValue:null, type:"RPCRequest Properties"}
        ],
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "attr:Calendar.eventNameFieldTitle":{
        ref:"attr:Calendar.eventNameFieldTitle",
        flags:"IR",
        description:"The title for the event name field in the quick event dialog",
        name:"eventNameFieldTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Event Name\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["i18nMessages"]
    },
    "classMethod:RPCManager.loginRequired":{
        ref:"classMethod:RPCManager.loginRequired",
        flags:"",
        description:" Called when a session timeout is encountered while trying to do a background RPC.  See\n ${isc.DocUtils.linkForRef('group:relogin','Relogin')}.\n <P>\n The transaction with the passed <code>transactionId</code> is suspended, and should either\n be ${isc.DocUtils.linkForRef('classMethod:RPCManager.clearTransaction','cleared')} or ${isc.DocUtils.linkForRef('classMethod:RPCManager.resendTransaction','resent')}\n after the user has been re-authenticated.  \n <P>\n The <code>rpcRequest</code> parameter can be used to determine whether the suspended\n transaction can simply be dropped (eg, it's periodic polling request).\n <P>\n The <code>rpcResponse</code> parameter has rpcResponse.data set to the raw text of the\n response that triggered <code>loginRequired()</code>.  Some very advanced relogin strategies\n may need to inspect the raw response to get information needed for re-authentication.\n\n",
        name:"loginRequired",
        seeAlso:[],
        params:[
            {description:"id of the transaction", optional:false, name:"transactionNum",
             defaultValue:null, type:"id"},
            {description:"first RPCRequest of the transaction", optional:false, name:"rpcRequest",
             defaultValue:null, type:"RPCRequest"},
            {description:"RPCResponse containing the session timeout response that                                  caused loginRequired() to be invoked",
             optional:false, name:"rpcResponse", defaultValue:null, type:"RPCResponse"}
        ],
        type:"classMethod",
        definingClass:"class:RPCManager",
        groups:["relogin"]
    },
    "attr:ListGridField.inputFormat":{
        ref:"attr:ListGridField.inputFormat",
        flags:"IRWA",
        description:"For fields of type <code>\"date\"</code>, if this is an editable listGrid, this property \n allows you to specify the ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')} applied to the editor \n for this field.",
        name:"inputFormat",
        seeAlso:[
            {ref:"attr:ListGridField.displayFormat", description:null}
        ],
        valueType:"DateInputFormat",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "method:Canvas.keyPress":{
        ref:"method:Canvas.keyPress",
        flags:"A",
        description:"\n Executed when a key is pressed and released on a focusable widget (${isc.DocUtils.linkForRef('attr:Canvas.canFocus')}:\n true). \n <P>\n Use ${isc.DocUtils.linkForRef('classMethod:EventHandler.getKey')} to find out the ${isc.DocUtils.linkForRef('type:KeyName','keyName')} of the key that\n was pressed, and use ${isc.DocUtils.linkForRef('classMethod:EventHandler.shiftKeyDown')} and related functions to determine\n whether modifier keys were down.\n\n",
        name:"keyPress",
        seeAlso:[
            {ref:"attr:Canvas.canFocus", description:null}
        ],
        returns:{description:"false to suppress native behavior in response to the keyPress, and prevent                    this event from bubbling to this widget's parent, or true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('keyboardEvents')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:StatefulCanvas.setDisabled":{
        ref:"method:StatefulCanvas.setDisabled",
        flags:"A",
        description:" Enable or disable this object\n",
        name:"setDisabled",
        seeAlso:[],
        params:[
            {description:"true if this widget is to be disabled", optional:false, name:"disabled",
             defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:StatefulCanvas",
        groups:["enable", "state"]
    },
    "method:CubeGrid.facetLabelOut":{
        ref:"method:CubeGrid.facetLabelOut",
        flags:"",
        description:" StringMethod handler fired when mouseout occurs over a facet label\n\n",
        name:"facetLabelOut",
        seeAlso:[],
        params:[
            {description:"ID of the appropriate facet", optional:false, name:"facetId",
             defaultValue:null, type:"object"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["events"]
    },
    "attr:ColorPicker.colorButtonSize":{
        ref:"attr:ColorPicker.colorButtonSize",
        flags:"IR",
        description:"Width and height of the basic color boxes (they are always square, and they are\n all the same size).",
        name:"colorButtonSize",
        seeAlso:[],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "method:Selection.deselect":{
        ref:"method:Selection.deselect",
        flags:"",
        description:"			Deselect a particular item\n",
        name:"deselect",
        seeAlso:[],
        params:[
            {description:"object to select", optional:false, name:"item", defaultValue:null,
             type:"object"}
        ],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:Selection",
        groups:["selection"]
    },
    "attr:MenuButton.menuAnimationEffect":{
        ref:"attr:MenuButton.menuAnimationEffect",
        flags:"IRWA",
        description:"Allows you to specify an animation effect to apply to the menu when it is being shown.\n Valid options are \"none\" (no animation), \"fade\", \"slide\" and \"wipe\".\n If unspecified falls through to <code>menu.showAnimationEffect</code>",
        name:"menuAnimationEffect",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MenuButton"
    },
    "type:Selected":{
        ref:"type:Selected",
        values:[
            {description:"StatefulCanvas should show focused state", value:"StatefulCanvas.FOCUSED"},
            {description:"StatefulCanvas is selected", value:"StatefulCanvas.SELECTED"},
            {description:"StatefulCanvas is not selected", value:"StatefulCanvas.UNSELECTED"}
        ],
        description:null,
        name:"Selected",
        seeAlso:[],
        type:"type",
        groups:["state"]
    },
    "attr:DateChooser.alternateStyleSuffix":{
        ref:"attr:DateChooser.alternateStyleSuffix",
        flags:"IRW",
        description:"The text appended to the style name when using ${isc.DocUtils.linkForRef('attr:DateChooser.alternateWeekStyles')}.",
        name:"alternateStyleSuffix",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Dark\"",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:FormItem.focusInItem":{
        ref:"method:FormItem.focusInItem",
        flags:"",
        description:"			Move the keyboard focus into this item's focusable element\n",
        name:"focusInItem",
        seeAlso:[],
        type:"method",
        definingClass:"class:FormItem",
        groups:["eventHandling", "focus"]
    },
    "method:ListGrid.getRecord":{
        ref:"method:ListGrid.getRecord",
        flags:"A",
        description:" Return the pointer to a particular record by record number.\n Synonym for ${isc.DocUtils.linkForRef('method:ListGrid.getCellRecord')}.\n\n",
        name:"getRecord",
        seeAlso:[
            {ref:"method:ListGrid.getCellRecord", description:null},
            {ref:"method:ListGrid.getEditedRecord", description:null}
        ],
        params:[
            {description:"row index of record to return.", optional:false, name:"recordNum",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"Record object for the row.", type:"ListGridRecord"},
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Class.observe":{
        ref:"method:Class.observe",
        flags:"",
        description:" Take an arbitrary action whenever a method is called on an instance.<br><br>\n\n When you observe some method of another object, eg:<br>\n			<code>thisObject.observe(thatObject, \"someMethod\", \"observer.foo()\")</code><br><br>\n\n When <code>thatObject.someMethod()</code> is called,<br>\n			<code>thisObject.foo()</code> <br>\n will be called automatically, after the observed method completes.<br><br>\n\n Action is typically a string expression.  Available variables:\n <ul>\n    <li> observed: target of the observation, that is, object passed to observe()\n    <li> observer: object that observes, that is, object that observe() was called on\n    <li> returnVal: return value of observed function\n </ul>\n\n An unlimited number of observers can observe any message, they will all be notified\n automatically in the order that the observations were set up.<br><br>\n\n NOTES: \n - observation also works on JavaScript Array objects\n - a method may trigger an observation of itself by another object, either through code \n   within the method itself or within an observer's action.  In this case the observation\n   will be set up, but the new observation action will not fire as part of this thread.\n   When the method is called again in the future the newly added observer will be fired.\n\n\n",
        name:"observe",
        seeAlso:[
            {ref:"method:Class.ignore", description:null}
        ],
        params:[
            {description:"object to observe", optional:false, name:"object", defaultValue:null,
             type:"object"},
            {description:"name of the method to observe", optional:false, name:"methodName",
             defaultValue:null, type:"string"},
            {description:"String for the function to call.										In this string, \n											<code>observer</code> is the object that is observing, \n											<code>this</code> is the object that is being observed\n\n										If <code>action</code> is not specified, \n											<code>observer.methodName()</code> will be called.",
             optional:true, name:"action", defaultValue:null, type:"string"}
        ],
        returns:{description:"true == observation set up, false == observation not set up", type:"boolean"},
        type:"method",
        definingClass:"class:Class",
        groups:["observation"]
    },
    "attr:Window.closeButton":{
        ref:"attr:Window.closeButton",
        flags:"R",
        description:"Button show in the header that will close this Window by calling ${isc.DocUtils.linkForRef('method:Window.closeClick')}.",
        name:"closeButton",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window"
    },
    "attr:TabSet.rightEdgeOffsets":{
        ref:"attr:TabSet.rightEdgeOffsets",
        flags:"IR",
        description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n and ${isc.DocUtils.linkForRef('attr:TabSet.symmetricEdges')} is set to false, the <code>leftEdgeOffsets</code>, \n <code>rightEdgeOffsets</code>, <code>topEdgeOffsets</code> and <code>bottomEdgeOffsets</code> \n propertes allow the offsets of edges for the paneContainer to be customized depending on\n the ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.\n <P>\n The attribute should be specified an ${isc.DocUtils.linkForRef('type:EdgeSizes','edgeSizes map')}, specifying the\n desired edge offsets where for the appropriate ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.",
        name:"rightEdgeOffsets",
        seeAlso:[],
        valueType:"EdgeSizes",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "attr:ListGrid.canPickFields":{
        ref:"attr:ListGrid.canPickFields",
        flags:"IRW",
        description:"Indicates whether the field picker item and submenu should be present in the header\n context menu",
        name:"canPickFields",
        seeAlso:[],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["sorting"]
    },
    "attr:DataBoundComponent.useAllDataSourceFields":{
        ref:"attr:DataBoundComponent.useAllDataSourceFields",
        flags:"IRW",
        description:"If true, the set of fields given by the \"default binding\" (see \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}) is used, with any fields specified in\n <code>component.fields</code> acting as overrides that can suppress or modify the\n display of individual fields, without having to list the entire set of fields that\n should be shown.\n <P>\n If <code>component.fields</code> contains fields that are not found in the DataSource,\n they will be shown after the most recently referred to DataSource field.  If the new\n fields appear first, they will be shown first.\n <P>\n ${isc.DocUtils.linkForExampleId('validationFieldBinding', 'This example')} shows a mixture of component\n fields and DataSource fields, and how they interact for validation.",
        name:"useAllDataSourceFields",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('validationFieldBinding')}"],
        definingClass:"interface:DataBoundComponent",
        groups:["databinding"]
    },
    "attr:Canvas.snapAxis":{
        ref:"attr:Canvas.snapAxis",
        flags:"IRW",
        description:"Describes which axes to apply snap-to-grid to.\n Valid values are Canvas.HORIZONTAL, Canvas.VERTICAL and Canvas.BOTH",
        name:"snapAxis",
        seeAlso:[
            {ref:"attr:Canvas.snapToGrid", description:null},
            {ref:"attr:Canvas.snapResizeToGrid", description:null},
            {ref:"attr:Canvas.childrenSnapToGrid", description:null},
            {ref:"attr:Canvas.childrenSnapResizeToGrid", description:null}
        ],
        valueType:"string",
        defaultValue:"Canvas.BOTH",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "method:Toolbar.addButtons":{
        ref:"method:Toolbar.addButtons",
        flags:"",
        description:" Add a list of buttons to the toolbar\n",
        name:"addButtons",
        seeAlso:[],
        params:[
            {description:"list of button object initializers.", optional:true, name:"buttons",
             defaultValue:null, type:"Array of objects"},
            {description:"position to add the new buttons at", optional:true, name:"position",
             defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:Toolbar"
    },
    "attr:TabSet.showPartialEdges":{
        ref:"attr:TabSet.showPartialEdges",
        flags:"IRA",
        description:"If the paneContainer for this tab set is showing ${isc.DocUtils.linkForRef('attr:Canvas.showEdges','edges')}, setting this\n attribute to <code>true</code> will set the paneContainer to show\n ${isc.DocUtils.linkForRef('attr:Canvas.customEdges','customEdges')} for the three sides opposing the tabBarPosition.",
        name:"showPartialEdges",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "method:Canvas.setClassName":{
        ref:"method:Canvas.setClassName",
        deprecated:"As of SmartClient version 5.5, use ${isc.DocUtils.linkForRef('method:Canvas.setStyleName')} instead.",
        flags:"A",
        description:" Sets the CSS class for this widget\n",
        name:"setClassName",
        seeAlso:[],
        params:[
            {description:"new CSS class name (must be defined previously)", optional:false,
             name:"newClass", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["appearance"]
    },
    "attr:TabSet.scrollerHSrc":{
        ref:"attr:TabSet.scrollerHSrc",
        flags:"IR",
        description:"If this TabSet is showing ${isc.DocUtils.linkForRef('attr:TabSet.showTabScroller','tab scroller buttons')}, and \n ${isc.DocUtils.linkForRef('attr:TabSet.symmetricScroller','symmetricScroller')} is true, this property governs the base\n URL for the tab bar back and forward scroller button images for horizontal tab bars [IE for\n tab sets with ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition','tabBarPosition')} set to \"top\" or \"bottom\"].\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:TabSet.symmetricScroller','symmetricScroller')} is false, \n ${isc.DocUtils.linkForRef('attr:TabSet.scrollerSrc')} will be used instead.\n <P>\n To get the path to the image to display, this base URL will be modified as follows:\n <ul>\n <li>If appropriate a state suffix of <code>\"Down\"</code> or <code>\"Disabled\"</code> will be\n     appended.</li>\n <li>A suffix of <code>\"forward\"</code> or <code>\"back\"</code> will be appended for the\n     forward or backward scrolling button.</li>\n </ul>\n For example - if the scrollerHSrc is set to <code>\"[SKIN]hscroll.gif\"</code>, the image\n displayed for the back-scroller button on a tabSet with <code>tabBarPosition</code> set to\n \"top\" and <code>symmetricScroller</code> set to true would be one of \n <code>\"[SKIN]hscroll_back.gif\"</code>, <code>\"[SKIN]hscroll_Down_back.gif\"</code>,\n and <code>\"[SKIN]hscroll_Disabled_back.gif\"</code>.\n <P>\n Note that for best results the media should be sized to match the scroller button sizes, \n determined by ${isc.DocUtils.linkForRef('attr:TabSet.tabBarThickness')} and ${isc.DocUtils.linkForRef('attr:TabSet.scrollerButtonSize')}.",
        name:"scrollerHSrc",
        seeAlso:[
            {ref:"attr:TabSet.symmetricScroller", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]hscroll.gif\"",
        type:"attr",
        definingClass:"class:TabSet",
        groups:["tabBarScrolling"]
    },
    "group:dynamicLoading":{
        ref:"group:dynamicLoading",
        refs:[],
        name:"dynamicLoading",
        seeAlso:[],
        type:"group"
    },
    "attr:MenuButton.showMenuBelow":{
        ref:"attr:MenuButton.showMenuBelow",
        flags:"IRW",
        description:"The menu drops down below the menu button.\n			Set to false if the menu should appear above the menu button.",
        name:"showMenuBelow",
        setter:["setShowMenuBelow"],
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:MenuButton"
    },
    "attr:TextAreaItem.width":{
        ref:"attr:TextAreaItem.width",
        flags:"IRW",
        description:"default width of this item",
        name:"width",
        seeAlso:[],
        valueType:"number",
        defaultValue:"150",
        type:"attr",
        definingClass:"class:TextAreaItem",
        groups:["appearance"]
    },
    "attr:RestDataSource.xmlRecordXPath":{
        ref:"attr:RestDataSource.xmlRecordXPath",
        flags:"IR",
        description:"<code>recordXPath</code> mapping to the data node of XML returned by the server.\n Applies if this.dataFormat is set to <code>\"xml\"</code>.<br>\n The default value will pick up data from a response structured as follows:<br>\n <pre>\n &lt;response&gt;\n    &lt;status&gt;0&lt;/status&gt;\n    &lt;data&gt;\n      &lt;record&gt;\n          &lt;field1&gt;value&lt;/field1&gt;\n          &lt;field2&gt;value&lt;/field2&gt;\n      &lt;/record&gt;\n      &lt;record&gt;\n          &lt;field1&gt;value&lt;/field1&gt;\n          &lt;field2&gt;value&lt;/field2&gt;\n      &lt;/record&gt;\n    &lt;/data&gt;\n &lt;/response&gt;\n </pre>",
        name:"xmlRecordXPath",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"/response/data/*\"",
        type:"attr",
        definingClass:"class:RestDataSource"
    },
    "attr:DynamicForm.titleOrientation":{
        flags:"IRW",
        getter:["getTitleOrientation"],
        type:"attr",
        ref:"attr:DynamicForm.titleOrientation",
        description:"Default orientation for titles for items in this form.  ${isc.DocUtils.linkForRef('type:TitleOrientation')}\n lists valid options.\n <P>\n Note that titles on the left or right take up a cell in tabular\n ${isc.DocUtils.linkForRef('group:formLayout','form layouts')}, but titles on top do not.",
        name:"titleOrientation",
        valueType:"TitleOrientation",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('formLayoutTitles')}"],
        defaultValue:"\"left\"",
        groups:["formTitles"],
        definingClass:"class:DynamicForm"
    },
    "class:ComboBoxItem":{
        methods:["method:ComboBoxItem.defaultDynamicValue", "method:ComboBoxItem.fetchData", 
         "method:ComboBoxItem.getDisplayFieldName","method:ComboBoxItem.getValueFieldName", "method:ComboBoxItem.getSelectedRecord", 
         "method:ComboBoxItem.getPickListFilterCriteria","method:ComboBoxItem.getClientPickListData", 
         "method:ComboBoxItem.filterClientPickListData","method:ComboBoxItem.dataArrived"],
        type:"class",
        ref:"class:ComboBoxItem",
        classAttrs:[],
        treeLocation:["Client Reference/Forms/Form Items"],
        classMethods:[],
        description:"The Combobox is a text input field which can show a list of options via a drop-down\n PickList.\n <p>\n The set of options will be filtered based on the current value in the text field, so only\n options that match what has been typed so far will be displayed.\n The set of options can be derived from a ValueMap or dynamically retrieved from a\n dataSource.  See the ${isc.DocUtils.linkForRef('interface:PickList')} interface for further settings.\n <P>\n Note that to select the first option as a default value for the item,\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.defaultToFirstOption')} may be set.",
        attrs:["attr:ComboBoxItem.defaultValue", "attr:ComboBoxItem.defaultToFirstOption", 
         "attr:ComboBoxItem.showPickerIcon","attr:ComboBoxItem.pickerIconWidth", "attr:ComboBoxItem.pickerIconHeight", 
         "attr:ComboBoxItem.pickerIconSrc","attr:ComboBoxItem.showPickListOnKeypress", "attr:ComboBoxItem.completeOnTab", 
         "attr:ComboBoxItem.optionDataSource","attr:ComboBoxItem.pickListFields", "attr:ComboBoxItem.optionFilterContext", 
         "attr:ComboBoxItem.displayField","attr:ComboBoxItem.valueField", "attr:ComboBoxItem.filterLocally", 
         "attr:ComboBoxItem.pickListCriteria","attr:ComboBoxItem.showOptionsFromDataSource", "attr:ComboBoxItem.pickListProperties", 
         "attr:ComboBoxItem.autoFetchData","attr:ComboBoxItem.filterWithValue", "attr:ComboBoxItem.textMatchStyle", 
         "attr:ComboBoxItem.showAllOptions","attr:ComboBoxItem.separatorRows"],
        implementsInterfaces:["PickList"],
        name:"ComboBoxItem",
        seeAlso:[
            {ref:"interface:PickList", description:null}
        ],
        examples:["${isc.DocUtils.linkForExampleId('listComboBox')}", 
         "${isc.DocUtils.linkForExampleId('listComboBox')}"]
    },
    "attr:TabSet.paneContainerClassName":{
        ref:"attr:TabSet.paneContainerClassName",
        flags:"IRW",
        description:"CSS style used for the paneContainer.",
        name:"paneContainerClassName",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "type:DragIntersectStyle":{
        ref:"type:DragIntersectStyle",
        values:[
            {description:"Look for drop targets that are under the current mouse cursor position.",
             value:"\"mouse\""},
            {description:"Look for drop targets by intersection of the entire rect of the drag               target with the droppable target.",
             value:"\"rect\""}
        ],
        description:"Different styles of determining intersection: with mouse or entire rect of target",
        name:"DragIntersectStyle",
        seeAlso:[],
        type:"type",
        groups:["dragdrop"]
    },
    "attr:CubeGrid.canSortFacets":{
        ref:"attr:CubeGrid.canSortFacets",
        flags:"IRW",
        description:"If true, sort controls will be shown on FacetHeaders.\n <P>\n When clicked, sort controls call ${isc.DocUtils.linkForRef('method:CubeGrid.sortByFacetId')}.",
        name:"canSortFacets",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "group:enable":{
        ref:"group:enable",
        title:"Enabling and Disabling",
        refs:["method:StatefulCanvas.setDisabled", "method:Button.setDisabled", 
         "method:ImgButton.setDisabled","method:StretchImgButton.setDisabled", "method:FormItem.setDisabled", 
         "method:FormItem.isDisabled","method:FormItem.enable", "method:FormItem.disable", "method:Canvas.setEnabled", 
         "method:Canvas.setDisabled","method:Canvas.enable", "method:Canvas.disable", "method:Canvas.isDisabled", 
         "method:Canvas.isEnabled","attr:Canvas.disabled", "attr:Canvas.enabled"],
        description:"Disabled components do not respond to mouse or keyboard events, and change appearance to\n indicate they are disabled.",
        name:"enable",
        seeAlso:[],
        type:"group"
    },
    "method:CubeGrid.hiliteCell":{
        ref:"method:CubeGrid.hiliteCell",
        flags:"",
        description:"\n      apply a hilite to a specific cell.\n      Note: can be called either as \n          hiliteCell(cellObject, hiliteID) or \n          hiliteCell(row, column, hiliteID)\n\n      <br><i>methodType</i> action\n",
        name:"hiliteCell",
        seeAlso:[],
        params:[
            {description:"cell to hilite / row of cell to hilite", optional:false, name:"cellObj",
             defaultValue:null, type:"cell object | row number"},
            {description:"hilite ID / column of cell to hilite", optional:false, name:"hiliteID",
             defaultValue:null, type:"string | column number"},
            {description:"optional third parameter - hilite ID.", optional:true, name:"",
             defaultValue:null, type:"string"}
        ],
        returns:{description:"true if the cell was successfully hilited.", type:"boolean"},
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["hiliting"]
    },
    "method:ComboBoxItem.getPickListFilterCriteria":{
        ref:"method:ComboBoxItem.getPickListFilterCriteria",
        flags:"A",
        description:" Returns filter criteria for options displayed for this item.  \n <P>\n The criteria returned by this method are used to decide which options should appear in\n the drop-down ${isc.DocUtils.linkForRef('interface:PickList')} shown by this ComboBox.\n <P>\n While the user is typing in a value, this method will return the typed-in value as part\n of the criteria, so that only matching values are shown.  Matching is determined by the\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.textMatchStyle','textMatchStyle')}.  \n <P>\n If the user explicitly shows the down-down pickList, via either clicking on the drop\n down icon or use the <i>Ctrl+Arrow Down</i> key combo, the typed in value is ignored for\n filtering.\n <P>\n If included in the criteria, the typed in value will be included as a value for the \n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.displayField','displayField')} (or for the\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.valueField','valueField')} if <code>this.displayField</code> is\n unspecified).\n <P>\n Static criteria, specified via ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListCriteria','pickListCriteria')},\n will always be included.\n <P>\n If you are implementing your own <code>getPickListFilterCriteria()</code> the\n <b>read-only</b> property ${isc.DocUtils.linkForRef('attr:ComboBoxItem.filterWithValue','this.filterWithValue')} can\n be read to determine whether the ComboBox would ordinarily ignore the typed-in value for\n filtering.  Note that in addition to cases where the user explicitly shows the pickList,\n <code>filterWithValue</code> will also be <code>true</code> during a call to \n ${isc.DocUtils.linkForRef('method:ComboBoxItem.fetchData')} on a databound comboBox.\n    \n",
        name:"getPickListFilterCriteria",
        seeAlso:[],
        returns:{description:"criteria to be used for databound or local filtering", type:"Criteria"},
        type:"method",
        definingClass:"class:ComboBoxItem"
    },
    "method:GridRenderer.rowDoubleClick":{
        ref:"method:GridRenderer.rowDoubleClick",
        flags:"A",
        description:" Called when a row receives a double click event.\n\n",
        name:"rowDoubleClick",
        seeAlso:[],
        params:[
            {description:"Record object returned from getCellRecord()", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "attr:OperationBinding.spoofResponses":{
        ref:"attr:OperationBinding.spoofResponses",
        flags:"IR",
        description:"For a DataSource contacting a ${isc.DocUtils.linkForRef('attr:DataSource.serviceNamespace','WSDL web service')}, setting\n this flag means the DataSource doesn't actually attempt to contact the server but generates\n a sample response instead, based on the XML Schema of the response message embedded in the\n WSDL.\n <P>\n The spoofed response will include all complexType elements and will fill in appropriate\n values by type for all simpleType elements, although the spoofed data will not conform to\n all xs:restriction declarations (eg xs:pattern).\n <P>\n Note that if your WSDL does not fully describe the response format (some WSDL services just\n have a placeholder &lt;xs:any&gt; element), SmartClient can only produce a partial\n response.  To use a hand-generated sample response, just save an XML file to disk and use\n the ${isc.DocUtils.linkForRef('attr:OperationBinding.dataURL')} setting to point to it.",
        name:"spoofResponses",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:["clientDataIntegration"]
    },
    "attr:CanvasItem.canvas":{
        ref:"attr:CanvasItem.canvas",
        flags:"IRW",
        description:"The canvas that will be displayed inside this item.  You can pass an instance you've \n already created, or its global ID as a String.  If none is passed, one will be \n auto-created using the overrideable defaults: ${isc.DocUtils.linkForRef('attr:CanvasItem.canvasProperties')} and\n ${isc.DocUtils.linkForRef('attr:CanvasItem.canvasConstructor')}",
        name:"canvas",
        seeAlso:[],
        valueType:"Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CanvasItem"
    },
    "method:TileLayout.setTileVMargin":{
        ref:"method:TileLayout.setTileVMargin",
        flags:"",
        description:" sets the width of tiles\n",
        name:"setTileVMargin",
        seeAlso:[],
        params:[
            {description:"width", optional:false, name:"", defaultValue:null, type:"Integer"}
        ],
        type:"method",
        definingClass:"class:TileLayout",
        groups:["tileLayout"]
    },
    "attr:DataSource.testData":{
        ref:"attr:DataSource.testData",
        flags:"IRW",
        description:"For a client-only DataSource, a set of records to use as a dataset, specified as an\n Array of JavaScript Objects.\n <P>\n See ${isc.DocUtils.linkForRef('group:clientOnlyDataSources','this discussion')} for ways to populate a\n client-only DataSource with test data.",
        name:"testData",
        seeAlso:[
            {ref:"attr:DataSource.clientOnly", description:null}
        ],
        valueType:"Array of Object",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('localDataSource')}"],
        definingClass:"class:DataSource",
        groups:["clientOnlyDataSources"]
    },
    "type:ControlName":{
        ref:"type:ControlName",
        values:[
            {description:"A button to make the current selection bold.", value:"\"boldSelection\""},
            {description:"A button to make the current selection italic.",
             value:"\"italicSelection\""},
            {description:"A button to make the current selection underlined.",
             value:"\"underlineSelection\""},
            {description:"A select item allowing the user to change the font of the current                     text selection.",
             value:"\"fontSelector\""},
            {description:"A select item allowing the user to change the font                       size of the current text selection.",
             value:"\"fontSizeSelector\""},
            {description:"A button to left-align the selected text.", value:"\"alignLeft\""},
            {description:"A button to right-align the selected text.", value:"\"alignRight\""},
            {description:"A button to center the selected text", value:"\"alignCenter\""},
            {description:"A button to justify the selected line of text.", value:"\"justify\""},
            {description:"A color-picker allowing the user to set the text color", value:"\"color\""},
            {description:"A color picker allowing the user to set the text background  color",
             value:"\"backgroundColor\""}
        ],
        description:"<code>ControlNames</code> are strings used to specify which UI controls should appear\n  in the editor toolbar.<br>",
        name:"ControlName",
        seeAlso:[],
        type:"type"
    },
    "attr:ListGrid.editOnFocus":{
        ref:"attr:ListGrid.editOnFocus",
        flags:"IRWA",
        description:"Should we start editing when this widget recieves focus (if this ListGrid supports\n editing)?\n <P>\n Note that this property being set to true will cause editing to occur on a single\n click, even if ${isc.DocUtils.linkForRef('attr:ListGrid.editEvent')} is <code>\"doubleClick\"</code>, because single clicking\n the grid will place keyboard focus there automatically.",
        name:"editOnFocus",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "method:Canvas.mouseMove":{
        ref:"method:Canvas.mouseMove",
        flags:"A",
        description:"\n Executed when the mouse moves within this widget.  No default implementation.\n\n",
        name:"mouseMove",
        seeAlso:[
            {ref:"method:Canvas.getOffsetX", description:null},
            {ref:"method:Canvas.getOffsetY", description:null}
        ],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('customMouseEvents')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:TabSet.setTabPane":{
        ref:"method:TabSet.setTabPane",
        flags:"",
        description:" Apply a new ${isc.DocUtils.linkForRef('attr:Tab.pane','pane')} to an existing tab in this tabSet\n",
        name:"setTabPane",
        seeAlso:[],
        params:[
            {description:"Tab to update (may be referenced by ID or index)", optional:false,
             name:"tab", defaultValue:null, type:"number | string | Tab"},
            {description:"new Pane for the tab", optional:false, name:"pane", defaultValue:null,
             type:"Canvas"}
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "attr:DataBoundComponent.dataFetchMode":{
        ref:"attr:DataBoundComponent.dataFetchMode",
        flags:"IRW",
        description:"How to fetch and manage records retrieve from the server.  See ${isc.DocUtils.linkForRef('type:FetchMode')}.\n <P>\n This setting only applies to the ${isc.DocUtils.linkForRef('class:ResultSet')} automatically created by calling\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.fetchData')}.  If a pre-existing ResultSet is passed to setData() instead, it's\n existing setting for ${isc.DocUtils.linkForRef('attr:ResultSet.fetchMode')} applies.",
        name:"dataFetchMode",
        seeAlso:[],
        valueType:"FetchMode",
        defaultValue:"\"paged\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["databinding"]
    },
    "method:TileGrid.deselectRecords":{
        ref:"method:TileGrid.deselectRecords",
        flags:"",
        description:"\n Deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n <P>\n Synonym for <code>selectRecords(records, false)</code>\n\n",
        name:"deselectRecords",
        seeAlso:[],
        params:[
            {description:"records (or row numbers) to deselect", optional:false, name:"records",
             defaultValue:null, type:"Array of Record | numbers"}
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:["selection"]
    },
    "attr:Scrollbar.showCorner":{
        ref:"attr:Scrollbar.showCorner",
        flags:"IRA",
        description:"If true, displays a corner piece at the bottom end of a vertical scrollbar, or the\n right end of a horizontal scrollbar. This is typically set only when both horizontal\n and vertical scrollbars are displayed and about the same corner.",
        name:"showCorner",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:["corner"]
    },
    "class:LayoutSpacer":{
        methods:[],
        ref:"class:LayoutSpacer",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Layout"],
        attrs:[],
        description:"Add a LayoutSpacer to a Layout to take up space just like a normal member, without actually\n drawing anything.  Semantically equivalent to using an empty canvas, but higher performance\n for this particular use case.",
        name:"LayoutSpacer",
        seeAlso:[],
        type:"class"
    },
    "method:ValuesManager.rememberValues":{
        ref:"method:ValuesManager.rememberValues",
        flags:"A",
        description:"			Make a snapshot of the current set of values, so we can reset to them later.\n			Creates a new object, then adds all non-method properties of values\n			to the new object.  Use <code>resetValues()</code> to revert to these values.\n          Note that this method is automatically called when the values for this form are\n          set programmatically via a call to ${isc.DocUtils.linkForRef('method:DynamicForm.setValues')}.\n\n",
        name:"rememberValues",
        seeAlso:[],
        returns:{description:"copy of current form values", type:"object"},
        type:"method",
        definingClass:"class:ValuesManager",
        groups:["formValues"]
    },
    "attr:Window.bodyConstructor":{
        ref:"attr:Window.bodyConstructor",
        flags:"IRWA",
        description:"The name of the widget class (as a string) to use for the body. If unset the appropriate\n constructor type will be determined as follows:<br>\n - if ${isc.DocUtils.linkForRef('attr:Window.items')} is defined as an array of widgets, and ${isc.DocUtils.linkForRef('attr:Window.contentLayout')} \n   is not set to <code>\"none\"</code>, bodyConstructor defaults to a ${isc.DocUtils.linkForRef('class:VLayout')}<br>\n - if ${isc.DocUtils.linkForRef('attr:Window.src')} is set, bodyConstructor defaults to an ${isc.DocUtils.linkForRef('class:HTMLFlow')}<br>\n - otherwise bodyConstructor will default to a simple ${isc.DocUtils.linkForRef('class:Canvas')}<br>\n Note that if this property is overridden for some window, the specified constructor \n should be a subclass of one of these defaults to ensure the window renders out as \n expected.",
        name:"bodyConstructor",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "body"]
    },
    "attr:Operator.ID":{
        ref:"attr:Operator.ID",
        flags:"IR",
        description:"Unique id for operator, which appears within ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} as the\n ${isc.DocUtils.linkForRef('object:Operator')} property.\n <P>\n A list of built-in identifiers is ${isc.DocUtils.linkForRef('type:OperatorId','here')}.",
        name:"ID",
        seeAlso:[],
        valueType:"OperatorId",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Operator",
        groups:["advancedFilter"]
    },
    "attr:Menu.autoDraw":{
        ref:"attr:Menu.autoDraw",
        flags:"IRWA",
        description:"Menus will not draw on initialization, until they're explicitly show()n",
        name:"autoDraw",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Menu"
    },
    "type:LogicalOperator":{
        ref:"type:LogicalOperator",
        values:[
            {description:"true if all criteria are true", value:"\"and\""},
            {description:"true if any criteria are true", value:"\"or\""},
            {description:"true if all criteria are false", value:"\"not\""}
        ],
        description:"Operators that can evaluate a set of criteria and produce a combined result.",
        name:"LogicalOperator",
        seeAlso:[],
        type:"type"
    },
    "attr:TreeGrid.data":{
        ref:"attr:TreeGrid.data",
        flags:"IRW",
        description:"A ${isc.DocUtils.linkForRef('class:Tree')} object containing of nested ${isc.DocUtils.linkForRef('object:TreeNode')}s to \n display as rows in this TreeGrid.  \n The <code>data</code> property will typically not be explicitly specified for \n databound TreeGrids, where the data is returned from the server via databound component\n methods such as <code>fetchData()</code>",
        name:"data",
        setter:["setData"],
        seeAlso:[],
        valueType:"Tree",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["data"]
    },
    "class:SimpleTile":{
        methods:["method:SimpleTile.getInnerHTML", "method:SimpleTile.getRecord"],
        ref:"class:SimpleTile",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Grids/TileGrid"],
        attrs:["attr:SimpleTile.baseStyle", "attr:SimpleTile.creator"],
        description:"Default class used by a ${isc.DocUtils.linkForRef('class:TileGrid')} to render each tile.  See ${isc.DocUtils.linkForRef('attr:TileGrid.tile')}.\n <P>\n SimpleTiles should not be created directly, instead, use a TileGrid and provide data and\n SimpleTile instances are created for you.",
        name:"SimpleTile",
        seeAlso:[],
        type:"class"
    },
    "group:errorIcon":{
        ref:"group:errorIcon",
        refs:["attr:FormItem.errorIconHeight", "attr:FormItem.errorIconWidth", 
         "attr:FormItem.errorIconSrc","attr:FormItem.showErrorIcon"],
        name:"errorIcon",
        seeAlso:[],
        type:"group"
    },
    "method:ListGrid.chartData":{
        ref:"method:ListGrid.chartData",
        flags:"",
        description:" Chart the data in this listGrid as a multi-series chart.\n <P>\n Each row provides a series of data.  Each series of data is labelled by a value from one\n column, called the <code>labelField</code>.  \n <P>\n For example, cell values are sales figures, and fields are \"Product\", \"August\",\n \"September\", \"October\".  In this case each row gives a series: sales figures for each of 3\n months.  The <code>labelField</code> in this case is the \"Product\" field, meaning each row\n represents sales figures for each of 3 months for a particular product.  This dataset\n can be charted via any multi-series chart: stacked or clustered bar or column chart, line\n chart with multiple lines, or area chart (stacked lines).\n <P>\n By default, all visible fields other than the label field are assumed to be labels for\n series values, but an explicit list of fields can be provided as <code>dataFields</code>.\n <P>\n By default, all data is charted if all data is loaded, otherwise, data visible in the\n viewport is charted.  An explicit set of rows can be provided via <code>dataRows</code>.\n \n",
        name:"chartData",
        seeAlso:[],
        params:[
            {description:"name of the field", optional:false, name:"labelField", defaultValue:null,
             type:"String"},
            {description:"optional list of fields to use as labels.  By      default, all fields are used.",
             optional:true, name:"dataFields", defaultValue:null, type:"Array of String"},
            {description:"set of records to chart.  Can be obtained by eg      ${isc.DocUtils.linkForRef('method:ResultSet.getRange','grid.data.getRange()')}.",
             optional:true, name:"dataRows", defaultValue:null, type:"Array of ListGridRecord"},
            {description:"properties to pass to the created chart", optional:true,
             name:"chartProperties", defaultValue:null, type:"Chart Properties"},
            {description:"if true, use the labelField as the \"first\" set of labels,      for example, as the bar labels in a stacked bar chart, whereas the second set of labels\n      would appear as the legend.",
             optional:true, name:"labelFieldFirst", defaultValue:null, type:"boolean"}
        ],
        returns:{description:"created Chart instance", type:"Chart"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('gridCharting')}"],
        definingClass:"class:ListGrid"
    },
    "attr:FormItem.hint":{
        flags:"IRW",
        type:"attr",
        ref:"attr:FormItem.hint",
        description:"Specifies \"hint\" string to show next to the form item to indicate something to the user.\n This string generally appears to the right of the form item.",
        name:"hint",
        setter:["setHint"],
        valueType:"String",
        seeAlso:[
            {ref:"attr:FormItem.hintStyle", description:null}
        ],
        examples:["${isc.DocUtils.linkForExampleId('formHints')}"],
        defaultValue:"null",
        groups:["appearance"],
        definingClass:"class:FormItem"
    },
    "attr:FormItem.top":{
        ref:"attr:FormItem.top",
        flags:"IRWA",
        description:"Top coordinate of this item in pixels.  Applies only when the containing DynamicForm\n sets <code>itemLayout:\"absolute\"</code>.",
        name:"top",
        setter:["setTop"],
        seeAlso:[],
        valueType:"integer",
        defaultValue:"0",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "attr:DateChooser.showCancelButton":{
        ref:"attr:DateChooser.showCancelButton",
        flags:"IRW",
        description:"Determines whether the \"Cancel\" button will be displayed.",
        name:"showCancelButton",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:SectionStack.itemEndIndent":{
        ref:"attr:SectionStack.itemEndIndent",
        flags:"IRW",
        description:"Size, in pixels, of indentation of all member items relative to the end of\n the alignment axis. For instance, for left-aligned members, \n itemStartIndent specifies indentation for every item from the right side of the\n section stack.",
        name:"itemEndIndent",
        seeAlso:[],
        valueType:"Number",
        defaultValue:"undefined",
        type:"attr",
        definingClass:"class:SectionStack",
        groups:["layoutMember"]
    },
    "method:List.addList":{
        ref:"method:List.addList",
        flags:"",
        description:" Add a list of items to this array.\n <P>\n Note: you can specify that a subset range be added by passing start and end indices\n\n",
        name:"addList",
        seeAlso:[],
        params:[
            {description:"list of items to add", optional:false, name:"list", defaultValue:null,
             type:"array"},
            {description:"optional start index in list", optional:true, name:"listStartRow",
             defaultValue:null, type:"number"},
            {description:"optional end index in list (non-inclusive)", optional:true,
             name:"listEndRow", defaultValue:null, type:"number"}
        ],
        returns:{description:"list of items that were added", type:"list"},
        type:"method",
        definingClass:"interface:List",
        groups:["modification"]
    },
    "method:Canvas.showNextTo":{
        ref:"method:Canvas.showNextTo",
        flags:"",
        description:" Show this widget next to another widget.\n",
        name:"showNextTo",
        seeAlso:[],
        params:[
            {description:"Canvas to show next to", optional:false, name:"otherWidget",
             defaultValue:null, type:"Canvas"},
            {description:"which side to show on, defaults to \"right\"", optional:true, name:"side",
             defaultValue:null, type:"String"}
        ],
        type:"method",
        definingClass:"class:Canvas"
    },
    "classMethod:Page.isRTL":{
        ref:"classMethod:Page.isRTL",
        flags:"",
        description:"\n Return whether the page text direction is right to left.  If you set \"DIR=RTL\" in the BODY tag of\n the page, then this method will return true.  If you set \"DIR=LTR\" then this method will return\n false.\n    \n",
        name:"isRTL",
        seeAlso:[],
        returns:{description:"true if Page text direction is RTL, false otherwise", type:"boolean"},
        type:"classMethod",
        definingClass:"class:Page"
    },
    "method:TreeGrid.dataArrived":{
        ref:"method:TreeGrid.dataArrived",
        flags:"",
        description:" Notification method fired whenever this TreeGrid recieves new data nodes from the \n dataSource. Only applies to databound TreeGrids where ${isc.DocUtils.linkForRef('attr:TreeGrid.data')} is a \n ${isc.DocUtils.linkForRef('class:ResultTree')} - either explicitly created and applied via ${isc.DocUtils.linkForRef('method:TreeGrid.setData')} or\n automatically generated via a ${isc.DocUtils.linkForRef('method:TreeGrid.fetchData','fetchData()')} call.\n",
        name:"dataArrived",
        seeAlso:[],
        params:[
            {description:"The parentNode for which children were just loaded", optional:false,
             name:"parentNode", defaultValue:null, type:"TreeNode"}
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:GridRenderer.getCellCSSText":{
        ref:"method:GridRenderer.getCellCSSText",
        flags:"A",
        description:" Return CSS text for styling this cell, which will be applied in addition to the CSS class\n for the cell, as overrides.\n <p>\n \"CSS text\" means semicolon-separated style settings, suitable for inclusion in a CSS\n stylesheet or in a STYLE attribute of an HTML element.\n\n",
        name:"getCellCSSText",
        seeAlso:[
            {ref:"method:GridRenderer.getCellStyle", description:null}
        ],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"CSS text for this cell", type:"string"},
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "method:Scrollbar.setScrollTarget":{
        ref:"method:Scrollbar.setScrollTarget",
        flags:"",
        description:"          Sets or clears the scrollbar's scrollTarget. If no argument is provided, then the\n          scrollTarget will be set to the scrollbar itself.\n\n",
        name:"setScrollTarget",
        seeAlso:[],
        params:[
            {description:"target canvas to be scrolled", optional:true, name:"newTarget",
             defaultValue:null, type:"Canvas"}
        ],
        type:"method",
        definingClass:"class:Scrollbar",
        groups:["scroll"]
    },
    "attr:ServerObject.dropExtraFields":{
        ref:"attr:ServerObject.dropExtraFields",
        flags:"IR",
        description:"By default, for DMI DSResponses, DSResponse.data is filtered on the server to just the set\n of fields defined on the DataSource.  This behavior can be overridden in several ways - see\n the overview in ${isc.DocUtils.linkForRef('class:DMI')} for details.  The value of this attribute overrides\n ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields')}.",
        name:"dropExtraFields",
        seeAlso:[],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ServerObject"
    },
    "method:DataSource.processResponse":{
        ref:"method:DataSource.processResponse",
        flags:"A",
        description:" Process a dsResponse for a request initiated by a DataSource with\n ${isc.DocUtils.linkForRef('attr:OperationBinding.dataProtocol','dataProtocol:\"clientCustom\"')}.\n <code>requestId</code> parameter should be dsRequest.requestId as found on the dsRequest\n passed to ${isc.DocUtils.linkForRef('method:DataSource.transformRequest')}.\n <P>\n You must provide a response for both error and non-error cases.  For an error case, a\n sufficient response is:\n <pre>\n { status : -1 }\n </pre>\n",
        name:"processResponse",
        seeAlso:[],
        params:[
            {description:"requestId attribute from the associated dataSource request object",
             optional:false, name:"requestId", defaultValue:null, type:"string"},
            {description:"Configuration for the dsResponse", optional:false, name:"dsResponse",
             defaultValue:null, type:"DSResponse properties"}
        ],
        type:"method",
        definingClass:"class:DataSource"
    },
    "method:FormItemIcon.click":{
        ref:"method:FormItemIcon.click",
        flags:"",
        description:"      StringMethod action to fire when this icon is clicked\n      If unset the form item's <code>iconClick</code> method will be fired instead (if\n      specified).\n",
        name:"click",
        seeAlso:[],
        params:[
            {description:"The Dynamic Form to which this icon's item belongs.", optional:false,
             name:"form", defaultValue:null, type:"DynamicForm"},
            {description:"The Form Item containing this icon", optional:false, name:"item",
             defaultValue:null, type:"FormItem"},
            {description:"A pointer to the form item icon clicked", optional:false, name:"icon",
             defaultValue:null, type:"FormItemIcon"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('formIcons')}"],
        definingClass:"object:FormItemIcon",
        groups:["formIcons"]
    },
    "attr:ListGrid.longTextEditorType":{
        ref:"attr:ListGrid.longTextEditorType",
        flags:"IRW",
        description:"When the length of the field specified by ${isc.DocUtils.linkForRef('attr:DataSourceField.length')} exceeds \n <code>this.longTextEditorThreshold</code> show an edit field of this type\n rather than the standard text field when the field enters inline edit mode.",
        name:"longTextEditorType",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"PopUpTextAreaItem\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "attr:Canvas.keepInParentRect":{
        ref:"attr:Canvas.keepInParentRect",
        flags:"IRWA",
        description:"Constrains drag-resizing and drag-repositioning of this canvas to either the rect of its\n parent (if set to true) or an arbitrary rect (if set to a [Left,Top,Width,Height] rect\n array).  If this canvas has no parent, constrains dragging to within the browser window.\n <p>\n Affects target and outline dragAppearance, not tracker.\n <p>\n Note: keepInParentRect affects only user drag interactions, not programmatic moves.",
        name:"keepInParentRect",
        seeAlso:[],
        valueType:"boolean or rect",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dragCreate')}"],
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "classMethod:isA.RegularExpression":{
        ref:"classMethod:isA.RegularExpression",
        flags:"",
        description:"\n	Is <code>object</code> a Regular Expression (RegExp) object?\n\n",
        name:"RegularExpression",
        seeAlso:[],
        params:[
            {description:"object to test", optional:false, name:"object", defaultValue:null,
             type:"object"}
        ],
        returns:{description:"true == <code>object</code> is a Boolean", type:"boolean"},
        type:"classMethod",
        definingClass:"object:isA"
    },
    "attr:SectionStack.headerHeight":{
        ref:"attr:SectionStack.headerHeight",
        flags:"IR",
        description:"Height of headers for sections.",
        name:"headerHeight",
        seeAlso:[],
        valueType:"Number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:SectionStack"
    },
    "attr:ActiveXControl.codeBase":{
        ref:"attr:ActiveXControl.codeBase",
        flags:"IR",
        description:"Specifies the URL from which to load the ActiveX control.",
        name:"codeBase",
        seeAlso:[],
        valueType:"URL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ActiveXControl"
    },
    "attr:DataBoundComponent.dataPageSize":{
        ref:"attr:DataBoundComponent.dataPageSize",
        flags:"IRW",
        description:"When using data paging, how many records to fetch at a time.  The value of this\n attribute is passed on to the auto-constructed ${isc.DocUtils.linkForRef('class:ResultSet')} object for this\n component.  In effect, this gives you control over the ${isc.DocUtils.linkForRef('attr:ResultSet.resultSize')}\n attribute for this component.\n <P>\n <b>Note</b> that regardless of the <code>dataPageSize</code> setting, a component will always fetch\n all of data that it needs to draw.  Settings such as\n ${isc.DocUtils.linkForRef('attr:ListGrid.showAllRecords','showAllRecords:true')},\n ${isc.DocUtils.linkForRef('attr:ListGrid.drawAllMaxCells','drawAllMaxCells')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.drawAheadRatio','drawAheadRatio')} can cause more rows than the configured\n <code>dataPageSize</code> to be fetched.",
        name:"dataPageSize",
        seeAlso:[
            {ref:"attr:ResultSet.resultSize", description:null}
        ],
        valueType:"number",
        defaultValue:"75",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["databinding"]
    },
    "method:Array.addAt":{
        ref:"method:Array.addAt",
        flags:"",
        description:" Add a single item to this array at a specific position in the list, sliding other items over\n to fit.\n\n",
        name:"addAt",
        seeAlso:[],
        params:[
            {description:"object to add", optional:false, name:"obj", defaultValue:null, type:"object"},
            {description:"position in the list to add at", optional:false, name:"pos",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"object that was added", type:"object"},
        type:"method",
        definingClass:"object:Array",
        groups:["modification"]
    },
    "attr:SummaryBuilder.formulaField":{
        ref:"attr:SummaryBuilder.formulaField",
        flags:"IR",
        description:"TextItem that users type into when entering a formula.",
        name:"formulaField",
        seeAlso:[],
        valueType:"AutoChild TextItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:["summaryFields"]
    },
    "attr:ListGrid.skinImgDir":{
        ref:"attr:ListGrid.skinImgDir",
        flags:"IRWA",
        description:"Where do 'skin' images (those provided with the class) live?",
        name:"skinImgDir",
        seeAlso:[],
        valueType:"URL",
        defaultValue:"\"images/ListGrid/\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["appearance", "images"]
    },
    "method:DataBoundComponent.disableHiliting":{
        ref:"method:DataBoundComponent.disableHiliting",
        flags:"",
        description:" Disable all hilites.\n\n",
        name:"disableHiliting",
        seeAlso:[],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["hiliting"]
    },
    "attr:SummaryBuilder.showAutoHideCheckBox":{
        ref:"attr:SummaryBuilder.showAutoHideCheckBox",
        flags:"IR",
        description:"Whether to show a checkbox offering the user the ability to automatically\n hide any fields involved in the formula.",
        name:"showAutoHideCheckBox",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:["summaryFields"]
    },
    "attr:FacetValue.align":{
        ref:"attr:FacetValue.align",
        flags:"IR",
        description:"Default alignment for facet label title, and cells for this facetValue.\n Can be overridden by setting titleAlign or cellAlign on the facetValue.",
        name:"align",
        seeAlso:[],
        valueType:"alignEnum",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "attr:RestDataSource.addDataURL":{
        ref:"attr:RestDataSource.addDataURL",
        flags:"IR",
        description:"Custom dataURL for add type operations",
        name:"addDataURL",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RestDataSource"
    },
    "attr:TreeGrid.nodeIcon":{
        flags:"IRW",
        type:"attr",
        ref:"attr:TreeGrid.nodeIcon",
        description:"The filename of the default icon for all leaf nodes in this grid. To specify a \n custom image for an individual node, set the ${isc.DocUtils.linkForRef('attr:TreeGrid.customIconProperty')} directly on\n the node.",
        name:"nodeIcon",
        setter:["setNodeIcon"],
        valueType:"SCImgURL",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('nodeTitles')}"],
        defaultValue:"\"[SKIN]file.gif\"",
        groups:["treeIcons"],
        definingClass:"class:TreeGrid"
    },
    "classMethod:Timer.setTimeout":{
        ref:"classMethod:Timer.setTimeout",
        flags:"",
        description:"    \n Execute an action in a given amount of time.  This method wraps the native setTimeout() method,\n correcting for browser-specific memory leaks.\n\n",
        name:"setTimeout",
        seeAlso:[
            {ref:"classMethod:Timer.clear", description:null}
        ],
        params:[
            {description:"Function to be called when delay has elapsed. \n				     Can also be a string representation of an expression.\n	    			 Passing a string is preferred.",
             optional:false, name:"action", defaultValue:null, type:"string expression or function"},
            {description:"Time until action is executed (in milliseconds). If not specified, the                       default is 100 milliseconds.",
             optional:false, name:"delay", defaultValue:null, type:"number"}
        ],
        returns:{description:"Reference to the timerEvent created. Note that this reference is provided 							 only so that it can be used as an argument for Timer.clear().",
         type:"timerEvent"},
        type:"classMethod",
        definingClass:"class:Timer"
    },
    "attr:Facet.titleAlign":{
        ref:"attr:Facet.titleAlign",
        flags:"IR",
        description:"Alignment of facet label title",
        name:"titleAlign",
        seeAlso:[
            {ref:"attr:CubeGrid.facetTitleAlign", description:null}
        ],
        valueType:"alignEnum",
        defaultValue:"cubeGrid.facetTitleAlign",
        type:"attr",
        definingClass:"class:Facet"
    },
    "method:Class.echo":{
        ref:"method:Class.echo",
        flags:"",
        description:" Return a short string representation of any object, suitable for viewing by a developer for\n debugging purposes.\n <P>\n If passed an object containing other objects, echo will not recurse into subobjects,\n summarizing them instead via echoLeaf().\n <P>\n NOTE: echo() is used to generate the output shown in the Log window when evaluating an\n expression.\n <P>\n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.echo()\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n \n",
        name:"echo",
        seeAlso:[
            {ref:"classMethod:Log.echoAll", description:null},
            {ref:"classMethod:Log.echoLeaf", description:null}
        ],
        params:[
            {description:"object to echo", optional:false, name:"obj", defaultValue:null, type:"any"}
        ],
        returns:{description:"a short string representation of the object", type:"string"},
        type:"method",
        definingClass:"class:Class",
        groups:["debug"]
    },
    "method:ListGrid.getCriteria":{
        ref:"method:ListGrid.getCriteria",
        flags:"",
        description:" Retrieves the current criteria for this component (may be null)\n",
        name:"getCriteria",
        seeAlso:[],
        returns:{description:"current filter criteria", type:"Criteria"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["dataBoundComponentMethods"]
    },
    "method:Layout.removeMember":{
        ref:"method:Layout.removeMember",
        flags:"",
        description:"\n Removes the specified member from the layout. If it has a resize bar, the bar will be\n destroyed.\n\n",
        name:"removeMember",
        seeAlso:[],
        params:[
            {description:"the canvas to be removed from the layout", optional:false, name:"member",
             defaultValue:null, type:"canvas"}
        ],
        type:"method",
        definingClass:"class:Layout"
    },
    "class:MultiFilePicker":{
        methods:[],
        ref:"class:MultiFilePicker",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Forms/Form Items/MultiFileItem"],
        attrs:[],
        description:"The MultiFilePicker is a pop-up picker used by the ${isc.DocUtils.linkForRef('class:MultiFileItem')} to allow the user to\n enter several files for upload.",
        name:"MultiFilePicker",
        seeAlso:[],
        type:"class",
        groups:["upload"]
    },
    "method:StretchImgButton.getTitle":{
        ref:"method:StretchImgButton.getTitle",
        flags:"A",
        description:" Return the title - text/HTML drawn inside the component.\n <p>\n Default is to simply return this.title.\n",
        name:"getTitle",
        seeAlso:[],
        returns:{description:"HTML for the title", type:"string"},
        type:"method",
        definingClass:"class:StretchImgButton"
    },
    "attr:ToolStripSeparator.hSrc":{
        ref:"attr:ToolStripSeparator.hSrc",
        flags:"IRW",
        description:"Image for horizontally oriented separator (for vertical toolstrips).",
        name:"hSrc",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]hseparator.png\"",
        type:"attr",
        definingClass:"class:ToolStripSeparator"
    },
    "attr:StretchImgButton.showRollOverIcon":{
        ref:"attr:StretchImgButton.showRollOverIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image on mouse rollover.",
        name:"showRollOverIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["buttonIcon"]
    },
    "attr:Layout.overflow":{
        ref:"attr:Layout.overflow",
        flags:"IR",
        description:"Normal ${isc.DocUtils.linkForRef('type:Overflow')} settings can be used on layouts, for example, an\n overflow:auto Layout will scroll if members exceed its specified size, whereas an\n overflow:visible Layout will grow to accomodate members.",
        name:"overflow",
        seeAlso:[],
        valueType:"Overflow",
        defaultValue:"\"visible\"",
        type:"attr",
        definingClass:"class:Layout",
        groups:["layoutPolicy"]
    },
    "method:DynamicForm.getSaveOperationType":{
        ref:"method:DynamicForm.getSaveOperationType",
        flags:"",
        description:" Returns the ${isc.DocUtils.linkForRef('type:DSOperationType')} to be performed when ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} is\n called. Valid options are <code>\"add\"</code> or <code>\"update\"</code>.\n <P>\n If a ${isc.DocUtils.linkForRef('class:DSRequest')} configuration object is passed in containing an explicit operationType\n this will be returned. Otherwise ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOperationType')} will be returned.\n\n",
        name:"getSaveOperationType",
        seeAlso:[],
        params:[
            {description:"Optional DSRequest config block for the  save operation", optional:true,
             name:"requestProperties", defaultValue:null, type:"DSRequest properties"}
        ],
        returns:{description:"Operation type for the save request.", type:"DSOperationType"},
        type:"method",
        definingClass:"class:DynamicForm"
    },
    "method:DynamicForm.getErrors":{
        ref:"method:DynamicForm.getErrors",
        flags:"",
        description:" Returns the current set of validation errors for this form.\n",
        name:"getErrors",
        seeAlso:[],
        returns:{description:"Errors are returned as an object of the format<br> <code>{fieldName:errors, fieldName:errors}</code><br>\n where each <code>errors</code> object will be either an error message string or an array\n of error message strings.",
         type:"object"},
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["errors"]
    },
    "method:Canvas.animateResize":{
        ref:"method:Canvas.animateResize",
        flags:"",
        description:" Animate a resize of this canvas from its current size to the specified size\n",
        name:"animateResize",
        seeAlso:[],
        params:[
            {description:"new width (or null for unchanged)", optional:false, name:"width",
             defaultValue:null, type:"number"},
            {description:"new height (or null for unchanged)", optional:false, name:"height",
             defaultValue:null, type:"number"},
            {description:"When the resize completes this callback will be fired. Single                              'earlyFinish' parameter will be passed if the animation was\n                              cut short by a call to finishAnimation",
             optional:true, name:"callback", defaultValue:null, type:"callback"},
            {description:"Duration in ms of the animated resize", optional:true, name:"duration",
             defaultValue:null, type:"number"},
            {description:"Optional acceleration effect to apply to the resize", optional:true,
             name:"acceleration", defaultValue:null, type:"AnimationAcceleration"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('animateResize')}"],
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "method:Calendar.eventClick":{
        ref:"method:Calendar.eventClick",
        flags:"",
        description:" Called whenever an event is clicked on in the day, week or month views.\n <P>\n By default a dialog appears showing details for the event, and offering the ability to\n edit events which are editable.  Return false to cancel the default action. This is a good\n place to, for example, show a completely customized event dialog instead of the default one.\n\n",
        name:"eventClick",
        seeAlso:[],
        params:[
            {description:"event that was clicked on", optional:false, name:"event", defaultValue:null,
             type:"CalendarEvent"},
            {description:"view where the event was clicked on: \"day\", \"week\" or \"month\"",
             optional:false, name:"viewName", defaultValue:null, type:"String"}
        ],
        returns:{description:"false to cancel the default action", type:"boolean"},
        type:"method",
        definingClass:"class:Calendar",
        groups:["monthViewEvents"]
    },
    "attr:StretchImgButton.capSize":{
        ref:"attr:StretchImgButton.capSize",
        flags:"IRW",
        description:"How big are the end pieces by default",
        name:"capSize",
        seeAlso:[],
        valueType:"number",
        defaultValue:"12",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["appearance"]
    },
    "attr:ListGrid.initialCriteria":{
        ref:"attr:ListGrid.initialCriteria",
        flags:"IR",
        description:"Criteria to be used when ${isc.DocUtils.linkForRef('attr:ListGrid.autoFetchData')} is set.",
        name:"initialCriteria",
        seeAlso:[],
        valueType:"Criteria",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:ListGridRecord.enabled":{
        ref:"attr:ListGridRecord.enabled",
        flags:"IR",
        description:"Default property name denoting whether this record is enabled. Property name may be modified\n for some grid via ${isc.DocUtils.linkForRef('attr:ListGrid.recordEnabledProperty')}.",
        name:"enabled",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('disabledRows')}"],
        definingClass:"object:ListGridRecord"
    },
    "attr:GridRenderer.scrollRedrawDelay":{
        ref:"attr:GridRenderer.scrollRedrawDelay",
        flags:"IRW",
        description:"While drag scrolling in an incrementally rendered grid, time in milliseconds to wait\n before redrawing, after the last mouse movement by the user.",
        name:"scrollRedrawDelay",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"75",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["performance"]
    },
    "attr:Label.showSelectedIcon":{
        ref:"attr:Label.showSelectedIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the button\n becomes selected.",
        name:"showSelectedIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Label",
        groups:["buttonIcon"]
    },
    "attr:DSRequest.resultSet":{
        ref:"attr:DSRequest.resultSet",
        flags:"R",
        description:"For advanced use in integrating dataset paging with web services,\n the ResultSet that issued this \"fetch\" DSRequest is automatically made available as the\n <code>resultSet</code> property.\n <P>\n This property can only be read.  There is no meaning to setting this property\n yourself.",
        name:"resultSet",
        seeAlso:[],
        valueType:"ResultSet",
        defaultValue:"{}",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "classAttr:Date.shortDayNames":{
        ref:"classAttr:Date.shortDayNames",
        flags:"IRWA",
        description:"This property may be set to an array of names of days of the week. <br>\n For example:\n <pre>\n [\"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\"]\n </pre>\n The appropriate day name will then be returned from ${isc.DocUtils.linkForRef('method:Date.getShortDayName')}, and may \n be used whenever SmartClient components display day-names (for example in the \n ${isc.DocUtils.linkForRef('class:DateItem','DateItem class')}).<br>\n Note: For US based applications the first item in the array should be the name for Sunday, \n then Monday, Tuesday, etc. For browsers with different locales this may vary. \n To determine the first day for some locale, you can run the following code:\n <pre>\n    alert(new Date(2000, 0, 2).getDay());\n </pre>\n You should see an alert with a number between zero and 6. This represents the numerical\n 'day' value for Sunday for your browser's locale, since Jan 2nd 2000 was a Sunday. \n Therefore if this code alerted the number 6, Sunday should appear last in your list \n of day-names, and Monday first.",
        name:"shortDayNames",
        seeAlso:[],
        valueType:"Array",
        defaultValue:"null",
        type:"classAttr",
        definingClass:"class:Date",
        groups:["i18nMessages"]
    },
    "method:DynamicForm.fetchData":{
        ref:"method:DynamicForm.fetchData",
        flags:"",
        description:" Retrieve data that matches the provided criteria, and edit the first record returned\n \n",
        name:"fetchData",
        seeAlso:[],
        params:[
            {description:"search criteria", optional:true, name:"criteria", defaultValue:null,
             type:"Criteria"},
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on the DSRequest                                            that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["dataBoundComponentMethods"]
    },
    "attr:Window.headerStyle":{
        ref:"attr:Window.headerStyle",
        flags:"IRWA",
        description:"Style for the Window header.",
        name:"headerStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"WindowHeader\"",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "header"]
    },
    "attr:Calendar.saveButtonTitle":{
        ref:"attr:Calendar.saveButtonTitle",
        flags:"IR",
        description:"The title for the save button in the quick event dialog and the event editor",
        name:"saveButtonTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Save Event\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["i18nMessages"]
    },
    "attr:ListGrid.headerButtonConstructor":{
        ref:"attr:ListGrid.headerButtonConstructor",
        flags:"IR",
        description:"Widget class for this ListGrid's header buttons. If unset constructor will be \n picked up directly standard ${isc.DocUtils.linkForRef('class:Toolbar')} button constructor.",
        name:"headerButtonConstructor",
        seeAlso:[],
        valueType:"Class",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["gridHeader", "appearance"]
    },
    "attr:DateChooser.nextYearIconHeight":{
        ref:"attr:DateChooser.nextYearIconHeight",
        flags:"IRW",
        description:"Height of the icon for the next year button",
        name:"nextYearIconHeight",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"7",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "classAttr:DynamicForm.nestedEditorType":{
        ref:"classAttr:DynamicForm.nestedEditorType",
        flags:"IRW",
        description:"Editor class to use for any ${isc.DocUtils.linkForRef('class:NestedEditorItem')}s on any DynamicForm. Can be\n overridden for individual nestedEditorItems by setting nestedEditorItem.editorConstructor.",
        name:"nestedEditorType",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"DynamicForm\"",
        type:"classAttr",
        definingClass:"class:DynamicForm"
    },
    "attr:SectionStack.animateSections":{
        ref:"attr:SectionStack.animateSections",
        flags:"IRW",
        description:"If true, sections are animated during expand/collapse and addition/removal of\n SectionItems is likewise animated.",
        name:"animateSections",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('animateSections')}"],
        definingClass:"class:SectionStack",
        groups:["animation"]
    },
    "method:List.containsAll":{
        ref:"method:List.containsAll",
        flags:"",
        description:" Return whether this list contains all the item in the specified list.\n\n",
        name:"containsAll",
        seeAlso:[],
        params:[
            {description:"items to look for", optional:false, name:"list", defaultValue:null,
             type:"List"}
        ],
        returns:{description:"whether all items were found", type:"boolean"},
        type:"method",
        definingClass:"interface:List",
        groups:["access"]
    },
    "method:SimpleTile.getRecord":{
        ref:"method:SimpleTile.getRecord",
        flags:"",
        description:" Return the record that this tile should render.\n <P>\n NOTE: a TileGrid that is doing data paging may reuse tiles with different records, so a\n subclass of SimpleTile should not cache the record returned by getRecord().\n <P>\n",
        name:"getRecord",
        seeAlso:[],
        returns:{description:"the TileRecord associated with this tile", type:"TileRecord"},
        type:"method",
        definingClass:"class:SimpleTile"
    },
    "attr:ListGridField.editorValueIconHeight":{
        ref:"attr:ListGridField.editorValueIconHeight",
        flags:"IRW",
        description:"When some cell in this field is being edited, setting this property will specify the\n height for value icons in the cell's editor. If unset, the editor's valueIcon width and\n height will be determined in the same way as it would be for a static cell.",
        name:"editorValueIconHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "attr:CubeGrid.cellAlign":{
        ref:"attr:CubeGrid.cellAlign",
        flags:"IRW",
        description:"default align for cell values (in body)",
        name:"cellAlign",
        seeAlso:[],
        valueType:"alignEnum",
        defaultValue:"\"center\"",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["gridLayout"]
    },
    "attr:Operator.titleProperty":{
        ref:"attr:Operator.titleProperty",
        flags:"IR",
        description:"Name of a property on the ${isc.DocUtils.linkForRef('class:Operators')} class that provides the title for this operator.",
        name:"titleProperty",
        seeAlso:[],
        valueType:"identifier",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Operator",
        groups:["advancedFilter"]
    },
    "method:Tree.getFolders":{
        ref:"method:Tree.getFolders",
        flags:"",
        description:"\n Returns all the first-level folders of a node.\n <br><br>\n For load on demand trees (those that only have a partial representation client-side), this\n method will return only nodes that have already been loaded from the server.  Furthermore,\n for databound trees the return value will be a ${isc.DocUtils.linkForRef('class:ResultSet')},\n so it's important to access the return value using the ${isc.DocUtils.linkForRef('interface:List')} interface\n instead of as a native Javascript Array.\n\n",
        name:"getFolders",
        seeAlso:[],
        params:[
            {description:"node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"List of immediate children that are folders", type:"List"},
        type:"method",
        definingClass:"class:Tree"
    },
    "method:Canvas.getScrollWidth":{
        ref:"method:Canvas.getScrollWidth",
        flags:"A",
        description:" Returns the scrollable width of the widget's contents, including children, ignoring\n clipping.\n",
        name:"getScrollWidth",
        seeAlso:[],
        returns:{description:"the scrollable width of the widget's contents", type:"number"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "attr:TextItem.characterCasing":{
        ref:"attr:TextItem.characterCasing",
        flags:"IRWA",
        description:"Should entered characters be converted to upper or lowercase?\n Also applies to values applied with ${isc.DocUtils.linkForRef('method:FormItem.setValue')}.",
        name:"characterCasing",
        seeAlso:[],
        valueType:"CharacterCasing",
        defaultValue:"TextItem.DEFAULT",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('formFilters')}"],
        definingClass:"class:TextItem"
    },
    "classMethod:isc.showLoginDialog":{
        ref:"classMethod:isc.showLoginDialog",
        flags:"",
        description:" Handle a complete login interaction with a typical login dialog asking for username and\n password credentials.\n <P>\n As with other convenience methods that show Dialogs, such as ${isc.DocUtils.linkForRef('classMethod:isc.warn')},\n the dialog is shown and the function immediately returns.  When the user responds, the\n provided callback function is called.\n <P>\n If the user clicks the \"Log in\" button, the credentials entered by the user are passed to\n the provided \"loginFunc\" as an Object with properties \"username\" and \"password\" (NOTE: both\n property names are all lowercase), as the variable \"credentials\".  For example:\n <pre>{ username: \"barney\", password: \"rUbbL3\" }</pre>\n <P>\n The \"loginFunc\" should then attempt to log in by whatever means is necessary.  The second\n parameter to the loginFunc, \"dialogCallback\", is a function, which must be called <i>whether\n login succeeds or fails</i> with a true/false value indicating whether login succeeded.\n <P>\n If the login dialog is dismissable (settable as properties.dismissable, default false) and\n the user dismisses it, the loginFunc will be fired with null for the credentials.\n <P>\n The following code shows typical usage.  This code assumes you have created a global\n function sendCredentials() that send credentials to some authentication system and fires a\n callback function with the result:\n <pre>\n isc.showLoginDialog(function (credentials, dialogCallback) {\n     if (credentials == null) return; // dismissed\n\n     // send credentials    \n     sendCredentials(credentials, function (loginSucceeded) {\n         // report success or failure\n         dialogCallback(loginSucceeded);\n     })\n })\n </pre>\n The login dialog has several built-in behaviors:\n <ul>\n <li> keyboard focus is automatically placed in the username field\n <li> hitting enter in the username field proceeds to the password field\n <li> hitting enter in the password field submits (fires the provided callback)\n </ul>\n In addition to normal properties supported by Dialog/Window, the following special\n properties can be passed:\n <ul>\n <li><code>username</code>: initial value for the username field\n <li><code>password</code>: initial value for the password field\n <li><code>usernameTitle</code>: title for the username field\n <li><code>passwordTitle</code>: title for the password field\n <li><code>errorMessage</code>: default error message on login failure\n <li><code>loginButtonTitle</code>: title for the login button\n <li><code>dismissable</code>: whether the dialog can be dismissed, default false\n <li><code>errorStyle</code>: CSS style for the error message, if shown\n </ul>\n See below for links to the default values for these properties.\n\n",
        name:"showLoginDialog",
        seeAlso:[
            {ref:"classAttr:Dialog.LOGIN_TITLE", description:null},
            {ref:"classAttr:Dialog.USERNAME_TITLE", description:null},
            {ref:"classAttr:Dialog.PASSWORD_TITLE", description:null},
            {ref:"classAttr:Dialog.LOGIN_BUTTON_TITLE", description:null},
            {ref:"classAttr:Dialog.LOGIN_ERROR_MESSAGE", description:null}
        ],
        params:[
            {description:"Function to call to attempt login.  Recieves parameters                                      \"credentials\" and \"dialogCallback\", described above",
             optional:false, name:"loginFunc", defaultValue:null, type:"Callback"},
            {description:"additional properties for the Dialog", optional:true, name:"properties",
             defaultValue:null, type:"Dialog Properties"}
        ],
        type:"classMethod",
        definingClass:"class:isc",
        groups:["Prompting"]
    },
    "method:Array.min":{
        ref:"method:Array.min",
        flags:"",
        description:"          \n 			Returns the smallest number in the array, skipping non-numeric values.\n\n			If the start and/or end are given, searches the specified subset of the list.\n\n",
        name:"min",
        seeAlso:[],
        params:[
            {description:"optional start index (default is 0)", optional:true, name:"start",
             defaultValue:null, type:"number"},
            {description:"optional end index (default is list.length)", optional:true, name:"end",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"minimum of all items in the list, or null if all values are non-numeric",
         type:"number"},
        type:"method",
        definingClass:"object:Array",
        groups:["arrayMath"]
    },
    "attr:ButtonItem.autoFit":{
        ref:"attr:ButtonItem.autoFit",
        flags:"IR",
        description:"Should the button auto fit to its title. Maps to ${isc.DocUtils.linkForRef('attr:Button.autoFit')} attribute.\n Note that if an explicit width or height is specified for this item, it will be respected,\n disabling autoFit behavior",
        name:"autoFit",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ButtonItem"
    },
    "method:ListGrid.getCellAlign":{
        ref:"method:ListGrid.getCellAlign",
        flags:"",
        description:" Return the horizontal alignment for cell contents. Default implementation returns \n ${isc.DocUtils.linkForRef('attr:ListGridField.cellAlign')} if specified, otherwise ${isc.DocUtils.linkForRef('attr:ListGridField.align')}.\n\n",
        name:"getCellAlign",
        seeAlso:[
            {ref:"method:ListGrid.getCellStyle", description:null}
        ],
        params:[
            {description:"this cell's record", optional:false, name:"record", defaultValue:null,
             type:"listGridRecord"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"Horizontal alignment of cell contents: 'right', 'center', or 'left'",
         type:"Alignment"},
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:DataSourceField.canFilter":{
        ref:"attr:DataSourceField.canFilter",
        flags:"IR",
        description:"Should the user be able to filter data by this field.\n Effects whether this field will show up in dataBoundComponents with UI for filtering data.",
        name:"canFilter",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField"
    },
    "attr:FormItem.endRow":{
        ref:"attr:FormItem.endRow",
        flags:"IRW",
        description:"Whether this item should end the row it's in in the form layout",
        name:"endRow",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["formLayout"]
    },
    "method:Canvas.parentResized":{
        ref:"method:Canvas.parentResized",
        flags:"",
        description:" Fires when the interior size of the parent changes, including parent resize and\n scrollbar introduction or removal.\n <p>\n This method allows a child to implement a layout policy that can be used within any \n parent, such as a Resizer component that always snaps to the parent's\n bottom-right corner.  The default implementation of this method applies a child's\n percent sizes, if any, or implements layout based on the ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')} property\n",
        name:"parentResized",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "attr:TreeGrid.customIconOpenProperty":{
        ref:"attr:TreeGrid.customIconOpenProperty",
        flags:"IRWA",
        description:"For folder nodes showing custom icons (set via the ${isc.DocUtils.linkForRef('attr:TreeGrid.customIconProperty')}),\n this property allows the developer to specify on a per-node basis whether a\n open state icon should be displayed when the folder is open.\n Set <code>node[treeGrid.customIconOpenProperty]</code> to true to show the open state\n icons, or false to suppress this.<br>\n If not specified, this behavior is determined by <code>grid.showCustomIconOpen</code>\n for this node.",
        name:"customIconOpenProperty",
        seeAlso:[
            {ref:"attr:TreeGrid.customIconProperty", description:null},
            {ref:"attr:TreeGrid.showCustomIconOpen", description:null}
        ],
        valueType:"string",
        defaultValue:"\"showOpenIcon\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "group:serverDataIntegration":{
        ref:"group:serverDataIntegration",
        title:"Server DataSource Integration",
        treeLocation:["Concepts/Client-Server Integration", "Java Server Reference"],
        refs:["attr:DataSource.dataFormat", "attr:DataSource.dataProtocol", 
         "attr:DataSource.requestProperties","attr:DataSource.serverType", "attr:DataSource.tableName", "attr:DataSource.dbName", 
         "attr:DataSource.serverObject","attr:OperationBinding.requestProperties", "type:DSDataFormat", "type:DSServerType"],
        description:"Server Data Integration means:\n <ul>\n <li> You ${isc.DocUtils.linkForRef('group:iscInstall','install')} the ${isc.DocUtils.linkForRef('group:iscServer','SmartClient Java\n Server')} into any J2SE/J2EE environment\n <li> You ${isc.DocUtils.linkForRef('group:dataSourceDeclaration','create DataSources')} in either XML or JavaScript,\n possibly on-the-fly from ${isc.DocUtils.linkForRef('group:metadataImport','existing metadata')}.  \n <li> When you bind ${isc.DocUtils.linkForRef('interface:DataBoundComponent','databinding-capable UI components')} to these\n DataSources, the ${isc.DocUtils.linkForRef('class:DSRequest','DataSource requests')} issued by these components will be\n transmitted to the server using a proprietary HTTP-based protocol, and the DataSource\n responses likewise sent back via a proprietary protocol\n <li> You will use SmartClient server APIs to receive the request data as Java Objects, and\n you will provide response data as Java Objects\n </ul>\n This approach is in contrast to \n ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side Data Integration')}, which does not require the\n SmartClient server, and in which client-side DataSources are configured to directly send and\n receive HTTP messages containing XML, JSON or other content.\n <P>\n <B>Handling DataSource Requests</B>\n <P>\n Client-side ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} will send\n ${isc.DocUtils.linkForRef('class:DSRequest','DSRequests')} to the ISC server as background communications transparent to\n the user.  Integrating SmartClient's DataSource layer with your data model is a matter of\n handling these DSRequests and sending back DSResponses, in order to fulfill the 4 basic\n operations of the ${isc.DocUtils.linkForRef('group:dataSourceOperations','DataSource Protocol')}.\n <P>\n There are two approaches for routing inbound dsRequests to your business logic:\n <dl>\n <dt>RPCManager dispatch</dt>\n <dd>inbound requests are handled by a single dispatcher implemented as a Java servlet or\n .jsp.  The ${isc.DocUtils.linkForRef('class:RPCManager')} is used to retrieve requests and provide responses</dd>\n <dt>${isc.DocUtils.linkForRef('class:DMI','Direct Method Invocation')}</dt>\n <dd>XML declarations route requests to existing business logic methods.  Inbound request\n data is adapted to method parameters, and method return values are delivered as\n responses</dd>\n </dl>\n <P>\n Which approach you use is largely a matter of preference.  Direct Method Invocation (DMI)\n may allow simple integration without writing any SmartClient-specific server code.\n RPCManager dispatch integration provides an earlier point of control, allowing logic that\n applies across different DataSource operations to be shared more easily.\n <P>\n Whether using RPCManager dispatch or DMI request routing, you must return data which, \n translated to JavaScript via the rules described in com.isomorphic.js.JSTranslater.toJS(),\n matches the ${isc.DocUtils.linkForRef('group:dataSourceOperations','response data required for the operationType')}.\n <P>\n For example, for a \"fetch\" request, your return data should translate to an Array of\n JavaScript objects.  Your backend may be capable of returning data in a number of ways - you\n should compare each format you can readily retrieve against the capabilities of the\n JSTranslater.  Common options are to pass an XML document fragment or a Collection of Java\n Beans/POJOs directly to DSResponse.setData().\n <p>\n For \"update\" and \"add\" DataSource requests, the inbound data is intended to be permanently\n stored.  If you are using a DataSource specified in XML format, you can run the validators\n you declared in the DataSource by calling the DSRequest.validate() method.  Assuming the\n declared validation is passed, you can run custom validation logic, if any, and finally\n create or update objects in your object model.  If you are using Beans/POJOs, the method\n DataSource.applyProperties(map, bean) is an easy way to apply the validated values to an\n Object tree or XML structure.\n <P>\n For more information on the DMI subsystem, see the ${isc.DocUtils.linkForRef('class:DMI')} class and the \n <a href='/examples/server_integration/#customDataSourceIntegrationDMI' onclick=\"window.open('/examples/server_integration/#customDataSourceIntegrationDMI');return false;\">DMI example</a> in\n the SDK.\n <P>\n Note that, as you continue to integrate your prototype with your backend, you can use a\n mixture of DataSources that have been fully integrated with your backend and DataSources\n that are either running in \"client-only\" mode (see ${isc.DocUtils.linkForRef('group:clientOnlyDataSources')}) or\n that use ISC's built-in SQL connectivity (see ${isc.DocUtils.linkForRef('group:sqlDataSource')}).\n <P>\n <b>RPCManager dispatch</b>\n <P>\n The basic flow of logic for handling DataSource requests using RPCManager dispatch is:\n <P>\n <table class=\"normal\" border=1>\n <tr>\n <td>1. Get current list of requests from the client.</td>\n <td>rpcManager.getRequests()</td>\n </tr>\n\n <tr>\n <td>2. Determine operation type (Fetch, Add, Update, Remove) for a single request.</td>\n <td>dsRequest.getOperationType()</td>\n </tr>\n\n <tr>\n <td>3. Get inbound values (Add, Update) and/or criteria (Fetch, Update, Remove) for this\n request.</td>\n <td>dsRequest.getFieldValue()<br>\n dsRequest.getValues()<br> \n dsRequest.getCriteria()</td>\n </tr>\n\n <tr>\n <td>4. Business logic, validation, calls to data and service tiers... anything you can code.\n </td>\n <td><b>execute custom logic</b></td>\n </tr>\n\n <tr>\n <td>5. Set status and data for the response.</td>\n <td>dsResponse.setStatus()<br>\n dsResponse.setData()</td>\n </tr>\n\n <tr>\n <td>6. Send response to the client.</td>\n <td>rpcManager.send()</td>\n </tr>\n </table>\n <P>\n For more information, see the ${isc.DocUtils.linkForRef('class:RPCManager','RPCManager documentation')}, and the \n <a href='/examples/server_integration/#customDataSourceIntegration' onclick=\"window.open('/examples/server_integration/#customDataSourceIntegration');return false;\">RPCManager example</a>.",
        name:"serverDataIntegration",
        seeAlso:[],
        type:"group"
    },
    "method:Button.action":{
        ref:"method:Button.action",
        flags:"",
        description:" This property contains the default 'action' for the Button to fire when activated.\n",
        name:"action",
        seeAlso:[],
        type:"method",
        definingClass:"class:Button"
    },
    "attr:Window.resizer":{
        ref:"attr:Window.resizer",
        flags:"R",
        description:"ImgButton-based resizer, shown in the footer.",
        name:"resizer",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window"
    },
    "attr:DataBoundComponent.useFlatFields":{
        ref:"attr:DataBoundComponent.useFlatFields",
        flags:"IR",
        description:"The <code>useFlatFields</code> flag causes all simple type fields anywhere in a nested\n set of DataSources to be exposed as a flat list for form binding.  \n <P>\n <code>useFlatFields</code> is typically used with imported metadata, such as \n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema','XML Schema')} from a \n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadWSDL','WSDL-described web servce')}, as a means of eliminating levels of XML\n nesting that aren't meaningful in a user interface, without the cumbersome and fragile\n process of mapping form fields to XML structures.\n <P>\n For example, having called ${isc.DocUtils.linkForRef('method:WebService.getInputDS')} to retrieve the input message\n schema for a web service operation whose input message looks like this:\n <pre>\n &lt;FindServices&gt;\n     &lt;searchFor&gt;search text&lt;/searchFor&gt;\n     &lt;Options&gt;\n         &lt;caseSensitive&gt;false&lt;/caseSensitive&gt;\n     &lt;/Options&gt;\n     &lt;IncludeInSearch&gt;\n         &lt;serviceName&gt;true&lt;/serviceName&gt;\n         &lt;documentation&gt;true&lt;/documentation&gt;\n         &lt;keywords&gt;true&lt;/keywords&gt;\n     &lt;/IncludeInSearch&gt;\n &lt;/FindServices&gt;\n </pre>\n Setting <code>useFlatFields</code> on a ${isc.DocUtils.linkForRef('class:DynamicForm')} that is bound to this input\n message schema would result in 5 ${isc.DocUtils.linkForRef('class:FormItem','FormItems')} reflecting the 5 simple type\n fields in the message.\n <P>\n For this form, the result of ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')} might look\n like:\n <P>\n <pre>{\n    searchFor: \"search text\",\n    caseSensitive: false,\n    serviceName: true,\n    documentation : true,\n    keywords : true\n }</pre>\n When contacting a ${isc.DocUtils.linkForRef('class:WebService','WSDL web service')}, these values can be automatically\n mapped to the structure of the input message for a web service operation by setting\n ${isc.DocUtils.linkForRef('attr:WSRequest.useFlatFields')} (for use with ${isc.DocUtils.linkForRef('method:WebService.callOperation')}) or by setting\n ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields')} (for use with a ${isc.DocUtils.linkForRef('class:DataSource')} that is\n ${isc.DocUtils.linkForRef('group:wsdlBinding','bound to a WSDL web service')} via\n ${isc.DocUtils.linkForRef('attr:OperationBinding.wsOperation')}).  \n <P>\n Using these two facilities in conjunction (component.useFlatFields and\n request.useFlatFields) allows gratuitous nesting to be consistently bypassed in both the user\n presentation and when providing the data for XML messages.\n <P>\n You can also set ${isc.DocUtils.linkForRef('attr:OperationBinding.useFlatFields')} to automatically enable \n \"flattened\" XML serialization (request.useFlatFields) for all DataSource requests of a\n particular operationType.\n <P>\n Note that <code>useFlatFields</code> is not generally recommended for use with structures\n where multiple simple type fields exist with the same name, however if used with such a\n structure, the first field to use a given name wins.  \"first\" means the first field\n encountered in a depth first search.  \"wins\" means only the first field will be present as a\n field when data binding.",
        name:"useFlatFields",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:DataBoundComponent"
    },
    "method:Img.setImageType":{
        ref:"method:Img.setImageType",
        flags:"",
        description:" Change the style of image rendering.\n\n",
        name:"setImageType",
        seeAlso:[],
        params:[
            {description:"new style of image rendering", optional:false, name:"imageType",
             defaultValue:null, type:"ImageStyle"}
        ],
        type:"method",
        definingClass:"class:Img"
    },
    "classAttr:Page.defaultUnsupportedBrowserURL":{
        ref:"classAttr:Page.defaultUnsupportedBrowserURL",
        flags:"IRWA",
        description:"On a call to <code>Page.checkBrowserAndRedirect()</code>, if no explicit URL\n      is passed in, and the browser is not supported by ISC, redirect to this URL.",
        name:"defaultUnsupportedBrowserURL",
        seeAlso:[
            {ref:"classMethod:Page.checkBrowserAndRedirect", description:null}
        ],
        valueType:"URL",
        defaultValue:"\"[SKIN]/unsupported_browser.html\"",
        type:"classAttr",
        definingClass:"class:Page",
        groups:["files"]
    },
    "classMethod:isc.clearPrompt":{
        ref:"classMethod:isc.clearPrompt",
        flags:"",
        description:"\n	Clear the modal prompt being shown to the user.\n\n",
        name:"clearPrompt",
        seeAlso:[
            {ref:"classAttr:Dialog.Prompt", description:null}
        ],
        type:"classMethod",
        definingClass:"class:isc",
        groups:["Prompting"]
    },
    "attr:ColumnTree.column":{
        ref:"attr:ColumnTree.column",
        flags:"IR",
        getter:["getColumn"],
        description:"Instance of ListGrid used to display each column of the tree.",
        name:"column",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ColumnTree"
    },
    "attr:ListGridRecord.canDrag":{
        ref:"attr:ListGridRecord.canDrag",
        flags:"IR",
        description:"When set to <code>false</code>, this record cannot be dragged. If canDrag is false for\n any record in the current selection, none of the records will be draggable.",
        name:"canDrag",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord"
    },
    "group:compression":{
        ref:"group:compression",
        title:"Compression",
        treeLocation:["Optional Modules/Network Performance"],
        refs:[],
        description:"Compression helps reduce the sizes of various data fetched from the server.  Most modern web\n browsers can handle compressed responses of certain content types. The time it takes to\n decompress these responses on a client system is negligible compared to the time saved\n by reducing the number of bits on the wire, especially for slow connections.\n <p>\n If you're not using the SmartClient Java back-end, there are several compression solutions\n available, depending on your server of choice.  Microsoft's IIS has built-in compression\n capability, please check the reference manual for details.  If you're using Apache, you can\n use <a href='http://sourceforge.net/projects/mod-gzip/' onclick=\"window.open('http://sourceforge.net/projects/mod-gzip/');return false;\">mod_gzip</a> or \n use <a href='http://httpd.apache.org/docs/2.0/mod/mod_deflate.html' onclick=\"window.open('http://httpd.apache.org/docs/2.0/mod/mod_deflate.html');return false;\">mod_deflate</a>.  Some\n servlet containers also natively support dynamic compression.\n <p>\n The SmartClient Java back-end supports two types of response compression:\n <ul>\n <li>Pre-compressed static content served via the ISC FileDownload servlet.\n <li>On-the-fly compression of arbitrary content using the CompressionFilter.\n </ul>\n <u>Serving pre-compressed files</u>\n <p>\n To serve pre-compressed static content via FileDownload, register the FileDownload servlet\n in your web.xml as follows:\n <pre>\n     &lt;servlet&gt;\n       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;\n       &lt;servlet-class&gt;com.isomorphic.servlet.FileDownload&lt;/servlet-class&gt;\n     &lt;/servlet&gt;\n </pre>\n Then map any resource that you want to serve compressed to the FileDownload servlet in your\n web.xml.  Typically, you'll want to serve all SmartClient modules compressed.  You can do so\n by adding the following servlet-mapping directive to your web.xml:\n <pre>\n     &lt;servlet-mapping&gt;\n       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;\n       &lt;url-pattern&gt;/isomorphic/system/modules/*&lt;/url-pattern&gt;\n     &lt;/servlet-mapping&gt;\n </pre>\n Finally, you'll need to create pre-compressed versions of your files alongside the\n uncompressed versions.  If you're using the FileAssembler mechanism, it can create\n pre-compressed files for you automatically.  For all other files, you can use any program\n that uses the gzip encoding.  The compressed file must have exactly the same filename as the\n uncompressed version, with a '.gz' extension.  Note that it's important that both the\n compressed and uncompressed versions be present alongside each other because there are cases\n where serving compressed content is not possible (for example HTTP 1.0 requests) - for those\n situations it's important that the uncompressed files be available to be served to the\n client.  The FileDownload filter automatically detects whether or not compression is\n possible.\n <p>\n <u>Dynamic Compression</u>\n <p>\n Dynamic Compression requires the optional Network Performance module.  To use Dynamic\n Compression, register the CompressionFilter filter in your web.xml as follows:\n <pre>\n     &lt;filter&gt;\n         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;\n         &lt;filter-class&gt;com.isomorphic.servlet.CompressionFilter&lt;/filter-class&gt;\n     &lt;/filter&gt;\n </pre>\n Then map any resource that you want dynamically compressed to this filter.  Note that the\n CompressionFilter knows the mime types that are compressible and will automatically ignore\n any stream that sets a content-encoding header, and it automatically figures out if the\n current request is an include or forward (and doesn't compress in that case), so it's safe\n to simply map it to all resources as follows:\n <pre>\n     &lt;filter-mapping&gt;\n         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;\n         &lt;url-pattern&gt;/*&lt;/url-pattern&gt;\n     &lt;/filter-mapping&gt;\n </pre>\n You can register the CompressionFilter anywhere in your filter chain, but be aware that\n if any filters in front wrap and inspect the HttpServletResponse output stream, they will\n be inspecting the compressed response.  Filters are typically applied in the order in which\n they are listed in web.xml. \n <p>\n <u>Compressable mime types and compatibility</u>\n <p>\n The FileDownload servlet and CompressionFilter filter can serve the following mime-types\n compressed: text/html, text/xml, application/x-javascript, text/javascript, text/ecmascript,\n image/svg+xml.  If your files are not being compressed, make sure your servlet container\n has a mime type mapping that identifies it as one of the above file types.\n <p>\n Compression for the mime types listed above is supported on all browsers supported by\n SmartClient.  There is one exception: compression of javascript files for IE versions older\n than IE6 Service Pack 2 requires that the CompressionFilter be registerd to dynamically\n compress the page that loads these javascript files.",
        name:"compression",
        seeAlso:[],
        type:"group"
    },
    "attr:Canvas.animateScrollAcceleration":{
        ref:"attr:Canvas.animateScrollAcceleration",
        flags:"IRWA",
        description:"Default acceleration function for performing an animated scroll.  If unset, \n <code>this.animateAcceleration</code> will be used by default instead",
        name:"animateScrollAcceleration",
        seeAlso:[],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "attr:HeaderItem.defaultValue":{
        ref:"attr:HeaderItem.defaultValue",
        flags:"IRW",
        description:"Header text",
        name:"defaultValue",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"Header\"",
        type:"attr",
        definingClass:"class:HeaderItem",
        groups:["appearance"]
    },
    "attr:HibernateBrowser.includeSubstring":{
        ref:"attr:HibernateBrowser.includeSubstring",
        flags:"IR",
        description:"If set, specifies a substring which must exist in an entity name for it to be included in\n this HibernateBrowser.  If this property is set to a List of strings, entity names are\n included if they match any one of the strings.  The comparison is case-insensitive.\n <p>\n For example, <code>includeSubstring: [\"Order\", \"inv\"]</code> would match all the following \n entity names: \"ORDERS\", \"Inventory\", \"client_invoicing\"",
        name:"includeSubstring",
        seeAlso:[],
        valueType:"String | List of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:HibernateBrowser"
    },
    "attr:ListGridField.valueIcons":{
        ref:"attr:ListGridField.valueIcons",
        flags:"IRW",
        description:"This property is a mapping between data values to ${isc.DocUtils.linkForRef('type:SCImgURL','SCImgURLs')} for icons to display\n for those data values.  For example, given a field named \"status\" with possible values\n \"Normal\", \"Slow\", \"Offline\", the follow definition would show various icons for that\n field:\n <P>\n <pre>\n fields : [\n     { name:\"status\", \n       valueIcons: {\n           Normal : \"greenIcon.png\",\n           Slow : \"yellowIcon.png\",\n           Offline : \"redIcon.png\"\n       }\n     },\n     ... other fields ...\n ]\n </pre>\n <P>\n <code>valueIcons</code> can either be displayed alongside the normal value or can\n replace the normal field value so that only the icon is shown.  See\n ${isc.DocUtils.linkForRef('attr:ListGridField.showValueIconOnly')}.\n <P>\n If inline editing is enabled for this field, editors displayed for this field will also\n show valueIcons.  This may be overridden by explicitly setting\n ${isc.DocUtils.linkForRef('attr:ListGridField.editorValueIcons')}.\n <P>\n Note that the following attributes related to valueIcon styling will also be picked up\n by the editor from the ListGridField object unless explicitly specified via the\n equivalent <code>editor_</code> attributes:<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconHeight')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconLeftPadding')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconRightPadding')}<br>            \n ${isc.DocUtils.linkForRef('attr:ListGridField.imageURLPrefix')}<br>    \n ${isc.DocUtils.linkForRef('attr:ListGridField.imageURLSuffix')}",
        name:"valueIcons",
        seeAlso:[],
        valueType:"object",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "attr:Window.footer":{
        ref:"attr:Window.footer",
        flags:"R",
        description:"Optional footer for the window, providing space for a resizer and status bar.",
        name:"footer",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window"
    },
    "attr:SectionHeader.baseStyle":{
        ref:"attr:SectionHeader.baseStyle",
        flags:"IRA",
        description:"CSS class for the section header.",
        name:"baseStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"sectionHeader\"",
        type:"attr",
        definingClass:"class:SectionHeader"
    },
    "attr:DataSource.dataTransport":{
        ref:"attr:DataSource.dataTransport",
        flags:"IR",
        description:"Transport to use for all operations on this DataSource. Defaults to\n ${isc.DocUtils.linkForRef('classAttr:RPCManager.defaultTransport')}.  This would typically only be set to\n enable \"scriptInclude\" transport for contacting ${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','JSON')} web\n services hosted on servers other than the origin server.\n <p>\n When using the \"scriptInclude\" transport, be sure to set ${isc.DocUtils.linkForRef('attr:DataSource.callbackParam')} or\n ${isc.DocUtils.linkForRef('attr:OperationBinding.callbackParam')} to match the name of the query parameter name expected\n by your JSON service provider.",
        name:"dataTransport",
        seeAlso:[
            {ref:"type:RPCTransport", description:null},
            {ref:"attr:DataSource.callbackParam", description:null}
        ],
        valueType:"RPCTransport",
        defaultValue:"RPCManager.defaultTransport",
        type:"attr",
        definingClass:"class:DataSource",
        groups:["clientDataIntegration"]
    },
    "class:ServerObject":{
        methods:[],
        ref:"class:ServerObject",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/RPC"],
        attrs:["attr:ServerObject.lookupStyle", "attr:ServerObject.className", "attr:ServerObject.ID", 
         "attr:ServerObject.bean","attr:ServerObject.attributeName", "attr:ServerObject.attributeScope", 
         "attr:ServerObject.visibleMethods","attr:ServerObject.dropExtraFields", "attr:ServerObject.targetXPath"],
        description:"The ServerObject tells the ISC server how to find or create a server-side object involved in\n ${isc.DocUtils.linkForRef('class:DMI')} (Direct Method Invocation).  \n <p>\n A ServerObject declaration appears in the XML definition of a ${isc.DocUtils.linkForRef('class:DataSource')} (for\n responding to ${isc.DocUtils.linkForRef('class:DSRequest')}s) or in an Application configuration file (.app.xml) for\n responding to ${isc.DocUtils.linkForRef('class:RPCRequest')}s.",
        name:"ServerObject",
        seeAlso:[
            {ref:"class:DMI", description:null}
        ],
        type:"class",
        requiresModules:["SCServer"]
    },
    "group:jsStringTag":{
        ref:"group:jsStringTag",
        title:"&lt;isomorphic:jsString&gt;",
        treeLocation:["Java Server Reference/SmartClient JSP Tags"],
        refs:[],
        description:"<i>produces:</i>JavaScript\n <p>\n This tag takes everything in its body and outputs a correctly-escaped JavaScript string.\n This is useful for capturing HTML for display in a Canvas or Label, for example.\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>var</b><br>\n <i>value format</i>: Any legal egal JavaScript variable name\n <i>default value</i>: NONE\n <p>\n If specified, the escaped string is assigned to a newly created variable of the specified\n name.  e.g: var foo = \"bar\";\n <p>\n <b>filename</b><br>\n <i>value format</i>: webRoot-relative path to file\n <i>default value</i>: NONE\n <p>\n If specified, the resulting string contents is loaded from the specified file instead of\n from the tag body.",
        name:"jsStringTag",
        seeAlso:[],
        type:"group",
        requiresModules:["SCServer"]
    },
    "method:ValuesManager.hasErrors":{
        ref:"method:ValuesManager.hasErrors",
        flags:"",
        description:" Are there any errors associated with any fields in this valuesManager?\n",
        name:"hasErrors",
        seeAlso:[],
        returns:{description:"returns true if there are any oustanding validation errors, false                   otherwise.",
         type:"boolean"},
        type:"method",
        definingClass:"class:ValuesManager",
        groups:["errors"]
    },
    "method:Slider.setValue":{
        ref:"method:Slider.setValue",
        flags:"",
        description:" Sets the slider value to newValue and moves the slider thumb to the appropriate position for this\n value. Sends the 'sliderMove' event to the sliderTarget.\n\n",
        name:"setValue",
        seeAlso:[],
        params:[
            {description:"the new value", optional:false, name:"newValue", defaultValue:null,
             type:"float"},
            {description:"do not animate the slider thumb to the new value", optional:false,
             name:"noAnimation", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:Slider"
    },
    "method:FacetValue.formatCellValue":{
        ref:"method:FacetValue.formatCellValue",
        flags:"",
        description:" Formatter to apply to values displayed for cells under this facetValue.\n <P>\n Can only be set on the ${isc.DocUtils.linkForRef('attr:CubeGrid.metricFacetId','metric facet')}, or if no metric facet\n is specified, on the innermost column facet.\n <P>\n If a single, grid-wide formatting style is desired implement\n ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue','grid.formatCellValue()')} instead.\n\n",
        name:"formatCellValue",
        seeAlso:[],
        params:[
            {description:"raw value for the cell being", optional:false, name:"value",
             defaultValue:null, type:"any"},
            {description:"record object for the cell.   Note: If this is a new cell that has not been saved, in an \n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter.",
             optional:false, name:"record", defaultValue:null, type:"CellRecord"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number for the cell.", optional:false, name:"colNum",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"formatted value to display in the cell.", type:"string"},
        type:"method",
        definingClass:"class:FacetValue"
    },
    "class:Label":{
        methods:["method:Label.setIconOrientation", "method:Label.setIcon", "method:Label.setContents"],
        ref:"class:Label",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Foundation"],
        attrs:["attr:Label.contents", "attr:Label.dynamicContents", "attr:Label.align", 
         "attr:Label.valign","attr:Label.wrap", "attr:Label.autoFit", "attr:Label.icon", "attr:Label.iconSize", 
         "attr:Label.iconWidth","attr:Label.iconHeight", "attr:Label.iconOrientation", "attr:Label.iconAlign", 
         "attr:Label.iconSpacing","attr:Label.showDisabledIcon", "attr:Label.showRollOverIcon", "attr:Label.showFocusedIcon", 
         "attr:Label.showDownIcon","attr:Label.showSelectedIcon"],
        description:"Labels display a small amount of ${isc.DocUtils.linkForRef('attr:Label.align','alignable')} ${isc.DocUtils.linkForRef('attr:Label.contents','text')}\n with optional ${isc.DocUtils.linkForRef('attr:Label.icon','icon')} and ${isc.DocUtils.linkForRef('attr:Label.autoFit','autoFit')}.\n <P>\n For a general-purpose container for HTML content, use ${isc.DocUtils.linkForRef('class:HTMLFlow')} or ${isc.DocUtils.linkForRef('class:HTMLPane')}\n instead.",
        name:"Label",
        seeAlso:[],
        type:"class",
        examples:["${isc.DocUtils.linkForExampleId('label')}"]
    },
    "attr:ListGrid.emptyMessageStyle":{
        ref:"attr:ListGrid.emptyMessageStyle",
        flags:"IRW",
        description:"The CSS style name applied to the ${isc.DocUtils.linkForRef('attr:ListGrid.emptyMessage')} if displayed.",
        name:"emptyMessageStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"emptyMessage\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["emptyMessage"]
    },
    "method:Class.logDebug":{
        ref:"method:Class.logDebug",
        flags:"",
        description:" Log a message at \"debug\" priority\n <P>\n A method named log<i>Priority</i> exists for each priority level, on every ISC Class and\n instance of an ISC Class.  Messages logged on a Class or instance have a default\n category of the classname.  Messages logged on an instance will also automatically\n incorporate the instance ID.  General best practice is to call logDebug() et al as\n \"this.logDebug\" whenever \"this\" is an instance, or as \"Log.logDebug\" otherwise.\n\n",
        name:"logDebug",
        seeAlso:[
            {ref:"classMethod:Log.echo", description:"for dumping datastructures to the log"},
            {ref:"classMethod:Log.setPriority",
             description:"for controlling what messages appear in the log"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"method",
        definingClass:"class:Class"
    },
    "attr:TileGrid.animateTileChange":{
        ref:"attr:TileGrid.animateTileChange",
        flags:"IRWA",
        description:"If set, when the dataset changes due to filtering, sorting or other actions, any tiles that\n were showing before and after the change will animate from their old positions to their new\n positions.",
        name:"animateTileChange",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileGrid",
        groups:["appearance"]
    },
    "attr:ListGridRecord._baseStyle":{
        ref:"attr:ListGridRecord._baseStyle",
        flags:"IRW",
        description:"Name of a CSS style to use as the ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')} for all cells for this\n particular record.  \n <P>\n The styleName specified with have suffixes appended to it as the record changes state\n (\"Over\", \"Selected\" and so forth) as described by ${isc.DocUtils.linkForRef('method:ListGrid.getCellStyle')}.  For a\n single, fixed style for a record, use ${isc.DocUtils.linkForRef('attr:ListGridRecord.customStyle')} instead.\n <P>\n See ${isc.DocUtils.linkForRef('method:ListGrid.getCellStyle')} for an overview of various ways to customize styling,\n both declarative and programmatic.\n <P>\n If this property is changed after draw(), to refresh the grid call\n ${isc.DocUtils.linkForRef('method:ListGrid.refreshRow')} (or ${isc.DocUtils.linkForRef('listGrid.markForRedraw')} if several rows are\n being refreshed).\n <P>\n If your application's data uses the \"_baseStyle\" attribute for something else, the\n property name can be changed via ${isc.DocUtils.linkForRef('attr:ListGrid.recordBaseStyleProperty')}.",
        name:"_baseStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord"
    },
    "classMethod:isc.defineClass":{
        ref:"classMethod:isc.defineClass",
        flags:"",
        description:" Shortcut for <code>isc.ClassFactory.defineClass()</code>.\n",
        name:"defineClass",
        seeAlso:[
            {ref:"classMethod:ClassFactory.defineClass", description:null}
        ],
        params:[
            {description:"Name for the new class.", optional:false, name:"className", defaultValue:null,
             type:"string"},
            {description:"Optional SuperClass Class object or name", optional:true, name:"superClass",
             defaultValue:null, type:"Class"}
        ],
        returns:{description:"Returns the new Class object.", type:"Class"},
        type:"classMethod",
        definingClass:"class:isc"
    },
    "attr:Calendar.timelineViewTitle":{
        ref:"attr:Calendar.timelineViewTitle",
        flags:"IR",
        description:"The title for the timeline view",
        name:"timelineViewTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Timeline\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["i18nMessages"]
    },
    "classMethod:Class.logInfo":{
        ref:"classMethod:Class.logInfo",
        flags:"",
        description:" Log a message at \"info\" priority\n \n",
        name:"logInfo",
        seeAlso:[
            {ref:"classMethod:Log.logDebug", description:"for usage info"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "method:ListGrid.saveAllEdits":{
        ref:"method:ListGrid.saveAllEdits",
        flags:"",
        description:" Save a number of outstanding edits for this ListGrid. If no rows are specifed, all \n outstanding edits will be saved\n",
        name:"saveAllEdits",
        seeAlso:[],
        params:[
            {description:"optionally specify which rows to save", optional:true, name:"rows",
             defaultValue:null, type:"array of numbers"},
            {description:"If specified this callback will be fired on a successful save  of the specified rows. Note that if there are no pending edits to be saved this callback will\n  not fire - you can check for this condition using ${isc.DocUtils.linkForRef('method:ListGrid.hasChanges')} or \n  ${isc.DocUtils.linkForRef('method:ListGrid.rowHasChanges')}.",
             optional:true, name:"saveCallback", defaultValue:null, type:"callback"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "attr:ListGrid.animateRemoveRecord":{
        ref:"attr:ListGrid.animateRemoveRecord",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} is enabled, should records be animated out of view\n when they are removed by the user?",
        name:"animateRemoveRecord",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:Canvas.enable":{
        ref:"method:Canvas.enable",
        flags:"",
        description:" Enables this widget and any children / peers of this widget.\n",
        name:"enable",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas",
        groups:["enable"]
    },
    "attr:DynamicForm.unknownErrorMessage":{
        ref:"attr:DynamicForm.unknownErrorMessage",
        flags:"IRW",
        description:"The error message for a failed validator that does not specify its own errorMessage.",
        name:"unknownErrorMessage",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Invalid value\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["validation", "i18nMessages"]
    },
    "attr:Validator.stopIfFalse":{
        ref:"attr:Validator.stopIfFalse",
        flags:"IR",
        description:"Normally, all validators defined for a field will be run even if one of the validators has\n already failed.  However, if <code>stopIfFalse</code> is set, validation will not proceed\n beyond this validator if the check fails.\n <P>\n This is useful to prevent expensive validators from being run unnecessarily, or to allow\n custom validators that don't need to be robust about handling every conceivable type of\n value.",
        name:"stopIfFalse",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Validator"
    },
    "method:DataSource.getDataProtocol":{
        ref:"method:DataSource.getDataProtocol",
        flags:"A",
        description:" Returns the appropriate ${isc.DocUtils.linkForRef('attr:OperationBinding.dataProtocol')} for a ${isc.DocUtils.linkForRef('class:DSRequest')}\n",
        name:"getDataProtocol",
        seeAlso:[],
        params:[
            {description:"DataSource Request object", optional:false, name:"dsRequest",
             defaultValue:null, type:"DSRequest"}
        ],
        returns:{description:"DataProtocol to be used for this request operation.", type:"DSDataProtocol"},
        type:"method",
        definingClass:"class:DataSource"
    },
    "attr:RPCRequest.contentType":{
        ref:"attr:RPCRequest.contentType",
        flags:"IRW",
        description:"Valid with the xmlHttpRequest transport only and only when\n ${isc.DocUtils.linkForRef('attr:RPCRequest.httpMethod')} is set to \"POST\".",
        name:"contentType",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"application/x-www-form-urlencoded\"",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "attr:Facet.isTree":{
        ref:"attr:Facet.isTree",
        flags:"IR",
        description:"Marks this facet as a hierarchical facet.\n <P>\n If set, ${isc.DocUtils.linkForRef('attr:Facet.values','facet.value')} will be linked as for a\n ${isc.DocUtils.linkForRef('attr:Tree.modelType','modelType:\"parent\"')} Tree, using\n ${isc.DocUtils.linkForRef('attr:FacetValue.id','facetValue.id')} and\n ${isc.DocUtils.linkForRef('attr:FacetValue.parentId','facetValue.parentId')}.\n Expand/collapse controls will be shown allowing navigation of the facet's values.\n <P>\n The CubeGrid's ${isc.DocUtils.linkForRef('attr:CubeGrid.dataSource','load on demand')} system automatically avoids\n fetching data for facetValues that are not currently visible due to the expand/collapse\n state of a tree facet.\n <P>\n Initial open/close state can be controlled via\n ${isc.DocUtils.linkForRef('attr:Facet.collapsed','facet.collapsed')} and ${isc.DocUtils.linkForRef('attr:FacetValue.collapsed')}.",
        name:"isTree",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Facet"
    },
    "attr:Menu.autoDismiss":{
        ref:"attr:Menu.autoDismiss",
        flags:"IRW",
        description:"When true, when a menu item is chosen (via mouse click or keyboard), the menu is not \n automatically hidden, staying in place for further interactivity",
        name:"autoDismiss",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Menu"
    },
    "method:ComboBoxItem.fetchData":{
        ref:"method:ComboBoxItem.fetchData",
        flags:"",
        description:" Only applies to databound items (see ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource')}).<br>\n Performs a fetch type operation on this item's DataSource to retrieve the set of valid\n options for the item, based on the current ${isc.DocUtils.linkForRef('attr:PickList.pickListCriteria')}.\n",
        name:"fetchData",
        seeAlso:[],
        params:[
            {description:"Callback to fire when the fetch completes. Callback will               fire with 2 parameters: <code>item</code> a pointer to the form item and\n              <code>dsResponse</code> the ${isc.DocUtils.linkForRef('class:DSResponse')} returned by the server.",
             optional:false, name:"callback", defaultValue:null, type:"callback"},
            {description:"properties to apply to the              dsRequest for this fetch.",
             optional:false, name:"requestProperties", defaultValue:null, type:"dsRequest properties"}
        ],
        type:"method",
        definingClass:"class:ComboBoxItem"
    },
    "attr:Validator.clientOnly":{
        ref:"attr:Validator.clientOnly",
        flags:"IR",
        description:"Indicates this validator runs on the client only.\n <p>\n Normally, if the server is trying to run validators and finds a validator that it can't\n execute, for safety reasons validation is considered to have failed.  Use this flag to\n explicitly mark a validator that only needs to run on the client.",
        name:"clientOnly",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Validator"
    },
    "group:monthViewFormatting":{
        ref:"group:monthViewFormatting",
        refs:["method:Calendar.getDayBodyHTML"],
        name:"monthViewFormatting",
        seeAlso:[],
        type:"group"
    },
    "attr:RowSpacerItem.startRow":{
        ref:"attr:RowSpacerItem.startRow",
        flags:"IRW",
        description:"these items are in a row by themselves by default",
        name:"startRow",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RowSpacerItem",
        groups:["appearance"]
    },
    "attr:GridRenderer.canSelectOnRightMouse":{
        ref:"attr:GridRenderer.canSelectOnRightMouse",
        flags:"RW",
        description:"If true, rightMouseDown events will fire 'selectOnRightMouseDown()' for the appropriate cells.",
        name:"canSelectOnRightMouse",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "method:DynamicForm.setValues":{
        ref:"method:DynamicForm.setValues",
        flags:"",
        description:" Replaces the current values of the entire form with the values passed in.\n <P>\n Note: when working with a form that is saving to a DataSource, you would typically call\n either ${isc.DocUtils.linkForRef('method:DynamicForm.editRecord')} for an existing record, or ${isc.DocUtils.linkForRef('method:DynamicForm.editNewRecord')} for a new\n record.  In addition to setting the current values of the form, these APIs establish the\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType')} used to save (\"update\" vs \"add\").\n <P>\n Values should be provided as an Object containing the new values as properties, where each\n propertyName is the name of a ${isc.DocUtils.linkForRef('group:Items','form item')} in the form, and each property value is\n the value to apply to that form item via ${isc.DocUtils.linkForRef('method:FormItem.setValue')}. \n <P>\n Values with no corresponding form item may also be passed, will be tracked by the form\n and returned by subsequent calls to ${isc.DocUtils.linkForRef('method:DynamicForm.getValues')}.\n <P>\n Any ${isc.DocUtils.linkForRef('class:FormItem')} for which a value is not provided will revert to its\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue','defaultValue')}.  To cause all FormItems to revert to default\n values, pass null.\n <P>\n This method also calls ${isc.DocUtils.linkForRef('method:DynamicForm.rememberValues')} so that a subsequent later call to\n ${isc.DocUtils.linkForRef('method:DynamicForm.resetValues')} will revert to the passed values.\n <P>\n\n",
        name:"setValues",
        seeAlso:[],
        params:[
            {description:"values for the form, or null to reset all items to default values",
             optional:true, name:"newData", defaultValue:null, type:"Object"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["formValues"]
    },
    "method:FormItem.isDisabled":{
        ref:"method:FormItem.isDisabled",
        flags:"A",
        description:"  Is this item disabled?\n",
        name:"isDisabled",
        seeAlso:[
            {ref:"attr:FormItem.disabled", description:null}
        ],
        returns:{description:"disabledtrue if this item is be disabled", type:"boolean"},
        type:"method",
        definingClass:"class:FormItem",
        groups:["enable"]
    },
    "attr:DataSourceField.validators":{
        ref:"attr:DataSourceField.validators",
        flags:"IR",
        description:"Validators to be applied to this field.\n <p>\n Validators are applied whenever there is an attempt to save changes to a field.\n <p>\n For the available set of built-in validators, and how to define a custom validator, see the\n ${isc.DocUtils.linkForRef('class:Validator')} class.",
        name:"validators",
        seeAlso:[
            {ref:"class:Validator", description:null}
        ],
        valueType:"Array of Validator",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["dataType", "validation"]
    },
    "method:Class.ignore":{
        ref:"method:Class.ignore",
        flags:"A",
        description:"		Stop observing a method on some other object.\n\n",
        name:"ignore",
        seeAlso:[
            {ref:"method:Class.observe", description:null}
        ],
        params:[
            {description:"object to observe", optional:false, name:"object", defaultValue:null,
             type:"object"},
            {description:"name of the method to observe", optional:false, name:"methodName",
             defaultValue:null, type:"string"}
        ],
        returns:{description:"true == observation stopped, false == no change made", type:"boolean"},
        type:"method",
        definingClass:"class:Class",
        groups:["observation"]
    },
    "attr:CubeGrid.canResizeColumns":{
        ref:"attr:CubeGrid.canResizeColumns",
        flags:"IRW",
        description:"If true, body columns can be resized via the innermost column headers.",
        name:"canResizeColumns",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["gridLayout"]
    },
    "attr:GridRenderer.alternateRowFrequency":{
        ref:"attr:GridRenderer.alternateRowFrequency",
        flags:"IRW",
        description:"The number of consecutive rows to draw in the same style before alternating, when\n alternateRowStyles is true.",
        name:"alternateRowFrequency",
        seeAlso:[],
        valueType:"number",
        defaultValue:"1",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["cellStyling"]
    },
    "attr:TextItem.showHintInField":{
        ref:"attr:TextItem.showHintInField",
        flags:"IRWA",
        description:"If showing hint for this form item, should it be shown within the field?\n <P>Note when this property is true, ${isc.DocUtils.linkForRef('attr:FormItem.hintStyle')} is not used -\n class \"textItemHint\" is always used.",
        name:"showHintInField",
        seeAlso:[
            {ref:"attr:FormItem.hint", description:null}
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TextItem",
        groups:["appearance"]
    },
    "attr:FilterBuilder.removeButtonPrompt":{
        ref:"attr:FilterBuilder.removeButtonPrompt",
        flags:"IR",
        description:"The hover prompt text for the remove button.",
        name:"removeButtonPrompt",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Remove\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:["i18nMessages"]
    },
    "attr:CubeGrid.canMinimizeColumns":{
        ref:"attr:CubeGrid.canMinimizeColumns",
        flags:"IRW",
        description:"If true, allow columns in the grid body to be minimized (reduced to the width of the\n minimize control) by clicking on a minimize control in the innermost column headers.",
        name:"canMinimizeColumns",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["gridLayout"]
    },
    "method:String.contains":{
        ref:"method:String.contains",
        flags:"",
        description:"			Returns true if this string contains the specified substring.\n",
        name:"contains",
        seeAlso:[],
        params:[
            {description:"string to look for", optional:false, name:"substring", defaultValue:null,
             type:"String"}
        ],
        returns:{description:"true == this string contains the substring", type:"boolean"},
        type:"method",
        definingClass:"class:String",
        groups:["stringProcessing"]
    },
    "attr:OperationBinding.callbackParam":{
        ref:"attr:OperationBinding.callbackParam",
        flags:"IR",
        description:"Applies only to dataFormat: \"json\".  Specifies the name of the query parameter that\n tells your JSON service what function to call as part of the response for this operation.\n <P>\n Typically set once for the DataSource as a whole via ${isc.DocUtils.linkForRef('attr:DataSource.callbackParam')}.",
        name:"callbackParam",
        seeAlso:[
            {ref:"attr:DataSource.callbackParam", description:null}
        ],
        valueType:"String",
        defaultValue:"\"callback\"",
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:["clientDataIntegration"]
    },
    "attr:DynamicForm.valuesManager":{
        ref:"attr:DynamicForm.valuesManager",
        flags:"IA",
        description:"If set at init time, this dynamicForm will be created as a member form for the\n specified valuesManager.  To update the valuesManager to which a form belongs after init\n use <code>valuesManager.addMember(form)</code> and \n <code>valuesManager.removeMember(form)</code>",
        name:"valuesManager",
        seeAlso:[
            {ref:"class:ValuesManager", description:null}
        ],
        valueType:"ValuesManager instance or global ID",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["formValuesManager"]
    },
    "class:HTMLFlow":{
        methods:["method:HTMLFlow.setContentsURL", "method:HTMLFlow.loadingContent", 
         "method:HTMLFlow.handleError","method:HTMLFlow.transformHTML", "method:HTMLFlow.contentLoaded"],
        type:"class",
        ref:"class:HTMLFlow",
        classAttrs:[],
        treeLocation:["Client Reference/Foundation"],
        classMethods:[],
        description:"Use the HTMLFlow component to display HTML content that should expand to its natural size\n without scrolling.  \n <p>\n HTML content can be loaded and reloaded from a URL via the property\n <code>contentsURL</code>.  This method of loading is for simple HTML content\n only; SmartClient components should be loaded via the ${isc.DocUtils.linkForRef('class:ViewLoader')} class.\n <P>\n NOTE: Since the size of an HTMLFlow component is determined by its HTML contents, this\n component will draw at varying sizes if given content of varying size.  When using HTMLFlow\n components within a Layout, consider what will happen if the HTMLFlow renders at various\n sizes.  An HTMLFlow which can expand should be placed in a container where other components\n can render smaller, where the container is allowed to scroll, or where there is padding to\n expand into.",
        attrs:["attr:HTMLFlow.contents", "attr:HTMLFlow.dynamicContents", "attr:HTMLFlow.contentsURL", 
         "attr:HTMLFlow.loadingMessage","attr:HTMLFlow.contentsURLParams", "attr:HTMLFlow.httpMethod", 
         "attr:HTMLFlow.contentsType","attr:HTMLFlow.allowCaching", "attr:HTMLFlow.evalScriptBlocks", 
         "attr:HTMLFlow.captureSCComponents"],
        name:"HTMLFlow",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('htmlFlow')}"],
        groups:["contentLoading"]
    },
    "attr:StretchImgButton.showFocusedIcon":{
        ref:"attr:StretchImgButton.showFocusedIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the button\n recieves focus.\n <P>\n If ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true, the <code>\"Over\"</code> icon will be\n displayed when the canvas has focus, otherwise a seperate <code>\"Focused\"</code> icon\n will be displayed",
        name:"showFocusedIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["buttonIcon"]
    },
    "type:RPCTransport":{
        ref:"type:RPCTransport",
        values:[
            {description:"Uses the XMLHttpRequest object to make the request to the server. Note that in some browsers with certain configurations, this transport may not be\n available.  See ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information.  This transport is\n not useful with file uploads.  Cannot be used to target cross-domain URLs directly.",
             value:"\"xmlHttpRequest\""},
            {description:"Write a SCRIPT tag into the DOM with a SRC attribute that targets an arbitrary URL.  This transport is the only one that allows direct cross-domain URL\n access.  \n <P>\n For ${isc.DocUtils.linkForRef('attr:RPCRequest.callback')} to work, the server being contacted must support the ability\n to generate JavaScript code in the response that will call a JavaScript function generated\n by SmartClient.  SmartClient passes the name of the function to call via a URL parameter,\n which can be controlled with ${isc.DocUtils.linkForRef('attr:RPCRequest.callbackParam')}.",
             value:"\"scriptInclude\""},
            {description:"Available with SmartClient Server only.  An HTML form is dynamically assembled that targets a hidden IFRAME.  This mechanism is supported on all\n browsers and cannot be disabled by end users.  \n <P>\n If using the SmartClient Server and using \n ${isc.DocUtils.linkForRef('group:serverDataIntegration','Server-side data integration')}, the \"hiddenFrame\" transport\n is automatically used for all RPCManager and DataSource requests if the \"xmlHttpRequest\"\n transport is not available.\n <P>\n Cannot be used to target cross-domain URLs directly.",
             value:"\"hiddenFrame\""}
        ],
        description:"SmartClient supports multiple RPC transports for maximum compatibility and feature richness.\n All of transports use HTTP as the underlying protocol, but use different mechanisms for\n sending the HTTP request and processing the response.  The transport is typically\n auto-selected for by based on the feature being used and the current browser settings.  For\n advanced use cases, ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')} and ${isc.DocUtils.linkForRef('classAttr:RPCManager.defaultTransport')} are\n exposed as override points.\n <p>",
        name:"RPCTransport",
        seeAlso:[],
        type:"type"
    },
    "attr:Tree.defaultNodeTitle":{
        ref:"attr:Tree.defaultNodeTitle",
        flags:"IRW",
        description:"Title assigned to nodes without a ${isc.DocUtils.linkForRef('attr:Tree.titleProperty')} value or a\n ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} value.",
        name:"defaultNodeTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Untitled\"",
        type:"attr",
        definingClass:"class:Tree"
    },
    "class:HStack":{
        methods:[],
        exampleConfig:"HStack.xml",
        ref:"class:HStack",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Layout"],
        attrs:[],
        description:"A subclass of Layout that simply stacks members on the horizontal axis without trying to\n manage their width.  On the vertical axis, any members that do not have explict heights will\n be sized to match the height of the stack.",
        name:"HStack",
        seeAlso:[
            {ref:"attr:Layout.hPolicy", description:null}
        ],
        type:"class"
    },
    "method:ListGrid.getEditCol":{
        ref:"method:ListGrid.getEditCol",
        flags:"",
        description:"\n  Returns the index of the column being edited or null if there is no edit col.\n\n",
        name:"getEditCol",
        seeAlso:[],
        returns:{description:"Index of the current edit column", type:"number"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "group:autoChildren":{
        ref:"group:autoChildren",
        refs:["method:Class.addAutoChild", "method:Class.createAutoChild", "type:AutoChild"],
        description:"An autoChild is an automatically generated subcomponent that a component creates to\n handle part of its presentation or functionality.\n <P>\n An example is the Window component and its subcomponent the \"header\".\n <P>\n AutoChildren support a standard set of properties that can be used to customize or skin\n them.\n <P>\n This topic explains how to use the autoChild system when creating custom components in\n order to create maximum flexibility.  To learn how to use the autoChild system with \n pre-existing components, ${isc.DocUtils.linkForRef('type:AutoChild','go here')}.  \n <P>\n Before reading this topic, be sure you have read the ${isc.DocUtils.linkForDocNode('QuickStart Guide')}\n material on creating custom components and have reviewed the provided examples.\n <P>\n <h3>Basics</h3>\n <P>\n The following is an example of creating subcomponents <b>without</b> using the AutoChild\n pattern.  In this case a fictitious \"Portlet\" class is being created, which uses an\n instance of isc.Label to serve as it's header.\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         this.headerLabel = isc.Label.create({\n             autoDraw:false,\n             contents: this.title, \n             styleName: this.titleStyleName,\n             portlet:this,\n             click : function () { this.portlet.bringToFront() },\n             wrap:false,  \n             overflow:\"hidden\", \n             width:\"100%\"\n         });\n         this.addMember(this.headerLabel);\n         ...\n </pre>\n While straightforward, this approach provides limited flexibility to someone using the\n \"Portlet\" class.  There is no way to:\n <ol>\n <li> avoid creating the headerLabel, for a \"headerless\" portlet\n <li> use a different, more advanced class as a header (eg, StretchImgButton or a custom \n class)\n <li> skin the headerLabel, other than CSS (rounded corners, animations, etc, wouldn't be\n possible)\n <li> change it's layout behavior (eg enable autoSize)\n <li> add or override event handlers\n </ol>\n Let's imagine we wanted to add some of the above features.  We could change the code\n like so:\n <P>\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     <b>showHeaderLabel:true,</b>\n     <b>headerLabelConstructor:isc.Label,</b>\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         <b>if (this.showHeaderLabel) {</b>\n             this.headerLabel = this.headerLabelConstructor.create({\n                 autoDraw:false,\n                 contents: this.title, \n                 styleName: this.titleStyleName,\n                 portlet:this,\n                 click : function () { this.portlet.bringToFront() },\n                 wrap:false,  \n                 overflow:\"hidden\", \n                 width:\"100%\"\n             }<b>, this.headerLabelProperties</b>);\n             this.addMember(this.headerLabel);\n         <b>}</b>\n         ...\n </pre>\n Our additions solve our initial concerns:\n <ul>\n <li> <code>showHeaderLabel:false</code> can be set to suppress the header label\n <li> <code>headerLabelConstructor</code> allows you to switch to a different class\n <li> <code>headerLabelProperties</code> give you a means to add arbitrary properties\n (skinning properties, sizing properties, event handlers, etc)\n </ul>\n However, the code is becoming more verbose and repetitive, and we've created a few\n additional properties that now need documentation and testing.  This extra work is going\n to be multiplied by every subcomponent we create where we want this kind of flexibility.\n <P>\n Enter the AutoChild system: the purpose of the AutoChild system is to define a standard\n pattern for creating subcomponents with maximum flexibility.  This means:\n <ul>\n <li> developers creating custom components write less code, have less to test and less\n to document\n <li> developers can more easily understand each other's code for custom components,\n because it follows a standard pattern\n <li> developers <b>using</b> custom components have a standard pattern for\n customization, instead of learning customization APIs for every component separately\n </ul>\n The code below uses the autoChild system to create the \"headerLabel\" subcomponent.  This\n version of the code would still respect all of the customization properties from earlier\n examples (<code>headerLabelProperties</code> et al) and offers several additional degrees\n of flexibility still to be explained, yet it's significantly shorter.  More importantly,\n this code is less redundant; the \"boilerplate\" code is gone and what's left is just the\n actual settings for the headerLabel subcomponent.\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     headerLabelDefaults : {\n         _constructor:isc.Label,\n         click : function () { this.creator.bringToFront() },\n         wrap:false,  \n         overflow:\"hidden\", \n         width:\"100%\"\n     },\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         this.addAutoChild(\"headerLabel\", {\n             contents: this.title, \n             styleName: this.titleStyleName\n         });\n         ...\n </pre>\n <P>\n The documentation for ${isc.DocUtils.linkForRef('method:Class.addAutoChild','addAutoChild()')} explains why this code\n will still respect the <code>showHeaderLabel</code> flag and other customization\n properties even though they aren't mentioned specifically.\n <P>\n <h3>Subclassing a component with autoChildren</h3>\n <P>\n If you are subclassing a component that has an autoChild and you want to change\n defaults for that autoChild, the correct way to do so is to use\n ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults','changeDefaults()')}:\n <pre>\n isc.defineClass(\"MyWindow\", \"Window\");\n isc.MyWindow.changeDefaults(\"headerDefaults\", { layoutMargin:10 });\n isc.MyWindow.addProperties({ \n    ...\n </pre>\n <P>\n <code>changeDefaults()</code> creates a copy of the superclass defaults and applies your\n changes, which is important because you want to inherit the superclass behavior without\n affecting the superclass, and yet apply overrides.\n <P>\n The following code sample indicates two common \n <span style=\"color:red;font-weight:bold\">incorrect</span> patterns for working with\n defaults, and the consequences of each: \n <pre>\n isc.defineClass(\"MyWindow\", \"Window\").addProperties({\n     // NO.  Superclass behavior / settings for autoChild\n     // won't be inherited.  Use changeDefaults() instead.\n     headerDefaults : { ... },\n \n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         // NO.  \"headerDefaults\" object is shared across the class,\n         // changing it affects all instances created from here on.\n         // Pass dynamic defaults to addAutoChild() instead\n         this.headerDefaults.myProperty = this.newValue;\n         ...\n });\n </pre>\n <b>defaults vs properties</b>\n <P>\n For AutoChildren, defaults and properties both provide similar means of adding\n properties to an AutoChild, and the distinction between them is primarily one of\n convention: a class that uses AutoChildren should never define a default value for\n <i>autoChildName</i>Properties, so that instances can freely specify\n <i>autoChildName</i>Properties without overriding built-in behavior.\n <pre>\n isc.defineClass(\"MyWindow\", \"Window\").addProperties({\n     // NO.  Any further use of \"headerProperties\", in\n     // instances or in subclasses, would wipe out behavior\n     headerProperties : { ... },\n </pre>\n <P>\n By consistently using ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults')} whenever you override autoChild\n defaults in a subclass, you ensure that your classes can in turn be subclassed and\n extended uniformly.\n <P>\n <h3>autoParents and creation order</h3>\n <P>\n The AutoChild pattern can create an entire hierarchy of generated subcomponents.  For\n example, the ${isc.DocUtils.linkForRef('class:Window')} class included with SmartClient uses several AutoChildren as\n part of the overall header structure: separate autoChildren for the minimize button,\n close button, and then the header itself, a Layout-derived class that contains all other\n header controls. \n <P>\n To facilitate construction of hierarchies of autoChildren, the special\n <code>autoParent</code> property may appear in either defaults or properties for an\n autoChild, and indicates the name of another autoChild that should used as a parent.\n For example, to create a \"closeButton\" autoChild that will be a member of the \"header\"\n autoChild:\n <P>\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     headerDefaults : {\n         _constructor:isc.HLayout,\n         ...\n     },\n     closeButtonDefaults : {\n         <b>autoParent:\"header\",</b>\n         _constructor:isc.ImgButton,\n         ...\n     },\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         this.addAutoChild(\"header\");\n         this.addAutoChild(\"closeButton\");\n         ...\n </pre>\n <P>\n In addition to cutting down on code and making inter-autoChild relationships clearer,\n using <code>autoParent</code> rather than manual calls to addMember() allows a\n subclass of your component to potentially completely rearrange the autoChildren you have\n defined, while retaining their behavior.\n <P>\n When using <code>autoParent</code> to arrange autoChildren, create parents first, then\n children.\n <P>\n <b>Tip:</b> if you want all of the behaviors of\n ${isc.DocUtils.linkForRef('method:Class.addAutoChild','addAutoChild()')} <i>except</i> automatically adding the\n autoChild to a parent, set <code>autoParent:\"none\"</code>.\n <P>\n <b>special case: TabSets and SectionStacks</b>\n <p>\n An autoChild that appears as a ${isc.DocUtils.linkForRef('attr:Tab.pane')} or\n ${isc.DocUtils.linkForRef('attr:SectionStackSection.items','section item')} does not have a clear way to refer to it's\n tab or section via the <code>autoParent</code> property.  For this special case, the\n TabSet and SectionStack components allow tab.pane / section.items to contain the special\n string \"autoChild:<i>autoChildName</i>\".  This will cause the corresponding autoChild to be\n automatically created when the tab is selected or section expanded.\n <P>\n For example:\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     ...\n     mainTabsDefaults : {\n         _constructor:isc.TabSet,\n         tabs : [\n             { title:\"First Pane\", pane:\"autoChild:firstPane\" }\n         ]\n     },\n     firstPaneDefaults : {\n         ...\n     },\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         // this automatically creates firstPane as an autoChild\n         this.addAutoChild(\"mainTabs\");\n         ...\n </pre>",
        name:"autoChildren",
        seeAlso:[],
        type:"group"
    },
    "method:Layout.drop":{
        ref:"method:Layout.drop",
        flags:"A",
        description:" Layouts have built-in handling of component drag and drop.  See the discussion in\n ${isc.DocUtils.linkForRef('class:Layout')} on how it works.  If you override this builtin implementation of drop() and\n you're using the built-in dropLine via ${isc.DocUtils.linkForRef('attr:Layout.canDropComponents')}:true, be sure to call\n ${isc.DocUtils.linkForRef('method:Layout.hideDropLine')} to hide the dropLine after doing your custom drop() handling.\n\n",
        name:"drop",
        seeAlso:[],
        returns:{description:"Returning false will cancel the drop entirely", type:"boolean"},
        type:"method",
        definingClass:"class:Layout"
    },
    "attr:EdgedCanvas.centerBackgroundColor":{
        ref:"attr:EdgedCanvas.centerBackgroundColor",
        flags:"IR",
        description:"Background color for the center section only.  Can be used as a surrogate background\n color for the decorated Canvas, if the Canvas is set to partially overlap the edges and\n hence can't show a background color itself without occluding media.",
        name:"centerBackgroundColor",
        seeAlso:[],
        valueType:"cssColor",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:EdgedCanvas",
        groups:["imageEdges"]
    },
    "group:prompt":{
        ref:"group:prompt",
        refs:[],
        name:"prompt",
        seeAlso:[],
        type:"group"
    },
    "method:ListGrid.clearRowErrors":{
        ref:"method:ListGrid.clearRowErrors",
        flags:"",
        description:"  Clear any stored validation errors for some row\n",
        name:"clearRowErrors",
        seeAlso:[
            {ref:"method:ListGrid.setRowErrors", description:null}
        ],
        params:[
            {description:"index of row to clear validation error for", optional:false, name:"rowNum",
             defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["validtion"]
    },
    "method:ListGrid.displayHeaderContextMenu":{
        ref:"method:ListGrid.displayHeaderContextMenu",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu')} is <code>true</code> this method is fired\n when the user right-clicks on the header for this grid.<br>\n Default implementation will display a menu with entries derived from\n ${isc.DocUtils.linkForRef('method:ListGrid.getHeaderContextMenuItems')} for the appropriate column.\n",
        name:"displayHeaderContextMenu",
        seeAlso:[
            {ref:"attr:ListGrid.showHeaderContextMenu", description:null}
        ],
        params:[
            {description:"which button in the header recieved the right-click event                         (may be the sorter button)",
             optional:false, name:"target", defaultValue:null, type:"Canvas"},
            {description:"Optional 2-element array specifying position at which the menu should                           be shown. If this is not passed in the menu will be shown at the\n                           mouseEvent position (default context menu behavior).",
             optional:true, name:"position", defaultValue:null, type:"Array"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["gridHeader"]
    },
    "attr:DetailViewer.showEmptyField":{
        ref:"attr:DetailViewer.showEmptyField",
        flags:"IRWA",
        description:"Whether to show the field when the value is null",
        name:"showEmptyField",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:["appearance"]
    },
    "method:Canvas.scrollToRight":{
        ref:"method:Canvas.scrollToRight",
        flags:"",
        description:" Horizontally scrolls the content of the widget to the end of its content\n\n",
        name:"scrollToRight",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas",
        groups:["scrolling"]
    },
    "method:CubeGrid.deselectAll":{
        ref:"method:CubeGrid.deselectAll",
        flags:"",
        description:"\n  deselect all cells and facetValues\n\n      <br><i>methodType</i> action\n",
        name:"deselectAll",
        seeAlso:[],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "classAttr:Operators.orTitle":{
        ref:"classAttr:Operators.orTitle",
        flags:"IR",
        description:"Title for the \"or\" operator",
        name:"orTitle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"Match Any\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:["i18nMessages"]
    },
    "attr:ImgSplitbar.canCollapse":{
        ref:"attr:ImgSplitbar.canCollapse",
        flags:"IRW",
        description:"If this property is true, a click on the Splitbar will collapse its \n ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}, hiding it and shifting the Splitbar and other members\n of the layout across to fill the newly available space. If the target is already hidden\n a click will expand it again (showing it at it's normal size).",
        name:"canCollapse",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ImgSplitbar"
    },
    "attr:ListGridField.defaultGroupingMode":{
        ref:"attr:ListGridField.defaultGroupingMode",
        flags:"IR",
        description:"Default groupingMode used when the user does not specify a mode or grouping is triggered\n programmatically and ${isc.DocUtils.linkForRef('attr:ListGridField.groupingMode','field.groupingMode')} is unset.\n See ${isc.DocUtils.linkForRef('attr:ListGridField.groupingModes','field.groupingModes')}.",
        name:"defaultGroupingMode",
        seeAlso:[],
        valueType:"identifier",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["grouping"]
    },
    "group:cacheSync":{
        ref:"group:cacheSync",
        refs:["attr:DSResponse.invalidateCache", "attr:ResultSet.initialData", 
         "attr:ResultSet.initialLength","attr:ResultSet.allRows", "attr:ResultSet.updateCacheFromRequest", 
         "attr:ResultSet.dropCacheOnUpdate","attr:ResultSet.disableCacheSync", "attr:ResultSet.neverDropUpdatedRows", 
         "attr:ResultSet.updatePartialCache","attr:ResultTree.updateCacheFromRequest", "attr:ResultTree.disableCacheSync"],
        name:"cacheSync",
        seeAlso:[],
        type:"group"
    },
    "method:Layout.showMember":{
        ref:"method:Layout.showMember",
        flags:"",
        description:" Show the specified member, firing the specified callback when the hide is complete.\n <P>\n Members can always be directly shown via <code>member.show()</code>, but if\n ${isc.DocUtils.linkForRef('attr:Layout.animateMembers','animation')} is enabled, animation will only occur if showMember() is\n called to show the member.\n\n",
        name:"showMember",
        seeAlso:[],
        params:[
            {description:"Member to show", optional:false, name:"member", defaultValue:null,
             type:"Canvas"},
            {description:"action to fire when the member has been shown", optional:false,
             name:"callback", defaultValue:null, type:"Callback"}
        ],
        type:"method",
        definingClass:"class:Layout"
    },
    "group:submitting":{
        ref:"group:submitting",
        refs:["method:DynamicForm.cancel", "method:ValuesManager.cancel", 
         "method:DynamicForm.submitForm","method:DynamicForm.submitValues", "method:SearchForm.search", "attr:DynamicForm.action", 
         "attr:DynamicForm.target","attr:DynamicForm.method", "attr:DynamicForm.encoding", "attr:DynamicForm.canSubmit", 
         "attr:DynamicForm.saveOnEnter","type:FormMethod", "type:Encoding"],
        description:"Direct submission of forms to a target URL\n <P>\n <b>NOTE:</b> directly submitting forms is only done for specialized purposes, such as\n integration with certain legacy systems.  Normal form usage contacts the server via \n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')}, through the RPCManager system.",
        name:"submitting",
        seeAlso:[],
        type:"group"
    },
    "attr:SelectOtherItem.separatorTitle":{
        ref:"attr:SelectOtherItem.separatorTitle",
        flags:"IRW",
        description:"Title for the separator between normal items and the <code>Other...</code> item in the drop\n down list.  Selecting this item will not change the FormItem's value.",
        name:"separatorTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"--------------------\"",
        type:"attr",
        definingClass:"class:SelectOtherItem",
        groups:["appearance"]
    },
    "attr:FilterBuilder.addButton":{
        ref:"attr:FilterBuilder.addButton",
        flags:"IR",
        description:"An ImgButton that allows new clauses to be added if ${isc.DocUtils.linkForRef('attr:FilterBuilder.showAddButton')}\n is set.",
        name:"addButton",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "attr:TreeGrid.showCustomIconOpen":{
        ref:"attr:TreeGrid.showCustomIconOpen",
        flags:"IRWA",
        description:"Should folder nodes showing custom icons (set via the ${isc.DocUtils.linkForRef('attr:TreeGrid.customIconProperty')}),\n show open state images when the folder is opened.\n If true, the ${isc.DocUtils.linkForRef('attr:TreeGrid.openIconSuffix')} will be appended to the image URL\n (so <code>\"customFolder.gif\"</code> might be replaced with \n <code>\"customFolder_open.gif\"</code>).<br>\n <b>Note</b> that the ${isc.DocUtils.linkForRef('attr:TreeGrid.closedIconSuffix')} is never appended to custom folder icons.<br>\n Can be overridden at the node level via the ${isc.DocUtils.linkForRef('attr:TreeGrid.customIconOpenProperty')} property.",
        name:"showCustomIconOpen",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "method:ListGrid.groupBy":{
        ref:"method:ListGrid.groupBy",
        flags:"",
        description:" Display the current set of records grouped by their values for the given field or\n fields. With no arguments, disables all grouping.\n <P>\n Grouping tranforms the current dataset into a Tree on the fly, then provides a familiar tree\n interface for exploring the grouped data.\n <P>\n Grouping works automatically with any dataset, providing simple default grouping based on\n each field's declared type.  However, you can use the\n ${isc.DocUtils.linkForRef('method:ListGridField.getGroupValue','field.getGroupValue()')} API to control how records are\n grouped, and the ${isc.DocUtils.linkForRef('method:ListGridField.getGroupTitle','field.getGroupTitle()')} API to control\n how groups are titled.\n <P>\n Grouping can be performed programmatically via this API, or you can set\n ${isc.DocUtils.linkForRef('attr:ListGrid.canGroupBy','grid.canGroupBy:true')} to enable menus that allow the user to performing\n grouping. To group a grid automatically, instantiate the grid with a\n  ${isc.DocUtils.linkForRef('attr:ListGrid.groupByField')} setting.\n <P>\n While grouped, the automatically created Tree is available as\n ${isc.DocUtils.linkForRef('attr:ListGrid.groupTree','grid.groupTree')} and the original dataset is availabe as\n ${isc.DocUtils.linkForRef('attr:ListGrid.originalData','grid.originalData')}.\n\n",
        name:"groupBy",
        seeAlso:[],
        params:[
            {description:"name of fields to group by", optional:true, name:"arguments 0-N",
             defaultValue:null, type:"String"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('dynamicGrouping')}"],
        definingClass:"class:ListGrid",
        groups:["grouping"]
    },
    "attr:Layout.layoutLeftMargin":{
        ref:"attr:Layout.layoutLeftMargin",
        flags:"IRW",
        description:"Space outside of all members, on the left-hand side.  Defaults to ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')}.\n <P>\n Requires a manual call to <code>setLayoutMargin()</code> if changed on the fly.",
        name:"layoutLeftMargin",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        groups:["layoutMargin"]
    },
    "method:Class.getClass":{
        ref:"method:Class.getClass",
        flags:"",
        description:"	\n	Gets a pointer to the class object for this instance\n\n",
        name:"getClass",
        seeAlso:[],
        returns:{description:"Class object that was used to construct this object", type:"Class"},
        type:"method",
        definingClass:"class:Class"
    },
    "attr:Splitbar.skinImgDir":{
        ref:"attr:Splitbar.skinImgDir",
        flags:"IR",
        description:"Default directory for skin images (those defined by the class), relative to the\n Page-wide ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','skinDir')}.",
        name:"skinImgDir",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Splitbar",
        groups:["images"]
    },
    "attr:Calendar.leadingDateField":{
        ref:"attr:Calendar.leadingDateField",
        flags:"IR",
        description:"The name of the end date field in a ${isc.DocUtils.linkForRef('object:CalendarEvent')}.",
        name:"leadingDateField",
        seeAlso:[
            {ref:"object:CalendarEvent", description:null}
        ],
        valueType:"String",
        defaultValue:"\"leadingDate\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["calendarEvent"]
    },
    "group:filterEditor":{
        ref:"group:filterEditor",
        refs:["method:ListGrid.focusInFilterEditor", "method:ListGrid.filterByEditor", 
         "method:ListGrid.setShowFilterEditor","method:ListGrid.getFilterEditorValueMap", "method:ListGrid.getFilterEditorType", 
         "attr:ListGridField.canFilter","attr:ListGridField.filterEditorValueMap", "attr:ListGridField.filterEditorType", 
         "attr:ListGridField.defaultFilterValue","attr:ListGridField.filterEditorProperties", "attr:ListGridField.filterOnKeypress", 
         "attr:ListGrid.fetchDelay","attr:ListGrid.showFilterEditor", "attr:ListGrid.filterEditorHeight", 
         "attr:ListGrid.filterByCell","attr:ListGrid.filterOnKeypress"],
        name:"filterEditor",
        seeAlso:[],
        type:"group"
    },
    "attr:RPCRequest.promptCursor":{
        ref:"attr:RPCRequest.promptCursor",
        flags:"IRW",
        description:"Controls the cursor shown when ${isc.DocUtils.linkForRef('classAttr:RPCManager.promptStyle')} is set to\n <code>\"cursor\"</code> for this request only. Defaults to ${isc.DocUtils.linkForRef('classAttr:RPCManager.promptCursor')}.\n <p>\n In Safari, IE 5.5 and Firefox 1.0 the default value is \"wait\", on all other platforms it is\n \"progress\".  The reason for this split is that the above-mentioned browsers do not support\n CSS2.1 - which is required for the \"progress\" cursor type.",
        name:"promptCursor",
        seeAlso:[
            {ref:"classAttr:RPCManager.promptCursor", description:null}
        ],
        valueType:"String",
        defaultValue:"browser-dependent",
        type:"attr",
        definingClass:"class:RPCRequest",
        groups:["rpcPrompt"]
    },
    "attr:ListGrid.bodyBackgroundColor":{
        ref:"attr:ListGrid.bodyBackgroundColor",
        flags:"IRW",
        description:"Background color applied to the ListGrid body (that is, the area of the grid where\n data values are rendered).<br>\n Note that this will typically not be visible to the user unless there are few enough\n rows that there is visible space in the body below the last row. To style data cells,\n override ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')} instead.",
        name:"bodyBackgroundColor",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"white\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["appearance"]
    },
    "method:Canvas.updateHover":{
        ref:"method:Canvas.updateHover",
        flags:"A",
        description:" If this canvas is currently showing a hover (see ${isc.DocUtils.linkForRef('method:Canvas.handleHover')}), this method\n can be called to update the contents of the hover. Has no effect if the hover canvas is not\n showing for this widget.\n",
        name:"updateHover",
        seeAlso:[],
        params:[
            {description:"Option to specify new HTML for the hover. If not passed, the result   of ${isc.DocUtils.linkForRef('method:Canvas.getHoverHTML','this.getHoverHTML()')} will be used instead. Note that if the\n   hover HTML is empty the hover will be hidden.",
             optional:true, name:"hoverHTML", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["hovers"]
    },
    "method:Canvas.setLeft":{
        ref:"method:Canvas.setLeft",
        flags:"",
        description:"			Set the left coordinate of this object, relative to its enclosing context, in pixels.\n			NOTE: if you're setting multiple coordinates, use setRect(), moveTo() or resizeTo()\n          instead\n",
        name:"setLeft",
        seeAlso:[],
        params:[
            {description:"new left coordinate", optional:false, name:"left", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "method:Selection.select":{
        ref:"method:Selection.select",
        flags:"",
        description:"			Select a particular item\n",
        name:"select",
        seeAlso:[],
        params:[
            {description:"object to select", optional:false, name:"item", defaultValue:null,
             type:"object"}
        ],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:Selection",
        groups:["selection"]
    },
    "attr:FormItem.editorType":{
        ref:"attr:FormItem.editorType",
        flags:"IR",
        description:"Name of the FormItem to use for editing, eg \"TextItem\" or \"SelectItem\".\n <P>\n The type of FormItem to use for editing is normally derived automatically from\n ${isc.DocUtils.linkForRef('attr:FormItem.type','field.type')}, which is the data type of the field, by the rules\n explained ${isc.DocUtils.linkForRef('type:FormItemType','here')}.",
        name:"editorType",
        seeAlso:[
            {ref:"type:FormItemType", description:null},
            {ref:"type:FieldType", description:null}
        ],
        valueType:"FormItem class",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["appearance"]
    },
    "attr:ListGrid.headerBarStyle":{
        ref:"attr:ListGrid.headerBarStyle",
        flags:"IR",
        description:"Set the CSS style used for the header as a whole.",
        name:"headerBarStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["gridHeader", "appearance"]
    },
    "classMethod:EventHandler.setDragTracker":{
        ref:"classMethod:EventHandler.setDragTracker",
        flags:"",
        description:" Set the HTML for the drag tracker that follows the mouse during a drag and drop interaction.\n <P>\n Your canvas can use this routine to set the drag tracker to whatever HTML you want like so:\n <pre>\n    dragStart : function () {\n        isc.EventHandler.setDragTracker('Your contents here');\n    }\n </pre>\n\n",
        name:"setDragTracker",
        seeAlso:[],
        params:[
            {description:"HTML for the tracker", optional:false, name:"html", defaultValue:null,
             type:"string"},
            {description:"new width for the tracker", optional:true, name:"newWidth", defaultValue:null,
             type:"number"},
            {description:"new height for the tracker", optional:true, name:"newHeight",
             defaultValue:null, type:"number"},
            {description:"x-offset for the tracker", optional:true, name:"offsetX", defaultValue:null,
             type:"number"},
            {description:"y-offset for the tracker", optional:true, name:"offsetY", defaultValue:null,
             type:"number"},
            {description:"Opportunity to pass in a free-form set of properties                                       for the dragTracker",
             optional:true, name:"properties", defaultValue:null, type:"object"}
        ],
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:["dragDrop", "dragTracker"]
    },
    "attr:ListGrid.headerSpan":{
        ref:"attr:ListGrid.headerSpan",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')} are created via the ${isc.DocUtils.linkForRef('type:AutoChild')} pattern, hence\n <code>headerSpanConstructor</code>, <code>headerSpanDefaults</code> and\n <code>headerSpanProperties</code> are valid.",
        name:"headerSpan",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["headerSpan"]
    },
    "attr:Canvas.percentBox":{
        ref:"attr:Canvas.percentBox",
        flags:"IRA",
        description:"Governs the model to be used when sizing canvases with percentage width or height, or \n positioning widgets with a specified ${isc.DocUtils.linkForRef('attr:Canvas.snapTo','snapTo')}.\n <P>\n Only affects widgets with a a specified ${isc.DocUtils.linkForRef('attr:Canvas.percentSource','percentSource')}, or \n widgets that have ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')} set and are peers of some \n ${isc.DocUtils.linkForRef('attr:Canvas.masterElement','other canvas')}.\n <P>\n Determines whether the coordinates used for sizing (for percentage sized widgets) and\n positioning (if <code>snapTo</code> is set) should be relative to the visible size or the\n viewport size of the percentSource or masterElement widget.",
        name:"percentBox",
        seeAlso:[],
        valueType:"PercentBoxModel",
        defaultValue:"\"visible\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "method:Tree.getParents":{
        ref:"method:Tree.getParents",
        flags:"",
        description:"\n Given a node, return an array of the node's parents with the immediate parent first.  The\n node itself is not included in the result.  For example, for the following tree:\n <pre>\n root\n   foo\n     bar\n </pre>\n Calling <code>tree.getParents(bar)</code> would return: <code>[foo, root]</code>.  Note that\n the returned array will contain references to the nodes, not the names.\n\n",
        name:"getParents",
        seeAlso:[],
        params:[
            {description:"node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"array of node's parents", type:"Array"},
        type:"method",
        definingClass:"class:Tree"
    },
    "attr:StatefulCanvas.iconWidth":{
        ref:"attr:StatefulCanvas.iconWidth",
        flags:"IR",
        description:"Width in pixels of the icon image.\n <P>\n If unset, defaults to <code>iconSize</code>",
        name:"iconWidth",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:["buttonIcon"]
    },
    "attr:ListGrid.validateByCell":{
        ref:"attr:ListGrid.validateByCell",
        flags:"IRW",
        description:"Whether client-side validation checks should be performed when the user moves between\n cells in the current edit row.  If unset, defaults to ${isc.DocUtils.linkForRef('attr:ListGrid.editByCell')}.\n <P>\n Note that validation always occurs when a row is to be saved, so setting\n ${isc.DocUtils.linkForRef('attr:ListGrid.saveByCell')}:true forces validation on cell transitions.  To completely disable\n automatic validation, set ${isc.DocUtils.linkForRef('attr:ListGrid.neverValidate')}:true.",
        name:"validateByCell",
        seeAlso:[
            {ref:"group:editing", description:null}
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["gridValidation"]
    },
    "method:ListGrid.removeSelectedData":{
        ref:"method:ListGrid.removeSelectedData",
        flags:"",
        description:" Remove the currently selected records from this component.\n If this is a databound grid, the records will be removed directly from the DataSource.\n <P>\n If no records are selected, no action is taken. The grid will automatically be\n updated if the record deletion succeeds.\n\n",
        name:"removeSelectedData",
        seeAlso:[],
        params:[
            {description:"callback to fire when the data has been removed", optional:true,
             name:"callback", defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on the DSRequest                                          that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('removeOperation')}"],
        definingClass:"class:ListGrid",
        groups:["dataBoundComponentMethods"]
    },
    "attr:Canvas.snapHGap":{
        ref:"attr:Canvas.snapHGap",
        flags:"IRW",
        description:"The horizontal grid size to use, in pixels, when snap-to-grid is enabled.",
        name:"snapHGap",
        seeAlso:[
            {ref:"attr:Canvas.snapToGrid", description:null},
            {ref:"attr:Canvas.snapResizeToGrid", description:null},
            {ref:"attr:Canvas.childrenSnapToGrid", description:null},
            {ref:"attr:Canvas.childrenSnapResizeToGrid", description:null}
        ],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "method:GridRenderer.getEventColumn":{
        ref:"method:GridRenderer.getEventColumn",
        flags:"",
        description:" Returns the column number of the most recent mouse event.\n",
        name:"getEventColumn",
        seeAlso:[],
        params:[
            {description:"optional x-coordinate to obtain column number for, in lieue of the x                        coordinate of the last mouse event",
             optional:true, name:"x", defaultValue:null, type:"number"}
        ],
        returns:{description:"column number, or -2 if beyond last drawn column", type:"number"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events", "selection"]
    },
    "group:debug":{
        ref:"group:debug",
        refs:["method:Class.getCallTrace", "method:Class.getStackTrace", "method:Class.echoLeaf", 
         "method:Class.echo","method:Class.echoAll", "class:Log", "classMethod:Class.getCallTrace", 
         "classMethod:Log.getCallTrace","classMethod:Class.getStackTrace", "classMethod:Log.getStackTrace", 
         "classMethod:Class.echoLeaf","classMethod:Log.echoLeaf", "classMethod:Class.echo", "classMethod:Log.echo", 
         "classMethod:Class.echoAll","classMethod:Log.echoAll", "classMethod:Log.show", "classMethod:Log.traceMethod", 
         "classMethod:Log.timeMethod"],
        description:"Support for debugging and logging",
        name:"debug",
        seeAlso:[],
        type:"group"
    },
    "attr:Canvas.snapTo":{
        flags:"IRW",
        getter:["getSnapTo"],
        type:"attr",
        ref:"attr:Canvas.snapTo",
        description:"Position this widget such that it is aligned with (\"snapped to\") an edge of its \n ${isc.DocUtils.linkForRef('attr:Canvas.masterElement','masterElement')} (if specified), or its\n ${isc.DocUtils.linkForRef('attr:Canvas.parentElement','parentElement')}.\n <P>\n Note that this property also impacts the sizing of this widget. If this widgets size\n is specifed as a percent value, and has no explicit\n ${isc.DocUtils.linkForRef('attr:Canvas.percentSource')}, sizing will be calculated based on the size of the \n masterElement when snapTo is set.\n <P>\n Possible values: BR, BL, TR, TL, R, L, B, T, C where B=Bottom, T=Top, L=Left, R=right\n and C=center",
        name:"snapTo",
        setter:["setSnapTo"],
        valueType:"String",
        seeAlso:[
            {ref:"attr:Canvas.snapEdge", description:null},
            {ref:"attr:Canvas.percentBox", description:null}
        ],
        defaultValue:"null",
        groups:["sizing"],
        definingClass:"class:Canvas"
    },
    "class:TileGrid":{
        methods:["method:TileGrid.exportData", "method:TileGrid.fetchData", "method:TileGrid.filterData", 
         "method:TileGrid.removeSelectedData","method:TileGrid.getSelection", "method:TileGrid.getSelectedRecord", 
         "method:TileGrid.selectRecord","method:TileGrid.deselectRecord", "method:TileGrid.selectRecords", 
         "method:TileGrid.deselectRecords","method:TileGrid.selectAllRecords", "method:TileGrid.deselectAllRecords", 
         "method:TileGrid.anySelected","method:TileGrid.getTileHTML", "method:TileGrid.getTile", "method:TileGrid.recordClick", 
         "method:TileGrid.selectionChanged","method:TileGrid.addTile", "method:TileGrid.removeTile", "method:TileGrid.addData", 
         "method:TileGrid.removeData","method:TileGrid.setDragTracker", "method:TileGrid.getTitleField", 
         "method:TileGrid.getDragTrackerTitle","method:TileGrid.transferDragData", "method:TileGrid.getDragData", 
         "method:TileGrid.transferSelectedData","method:TileGrid.setFieldState", "method:TileGrid.getFieldState"],
        ref:"class:TileGrid",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Grids"],
        attrs:["attr:TileGrid.fields", "attr:TileGrid.showDetailFields", "attr:TileGrid.tileValueStyle", 
         "attr:TileGrid.tileValueAlign","attr:TileGrid.data", "attr:TileGrid.dataSource", "attr:TileGrid.autoFetchData", 
         "attr:TileGrid.autoFetchAsFilter","attr:TileGrid.initialCriteria", "attr:TileGrid.selectionType", "attr:TileGrid.tile", 
         "attr:TileGrid.tileConstructor","attr:TileGrid.showAllRecords", "attr:TileGrid.animateTileChange", 
         "attr:TileGrid.styleName","attr:TileGrid.dragTrackerStyle", "attr:TileGrid.dragDataAction"],
        description:"A TileGrid is a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} that displays a list of objects as a set\n of \"tiles\", where each tile represents one object, and the tiles are laid out in a grid with\n multiple tiles per row.  Each tile displays one or more properties of the object it\n represents.",
        name:"TileGrid",
        implementsInterfaces:["DataBoundComponent"],
        seeAlso:[],
        type:"class"
    },
    "attr:TileLayout.tileHMargin":{
        ref:"attr:TileLayout.tileHMargin",
        flags:"IR",
        description:"Horizontal margin in between tiles.  See ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin')}.",
        name:"tileHMargin",
        setter:["setTileHMargin"],
        seeAlso:[],
        valueType:"int",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:["layoutMargin"]
    },
    "attr:DataSource.dataFormat":{
        ref:"attr:DataSource.dataFormat",
        flags:"IR",
        description:"Indicates the format to be used for HTTP requests and responses when\n fulfilling DSRequests (eg ${isc.DocUtils.linkForRef('method:DataSource.fetchData')} is called).",
        name:"dataFormat",
        seeAlso:[],
        valueType:"DSDataFormat",
        defaultValue:"\"iscServer\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('jsonDataSource')}", 
         "${isc.DocUtils.linkForExampleId('simpleJSON')}"],
        definingClass:"class:DataSource",
        groups:["clientDataIntegration", "serverDataIntegration"]
    },
    "attr:Canvas.edgeCursorMap":{
        ref:"attr:Canvas.edgeCursorMap",
        flags:"IRWA",
        description:"Cursor to use when over each edge of a Canvas that is drag resizable.\n <P>\n To disable drag resize cursors, set the edgeCursorMap property to null.",
        name:"edgeCursorMap",
        seeAlso:[
            {ref:"attr:Canvas.resizeFrom", description:null}
        ],
        valueType:"object",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "attr:Canvas.hoverWidth":{
        ref:"attr:Canvas.hoverWidth",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.showHover','this.showHover')} is true, this property can be used to customize the\n width of the hover canvas shown.",
        name:"hoverWidth",
        seeAlso:[
            {ref:"attr:Canvas.showHover", description:null}
        ],
        valueType:"measure",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('customHovers')}"],
        definingClass:"class:Canvas",
        groups:["hovers"]
    },
    "attr:CubeGrid.innerHeaderBaseStyle":{
        ref:"attr:CubeGrid.innerHeaderBaseStyle",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('attr:Button.baseStyle','baseStyle')} for the buttons in the innermost column header for \n this cubeGrid.",
        name:"innerHeaderBaseStyle",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"innerHeader",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["appearance"]
    },
    "attr:FormItem.iconWidth":{
        ref:"attr:FormItem.iconWidth",
        flags:"IRWA",
        getter:["getIconWidth"],
        description:"Default width for form item icons",
        name:"iconWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["formIcons"]
    },
    "method:Array.lastIndexOf":{
        ref:"method:Array.lastIndexOf",
        flags:"",
        description:" Return the position in the list of the last instance of the specified object.\n <p>\n If pos is specified, starts looking before that position.\n <p>\n Returns -1 if not found.\n\n",
        name:"lastIndexOf",
        seeAlso:[],
        params:[
            {description:"object to look for", optional:false, name:"obj", defaultValue:null, type:"any"},
            {description:"last index to consider", optional:true, name:"pos", defaultValue:null,
             type:"number"},
            {description:"earliest index to consider", optional:true, name:"endPos", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"position of the item, if found, -1 if not found", type:"number"},
        type:"method",
        definingClass:"object:Array",
        groups:["access"]
    },
    "attr:DSRequest.resultTree":{
        ref:"attr:DSRequest.resultTree",
        flags:"R",
        description:"For advanced use in integrating trees that \n ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','load data on demand')} with web services,\n the ResultTree that issued this \"fetch\" DSRequest is automatically made available as the\n <code>resultTree</code> property.\n <P>\n This property can only be read.  There is no meaning to setting this property\n yourself.",
        name:"resultTree",
        seeAlso:[],
        valueType:"ResultTree",
        defaultValue:"{}",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:ValuesManager.members":{
        ref:"attr:ValuesManager.members",
        flags:"IRW",
        getter:["getMembers"],
        description:"The set of member forms for this valuesManager.  These can be specified at init time via\n the <code>members</code> property, or updated at runtime via <code>addMember()</code> and\n <code>removeMember()</code>.<br>\n Note: Alternatively a form can be initialized as a member of a valuesManager by setting\n the <code>valuesManager</code> property of the form to a pre-defined valuesManager\n instance.",
        name:"members",
        seeAlso:[
            {ref:"method:ValuesManager.addMember", description:null},
            {ref:"method:ValuesManager.removeMember", description:null}
        ],
        valueType:"Array",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ValuesManager"
    },
    "attr:ColorItem.pickerIconProperties":{
        ref:"attr:ColorItem.pickerIconProperties",
        flags:"IRWA",
        description:"Properties for the picker icon. Default object specifies a prompt for the picker icon",
        name:"pickerIconProperties",
        seeAlso:[],
        valueType:"object",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:ColorItem"
    },
    "method:DynamicForm.submitValues":{
        ref:"method:DynamicForm.submitValues",
        flags:"",
        description:" Triggered when a SubmitItem is included in the form is submitted and gets pressed.\n \n",
        name:"submitValues",
        seeAlso:[
            {ref:"method:DynamicForm.submit", description:null}
        ],
        params:[
            {description:"the form values", optional:false, name:"values", defaultValue:null,
             type:"object"},
            {description:"the form being submitted", optional:false, name:"form", defaultValue:null,
             type:"DynamicForm"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["submitting"]
    },
    "method:StatefulCanvas.select":{
        ref:"method:StatefulCanvas.select",
        flags:"",
        description:" Select this object.\n",
        name:"select",
        seeAlso:[],
        type:"method",
        definingClass:"class:StatefulCanvas",
        groups:["state"]
    },
    "object:CellRecord":{
        methods:[],
        ref:"object:CellRecord",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Optional Modules/Analytics/CubeGrid"],
        attrs:["attr:CellRecord.enabled"],
        description:"A CellRecord represents the data for one cell of the body area.\n <P>\n Each CellRecord should be an object that minimally has a property named after each\n visible facetId with the value being a facetValueId from that facet, and also a value\n for ${isc.DocUtils.linkForRef('attr:CubeGrid.valueProperty')}.\n <P>\n Cell records can contain any other properties desired, such as cell ids, or values for\n facets not initially shown.",
        name:"CellRecord",
        seeAlso:[],
        type:"object",
        requiresModules:["Analytics"]
    },
    "attr:DynamicForm.itemLayout":{
        ref:"attr:DynamicForm.itemLayout",
        flags:"IRWA",
        description:"Layout style to use with this form.  \n <P>\n The default of \"table\" uses a tabular layout similar to HTML tables, but with much more\n powerful control over sizing, item visibility and reflow, overflow handling, etc.\n <P>\n <code>itemLayout:\"absolute\"</code> allows absolute positioning of every form item.  This\n provides maximum flexibility in placement, with the following limitations:<ul>\n <li> titles, which normally take up an adjacent cell, are not shown.  Use\n      StaticTextItems to show titles\n <li> no automatic reflow when showing or hiding items.  ${isc.DocUtils.linkForRef('method:FormItem.setLeft')}\n      and ${isc.DocUtils.linkForRef('method:FormItem.setTop')} can be used for manual reflow.\n <li> only pixel and percent sizes are allowed, no \"*\".  Percent widths mean percentage\n      of the overall form size rather than the column size\n <li> with different font styling or internationalized titles, items may overlap that did\n      not overlap in the skin used at design time\n </ul>",
        name:"itemLayout",
        seeAlso:[],
        valueType:"FormLayoutType",
        defaultValue:"\"table\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["formLayout"]
    },
    "attr:TileGrid.showAllRecords":{
        ref:"attr:TileGrid.showAllRecords",
        flags:"IR",
        description:"Whether tiles are created and drawn for all records, or only for those currently visible.",
        name:"showAllRecords",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TileGrid",
        groups:["basics"]
    },
    "attr:DateChooser.prevYearIcon":{
        ref:"attr:DateChooser.prevYearIcon",
        flags:"IR",
        description:"Icon for the previous year button",
        name:"prevYearIcon",
        seeAlso:[
            {ref:"attr:DateChooser.showDoubleYearIcon", description:null}
        ],
        valueType:"URL",
        defaultValue:"\"[SKIN]doubleArrow_left.gif\"",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:TreeGrid.openLeaf":{
        ref:"method:TreeGrid.openLeaf",
        flags:"A",
        description:" Executed when a leaf node receives a 'doubleClick' event. This handler must be\n specified as a function, whose single parameter is a reference to the relevant leaf node in\n the tree's data.<br>\n See the ListGrid Widget Class for inherited recordClick and recordDoubleClick events.\n\n",
        name:"openLeaf",
        seeAlso:[
            {ref:"class:ListGrid", description:null}
        ],
        params:[
            {description:"node to open", optional:false, name:"node", defaultValue:null, type:"TreeNode"}
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "classMethod:XMLTools.selectObjects":{
        ref:"classMethod:XMLTools.selectObjects",
        flags:"A",
        description:" Applies an XPath expression to JavaScript objects, returning matching objects.\n <P>\n Both child and attribute names are interpreted as property names, and array access notation\n can be used to select elements from Arrays.  For example:<pre>\n     var results = {\n        searchResults:[\n            { title:\"Page One\", relevance:6.3 },\n            { title:\"Page Two\", relevance:5.2, \n              summary: \"Summary of Page One\" }\n        ]\n     };\n\n     // returns the \"searchResults\" two-item Array\n     isc.XMLTools.selectObjects(results, \"/searchResults\");\n\n     // returns the first item under \"searchResults\", in an Array (NOTE: in XPath, Array\n     // index starts at 1, not 0)\n     isc.XMLTools.selectObjects(results, \"/searchResults[1]\");\n\n     // returns [\"Page One\"]\n     isc.XMLTools.selectObjects(results, \"/searchResults[1]/title\");\n\n     // also returns [\"Page One\"]\n     isc.XMLTools.selectObjects(results, \"/searchResults[1]@title\");\n </pre>\n A limited form of XPath \"predicates\", that is, expressions with brackets that filter\n returned objects, is allowed.  A predicate can be either:\n <ul>\n <li> a number only, eg [5], for Array access\n <li> the XPath function call \"last()\", eg [last()], to retrieve the last item\n <li> a property name (*without* any leading \"@\"), meaning that the property contains a value\n      that is considered \"true\" in JavaScript.  For example: [summary]\n <li> a property name, comparison operator, and either a number or String literal, for\n      example, [name = \"bob\"].  In this case the property can also be the XPath function\n      position(), for example, [position() > 5]\n </ul>\n Some examples of using simple predicates with the sample data above:\n <pre>\n     // returns an Array with only the first result\n     isc.XMLTools.selectObjects(results, \"/searchResults[relevance > 5.5]\");\n \n     // return an Array with only the second result, since the first has no summary\n     isc.XMLTools.selectObjects(results, \"/searchResults[summary]\");\n </pre>\n Details of the XPath -> Objects mapping:\n <ul> \n <li> JavaScript Object properties are considered element children, and text children do not\n      exist (in the XML model, text children exist *between* element children, but nothing\n      exists between JavaScript properties)\n <li> The contents of Array-valued properties are considered immediate element children (this\n      is consistent with the predicate \"[5]\" acting like Array access)\n <li> \"*\" in XML selects all element children, so \"*\" in Object XPath selects the values of\n      all properties, that is, ${isc.DocUtils.linkForRef('classMethod:isc.getValues','isc.getValues(object)')}, except\n      that Array-valued properties are \"flattened\" into the returned list.\n </ul>\n\n",
        name:"selectObjects",
        seeAlso:[],
        params:[
            {description:"Object to select results from", optional:false, name:"object",
             defaultValue:null, type:"Object"},
            {description:"XPath expression", optional:false, name:"xPath", defaultValue:null,
             type:"String"}
        ],
        returns:{description:"Array of matching objects, or null for no match", type:"Array"},
        type:"classMethod",
        definingClass:"class:XMLTools"
    },
    "method:ListGrid.getSelectedState":{
        ref:"method:ListGrid.getSelectedState",
        flags:"",
        description:" Returns a snapshot of the current selection within this listGrid as \n a ${isc.DocUtils.linkForRef('type:listGridSelectedState')} object.<br>\n This object can be passed to ${isc.DocUtils.linkForRef('method:ListGrid.setSelectedState')} to reset this grid's selection\n the current state (assuming the same data is present in the grid).<br>\n",
        name:"getSelectedState",
        seeAlso:[
            {ref:"method:ListGrid.setSelectedState", description:null}
        ],
        returns:{description:"current state of this grid's selection", type:"listGridSelectedState"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["viewState"]
    },
    "attr:Tree.rootValue":{
        ref:"attr:Tree.rootValue",
        flags:"IR",
        description:"If you are using the \"parent\" modelType and did not specify a root node via ${isc.DocUtils.linkForRef('attr:Tree.root')}\n with an id (${isc.DocUtils.linkForRef('attr:Tree.idField')}), then you can provide the root node's id via this property.\n See the example in ${isc.DocUtils.linkForRef('attr:Tree.data')} for more info.",
        name:"rootValue",
        seeAlso:[
            {ref:"attr:Tree.data", description:null}
        ],
        valueType:"string|number",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('nodeTitles')}"],
        definingClass:"class:Tree"
    },
    "attr:TabSet.pickerButtonSize":{
        ref:"attr:TabSet.pickerButtonSize",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:TabSet.showTabPicker')} is true, this property governs the size of tab-picker\n button. Applied as the width of buttons if the tabBar is horizontal, or the height\n if tabBar is vertical. Note that the other dimension is determined by\n ${isc.DocUtils.linkForRef('attr:TabSet.tabBarThickness','this.tabBarThickness')}",
        name:"pickerButtonSize",
        seeAlso:[],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:TabSet",
        groups:["tabBarControls"]
    },
    "attr:Splitbar.canCollapse":{
        ref:"attr:Splitbar.canCollapse",
        flags:"IRW",
        description:"If this property is true, a click on the Splitbar will collapse its \n ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}, hiding it and shifting the Splitbar and other members\n of the layout across to fill the newly available space. If the target is already hidden\n a click will expand it again (showing it at it's normal size).",
        name:"canCollapse",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Splitbar"
    },
    "group:event":{
        ref:"group:event",
        refs:[],
        name:"event",
        seeAlso:[],
        type:"group"
    },
    "method:DynamicForm.focusInItem":{
        ref:"method:DynamicForm.focusInItem",
        flags:"",
        description:" Move the keyboard focus into a particular item.\n",
        name:"focusInItem",
        seeAlso:[],
        params:[
            {description:"Item (or reference to) item to focus in.", optional:false, name:"itemName",
             defaultValue:null, type:"number|itemName|formItem"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["eventHandling", "focus"]
    },
    "group:grouping":{
        ref:"group:grouping",
        refs:["method:ListGridField.getGroupValue", "method:ListGridField.getGroupTitle", 
         "method:ListGrid.groupBy","object:groupNode", "attr:groupNode.groupMembers", "attr:groupNode.groupTitle", 
         "attr:groupNode.groupValue","attr:ListGrid.originalData", "attr:ListGrid.groupTree", "attr:ListGrid.groupStartOpen", 
         "attr:ListGridField.groupingModes","attr:ListGridField.groupingMode", "attr:ListGridField.defaultGroupingMode", 
         "attr:ListGridField.groupPrecision","attr:ListGridField.groupGranularity", "attr:ListGrid.groupNodeStyle", 
         "attr:ListGrid.groupIcon","attr:ListGrid.groupIconSize", "attr:ListGrid.groupIndentSize", 
         "attr:ListGrid.groupLeadingIndent","attr:ListGrid.canGroupBy", "attr:ListGrid.groupByMaxRecords", "attr:ListGrid.isGrouped", 
         "attr:ListGrid.nullGroupTitle","attr:ListGrid.groupByField"],
        name:"grouping",
        seeAlso:[],
        type:"group"
    },
    "group:dateFormatting":{
        ref:"group:dateFormatting",
        refs:["method:Date.getShortDayName", "method:Date.getShortMonthName", "method:Date.getShortYear", 
         "method:Date.getWeek","method:Date.toDateStamp", "method:Date.toNormalDate", "method:Date.toShortDate", 
         "method:Date.setDefaultDateSeparator","method:Date.getDefaultDateSeparator", "method:Date.toUSShortDate", 
         "method:Date.toUSShortDateTime","method:Date.toEuropeanShortDate", "method:Date.toEuropeanShortDateTime", 
         "method:Date.toJapanShortDate","method:Date.toJapanShortDateTime", "method:Date.toSerializeableDate", 
         "method:Date.setFormatter","method:Date.toPrettyString", "classMethod:Date.parseInput", 
         "classMethod:Date.setNormalDisplayFormat","classMethod:Date.setShortDisplayFormat"],
        name:"dateFormatting",
        seeAlso:[],
        type:"group"
    },
    "classMethod:Page.getScrollHeight":{
        ref:"classMethod:Page.getScrollHeight",
        flags:"",
        description:"		Get the height of the window contents as they have been drawn.\n		If the page scrolls, this may be larger than the page.getHeight().\n",
        name:"getScrollHeight",
        seeAlso:[],
        returns:{description:"height of the page as drawn", type:"number"},
        type:"classMethod",
        definingClass:"class:Page",
        groups:["sizing"]
    },
    "method:ListGrid.setEditValue":{
        ref:"method:ListGrid.setEditValue",
        flags:"A",
        description:"\n  Modifies a field value being tracked as an unsaved user edit.<P>\n  Use for suggested or reformatted values for edits that remain unsaved.\n\n",
        name:"setEditValue",
        seeAlso:[],
        params:[
            {description:"Row number (or edit values ID)", optional:false, name:"rowNum",
             defaultValue:null, type:"number"},
            {description:"Column number of cell, or name of field                                           having editValue updated",
             optional:false, name:"colNum", defaultValue:null, type:"number | string"},
            {description:"New value for the appropriate field.", optional:false, name:"value",
             defaultValue:null, type:"any"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "attr:TileGrid.selectionType":{
        ref:"attr:TileGrid.selectionType",
        flags:"IRW",
        description:"Defines a tileGrid's clickable-selection behavior.",
        name:"selectionType",
        seeAlso:[
            {ref:"type:SelectionStyle", description:null}
        ],
        valueType:"SelectionStyle",
        defaultValue:"Selection.MULTIPLE",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('tilingEditing')}"],
        definingClass:"class:TileGrid",
        groups:["selection", "appearance"]
    },
    "group:headerSpan":{
        ref:"group:headerSpan",
        refs:["method:ListGrid.getHeaderSpanContextMenuItems", "method:ListGrid.setHeaderSpans", 
         "method:ListGrid.setHeaderSpanTitle","object:HeaderSpan", "attr:ListGrid.headerSpans", "attr:ListGrid.headerSpanHeight", 
         "attr:ListGrid.headerSpanVAlign","attr:ListGrid.unspannedHeaderVAlign", "attr:ListGrid.headerSpanConstructor", 
         "attr:ListGrid.headerSpan","attr:HeaderSpan.name", "attr:HeaderSpan.fields", "attr:HeaderSpan.title", 
         "attr:HeaderSpan.height","attr:HeaderSpan.valign", "attr:HeaderSpan.align", "attr:ListGrid.showTreeColumnPicker"],
        name:"headerSpan",
        seeAlso:[],
        type:"group"
    },
    "attr:CubeGrid.simpleDeselect":{
        ref:"attr:CubeGrid.simpleDeselect",
        flags:"IRW",
        description:"If true, clicking on the existing selection causes it to be entirely deselected.",
        name:"simpleDeselect",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "attr:Splitbar.src":{
        ref:"attr:Splitbar.src",
        flags:"IR",
        description:"The base URL for the image. \n <P>\n As with ${isc.DocUtils.linkForRef('attr:Img.src')}, the ${isc.DocUtils.linkForRef('type:State')} of the component is added to this URL.  Then,\n the image segment name as specified by ${isc.DocUtils.linkForRef('attr:StretchImg.items')} is added.\n <P>\n For example, for a stretchImg in \"Over\" state with a <code>src</code> of \"button.png\"\n and a segment name of \"stretch\", the resulting URL would be \"button_Over_stretch.png\".",
        name:"src",
        seeAlso:[
            {ref:"attr:StretchImg.hSrc", description:null},
            {ref:"attr:StretchImg.vSrc", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Splitbar",
        groups:["appearance"]
    },
    "group:dataSourceRelations":{
        ref:"group:dataSourceRelations",
        title:"Relations",
        refs:["attr:DataSourceField.primaryKey", "attr:DataSourceField.foreignKey", 
         "attr:DataSourceField.childrenProperty","attr:DataSourceField.rootValue", "attr:DataSource.childrenField"],
        description:"Properties for declaring relations between DataSource and within DataSources, such as\n master-detail relationship (a SalesOrder contains 0 or more OrderItems) and tree\n relationships (records can be linked by a parentId field).",
        name:"dataSourceRelations",
        seeAlso:[
            {ref:"attr:DataSourceField.foreignKey", description:null}
        ],
        type:"group"
    },
    "attr:Calendar.eventEditor":{
        ref:"attr:Calendar.eventEditor",
        flags:"R",
        description:"An autochild of type ${isc.DocUtils.linkForRef('class:DynamicForm')} which displays ${isc.DocUtils.linkForRef('object:CalendarEvent','event data')}. \n This form is created within the ${isc.DocUtils.linkForRef('attr:Calendar.eventEditorLayout','event editor layout')}",
        name:"eventEditor",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "attr:RPCRequest.evalVars":{
        ref:"attr:RPCRequest.evalVars",
        flags:"IRWA",
        description:"If you've set ${isc.DocUtils.linkForRef('attr:RPCRequest.evalResult')} : true, then the property values of this object\n will be available in the evaluation scope of the result under the variable names\n specified by the property names. \n <p>\n So e.g. if evalVars is: <code>{foo: \"bar\"}</code> then a reference to the\n variable <code>foo</code> in the result will evaluate to <code>\"bar\"</code>.",
        name:"evalVars",
        seeAlso:[],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RPCRequest",
        groups:["viewLoading"]
    },
    "method:DataSource.evaluateCriterion":{
        ref:"method:DataSource.evaluateCriterion",
        flags:"",
        description:" Evaluate the given criterion with respect to the passed record.\n <P>\n Typically called by the ${isc.DocUtils.linkForRef('method:Operator.condition','condition')} function of a custom\n ${isc.DocUtils.linkForRef('object:Operator')} to evaluate ${isc.DocUtils.linkForRef('attr:Criterion.criteria','sub-criteria')}.\n\n",
        name:"evaluateCriterion",
        seeAlso:[],
        params:[
            {description:"record to evaluate", optional:false, name:"record", defaultValue:null,
             type:"Record"},
            {description:"criterion to use", optional:false, name:"criterion", defaultValue:null,
             type:"Criterion"}
        ],
        returns:{description:"whether the record meets the supplied ${isc.DocUtils.linkForRef('object:Criterion')}",
         type:"boolean"},
        type:"method",
        definingClass:"class:DataSource",
        groups:["advancedFilter"]
    },
    "classMethod:Log.show":{
        ref:"classMethod:Log.show",
        flags:"",
        description:" Open the Developer Console.\n <P>\n The Developer Console should <b>always</b> be open while developing any ISC-enabled\n application, because ISC logs many important errors and warnings to the Developer Console.\n <P>\n In Internet Explorer, the Developer Console is able to log a stack trace for every JS error,\n including errors that occur in non-ISC code.\n <P>\n NOTE: if you have the Microsoft JavaScript Debugger installed, ISC will be unable to log\n stack traces on JS errors until you go to Tools->Internet Options->Advanced Tab and check\n \"Disable script debugging\".  The ability to see stack traces in the Developer Console is\n generally much more useful for debugging ISC-based applications than the generic Javascript\n Debugging facilities.\n \n",
        name:"show",
        seeAlso:[],
        type:"classMethod",
        definingClass:"class:Log",
        groups:["debug"]
    },
    "method:ListGridField.showIf":{
        ref:"method:ListGridField.showIf",
        flags:"",
        description:" An optional ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')} which if provided, is evaluated to\n conditionally determine whether this field should be displayed. \n Evaluated on initial draw, then reevaluated on explicit \n calls to <code>listGrid.refreshFields()</code> or <code>listGrid.setFields()</code>. \n <P>\n Use 'showIf:\"false\"' to set a ListGrid field to initially hidden.\n <P>\n Note that explicit calls to ${isc.DocUtils.linkForRef('method:ListGrid.showField','grid.showField()')} or hideField()\n will wipe out the <code>showIf</code> expression, as will the end user showing and\n hiding columns via the ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','header contextMenu')}.\n <P>\n Also note that fields marked as ${isc.DocUtils.linkForRef('attr:DataSourceField.detail','detail:true')} will be hidden by\n default even if ${isc.DocUtils.linkForRef('attr:ListGrid.showDetailFields')} is <code>true</code>. To show detail fields\n inherited from a DataSource, include an explicit field definition for the field and\n set this property to return <code>true</code>.\n",
        name:"showIf",
        seeAlso:[
            {ref:"method:ListGrid.refreshFields", description:null}
        ],
        params:[
            {description:"A pointer to the listGrid containing the field", optional:false, name:"list",
             defaultValue:null, type:"ListGrid"},
            {description:"the ListGridField object", optional:false, name:"field", defaultValue:null,
             type:"ListGridField"},
            {description:"the index of the field", optional:false, name:"fieldNum", defaultValue:null,
             type:"integer"}
        ],
        type:"method",
        definingClass:"object:ListGridField",
        groups:["appearance"]
    },
    "classAttr:Array.LOADING":{
        ref:"classAttr:Array.LOADING",
        flags:"IRA",
        description:"Marker value returned by Lists that manage remote datasets, indicating the requested data is\n being loaded. Note that the recommended test for loading data is to call ${isc.DocUtils.linkForRef('classMethod:Array.isLoading')}\n rather than compare to this value directly.",
        name:"LOADING",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"loading\"",
        type:"classAttr",
        definingClass:"object:Array"
    },
    "attr:MenuButton.menuButtonImage":{
        ref:"attr:MenuButton.menuButtonImage",
        flags:"IRA",
        description:"Image for menu button indicating that the button expands a menu.  This image is shown\n for menus expanding down from the button.   Menu direction is controlled by\n ${isc.DocUtils.linkForRef('attr:MenuButton.showMenuBelow')}.",
        name:"menuButtonImage",
        seeAlso:[
            {ref:"attr:MenuButton.menuButtonImageUp", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]menu_button.gif\"",
        type:"attr",
        definingClass:"class:MenuButton"
    },
    "attr:Toolbar.canResizeItems":{
        ref:"attr:Toolbar.canResizeItems",
        flags:"IRWA",
        description:"If true, items (buttons) can be resized by dragging on them.",
        name:"canResizeItems",
        setter:["setCanResizeItems"],
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Toolbar",
        groups:["dragndrop"]
    },
    "type:PageEvent":{
        ref:"type:PageEvent",
        values:[
            {description:"Fires repeatedly (every 10 ms by default) when the system is idle (i.e.,\n        not busy running other scripts) after the page is loaded.",
             value:"\"idle\""},
            {description:"Fires when the page has finished loading. It corresponds to the\n        browser 'load' event normally handled by window.onload.",
             value:"\"load\""},
            {description:"Fires when the page is exited or unloaded. It corresponds to the\n        browser 'unload' event normally handled by window.onunload.",
             value:"\"unload\""},
            {description:"Fires when the browser window is resized by the user. It corresponds\n        to the browser 'resize' event normally handled by window.onresize.",
             value:"\"resize\""},
            {description:"Fires when the left mouse button is pressed on the Page.",
             value:"\"mouseDown\""},
            {description:"Fires when the right mouse button is pressed on the Page.",
             value:"\"rightMouseDown\""},
            {description:"Fires when the mouse moves on the Page.", value:"\"mouseMove\""},
            {description:"Fires when the left mouse button released on the Page.",
             value:"\"mouseUp\""},
            {description:"Fires when the user clicks the mouse on the Page.", value:"\"cick\""},
            {description:"Fires when the uesr double-clicks on the Page.", value:"\"doubleClick\""},
            {description:"Fires when the right mouse button is clicked on the page.  If your event handler\n        for this event returns false, the native browser context menu will be suppressed.<br>\n        Note: On the Macintosh platform, <code>Command+Click</code> may be used instead\n        of right-button click to trigger a context menu event.<br>\n        On the Opera browser, <code>Ctrl+Shift+Click</code> should be used instead of\n        right-button click.",
             value:"\"showContextMenu\""},
            {description:"Fires when a user presses a key on the keyboard. \n see classMethod:Page.setEvent()\n see classMethod:Page.clearEvent()",
             value:"\"keyPress\""}
        ],
        description:"Events registerable via ${isc.DocUtils.linkForRef('classMethod:Page.setEvent')}",
        name:"PageEvent",
        seeAlso:[],
        type:"type"
    },
    "method:Canvas.intersects":{
        ref:"method:Canvas.intersects",
        flags:"",
        description:"			Returns true if the rectangles of this widget and the specified widget overlap.\n",
        name:"intersects",
        seeAlso:[],
        params:[
            {description:"other canvas to test for intersection", optional:false, name:"other",
             defaultValue:null, type:"canvas"}
        ],
        returns:{description:"true if this canvas intersects other; false otherwise", type:"boolean"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "attr:PickList.pickListBaseStyle":{
        ref:"attr:PickList.pickListBaseStyle",
        flags:"IR",
        description:"Base Style for pickList cells.  As with ListGrid Cells, will have 'over', 'selected'\n and 'disabled' appended on changes of state for the cells.",
        name:"pickListBaseStyle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"pickListCell\"",
        type:"attr",
        definingClass:"interface:PickList"
    },
    "method:ValuesManager.getMemberForField":{
        ref:"method:ValuesManager.getMemberForField",
        flags:"",
        description:" Given a fieldName, this method will find the member form containing an item for that\n field. If no member form is found, returns null.\n",
        name:"getMemberForField",
        seeAlso:[],
        params:[
            {description:"fieldName to check", optional:false, name:"fieldName", defaultValue:null,
             type:"string"}
        ],
        returns:{description:"member form containing an item for the fieldName, or null.", type:"DynamicForm"},
        type:"method",
        definingClass:"class:ValuesManager",
        groups:["members"]
    },
    "attr:Progressbar.vertical":{
        ref:"attr:Progressbar.vertical",
        flags:"IRW",
        description:"Indicates whether this is a vertical or horizontal progressbar.",
        name:"vertical",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Progressbar",
        groups:["appearance"]
    },
    "attr:ListGrid.editEvent":{
        ref:"attr:ListGrid.editEvent",
        flags:"IRW",
        description:"Event that will trigger inline editing, see ${isc.DocUtils.linkForRef('type:ListGridEditEvent')} for options.\n <P>\n Note this setting has no effect unless ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit')} has been set to enable editing.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:ListGrid.editOnFocus')} and ${isc.DocUtils.linkForRef('method:ListGrid.startEditing')}.",
        name:"editEvent",
        seeAlso:[],
        valueType:"ListGridEditEvent",
        defaultValue:"\"doubleClick\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('editByRow')}"],
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "method:ListGrid.setSelectedState":{
        ref:"method:ListGrid.setSelectedState",
        flags:"",
        description:" Reset this grid's selection to match the ${isc.DocUtils.linkForRef('type:listGridSelectedState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to \n ${isc.DocUtils.linkForRef('method:ListGrid.getSelectedState')}.\n\n",
        name:"setSelectedState",
        seeAlso:[
            {ref:"method:ListGrid.getSelectedState", description:null}
        ],
        params:[
            {description:"Object describing the desired selection state of                                              the grid",
             optional:false, name:"selectedState", defaultValue:null, type:"listGridSelectedState"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["viewState"]
    },
    "group:widgetEvents":{
        ref:"group:widgetEvents",
        refs:["method:Canvas.showContextMenu", "method:Canvas.hideContextMenu", 
         "method:Canvas.mouseOver","method:Canvas.mouseDown", "method:Canvas.rightMouseDown", "method:Canvas.mouseStillDown", 
         "method:Canvas.mouseMove","method:Canvas.mouseOut", "method:Canvas.mouseUp", "method:Canvas.click", 
         "method:Canvas.doubleClick","method:Canvas.mouseWheel", "method:Canvas.dragRepositionStart", 
         "method:Canvas.dragRepositionMove","method:Canvas.dragRepositionStop", "method:Canvas.dragResizeStart", 
         "method:Canvas.dragResizeMove","method:Canvas.dragResizeStop", "method:Canvas.dragStart", "method:Canvas.dragMove", 
         "method:Canvas.dragStop","method:Canvas.dropOver", "method:Canvas.dropMove", "method:Canvas.dropOut", 
         "method:Canvas.drop","method:Canvas.keyDown", "method:Canvas.keyUp", "method:Canvas.keyPress"],
        name:"widgetEvents",
        seeAlso:[],
        type:"group"
    },
    "method:Layout.reflowNow":{
        ref:"method:Layout.reflowNow",
        flags:"A",
        description:" Layout members according to current settings, immediately.\n <br>\n Generally, when changes occur that require a layout to reflow (such as members being shown\n or hidden), the Layout will reflow only after a delay, so that multiple changes cause only\n one reflow.  To remove this delay for cases where it is not helpful, reflowNow() can be\n called.\n",
        name:"reflowNow",
        seeAlso:[],
        type:"method",
        definingClass:"class:Layout"
    },
    "attr:TreeGrid.openerImage":{
        ref:"attr:TreeGrid.openerImage",
        flags:"IR",
        description:"The base filename of the opener icon for the folder node when 'showConnectors' is false\n for this TreeGrid.<br>\n The opener icon is displayed beside the folder icon in the Tree column for folder nodes.\n Clicking on this icon will toggle the open state of the folder.<br>\n The filenames for these icons are assembled from this base filename and the state of the\n node, as follows:<br>\n If the openerImage is set to <code>{baseName}.{extension}</code>, \n <code>{baseName}_opened.{extension}</code> will be displayed next to opened folders, and\n <code>{baseName}_closed.{extension}</code> will be displayed next to closed folders, or\n if this page is in RTL mode, <code>{baseName}_opened_rtl.{extension}</code> and\n <code>{baseName}_closed_rtl.{extension}</code> will be used.",
        name:"openerImage",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]opener.gif\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "classAttr:Operators.andTitle":{
        ref:"classAttr:Operators.andTitle",
        flags:"IR",
        description:"Title for the \"and\" operator",
        name:"andTitle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"Match All\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:["i18nMessages"]
    },
    "group:hiliting":{
        ref:"group:hiliting",
        title:"Hiliting Overview",
        refs:["method:CubeGrid.hiliteCell", "method:CubeGrid.hiliteCellList", 
         "method:CubeGrid.hiliteFacetValue","method:DataBoundComponent.enableHilite", "method:DataBoundComponent.disableHilite", 
         "method:DataBoundComponent.enableHiliting","method:DataBoundComponent.disableHiliting"],
        description:"Hiliting means special visual styling which is applied to specific data values that meet\n certain criteria.\n <P>\n A ${isc.DocUtils.linkForRef('object:Hilite')} definition contains styling information such as ${isc.DocUtils.linkForRef('attr:Hilite.cssText')} and\n ${isc.DocUtils.linkForRef('attr:Hilite.htmlBefore')} that define what the hilite looks like, as well as properties\n defining where the hilite is applied.\n <P>\n A hilite can be applied to data <b>either</b> by defining ${isc.DocUtils.linkForRef('attr:Hilite.criteria','criteria')}\n or by explicitly including markers on the data itself.  \n <P>\n Hiliting rules such as hiliting different ranges of values with different colors can be\n accomplished entirely client-side by defining ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} in hilite definitions\n that pick out values to be highlighted.\n <P>\n Hiliting rules that require server-side calculations can be achieved by assigning a\n ${isc.DocUtils.linkForRef('attr:Hilite.id')} to a hilite definition, and setting the\n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.hiliteProperty')} on the records that should show that highlight.\n This can be used, for example, to hilite the record with the maximum value for a dataset\n that the application will load incrementally.",
        name:"hiliting",
        seeAlso:[],
        type:"group"
    },
    "attr:ImgButton.selected":{
        ref:"attr:ImgButton.selected",
        flags:"IRW",
        description:"Whether this component is selected.  For some components, selection affects appearance.",
        name:"selected",
        setter:["setSelected"],
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["state"]
    },
    "attr:ValuesManager.disableValidation":{
        ref:"attr:ValuesManager.disableValidation",
        flags:"IRWA",
        description:"If set to true, client-side validators will not run on the form when validate() is\n called.  Server-side validatiors (if any) will still run on attempted save.",
        name:"disableValidation",
        seeAlso:[
            {ref:"method:DynamicForm.saveData", description:null},
            {ref:"method:DynamicForm.submit", description:null}
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ValuesManager",
        groups:["validation"]
    },
    "interface:List":{
        methods:["method:List.get", "method:List.getLength", "method:List.isEmpty", "method:List.first", 
         "method:List.last","method:List.indexOf", "method:List.lastIndexOf", "method:List.findIndex", 
         "method:List.findNextIndex","method:List.find", "method:List.findAll", "method:List.contains", 
         "method:List.containsAll","method:List.intersect", "method:List.equals", "method:List.getItems", 
         "method:List.getRange","method:List.duplicate", "method:List.set", "method:List.addAt", "method:List.removeAt", 
         "method:List.add","method:List.addList", "method:List.setLength", "method:List.addListAt", 
         "method:List.remove","method:List.removeList", "method:List.sort", "method:List.getProperty", 
         "method:List.sortByProperty","method:List.getValueMap", "method:List.dataChanged"],
        ref:"interface:List",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/System"],
        attrs:[],
        description:"An interface for an ordered collection of items.\n <P>\n This is the interface that is expected by list-oriented display components such as the\n ListGrid.  The JavaScript native Array object is retrofitted to support the List interface.\n Also, a valid List can be created by mixing the List interface into any class that supports:\n <ul>\n <li> for read-only support: get(position), getLength()\n <li> for modifiable support: set(position), addAt(object, position), removeAt(position)\n </ul>\n <P>\n NOTE: this interface is compatible with the java.util.List interface, except that:\n <ul>\n <li> for removal by index, removeAt() must be called instead of remove().  In Java, remove()\n is an overloaded method that takes either an int or Object, whereas in JavaScript, a\n Number is an Object.\n <li> Iterators don't exist.\n </ul> \n Some methods from the Java List interface have been omitted from the documentation to avoid\n redundancy.",
        name:"List",
        seeAlso:[],
        type:"interface"
    },
    "classMethod:EventHandler.leftButtonDown":{
        ref:"classMethod:EventHandler.leftButtonDown",
        flags:"",
        description:"			Returns true if the left mouse button is being pressed.\n\n",
        name:"leftButtonDown",
        seeAlso:[],
        returns:{description:"true == left button is down, false == up", type:"boolean"},
        type:"classMethod",
        platformNotes:"Mac:		Macintosh platform generally has only one mouse button - ISC considers it to be the \"left\"\n		mouse button, so this method will return true if the mouse is down on a single-button mouse Mac.",
        definingClass:"class:EventHandler",
        groups:["mouseEvents"]
    },
    "method:Canvas.dropOver":{
        ref:"method:Canvas.dropOver",
        flags:"A",
        description:"\n Executed when the compatible dragged object is first moved over this drop target. Your\n implementation can use this to show a custom visual indication that the object can be\n dropped here.\n\n",
        name:"dropOver",
        seeAlso:[
            {ref:"method:Canvas.getOffsetX", description:null},
            {ref:"method:Canvas.getOffsetY", description:null}
        ],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('customDrag')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:CubeGrid.getEditValues":{
        ref:"method:CubeGrid.getEditValues",
        flags:"",
        description:" Returns the current set of unsaved edits for a given row being edited.\n\n",
        name:"getEditValues",
        seeAlso:[],
        params:[
            {description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
             optional:false, name:"valuesID", defaultValue:null, type:"number | Object"},
            {description:"colNum of the record being edited. Only required if valuesID                         is passed in as a rowNum.",
             optional:false, name:"colNum", defaultValue:null, type:"number"}
        ],
        returns:{description:"Current editValues object for the row.  This contains the current                     edit values in {fieldName1:value1, fieldName2:value2} format.",
         type:"object"},
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["editing"]
    },
    "attr:Calendar.eventOverlapIdenticalStartTimes":{
        ref:"attr:Calendar.eventOverlapIdenticalStartTimes",
        flags:"IR",
        description:"When set to true, events that start at the same time will not overlap each other to prevent \n events having their close button hidden",
        name:"eventOverlapIdenticalStartTimes",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["calendarEvent"]
    },
    "attr:ListGrid.headerMenuButtonConstructor":{
        ref:"attr:ListGrid.headerMenuButtonConstructor",
        flags:"IRA",
        description:"Constrocutor for the  ${isc.DocUtils.linkForRef('attr:ListGrid.headerMenuButton')}. If unset a standard \"Button\" will\n be rendered out. Note that this property may be overridden by different skins.",
        name:"headerMenuButtonConstructor",
        seeAlso:[],
        valueType:"className",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["headerMenuButton"]
    },
    "method:Selection.selectRange":{
        ref:"method:Selection.selectRange",
        flags:"",
        description:"			Select range of records from <code>start</code> to <code>end</code>, non-inclusive.\n",
        name:"selectRange",
        seeAlso:[],
        params:[
            {description:"start index to select", optional:false, name:"start", defaultValue:null,
             type:"number"},
            {description:"end index (non-inclusive)", optional:false, name:"end", defaultValue:null,
             type:"number"},
            {description:"optional new selection state to set.  True means                                      selected, false means unselected.  Defaults to true.",
             optional:true, name:"newState", defaultValue:null, type:"boolean"}
        ],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:Selection",
        groups:["selection"]
    },
    "classMethod:Page.setAppImgDir":{
        ref:"classMethod:Page.setAppImgDir",
        flags:"",
        description:" Specify the directory for app-specific images.\n <P>\n This becomes the default location where any SmartClient component will load images from\n unless the special \"[SKIN]\" prefix is used to indicate that an image is part of a skin.\n <P>\n Default is \"[APP]images/\"\n\n",
        name:"setAppImgDir",
        seeAlso:[],
        params:[
            {description:"New imgDir URL.", optional:true, name:"URL", defaultValue:null, type:"string"}
        ],
        type:"classMethod",
        definingClass:"class:Page",
        groups:["files", "images"]
    },
    "method:ListGrid.hasChanges":{
        ref:"method:ListGrid.hasChanges",
        flags:"",
        description:" Whether the grid as a whole has any unsaved edits, in any row.\n",
        name:"hasChanges",
        seeAlso:[],
        returns:{description:"returns true of any unsaved edits are present", type:"boolean"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "attr:OperationBinding.invalidateCache":{
        ref:"attr:OperationBinding.invalidateCache",
        flags:"IR",
        description:"If set, every invocation of this operationBinding will invalidate the local cache, forcing\n a server visit to refresh the data.",
        name:"invalidateCache",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding"
    },
    "attr:Layout.hPolicy":{
        ref:"attr:Layout.hPolicy",
        flags:"IRWA",
        description:"Sizing policy applied to members on horizonal axis",
        name:"hPolicy",
        seeAlso:[],
        valueType:"LayoutPolicy",
        defaultValue:"\"fill\"",
        type:"attr",
        definingClass:"class:Layout",
        groups:["layoutPolicy"]
    },
    "attr:ListGrid.canResizeFields":{
        flags:"IRW",
        type:"attr",
        ref:"attr:ListGrid.canResizeFields",
        description:"Indicates whether fields in this listGrid can be resized by dragging header\n          fields.",
        name:"canResizeFields",
        setter:["setCanResizeFields"],
        valueType:"boolean",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('columnSize')}"],
        defaultValue:"true",
        groups:["dragging"],
        definingClass:"class:ListGrid"
    },
    "attr:Window.showFooter":{
        ref:"attr:Window.showFooter",
        flags:"IRW",
        description:"If true, show a footer for this Window, including resizer, statusBar, etc.\n This setting is commonly overridden for skinning purposes.",
        name:"showFooter",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('windowFooter')}"],
        definingClass:"class:Window",
        groups:["appearance", "footer"]
    },
    "type:XMLDocument":{
        ref:"type:XMLDocument",
        description:"XMLDocument is the \"parsed\" or object form of XML, which allows XML to be navigated as\n a tree of nodes with attributes, namespaces and other metadata, as opposed to being\n manipulated as just a String.\n <P> \n XMLDocument is a native object supplied directly by the browser.  The SmartClient-supported\n interfaces for this object are methods that take an XMLDocument as an argument (such as\n ${isc.DocUtils.linkForRef('classMethod:XMLTools.selectNodes')}).  If you want to retrieve XML data and display it in a\n SmartClient component, read about ${isc.DocUtils.linkForRef('group:clientDataIntegration','XML Data Binding')}.  To\n extract data as JavaScript Objects from XML, see ${isc.DocUtils.linkForRef('classMethod:XMLTools.toJS')}.  Direct\n manipulation of XMLDocument is subject to cross-browser inconsistencies, bugs, memory leaks\n and performance issues.",
        name:"XMLDocument",
        seeAlso:[],
        type:"type"
    },
    "attr:ListGridField.isRemoveField":{
        ref:"attr:ListGridField.isRemoveField",
        flags:"IRA",
        description:"If set to true and ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} is true, this field will be rendered\n as the remove-field for this grid. In most common usage scenarios this field will essentially\n be a placeholder indicating where the remove field should be rendered, meaning properties \n other than <code>isRemoveField</code>, such as <code>name</code> or <code>title</code>, may\n be left unset.",
        name:"isRemoveField",
        seeAlso:[
            {ref:"attr:ListGrid.canRemoveRecords", description:null}
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "method:Canvas.setPercentSource":{
        ref:"method:Canvas.setPercentSource",
        flags:"A",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:Canvas.percentSource','percentSource')} attribute.\n",
        name:"setPercentSource",
        seeAlso:[],
        params:[
            {description:"eterNew percent source (if ommitted existing                                      percentSource will just be cleared).",
             optional:true, name:"sourceWidget", defaultValue:null, type:"Canvas"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "attr:DynamicForm.rightTitlePrefix":{
        ref:"attr:DynamicForm.rightTitlePrefix",
        flags:"IRW",
        description:"The string prepended to the title of an item in this form if its\n          titleOrientation property is set to \"right\".",
        name:"rightTitlePrefix",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\":&nbsp;\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["formTitles"]
    },
    "group:componentBinding":{
        ref:"group:componentBinding",
        title:"Component Binding",
        refs:["attr:DataSourceField.title", "attr:DataSourceField.canEdit", 
         "attr:DataSourceField.canSave","attr:DataSourceField.editorType", "attr:DataSourceField.hidden", 
         "attr:DataSourceField.ignore","attr:DataSourceField.detail"],
        description:"Properties that control how a DataBound Component binds to this DataSource",
        name:"componentBinding",
        seeAlso:[],
        type:"group"
    },
    "method:SectionStack.getVisibleSections":{
        ref:"method:SectionStack.getVisibleSections",
        flags:"",
        description:"\n Returns the list of currently visible sections.  The list items are section IDs.\n\n",
        name:"getVisibleSections",
        seeAlso:[],
        returns:{description:"list of hidden sections", type:"List"},
        type:"method",
        definingClass:"class:SectionStack"
    },
    "classMethod:EventHandler.getKey":{
        ref:"classMethod:EventHandler.getKey",
        flags:"",
        description:"			Return the name of the key for the event passed in.\n			Note that this is only set reliably for keyboard events.\n\n",
        name:"getKey",
        seeAlso:[],
        returns:{description:"Key Name", type:"KeyName"},
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:["keyboardEvents"]
    },
    "attr:ListGridField.baseStyle":{
        ref:"attr:ListGridField.baseStyle",
        flags:"IRW",
        description:"Custom base style to apply to all cells in this field instead of ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')}\n  To override the baseStyle at the row level, use \n  ${isc.DocUtils.linkForRef('attr:ListGrid.recordBaseStyleProperty','record[listGrid.recordBaseStyleProperty]')}\n  instead.",
        name:"baseStyle",
        seeAlso:[
            {ref:"attr:ListGrid.recordBaseStyleProperty", description:null}
        ],
        valueType:"cssClass",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('gridCells')}"],
        definingClass:"object:ListGridField",
        groups:["appearance"]
    },
    "attr:Calendar.eventDialog":{
        ref:"attr:Calendar.eventDialog",
        flags:"R",
        description:"An autochild of type ${isc.DocUtils.linkForRef('class:Window')} that displays a quick event entry form within a \n popup window.",
        name:"eventDialog",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "method:ImgButton.setState":{
        ref:"method:ImgButton.setState",
        flags:"",
        description:" Set the 'state' of this object, this changes it's appearance.\n\n",
        name:"setState",
        seeAlso:[
            {ref:"method:ImgButton.setDisabled", description:"which also affects state values."}
        ],
        params:[
            {description:"new state", optional:false, name:"newState", defaultValue:null, type:"State"}
        ],
        type:"method",
        definingClass:"class:ImgButton",
        groups:["state", "appearance"]
    },
    "attr:Canvas.animateAcceleration":{
        ref:"attr:Canvas.animateAcceleration",
        flags:"IRWA",
        description:"Default acceleration effect to apply to all animations on this Canvas.\n Can be overridden by setting animationAcceleration for specific animations or by passing\n an acceleration function directly into the appropriate method.",
        name:"animateAcceleration",
        seeAlso:[],
        valueType:"AnimationEffect",
        defaultValue:"\"smoothEnd\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "method:ListGrid.refreshFields":{
        ref:"method:ListGrid.refreshFields",
        flags:"",
        description:" Re-evaluates ${isc.DocUtils.linkForRef('method:ListGridField.showIf')} for each field, dynamically showing and \n hiding the appropriate set of fields\n",
        name:"refreshFields",
        seeAlso:[],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:CubeGrid.cellSelectionChanged":{
        ref:"method:CubeGrid.cellSelectionChanged",
        flags:"",
        description:"\n      Handler/Notification function for cell selection change\n      May update header button styles.\n\n      <br><i>methodType</i> handler\n",
        name:"cellSelectionChanged",
        seeAlso:[],
        params:[
            {description:"array of cells with new selection state", optional:false, name:"cellList",
             defaultValue:null, type:"Array of cells"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "method:TileGrid.selectRecords":{
        ref:"method:TileGrid.selectRecords",
        flags:"",
        description:"\n Select/deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n\n",
        name:"selectRecords",
        seeAlso:[],
        params:[
            {description:"records (or row numbers) to select", optional:false, name:"records",
             defaultValue:null, type:"Array of Record | numbers"},
            {description:"new selection state (if null, defaults to true)", optional:true,
             name:"newState", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:["selection"]
    },
    "attr:ListGridField.imageURLSuffix":{
        ref:"attr:ListGridField.imageURLSuffix",
        flags:"IRWA",
        description:"If any cells in this field are showing a value icon (see: ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')})\n or this is has ${isc.DocUtils.linkForRef('type:ListGridFieldType')} set to <code>\"image\"</code>, this the value\n of this property will be appended to the end of the URL for the icon displayed.<br>\n Typical usage might be to append a file type such as <code>\".gif\"</code> to the\n filename of the image.<br>\n For editable fields, this property will also be passed through to any editors as\n ${isc.DocUtils.linkForRef('attr:FormItem.imageURLSuffix')}.",
        name:"imageURLSuffix",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('imageType')}"],
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "attr:StretchImgButton.labelVPad":{
        ref:"attr:StretchImgButton.labelVPad",
        flags:"IRW",
        description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",
        name:"labelVPad",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "method:Array.remove":{
        ref:"method:Array.remove",
        flags:"",
        description:" Remove first instance of the passed object from this array, sliding other items around to\n fill gaps.\n\n",
        name:"remove",
        seeAlso:[],
        params:[
            {description:"item to remove", optional:false, name:"obj", defaultValue:null, type:"any"}
        ],
        returns:{description:"true if a matching object was found and removed, false if no matching object was found and the list remains unchanged.",
         type:"boolean"},
        type:"method",
        definingClass:"object:Array",
        groups:["modification"]
    },
    "attr:StretchImgButton.labelLengthPad":{
        ref:"attr:StretchImgButton.labelLengthPad",
        flags:"IRW",
        description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",
        name:"labelLengthPad",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "method:Canvas.scrollToLeft":{
        ref:"method:Canvas.scrollToLeft",
        flags:"",
        description:" Horizontally scrolls the content of the widget to 0\n\n",
        name:"scrollToLeft",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas",
        groups:["scrolling"]
    },
    "method:ImgButton.select":{
        ref:"method:ImgButton.select",
        flags:"",
        description:" Select this object.\n",
        name:"select",
        seeAlso:[],
        type:"method",
        definingClass:"class:ImgButton",
        groups:["state"]
    },
    "attr:Chart.title":{
        ref:"attr:Chart.title",
        flags:"IR",
        description:"Title for the chart as a whole.",
        name:"title",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:Chart"
    },
    "method:GridRenderer.refreshCellStyle":{
        ref:"method:GridRenderer.refreshCellStyle",
        flags:"",
        description:" Refresh the styling of an individual cell without redrawing the grid.\n <P>\n The cell's CSS class and CSS text will be refreshed, to the current values returned by\n getCellStyle() and getCellCSSText() respectively.\n <P>\n The cell's contents (as returned by getCellValue()) will <b>not</b> be refreshed.  To\n refresh both styling and contents, call refreshCell() instead.\n\n",
        name:"refreshCellStyle",
        seeAlso:[
            {ref:"method:GridRenderer.refreshCell", description:"to update cell contents too"}
        ],
        params:[
            {description:"row number of cell to refresh", optional:false, name:"rowNum",
             defaultValue:null, type:"number"},
            {description:"column number of cell to refresh", optional:false, name:"colNum",
             defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["appearance"]
    },
    "method:Canvas.setCursor":{
        ref:"method:Canvas.setCursor",
        flags:"",
        description:"			Sets the cursor for this widget to cursor. See the cursor property\n          for possible values.\n",
        name:"setCursor",
        seeAlso:[],
        params:[
            {description:"new cursor", optional:false, name:"newCursor", defaultValue:null,
             type:"Cursor"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["cues"]
    },
    "group:subset":{
        ref:"group:subset",
        refs:["method:Array.getUniqueItems"],
        name:"subset",
        seeAlso:[],
        type:"group"
    },
    "method:List.isEmpty":{
        ref:"method:List.isEmpty",
        flags:"",
        description:" Return whether or not this array is empty\n\n",
        name:"isEmpty",
        seeAlso:[],
        returns:{description:"true == this array is empty, false == some items in the array", type:"boolean"},
        type:"method",
        definingClass:"interface:List",
        groups:["access"]
    },
    "method:SectionStack.addItem":{
        ref:"method:SectionStack.addItem",
        flags:"",
        description:" Add a canvas as an item to a section.\n",
        name:"addItem",
        seeAlso:[],
        params:[
            {description:"ID or index of the section to add item to", optional:false, name:"section",
             defaultValue:null, type:"String or Number"},
            {description:"Item to insert into the section", optional:false, name:"item",
             defaultValue:null, type:"Canvas"},
            {description:"Index into section to insert item", optional:false, name:"index",
             defaultValue:null, type:"Number"}
        ],
        type:"method",
        definingClass:"class:SectionStack"
    },
    "attr:ListGrid.checkboxFieldTrueImage":{
        ref:"attr:ListGrid.checkboxFieldTrueImage",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionAppearance')} is set to <code>\"checkbox\"</code> this property\n determines the image to display in the checkbox field for a selected row.\n If unset, the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} will be used.",
        name:"checkboxFieldTrueImage",
        seeAlso:[
            {ref:"attr:ListGrid.checkboxFieldFalseImage", description:null},
            {ref:"attr:ListGrid.checkboxFieldImageWidth", description:null},
            {ref:"attr:ListGrid.checkboxFieldImageHeight", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["checkboxField"]
    },
    "attr:Canvas.animateScrollTime":{
        ref:"attr:Canvas.animateScrollTime",
        flags:"IRWA",
        description:"Default time for performing an animated scroll.  If unset, <code>this.animateTime</code>\n will be used by default instead",
        name:"animateScrollTime",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "group:buttonIcon":{
        ref:"group:buttonIcon",
        title:"Button Icon",
        refs:["method:StatefulCanvas.setIconOrientation", "method:StatefulCanvas.setIcon", 
         "method:Button.setIconOrientation","method:Button.setIcon", "method:Button.iconClick", "method:Label.setIconOrientation", 
         "method:Label.setIcon","method:ImgButton.setIconOrientation", "method:ImgButton.setIcon", 
         "method:StretchImgButton.setIconOrientation","method:StretchImgButton.setIcon", "method:StretchImgButton.iconClick", 
         "attr:StatefulCanvas.icon","attr:StatefulCanvas.iconSize", "attr:StatefulCanvas.iconWidth", 
         "attr:StatefulCanvas.iconHeight","attr:StatefulCanvas.iconOrientation", "attr:StatefulCanvas.iconSpacing", 
         "attr:StatefulCanvas.showDisabledIcon","attr:StatefulCanvas.showRollOverIcon", "attr:StatefulCanvas.showDownIcon", 
         "attr:StatefulCanvas.showSelectedIcon","attr:StatefulCanvas.showFocusedIcon", "attr:Button.icon", "attr:Button.iconSize", 
         "attr:Button.iconWidth","attr:Button.iconHeight", "attr:Button.iconOrientation", "attr:Button.iconAlign", 
         "attr:Button.iconSpacing","attr:Button.showDisabledIcon", "attr:Button.showRollOverIcon", 
         "attr:Button.showFocusedIcon","attr:Button.showDownIcon", "attr:Button.showSelectedIcon", "attr:Label.icon", 
         "attr:Label.iconSize","attr:Label.iconWidth", "attr:Label.iconHeight", "attr:Label.iconOrientation", 
         "attr:Label.iconAlign","attr:Label.iconSpacing", "attr:Label.showDisabledIcon", "attr:Label.showRollOverIcon", 
         "attr:Label.showFocusedIcon","attr:Label.showDownIcon", "attr:Label.showSelectedIcon", "attr:ImgButton.icon", 
         "attr:ImgButton.iconSize","attr:ImgButton.iconWidth", "attr:ImgButton.iconHeight", "attr:ImgButton.iconOrientation", 
         "attr:ImgButton.iconAlign","attr:ImgButton.iconSpacing", "attr:ImgButton.showDisabledIcon", 
         "attr:ImgButton.showRollOverIcon","attr:ImgButton.showFocusedIcon", "attr:ImgButton.showDownIcon", 
         "attr:ImgButton.showSelectedIcon","attr:StretchImgButton.icon", "attr:StretchImgButton.iconSize", 
         "attr:StretchImgButton.iconWidth","attr:StretchImgButton.iconHeight", "attr:StretchImgButton.iconOrientation", 
         "attr:StretchImgButton.iconAlign","attr:StretchImgButton.iconSpacing", "attr:StretchImgButton.showDisabledIcon", 
         "attr:StretchImgButton.showRollOverIcon","attr:StretchImgButton.showFocusedIcon", "attr:StretchImgButton.showDownIcon", 
         "attr:StretchImgButton.showSelectedIcon","attr:ListGridField.iconSpacing", "attr:ListGridField.showDisabledIcon", 
         "attr:ListGridField.showRollOverIcon","attr:ListGridField.showFocusedIcon", "attr:ListGridField.showDownIcon", 
         "attr:ListGridField.showSelectedIcon"],
        description:"Control over optional icons shown in Buttons, Labels and other contexts",
        name:"buttonIcon",
        seeAlso:[],
        type:"group"
    },
    "attr:Tree.nameProperty":{
        ref:"attr:Tree.nameProperty",
        flags:"IRW",
        description:"Name of the property on a ${isc.DocUtils.linkForRef('object:TreeNode')} that holds a name for the node that is unique\n among it's immediate siblings, thus allowing a unique path to be used to identify the node,\n similar to a file system.  Default value is \"name\".  See ${isc.DocUtils.linkForRef('attr:TreeNode.name')} for usage.",
        name:"nameProperty",
        seeAlso:[
            {ref:"attr:TreeNode.name", description:null}
        ],
        valueType:"string",
        defaultValue:"\"name\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('nodeTitles')}"],
        definingClass:"class:Tree"
    },
    "attr:StretchImgButton.hiliteAccessKey":{
        ref:"attr:StretchImgButton.hiliteAccessKey",
        flags:"IRW",
        description:"If set to true, if the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.title','title')} of this button contains the\n specified ${isc.DocUtils.linkForRef('attr:Canvas.accessKey','accessKey')}, when the title is displayed to the user\n it will be modified to include HTML to underline the accessKey.<br>\n Note that this property may cause titles that include HTML (rather than simple strings)\n to be inappropriately modified, so should be disabled if your title string includes\n HTML characters.",
        name:"hiliteAccessKey",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "method:CubeGrid.getFacetValuesRow":{
        ref:"method:CubeGrid.getFacetValuesRow",
        flags:"",
        description:" Get the index of the first row in the grid that matches the specified FacetValueMap.<br>\n The facetValues passed in should contain values for at least one row facet. If values are \n sparse (values not specified for every row facet), the first row matching the specified\n facet values will be returned.\n",
        name:"getFacetValuesRow",
        seeAlso:[],
        params:[
            {description:"facet values to find", optional:false, name:"facetValues", defaultValue:null,
             type:"facetValueMap"}
        ],
        returns:{description:"index of first row in the grid that matches the facet values passed in.",
         type:"integer"},
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "classMethod:Log.setLogPriority":{
        ref:"classMethod:Log.setLogPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for some log category, when logged on\n this Class or Instance object.<br>\n If called with no category, this priority will be applied to every logged message on this\n object<br>\n To set the visible log priority for some category across the entire page, use\n <code>isc.Log.setPriority()</code> instead.\n",
        name:"setLogPriority",
        seeAlso:[
            {ref:"classMethod:Log.setPriority", description:null}
        ],
        params:[
            {description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
             optional:false, name:"category", defaultValue:null, type:"string"},
            {description:"priority level", optional:false, name:"priority", defaultValue:null,
             type:"LogPriority"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "method:ListGrid.selectionChanged":{
        ref:"method:ListGrid.selectionChanged",
        flags:"",
        description:" Called when (row-based) selection changes within this grid. Note this method fires for\n each record for which selection is modified - so when a user clicks inside a grid this\n method will typically fire twice (once for the old record being deselected, and once for\n the new record being selected).\n\n",
        name:"selectionChanged",
        seeAlso:[],
        params:[
            {description:"record for which selection changed", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"New selection state (true for selected, false for unselected)",
             optional:false, name:"state", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('multipleSelect')}"],
        definingClass:"class:ListGrid",
        groups:["selection"]
    },
    "attr:Canvas.dragRepositionCursor":{
        ref:"attr:Canvas.dragRepositionCursor",
        flags:"IRWA",
        description:"Cursor to switch to if the mouse is over a widget that is drag repositionable.",
        name:"dragRepositionCursor",
        seeAlso:[],
        valueType:"Cursor",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "group:clientOnlyDataSources":{
        ref:"group:clientOnlyDataSources",
        title:"Client Only DataSources",
        treeLocation:["Client Reference/Data Binding/DataSource"],
        refs:["attr:DataSource.clientOnly", "attr:DataSource.testData"],
        description:"For prototyping purposes, a \"client-only\" DataSource can be created that has no permanent\n storage and never contacts the server, instead using a set of test data to respond to\n requests in the same manner as a server-based DataSource might.\n <P>\n The client-side interface to a client-only DataSource is identical to a server-based\n DataSource, including asynchronous responses, so that a client-only DataSource can be\n replaced by a server-based DataSource without code changes.  The only difference is that\n changes to records belonging to the DataSource persist only until the page is reloaded.\n <p>\n Client-only DataSources allow you to create a complete prototype application in an .html\n file that does not require a server.\n <p>\n The <code>clientOnly</code> property is specified to create a client-only DataSource, and\n the <code>testData</code> property should contain the test dataset, as an Array of Objects,\n one per DataSource record.  For example:\n <pre>\n   isc.DataSource.create({\n       ID:\"supplyItem\",\n       fields: ...,\n       clientOnly:true,\n       testData:[\n          {itemName:\"Pencil\", cost:5.50},\n          ...\n       ]\n   });\n </pre>\n If you have existing test data in XML (see the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} for\n expected format),\n you can use the XML->JS translation engine to load it into a client-only DataSource, like so:\n <pre>\n   isc.DataSource.create({\n     ID:\"solutions\",\n     fields: ...,\n     clientOnly : true,\n     testData : \n         &lt;isomorphic:XML filename=\"shared/ds/test_data/solutions.data.xml\"/&gt;\n   });\n </pre>\n Another useful practice is to specify both the clientOnly DataSource and it's test data in\n XML, so that the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} can later be used to import the\n DataSource and its test data into a SQL DataBase.  An idiom for accomplishing this is:\n <pre>\n   &lt;isomorphic:loadDS name=\"solutions\"/&gt;\n   isc.DataSource.getDataSource(\"solutions\").addProperties({\n     clientOnly : true,\n     testData : \n        &lt;isomorphic:XML filename=\"shared/ds/test_data/solutions.data.xml\"/&gt;\n   });\n </pre>\n Finally, if you specify your DataSource as <code>clientOnly: true</code>, omit testData\n entirely, and provide either a ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')} or a <code>testFileName</code>, the\n DataSource will lazily make a one-time fetch against the specified data file the first time\n an operation is called on it.  From then on, the DataSource will work against the local\n cache created from this initial request.  This is a quick way to prototype against some test\n data that may eventually be returned from an arbitrary back-end.",
        name:"clientOnlyDataSources",
        seeAlso:[],
        type:"group"
    },
    "attr:StretchImg.vSrc":{
        ref:"attr:StretchImg.vSrc",
        flags:"IRW",
        description:"Base URL for the image if ${isc.DocUtils.linkForRef('attr:StretchImg.vertical')} is true and \n ${isc.DocUtils.linkForRef('attr:StretchImg.src')} is unset.",
        name:"vSrc",
        seeAlso:[
            {ref:"attr:StretchImg.src", description:null},
            {ref:"attr:StretchImg.vSrc", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImg",
        groups:["appearance"]
    },
    "method:Canvas.doubleClick":{
        ref:"method:Canvas.doubleClick",
        flags:"A",
        description:"\n Executed when the left mouse button is clicked twice in rapid succession (within\n ${isc.DocUtils.linkForRef('attr:Canvas.doubleClickDelay')} by default) in this object.\n\n",
        name:"doubleClick",
        seeAlso:[
            {ref:"attr:Canvas.doubleClickDelay", description:null}
        ],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "type:SortDirection":{
        ref:"type:SortDirection",
        values:[
            {description:"Sort in ascending order (eg: A-Z, larger items later in the list)",
             value:"\"ascending\""},
            {description:"Sort in descending order (eg: Z-A, larger items earlier in the list)",
             value:"\"descending\""}
        ],
        description:null,
        name:"SortDirection",
        seeAlso:[],
        type:"type",
        groups:["sorting"]
    },
    "group:sizing":{
        ref:"group:sizing",
        refs:["method:FormItem.getIconHeight", "method:FormItem.getIconWidth", "method:Canvas.setRect", 
         "method:Canvas.getWidth","method:Canvas.setWidth", "method:Canvas.getHeight", "method:Canvas.setHeight", 
         "method:Canvas.getRight","method:Canvas.setRight", "method:Canvas.getBottom", "method:Canvas.setBottom", 
         "method:Canvas.getScrollWidth","method:Canvas.getScrollHeight", "method:Canvas.getViewportWidth", 
         "method:Canvas.getViewportHeight","method:Canvas.getInnerHeight", "method:Canvas.getInnerWidth", 
         "method:Canvas.getInnerContentHeight","method:Canvas.getInnerContentWidth", "method:Canvas.getVisibleWidth", 
         "method:Canvas.getVisibleHeight","method:Canvas.resizeBy", "method:Canvas.setPercentSource", "method:Canvas.layoutChildren", 
         "method:Canvas.resizeTo","method:Canvas.parentResized", "method:Canvas.setOverflow", 
         "method:Canvas.adjustForContent","method:ListGrid.setHeaderHeight", "classMethod:Page.resizeTo", 
         "classMethod:Page.getWidth","classMethod:Page.getHeight", "classMethod:Page.getScrollWidth", 
         "classMethod:Page.getScrollHeight","classMethod:Page.getScrollLeft", "classMethod:Page.getScrollTop", 
         "attr:StatefulCanvas.autoFit","attr:Button.autoFit", "attr:Img.size", "attr:Label.wrap", "attr:Label.autoFit", 
         "attr:ToolStrip.height","attr:ImgButton.autoFit", "attr:StretchImgButton.autoFit", "attr:Canvas.width", 
         "attr:Canvas.height","attr:Canvas.defaultWidth", "attr:Canvas.defaultHeight", "attr:Canvas.minWidth", 
         "attr:Canvas.maxWidth","attr:Canvas.minHeight", "attr:Canvas.maxHeight", "attr:Canvas.overflow", 
         "attr:Canvas.percentSource","attr:Canvas.percentBox", "attr:Canvas.snapTo", "attr:Canvas.snapEdge", 
         "attr:Canvas.snapOffsetLeft","attr:Canvas.snapOffsetTop", "attr:GridRenderer.fixedColumnWidths", 
         "attr:GridRenderer.autoFit","attr:ListGrid.bodyOverflow", "attr:ListGrid.headerHeight", "attr:Menu.defaultWidth", 
         "attr:Menu.cellHeight","attr:TileLayout.tileSize", "attr:TileLayout.tileWidth", "attr:TileLayout.tileHeight", 
         "attr:TileLayout.overflow","type:Overflow"],
        description:"Width and height of an object",
        name:"sizing",
        seeAlso:[],
        type:"group"
    },
    "attr:ListGrid.cellHeight":{
        ref:"attr:ListGrid.cellHeight",
        flags:"IRW",
        description:"The default height of each row in pixels.",
        name:"cellHeight",
        seeAlso:[
            {ref:"method:GridRenderer.getRowHeight", description:null}
        ],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('multilineValues')}"],
        definingClass:"class:ListGrid",
        groups:["cellStyling"]
    },
    "group:labels":{
        ref:"group:labels",
        refs:["attr:DetailViewer.labelPrefix", "attr:DetailViewer.labelSuffix", 
         "attr:DetailViewer.wrapLabel","attr:DetailViewer.wrapValues"],
        name:"labels",
        seeAlso:[],
        type:"group"
    },
    "attr:DetailViewer.recordsPerBlock":{
        ref:"attr:DetailViewer.recordsPerBlock",
        flags:"IRW",
        description:"The number of records to display in a block. A block is a horizontal row on a page\n          containing one or more records, as specified by the value of recordsPerBlock. The\n          height of a block is equal to the height of a single record. The default setting of\n          1 causes each record to appear by itself in a vertical row. Setting recordsPerBlock\n          to 2 would cause records to appear side by side in groups of two.\n          Use a value of \"*\" to indicate all records.",
        name:"recordsPerBlock",
        seeAlso:[],
        valueType:"number",
        defaultValue:"1",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:["appearance"]
    },
    "attr:Canvas.position":{
        ref:"attr:Canvas.position",
        flags:"IRWA",
        description:"Absolute or relative, corresponding to the \"absolute\" (with respect to parent) or\n \"relative\" (with respect to document flow) values for the CSS position attribute.\n <P>\n Setting <code>position:\"relative\"</code> enables SmartClient components to be embedded\n directly into the native HTML flow of a page, causing the component to be rendered \n within an existing DOM structure. \n This attribute should only be set to <code>\"relative\"</code> on a top level component \n (a component with no ${isc.DocUtils.linkForRef('attr:Canvas.parentElement')}). \n <P>\n There are 2 ways to embed relatively positioned canvases in the DOM - by default the\n component will be written out inline when it gets ${isc.DocUtils.linkForRef('method:Canvas.draw','drawn()n')}. For example\n to embed a canvas in an HTML table you could use this code: \n <pre>\n &lt;table&gt;\n   &lt;tr&gt;\n     &lt;td&gt;\n       &lt;script&gt;\n         isc.Canvas.create({autoDraw:true, backgroundColor:\"red\", position:\"relative\"});\n       &lt;/script&gt;\n     &lt;td&gt;\n   &lt;/tr&gt;\n &lt;/table&gt;\n </pre>\n Alternatively you can make use of the ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} attribute.\n <P>\n Relative positioning is intended as a short-term integration scenario while incrementally\n upgrading existing applications.\n Note that relative positioning is not used to manage layout within SmartClient components -\n instead the ${isc.DocUtils.linkForRef('class:Layout')} class would typically be used.\n For best consistency and flexibility across browsers, all SmartClient layout managers\n use absolute positioning.\n <P>\n For canvases with a specified ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')}, this attribute defaults to\n <code>\"relative\"</code>. In all other cases the default value will be \n <code>\"aboslute\"</code>.",
        name:"position",
        seeAlso:[],
        valueType:"Positioning",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('inlineComponents')}"],
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "classMethod:Log.echo":{
        ref:"classMethod:Log.echo",
        flags:"",
        description:" Return a short string representation of any object, suitable for viewing by a developer for\n debugging purposes.\n <P>\n If passed an object containing other objects, echo will not recurse into subobjects,\n summarizing them instead via echoLeaf().\n <P>\n NOTE: echo() is used to generate the output shown in the Log window when evaluating an\n expression.\n <P>\n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.echo()\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n \n",
        name:"echo",
        seeAlso:[
            {ref:"classMethod:Log.echoAll", description:null},
            {ref:"classMethod:Log.echoLeaf", description:null}
        ],
        params:[
            {description:"object to echo", optional:false, name:"obj", defaultValue:null, type:"any"}
        ],
        returns:{description:"a short string representation of the object", type:"string"},
        type:"classMethod",
        definingClass:"class:Log",
        groups:["debug"]
    },
    "method:CubeGrid.makeChart":{
        ref:"method:CubeGrid.makeChart",
        flags:"",
        description:" Chart the portion of the dataset indicated by <code>fixedFacetValues</code>, for all \n values of the <code>variableFacets</code>.\n <P>\n One, two or more variableFacets may be passed.  Two variable facets for a column chart will\n result in ${isc.DocUtils.linkForRef('attr:Chart.stacked','stacking')} or clustering.  Three facets or more may be\n supported by some ${isc.DocUtils.linkForRef('attr:CubeGrid.chartType','chartTypes')} or\n ${isc.DocUtils.linkForRef('attr:CubeGrid.chartConstructor','charting engines')}.\n \n",
        name:"makeChart",
        seeAlso:[],
        params:[
            {description:"set of facet values to hold constant.  Pass null to                                         chart the entire dataset.",
             optional:false, name:"fixedFacetValues", defaultValue:null, type:"FacetValueMap"},
            {description:"set of facets to be charted", optional:false, name:"variableFacets",
             defaultValue:null, type:"Array of FacetIds"},
            {description:"properties to pass through to the created                        ${isc.DocUtils.linkForRef('interface:Chart')}",
             optional:false, name:"chartProperties", defaultValue:null, type:"Chart properties"}
        ],
        returns:{description:"created chart instance", type:"Chart"},
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:Tree.discardParentlessNodes":{
        ref:"attr:Tree.discardParentlessNodes",
        flags:"IRA",
        description:"If this tree has ${isc.DocUtils.linkForRef('attr:Tree.modelType','modelType:\"parent\"')}, should nodes in the data array for the\n tree be dropped if they have an explicitly specified value for the ${isc.DocUtils.linkForRef('attr:Tree.parentIdField')}\n which doesn't match any other nodes in the tree. If set to false these nodes will be added as\n children of the root node.",
        name:"discardParentlessNodes",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Tree"
    },
    "attr:SectionStackSection.resizeable":{
        ref:"attr:SectionStackSection.resizeable",
        flags:"I",
        description:"If set to false, then the items in this section will not be resized by sectionHeader\n repositioning.  You may also set this flag directly on any of the items in any section to\n cause that item to not be resizeable.",
        name:"resizeable",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('resizeSections')}"],
        definingClass:"object:SectionStackSection"
    },
    "attr:DetailViewerField.imageSize":{
        ref:"attr:DetailViewerField.imageSize",
        flags:"IRW",
        description:"Size of images shown for fieldTypes image in this field.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n height.  For example, if <code>field.imageSize</code> is \"logoSize\",\n <code>record.logoSize</code> will control the size of the image.",
        name:"imageSize",
        seeAlso:[
            {ref:"attr:DetailViewerField.imageWidth", description:null},
            {ref:"attr:DetailViewerField.imageHeight", description:null}
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField",
        groups:["imageColumns"]
    },
    "method:PickList.getPickListFilterCriteria":{
        ref:"method:PickList.getPickListFilterCriteria",
        flags:"A",
        description:" Returns a set of filter criteria to be applied to the data displayed in the pickList when\n it is shown.\n <P>\n If this is a databound item the criteria will be passed as criteria to\n ${isc.DocUtils.linkForRef('method:DataSource.fetchData')}.  Otherwise an equivalent client-side filter will be\n performed on the data returned by ${isc.DocUtils.linkForRef('method:PickList.getClientPickListData')}.\n <P>\n By default returns ${isc.DocUtils.linkForRef('attr:PickList.pickListCriteria')} if specified, otherwise an empty \n set of criteria so all records will be displayed.\n\n",
        name:"getPickListFilterCriteria",
        seeAlso:[],
        returns:{description:"criteria to be used for databound or local filtering", type:"Criteria"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('databoundDependentSelects')}"],
        definingClass:"interface:PickList"
    },
    "method:MenuButton.setShowMenuBelow":{
        ref:"method:MenuButton.setShowMenuBelow",
        flags:"",
        description:" Setter for the 'showMenuButtonBelow' property - determines whether the menu will be\n shown above or below the menubutton.\n",
        name:"setShowMenuBelow",
        seeAlso:[],
        params:[
            {description:"True if the menu should be shown below the menubutton.", optional:false,
             name:"below", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:MenuButton"
    },
    "method:Array.equals":{
        ref:"method:Array.equals",
        flags:"",
        description:" Return whether this list is equal to another list.\n <P>\n Two lists are equal only if they have the same length and all contained items are in the same\n order and are also equal.\n\n",
        name:"equals",
        seeAlso:[],
        params:[
            {description:"list to check for equality", optional:false, name:"list", defaultValue:null,
             type:"List"}
        ],
        returns:{description:"whether the specified list is equal to this list", type:"boolean"},
        type:"method",
        definingClass:"object:Array",
        groups:["access"]
    },
    "attr:CubeGrid.defaultFacetWidth":{
        ref:"attr:CubeGrid.defaultFacetWidth",
        flags:"IRW",
        description:"default width of inner column headers",
        name:"defaultFacetWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["gridLayout"]
    },
    "attr:Tab.pickerTitle":{
        ref:"attr:Tab.pickerTitle",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:TabSet.showTabPicker')} is true for this TabSet, if set this property will determine\n the title of the picker menu item for this tab. If unset, ${isc.DocUtils.linkForRef('attr:Tab.title')} will be used\n instead",
        name:"pickerTitle",
        seeAlso:[
            {ref:"attr:TabSet.showTabPicker", description:null},
            {ref:"attr:Tab.title", description:null}
        ],
        valueType:"HTML",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Tab",
        groups:["tabBarControls"]
    },
    "method:ListGrid.hasErrors":{
        ref:"method:ListGrid.hasErrors",
        flags:"",
        description:" Does this grid currently have errors associated with editValues for any row in the grid.\n",
        name:"hasErrors",
        seeAlso:[
            {ref:"method:ListGrid.rowHasErrors", description:null},
            {ref:"method:ListGrid.cellHasErrors", description:null}
        ],
        returns:{description:"true if there are unresolved errors, false otherwise", type:"boolean"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["gridValidation"]
    },
    "attr:ColumnTree.fields":{
        ref:"attr:ColumnTree.fields",
        flags:"IRW",
        description:"An array of field objects, specifying the order, layout, dynamic calculation, and\n sorting behavior of each field in each column in the columnTree object. In ColumnTrees, \n the fields array specifies sub-columns within each main column. \n Each field in the fields array is a ListGridField object.\n <p>\n If ${isc.DocUtils.linkForRef('attr:ColumnTree.dataSource')} is also set, this value acts as a set of overrides as\n explained in ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}.",
        name:"fields",
        seeAlso:[
            {ref:"object:ListGridField", description:null}
        ],
        valueType:"Array of ListGridField",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ColumnTree",
        groups:["databinding"]
    },
    "method:ListGrid.rowEditorExit":{
        ref:"method:ListGrid.rowEditorExit",
        flags:"A",
        description:" Callback fired when the user attempts to navigate away from the current edit row, \n or complete the current edit.\n <P>\n Return false from this method to cancel the default behavior (Saving / cancelling the\n current edit / moving to the next edit cell).\n\n",
        name:"rowEditorExit",
        seeAlso:[
            {ref:"method:ListGridField.editorExit", description:null}
        ],
        params:[
            {description:"How was the edit completion fired?", optional:false,
             name:"editCompletionEvent", defaultValue:null, type:"EditCompletionEvent"},
            {description:"record for the cell being edited", optional:false, name:"record",
             defaultValue:null, type:"ListGridRecord"},
            {description:"new values for the record [Note that fields that have                                 not been edited will not be included in this object]",
             optional:false, name:"newValues", defaultValue:null, type:"object"},
            {description:"row number for the row being left", optional:false, name:"rowNum",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"Returning false from this method will cancel the default behavior                      (for example saving the row) and leave the editor visible and focus\n                      in this edit cell.",
         type:"boolean"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "method:ValuesManager.cancel":{
        ref:"method:ValuesManager.cancel",
        flags:"",
        description:"\n This method exists for clean integration with existing server frameworks that have a 'cancel'\n feature which typically clears session state associated with the form.  When this method is\n called, an RPC is sent to the server with a parameter named\n ${isc.DocUtils.linkForRef('attr:DynamicForm.cancelParamName')} with the value\n ${isc.DocUtils.linkForRef('attr:DynamicForm.cancelParamValue')}.<p>\n\n Note that no other form data is sent.  By default the current top-level page is replaced with the\n reply.  If you wish to ignore the server reply instead, call this method like this:\n <pre>\n dynamicFormInstance.cancel({ignoreTimeout: true, target: null});\n </pre>\n\n",
        name:"cancel",
        seeAlso:[],
        params:[
            {description:"additional properties to set on the RPCRequest                                          that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        definingClass:"class:ValuesManager",
        groups:["submitting"]
    },
    "method:Label.setIconOrientation":{
        ref:"method:Label.setIconOrientation",
        flags:"",
        description:" Changes the orientation of the icon relative to the text of the button.\n\n",
        name:"setIconOrientation",
        seeAlso:[],
        params:[
            {description:"The new orientation of the icon relative to the text of the button.",
             optional:false, name:"orientation", defaultValue:null, type:"\"left\" or \"right\""}
        ],
        type:"method",
        definingClass:"class:Label",
        groups:["buttonIcon"]
    },
    "method:List.findAll":{
        ref:"method:List.findAll",
        flags:"",
        description:" Find all objects where property == value in the object.\n <P>\n Pass an Object as the <code>propertyName</code> argument to match multiple properties.\n\n",
        name:"findAll",
        seeAlso:[],
        params:[
            {description:"property to match, or if an Object is passed, set of                                        properties and values to match",
             optional:false, name:"propertyName", defaultValue:null, type:"String or Object"},
            {description:"value to compare against (if propertyName is a string)", optional:true,
             name:"value", defaultValue:null, type:"any"}
        ],
        returns:{description:"all matching Objects or null if none found", type:"Array"},
        type:"method",
        definingClass:"interface:List",
        groups:["access", "find"]
    },
    "method:DOMGrid.setRootElement":{
        ref:"method:DOMGrid.setRootElement",
        flags:"",
        description:" Set the root element (or document) to view in the tree.\n",
        name:"setRootElement",
        seeAlso:[],
        params:[
            {description:"new root element", optional:false, name:"rootElement", defaultValue:null,
             type:"DOMElement"}
        ],
        type:"method",
        definingClass:"class:DOMGrid"
    },
    "method:CubeGrid.getEditedRecord":{
        ref:"method:CubeGrid.getEditedRecord",
        flags:"",
        description:" Returns the combination of unsaved edits (if any) and original values (if any) for a given\n cell being edited.\n <P>\n The returned value is never null, and can be freely modified.\n\n",
        name:"getEditedRecord",
        seeAlso:[],
        params:[
            {description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
             optional:false, name:"valuesID", defaultValue:null, type:"number | Object"},
            {description:"colNum of the record being edited. Only required if the records                          rowNum is passed in as the first parameter",
             optional:true, name:"colNum", defaultValue:null, type:"number"}
        ],
        returns:{description:"A copy of the record with unsaved edits included", type:"Object"},
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["editing"]
    },
    "method:ListGridField.getFieldTitle":{
        ref:"method:ListGridField.getFieldTitle",
        flags:"",
        description:" If your derivation of the field title is more complex than specifying a static string,\n you can specify a getFieldTitle() method on your field to return the title string.\n Otherwise you can use the ${isc.DocUtils.linkForRef('attr:ListGridField.title')} attribute on the field to specify the title.\n <P>\n You can use ${isc.DocUtils.linkForRef('method:ListGrid.setFieldProperties','setFieldProperties()')} to dynamically\n update the title.\n\n",
        name:"getFieldTitle",
        seeAlso:[
            {ref:"attr:ListGridField.title", description:null}
        ],
        params:[
            {description:"pointer back to the ListGrid", optional:false, name:"viewer",
             defaultValue:null, type:"ListGrid"},
            {description:"index of this field in the grid's fields array.", optional:false,
             name:"fieldNum", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"object:ListGridField",
        groups:["appearance"]
    },
    "attr:CubeGrid.skinImgDir":{
        ref:"attr:CubeGrid.skinImgDir",
        flags:"IR",
        description:"Default directory for skin images (those defined by the class), relative to the\n Page-wide ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','skinDir')}.",
        name:"skinImgDir",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"images/CubeGrid/\"",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["images"]
    },
    "classMethod:DataSource.setTypeOperators":{
        ref:"classMethod:DataSource.setTypeOperators",
        flags:"",
        description:" Set the list of valid ${isc.DocUtils.linkForRef('type:OperatorId')}s valid for a given FieldType.\n \n",
        name:"setTypeOperators",
        seeAlso:[],
        params:[
            {description:null, optional:false, name:"typeName", defaultValue:null, type:"FieldType"},
            {description:"available Operators", optional:false, name:"operators", defaultValue:null,
             type:"Array of OperatorId"}
        ],
        type:"classMethod",
        definingClass:"class:DataSource",
        groups:["advancedFilter"]
    },
    "method:Tree.addList":{
        ref:"method:Tree.addList",
        flags:"",
        description:"\n Add a list of nodes to some parent.\n\n",
        name:"addList",
        seeAlso:[
            {ref:"group:sharingNodes", description:null}
        ],
        params:[
            {description:"The list of nodes to add", optional:false, name:"nodeList", defaultValue:null,
             type:"List of TreeNode"},
            {description:"Parent of the node being added.  You can pass                                          in either the ${isc.DocUtils.linkForRef('object:TreeNode')} itself, or a path to\n	                                        the node (as a String), in which case a\n	                                        ${isc.DocUtils.linkForRef('method:Tree.find')} is performed to find\n	                                        the node.",
             optional:false, name:"parent", defaultValue:null, type:"String or TreeNode"},
            {description:"Position of the new node in the children list. If not	                                specified, the node will be added at the end of the list.",
             optional:true, name:"position", defaultValue:null, type:"number"}
        ],
        returns:{description:"List of added nodes.", type:"List"},
        type:"method",
        definingClass:"class:Tree"
    },
    "group:viewLoading":{
        ref:"group:viewLoading",
        refs:["method:ViewLoader.setViewURL", "class:ViewLoader", "attr:RPCRequest.evalResult", 
         "attr:RPCRequest.evalVars","attr:ViewLoader.loadingMessage"],
        name:"viewLoading",
        seeAlso:[],
        type:"group"
    },
    "attr:ListGrid.booleanTrueImage":{
        ref:"attr:ListGrid.booleanTrueImage",
        flags:"IRWA",
        description:"Image to display for a true value in a boolean field.\n <P>\n To turn this off explicitly set ${isc.DocUtils.linkForRef('attr:ListGridField.suppressValueIcon')} to true.\n <P>\n If this and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')} are undefined, this will be set to\n ${isc.DocUtils.linkForRef('attr:CheckboxItem.checkedImage')}.",
        name:"booleanTrueImage",
        seeAlso:[
            {ref:"attr:ListGrid.booleanFalseImage", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["imageColumns"]
    },
    "attr:PickTreeItem.displayField":{
        ref:"attr:PickTreeItem.displayField",
        flags:"IR",
        description:"Specifies an alternative field from which display values should be retrieved for this\n item.<br>\n If this item is not databound (${isc.DocUtils.linkForRef('attr:PickTreeItem.dataSource')} is unset), this is\n implemented by picking up the value of the specified field from the\n ${isc.DocUtils.linkForRef('attr:PickTreeItem.valueTree')}.<br>\n Otherwise this item will attempt to map its underlying value to a display value\n by retrieving a record from the ${isc.DocUtils.linkForRef('attr:PickTreeItem.dataSource')} where the \n ${isc.DocUtils.linkForRef('attr:PickTreeItem.valueField')} matches this item's value, and displaying the \n <code>displayField</code> value from that record.<br>",
        name:"displayField",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:PickTreeItem"
    },
    "method:DynamicForm.getField":{
        ref:"method:DynamicForm.getField",
        flags:"",
        description:" Synonym for dynamicForm.getItem()\n\n",
        name:"getField",
        seeAlso:[
            {ref:"method:DynamicForm.getItem", description:null}
        ],
        params:[
            {description:"name of the item you're looking for", optional:false, name:"itemName",
             defaultValue:null, type:"string"}
        ],
        returns:{description:"FormItem object or null if not found", type:"FormItem"},
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["items"]
    },
    "classMethod:EventHandler.rightButtonDown":{
        ref:"classMethod:EventHandler.rightButtonDown",
        flags:"",
        description:"			Returns true if the right mouse button is being pressed.\n\n",
        name:"rightButtonDown",
        seeAlso:[],
        returns:{description:"true == right button is down, false == up", type:"boolean"},
        type:"classMethod",
        platformNotes:"Mac:		Macintosh platform generally has only one mouse button, and the\n		control key being held down serves the same purpose of the \n		right mouse button on Windows.  This is taken into account automatically.<br>\n      Opera: \n      The Opera browser does not pass right mouse button events to JavaScript code by default\n      (the user must explictly enable this bahavior via a menu item). Therefore we \n      treat <b>Shift+Ctrl+Click</b> as a context click in Opera.",
        definingClass:"class:EventHandler",
        groups:["mouseEvents"]
    },
    "attr:ListGrid.valueIconLeftPadding":{
        ref:"attr:ListGrid.valueIconLeftPadding",
        flags:"IRW",
        description:"How much padding should there be on the left of valueIcons by default\n Can be overridden at the field level",
        name:"valueIconLeftPadding",
        seeAlso:[
            {ref:"attr:ListGridField.valueIcons", description:null}
        ],
        valueType:"number",
        defaultValue:"2",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["imageColumns"]
    },
    "method:ListGrid.setRowErrors":{
        ref:"method:ListGrid.setRowErrors",
        flags:"",
        description:" Set the validation errors for some row (replacing any pre-existant validation errors)\n",
        name:"setRowErrors",
        seeAlso:[
            {ref:"method:ListGrid.getRowErrors", description:null},
            {ref:"method:ListGrid.setFieldError", description:null}
        ],
        params:[
            {description:"row to add validation error for", optional:false, name:"rowNum",
             defaultValue:null, type:"number"},
            {description:"validation errors for the row in the format                           <code>{fieldName:errorMessage, ...}</code> <br>or <br>\n                          <code>{fieldName:[errorMessage1, errorMessage2], ...}</code>",
             optional:false, name:"errors", defaultValue:null, type:"object"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["gridValidation"]
    },
    "attr:StretchImgButton.showDownIcon":{
        ref:"attr:StretchImgButton.showDownIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the mouse goes\n down on the button.",
        name:"showDownIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["buttonIcon"]
    },
    "attr:ListGridField.displayFormat":{
        ref:"attr:ListGridField.displayFormat",
        flags:"IRWA",
        description:"For fields of type <code>\"date\"</code>, set this property to a valid\n ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} to specify how the date should be formatted.<br>\n For fields of type <code>\"time\"</code>, set this property to a valid \n ${isc.DocUtils.linkForRef('type:timeFormatter','timeFormatter')} to specify how the time should be formatted.<br>\n If unset, display format may be set at the listGrid level via ${isc.DocUtils.linkForRef('attr:ListGrid.dateFormatter')}\n or ${isc.DocUtils.linkForRef('attr:ListGrid.timeFormatter')}.\n <p>\n If this field is editable the displayFormat will also be passed to the editor created\n to edit this field.  For dates you may also need to set ${isc.DocUtils.linkForRef('attr:ListGridField.inputFormat')}.",
        name:"displayFormat",
        seeAlso:[
            {ref:"attr:ListGridField.inputFormat", description:null},
            {ref:"attr:ListGrid.dateFormatter", description:null},
            {ref:"attr:ListGrid.timeFormatter", description:null}
        ],
        valueType:"varies",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "attr:Calendar.showDateChooser":{
        ref:"attr:Calendar.showDateChooser",
        flags:"IR",
        description:"Determines whether the ${isc.DocUtils.linkForRef('attr:Calendar.dateChooser','dateChooser')} is displayed.",
        name:"showDateChooser",
        seeAlso:[],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["visibility"]
    },
    "method:WebService.getSoapMessage":{
        ref:"method:WebService.getSoapMessage",
        flags:"A",
        description:" Return the SOAP message that will be formed from this WSRequest.\n \n",
        name:"getSoapMessage",
        seeAlso:[],
        params:[
            {description:"web service request object", optional:false, name:"wsRequest",
             defaultValue:null, type:"WSRequest Properties"}
        ],
        returns:{description:"SOAP message", type:"String"},
        type:"method",
        definingClass:"class:WebService"
    },
    "attr:DSRequest.useFlatHeaderFields":{
        ref:"attr:DSRequest.useFlatHeaderFields",
        flags:"IRW",
        description:"Cause the ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields','useFlatFields')} XML serialization behavior to be used\n for <b>all</b> soap headers in the request.  See also ${isc.DocUtils.linkForRef('attr:DSRequest.headerData')}.",
        name:"useFlatHeaderFields",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest",
        groups:["flatFields"]
    },
    "attr:Toolbar.buttons":{
        ref:"attr:Toolbar.buttons",
        flags:"IRW",
        description:"An array of button object initializers. See the Button Widget Class for standard\n button properties. The following additional properties can also be specified for\n button sizing and positioning on the toolbar itself:<br><br>\n <ul><li>width--Specifies the width of this button as an absolute number of pixels, a\n named property of the toolbar that specifies an absolute number of pixels, a\n percentage of the remaining space (e.g. '60%'), or \"*\" (default) to allocate an\n equal portion of the remaining space.\n <li>height--Specifies the height of this button.\n <li>extraSpace--Specifies an optional amount of extra space, in pixels, to separate\n this button from the next button in the toolbar.</ul>",
        name:"buttons",
        setter:["setButtons"],
        seeAlso:[
            {ref:"method:Toolbar.addButtons", description:null},
            {ref:"method:Toolbar.removeButtons", description:null},
            {ref:"class:Button", description:null}
        ],
        valueType:"array",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Toolbar"
    },
    "method:Calendar.setChosenDate":{
        ref:"method:Calendar.setChosenDate",
        flags:"",
        description:" Set the current date for which the calendar will display events.\n\n",
        name:"setChosenDate",
        seeAlso:[],
        params:[
            {description:"the new date to set as the current date", optional:false, name:"newDate",
             defaultValue:null, type:"Date"}
        ],
        type:"method",
        definingClass:"class:Calendar"
    },
    "attr:OperationBinding.preventHTTPCaching":{
        ref:"attr:OperationBinding.preventHTTPCaching",
        flags:"IR",
        description:"Configures ${isc.DocUtils.linkForRef('attr:DataSource.preventHTTPCaching')} on a per-operationType basis.",
        name:"preventHTTPCaching",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding"
    },
    "attr:Window.src":{
        ref:"attr:Window.src",
        flags:"IRW",
        description:"A URL to load as content for the Window's body.  If specified, this\n attribute will take precedence over the items attribute.\n <P>\n Note that setting window.src is essentially a shortcut for setting ${isc.DocUtils.linkForRef('attr:Window.items')}\n to a single HTMLflow with a specified ${isc.DocUtils.linkForRef('attr:HTMLFlow.contentsURL','contentsURL')}.",
        name:"src",
        setter:["setSrc"],
        seeAlso:[
            {ref:"attr:Window.contentsType", description:null}
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "body"]
    },
    "attr:Canvas.className":{
        deprecated:"In favor or ${isc.DocUtils.linkForRef('attr:Canvas.styleName')} as of SmartClient release 5.5",
        flags:"IRW",
        type:"attr",
        ref:"attr:Canvas.className",
        description:"The CSS class applied to this widget as a whole.",
        name:"className",
        setter:["setClassName"],
        valueType:"CSSStyleName",
        seeAlso:[],
        defaultValue:"\"normal\"",
        groups:["appearance"],
        definingClass:"class:Canvas"
    },
    "attr:DataSource.resultSetClass":{
        ref:"attr:DataSource.resultSetClass",
        flags:"IRA",
        description:"Class for ResultSets used by this datasource.  If null, defaults to using\n ${isc.DocUtils.linkForRef('class:ResultSet')}.\n <P>\n This can be set to a custom subclass of ResultSet that, for example, hangs onto to extra\n information necessary for integration with web services.",
        name:"resultSetClass",
        seeAlso:[],
        valueType:"Class Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSource"
    },
    "object:CalendarEvent":{
        methods:[],
        ref:"object:CalendarEvent",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Optional Modules/Calendar"],
        attrs:["attr:CalendarEvent.startDate", "attr:CalendarEvent.endDate", "attr:CalendarEvent.name", 
         "attr:CalendarEvent.description","attr:CalendarEvent.canEdit", "attr:CalendarEvent.eventWindowStyle"],
        description:"An object which represents an event to occur at a specific time, displayed within the\n calendar.",
        name:"CalendarEvent",
        seeAlso:[],
        type:"object",
        groups:["data"]
    },
    "class:ColorItem":{
        methods:["method:ColorItem.pickerColorSelected"],
        exampleConfig:"ColorItem.xml",
        ref:"class:ColorItem",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Forms/Form Items"],
        attrs:["attr:ColorItem.showPickerIcon", "attr:ColorItem.pickerIconWidth", 
         "attr:ColorItem.pickerIconHeight","attr:ColorItem.pickerIconSrc", "attr:ColorItem.pickerIconProperties", 
         "attr:ColorItem.defaultPickerMode","attr:ColorItem.allowComplexMode", "attr:ColorItem.supportsTransparency"],
        description:"FormItem for selecting a color via a pop-up ColorPicker.",
        name:"ColorItem",
        seeAlso:[],
        type:"class"
    },
    "attr:DataSourceField.canEdit":{
        ref:"attr:DataSourceField.canEdit",
        flags:"IR",
        description:"Whether this field can ever be edited by the user.  If set to <code>false</code>, no\n DataBound component will ever try to offer an editing interface for this field.",
        name:"canEdit",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["componentBinding"]
    },
    "attr:ListGridField.target":{
        ref:"attr:ListGridField.target",
        flags:"IRW",
        description:"By default, clicking a link rendered by this item opens it in a new browser window.  You \n can alter this behavior by setting this property.  The value of this property will be \n passed as the value to the <code>target</code> attribute of the anchor tag used to render \n the link.\n <P>\n If you set listGridField.target to \"javascript\", the default behaviour is to catch and \n consume mouse-clicks that would result in the link being followed.  Instead, the\n ${isc.DocUtils.linkForRef('method:ListGrid.cellClick')} event is fired for the containing cell.",
        name:"target",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"_blank\"",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "classAttr:GroupingMessages.upcomingNextMonthTitle":{
        ref:"classAttr:GroupingMessages.upcomingNextMonthTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs next month,\n relative to the current date.",
        name:"upcomingNextMonthTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Next Month\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:["i18nMessages"]
    },
    "method:ValuesManager.editSelectedData":{
        ref:"method:ValuesManager.editSelectedData",
        flags:"",
        description:"\n Edit the record selected in the specified selection component (typically a\n ${isc.DocUtils.linkForRef('class:ListGrid')}).\n <P>\n Updates the values of this editor to match the selected record's values.\n <P>\n If this form has a dataSource, then saving via ${isc.DocUtils.linkForRef('method:ValuesManager.saveData')} will use the \n \"update\" operation type.\n\n",
        name:"editSelectedData",
        seeAlso:[
            {ref:"method:DynamicForm.saveData", description:null}
        ],
        params:[
            {description:"the ListGrid or ID of a ${isc.DocUtils.linkForRef('class:ListGrid')} whose currently selected\n     record(s) is/are to be edited",
             optional:false, name:"selectionComponent", defaultValue:null, type:"ListGrid or ID"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('updateOperation')}"],
        definingClass:"class:ValuesManager",
        groups:["dataBoundComponentMethods"]
    },
    "method:ListGrid.setFieldProperties":{
        ref:"method:ListGrid.setFieldProperties",
        flags:"",
        description:" Set properties for a particular field, such as the title.\n <P>\n NOTE: to resize a field, use resizeField() instead.\n\n",
        name:"setFieldProperties",
        seeAlso:[],
        params:[
            {description:"name of the field, or index.", optional:false, name:"fieldNum",
             defaultValue:null, type:"number or String"},
            {description:"properties to apply to the header", optional:false, name:"properties",
             defaultValue:null, type:"Button Properties"}
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Img.resetSrc":{
        ref:"method:Img.resetSrc",
        flags:"A",
        description:" Refresh the image being shown.  Call this when the ${isc.DocUtils.linkForRef('attr:Img.src')} attribute has not changed, but\n other state that affects the image URL (such as being selected) has changed.\n\n",
        name:"resetSrc",
        seeAlso:[],
        type:"method",
        definingClass:"class:Img",
        groups:["appearance"]
    },
    "attr:Calendar.showQuickEventDialog":{
        ref:"attr:Calendar.showQuickEventDialog",
        flags:"IR",
        description:"Determines whether the quick event dialog is displayed when a time is clicked. If this is\n false, the full event editor is displayed.",
        name:"showQuickEventDialog",
        seeAlso:[],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["editing"]
    },
    "method:Array.duplicate":{
        ref:"method:Array.duplicate",
        flags:"A",
        description:" Return an Array that is a shallow copy of the list, that is, containing the same items.\n\n",
        name:"duplicate",
        seeAlso:[],
        returns:{description:"new array, pointing to the same items", type:"Array"},
        type:"method",
        definingClass:"object:Array",
        groups:["access"]
    },
    "method:Canvas.containsFocus":{
        ref:"method:Canvas.containsFocus",
        flags:"",
        description:" Returns true if the keyboard focus is in this Canvas or any child of this Canvas.\n",
        name:"containsFocus",
        seeAlso:[],
        returns:{description:"whether this Canvas contains the keyboard focus", type:"boolean"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["focus"]
    },
    "attr:FormItem.name":{
        ref:"attr:FormItem.name",
        flags:"IRW",
        description:"Name for this form field.\n <br><br>\n The FormItem's name determines the name of the property it edits within the form.",
        name:"name",
        seeAlso:[],
        valueType:"identifier",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["basics"]
    },
    "attr:ImgButton.showTitle":{
        ref:"attr:ImgButton.showTitle",
        flags:"IRWA",
        description:"Determines whether any specified ${isc.DocUtils.linkForRef('method:StatefulCanvas.getTitle','title')} will be \n displayed for this component.<br>\n Applies to Image-based components only, where the title will be rendered out in a label\n floating over the component",
        name:"showTitle",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ImgButton"
    },
    "attr:TextItem.width":{
        ref:"attr:TextItem.width",
        flags:"IRW",
        description:"Default width for fields.",
        name:"width",
        seeAlso:[],
        valueType:"number",
        defaultValue:"150",
        type:"attr",
        definingClass:"class:TextItem",
        groups:["appearance"]
    },
    "method:ListGrid.setFieldState":{
        ref:"method:ListGrid.setFieldState",
        flags:"",
        description:" Sets some presentation properties (visibility, width, userFormula and userSummary) of the \n listGrid fields based on the ${isc.DocUtils.linkForRef('type:listGridFieldState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to ${isc.DocUtils.linkForRef('method:ListGrid.getFieldState')}.\n\n",
        name:"setFieldState",
        seeAlso:[
            {ref:"method:ListGrid.getFieldState", description:null}
        ],
        params:[
            {description:"state to apply to the listGrid's fields.", optional:false, name:"fieldState",
             defaultValue:null, type:"listGridFieldState"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["viewState"]
    },
    "method:Calendar.eventRemoved":{
        ref:"method:Calendar.eventRemoved",
        flags:"",
        description:" Notification fired whenever a user removes an event\n <P>\n In a calendar with a DataSource, eventRemoved() fires <b>after</b> the event has\n been successfully removed from the server\n\n",
        name:"eventRemoved",
        seeAlso:[],
        params:[
            {description:"the event that was removed", optional:false, name:"event", defaultValue:null,
             type:"CalendarEvent"}
        ],
        type:"method",
        definingClass:"class:Calendar",
        groups:["monthViewEvents"]
    },
    "attr:ListGridField.groupGranularity":{
        ref:"attr:ListGridField.groupGranularity",
        flags:"IR",
        description:"Granularity of grouping for numeric fields.\n <P>\n Groups will be formed based on ranges of values of size <code>groupGranularity</code>.  For\n example, if groupGranularity were 1000, groups would be 0-1000, 1000-2000, etc.",
        name:"groupGranularity",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["grouping"]
    },
    "classMethod:EventHandler.getY":{
        ref:"classMethod:EventHandler.getY",
        flags:"",
        description:"			Return the page-relative Y (vertical) coordinate of an event.\n\n",
        name:"getY",
        seeAlso:[],
        returns:{description:"y-coordinate in page coordinate space", type:"number"},
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:["mouseEvents"]
    },
    "method:MenuItem.click":{
        ref:"method:MenuItem.click",
        flags:"",
        description:" Executed when this menu item is clicked by the user. The click handler must be specified\n as a function or string of script.  Return false to suppress the ${isc.DocUtils.linkForRef('method:Menu.itemClick')}\n handler if specified.\n\n",
        name:"click",
        seeAlso:[],
        params:[
            {description:"for a menu shown as a context menu, the Canvas the menu was shown                        on.  Otherwise the ${isc.DocUtils.linkForRef('class:Menu')} instance of which this\n                        ${isc.DocUtils.linkForRef('object:MenuItem')} is a member.",
             optional:false, name:"target", defaultValue:null, type:"Canvas"},
            {description:"The ${isc.DocUtils.linkForRef('object:MenuItem')} that was clicked on.",
             optional:false, name:"item", defaultValue:null, type:"MenuItem"},
            {description:"The ${isc.DocUtils.linkForRef('class:Menu')} instance of which this ${isc.DocUtils.linkForRef('object:MenuItem')} is a                          member.",
             optional:false, name:"menu", defaultValue:null, type:"Menu"},
            {description:"Index of the column the user clicked. May be null if the                          user activated the menu via a keyboard event.",
             optional:true, name:"colNum", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"object:MenuItem",
        groups:["menuItemEvents"]
    },
    "classMethod:Time.setNormalDisplayFormat":{
        ref:"classMethod:Time.setNormalDisplayFormat",
        flags:"",
        description:" Sets the default format for strings returned by ${isc.DocUtils.linkForRef('classMethod:Time.toTime')}.\n",
        name:"setNormalDisplayFormat",
        seeAlso:[],
        params:[
            {description:"Optional custom formatter to use. Will accept  a function (which will be passed a pointer to the date to perform the conversion), or\n  a string designating a standard formatter",
             optional:false, name:"formatter", defaultValue:null, type:"timeFormatter|function"}
        ],
        type:"classMethod",
        definingClass:"class:Time"
    },
    "attr:TreeGrid.canDropOnLeaves":{
        ref:"attr:TreeGrid.canDropOnLeaves",
        flags:"IRWA",
        description:"Whether drops are allowed on leaf nodes.\n <P>\n Dropping is ordinarily not allowed on leaf nodes unless ${isc.DocUtils.linkForRef('attr:TreeGrid.canReorderRecords')} is\n set.  \n <P>\n The default action for a drop on a leaf node is to place the node in that leaf's parent\n folder.  This can be customized by overriding ${isc.DocUtils.linkForRef('method:TreeGrid.folderDrop')}.",
        name:"canDropOnLeaves",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TreeGrid"
    },
    "method:Canvas.getHSnapOrigin":{
        ref:"method:Canvas.getHSnapOrigin",
        flags:"",
        description:" Get an offset to be used when calculating snap positioning. Returns 0 by default.\n\n",
        name:"getHSnapOrigin",
        seeAlso:[
            {ref:"method:Canvas.getHSnapPosition", description:null}
        ],
        params:[
            {description:"the child that is being snapped", optional:true, name:"snapChild",
             defaultValue:null, type:"Canvas"}
        ],
        returns:{description:"The offset to use when snapping", type:"integer"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "method:StatefulCanvas.setIconOrientation":{
        ref:"method:StatefulCanvas.setIconOrientation",
        flags:"",
        description:" Changes the orientation of the icon relative to the text of the button.\n\n",
        name:"setIconOrientation",
        seeAlso:[],
        params:[
            {description:"The new orientation of the icon relative to the text of the button.",
             optional:false, name:"orientation", defaultValue:null, type:"\"left\" or \"right\""}
        ],
        type:"method",
        definingClass:"class:StatefulCanvas",
        groups:["buttonIcon"]
    },
    "method:SectionStack.reorderSection":{
        ref:"method:SectionStack.reorderSection",
        deprecated:"As of SmartClient version 5.5, use ${isc.DocUtils.linkForRef('method:SectionStack.moveSection')}.",
        flags:"",
        description:"\n Reorder the sections by shifting the specified section to a new position\n\n",
        name:"reorderSection",
        seeAlso:[],
        params:[
            {description:"Section to move.  You can pass the position                       of the section in the SectionStack or the ID of the section.",
             optional:false, name:"section", defaultValue:null, type:"position|sectionId"},
            {description:"new position index for the section.", optional:false, name:"position",
             defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:SectionStack"
    },
    "method:CubeGrid.getFacet":{
        ref:"method:CubeGrid.getFacet",
        flags:"",
        description:" Get a facet definition by facetId.  Constant time.\n\n",
        name:"getFacet",
        seeAlso:[
            {ref:"class:Facet", description:null}
        ],
        params:[
            {description:"the id of the facet to retrieve", optional:false, name:"facetId",
             defaultValue:null, type:"String"}
        ],
        returns:{description:"the Facet if found, or null", type:"Facet"},
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:SelectItem.showOptionsFromDataSource":{
        ref:"attr:SelectItem.showOptionsFromDataSource",
        flags:"IRWA",
        description:"If this item is part of a databound form, and has a specified <code>valueMap</code>\n by default we show the valueMap options in the pickList for the item.\n Setting this property to true will ensure that the options displayed in our pickList\n are derived from the form's <code>dataSource</code>.",
        name:"showOptionsFromDataSource",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:["databinding"]
    },
    "attr:Splitbar.target":{
        ref:"attr:Splitbar.target",
        flags:"R",
        description:"When a <code>Splitbar</code> is created by a layout, the <code>target</code> property\n of the Splitbar will be a pointer to the member for which it is acting as a resizeBar.\n The Splitbar will be positioned next to its target, and will resize it on drag completion.",
        name:"target",
        seeAlso:[],
        valueType:"Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Splitbar"
    },
    "attr:TileGrid.dataSource":{
        ref:"attr:TileGrid.dataSource",
        flags:"IRW",
        description:"The DataSource that this component should bind to for default fields and for performing\n ${isc.DocUtils.linkForRef('class:DSRequest','DataSource requests')}.\n <P>\n Can be specified as either a DataSource instance or the String ID of a DataSource.",
        name:"dataSource",
        seeAlso:[],
        valueType:"DataSource or ID",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dataSourceFields')}"],
        definingClass:"class:TileGrid",
        groups:["databinding"]
    },
    "attr:Canvas.edgeShowCenter":{
        ref:"attr:Canvas.edgeShowCenter",
        flags:"IR",
        description:"Whether to show media in the center section, that is, behind the decorated Canvas.",
        name:"edgeShowCenter",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('corners')}"],
        definingClass:"class:Canvas",
        groups:["imageEdges"]
    },
    "attr:Toolbar.canAcceptDrop":{
        ref:"attr:Toolbar.canAcceptDrop",
        flags:"IRWA",
        description:"If true, items (buttons) can be dropped into this toolbar, and the toolbar will\n show a drop line at the drop location.  Override drop() to decide what happens when the\n item is dropped.",
        name:"canAcceptDrop",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Toolbar",
        groups:["dragndrop"]
    },
    "attr:ListGrid.dragTrackerMode":{
        ref:"attr:ListGrid.dragTrackerMode",
        flags:"IRA",
        description:"When records are being dragged from within a ListGrid, what sort of drag-tracker\n should be displayed?<br>\n Note that if multiple records are being dragged the displayed tracker will be\n based on the first selected record.",
        name:"dragTrackerMode",
        seeAlso:[],
        valueType:"DragTrackerMode",
        defaultValue:"\"icon\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["dragTracker"]
    },
    "attr:ListGridField.canSort":{
        ref:"attr:ListGridField.canSort",
        flags:"IRW",
        description:"Enables or disables sorting by this column. If false, neither interactive\n  nor scripted (via the sort() method) instructions will sort the listGrid by this\n  column.",
        name:"canSort",
        seeAlso:[
            {ref:"method:ListGrid.sort", description:null},
            {ref:"attr:ListGrid.canSort", description:null}
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["sorting"]
    },
    "method:List.find":{
        ref:"method:List.find",
        flags:"",
        description:" Like ${isc.DocUtils.linkForRef('method:List.findIndex')}, but returns the object itself instead of its index.\n\n",
        name:"find",
        seeAlso:[],
        params:[
            {description:"property to match, or if an Object is passed, set of                                        properties and values to match",
             optional:false, name:"propertyName", defaultValue:null, type:"String or Object"},
            {description:"value to compare against (if propertyName is a string)", optional:true,
             name:"value", defaultValue:null, type:"any"}
        ],
        returns:{description:"first matching object or null if not found", type:"Object"},
        type:"method",
        definingClass:"interface:List",
        groups:["access", "find"]
    },
    "attr:TreeGrid.separateFolders":{
        ref:"attr:TreeGrid.separateFolders",
        flags:"IR",
        description:"Specifies whether folders and leaves should be segregated in the treeGrid display.\n          With separateFolders:true and sortDirection:\"descending\", folders are displayed\n          before their sibling leaves; with sortDirection:\"ascending\", leaves are displayed\n          before their sibling folders.",
        name:"separateFolders",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeField"]
    },
    "method:StretchImgButton.setBaseStyle":{
        ref:"method:StretchImgButton.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[],
        params:[
            {description:"new base style", optional:false, name:"style", defaultValue:null,
             type:"className"}
        ],
        type:"method",
        definingClass:"class:StretchImgButton"
    },
    "method:ColumnTree.setData":{
        ref:"method:ColumnTree.setData",
        flags:"",
        description:" Set the ${isc.DocUtils.linkForRef('class:Tree')} object this ColumnTree will view\n\n",
        name:"setData",
        seeAlso:[],
        params:[
            {description:"Tree to show", optional:false, name:"newData", defaultValue:null, type:"Tree"}
        ],
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:ComboBoxItem.valueField":{
        ref:"attr:ComboBoxItem.valueField",
        flags:"IRW",
        getter:["FormItem.getValueFieldName"],
        description:"If this form item maps data values to display values by retrieving the \n ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} values from an \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')}, this property \n denotes the the field to use as the underlying data value in records from the \n optionDataSource.<br>\n If unset, assumed to be the ${isc.DocUtils.linkForRef('attr:FormItem.name')} of this form item.",
        name:"valueField",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem",
        groups:["display_values"]
    },
    "attr:ListGrid.linkTextProperty":{
        ref:"attr:ListGrid.linkTextProperty",
        flags:"IRW",
        description:"Property name on a record that will hold the link text for that record.\n <br>\n This property is configurable to avoid possible collision with data values in the record.",
        name:"linkTextProperty",
        seeAlso:[
            {ref:"type:ListGridFieldType", description:null},
            {ref:"type:FieldType", description:null},
            {ref:"attr:ListGridField.linkText", description:null}
        ],
        valueType:"string",
        defaultValue:"\"linkText\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["display_values"]
    },
    "attr:Img.name":{
        ref:"attr:Img.name",
        flags:"IA",
        description:"The value of this attribute is specified as the value of the 'name' attribute in the\n resulting HTML.\n <p>\n Note: this attribute is ignored if the imageType is set to \"tile\"",
        name:"name",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"main\"",
        type:"attr",
        definingClass:"class:Img"
    },
    "attr:DynamicForm.cancelParamName":{
        ref:"attr:DynamicForm.cancelParamName",
        flags:"IRW",
        description:"The name of the special field sent to the server as part of ${isc.DocUtils.linkForRef('method:DynamicForm.cancel')}",
        name:"cancelParamName",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"org.apache.struts.taglib.html.CANCEL\"",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "method:ListGrid.getSortState":{
        ref:"method:ListGrid.getSortState",
        flags:"",
        description:" Returns a snapshot of the current sort state (sort field and order) within this listGrid as \n a ${isc.DocUtils.linkForRef('type:listGridSortState')} object.<br>\n This object can be passed to ${isc.DocUtils.linkForRef('method:ListGrid.setSortState')} to reset this grid's sort to\n the current state (assuming the same fields are present in the grid).<br>\n",
        name:"getSortState",
        seeAlso:[
            {ref:"method:ListGrid.setSortState", description:null}
        ],
        returns:{description:"current sort state for the grid.", type:"listGridSortState"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["viewState"]
    },
    "classMethod:isc.clone":{
        ref:"classMethod:isc.clone",
        flags:"",
        description:" Create a deep clone of an object that can be edited without affecting the original\n <br>\n All mutable types, including Objects, Arrays and Dates, are copied.  All immutable types are\n just preserved by reference.\n <br>\n Does not handle looping references (will infinite loop).\n\n",
        name:"clone",
        seeAlso:[],
        params:[
            {description:"object to clone", optional:false, name:"object", defaultValue:null,
             type:"object"}
        ],
        returns:{description:"cloned object", type:"object"},
        type:"classMethod",
        definingClass:"class:isc",
        groups:["serialization"]
    },
    "attr:Canvas.customEdges":{
        ref:"attr:Canvas.customEdges",
        flags:"IR",
        description:"Array of side names (\"T\", \"B\", \"L\", \"R\") specifying which sides of the decorated\n component should show edges.  For example: <pre>\n      customEdges : [\"T\", \"B\"]\n </pre>\n .. would show edges only on the top and bottom of a component.\n <P>\n The default of <code>null</code> means edges will be shown on all sides.",
        name:"customEdges",
        seeAlso:[],
        valueType:"Array of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["imageEdges"]
    },
    "classMethod:Class.getDefaultLogPriority":{
        ref:"classMethod:Class.getDefaultLogPriority",
        flags:"",
        description:" Retrieves the default priority of messages for this class or instance.\n",
        name:"getDefaultLogPriority",
        seeAlso:[],
        returns:{description:"default priority for logging messages on this object.", type:"LogPriority"},
        type:"classMethod",
        definingClass:"class:Class"
    },
    "attr:FilterBuilder.allowEmpty":{
        ref:"attr:FilterBuilder.allowEmpty",
        flags:"IR",
        description:"If set to false, the last clause cannot be removed.",
        name:"allowEmpty",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "class:DataSource":{
        methods:["method:DataSource.getLegalChildTags", "method:DataSource.transformRequest", 
         "method:DataSource.getUpdatedData","method:DataSource.getDataProtocol", "method:DataSource.processResponse", 
         "method:DataSource.getXMLRequestBody","method:DataSource.xmlSerialize", "method:DataSource.recordsFromXML", 
         "method:DataSource.transformResponse","method:DataSource.fetchRecord", "method:DataSource.fetchData", 
         "method:DataSource.filterData","method:DataSource.exportData", "method:DataSource.addData", 
         "method:DataSource.updateData","method:DataSource.removeData", "method:DataSource.downloadFile", 
         "method:DataSource.viewFile","method:DataSource.handleError", "method:DataSource.getField", 
         "method:DataSource.getFieldNames","method:DataSource.getPrimaryKeyField", "method:DataSource.getPrimaryKeyFieldName", 
         "method:DataSource.getAutoTitle","method:DataSource.getClientOnlyResponse", "method:DataSource.applyFilter", 
         "method:DataSource.fieldMatchesFilter","method:DataSource.supportsTextMatchStyle", "method:DataSource.compareCriteria", 
         "method:DataSource.convertCriteria","method:DataSource.combineCriteria", "method:DataSource.addSearchOperator", 
         "method:DataSource.getSearchOperator","method:DataSource.getTypeOperators", "method:DataSource.setTypeOperators", 
         "method:DataSource.getFieldOperators","method:DataSource.getFieldOperatorMap", "method:DataSource.getTypeOperatorMap", 
         "method:DataSource.evaluateCriterion"],
        ref:"class:DataSource",
        classAttrs:[],
        classMethods:["classMethod:DataSource.getDataSource", "classMethod:DataSource.get", 
         "classMethod:DataSource.addSearchOperator","classMethod:DataSource.setTypeOperators", "classMethod:DataSource.getAutoTitle"],
        treeLocation:["Client Reference/Data Binding"],
        attrs:["attr:DataSource.ID", "attr:DataSource.addGlobalId", "attr:DataSource.dataFormat", 
         "attr:DataSource.dataProtocol","attr:DataSource.callbackParam", "attr:DataSource.requestProperties", 
         "attr:DataSource.dataTransport","attr:DataSource.preventHTTPCaching", "attr:DataSource.serverType", 
         "attr:DataSource.tableName","attr:DataSource.dbName", "attr:DataSource.jsonPrefix", "attr:DataSource.jsonSuffix", 
         "attr:DataSource.fields","attr:DataSource.inheritsFrom", "attr:DataSource.useFlatFields", 
         "attr:DataSource.showLocalFieldsOnly","attr:DataSource.useParentFieldOrder", "attr:DataSource.dropExtraFields", 
         "attr:DataSource.sendExtraFields","attr:DataSource.autoDeriveSchema", "attr:DataSource.serviceNamespace", 
         "attr:DataSource.schemaNamespace","attr:DataSource.recordXPath", "attr:DataSource.dataURL", "attr:DataSource.tagName", 
         "attr:DataSource.clientOnly","attr:DataSource.testData", "attr:DataSource.criteriaPolicy", 
         "attr:DataSource.resultTreeClass","attr:DataSource.resultSetClass", "attr:DataSource.useLocalValidators", 
         "attr:DataSource.showPrompt","attr:DataSource.enumTranslateStrategy", "attr:DataSource.enumConstantProperty", 
         "attr:DataSource.enumOrdinalProperty","attr:DataSource.autoDeriveTitles", "attr:DataSource.title", "attr:DataSource.pluralTitle", 
         "attr:DataSource.titleField","attr:DataSource.iconField", "attr:DataSource.childrenField", 
         "attr:DataSource.serverConstructor","attr:DataSource.qualifyColumnNames", "attr:DataSource.globalNamespaces", 
         "attr:DataSource.resultBatchSize","attr:DataSource.serverObject", "attr:DataSource.operationBindings", 
         "attr:DataSource.strictSQLFiltering"],
        description:"A DataSource is data-provider-independant description of a set of objects\n that will be loaded, edited and saved within the user interface of your application.\n <P>\n Each DataSource consists of a list of ${isc.DocUtils.linkForRef('attr:DataSource.fields','fields')} that make up a\n DataSource <code>record</code>, along with ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field types')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.validators','validation rules')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','relationships')} to other DataSources, and other\n metadata.\n <P>\n The abstract object description provided by a DataSource is easily mapped to a variety of\n backend object models and storage schemes.  The following table shows analogous terminology\n across systems.\n <table border=1 class=\"normal\">\n <tr>\n   <td>Isomorphic SmartClient</td>\n   <td>Relational Database</td>\n   <td>Enterprise Java Beans (EJB)</td>\n   <td>Entity/Relationship Modelling</td>\n   <td>OO/UML</td>\n   <td>XML Schema/WSDL</td>\n   <td>LDAP</td>\n </tr><tr>\n   <td>DataSource</td>\n   <td>Table</td>\n   <td>EJB class</td>\n   <td>Entity</td>\n   <td>Class</td>\n   <td>Element Schema (ComplexType)</td>\n   <td>Objectclass</td>\n </tr><tr>\n   <td>Record</td>\n   <td>Row</td>\n   <td>EJB instance</td>\n   <td>Entity instance</td>\n   <td>Class instance/Object</td>\n   <td>Element instance (ComplexType)</td>\n   <td>Entry</td>\n </tr><tr>\n   <td>Field</td>\n   <td>Column</td>\n   <td>Property</td>\n   <td>Attribute</td>\n   <td>Property/Attribute</td>\n   <td>Attribute or Element (SimpleType)</td>\n   <td>Attribute</td>\n </tr></table>\n <P>\n DataSources can be ${isc.DocUtils.linkForRef('group:dataSourceDeclaration','declared')} in either JavaScript or XML\n format, and can also be ${isc.DocUtils.linkForRef('group:metadataImport','imported')} from existing metadata formats,\n including XML Schema.\n <P>\n <i>Data Binding</i> is the process by which\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','Data Binding-capable UI components')} can automatically configure\n themselves for viewing, editing and saving data described by DataSources.  DataBinding is\n covered in the ${isc.DocUtils.linkForDocNode('QuickStartGuide', 'QuickStart Guide')}, Chapter 6, <i>Data\n Binding</i>.\n <P>\n ${isc.DocUtils.linkForRef('group:clientServerIntegration','Data Integration')} is the process by which a DataSource\n can be connected to server systems such as SQL DataBases, Java Object models, WSDL web\n services and other data providers.  Data Integration comes in two variants: client-side and\n server-side.  ${isc.DocUtils.linkForRef('group:serverDataIntegration','Server-side integration')} uses the\n SmartClient Java-based server to connect to data represented by Java Objects or\n JDBC-accessible databases.  ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side integration')}\n connects SmartClient DataSources to XML, JSON or other formats accessible via HTTP.\n <P>\n DataSources have a concept of ${isc.DocUtils.linkForRef('group:dataSourceOperations','4 core operations')} (\"fetch\",\n \"add\", \"update\" and \"remove\") that can be performed on the set of objects represented by a\n DataSource.  Once a DataSource has been integrated with your data store, databinding-capable \n UI components can leverage the 4 core DataSource operations to provide many complete user\n interactions without the need to configure how each individual component loads and saves\n data.\n <P>\n These interactions include ${isc.DocUtils.linkForRef('class:ListGrid','grid views')}, ${isc.DocUtils.linkForRef('class:TreeGrid','tree views')}, \n ${isc.DocUtils.linkForRef('class:DetailViewer','detail views')}, ${isc.DocUtils.linkForRef('class:DynamicForm','form')}-based \n ${isc.DocUtils.linkForRef('method:DynamicForm.editRecord','editing')} and ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','saving')},\n grid-based ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','editing')} and ${isc.DocUtils.linkForRef('attr:ListGrid.saveByCell','saving')},\n and custom interactions provided by ${isc.DocUtils.linkForExampleId('patternReuse')} custom\n databinding-capable components.",
        name:"DataSource",
        seeAlso:[
            {ref:"interface:DataBoundComponent",
             description:"for information on DataBound Components"},
            {ref:"group:dataSourceDeclaration", description:"for how to create DataSources"}
        ],
        type:"class"
    },
    "attr:SummaryBuilder.helpIcon":{
        ref:"attr:SummaryBuilder.helpIcon",
        flags:"IRA",
        description:"Icon that appears after the ${isc.DocUtils.linkForRef('attr:SummaryBuilder.formulaField')}, showing help on hover.",
        name:"helpIcon",
        seeAlso:[],
        valueType:"AutoChild FormItemIcon",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:["summaryFields"]
    },
    "class:Operators":{
        methods:[],
        ref:"class:Operators",
        classAttrs:["classAttr:Operators.equalsTitle", "classAttr:Operators.notEqualTitle", 
         "classAttr:Operators.greaterThanTitle","classAttr:Operators.lessThanTitle", "classAttr:Operators.greaterOrEqualTitle", 
         "classAttr:Operators.lessOrEqualTitle","classAttr:Operators.betweenTitle", "classAttr:Operators.betweenInclusiveTitle", 
         "classAttr:Operators.iContainsTitle","classAttr:Operators.iStartsWithTitle", "classAttr:Operators.iEndsWithTitle", 
         "classAttr:Operators.containsTitle","classAttr:Operators.startsWithTitle", "classAttr:Operators.endsWithTitle", 
         "classAttr:Operators.iNotContainsTitle","classAttr:Operators.iNotStartsWithTitle", "classAttr:Operators.iNotEndsWithTitle", 
         "classAttr:Operators.notContainsTitle","classAttr:Operators.notStartsWithTitle", "classAttr:Operators.notEndsWithTitle", 
         "classAttr:Operators.isNullTitle","classAttr:Operators.notNullTitle", "classAttr:Operators.regexpTitle", 
         "classAttr:Operators.iregexpTitle","classAttr:Operators.inSetTitle", "classAttr:Operators.notInSetTitle", 
         "classAttr:Operators.equalsFieldTitle","classAttr:Operators.notEqualFieldTitle", "classAttr:Operators.andTitle", 
         "classAttr:Operators.notTitle","classAttr:Operators.orTitle"],
        classMethods:[],
        treeLocation:["Client Reference/Data Binding/DataSource"],
        attrs:[],
        description:"The Operators class provides a collection of class-level properties that can be used to\n modify the descriptions associated with the logical ${isc.DocUtils.linkForRef('object:Operator')}s used in \n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}. This is primarily intended for internationalization.\n <p>\n To add or override an operator's description, use\n Operators.${isc.DocUtils.linkForRef('classMethod:Class.addClassProperties','addClassProperties()')}.  For example:\n <p>\n <code>Operators.addClassProperties({lessOrEqualTitle: \"Less than or equal to\"});</code>",
        name:"Operators",
        seeAlso:[],
        type:"class"
    },
    "attr:Slider.maxValueLabel":{
        ref:"attr:Slider.maxValueLabel",
        flags:"IRW",
        description:"The text displayed in the label for the maximum value of the slider. If left as null, then\n slider.maxValue will be displayed.",
        name:"maxValueLabel",
        seeAlso:[
            {ref:"attr:Slider.showRange", description:null},
            {ref:"attr:Slider.maxValue", description:null}
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Slider"
    },
    "attr:ComboBoxItem.pickerIconHeight":{
        ref:"attr:ComboBoxItem.pickerIconHeight",
        flags:"IRW",
        description:"Don't specify an explicit height for the picker icon - instead have it size to match the\n height of the combo box item.",
        name:"pickerIconHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "type:Properties":{
        ref:"type:Properties",
        description:"When the type for a parameter mentions \"properties\" as in \"ListGrid Properties\" or\n \"RPCRequest Properties\", it means that the expected value is a JavaScript Object\n containing any set of properties generally legal when creating an object of that type.\n <P>\n For example, the first parameter of ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendRequest')} is of type\n \"RPCRequest Properties\".  This means it should be called like:\n <pre>\n    isc.RPCManager.sendRequest({\n        actionURL : \"/foo.do\",\n        showPrompt:false\n    });</pre>\n ${isc.DocUtils.linkForRef('attr:RPCRequest.actionURL','actionURL')} and ${isc.DocUtils.linkForRef('attr:RPCRequest.showPrompt','showPrompt')} are \n properties of ${isc.DocUtils.linkForRef('class:RPCRequest')}.  \n <P>\n Note that the notation shown above is an example of a\n ${isc.DocUtils.linkForRef('type:ObjectLiteral','JavaScript object literal')}.",
        name:"Properties",
        seeAlso:[],
        type:"type"
    },
    "group:buttons":{
        ref:"group:buttons",
        refs:["method:Window.closeClick", "method:Dialog.saveData", "method:Dialog.closeClick", 
         "method:Dialog.cancelClick","method:Dialog.okClick", "method:Dialog.applyClick", "method:Dialog.yesClick", 
         "method:Dialog.noClick","method:Dialog.doneClick", "method:Toolbar.getButton"],
        name:"buttons",
        seeAlso:[],
        type:"group"
    },
    "classMethod:Log.getCallTrace":{
        ref:"classMethod:Log.getCallTrace",
        flags:"",
        description:" Returns a one-line summary of the current method call, showing method name and passed\n arguments. \n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.getCallTrace()\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n\n",
        name:"getCallTrace",
        seeAlso:[],
        params:[
            {description:"arguments object from the call to trace.  On IE, defaults to the                             calling function's arguments",
             optional:true, name:"args", defaultValue:null, type:"Arguments"}
        ],
        type:"classMethod",
        platformNotes:"IE only.",
        definingClass:"class:Log",
        groups:["debug"]
    },
    "method:Canvas.setTop":{
        ref:"method:Canvas.setTop",
        flags:"",
        description:" Set the top coordinate of this object, relative to its enclosing context, in pixels.\n <P>\n NOTE: if you're setting multiple coordinates, use setRect() or moveTo() instead\n\n",
        name:"setTop",
        seeAlso:[],
        params:[
            {description:"new top coordinate", optional:false, name:"top", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "class:SubmitItem":{
        methods:[],
        ref:"class:SubmitItem",
        classAttrs:[],
        classMethods:[],
        attrs:["attr:SubmitItem.title"],
        description:"Button that saves the data in the form, by calling ${isc.DocUtils.linkForRef('method:DynamicForm.submit')} when clicked.\n ${isc.DocUtils.linkForRef('method:DynamicForm.submit')} for details on how to control what happens when a form is\n submitted.",
        name:"SubmitItem",
        seeAlso:[
            {ref:"group:operations", description:null}
        ],
        type:"class"
    },
    "method:DataBoundComponent.disableHilite":{
        ref:"method:DataBoundComponent.disableHilite",
        flags:"",
        description:" Disable a hilite\n\n",
        name:"disableHilite",
        seeAlso:[],
        params:[
            {description:"ID of hilite to disable", optional:false, name:"hiliteID", defaultValue:null,
             type:"string"}
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["hiliting"]
    },
    "attr:Layout.vertical":{
        ref:"attr:Layout.vertical",
        flags:"IRW",
        description:"Should this layout appear with members stacked vertically or horizontally. Defaults to \n <code>false</code> if unspecified.",
        name:"vertical",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        groups:["layoutPolicy"]
    },
    "attr:FormulaBuilder.editMode":{
        ref:"attr:FormulaBuilder.editMode",
        flags:"IR",
        description:"Are we editing an existing field?",
        name:"editMode",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["formulaFields"]
    },
    "method:StretchImgButton.setDisabled":{
        ref:"method:StretchImgButton.setDisabled",
        flags:"",
        description:" Enable or disable this object\n",
        name:"setDisabled",
        seeAlso:[],
        params:[
            {description:"true if this widget is to be disabled", optional:false, name:"disabled",
             defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:StretchImgButton",
        groups:["enable", "state"]
    },
    "method:DataBoundComponent.transferSelectedData":{
        ref:"method:DataBoundComponent.transferSelectedData",
        flags:"",
        description:" Simulates a drag / drop type transfer of the selected records in some other component to this\n component, without requiring any user interaction.  This method acts on the dropped records \n exactly as if they had been dropped in an actual drag / drop interaction, including any \n special databound behavior invoked by calling\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.getDropValues','getDropValues')} for each dropped record.\n <P>\n To transfer <b>all</b> data in, for example, a ${isc.DocUtils.linkForRef('class:ListGrid')}, call grid.selection.selectAll() first.\n <P>\n See the ${isc.DocUtils.linkForRef('group:dragging')} documentation for an overview of list grid drag/drop data\n transfer.\n \n",
        name:"transferSelectedData",
        seeAlso:[],
        params:[
            {description:"source component from which the records will be tranferred", optional:false,
             name:"source", defaultValue:null, type:"DataBoundComponent"},
            {description:"target index (drop position) of the rows within this grid.", optional:true,
             name:"index", defaultValue:null, type:"integer"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('dragListMove')}"],
        definingClass:"interface:DataBoundComponent",
        groups:["dragging"]
    },
    "method:Canvas.drop":{
        ref:"method:Canvas.drop",
        flags:"A",
        description:"\n Executed when the mouse button is released over a compatible drop target at the end of\n a drag sequence. Your widget should implement whatever it wants to do when receiving a\n drop here. For example, in a file moving interface, a drop might mean that you should\n move or copy the dragged file into the folder it was dropped on, or dropping something in\n a trash can might mean to clear it from the screen.\n\n",
        name:"drop",
        seeAlso:[
            {ref:"method:Canvas.getOffsetX", description:null},
            {ref:"method:Canvas.getOffsetY", description:null},
            {ref:"classMethod:EventHandler.getDragTarget", description:null}
        ],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('dragCreate')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:ResultSet.findAll":{
        ref:"method:ResultSet.findAll",
        flags:"",
        description:" Like ${isc.DocUtils.linkForRef('method:List.findAll')}.  Checks only loaded rows and will not trigger a fetch.\n",
        name:"findAll",
        seeAlso:[],
        params:[
            {description:"property to match, or if an Object is passed, set of                                        properties and values to match",
             optional:false, name:"propertyName", defaultValue:null, type:"String or Object"},
            {description:"value to compare against (if propertyName is a string)", optional:true,
             name:"value", defaultValue:null, type:"any"}
        ],
        returns:{description:"all matching Objects or null if none found", type:"Array"},
        type:"method",
        definingClass:"class:ResultSet",
        groups:["access", "find"]
    },
    "classMethod:SchemaSet.get":{
        ref:"classMethod:SchemaSet.get",
        flags:"A",
        description:" Retrieve a SchemaSet object by it's schemaNamespace.\n\n",
        name:"get",
        seeAlso:[],
        params:[
            {description:"uri from the \"targetNamespace\" attribute of the &lt;xsd:schema&gt; element from the XML Schema or WSDL file this SchemaSet was derived\n from.",
             optional:false, name:"schemaNamespace", defaultValue:null, type:"String"}
        ],
        returns:{description:"the requested SchemaSet, or null if not loaded", type:"SchemaSet"},
        type:"classMethod",
        definingClass:"class:SchemaSet"
    },
    "classMethod:Log.setDefaultLogPriority":{
        ref:"classMethod:Log.setDefaultLogPriority",
        flags:"",
        description:" Set the default priority of logging for messages logged on this Class or Instance object.\n All categories for which there is no explicit, instance level logging priority set will\n log at this level on this object.<br>  \n To set the default visible log priority across the entire page, use\n <code>isc.Log.setDefaultPriority()</code> instead.\n",
        name:"setDefaultLogPriority",
        seeAlso:[
            {ref:"classMethod:Log.setPriority", description:null}
        ],
        params:[
            {description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
             optional:false, name:"category", defaultValue:null, type:"string"},
            {description:"priority level", optional:false, name:"priority", defaultValue:null,
             type:"LogPriority"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:StretchImg.hSrc":{
        ref:"attr:StretchImg.hSrc",
        flags:"IRW",
        description:"Base URL for the image if ${isc.DocUtils.linkForRef('attr:StretchImg.vertical')} is false and \n ${isc.DocUtils.linkForRef('attr:StretchImg.src')} is unset.",
        name:"hSrc",
        seeAlso:[
            {ref:"attr:StretchImg.src", description:null},
            {ref:"attr:StretchImg.vSrc", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImg",
        groups:["appearance"]
    },
    "method:GridRenderer.cellOver":{
        ref:"method:GridRenderer.cellOver",
        flags:"A",
        description:" Called when the mouse pointer enters a cell\n\n",
        name:"cellOver",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "attr:Flashlet.params":{
        ref:"attr:Flashlet.params",
        flags:"IR",
        description:"A map of key/value pairs to pass to the flashlet as parameters.  Note that these will be set\n  on the outer &lt;object&gt; element as well as the inner &lt;embed&gt; element.",
        name:"params",
        seeAlso:[],
        valueType:"object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Flashlet"
    },
    "method:ComboBoxItem.getDisplayFieldName":{
        ref:"method:ComboBoxItem.getDisplayFieldName",
        flags:"A",
        description:" Returns the ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} for this form item.\n If unset, and ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')} is explicitly specified, this method\n will return the title field for the <code>optionDataSource</code>\n",
        name:"getDisplayFieldName",
        seeAlso:[],
        returns:{description:"display field name, or null", type:"String"},
        type:"method",
        definingClass:"class:ComboBoxItem"
    },
    "attr:Calendar.datePickerButton":{
        ref:"attr:Calendar.datePickerButton",
        flags:"IR",
        description:"The datePickerIcon is an ImgButton that appears above the week/day/month views of the\n calendar and offers alternative access to a ${isc.DocUtils.linkForRef('class:DateChooser')} to pick the current day.",
        name:"datePickerButton",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "attr:Calendar.showDayHeaders":{
        ref:"attr:Calendar.showDayHeaders",
        flags:"IR",
        description:"If false, the month view does not show day headers",
        name:"showDayHeaders",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["visibility"]
    },
    "method:CubeGrid.clearEditValue":{
        ref:"method:CubeGrid.clearEditValue",
        flags:"A",
        description:"\n  Clear a field value being tracked as an unsaved user edit for some cell.<P>\n  The saved record value will be displayed in the the appropriate cell instead.\n\n",
        name:"clearEditValue",
        seeAlso:[],
        params:[
            {description:"Row number, primary keys object for the record,                                              or editValues object",
             optional:false, name:"editValuesID", defaultValue:null, type:"number | object"},
            {description:"Column number for the cell in question. Only required if the                              first parameter is a row number.",
             optional:true, name:"colNum", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["editing"]
    },
    "attr:Menu.submenuDisabledImage":{
        ref:"attr:Menu.submenuDisabledImage",
        flags:"IRWA",
        description:"Default image to use for the submenu indicator when item is disabled. Valid src, width and\n height must be specified. See ${isc.DocUtils.linkForRef('object:ImgProperties')} for format.<br>\n If ${isc.DocUtils.linkForRef('attr:Menu.submenuDirection')} is set to <code>\"left\"</code>, the image src will have\n the suffix <code>\"_left\"</code> appended to it.",
        name:"submenuDisabledImage",
        seeAlso:[],
        valueType:"ImgProperties",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:Menu"
    },
    "group:fields":{
        ref:"group:fields",
        refs:["attr:DataSource.fields", "attr:DataSource.inheritsFrom", "attr:DataSource.useFlatFields", 
         "attr:DataSource.showLocalFieldsOnly","attr:DataSource.useParentFieldOrder", "attr:DataSource.autoDeriveSchema"],
        name:"fields",
        seeAlso:[],
        type:"group"
    },
    "method:Toolbar.getButton":{
        ref:"method:Toolbar.getButton",
        flags:"",
        description:"          Retrieves a button widget instance (within this toolbar) from the ID / index / \n          descriptor object for the button (as with the getButtonNumber() method)\n          This provides a way to access a toolbar button's properties and methods directly.\n",
        name:"getButton",
        seeAlso:[
            {ref:"method:Toolbar.getButtonNumber", description:null}
        ],
        params:[
            {description:"identifier for the button to retrieve", optional:false, name:"index",
             defaultValue:null, type:"number | string | object"}
        ],
        returns:{description:"the button, or null if the button wasn't found", type:"Button"},
        type:"method",
        definingClass:"class:Toolbar",
        groups:["buttons"]
    },
    "method:CubeGrid.facetHasSelection":{
        ref:"method:CubeGrid.facetHasSelection",
        flags:"",
        description:"\n return whether any facet value for this facet is selected in headers.  If no facetId passed,\n return whether any facet has a selection\n\n  <br><i>methodType</i> tester\n",
        name:"facetHasSelection",
        seeAlso:[],
        params:[
            {description:"Id for facet to test", optional:false, name:"facetId", defaultValue:null,
             type:"string"}
        ],
        returns:{description:"true if any facet value in this header is selected", type:"boolean"},
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "attr:ImgButton.iconOrientation":{
        ref:"attr:ImgButton.iconOrientation",
        flags:"IR",
        description:"If this button is showing an icon should it appear to the left or right of the title?\n valid options are <code>\"left\"</code> and <code>\"right\"</code>.",
        name:"iconOrientation",
        setter:["setIconOrientation"],
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"left\"",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["buttonIcon"]
    },
    "method:ListGrid.setViewState":{
        ref:"method:ListGrid.setViewState",
        flags:"",
        description:" Reset this grid's view state to match the ${isc.DocUtils.linkForRef('type:listGridViewState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to \n ${isc.DocUtils.linkForRef('method:ListGrid.getViewState')}.\n\n",
        name:"setViewState",
        seeAlso:[
            {ref:"method:ListGrid.getViewState", description:null}
        ],
        params:[
            {description:"Object describing the desired view state for the grid", optional:false,
             name:"viewState", defaultValue:null, type:"listGridViewState"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["viewState"]
    },
    "attr:ListGridField.valueIconOrientation":{
        ref:"attr:ListGridField.valueIconOrientation",
        flags:"IRW",
        description:"If we're showing a valueIcon for this field should it appear to the left or the right\n of the text?  By default the icon will appear to the left of the textual value - \n set this to \"right\" to show the icon on the right of the text.\n Has no effect if ${isc.DocUtils.linkForRef('attr:ListGridField.showValueIconOnly')} is true",
        name:"valueIconOrientation",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "method:Canvas.isEnabled":{
        ref:"method:Canvas.isEnabled",
        deprecated:"As of SmartClient version 5.5 deprecated in favor of ${isc.DocUtils.linkForRef('method:Canvas.isDisabled')}.",
        flags:"",
        description:" Returns true if the widget and all widgets above it in the containment hierarchy are enabled.\n Returns false otherwise.\n",
        name:"isEnabled",
        seeAlso:[],
        returns:{description:"true if the widget and all widgets above it in the containment hierarchy                      are enabled; false otherwise",
         type:"boolean"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["enable"]
    },
    "classAttr:RPCManager.timeoutErrorMessage":{
        ref:"classAttr:RPCManager.timeoutErrorMessage",
        flags:"IRW",
        description:"Default message displayed to user when an opration fails to return from the server within\n the timeout period specified by ${isc.DocUtils.linkForRef('classAttr:RPCManager.defaultTimeout')}.",
        name:"timeoutErrorMessage",
        seeAlso:[
            {ref:"classAttr:RPCManager.defaultTimeout", description:null}
        ],
        valueType:"string",
        defaultValue:"\"Operation timed out\"",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:["i18nMessages"]
    },
    "attr:Canvas.backgroundColor":{
        ref:"attr:Canvas.backgroundColor",
        flags:"IRW",
        description:"The background color for this widget. It corresponds to the CSS background-color\n attribute. You can set this property to an RGB value (e.g. #22AAFF) or a named color\n (e.g. red) from a list of browser supported color names.",
        name:"backgroundColor",
        setter:["setBackgroundColor"],
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["appearance"]
    },
    "attr:SectionHeader.controlsLayout":{
        ref:"attr:SectionHeader.controlsLayout",
        flags:"IR",
        description:"A ${isc.DocUtils.linkForRef('class:Layout')} containing specified ${isc.DocUtils.linkForRef('attr:SectionHeader.controls')} if any.  Sets\n ${isc.DocUtils.linkForRef('attr:Layout.membersMargin')}:5, ${isc.DocUtils.linkForRef('attr:Layout.defaultLayoutAlign')}:\"center\", and\n RTL-sensitive ${isc.DocUtils.linkForRef('attr:Layout.align')} (right by default).",
        name:"controlsLayout",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SectionHeader"
    },
    "attr:ListGridField.valueMap":{
        ref:"attr:ListGridField.valueMap",
        flags:"IRW",
        description:"Array of legal values for this field, or an Object where each property maps a stored\n value to a user-displayable value.<br>\n Note that if this field is editable (see ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit')}, \n ${isc.DocUtils.linkForRef('attr:ListGridField.canEdit')}), editors displayed for this field will pick up their\n valueMap either from this value or from ${isc.DocUtils.linkForRef('attr:ListGridField.editorValueMap')}.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:DataSourceField.valueMap')}.",
        name:"valueMap",
        seeAlso:[
            {ref:"method:ListGrid.setValueMap", description:null}
        ],
        valueType:"Array of Object",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('listType')}"],
        definingClass:"object:ListGridField",
        groups:["display_values"]
    },
    "attr:SelectItem.addUnknownValues":{
        ref:"attr:SelectItem.addUnknownValues",
        flags:"IRWA",
        description:"If we're setting the value of a select item and the value isn't a legal value in the\n valueMap, whether we should allow the value (creating a new option for it) or reject it.\n <P>\n Exception: If the value is set to <code>null</code> but there is no null entry in the\n valueMap for this item, setting <code>addUnknownValues</code> to true will not cause\n a null option to show up at the top of the select item pickList. Whether an empty \n option is shown in the pickList is governed by ${isc.DocUtils.linkForRef('attr:SelectItem.allowEmptyValue')}\n instead.",
        name:"addUnknownValues",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('formDependentSelects')}"],
        definingClass:"class:SelectItem"
    },
    "group:event handling":{
        ref:"group:event handling",
        refs:["method:StatefulCanvas.getActionType", "method:StatefulCanvas.setActionType", 
         "method:StatefulCanvas.addToRadioGroup","method:StatefulCanvas.removeFromRadioGroup", "method:Button.addToRadioGroup", 
         "method:Button.removeFromRadioGroup","method:Button.setActionType", "method:Button.getActionType", "method:Toolbar.itemClick", 
         "method:ImgButton.addToRadioGroup","method:ImgButton.removeFromRadioGroup", "method:ImgButton.setActionType", 
         "method:ImgButton.getActionType","method:StretchImgButton.addToRadioGroup", "method:StretchImgButton.removeFromRadioGroup", 
         "method:StretchImgButton.setActionType","method:StretchImgButton.getActionType", "method:TreeGrid.willAcceptDrop", 
         "attr:StatefulCanvas.actionType","attr:StatefulCanvas.radioGroup", "attr:Button.radioGroup", "attr:Button.actionType", 
         "attr:ImgButton.radioGroup","attr:ImgButton.actionType", "attr:StretchImgButton.radioGroup", 
         "attr:StretchImgButton.actionType","type:SelectionType"],
        name:"event handling",
        seeAlso:[],
        type:"group"
    },
    "attr:DataBoundComponent.addSummaryFieldText":{
        ref:"attr:DataBoundComponent.addSummaryFieldText",
        flags:"IRW",
        description:"Text for a menu item allowing users to add a formula field",
        name:"addSummaryFieldText",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"Add summary column...\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["i18nMessages"]
    },
    "class:Splitbar":{
        methods:[],
        ref:"class:Splitbar",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Layout"],
        attrs:["attr:Splitbar.target", "attr:Splitbar.vertical", "attr:Splitbar.src", 
         "attr:Splitbar.hSrc","attr:Splitbar.vSrc", "attr:Splitbar.capSize", "attr:Splitbar.skinImgDir", 
         "attr:Splitbar.showGrip","attr:Splitbar.gripImgSuffix", "attr:Splitbar.showDownGrip", 
         "attr:Splitbar.showRollOverGrip","attr:Splitbar.showClosedGrip", "attr:Splitbar.canDrag", "attr:Splitbar.canCollapse", 
         "attr:Splitbar.cursor","attr:Splitbar.vResizeCursor", "attr:Splitbar.hResizeCursor"],
        description:"Subclass of the ${isc.DocUtils.linkForRef('class:StretchImg')} class. As with the ${isc.DocUtils.linkForRef('class:ImgSplitbar')} class, \n  widgets of this class can be displayed as a resize-bar for widgets \n  in Layouts where showResizeBar is set to true. Provides a different appearance from\n  the <code>ImgSplitbar</code> class.<br>\n  To specify the resizeBar class for some layout, use the ${isc.DocUtils.linkForRef('attr:Layout.resizeBarClass')}\n  property.",
        name:"Splitbar",
        seeAlso:[
            {ref:"class:Layout", description:null},
            {ref:"class:ImgSplitbar", description:null}
        ],
        type:"class"
    },
    "method:CubeGrid.getCellFacetValues":{
        ref:"method:CubeGrid.getCellFacetValues",
        flags:"",
        description:" Given a cell coordinate within this CubeGrid return a ${isc.DocUtils.linkForRef('type:FacetValueMap','FacetValueMap')}\n indicating the facet values for the cell.\n",
        name:"getCellFacetValues",
        seeAlso:[],
        params:[
            {description:"row index of the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"row index of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"facet values for the specified cell. Returns null if the specified cell    is not present in the grid.",
         type:"FacetValueMap"},
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:BlurbItem.wrap":{
        ref:"attr:BlurbItem.wrap",
        flags:"IRW",
        description:"If true, item contents can wrap. If false, all the contents should appear on a single line.",
        name:"wrap",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:BlurbItem",
        groups:["appearance"]
    },
    "method:Button.setState":{
        ref:"method:Button.setState",
        flags:"",
        description:" Set the 'state' of this object, this changes it's appearance.\n\n",
        name:"setState",
        seeAlso:[
            {ref:"method:Button.setDisabled", description:"which also affects state values."}
        ],
        params:[
            {description:"new state", optional:false, name:"newState", defaultValue:null, type:"State"}
        ],
        type:"method",
        definingClass:"class:Button",
        groups:["state", "appearance"]
    },
    "attr:DataSourceField.sequenceName":{
        ref:"attr:DataSourceField.sequenceName",
        flags:"IR",
        description:"For a DataSource with ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType:\"sql\"')} with a field of type\n \"sequence\", the name of the SQL sequence that should be used when inserting new records into\n this table.\n <P>\n Note that this is never required for SQL tables that are generated from SmartClient\n DataSources (a default sequence name of tableName + \"_\" + columnName is chosen), and is \n never required for databases where inserting null into a sequence column is sufficient\n (MySQL, SQL Server, DB2 and others).  \n <P>\n You would only need to set sequenceName if you are integrating with a pre-existing table\n stored in a database where the sequence must be named for insertion to work (Oracle,\n Postgres) OR you are trying to use the same sequence across multiple DataSources.",
        name:"sequenceName",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["sqlDataSource"]
    },
    "method:ImgButton.getTitle":{
        ref:"method:ImgButton.getTitle",
        flags:"A",
        description:" Return the title - text/HTML drawn inside the component.\n <p>\n Default is to simply return this.title.\n",
        name:"getTitle",
        seeAlso:[],
        returns:{description:"HTML for the title", type:"string"},
        type:"method",
        definingClass:"class:ImgButton"
    },
    "classMethod:EventHandler.getX":{
        ref:"classMethod:EventHandler.getX",
        flags:"",
        description:"			Return the page-relative X (horizontal) coordinate of an event.\n\n",
        name:"getX",
        seeAlso:[],
        returns:{description:"x-coordinate in page coordinate space", type:"number"},
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:["mouseEvents"]
    },
    "attr:Label.icon":{
        ref:"attr:Label.icon",
        flags:"IRW",
        description:"Optional icon to be shown with the button title text.  \n <P>\n Specify as the partial URL to an image, relative to the imgDir of this component.",
        name:"icon",
        setter:["setIcon"],
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Label",
        groups:["buttonIcon"]
    },
    "method:Canvas.getPageRight":{
        ref:"method:Canvas.getPageRight",
        flags:"",
        description:" Return the page-relative right coordinate of this object, in pixels.\n		\n",
        name:"getPageRight",
        seeAlso:[],
        returns:{description:"GLOBAL right coordinate", type:"number"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "attr:Canvas.top":{
        flags:"IRW",
        getter:["getTop"],
        type:"attr",
        ref:"attr:Canvas.top",
        description:"Number of pixels the top of the widget is offset down from its default drawing context\n (either its parent's top-left corner, or the document flow, depending on the value of\n the ${isc.DocUtils.linkForRef('attr:Canvas.position')} property).",
        name:"top",
        setter:["setTop"],
        valueType:"number",
        seeAlso:[],
        defaultValue:"0",
        groups:["positioning"],
        definingClass:"class:Canvas"
    },
    "method:ImgButton.setTitle":{
        ref:"method:ImgButton.setTitle",
        flags:"",
        description:" Set the title.\n",
        name:"setTitle",
        seeAlso:[],
        params:[
            {description:"new title", optional:false, name:"newTitle", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:ImgButton",
        groups:["appearance"]
    },
    "classMethod:Log.logInfo":{
        ref:"classMethod:Log.logInfo",
        flags:"",
        description:" Log a message at \"info\" priority\n \n",
        name:"logInfo",
        seeAlso:[
            {ref:"classMethod:Log.logDebug", description:"for usage info"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "method:TreeGrid.nodeClick":{
        ref:"method:TreeGrid.nodeClick",
        flags:"",
        description:"\n This method is called when a leaf or folder record is clicked on.  Note that if you set\n up a callback for <code>nodeClick()</code> and e.g. ${isc.DocUtils.linkForRef('method:TreeGrid.leafClick')}, then\n both will fire (in that order) if a leaf is clicked on.\n\n",
        name:"nodeClick",
        seeAlso:[
            {ref:"method:TreeGrid.folderClick", description:null},
            {ref:"method:TreeGrid.leafClick", description:null}
        ],
        params:[
            {description:"The TreeGrid on which leafClick() occurred.", optional:false, name:"viewer",
             defaultValue:null, type:"TreeGrid"},
            {description:"The node (record) that was clicked", optional:false, name:"node",
             defaultValue:null, type:"TreeNode"},
            {description:"Index of the row where the click occurred.", optional:false,
             name:"recordNum", defaultValue:null, type:"number"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('treeDropEvents')}"],
        definingClass:"class:TreeGrid"
    },
    "method:ImgButton.getActionType":{
        ref:"method:ImgButton.getActionType",
        flags:"",
        description:" Return the 'actionType' for this canvas (radio / checkbox / button)\n",
        name:"getActionType",
        seeAlso:[],
        type:"method",
        definingClass:"class:ImgButton",
        groups:["state", "event handling"]
    },
    "attr:SectionStackSection.ID":{
        ref:"attr:SectionStackSection.ID",
        flags:"IR",
        description:"Optional ID for the section.  This can be used later in calls to ${isc.DocUtils.linkForRef('class:SectionStack')} APIs such as\n ${isc.DocUtils.linkForRef('method:SectionStack.expandSection')} and ${isc.DocUtils.linkForRef('method:SectionStack.collapseSection')}.",
        name:"ID",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:SectionStackSection"
    },
    "method:ColorPicker.getLuminosity":{
        ref:"method:ColorPicker.getLuminosity",
        flags:"",
        description:" Returns the Luminosity (brightness) of the currently-selected color, as an \n integer from 0-240\n",
        name:"getLuminosity",
        seeAlso:[
            {ref:"method:ColorPicker.setLuminosity", description:null}
        ],
        returns:{description:"luminosity value", type:"int"},
        type:"method",
        definingClass:"class:ColorPicker"
    },
    "method:DynamicForm.getItem":{
        ref:"method:DynamicForm.getItem",
        flags:"",
        description:" Retrieve a ${isc.DocUtils.linkForRef('class:FormItem')} in this form by it's ${isc.DocUtils.linkForRef('attr:FormItem.name','name')} or index within\n the ${isc.DocUtils.linkForRef('attr:DynamicForm.items','items')} array.\n <P>\n FormItems that also have a ${isc.DocUtils.linkForRef('attr:FormItem.ID')} may be accessed directly as a global variable\n <code>window[itemID]</code> or just <code>itemID</code>\n\n",
        name:"getItem",
        seeAlso:[
            {ref:"method:DynamicForm.getItem", description:null}
        ],
        params:[
            {description:"name of the item you're looking for", optional:false, name:"itemName",
             defaultValue:null, type:"string or int"}
        ],
        returns:{description:"FormItem object or null if not found", type:"FormItem"},
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["items"]
    },
    "group:clientServerIntegration":{
        ref:"group:clientServerIntegration",
        title:"Client-Server Integration",
        treeLocation:["Concepts"],
        refs:[],
        description:"Like client-server desktop applications, SmartClient browser-based applications interact\n with remote data and services via background communication channels. Background requests\n retrieve chunks of data rather than new HTML pages, and update your visual components in\n place rather than rebuilding the entire user interface.\n <P>\n SmartClient supports two general classes of client-server operations:\n ${isc.DocUtils.linkForRef('class:DSRequest','DSRequests')} (DataSource Requests) and ${isc.DocUtils.linkForRef('class:RPCRequest')}s (Remote Procedure\n Call Requests).  DataSource requests are for manipulating structured data described by\n ${isc.DocUtils.linkForRef('class:DataSource','DataSources')}.  RPCRequests are a low-level, very flexible mechanism for\n custom client-server communications.  In an nutshell, RPCRequests:\n <ul>\n <li> may contain arbitrary data\n <li> are always initiated by custom code (a call to ${isc.DocUtils.linkForRef('classMethod:RPCManager.send')}), and have\n their responses handled by custom code (the callback passed to <code>send()</code>)\n </ul>\n <P>\n DSRequests:\n <ul>\n <li> contain data that follows the ${isc.DocUtils.linkForRef('group:dataSourceOperations','DataSource protocol')},\n which reflect the 4 basic operations on stored records: fetch, update, create, remove.\n <li> are initiated by ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} in response to user\n actions, and have their responses automatically managed (for example, \n ${isc.DocUtils.linkForRef('class:ResultSet','cache management')} and \n ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','validation error handling')}).  DSRequests can also be\n initiated manually and have their responses handled with custom code.\n </ul>\n See the ${isc.DocUtils.linkForRef('class:RPCManager')} documentation for further information on RPCRequests - the\n remainder of this document focuses on integrating DataSource operations with your server.\n <P>\n <b>DataSource Creation</b>\n <p>\n First you must create ${isc.DocUtils.linkForRef('class:DataSource','DataSources')} that describe the objects from\n your object model that will be loaded or manipulated within your application.  All of ISC's\n most powerful functionality builds on the concept of a DataSource, and because of ISC's \n databinding framework (see ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}), it's as easy to create a\n DataSource that can configure an unlimited number of components as it is to configure a\n single component.\n <P>\n There are a number of options for creating DataSources; for early prototyping, creating a\n DataSource by hand in either JavaScript or XML is simplest (this is covered under \n ${isc.DocUtils.linkForRef('group:dataSourceDeclaration','DataSource declaration')}).  Later on, you can pursue one of\n many ${isc.DocUtils.linkForRef('group:metadataImport','metadata import')} strategies for automatically leveraging\n your existing metadata.\n <p>\n Once you have a DataSource, you can bind a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} such as a \n ${isc.DocUtils.linkForRef('class:ListGrid')} to it, call one of the \n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')} on it, such as\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')}, the ListGrid will send a background HTTP request to the\n server asking for data.  You can set the log category \"RPCManager\" to DEBUG threshold to see\n the outbound request and the server's response.\n <P>\n In this case, the ListGrid is sending a DataSource operation request of type \"fetch\".  To\n fulfill it, you will need to provide a set of matching records in one of many possible\n formats.\n <P>\n At this point your code is just a handful of lines (this example shows a DataSource created\n in JavaScript):\n <pre>\n     DataSource.create({\n         ID:\"employees\",\n         fields:[ \n             ... \n         ]\n     });\n     ListGrid.create({\n         ID:\"myGrid\",\n         dataSource:\"employees\"\n     });\n     myGrid.fetchData();\n </pre>\n If you now bind a ${isc.DocUtils.linkForRef('class:DynamicForm')} to your DataSource, you can use the \n ${isc.DocUtils.linkForRef('method:DynamicForm.editSelectedData')} and ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')}\n methods to cause the client to submit \"update\" operations.  For both \"update\" and \"add\"\n operations, the DSRequest object you receive will have inbound data that is expected to be\n committed to your data model.  \n <P>\n <b>Data Integration</b>\n <P>\n There are two main approaches to integrating DataSources with your server technology:\n <ul>\n <li> ${isc.DocUtils.linkForRef('group:serverDataIntegration','Server-side integration')}: DataSource requests from\n the browser arrive as Java Objects on the server.  You deliver responses to the browser by\n returning Java Objects.\n <li> ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side integration')}: DataSource requests arrive\n as simple HTTP requests which your server code receives directly (in Java, you use the\n Servlet API or .jsps to handle the requests).  Responses are sent as XML or JSON which you\n directly generate.  \n </ul>\n Note that using WSDL-described web services is also considered a client-side integration\n approach, although in this case it is typical to use extensive third-party web service\n libraries such as <a href='http://ws.apache.org/axis/' onclick=\"window.open('http://ws.apache.org/axis/');return false;\">Apache Axis</a> to provide Java\n bindings.\n <P>\n The possible approaches are summarized in the diagram below.  Paths 2, 3, and 4 are\n client-side integration approaches, and path 1 includes all server-side integration\n approaches.\n <P>\n <img src=\"${isc.DocViewer.instance.referenceRoot}skin/ds_bindings.png\" width=763 height=475>\n <P>\n All of these integration options can be used in parallel within the same application.  For\n example, an application that typically talks to a Java backend may contact Yahoo's\n JSON-based search services to get related search results, or integrate with SalesForce\n applications via the AppForce WSDL-described web service.\n <P>\n If you cannot install the SmartClient Server or must integrate with a pre-existing web\n service, then you must pursue ${isc.DocUtils.linkForRef('group:clientDataIntegration','client-side integration')}.\n Otherwise there are several factors to consider:\n\n <ul>\n\n <li> With an existing Java backend, the fastest integration approach is\n ${isc.DocUtils.linkForRef('group:serverDataIntegration','server-side integration')} using \n ${isc.DocUtils.linkForRef('class:DMI','Direct Method Invocation (DMI)')}.  Given \n a Java method that returns a Collection of POJOs, a short XML declaration will achieve\n data loading.</li>\n\n <li> If you are building an \n <a href='http://www.google.com/search?q=SOA+architecture' onclick=\"window.open('http://www.google.com/search?q=SOA+architecture');return false;\">SOA Architecture</a>, and some of\n the services that your SmartClient application needs to contact could be shared with other\n kinds of clients, consider the WSDL- or XML-based\n ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-Side Integration')}.</li>\n\n <li> The SmartClient server accelerates Java integration and provides various useful\n facilities, including the broadest possible browser support, server-push, and network\n performance enhancements.  See the ${isc.DocUtils.linkForRef('group:iscServer','SmartClient Server Summary')} for\n details.</li>\n\n </ul>",
        name:"clientServerIntegration",
        seeAlso:[],
        type:"group"
    },
    "attr:Canvas.peers":{
        ref:"attr:Canvas.peers",
        flags:"IRWA",
        description:"Array of all Canvii that are peers of this Canvas.",
        name:"peers",
        seeAlso:[],
        valueType:"Array of Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["containment"]
    },
    "method:TabSet.addTabs":{
        ref:"method:TabSet.addTabs",
        flags:"A",
        description:" Add one or more tabs\n",
        name:"addTabs",
        seeAlso:[
            {ref:"method:TabSet.addTab", description:null}
        ],
        params:[
            {description:"new tab or tabs", optional:false, name:"tabs", defaultValue:null,
             type:"Tab or Array of Tab"},
            {description:"position where tab should be added (or array of positions)", optional:false,
             name:"position", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "attr:DateChooser.prevMonthIcon":{
        ref:"attr:DateChooser.prevMonthIcon",
        flags:"IR",
        description:"Icon for the previous month button",
        name:"prevMonthIcon",
        seeAlso:[],
        valueType:"URL",
        defaultValue:"\"[SKIN]arrow_left.gif\"",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:ResultSet.lengthIsKnown":{
        ref:"method:ResultSet.lengthIsKnown",
        flags:"",
        description:" Whether the ResultSet actually knows how many records are available from the server.\n The ResultSet will not know how many records are available when initially fetching and \n filtering data. Note that the value returned from ${isc.DocUtils.linkForRef('method:ResultSet.getLength')} will be \n an arbitrary, large value if the actual length is not known.\n",
        name:"lengthIsKnown",
        seeAlso:[],
        returns:{description:"whether length is known", type:"boolean"},
        type:"method",
        definingClass:"class:ResultSet"
    },
    "group:EventRegistry":{
        ref:"group:EventRegistry",
        refs:["classMethod:Page.setEvent", "classMethod:Page.clearEvent", "type:FireStyle"],
        name:"EventRegistry",
        seeAlso:[],
        type:"group"
    },
    "class:ToolbarItem":{
        methods:[],
        exampleConfig:"ToolbarItem.xml",
        ref:"class:ToolbarItem",
        classAttrs:[],
        classMethods:[],
        attrs:["attr:ToolbarItem.buttons", "attr:ToolbarItem.showTitle", "attr:ToolbarItem.startRow", 
         "attr:ToolbarItem.endRow","attr:ToolbarItem.colSpan", "attr:ToolbarItem.vertical", 
         "attr:ToolbarItem.buttonConstructor","attr:ToolbarItem.buttonProperties", "attr:ToolbarItem.buttonBaseStyle"],
        description:"Set of horizontally arranged buttons.",
        name:"ToolbarItem",
        seeAlso:[],
        type:"class"
    },
    "attr:CubeGrid.autoSelectValues":{
        ref:"attr:CubeGrid.autoSelectValues",
        flags:"IR",
        description:"Whether to select cells in the body when row or column headers are selected.<br><br>\n Legal values: \"both\", \"rows\", \"cols\", \"none\" (or false)",
        name:"autoSelectValues",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"both\"",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "attr:Layout.membersMargin":{
        ref:"attr:Layout.membersMargin",
        flags:"IRW",
        description:"Space between each member of the layout.\n <P>\n Requires a manual call to <code>reflow()</code> if changed on the fly.",
        name:"membersMargin",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"0",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('userSizing')}"],
        definingClass:"class:Layout",
        groups:["layoutMargin"]
    },
    "method:Canvas.moveAbove":{
        ref:"method:Canvas.moveAbove",
        flags:"",
        description:" Puts this widget just above the specified widget in the stacking order, so it appears in\n front of the specified widget if both widgets have the same parent.\n",
        name:"moveAbove",
        seeAlso:[],
        params:[
            {description:"canvas to move above", optional:false, name:"canvas", defaultValue:null,
             type:"Canvas or subclass"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('layer')}"],
        definingClass:"class:Canvas",
        groups:["zIndex"]
    },
    "attr:Window.dismissOnOutsideClick":{
        ref:"attr:Window.dismissOnOutsideClick",
        flags:"IRW",
        description:"If true, a click outside the bounds of the Window will have the same effect as\n      pressing its cancel button.<br>\n      <b>Note:</b> Applies only to modal windows.",
        name:"dismissOnOutsideClick",
        seeAlso:[
            {ref:"attr:Window.isModal", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Window",
        groups:["modal"]
    },
    "attr:Canvas.animateResizeAcceleration":{
        ref:"attr:Canvas.animateResizeAcceleration",
        flags:"IRWA",
        description:"Default acceleration function for performing an animated resize.  If unset, \n <code>this.animateAcceleration</code> will be used by default instead",
        name:"animateResizeAcceleration",
        seeAlso:[],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "method:CellSelection.deselectCell":{
        ref:"method:CellSelection.deselectCell",
        flags:"",
        description:"			Deselect a particular cell\n",
        name:"deselectCell",
        seeAlso:[],
        params:[
            {description:"row index of the cell to select", optional:false, name:"rowNum",
             defaultValue:null, type:"number"},
            {description:"column index of the cell to select", optional:false, name:"colNum",
             defaultValue:null, type:"number"}
        ],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:CellSelection",
        groups:["selection"]
    },
    "attr:SelectItem.valueField":{
        flags:"IRW",
        getter:["FormItem.getValueFieldName"],
        type:"attr",
        ref:"attr:SelectItem.valueField",
        description:"If this form item maps data values to display values by retrieving the \n ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} values from an \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')}, this property \n denotes the the field to use as the underlying data value in records from the \n optionDataSource.<br>\n If unset, assumed to be the ${isc.DocUtils.linkForRef('attr:FormItem.name')} of this form item.",
        name:"valueField",
        valueType:"string",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('relatedRecords')}"],
        defaultValue:"null",
        groups:["display_values"],
        definingClass:"class:SelectItem"
    },
    "method:FormItem.setValueMap":{
        ref:"method:FormItem.setValueMap",
        flags:"A",
        description:" Set the valueMap for this item.\n",
        name:"setValueMap",
        seeAlso:[
            {ref:"attr:FormItem.valueMap", description:null}
        ],
        params:[
            {description:"new valueMap", optional:false, name:"valueMap", defaultValue:null,
             type:"Array or Object"}
        ],
        type:"method",
        definingClass:"class:FormItem",
        groups:["valueMap"]
    },
    "attr:Layout.animateMembers":{
        ref:"attr:Layout.animateMembers",
        flags:"IRW",
        description:"If true when members are added / removed, they should be animated as they are shown\n or hidden in position",
        name:"animateMembers",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('animateLayout')}"],
        definingClass:"class:Layout",
        groups:["animation"]
    },
    "class:Page":{
        methods:[],
        ref:"class:Page",
        classAttrs:["classAttr:Page.defaultUnsupportedBrowserURL", "classAttr:Page.unsupportedBrowserAction"],
        classMethods:["classMethod:Page.isLoaded", "classMethod:Page.setTitle", "classMethod:Page.getAppDir", 
         "classMethod:Page.setAppImgDir","classMethod:Page.getAppImgDir", "classMethod:Page.setAppFilesDir", 
         "classMethod:Page.getAppFilesDir","classMethod:Page.setIsomorphicDir", "classMethod:Page.getIsomorphicDir", 
         "classMethod:Page.setSkinDir","classMethod:Page.getSkinDir", "classMethod:Page.getSkinImgDir", 
         "classMethod:Page.getImgURL","classMethod:Page.getURL", "classMethod:Page.isRTL", "classMethod:Page.loadStyleSheet", 
         "classMethod:Page.resizeTo","classMethod:Page.moveTo", "classMethod:Page.scrollTo", "classMethod:Page.getWidth", 
         "classMethod:Page.getHeight","classMethod:Page.getScrollWidth", "classMethod:Page.getScrollHeight", 
         "classMethod:Page.getScrollLeft","classMethod:Page.getScrollTop", "classMethod:Page.getScreenWidth", 
         "classMethod:Page.getScreenHeight","classMethod:Page.goBack", "classMethod:Page.waitFor", "classMethod:Page.waitForMultiple", 
         "classMethod:Page.checkBrowserAndRedirect","classMethod:Page.getUnsupportedBrowserPromptString", "classMethod:Page.setEvent", 
         "classMethod:Page.clearEvent","classMethod:Page.registerKey", "classMethod:Page.unregisterKey"],
        treeLocation:["Client Reference/System"],
        attrs:[],
        description:"Provides information about the page you're loaded in.  We define \"page\" here to be roughly\n 	equivalent to the browser window or frame the libraries have been loaded in.",
        name:"Page",
        seeAlso:[],
        type:"class"
    },
    "attr:StatefulCanvas.autoFit":{
        ref:"attr:StatefulCanvas.autoFit",
        flags:"IRW",
        description:"If true, ignore the specified size of this widget and always size just large\n enough to accomodate the title.  If <code>setWidth()</code> is explicitly called on an\n autoFit:true button, autoFit will be reset to <code>false</code>.\n <P>\n Note that for StretchImgButton instances, autoFit will occur horizontally only, as \n unpredictable vertical sizing is likely to distort the media. If you do want vertical \n auto-fit, this can be achieved by simply setting a small height, and having \n overflow:\"visible\"",
        name:"autoFit",
        setter:["setAutoFit"],
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:["sizing"]
    },
    "attr:HiddenItem.showTitle":{
        ref:"attr:HiddenItem.showTitle",
        flags:"IRW",
        description:"we never show a separate title cell for hidden fields",
        name:"showTitle",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:HiddenItem",
        groups:["appearance"]
    },
    "attr:ImgButton.iconSpacing":{
        ref:"attr:ImgButton.iconSpacing",
        flags:"IRW",
        description:"Optional icon to be shown with the button title text.  \n <P>\n Specify as the partial URL to an image, relative to the imgDir of this component.",
        name:"iconSpacing",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["buttonIcon"]
    },
    "method:Canvas.setHtmlPosition":{
        ref:"method:Canvas.setHtmlPosition",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:Canvas.htmlPosition')}.\n",
        name:"setHtmlPosition",
        seeAlso:[],
        params:[
            {description:"New htmlPosition for this canvas", optional:false, name:"element",
             defaultValue:null, type:"DrawPosition"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["htmlElement"]
    },
    "attr:TreeGrid.treeFieldTitle":{
        ref:"attr:TreeGrid.treeFieldTitle",
        flags:"IR",
        description:"Visible title for the tree column (field).",
        name:"treeFieldTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Name\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:["treeField"]
    },
    "method:ImgButton.setBaseStyle":{
        ref:"method:ImgButton.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[],
        params:[
            {description:"new base style", optional:false, name:"style", defaultValue:null,
             type:"className"}
        ],
        type:"method",
        definingClass:"class:ImgButton"
    },
    "attr:OperationBinding.serverMethod":{
        ref:"attr:OperationBinding.serverMethod",
        flags:"IR",
        description:"The name of the method to invoke on the ${isc.DocUtils.linkForRef('class:ServerObject')} for this operationBinding.",
        name:"serverMethod",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding",
        requiresModules:["SCServer"]
    },
    "attr:ListGrid.groupTree":{
        ref:"attr:ListGrid.groupTree",
        flags:"R",
        description:"The data tree that results from a call to  ${isc.DocUtils.linkForRef('method:ListGrid.groupBy')}.\n This will be a ${isc.DocUtils.linkForRef('class:ResultTree')} if ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')} is\n present, otherwise it will be a ${isc.DocUtils.linkForRef('class:Tree')}.",
        name:"groupTree",
        seeAlso:[
            {ref:"method:ListGrid.groupBy", description:null}
        ],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["grouping"]
    },
    "class:JSONEncoder":{
        methods:["method:JSONEncoder.encode", "method:JSONEncoder.encodeDate"],
        ref:"class:JSONEncoder",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Data Binding"],
        attrs:["attr:JSONEncoder.dateFormat", "attr:JSONEncoder.strictQuoting", 
         "attr:JSONEncoder.circularReferenceMode","attr:JSONEncoder.circularReferenceMarker", "attr:JSONEncoder.prettyPrint"],
        description:"Class for encoding objects as JSON strings.",
        name:"JSONEncoder",
        seeAlso:[],
        type:"class"
    },
    "classAttr:RPCManager.saveDataPrompt":{
        ref:"classAttr:RPCManager.saveDataPrompt",
        flags:"IRW",
        description:"Default prompt displayed to the user while an opreration is running to save data to\n the server.<br>\n Displayed as a result of the ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} code path.",
        name:"saveDataPrompt",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Saving form...\"",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:["i18nMessages"]
    },
    "attr:Scrollbar.showTrackEnds":{
        ref:"attr:Scrollbar.showTrackEnds",
        flags:"IRA",
        description:"If true, the scrollbar uses a 5-segment rather than 3-segment image representation,\n where the 3 interior image segments have the same state (Down, Over, etc), independent\n of the two outermost image segments.  \n <P>\n This allows certain advanced skinning designs where the track-as-such (space in which\n the thumb may be dragged) has curved endcaps, and is also visually stateful (that is,\n changes when the mouse goes down, without affecting the appearance of the outermost\n segments).",
        name:"showTrackEnds",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:["track"]
    },
    "attr:SelectItem.showFocused":{
        ref:"attr:SelectItem.showFocused",
        flags:"IRWA",
        description:"When this item recieves focus, should it be re-styled to indicate it has focus?",
        name:"showFocused",
        seeAlso:[
            {ref:"attr:FormItem.cellStyle", description:null}
        ],
        valueType:"boolean",
        defaultValue:"true, [IRWA]",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:["appearance"]
    },
    "method:ListGrid.reorderFields":{
        ref:"method:ListGrid.reorderFields",
        flags:"A",
        description:" Reorder a set of adjacent fields, from start to end exclusive at the end, by distance\n moveDelta.<br><br>\n\n NOTE: start and end coordinates are in terms of the currently visible fields, not the full set of\n fields.\n\n",
        name:"reorderFields",
        seeAlso:[],
        params:[
            {description:"Start of the range of fields to move, inclusive", optional:false,
             name:"start", defaultValue:null, type:"number"},
            {description:"End of the range of fields to move, non-inclusive", optional:false,
             name:"end", defaultValue:null, type:"number"},
            {description:"Distance to move by", optional:false, name:"moveDelta", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:TreeGrid.animateFolders":{
        ref:"attr:TreeGrid.animateFolders",
        flags:"IRW",
        description:"If true, when folders are opened / closed children will be animated into view.",
        name:"animateFolders",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('animateTree')}"],
        definingClass:"class:TreeGrid",
        groups:["animation"]
    },
    "attr:ListGridRecord.singleCellValue":{
        ref:"attr:ListGridRecord.singleCellValue",
        flags:"IRW",
        description:"Default property name denoting the single value to display for all fields of this row.\n If this property is set for some record, the record will be displayed as a single \n cell spanning every column in the grid, with contents set to the value of this\n property.<br>\n Note: this attribute name is governed by ${isc.DocUtils.linkForRef('attr:ListGrid.singleCellValueProperty')}.",
        name:"singleCellValue",
        seeAlso:[],
        valueType:"HTML",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord"
    },
    "classAttr:Time.shortDisplayFormat":{
        ref:"classAttr:Time.shortDisplayFormat",
        flags:"RWA",
        description:"Standard formatter to be used when converting a date to a time-string via ${isc.DocUtils.linkForRef('classMethod:Time.toShortTime')}",
        name:"shortDisplayFormat",
        setter:["setShortDisplayFormat"],
        seeAlso:[],
        valueType:"timeFormatter|function",
        defaultValue:"\"toShortTime\"",
        type:"classAttr",
        definingClass:"class:Time"
    },
    "method:TabSet.getTabObject":{
        ref:"method:TabSet.getTabObject",
        flags:"",
        description:" Get the tab Object originally passed to ${isc.DocUtils.linkForRef('attr:TabSet.tabs')}, by index or ID.\n If passed a tab Object, just returns it.\n\n",
        name:"getTabObject",
        seeAlso:[],
        params:[
            {description:null, optional:false, name:"tab", defaultValue:null, type:"int | ID | Tab"}
        ],
        returns:{description:"the tab, or null if not found", type:"Tab"},
        type:"method",
        definingClass:"class:TabSet"
    },
    "method:Calendar.getActiveDay":{
        ref:"method:Calendar.getActiveDay",
        flags:"",
        description:" Gets the day of the week (0-6) that the mouse is currently over.\n\n",
        name:"getActiveDay",
        seeAlso:[
            {ref:"method:Calendar.getActiveTime", description:null}
        ],
        returns:{description:"the day that the mouse is currently over", type:"integer"},
        type:"method",
        definingClass:"class:Calendar"
    },
    "attr:DSResponse.clientContext":{
        ref:"attr:DSResponse.clientContext",
        flags:"R",
        description:"The ${isc.DocUtils.linkForRef('attr:DSRequest.clientContext')} object as set on the ${isc.DocUtils.linkForRef('class:DSRequest')}.",
        name:"clientContext",
        seeAlso:[
            {ref:"attr:DSRequest.clientContext", description:null},
            {ref:"attr:RPCResponse.clientContext", description:null}
        ],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSResponse"
    },
    "attr:RPCRequest.omitNullMapValuesInResponse":{
        ref:"attr:RPCRequest.omitNullMapValuesInResponse",
        flags:"IRWA",
        description:"If enabled, the server omits any key/value pairs in map that have null values from the\n response.  This can reduce the size of the response when many fields have null values.\n <p>\n To enable this globally for all responses you can set RPCManager.omitNullMapValuesInResponse\n in server.properties.",
        name:"omitNullMapValuesInResponse",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "method:ListGridField.formatEditorValue":{
        ref:"method:ListGridField.formatEditorValue",
        flags:"",
        description:" Return the value to display in cells of this field which are being edited.\n <P>\n <i>Example usage</i>: converting a stored value in cents (100) to a dollar-and-cents \n value in the editor (1.00)\n <P>\n The value passed to this method is the raw value for the cell.\n <P>\n <code>formatEditorValue</code> takes precedence over ${isc.DocUtils.linkForRef('method:ListGrid.formatEditorValue')}\n defined at the grid level for cells in this field.\n <P>\n To convert the formatted value displayed within an editor back to a raw value, implement\n ${isc.DocUtils.linkForRef('method:ListGridField.parseEditorValue')} as well.\n\n",
        name:"formatEditorValue",
        seeAlso:[
            {ref:"method:ListGridField.formatCellValue", description:null},
            {ref:"method:ListGrid.formatEditorValue", description:null},
            {ref:"method:ListGridField.parseEditorValue", description:null}
        ],
        params:[
            {description:"raw value for the cell being edited", optional:false, name:"value",
             defaultValue:null, type:"any"},
            {description:"Record object for the cell. Note: If this is a new row that has not been saved, in an \n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter.",
             optional:false, name:"record", defaultValue:null, type:"ListGridRecord"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number for the cell.", optional:false, name:"colNum",
             defaultValue:null, type:"number"},
            {description:"A pointer to the ListGrid displaying the cell", optional:false, name:"grid",
             defaultValue:null, type:"ListGrid instance"}
        ],
        returns:{description:"formatted value to display in the editor", type:"any"},
        type:"method",
        definingClass:"object:ListGridField",
        groups:["editing"]
    },
    "method:CubeGrid.facetLabelOver":{
        ref:"method:CubeGrid.facetLabelOver",
        flags:"",
        description:" StringMethod handler fired when mouseover occurs over a facet label\n\n\n",
        name:"facetLabelOver",
        seeAlso:[],
        params:[
            {description:"ID of the appropriate facet", optional:false, name:"facetId",
             defaultValue:null, type:"object"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["events"]
    },
    "attr:Label.iconSize":{
        ref:"attr:Label.iconSize",
        flags:"IR",
        description:"Size in pixels of the icon image.\n <P>\n The <code>iconWidth</code> and <code>iconHeight</code> properties can be used to\n configure width and height separately.",
        name:"iconSize",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:Label",
        groups:["buttonIcon"]
    },
    "attr:DetailViewerField.valueMap":{
        ref:"attr:DetailViewerField.valueMap",
        flags:"IR",
        description:"A property list (or an expression that evaluates to a property list)\n specifying a mapping of internal values to display values for the field (row).",
        name:"valueMap",
        seeAlso:[],
        valueType:"object",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField"
    },
    "attr:FacetValue.canCollapse":{
        ref:"attr:FacetValue.canCollapse",
        flags:"IR",
        description:"For individual parent facetValues within a hierarchical facet, this flag controls\n whether an expand/collapse control will be shown.",
        name:"canCollapse",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "method:DataBoundComponent.getDropValues":{
        ref:"method:DataBoundComponent.getDropValues",
        flags:"",
        description:" Returns the \"drop values\" to apply to a record dropped on this component prior to update.  Only\n applicable to databound components - see ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dropValues')} for more details.  If multiple records \n are being dropped, this method is called for each of them in turn.\n <P>\n This method returns the following:\n <UL>\n <LI>Nothing, if ${isc.DocUtils.linkForRef('attr:DataBoundComponent.addDropValues')} is false</LI>\n <LI>dropValues, if that property is set.  If the component's criteria object is applicable (as explained\n in the next item), it is merged into dropValues, with properties in dropValues taking precedence.</LI>\n <LI>The component's criteria object, if the most recent textMatchStyle for the component was \"exact\" \n     and it is simple criteria (ie, not an AdvancedCriteria object)</LI>\n <LI>Otherwise nothing</LI>\n </UL>\n <P>\n You can override this method if you need more complex setting of drop values than can be \n provided by simply supplying a dropValues object.\n \n",
        name:"getDropValues",
        seeAlso:[],
        params:[
            {description:"record being dropped", optional:false, name:"record", defaultValue:null,
             type:"Record"},
            {description:"dataSource the record being dropped is bound to", optional:false,
             name:"sourceDS", defaultValue:null, type:"DataSource"},
            {description:"record being dropped on", optional:false, name:"targetRecord",
             defaultValue:null, type:"Record"},
            {description:"index of record being dropped on", optional:false, name:"index",
             defaultValue:null, type:"int"},
            {description:"widget where dragging began", optional:false, name:"sourceWidget",
             defaultValue:null, type:"Canvas"}
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent"
    },
    "method:CubeGrid.deselectCell":{
        ref:"method:CubeGrid.deselectCell",
        flags:"",
        description:"\n  deselect a single cell - accepts cell ID or cell record.\n\n      <br><i>methodType</i> action\n",
        name:"deselectCell",
        seeAlso:[],
        params:[
            {description:"cell to deselect", optional:false, name:"cell", defaultValue:null,
             type:"ID | object"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "attr:ViewLoader.viewURL":{
        ref:"attr:ViewLoader.viewURL",
        flags:"IR",
        description:"URL to load components from.",
        name:"viewURL",
        setter:["setViewURL"],
        seeAlso:[],
        valueType:"URL",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('viewLoading')}"],
        definingClass:"class:ViewLoader"
    },
    "method:DataSource.updateData":{
        ref:"method:DataSource.updateData",
        flags:"",
        description:" Perform an \"update\" DataSource operation against this DataSource, to update values in an\n existing DataSource record.\n\n",
        name:"updateData",
        seeAlso:[],
        params:[
            {description:"updated record", optional:false, name:"updatedRecord", defaultValue:null,
             type:"Record Properties"},
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on                                                       the DSRequest that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest Properties"}
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:["operations"]
    },
    "method:Canvas.moveBelow":{
        ref:"method:Canvas.moveBelow",
        flags:"",
        description:" Puts this widget just below the specified widget in the stacking order, so it appears\n behind the specified widget if both widgets have the same parent.\n",
        name:"moveBelow",
        seeAlso:[],
        params:[
            {description:"canvas to move below", optional:false, name:"canvas", defaultValue:null,
             type:"Canvas or subclass"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('layer')}"],
        definingClass:"class:Canvas",
        groups:["zIndex"]
    },
    "method:Menu.getItemNum":{
        ref:"method:Menu.getItemNum",
        flags:"",
        description:" Given a MenuItem, return it's index in the items array.\n\n",
        name:"getItemNum",
        seeAlso:[],
        params:[
            {description:"index of the item or MenuItem itself", optional:false, name:"item",
             defaultValue:null, type:"MenuItem | int"}
        ],
        returns:{description:"index of the item, or -1 if not defined.", type:"int"},
        type:"method",
        definingClass:"class:Menu",
        groups:["menuItems"]
    },
    "attr:Applet.altHTML":{
        ref:"attr:Applet.altHTML",
        flags:"IR",
        description:"This text is displayed if the browser does not understand the tag used for the applet html\n  element.",
        name:"altHTML",
        seeAlso:[
            {ref:"attr:Applet.alt", description:null},
            {ref:"attr:Applet.useTag", description:null}
        ],
        valueType:"HTML",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Applet"
    },
    "attr:ListGrid.discardEditsSaveButtonTitle":{
        ref:"attr:ListGrid.discardEditsSaveButtonTitle",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.confirmDiscardEdits')} is true this is the title for the save button\n appearing in the lost edits confirmation dialog. Override this for localization if necessary.",
        name:"discardEditsSaveButtonTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Save\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["editing", "i18nMessages"]
    },
    "attr:ViewLoader.viewURLParams":{
        ref:"attr:ViewLoader.viewURLParams",
        flags:"IR",
        description:"Parameters to be sent to the viewURL when fetching the view.",
        name:"viewURLParams",
        seeAlso:[],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ViewLoader"
    },
    "classMethod:Log.traceMethod":{
        ref:"classMethod:Log.traceMethod",
        flags:"",
        description:"\n  Observe a method on an object, logging a stack trace whenever the method is called.\n  <P>\n  Call a second time with identical arguments to disable tracing.\n\n",
        name:"traceMethod",
        seeAlso:[],
        params:[
            {description:"object to observe", optional:false, name:"object", defaultValue:null,
             type:"object"},
            {description:"name of the method to observe", optional:false, name:"methodName",
             defaultValue:null, type:"string"}
        ],
        type:"classMethod",
        definingClass:"class:Log",
        groups:["debug"]
    },
    "attr:Canvas.showEdges":{
        ref:"attr:Canvas.showEdges",
        flags:"IR",
        description:"Whether an ${isc.DocUtils.linkForRef('class:EdgedCanvas')} should be used to show image-based edges around this\n component.",
        name:"showEdges",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('edges')}"],
        definingClass:"class:Canvas",
        groups:["imageEdges"]
    },
    "method:DynamicForm.submit":{
        ref:"method:DynamicForm.submit",
        flags:"",
        description:" <code>submit()</code> is automatically called when a ${isc.DocUtils.linkForRef('class:SubmitItem')} included in the\n form is clicked, or, if ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOnEnter','saveOnEnter')} is set, when the\n \"Enter\" key is pressed in a text input.  Submit can also be manually called.\n <P>\n If ${isc.DocUtils.linkForRef('method:DynamicForm.submitValues','form.submitValues()')} exists, it will be called, then\n immediately return.\n <P>\n Otherwise, default behavior varies based on ${isc.DocUtils.linkForRef('attr:DynamicForm.canSubmit','form.canSubmit')}: if\n <code>canSubmit</code> is false, ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} will be called to\n handle saving via SmartClient databinding.  \n <P>\n If <code>canSubmit</code> is true, the form will be submitted like an ordinary HTML\n form via ${isc.DocUtils.linkForRef('method:DynamicForm.submitForm')}.\n <P>\n The parameters to <code>submit()</code> apply only if <code>submit()</code> will be\n calling ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')}.  If you override <code>submit()</code>, you can safely\n ignore the parameters as SmartClient framework code does not pass them.\n \n",
        name:"submit",
        seeAlso:[
            {ref:"method:DynamicForm.submitValues", description:null}
        ],
        params:[
            {description:"callback to invoke on completion.                                          [Ignored if this.canSubmit is true]",
             optional:true, name:"callback", defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on the DSRequest                                          that will be issued\n                                          [Ignored if this.canSubmit is true]",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["dataBoundComponentMethods"]
    },
    "method:RichTextEditor.setValue":{
        ref:"method:RichTextEditor.setValue",
        flags:"",
        description:"  Updates the current value of the edit area.\n",
        name:"setValue",
        seeAlso:[],
        type:"method",
        definingClass:"class:RichTextEditor"
    },
    "attr:Calendar.datePickerHoverText":{
        ref:"attr:Calendar.datePickerHoverText",
        flags:"IR",
        description:"The text to be displayed when a user hovers over the ${isc.DocUtils.linkForRef('attr:Calendar.datePickerButton','date picker')}\n toolbar button",
        name:"datePickerHoverText",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Choose a date\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["i18nMessages"]
    },
    "group:dragTracker":{
        ref:"group:dragTracker",
        refs:["method:DataBoundComponent.setDragTracker", "method:ListGrid.setDragTracker", 
         "method:ListGrid.getDragTrackerIcon","method:ListGrid.getDragTrackerTitle", "method:TreeGrid.getDragTrackerIcon", 
         "method:TileGrid.setDragTracker","method:TileGrid.getDragTrackerTitle", "classMethod:EventHandler.setDragTracker", 
         "attr:ListGrid.dragTrackerMode","attr:ListGrid.trackerImage", "type:DragTrackerMode"],
        name:"dragTracker",
        seeAlso:[],
        type:"group"
    },
    "class:SelectItem":{
        methods:["method:SelectItem.defaultDynamicValue", "method:SelectItem.showPicker", 
         "method:SelectItem.fetchData","method:SelectItem.getDisplayFieldName", "method:SelectItem.getValueFieldName", 
         "method:SelectItem.dataArrived","method:SelectItem.getSelectedRecord"],
        ref:"class:SelectItem",
        classAttrs:[],
        classMethods:[],
        attrs:["attr:SelectItem.height", "attr:SelectItem.addUnknownValues", 
         "attr:SelectItem.defaultValue","attr:SelectItem.defaultToFirstOption", "attr:SelectItem.showPickerIcon", 
         "attr:SelectItem.textBoxStyle","attr:SelectItem.controlStyle", "attr:SelectItem.pickerIconStyle", 
         "attr:SelectItem.showFocused","attr:SelectItem.pickerIconWidth", "attr:SelectItem.pickerIconHeight", 
         "attr:SelectItem.pickerIconSrc","attr:SelectItem.pickerIconProperties", "attr:SelectItem.hiliteOnFocus", 
         "attr:SelectItem.hiliteColor","attr:SelectItem.hiliteTextColor", "attr:SelectItem.pickButtonWidth", 
         "attr:SelectItem.pickButtonHeight","attr:SelectItem.pickButtonSrc", "attr:SelectItem.showOver", 
         "attr:SelectItem.allowEmptyValue","attr:SelectItem.autoFetchData", "attr:SelectItem.optionDataSource", 
         "attr:SelectItem.pickListFields","attr:SelectItem.optionFilterContext", "attr:SelectItem.displayField", 
         "attr:SelectItem.valueField","attr:SelectItem.filterLocally", "attr:SelectItem.pickListCriteria", 
         "attr:SelectItem.showOptionsFromDataSource","attr:SelectItem.pickListProperties", "attr:SelectItem.multiple"],
        description:"FormItem that allows picking between several mutually exclusive options via a select list.\n <P>\n Options may be derived from a <code>dataSource</code> or a <code>valueMap</code>\n <P>\n Note that to select the first option as a default value for the item,\n ${isc.DocUtils.linkForRef('attr:SelectItem.defaultToFirstOption')} may be set.",
        name:"SelectItem",
        implementsInterfaces:["PickList"],
        seeAlso:[
            {ref:"attr:PickList.optionDataSource", description:null},
            {ref:"attr:FormItem.valueMap", description:null}
        ],
        type:"class",
        examples:["${isc.DocUtils.linkForExampleId('selectItem')}"]
    },
    "attr:TileRecord.tileConstructor":{
        ref:"attr:TileRecord.tileConstructor",
        flags:"IRW",
        description:"SmartClient Class to use to construct the tile for this particular record.",
        name:"tileConstructor",
        seeAlso:[],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:TileRecord"
    },
    "attr:Layout.enforcePolicy":{
        ref:"attr:Layout.enforcePolicy",
        flags:"IRWA",
        description:"Whether the layout policy is continuously enforced as new members are added or removed\n and as members are resized.\n <p>\n This setting implies that any member that resizes larger, or any added member, will take\n space from other members in order to allow the overall layout to stay the same size.",
        name:"enforcePolicy",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Layout",
        groups:["layoutPolicy"]
    },
    "attr:StretchImgButton.iconHeight":{
        ref:"attr:StretchImgButton.iconHeight",
        flags:"IR",
        description:"Height in pixels of the icon image.\n <P>\n If unset, defaults to <code>iconSize</code>",
        name:"iconHeight",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["buttonIcon"]
    },
    "method:DataSource.removeData":{
        ref:"method:DataSource.removeData",
        flags:"",
        description:" Perform a \"remove\" DataSource operation against this DataSource, to delete an existing\n DataSource record.\n\n",
        name:"removeData",
        seeAlso:[],
        params:[
            {description:"primary key values of record to delete,                                             (or complete record)",
             optional:false, name:"data", defaultValue:null, type:"Record PrimaryKeys"},
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on                                                       the DSRequest that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest Properties"}
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:["operations"]
    },
    "attr:FormItem.cellStyle":{
        ref:"attr:FormItem.cellStyle",
        flags:"IRW",
        description:"CSS style applied to the form item as a whole, including the text element, any icons, and\n any hint text for the item. Applied to the cell containing the form item.\n <P>\n NOTE: See the ${isc.DocUtils.linkForRef('group:CompoundFormItem_skinning')} discussion for special skinning considerations.",
        name:"cellStyle",
        seeAlso:[],
        valueType:"FormItemBaseStyle",
        defaultValue:"\"formCell\"",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["appearance"]
    },
    "attr:Dialog.styleName":{
        ref:"attr:Dialog.styleName",
        flags:"IRW",
        description:"Style of the Dialog background",
        name:"styleName",
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"\"dialogBackground\"",
        type:"attr",
        definingClass:"class:Dialog",
        groups:["appearance"]
    },
    "attr:FormItem.pickerConstructor":{
        ref:"attr:FormItem.pickerConstructor",
        flags:"IRW",
        description:"Class name of the picker to be created.",
        name:"pickerConstructor",
        seeAlso:[],
        valueType:"SCClassName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "attr:Tab.icon":{
        ref:"attr:Tab.icon",
        flags:"IRW",
        description:"If specified, this tab will show an icon next to the tab title.  Note that as with \n ${isc.DocUtils.linkForRef('attr:Button.icon')}, the URL of a tabs icon will be updated to reflect disabled state.<br>\n If desired a click handler may be assigned to the icon, which will be fired when the user\n clicks the tab. This method takes a single parameter <code>tab</code>, a pointer to the tab\n object.",
        name:"icon",
        seeAlso:[
            {ref:"method:TabSet.tabIconClick", description:null}
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('tabsOrientation')}"],
        definingClass:"object:Tab"
    },
    "attr:FormulaBuilder.autoHideCheckBox":{
        ref:"attr:FormulaBuilder.autoHideCheckBox",
        flags:"IR",
        description:"CheckBox that, when selected, hides columns in the component that are used in this formula.",
        name:"autoHideCheckBox",
        seeAlso:[],
        valueType:"AutoChild TextItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["formulaFields"]
    },
    "attr:TextItem.height":{
        ref:"attr:TextItem.height",
        flags:"IRW",
        description:"Default height for text items.",
        name:"height",
        seeAlso:[],
        valueType:"number",
        defaultValue:"19",
        type:"attr",
        definingClass:"class:TextItem",
        groups:["appearance"]
    },
    "classAttr:Array.DATE_VALUES":{
        ref:"classAttr:Array.DATE_VALUES",
        flags:null,
        description:"This is a built-in comparator for the ${isc.DocUtils.linkForRef('method:Array.find','find')} and ${isc.DocUtils.linkForRef('method:Array.findIndex','findIndex')}\n methods of Array.  Passing this comparator to those methods will find instances where Dates  \n in the search criteria match Dates in the array members (ordinarily, Javascript only regards\n Dates as equal if they refer to the exact same object).  This comparator compares <i>logical</i>\n dates; the time elements of the values being compared are ignored, so two Dates representing\n different times on the same day will be considered equal.",
        name:"DATE_VALUES",
        seeAlso:[
            {ref:"classAttr:Array.DATETIME_VALUES", description:null}
        ],
        valueType:"Function",
        defaultValue:"See below",
        type:"classAttr",
        definingClass:"object:Array"
    },
    "attr:Slider.animateThumbInit":{
        ref:"attr:Slider.animateThumbInit",
        flags:"IRW",
        description:"If thumb animation is enabled, should the thumb be animated to its initial value?",
        name:"animateThumbInit",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Slider",
        groups:["animation"]
    },
    "attr:Calendar.showWorkday":{
        ref:"attr:Calendar.showWorkday",
        flags:"IR",
        description:"If set, causes the calendar to use ${isc.DocUtils.linkForRef('attr:Calendar.workdayBaseStyle')}\n for cells falling within the workday as defined by ${isc.DocUtils.linkForRef('attr:Calendar.workdayStart')} and ${isc.DocUtils.linkForRef('attr:Calendar.workdayEnd')},\n in both the ${isc.DocUtils.linkForRef('attr:Calendar.weekView')} and ${isc.DocUtils.linkForRef('attr:Calendar.dayView')}.",
        name:"showWorkday",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["workday"]
    },
    "attr:RestDataSource.metaDataPrefix":{
        ref:"attr:RestDataSource.metaDataPrefix",
        flags:"IR",
        description:"I ${isc.DocUtils.linkForRef('attr:RestDataSource.sendMetaData')} is true, this attribute is used to specify\n the prefix to apply to 'meta data' properties when assembling parameters to send to the \n server.  Applies to operations where OperationBinding.dataProtocol is set to \n <code>\"getParams\"</code> or <code>\"postParams\"</code> only.",
        name:"metaDataPrefix",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"_\"",
        type:"attr",
        definingClass:"class:RestDataSource"
    },
    "method:TreeGrid.recordDrop":{
        ref:"method:TreeGrid.recordDrop",
        flags:"",
        description:" The superclass event ${isc.DocUtils.linkForRef('method:ListGrid.recordDrop')} does not fire on a TreeGrid, use\n ${isc.DocUtils.linkForRef('method:TreeGrid.folderDrop')} instead.\n\n",
        name:"recordDrop",
        seeAlso:[],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:ListGrid.filterByEditor":{
        ref:"method:ListGrid.filterByEditor",
        flags:"",
        description:" If the filter editor (${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')}) is visible for this grid, \n this method will perform a filter based on the current values in the editor.\n",
        name:"filterByEditor",
        seeAlso:[],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["filterEditor"]
    },
    "attr:Canvas.backgroundPosition":{
        ref:"attr:Canvas.backgroundPosition",
        flags:"IRW",
        description:"Specifies how the background image should be positioned on the widget.\n      It corresponds to the CSS background-position attribute. If unset,\n      no background-position attribute is specified if a background image is\n      specified.",
        name:"backgroundPosition",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["appearance"]
    },
    "attr:DataBoundComponent.dropValues":{
        flags:"IRWA",
        getter:["getDropValues"],
        type:"attr",
        ref:"attr:DataBoundComponent.dropValues",
        description:"When an item is dropped on this component, and ${isc.DocUtils.linkForRef('attr:DataBoundComponent.addDropValues')} is true and both \n          the source and target widgets are databound, either to the same DataSource or \n          to different DataSources that are related via a foreign key, this object \n          provides the \"drop values\" that SmartClient will apply to the dropped object \n          before updating it.\n          <P>\n          If this property is not defined, SmartClient defaults to returning the selection\n          criteria currently in place for this component.  Thus, any databound items (for example, \n          rows from other grids bound to the same DataSource) dropped on the grid will,\n          by default, be subjected to an update that makes them conform to the grid's \n          current filter criteria.",
        name:"dropValues",
        valueType:"Object",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('listRecategorize')}"],
        defaultValue:"null",
        groups:["dragging"],
        definingClass:"interface:DataBoundComponent"
    },
    "attr:ListGridField.validateOnChange":{
        ref:"attr:ListGridField.validateOnChange",
        flags:"IRW",
        description:"If set to true, any ${isc.DocUtils.linkForRef('attr:ListGridField.validators')} for this field will be run whenever\n the value of the field is changed.\n <P>\n Analgous to the ${isc.DocUtils.linkForRef('attr:FormItem.validateOnChange')} property.",
        name:"validateOnChange",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["gridValidation"]
    },
    "method:ColumnTree.getIcon":{
        ref:"method:ColumnTree.getIcon",
        flags:"",
        description:" Get the appropriate icon for a node.\n <P>\n By default icons are derived from ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')} and ${isc.DocUtils.linkForRef('attr:ColumnTree.nodeIcon')}.\n Custom icons for individual nodes can be overriden by setting the ${isc.DocUtils.linkForRef('attr:ColumnTree.customIconProperty')}\n on a node.\n <p>\n If you want to suppress icons altogether, provide an override of this method that simply\n returns null.\n <p> \n Note that the full icon URL will be derived by applying ${isc.DocUtils.linkForRef('method:Canvas.getImgURL')} to the\n value returned from this method.\n\n",
        name:"getIcon",
        seeAlso:[],
        params:[
            {description:"tree node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"URL for icon to show for this node", type:"URL"},
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:HiddenItem.rowSpan":{
        ref:"attr:HiddenItem.rowSpan",
        flags:"IRW",
        description:"hidden fields don't take up any rows",
        name:"rowSpan",
        seeAlso:[],
        valueType:"number",
        defaultValue:"0",
        type:"attr",
        definingClass:"class:HiddenItem",
        groups:["appearance"]
    },
    "method:CubeGrid.facetValueHoverHTML":{
        ref:"method:CubeGrid.facetValueHoverHTML",
        flags:"",
        description:"\n      Get the HTML for the facetValue button hover.  Default implementation returns null.\n\n      <br><i>methodType</i> callback\n",
        name:"facetValueHoverHTML",
        seeAlso:[],
        params:[
            {description:"facetValues object for the button", optional:false, name:"facetValues",
             defaultValue:null, type:"facetValues object"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["hoverTips"]
    },
    "method:Tree.hasChildren":{
        ref:"method:Tree.hasChildren",
        flags:"",
        description:"\n Returns true if this node has any children.\n\n",
        name:"hasChildren",
        seeAlso:[],
        params:[
            {description:"node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"true if the node has children", type:"boolean"},
        type:"method",
        definingClass:"class:Tree"
    },
    "method:TreeGrid.setOpenState":{
        ref:"method:TreeGrid.setOpenState",
        flags:"",
        description:" Reset this set of open folders within this grid's data to match the \n ${isc.DocUtils.linkForRef('type:treeGridOpenState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to \n ${isc.DocUtils.linkForRef('method:TreeGrid.getOpenState')}.\n\n",
        name:"setOpenState",
        seeAlso:[
            {ref:"method:TreeGrid.getOpenState", description:null}
        ],
        params:[
            {description:"Object describing the desired set of open folders.", optional:false,
             name:"openState", defaultValue:null, type:"treeGridOpenState"}
        ],
        type:"method",
        definingClass:"class:TreeGrid",
        groups:["viewState"]
    },
    "classMethod:Class.clearLogPriority":{
        ref:"classMethod:Class.clearLogPriority",
        flags:"",
        description:" Clear this object's priority setting for a particular category, so that the category's \n effective priority returns to the specified priority for this category at the Log level\n (or <code>Log.defaultPriority</code> if not set).<br>\n To clear the Page-level priority setting for this log category use \n <code>isc.Log.clearPriority()</code> instead.\n\n",
        name:"clearLogPriority",
        seeAlso:[
            {ref:"classMethod:Log.clearPriority", description:null}
        ],
        params:[
            {description:"Category name. If not specified, all logging on this object                              will revert to default priority settings.",
             optional:false, name:"category", defaultValue:null, type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "method:DataBoundComponent.anySelected":{
        ref:"method:DataBoundComponent.anySelected",
        flags:"",
        description:" Whether at least one item is selected\n",
        name:"anySelected",
        seeAlso:[],
        returns:{description:"true == at least one item is selected								false == nothing at all is selected",
         type:"boolean"},
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["selection"]
    },
    "attr:Canvas.dynamicContents":{
        ref:"attr:Canvas.dynamicContents",
        flags:"IRWA",
        description:"Dynamic contents allows the contents string to be treated as a simple, but powerful\n template.  When this attribute is set to true, expressions of the form \\${arbitrary JS\n here} are replaced by the result of the evaluation of the JS code inside the curly\n brackets.  This evaluation happens at draw time.  If you want to trigger a re-evaluation\n of the expressions in the contents string you can call markForRedraw() on the canvas.\n <p>\n You can use this feature to build some simple custom components. For example, let's say\n you want to show the value of a Slider in a Canvas somewhere on the screen.  You can do\n this by observing the valueChanged() method on the slider and calling setContents() on\n your canvas with the new string or you can set the contents of the canvas to something\n like:\n <p><code>\n \"The slider value is \\${sliderInstance.getValue()}.\"\n </code><p>\n Next you set dynamicContents: true on the canvas, observe valueChanged() on the slider\n and call canvas.markForRedraw() in that observation.  This approach is cleaner than\n setContents() when the Canvas is aggregating several values or dynamic expressions.\n Like so:\n <p>\n <pre>\n Slider.create({\n     ID: \"mySlider\"\n });\n\n Canvas.create({\n     ID: \"myCanvas\",\n     dynamicContents: true,\n     contents: \"The slider value is \\${mySlider.getValue()}.\"\n });\n     \n myCanvas.observe(mySlider, \"valueChanged\", \n                  \"observer.markForRedraw()\");\n </pre>\n You can embed an arbitrary number of dynamic expressions in the contents string.  The\n search and replace is optimized for speed.\n <p>\n If an error occurs during the evaluation of one of the expressions, a warning is logged\n to the ISC Developer Console and the error string is embedded in place of the expected\n value in the Canvas.\n <p>\n The value of a function is its return value.  The value of any variable is the same as\n that returned by its toString() representation.\n <p>\n Inside the evalution contentext, <code>this</code> points to the canvas instance that\n has the dynamicContents string as its contents - in other words the canvas instance on\n which the template is declared.",
        name:"dynamicContents",
        seeAlso:[
            {ref:"attr:Canvas.contents", description:null},
            {ref:"attr:Canvas.dynamicContentsVars", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dynamicContents')}"],
        definingClass:"class:Canvas",
        groups:["contents"]
    },
    "attr:ListGrid.bodyOverflow":{
        flags:"IRWA",
        type:"attr",
        ref:"attr:ListGrid.bodyOverflow",
        description:"Overflow setting for the \"body\", that is, the area of the grid where data values are\n rendered.\n <P>\n By setting both the grid itself and the body to overflow:visible, it is possible to\n \"auto-fit\" to the rendered height or width of the rows.  Note that in this case\n <code>grid.width</code> and <code>grid.height</code> act as minimums.",
        name:"bodyOverflow",
        setter:["setBodyOverflow"],
        valueType:"Overflow",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('autofitRows')}"],
        defaultValue:"Canvas.AUTO",
        groups:["sizing"],
        definingClass:"class:ListGrid"
    },
    "attr:Chart.data":{
        ref:"attr:Chart.data",
        flags:"IR",
        description:"Dataset for this chart.\n <P>\n Two basic formats are supported:\n <ul>\n <li> \"Standard model\": <code>data</code> is an array of CellRecords where each record\n contains one data value.  Each record also contains a property named after each facetId\n whose value is a facetValueId from that facet.\n <p>\n For example, with a facet with id \"regions\" and facetValues \"west\", \"north\" and \"east\", and\n with ${isc.DocUtils.linkForRef('attr:Chart.valueProperty')} with it's default value \"_value\", the <code>data</code> property\n could be:\n <pre>\n    isc.Chart.create({\n       facets:[{ id:\"regions\" }],\n       data : [\n          {regions:\"west\", _value:4},\n          {regions:\"north\", _value:2},\n          {regions:\"east\", _value:5}\n       ]\n    })</pre>\n If there were a second facet with id \"product\" and facetValues \"cars\" and \"trucks\", a Chart\n with a complete set of values would be:\n <pre>\n    isc.Chart.create({\n       facets:[{ id:\"regions\" }, { id:\"product\" }],\n       data : [\n          {product:\"cars\", regions:\"west\", _value:4},\n          {product:\"cars\", regions:\"north\", _value:2},\n          {product:\"cars\", regions:\"east\", _value:5},\n          {product:\"trucks\", regions:\"west\", _value:1},\n          {product:\"trucks\", regions:\"north\", _value:9},\n          {product:\"trucks\", regions:\"east\", _value:3}\n       ]\n    })</pre>\n This 2 facet (or \"2 dimensional\") dataset, if rendered as a bar chart, would use stacked or\n clustered bars and a legend.\n <P>\n\n <li> \"Inlined facet\": <code>data</code> is a single CellRecord or Array of CellRecords where\n each record contains multiple data values.  In this case, one facet definition is considered\n \"inlined\", meaning that the facetValueIds from this facet appear as properties in each\n record, and each such property holds one data value.  For example, a complete chart\n definition whose dataset is equivalent to the previous example would be:\n <pre>\n    isc.Chart.create({\n       facets: [{ \n          inlinedValues:true,\n          values : [ { id:\"west\" }, { id:\"north\" }, { id : \"east\" } ]\n       }],\n       data : { west:4, north:5, east:2 }\n    })</pre>\n Note that the property \"inlinedValues\" must be set on the facet definition, and the set of\n facetValueIds must be specified outside of the data array (with the \"standard model\",\n facetValueIds can be automatically derived from the data).  \n <P>\n A two facet chart with an inlined facet can be defined as follows:\n <pre>\n    isc.Chart.create({\n       facets: [\n         { \n            inlinedValues:true,\n            values : [ { id:\"west\" }, { id:\"north\" }, { id : \"east\" } ]\n         }, \n         { id:\"product\" }\n       ],\n       data : [\n           { product:\"cars\", west:4, north:5, east:2 },\n           { product:\"trucks\", west:1, north:9, east:3 }\n       ]\n    })</pre>\n </ul>\n Comparing between the formats, the \"standard model\" format treats all facets identically,\n which can be of use when integrating with server technology that likewise treats all facets\n identically.  The \"inlined facet\" format is a more compact data representation and allows\n easier conversion from data displayed in a ListGrid.",
        name:"data",
        setter:["setData"],
        seeAlso:[],
        valueType:"Array of CellRecord or CellRecord",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:Chart"
    },
    "attr:ListGridField.valueIconHeight":{
        ref:"attr:ListGridField.valueIconHeight",
        flags:"IRW",
        description:"Height for value icons for this listGrid field.\n Overrides ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconSize')}, ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconHeight')}, and\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')}.",
        name:"valueIconHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "classAttr:RPCManager.promptStyle":{
        ref:"classAttr:RPCManager.promptStyle",
        flags:"IRW",
        description:"Controls the default prompt style.  Overrideable by ${isc.DocUtils.linkForRef('attr:RPCRequest.promptStyle')}.",
        name:"promptStyle",
        seeAlso:[
            {ref:"attr:RPCRequest.promptStyle", description:null}
        ],
        valueType:"PromptStyle",
        defaultValue:"\"dialog\"",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:["rpcPrompt"]
    },
    "method:Class.addPropertyList":{
        ref:"method:Class.addPropertyList",
        flags:"",
        description:"\n	Add properties to this instance.\n\n",
        name:"addPropertyList",
        seeAlso:[],
        params:[
            {description:"listarray of objects with properties to add", optional:true, name:"",
             defaultValue:null, type:"object"}
        ],
        returns:{description:"the object after properties have been added to it", type:"object"},
        type:"method",
        definingClass:"class:Class"
    },
    "attr:ImgButton.showFocusedIcon":{
        ref:"attr:ImgButton.showFocusedIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the button\n recieves focus.\n <P>\n If ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true, the <code>\"Over\"</code> icon will be\n displayed when the canvas has focus, otherwise a seperate <code>\"Focused\"</code> icon\n will be displayed",
        name:"showFocusedIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["buttonIcon"]
    },
    "attr:Window.footerHeight":{
        ref:"attr:Window.footerHeight",
        flags:"IR",
        description:"The height of the footer, in pixels.",
        name:"footerHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"18",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "footer"]
    },
    "attr:ImgButton.radioGroup":{
        ref:"attr:ImgButton.radioGroup",
        flags:"IRWA",
        description:"String identifier for this canvas's mutually exclusive selection group.",
        name:"radioGroup",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('buttonRadioToggle')}"],
        definingClass:"class:ImgButton",
        groups:["state", "event handling"]
    },
    "type:TopOperatorAppearance":{
        ref:"type:TopOperatorAppearance",
        values:[
            {description:"radio buttons appear at the top of the form", value:"\"radio\""},
            {description:"a SelectItem appears with a \"bracket\" spanning all top-level clauses, exactly the same appearance used for showing\n ${isc.DocUtils.linkForRef('attr:FilterBuilder.showSubClauseButton','subClauses')}, if enabled.",
             value:"\"bracket\""},
            {description:"no interface is shown.  The top-level operator is expected to be shown to the user outside the FilterBuilder, and, if editable, ${isc.DocUtils.linkForRef('method:FilterBuilder.setTopOperator')}\n should be called to update it",
             value:"\"none\""}
        ],
        description:"Interface to use for the showing and editing the ${isc.DocUtils.linkForRef('attr:FilterBuilder.topOperator','top-level operator')} of a\n FilterBuilder.",
        name:"TopOperatorAppearance",
        seeAlso:[],
        type:"type"
    },
    "method:DataBoundComponent.selectRecords":{
        ref:"method:DataBoundComponent.selectRecords",
        flags:"",
        description:"\n Select/deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n\n",
        name:"selectRecords",
        seeAlso:[],
        params:[
            {description:"records (or row numbers) to select", optional:false, name:"records",
             defaultValue:null, type:"Array of Record | numbers"},
            {description:"new selection state (if null, defaults to true)", optional:true,
             name:"newState", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["selection"]
    },
    "attr:Slider.labelWidth":{
        ref:"attr:Slider.labelWidth",
        flags:"IRW",
        description:"The width of the labels used to display the minimum, maximum and current values of the\n slider.",
        name:"labelWidth",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"50",
        type:"attr",
        definingClass:"class:Slider"
    },
    "method:PickList.fetchData":{
        ref:"method:PickList.fetchData",
        flags:"",
        description:" Only applies to databound items (see ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource')}).<br>\n Performs a fetch type operation on this item's DataSource to retrieve the set of valid\n options for the item, based on the current ${isc.DocUtils.linkForRef('attr:PickList.pickListCriteria')}.\n",
        name:"fetchData",
        seeAlso:[],
        params:[
            {description:"Callback to fire when the fetch completes. Callback will               fire with 2 parameters: <code>item</code> a pointer to the form item and\n              <code>dsResponse</code> the ${isc.DocUtils.linkForRef('class:DSResponse')} returned by the server.",
             optional:false, name:"callback", defaultValue:null, type:"callback"},
            {description:"properties to apply to the              dsRequest for this fetch.",
             optional:false, name:"requestProperties", defaultValue:null, type:"dsRequest properties"}
        ],
        type:"method",
        definingClass:"interface:PickList"
    },
    "method:DynamicForm.getFields":{
        ref:"method:DynamicForm.getFields",
        flags:"",
        description:" Method to retrieve the ${isc.DocUtils.linkForRef('attr:DynamicForm.fields','items')} for this DynamicForm. \n\n",
        name:"getFields",
        seeAlso:[],
        returns:{description:null, type:"Array of FormItem"},
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["elements"]
    },
    "method:Tree.getPath":{
        ref:"method:Tree.getPath",
        flags:"",
        description:"\n Returns the path of a node - a path has the following format:\n <code>([name][pathDelim]?)*</code>\n <br><br>\n For example, in this tree:\n <pre>\n root\n   foo\n     bar\n </pre>\n Assuming that ${isc.DocUtils.linkForRef('attr:Tree.pathDelim')} is the default <code>/</code>, the <code>bar</code>\n node would have the path <code>root/foo/bar</code> and the path for the <code>foo</code>\n node would be <code>root/foo</code>.\n <br><br>\n Once you have a path to a node, you can call find(path) to retrieve a reference to the node\n later.\n\n",
        name:"getPath",
        seeAlso:[
            {ref:"method:Tree.getParentPath", description:null}
        ],
        params:[
            {description:"node in question", optional:false, name:"node", defaultValue:null,
             type:"TreeNode"}
        ],
        returns:{description:"path to the node", type:"string"},
        type:"method",
        definingClass:"class:Tree"
    },
    "attr:Slider.vertical":{
        ref:"attr:Slider.vertical",
        flags:"IRW",
        description:"Indicates whether this is a vertical or horizontal slider.",
        name:"vertical",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('slider')}"],
        definingClass:"class:Slider"
    },
    "attr:Window.showHeaderBackground":{
        ref:"attr:Window.showHeaderBackground",
        flags:"IRA",
        description:"Should the window header show a background image? Default value is true for all browsers\n except for Internet Explorer.<br>\n If set to true the image source is derived from ${isc.DocUtils.linkForRef('attr:Window.headerSrc')} and \n ${isc.DocUtils.linkForRef('attr:Window.hiliteHeaderSrc')}, otherwise the background will be styled according to \n ${isc.DocUtils.linkForRef('attr:Window.headerStyle')} / ${isc.DocUtils.linkForRef('attr:Window.hiliteHeaderStyle')}.",
        name:"showHeaderBackground",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:Window",
        groups:["appearance", "header"]
    },
    "attr:ListGrid.checkboxFieldImageWidth":{
        ref:"attr:ListGrid.checkboxFieldImageWidth",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionAppearance')} is set to <code>\"checkbox\"</code> this property\n may be set to govern the width of the checkbox image displayed to indicate whether a row is\n selected. If unset, the checkboxField image will be sized to match the\n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanImageWidth')} for this grid.",
        name:"checkboxFieldImageWidth",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["checkboxField"]
    },
    "attr:DynamicForm.minColWidth":{
        ref:"attr:DynamicForm.minColWidth",
        flags:"IRW",
        description:"Minimum width of a form column.",
        name:"minColWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:["tableLayout"]
    },
    "attr:CubeGrid.hideEmptyFacetValues":{
        ref:"attr:CubeGrid.hideEmptyFacetValues",
        flags:"IRW",
        description:"This causes the headers for any combination of facetValues for which there are no \n cellRecords to be suppressed.\n (Note: Valid only for CubeGrids that specify the complete dataset upfront - \n  don't use load on demand)",
        name:"hideEmptyFacetValues",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["facetLayout"]
    },
    "class:SpacerItem":{
        methods:[],
        ref:"class:SpacerItem",
        classAttrs:[],
        classMethods:[],
        attrs:["attr:SpacerItem.showTitle", "attr:SpacerItem.width", "attr:SpacerItem.height"],
        description:"A SpacerItem takes up a single cell in the FormLayout, of arbitrary size.",
        name:"SpacerItem",
        seeAlso:[],
        type:"class"
    },
    "attr:FormItem.valueIconRightPadding":{
        ref:"attr:FormItem.valueIconRightPadding",
        flags:"IRW",
        description:"If we're showing a value icon, this attribute governs the amount of space between the \n icon and the label of the form item",
        name:"valueIconRightPadding",
        seeAlso:[
            {ref:"attr:FormItem.valueIcons", description:null}
        ],
        valueType:"number",
        defaultValue:"3",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["valueIcons"]
    },
    "attr:Canvas.canDrag":{
        ref:"attr:Canvas.canDrag",
        flags:"IRWA",
        description:"Indicates whether this widget can initiate custom drag-and-drop operations (other than\n      reposition or resize). Normally canDragReposition or canDragResize would be used\n      instead of this property.\n      Note: this property may be manipulated by higher-level dragging semantics.",
        name:"canDrag",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dragCreate')}"],
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "attr:ColumnTree.nodeIcon":{
        ref:"attr:ColumnTree.nodeIcon",
        flags:"IRW",
        description:"The filename of the default icon for all leaf nodes in this grid. To specify a \n custom image for an individual node, set the ${isc.DocUtils.linkForRef('attr:ColumnTree.customIconProperty')} directly on\n the node.",
        name:"nodeIcon",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]file.gif\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('millerColumns')}"],
        definingClass:"class:ColumnTree",
        groups:["treeIcons"]
    },
    "type:DateDisplayFormat":{
        ref:"type:DateDisplayFormat",
        values:[
            {description:"Default native browser 'toString()' implementation. May vary by browser.<br>\n <i>Example</i>: <code>Fri Nov 04 2005 11:03:00 GMT-0800 (Pacific Standard Time)</code>",
             value:"toString"},
            {description:"Default native browser 'toLocaleString()' implementation. May vary by browser.\n <i>Example</i>: <code>Friday, November 04, 2005 11:03:00 AM</code>",
             value:"toLocaleString"},
            {description:"Short date in format MM/DD/YYYY.<br> <i>Example</i>: <code>11/4/2005</code>",
             value:"toUSShortDate"},
            {description:"Short date with time in format MM/DD/YYYY HH:MM<br> <i>Example</i>: <code>11/4/2005 11:03</code>",
             value:"toUSShortDateTime"},
            {description:"Short date in format DD/MM/YYYY.<br> <i>Example</i>: <code>4/11/2005</code>",
             value:"toEuropeanShortDate"},
            {description:"Short date with time in format DD/MM/YYYY HH:MM<br> <i>Example</i>: <code>4/11/2005 11:03</code>",
             value:"toEuropeanShortDateTime"},
            {description:"Short date in format YYYY/MM/DD.<br> <i>Example</i>: <code>2005/11/4</code>",
             value:"toJapanShortDate"},
            {description:"Short date with time in format YYYY/MM/DD HH:MM<br> <i>Example</i>: <code>2005/11/4 11:03</code>",
             value:"toJapanShortDateTime"},
            {description:"Date in the format YYYY-MM-DD HH:MM:SS<br> <i>Example</i>: <code>2005-11-04 11:09:15</code>",
             value:"toSerializeableDate"},
            {description:"Date in the format &lt;YYYYMMDD&gt;T&lt;HHMMSS&gt;Z <i>Example</i>: <code>20051104T111001Z</code>\n <br>\n <br>\n Note: In addition to these standard formats, custom formatting can be set by passing\n a function directly to ${isc.DocUtils.linkForRef('classMethod:Date.setNormalDisplayFormat')} et al. This \n function will then be executed whenever the appropriate formatter method is called [eg \n ${isc.DocUtils.linkForRef('method:Date.toNormalDate')}], in the scope of the date instance in question.",
             value:"toDateStamp"}
        ],
        description:"Valid display formats for dates.  These strings are the names of formatters which can be \n passed to <code>Date.setNormalDisplayFormat()</code> or <code>Date.setShortDisplayFormat()</code>\n and will be subsequently used as default long or short formatters for date objects by\n SmartClient components.<br>\n Default set of valid display formats is as follows:<br><br>",
        name:"DateDisplayFormat",
        seeAlso:[],
        type:"type"
    },
    "attr:ListGrid.checkboxField":{
        ref:"attr:ListGrid.checkboxField",
        flags:"IR",
        getter:["getCheckboxField"],
        description:"Returns the specially generated checkbox field used when ${isc.DocUtils.linkForRef('type:SelectionAppearance')} is\n \"checkbox\".  Created via the ${isc.DocUtils.linkForRef('type:AutoChild')} pattern so that\n <code>checkboxFieldDefaults</code> and <code>checkboxFieldProperties</code> are available\n for skinning purposes.\n <P>\n This field will render an icon to indicate the selected state of each row, which, when\n clicked will toggle the selection state. The icon src may be configured using \n ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxFieldTrueImage')} and ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxFieldFalseImage')}, as\n well as ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxFieldImageWidth')} and ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxFieldImageHeight')}.\n <P>\n The checkboxField can be detected by calling ${isc.DocUtils.linkForRef('method:ListGrid.isCheckboxField')} on any\n ListGridField object.",
        name:"checkboxField",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["checkboxField"]
    },
    "method:Progressbar.setBreadth":{
        ref:"method:Progressbar.setBreadth",
        flags:"",
        description:" Sets the breadth of the progressbar to newLength. This is the height of a horizontal progressbar,\n or the width of a vertical progressbar.\n\n",
        name:"setBreadth",
        seeAlso:[],
        params:[
            {description:"the new breadth of the progressbar", optional:false, name:"newBreadth",
             defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:Progressbar"
    },
    "attr:ListGridField.imageURLPrefix":{
        ref:"attr:ListGridField.imageURLPrefix",
        flags:"IRWA",
        description:"If this field has type [${isc.DocUtils.linkForRef('type:ListGridFieldType')}] set to <code>\"image\"</code>\n and the URL for the image displayed is not absolute, the path of the URL will be relative \n to this string<br>\n Alternatively, if this field displays any valueIcons, this prefix will be applied to\n the beginning of any ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')} when determining the\n URL for the image.",
        name:"imageURLPrefix",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('imageType')}"],
        definingClass:"object:ListGridField",
        groups:["imageColumns"]
    },
    "method:ListGrid.setAlternateRecordStyles":{
        ref:"method:ListGrid.setAlternateRecordStyles",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:ListGrid.alternateRecordStyles')}\n",
        name:"setAlternateRecordStyles",
        seeAlso:[],
        params:[
            {description:"New value for <code>this.alternateRecordStyles</code>", optional:false,
             name:"alternateStyles", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Menu.itemClick":{
        ref:"method:Menu.itemClick",
        flags:"A",
        description:"          Executed when a menu item with no click handler is clicked by the user. This\n          itemClick handler must be specified as a function. It is passed an item parameter that\n          is a reference to the clicked menu item.\n\n",
        name:"itemClick",
        seeAlso:[],
        params:[
            {description:"pointer to the item in question", optional:false, name:"item",
             defaultValue:null, type:"object"},
            {description:"Index of the column clicked by the user. May be null if                                  this menu item was activated in response to a keyboard event.",
             optional:true, name:"colNum", defaultValue:null, type:"number"}
        ],
        returns:{description:"false if event processing should be stopped, true to continue", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('menuColumns')}"],
        definingClass:"class:Menu"
    },
    "attr:ListGrid.autoFitMaxRecords":{
        ref:"attr:ListGrid.autoFitMaxRecords",
        flags:"IRW",
        description:"if ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code> this\n property provides the maximum number of records for which the ListGrid will expand. If more\n records are present, scrolling will be introduced to reach them as normal.\n If unset, by default the ListGrid will expand to accomodate as many records as are present.",
        name:"autoFitMaxRecords",
        setter:["setAutoFitMaxRecords"],
        seeAlso:[],
        valueType:"number",
        defaultValue:"50",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["autoFitData"]
    },
    "class:SchemaSet":{
        methods:["method:SchemaSet.getSchema"],
        ref:"class:SchemaSet",
        classAttrs:[],
        classMethods:["classMethod:SchemaSet.get"],
        treeLocation:["Client Reference/Data Binding"],
        attrs:["attr:SchemaSet.schemaNamespace"],
        description:"A set of schema derived from the &lt;xsd:schema&gt; element in a WSDL or XML schema file\n loaded by ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadWSDL')} or ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema')}.",
        name:"SchemaSet",
        seeAlso:[],
        type:"class"
    },
    "method:DataBoundComponent.addFormulaField":{
        ref:"method:DataBoundComponent.addFormulaField",
        flags:"",
        description:" Convenience method to display a ${isc.DocUtils.linkForRef('class:FormulaBuilder')} to create a new Formula Field.  This \n is equivalent to calling ${isc.DocUtils.linkForRef('method:DataBoundComponent.editFormulaField','editFormulaField()')} with \n no paramater.\n\n",
        name:"addFormulaField",
        seeAlso:[],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:["formulaFields"]
    },
    "method:CubeGrid.saveAllEdits":{
        ref:"method:CubeGrid.saveAllEdits",
        flags:"",
        description:" Save a number of outstanding edits for this CubeGrids. If no cells are specifed, all \n outstanding edits will be saved\n",
        name:"saveAllEdits",
        seeAlso:[],
        params:[
            {description:"optionally specify which cells to save. Each cell  should be specified as a 2 element array in the format <code>[rowNum,colNum]</code>.",
             optional:true, name:"cells", defaultValue:null, type:"array of 2-element arrays"},
            {description:"If specified this callback will be fired on a successful save  of the specified rows. Note that if there are no pending edits to be saved this callback will\n  not fire - you can check for this condition using ${isc.DocUtils.linkForRef('method:CubeGrid.hasChanges')} or \n  ${isc.DocUtils.linkForRef('method:CubeGrid.recordHasChanges')}.",
             optional:true, name:"saveCallback", defaultValue:null, type:"callback"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["editing"]
    },
    "classAttr:Date.weekendDays":{
        ref:"classAttr:Date.weekendDays",
        flags:"IR",
        description:"Days that are considered \"weekend\" days.   Values should be the integers returned by the\n JavaScript built-in Date.getDay(), eg, 0 in Sunday and 6 is Saturday.  Override to\n accomodate different workweeks such as Saudi Arabia (Saturday -> Wednesday) or Israel \n (Sunday -> Thurday).",
        name:"weekendDays",
        seeAlso:[],
        valueType:"Array of int",
        defaultValue:"[0, 6]",
        type:"classAttr",
        definingClass:"class:Date"
    },
    "attr:MenuItem.icon":{
        ref:"attr:MenuItem.icon",
        flags:"IR",
        description:"The base filename for this item's custom icon. If both this property and\n ${isc.DocUtils.linkForRef('attr:MenuItem.checked')} are both specified, only icon specified by this property will be\n displayed. The path to the loaded skin directory and the skinImgDir are prepended to\n this filename to form the full URL.\n <p>\n If you need to set this state dynamically, use ${isc.DocUtils.linkForRef('method:MenuItem.dynamicIcon')} instead.",
        name:"icon",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('fullMenu')}"],
        definingClass:"object:MenuItem",
        groups:["menuIcons"]
    },
    "attr:ViewLoader.viewRPCProperties":{
        ref:"attr:ViewLoader.viewRPCProperties",
        flags:"IRA",
        description:"RPCRequest properties to be sent with every RPCRequest issued by the ViewLoader.  Very\n advanced; could be used to, for example, set HTTP headers.",
        name:"viewRPCProperties",
        seeAlso:[],
        valueType:"RPCRequest Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ViewLoader"
    },
    "method:Canvas.dropOut":{
        ref:"method:Canvas.dropOut",
        flags:"A",
        description:"\n Executed when the dragged object is moved out of the rectangle of this drop target. If you\n have set a visual indication in dropOver or dropMove, you should reset it to its normal\n state in dropOut.\n\n",
        name:"dropOut",
        seeAlso:[
            {ref:"method:Canvas.getOffsetX", description:null},
            {ref:"method:Canvas.getOffsetY", description:null}
        ],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('customDrag')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:TreeGrid.setData":{
        ref:"method:TreeGrid.setData",
        flags:"",
        description:" Set the ${isc.DocUtils.linkForRef('class:Tree')} object this TreeGrid will view and manipulate.\n\n",
        name:"setData",
        seeAlso:[],
        params:[
            {description:"Tree to show", optional:false, name:"newData", defaultValue:null, type:"Tree"}
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "attr:Slider.thumbThinWidth":{
        ref:"attr:Slider.thumbThinWidth",
        flags:"IRW",
        description:"The dimension of the thumb parallel to the slider track.",
        name:"thumbThinWidth",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"17",
        type:"attr",
        definingClass:"class:Slider"
    },
    "attr:ListGrid.dragDataAction":{
        ref:"attr:ListGrid.dragDataAction",
        flags:"IRW",
        description:"Indicates what to do with data dragged into another DataBoundComponent. See\n          DragDataAction type for details.",
        name:"dragDataAction",
        seeAlso:[],
        valueType:"DragDataAction",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('gridsDragMove')}", 
         "${isc.DocUtils.linkForExampleId('gridsDragCopy')}"],
        definingClass:"class:ListGrid",
        groups:["dragging"]
    },
    "class:EdgedCanvas":{
        methods:[],
        ref:"class:EdgedCanvas",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Client Reference/Foundation"],
        attrs:["attr:EdgedCanvas.skinImgDir", "attr:EdgedCanvas.edgeImage", "attr:EdgedCanvas.edgeColor", 
         "attr:EdgedCanvas.customEdges","attr:EdgedCanvas.showCenter", "attr:EdgedCanvas.edgeSize", "attr:EdgedCanvas.edgeLeft", 
         "attr:EdgedCanvas.edgeRight","attr:EdgedCanvas.edgeTop", "attr:EdgedCanvas.edgeBottom", "attr:EdgedCanvas.edgeOffset", 
         "attr:EdgedCanvas.edgeOffsetTop","attr:EdgedCanvas.edgeOffsetBottom", "attr:EdgedCanvas.edgeOffsetLeft", 
         "attr:EdgedCanvas.edgeOffsetRight","attr:EdgedCanvas.centerBackgroundColor", "attr:EdgedCanvas.edgeStyleName", 
         "attr:EdgedCanvas.addEdgeStyleSuffix"],
        description:"EdgedCanvas acts as a decorative, image-based frame around another single Canvas.",
        name:"EdgedCanvas",
        seeAlso:[],
        type:"class",
        groups:["imageEdges"]
    },
    "attr:Window.canDragReposition":{
        ref:"attr:Window.canDragReposition",
        flags:"IRW",
        description:"if true, this Window may be moved around by the user by dragging on the Window header.  \n Note that if the header is not showing, the Window can't be drag-repositioned regardless\n of this setting.",
        name:"canDragReposition",
        seeAlso:[
            {ref:"attr:Window.showHeader", description:null}
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Window",
        groups:["dragging"]
    },
    "method:Button.setAutoFit":{
        ref:"method:Button.setAutoFit",
        flags:"",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        name:"setAutoFit",
        seeAlso:[],
        params:[
            {description:"New autoFit setting.", optional:false, name:"autoFit", defaultValue:null,
             type:"boolean"}
        ],
        type:"method",
        definingClass:"class:Button"
    },
    "attr:Scrollbar.autoEnable":{
        ref:"attr:Scrollbar.autoEnable",
        flags:"IRWA",
        description:"If true, this scrollbar will automatically enable when the scrollTarget is\n scrollable (i.e., when the contents of the scrollTarget exceed its clip size in the\n direction relevant to this scrollbar), and automatically disable when the\n scrollTarget is not scrollable. Set this property to false for full manual control\n over a scrollbar's enabled state.",
        name:"autoEnable",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Scrollbar"
    },
    "method:ListGrid.setBodyStyleName":{
        ref:"method:ListGrid.setBodyStyleName",
        flags:"",
        description:" Update the ${isc.DocUtils.linkForRef('attr:ListGrid.bodyStyleName','bodyStyleName')} for this listGrid.\n",
        name:"setBodyStyleName",
        seeAlso:[],
        params:[
            {description:"new body style name", optional:false, name:"styleName", defaultValue:null,
             type:"CSSStyleName"}
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:StretchImgButton.wrap":{
        ref:"attr:StretchImgButton.wrap",
        flags:"IRW",
        description:"Should the title for this button wrap? If unset, default behavior is to allow wrapping\n if this.vertical is true, otherwise disallow wrapping",
        name:"wrap",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "method:Canvas.resizeTo":{
        ref:"method:Canvas.resizeTo",
        flags:"",
        description:"			Resizes the widget to the specified width and height (moves the right and/ or bottom\n          sides of the widget). The width and height parameters can be expressed as a percentage\n          of viewport size or as the number of pixels.\n",
        name:"resizeTo",
        seeAlso:[],
        params:[
            {description:"new width for canvas", optional:true, name:"width", defaultValue:null,
             type:"number"},
            {description:"new height for canvas", optional:true, name:"height", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether the size actually changed", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('resize')}"],
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "classAttr:RPCManager.useCursorTracker":{
        ref:"classAttr:RPCManager.useCursorTracker",
        flags:"IRW",
        description:"If true, an image is shown to the right of the cursor when ${isc.DocUtils.linkForRef('attr:RPCRequest.promptStyle')} is\n set to \"cursor\", otherwise the cursor itself is modified via css to the value of\n ${isc.DocUtils.linkForRef('attr:RPCRequest.promptCursor')}.  The default is platform-dependent.  In Safari, IE 5.5 and\n Firefox 1.0 the default is true, on all other platforms it is false.  The reason for\n this split is that, the above browsers require that the cursor move before CSS settings are\n re-evaluated - this means the progress cursor can stick until the user moves the mouse.\n <p>\n This value can be overridden on a per-request basis via ${isc.DocUtils.linkForRef('classAttr:RPCRequest.useCursorTracker')}.",
        name:"useCursorTracker",
        seeAlso:[
            {ref:"classAttr:RPCRequest.useCursorTracker", description:null}
        ],
        valueType:"boolean",
        defaultValue:"platform-dependent",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:["rpcPrompt"]
    },
    "attr:ListGrid.headerMenuButtonHeight":{
        ref:"attr:ListGrid.headerMenuButtonHeight",
        flags:"IRA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderMenuButton')} is true, this property governs the height of the \n auto-generated <code>headerMenuButton</code>",
        name:"headerMenuButtonHeight",
        seeAlso:[],
        valueType:"measure",
        defaultValue:"\"100%\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["headerMenuButton"]
    },
    "attr:DateChooser.prevMonthIconHeight":{
        ref:"attr:DateChooser.prevMonthIconHeight",
        flags:"IR",
        description:"Height of the icon for the previous month button",
        name:"prevMonthIconHeight",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"7",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:Canvas.getInnerHTML":{
        ref:"method:Canvas.getInnerHTML",
        flags:"A",
        description:"      Return the inner HTML for this canvas. Called when the canvas is drawn or redrawn; \n      override to customize.\n",
        name:"getInnerHTML",
        seeAlso:[],
        returns:{description:"HTML contents of this canvas", type:"string"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["drawing"]
    },
    "classAttr:Operators.iNotEndsWithTitle":{
        ref:"classAttr:Operators.iNotEndsWithTitle",
        flags:"IR",
        description:"Title for the \"iNotEndsWith\" operator",
        name:"iNotEndsWithTitle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"does not end with\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:["i18nMessages"]
    },
    "classAttr:ValidatorTypes.isString":{
        ref:"classAttr:ValidatorTypes.isString",
        flags:"IR",
        description:"Validation will fail if the value is not a string value.",
        name:"isString",
        seeAlso:[],
        valueType:"validatorDefinition",
        defaultValue:"object",
        type:"classAttr",
        definingClass:"class:ValidatorTypes"
    },
    "attr:ColorPicker.defaultOpacity":{
        ref:"attr:ColorPicker.defaultOpacity",
        flags:"IR",
        description:"The initial opacity value for the component, as a percentage value between 0 and 100",
        name:"defaultOpacity",
        seeAlso:[],
        valueType:"number",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "attr:Window.canFocusInHeaderButtons":{
        ref:"attr:Window.canFocusInHeaderButtons",
        flags:"IRWA",
        description:"If true, the user can give the header buttons keyboard focus (by clicking on\n      them and including them in the tabOrder)",
        name:"canFocusInHeaderButtons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Window",
        groups:["focus", "header"]
    },
    "attr:ToolStrip.members":{
        ref:"attr:ToolStrip.members",
        flags:"IR",
        description:"Array of components that will be contained within this Toolstrip, like\n ${isc.DocUtils.linkForRef('attr:Layout.members')}, with the following special behaviors:\n <ul>\n <li>the String \"separator\" will cause a separator to be created (instance of \n ${isc.DocUtils.linkForRef('attr:ToolStrip.separatorClass')})\n <li>the String \"resizer\" will cause a resizer to be created (instance of\n ${isc.DocUtils.linkForRef('attr:ToolStrip.resizeBarClass')}).  This is equivalent to setting\n ${isc.DocUtils.linkForRef('attr:Canvas.showResizeBar','showResizeBar:true')} on the preceding member.\n </ul>",
        name:"members",
        seeAlso:[],
        valueType:"Array of Canvas",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('toolstrip')}"],
        definingClass:"class:ToolStrip"
    },
    "method:GridRenderer.findColNum":{
        ref:"method:GridRenderer.findColNum",
        flags:"",
        description:" Given a record displayed in this grid, find and return the colNum in which the record\n appears.\n <P>\n As with ${isc.DocUtils.linkForRef('method:GridRenderer.getCellRecord')} implementing this method is optional as a valid\n grid may be created without any notion of records, or records may not be displayed in a\n single column (as with the ${isc.DocUtils.linkForRef('class:ListGrid','ListGrid')} class where each record is \n displayed in an entire row.  \n\n",
        name:"findColNum",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"}
        ],
        returns:{description:"index of the column containing the record or -1 if not found", type:"number"},
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "attr:Toolbar.buttonDefaults":{
        ref:"attr:Toolbar.buttonDefaults",
        flags:"IRWA",
        description:"Settings to apply to all buttons of a toolbar. Properties that can be applied to\n button objects can be applied to all buttons of a toolbar by specifying them in\n buttonDefaults using the following syntax:<br>\n <code>buttonDefaults:{property1:value1, property2:value2, ...}</code><br>\n See the Button Widget Class for standard button properties.",
        name:"buttonDefaults",
        seeAlso:[
            {ref:"class:Button", description:null}
        ],
        valueType:"object",
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:Toolbar",
        groups:["appearance"]
    },
    "attr:CheckboxItem.allowEmptyValue":{
        ref:"attr:CheckboxItem.allowEmptyValue",
        flags:"IRW",
        description:"By default checkboxes allow the user to toggle between true and false values only.\n Setting this property to true will allow the user to toggle between three values - \n <code>true</code>, <code>false</code> and unset.",
        name:"allowEmptyValue",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:CheckboxItem"
    },
    "attr:RPCRequest.evalResult":{
        ref:"attr:RPCRequest.evalResult",
        flags:"IRWA",
        description:"This works similarly to ${isc.DocUtils.linkForRef('attr:RPCRequest.serverOutputAsString')} except the resulting String\n is automatically evaluated as JavaScript.  The result of the evaluation is then passed to\n any specified ${isc.DocUtils.linkForRef('attr:RPCRequest.callback')} as ${isc.DocUtils.linkForRef('attr:RPCResponse.data')}.\n <p>\n This feature can be used to dynamically load new application modules into a running\n application.  An RPCRequest with <code>evalResult</code> enabled can be used to fetch a\n static .js file or JavaScript dynamically generated by the server.  The returned JavaScript\n can contain anything that a JavaScript file loaded at init time can contain, including new\n views and new SmartClient class definitions.\n <p>\n <i>Example usage with ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendRequest')}:</i>\n <pre>\n isc.RPCManager.sendRequest({\n     evalResult:true,\n     actionURL:\"js/loadLabel.js\",\n     evalVars:{var1:\"A Value\"}\n });\n </pre>\n This call would execute the code from <code>loadLabel.js</code>, and make the variable\n <code>var1</code> available to that code. Therefore if the .js file contained this code:\n <pre>\n isc.Label.create({\n     contents:var1\n })\n </pre>\n A label would be created with contents set to the value of <code>var1</code> - the string\n <code>\"A Value\"</code>.\n \n <p>\n This feature relies on the XMLHttpRequest object which can be disabled by end-users in some\n supported browsers.  See ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information.",
        name:"evalResult",
        seeAlso:[
            {ref:"class:ViewLoader", description:null},
            {ref:"attr:RPCRequest.evalVars", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:RPCRequest",
        groups:["viewLoading"]
    },
    "type:DrawPosition":{
        ref:"type:DrawPosition",
        values:[
            {description:"insert before the target element", value:"\"beforeBegin\""},
            {description:"insert as the target element's first child", value:"\"afterBegin\""},
            {description:"insert as the target element's last child", value:"\"beforeEnd\""},
            {description:"insert after the target element", value:"\"afterEnd\""},
            {description:"replace the target element", value:"\"replace\""}
        ],
        description:null,
        name:"DrawPosition",
        seeAlso:[],
        type:"type",
        groups:["drawContext"]
    },
    "attr:FormulaBuilder.cancelButton":{
        ref:"attr:FormulaBuilder.cancelButton",
        flags:"IR",
        description:"Button to Cancel this FormulaBuilder.  The formula is not tested, formulaBuilder.cancelled\n is set to true and formulaBuilder.fireOnClose is fired.",
        name:"cancelButton",
        seeAlso:[],
        valueType:"AutoChild Button",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["formulaFields"]
    },
    "attr:Menu.showIcons":{
        ref:"attr:Menu.showIcons",
        flags:"IRW",
        description:"A boolean, indicating whether the checkmark/custom icon column should be displayed.\n If showIcons is not set, the menu will show the icon column only if one of its items\n specifies an icon, checked, checkIf, or dynamicIcon property.",
        name:"showIcons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Menu"
    },
    "attr:FormItem.showFocusedIcons":{
        ref:"attr:FormItem.showFocusedIcons",
        flags:"IRWA",
        description:"If we're showing icons, should we change their image source to the appropriate\n  <i>focused</i>  source when this item has focus?  Can be overridden on a per\n  icon basis by the formItemIcon <code>showFocused</code> property.",
        name:"showFocusedIcons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["formIcons"]
    },
    "attr:DynamicForm.saveOperationType":{
        ref:"attr:DynamicForm.saveOperationType",
        flags:"IRW",
        getter:["getSaveOperationType"],
        description:"Default ${isc.DocUtils.linkForRef('type:DSOperationType')} to be performed when ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} is called.\n This property is automatically set on a call to ${isc.DocUtils.linkForRef('method:DynamicForm.editRecord')} or\n ${isc.DocUtils.linkForRef('method:DynamicForm.editNewRecord')}, or may be set directly via \n ${isc.DocUtils.linkForRef('method:DynamicForm.setSaveOperationType')}.\n <P>\n If <code>saveOperationType</code> is unset, the form will heuristically determine\n whether an \"add\" or \"update\" operation is intended based on whether the primaryKey field\n is present and editable.",
        name:"saveOperationType",
        setter:["setSaveOperationType"],
        seeAlso:[],
        valueType:"DSOperationType",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "attr:ListGrid.headerSpanVAlign":{
        ref:"attr:ListGrid.headerSpanVAlign",
        flags:"IR",
        description:"Default alignment for ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')} with no\n ${isc.DocUtils.linkForRef('attr:HeaderSpan.valign')} specified.",
        name:"headerSpanVAlign",
        seeAlso:[],
        valueType:"vAlign",
        defaultValue:"\"center\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["headerSpan"]
    },
    "method:CubeGrid.getEditedCell":{
        ref:"method:CubeGrid.getEditedCell",
        flags:"",
        description:" Returns the current value of a cell. If the cell has an outstanding edit value, this will\n be returned, otherwise the underlying value of the record will be returned.\n\n",
        name:"getEditedCell",
        seeAlso:[],
        params:[
            {description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
             optional:false, name:"record", defaultValue:null, type:"number | Object"},
            {description:"colNum of the cell. Only required if the first parameter is                              a rowNum",
             optional:false, name:"colNum", defaultValue:null, type:"number"}
        ],
        returns:{description:"Current edit value, or underlying value for the cell.", type:"any"},
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["editing"]
    },
    "attr:Slider.trackImageType":{
        ref:"attr:Slider.trackImageType",
        flags:"IRW",
        description:"The imageType setting for the slider track.",
        name:"trackImageType",
        seeAlso:[
            {ref:"type:ImageStyle", description:null},
            {ref:"attr:StretchImg.imageType", description:null}
        ],
        valueType:"ImageStyle",
        defaultValue:"\"stretch\"",
        type:"attr",
        definingClass:"class:Slider"
    },
    "attr:FilterBuilder.radioOptions":{
        ref:"attr:FilterBuilder.radioOptions",
        flags:"IR",
        description:"Logical operators to allow if we have a ${isc.DocUtils.linkForRef('type:TopOperatorAppearance')} of \"radio\".",
        name:"radioOptions",
        seeAlso:[],
        valueType:"Array of OperatorId",
        defaultValue:"[\"and\", \"or\", \"not\"]",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "attr:TreeNode.id":{
        ref:"attr:TreeNode.id",
        flags:"IR",
        description:"Specifies the unique ID of this node.  \n <P>\n Required for trees with ${isc.DocUtils.linkForRef('attr:Tree.modelType')} \"parent\".  With modelType:\"parent\", the unique\n ID of a node, together with the unique ID of its parent (see ${isc.DocUtils.linkForRef('attr:TreeNode.parentId')}) is\n used by ${isc.DocUtils.linkForRef('method:Tree.linkNodes')} to link a list of nodes into a tree.\n <p>\n Note: the name of this property can be changed by setting ${isc.DocUtils.linkForRef('attr:Tree.idField')}.",
        name:"id",
        seeAlso:[
            {ref:"attr:TreeNode.parentId", description:null},
            {ref:"method:Tree.linkNodes", description:null},
            {ref:"attr:Tree.modelType", description:null},
            {ref:"attr:Tree.idField", description:null}
        ],
        valueType:"String or Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:TreeNode"
    },
    "attr:FormItem.filterLocally":{
        ref:"attr:FormItem.filterLocally",
        flags:"IRA",
        description:"If this form item is mapping data values to a display value by fetching them from a \n dataSource (see ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')}, ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} \n and ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues')}), setting this property to true ensures that when\n the form item value is set, entire data-set from the dataSource is loaded at once and \n used as a valueMap, rather than just loading the display value for the current value.\n This avoids the need to perform fetches each time setValue() is called with a new value.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:PickList.filterLocally')} for behavior on form items such as SelectItems\n that show pick-lists.",
        name:"filterLocally",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["display_values"]
    },
    "attr:OperationBinding.qualifyColumnNames":{
        ref:"attr:OperationBinding.qualifyColumnNames",
        flags:"IR",
        description:"Specifies, for this specific operationBinding, whether to qualify column names with table\n names in any SQL we generate.  Overrides the ${isc.DocUtils.linkForRef('attr:DataSource.qualifyColumnNames')} property.\n Only applicable to dataSources of ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"sql\".",
        name:"qualifyColumnNames",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:OperationBinding"
    },
    "attr:Canvas.matchElement":{
        ref:"attr:Canvas.matchElement",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} is specified, should this canvas initially be drawn\n at the same dimensions as the htmlElement?<br>\n Note: setting this property will not force the canvas to resize if the element\n subsequently resizes (for example due to page reflow).",
        name:"matchElement",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas"
    },
    "method:CubeGrid.getSelectedCellIds":{
        ref:"method:CubeGrid.getSelectedCellIds",
        flags:"",
        description:"\n  return an array of the IDs of all selected cell records\n\n  <br><i>methodType</i> getter\n",
        name:"getSelectedCellIds",
        seeAlso:[],
        returns:{description:"array of the selected cell IDs", type:"Array"},
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "attr:ListGrid.bodyStyleName":{
        ref:"attr:ListGrid.bodyStyleName",
        flags:"IR",
        description:"CSS style used for the body of this grid.  If applying a background-color to the body\n via a CSS style applied using this property, be sure to set \n ${isc.DocUtils.linkForRef('attr:ListGrid.bodyBackgroundColor')} to <code>null</code>.",
        name:"bodyStyleName",
        setter:["setBodyStyleName"],
        seeAlso:[],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["appearance"]
    },
    "method:List.getValueMap":{
        ref:"method:List.getValueMap",
        flags:"",
        description:" Get a map of the form <code>{ item[idField] -&gt; item[displayField] }</code>, for all \n items in the list.  Note that if more than one item has the same <code>idProperty</code>, \n the value for the later item in the list will clobber the value for the earlier item.\n\n",
        name:"getValueMap",
        seeAlso:[],
        params:[
            {description:"Property to use as ID (data value) in the valueMap", optional:false,
             name:"idField", defaultValue:null, type:"string"},
            {description:"Property to use a display value in the valueMap", optional:false,
             name:"displayField", defaultValue:null, type:"string"}
        ],
        returns:{description:"valueMap object", type:"object"},
        type:"method",
        definingClass:"interface:List"
    },
    "method:ListGrid.recordClick":{
        ref:"method:ListGrid.recordClick",
        flags:"",
        description:" Executed when the listGrid receives a 'click' event on an enabled, non-separator\n record. The default implementation does nothing -- override to perform some action\n when any record or field is clicked.<br>\n A record event handler can be specified either as\n a function to execute, or as a string of script to evaluate. If the handler is defined\n as a string of script, all the parameters below will be available as variables for use\n in the script.<br>\n	To do something specific if a particular field is clicked, add a recordClick\n	method or string of script to that field (same parameters) when you're setting up\n	the list.<br>\n	<b>Notes:</b><ul>\n  <li>This will not be called if the click is below the last item of the list.</li>\n  <li>This method is called from the default implementaiton of\n  ${isc.DocUtils.linkForRef('method:ListGrid.rowClick')}, so if that method is overridden\n  this method may not be fired.</li></ul>\n",
        name:"recordClick",
        seeAlso:[
            {ref:"method:ListGrid.rowClick", description:null}
        ],
        params:[
            {description:"the listGrid that contains the click event", optional:false, name:"viewer",
             defaultValue:null, type:"listGrid"},
            {description:"the record that was clicked on", optional:false, name:"record",
             defaultValue:null, type:"ListGridRecord"},
            {description:"number of the record clicked on in the current set of                                  displayed records (starts with 0)",
             optional:false, name:"recordNum", defaultValue:null, type:"number"},
            {description:"the field that was clicked on (field definition)", optional:false,
             name:"field", defaultValue:null, type:"ListGridField"},
            {description:"number of the field clicked on in the listGrid.fields                                  array",
             optional:false, name:"fieldNum", defaultValue:null, type:"number"},
            {description:"value of the cell (after valueMap, etc. applied)", optional:false,
             name:"value", defaultValue:null, type:"object"},
            {description:"raw value of the cell (before valueMap, etc applied)", optional:false,
             name:"rawValue", defaultValue:null, type:"object"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["events"]
    },
    "method:Menu.setItemTitle":{
        ref:"method:Menu.setItemTitle",
        flags:"",
        description:" Sets the title of a particular menu item to the string specified by newTitle and\n redraws the menu if necessary.\n\n",
        name:"setItemTitle",
        seeAlso:[],
        params:[
            {description:"MenuItem in question, or it's index", optional:false, name:"item",
             defaultValue:null, type:"MenuItem or number"},
            {description:"new title", optional:false, name:"newTitle", defaultValue:null, type:"string"}
        ],
        returns:{description:"true if the title was changed, and false otherwise", type:"boolean"},
        type:"method",
        definingClass:"class:Menu"
    },
    "attr:ServerObject.attributeScope":{
        ref:"attr:ServerObject.attributeScope",
        flags:"IR",
        description:"Specifies the scope in which the DMI instance is to be looked up.  Valid values are: \n <code>\"request\"</code>, <code>\"session\"</code>, and <code>\"application\"</code>.  If\n <code>attributeScope</code> is left out of the <code>ServerObject</code> definition, then\n all scopes are searched in the order in which they are listed above.\n <p>\n This attribute is consulted only when the value of ${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')} is\n <code>\"attribute\"</code>.",
        name:"attributeScope",
        seeAlso:[
            {ref:"attr:ServerObject.attributeName", description:null},
            {ref:"attr:ServerObject.lookupStyle", description:null}
        ],
        valueType:"\"request\"|\"session\"|\"application\"",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ServerObject"
    },
    "attr:ListGrid.groupByText":{
        ref:"attr:ListGrid.groupByText",
        flags:"IRWA",
        getter:["getGroupByText"],
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid and\n ${isc.DocUtils.linkForRef('attr:ListGrid.canGroupBy','this.canGroupBy')} is true, this string will be shown as the\n title for the menu item to toggle the group by setting for a field.\n <P>\n This is a dynamic string - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>viewer</code> available as a variable mapped to\n the ListGrid instance, and <code>field</code> as a variable pointing to the ListGrid field.\n <P>\n Default value returns \"Group by \" + the field's summary title.",
        name:"groupByText",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Group by \\${title}\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["i18nMessages"]
    },
    "classAttr:RPCRequest.useCursorTracker":{
        ref:"classAttr:RPCRequest.useCursorTracker",
        flags:"IRW",
        description:"If true, an image is shown to the right of the cursor when ${isc.DocUtils.linkForRef('attr:RPCRequest.promptStyle')} is\n set to \"cursor\", otherwise the cursor itself is modified via css to the value of\n ${isc.DocUtils.linkForRef('attr:RPCRequest.promptCursor')}.  The default is platform-dependent.  In Safari, IE 5.5 and\n Firefox 1.0 the default is true, on all other platforms it is false.  The reason for this\n split is that the above browsers require that the cursor move before CSS settings are\n re-evaluated - this means the progress cursor can stick until the user moves the mouse.\n <p>\n If left unspecified, the default value is set by ${isc.DocUtils.linkForRef('classAttr:RPCManager.useCursorTracker')}.",
        name:"useCursorTracker",
        seeAlso:[
            {ref:"classAttr:RPCManager.useCursorTracker", description:null}
        ],
        valueType:"boolean",
        defaultValue:"platform-dependent",
        type:"classAttr",
        definingClass:"class:RPCRequest",
        groups:["rpcPrompt"]
    },
    "attr:TreeGrid.showDropIcons":{
        ref:"attr:TreeGrid.showDropIcons",
        flags:"IRW",
        description:"If true, when the user drags a droppable target over a folder in this TreeGrid, show \n a different icon folder icon.\n This is achieved by appending the ${isc.DocUtils.linkForRef('attr:TreeGrid.dropIconSuffix')} onto the\n ${isc.DocUtils.linkForRef('attr:TreeGrid.folderIcon')} URL (for example <code>\"[SKIN]/folder.gif\"</code> may be\n replaced by <code>\"[SKIN]/folder_drop.gif\"</code>).",
        name:"showDropIcons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('nodeTitles')}"],
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "method:Applet.getPluginHandle":{
        ref:"method:Applet.getPluginHandle",
        flags:"A",
        description:" \n  Returns a handle to the applet DOM element (valid only after the component has been drawn).  \n\n",
        name:"getPluginHandle",
        seeAlso:[],
        type:"method",
        definingClass:"class:Applet"
    },
    "attr:Canvas.cursor":{
        flags:"IRWA",
        type:"attr",
        ref:"attr:Canvas.cursor",
        description:"Specifies the cursor image to display when the mouse pointer is\n      over this widget. It corresponds to the CSS cursor attribute. See Cursor type for\n      different cursors.",
        name:"cursor",
        setter:["setCursor"],
        valueType:"Cursor",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('dragCreate')}", 
         "${isc.DocUtils.linkForExampleId('cursors')}"],
        defaultValue:"Canvas.DEFAULT",
        groups:["cues"],
        definingClass:"class:Canvas"
    },
    "method:TileGrid.filterData":{
        ref:"method:TileGrid.filterData",
        flags:"",
        description:" Retrieves data that matches the provided criteria and displays the matching data in this\n component.\n <P>\n This method behaves exactly like ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} except that\n ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')} is automatically set to \"substring\" so that String-valued\n fields are matched by case-insensitive substring comparison.\n\n",
        name:"filterData",
        seeAlso:[],
        params:[
            {description:"Search criteria.                       If a ${isc.DocUtils.linkForRef('class:DynamicForm')} is passed in as this argument\n                      instead of a raw criteria object, will be derived by calling\n                      ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}",
             optional:true, name:"criteria", defaultValue:null, type:"Criteria"},
            {description:"callback to invoke when a fetch is complete.  Fires                                          only if server contact was required; see\n                                          ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} for details",
             optional:true, name:"callback", defaultValue:null, type:"DSCallback"},
            {description:"for databound components only - optional                            additional properties to set on the DSRequest that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:["dataBoundComponentMethods"]
    },
    "attr:FormulaBuilder.autoTestDelay":{
        ref:"attr:FormulaBuilder.autoTestDelay",
        flags:"IRWA",
        description:"When ${isc.DocUtils.linkForRef('attr:FormulaBuilder.autoTest')} is true, this property indicates the delay in \n milliseconds between a user pausing and ${isc.DocUtils.linkForRef('method:FormulaBuilder.testFunction','testFunction()')}\n being called.\n <P>\n The default is 200 milliseconds.",
        name:"autoTestDelay",
        seeAlso:[],
        valueType:"integer",
        defaultValue:"200",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["formulaFields"]
    },
    "method:StretchImgButton.getState":{
        ref:"method:StretchImgButton.getState",
        flags:"",
        description:" Return the state of this StatefulCanvas\n",
        name:"getState",
        seeAlso:[],
        returns:{description:null, type:"State"},
        type:"method",
        definingClass:"class:StretchImgButton",
        groups:["state"]
    },
    "classMethod:Class.getStackTrace":{
        ref:"classMethod:Class.getStackTrace",
        flags:"",
        description:" Returns a \"stack trace\" - one line per method in the current call stack, showing the method\n name and any parameters passed.\n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.getStackTrace\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n <P>\n This API can currently only be supported in Internet Explorer.  See\n ${isc.DocUtils.linkForRef('group:debugging')} for information on how to get equivalent information from other\n browsers.\n\n",
        name:"getStackTrace",
        seeAlso:[],
        returns:{description:"stack trace.  Use eg ${isc.DocUtils.linkForRef('method:Class.logWarn')} to log to the Developer Console.",
         type:"String"},
        type:"classMethod",
        definingClass:"class:Class",
        groups:["debug"]
    },
    "method:DataSource.fetchData":{
        ref:"method:DataSource.fetchData",
        flags:"",
        description:" Perform a \"fetch\" DataSource operation against this DataSource, sending search criteria\n and retrieving matching records.\n <P>\n In contrast to ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')}, which creates a ${isc.DocUtils.linkForRef('class:ResultSet')} to manage\n the returned data, calling <code>dataSource.fetchData()</code> provides the returned\n data in the callback as a simple JavaScript Array of JavaScript Objects.  Calling\n <code>dataSource.fetchData()</code> does not automatically update any visual components or\n caches: code in the callback passed to <code>fetchData()</code> decides what to do with\n the returned data. \n <P>\n For example, given a ListGrid \"myGrid\" and a DataSource \"employees\", the following code\n would populate \"myGrid\" with data fetched from the DataSource:\n <pre>\n    isc.DataSource.get(\"employees\").fetchData(null, \"myGrid.setData(data)\");\n </pre>\n Unlike calling <code>myGrid.fetchData()</code>, which creates a ${isc.DocUtils.linkForRef('class:ResultSet')}, the\n data provided to the grid is \"disconnected\" data, unmanaged by SmartClient's databinding\n facilities and safe to directly modify.  This is useful when, for example, a ListGrid is\n being used as a more sophisticated version of HTML's multi-select component.\n <P>\n Disconnected datasets may be used to populate various visual components.  For example,\n while an individual FormItem can be configured to fetch\n ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')} options from a DataSource via the\n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')} property, the following code shows\n storing a dataset to derive valueMaps from later:\n <pre>\n    isc.DataSource.get(\"countries\").fetchData(null, \"window.countries = data\");\n\n    ... later, a form is created dynamically ...\n\n    function showForm() {\n       isc.DynamicForm.create({\n           items : [\n              { name:\"country\", title:\"Pick Country\",\n                valueMap: window.countries.getValueMap(\"countryId\", \"countryName\")\n              },\n       ...\n </pre>\n <P>\n You can also create a ResultSet from the data retrieved from <code>fetchData()</code>,\n like so:\n <pre>\n    isc.DataSource.get(\"countries\").fetchData(null,\n        function (dsResponse, data) {\n           isc.ResultSet.create({\n              dataSource:\"countries\",\n              allRows:data\n           })\n        }\n    )\n </pre>\n <P>\n This gives you a dataset that supports client-side filtering (via\n ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria','setCriteria()')}), can provide \n ${isc.DocUtils.linkForRef('method:ResultSet.getValueMap','filtered valueMaps')}, will \n ${isc.DocUtils.linkForRef('attr:ResultSet.disableCacheSync','automatically reflect updates')} to the DataSource made via\n other components, and can be re-used with multiple visual components.\n <P>\n See also the server-side com.isomorphic.js.JSTranslater class in the\n ${isc.DocUtils.linkForDocNode('javaServerReference', 'Java Server Reference')} for other, similar approaches\n involving dumping data into the page during initial page load.  <b>Note:</b> care should\n be taken when using this approach.  Large datasets degrade the basic performance of some\n browsers, so use ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource','optionDataSource')} and similar\n facilities to manage datasets that may become very large.\n <P>\n <b>Data-Driven Visual Component Creation</b>\n <P>\n <code>DataSource.fetchData()</code> can also be used to create SmartClient components in\n a data-driven way.  Many properties on SmartClient visual components are configured via\n an Array of Objects - the same data format that <code>dataSource.fetchData()</code>\n returns.  These include ${isc.DocUtils.linkForRef('attr:ListGrid.fields')}, ${isc.DocUtils.linkForRef('attr:TabSet.tabs')},\n ${isc.DocUtils.linkForRef('attr:DynamicForm.items')}, ${isc.DocUtils.linkForRef('attr:Facet.values')} and even ${isc.DocUtils.linkForRef('attr:DataSource.fields')}.\n <P>\n For example, if you had a DataSource \"myFormFields\" whose fields included the\n basic properties of ${isc.DocUtils.linkForRef('class:FormItem','FormItems')} (name, title, type, etc), this example\n code would create a form based on stored field definitions, loaded from the\n \"myFormFields\" DataSource on the fly:\n <pre>\n    isc.DataSource.get(\"myFormFields\").fetchData(null, \n        \"isc.DynamicForm.create({ items:data })\"\n    )\n </pre>\n This capability to dynamically create visual components from dynamically fetched data\n provides a foundation for creating interfaces that can be customized by end users.\n See also ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')}.\n\n",
        name:"fetchData",
        seeAlso:[],
        params:[
            {description:"search criteria", optional:true, name:"criteria", defaultValue:null,
             type:"Criteria"},
            {description:"callback to invoke on completion", optional:true, name:"callback",
             defaultValue:null, type:"DSCallback"},
            {description:"additional properties to set on                                                       the DSRequest that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest Properties"}
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:["operations"]
    },
    "classAttr:Log.defaultPriority":{
        ref:"classAttr:Log.defaultPriority",
        flags:"IRWA",
        getter:["getDefaultPriority"],
        description:"Any logs below this priority will be suppressed, unless a more specific setting exists for\n the category.",
        name:"defaultPriority",
        setter:["setDefaultPriority"],
        seeAlso:[
            {ref:"classMethod:Log.setPriority", description:null}
        ],
        valueType:"LogPriority",
        defaultValue:"Log.WARN",
        type:"classAttr",
        definingClass:"class:Log"
    },
    "classAttr:Operators.notEqualTitle":{
        ref:"classAttr:Operators.notEqualTitle",
        flags:"IR",
        description:"Title for the \"notEqual\" operator",
        name:"notEqualTitle",
        seeAlso:[],
        valueType:"String",
        defaultValue:"\"not equal\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:["i18nMessages"]
    },
    "attr:DateChooser.todayButtonTitle":{
        ref:"attr:DateChooser.todayButtonTitle",
        flags:"IRW",
        description:"Title for \"Today\" button.",
        name:"todayButtonTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Today\"",
        type:"attr",
        definingClass:"class:DateChooser",
        groups:["i18nMessages"]
    },
    "method:ListGrid.cellOut":{
        ref:"method:ListGrid.cellOut",
        flags:"",
        description:" Called when the mouse pointer leaves a cell\n\n",
        name:"cellOut",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        definingClass:"class:ListGrid",
        groups:["events"]
    },
    "attr:Canvas.skinImgDir":{
        ref:"attr:Canvas.skinImgDir",
        flags:"IRWA",
        description:"Default directory for skin images (those defined by the class), relative to the\n Page-wide ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','skinDir')}.",
        name:"skinImgDir",
        seeAlso:[],
        valueType:"URL",
        defaultValue:"\"images/\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["images"]
    },
    "attr:CubeGrid.facetValueHoverWidth":{
        ref:"attr:CubeGrid.facetValueHoverWidth",
        flags:"IRWA",
        description:"If specified and <code>this.showHover</code> is true, this is the default width to apply\n to hover tips shown for facetValues. If unset, hover canvas will be sized to \n <code>this.hoverWidth</code> if specified instead.",
        name:"facetValueHoverWidth",
        seeAlso:[
            {ref:"attr:Canvas.hoverWidth", description:null}
        ],
        valueType:"measure",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["hoverTips"]
    },
    "method:TreeGrid.setViewState":{
        ref:"method:TreeGrid.setViewState",
        flags:"",
        description:" Overridden to take a ${isc.DocUtils.linkForRef('type:treeGridViewState')} object.\n\n",
        name:"setViewState",
        seeAlso:[
            {ref:"method:TreeGrid.getViewState", description:null}
        ],
        params:[
            {description:"Object describing the desired view state for the grid", optional:false,
             name:"viewState", defaultValue:null, type:"treeGridViewState"}
        ],
        type:"method",
        definingClass:"class:TreeGrid",
        groups:["viewState"]
    },
    "classAttr:Dialog.NO_BUTTON_TITLE":{
        ref:"classAttr:Dialog.NO_BUTTON_TITLE",
        flags:"IRW",
        description:"Title for the <code>\"No\"</code> button.",
        name:"NO_BUTTON_TITLE",
        seeAlso:[
            {ref:"type:DialogButtons", description:null}
        ],
        valueType:"HTML",
        defaultValue:"\"No\"",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:["i18nMessages"]
    },
    "attr:StretchImgButton.src":{
        ref:"attr:StretchImgButton.src",
        flags:"IRW",
        description:"Base URL for the image.  By default, StretchImgButtons consist of three image parts: A\n start image (displayed at the top or left), a scaleable central image and an end image\n displayed at the bottom or right.\n <P>\n The images displayed in the stretchImgButton are derived from this property in the \n following way:\n <P>\n <ul>\n <li> When the button is in its standard state the suffixes \"_start\", \"_end\" and \n      \"_stretch\" are applied to the src (before the file extension), so by default \n      the images displayed will be \"button_start.gif\" (sized to be \n      <code>this.capSize</code> by the specified width of the stretchImgButton), \n      \"button_stretch.gif\" (stretched to the necessary width) and \"button_end.gif\" \n      (sized the same as the start image).\n <li> As the button's state changes, the images will have suffixes appended <b>before</b>\n      the \"_start\" / \"_end\" / \"_stretch\" to represent the button state. Possible states \n      are \"Down\", \"Over\", \"Selected\" \"Focused\" and \"Disabled\". Note that \"Selected\" and\n      \"Focused\" are compound states which may be applied in addition to \"Down\" etc.\n </ul>\n For example the center piece of a selected stretchImgButton with the mouse hovering\n over it might have the URL: <code>\"button_Selected_Down_stretch.gif\"</code>.\n <P>\n Media should be present for each possible state of the _start, _end and _stretch images.",
        name:"src",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"button.gif\"",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "attr:Calendar.addEventButtonHoverText":{
        ref:"attr:Calendar.addEventButtonHoverText",
        flags:"IR",
        description:"The text to be displayed when a user hovers over the ${isc.DocUtils.linkForRef('attr:Calendar.addEventButton','add event')}\n toolbar button",
        name:"addEventButtonHoverText",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Add an event\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["i18nMessages"]
    },
    "method:Calendar.setShowWeekends":{
        ref:"method:Calendar.setShowWeekends",
        flags:"",
        description:"  Setter for ${isc.DocUtils.linkForRef('attr:Calendar.showWeekends')} to change this property at runtime.\n\n",
        name:"setShowWeekends",
        seeAlso:[],
        type:"method",
        definingClass:"class:Calendar"
    },
    "method:Canvas.animateScroll":{
        ref:"method:Canvas.animateScroll",
        flags:"",
        description:" Animate a scroll from the current scroll position to the specified position.\n",
        name:"animateScroll",
        seeAlso:[],
        params:[
            {description:"desired final left scroll postion", optional:false, name:"scrollLeft",
             defaultValue:null, type:"number"},
            {description:"desired final top scroll postion", optional:false, name:"scrollTop",
             defaultValue:null, type:"number"},
            {description:"When the scroll completes this callback will be fired. Single                              'earlyFinish' parameter will be passed if the animation was\n                              cut short by a call to finishAnimation",
             optional:true, name:"callback", defaultValue:null, type:"callback"},
            {description:"Duration in ms of the animated scroll", optional:true, name:"duration",
             defaultValue:null, type:"number"},
            {description:"Optional acceleration to bias the animation ratios", optional:true,
             name:"acceleration", defaultValue:null, type:"AnimationAcceleration"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "attr:Button.autoFit":{
        flags:"IRW",
        type:"attr",
        ref:"attr:Button.autoFit",
        description:"If true, ignore the specified size of this widget and always size just large\n enough to accomodate the title.  If <code>setWidth()</code> is explicitly called on an\n autoFit:true button, autoFit will be reset to <code>false</code>.\n <P>\n Note that for StretchImgButton instances, autoFit will occur horizontally only, as \n unpredictable vertical sizing is likely to distort the media. If you do want vertical \n auto-fit, this can be achieved by simply setting a small height, and having \n overflow:\"visible\"",
        name:"autoFit",
        setter:["setAutoFit"],
        valueType:"boolean",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('buttonAutoFit')}"],
        defaultValue:"null",
        groups:["sizing"],
        definingClass:"class:Button"
    },
    "attr:ListGrid.autoFitMaxHeight":{
        ref:"attr:ListGrid.autoFitMaxHeight",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code> this\n property provides an upper limit on how far the ListGrid will expand vertically to accomodate\n its content. If content exceeds this height, scrollbars will be introduced as usual.  \n In addition to this property, ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxRecords')} allows you to limit vertical\n expansion based on the number of rows to be rendered.",
        name:"autoFitMaxHeight",
        setter:["setAutoFitMaxHeight"],
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["autoFitData"]
    },
    "method:Tree.add":{
        ref:"method:Tree.add",
        flags:"",
        description:"\n Add a single node under the specified parent\n\n",
        name:"add",
        seeAlso:[
            {ref:"group:sharingNodes", description:null},
            {ref:"method:Tree.addList", description:null}
        ],
        params:[
            {description:"node to add", optional:false, name:"node", defaultValue:null, type:"TreeNode"},
            {description:"Parent of the node being added.  You can pass                                          in either the ${isc.DocUtils.linkForRef('object:TreeNode')} itself, or a path to\n	                                        the node (as a String), in which case a\n	                                        ${isc.DocUtils.linkForRef('method:Tree.find')} is performed to find\n	                                        the node.",
             optional:false, name:"parent", defaultValue:null, type:"String or TreeNode"},
            {description:"Position of the new node in the children list. If not	                                specified, the node will be added at the end of the list.",
             optional:true, name:"position", defaultValue:null, type:"number"}
        ],
        returns:{description:"The added node. Will return null if the node was not added (typically    because the specified <code>parent</code> could not be found in the tree).",
         type:"TreeNode or null"},
        type:"method",
        definingClass:"class:Tree"
    },
    "method:ImgButton.deselect":{
        ref:"method:ImgButton.deselect",
        flags:"",
        description:" Select this object.\n",
        name:"deselect",
        seeAlso:[],
        type:"method",
        definingClass:"class:ImgButton",
        groups:["state"]
    },
    "attr:TileGrid.tileValueStyle":{
        ref:"attr:TileGrid.tileValueStyle",
        flags:"IR",
        description:"When using the default ${isc.DocUtils.linkForRef('class:SimpleTile')}, CSS style for each value shown within a tile.",
        name:"tileValueStyle",
        seeAlso:[],
        valueType:"CSSClassName",
        defaultValue:"\"tileValue\"",
        type:"attr",
        definingClass:"class:TileGrid"
    },
    "attr:MenuItem.keys":{
        ref:"attr:MenuItem.keys",
        flags:"IR",
        description:"Shortcut key(s) to fire the menu item action. Each key can be defined as a ${isc.DocUtils.linkForRef('type:KeyIdentifier')}.\n To apply multiple shortcut keys to this item, set this property to an array of such key\n identifiers.",
        name:"keys",
        seeAlso:[],
        valueType:"KeyIdentifier | Array of KeyIdentifer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MenuItem",
        groups:["menuKeys"]
    },
    "attr:Tab.title":{
        ref:"attr:Tab.title",
        flags:"IRW",
        description:"Specifies the title of the this tab.  To change the title after the TabSet has been\n created, call ${isc.DocUtils.linkForRef('method:TabSet.setTabTitle')}.",
        name:"title",
        seeAlso:[
            {ref:"method:TabSet.setTabTitle", description:null}
        ],
        valueType:"HTML",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Tab"
    },
    "attr:Calendar.nextButton":{
        ref:"attr:Calendar.nextButton",
        flags:"IR",
        description:"The nextButton is an ImgButton that appears above the week/day/month views of the\n calendar and allows the user to move the calendar forwards in time.",
        name:"nextButton",
        seeAlso:[],
        valueType:"AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "group:sorting":{
        ref:"group:sorting",
        refs:["method:ResultSet.sortByProperty", "method:Array.sortByProperty", "method:Array.unsort", 
         "method:List.sortByProperty","method:ListGridField.sortNormalizer", "method:ListGrid.headerClick", 
         "method:ListGrid.unsort","method:ListGrid.sort", "classMethod:Array.compareAscending", 
         "classMethod:Array.compareDescending","attr:ListGridField.canSort", "attr:ListGridField.sortDirection", "attr:ListGrid.canSort", 
         "attr:ListGrid.sortFieldNum","attr:ListGrid.sortField", "attr:ListGrid.sortDirection", "attr:ListGrid.showSortArrow", 
         "attr:ListGrid.canPickFields","type:SortDirection", "type:SortArrow"],
        description:null,
        name:"sorting",
        seeAlso:[],
        type:"group"
    },
    "method:TreeGrid.transferSelectedData":{
        ref:"method:TreeGrid.transferSelectedData",
        flags:"",
        description:" Simulates a drag / drop type transfer of the selected records in some other grid to this\n treeGrid, without requiring any user interaction.<br>\n See the ${isc.DocUtils.linkForRef('group:dragging')} documentation for an overview of grid drag/drop data\n transfer.\n",
        name:"transferSelectedData",
        seeAlso:[],
        params:[
            {description:"source grid from which the records will be tranferred", optional:false,
             name:"sourceGrid", defaultValue:null, type:"ListGrid"},
            {description:"parent node into which records should be dropped - if null    records will be transferred as children of the root node.",
             optional:true, name:"folder", defaultValue:null, type:"TreeNode"},
            {description:"target index (drop position) within the parent folder", optional:true,
             name:"index", defaultValue:null, type:"integer"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('dragTree')}"],
        definingClass:"class:TreeGrid",
        groups:["dragging"]
    },
    "attr:Calendar.showTimelineView":{
        ref:"attr:Calendar.showTimelineView",
        flags:"IRW",
        description:"If set to true, show the Timeline view.",
        name:"showTimelineView",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "group:cellStyling":{
        ref:"group:cellStyling",
        refs:["attr:CubeGrid.baseStyle", "attr:GridRenderer.cellHeight", 
         "attr:GridRenderer.fixedRowHeights","attr:GridRenderer.wrapCells", "attr:GridRenderer.cellPadding", 
         "attr:GridRenderer.baseStyle","attr:GridRenderer.alternateRowStyles", "attr:GridRenderer.alternateRowFrequency", 
         "attr:GridRenderer.emptyCellValue","attr:ListGrid.emptyCellValue", "attr:ListGrid.cellHeight", 
         "attr:ListGrid.fixedRecordHeights","attr:ListGrid.wrapCells", "attr:ListGrid.cellPadding", "attr:ListGrid.baseStyle", 
         "attr:ListGrid.alternateRecordStyles","attr:ListGrid.alternateRecordFrequency"],
        name:"cellStyling",
        seeAlso:[],
        type:"group"
    },
    "attr:DataBoundComponent.fetchOperation":{
        ref:"attr:DataBoundComponent.fetchOperation",
        flags:"IRW",
        description:"Operation ID this component should use when performing fetch operations.",
        name:"fetchOperation",
        seeAlso:[
            {ref:"attr:DSRequest.operationId", description:null}
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:["operations"]
    },
    "attr:TileGrid.dragDataAction":{
        ref:"attr:TileGrid.dragDataAction",
        flags:"IRW",
        description:"Indicates what to do with data dragged into another DataBoundComponent. See\n          DragDataAction type for details.",
        name:"dragDataAction",
        seeAlso:[],
        valueType:"DragDataAction",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('gridsDragMove')}", 
         "${isc.DocUtils.linkForExampleId('gridsDragCopy')}"],
        definingClass:"class:TileGrid",
        groups:["dragging"]
    },
    "attr:ListGrid.frozenHeaderTitleStyle":{
        ref:"attr:ListGrid.frozenHeaderTitleStyle",
        flags:"IR",
        description:"If this listGrid contains any frozen fields, this property can be used to apply a custom\n headerTitleStyle to the frozen fields set of fields. If unset, the standard headerTitleStyle\n will be used for both frozen and unfrozen cells.",
        name:"frozenHeaderTitleStyle",
        seeAlso:[
            {ref:"attr:ListGrid.headerTitleStyle", description:null},
            {ref:"attr:ListGridField.frozen", description:null}
        ],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["gridHeader", "appearance", "frozenFields"]
    },
    "method:ListGrid.hideField":{
        ref:"method:ListGrid.hideField",
        flags:"",
        description:" Force a field to be hidden.<br><br>\n\n NOTE: If a field.showIf expression exists, it will be destroyed.\n \n",
        name:"hideField",
        seeAlso:[],
        params:[
            {description:"field to hide", optional:false, name:"field", defaultValue:null,
             type:"field name or ListGridField"},
            {description:"if passed, don't relayout non-explicit sized fields                                       to fit the available space",
             optional:true, name:"suppressRelayout", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('columnOrder')}"],
        definingClass:"class:ListGrid"
    },
    "method:Canvas.getOffsetX":{
        ref:"method:Canvas.getOffsetX",
        flags:"",
        description:"	Return the X-coordinate of the last event relative to the left edge of the content of this\n	Canvas.<br><br>\n\n  NOTE: To get a coordinate relative to the <b>viewport</b> of this Canvas, subtract\n  this.getScrollLeft()\n\n",
        name:"getOffsetX",
        seeAlso:[],
        returns:{description:null, type:"number"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["events", "positioning"]
    },
    "attr:Canvas.animateMoveAcceleration":{
        ref:"attr:Canvas.animateMoveAcceleration",
        flags:"IRWA",
        description:"Default acceleration effect for performing an animated move.  If unset, \n <code>this.animateAcceleration</code> will be used by default instead",
        name:"animateMoveAcceleration",
        seeAlso:[],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "method:Canvas.getOffsetY":{
        ref:"method:Canvas.getOffsetY",
        flags:"",
        description:"	Return the Y-coordinate of the last event, relative to the top edge of the content of this\n	Canvas.<br><br>\n\n  NOTE: To get a coordinate relative to the <b>viewport</b> of this Canvas, subtract\n  this.getScrollTop()\n\n",
        name:"getOffsetY",
        seeAlso:[],
        returns:{description:null, type:"number"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["events", "positioning"]
    },
    "method:Calendar.dateChanged":{
        ref:"method:Calendar.dateChanged",
        flags:"",
        description:" Fires whenever the user changes the current date, including picking a specific date or\n navigating to a new week or month.\n",
        name:"dateChanged",
        seeAlso:[],
        type:"method",
        definingClass:"class:Calendar"
    },
    "method:CubeGrid.resizeFacetValue":{
        ref:"method:CubeGrid.resizeFacetValue",
        flags:"",
        description:" Resizes all columns for the provided facetValueId, which must be a facetValueId from the\n innermost column facet.\n\n",
        name:"resizeFacetValue",
        seeAlso:[],
        params:[
            {description:"facetValueId of columns to be resized", optional:false, name:"facetValueId",
             defaultValue:null, type:"id"},
            {description:"column's new width", optional:false, name:"newWidth", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "group:orientation":{
        ref:"group:orientation",
        refs:["type:Orientation"],
        name:"orientation",
        seeAlso:[],
        type:"group"
    },
    "attr:CubeGrid.facetValueAlign":{
        ref:"attr:CubeGrid.facetValueAlign",
        flags:"IRW",
        description:"default alignment for facet values (in headers)",
        name:"facetValueAlign",
        seeAlso:[],
        valueType:"alignEnum",
        defaultValue:"\"center\"",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["gridLayout"]
    },
    "attr:CheckboxItem.valueMap":{
        ref:"attr:CheckboxItem.valueMap",
        flags:"IRW",
        description:"Object defining how the checkbox \"checked\" state will be mapped to the field value.<br>\n Checkboxes only support 2 states. By default a checked checkbox will have\n value <code>true</code>, and an unchecked one will have value <code>false</code>\n (or <code>null</code> if there is no default value and the value has never been set).\n <p>\n A valueMap can modify this in 2 ways:<br>\n - If the desired checked/unchecked values can be resolved to <code>true</code> \n   and <code>false</code> directly in JavaScript, the valueMap may be specified as\n   a 2-element array containing these values. Examples of this woud include<br>\n   <code>&nbsp;&nbsp;[0,1]</code>: \n   In this case an unchecked checkbox would have value <code>0</code> and a checked box\n   would have value <code>1</code><br>\n   <code>&nbsp;&nbsp;[null,\"Some String\"]</code>:\n   In this case an unchecked checkbox would have value <code>null</code> and a checked \n    box would have value <code>\"Some String\"</code><br>\n - More arbitrary data values can be resolved to checked / unchecked values via an\n   object mapping the abitrary data values to display values of <code>true</code> and\n   <code>false</code>. For example:<br>\n   <code>&nbsp;&nbsp;{\"A\":false, \"B\":true}</code><br>\n    In this case an unchecked checkbox would have value \"A\", and a checked box \n    would have value \"B\"\n <p>\n Note: ValueMaps in other formats will be ignored by the CheckboxItem class. To update\n the valueMap at runtime, always use ${isc.DocUtils.linkForRef('method:CheckboxItem.setValueMap')}",
        name:"valueMap",
        setter:["setValueMap"],
        seeAlso:[],
        valueType:"object | Array",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CheckboxItem",
        groups:["valueMap"]
    },
    "group:containment":{
        ref:"group:containment",
        refs:["method:Canvas.addChild", "method:Canvas.removePeer", "method:Canvas.removeChild", 
         "method:Canvas.addPeer","method:Canvas.getParentElements", "method:Canvas.contains", "attr:Canvas.parentElement", 
         "attr:Canvas.topElement","attr:Canvas.masterElement", "attr:Canvas.children", "attr:Canvas.peers"],
        description:"Canvases containing other objects as children or peers",
        name:"containment",
        seeAlso:[],
        type:"group"
    },
    "classAttr:Array.CASE_INSENSITIVE":{
        ref:"classAttr:Array.CASE_INSENSITIVE",
        flags:null,
        description:"This is a built-in comparator for the ${isc.DocUtils.linkForRef('method:Array.find','find')} and ${isc.DocUtils.linkForRef('method:Array.findIndex','findIndex')}\n methods of Array.  Passing this comparator to those methods will find case-insensitively,\n so, eg, <code>find(\"foo\", \"bar\")</code> would find objects with a \"foo\" property set to \n \"Bar\", \"BAR\" or \"bar\"",
        name:"CASE_INSENSITIVE",
        seeAlso:[],
        valueType:"Function",
        defaultValue:"See below",
        type:"classAttr",
        definingClass:"object:Array"
    },
    "method:DynamicForm.editNewRecord":{
        ref:"method:DynamicForm.editNewRecord",
        flags:"",
        description:"\n Prepare to edit a new record by clearing the current set of values (or replacing them \n with initialValues if specified).\n <br>\n This method will also call ${isc.DocUtils.linkForRef('method:DynamicForm.setSaveOperationType')} to ensure\n subsequent calls to <code>saveData()</code> will use an <code>add</code> rather than\n an <code>update</code> operation.\n\n",
        name:"editNewRecord",
        seeAlso:[
            {ref:"method:DynamicForm.saveData", description:null}
        ],
        params:[
            {description:"initial set of values for the editor as a map of field names to their corresponding\n     values",
             optional:true, name:"initialValues", defaultValue:null, type:"object"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["dataBoundComponentMethods"]
    },
    "group:creation":{
        ref:"group:creation",
        refs:[],
        name:"creation",
        seeAlso:[],
        type:"group"
    },
    "method:SliderItem.setMaxValue":{
        ref:"method:SliderItem.setMaxValue",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.maxValue','maximum value')} of the slider \n\n",
        name:"setMaxValue",
        seeAlso:[],
        params:[
            {description:"the new maximum value", optional:false, name:"newValue", defaultValue:null,
             type:"float"}
        ],
        type:"method",
        definingClass:"class:SliderItem"
    },
    "classMethod:Page.getScrollLeft":{
        ref:"classMethod:Page.getScrollLeft",
        flags:"",
        description:"		Get the amount that the browser window has been scrolled horizontally.\n",
        name:"getScrollLeft",
        seeAlso:[],
        returns:{description:"horizontal scroll amount", type:"number"},
        type:"classMethod",
        definingClass:"class:Page",
        groups:["sizing"]
    },
    "class:SectionItem":{
        exampleConfig:"SectionItem.xml",
        methods:["method:SectionItem.expandSection", "method:SectionItem.collapseSection"],
        type:"class",
        ref:"class:SectionItem",
        classAttrs:[],
        treeLocation:["Client Reference/Forms/Form Items"],
        classMethods:[],
        description:"Header item for a collapsable section in a ${isc.DocUtils.linkForRef('class:DynamicForm')}.  Each <code>SectionItem</code>\n is associated with a number of other <code>item</code>s in the form, which will be shown or\n hidden as a group when the section is expanded or collapsed.  Clicking on a\n <code>SectionItem</code> will expand or collapse the section.\n <P>\n To make a form where only one section is expanded at a time, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.sectionVisibilityMode')} to \"mutex\".",
        attrs:["attr:SectionItem.defaultValue", "attr:SectionItem.itemIds", 
         "attr:SectionItem.sectionVisible","attr:SectionItem.sectionExpanded", "attr:SectionItem.sectionHeaderClass", 
         "attr:SectionItem.canCollapse"],
        name:"SectionItem",
        seeAlso:[
            {ref:"attr:DynamicForm.sectionVisibilityMode", description:null}
        ],
        examples:["${isc.DocUtils.linkForExampleId('formSections')}"]
    },
    "attr:TileRecord.tileProperties":{
        ref:"attr:TileRecord.tileProperties",
        flags:"IRW",
        description:"Additional properties to be passed when creating a tile for this record.",
        name:"tileProperties",
        seeAlso:[],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:TileRecord"
    },
    "method:Layout.reflow":{
        ref:"method:Layout.reflow",
        flags:"A",
        description:" Layout members according to current settings.\n <P>\n Members will reflow automatically when the layout is resized, members resize, the list of\n members changes or members change visibility.  It is only necessary to manually call\n <code>reflow()</code> after changing settings on the layout, for example,\n <code>layout.reverseOrder</code>.\n\n",
        name:"reflow",
        seeAlso:[],
        params:[
            {description:"reason reflow() had to be called (appear in logs if enabled)",
             optional:true, name:"reason", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:Layout"
    },
    "method:TabSet.closeClick":{
        ref:"method:TabSet.closeClick",
        flags:"",
        description:" When ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')} is set, method fired when the user clicks the \"close\" icon for a\n tab.\n <P>\n Default implementation will remove the tab from the tabSet via ${isc.DocUtils.linkForRef('method:TabSet.removeTab')}.\n",
        name:"closeClick",
        seeAlso:[],
        params:[
            {description:"tab to close", optional:false, name:"tab", defaultValue:null, type:"Tab"}
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "class:RPCManager":{
        methods:[],
        ref:"class:RPCManager",
        classAttrs:["classAttr:RPCManager.defaultTimeout", "classAttr:RPCManager.defaultPrompt", 
         "classAttr:RPCManager.timeoutErrorMessage","classAttr:RPCManager.removeDataPrompt", "classAttr:RPCManager.saveDataPrompt", 
         "classAttr:RPCManager.promptStyle","classAttr:RPCManager.useCursorTracker", "classAttr:RPCManager.promptCursor", 
         "classAttr:RPCManager.fetchDataPrompt","classAttr:RPCManager.showPrompt", "classAttr:RPCManager.actionURL", 
         "classAttr:RPCManager.useXmlHttpRequest","classAttr:RPCManager.defaultTransport", "classAttr:RPCManager.credentialsURL"],
        classMethods:["classMethod:RPCManager.queueSent", "classMethod:RPCManager.xmlHttpRequestAvailable", 
         "classMethod:RPCManager.send","classMethod:RPCManager.sendProxied", "classMethod:RPCManager.sendRequest", 
         "classMethod:RPCManager.startQueue","classMethod:RPCManager.cancelQueue", "classMethod:RPCManager.clearTransaction", 
         "classMethod:RPCManager.suspendTransaction","classMethod:RPCManager.resendTransaction", "classMethod:RPCManager.sendQueue", 
         "classMethod:RPCManager.handleError","classMethod:RPCManager.handleTransportError", "classMethod:RPCManager.loginRequired"],
        treeLocation:["Client Reference/RPC"],
        attrs:[],
        description:"RPCManager is a static singleton class that manages transparent client/server RPC (remote\n procedure call).  This class provides a generic, low-level client/server communication\n integration point.  You can use it to send arbitrary data to a URL of your choosing on the\n server and optionally be called back with server-returned data when the server replies.  \n You can process the RPC request in a JSP, Servlet or Filter on the server.\n <P>\n SmartClient's powerful ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} automatically issue\n RPCs as necessary, based on the \n ${isc.DocUtils.linkForRef('group:dataSourceOperations','DataSource protocol')}.  To integrate DataBoundComponents\n with your server, ${isc.DocUtils.linkForRef('group:clientServerIntegration','start here')}.\n <P>\n <u>Simple example (client code):</u>\n <P><code>\n var data = { here: \"is some data\", to: [\"send to the server\"]};<br>\n RPCManager.sendRequest({ data: data, callback: \"myCallback(data)\", actionURL: \"/rpcHandler.jsp\"});<br>\n function myCallback(data) { alert(\"response from the server: \" + data); }\n </code><br><br>\n <u>Simple example (server code: /rpcHandler.jsp):</u>\n <br><br><code>\n RPCManager rpc = new RPCManager(request, response, out);<br>\n Object data = rpc.getData();<br>\n System.out.println(\"client sent: \" + data.toString());<br>\n rpc.send(\"here's a response\");<br>\n </code>\n <P>\n Note that, while the example above uses the SmartClient Java Server, the RPCManager is also\n capable of issuing RPCs that do not require a SmartClient server.  See\n ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-Side Data Integration')} for details.\n <P>\n <u><b>Queuing</b></u>\n <br>\n Because of browser limitations on the total number of simultaneous HTTP connections to a given\n server, batching multiple RPC requests into a single HTTP request is highly advisable whenever\n possible.  The RPCManager provides a queuing mechanism that allows this.\n <br><br>\n <u>Queuing example (client code):</u>\n <br><br><code>\n RPCManager.startQueue();<br>\n RPCManager.send(\"a string of data\", \"myCallback(data)\", {actionURL: \"/rpcHandler.jsp\"});<br>\n RPCManager.sendRequest({ data: [\"some\", \"more data\", 2], callback: \"myCallback(data)\", actionURL: \"/rpcHandler.jsp\"});<br>\n RPCManager.sendRequest({ data: \"different callback\", callback: \"myCallback2(data)\", actionURL: \"/rpcHandler.jsp\"});<br>\n RPCManager.sendQueue()<br>\n function myCallback(data) { alert(\"response from the server: \" + data); }<br>\n function myCallback2(data) { alert(\"response from the server (other callback): \" + data); }\n </code><br><br>\n <u>Queuing example (server code: /rpcHandler.jsp):</u>\n <br><br><code>\n RPCManager rpc = new RPCManager(request, response, out);<br>\n for(Iterator i = rpc.getRequests().iterator(); i.hasNext();) {<br>\n &nbsp;&nbsp;&nbsp;&nbsp;RPCRequest rpcRequest = (RPCRequest)i.next();<br>\n &nbsp;&nbsp;&nbsp;&nbsp;Object data = rpcRequest.getData();<br>\n &nbsp;&nbsp;&nbsp;&nbsp;System.out.println(\"client sent:\" + data.toString());<br>\n &nbsp;&nbsp;&nbsp;&nbsp;//send back the data sent to us by the client<br>\n &nbsp;&nbsp;&nbsp;&nbsp;rpc.send(rpcRequest, new RPCResponse(data));<br>\n }<br>\n </code>\n <br><br>\n <u><b>Error Handling</b></u>\n <br>\n The ${isc.DocUtils.linkForRef('class:RPCResponse')} object has an integer status field that the RPCManager inspects when\n the response is received from the server. If the value of this field is less than zero, the\n request is considered to have failed.  Otherwise it is considered to have succeeded.  This\n value is settable via the setStatus() method call on the RPCResponse server-side object.\n <br><br>\n If the status field shows a failure, the RPCManager will, by default, show a dialog with the\n contents of the ${isc.DocUtils.linkForRef('attr:RPCRequest.data')} field (which is assumed to contain a \n meaningful description of the error that occured).  If you specified a callback in your\n RPCRequest, it will <b>not</b> be called if the status shows a failure (see below for how to\n change this).\n <br><br>\n If the status field shows success, the RPCManager takes no special action.\n <br><br>\n The built-in status codes and default behavior are there for convenience.  You can choose to\n completely ignore it and handle errors as you see fit (for example by encoding them into the data\n field returned by the server, and always setting the RPCResponse status field to a success\n value).  In fact, the status field is automatically set to a success code\n (RPCResponse.STATUS_SUCCESS) by the constructor of the RPCResponse object on the server. \n <br><br>\n If you choose to use the status field, but want to handle the errors yourself in your callback\n (and suppress the default error dialog popped up by the RPCManager), simply specify the\n ${isc.DocUtils.linkForRef('attr:RPCRequest.willHandleError','willHandleError:true')} on your RPCRequest object.  This\n allows you to use the RPCManager.sendError() convenience methods on the server without the\n default error handling behavior on the client.",
        name:"RPCManager",
        seeAlso:[],
        type:"class"
    },
    "method:DataSourceField.getFieldValue":{
        ref:"method:DataSourceField.getFieldValue",
        flags:"A",
        description:" Function or JavaScript expression used to retrieve the field's value from the XML element or\n JSON record returned from a web service.\n <P>\n This is an advanced API for use when a ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','valueXPath')} setting\n is insufficient to derive a field's value, yet an implementation of\n ${isc.DocUtils.linkForRef('method:DataSource.transformResponse')} is overkill.\n\n",
        name:"getFieldValue",
        seeAlso:[],
        params:[
            {description:"record object selected from web service response data                                      by ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath','recordXPath')}",
             optional:false, name:"record", defaultValue:null, type:"Object or XMLElement"},
            {description:"default value derived by the method described in                    ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath')}",
             optional:false, name:"value", defaultValue:null, type:"any"},
            {description:"DataSourceField definition", optional:false, name:"field", defaultValue:null,
             type:"DataSourceField"},
            {description:"name of the DataSource field", optional:false, name:"fieldName",
             defaultValue:null, type:"String"}
        ],
        type:"method",
        definingClass:"class:DataSourceField",
        groups:["clientDataIntegration"]
    },
    "method:ListGrid.rowEditorEnter":{
        ref:"method:ListGrid.rowEditorEnter",
        flags:"A",
        description:" Callback fired when the user starts editing a new row.\n\n",
        name:"rowEditorEnter",
        seeAlso:[
            {ref:"method:ListGrid.editorEnter", description:null}
        ],
        params:[
            {description:"record for the cell being edited", optional:false, name:"record",
             defaultValue:null, type:"ListGridField"},
            {description:"edit values for the current row", optional:false, name:"editValues",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "method:DynamicForm.cancel":{
        ref:"method:DynamicForm.cancel",
        flags:"",
        description:"\n This method exists for clean integration with existing server frameworks that have a 'cancel'\n feature which typically clears session state associated with the form.  When this method is\n called, an RPC is sent to the server with a parameter named\n ${isc.DocUtils.linkForRef('attr:DynamicForm.cancelParamName')} with the value\n ${isc.DocUtils.linkForRef('attr:DynamicForm.cancelParamValue')}.<p>\n\n Note that no other form data is sent.  By default the current top-level page is replaced with the\n reply.  If you wish to ignore the server reply instead, call this method like this:\n <pre>\n dynamicFormInstance.cancel({ignoreTimeout: true, target: null});\n </pre>\n\n",
        name:"cancel",
        seeAlso:[],
        params:[
            {description:"additional properties to set on the RPCRequest                                          that will be issued",
             optional:true, name:"requestProperties", defaultValue:null, type:"DSRequest"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["submitting"]
    },
    "method:Class.setLogPriority":{
        ref:"method:Class.setLogPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for some log category, when logged on\n this Class or Instance object.<br>\n If called with no category, this priority will be applied to every logged message on this\n object<br>\n To set the visible log priority for some category across the entire page, use\n <code>isc.Log.setPriority()</code> instead.\n",
        name:"setLogPriority",
        seeAlso:[
            {ref:"classMethod:Log.setPriority", description:null}
        ],
        params:[
            {description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
             optional:false, name:"category", defaultValue:null, type:"string"},
            {description:"priority level", optional:false, name:"priority", defaultValue:null,
             type:"LogPriority"}
        ],
        type:"method",
        definingClass:"class:Class"
    },
    "attr:Layout.stackZIndex":{
        ref:"attr:Layout.stackZIndex",
        flags:"IR",
        description:"For use in conjunction with ${isc.DocUtils.linkForRef('attr:Layout.memberOverlap')}, controls the z-stacking order of\n members.\n <P>\n If \"lastOnTop\", members stack from the first member at bottom to the last member at\n top. If \"firstOnTop\", members stack from the last member at bottom to the first member\n at top.",
        name:"stackZIndex",
        seeAlso:[],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout"
    },
    "attr:FormulaBuilder.showHelpIcon":{
        ref:"attr:FormulaBuilder.showHelpIcon",
        flags:"IR",
        description:"Whether to show the help icon that appears after the ${isc.DocUtils.linkForRef('attr:FormulaBuilder.formulaField')}.",
        name:"showHelpIcon",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:["formulaFields"]
    },
    "method:Canvas.mouseUp":{
        ref:"method:Canvas.mouseUp",
        flags:"A",
        description:"\n Executed when the left mouse is released on this widget.  No default implementation.\n\n",
        name:"mouseUp",
        seeAlso:[
            {ref:"method:Canvas.getOffsetX", description:null},
            {ref:"method:Canvas.getOffsetY", description:null}
        ],
        returns:{description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
         type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('customMouseEvents')}"],
        definingClass:"class:Canvas",
        groups:["widgetEvents"]
    },
    "method:WebService.getOutputHeaderSchema":{
        ref:"method:WebService.getOutputHeaderSchema",
        flags:"",
        description:" Get the schema for each part of the SOAP header for the output message of a given\n operation, as a mapping from part name to schema.  For example, given WSDL like:\n <pre>\n     &lt;soap:header part=\"SessionHeader\"/&gt;\n     &lt;soap:header part=\"CallOptions\"/&gt;\n </pre>\n The following schema would be returned:\n <pre>\n     { SessionHeader : <i>sessionHeaderPartSchema</i>,\n       CallOptions : <i>callOptionsPartSchema</i> }\n </pre>\n The schema are instances of ${isc.DocUtils.linkForRef('class:DataSource')} that can be inspected to discover the\n elements and types that are legal in that header part, and can construct a valid SOAP\n header part if ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')} is invoked.\n\n",
        name:"getOutputHeaderSchema",
        seeAlso:[],
        params:[
            {description:"name of an operation from this web service", optional:false,
             name:"operationName", defaultValue:null, type:"String"}
        ],
        returns:{description:"mapping from partName to schema", type:"Object"},
        type:"method",
        definingClass:"class:WebService"
    },
    "attr:StretchImgButton.showRollOver":{
        ref:"attr:StretchImgButton.showRollOver",
        flags:"IRW",
        description:"Should we visibly change state when the mouse goes over this object?",
        name:"showRollOver",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["state"]
    },
    "attr:ListGrid.booleanImageWidth":{
        ref:"attr:ListGrid.booleanImageWidth",
        flags:"IRWA",
        description:"Width for the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')}.\n Note: If ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} is unset, the ${isc.DocUtils.linkForRef('attr:CheckboxItem.checkedImage')}\n will be used to indicate a true value in a boolean field. In this case this property is\n ignored in favor of ${isc.DocUtils.linkForRef('attr:CheckboxItem.valueIconWidth')}.",
        name:"booleanImageWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["imageColumns"]
    },
    "attr:ListGridField.editorValueMap":{
        ref:"attr:ListGridField.editorValueMap",
        flags:"IRW",
        getter:["getEditorValueMap"],
        description:"A valueMap to use for editors shown for this field.  By default if this is not\n specified ${isc.DocUtils.linkForRef('attr:ListGridField.valueMap','field.valueMap')} will be used instead.\n <P>\n Dynamic valueMaps can be provided by implementing ${isc.DocUtils.linkForRef('method:ListGrid.getEditorValueMap')}.",
        name:"editorValueMap",
        seeAlso:[
            {ref:"method:ListGrid.getEditorValueMap", description:null},
            {ref:"method:ListGrid.setEditorValueMap", description:null}
        ],
        valueType:"Array or Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:["editing"]
    },
    "object:FormItemIcon":{
        methods:["method:FormItemIcon.click", "method:FormItemIcon.keyPress"],
        type:"object",
        ref:"object:FormItemIcon",
        classAttrs:[],
        treeLocation:["Client Reference/Forms/Form Items/FormItem"],
        classMethods:[],
        description:"Form item icon descriptor objects used by Form Items to specify the appearance and\n  behavior of icons displayed after the item in the page flow.",
        attrs:["attr:FormItemIcon.src", "attr:FormItemIcon.showOver", "attr:FormItemIcon.showFocused", 
         "attr:FormItemIcon.showFocusedWithItem","attr:FormItemIcon.neverDisable", "attr:FormItemIcon.width", "attr:FormItemIcon.height", 
         "attr:FormItemIcon.prompt"],
        name:"FormItemIcon",
        seeAlso:[
            {ref:"attr:FormItem.icons", description:null}
        ],
        examples:["${isc.DocUtils.linkForExampleId('formIcons')}"],
        groups:["formIcons"]
    },
    "class:HiddenItem":{
        methods:[],
        ref:"class:HiddenItem",
        classAttrs:[],
        classMethods:[],
        attrs:["attr:HiddenItem.showTitle", "attr:HiddenItem.colSpan", "attr:HiddenItem.rowSpan"],
        description:"HiddenItems track a value but have no visible appearance and do not take up space in the form\n layout.\n <P>\n When using SmartClient databinding it is usually not necessary to use a HiddenItem, since\n the DynamicForm will track values for which no actual form control exists, and will submit\n these 'extra' values when ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} is called.  HiddenItems only apply\n to forms that are submitted like ordinary HTML forms, via the\n ${isc.DocUtils.linkForRef('method:DynamicForm.submitForm')} method.",
        name:"HiddenItem",
        seeAlso:[],
        type:"class"
    },
    "attr:Canvas.defaultWidth":{
        ref:"attr:Canvas.defaultWidth",
        flags:"IRWA",
        description:"For custom components, establishes a default width for the component.\n <P>\n For a component that should potentially be sized automatically by a Layout, set this\n property rather than ${isc.DocUtils.linkForRef('attr:Canvas.width')} directly, because Layouts regard a width setting as\n an explicit size that shouldn't be changed.",
        name:"defaultWidth",
        seeAlso:[],
        valueType:"Number",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "method:Canvas.layoutChildren":{
        ref:"method:Canvas.layoutChildren",
        flags:"A",
        description:"\n <code>layoutChildren()</code> is where a Canvas should implement a sizing policy for it's\n Canvas children.  Since <code>layoutChildren</code> calls parentResized() on its children,\n ${isc.DocUtils.linkForRef('method:Canvas.parentResized')} is a good place for a child to implement a layout policy that\n can be used within any parent.\n <P>\n Recommended practice for a Canvas that manages Canvas children is to create those children\n without any initial coordinate or size settings and do all sizing when layoutChildren() is\n called.\n <P>\n layoutChildren() is always called at least once before children are drawn, and is called\n automatically whenever the viewport size changes (which includes both resizing and\n introduction/removal of scrolling).  layoutChildren() can also be manually invoked in any\n other component-specific situation which changes the layout.\n <P>\n NOTE: layoutChildren() may be called before draw() if a widget is resized before draw(), so\n be sure to avoid errors such as assuming that any children you automatically create have\n already been created.\n <P>\n NOTE: auto-sizing: layoutChildren() is also called once during the initial draw(), before\n children are drawn, with a \"reason\" of \"initial draw\".  During this invocation of\n layoutChildren() it is legal to directly draw children (call child.draw()), which is\n otherwise never allowed.  This allows a Canvas to implement an auto-sizing layout policy by\n drawing some children before deciding on the sizes of remaining children, which is far more\n efficient than drawing all children and resizing some of them after they are drawn.\n",
        name:"layoutChildren",
        seeAlso:[],
        params:[
            {description:"reason why layoutChildren() is being called, passed when framework                        code invokes layoutChildren()",
             optional:false, name:"reason", defaultValue:null, type:"string"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["sizing"]
    },
    "method:CubeGrid.deselectFacetValues":{
        ref:"method:CubeGrid.deselectFacetValues",
        flags:"",
        description:"\n deselect the header showing a given set of facet values\n\n  <br><i>methodType</i> action\n",
        name:"deselectFacetValues",
        seeAlso:[],
        params:[
            {description:"facetVales to deselect", optional:false, name:"facetValues",
             defaultValue:null, type:"facetValues object"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "group:scrolling":{
        ref:"group:scrolling",
        refs:["method:Canvas.getScrollLeft", "method:Canvas.getScrollTop", 
         "method:Canvas.getScrollbarSize","method:Canvas.getScrollBottom", "method:Canvas.getScrollRight", 
         "method:Canvas.scrollToTop","method:Canvas.scrollToBottom", "method:Canvas.scrollToLeft", 
         "method:Canvas.scrollToRight","method:Canvas.scrollBy", "method:Canvas.scrollByPercent", "method:Canvas.scrollTo", 
         "method:Canvas.scrolled","method:Canvas.scrollToPercent", "attr:Canvas.showCustomScrollbars", 
         "attr:Canvas.scrollbarSize"],
        description:"Scrolling and clipping of objects when part of the object is obscured",
        name:"scrolling",
        seeAlso:[],
        type:"group"
    },
    "method:Selection.selectList":{
        ref:"method:Selection.selectList",
        flags:"",
        description:" Select an array of items (subset of the entire list)\n",
        name:"selectList",
        seeAlso:[],
        params:[
            {description:"listarray of objects to select", optional:true, name:"", defaultValue:null,
             type:"object"}
        ],
        returns:{description:"true == selection actually changed, false == no change", type:"boolean"},
        type:"method",
        definingClass:"class:Selection",
        groups:["selection"]
    },
    "method:DynamicForm.titleHoverHTML":{
        ref:"method:DynamicForm.titleHoverHTML",
        flags:"A",
        description:"  Retrieves the HTML to display in a hover canvas when the user holds the mousepointer over\n  some item's title.  Return null to suppress the hover canvas altogether.<br>\n  Default implementation returns the prompt for the item if defined.  If no prompt is defined\n  and the item title is clipped, the item title will be shown in a hover by default.<br>\n  Can be overridden via <code>item.titleHoverHTML()</code>\n\n",
        name:"titleHoverHTML",
        seeAlso:[
            {ref:"attr:FormItem.prompt", description:null},
            {ref:"method:FormItem.titleHoverHTML", description:null}
        ],
        params:[
            {description:"Item the user is hovering over.", optional:false, name:"item",
             defaultValue:null, type:"FormItem"}
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:["Hovers"]
    },
    "classMethod:Log.logDebug":{
        ref:"classMethod:Log.logDebug",
        flags:"",
        description:" Log a message at \"debug\" priority\n <P>\n A method named log<i>Priority</i> exists for each priority level, on every ISC Class and\n instance of an ISC Class.  Messages logged on a Class or instance have a default\n category of the classname.  Messages logged on an instance will also automatically\n incorporate the instance ID.  General best practice is to call logDebug() et al as\n \"this.logDebug\" whenever \"this\" is an instance, or as \"Log.logDebug\" otherwise.\n\n",
        name:"logDebug",
        seeAlso:[
            {ref:"classMethod:Log.echo", description:"for dumping datastructures to the log"},
            {ref:"classMethod:Log.setPriority",
             description:"for controlling what messages appear in the log"}
        ],
        params:[
            {description:"message to log", optional:false, name:"message", defaultValue:null,
             type:"String"},
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:StretchImgButton.showDown":{
        ref:"attr:StretchImgButton.showDown",
        flags:"IRW",
        description:"Should we visibly change state when the mouse goes down in this object?",
        name:"showDown",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:["state"]
    },
    "method:FormItem.getIconWidth":{
        ref:"method:FormItem.getIconWidth",
        flags:"A",
        description:"	Takes an icon definition object, and returns the width for that icon in px.\n",
        name:"getIconWidth",
        seeAlso:[],
        params:[
            {description:"icon definition object for this item.", optional:false, name:"icon",
             defaultValue:null, type:"object"}
        ],
        returns:{description:"width of the form item icon in px", type:"number"},
        type:"method",
        definingClass:"class:FormItem",
        groups:["sizing"]
    },
    "classMethod:Log.getLogPriorities":{
        ref:"classMethod:Log.getLogPriorities",
        flags:"",
        description:" Get all priority settings as an object mapping category names to priority levels.\n\n",
        name:"getLogPriorities",
        seeAlso:[],
        params:[
            {description:"Optional param to get priorities specific to                                            some ISC class or instance.",
             optional:true, name:"object", defaultValue:null, type:"Class or Instance object"},
            {description:"If this method is retrieving the priorities specific                                   to logging for some class or instance, this parameter\n                                  can be used to view only the overrides to the default\n                                  log priorites on this object.",
             optional:true, name:"overridesOnly", defaultValue:null, type:"boolean"}
        ],
        returns:{description:"priority settings", type:"Object"},
        type:"classMethod",
        definingClass:"class:Log"
    },
    "method:StatefulCanvas.setBaseStyle":{
        ref:"method:StatefulCanvas.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[],
        params:[
            {description:"new base style", optional:false, name:"style", defaultValue:null,
             type:"className"}
        ],
        type:"method",
        definingClass:"class:StatefulCanvas"
    },
    "method:CubeGrid.selectCell":{
        ref:"method:CubeGrid.selectCell",
        flags:"",
        description:"\n  select / deselect a single cell - accepts cell ID or cell record.\n\n      <br><i>methodType</i> action\n",
        name:"selectCell",
        seeAlso:[],
        params:[
            {description:"cell to select / deselect", optional:false, name:"cell", defaultValue:null,
             type:"ID | object"},
            {description:"new selection state (if null, defaults to true)", optional:true,
             name:"newState", defaultValue:null, type:"boolean"}
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:["selection"]
    },
    "group:skins":{
        ref:"group:skins",
        refs:["classMethod:Page.setSkinDir", "classMethod:Page.loadStyleSheet"],
        description:"Properties used to manage to the the overall appearance of the application.\n <P>\n A \"skin\" consists of \n <ul>\n <li><code>skin_styles.css</code>: a .css file defining the set of \n     classes to apply to SmartClient components' visual elements</li>\n <li><code>images/</code>: a directory of image files used as part of visual \n     components</li>\n <li><code>load_skin.js</code>: a .js file containing overrides for various \n     SmartClient component properties that affect the appearance of those components.</li>\n </ul>\n Skins are loaded via the <code>skin</code> attribute of the ${isc.DocUtils.linkForRef('group:loadISCTag')} or \n by including the appropriate <code>load_skin.js</code> source file with a standard script\n include tag.\n <P>\n To create a custom skin, we suggest making a complete copy of an existing skin, then\n modifying the media, css class definitions and component property overrides you wish to\n change.\n <P>\n Note that the <code>load_skin.js</code> file contains a ${isc.DocUtils.linkForRef('classMethod:Page.setSkinDir')} \n directive to set up the skin dir (used to ensure media is retrieved from the appropriate\n directory), and a ${isc.DocUtils.linkForRef('classMethod:Page.loadStyleSheet')} directive to load the .css file.\n <P>\n See the ${isc.DocUtils.linkForRef('group:skinning','Skinning Overview')} for more information.",
        name:"skins",
        seeAlso:[
            {ref:"group:appearance", description:null},
            {ref:"group:images", description:null},
            {ref:"group:files", description:null}
        ],
        type:"group"
    },
    "class:ListGrid":{
        exampleConfig:"ListGrid.xml",
        methods:["method:ListGrid.fetchData", "method:ListGrid.exportData", "method:ListGrid.filterData", 
         "method:ListGrid.fetchRelatedData","method:ListGrid.clearCriteria", "method:ListGrid.getCriteria", 
         "method:ListGrid.setCriteria","method:ListGrid.invalidateCache", "method:ListGrid.willFetchData", 
         "method:ListGrid.addData","method:ListGrid.updateData", "method:ListGrid.removeSelectedData", 
         "method:ListGrid.getSelection","method:ListGrid.getSelectedRecord", "method:ListGrid.getVisibleRows", 
         "method:ListGrid.getDrawnRows","method:ListGrid.getCellStyle", "method:ListGrid.getCellCSSText", 
         "method:ListGrid.refreshCellStyle","method:ListGrid.cellOver", "method:ListGrid.rowOver", "method:ListGrid.cellOut", 
         "method:ListGrid.rowOut","method:ListGrid.cellHover", "method:ListGrid.rowHover", "method:ListGrid.cellHoverHTML", 
         "method:ListGrid.cellContextClick","method:ListGrid.rowContextClick", "method:ListGrid.cellMouseDown", 
         "method:ListGrid.rowMouseDown","method:ListGrid.cellMouseUp", "method:ListGrid.rowMouseUp", "method:ListGrid.cellClick", 
         "method:ListGrid.cellDoubleClick","method:ListGrid.getFormulaFieldValue", "method:ListGrid.getSummaryFieldValue", 
         "method:ListGrid.setData","method:ListGrid.setSelectionType", "method:ListGrid.setSelectionAppearance", 
         "method:ListGrid.setBodyOverflow","method:ListGrid.setBodyStyleName", "method:ListGrid.setAlternateBodyStyleName", 
         "method:ListGrid.setAlternateRecordStyles","method:ListGrid.setAutoFitData", "method:ListGrid.setAutoFitMaxRecords", 
         "method:ListGrid.setAutoFitMaxHeight","method:ListGrid.setAutoFitMaxColumns", "method:ListGrid.setAutoFitMaxWidth", 
         "method:ListGrid.setFieldProperties","method:ListGrid.setFieldTitle", "method:ListGrid.showField", "method:ListGrid.hideField", 
         "method:ListGrid.fieldIsVisible","method:ListGrid.getTitleField", "method:ListGrid.setFields", 
         "method:ListGrid.focusInFilterEditor","method:ListGrid.filterByEditor", "method:ListGrid.getFieldState", 
         "method:ListGrid.setFieldState","method:ListGrid.getCheckboxField", "method:ListGrid.isCheckboxField", 
         "method:ListGrid.getSelectedState","method:ListGrid.setSelectedState", "method:ListGrid.getSortState", 
         "method:ListGrid.setSortState","method:ListGrid.getViewState", "method:ListGrid.setViewState", 
         "method:ListGrid.refreshFields","method:ListGrid.getFieldWidth", "method:ListGrid.getBaseStyle", 
         "method:ListGrid.getCellValue","method:ListGrid.getCellAlign", "method:ListGrid.getCellVAlign", 
         "method:ListGrid.getValueIcon","method:ListGrid.rowClick", "method:ListGrid.rowDoubleClick", 
         "method:ListGrid.selectRecord","method:ListGrid.deselectRecord", "method:ListGrid.selectRecords", 
         "method:ListGrid.deselectRecords","method:ListGrid.selectAllRecords", "method:ListGrid.deselectAllRecords", 
         "method:ListGrid.anySelected","method:ListGrid.selectSingleRecord", "method:ListGrid.keyPress", 
         "method:ListGrid.bodyKeyPress","method:ListGrid.getFocusRow", "method:ListGrid.recordClick", 
         "method:ListGrid.recordDoubleClick","method:ListGrid.setShowFilterEditor", "method:ListGrid.getFilterEditorValueMap", 
         "method:ListGrid.getFilterEditorType","method:ListGrid.setFilterEditorCriteria", "method:ListGrid.getFilterEditorCriteria", 
         "method:ListGrid.canEditCell","method:ListGrid.startEditing", "method:ListGrid.stopHover", 
         "method:ListGrid.getEditorValueMap","method:ListGrid.getEditorValueIcons", "method:ListGrid.setEditorValueMap", 
         "method:ListGrid.getEditorType","method:ListGrid.refreshCell", "method:ListGrid.refreshRow", 
         "method:ListGrid.startEditingNew","method:ListGrid.getAllEditRows", "method:ListGrid.getEditValues", 
         "method:ListGrid.getEditedRecord","method:ListGrid.getEditedCell", "method:ListGrid.setEditValues", 
         "method:ListGrid.setEditValue","method:ListGrid.getEditValue", "method:ListGrid.clearEditValue", 
         "method:ListGrid.getEditRow","method:ListGrid.getEditCol", "method:ListGrid.getEditField", 
         "method:ListGrid.cancelEditing","method:ListGrid.endEditing", "method:ListGrid.discardAllEdits", 
         "method:ListGrid.discardEdits","method:ListGrid.saveEdits", "method:ListGrid.rowHasChanges", "method:ListGrid.hasChanges", 
         "method:ListGrid.cellHasChanges","method:ListGrid.saveAllEdits", "method:ListGrid.validateRow", 
         "method:ListGrid.validateCell","method:ListGrid.getRequiredFieldMessage", "method:ListGrid.hasErrors", 
         "method:ListGrid.rowHasErrors","method:ListGrid.cellHasErrors", "method:ListGrid.getRowErrors", 
         "method:ListGrid.getCellErrors","method:ListGrid.setFieldError", "method:ListGrid.setRowErrors", 
         "method:ListGrid.clearFieldError","method:ListGrid.clearRowErrors", "method:ListGrid.removeData", 
         "method:ListGrid.setDragTracker","method:ListGrid.getDragTrackerIcon", "method:ListGrid.getDragTrackerTitle", 
         "method:ListGrid.willAcceptDrop","method:ListGrid.transferSelectedData", "method:ListGrid.recordDrop", 
         "method:ListGrid.transferDragData","method:ListGrid.getDragData", "method:ListGrid.getRecord", 
         "method:ListGrid.getCellRecord","method:ListGrid.getTotalRows", "method:ListGrid.getAllFields", 
         "method:ListGrid.getFieldName","method:ListGrid.getField", "method:ListGrid.getFieldNum", 
         "method:ListGrid.getSummaryTitle","method:ListGrid.setValueMap", "method:ListGrid.getRecordIndex", 
         "method:ListGrid.getEventRow","method:ListGrid.getEventColumn", "method:ListGrid.getDropIndex", 
         "method:ListGrid.selectionChanged","method:ListGrid.setCanFreezeFields", "method:ListGrid.freezeField", 
         "method:ListGrid.unfreezeField","method:ListGrid.toggleFrozen", "method:ListGrid.setHeaderHeight", 
         "method:ListGrid.setShowHeader","method:ListGrid.headerClick", "method:ListGrid.reorderField", 
         "method:ListGrid.reorderFields","method:ListGrid.setCanResizeFields", "method:ListGrid.resizeField", 
         "method:ListGrid.displayHeaderContextMenu","method:ListGrid.getToggleFreezeText", "method:ListGrid.getGroupByText", 
         "method:ListGrid.getHeaderSpanContextMenuItems","method:ListGrid.getHeaderContextMenuItems", "method:ListGrid.unsort", 
         "method:ListGrid.sort","method:ListGrid.chartData", "method:ListGrid.chartRow", "method:ListGrid.chartColumn", 
         "method:ListGrid.groupBy","method:ListGrid.getGroupNodeHTML", "method:ListGrid.ungroup", 
         "method:ListGrid.setHeaderSpans","method:ListGrid.setHeaderSpanTitle", "method:ListGrid.cellChanged", 
         "method:ListGrid.editComplete","method:ListGrid.editFailed", "method:ListGrid.editorEnter", 
         "method:ListGrid.rowEditorEnter","method:ListGrid.editorExit", "method:ListGrid.rowEditorExit", 
         "method:ListGrid.formatCellValue","method:ListGrid.formatEditorValue", "method:ListGrid.parseEditorValue", 
         "method:ListGrid.fieldStateChanged","method:ListGrid.dataArrived"],
        type:"class",
        ref:"class:ListGrid",
        classAttrs:[],
        treeLocation:["Client Reference/Grids"],
        classMethods:[],
        description:"A ListGrid is a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} that displays a list of objects in a grid, where\n each row represents one object and each cell in the row represents one property.",
        attrs:["attr:ListGrid.autoFetchData", "attr:ListGrid.initialCriteria", 
         "attr:ListGrid.fastCellUpdates","attr:ListGrid.styleName", "attr:ListGrid.data", "attr:ListGrid.recordEnabledProperty", 
         "attr:ListGrid.fields","attr:ListGrid.dataSource", "attr:ListGrid.autoFetchDisplayMap", 
         "attr:ListGrid.saveLocally","attr:ListGrid.useAllDataSourceFields", "attr:ListGrid.showDetailFields", 
         "attr:ListGrid.titleField","attr:ListGrid.dataProperties", "attr:ListGrid.originalData", "attr:ListGrid.groupTree", 
         "attr:ListGrid.groupStartOpen","attr:ListGrid.groupNodeStyle", "attr:ListGrid.groupIcon", "attr:ListGrid.groupIconSize", 
         "attr:ListGrid.groupIndentSize","attr:ListGrid.groupLeadingIndent", "attr:ListGrid.canGroupBy", 
         "attr:ListGrid.groupByMaxRecords","attr:ListGrid.isGrouped", "attr:ListGrid.nullGroupTitle", "attr:ListGrid.groupByField", 
         "attr:ListGrid.valueIconSize","attr:ListGrid.valueIconWidth", "attr:ListGrid.valueIconHeight", 
         "attr:ListGrid.valueIconLeftPadding","attr:ListGrid.valueIconRightPadding", "attr:ListGrid.imageSize", 
         "attr:ListGrid.headerSpans","attr:ListGrid.headerSpanHeight", "attr:ListGrid.headerSpanVAlign", 
         "attr:ListGrid.unspannedHeaderVAlign","attr:ListGrid.headerSpanConstructor", "attr:ListGrid.headerSpan", 
         "attr:ListGrid.showTreeColumnPicker","attr:ListGrid.modalEditing", "attr:ListGrid.fetchDelay", "attr:ListGrid.showAllRecords", 
         "attr:ListGrid.drawAllMaxCells","attr:ListGrid.drawAheadRatio", "attr:ListGrid.quickDrawAheadRatio", 
         "attr:ListGrid.scrollRedrawDelay","attr:ListGrid.dataPageSize", "attr:ListGrid.body", "attr:ListGrid.bodyOverflow", 
         "attr:ListGrid.bodyBackgroundColor","attr:ListGrid.bodyStyleName", "attr:ListGrid.emptyCellValue", "attr:ListGrid.cellHeight", 
         "attr:ListGrid.fixedRecordHeights","attr:ListGrid.autoFitData", "attr:ListGrid.autoFitMaxHeight", 
         "attr:ListGrid.autoFitMaxRecords","attr:ListGrid.autoFitMaxWidth", "attr:ListGrid.autoFitMaxColumns", 
         "attr:ListGrid.leaveScrollbarGap","attr:ListGrid.wrapCells", "attr:ListGrid.cellPadding", "attr:ListGrid.dateFormatter", 
         "attr:ListGrid.dateInputFormat","attr:ListGrid.timeFormatter", "attr:ListGrid.linkTextProperty", "attr:ListGrid.baseStyle", 
         "attr:ListGrid.editFailedBaseStyle","attr:ListGrid.editFailedCSSText", "attr:ListGrid.editPendingBaseStyle", 
         "attr:ListGrid.editPendingCSSText","attr:ListGrid.recordCustomStyleProperty", "attr:ListGrid.recordBaseStyleProperty", 
         "attr:ListGrid.frozenBaseStyle","attr:ListGrid.shrinkForFreeze", "attr:ListGrid.alternateRecordStyles", 
         "attr:ListGrid.alternateBodyStyleName","attr:ListGrid.alternateRecordFrequency", "attr:ListGrid.generateClickOnSpace", 
         "attr:ListGrid.generateClickOnEnter","attr:ListGrid.generateDoubleClickOnSpace", "attr:ListGrid.generateDoubleClickOnEnter", 
         "attr:ListGrid.arrowKeyAction","attr:ListGrid.showRollOver", "attr:ListGrid.canHover", "attr:ListGrid.showHover", 
         "attr:ListGrid.hoverStyle","attr:ListGrid.selection", "attr:ListGrid.selectionAppearance", 
         "attr:ListGrid.selectionType","attr:ListGrid.canDragSelect", "attr:ListGrid.checkboxField", 
         "attr:ListGrid.checkboxFieldTrueImage","attr:ListGrid.checkboxFieldFalseImage", "attr:ListGrid.checkboxFieldImageWidth", 
         "attr:ListGrid.checkboxFieldImageHeight","attr:ListGrid.showEmptyMessage", "attr:ListGrid.emptyMessage", 
         "attr:ListGrid.emptyMessageStyle","attr:ListGrid.loadingDataMessage", "attr:ListGrid.loadingDataMessageStyle", 
         "attr:ListGrid.loadingMessage","attr:ListGrid.singleCellValueProperty", "attr:ListGrid.isSeparatorProperty", 
         "attr:ListGrid.showFilterEditor","attr:ListGrid.filterEditorHeight", "attr:ListGrid.autoFetchAsFilter", 
         "attr:ListGrid.canEdit","attr:ListGrid.recordEditProperty", "attr:ListGrid.editByCell", "attr:ListGrid.saveByCell", 
         "attr:ListGrid.validateByCell","attr:ListGrid.validateOnChange", "attr:ListGrid.neverValidate", 
         "attr:ListGrid.canRemoveRecords","attr:ListGrid.removeIcon", "attr:ListGrid.animateRemoveRecord", 
         "attr:ListGrid.animateRemoveTime","attr:ListGrid.animateRemoveSpeed", "attr:ListGrid.removeFieldTitle", 
         "attr:ListGrid.removeFieldDefaults","attr:ListGrid.removeFieldProperties", "attr:ListGrid.filterByCell", 
         "attr:ListGrid.filterOnKeypress","attr:ListGrid.waitForSave", "attr:ListGrid.stopOnErrors", "attr:ListGrid.autoSaveEdits", 
         "attr:ListGrid.confirmCancelEditing","attr:ListGrid.cancelEditingConfirmationMessage", "attr:ListGrid.confirmDiscardEdits", 
         "attr:ListGrid.confirmDiscardEditsMessage","attr:ListGrid.discardEditsSaveButtonTitle", "attr:ListGrid.rowEndEditAction", 
         "attr:ListGrid.listEndEditAction","attr:ListGrid.enterKeyEditAction", "attr:ListGrid.escapeKeyEditAction", 
         "attr:ListGrid.editEvent","attr:ListGrid.editOnFocus", "attr:ListGrid.selectOnEdit", 
         "attr:ListGrid.longTextEditorThreshold","attr:ListGrid.longTextEditorType", "attr:ListGrid.header", "attr:ListGrid.headerHeight", 
         "attr:ListGrid.minFieldWidth","attr:ListGrid.showHeader", "attr:ListGrid.headerBarStyle", 
         "attr:ListGrid.headerBackgroundColor","attr:ListGrid.headerButtonConstructor", "attr:ListGrid.headerBaseStyle", 
         "attr:ListGrid.headerTitleStyle","attr:ListGrid.frozenHeaderBaseStyle", "attr:ListGrid.frozenHeaderTitleStyle", 
         "attr:ListGrid.headerButtonDefaults","attr:ListGrid.headerButtonProperties", "attr:ListGrid.sorterConstructor", 
         "attr:ListGrid.sorterDefaults","attr:ListGrid.sorterProperties", "attr:ListGrid.canSort", "attr:ListGrid.sortFieldNum", 
         "attr:ListGrid.sortField","attr:ListGrid.sortDirection", "attr:ListGrid.showSortArrow", 
         "attr:ListGrid.canPickFields","attr:ListGrid.canFreezeFields", "attr:ListGrid.canAddFormulaFields", 
         "attr:ListGrid.canAddSummaryFields","attr:ListGrid.showHeaderContextMenu", "attr:ListGrid.showHeaderMenuButton", 
         "attr:ListGrid.headerMenuButtonConstructor","attr:ListGrid.headerMenuButton", "attr:ListGrid.headerMenuButtonIcon", 
         "attr:ListGrid.headerMenuButtonIconWidth","attr:ListGrid.headerMenuButtonIconHeight", "attr:ListGrid.headerMenuButtonWidth", 
         "attr:ListGrid.headerMenuButtonHeight","attr:ListGrid.canDragRecordsOut", "attr:ListGrid.canAcceptDroppedRecords", 
         "attr:ListGrid.canReorderRecords","attr:ListGrid.canReorderFields", "attr:ListGrid.canResizeFields", 
         "attr:ListGrid.dragTrackerMode","attr:ListGrid.resizeFieldsInRealTime", "attr:ListGrid.dragDataAction", 
         "attr:ListGrid.skinImgDir","attr:ListGrid.sortAscendingImage", "attr:ListGrid.sortDescendingImage", 
         "attr:ListGrid.trackerImage","attr:ListGrid.booleanTrueImage", "attr:ListGrid.booleanFalseImage", 
         "attr:ListGrid.booleanImageWidth","attr:ListGrid.booleanImageHeight", "attr:ListGrid.dragTrackerStyle", 
         "attr:ListGrid.freezeOnRightText","attr:ListGrid.freezeOnLeftText", "attr:ListGrid.sortFieldAscendingText", 
         "attr:ListGrid.sortFieldDescendingText","attr:ListGrid.fieldVisibilitySubmenuTitle", "attr:ListGrid.freezeFieldText", 
         "attr:ListGrid.unfreezeFieldText","attr:ListGrid.groupByText", "attr:ListGrid.ungroupText"],
        implementsInterfaces:["DataBoundComponent"],
        name:"ListGrid",
        seeAlso:[]
    },
    "attr:Calendar.cancelButtonTitle":{
        ref:"attr:Calendar.cancelButtonTitle",
        flags:"IR",
        description:"The title for the cancel button in the event editor",
        name:"cancelButtonTitle",
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"Cancel\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["i18nMessages"]
    },
    "classMethod:Class.logIsWarnEnabled":{
        ref:"classMethod:Class.logIsWarnEnabled",
        flags:"",
        description:" Check whether a message logged at \"warn\" priority would be visible in the log.\n <P>\n As with logDebug, category is defaulted to the current className.  Use this method to avoid\n putting together expensive log messages if they will never appear in the log.\n\n",
        name:"logIsWarnEnabled",
        seeAlso:[],
        params:[
            {description:"category to log in", optional:true, name:"category", defaultValue:null,
             type:"String"}
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "attr:Menu.showSubmenus":{
        ref:"attr:Menu.showSubmenus",
        flags:"IRW",
        description:"A boolean, indicating whether the submenu indicator column should be displayed. If\n showSubmenus is not set, the menu will show the indicator column only if one of its\n items specifies a submenu property. If showSubmenus is false, the submenu arrows\n will not be displayed, but submenus will still appear on rollover.",
        name:"showSubmenus",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Menu"
    },
    "attr:SectionStack.sections":{
        ref:"attr:SectionStack.sections",
        flags:"IR",
        getter:["getSections"],
        description:"List of sections of components managed by this SectionStack.",
        name:"sections",
        seeAlso:[
            {ref:"method:SectionStack.getSections", description:null}
        ],
        valueType:"Array of SectionStackSection Properties",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('sectionsExpandCollapse')}"],
        definingClass:"class:SectionStack"
    },
    "attr:SimpleType.editorType":{
        ref:"attr:SimpleType.editorType",
        flags:"IR",
        description:"Classname of the FormItem that should be the default for editing values of this type (eg\n \"SelectItem\").\n <P>\n You can create a simple custom FormItem by adding default ${isc.DocUtils.linkForRef('attr:FormItem.icons')} that\n launch custom value picking dialogs (an example is in the <i>QuickStart\n Guide</i>, Chapter 9, <i>Extending SmartClient</i>).  By setting simpleType.editorType\n to the name of your custom FormItem, forms will automatically use the custom FormItem,\n as will grids performing ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','inline editing')}.",
        name:"editorType",
        seeAlso:[],
        valueType:"FormItem ClassName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SimpleType"
    },
    "attr:FormItem.pickerIconSrc":{
        ref:"attr:FormItem.pickerIconSrc",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon')} is true for this item, this property governs the\n src of the picker icon image to be displayed.",
        name:"pickerIconSrc",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"\"",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "attr:Canvas.snapEdge":{
        flags:"IRW",
        getter:["getSnapEdge"],
        type:"attr",
        ref:"attr:Canvas.snapEdge",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.snapTo','snapTo')} is defined to this widget, this property can be used to\n define which edge of this widget should be snapped to an edge of the master or parent \n element.\n <P>\n If unspecified the, default snapTo behavior is set up to align the \"snapTo\" edge of this \n widget with the snapTo edge of the master or parent.",
        name:"snapEdge",
        setter:["setSnapEdge"],
        valueType:"String",
        seeAlso:[
            {ref:"attr:Canvas.snapTo", description:null}
        ],
        defaultValue:"null",
        groups:["sizing"],
        definingClass:"class:Canvas"
    },
    "method:Tree.indexOf":{
        ref:"method:Tree.indexOf",
        flags:"",
        description:" Return the position in the list of the first instance of the specified object.\n <p>\n If pos is specified, starts looking after that position.\n <p>\n Returns -1 if not found.\n\n",
        name:"indexOf",
        seeAlso:[],
        params:[
            {description:"object to look for", optional:false, name:"obj", defaultValue:null, type:"any"},
            {description:"earliest index to consider", optional:true, name:"pos", defaultValue:null,
             type:"number"},
            {description:"last index to consider", optional:true, name:"endPos", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"position of the item, if found, -1 if not found", type:"number"},
        type:"method",
        definingClass:"class:Tree",
        groups:["access"]
    },
    "attr:TreeGrid.folderIcon":{
        ref:"attr:TreeGrid.folderIcon",
        flags:"IRW",
        description:"The URL of the base icon for all folder nodes in this treeGrid. Note that this URL will\n have ${isc.DocUtils.linkForRef('attr:TreeGrid.openIconSuffix')}, ${isc.DocUtils.linkForRef('attr:TreeGrid.closedIconSuffix')} or \n ${isc.DocUtils.linkForRef('attr:TreeGrid.dropIconSuffix')} appended to indicate state changes if appropriate - \n see documentation on  ${isc.DocUtils.linkForRef('attr:TreeGrid.showOpenIcons')} and ${isc.DocUtils.linkForRef('attr:TreeGrid.showDropIcons')}.",
        name:"folderIcon",
        seeAlso:[],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]folder.gif\"",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('nodeTitles')}"],
        definingClass:"class:TreeGrid",
        groups:["treeIcons"]
    },
    "attr:ListGrid.editPendingCSSText":{
        ref:"attr:ListGrid.editPendingCSSText",
        flags:"IRWA",
        description:"Custom CSS text to be applied to cells with pending edits that have not yet been\n  submitted.<br>\n For further customization of styling for cells with pending edits use\n <code>this.editPendingBaseStyle</code> instead.",
        name:"editPendingCSSText",
        seeAlso:[
            {ref:"attr:ListGrid.editFailedBaseStyle", description:null}
        ],
        valueType:"string",
        defaultValue:"\"border:color:#0066CC;\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["appearance"]
    },
    "attr:CubeGrid.canMoveFacets":{
        ref:"attr:CubeGrid.canMoveFacets",
        flags:"IRW",
        description:"Whether row and column facets can be rearranged by the user, by dragging and dropping the\n facet labels.",
        name:"canMoveFacets",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["facetLayout"]
    },
    "attr:Button.showDown":{
        ref:"attr:Button.showDown",
        flags:"IRW",
        description:"Should we visibly change state when the mouse goes down in this object?",
        name:"showDown",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('buttonStates')}"],
        definingClass:"class:Button",
        groups:["state"]
    },
    "method:ListGrid.endEditing":{
        ref:"method:ListGrid.endEditing",
        flags:"",
        description:"\n Complete the current edit by storing the value and hiding the inline editor. Note that\n if ${isc.DocUtils.linkForRef('attr:ListGrid.autoSaveEdits')} is true, the value will be saved to the server. \n\n",
        name:"endEditing",
        seeAlso:[
            {ref:"method:ListGrid.startEditing", description:null}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "attr:GridRenderer.snapInsideBorder":{
        ref:"attr:GridRenderer.snapInsideBorder",
        flags:"IRW",
        description:"If true, snap-to-cell drops will snap the dropped object inside the selected cell's border.\n If false, snap-to-cell drops will snap the dropped object to the edge of the selected cell, \n regardless of borders",
        name:"snapInsideBorder",
        seeAlso:[
            {ref:"attr:GridRenderer.snapToCells", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:["dragdrop"]
    },
    "attr:CubeGrid.bodyMinWidth":{
        ref:"attr:CubeGrid.bodyMinWidth",
        flags:"IRWA",
        description:"Minimum width for the body of this cubeGrid",
        name:"bodyMinWidth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["gridLayout"]
    },
    "method:HTMLFlow.handleError":{
        ref:"method:HTMLFlow.handleError",
        flags:"",
        description:"\n This method is called when a transport error occurs.  Typically, this is the result of the\n server returning an HTTP error code such as 404 - document not found.  You can inspect the\n RPCResponse object for the reasons for the error and take appropriate action.  Typical\n properties to look at are rpcResponse.status, and rpcResponse.httpResponseCode.\n <p>\n This method is called from the response processing pipeline.  If you want to provide your\n own HTML response that should be rendered into this component as the result of the error,\n you can do so by setting rpcResponse.data to your HTML string.  Returning false from this\n method suppresses any further response handling.  The default implementation of this method\n causes an error message to be logged to the Developer Console and sets the HTML to the error\n string.\n\n",
        name:"handleError",
        seeAlso:[],
        params:[
            {description:"The RPCRequest that was made to the server", optional:false,
             name:"rpcRequest", defaultValue:null, type:"RPCRequest"},
            {description:"The RPCResponse that was received", optional:false, name:"rpcResponse",
             defaultValue:null, type:"RPCResponse"}
        ],
        returns:{description:"false to suppress further response processing", type:"boolean"},
        type:"method",
        definingClass:"class:HTMLFlow",
        groups:["contentLoading"]
    },
    "attr:EdgedCanvas.showCenter":{
        ref:"attr:EdgedCanvas.showCenter",
        flags:"IR",
        description:"Whether to show media in the center section, that is, behind the decorated Canvas.",
        name:"showCenter",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:EdgedCanvas",
        groups:["imageEdges"]
    },
    "method:Tree.linkNodes":{
        ref:"method:Tree.linkNodes",
        flags:"",
        description:"\n This method is provided as a mechanism to link new nodes into the tree of modelType\n \"parent\".  This method takes a list of nodes that must contain at a minimum a unique ID\n (keyed by ${isc.DocUtils.linkForRef('attr:Tree.idField')}) and a parent ID (keyed by\n ${isc.DocUtils.linkForRef('attr:Tree.parentIdField')}).  Based on this information, the list of nodes is integrated\n into the tree structure.\n\n",
        name:"linkNodes",
        seeAlso:[
            {ref:"attr:Tree.data", description:null},
            {ref:"attr:Tree.modelType", description:null}
        ],
        params:[
            {description:"list of nodes to link into the tree.", optional:false, name:"nodes",
             defaultValue:null, type:"Array of TreeNode"}
        ],
        type:"method",
        definingClass:"class:Tree"
    },
    "attr:FormItem.titleOrientation":{
        ref:"attr:FormItem.titleOrientation",
        flags:"IRW",
        description:"On which side of this item should the title be placed.  ${isc.DocUtils.linkForRef('type:TitleOrientation')}\n lists valid options.\n <P>\n Note that titles on the left or right take up a cell in tabular\n ${isc.DocUtils.linkForRef('group:formLayout','form layouts')}, but titles on top do not.",
        name:"titleOrientation",
        seeAlso:[
            {ref:"attr:DynamicForm.titleOrientation", description:null}
        ],
        valueType:"TitleOrientation",
        defaultValue:"Canvas.LEFT",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["title"]
    },
    "group:dragResize":{
        ref:"group:dragResize",
        refs:["classMethod:Canvas.getEventEdge"],
        name:"dragResize",
        seeAlso:[],
        type:"group"
    },
    "method:Toolbar.getButtonNumber":{
        ref:"method:Toolbar.getButtonNumber",
        flags:"A",
        description:"			get the index of a button in the buttons array<p>\n          The button can be specified as - \n          <ul>\n          <li>an index within this.buttons (just returned)\n          <li>the ID property of a button\n          <li>a pointer to the button descriptor object in this.buttons\n          <li>the actual button widget in this.members\n          </ul><p>\n			returns -1 if not found\n\n",
        name:"getButtonNumber",
        seeAlso:[],
        params:[
            {description:null, optional:false, name:"button", defaultValue:null,
             type:"number | string  | button object | button widget"}
        ],
        returns:{description:"index of the button in question", type:"number"},
        type:"method",
        definingClass:"class:Toolbar"
    },
    "attr:ListGrid.sortFieldNum":{
        deprecated:"as of version 7.0 in favor of ${isc.DocUtils.linkForRef('attr:ListGrid.sortField')}",
        flags:"IRW",
        type:"attr",
        ref:"attr:ListGrid.sortFieldNum",
        description:"Specifies the number of the field by which to sort this listGrid. Column numbers\n          start at 0 for the left-most column.",
        name:"sortFieldNum",
        valueType:"number",
        seeAlso:[],
        examples:["${isc.DocUtils.linkForExampleId('sort')}"],
        defaultValue:"null",
        groups:["sorting"],
        definingClass:"class:ListGrid"
    },
    "method:FormItem.updateState":{
        ref:"method:FormItem.updateState",
        flags:"A",
        description:" Update the visual state of a FormItem to reflect any changes in state or any changes in\n style settings (eg ${isc.DocUtils.linkForRef('attr:FormItem.textBoxStyle')}). \n <P>\n Calls to <code>updateState()</code> normally occur automatically as a consequence of\n focus changes, items becoming disabled, etc.  This method is advanced and intended only\n for use in workarounds.\n\n",
        name:"updateState",
        seeAlso:[],
        type:"method",
        definingClass:"class:FormItem"
    },
    "attr:DatabaseBrowser.includeSubstring":{
        ref:"attr:DatabaseBrowser.includeSubstring",
        flags:"IR",
        description:"If set, specifies a substring which must exist in a table name for it to be included in\n this DatabaseBrowser.  If this property is set to a List of strings, table names are\n included if they match any one of the strings.  The comparison is case-insensitive.\n <p>\n For example, <code>includeSubstring: [\"E\", \"qry\"]</code> would match all the following \n table names: \"table\", \"QryTbl\", \"QRY\", \"ORDERS\"",
        name:"includeSubstring",
        seeAlso:[],
        valueType:"String | List of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DatabaseBrowser"
    },
    "attr:FormItem.errorMessageWidth":{
        ref:"attr:FormItem.errorMessageWidth",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors')} and ${isc.DocUtils.linkForRef('attr:FormItem.showErrorText')} are both true and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorOrientation')} is \"left\" or \"right\", errorMessageWidth is the amount to reduce\n the width of the editor to accomodate the error message and icon.",
        name:"errorMessageWidth",
        seeAlso:[],
        valueType:"int",
        defaultValue:"80",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["validation"]
    },
    "attr:SectionItem.sectionExpanded":{
        ref:"attr:SectionItem.sectionExpanded",
        flags:"IR",
        description:"Whether this form section should be initially collapsed. Can be set programatically\n via ${isc.DocUtils.linkForRef('method:SectionItem.expandSection')} and ${isc.DocUtils.linkForRef('method:SectionItem.collapseSection')}.",
        name:"sectionExpanded",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('formSections')}"],
        definingClass:"class:SectionItem"
    },
    "method:DataBoundComponent.getField":{
        ref:"method:DataBoundComponent.getField",
        flags:"",
        description:" Return a field by a field index or field name.\n\n",
        name:"getField",
        seeAlso:[],
        params:[
            {description:"field index or field.name", optional:false, name:"fieldID", defaultValue:null,
             type:"String || Number"}
        ],
        returns:{description:"Field description", type:"object"},
        type:"method",
        definingClass:"interface:DataBoundComponent"
    },
    "attr:StatefulCanvas.iconOrientation":{
        ref:"attr:StatefulCanvas.iconOrientation",
        flags:"IR",
        description:"If this button is showing an icon should it appear to the left or right of the title?\n valid options are <code>\"left\"</code> and <code>\"right\"</code>.",
        name:"iconOrientation",
        setter:["setIconOrientation"],
        seeAlso:[],
        valueType:"string",
        defaultValue:"\"left\"",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:["buttonIcon"]
    },
    "class:FusionChart":{
        methods:["method:FusionChart.getDataColor"],
        type:"class",
        requiresModules:["Analytics"],
        ref:"class:FusionChart",
        classAttrs:[],
        treeLocation:["Optional Modules/Analytics"],
        classMethods:[],
        description:"Component that wraps the FusionCharts charting engine.\n <P>\n Provides multiple-series (area, bar, column, line, radar) and single-series (doughnut, pie)\n chart types. These charts all depict a single continuous dimension (eg revenue), broken down\n by one or two discrete dimensions (eg product, region).",
        attrs:["attr:FusionChart.chartsBaseURL", "attr:FusionChart.chartURL", 
         "attr:FusionChart.fusionVersion","attr:FusionChart.chartProperties", "attr:FusionChart.dataColors"],
        implementsInterfaces:["Chart"],
        name:"FusionChart",
        seeAlso:[]
    },
    "method:GridRenderer.cellMouseDown":{
        ref:"method:GridRenderer.cellMouseDown",
        flags:"A",
        description:" Called when a cell receives a mousedown event.\n \n",
        name:"cellMouseDown",
        seeAlso:[],
        params:[
            {description:"cell record as returned by getCellRecord()", optional:false, name:"record",
             defaultValue:null, type:"object"},
            {description:"row number for the cell", optional:false, name:"rowNum", defaultValue:null,
             type:"number"},
            {description:"column number of the cell", optional:false, name:"colNum", defaultValue:null,
             type:"number"}
        ],
        returns:{description:"whether to cancel the event", type:"boolean"},
        type:"method",
        definingClass:"class:GridRenderer",
        groups:["events"]
    },
    "attr:FormItem.showFocused":{
        ref:"attr:FormItem.showFocused",
        flags:"IRWA",
        description:"When this item recieves focus, should it be re-styled to indicate it has focus?",
        name:"showFocused",
        seeAlso:[
            {ref:"attr:FormItem.cellStyle", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["appearance"]
    },
    "method:MenuItem.checkIf":{
        ref:"method:MenuItem.checkIf",
        flags:"",
        description:" Contains the condition that will check or uncheck the curent menuItem. The handler must be specified\n as a function or string of script.  Return false to uncheck the menuItem or true to check it\n <p>\n If you don't need to set this state dynamically, use ${isc.DocUtils.linkForRef('attr:MenuItem.checked')} instead.\n <p>\n May be defined as a ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')}.\n <p>\n",
        name:"checkIf",
        seeAlso:[],
        params:[
            {description:"${isc.DocUtils.linkForRef('attr:Menu.target','target')} attribute for the top level menu.",
             optional:false, name:"target", defaultValue:null, type:"Canvas"},
            {description:"${isc.DocUtils.linkForRef('class:Menu','menu')} contains the reference to the menu that contains the current item",
             optional:false, name:"menu", defaultValue:null, type:"Menu"},
            {description:"contains the reference to the current item", optional:false, name:"item",
             defaultValue:null, type:"MenuItem"}
        ],
        returns:{description:"Return true to show a checkmark by this menu item", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('menuDynamicItems')}"],
        definingClass:"object:MenuItem",
        groups:["dynamicMenuItem"]
    },
    "attr:CubeGrid.canReorderColumns":{
        ref:"attr:CubeGrid.canReorderColumns",
        flags:"IRW",
        description:"If true, body columns can be reordered via the innermost column headers.",
        name:"canReorderColumns",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:["facetLayout"]
    },
    "attr:ImgButton.align":{
        ref:"attr:ImgButton.align",
        flags:"IRW",
        description:"Horizontal alignment of this component's title.",
        name:"align",
        seeAlso:[],
        valueType:"Alignment",
        defaultValue:"Canvas.CENTER",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:["appearance"]
    },
    "attr:Canvas.shadowDepth":{
        ref:"attr:Canvas.shadowDepth",
        flags:"IR",
        description:"Depth of the shadow, or the virtual height above the page of the widget throwing the shadow.\n <P>\n This is a single parameter that can be used to control both <code>shadowSoftness</code> and\n <code>shadowOffset</code>.",
        name:"shadowDepth",
        seeAlso:[],
        valueType:"number",
        defaultValue:"4",
        type:"attr",
        definingClass:"class:Canvas",
        groups:["shadow"]
    },
    "method:Canvas.setSnapTo":{
        ref:"method:Canvas.setSnapTo",
        flags:"",
        description:" Set the snapTo property of this canvas, and handle repositioning.\n\n",
        name:"setSnapTo",
        seeAlso:[],
        params:[
            {description:"new snapTo value", optional:false, name:"snapTo", defaultValue:null,
             type:"string"}
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "method:Calendar.eventMoved":{
        ref:"method:Calendar.eventMoved",
        flags:"",
        description:" Called when an event is moved via dragging by a user.  Return false to disallow the move.\n",
        name:"eventMoved",
        seeAlso:[],
        params:[
            {description:"new date and time that event is being moved to", optional:false,
             name:"newDate", defaultValue:null, type:"Date"},
            {description:null, optional:false, name:"event", defaultValue:null, type:"CalendarEvent"}
        ],
        type:"method",
        definingClass:"class:Calendar",
        groups:["monthViewEvents"]
    },
    "attr:MenuItem.title":{
        ref:"attr:MenuItem.title",
        flags:"IR",
        description:"The text displayed for the menu item",
        name:"title",
        seeAlso:[],
        valueType:"HTML",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MenuItem",
        groups:["menuBasic"]
    },
    "attr:ListGrid.stopOnErrors":{
        ref:"attr:ListGrid.stopOnErrors",
        flags:"IRWA",
        description:"If this is an editable listGrid, this property determines how failure to save due to \n validation errors should be displayed to the user.\n <P>\n If this property is true, when validation errors occur the errors will be displayed\n to the user in an alert, and focus will be returned to the first cell to fail validation.\n <P>\n If false, this the cells that failed validation will be silently styled with the \n editFailedBaseStyle.<br>\n <b>Note:</b> stopOnErrors being set to true implies that 'waitForSave' is also true.\n We will not dismiss the editor until save has completed if stopOnErrors is true.",
        name:"stopOnErrors",
        seeAlso:[
            {ref:"attr:ListGrid.waitForSave", description:null}
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["editing"]
    },
    "method:ListGrid.clearFieldError":{
        ref:"method:ListGrid.clearFieldError",
        flags:"",
        description:" Clears any validation errors for some cell.\n",
        name:"clearFieldError",
        seeAlso:[
            {ref:"method:ListGrid.setFieldError", description:null}
        ],
        params:[
            {description:"row index of cell to add validation error for", optional:false,
             name:"rowNum", defaultValue:null, type:"number"},
            {description:"col index or field name of cell to add validation error for",
             optional:false, name:"fieldName", defaultValue:null, type:"number | string"}
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:["gridValidation"]
    },
    "class:FacetValue":{
        methods:["method:FacetValue.getCellValue", "method:FacetValue.formatCellValue"],
        ref:"class:FacetValue",
        classAttrs:[],
        classMethods:[],
        treeLocation:["Optional Modules/Analytics/CubeGrid"],
        attrs:["attr:FacetValue.id", "attr:FacetValue.title", "attr:FacetValue.parentId", 
         "attr:FacetValue.canEdit","attr:FacetValue.collapsed", "attr:FacetValue.canCollapse", 
         "attr:FacetValue.isMinimizeValue","attr:FacetValue.width", "attr:FacetValue.align", "attr:FacetValue.cellAlign", 
         "attr:FacetValue.borderBefore","attr:FacetValue.borderAfter", "attr:FacetValue.selectionBoundary", 
         "attr:FacetValue.titleHilite"],
        description:"Facet value definition object made use of by the CubeGrid class (contained by facets)",
        name:"FacetValue",
        seeAlso:[],
        type:"class",
        requiresModules:["Analytics"]
    },
    "method:List.dataChanged":{
        ref:"method:List.dataChanged",
        flags:"A",
        description:" Method called when this array changes in some way.  Observe the method to react to changes in\n this list.\n <P>\n Note: dataChanged() will only fire when items are added, removed or rearranged.  If a list\n contains objects, dataChanged() will not fire if changes are made to objects within the list\n without changing their position within the list.  If an observer of dataChanged() needs to react\n to such a change, you can manually fire dataChanged() by simply calling it.\n <P>\n Note: may be called multiple times as the result of a multi-item add or remove, etc.\n\n",
        name:"dataChanged",
        seeAlso:[],
        type:"method",
        definingClass:"interface:List",
        groups:["modification"]
    },
    "attr:ListGrid.canSort":{
        ref:"attr:ListGrid.canSort",
        flags:"IRW",
        description:"Enables or disables interactive sorting behavior for this listGrid. Does not\n          affect sorting by direct calls to the sort method.",
        name:"canSort",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["sorting"]
    },
    "class:LinkItem":{
        methods:["method:LinkItem.setLinkTitle"],
        ref:"class:LinkItem",
        classAttrs:[],
        classMethods:[],
        attrs:["attr:LinkItem.target", "attr:LinkItem.linkTitle"],
        description:"A FormItem that displays an HTML link",
        name:"LinkItem",
        seeAlso:[],
        type:"class"
    },
    "attr:DSRequest.requestId":{
        ref:"attr:DSRequest.requestId",
        flags:"RA",
        description:"Automatically generated unique ID for this request. This ID will be required by developers \n making use of the ${isc.DocUtils.linkForRef('type:DSProtocol','\"clientCustom\" dataProtocol')}.",
        name:"requestId",
        seeAlso:[],
        valueType:"String",
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:FormItem.ID":{
        ref:"attr:FormItem.ID",
        flags:"IRW",
        description:"Global identifier for referring to the formItem in JavaScript.  The ID property is\n optional if you do not need to refer to the widget from JavaScript, or can refer to it\n indirectly (for example, via <code>form.getItem(\"<i>itemName</i>\")</code>).\n <P>\n An internal, unique ID will automatically be created upon instantiation for any formItem\n where one is not provided.",
        name:"ID",
        seeAlso:[],
        valueType:"identifier",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:["basics"]
    },
    "attr:ListGrid.valueIconHeight":{
        ref:"attr:ListGrid.valueIconHeight",
        flags:"IRW",
        description:"Height for value icons for this listGrid.\n Overrides ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconSize')}.\n Can be overridden at the field level",
        name:"valueIconHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:["imageColumns"]
    },
    "type:SortArrow":{
        ref:"type:SortArrow",
        values:[
            {description:"Don't show a sort arrow at all.", value:"\"none\""},
            {description:"Display sort arrow in the upper-right corner (above the scrollbar) only.",
             value:"\"corner\""},
            {description:"Display sort arrow above each field header only.", value:"\"field\""},
            {description:"Display sort arrow above each field header AND in corner above scrollbar.BOTH:\"both\", // NOTE: Canvas establishes this constant",
             value:"\"both\""}
        ],
        description:"Do we display an arrow for the sorted field ?",
        name:"SortArrow",
        seeAlso:[],
        type:"type",
        groups:["sorting", "appearance"]
    },
    "attr:TileGrid.autoFetchAsFilter":{
        ref:"attr:TileGrid.autoFetchAsFilter",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:TileGrid.autoFetchData')} is <code>true</code>, this attribute determines\n whether the initial fetch operation should be performed via ${isc.DocUtils.linkForRef('method:TileGrid.fetchData')} or\n ${isc.DocUtils.linkForRef('method:TileGrid.filterData')}",
        name:"autoFetchAsFilter",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TileGrid",
        groups:["databinding"]
    },
    "attr:PickList.emptyPickListHeight":{
        ref:"attr:PickList.emptyPickListHeight",
        flags:"IRW",
        description:"Height for an empty pick list (showing the empty message), if the pick list has no\n records and ${isc.DocUtils.linkForRef('attr:PickList.hideEmptyPickList')} is <code>false</code>.",
        name:"emptyPickListHeight",
        seeAlso:[],
        valueType:"number",
        defaultValue:"100",
        type:"attr",
        definingClass:"interface:PickList"
    },
    "method:Window.addMember":{
        ref:"method:Window.addMember",
        flags:"A",
        description:"\n  Add a canvas to the layout, optionally at a specific position.\n\n",
        name:"addMember",
        seeAlso:[
            {ref:"method:Window.addMembers", description:null}
        ],
        params:[
            {description:"the canvas object to be added to the layout", optional:false,
             name:"newMember", defaultValue:null, type:"canvas"},
            {description:"the position in the layout to place newMember (starts with 0);                                  if omitted, it will be added at the last position",
             optional:true, name:"position", defaultValue:null, type:"number"}
        ],
        type:"method",
        definingClass:"class:Window"
    },
    "method:ListGrid.getGroupNodeHTML":{
        ref:"method:ListGrid.getGroupNodeHTML",
        flags:"",
        description:" Returns the HTML code necessary to render a group node, including icon, title, and padding.\n The amount of the padding is at least ${isc.DocUtils.linkForRef('attr:ListGrid.groupLeadingIndent')} pixels, and\n an additional ${isc.DocUtils.linkForRef('attr:ListGrid.groupIndentSize')} pixels for each increasing level of the\n node.\n",
        name:"getGroupNodeHTML",
        seeAlso:[],
        params:[
            {description:"Specified group node", optional:false, name:"node", defaultValue:null,
             type:"Object"}
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:Layout.managePercentBreadth":{
        ref:"attr:Layout.managePercentBreadth",
        flags:"IR",
        description:"If set, a Layout with breadthPolicy:\"fill\" will specially interpret a percentage breadth on\n a member as a percentage of available space excluding the ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')}.  If false,\n percentages work exactly as for a non-member, with layoutMargins, if any, ignored.",
        name:"managePercentBreadth",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Layout"
    },
    "method:Canvas.animateFade":{
        ref:"method:Canvas.animateFade",
        flags:"",
        description:" Animate a change in opacity from the widget's current opacity to the specified opacity.\n",
        name:"animateFade",
        seeAlso:[],
        params:[
            {description:"desired final opacity", optional:false, name:"opacity", defaultValue:null,
             type:"number"},
            {description:"When the fade completes this callback will be fired. Single                              'earlyFinish' parameter will be passed if the animation was\n                              cut short by a call to finishAnimation",
             optional:true, name:"callback", defaultValue:null, type:"callback"},
            {description:"Duration in ms of the animated fade", optional:true, name:"duration",
             defaultValue:null, type:"number"},
            {description:"Optional animation acceleration to bias the ratios", optional:true,
             name:"acceleration", defaultValue:null, type:"AnimationAcceleration"}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('animateFade')}"],
        definingClass:"class:Canvas",
        groups:["animation"]
    },
    "type:MenuFieldID":{
        ref:"type:MenuFieldID",
        values:[
            {description:"Displays the icon field for the menu. This field contains the items                  specified icon (if there is one), or if the item is checked, the \n                  checkmark icon for the item.",
             value:"\"icon\""},
            {description:"Displays the item's title", value:"\"title\""},
            {description:"Displays the key field for the menu. This field contains the name or                title of any shortcut keys for this menu item.",
             value:"\"key\""},
            {description:"Field to display the submenu image for items that have a submenu.",
             value:"\"subMenu\""}
        ],
        description:"Simple string identifiers for standard menu fields.",
        name:"MenuFieldID",
        seeAlso:[],
        type:"type"
    },
    "classAttr:ValidatorTypes.dateRange":{
        ref:"classAttr:ValidatorTypes.dateRange",
        flags:"IR",
        description:"Tests whether the value for a date field is within the range specified.\n Range is inclusive, and is specified via <code>validator.min</code> and\n <code>validator.max</code>, which should be dates.<br>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>\\${...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        name:"dateRange",
        seeAlso:[],
        valueType:"validatorDefinition",
        defaultValue:"object",
        type:"classAttr",
        definingClass:"class:ValidatorTypes"
    },
    "method:Canvas.getScrollRight":{
        ref:"method:Canvas.getScrollRight",
        flags:"",
        description:" Returns the scrollLeft required to scroll horizontally to the end of this widget's content.\n",
        name:"getScrollRight",
        seeAlso:[],
        type:"method",
        definingClass:"class:Canvas",
        groups:["scrolling"]
    },
    "method:ValuesManager.validate":{
        ref:"method:ValuesManager.validate",
        flags:"",
        description:" Validate the current set of values for this values manager against validators defined\n in the member forms. For databound valuesManagers, also perform validation against any\n validators defined on datasource fields.\n <P>\n Note that if validation errors occur for a value that is not shown in any member forms,\n those errors will cause a warning and ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')} will be\n called.  This can occur if:<br>\n - A datasource field has no correspending item in any member form<br>\n - The item in question is hidden<br>\n - The member form containing the item is hidden.\n\n",
        name:"validate",
        seeAlso:[],
        returns:{description:"true if all validation passed", type:"boolean"},
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('formSplitting')}"],
        definingClass:"class:ValuesManager"
    },
    "method:Canvas.getPageBottom":{
        ref:"method:Canvas.getPageBottom",
        flags:"",
        description:" Return the page-relative bottom coordinate of this object, in pixels.\n",
        name:"getPageBottom",
        seeAlso:[],
        returns:{description:"GLOBAL bottom coordinate", type:"number"},
        type:"method",
        definingClass:"class:Canvas",
        groups:["positioning"]
    },
    "attr:GridRenderer.fastCellUpdates":{
        ref:"attr:GridRenderer.fastCellUpdates",
        flags:"I",
        description:"Whether to speed up dynamic styling at the expense of slightly slower drawing.\n <P>\n <code>fastCellUpdates</code> speeds up the dynamic styling system used by rollovers,\n selections, and custom styling that calls ${isc.DocUtils.linkForRef('method:GridRenderer.refreshCellStyle')}, at\n the cost of slightly slower draw() and redraw() times.",
        name:"fastCellUpdates",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:GridRenderer"
    },
    "classMethod:MathFunction.getDefaultFunctionIndex":{
        ref:"classMethod:MathFunction.getDefaultFunctionIndex",
        flags:"",
        description:" Returns an index of all default registered functions by name, ordered by \n ${isc.DocUtils.linkForRef('attr:MathFunction.defaultSortPosition')}.\n \n",
        name:"getDefaultFunctionIndex",
        seeAlso:[],
        returns:{description:null, type:"Index"},
        type:"classMethod",
        definingClass:"class:MathFunction",
        groups:["formulaFields"]
    },
    "attr:Canvas.dragOpacity":{
        ref:"attr:Canvas.dragOpacity",
        flags:"IRWA",
        description:"If this widget has dragAppearance <code>\"target\"</code>, this value specifies the\n opacity to render the target while it is being dragged. A null value implies we do\n not modify the opacity.",
        name:"dragOpacity",
        seeAlso:[],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        examples:["${isc.DocUtils.linkForExampleId('dragEffects')}"],
        definingClass:"class:Canvas",
        groups:["dragdrop"]
    },
    "classMethod:XMLTools.parseXML":{
        ref:"classMethod:XMLTools.parseXML",
        flags:"",
        description:" Parse XML text into an ${isc.DocUtils.linkForRef('type:XMLDocument')}.  Parse errors, if any, are reported to the log.\n\n",
        name:"parseXML",
        seeAlso:[],
        params:[
            {description:"XML text to be parsed", optional:false, name:"xmlText", defaultValue:null,
             type:"String"}
        ],
        returns:{description:"resulting XMLDocument", type:"XMLDocument"},
        type:"classMethod",
        definingClass:"class:XMLTools"
    },
    "method:ColorPicker.colorSelected":{
        ref:"method:ColorPicker.colorSelected",
        flags:"",
        description:" Override this method to be notified when the user selects a color\n either by clicking a basic color box in simple mode, or by clicking \n the OK button in complex mode. It is not intended that client code \n call this method.\n",
        name:"colorSelected",
        seeAlso:[
            {ref:"method:ColorPicker.colorChanged", description:null}
        ],
        params:[
            {description:"The color selected, in HTML format", optional:false, name:"color",
             defaultValue:null, type:"String"},
            {description:"The opacity selected, from 0-100.", optional:false, name:"opacity",
             defaultValue:null, type:"Number"}
        ],
        type:"method",
        definingClass:"class:ColorPicker"
    },
    "attr:DataSourceField.detail":{
        ref:"attr:DataSourceField.detail",
        flags:"IR",
        description:"Whether this field should be considered a \"detail\" by a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}.\n <P>\n Detail fields won't be shown by default in a DataBoundComponent where \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.showDetailFields')} is false.  This allows for some DataBound\n components, like a ${isc.DocUtils.linkForRef('class:ListGrid')}, to show a summary view of records which displays only \n the most commonly viewed fields by default, while other DataBoundComponents, like a\n ${isc.DocUtils.linkForRef('class:DetailViewer')}, show all fields by default.\n <P>\n In addition, the ${isc.DocUtils.linkForRef('method:FormItem.showIf','formItem.showIf')} property is supported in multiple\n components for conditional visibility - see for example ${isc.DocUtils.linkForRef('method:ListGridField.showIf')} and\n ${isc.DocUtils.linkForRef('method:FormItem.showIf')}).",
        name:"detail",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DataSourceField",
        groups:["componentBinding"]
    },
    "attr:Calendar.scrollToWorkday":{
        ref:"attr:Calendar.scrollToWorkday",
        flags:"IR",
        description:"If set, causes the ${isc.DocUtils.linkForRef('attr:Calendar.workdayStart','workday hours')} to be sized to fill the available space\n in the day view and week view, and automatically scrolls these views to the start of the\n workday when the calendar is first displayed and whenever the user switches to a new day or\n week.",
        name:"scrollToWorkday",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar",
        groups:["workday"]
    },
    "method:ColorPicker.getHtmlColor":{
        ref:"method:ColorPicker.getHtmlColor",
        flags:"",
        description:" Returns the currently-selected color, in HTML color representation form, as a string.\n HTML color representation is a hash sign, followed by the red, green and blue elements\n of the color in 2-digit hex form - for example \"#F17F1D\"\n",
        name:"getHtmlColor",
        seeAlso:[
            {ref:"method:ColorPicker.setHtmlColor", description:null}
        ],
        returns:{description:"HTML color value", type:"String"},
        type:"method",
        definingClass:"class:ColorPicker"
    },
    "method:FormItem.doubleClick":{
        ref:"method:FormItem.doubleClick",
        flags:"",
        description:" Called when this FormItem is double-clicked.\n\n",
        name:"doubleClick",
        seeAlso:[],
        params:[
            {description:"the managing DynamicForm instance", optional:false, name:"form",
             defaultValue:null, type:"DynamicForm"},
            {description:"the form item itself (also available as \"this\")", optional:false,
             name:"item", defaultValue:null, type:"FormItem"}
        ],
        type:"method",
        definingClass:"class:FormItem",
        groups:["eventHandling"]
    },
    "method:SectionStack.hideSection":{
        ref:"method:SectionStack.hideSection",
        flags:"",
        description:" \n Hides a section or sections.  This includes the section header and its items.  The space\n vacated by this action is reassigned to the nearest visible section item above this\n section.  If there are no visible section items above this section, the space is\n reassigned to the nearest visible section item below this section.\n\n",
        name:"hideSection",
        seeAlso:[
            {ref:"method:SectionStack.collapseSection", description:null}
        ],
        params:[
            {description:"Section(s) to hide.  For this parameter, you can pass the position \n                      of the section in the SectionStack, the ID of the section, or a\n                      List of sectionIDs",
             optional:false, name:"sections", defaultValue:null,
             type:"position|sectionId|list of sectionIDs"},
            {description:"callback to fire when the section has been hidden", optional:true,
             name:"callback", defaultValue:null, type:null}
        ],
        type:"method",
        examples:["${isc.DocUtils.linkForExampleId('sectionsShowAndHide')}"],
        definingClass:"class:SectionStack"
    },
    "attr:ColumnTree.showOpenIcons":{
        ref:"attr:ColumnTree.showOpenIcons",
        flags:"IRW",
        description:"If true, show a different icon for <code>open</code> folders than closed folders.\n This is achieved by appending the ${isc.DocUtils.linkForRef('attr:ColumnTree.openIconSuffix')} onto the \n ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')} URL [for example <code>\"[SKIN]/folder.gif\"</code> might be \n replaced by <code>\"[SKIN]/folder_open.gif\"</code>.<br>\n <b>Note</b> If this property is set to <code>false</code> the same icon is shown for\n open folders as for closed folders, unless a custom folder icon was specified. This will be\n determined by ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')} plus the ${isc.DocUtils.linkForRef('attr:ColumnTree.closedIconSuffix')}.",
        name:"showOpenIcons",
        seeAlso:[],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        