isc.ExampleTree.create({
    ID:"exampleTree",
    nodeVisibility:"sdk",
    root:{
        name:"root/",
        children:[
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/house.png",
                screenshot:"screenshots/tabs_ds_code.png",
                screenshotHeight:"176",
                screenshotWidth:"291",
                showSkinSwitcher:"true",
                description:"\n    Welcome to the SmartClient Feature Tour!\n    <BR>\n    <BR>\n    Click on the name of an example in the tree on the left to load it.\n    <BR>\n    <BR>\n    With an example loaded, you can view source code by clicking on the tabs shown above the\n    running example.\n    <BR>\n    <BR>\n    For an overview of how to use this Feature Explorer, including specific instructions for\n    using code shown here in a standalone application, please see the <a target=_blank\n    href='${isc.ExampleViewer.getRefDocsURL()}#featureExplorerOverview'>\n    Feature Explorer Overview</a> topic in the Reference Docs.\n    \n      \n\n",
                isOpen:true,
                id:"Welcome",
                title:"Featured Samples",
                children:[
                    {jsURL:"welcome/helloButton.js", xmlURL:"welcome/helloButton.xml",
                     description:"\n        A SmartClient <code>IButton</code> component responds to mouse clicks by showing a\n        modal <code>Dialog</code> component with the \"Hello world!\" message.  Source code is\n        provided in both XML and JS formats.\n        ", title:"Hello World"},
                    {
                        jsURL:"welcome/helloStyled.js",
                        visibility:"sdk",
                        xmlURL:"welcome/helloStyled.xml",
                        description:"\n        This <code>Label</code> component is heavily styled with a combination of CSS class,\n        CSS attribute shortcuts, and SmartClient attributes.  Source code is\n        provided in both XML and JS formats.\n        ",
                        tabs:[
                            {title:"CSS", url:"welcome/helloStyled.css"}
                        ],
                        title:"Hello World (styling)"
                    },
                    {jsURL:"welcome/helloForm.js", visibility:"sdk", xmlURL:"welcome/helloForm.xml",
                     description:"\n        This SmartClient <code>FormLayout</code> provides a text field and a button control.\n        Type your name in the field, then click the button for a personalized message.\n        Source code is provided in both XML and JS formats.\n        ", title:"Hello You (form)"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/cal.png", ref:"databoundCalendar",
                     title:"Databound Calendar"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_put.png",
                     ref:"fetchOperation", description:"\n        <p>Rows are fetched automatically as the user drags the scrollbar. Drag the \n        scrollbar quickly to the bottom to fetch a range near the end (a prompt will appear \n        during server fetch).</p>\n        <p>Scroll slowly back up to fill in the middle.</p>\n        <p>Another key unique feature of SmartClient is lazy rendering of <b>columns</b>. Most \n        browsers cannot handle displaying a large number of column and have serious \n        performance issues. SmartClient, however, does not render all columns outside the \n        visible area by default and only renders them as you scroll horizontally. You can \n        however disable this feature if desired.</p>\n        <p>You can control how far ahead of the currently visible area rows should be \n        rendered. This is expressed as a ratio from viewport size to rendered area size. \n        The default is 1.3.</p>\n        <p>Tweaking drawAheadRatio allows you to make tradeoffs between continuous \n        scrolling speed vs initial render time and render time when scrolling by large \n        amounts.</p> ",
                     title:"Live Grid"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/sc_insertformula.png",
                     ref:"filterBuilderBracket", title:"Advanced Filter"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_view_detail.png",
                     ref:"adaptiveFilter", title:"Adaptive Filter"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_side_tree.png",
                     ref:"dynamicGrouping", title:"Dynamic Grouping"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_view_detail.png",
                     ref:"dynamicFreeze", title:"Dynamic Frozen Columns"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/arrow_out.png", ref:"massUpdate",
                     title:"Mass Update"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_split.png",
                     ref:"relatedRecords", title:"Related Records"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_view_columns.png",
                     ref:"databoundDependentSelects", title:"Dependent Selects (Grid)"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_view_columns.png",
                     ref:"formDependentSelects", title:"Dependent Selects (Form)"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/database_link.png",
                     ref:"databoundDragCopy", title:"Databound Dragging"},
                    {
                        dataSource:"supplyCategory",
                        fullScreen:"true",
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/application_osx.png",
                        jsURL:"demoApp/demoAppJS.js",
                        needServer:"true",
                        screenshot:"demoApp/demoApp.png",
                        screenshotHeight:"337",
                        screenshotWidth:"480",
                        xmlURL:"demoApp/demoAppXML.xml",
                        description:"Demonstrates a range of SmartClient GUI components, data binding operations,\n        and layout managers in a single-page application.\n        ",
                        tabs:[
                            {title:"supplyItem", url:"supplyItem.ds.xml"}
                        ],
                        id:"showcaseApp",
                        title:"Complete Application"
                    },
                    {ref:"serverExamples", isOpen:true, title:"Server Examples"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/application_view_tile.png",
                     ref:"tilingFilter", title:"Tile Sort & Filter"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/cube_simple.png", ref:"basicCube",
                     title:"Simple Cube"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/cube_simple.png", ref:"analytics",
                     title:"Advanced Cube"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/pencil.png", ref:"Drawing",
                     showSkinSwitcher:false, title:"Drawing Preview"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/world.png", ref:"portal",
                     title:"Portal Preview"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/printer.png", ref:"printing",
                     title:"Printing"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/database_table.png", ref:"patternReuse",
                     title:"Pattern Reuse"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/arrow_in.png", ref:"xmlSchemaImport",
                     title:"Metadata Import"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/bug.png",
                     jsURL:"devConsole/devConsole.js", description:"\nThe Developer Console is a suite of development tools implemented in SmartClient itself.  The\nConsole runs in its own browser window, parallel to your running application, so it is always\navailable: in every browser, and in every deployment environment.<BR> \nClick on the name of a screenshot below to see more information about developer\nconsole features.\n        ",
                     showSkinSwitcher:false, showSource:false, title:"Developer Console"},
                    {jsURL:"docs/docs.js",
                     description:"\n        SmartClient contains over 100 documented components with more than 2000 documented,\n        supported APIs.  All of SmartClient's documentation is integrated into a\n        SmartClient-based, searchable documentation browser, including API reference, concepts,\n        tutorials, live examples, architectural blueprints and deployment instructions.\n        ", showSkinSwitcher:false,
                     showSource:false, title:"SmartClient Docs"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/application_view_columns.png",
                showSkinSwitcher:"true",
                description:"\n    High-performance interactive data grids.\n",
                isOpen:false,
                title:"Grids",
                children:[
                    {
                        description:"\n    Styling, sizing and formatting options for grids, as well as built-in end user controls.\n",
                        isOpen:false,
                        title:"Appearance",
                        children:[
                            {
                                jsURL:"grids/layout/columnOrder.js",
                                description:"\n        Drag and drop the column headers to rearrange columns in the grid.\n        Right-click the column headers to hide or show columns.\n        Click the buttons to hide or show the \"Capital\" column.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"columnOrder",
                                title:"Column order"
                            },
                            {
                                jsURL:"grids/layout/columnSize.js",
                                description:"\n        Click and drag between the column headers to resize columns in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"columnSize",
                                title:"Column size"
                            },
                            {
                                jsURL:"grids/layout/columnAlign.js",
                                visibility:"sdk",
                                description:"\n        Click the radio buttons to change the alignment of the \"Flag\" column.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Column align"
                            },
                            {
                                jsURL:"grids/layout/columnHeaders.js",
                                visibility:"sdk",
                                description:"\n        Click the buttons to show or hide the column headers.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Column headers"
                            },
                            {
                                jsURL:"grids/layout/columnTitles.js",
                                visibility:"sdk",
                                description:"\n        Click the buttons to change the title of the \"Country\" column.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Column titles"
                            },
                            {
                                jsURL:"grids/layout/multiLineValues.js",
                                description:"\n        Click and drag between the \"Background\" and \"Flag\" column headers, or resize your browser\n        window to change the size of the entire grid. The \"Background\" values are\n        confined to a fixed row height.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryDataDetail.js"}
                                ],
                                id:"multilineValues",
                                title:"Multiline values"
                            },
                            {ref:"headerSpans", title:"Header Spans"},
                            {
                                jsURL:"grids/formatting/cellStyles.js",
                                description:"\n        Mouse over the rows and click-drag to select rows, to see the effects of different\n        base styles on these two grids.\n        ",
                                tabs:[
                                    {title:"CSS", url:"grids/formatting/cellStyles.css"},
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Cell styles"
                            },
                            {
                                jsURL:"grids/formatting/addStyle.js",
                                description:"\n        This grid hilites \"Population\" values greater than 1 billion or less than 50 million\n        using additive style attributes (text color and weight).\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"addStyle",
                                title:"Hilite cells (add style)"
                            },
                            {
                                jsURL:"grids/formatting/replaceStyle.js",
                                description:"\n        This grid hilites \"Population\" values greater than 1 billion or less than 50 million\n        using a full set of compound styles (with customized background colors). Mouse over or\n        click-drag rows to see how these styles apply to different row states.\n        ",
                                tabs:[
                                    {title:"CSS", url:"grids/formatting/replaceStyle.css"},
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"replaceStyle",
                                title:"Hilite cells (replace style)"
                            },
                            {
                                jsURL:"grids/formatting/roundedSelection.js",
                                description:"\n        Select the rows to see a custom selection effect with rounded edges achieved via the\n        selectionCanvas subsystem.\n        ",
                                badSkins:"BlackOps",
                                bestSkin:"TreeFrog",
                                tabs:[
                                    {title:"CSS", url:"grids/formatting/simpleCellStyles.css"},
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Rounded Selection"
                            },
                            {
                                jsURL:"grids/formatting/animatedSelection_RollOver.js",
                                description:"\n        RollOver, and select the rows in the grid to see rollover and selection indicators fade\n        into view. This is achieved via the rollOverCanvas and selectionCanvas subsystem. \n        Note that the opacity setting on the rollUnderCanvas allows true color layering.\n        ",
                                tabs:[
                                    {title:"CSS", url:"grids/formatting/simpleCellStyles.css"},
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Animated Selection and RollOvers"
                            },
                            {
                                jsURL:"grids/formatting/rollOverRecticle.js",
                                description:"\n        RollOver the rows in the grid to see a custom roll over recticle effect, \n        achieved via the rollOverCanvas subsystem.\n        ",
                                badSkins:"BlackOps",
                                bestSkin:"TreeFrog",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"RollOver Reticle Effect"
                            },
                            {
                                jsURL:"grids/formatting/rollOverControls.js",
                                description:"\n        RollOver the rows in the grid to row-level controls buttons appear embedded in the row.\n        This example utilizes the rollOverCanvas subsystem to achieve this effect. \n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"RollOver Controls"
                            },
                            {
                                jsURL:"grids/formatting/formatValues.js",
                                description:"\n        This grid applies custom formatters to the \"Nationhood\" and \"Area\" columns.\n        Click on the \"Nationhood\" or \"Area\" column headers to sort the underlying data values.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"formatValues",
                                title:"Format values"
                            },
                            {
                                jsURL:"grids/formatting/emptyValues.js",
                                description:"\n        Double-click any cell, delete its value, and press Enter or click outside the cell to\n        save and display the empty value. This grid shows \"--\" for empty date values, and\n        \"unknown\" for other empty values.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"emptyValues",
                                title:"Empty values"
                            },
                            {
                                jsURL:"grids/layout/emptyGrid.js",
                                description:"\n        Click the buttons to add or remove all data in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"emptyGrid",
                                title:"Empty grid"
                            }
                        ]
                    },
                    {
                        description:"\n    Selection and drag and drop of data, hovers, and grid events.\n",
                        isOpen:false,
                        title:"Interaction",
                        children:[
                            {
                                jsURL:"grids/interaction/rollover.js",
                                visibility:"sdk",
                                description:"\n        Move the mouse over rows in the grid to see rollover highlights.\n        Click the buttons to enable or disable this behavior.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Rollover"
                            },
                            {
                                jsURL:"grids/selection/singleSelect.js",
                                visibility:"sdk",
                                description:"\n        Click to select any single row in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Single select"
                            },
                            {
                                jsURL:"grids/selection/multipleSelect.js",
                                description:"\n        Click to select a single row in the grid. Shift-click to select a continuous range of rows.\n        Ctrl-click to add or remove individual rows from the selection.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"multipleSelect",
                                title:"Multiple select"
                            },
                            {
                                jsURL:"grids/selection/simpleSelect.js",
                                description:"\n        Click to select or deselect any row in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Simple select"
                            },
                            {
                                jsURL:"grids/selection/checkboxSelect.js",
                                description:"\n        By setting selectionAppearance to \"checkbox\", the ListGrid can use checkboxes \n        to indicate the selected state of records. Only by clicking on a checkbox will the \n        corresponding record be selected or unselected.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Checkbox Select"
                            },
                            {
                                jsURL:"grids/selection/dragSelect.js",
                                description:"\n        Click and drag to select a continuous range of rows in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Drag select"
                            },
                            {
                                jsURL:"grids/interaction/valueHover.js",
                                description:"\n        Move the mouse over a value in the \"Government\" column and pause (hover) for a\n        longer description of that value.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"valueHoverTips",
                                title:"Value hover tips"
                            },
                            {
                                jsURL:"grids/interaction/headerHover.js",
                                description:"\n        Move the mouse over a column header and pause (hover) for a longer description\n        of that column.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Header hover tips"
                            },
                            {
                                jsURL:"grids/interaction/dragOrder.js",
                                description:"\n        Drag and drop to change the order of countries in this list.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"gridsDragReorder",
                                title:"Drag reorder"
                            },
                            {
                                jsURL:"grids/interaction/dragMove.js",
                                description:"\n        Drag and drop to move rows between the two lists. \n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"gridsDragMove",
                                title:"Drag move"
                            },
                            {
                                jsURL:"grids/interaction/dragCopy.js",
                                description:"\n        Drag and drop to copy rows from the first list to the second list.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"gridsDragCopy",
                                title:"Drag copy"
                            },
                            {
                                jsURL:"grids/interaction/disabled.js",
                                description:"\n        Mouse over, drag, or click on any values in this grid.\n        All \"Europe\" country records in this grid are disabled.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"disabledRows",
                                title:"Disabled rows"
                            },
                            {
                                jsURL:"grids/interaction/recordClicks.js",
                                description:"\n        Click, double-click, or right-click any row in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"recordClicks",
                                title:"Record clicks"
                            },
                            {
                                jsURL:"grids/interaction/cellClicks.js",
                                description:"\n        Click, double-click, or right-click any value in the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"cellClicks",
                                title:"Cell clicks"
                            }
                        ]
                    },
                    {
                        description:"\n    Various auto-fit behaviors built-in to every Grid\n",
                        isOpen:false,
                        title:"Autofit",
                        children:[
                            {
                                jsURL:"grids/autofit/autoFitFreeSpace.js",
                                description:"\n        By default, grids used in a Layout will fill available space, allowing users to show \n        and hide other components on the screen in order to view and interact with more data \n        at once in the grid.  Imagine that the blue outline represents all the space that is\n        available for this interface.  Click on the \"Details\" header to hide the tabs and\n        reveal more rows.  Click on the resizebar next to the Navigation tree to hide it,\n        allowing more space for columns.\n        ",
                                tabs:[
                                    {title:"supplyItem", url:"supplyItem.ds.xml"}
                                ],
                                id:"autoFitFreeSpace",
                                title:"Free Space"
                            },
                            {
                                jsURL:"grids/autofit/autoFitValues.js",
                                description:"\n        Click and drag between the \"Background\" and \"Flag\" column headers, or resize your browser\n        window to change the size of the entire grid. The rows resize to fit\n        the \"Background\" values.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryDataDetail.js"}
                                ],
                                id:"autofitValues",
                                title:"Cell Values"
                            },
                            {
                                jsURL:"grids/autofit/autoFitRows.js",
                                description:"\n        Click the buttons to show different numbers of records. The grid resizes to fit\n        all rows without scrolling.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"autofitRows",
                                title:"Rows"
                            },
                            {
                                jsURL:"grids/autofit/autoFitColumns.js",
                                description:"\n        Click and drag between the column headers to resize the columns. The grid resizes to\n        fit the new column widths.  The width setting on the grid as a whole acts as a minimum.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"autofitColumns",
                                title:"Columns"
                            },
                            {jsURL:"grids/autofit/autoFitNewRecords.js",
                             description:"\n        Autofit to rows can be made subject to a maximum. Add new rows to the grid, and note that the\n        grid expands to show the new rows. This grid is configured to stop expanding once you have more\n        than 6 rows, and begin scrolling instead.\n        ", id:"autofitNewRecords",
                             title:"New Records"},
                            {
                                jsURL:"grids/autofit/autoFitFilter.js",
                                description:"\n        Change the filter to show the grid resizing within the constraint of its maximum \n        autofit rows. Enter a country filter of \"cook island\" to see the grid shrink down to minimum\n        size. Change the country filter to \"island\" to show the grid at almost maximum size, but\n        not scrolling.  Change the country filter to \"land\" to show the grid scrolling because\n        its maximum autofit size (10) isn't large enough to display all rows.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"autofitFilter",
                                title:"Filter"
                            }
                        ]
                    },
                    {
                        description:"\n    SmartClient grids provide interactive sorting of standard and custom data types,\n    with automatic client/server coordination.\n",
                        isOpen:false,
                        title:"Sort & Filter",
                        children:[
                            {
                                jsURL:"grids/sorting/sort.js",
                                description:"\n        Click on any column header to sort by that column. To reverse the sort direction,\n        click on the same column header, or the top-right corner of the grid.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"sort",
                                title:"Sort"
                            },
                            {
                                jsURL:"grids/sorting/disableSort.js",
                                visibility:"sdk",
                                description:"\n        Sorting is disabled on the \"Flag\" column. Click on any other column header to sort\n        on the corresponding column.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Disable sort"
                            },
                            {
                                jsURL:"grids/sorting/sortArrow.js",
                                visibility:"sdk",
                                description:"\n        Click on any column header to sort or reverse-sort by that column.\n        This grid shows the sort-direction arrow in the top-right corner only.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Sort arrows"
                            },
                            {
                                jsURL:"grids/sorting/dataTypes.js",
                                description:"\n        Click on any column header to sort by that column.\n        The \"Nationhood\", \"Area\", and \"GDP (per capita)\" columns are sorted as date, number, and\n        calculated number values, respectively.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"dataTypes",
                                title:"Data-Aware Sort"
                            },
                            {
                                jsURL:"grids/filtering/filter.js",
                                description:"\n        Type \"island\" above the Country column, then press Enter or click the filter button\n        (top-right corner of the grid) to show only countries with \"island\" in their name.\n        Select \"North America\" above the Continent column to filter countries by that continent.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"filter",
                                title:"Filter"
                            },
                            {
                                jsURL:"grids/filtering/liveFilter.js",
                                description:"\n        Begin typing a country name into in the filter box for the Country column.  Grids can \n        be configured to filter as you type.        \n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"liveFilter",
                                title:"Live Filter"
                            },
                            {
                                jsURL:"grids/filtering/adaptiveFilter.js",
                                description:"\n        SmartClient combines large dataset handling with <b>adaptive</b> use of\n        client-side filtering.  Begin typing an Item name in the filter box above the \"Item\"\n        column.  When the dataset becomes small enough, SmartClient switches to client-side\n        filtering automatically.  Delete part of the item name to see SmartClient automatically\n        switch back to server-side filtering.  The label underneath the grid flashes briefly \n        every time SmartClient needs to visit the server.\n        ",
                                tabs:[
                                    {title:"supplyItem", url:"supplyItem.ds.xml"}
                                ],
                                id:"adaptiveFilter",
                                title:"Adaptive Filter"
                            },
                            {
                                jsURL:"grids/sorting/adaptiveSort.js",
                                description:"\n        SmartClient combines large dataset handling with <b>adaptive</b> use of\n        client-side sort.  Click any header now and server-side sort will be used for this\n        large dataset.  Check \"Limit to Electronics\" to limit the dataset and sort again:\n        when the dataset becomes small enough, SmartClient switches to client-side\n        sorting automatically.  The label underneath the grid flashes briefly \n        every time SmartClient needs to visit the server.\n        ",
                                tabs:[
                                    {title:"supplyItem", url:"supplyItem.ds.xml"}
                                ],
                                id:"adaptiveSort",
                                title:"Adaptive Sort"
                            },
                            {
                                jsURL:"grids/filtering/advancedFilter.js",
                                description:"\n        SmartClient's Advanced Filter feature allows you to create complex, multi-condition \n        filters.  Ordinary DynamicForms can be used to generate AdvancedCriteria objects, as we\n        are doing here, simply by specifying a valid \"operator\" on one or more of the form fields.  \n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"advancedFilter",
                                title:"Advanced Filter"
                            },
                            {
                                jsURL:"grids/filtering/filterBuilder.js",
                                description:"\n        Use the FilterBuilder to construct custom queries that combine multiple criteria across\n        any field in your DataSource.  Note that the operator\n        select list only shows operators suitable for the field selected, and the comparison\n        field changes to suit the type of the selected field (for example, select field \n        \"independence\" and note that the comparison field changes to a date). Add clauses to\n        your query with the \"+\" icon. Click \"Filter\" to see the result in the ListGrid.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"filterBuilder",
                                title:"Custom Filter"
                            },
                            {
                                jsURL:"grids/filtering/filterBuilderBracket.js",
                                description:"\n        Use the FilterBuilder to construct queries of arbitrary complexity.  The FilterBuilder,\n        and the underlying AdvancedCriteria system, support building queries with subclauses\n        nested to any depth. Add clauses to your query with the \"+\" icon; add nested subclauses \n        with the \"+()\" button. Click \"Filter\" to see the result in the ListGrid.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"filterBuilderBracket",
                                title:"Nested Filter"
                            },
                            {
                                jsURL:"grids/sorting/headerSpans.js",
                                description:"\n        HeaderSpans are a second level of headers that appears above the normal ListGrid \n        headers, providing a visual cue for grouping. Resize columns and note that the \n        HeaderSpans change accordingly. Right-click in the header and note that you can hide\n        and display spanned columns as a group, as well as individually.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"headerSpans",
                                title:"Header Spans"
                            },
                            {
                                jsURL:"grids/filtering/disable.js",
                                description:"\n        Type \"island\" above the Country column, then press Enter or click the filter button\n        (top-right corner of the grid) to show only countries with \"island\" in their name.\n        Select \"North America\" above the Continent column to filter countries by that continent.\n        Filtering is disabled on the \"Flag\" and \"Capital\" columns.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"disableFilter",
                                title:"Disable filter"
                            },
                            {ref:"autofitFilter", title:"Autofit filter"}
                        ]
                    },
                    {
                        description:"\n    SmartClient grids provide inline editing of all data types, with automatic validation and\n    client/server updates.<br><br>\n    These examples are all bound to the same remote DataSource, so your\n    changes are saved on SmartClient.com and will appear in all Grid Editing examples during this\n    session. To end your SmartClient.com session and reset the example data on the server, simply\n    close all instances of your web browser.\n",
                        isOpen:false,
                        title:"Editing",
                        children:[
                            {
                                jsURL:"grids/editing/editRows.js",
                                description:"\n        <b>Click</b> on any cell to start editing. Use <b>Tab</b>, <b>Shift-Tab</b>,\n        <b>Up Arrow</b>, and <b>Down Arrow</b> to move between cells. Changes are saved\n        automatically when you move to another row. Press <b>Enter</b> to save the current row\n        and dismiss the editors, or <b>Esc</b> to discard changes for the current row and dismiss\n        the editors.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"editByRow",
                                title:"Edit by row"
                            },
                            {
                                jsURL:"grids/editing/editCells.js",
                                description:"\n        <b>Click</b> on any cell to start editing. Use <b>Tab</b>, <b>Shift-Tab</b>,\n        <b>Up Arrow</b>, and <b>Down Arrow</b> to move between cells. Press <b>Enter</b> to save\n        the current row and dismiss the editors, or <b>Esc</b> to discard changes for the current\n        cell and dismiss the editors.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"editByCell",
                                title:"Edit by cell"
                            },
                            {
                                jsURL:"grids/editing/enterRows.js",
                                description:"\n        <b>Click</b> on any cell to start editing, then <b>Tab</b> or <b>Down Arrow</b> past the\n        last row in the grid to create a new row. Alternatively, click the <b>Edit New</b> button\n        to create a new data-entry row at the end of the grid.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"enterNewRows",
                                title:"Enter new rows"
                            },
                            {ref:"autofitNewRecords", title:"Autofit new rows"},
                            {
                                jsURL:"grids/editing/massUpdate.js",
                                description:"\n        <b>Click</b> on any cell to start editing, then <b>Tab</b> or <b>Down Arrow</b> past the\n        last row in the grid to create a new row. Alternatively, click the <b>Edit New</b> button\n        to create a new data-entry row at the end of the grid. Unlike the other editing examples, \n        none of your changes are being automatically saved to the server.  Note how SmartClient\n        highlights changed values, and new rows. Click the \"Save\" button to save all your \n        changes at once, or click the \"Discard\" button to discard all your changes (including \n        any new rows) and revert to the data as it was before you started editing.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"massUpdate",
                                title:"Mass Update"
                            },
                            {
                                jsURL:"grids/editing/modalEditing.js",
                                description:"\n        <b>Double-click</b> on any cell to start editing. Click anywhere outside of the cell\n        editors to save changes, or press the <b>Esc</b> key to discard changes.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"modalEditing",
                                title:"Modal editing"
                            },
                            {
                                jsURL:"grids/editing/disableEditing.js",
                                description:"\n        <b>Click</b> on any cell to start editing. Use Tab/Arrow keys to move between cells,\n        Enter/Esc keys to save or cancel. Editing is disabled for the \"Country\" and \"G8\" columns.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"disableEditing",
                                title:"Disable editing"
                            },
                            {
                                jsURL:"grids/editing/customEditors.js",
                                description:"\n        <b>Click</b> on any cell to start editing. The \"Government\", \"Population\", and \"Nationhood\"\n        columns specify custom editors: a multiple-line textarea, a numeric spinner, and a compound\n        date control.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"customEditors",
                                title:"Custom editors"
                            },
                            {
                                jsURL:"grids/editing/validation.js",
                                description:"\n        <b>Click</b> on any cell to start editing. Delete the value in a \"Country\" cell, or type a\n        non-numeric value in a \"Population\" cell, to see validation errors.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"dataValidation",
                                title:"Data validation"
                            },
                            {
                                jsURL:"grids/editing/dependentSelects.js",
                                description:"\n                \n                <p />In the first example, <b>Double Click</b> on any row to start editing. Select a value \n                in the \"Division\" column to change the set of options available in the \"Department\" \n                column.\n                <p />\n                <p />In the second example, click the <b>Order New Item</b> button to add an editable row \n                to the grid.  Select a Category in the second column to change the set of options \n                available in the \"Item\" column.\n            ",
                                tabs:[
                                    {dataSource:"supplyItem", name:"supplyItem"},
                                    {dataSource:"supplyCategory", name:"supplyCategory"}
                                ],
                                id:"databoundDependentSelects",
                                title:"Dependent Selects"
                            }
                        ]
                    },
                    {
                        description:"\n    SmartClient supports rendering out grids with frozen fields.<br><br>\n    Frozen fields are fields that do not scroll horizontally with the other fields, remaining\n    visible on the screen while other fields may be scrolled out of view.\n",
                        isOpen:false,
                        title:"Frozen Columns",
                        children:[
                            {
                                jsURL:"grids/freezeFields/simpleFreeze.js",
                                description:"\n        Setting <code>frozen:true</code> on a column definition establishes a\n        frozen column.  Column resize and reorder work normally.\n        ",
                                tabs:[
                                    {dataSource:"supplyItem", name:"supplyItem"}
                                ],
                                id:"simpleFreeze",
                                title:"Simple Freeze"
                            },
                            {
                                jsURL:"grids/freezeFields/dynamicFreeze.js",
                                description:"\n        Right click on any column header to show a menu that allows you to freeze\n        that column.<br>\n        Multiple columns may be frozen, and frozen columns may be\n        reordered.<br>\n        Right click on a frozen column to unfreeze it.\n        ",
                                tabs:[
                                    {dataSource:"supplyItem", name:"supplyItem"}
                                ],
                                id:"dynamicFreeze",
                                title:"Dynamic Freeze"
                            },
                            {
                                jsURL:"grids/freezeFields/freezeEditing.js",
                                description:"\n        SmartClient's inline editing support works normally with frozen columns\n        with no further configuration.\n        ",
                                tabs:[
                                    {dataSource:"supplyItem", name:"supplyItem"}
                                ],
                                id:"canEditFreeze",
                                title:"Editing"
                            },
                            {
                                jsURL:"grids/freezeFields/freezeDragDrop.js",
                                description:"\n        SmartClient's drag and drop support works normally with frozen columns\n        with no further configuration.  Drag countries within grids to reorder them, or between\n        grids to move countries back and forth.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/splitCountryData.js"}
                                ],
                                title:"Drag and Drop"
                            }
                        ]
                    },
                    {
                        isopen:"false",
                        description:"\n    List entries can be grouped according to field value.\n    ",
                        title:"Grouping",
                        children:[
                            {
                                jsURL:"grids/grouping/dynamicGrouping.js",
                                description:"\n        Right click on any column header to show a menu that allows you to group by that \n        column. Right click and pick \"ungroup\" to go back to a flat listing.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"dynamicGrouping",
                                title:"Dynamic Grouping"
                            },
                            {
                                jsURL:"grids/grouping/groupedEditing.js",
                                description:"\n        Inline editing works normally with grouped data. Try editing the field that records \n        are grouped by and notice that the record moves to its new group automatically.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"groupedEditing",
                                title:"Grouped Editing"
                            },
                            {
                                jsURL:"grids/grouping/customGrouping.js",
                                description:"\n        You can specify custom grouping behavior for a field. Group by the Nationhood and \n        Population fields to see examples of custom grouping.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"countryDS",
                                     url:"grids/ds/countrySQLDS.ds.xml"}
                                ],
                                id:"customGrouping",
                                title:"Custom Grouping"
                            }
                        ]
                    },
                    {
                        jsURL:"grids/customColumns.js",
                        descriptionHeight:"220",
                        description:"\n        <b>Formula and Summary fields</b> provide built-in wizards for end users to define \n        formula fields that can compute values using other fields, or summary fields that can \n        combine other fields with intervening / surrounding text. Available in all \n        DataBoundComponents and easy to persist as preferences.\n        <P>\n        The Formula and Summary Builders are accessible from the grid header context menu. They \n        can also be invoked programatically as demonstrated by clicking the buttons in this \n        sample.\n        <P>\n        Launch the Formula Builder and enter the title of the new field, and the desired \n        formula. For example, enter <b>Population Density</b> for the field title and in the \n        formula field enter <b>A / B</b>. As indicated in the dialog, <b>A</b> represents the \n        Population field, and <b>B</b> represents the Area field. Notice that you can now sort on this \n        newly added <b>Population Density</b> field just like any other field. Click the help \n        icon to view the various supported inbuilt functions.\n        <P>\n        Next launch the Summary Builder and enter the title of the new field, and the Summary \n        formulation. For example, enter <b>County (Flag)</b> for the field name and enter \n        <b>#B (#A)</b> in the summary field.\n        <P>\n        Once some additional user-fields have been added, all you need to persist the column-layout\n        for later restoration to another grid, is the ability to save a string.  Click the \n        button below to store the grid's state by calling <i>getFieldState()</i>, destroy the \n        grid and restore it's state to another grid using <i>setFieldState()</i>. \n        \n    ",
                        tabs:[
                            {canEdit:"false", title:"countryDS", url:"grids/ds/countrySQLDS.ds.xml"}
                        ],
                        id:"customColumns",
                        title:"Custom Columns"
                    },
                    {
                        description:"\n    Using the TileGrid to display data in a tiled format.\n",
                        isOpen:false,
                        title:"Tiling",
                        children:[
                            {
                                jsURL:"grids/tiling/basic.js",
                                description:"\n       SmartClient can display data in a \"tiled\" view.  Mouse over widgets to see rollovers, click to\n       select (shift- and ctrl-click for multi-select).\n        ",
                                tabs:[
                                    {title:"animalData", url:"grids/data/animalData.js"}
                                ],
                                id:"tilingBasic",
                                title:"Basic"
                            },
                            {
                                cssURL:"grids/tiling/tileStyle.css",
                                jsURL:"grids/tiling/filter.js",
                                description:"\n        Tiled views can be filtered and sorted just like ListGrids.  Use the \"Search\" form to eliminate\n        some tiles and watch remaining tiles animate to new positions.  Use the \"Sort\" form to change\n        the sort direction.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"animalsDS",
                                     url:"grids/ds/animalsSQLDS.ds.xml"}
                                ],
                                id:"tilingFilter",
                                title:"Filter & Sort"
                            },
                            {jsURL:"grids/tiling/loadOnDemand.js",
                             description:"\n       Tiled views can load data from services via DataSources, just like other data-aware components.\n       Enter a search term to search Yahoo Images and display available images as tiles.  \n        ", id:"tilingLoadOnDemand",
                             title:"Load on Demand"},
                            {
                                cssURL:"grids/tiling/tileStyle.css",
                                jsURL:"grids/tiling/editing.js",
                                description:"\n       Tiled views can be connected to editors.  The TiledView automatically reacts to changes to the\n       underlying dataset.  Change the life span of Gazelle to 2 to see it\n       animate to the beginning of the list.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"animalsDS",
                                     url:"grids/ds/animalsSQLDS.ds.xml"}
                                ],
                                id:"tilingEditing",
                                title:"Editing"
                            }
                        ]
                    },
                    {
                        jsURL:"grids/export.js",
                        requiresModules:"SCServer",
                        description:"\n            It's now easy to export data from a DataSource or from DataboundComponents, \n            such as <i>ListGrid</i>, <i>TreeGrid</i> and <i>TileGrid</i>.  In the example \n            below, choose an Export-Format from the select-list, decide whether to \n            download the results or view them in a window using the checkbox and \n            click the Export button.  Because exporting to JSON is allowed only via \n            server-side custom-code or via an OperationBinding, choosing <i>JSON</i>\n            from the select-item issues the export using the operationId set up in\n            the DataSource but still respects the \"Show in Window\" checkbox.  See the \n            <i>JS</i> and <i>worldDSExport</i> tabs below.\n            <p>Try changing the filters and sort-order on the grid to see that the exported data \n            is filtered and sorted according to criteria applied to the grid.\n        ",
                        tabs:[
                            {canEdit:"false", title:"worldDSExport",
                             url:"grids/ds/worldSQLDSExport.ds.xml"}
                        ],
                        id:"export",
                        title:"Export"
                    },
                    {
                        description:"\n    Built-in display and editing behaviors for common data types, and how to customize them.\n",
                        isOpen:false,
                        id:"gridsDataTypes",
                        title:"Data types",
                        children:[
                            {
                                jsURL:"grids/dataTypes/text.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        All fields in this grid are text fields.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Text"
                            },
                            {
                                jsURL:"grids/dataTypes/image.js",
                                description:"\n        \"Flag\" is an image field.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"imageType",
                                title:"Image"
                            },
                            {
                                jsURL:"grids/dataTypes/longtext.js",
                                description:"\n        Click on data values to edit.\n        \"Government\" is a long text field with a popup editor.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"longText",
                                title:"Long Text"
                            },
                            {
                                jsURL:"grids/dataTypes/date.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        \"Nationhood\" is a date field.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Date"
                            },
                            {
                                jsURL:"grids/dataTypes/integer.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        \"Population\" is an integer field.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Integer"
                            },
                            {
                                jsURL:"grids/dataTypes/decimal.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        \"GDP\" is a decimal (aka float) field.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Decimal"
                            },
                            {
                                jsURL:"grids/dataTypes/boolean.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        \"G8\" is a boolean (true/false) field.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Boolean"
                            },
                            {
                                jsURL:"grids/dataTypes/linkText.js",
                                description:"\n        Click on the values in the \"Info\" column to open external links.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Link (text)"
                            },
                            {
                                jsURL:"grids/dataTypes/linkImage.js",
                                description:"\n        Click on the book images in the \"Info\" column to open external links.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"linkImage",
                                title:"Link (image)"
                            },
                            {
                                jsURL:"grids/dataTypes/list.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        \"Continent\" is a list (aka valueMapped) field.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"listType",
                                title:"List"
                            },
                            {
                                jsURL:"grids/dataTypes/calculated.js",
                                description:"\n        Click on column headers to sort, or data values to edit.\n        \"GDP (per capita)\" is calculated from the \"GDP\" and \"Population\" fields.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"calculatedCellValue",
                                title:"Calculated"
                            }
                        ]
                    },
                    {
                        description:"\n    How to bind grids to DataSources to share field (column) definitions with other components,\n    and how to load data from local and remote data sources and services.    \n",
                        isOpen:false,
                        id:"gridsDataBinding",
                        title:"Data binding",
                        children:[
                            {
                                jsURL:"grids/dataBinding/fieldsGrid.js",
                                description:"\n        This <code>ListGrid</code> takes its field (column) settings from the \"fields\"\n        property of the component definition only. This technique is appropriate for\n        presentation-only grids that do not require data binding.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"listGridFields",
                                title:"ListGrid fields"
                            },
                            {
                                jsURL:"grids/dataBinding/fieldsDS.js",
                                description:"\n        This <code>ListGrid</code> takes its field (column) settings from the\n        <code>countryDS</code> DataSource specified in the \"dataSource\" property of the\n        component definition. This technique is appropriate for easy display of a shared\n        data model with the default UI appearance and behaviors.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"},
                                    {title:"countryDS", url:"grids/ds/countryMergeDS.ds.js"}
                                ],
                                id:"dataSourceFields",
                                title:"DataSource fields"
                            },
                            {
                                jsURL:"grids/dataBinding/fieldsMerged.js",
                                description:"\n        This <code>ListGrid</code> merges field settings from both the component \"fields\"\n        (for presentation attributes) and the <code>countryDS</code> DataSource (for\n        data model attributes). This is the usual approach to customize the look and feel of a\n        data-bound component.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"},
                                    {title:"countryDS", url:"grids/ds/countryMergeDS.ds.js"}
                                ],
                                id:"mergedFields",
                                title:"Merged fields"
                            },
                            {jsURL:"grids/dataProviders/inlineData.js",
                             description:"\n        This <code>ListGrid</code> uses an inline data array in the component definition. This\n        technique is appropriate for very small read-only data sets, typically with static data\n        values.\n        ", id:"inlineData",
                             title:"Inline data"},
                            {
                                jsURL:"grids/dataProviders/localData.js",
                                description:"\n        This <code>ListGrid</code> loads data from a local data array (included in a separate\n        JavaScript data file). This technique is appropriate for read-only data sets, typically\n        with less than 500 records.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"localData",
                                title:"Local data"
                            },
                            {
                                jsURL:"grids/dataProviders/databound.js",
                                description:"\n        This <code>ListGrid</code> binds to a client-only <code>DataSource</code> that loads data\n        from a local data array. This technique is appropriate for client-only rapid prototyping\n        when the production application will support add or update (write operations), switchable\n        data providers (JSON, XML, WSDL, Java), arbitrarily large data sets (1000+ records), or\n        a data model that is shared by multiple components.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"},
                                    {title:"countryDS", url:"grids/ds/countryLocalDS.ds.js"}
                                ],
                                id:"localDataSource",
                                title:"Local DataSource"
                            },
                            {
                                jsURL:"grids/dataProviders/databound.js",
                                description:"\n        This <code>ListGrid</code> binds to a <code>DataSource</code> that loads data from a\n        remote JSON data provider.  This approach of loading simple JSON data over HTTP can be\n        used with PHP and other server technologies.\n        ",
                                tabs:[
                                    {title:"countryDS", url:"grids/ds/countryJSONDS.ds.xml"},
                                    {canEdit:"false", doEval:"false", title:"countryData.json",
                                     url:"grids/data/countryData.json"}
                                ],
                                id:"jsonDataSource",
                                title:"JSON DataSource"
                            },
                            {
                                jsURL:"grids/dataProviders/databound.js",
                                needXML:"true",
                                description:"\n        This <code>ListGrid</code> binds to a <code>DataSource</code> that loads data from a\n        remote XML data provider.  This approach of loading simple XML data over HTTP can be\n        used with PHP and other server technologies.\n        ",
                                tabs:[
                                    {title:"countryDS", url:"grids/ds/countryXMLDS.ds.xml"},
                                    {canEdit:"false", doEval:"false", title:"countryData.xml",
                                     url:"grids/data/countryData.xml"}
                                ],
                                id:"xmlDataSource",
                                title:"XML DataSource"
                            },
                            {
                                jsURL:"grids/dataProviders/WSDLBound.js",
                                needXML:"true",
                                description:"\n        This <code>ListGrid</code> binds to a <code>DataSource</code> that loads data via a\n        WSDL service.  This example WSDL service supports all 4 basic operation types (fetch,\n        add, update, remove) and can be implemented with any server technology.  Sample\n        request/response SOAP messages for a \"fetch\" operation are shown.\n        ",
                                tabs:[
                                    {title:"countryDS", url:"grids/ds/countryWSDLDS.ds.xml"},
                                    {canEdit:"false", doEval:"false", title:"soapRequest.xml",
                                     url:"grids/data/countrySoapRequest.xml"},
                                    {canEdit:"false", doEval:"false", title:"soapResponse.xml",
                                     url:"grids/data/countrySoapResponse.xml"},
                                    {canEdit:"false", doEval:"false", title:"WSDL",
                                     url:"grids/ds/SmartClientOperations.wsdl"}
                                ],
                                id:"WSDLDataSource",
                                title:"WSDL DataSource"
                            }
                        ]
                    },
                    {
                        description:"\n    Basic operations on datasets, both local and remote.\n",
                        isOpen:false,
                        title:"Data operations",
                        children:[
                            {
                                jsURL:"grids/dataOperations/localSet.js",
                                visibility:"sdk",
                                description:"\n        Click the buttons to populate the grid with records from a local data set.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Local set"
                            },
                            {
                                jsURL:"grids/dataOperations/localAdd.js",
                                visibility:"sdk",
                                description:"\n        Click the buttons to add records to the top and bottom of the list.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Local add"
                            },
                            {
                                jsURL:"grids/dataOperations/localRemove.js",
                                visibility:"sdk",
                                description:"\n        Click \"Remove first\" to remove the first record in the list. Click the other buttons to\n        remove records based on your selection (click, Ctrl-click, or\n        Shift-click in the list to select records).\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Local remove"
                            },
                            {
                                jsURL:"grids/dataOperations/localUpdate.js",
                                visibility:"sdk",
                                description:"\n        Click to select any record in the list, then click one of the buttons to change\n        the \"Continent\" value for that record. Also see the <b>Grids > Editing</b> examples\n        for automatic update behavior.\n        ",
                                tabs:[
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                title:"Local update"
                            },
                            {
                                jsURL:"grids/dataOperations/databoundFetch.js",
                                description:"\n        Click the buttons to fetch (exact match) country records from the server.\n        Click the \"Fetch All\" button to fetch the first \"page\" of 50 records, then scroll\n        the grid to fetch new pages of data on demand.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"databoundFetch",
                                title:"Databound fetch"
                            },
                            {
                                jsURL:"grids/dataOperations/databoundFilter.js",
                                description:"\n        Click the buttons to filter (partial match) records from the server. Also see the\n        <b>Grids &gt; Sort &amp; filter &gt; Filter</b> example for automatic databound Filter\n        operations triggered by user input.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"databoundFilter",
                                title:"Databound filter"
                            },
                            {
                                jsURL:"grids/dataOperations/databoundAdd.js",
                                description:"\n        Click the \"Add new country\" button to create a new country record on the server.\n        Also see the <b>Grids &gt; Editing &gt; Enter new rows</b> example for automatic databound\n        Add operations triggered by user input.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"databoundAdd",
                                title:"Databound add"
                            },
                            {
                                jsURL:"grids/dataOperations/databoundRemove.js",
                                description:"\n        Click \"Remove first\" to remove (delete) the first record in the list from the server.\n        Click the other buttons to remove records based on your selection (click, Ctrl-click, or\n        Shift-click in the list to select records).\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"databoundRemove",
                                title:"Databound remove"
                            },
                            {
                                jsURL:"grids/dataOperations/databoundUpdate.js",
                                description:"\n        Click to select any record in the list, then click one of the buttons to change\n        the \"Continent\" value for that record on the server. Also see the <b>Grids &gt; Editing</b>\n        examples for automatic databound Update operations triggered by user input.\n        ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"databoundUpdate",
                                title:"Databound update"
                            }
                        ]
                    },
                    {ref:"dataIntegration", visibility:"www", title:"Service Integration"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/chart_organisation.png",
                showSkinSwitcher:"true",
                description:"\n    High-performance interactive tree views\n    <BR>\n    <BR>\n    Trees are based on grid views, and so share all of the appearance, interactivity and\n    databinding features of grids, in addition to tree-specific features.\n",
                isOpen:false,
                title:"Trees",
                children:[
                    {
                        description:"\n        Trees can have dynamic titles, display multiple columns and show connector\n        lines.\n    ",
                        isOpen:false,
                        title:"Appearance",
                        children:[
                            {dataSource:"employees", jsURL:"trees/appearance/nodeTitles.js",
                             description:"\n            Formatter interfaces allow you to add custom tree titles.\n            ", id:"nodeTitles",
                             title:"Node Titles"},
                            {dataSource:"employees", jsURL:"trees/appearance/multipleColumns.js",
                             description:"\n            Trees can show multiple columns of data for each node.  Each column has the\n            styling, formatting, and data type awareness features of columns in a normal\n            grid.\n\n            Try drag reordering columns, or sorting by the Salary field.\n            ", title:"Multiple Columns"},
                            {
                                cssURL:"trees/appearance/connectors.css",
                                dataSource:"employees",
                                jsURL:"trees/appearance/connectors.js",
                                description:"\n            Trees can show skinnable connector lines. Toggle the checkbox to show or hide \"full\"\n            connector lines.\n        ",
                                badSkins:["BlackOps", "SilverWave"],
                                bestSkin:"TreeFrog",
                                id:"connectors",
                                title:"Connectors"
                            }
                        ]
                    },
                    {
                        description:"\n        Trees have built-in drag and drop behaviors and tree-specific events.\n    ",
                        isOpen:false,
                        title:"Interaction",
                        children:[
                            {
                                jsURL:"trees/interaction/dragReparent.js",
                                description:"\n            Try dragging employees under new managers.  Note that a position indicator line\n            appears during drag, allowing employees to be placed in a particular order.\n            ",
                                tabs:[
                                    {name:"employeeData", url:"trees/employeeData.js"}
                                ],
                                id:"treeDragReparent",
                                title:"Drag reparent"
                            },
                            {ref:"dragTree", title:"Drag nodes"},
                            {ref:"treeDragReparent",
                             description:"\n            Try dragging employees under new managers.  Note that closed folders automatically\n            open if you hover over them momentarily.\n            ", title:"Springloaded Folders"},
                            {
                                jsURL:"trees/interaction/dropEvents.js",
                                description:"\n            Click on any category on the left to show items from that category on the right.  \n            Drag and drop items from the list on the right into new categories in the tree on\n            the left.\n            ",
                                tabs:[
                                    {dataSource:"supplyCategory", name:"supplyCategory"},
                                    {dataSource:"supplyItem", name:"supplyItem"}
                                ],
                                id:"treeDropEvents",
                                title:"Drop Events"
                            }
                        ]
                    },
                    {
                        description:"\n        Trees can bind to DataSources and handle all the data formats that grids can, using\n        additional properties to control tree structure, open state, and folderness.\n    ",
                        isOpen:false,
                        id:"treesDataBinding",
                        title:"Data binding",
                        children:[
                            {jsURL:"trees/dataBinding/parentLinking.js",
                             description:"\n            Tree data can be specified as a flat list of nodes that refer to each other by\n            ID.  This format is also used for load on demand.\n            ", id:"parentLinking",
                             title:"Parent Linking"},
                            {jsURL:"trees/dataBinding/childrenArrays.js",
                             description:"\n            Tree data can be specified as a tree of nodes where each node lists its children.\n            ", id:"childrenArrays",
                             title:"Children Arrays"},
                            {
                                jsURL:"trees/dataBinding/loadXMLParentLinked.js",
                                description:"\n            Tree data can be loaded in XML or JSON format.  For a \"parent-linked\" Tree, the\n            <code>primaryKey</code> and <code>foreignKey</code> declarations in the DataSource\n            control how nodes are linked together to form the tree structure.\n            \n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"employeesXMLData",
                                     url:"trees/dataBinding/employeesDataParentLinked.xml"}
                                ],
                                title:"Load XML (Parent Linked)"
                            },
                            {
                                jsURL:"trees/dataBinding/loadXMLChildrenArrays.js",
                                needXML:"true",
                                description:"\n            Tree data can be loaded in XML or JSON format.  For a \"children arrays\" Tree, one\n            DataSource field is marked <code>childrenProperty:true</code>, and the children of\n            a node are expected to appear under the same-named XML element or JSON property.\n            \n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"employeesXMLData",
                                     url:"trees/dataBinding/employeesDataChildrenArrays.xml"}
                                ],
                                id:"treeLoadXML",
                                title:"Load XML (Child Arrays)"
                            },
                            {dataSource:"employees", jsURL:"trees/dataBinding/loadOnDemand.js",
                             description:"\n            Begin opening folders and note the prompt which briefly appears during server\n            fetches.  Trees can load data one folder at a time.  When a folder is opened for the first\n            time, the tree asks the server for the children of the node just opened by passing\n            the unique id of the parent as search criteria.\n            ", title:"Load on Demand"},
                            {dataSource:"employees", jsURL:"trees/dataBinding/initialDataLOD.js",
                             description:"\n            Begin opening folders and note the load on demand behavior.\n            \n            Trees that use load on demand can optional specify an initial dataset set up front.  \n            ", id:"initialData",
                             title:"Initial Data & Load on Demand"}
                        ]
                    },
                    {dataSource:"employees", jsURL:"trees/sorting.js",
                     description:"\n        Trees sort per folder.  Click on the \"Name\" column header to sort alphabetically by\n        folder name, or on the \"Salary\" column header to sort by Salary.\n    ", title:"Sorting"},
                    {dataSource:"employees", jsURL:"trees/editing.js",
                     description:"\n        Click on employees in the tree to edit them, and drag and drop employees to rearrange them.\n        Choose an employee via the menu to see that employee's direct reports in the ListGrid.  Changes\n        made in the tree or ListGrid are automatically saved to the server and reflected in the other\n        components.\n    ", id:"treesEditing",
                     title:"Editing"},
                    {dataSource:"employees", jsURL:"trees/freezeTree.js",
                     description:"\n     Setting <code>frozen:true</code> enables frozen columns for Trees.  Columns\n     can be frozen and unfrozen by right-clicking on column headers.<br>\n     Column resize, column reorder, drag and drop and load on demand all function normally.\n     ", id:"freezeTree",
                     title:"Frozen Columns"},
                    {dataSource:"employees", jsURL:"trees/millerColumns.js",
                     description:"\n        The <code>ColumnTree</code> provides an alternate navigation paradigm for Tree data,\n        sometimes called \"Miller Columns\" and seen in Apple&trade; iTunes&trade;.\n        The <code>ColumnTree</code> provides identical data binding and load on demand facilities to\n        normal <code>TreeGrids</code>.\n        ", id:"millerColumns",
                     title:"Miller Columns"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/cube_blue.png",
                description:"\n    Multidimensional \"cube\" data sets as used in BI, Analytics and OLAP applications.\n    Load-on-demand, drill-down, roll-up, in-browser dataset pivoting, multiple frozen panes, \n    resizing and reorder of fields, tree dimensions, chart generation, editing and other\n    features.\n",
                isOpen:false,
                id:"cubeGrid",
                title:"Cubes",
                children:[
                    {
                        jsURL:"cubes/basicCube.js",
                        requiresModules:"Analytics",
                        description:"\n        In this multi-dimensional dataset, each cell value has a series of attributes,\n        called \"facets\", that appear as stacked headers labelling the cell value. \n        ",
                        tabs:[
                            {title:"productData", url:"cubes/productData.js"}
                        ],
                        id:"basicCube",
                        title:"Basic Cube"
                    },
                    {ref:"analytics", requiresModules:"Analytics", title:"Analytics"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/vcard_edit.png",
                description:"\n    Form managers and input controls.\n",
                isOpen:false,
                title:"Forms",
                children:[
                    {
                        description:"\n        A specialized form layout manager allows your forms to grow into available space,\n        hide sections, and span across tabs.\n    ",
                        isOpen:false,
                        id:"formsLayout",
                        title:"Layout",
                        children:[
                            {jsURL:"forms/layout/titles.js",
                             description:"\n            Click on \"Swap Titles\" to change title orientation.\n            \n            Form layout automatically places titles next to fields.  Left-oriented titles take\n            up a column so that labels line up.  Top oriented titles don't.\n            ", id:"formLayoutTitles",
                             title:"Titles"},
                            {jsURL:"forms/layout/spanning.js",
                             description:"\n            Drag resize the form from the right edge to see the effect of spanning.\n            \n            Specifying column widths and column spanning items allows for larger and smaller\n            input areas.\n            ", id:"columnSpanning",
                             title:"Spanning"},
                            {jsURL:"forms/layout/filling.js",
                             description:"\n            Click on the \"Short Message\" and \"Long Message\" buttons to change the amount of\n            space available to the form.\n            \n            SmartClient form layouts allow you to fill available space, even when\n            available space cannot be known in advance because it is data-dependant.\n            ", id:"formLayoutFilling",
                             title:"Filling"},
                            {xmlURL:"ValuesManager.xml",
                             description:"\n            Click \"Submit\" to jump to a validation error in the \"Stock\" tab.\n            \n            Forms which are split for layout purposes can behave like a single logical form for\n            validation and saves.\n            ", showSkinSwitcher:true,
                             id:"formSplitting", title:"Splitting"},
                            {xmlURL:"SectionItem.xml",
                             description:"\n            Click on \"Stock\" to reveal fields relating to stock on hand.\n            ", showSkinSwitcher:true,
                             id:"formSections", title:"Sections"},
                            {ref:"validationFieldBinding", title:"Data Binding"}
                        ]
                    },
                    {
                        description:"\n        Common field dependencies within a form, such as fields that are only applicable to\n        some users, can be handled by specifying simple expressions.\n    ",
                        isOpen:false,
                        title:"Field Dependencies",
                        children:[
                            {jsURL:"forms/fieldDependencies/showAndHide.js",
                             description:"\n            Select \"On order\" to reveal the \"Shipping Date\" field.\n            ", id:"formShowAndHide",
                             title:"Show & Hide"},
                            {jsURL:"forms/fieldDependencies/enableAndDisable.js",
                             description:"\n            Check \"I accept the agreement\" to enable the \"Proceed\" button.\n            ", id:"fieldEnableDisable",
                             title:"Enable & Disable"},
                            {jsURL:"forms/fieldDependencies/conditionallyRequired.js",
                             description:"\n            Select \"No\" and click the \"Validate\" button - the reason field becomes required.\n            ", id:"conditionallyRequired",
                             title:"Conditionally Required"},
                            {jsURL:"forms/fieldDependencies/matchValue.js",
                             description:"\n            Try entering mismatched values for \"Password\" and \"Password Again\", then click\n            \"Create Account\" to see a validation error.\n            ", id:"matchValue",
                             title:"Match Value"},
                            {
                                jsURL:"forms/fieldDependencies/dependentSelects.js",
                                description:"\n            <p />\n            In the first example, select a \"Division\" to cause the \"Department\" select to be \n            populated with departments from that division.\n            <p />\n            The second example demonstrates two select items, both of which load data on the fly from\n            a DataSource, where the \"Category\" drop-down controls the list of available items\n            in the \"Item\" drop-down.  Try selecting a value in the \"Category\" drop-down list to change the set of options \n            available in the \"Item\" drop-down.\n            ",
                                tabs:[
                                    {dataSource:"supplyItem", name:"supplyItem"},
                                    {dataSource:"supplyCategory", name:"supplyCategory"}
                                ],
                                id:"formDependentSelects",
                                title:"Dependent Selects"
                            }
                        ]
                    },
                    {
                        description:"\n        The form has built-in editors and pickers for common types such as numbers and dates,\n        as well as the ability to use the databinding framework to pick from lists and trees of\n        related records.\n    ",
                        isOpen:false,
                        title:"Form Controls",
                        children:[
                            {xmlURL:"TextItem.xml", description:"\n            ", id:"textItem",
                             title:"Text"},
                            {xmlURL:"TextAreaItem.xml", description:"\n            ",
                             id:"textAreaItem", title:"TextArea"},
                            {xmlURL:"DateItem.xml",
                             description:"\n            DateItems support direct or pickList-based input of dates, and have a built-in\n            pop-up day picker.\n            ", id:"dateItem",
                             title:"Date"},
                            {xmlURL:"TimeItem.xml",
                             description:"\n            TimeItem supports text-based input of Times\n            ", id:"timeItem",
                             title:"Time"},
                            {jsURL:"forms/dataTypes/numberSpinner.js",
                             description:"\n            Click the up and down buttons to change shoe size.  Click and hold to change shoe\n            size quickly.  Note spinner stops at a maximum and minimum value.\n            ", id:"spinnerItem",
                             title:"Number - Spinner"},
                            {jsURL:"forms/dataTypes/numberSlider.js",
                             description:"\n            Change the value by clicking and dragging the thumb, clicking on the track, or\n            using the keyboard. \n            ", id:"sliderItem",
                             title:"Number - Slider"},
                            {xmlURL:"CheckboxItem.xml", description:"\n            ",
                             id:"checkboxItem", title:"Boolean - Checkbox"},
                            {jsURL:"forms/dataTypes/listSelect.js",
                             description:"\n            Note the icons and customized text styling.  Click to reveal the options and note\n            the drop shadow.  \n            \n            The SmartClient SelectItem offers more powerful and consistent control over\n            appearance and behavior than the HTML &lt;SELECT&gt; element.\n            ", id:"selectItem",
                             title:"List - Select"},
                            {dataSource:"supplyItem", jsURL:"forms/dataTypes/listComboBox.js",
                             description:"\n            Start typing in either field to see a list of matching options.  The field\n            labelled \"Item Name\" retrieves options dynamically from the SupplyItem\n            DataSource\n            ", id:"listComboBox",
                             title:"List - Combo Box"},
                            {dataSource:"supplyItem", jsURL:"forms/dataTypes/relatedRecords.js",
                             description:"\n            Open the picker in either form to select the item you want to order from the\n            \"supplyItem\" DataSource.  The picker on the left stores the \"itemId\" from the\n            related \"supplyItem\" records.  The picker on the right stores the \"SKU\" while\n            displaying multiple fields.  You can scroll to dynamically load more records.  \n            This pattern works with any DataSource.  \n            ", showSkinSwitcher:true,
                             id:"relatedRecords", title:"List - Related Records"},
                            {xmlURL:"ColorItem.xml",
                             description:"\n            ColorItems support direct input of HTML color values (in the form #RRGGBB), or \n            selection of colors via a ColorPicker widget.\n            ", id:"colorItem",
                             title:"Color"},
                            {dataSource:"supplyCategory", xmlURL:"PickTree.xml",
                             description:"\n            Click on \"Department\" or \"Category\" below to show hierarchical menus.  The\n            \"Category\" menu loads options dynamically from the SupplyCategory DataSource.\n            ", showSkinSwitcher:true,
                             id:"pickTree", title:"Tree"},
                            {visibility:"sdk", xmlURL:"SelectOtherItem.xml",
                             description:"\n            Select \"Other..\" from the drop down to enter a custom value.\n            ", title:"List - Select Other"},
                            {ref:"RichTextEditor", title:"HTML"}
                        ]
                    },
                    {ref:"validation", isOpen:false, title:"Validation"},
                    {
                        description:"\n        Hovers and hints explain the form to the user.  Icons provide an easy extension point\n        for help, custom pickers and other extensions.  KeyPress filtering allows character\n        casing to be forced on entry or invalid keystrokes to be ignored.\n    ",
                        isOpen:false,
                        title:"Details",
                        children:[
                            {jsURL:"forms/layout/icons.js",
                             description:"\n            Click on the help icon below to see a description for severity levels.  Form items\n            can show an arbitrary number of icons to do whatever you need.\n            ", id:"formIcons",
                             title:"Icons"},
                            {jsURL:"forms/details/hovers.js",
                             description:"\n            Hover anywhere over the field to see what the current value means.  Change the\n            value or disable the field to see different hovers.  Note that the hovers contain\n            HTML formatting.  \n            ", id:"itemHoverHTML",
                             title:"Hovers"},
                            {jsURL:"forms/layout/hints.js",
                             description:"\n            Hints provide guidance to the user filling out the form.  In this case, the MM/YYYY\n            hint tells the user the expected format for the free-form date field. Note both\n            trailing and in-field styles are shown.\n            ", id:"formHints",
                             title:"Hints"},
                            {jsURL:"forms/details/filters.js",
                             description:"\n            KeyPress filters help prevent the user from entering invalid characters.\n            Additionally, character casing can be forced to either upper or lowercase.\n            ", id:"formFilters",
                             title:"KeyPress Filters"}
                        ]
                    }
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/cal.png",
                showSkinSwitcher:"true",
                description:"Customizable calendars that display events in day, week, and month views.",
                isOpen:false,
                title:"Calendars",
                children:[
                    {
                        cssURL:"calendar/calendar.css",
                        jsURL:"calendar/simpleCalendar.js",
                        requiresModules:"Calendar",
                        description:"\n            This calendar is bound to an array of event data. Drag events to alter their start times, and\n            resize events to alter their durations. Click and drag in an empty cell to create new events,\n            or click on an existing event to edit it. Notice how the red event can't be edited; This was \n            specified within the event data itself (see the 'eventData' tab below).\n        ",
                        tabs:[
                            {title:"eventData", url:"calendar/calendarData.js"}
                        ],
                        id:"simpleCalendar",
                        title:"Simple Calendar"
                    },
                    {
                        cssURL:"calendar/calendar.css",
                        jsURL:"calendar/databoundCalendar.js",
                        requiresModules:"Calendar",
                        description:"\n            This calendar is bound to a dataSource. Drag events to alter their start times, and\n            resize events to alter their durations. Click and drag in an empty cell to create new events,\n            or click on an existing event to edit it. Notice how the red event can't be edited; This was \n            specified within the event data itself (see the 'eventData' tab below).\n        ",
                        tabs:[
                            {title:"eventData", url:"calendar/calendarData.js"}
                        ],
                        id:"databoundCalendar",
                        title:"Databound Calendar"
                    },
                    {
                        jsURL:"calendar/compactCalendar.js",
                        requiresModules:"Calendar",
                        description:"\n            Hover over the days with the check icon in them to see the events for those days.\n            Use the 'next' and 'previous' arrows to change months.\n        ",
                        tabs:[
                            {title:"eventData", url:"calendar/calendarData.js"}
                        ],
                        id:"compactCalendar",
                        title:"Compact Calendar"
                    },
                    {
                        cssURL:"calendar/calendar.css",
                        jsURL:"calendar/workdayCalendar.js",
                        requiresModules:"Calendar",
                        description:"\n            The calendar can focus in on workday hours, giving a clearer view of events that occur\n            durring the work day. The boundaries of the workday itself can also be customized.\n        ",
                        tabs:[
                            {title:"eventData", url:"calendar/calendarData.js"}
                        ],
                        id:"workdayCalendar",
                        title:"Workday Calendar"
                    },
                    {
                        cssURL:"calendar/calendar.css",
                        jsURL:"calendar/customEventEditing.js",
                        requiresModules:"Calendar",
                        description:"\n            Click in an empty cell or in an event to see custom fields in the quick event editor and in \n            the full event editor. Notice how the red event can't be edited; This was \n            specified within the event data itself (see the 'eventData' tab below).\n        ",
                        tabs:[
                            {title:"eventData", url:"calendar/calendarData.js"}
                        ],
                        id:"customCalendar",
                        title:"Custom Event Editing"
                    },
                    {
                        cssURL:"calendar/calendar.css",
                        jsURL:"calendar/eventAutoArrange.js",
                        requiresModules:"Calendar",
                        description:"\n            The calendar can automatically arrange events that share time so that each is always\n            fully visible at its proper location.  Drag one event onto or away from another to \n            see the effect.\n        ",
                        tabs:[
                            {title:"eventOverlapData", url:"calendar/calendarOverlapData.js"}
                        ],
                        id:"eventAutoArrange",
                        title:"Event Auto-Arranging"
                    },
                    {
                        cssURL:"calendar/calendar.css",
                        jsURL:"calendar/eventOverlapping.js",
                        requiresModules:"Calendar",
                        description:"\n            When eventAutoArrange is true, you can have the Calendar overlap concurrent \n            events slightly.  The zorder is from left to right and the overlap-size is a \n            percentage of event-width (see the \"JS\" tab).  If two events start at exactly the \n            same time, the default behaviour is to reject the overlap to avoid the first event's \n            close button from being hidden by the second event (see the \"JS\" tab).  You can see\n            this by dropping one event onto the start-time of another below.\n        ",
                        tabs:[
                            {title:"eventOverlapData", url:"calendar/calendarOverlapData.js"}
                        ],
                        id:"eventOverlapping",
                        title:"Event Overlapping"
                    }
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/application_side_list.png",
                description:"\n    Liquid layout managers and user interface containers.\n",
                isOpen:false,
                title:"Layout",
                children:[
                    {jsURL:"forms/layout/filling.js",
                     description:"\n        Click on the \"Short Message\" and \"Long Message\" buttons to change the amount of\n        space available to the form.\n        \n        Layouts automatically react to resizes and re-apply the layout policy.\n        ", title:"Filling"},
                    {jsURL:"layout/nesting.js",
                     description:"\n        Use the resize bars to reallocate space between the 3 panes.\n        \n        Layouts can be nested to create standard application views.  Resize bars are built-in.\n        ", showSkinSwitcher:true,
                     id:"layoutNesting", title:"Nesting"},
                    {jsURL:"layout/userSizing.js",
                     description:"\n        Resize the outer frame to watch \"Member 1\" and \"Member 2\" split the space.  Now resize\n        either member and resize the outer frame again.\n        \n        Layouts track sizes which have been set by user action and respect the user's settings.\n        ", id:"userSizing",
                     title:"User Sizing"},
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/vcard_edit.png", ref:"formsLayout",
                     title:"Form Layout"},
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/application_cascade.png",
                        showSkinSwitcher:"true",
                        description:"\n        Windows for dialogs, wizards, tools and free-form application layouts.\n    ",
                        isOpen:false,
                        title:"Windows",
                        children:[
                            {jsURL:"layout/window/autoSize.js",
                             description:"\n            Windows can autoSize to content or can dictate the content's size.\n            ", id:"windowAutosize",
                             title:"Auto Size"},
                            {ref:"modality", title:"Modality"},
                            {jsURL:"layout/window/dragging.js",
                             description:"\n            Grab the window by its title bar to move it around.  Resize it by the right or\n            bottom edge.\n            ", title:"Dragging"},
                            {ref:"windowMinimize", title:"Minimize"},
                            {jsURL:"layout/window/controls.js",
                             description:"\n            Header controls can be reordered and custom controls added.\n            ", id:"windowHeaderControls",
                             title:"Header Controls"},
                            {jsURL:"layout/window/footer.js",
                             description:"\n            Windows support a footer with a visible resizer and updateable status bar.\n            ", id:"windowFooter",
                             title:"Footer"}
                        ]
                    },
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/tab.png",
                        showSkinSwitcher:"true",
                        description:"\n        Tabs for sectioning applications and forms.\n    ",
                        isOpen:false,
                        title:"Tabs",
                        children:[
                            {jsURL:"layout/tabs/orientation.js",
                             description:"\n            Tabs can be horizontally or vertically oriented.  To select tabs, click on them, or\n            on click the \"Select Blue\" and \"Select Green\" buttons.\n            ", id:"tabsOrientation",
                             title:"Orientation"},
                            {jsURL:"layout/tabs/align.js",
                             description:"\n            Tabs can be left or right aligned (for horizontal tabs) or top or bottom aligned\n            (for vertical tabs)\n            ", id:"tabsAlign",
                             title:"Align"},
                            {jsURL:"layout/tabs/addAndRemove.js",
                             description:"\n            Click on \"Add Tab\" and \"Remove Tab\" to add and remove tabs.   When you add too many\n            tabs to display at once, a tab scrolling interface will appear.\n            ", id:"tabsAddAndRemove",
                             title:"Add and Remove"},
                            {jsURL:"layout/tabs/closeableTabs.js",
                             description:"\n            Click on the red close icons to close tabs.  Tabbed views can have any mixture of\n            closeable and permanent tabs.\n            ", id:"closeableTabs",
                             title:"Closeable Tabs"},
                            {jsURL:"layout/tabs/titleChange.js",
                             description:"\n            Titles can be changed on the fly.  Type in your name to see the \"Preferences\" tab\n            change its title to include your name.  Note that the tab automatically sizes to\n            accomodate the longer title - automatic sizing also happens at initialization.\n            ", id:"titleChange",
                             title:"Title Change"},
                            {
                                jsURL:"advanced/viewLoading.js",
                                needXHR:"true",
                                description:"\n            Click on \"Tab2\" to load a grid view on the fly.\n            \n            Declarative view loading allows extremely large applications to be split into\n            separately loadable chunks, and creates an easy integration path for applications\n            with server-driven application flow.\n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"loadedView",
                                     url:"advanced/loadedView.js"}
                                ],
                                id:"viewLoading",
                                title:"View Loading"
                            }
                        ]
                    },
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/application_tile_vertical.png",
                        showSkinSwitcher:"true",
                        description:"\n        Sections (also called Accordions) label sections of the application\n        and allow users to hide or resize sections.\n    ",
                        isOpen:false,
                        title:"Sections",
                        children:[
                            {jsURL:"layout/sections/expandCollapse.js",
                             description:"\n            Click on any section header showing an arrow to expand and collapse it (the \"Green \n            Cube\" section is marked not collapsible).  Click on the \"Expand Blue\" and \n            \"Collapse Blue\" buttons to expand and collapse sections externally.\n            ", id:"sectionsExpandCollapse",
                             title:"Expand / Collapse"},
                            {jsURL:"layout/sections/resizeSections.js",
                             description:"\n            Drag the \"Help 2\" header to resize sections, or press \"Resize Help 1\" to resize to\n            fixed height.  The \"Blue Pawn\" section is marked not resizeable.\n            ", id:"resizeSections",
                             title:"Resize Sections"},
                            {jsURL:"layout/sections/sectionControls.js",
                             description:"\n            Custom controls may appear on section headers.\n            ", id:"sectionControls",
                             title:"Custom Controls"},
                            {jsURL:"layout/sections/addAndRemove.js",
                             description:"\n            Press the \"Add Section\" and \"Remove Section\" buttons to add or remove sections.\n            ", id:"sectionsAddAndRemove",
                             title:"Add and Remove"},
                            {jsURL:"layout/sections/showAndHide.js",
                             description:"\n            Press the \"Show Section\" and \"Hide Section\" buttons to reveal or hide the Yellow\n            Section.  Showing and hiding sections lets you reuse a SectionStack for slightly\n            different purposes, hiding or revealing relevant sections.\n            ", id:"sectionsShowAndHide",
                             title:"Show and Hide"}
                        ]
                    }
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/brick.png",
                description:"\n    Navigation and action controls.\n",
                isOpen:false,
                title:"Control",
                children:[
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/brick.png",
                        description:"\n    SmartClient buttons are visually appealing, easily skinned, and easy to use.\n    ",
                        isOpen:false,
                        title:"Buttons",
                        children:[
                            {jsURL:"actions/buttons/appearance.js",
                             description:"\n            Buttons come in three basic types: CSS buttons, single-image buttons, and \n            multiple-image stretch buttons.  All share a basic set of capabilities.\n        ", showSkinSwitcher:true,
                             id:"buttonAppearance", title:"Appearance"},
                            {css:"actions/buttons/states.css", jsURL:"actions/buttons/states.js",
                             description:"\n            Move the mouse over the buttons, and click and hold to see buttons in different\n            states.  Click \"Disable All\" to put all buttons in the disabled state.\n            \n            Edit the CSS style definitions to change the appearance of various states.\n        ", id:"buttonStates",
                             title:"States"},
                            {jsURL:"actions/buttons/icons.js",
                             description:"\n            Click and hold on the \"Save\" button to see the icon change as the button goes\n            down.  Note that the binoculars icon does not change when the button goes down.\n            Click \"Disable Save\" to see the icon change to reflect disabled state.\n            \n            Button icons can be left or right oriented, and can optionally react to any the\n            state of the button.\n        ", id:"buttonIcons",
                             title:"Icons"},
                            {jsURL:"actions/buttons/autoFit.js",
                             description:"\n            Buttons can automatically size to accomodate the title and icon, and resize\n            automatically when the title is changed, notifying components around them they have\n            changed size.\n        ", id:"buttonAutoFit",
                             title:"Auto Fit"},
                            {jsURL:"actions/buttons/radioCheckbox.js",
                             description:"\n            Click on the buttons for Bold, Italic, and Underline and note that they stick in a\n            down state.  Click on the buttons for left, center and right justify and note that\n            they are mutually exclusive.\n        ", id:"buttonRadioToggle",
                             title:"Radio / Toggle Behavior"}
                        ]
                    },
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/application_osx.png",
                        showSkinSwitcher:"true",
                        description:"\n    Dynamic, appealing menus that can bind directly to data.\n    ",
                        isOpen:false,
                        title:"Menus",
                        children:[
                            {jsURL:"actions/menus/appearance.js",
                             description:"\n            Click \"File\" to see a typical File menu with icons, submenus, checks,\n            separators, disabled items, and keyboard shortcut hints.  Note the beveled edge and\n            drop shadow.\n            ", id:"fullMenu",
                             title:"Appearance"},
                            {jsURL:"actions/menus/dynamicItems.js",
                             description:"\n            Open the \"File\" menu to see the \"New file in..\" item initially disabled.  Select a\n            project and note that the menu item has become enabled, changed title and changed\n            icon.  Pick \"Project Listing\" to show and hide the project list, and note the item\n            checks and unchecks itself.\n            ", id:"menuDynamicItems",
                             title:"Dynamic Items"},
                            {ref:"fullMenu",
                             description:"\n            Click \"File\" and navigate over \"Recent Documents\" or \"Export as...\" to see\n            submenus.\n            ", title:"Submenus"},
                            {jsURL:"actions/menus/columns.js",
                             description:"\n            Open the menu to see a standard column showing item titles, and an additional\n            column showing an option to close menu items. Clicking in the second column will\n            remove the item from the menu.\n            ", id:"menuColumns",
                             title:"Custom Columns"},
                            {dataSource:"supplyCategory", jsURL:"actions/menus/treeBinding.js",
                             description:"\n            Click on \"Department\" or \"Category\" below to show hierarchical menus.  The\n            \"Category\" menu loads options dynamically from the SupplyCategory DataSource.\n            ", id:"treeBinding",
                             title:"Tree Binding"}
                        ]
                    },
                    {jsURL:"actions/toolStrips.js",
                     description:"\n        Click the icons at left to see \"radio\"-style selection.  Click the drop-down to see\n        font options.\n        ", id:"toolstrip",
                     title:"ToolStrips"},
                    {jsURL:"actions/dialogs.js",
                     description:"\n        Click \"Confirm\", \"Ask\" or \"Ask For Value\" to show three of the pre-built, skinnable \n        SmartClient Dialogs for common interactions.  \n        ", showSkinSwitcher:true,
                     id:"dialogs", title:"Dialogs"},
                    {jsURL:"actions/loginDialog.js",
                     description:"\n        Click \"Login\" to show SmartClient's built-in user login dialog.  Try entering both good\n        and bad credentials - user \"barney\", password \"rubble\" is a valid user.\n        ", showSkinSwitcher:true,
                     id:"loginDialog", title:"Login Dialog"},
                    {xmlURL:"actions/slider.js",
                     description:"\n        Move either Slider to update the other.  You can change the value by clicking and\n        dragging the thumb, clicking on the track, or using the keyboard (once you've focused\n        on one of the sliders)\n        ", id:"slider",
                     title:"Slider"},
                    {jsURL:"actions/colorPicker.js",
                     description:"\n        Use the radio buttons to set which mode the ColorPicker initially appears in, and the \n        window position policy.  Click \"Pick a Color\" and select a color from either the simple\n        or complex picker - the \"Selected color\" label changes to reflect your selection.  The \n        ColorPicker also supports selecting semi-transparent colors - this is more easily seen\n        in a skin that shows a background image (eg BlackOps).\n        ", showSkinSwitcher:true,
                     id:"colorPicker", title:"ColorPicker"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/disconnect.png",
                description:"\n    Data binding allows multiple components to share a central definition of an object (called\n    a DataSource), so that all components can consistently retrieve, display, edit, validate\n    and save objects of that type.\n",
                isOpen:false,
                title:"Data Binding",
                children:[
                    {ref:"gridsDataBinding", showSkinSwitcher:"true", isOpen:false, id:"lists",
                     title:"Lists"},
                    {ref:"treesDataBinding", showSkinSwitcher:"true", isOpen:false, id:"trees",
                     title:"Trees"},
                    {
                        showSkinSwitcher:"true",
                        description:"\n    DataBound Components understand a core set of operations called \"Fetch\", \"Add\", \"Update\"\n    and \"Remove\" (also known as CRUD operations).  These operations can be programmatically\n    initiated or automatically initiated in response to user action.\n    In either case the integration model and APIs are the same.\n    ",
                        isOpen:false,
                        id:"operations",
                        title:"Operations",
                        children:[
                            {dataSource:"supplyItem", jsURL:"databind/operations/fetch.js",
                             xmlURL:"databind/operations/fetch.xml", description:"\n            Rows are fetched automatically as the user drags the scrollbar.  Drag the scrollbar\n            quickly to the bottom to fetch a range near the end (a prompt will appear during\n            server fetch).  Scroll slowly back up to fill in the middle.\n            ",
                             id:"fetchOperation", title:"Fetch"},
                            {dataSource:"supplyItem", xmlURL:"databind/operations/add.xml",
                             description:"\n            Use the form to create a new stock item.  Create an item in the currently shown\n            category to see it appear in the filtered listing automatically.  Create an item in\n            any other category and note that it is filtered out.\n            ", id:"addOperation",
                             title:"Add"},
                            {dataSource:"supplyItem", xmlURL:"databind/operations/update.xml",
                             description:"\n            Select an item and use the form to change its price.  The list updates\n            automatically.  Now change the item's category and note that it is removed\n            automatically from the list.\n            ", id:"updateOperation",
                             title:"Update"},
                            {dataSource:"supplyItem", xmlURL:"databind/operations/remove.xml",
                             description:"\n            Click the \"Remove\" button to remove the selected item.\n            ", id:"removeOperation",
                             title:"Remove"}
                        ]
                    },
                    {
                        description:"\n        Typical validation needs are covered by validators built-in to the SmartClient\n        framework.  Validators can be combined into custom type definitions which are reusable\n        across all components.\n    ",
                        isOpen:false,
                        id:"validation",
                        title:"Validation",
                        children:[
                            {dataSource:"databind/validation/type.ds.xml",
                             jsURL:"databind/validation/type.js", description:"\n            Type a non-numeric value into the field and press \"Validate\" to receive a\n            validation error.\n            \n            Declaring field type implies automatic validation anywhere a value is edited.\n            ",
                             id:"validationType", title:"Type"},
                            {dataSource:"databind/validation/builtins.ds.xml",
                             jsURL:"databind/validation/builtins.js", description:"\n            Type a number greater than 20 or less than 1 and press \"Validate\" to receive a\n            validation error.\n            \n            SmartClient implements the XML Schema set of validators on both client and server\n            ",
                             id:"validationBuiltins", title:"Built-ins"},
                            {dataSource:"databind/validation/regularExpression.ds.xml",
                             jsURL:"databind/validation/regularExpression.js", description:"\n            Enter a bad email address (eg just \"mike\") and press \"Validate\" to receive a\n            validation error.\n            \n            The regular expression validator allows simple custom field types, with automatic\n            enforcement on client on server.\n            ",
                             id:"regularExpression", title:"Regular Expression"},
                            {dataSource:"databind/validation/valueTransform.ds.xml",
                             jsURL:"databind/validation/valueTransform.js", description:"\n            Enter a 10 digit US phone number with any typical punctuation press \"Validate\" to see it\n            transformed to a canonical format.\n            ",
                             id:"valueTransform", title:"Value Transform"},
                            {dataSource:"databind/validation/customTypes.ds.xml",
                             jsURL:"databind/validation/customTypes.js", description:"\n            Enter a bad zip code (eg just \"123\") and press \"Validate\" to receive a\n            validation error.\n            \n            Custom types can be declared based on built-in validators and re-used in multiple\n            DataSources\n            ",
                             id:"customSimpleType", title:"Custom Types"},
                            {dataSource:"databind/forms/users.ds.xml",
                             jsURL:"databind/forms/customBinding.js", description:"\n            Click \"Validate\" to see validation errors triggered by rules both in this form and\n            in the DataSource.\n            \n            Screen-specific fields and validation logic, such as the duplicate password entry\n            box, can be added to a particular form while still sharing schema information that\n            applies to all views.\n            ",
                             id:"validationFieldBinding", title:"Customized Binding"}
                        ]
                    },
                    {
                        description:"\n        Databound components have built-in dragging behaviors that operate on persistent\n        datasets.\n    ",
                        isOpen:false,
                        id:"dataDragging",
                        title:"Dragging",
                        children:[
                            {dataSource:"employees", jsURL:"databind/drag/treeReparent.js",
                             ref:"treeReparent", description:"\n            Dragging employees between managers in this tree automatically saves the new\n            relationship to a DataSource, without writing any code.  Make changes, then \n            reload the page: your changes persist.\n            ",
                             title:"Tree Reparent"},
                            {
                                dataSource:"supplyCategory",
                                jsURL:"databind/drag/treeRecategorize.js",
                                ref:"treeRecategorize",
                                description:"\n            Dragging items from the list and dropping them on categories in the tree automatically\n            re-categorizes the item, without any code needed.  Make changes, then \n            reload the page: your changes persist.  This behavior is (optionally) automatic where\n            SmartClient can establish a relationship via foreign key between the DataSources\n            two components are bound to.\n            ",
                                tabs:[
                                    {title:"supplyItem", url:"supplyItem.ds.xml"}
                                ],
                                title:"Recategorize (Tree)"
                            },
                            {dataSource:"supplyItem", jsURL:"databind/drag/listRecategorize.js",
                             ref:"listRecategorize", description:"\n            The two lists are showing items in different categories.  Drag items from one list to\n            another to automatically recategorize the items without writing any code.  Make\n            changes, then reload the page; your changes persist.\n            ",
                             title:"Recategorize (List)"},
                            {ref:"recategorizeTiles", title:"Recategorize (Tile)"},
                            {
                                dataSource:"employees",
                                jsURL:"databind/drag/listCopy.js",
                                ref:"databoundDragCopy",
                                description:"\n            Drag employee records into the Project Team Members list.  SmartClient recognizes that the \n            two dataSources are linked by a foreign key relationship, and automatically uses that \n            relationship to populate values in the record that is added when you drop. SmartClient\n            also populates fields based on current criteria and maps explicit titleFields as \n            necessary.<p>\n            In this example, note that SmartClient is automatically populating all three\n            of the fields in the teamMembers dataSource, even though none of those fields is present \n            in the employees dataSource we are dragging from.  Change the \"Team for Project\" select \n            box, then try dragging employees across; note that the Project Code column is being \n            correctly populated for the dropped records.\n            ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"teamMembers", url:"teamMembers.ds.xml"}
                                ],
                                title:"Copy"
                            }
                        ]
                    },
                    {ref:"adaptiveFilter", title:"Adaptive Filter"},
                    {ref:"adaptiveSort", title:"Adaptive Sort"},
                    {ref:"relatedRecords",
                     description:"\n        Open the picker in either form to select the item you want to order from the\n        \"supplyItem\" DataSource.  The picker on the left stores the \"itemId\" from the\n        related \"supplyItem\" records.  The picker on the right stores the \"SKU\" while\n        displaying multiple fields.  You can scroll to dynamically load more records.  \n        This pattern works with any DataSource.  \n    ", title:"Related Records"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/database_table.png",
                description:"\n    SmartClient supports declarative, XPath-based binding of visual components to web services\n    that return XML or JSON responses.  SmartClient understands XML Schema and can bind\n    components directly to WSDL web services.  \n",
                isOpen:false,
                id:"dataIntegration",
                title:"Data Integration",
                children:[
                    {
                        description:"\n        SmartClient can declaratively bind to standard formats like WSDL or RSS, homebrew\n        formats, or simple flat files.  \n    ",
                        isOpen:false,
                        id:"xmlDataIntegration",
                        title:"XML",
                        children:[
                            {jsURL:"dataIntegration/xml/rssFeed.js", needXML:"true",
                             description:"\n            DataSources can bind directly to simple XML documents where field values appear as\n            attributes or subelements.\n            ", showSkinSwitcher:true,
                             id:"rssFeed", title:"RSS Feed"},
                            {
                                jsURL:"dataIntegration/xml/xpathBinding.js",
                                needXML:"true",
                                description:"\n            DataSources can extract field values from complex XML documents via XPath\n            expressions.  Note how the address fields, which are represented in the contacts\n            data as a subelement, appear as columns in the grid. This approach of loading\n            simple XML data over HTTP can be used with PHP and other server technologies.\n            ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"contactsData.xml",
                                     url:"dataIntegration/xml/contactsData.xml"}
                                ],
                                id:"xpathBinding",
                                title:"XPath Binding"
                            },
                            {jsURL:"dataIntegration/xml/yahooWebServices.js", needXML:"true",
                             description:"\n            XPath binding allows declarative integration with web services.  Note how the\n            height and width for the thumbnail images have been declaratively extracted from\n            the \"Thumbnail\" subobject.\n            ", showSkinSwitcher:true,
                             id:"xmlYahooWebServices", title:"Yahoo! Web Services"},
                            {jsURL:"dataIntegration/xml/wsdlWebServiceOperations.js", needXML:"true",
                             description:"\n            SmartClient can load WSDL service definitions and call web service operations\n            with automatic JSON<->XML translation.\n            \n            SOAP encoding rules, namespacing, and element ordering are handled automatically\n            for your inputs and outputs. \n            ", showSkinSwitcher:false,
                             id:"wsdlOperation", title:"WSDL Web Services"},
                            {jsURL:"dataIntegration/xml/googleSOAPSearch.js", needXML:"true",
                             description:"\n            Enter a search in the \"q\" field to search the web with Google. \n            \n            DataSources can bind directly to the structure of WSDL messages.\n            ", showSkinSwitcher:true,
                             id:"wsdlBinding", title:"Google SOAP Search"},
                            {
                                jsURL:"dataIntegration/xml/operationBinding_dataURL.js",
                                description:"\n        Demonstrates <b>Add</b>, <b>Update</b> and <b>Remove</b> operations with a server that\n        returns simple XML responses, an integration strategy popular with PHP, Ruby and Perl\n        backends.\n        <br>\n        Each operation is directed to a different XML file containing a sample response for\n        that operationType.  The server returns the data-as-saved to allow the grid to update\n        its cache.\n        ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"country_fetch.xml",
                                     url:"dataIntegration/xml/responses/country_fetch.xml"},
                                    {canEdit:"false", doEval:"false", title:"country_add.xml",
                                     url:"dataIntegration/xml/responses/country_add.xml"},
                                    {canEdit:"false", doEval:"false", title:"country_update.xml",
                                     url:"dataIntegration/xml/responses/country_update.xml"},
                                    {canEdit:"false", doEval:"false", title:"country_remove.xml",
                                     url:"dataIntegration/xml/responses/country_remove.xml"}
                                ],
                                id:"xmlEditSave",
                                title:"Edit and Save"
                            },
                            {
                                jsURL:"dataIntegration/xml/restDS_operationBinding.js",
                                description:"\n        The RestDataSource provides a simple protocol based on XML or JSON over HTTP.  This\n        protocol can be implemented with any server technology (PHP, Ruby, ..) and \n        includes all the features of SmartClient's databinding layer (data paging, server\n        validation errors, cache sync, etc).<br>\n        In this example, each DataSource operation is directed to a different XML file\n        containing a sample response for that operationType.  The server returns the\n        data-as-saved to allow the grid to update its cache.\n        ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"country_fetch.xml",
                                     url:"dataIntegration/xml/responses/country_fetch_rest.xml"},
                                    {canEdit:"false", doEval:"false", title:"country_add.xml",
                                     url:"dataIntegration/xml/responses/country_add_rest.xml"},
                                    {canEdit:"false", doEval:"false", title:"country_update.xml",
                                     url:"dataIntegration/xml/responses/country_update_rest.xml"},
                                    {canEdit:"false", doEval:"false", title:"country_remove.xml",
                                     url:"dataIntegration/xml/responses/country_remove_rest.xml"}
                                ],
                                id:"restEditSave",
                                title:"RestDataSource - Edit and Save"
                            },
                            {
                                jsURL:"dataIntegration/xml/serverValidationErrors/serverValidationErrors.js",
                                needXML:"true",
                                description:"\n            Click \"Save\" to see validation errors derived from an XML response.\n            \n            Validation errors expressed in application-specific XML formats can be \n            communicated to visual components by implementing\n            <code>DataSource.transformResponse()</code>.  The resulting validation\n            errors will be displayed and tracked by forms and editabled grids.\n            ",
                                showSkinSwitcher:false,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"serverResponse.xml",
                                     url:"dataIntegration/xml/serverValidationErrors/serverResponse.xml"}
                                ],
                                id:"xmlServerValidationErrors",
                                title:"Server Validation Errors"
                            },
                            {
                                needXML:"true",
                                url:"dataIntegration/xml/xmlSchemaImport.js",
                                description:"\n            Click \"Load Schema\" to load a version of the <code>supplyItem</code>\n            DataSource expressed in XML Schema format, and bind the Grid and Form to it.  Note\n            that the form and grid choose appropriate editors according to declared XML Schema\n            types.  Click \"Validate\" to see validation errors from automatically imported\n            validators.\n            ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"supplyItem.xsd",
                                     url:"dataIntegration/xml/supplyItem.xsd"}
                                ],
                                id:"xmlSchemaImport",
                                title:"XML Schema Import"
                            },
                            {
                                needXML:"true",
                                url:"dataIntegration/xml/schemaChaining.js",
                                description:"\n            Click \"Load Schema\" to load a <code>supplyItem</code> DataSource from\n            XML Schema format, then extend that schema with SmartClient-specific presentation\n            attributes, and bind the Grid and Form to it.  Note that the internal \"itemId\"\n            field has been hidden from the user, some fields have been retitled, and default\n            editors overriden.\n            ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"supplyItem.xsd",
                                     url:"dataIntegration/xml/supplyItem.xsd"}
                                ],
                                id:"schemaChaining",
                                title:"Schema Chaining"
                            },
                            {needXML:"true", ref:"WSDLDataSource", showSkinSwitcher:true,
                             title:"SmartClient WSDL"}
                        ]
                    },
                    {
                        description:"\n        SmartClient brings declarative XPath binding and typed schema (even XML Schema) to the\n        simple and convenient JSON format.\n    ",
                        isOpen:false,
                        title:"JSON",
                        children:[
                            {
                                jsURL:"dataIntegration/json/simpleJSON.js",
                                description:"\n            DataSources can bind directly to JSON data where records appear as an Array of\n            JavaScript Objects with field values as properties.  This approach of loading\n            simple JSON data over HTTP can be used with PHP and other server technologies.\n            ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"countries_small.js",
                                     url:"dataIntegration/json/countries_small.js"}
                                ],
                                id:"simpleJSON",
                                title:"Simple JSON"
                            },
                            {
                                jsURL:"dataIntegration/json/xpathBinding.js",
                                description:"\n            DataSources can extract field values from complex JSON structures via XPath\n            expressions.  Note how the address fields, which are represented in the contacts\n            data as a subobject, appear as columns in the grid.\n            ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"contactsData.js",
                                     url:"dataIntegration/json/contactsData.js"}
                                ],
                                id:"jsonXPath",
                                title:"JSON XPath Binding"
                            },
                            {jsURL:"dataIntegration/json/yahooWebServices.js",
                             description:"\n            Enter a search term in the Query input field to see images from Yahoo Image\n            Search.<BR>\n            XPath binding allows declarative integration with web services.  Note how the\n            height and width for the thumbnail images have been declaratively extracted from\n            the \"Thumbnail\" subobject.\n            ", showSkinSwitcher:true,
                             id:"jsonYahooWebServices", title:"Yahoo! Web Services"},
                            {jsURL:"dataIntegration/json/yahooWebServices.js",
                             description:"\n            Using the \"scriptInclude\" protocol, SmartClient applications can contact compatible\n            JSON web services without the need for any intervening server.\n            ", showSkinSwitcher:true,
                             title:"Cross-Site JSON"},
                            {
                                jsURL:"dataIntegration/json/serverValidationErrors/serverValidationErrors.js",
                                description:"\n            Click \"Save\" to see validation errors derived from a JSON response.<BR>\n            \n            Validation errors expressed in application-specific JSON formats can be \n            communicated to the SmartClient system by implementing\n            <code>DataSource.transformResponse()</code>.  The resulting validation\n            errors will be displayed and tracked by forms and editabled grids.\n            ",
                                showSkinSwitcher:false,
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"serverResponse.js",
                                     url:"dataIntegration/json/serverValidationErrors/serverResponse.js"}
                                ],
                                id:"jsonServerValidationErrors",
                                title:"Server Validation Errors"
                            }
                        ]
                    }
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/server_lightning.png",
                description:"\n    The SmartClient Server framework is a collection of .jar files and optional servlets that works with\n    any J2EE or J2SE container and is easily integrated into existing applications.  Its major\n    features include:<ul>\n    <li><b>Simplified server integration:</b> A pre-built network protocol for browser-server\n        communication, which handles data paging, transactions/batch operations, server-side\n        sort, automatic cache updates, validation and other error handling, optimistic\n        concurrency (aka long transactions) and binary file uploads.<P></li>\n    <li><b>Rapid integration with Java Beans:</b> Robust, complete,\n        bi-directional translation between Java and Javascript objects for \n        rapid integration with any Java beans-based persistence system, including Hibernate,\n        JPA, EJB3, Ibatis, Toplink and custom/homegrown ORM systems.  Send and receive complex\n        structures including Java Enums and Java Generics without the need to write mapping or\n        validation code.  Declaratively trim and rearrange data so that only selected data is\n        sent to the client<P></li>\n    <li><b>SQL Connector:</b> Secure, flexible, built-in support for SQL databases<P></li>\n    <li><b>Hibernate Connector:</b> Built-in support for Hibernate, using either normal\n        Java bean mappings or a special \"beanless\" mode that requires no server-side code or\n        Hibernate config<P></li>\n    <li><b>Server enforcement of Validators:</b> A single file specificies validation rules\n        which are enforced both client and server side<P></li>\n    <li><b>High speed data delivery / data compression<br></li>\n    </ul>\n    The SmartClient Server framework is an optional, commercially-licensed package.  See the \n    <a href=http://www.smartclient.com/product/index.jsp>products page</a> for details.\n    \n",
                isOpen:false,
                id:"serverExamples",
                title:"Server examples",
                children:[
                    {dataSource:"supplyItem", jsURL:"dataIntegration/java/serverValidation.js",
                     requiresModules:"SCServer", description:"\n        Validation rules are automatically enforced on both the client- and server-side based on\n        a single, shared declaration.  Press \"Save\" to see errors from client-side\n        validation.  Press \"Clear Errors\" then \"Disable Validation\" then \"Save\" again to see the\n        same errors caught by the SmartClient server.\n        ",
                     id:"serverValidation", title:"Validation"},
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/database_lightning.png",
                        description:"\n        The SmartClient Server provides powerful built-in support for codeless connection to\n        mainstream SQL databases.\n    ",
                        isOpen:false,
                        title:"SQL",
                        children:[
                            {icon:"[ISO_DOCS_SKIN]/images/silkicons/database_gear.png",
                             jsURL:"serverExamples/sql/vb_Database.js", requiresModules:"SCServer",
                             description:"\n            SmartClient's Visual Builder tool provides an extremely easy and completely codeless \n            way to create DataSources for instantly connecting to existing database tables.  Just\n            click the \"New\" button, select \"Existing SQL Table\", and the Database Browser will\n            show you your tables, column details and the actual data.  Select a table, and \n            Visual Builder will create a fully-functioning DataSource that can perform\n            all four CRUD operations on that table, including - for systems with the Enterprise \n            license - complex searches enabled by SmartClient Advanced Criteria system.\n            ", showSkinSwitcher:false,
                             showSource:false, id:"sqlWizard", title:"Database Wizard"},
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/database_gear.png",
                                jsURL:"serverExamples/sql/basicConnector.js",
                                requiresModules:"SCServer",
                                descriptionHeight:"180",
                                description:"\n            The basic SQL Connector gives you the ability to immediately connect SmartClient components to\n            SQL databases without writing any code.  \n            <P>\n            You can either use the SQL Wizard in Visual Builder to generate a DataSource descriptor\n            (.ds.xml file) from an existing SQL table, or use the Admin Console to generate a SQL table\n            from a DataSource descriptor you write.  Either way, you get the immediate ability to perform\n            all 4 basic SQL operations (select, insert, update, delete) from any of SmartClient's\n            data-aware components.\n            <P>\n            The grid below is connected to a SQL DataSource and has settings enabled to allow this grid to\n            perform all 4 operations.  Type in the input boxes above each column to do query by example.\n            Note that data paging is automatically enabled - just scroll to load data on demand.  Click on\n            a red X to delete a record.  Click on a record to edit it and click \"Add New\" to add a new record.\n            <P>\n            It's easy to add business logic that takes place before and after SQL operations to enforce\n            security or add additional data validation rules.\n            <P>\n            Even if your primary data storage approach is non-SQL or if you choose to use JPA or other ORM\n            systems for most objects, the SQL connector is still valuable for initial prototypes and for\n            lightweight storage when a full ORM approach would be overkill.\n            ",
                                tabs:[
                                    {canEdit:"false", title:"worldDS",
                                     url:"grids/ds/worldSQLDS.ds.xml"}
                                ],
                                id:"sqlConnector",
                                title:"Basic Connector"
                            },
                            {icon:"[ISO_DOCS_SKIN]/images/iconexperience/funnel.png",
                             ref:"filterBuilderBracket", requiresModules:"SCServer,serverCriteria",
                             descriptionHeight:"150", description:"\n            Use the FilterBuilder to construct queries of arbitrary complexity.  The FilterBuilder,\n            and the underlying AdvancedCriteria system, support building queries with subclauses\n            nested to any depth. Add clauses to your query with the \"+\" icon; add nested subclauses \n            with the \"+()\" button. Click \"Filter\" to see the result in the ListGrid.\n            <P>\n            Note that this example is backed by a \"sql\" dataSource; the SmartClient Server is \n            automatically generating the SQL queries required to implement the filters that the \n            FilterBuilder can assemble.  This works adaptively and seamlessly with client-side \n            Advanced Filtering: the generated SQL query will yield exactly the same resultset \n            as the client-side filtering.  This means SmartClient is able to switch to client-side\n            filtering when its cache is full, giving a more responsive, more scalable application.\n            ",
                             title:"Server Advanced Filtering (SQL)"},
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/table_relationship.png",
                                jsURL:"serverExamples/sql/largeValueMap/largeValueMap.js",
                                requiresModules:"SCServer,customSQL",
                                descriptionHeight:"180",
                                description:"\n            This example shows the simple use of custom SQL clauses to provide a DataSource that\n            joins multiple tables while retaining SmartClient's automatic paging and filtering\n            behavior.  When trying this example, remember that this is <b>automatic</b> \n            dataset-handling behavior that works without any coding, even though the data is being \n            provided by a custom SQL query.<p>\n            \n            The list contains order items; each order item holds an itemID, which is being used\n            to join to the supplyItem table and obtain the itemName.  Note that you can filter on\n            the itemName - either select a full item name or just enter a partial value in the \n            combo box.  Pagination is also active - try quickly dragging the scrollbar down, and\n            you'll see SmartClient contacting the server for more records.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"largeValueMap_orderItem",
                                     name:"orderItem"}
                                ],
                                id:"largeValueMapSQL",
                                title:"Large Value Map (SQL)"
                            },
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/user_orange.png",
                                jsURL:"serverExamples/sql/userSpecificData/userSpecificData.js",
                                requiresModules:"SCServer,customSQL",
                                descriptionHeight:"200",
                                description:"\n            This example shows the use of some simple user-written server code in conjunction with\n            SmartClient databound dragging features and the SmartClient SQL DataSource to implement\n            a simple, but secure, shopping cart example.\n            <p>\n            Via DMI (Direct Method Invocation), the <code>cartItem</code> DataSource declares\n            that all DataSource operations should go through a custom Java method\n            <code>CartDMI.enforceUserAccess()</code> <b>before</b> proceeding to read or write\n            the database.  &nbsp;&nbsp<code>CartDMI.enforceUserAccess()</code> adds the current sessionId to the\n            DSRequest, so that the user can only read and write his own shopping cart.\n            <P>\n            Drag items from the left-hand grid to the right-hand grid.  You can edit the quantity\n            in the right-hand grid, and you can delete records.  You can verify that the example\n            is protecting each user's data from others by running the example in two different\n            browsers (eg one Firefox and one IE) - this creates distinct sessions with separate\n            carts.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"cartItem", name:"cartItem"},
                                    {canEdit:"false", title:"supplyItem", url:"supplyItem.ds.xml"},
                                    {canEdit:"false", doEval:"false", title:"CartDMI.java",
                                     url:"serverExamples/sql/userSpecificData/CartDMI.java"}
                                ],
                                id:"userSpecificData",
                                title:"User-Specific Data"
                            },
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/table_multiple.png",
                                jsURL:"serverExamples/sql/dynamicReporting/dynamicReporting.js",
                                requiresModules:"SCServer,customSQL",
                                descriptionHeight:"210",
                                description:"\n            This example shows the use of custom SQL clauses to build a fairly complex query, including\n            both standard and bespoke WHERE conditions and the use of aggregate functions and a \n            GROUP BY.  It is important to note that we can do this whilst still keeping the normal \n            benefits of SmartClient DataSources, such as automatic dataset paging and arbitrary\n            filtering and sorting.  Also note that this example, though it makes heavy use of custom\n            SQL clauses, doesn't make use of any database-specific syntax or functions, so it is \n            portable across different database products.<p>\n            \n            The list contains a summary of orders in a given date range, summarized by item - each\n            item appears just once in the list, alongside the total quantity of that item ordered \n            in the given date range.  Change the date range to be more restrictive (all the rows\n            in the sample database have dates in February 2009) and click \"Filter\", and you will see\n            the quantities change, and items disappear from the list.  You can also use the \n            filter editor at the top of the grid to arbitrarily filter the records, or click\n            the column headings to sort.<p>\n            \n            Scroll the grid quickly to the bottom, and you will see a brief notification as \n            SmartClient contacts the server - pagination is still working, despite the unusual\n            and complex query.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"dynamicReporting_orderItem",
                                     name:"orderItem"}
                                ],
                                id:"dynamicReporting",
                                title:"Dynamic Reporting"
                            }
                        ]
                    },
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/server_lightning.png",
                        description:"\n        The SmartClient Server's built-in support for Hibernate\n    ",
                        isOpen:false,
                        title:"Hibernate / Beans",
                        children:[
                            {icon:"[ISO_DOCS_SKIN]/images/iconexperience/coffeebean_view.png",
                             jsURL:"serverExamples/hibernate/vb_Hibernate.js", requiresModules:"SCServer",
                             description:"\n            SmartClient's Visual Builder tool provides an extremely easy and completely codeless \n            way to create DataSources for instantly connecting to existing Hibernate mapped \n            entitites.  Just click the \"New\" button, select \"Hibernate Bean\", and the Hibernate \n            Browser will show your mapped entities, properties and even the data in the actual \n            table to which the entity is mapped.  Select an entity, and \n            Visual Builder will create a fully-functioning DataSource that can perform\n            all four CRUD operations via Hibernate on that entity, including - for systems with \n            the Enterprise license - complex searches enabled by SmartClient's Advanced \n            Criteria system.\n            ", showSkinSwitcher:false,
                             showSource:false, id:"hibernateWizard", title:"Hibernate Wizard"},
                            {dataSource:"supplyItemHB",
                             icon:"[ISO_DOCS_SKIN]/images/iconexperience/coffeebean_delete.png", jsURL:"dataIntegration/java/hibernatePrototyping.js",
                             requiresModules:"SCServer", description:"\n            SmartClient supports beanless integration with Hibernate for rapid prototyping.\n            Simply declaring a DataSource with <code>serverType:\"hibernate\"</code> enables you\n            to automatically generate tables, import sample data and perform all four\n            DataSource operations, without writing any Java code or creating Hibernate mapping\n            files.  The DataSource is the only file you create.\n            <P>\n            As with all SmartClient DataSources, you can later add business logic that executes\n            before or after SmartClient's default Hibernate behavior, or, you can switch this\n            DataSource to use an actual Java bean, or switch to a completely different data\n            provider (eg a WSDL web service).  In all of these cases nothing in your UI needs\n            to be updated.\n            ",
                             id:"hibernatePrototyping", title:"Hibernate (Beanless)"},
                            {
                                icon:"[ISO_DOCS_SKIN]/images/iconexperience/funnel.png",
                                jsURL:"serverExamples/hibernate/advancedFilter/advancedFilterHibernate.js",
                                requiresModules:"SCServer,serverCriteria",
                                descriptionHeight:"150",
                                description:"\n            Use the FilterBuilder to construct queries of arbitrary complexity.  The FilterBuilder,\n            and the underlying AdvancedCriteria system, support building queries with subclauses\n            nested to any depth. Add clauses to your query with the \"+\" icon; add nested subclauses \n            with the \"+()\" button. Click \"Filter\" to see the result in the ListGrid.\n            <p>\n            Note that this example is backed by a \"hibernate\" dataSource; the SmartClient Server is \n            automatically generating the Hibernate Criteria Queries (including database-specific SQL\n            where necessary) to implement the filters that the FilterBuilder \n            can assemble.    This works adaptively and seamlessly with client-side \n            Advanced Filtering: the generated Criteria query will yield exactly the same resultset \n            as the client-side filtering.  This means SmartClient is able to switch to client-side\n            filtering when its cache is full, giving a more responsive, more scalable application.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"supplyItemHB", name:"supplyItemHB"}
                                ],
                                id:"advancedFilterHibernate",
                                title:"Server Advanced Filtering (Hibernate)"
                            },
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/table_multiple.png",
                                jsURL:"serverExamples/hibernate/masterDetail/masterDetail.js",
                                requiresModules:"SCServer",
                                descriptionHeight:"150",
                                description:"\n            This example shows a simple way to implement an updatable parent-child relationship\n            with SmartClient, the SmartClient Server and Hibernate.  As you can see from from the \n            various source tabs, <code>Order</code> and <code>OrderItem</code> are related via \n            a unidirectional Set collection in Hibernate.\n            The order dataSource also declares its <code>items</code> field as being\n            of type <code>masterDetail_orderItemHB</code>, which tells SmartClient to use that \n            dataSource as schema when processing the detail lines.  With this configuration in\n            place, creating a UI capable of updating across this parent-child association becomes\n            extremely easy - only two lines of SmartClient code, beyond the creation and layout \n            of the visual components themselves, is required.\n            <p>\n            Click a record in the top grid to see the order's details and the associated detail \n            lines in the form and grid below.\n            You can edit the order information using this screen (both header and detail - \n            double-click the grid to edit the details); when you click Save, SmartClient will \n            submit the master and detail information together, and Hibernate will save all \n            changes as a single operation.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"masterDetail_orderHB",
                                     name:"masterDetail_order"},
                                    {canEdit:"false", dataSource:"masterDetail_orderItemHB",
                                     name:"masterDetail_orderItem"},
                                    {canEdit:"false", doEval:"false", title:"Order.java",
                                     url:"serverExamples/hibernate/masterDetail/Order.java"},
                                    {canEdit:"false", doEval:"false", title:"Order.hbm.xml",
                                     url:"serverExamples/hibernate/masterDetail/Order.hbm.xml"},
                                    {canEdit:"false", doEval:"false", title:"OrderItem.java",
                                     url:"serverExamples/hibernate/masterDetail/OrderItem.java"},
                                    {canEdit:"false", doEval:"false", title:"OrderItem.hbm.xml",
                                     url:"serverExamples/hibernate/masterDetail/OrderItem.hbm.xml"}
                                ],
                                id:"masterDetail",
                                title:"Master-Detail (Batch Load and Save)"
                            },
                            {
                                dataSource:"flattenedBeans_flatUserHB",
                                icon:"[ISO_DOCS_SKIN]/images/iconexperience/branch.png",
                                jsURL:"serverExamples/hibernate/flattenedBeans/flattenedBeans.js",
                                requiresModules:"SCServer",
                                descriptionHeight:"150",
                                description:"\n            This example shows the SmartClient Server's support for flattening and reconstructing\n            hierarchical data, by use of XPaths.  The ListGrid below shows each user's address,\n            city and state as if those fields were part of the user's data.  In fact, this address\n            information is held in a separate Address bean; this information is extracted from \n            the separate bean at fetch time by the SmartClient Server, based purely on the XPath\n            declarations of those fields in the dataSource.\n            <p>\n            More interestingly, the SmartClient Server is also able to reconstruct the hierarchical\n            data from the flattened version, again transparently by use of the XPath.  This means\n            that you can update the flattened fields in this example - for example, changing a\n            user's city - and your changes will be correctly persisted.\n            <p>\n            Click a record in the grid to see the order's details in the form.  Edit the user\n            details and click \"Save Changes\".  Using the declared XPaths, the SmartClient Server \n            will populate any changed flattened field back into its correct place in the hierarchy,\n            allowing the data provider (Hibernate, in this case) to persist the change.\n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"FlatUser.java",
                                     url:"serverExamples/hibernate/flattenedBeans/FlatUser.java"},
                                    {canEdit:"false", doEval:"false", title:"FlatUser.hbm.xml",
                                     url:"serverExamples/hibernate/flattenedBeans/FlatUser.hbm.xml"},
                                    {canEdit:"false", doEval:"false", title:"Address.java",
                                     url:"serverExamples/hibernate/flattenedBeans/Address.java"},
                                    {canEdit:"false", doEval:"false", title:"Address.hbm.xml",
                                     url:"serverExamples/hibernate/flattenedBeans/Address.hbm.xml"}
                                ],
                                id:"flattenedBeans",
                                title:"Flattened Data Model"
                            },
                            {
                                dataSource:"supplyItemSpringDMI",
                                jsURL:"dataIntegration/java/hibernateProduction.js",
                                requiresModules:"SCServer",
                                description:"\n            Hibernate's <code>Criteria</code> object can be created from SmartClient's \n            <code>DSRequest</code> in order to fulfill the \"fetch\" operation, with data paging \n            enabled.  Hibernate-managed beans can be populated with inbound, validated data\n            with a single method call.\n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false",
                                     title:"Spring applicationContext.xml", url:"dataIntegration/java/applicationContext.xml"},
                                    {canEdit:"false", doEval:"false", title:"SupplyItemDao.java",
                                     url:"dataIntegration/java/SupplyItemDao.java"},
                                    {canEdit:"false", doEval:"false", title:"SupplyItem.hbml.xml",
                                     url:"dataIntegration/java/SupplyItem.hbm.xml"},
                                    {canEdit:"false", doEval:"false", title:"SupplyItem.java",
                                     url:"dataIntegration/java/SupplyItem.java"}
                                ],
                                id:"hibernateProduction",
                                title:"Hibernate and Spring"
                            },
                            {
                                dataSource:"supplyItemDMI",
                                icon:"[ISO_DOCS_SKIN]/images/iconexperience/coffeebean.png",
                                jsURL:"dataIntegration/java/javaBeans.js",
                                requiresModules:"SCServer",
                                showDataSource:"false",
                                description:"\n            SmartClient DataSource operations can be fulfilled by returning Java Beans (aka EJBs \n            or POJOs) from your existing business logic.  When you call SmartClient's \n            <code>DSResponse.setData()</code> API, your Java objects are automatically translated \n            to JavaScript, transmitted to the browser, and provided to the requesting component.\n            See the sample implementation of the \"fetch\" operation in SupplyItemFetch.java\n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"SupplyItemFetch.java",
                                     url:"dataIntegration/java/SupplyItemFetch.java"},
                                    {canEdit:"false", doEval:"false", title:"SupplyItem.java",
                                     url:"dataIntegration/java/SupplyItem.java"}
                                ],
                                id:"javaBeans",
                                title:"Java Beans"
                            },
                            {
                                dataSource:"supplyItemDMI",
                                icon:"[ISO_DOCS_SKIN]/images/iconexperience/code_java.png",
                                jsURL:"dataIntegration/java/dmi.js",
                                requiresModules:"SCServer",
                                description:"\n            Direct Method Invocation (DMI) allows you to map DataSource operations directly \n            to Java methods via XML configuration in a DataSource descriptor (.ds.xml file).\n            The arguments of your Java methods are automatically populated from the inbound \n            request.  See the sample implementation in SupplyItemDMI.java\n            ",
                                tabs:[
                                    {canEdit:"false", doEval:"false", title:"SupplyItemDMI.java",
                                     url:"dataIntegration/java/SupplyItemDMI.java"},
                                    {canEdit:"false", doEval:"false", title:"SupplyItem.java",
                                     url:"dataIntegration/java/SupplyItem.java"}
                                ],
                                id:"DMI",
                                title:"DMI"
                            }
                        ]
                    },
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/server_lightning.png",
                        description:"\n            SmartClient provides robust support for transactional applications.\n            <P>\n            <b>Queuing</b> allows you to easily combine operations together into a single\n            transaction, for more efficient data loading and transactional saves.\n            <P>\n            <b>Transaction Chaining</b> allows you to declaratively handle data dependencies\n            between operations submitted together in a queue.\n     ",
                        isOpen:false,
                        id:"transactionsFolder",
                        title:"Transactions",
                        children:[
                            {
                                jsURL:"serverExamples/hibernate/queuing/queuing.js",
                                requiresModules:"SCServer",
                                descriptionHeight:"150",
                                description:"\n            Queuing allows any set of DataSource operations to be combined into a single HTTP\n            request, without requiring any special code to be written to transport the combined\n            inputs and outputs.\n            <p>\n            Click the \"Find Orders\" button and the example will load both the selected user's\n            details and all the orders associated with that user, as a single request.\n            Queuing works transparently to the components involved, so for example, scrolling down\n            in the orders grid causes data paging to be activated, exactly as though the grid had\n            done a fetch that was not combined into a queue.  \n            <P>\n            Since queuing is transparent to components, a screen full of various components\n            which need to load data from different sources can participate in a queue without\n            any special component-specific code, and with no need to rework how data is\n            transferred if new components are added - each component can be treated as though\n            it were standalone.\n            <P>\n            Server-side, queuing allows you to focus on simple, secure, reusable data\n            operations and other services, which can then be accessed in arbitrary combinations\n            according to the data loading and saving requirements of particular screens, with\n            no need to write brittle, screen-specific server code.\n            <P>\n            Queuing works even when the operations are on different data providers (as in this \n            case, where the user details are coming from Hibernate and the order details are coming\n            from the SmartClient Server SQL provider).\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"queuing_userHB", name:"queuing_user"},
                                    {canEdit:"false", dataSource:"queuing_order", name:"queuing_order"},
                                    {canEdit:"false", doEval:"false", title:"User.java",
                                     url:"serverExamples/hibernate/queuing/User.java"},
                                    {canEdit:"false", doEval:"false", title:"User.hbm.xml",
                                     url:"serverExamples/hibernate/queuing/User.hbm.xml"}
                                ],
                                id:"queuing",
                                title:"Simple Queuing"
                            },
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/table_row_insert.png",
                                jsURL:"serverExamples/sql/queuedAdd/queuedMasterDetailAdd.js",
                                requiresModules:"SCServer, chaining",
                                descriptionHeight:"150",
                                description:"\n            This example makes use of the SmartClient server's support for setting DSRequest \n            properties dynamically at runtime, based on responses to requests earlier in the \n            same queue.<p>\n            Edit the order header details, then add one or more lines.  When you click \"Save \n            Order\", SmartClient will send multiple DataSource requests to the server - one to\n            save the order header, and one each for however many lines you enter - but it will combine\n            them into a single HTTP request, so that a transactional commit is possible.<p>\n            New orders are given an automatically generated sequence value as a primary\n            key, and the orderItems need this value in order to establish a relationship with\n            their order.<P>\n            As a result of the <code>&lt;values&gt;</code> tag in the <code>queuedAdd_orderItem</code>\n            DataSource definition, the server will set the \"orderID\" property on each order\n            item to the unique sequence value assigned to the order header when it was\n            saved.<P>\n            This entire interaction is accomplished by simply re-using the capability of the\n            DataSource to add new records, without the need to write any server-side\n            code.  SQL DataSources are shown, but this interaction works with any DataSource\n            that can support CRUD operations, include custom DataSources and even a mix of\n            DataSources that use different storage systems.<P>\n            The <code>&lt;values&gt;</code> tag (and the similar \n            property <code>&lt;criteria&gt;</code> tag) are specified using the Velocity\n            Template Language, so the support is very flexible.<P>\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"queuedAdd_order", name:"order"},
                                    {canEdit:"false", dataSource:"queuedAdd_orderItem",
                                     name:"orderItem"},
                                    {canEdit:"false", dataSource:"supplyItem", name:"supplyItem"},
                                    {canEdit:"false", dataSource:"supplyCategory",
                                     name:"supplyCategory"}
                                ],
                                id:"queuedAdd",
                                title:"Master/Detail Add"
                            },
                            {icon:"[ISO_DOCS_SKIN]/images/silkicons/arrow_out.png", ref:"massUpdate",
                             descriptionHeight:"120", description:"\n        <b>Click</b> on any cell to start editing, then <b>Tab</b> or <b>Down Arrow</b> past the\n        last row in the grid to create a new row. Alternatively, click the <b>Edit New</b> button\n        to create a new data-entry row at the end of the grid.  When you click the \"Save\" button\n        all your changes - changed rows and new ones - are sent to the server in a queue, as a \n        single HTTP request.<p>\n        Because all your changes arrive on the server at once, committing \n        them as a single transaction becomes possible.  And because SmartClient's queuing support\n        is completely inobtrusive and requires no extra code on either client or server, as soon\n        as you have an operation that can update a single record, you automatically have an \n        operation that can participate in SmartClient queued updates and potentially transactional\n        commits.\n        ",
                             title:"Mass Update"},
                            {icon:"[ISO_DOCS_SKIN]/images/silkicons/database_link.png",
                             ref:"databoundDragCopy", descriptionHeight:"160",
                             description:"\n        Drag employee records into the Project Team Members list.  SmartClient recognizes that the \n        two dataSources are linked by a foreign key relationship, and automatically uses that \n        relationship to populate values in the records that are added when you drop. SmartClient \n        also populates fields based on current criteria and maps explicit titleFields as necessary.<p>\n        Multi-row selection is enabled on the Employees grid, so you can select multiple employees \n        and drag them to the Teams grid in one go.  Because the grids are databound, this drag and \n        drop action will send data operations to the server automatically, using SmartClient \n        queuing to ensure all the updates arrive on the server together.<p>\n        All of this just works, there is no coding needed to enable it.\n         ", title:"Multi-Row Drag & Save"}
                        ]
                    },
                    {
                        icon:"[ISO_DOCS_SKIN]/images/silkicons/server_lightning.png",
                        description:"\n        Examples showing how to leverage the SmartClient Server to create partially or completely\n        customized DataSource implementations.\n    ",
                        isOpen:false,
                        title:"Custom DataSources",
                        children:[
                            {
                                icon:"[ISO_DOCS_SKIN]/images/silkicons/table_row_insert.png",
                                jsURL:"serverExamples/other/customDataSource/customDataSource.js",
                                requiresModules:"SCServer",
                                descriptionHeight:"150",
                                description:"\n            This example shows an entirely custom DataSource.  It is created by extending \n            <code>BasicDataSource</code> and implementing the four core CRUD methods.  In this \n            case, we maintain a static List of Maps that is initialized with hard-coded data\n            every time the server starts; but of course, this code could do <i>anything</i>. This \n            approach allows completely custom data operations to be simply plugged in to the\n            SmartClient Server framework.<p>\n            Note also that this code deals directly with Java <code>Map</code>s and \n            <code>List</code>s, without worrying about format conversions - even custom code \n            leverages the SmartClient Server's automatic and transparent translation of request\n            data, from JSON to Java and back to JSON.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"customDataSource_user", name:"user"},
                                    {canEdit:"false", doEval:"false", title:"UserDataSource.java",
                                     url:"serverExamples/other/customDataSource/UserDataSource.java"}
                                ],
                                id:"customDataSource",
                                title:"Simple (Hardcoded)"
                            },
                            {
                                icon:"[ISO_DOCS_SKIN]/images/iconexperience/objects_exchange.png",
                                jsURL:"serverExamples/other/ormDataSource/ormDataSource.js",
                                requiresModules:"SCServer",
                                descriptionHeight:"200",
                                description:"\n            This example shows an entirely custom DataSource that connects SmartClient Server to\n            Hibernate (note that this is just an example of the principles involved - SmartClient \n            Server's built-in Hibernate support is considerably more sophisticated than the \n            simple adapter shown here).  It is created by extending <code>BasicDataSource</code>\n            and implementing the four core CRUD methods.  In this case, we connect DataSource\n            requests to Hibernate <code>Criteria</code> queries and the <code>saveOrUpdate</code>  \n            method.<p>\n            This implementation, though simple, is fully functional and could be used unchanged\n            in a real application.  It supports all four CRUD operations, plus data pagination,\n            server-side sorting and filtering, client cache synchronization, and of course it \n            is actually persisting the data to a real database.  Creating an equivalent adapter \n            for Toplink or Ibatis or some other ORM solution would be a fairly simple matter of \n            replacing the Hibernate-specific code in this example with the equivalent specifics \n            from the other ORM system.\n            <p>\n            As with the other custom DataSource examples, note how the <code>ORMDataSource.java</code> \n            code deals entirely in native Java objects - even entirely custom DataSources benefit\n            from SmartClient Server's robust and comprehensive Javascript<->Java translation.\n            ",
                                tabs:[
                                    {canEdit:"false", dataSource:"ormDataSource_country",
                                     name:"country"},
                                    {canEdit:"false", doEval:"false", title:"ORMDataSource.java",
                                     url:"serverExamples/other/ormDataSource/ORMDataSource.java"},
                                    {canEdit:"false", doEval:"false", title:"Country.java",
                                     url:"serverExamples/other/ormDataSource/Country.java"},
                                    {canEdit:"false", doEval:"false", title:"Country.hbm.xml",
                                     url:"serverExamples/other/ormDataSource/Country.hbm.xml"}
                                ],
                                id:"ormDataSource",
                                title:"ORM DataSource"
                            }
                        ]
                    },
                    {icon:"[ISO_DOCS_SKIN]/images/silkicons/arrow_out.png", ref:"export",
                     title:"Excel Export"},
                    {ref:"rssFeed", descriptionHeight:"150",
                     description:"\n            The SmartClient Server includes an HTTP Proxy servlet which allows you to contact REST and\n            WSDL web services as though they were hosted by your web server, avoiding the \"same origin\n            policy\" restriction which normally prevents web applications from accessing remote\n            services.\n            <P>\n            The proxy is used automatically whenever you attempt to contact a URL on another host - no\n            special code is needed.  In this example, a DataSource is configured to download the\n            Slashdot RSS feed, with no server-side code or proxy configuration required.\n            <P>\n            Configuration files allow you to restrict proxying to specific\n            services you wish to allow users to contact through your application.\n        ", title:"HTTP Proxy"}
                ]
            },
            {ref:"dragDropExamples", isOpen:false, title:"Drag & Drop"},
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/overlays.png",
                description:"\n    Basic capabilities shared by all SmartClient visual components.\n",
                isOpen:false,
                title:"Basics",
                children:[
                    {
                        description:"\n    Basic capabilities shared by all SmartClient visual components.\n",
                        isOpen:false,
                        title:"Components",
                        children:[
                            {jsURL:"basics/create.js",
                             description:"\n        Click the button to create new cube objects.\n        ", id:"create",
                             title:"Create"},
                            {jsURL:"basics/draw.js",
                             description:"\n        Click the button to draw another Label component. The first Label is configured\n        to draw automatically.\n        ", id:"autodraw",
                             title:"Draw"},
                            {jsURL:"basics/show.js",
                             description:"\n        Click the buttons to show or hide the message.\n        ", id:"showAndHide",
                             title:"Show & Hide"},
                            {jsURL:"basics/move.js",
                             description:"\n        Click and hold the arrow to move the van. Click on the solid circle to return to\n        the starting position.\n        ", id:"move",
                             title:"Move"},
                            {jsURL:"basics/resize.js",
                             description:"\n        Click the buttons to expand or collapse the text box.\n        ", id:"resize",
                             title:"Resize"},
                            {jsURL:"basics/layer.js",
                             description:"\n        Click the buttons to move the draggable box above or below the other boxes.\n        ", id:"layer",
                             title:"Layer"},
                            {jsURL:"basics/stack.js",
                             description:"\n        <code>HStack</code> and <code>VStack</code> containers manage the stacked positions\n        of multiple member components.\n        ", title:"Stack"},
                            {jsURL:"basics/layout.js",
                             description:"\n        <code>HLayout</code> and <code>VLayout</code> containers manage the stacked positions and\n        sizes of multiple member components. Resize the browser window to reflow these layouts.\n        ", title:"Layout"},
                            {
                                doEval:"false",
                                iframe:"true",
                                url:"inlineComponents/inlineComponents.html",
                                description:"\n        SmartClient GUI components are assembled from the same standard HTML and CSS as\n        plain old web pages. So you can add SmartClient controls above, below, inline,\n        and inside your existing web page elements.\n        ",
                                tabs:[
                                    {title:"cssLayout.css", url:"inlineComponents/cssLayout.css"}
                                ],
                                id:"inlineComponents",
                                title:"Inline components"
                            }
                        ]
                    },
                    {
                        description:"\n    Mixing SmartClient components with HTML pages, chunks, and elements.\n",
                        isOpen:false,
                        title:"HTML",
                        children:[
                            {ref:"inlineComponents", title:"Inline Components"},
                            {description:"\n        SmartClient supports browser history management.  Click your browser's Back button to go\n        to a previous example, and click forward to return to this example.  You can even\n        navigate off the SmartClient site and navigate back.  SmartClient's History module\n        allows you to pick which application events create history entries.\n        ",
                             title:"Back Button"},
                            {jsURL:"html/htmlFlow.js", xmlURL:"html/htmlFlow.xml",
                             description:"\n        The <code>HTMLFlow</code> component displays a chunk of standard HTML in a free-form,\n        flowable region.\n        ", id:"htmlFlow",
                             title:"HTMLFlow"},
                            {jsURL:"html/htmlPane.js", xmlURL:"html/htmlPane.xml",
                             description:"\n        The <code>HTMLPane</code> component displays a chunk or page of standard HTML in a\n        sizeable, scrollable pane.\n        ", id:"htmlPane",
                             title:"HTMLPane"},
                            {jsURL:"html/htmlLabel.js", xmlURL:"html/htmlLabel.xml",
                             description:"\n        The <code>Label</code> component adds alignment, text wrapping, and icon support for\n        small chunks of standard HTML.\n        ", id:"label",
                             title:"Label"},
                            {jsURL:"html/richTextEditor.js", requiresModules:"RichTextEditor",
                             xmlURL:"html/richTextEditor.xml", description:"RichTextEditor supports editing of HTML with a configurable set of\n       styling controls",
                             id:"RichTextEditor", title:"Editing HTML"},
                            {jsURL:"html/htmlImg.js",
                             description:"\n        The <code>Img</code> component displays images in the standard web formats\n        (png, gif, jpg) and other image formats supported by the web browser.\n        ", id:"img",
                             title:"Img"},
                            {jsURL:"html/htmlDynamic1.js",
                             description:"\n        Embed JavaScript expressions inside chunks of HTML to create simple dynamic elements.\n        ", id:"dynamicContents",
                             title:"Dynamic HTML (inline)"},
                            {jsURL:"html/htmlDynamic2.js",
                             description:"\n        Click the buttons to display different chunks of HTML.\n        ", id:"setContents",
                             title:"Dynamic HTML (set)"},
                            {jsURL:"html/htmlLoadImg.js",
                             description:"\n        Click the buttons to load different images.\n        ", id:"loadImages",
                             title:"Load images"},
                            {jsURL:"html/htmlLoadChunks.js",
                             description:"\n        Click the buttons to load different chunks of HTML.\n        ", title:"Load HTML chunks"},
                            {jsURL:"html/htmlLoadPages.js",
                             description:"\n        Click the buttons to display different websites.\n        ", id:"loadHtmlPages",
                             title:"Load HTML pages"}
                        ]
                    },
                    {
                        description:"\n    Basic interactive component capabilities.\n    <BR>\n    <BR>\n    SmartClient components provide hundreds of hooks for event handlers, including\n    all the standard mouse, keyboard, and communication events.\n",
                        isOpen:false,
                        title:"Interaction",
                        children:[
                            {jsURL:"interact/mouseEvents.js",
                             description:"\n        Mouse over the blue square to see the color respond to your position.  Click and hold\n        to see a fade.  If you have a mousewheel, roll up and down to change size.\n        SmartClient components support the standard mouse events in addition to custom events\n        like \"mouseStillDown\".\n        ", id:"customMouseEvents",
                             title:"Mouse events"},
                            {jsURL:"interact/dragEvents.js",
                             description:"\n        Click and drag the pawn over \"Show Drop Reticle\" to see a simple custom drag and drop\n        interaction.\n        ", id:"customDrag",
                             title:"Drag events"},
                            {css:"interact/hover.css", jsURL:"interact/hover.js",
                             description:"\n        Hover over the button, the image, the \"Interesting Facts\" field of the grid, and the\n        \"Severity\" form label to see various hovers.\n        ", showSkinSwitcher:true,
                             id:"customHovers", title:"Hovers / Tooltips"},
                            {jsURL:"interact/contextmenu.js",
                             description:"\n        Right click (or option-click on Macs) on the Yin Yang image to access a context menu.\n        You can also click on the \"Widget\" button to access the identical menu.\n        ", showSkinSwitcher:true,
                             id:"contextMenus", title:"Context menus"},
                            {ref:"fieldEnableDisable", title:"Enable / Disable"},
                            {jsURL:"interact/focus.js",
                             description:"\n        Press the Tab key to cycle through through the tab order starting from the blue\n        piece.  Then drag reorder either piece, click on the leftmost piece and use Tab to\n        cycle through again. Tab order is automatically updated to reflect the visual order.\n        ", id:"focus",
                             title:"Focus & Tabbing"},
                            {jsURL:"interact/cursor.js",
                             description:"\n        Mouse over the draggable labels for a 4-way move cursor.  Move over drag resizeable\n        edges to see resize cursors.  Mouse over the \"Save\" button to see the hand cursor,\n        which is not shown if the \"Save\" button is disabled.\n        ", id:"cursors",
                             title:"Cursors"},
                            {jsURL:"interact/keyboard.js",
                             description:"\n        Click the \"Move Me\" label, then use the arrow keys to move it around.  Hold down keys to see the\n        component respond to key repetition. SmartClient unifies keyboard event handling across browsers.\n        ", id:"keyboardEvents",
                             title:"Keyboard events"},
                            {jsURL:"interact/modality.js",
                             description:"\n        Click on \"Show Window\" to show a modal window.  Note that the \"Touch This\" button no\n        longer shows rollovers or an interactive cursor, nothing outside the window can be\n        clicked, clicks outside the window cause the window to flash, and tabbing remains in a\n        closed loop cycling through only the contents of the window.\n        ", showSkinSwitcher:true,
                             id:"modality", title:"Modality"}
                        ]
                    },
                    {
                        jsURL:"basics/printing.js",
                        description:"\n        SmartClient provides comprehensive support for rendering your UI in a print-friendly\n        fashion.  Click the \"Print Preview\" button and note the following things:\n        <ul>\n        <li>All components have simplified appearance (eg gradients omitted) to be legible in \n        black and white\n        <li>The ListGrid had a scrollbar because it wasn't big enough to show all records, \n        but the printable view shows all data\n        <li>Buttons and other interactive controls that are not meaningful in print view are omitted\n        \n        ",
                        showSkinSwitcher:true,
                        tabs:[
                            {canEdit:"false", title:"worldDS", url:"grids/ds/worldSQLDS.ds.xml"}
                        ],
                        id:"printing",
                        title:"Printing"
                    }
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/layers.png",
                description:"\n    Effects for creating a polished, branded, appealing application.\n    <BR>\n    <BR>\n    SmartClient supports rich skinning and styling capabilities, drag and drop interactions,\n    and built-in animations.\n",
                isOpen:false,
                title:"Effects",
                children:[
                    {
                        description:"\n    Drag & drop services and built-in drag & drop interactions.\n",
                        isOpen:false,
                        id:"dragDropExamples",
                        title:"Drag & Drop",
                        children:[
                            {
                                jsURL:"dragdrop/dragListCopy.js",
                                description:"\n        Drag and drop to copy items from the first list to the second list.\n        You can drag over the top or bottom edge of a scrolling list to scroll\n        in that direction before dropping.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"exampleData", url:"dragdrop/dragList_data.js"}
                                ],
                                title:"Drag list (copy)"
                            },
                            {
                                jsURL:"dragdrop/dragListMove.js",
                                description:"\n        Drag and drop to move items within or between the lists.\n        You can drag over the top or bottom edge of a scrolling list to scroll\n        in that direction before dropping.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"exampleData", url:"dragdrop/dragList_data.js"}
                                ],
                                id:"dragListMove",
                                title:"Drag list (move)"
                            },
                            {
                                jsURL:"dragdrop/dragListSelect.js",
                                description:"\n        Drag to select items in the first list. The second list will\n        mirror your selection.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"exampleData", url:"dragdrop/dragList_data.js"}
                                ],
                                id:"dragListSelect",
                                title:"Drag list (select)"
                            },
                            {
                                jsURL:"dragdrop/dragTreeMove.js",
                                description:"\n        Drag and drop to move parts and folders within and between the trees.\n        You can open a closed folder by pausing over it during a drag interaction\n        (aka \"spring loaded folders\").\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"exampleData", url:"dragdrop/dragTree_data.js"}
                                ],
                                id:"dragTree",
                                title:"Drag tree (move)"
                            },
                            {
                                jsURL:"dragdrop/dragTilesMove.js",
                                description:"\n        Drag and drop animals from the ListGrid on the left to the TileGrid on the right. \n        Animals can also be dragged from the TileGrid back to the ListGrid.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"animalData", url:"grids/data/animalData2.js"}
                                ],
                                id:"dragTiles",
                                title:"Drag tiles (move)"
                            },
                            {
                                description:"\n        Databound components have built-in dragging behaviors that operate on persistent\n        datasets.\n    ",
                                isOpen:false,
                                id:"dataDraggingCopy",
                                title:"Data Binding",
                                children:[
                                    {dataSource:"employees", jsURL:"databind/drag/treeReparent.js",
                                     description:"\n            Dragging employees between managers in this tree automatically saves the new\n            relationship to a DataSource, without writing any code.  Make changes, then \n            reload the page: your changes persist.\n            ", id:"treeReparent",
                                     title:"Tree Reparent"},
                                    {
                                        dataSource:"supplyCategory",
                                        jsURL:"databind/drag/treeRecategorize.js",
                                        description:"\n            Dragging items from the list and dropping them on categories in the tree automatically\n            re-categorizes the item, without any code needed.  Make changes, then \n            reload the page: your changes persist.  This behavior is (optionally) automatic where\n            SmartClient can establish a relationship via foreign key between the DataSources\n            two components are bound to.\n            ",
                                        tabs:[
                                            {title:"supplyItem", url:"supplyItem.ds.xml"}
                                        ],
                                        id:"treeRecategorize",
                                        title:"Recategorize (Tree)"
                                    },
                                    {dataSource:"supplyItem",
                                     jsURL:"databind/drag/listRecategorize.js", description:"\n            The two lists are showing items in different categories.  Drag items from one list to\n            another to automatically recategorize the items without writing any code.  Make\n            changes, then reload the page; your changes persist.\n            ",
                                     id:"listRecategorize", title:"Recategorize (List)"},
                                    {
                                        jsURL:"dragdrop/recategorizeTile.js",
                                        description:"\n            Drag and drop animals between the grids in either direction, and the status of the dropped tile will change to \n            match the filtered status of the TileGrid in which it was dropped. Select different values\n            in the drop down lists above each TileGrid to change the animals that will appear in each grid.\n            ",
                                        showSkinSwitcher:true,
                                        tabs:[
                                            {canEdit:"false", title:"animalsDS",
                                             url:"grids/ds/animalsSQLDS.ds.xml"}
                                        ],
                                        id:"recategorizeTiles",
                                        title:"Recategorize (Tile)"
                                    },
                                    {
                                        dataSource:"employees",
                                        jsURL:"databind/drag/listCopy.js",
                                        description:"\n            Drag employee records into the Project Team Members list.  SmartClient recognizes that the \n            two dataSources are linked by a foreign key relationship, and automatically uses that \n            relationship to populate values in the record that is added when you drop. SmartClient\n            also populates fields based on current criteria and maps explicit titleFields as \n            necessary.<p>\n            In this example, note that SmartClient is automatically populating all three\n            of the fields in the teamMembers dataSource, even though none of those fields is present \n            in the employees dataSource we are dragging from.  Change the \"Team for Project\" select \n            box, then try dragging employees across; note that the Project Code column is being \n            correctly populated for the dropped records.\n            ",
                                        showSkinSwitcher:true,
                                        tabs:[
                                            {title:"teamMembers", url:"teamMembers.ds.xml"}
                                        ],
                                        id:"databoundDragCopy",
                                        title:"Copy"
                                    }
                                ]
                            },
                            {
                                jsURL:"dragdrop/dragFromMenu.js",
                                description:"\n        Open the parts menu and drag parts from the menu onto the grid.\n        Menus support all the drag and drop behaviors supported by grids.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"exampleData", url:"dragdrop/dragList_data.js"}
                                ],
                                id:"dragMenu",
                                title:"Drag from Menu"
                            },
                            {jsURL:"dragdrop/dragMove.js",
                             description:"\n        Drag and drop to move pieces between the boxes. The green box sets a thicker green\n        \"drop line\" indicator to match its border. The blue box shows a \"drag placeholder\"\n        outline at the original location of the dragged object while dragging.\n        ", id:"dragMove",
                             title:"Drag move"},
                            {jsURL:"dragdrop/dragReorder.js",
                             description:"\n        Drag and drop to rearrange the order of the pieces.\n        ", title:"Drag reorder"},
                            {jsURL:"dragdrop/dragTypes.js",
                             description:"\n        Drag and drop to move pieces between the three boxes.\n        The gray box accepts any piece.\n        The blue and green boxes accept pieces of the same color only.\n        ", title:"Drag types"},
                            {jsURL:"dragdrop/dragCreate.js",
                             description:"\n        Drag the large cubes into the boxes to create new small cubes.\n        The blue, yellow, and green boxes accept cubes with the same color only.\n        The gray box accepts any color.\n        Right-click on the small cubes to remove them from the boxes.\n        ", id:"dragCreate",
                             title:"Drag create"},
                            {jsURL:"dragdrop/dragEffects.js",
                             description:"\n        Click and drag to move the labels.\n        ", id:"dragEffects",
                             title:"Drag effects"},
                            {jsURL:"dragdrop/dragReposition.js", visibility:"sdk",
                             description:"\n        Click and drag to move the piece.\n        ", title:"Drag reposition"},
                            {jsURL:"dragdrop/dragResize.js",
                             description:"\n        Click and drag on the edges of the labels to resize.\n        ", id:"dragResize",
                             title:"Drag resize"},
                            {jsURL:"dragdrop/dragTracker.js",
                             description:"\n        Drag and drop the pieces onto the box.\n        ", id:"dragTracker",
                             title:"Drag tracker"},
                            {jsURL:"dragdrop/dragPan.js",
                             description:"\n        Click and drag to pan the image inside its frame.\n        ", id:"dragPan",
                             title:"Drag pan"},
                            {jsURL:"dragdrop/dragSnapTo.js",
                             description:"\n        Drag the box around the grid. It will snap into alignment according to the values you \n        set in the radio buttons below. Snap-to-grid dragging can be enabled separately for \n        moving and resizing; toggle the checkboxes to see this working.\n        ", showSkinSwitcher:true,
                             id:"dragSnapTo", title:"Snap-to-grid Dragging"}
                        ]
                    },
                    {
                        description:"\n    Animation services and built-in animation effects.\n",
                        isOpen:false,
                        title:"Animation",
                        children:[
                            {
                                jsURL:"animate/animateTree.js",
                                description:"\n        Click the open/close icon for any folder.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"exampleData", url:"animate/animateTreeData.js"}
                                ],
                                id:"animateTree",
                                title:"Tree Folders"
                            },
                            {jsURL:"animate/animateMinimize.js",
                             description:"\n        Click on the minimize button (round button in header with flat line).\n        ", showSkinSwitcher:true,
                             id:"windowMinimize", title:"Window Minimize"},
                            {jsURL:"animate/animateSections.xml",
                             description:"\n        Click on any section header to expand/collapse sections.\n        ", showSkinSwitcher:true,
                             id:"animateSections", title:"Section Reveal"},
                            {jsURL:"animate/animateLayout.js",
                             description:"\n        Click on the buttons to hide and show the green star.\n        ", id:"animateLayout",
                             title:"Layout Add & Remove"},
                            {jsURL:"animate/animateMove.js",
                             description:"\n        Click the buttons to move the Label into view or out of view.\n        ", id:"animateMove",
                             title:"Fly Onscreen"},
                            {jsURL:"animate/animateResize.js",
                             description:"\n        Click the buttons to expand or collapse the text box.\n        ", id:"animateResize",
                             title:"Resize"},
                            {jsURL:"animate/animateWipe.js",
                             description:"\n        Click the buttons to show or hide the Label with a \"wipe\" effect.\n        ", id:"animateWipe",
                             title:"Wipe Show & Hide"},
                            {jsURL:"animate/animateSlide.js",
                             description:"\n        Click the buttons to show or hide the Label with a \"slide\" effect.\n        ", title:"Slide Show & Hide"},
                            {jsURL:"animate/animateFade.js",
                             description:"\n        Click the buttons to fade the image.\n        ", id:"animateFade",
                             title:"Fade Show & Hide"},
                            {jsURL:"animate/animateZoom.js",
                             description:"\n        Click the buttons to zoom or shrink the image.\n        ", id:"animateZoom",
                             title:"Zoom & Shrink"},
                            {jsURL:"animate/animateSeqSimple.js",
                             description:"\n        Click the buttons for a 2-stage expand or collapse effect.\n        ", title:"Sequence (simple)"},
                            {jsURL:"animate/animateSeqComplex.js",
                             description:"\n        Click to select and zoom each piece.\n        ", title:"Sequence (complex)"},
                            {jsURL:"animate/animateCustom.js",
                             description:"\n        Click on the globe for a custom \"orbit\" animation.\n        ", id:"customAnimation",
                             title:"Custom Animation"},
                            {ref:"tilingFilter", title:"Tile Filter & Sort"},
                            {fullScreen:"true", jsURL:"animate/portal.js", needServer:"true",
                             screenshot:"animate/portal.png", screenshotHeight:"337",
                             screenshotWidth:"480", description:"Animations built into SmartClient layouts can be used to create a drag and drop portal\n      experience.  Click on the portlet list to the left to create portlets and see them\n      animate into place.  Drag portlets around to new locations and they animate into place.\n        ",
                             showSkinSwitcher:true, id:"portalAnimation", title:"Simple Portal"}
                        ]
                    },
                    {
                        description:"\n    Apply rich visual styles to SmartClient components.\n",
                        isOpen:false,
                        title:"Look & Feel",
                        children:[
                            {jsURL:"lookfeel/edges.js",
                             description:"\n        Drag the text boxes. These boxes show customized frame and glow effects\n        using edge images.\n        ", id:"edges",
                             title:"Edges"},
                            {jsURL:"lookfeel/corners.js",
                             description:"\n        Drag the text boxes. These boxes show customized rounded-corner effects\n        using edge images.        \n        ", id:"corners",
                             title:"Corners"},
                            {jsURL:"lookfeel/shadows.js",
                             description:"\n        Drag the slider to change the shadow depth for the text box.\n        ", badSkins:"BlackOps",
                             bestSkin:"TreeFrog", id:"shadows", title:"Shadows"},
                            {jsURL:"lookfeel/bgColor.js", visibility:"sdk",
                             description:"\n        Click on the color picker to select a background color for the box.\n        ", title:"Background color"},
                            {jsURL:"lookfeel/bgImage.js", visibility:"sdk",
                             description:"\n        Click any button to change the background texture for the box.\n        ", title:"Background texture"},
                            {jsURL:"lookfeel/opacity.js",
                             description:"\n        Drag the slider to change opacity.\n        ", id:"translucency",
                             title:"Translucency"},
                            {jsURL:"lookfeel/boxAttrs.js", visibility:"sdk",
                             description:"\n        Drag the sliders to change the CSS box attributes.\n        <P>\n        Containers in SmartClient automatically react to changes in CSS styling on contained elements\n        \n        ", title:"Box attributes"},
                            {
                                jsURL:"lookfeel/styles.js",
                                description:"\n        Click the radio buttons to apply different CSS styles to the text. Click the CSS tab for\n        CSS class definitions.<BR>\n        This container auto-sizes to the styled text.\n        ",
                                badSkins:"BlackOps",
                                bestSkin:"TreeFrog",
                                tabs:[
                                    {title:"CSS", url:"lookfeel/styles.css"}
                                ],
                                id:"styles",
                                title:"CSS styles"
                            },
                            {css:"lookfeel/consistentSizing.css",
                             jsURL:"lookfeel/consistentSizing.js", description:"\n      Drag the slider to resize all three text boxes. The box sizes match despite different\n      edge styling specified in CSS, enabling CSS-based skinning without affecting\n      application layout.\n    ",
                             id:"consistentSizing", title:"Consistent sizing"},
                            {
                                jsURL:"grids/formatting/cellStyles.js",
                                description:"\n        Mouse over the rows and click-drag to select rows, to see the effects of different\n        base styles on these two grids.\n        ",
                                showSkinSwitcher:true,
                                tabs:[
                                    {title:"CSS", url:"grids/formatting/cellStyles.css"},
                                    {title:"countryData", url:"grids/data/countryData.js"}
                                ],
                                id:"gridCells",
                                title:"Grid cells"
                            }
                        ]
                    }
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/chart_bar.png",
                requiresModules:"PluginBridges,Analytics",
                description:"\n    SmartClient supports a pluggable Charting API that can be easily connected to multiple\n    charting systems, with out of the box integration with the FusionCharts package (sold\n    separately by <a target=\"_blank\" href=\"http://www.infosoftglobal.com/\">Infosoft Global</a>).\n",
                isOpen:false,
                title:"Charting",
                children:[
                    {jsURL:"charts/gridChart.js", requiresModules:"PluginBridges,Analytics",
                     description:"\n        Data loaded into a ListGrid can be charted with a single API call.\n        <P>\n        Use the \"Chart Type\" selector below to see same data rendered by multiple different\n        chart types.  Edit the data in the grid to have the chart regenerated automatically.\n        ", id:"gridCharting",
                     title:"Grid Charting"},
                    {ref:"analytics", requiresModules:"PluginBridges,Analytics",
                     description:"\n       This example shows binding to a multi-dimensional dataset, where each cell value has a\n       series of attributes, called \"facets\", that appear as headers labelling the cell value.\n       Drag facets onto the grid to expand the cube model.<BR>\n       Right click on any cell and pick \"Chart\" to chart values by any two facets.\n       ", title:"CubeGrid Charting"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/cube_blue.png",
                requiresModules:"Drawing",
                description:"\n    SmartClient leverages the native browser drawing capabilities to provide a consistent cross\n    browser drawing interface via the optional <b>Drawing</b> module.\n    <P>\n    This is a <span style=\"color:red\">preview</span> of unreleased SmartClient functionality.  \n    <a href=\"http://www.smartclient.com/company/contact.jsp\">Contact\n    Isomorphic</a> to get\n    early access to this technology.\n",
                isOpen:false,
                title:"Drawing",
                children:[
                    {externalWindowConfig:"height=675,width=740,toolbar=no,resizable=no",
                     requiresModules:"Drawing", screenshot:"drawing/drawing_screenshot.png",
                     screenshotHeight:"336", screenshotWidth:"386", url:"drawing/Drawing.html",
                     description:"Click on the buttons at the top to create (or erase) shapes using\n       the SmartClient drawing module. Drawn objects may be manipulated at runtime - drag the\n       control points, or change the control form values to update them.\n       <P>\n       This is a <span style=\"color:red\">preview</span> of unreleased SmartClient functionality.  \n       <a href=\"http://www.smartclient.com/company/contact.jsp\">Contact\n       Isomorphic</a> to get\n       early access to this technology.\n       ", external:true,
                     id:"Drawing", title:"Shape Playground"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/application_osx.png",
                description:"\n    Demos of complete applications based on SmartClient.\n",
                isOpen:false,
                title:"Applications",
                children:[
                    {ref:"showcaseApp", title:"Office Supply Catalog"},
                    {
                        dataSource:"productRevenue",
                        fullScreen:"true",
                        jsURL:"advanced/cubegrid/databound_cubegrid.js",
                        requiresModules:"PluginBridges,Analytics",
                        screenshot:"advanced/cubegrid/databound_cubegrid.png",
                        screenshotHeight:"327",
                        screenshotWidth:"468",
                        description:"\n        This example shows binding to a multi-dimensional dataset, where each\n        cell value has a series of attributes, called \"facets\", that appear as headers\n        labelling the cell value.  Facets can be added to the view, exposing more detail, by\n        dragging the menu buttons onto the grid, or into the \"Row Facets\" and \"Column Facets\"\n        listings. \n        Click grid turndown controls to expand tree facets.  Note that data loads as it is\n        revealed.\n    ",
                        showSkinSwitcher:true,
                        tabs:[
                            {loadAtEnd:"true", title:"facet controls",
                             url:"advanced/cubegrid/facet_controls.js"}
                        ],
                        id:"analytics",
                        title:"Interactive Analytics"
                    },
                    {fullScreen:"true", jsURL:"portal/smartclientPortal.js",
                     requiresModules:"PluginBridges,Analytics", screenshot:"portal/salesPortal.png",
                     screenshotHeight:"327", screenshotWidth:"468",
                     description:"\n       Going beyond basic portal layout, SmartClient's portalling framework allows users to\n       build a customized layout from a palette of available components, and automatically\n       persist both the layout and customizations made to components.\n       <P>\n       This is a <span style=\"color:red\">preview</span> of unreleased SmartClient functionality.  \n       <a href=\"http://www.smartclient.com/company/contact.jsp\">Contact\n       Isomorphic</a> to get\n       early access to this technology.\n    ", showSkinSwitcher:true,
                     id:"portal", title:"Portal (Preview)"}
                ]
            },
            {
                icon:"[ISO_DOCS_SKIN]/images/silkicons/arrow_branch.png",
                description:"\n    Examples of extending SmartClient functionality\n",
                isOpen:false,
                title:"Extending",
                children:[
                    {css:"extending/portlet.css", jsURL:"extending/componentReuse.js",
                     description:"\n        The portlets below are a custom component created with less than one page of code\n        (see the \"JS\" tab).  The portlets support drag repositioning, drag resizing, a close\n        button, can contain any HTML content, and are skinnable.\n    ", title:"Component Reuse"},
                    {
                        dataSource:"supplyItem",
                        jsURL:"extending/patternReuse.js",
                        description:"\n        Click to select a DataSource, click on records to edit them in the adjacent form, then\n        click the \"Save\" button to save changes.<br>\n        This custom component combines a databound form and grid into a reusable application\n        pattern of side-by-side editing, that can be used with any DataSource.\n    ",
                        tabs:[
                            {canEdit:"false", title:"countryDS", url:"grids/ds/countrySQLDS.ds.xml"}
                        ],
                        id:"patternReuse",
                        title:"Pattern Reuse"
                    },
                    {ref:"schemaChaining", title:"Schema Reuse"},
                    {ref:"customSimpleType", title:"Type Reuse"},
                    {
                        jsURL:"extending/dateFormat_local.js",
                        description:"\n         Dates displayed in the <b>\"Hire Date\"</b> field in this example are formatted using the\n        standard <code>\"toJapanShortDate\"</code> formatter. Click on a record to edit it in the\n        Form, or double click to edit inline in the ListGrid.\n        ",
                        showSource:false,
                        tabs:[
                            {doEval:"false", title:"JS", url:"extending/dateFormat.js"},
                            {title:"employees", url:"extending/employees.js"}
                        ],
                        id:"dateFormat",
                        title:"Standard Date Format"
                    },
                    {
                        jsURL:"extending/customDateFormat_local.js",
                        description:"\n         Dates displayed in the <b>\"Hire Date\"</b> field in this example are formatted\n        using a custom formatting function. Click on a record to edit it in the\n        Form, or double click to edit inline in the ListGrid.\n        ",
                        showSource:false,
                        tabs:[
                            {doEval:"false", title:"JS", url:"extending/customDateFormat.js"},
                            {title:"employees", url:"extending/employees.js"}
                        ],
                        id:"customDateFormat",
                        title:"Custom Date Format"
                    },
                    {dataSource:"supplyItem", jsURL:"extending/customizeFields.js",
                     description:"\n        Edit field definitions in the grid below to override how this form binds to the \n        <code>supplyItem</code> DataSource.  This is a simplified example of how\n        you can deliver an application that can be customized with organization-specific fields\n        and rules.  Dynamic schema binding makes building WYSIWYG editing interfaces very\n        simple.  \n        ", title:"Customize Fields"},
                    {ref:"customDrag", title:"Drag and Drop"},
                    {ref:"customHovers", title:"Hovers"},
                    {ref:"customMouseEvents", title:"Mouse Handling"},
                    {ref:"customAnimation", title:"Animation"},
                    {ref:"portalAnimation", title:"Simple Portal"}
                ]
            }
        ]
    },
    openProperty:"isOpen"
})

