isc.Tree.create({
    ID:"docTree",
    root:{
        name:"/",
        children:[
            {contentsURL:"[docRoot]SmartClient_Quick_Start_Guide.pdf", icon:"[SKIN]pdf.gif",
             id:"QuickStartGuide", title:"SmartClient QuickStart Guide"},
            {contentsURL:"[referenceRoot]SmartClient_Explorer.html", icon:"[SKIN]features.png",
             id:"FeatureExplorer", title:"Feature Explorer"},
            {icon:"[SKIN]cube_blue.gif", ref:"group:featureExplorerOverview",
             id:"featureExplorerOverview", title:"Feature Explorer Overview"},
            {
                isOpen:"true",
                title:"Concepts",
                children:[
                    {
                        title:"Client-Server Integration",
                        id:"2",
                        children:[
                            {id:"38", ref:"group:clientDataIntegration", icon:"[SKIN]cube_blue.gif",
                             title:"Client-side Data Integration"},
                            {id:"53", ref:"group:serverDataIntegration", icon:"[SKIN]cube_blue.gif",
                             title:"Server DataSource Integration"}
                        ],
                        icon:"[SKIN]cube_blue.gif",
                        ref:"group:clientServerIntegration"
                    },
                    {title:"SmartClient Architecture", id:"3", icon:"[SKIN]cube_blue.gif",
                     ref:"group:smartArchitecture"},
                    {title:"Debugging", id:"4", icon:"[SKIN]cube_blue.gif", ref:"group:debugging"},
                    {title:"Deploying SmartClient", id:"5", icon:"[SKIN]cube_blue.gif",
                     ref:"group:iscInstall"},
                    {title:"Visual Builder", id:"6", icon:"[SKIN]cube_blue.gif",
                     ref:"group:visualBuilder"},
                    {title:".NET, PHP, Serverless Integration", id:"7", icon:"[SKIN]cube_blue.gif",
                     ref:"group:nonJavaBackend"},
                    {title:"Integration with Spring", id:"8", icon:"[SKIN]cube_blue.gif",
                     ref:"group:springIntegration"},
                    {title:"Integration with Hibernate", id:"9", icon:"[SKIN]cube_blue.gif",
                     ref:"group:hibernateIntegration"},
                    {title:"Integration with JSF", id:"10", icon:"[SKIN]cube_blue.gif",
                     ref:"group:jsfIntegration"},
                    {title:"Integration with Struts", id:"11", icon:"[SKIN]cube_blue.gif",
                     ref:"group:strutsIntegration"},
                    {
                        title:"Component XML",
                        id:"12",
                        icon:"[SKIN]cube_blue.gif",
                        ref:"group:componentXML",
                        children:[
                            {id:"31", ref:"group:componentSchema", icon:"[SKIN]cube_blue.gif",
                             title:"Component Schema"}
                        ]
                    },
                    {id:"34", ref:"group:i18n", icon:"[SKIN]cube_blue.gif",
                     title:"Internationalization and Localization (i18n,l10n)"},
                    {id:"65", ref:"group:skinning", icon:"[SKIN]cube_blue.gif",
                     title:"Skinning / Theming"}
                ],
                id:"0"
            },
            {
                isOpen:"true",
                title:"Client Reference",
                children:[
                    {
                        title:"Grids",
                        isFolder:true,
                        id:"13",
                        children:[
                            {id:"112", ref:"class:DatabaseBrowser",
                             icon:"[SKIN]text_code_javascript.gif", title:"DatabaseBrowser"},
                            {id:"113", ref:"class:HibernateBrowser",
                             icon:"[SKIN]text_code_javascript.gif", title:"HibernateBrowser"},
                            {
                                id:"145",
                                ref:"class:ListGrid",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"ListGrid",
                                children:[
                                    {id:"146", ref:"class:GroupingMessages",
                                     icon:"[SKIN]text_code_javascript.gif", title:"GroupingMessages"},
                                    {id:"235", ref:"object:ListGridRecord",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ListGridRecord"},
                                    {id:"236", ref:"object:groupNode",
                                     icon:"[SKIN]text_code_javascript.gif", title:"groupNode"},
                                    {id:"237", ref:"object:ListGridField",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ListGridField"},
                                    {id:"238", ref:"object:HeaderSpan",
                                     icon:"[SKIN]text_code_javascript.gif", title:"HeaderSpan"}
                                ]
                            },
                            {id:"215", ref:"object:Hilite", icon:"[SKIN]text_code_javascript.gif",
                             title:"Hilite"},
                            {
                                id:"227",
                                ref:"class:TreeGrid",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"TreeGrid",
                                children:[
                                    {id:"228", ref:"object:TreeNode",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TreeNode"},
                                    {id:"239", ref:"object:TreeGridField",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TreeGridField"}
                                ]
                            },
                            {
                                id:"231",
                                ref:"class:DetailViewer",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"DetailViewer",
                                children:[
                                    {id:"232", ref:"object:DetailViewerRecord",
                                     icon:"[SKIN]text_code_javascript.gif", title:"DetailViewerRecord"},
                                    {id:"233", ref:"object:DetailViewerField",
                                     icon:"[SKIN]text_code_javascript.gif", title:"DetailViewerField"}
                                ]
                            },
                            {id:"243", ref:"class:TileLayout", icon:"[SKIN]text_code_javascript.gif",
                             title:"TileLayout"},
                            {
                                id:"244",
                                ref:"class:TileGrid",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"TileGrid",
                                children:[
                                    {id:"246", ref:"class:SimpleTile",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SimpleTile"}
                                ]
                            },
                            {id:"245", ref:"object:TileRecord", icon:"[SKIN]text_code_javascript.gif",
                             title:"TileRecord"},
                            {id:"247", ref:"class:ColumnTree", icon:"[SKIN]text_code_javascript.gif",
                             title:"ColumnTree"},
                            {id:"248", ref:"class:DOMGrid", icon:"[SKIN]text_code_javascript.gif",
                             title:"DOMGrid"}
                        ]
                    },
                    {
                        title:"Forms",
                        isFolder:true,
                        id:"14",
                        children:[
                            {id:"57", ref:"group:formLayout", icon:"[SKIN]cube_blue.gif",
                             title:"Form Layout"},
                            {
                                id:"58",
                                title:"Form Items",
                                children:[
                                    {
                                        id:"59",
                                        ref:"class:FileItem",
                                        icon:"[SKIN]text_code_javascript.gif",
                                        title:"FileItem",
                                        children:[
                                            {id:"60", ref:"group:upload", icon:"[SKIN]cube_blue.gif",
                                             title:"Uploading Files"}
                                        ]
                                    },
                                    {
                                        id:"151",
                                        ref:"class:FormItem",
                                        icon:"[SKIN]text_code_javascript.gif",
                                        title:"FormItem",
                                        children:[
                                            {id:"152", ref:"object:FormItemIcon",
                                             icon:"[SKIN]text_code_javascript.gif", title:"FormItemIcon"}
                                        ]
                                    },
                                    {id:"155", ref:"class:CanvasItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"CanvasItem"},
                                    {id:"156", ref:"class:TextItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TextItem"},
                                    {id:"157", ref:"class:BlurbItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"BlurbItem"},
                                    {id:"158", ref:"class:ButtonItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ButtonItem"},
                                    {id:"159", ref:"interface:PickList",
                                     icon:"[SKIN]text_code_javascript.gif", title:"PickList"},
                                    {id:"160", ref:"class:SelectItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SelectItem"},
                                    {id:"161", ref:"class:SelectOtherItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SelectOtherItem"},
                                    {id:"162", ref:"class:CheckboxItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"CheckboxItem"},
                                    {id:"163", ref:"class:NativeCheckboxItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"NativeCheckboxItem"},
                                    {id:"164", ref:"class:HeaderItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"HeaderItem"},
                                    {id:"165", ref:"class:SectionItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SectionItem"},
                                    {id:"166", ref:"class:HiddenItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"HiddenItem"},
                                    {id:"167", ref:"class:StaticTextItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"StaticTextItem"},
                                    {id:"168", ref:"class:LinkItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"LinkItem"},
                                    {id:"169", ref:"class:PasswordItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"PasswordItem"},
                                    {id:"170", ref:"class:RadioGroupItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"RadioGroupItem"},
                                    {id:"171", ref:"class:ResetItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ResetItem"},
                                    {id:"172", ref:"class:DateItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"DateItem"},
                                    {id:"173", ref:"class:SpacerItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SpacerItem"},
                                    {id:"174", ref:"class:RowSpacerItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"RowSpacerItem"},
                                    {id:"175", ref:"class:SubmitItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SubmitItem"},
                                    {id:"176", ref:"class:TextAreaItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TextAreaItem"},
                                    {id:"177", ref:"class:AutoFitTextAreaItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"AutoFitTextAreaItem"},
                                    {id:"178", ref:"class:TimeItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TimeItem"},
                                    {id:"179", ref:"class:ToolbarItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ToolbarItem"},
                                    {id:"180", ref:"class:UploadItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"UploadItem"},
                                    {id:"181", ref:"class:ComboBoxItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ComboBoxItem"},
                                    {
                                        id:"182",
                                        ref:"class:MultiFileItem",
                                        icon:"[SKIN]text_code_javascript.gif",
                                        title:"MultiFileItem",
                                        children:[
                                            {id:"183", ref:"class:MultiFilePicker",
                                             icon:"[SKIN]text_code_javascript.gif", title:"MultiFilePicker"}
                                        ]
                                    },
                                    {id:"184", ref:"class:SpinnerItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SpinnerItem"},
                                    {id:"185", ref:"class:SliderItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SliderItem"},
                                    {id:"186", ref:"class:ColorItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ColorItem"},
                                    {id:"187", ref:"class:PickTreeItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"PickTreeItem"},
                                    {id:"191", ref:"class:NestedEditorItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"NestedEditorItem"},
                                    {id:"192", ref:"class:NestedListEditorItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"NestedListEditorItem"},
                                    {id:"224", ref:"class:RichTextItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"RichTextItem"}
                                ]
                            },
                            {id:"104", ref:"class:PropertySheet",
                             icon:"[SKIN]text_code_javascript.gif", title:"PropertySheet"},
                            {id:"111", ref:"class:FilterBuilder",
                             icon:"[SKIN]text_code_javascript.gif", title:"FilterBuilder"},
                            {id:"148", ref:"class:DateChooser", icon:"[SKIN]text_code_javascript.gif",
                             title:"DateChooser"},
                            {id:"150", ref:"class:DynamicForm", icon:"[SKIN]text_code_javascript.gif",
                             title:"DynamicForm"},
                            {
                                id:"153",
                                ref:"class:Validator",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"Validator",
                                children:[
                                    {id:"154", ref:"class:ValidatorTypes",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ValidatorTypes"}
                                ]
                            },
                            {id:"188", ref:"class:SearchForm", icon:"[SKIN]text_code_javascript.gif",
                             title:"SearchForm"},
                            {id:"189", ref:"class:ValuesManager",
                             icon:"[SKIN]text_code_javascript.gif", title:"ValuesManager"},
                            {id:"190", ref:"class:ColorPicker", icon:"[SKIN]text_code_javascript.gif",
                             title:"ColorPicker"}
                        ]
                    },
                    {
                        title:"Layout",
                        isFolder:true,
                        id:"15",
                        children:[
                            {
                                id:"68",
                                ref:"class:TabSet",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"TabSet",
                                children:[
                                    {id:"69", ref:"class:TabBar",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TabBar"},
                                    {id:"72", ref:"object:Tab", icon:"[SKIN]text_code_javascript.gif",
                                     title:"Tab"}
                                ]
                            },
                            {id:"70", ref:"class:Window", icon:"[SKIN]text_code_javascript.gif",
                             title:"Window"},
                            {id:"116", ref:"class:Layout", icon:"[SKIN]text_code_javascript.gif",
                             title:"Layout"},
                            {id:"117", ref:"class:HLayout", icon:"[SKIN]text_code_javascript.gif",
                             title:"HLayout"},
                            {id:"118", ref:"class:VLayout", icon:"[SKIN]text_code_javascript.gif",
                             title:"VLayout"},
                            {id:"119", ref:"class:HStack", icon:"[SKIN]text_code_javascript.gif",
                             title:"HStack"},
                            {id:"120", ref:"class:VStack", icon:"[SKIN]text_code_javascript.gif",
                             title:"VStack"},
                            {id:"121", ref:"class:LayoutSpacer", icon:"[SKIN]text_code_javascript.gif",
                             title:"LayoutSpacer"},
                            {id:"129", ref:"class:Toolbar", icon:"[SKIN]text_code_javascript.gif",
                             title:"Toolbar"},
                            {
                                id:"130",
                                ref:"class:ToolStrip",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"ToolStrip",
                                children:[
                                    {id:"131", ref:"class:ToolStripSeparator",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ToolStripSeparator"},
                                    {id:"144", ref:"class:ToolStripResizer",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ToolStripResizer"}
                                ]
                            },
                            {
                                id:"134",
                                ref:"class:SectionStack",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"SectionStack",
                                children:[
                                    {id:"135", ref:"object:SectionStackSection",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SectionStackSection"},
                                    {id:"136", ref:"class:SectionHeader",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SectionHeader"},
                                    {id:"137", ref:"class:ImgSectionHeader",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ImgSectionHeader"}
                                ]
                            },
                            {id:"141", ref:"class:Splitbar", icon:"[SKIN]text_code_javascript.gif",
                             title:"Splitbar"},
                            {id:"142", ref:"class:ImgSplitbar", icon:"[SKIN]text_code_javascript.gif",
                             title:"ImgSplitbar"},
                            {id:"143", ref:"class:Snapbar", icon:"[SKIN]text_code_javascript.gif",
                             title:"Snapbar"}
                        ]
                    },
                    {
                        title:"Control",
                        isFolder:true,
                        id:"16",
                        children:[
                            {id:"30", ref:"group:Prompting", icon:"[SKIN]cube_blue.gif",
                             title:"Prompting"},
                            {id:"71", ref:"class:Dialog", icon:"[SKIN]text_code_javascript.gif",
                             title:"Dialog"},
                            {
                                id:"122",
                                ref:"class:Button",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"Button",
                                children:[
                                    {id:"123", ref:"class:AutoFitButton",
                                     icon:"[SKIN]text_code_javascript.gif", title:"AutoFitButton"}
                                ]
                            },
                            {id:"124", ref:"class:IButton", icon:"[SKIN]text_code_javascript.gif",
                             title:"IButton"},
                            {id:"128", ref:"class:Progressbar", icon:"[SKIN]text_code_javascript.gif",
                             title:"Progressbar"},
                            {id:"132", ref:"class:ImgButton", icon:"[SKIN]text_code_javascript.gif",
                             title:"ImgButton"},
                            {id:"133", ref:"class:StretchImgButton",
                             icon:"[SKIN]text_code_javascript.gif", title:"StretchImgButton"},
                            {id:"149", ref:"class:Slider", icon:"[SKIN]text_code_javascript.gif",
                             title:"Slider"},
                            {id:"220", ref:"class:Hover", icon:"[SKIN]text_code_javascript.gif",
                             title:"Hover"},
                            {
                                id:"240",
                                ref:"class:Menu",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"Menu",
                                children:[
                                    {id:"241", ref:"object:MenuItem",
                                     icon:"[SKIN]text_code_javascript.gif", title:"MenuItem"}
                                ]
                            },
                            {id:"242", ref:"class:MenuButton", icon:"[SKIN]text_code_javascript.gif",
                             title:"MenuButton"},
                            {id:"249", ref:"class:MenuBar", icon:"[SKIN]text_code_javascript.gif",
                             title:"MenuBar"}
                        ]
                    },
                    {
                        title:"Foundation",
                        isFolder:true,
                        id:"17",
                        children:[
                            {id:"67", ref:"class:ImgTab", icon:"[SKIN]text_code_javascript.gif",
                             title:"ImgTab"},
                            {id:"74", ref:"object:Browser", icon:"[SKIN]text_code_javascript.gif",
                             title:"Browser"},
                            {id:"105", ref:"class:ViewLoader", icon:"[SKIN]text_code_javascript.gif",
                             title:"ViewLoader"},
                            {id:"106", ref:"class:HTMLFlow", icon:"[SKIN]text_code_javascript.gif",
                             title:"HTMLFlow"},
                            {id:"107", ref:"class:HTMLPane", icon:"[SKIN]text_code_javascript.gif",
                             title:"HTMLPane"},
                            {id:"115", ref:"class:StatefulCanvas",
                             icon:"[SKIN]text_code_javascript.gif", title:"StatefulCanvas"},
                            {id:"125", ref:"class:Img", icon:"[SKIN]text_code_javascript.gif",
                             title:"Img"},
                            {id:"126", ref:"class:StretchImg", icon:"[SKIN]text_code_javascript.gif",
                             title:"StretchImg"},
                            {id:"127", ref:"class:Label", icon:"[SKIN]text_code_javascript.gif",
                             title:"Label"},
                            {id:"138", ref:"class:Scrollbar", icon:"[SKIN]text_code_javascript.gif",
                             title:"Scrollbar"},
                            {
                                id:"139",
                                title:"ScrollBar",
                                children:[
                                    {id:"140", ref:"class:ScrollThumb",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ScrollThumb"}
                                ]
                            },
                            {
                                id:"212",
                                ref:"class:Canvas",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"Canvas",
                                children:[
                                    {id:"213", ref:"object:ImgProperties",
                                     icon:"[SKIN]text_code_javascript.gif", title:"ImgProperties"}
                                ]
                            },
                            {id:"219", ref:"class:EdgedCanvas", icon:"[SKIN]text_code_javascript.gif",
                             title:"EdgedCanvas"},
                            {id:"223", ref:"class:RichTextEditor",
                             icon:"[SKIN]text_code_javascript.gif", title:"RichTextEditor"},
                            {id:"234", ref:"class:GridRenderer", icon:"[SKIN]text_code_javascript.gif",
                             title:"GridRenderer"}
                        ]
                    },
                    {
                        title:"Data Binding",
                        isFolder:true,
                        id:"18",
                        children:[
                            {
                                id:"32",
                                ref:"class:DataSource",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"DataSource",
                                children:[
                                    {id:"33", ref:"group:dataSourceDeclaration",
                                     icon:"[SKIN]cube_blue.gif", title:"Creating DataSources"},
                                    {id:"35", ref:"group:sqlDataSource", icon:"[SKIN]cube_blue.gif",
                                     title:"SQL DataSources"},
                                    {id:"36", ref:"group:adminConsole", icon:"[SKIN]cube_blue.gif",
                                     title:"Admin Console"},
                                    {id:"37", ref:"group:clientOnlyDataSources",
                                     icon:"[SKIN]cube_blue.gif", title:"Client Only DataSources"},
                                    {id:"84", ref:"object:Record",
                                     icon:"[SKIN]text_code_javascript.gif", title:"Record"},
                                    {id:"85", ref:"class:DataSourceField",
                                     icon:"[SKIN]text_code_javascript.gif", title:"DataSourceField"},
                                    {id:"86", ref:"object:SerializationContext",
                                     icon:"[SKIN]text_code_javascript.gif", title:"SerializationContext"},
                                    {id:"90", ref:"class:OperationBinding",
                                     icon:"[SKIN]text_code_javascript.gif", title:"OperationBinding"},
                                    {id:"91", ref:"object:AdvancedCriteria",
                                     icon:"[SKIN]text_code_javascript.gif", title:"AdvancedCriteria"},
                                    {id:"92", ref:"object:Criterion",
                                     icon:"[SKIN]text_code_javascript.gif", title:"Criterion"},
                                    {id:"93", ref:"object:Operator",
                                     icon:"[SKIN]text_code_javascript.gif", title:"Operator"},
                                    {id:"110", ref:"class:Operators",
                                     icon:"[SKIN]text_code_javascript.gif", title:"Operators"},
                                    {id:"267", ref:"type:DSCallback", icon:"[SKIN]text_code.gif",
                                     title:"DSCallback"},
                                    {id:"272", ref:"type:OperatorValueType",
                                     icon:"[SKIN]text_code.gif", title:"OperatorValueType"},
                                    {id:"273", ref:"type:OperatorId", icon:"[SKIN]text_code.gif",
                                     title:"OperatorId"}
                                ]
                            },
                            {id:"39", ref:"group:clientDataIntegration", icon:"[SKIN]cube_blue.gif",
                             title:"Client-side Data Integration"},
                            {id:"48", ref:"group:wsdlBinding", icon:"[SKIN]cube_blue.gif",
                             title:"WSDL Binding"},
                            {id:"51", ref:"group:operations", icon:"[SKIN]cube_blue.gif",
                             title:"Operations Overview"},
                            {id:"52", ref:"group:dataSourceOperations", icon:"[SKIN]cube_blue.gif",
                             title:"DataSource Operations"},
                            {id:"54", ref:"group:metadataImport", icon:"[SKIN]cube_blue.gif",
                             title:"Metadata Import"},
                            {id:"56", ref:"group:treeDataBinding", icon:"[SKIN]cube_blue.gif",
                             title:"Tree DataBinding"},
                            {id:"66", ref:"group:dataBoundComponentMethods",
                             icon:"[SKIN]cube_blue.gif", title:"DataBound Component Methods"},
                            {id:"83", ref:"class:XMLTools", icon:"[SKIN]text_code_javascript.gif",
                             title:"XMLTools"},
                            {id:"87", ref:"class:DSResponse", icon:"[SKIN]text_code_javascript.gif",
                             title:"DSResponse"},
                            {id:"88", ref:"class:DSRequest", icon:"[SKIN]text_code_javascript.gif",
                             title:"DSRequest"},
                            {id:"94", ref:"class:XJSONDataSource",
                             icon:"[SKIN]text_code_javascript.gif", title:"XJSONDataSource"},
                            {id:"95", ref:"class:WebService", icon:"[SKIN]text_code_javascript.gif",
                             title:"WebService"},
                            {id:"96", ref:"class:SchemaSet", icon:"[SKIN]text_code_javascript.gif",
                             title:"SchemaSet"},
                            {id:"97", ref:"class:WSRequest", icon:"[SKIN]text_code_javascript.gif",
                             title:"WSRequest"},
                            {id:"102", ref:"class:ResultSet", icon:"[SKIN]text_code_javascript.gif",
                             title:"ResultSet"},
                            {id:"103", ref:"class:ResultTree", icon:"[SKIN]text_code_javascript.gif",
                             title:"ResultTree"},
                            {id:"108", ref:"class:WSDataSource", icon:"[SKIN]text_code_javascript.gif",
                             title:"WSDataSource"},
                            {id:"109", ref:"class:RestDataSource",
                             icon:"[SKIN]text_code_javascript.gif", title:"RestDataSource"},
                            {id:"147", ref:"class:SimpleType", icon:"[SKIN]text_code_javascript.gif",
                             title:"SimpleType"},
                            {id:"214", ref:"interface:DataBoundComponent",
                             icon:"[SKIN]text_code_javascript.gif", title:"DataBoundComponent"},
                            {
                                id:"216",
                                ref:"class:FormulaBuilder",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"FormulaBuilder",
                                children:[
                                    {id:"217", ref:"class:MathFunction",
                                     icon:"[SKIN]text_code_javascript.gif", title:"MathFunction"},
                                    {id:"218", ref:"object:TestFunctionResult",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TestFunctionResult"}
                                ]
                            },
                            {id:"221", ref:"class:JSON", icon:"[SKIN]text_code_javascript.gif",
                             title:"JSON"},
                            {id:"222", ref:"class:JSONEncoder", icon:"[SKIN]text_code_javascript.gif",
                             title:"JSONEncoder"},
                            {id:"251", ref:"class:SummaryBuilder",
                             icon:"[SKIN]text_code_javascript.gif", title:"SummaryBuilder"},
                            {id:"278", ref:"type:Criteria", icon:"[SKIN]text_code.gif",
                             title:"Criteria"}
                        ]
                    },
                    {
                        title:"RPC",
                        isFolder:true,
                        id:"19",
                        children:[
                            {id:"50", ref:"group:relogin", icon:"[SKIN]cube_blue.gif", title:"Relogin"},
                            {id:"89", ref:"class:ServerObject", icon:"[SKIN]text_code_javascript.gif",
                             title:"ServerObject"},
                            {id:"98", ref:"class:RPCManager", icon:"[SKIN]text_code_javascript.gif",
                             title:"RPCManager"},
                            {id:"99", ref:"class:RPCRequest", icon:"[SKIN]text_code_javascript.gif",
                             title:"RPCRequest"},
                            {id:"100", ref:"class:RPCResponse", icon:"[SKIN]text_code_javascript.gif",
                             title:"RPCResponse"},
                            {id:"101", ref:"class:DMI", icon:"[SKIN]text_code_javascript.gif",
                             title:"DMI"},
                            {id:"275", ref:"type:RPCCallback", icon:"[SKIN]text_code.gif",
                             title:"RPCCallback"}
                        ]
                    },
                    {
                        title:"System",
                        isFolder:true,
                        id:"20",
                        children:[
                            {id:"49", ref:"group:platformDependencies", icon:"[SKIN]cube_blue.gif",
                             title:"Platform Dependencies"},
                            {id:"64", ref:"group:stringMethods", icon:"[SKIN]cube_blue.gif",
                             title:"String Methods Overview"},
                            {id:"73", ref:"class:isc", icon:"[SKIN]text_code_javascript.gif",
                             title:"isc"},
                            {id:"75", ref:"class:History", icon:"[SKIN]text_code_javascript.gif",
                             title:"History"},
                            {id:"114", ref:"object:animationShowEffect",
                             icon:"[SKIN]text_code_javascript.gif", title:"animationShowEffect"},
                            {id:"200", ref:"object:isA", icon:"[SKIN]text_code_javascript.gif",
                             title:"isA"},
                            {id:"201", ref:"object:ClassFactory",
                             icon:"[SKIN]text_code_javascript.gif", title:"ClassFactory"},
                            {id:"202", ref:"class:Class", icon:"[SKIN]text_code_javascript.gif",
                             title:"Class"},
                            {id:"203", ref:"object:Array", icon:"[SKIN]text_code_javascript.gif",
                             title:"Array"},
                            {id:"204", ref:"object:Number", icon:"[SKIN]text_code_javascript.gif",
                             title:"Number"},
                            {id:"205", ref:"class:Date", icon:"[SKIN]text_code_javascript.gif",
                             title:"Date"},
                            {id:"206", ref:"class:String", icon:"[SKIN]text_code_javascript.gif",
                             title:"String"},
                            {id:"207", ref:"class:Log", icon:"[SKIN]text_code_javascript.gif",
                             title:"Log"},
                            {id:"208", ref:"class:Time", icon:"[SKIN]text_code_javascript.gif",
                             title:"Time"},
                            {id:"209", ref:"class:Page", icon:"[SKIN]text_code_javascript.gif",
                             title:"Page"},
                            {id:"210", ref:"class:Timer", icon:"[SKIN]text_code_javascript.gif",
                             title:"Timer"},
                            {id:"211", ref:"class:EventHandler", icon:"[SKIN]text_code_javascript.gif",
                             title:"EventHandler"},
                            {id:"225", ref:"interface:List", icon:"[SKIN]text_code_javascript.gif",
                             title:"List"},
                            {
                                id:"226",
                                ref:"class:Tree",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"Tree",
                                children:[
                                    {id:"229", ref:"object:TreeNode",
                                     icon:"[SKIN]text_code_javascript.gif", title:"TreeNode"}
                                ]
                            },
                            {
                                id:"230",
                                ref:"class:Selection",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"Selection",
                                children:[
                                    {id:"250", ref:"class:CellSelection",
                                     icon:"[SKIN]text_code_javascript.gif", title:"CellSelection"}
                                ]
                            },
                            {
                                id:"256",
                                title:"Types",
                                children:[
                                    {id:"257", ref:"type:DialogButtons", icon:"[SKIN]text_code.gif",
                                     title:"DialogButtons"},
                                    {id:"258", ref:"type:EdgeSizes", icon:"[SKIN]text_code.gif",
                                     title:"EdgeSizes"},
                                    {id:"259", ref:"type:XMLDocument", icon:"[SKIN]text_code.gif",
                                     title:"XMLDocument"},
                                    {id:"260", ref:"type:XMLElement", icon:"[SKIN]text_code.gif",
                                     title:"XMLElement"},
                                    {id:"261", ref:"type:DSOperationType", icon:"[SKIN]text_code.gif",
                                     title:"DSOperationType"},
                                    {id:"262", ref:"type:DSDataFormat", icon:"[SKIN]text_code.gif",
                                     title:"DSDataFormat"},
                                    {id:"263", ref:"type:DSServerType", icon:"[SKIN]text_code.gif",
                                     title:"DSServerType"},
                                    {id:"264", ref:"type:EnumTranslateStrategy",
                                     icon:"[SKIN]text_code.gif", title:"EnumTranslateStrategy"},
                                    {id:"265", ref:"type:ValueMap", icon:"[SKIN]text_code.gif",
                                     title:"ValueMap"},
                                    {id:"266", ref:"type:FieldType", icon:"[SKIN]text_code.gif",
                                     title:"FieldType"},
                                    {id:"268", ref:"type:ExportFormat", icon:"[SKIN]text_code.gif",
                                     title:"ExportFormat"},
                                    {id:"269", ref:"type:ExportDisplay", icon:"[SKIN]text_code.gif",
                                     title:"ExportDisplay"},
                                    {id:"270", ref:"type:LineBreakStyle", icon:"[SKIN]text_code.gif",
                                     title:"LineBreakStyle"},
                                    {id:"271", ref:"type:DSProtocol", icon:"[SKIN]text_code.gif",
                                     title:"DSProtocol"},
                                    {id:"274", ref:"type:CriteriaCombineOperator",
                                     icon:"[SKIN]text_code.gif", title:"CriteriaCombineOperator"},
                                    {id:"276", ref:"type:RPCTransport", icon:"[SKIN]text_code.gif",
                                     title:"RPCTransport"},
                                    {id:"277", ref:"type:PromptStyle", icon:"[SKIN]text_code.gif",
                                     title:"PromptStyle"},
                                    {id:"279", ref:"type:FetchMode", icon:"[SKIN]text_code.gif",
                                     title:"FetchMode"},
                                    {id:"280", ref:"type:CriteriaPolicy", icon:"[SKIN]text_code.gif",
                                     title:"CriteriaPolicy"},
                                    {id:"281", ref:"type:LogicalOperator", icon:"[SKIN]text_code.gif",
                                     title:"LogicalOperator"},
                                    {id:"282", ref:"type:TopOperatorAppearance",
                                     icon:"[SKIN]text_code.gif", title:"TopOperatorAppearance"},
                                    {id:"283", ref:"type:AnimationAcceleration",
                                     icon:"[SKIN]text_code.gif", title:"AnimationAcceleration"},
                                    {id:"284", ref:"type:animateShowEffectId",
                                     icon:"[SKIN]text_code.gif", title:"animateShowEffectId"},
                                    {id:"285", ref:"type:State", icon:"[SKIN]text_code.gif",
                                     title:"State"},
                                    {id:"286", ref:"type:SelectionType", icon:"[SKIN]text_code.gif",
                                     title:"SelectionType"},
                                    {id:"287", ref:"type:Selected", icon:"[SKIN]text_code.gif",
                                     title:"Selected"},
                                    {id:"288", ref:"type:Orientation", icon:"[SKIN]text_code.gif",
                                     title:"Orientation"},
                                    {id:"289", ref:"type:LayoutPolicy", icon:"[SKIN]text_code.gif",
                                     title:"LayoutPolicy"},
                                    {id:"290", ref:"type:LayoutResizeBarPolicy",
                                     icon:"[SKIN]text_code.gif", title:"LayoutResizeBarPolicy"},
                                    {id:"291", ref:"type:VisibilityMode", icon:"[SKIN]text_code.gif",
                                     title:"VisibilityMode"},
                                    {id:"292", ref:"type:FormMethod", icon:"[SKIN]text_code.gif",
                                     title:"FormMethod"},
                                    {id:"293", ref:"type:Encoding", icon:"[SKIN]text_code.gif",
                                     title:"Encoding"},
                                    {id:"294", ref:"type:TitleOrientation", icon:"[SKIN]text_code.gif",
                                     title:"TitleOrientation"},
                                    {id:"295", ref:"type:FormItemType", icon:"[SKIN]text_code.gif",
                                     title:"FormItemType"},
                                    {id:"296", ref:"type:FormItemBaseStyle",
                                     icon:"[SKIN]text_code.gif", title:"FormItemBaseStyle"},
                                    {id:"297", ref:"type:CharacterCasing", icon:"[SKIN]text_code.gif",
                                     title:"CharacterCasing"},
                                    {id:"298", ref:"type:TEXTAREA_WRAP", icon:"[SKIN]text_code.gif",
                                     title:"TEXTAREA_WRAP"},
                                    {id:"299", ref:"type:FacetValueMap", icon:"[SKIN]text_code.gif",
                                     title:"FacetValueMap"},
                                    {id:"300", ref:"type:ChartType", icon:"[SKIN]text_code.gif",
                                     title:"ChartType"},
                                    {id:"301", ref:"type:Object", icon:"[SKIN]text_code.gif",
                                     title:"Object"},
                                    {id:"302", ref:"type:SCClassName", icon:"[SKIN]text_code.gif",
                                     title:"SCClassName"},
                                    {id:"303", ref:"type:Callback", icon:"[SKIN]text_code.gif",
                                     title:"Callback"},
                                    {id:"304", ref:"type:Properties", icon:"[SKIN]text_code.gif",
                                     title:"Properties"},
                                    {id:"305", ref:"type:ObjectLiteral", icon:"[SKIN]text_code.gif",
                                     title:"ObjectLiteral"},
                                    {id:"306", ref:"type:AutoChild", icon:"[SKIN]text_code.gif",
                                     title:"AutoChild"},
                                    {id:"307", ref:"type:DateInputFormat", icon:"[SKIN]text_code.gif",
                                     title:"DateInputFormat"},
                                    {id:"308", ref:"type:DateDisplayFormat",
                                     icon:"[SKIN]text_code.gif", title:"DateDisplayFormat"},
                                    {id:"309", ref:"type:LogPriority", icon:"[SKIN]text_code.gif",
                                     title:"LogPriority"},
                                    {id:"310", ref:"type:SortDirection", icon:"[SKIN]text_code.gif",
                                     title:"SortDirection"},
                                    {id:"311", ref:"type:timeFormatter", icon:"[SKIN]text_code.gif",
                                     title:"timeFormatter"},
                                    {id:"312", ref:"type:SendMethod", icon:"[SKIN]text_code.gif",
                                     title:"SendMethod"},
                                    {id:"313", ref:"type:FireStyle", icon:"[SKIN]text_code.gif",
                                     title:"FireStyle"},
                                    {id:"314", ref:"type:PageEvent", icon:"[SKIN]text_code.gif",
                                     title:"PageEvent"},
                                    {id:"315", ref:"type:DragAppearance", icon:"[SKIN]text_code.gif",
                                     title:"DragAppearance"},
                                    {id:"316", ref:"type:DragIntersectStyle",
                                     icon:"[SKIN]text_code.gif", title:"DragIntersectStyle"},
                                    {id:"317", ref:"type:KeyName", icon:"[SKIN]text_code.gif",
                                     title:"KeyName"},
                                    {id:"318", ref:"type:KeyIdentifier", icon:"[SKIN]text_code.gif",
                                     title:"KeyIdentifier"},
                                    {id:"319", ref:"type:clickMaskMode", icon:"[SKIN]text_code.gif",
                                     title:"clickMaskMode"},
                                    {id:"320", ref:"type:Positioning", icon:"[SKIN]text_code.gif",
                                     title:"Positioning"},
                                    {id:"321", ref:"type:Visibility", icon:"[SKIN]text_code.gif",
                                     title:"Visibility"},
                                    {id:"322", ref:"type:Overflow", icon:"[SKIN]text_code.gif",
                                     title:"Overflow"},
                                    {id:"323", ref:"type:Alignment", icon:"[SKIN]text_code.gif",
                                     title:"Alignment"},
                                    {id:"324", ref:"type:VerticalAlignment",
                                     icon:"[SKIN]text_code.gif", title:"VerticalAlignment"},
                                    {id:"325", ref:"type:Side", icon:"[SKIN]text_code.gif",
                                     title:"Side"},
                                    {id:"326", ref:"type:Direction", icon:"[SKIN]text_code.gif",
                                     title:"Direction"},
                                    {id:"327", ref:"type:Cursor", icon:"[SKIN]text_code.gif",
                                     title:"Cursor"},
                                    {id:"328", ref:"type:ImageStyle", icon:"[SKIN]text_code.gif",
                                     title:"ImageStyle"},
                                    {id:"329", ref:"type:DrawPosition", icon:"[SKIN]text_code.gif",
                                     title:"DrawPosition"},
                                    {id:"330", ref:"type:CSSStyleName", icon:"[SKIN]text_code.gif",
                                     title:"CSSStyleName"},
                                    {id:"331", ref:"type:PercentBoxModel", icon:"[SKIN]text_code.gif",
                                     title:"PercentBoxModel"},
                                    {id:"332", ref:"type:SCImgURL", icon:"[SKIN]text_code.gif",
                                     title:"SCImgURL"},
                                    {id:"333", ref:"type:DragDataAction", icon:"[SKIN]text_code.gif",
                                     title:"DragDataAction"},
                                    {id:"334", ref:"type:JSONDateFormat", icon:"[SKIN]text_code.gif",
                                     title:"JSONDateFormat"},
                                    {id:"335", ref:"type:JSONCircularReferenceMode",
                                     icon:"[SKIN]text_code.gif", title:"JSONCircularReferenceMode"},
                                    {id:"336", ref:"type:ControlName", icon:"[SKIN]text_code.gif",
                                     title:"ControlName"},
                                    {id:"337", ref:"type:DisplayNodeType", icon:"[SKIN]text_code.gif",
                                     title:"DisplayNodeType"},
                                    {id:"338", ref:"type:TreeModelType", icon:"[SKIN]text_code.gif",
                                     title:"TreeModelType"},
                                    {id:"339", ref:"type:SelectionStyle", icon:"[SKIN]text_code.gif",
                                     title:"SelectionStyle"},
                                    {id:"340", ref:"type:SortArrow", icon:"[SKIN]text_code.gif",
                                     title:"SortArrow"},
                                    {id:"341", ref:"type:ReorderPosition", icon:"[SKIN]text_code.gif",
                                     title:"ReorderPosition"},
                                    {id:"342", ref:"type:RowEndEditAction", icon:"[SKIN]text_code.gif",
                                     title:"RowEndEditAction"},
                                    {id:"343", ref:"type:EnterKeyEditAction",
                                     icon:"[SKIN]text_code.gif", title:"EnterKeyEditAction"},
                                    {id:"344", ref:"type:EscapeKeyEditAction",
                                     icon:"[SKIN]text_code.gif", title:"EscapeKeyEditAction"},
                                    {id:"345", ref:"type:EditCompletionEvent",
                                     icon:"[SKIN]text_code.gif", title:"EditCompletionEvent"},
                                    {id:"346", ref:"type:ListGridFieldType",
                                     icon:"[SKIN]text_code.gif", title:"ListGridFieldType"},
                                    {id:"347", ref:"type:ListGridEditEvent",
                                     icon:"[SKIN]text_code.gif", title:"ListGridEditEvent"},
                                    {id:"348", ref:"type:DragTrackerMode", icon:"[SKIN]text_code.gif",
                                     title:"DragTrackerMode"},
                                    {id:"349", ref:"type:listGridFieldState",
                                     icon:"[SKIN]text_code.gif", title:"listGridFieldState"},
                                    {id:"350", ref:"type:SelectionAppearance",
                                     icon:"[SKIN]text_code.gif", title:"SelectionAppearance"},
                                    {id:"351", ref:"type:listGridSelectedState",
                                     icon:"[SKIN]text_code.gif", title:"listGridSelectedState"},
                                    {id:"352", ref:"type:listGridSortState",
                                     icon:"[SKIN]text_code.gif", title:"listGridSortState"},
                                    {id:"353", ref:"type:listGridViewState",
                                     icon:"[SKIN]text_code.gif", title:"listGridViewState"},
                                    {id:"354", ref:"type:treeGridOpenState",
                                     icon:"[SKIN]text_code.gif", title:"treeGridOpenState"},
                                    {id:"355", ref:"type:treeGridViewState",
                                     icon:"[SKIN]text_code.gif", title:"treeGridViewState"},
                                    {id:"356", ref:"type:MenuFieldID", icon:"[SKIN]text_code.gif",
                                     title:"MenuFieldID"},
                                    {id:"357", ref:"type:TileLayoutPolicy", icon:"[SKIN]text_code.gif",
                                     title:"TileLayoutPolicy"}
                                ]
                            }
                        ]
                    },
                    {
                        id:"81",
                        title:"Connectors",
                        children:[
                            {id:"82", ref:"class:EBay", icon:"[SKIN]text_code_javascript.gif",
                             title:"EBay"}
                        ]
                    },
                    {
                        id:"252",
                        title:"Calendar",
                        children:[
                            {id:"253", ref:"class:Calendar", icon:"[SKIN]text_code_javascript.gif",
                             title:"Calendar"}
                        ]
                    }
                ],
                id:"1"
            },
            {
                isOpen:"true",
                requiresModules:"SCServer",
                id:"javaServerReference",
                title:"Java Server Reference",
                children:[
                    {title:"SmartClient Server Summary", id:"21", icon:"[SKIN]cube_blue.gif",
                     ref:"group:iscServer"},
                    {title:"Server DataSource Integration", id:"22", icon:"[SKIN]cube_blue.gif",
                     ref:"group:serverDataIntegration"},
                    {contentsURL:"[referenceRoot]server/javadoc/index.html", icon:"[SKIN]cup.gif",
                     title:"Javadoc", id:"23"},
                    {
                        icon:"[SKIN]cube_blue.gif",
                        isOpen:"true",
                        ref:"group:jspTags",
                        title:"SmartClient JSP Tags",
                        isFolder:true,
                        id:"24",
                        children:[
                            {id:"40", ref:"group:loadISCTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadISC&gt;"},
                            {id:"41", ref:"group:loadModulesTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadModules&gt;"},
                            {id:"42", ref:"group:loadDSTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadDS&gt;"},
                            {id:"43", ref:"group:loadUITag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadUI&gt;"},
                            {id:"44", ref:"group:xmlTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:XML&gt;"},
                            {id:"45", ref:"group:loadXMLSchemaTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadXMLSchema&gt;"},
                            {id:"46", ref:"group:loadWSDLTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadWSDL&gt;"},
                            {id:"47", ref:"group:jsStringTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:jsString&gt;"},
                            {id:"55", ref:"group:loadDMIStubsTag", icon:"[SKIN]cube_blue.gif",
                             title:"&lt;isomorphic:loadDMIStubs&gt;"}
                        ]
                    }
                ]
            },
            {
                isOpen:"false",
                id:"optionalModules",
                title:"Optional Modules",
                children:[
                    {
                        isOpen:"false",
                        requiresModules:"Analytics",
                        title:"Analytics",
                        isFolder:true,
                        children:[
                            {contentsURL:"[docRoot]resources/Analytics_QuickRef.pdf",
                             icon:"[SKIN]pdf.gif", title:"CubeGrid QuickRef", id:"29"},
                            {
                                id:"193",
                                ref:"class:CubeGrid",
                                icon:"[SKIN]text_code_javascript.gif",
                                title:"CubeGrid",
                                children:[
                                    {id:"194", ref:"class:Facet",
                                     icon:"[SKIN]text_code_javascript.gif", title:"Facet"},
                                    {id:"195", ref:"class:FacetValue",
                                     icon:"[SKIN]text_code_javascript.gif", title:"FacetValue"},
                                    {id:"196", ref:"object:CellRecord",
                                     icon:"[SKIN]text_code_javascript.gif", title:"CellRecord"}
                                ]
                            },
                            {id:"197", ref:"interface:Chart", icon:"[SKIN]text_code_javascript.gif",
                             title:"Chart"},
                            {id:"198", ref:"class:FusionChart", icon:"[SKIN]text_code_javascript.gif",
                             title:"FusionChart"}
                        ],
                        id:"25"
                    },
                    {
                        isOpen:"false",
                        requiresModules:"RealtimeMessaging",
                        title:"Messaging",
                        isFolder:true,
                        children:[
                            {contentsURL:"[docRoot]resources/Messaging_QuickRef.pdf",
                             icon:"[SKIN]pdf.gif", id:"Messaging QuickRef",
                             title:"Messaging QuickRef"}
                        ],
                        id:"26"
                    },
                    {
                        isOpen:"false",
                        requiresModules:"PluginBridges",
                        title:"Client Bridges",
                        isFolder:true,
                        id:"27",
                        children:[
                            {id:"76", ref:"class:BrowserPlugin", icon:"[SKIN]text_code_javascript.gif",
                             title:"BrowserPlugin"},
                            {id:"77", ref:"class:Applet", icon:"[SKIN]text_code_javascript.gif",
                             title:"Applet"},
                            {id:"78", ref:"class:Flashlet", icon:"[SKIN]text_code_javascript.gif",
                             title:"Flashlet"},
                            {id:"79", ref:"class:SVG", icon:"[SKIN]text_code_javascript.gif",
                             title:"SVG"},
                            {id:"80", ref:"class:ActiveXControl",
                             icon:"[SKIN]text_code_javascript.gif", title:"ActiveXControl"}
                        ]
                    },
                    {
                        isOpen:"false",
                        requiresModules:"NetworkPerformance",
                        title:"Network Performance",
                        isFolder:true,
                        id:"28",
                        icon:"[SKIN]cube_blue.gif",
                        ref:"group:networkPerformance",
                        children:[
                            {id:"61", ref:"group:compression", icon:"[SKIN]cube_blue.gif",
                             title:"Compression"},
                            {id:"62", ref:"group:caching", icon:"[SKIN]cube_blue.gif", title:"Caching"},
                            {id:"63", ref:"group:fileAssembly", icon:"[SKIN]cube_blue.gif",
                             title:"File Assembly"},
                            {id:"199", ref:"class:FileLoader", icon:"[SKIN]text_code_javascript.gif",
                             title:"FileLoader"}
                        ]
                    },
                    {
                        id:"254",
                        title:"Calendar",
                        children:[
                            {id:"255", ref:"object:CalendarEvent",
                             icon:"[SKIN]text_code_javascript.gif", title:"CalendarEvent"}
                        ]
                    }
                ]
            }
        ]
    },
    nameProperty:"id",
    showRoot:false,
    openProperty:"isOpen",
    refToID:{"class:DOMGrid":"248", "class:HTMLFlow":"106", "type:RPCTransport":"276",
     "type:LayoutPolicy":"289", "class:HStack":"119", "object:Hilite":"215", "class:CanvasItem":"155",
     "object:DetailViewerRecord":"232", "class:FacetValue":"195", "class:MenuButton":"242",
     "group:clientServerIntegration":"2", "type:RPCCallback":"275", "class:BrowserPlugin":"76",
     "class:LinkItem":"168", "class:ToolbarItem":"179", "object:Criterion":"92",
     "type:LayoutResizeBarPolicy":"290", "type:SortArrow":"340", "type:DragAppearance":"315",
     "class:EventHandler":"211", "class:HeaderItem":"164", "type:MenuFieldID":"356",
     "type:CriteriaCombineOperator":"274", "group:upload":"60", "class:Page":"209",
     "class:GroupingMessages":"146", "class:SectionStack":"134", "type:EnterKeyEditAction":"343",
     "type:treeGridOpenState":"354", "group:loadWSDLTag":"46", "type:listGridViewState":"353",
     "type:FormItemType":"295", "type:SelectionStyle":"339", "type:ExportFormat":"268",
     "class:HTMLPane":"107", "type:DSProtocol":"271", "class:JSONEncoder":"222",
     "object:Operator":"93", "type:listGridSelectedState":"351", "class:DataSourceField":"85",
     "class:RichTextItem":"224", "class:UploadItem":"180", "group:networkPerformance":"28",
     "class:TimeItem":"178", "class:ValuesManager":"189", "type:LineBreakStyle":"270",
     "class:NestedEditorItem":"191", "class:CubeGrid":"193", "class:ViewLoader":"105",
     "class:SVG":"79", "class:TileGrid":"244", "type:Orientation":"288", "type:State":"285",
     "group:metadataImport":"54", "type:TileLayoutPolicy":"357", "type:ListGridEditEvent":"347",
     "class:Selection":"230", "group:dataBoundComponentMethods":"66", "type:FacetValueMap":"299",
     "object:SectionStackSection":"135", "type:OperatorValueType":"272", "class:ImgSplitbar":"142",
     "class:WebService":"95", "group:fileAssembly":"63", "type:AnimationAcceleration":"283",
     "class:SelectItem":"160", "class:DetailViewer":"231", "class:PickTreeItem":"187",
     "group:operations":"51", "class:Log":"207", "class:OperationBinding":"90", "type:FieldType":"266",
     "class:DateChooser":"148", "type:Direction":"326", "type:SCImgURL":"332",
     "object:CellRecord":"196", "class:FormItem":"151", "class:ImgTab":"67", "type:LogPriority":"309",
     "type:DateInputFormat":"307", "class:Layout":"116", "object:DetailViewerField":"233",
     "type:PromptStyle":"277", "type:PercentBoxModel":"331", "type:DialogButtons":"257",
     "type:VerticalAlignment":"324", "class:XJSONDataSource":"94", "class:ImgSectionHeader":"137",
     "object:animationShowEffect":"114", "type:animateShowEffectId":"284", "object:TileRecord":"245",
     "class:FormulaBuilder":"216", "type:SCClassName":"302", "group:sqlDataSource":"35",
     "class:VStack":"120", "class:isc":"73", "group:dataSourceDeclaration":"33",
     "type:Positioning":"320", "type:TEXTAREA_WRAP":"298", "class:StatefulCanvas":"115",
     "type:CriteriaPolicy":"280", "type:ObjectLiteral":"305", "type:listGridSortState":"352",
     "class:RichTextEditor":"223", "class:SummaryBuilder":"251", "group:platformDependencies":"49",
     "type:DisplayNodeType":"337", "class:Tree":"226", "group:loadUITag":"43",
     "class:TileLayout":"243", "type:treeGridViewState":"355", "type:TopOperatorAppearance":"282",
     "object:ListGridRecord":"235", "object:TreeNode":"229", "type:DSCallback":"267",
     "type:Cursor":"327", "type:Alignment":"323", "type:ValueMap":"265", "class:ResetItem":"171",
     "type:Overflow":"322", "type:Object":"301", "object:groupNode":"236", "type:PageEvent":"314",
     "class:DSRequest":"88", "group:dataSourceOperations":"52", "class:SpacerItem":"173",
     "type:ExportDisplay":"269", "object:TestFunctionResult":"218", "type:DateDisplayFormat":"308",
     "class:RowSpacerItem":"174", "class:ScrollThumb":"140", "class:ResultSet":"102",
     "class:SchemaSet":"96", "object:AdvancedCriteria":"91", "class:String":"206",
     "type:KeyName":"317", "interface:PickList":"159", "class:ColumnTree":"247", "class:Class":"202",
     "class:ResultTree":"103", "class:Validator":"153", "type:DSServerType":"263",
     "type:FormMethod":"292", "class:Slider":"149", "interface:List":"225", "class:SpinnerItem":"184",
     "object:Number":"204", "type:CSSStyleName":"330", "type:XMLElement":"260", "type:Callback":"303",
     "type:FireStyle":"313", "type:FormItemBaseStyle":"296", "group:springIntegration":"8",
     "class:EdgedCanvas":"219", "type:listGridFieldState":"349", "type:XMLDocument":"259",
     "group:smartArchitecture":"3", "group:loadDMIStubsTag":"55", "group:visualBuilder":"6",
     "class:DSResponse":"87", "type:Selected":"287", "group:wsdlBinding":"48", "class:Flashlet":"78",
     "class:FileItem":"59", "class:NativeCheckboxItem":"163", "class:MultiFileItem":"182",
     "class:PasswordItem":"169", "type:EscapeKeyEditAction":"344", "type:Criteria":"278",
     "class:MathFunction":"217", "class:Img":"125", "class:ComboBoxItem":"181",
     "type:DrawPosition":"329", "class:MenuBar":"249", "type:DragIntersectStyle":"316",
     "class:RadioGroupItem":"170", "class:StaticTextItem":"167", "class:FilterBuilder":"111",
     "class:SearchForm":"188", "object:ImgProperties":"213", "type:ControlName":"336",
     "class:ActiveXControl":"80", "group:treeDataBinding":"56", "group:caching":"62",
     "class:JSON":"221", "group:clientOnlyDataSources":"37", "type:clickMaskMode":"319",
     "type:SortDirection":"310", "type:SelectionAppearance":"350", "class:RPCResponse":"100",
     "class:SliderItem":"185", "group:i18n":"34", "type:Encoding":"293", "class:LayoutSpacer":"121",
     "type:LogicalOperator":"281", "class:RPCRequest":"99", "group:debugging":"4",
     "class:SimpleTile":"246", "class:Scrollbar":"138", "type:ImageStyle":"328",
     "object:ListGridField":"237", "object:Record":"84", "type:ChartType":"300",
     "group:hibernateIntegration":"9", "class:Hover":"220", "class:Button":"122",
     "type:AutoChild":"306", "group:iscInstall":"5", "type:OperatorId":"273",
     "type:VisibilityMode":"291", "class:DatabaseBrowser":"112", "class:DynamicForm":"150",
     "class:RestDataSource":"109", "class:ButtonItem":"158", "class:Menu":"240",
     "group:featureExplorerOverview":"featureExplorerOverview", "class:ToolStripResizer":"144",
     "object:isA":"200", "class:EBay":"82", "class:HibernateBrowser":"113", "group:xmlTag":"44",
     "class:Facet":"194", "class:Applet":"77", "class:SectionHeader":"136", "class:TabBar":"69",
     "type:SendMethod":"312", "type:DragDataAction":"333", "type:Visibility":"321",
     "object:MenuItem":"241", "class:Progressbar":"128", "type:Side":"325",
     "type:EnumTranslateStrategy":"264", "class:Date":"205", "group:jsfIntegration":"10",
     "class:SimpleType":"147", "class:MultiFilePicker":"183", "group:nonJavaBackend":"7",
     "group:strutsIntegration":"11", "group:componentSchema":"31", "class:ToolStripSeparator":"131",
     "group:adminConsole":"36", "object:CalendarEvent":"255", "group:formLayout":"57",
     "class:ValidatorTypes":"154", "class:ColorItem":"186", "type:JSONDateFormat":"334",
     "type:FetchMode":"279", "class:SectionItem":"165", "class:TextItem":"156",
     "class:AutoFitTextAreaItem":"177", "class:RPCManager":"98", "group:clientDataIntegration":"39",
     "class:SelectOtherItem":"161", "group:loadDSTag":"42", "class:TreeGrid":"227",
     "group:loadModulesTag":"41", "type:EditCompletionEvent":"345", "type:EdgeSizes":"258",
     "type:ReorderPosition":"341", "object:Tab":"72", "group:Prompting":"30",
     "object:SerializationContext":"86", "class:Timer":"210", "object:Browser":"74",
     "object:Array":"203", "object:HeaderSpan":"238", "group:loadISCTag":"40",
     "class:NestedListEditorItem":"192", "class:TabSet":"68", "class:ColorPicker":"190",
     "object:TreeGridField":"239", "object:FormItemIcon":"152", "class:HiddenItem":"166",
     "class:ImgButton":"132", "class:DMI":"101", "type:CharacterCasing":"297", "group:skinning":"65",
     "class:XMLTools":"83", "type:TreeModelType":"338", "class:Calendar":"253",
     "class:StretchImgButton":"133", "class:DateItem":"172", "class:ToolStrip":"130",
     "class:DataSource":"32", "class:Operators":"110", "interface:Chart":"197",
     "type:DSOperationType":"261", "group:loadXMLSchemaTag":"45", "group:serverDataIntegration":"22",
     "class:FileLoader":"199", "type:SelectionType":"286", "type:JSONCircularReferenceMode":"335",
     "class:Window":"70", "class:ListGrid":"145", "group:compression":"61",
     "type:DragTrackerMode":"348", "type:Properties":"304", "class:History":"75",
     "type:TitleOrientation":"294", "class:Time":"208", "type:KeyIdentifier":"318",
     "class:AutoFitButton":"123", "type:RowEndEditAction":"342", "class:BlurbItem":"157",
     "type:timeFormatter":"311", "class:Toolbar":"129", "class:SubmitItem":"175",
     "interface:DataBoundComponent":"214", "class:ServerObject":"89", "group:jsStringTag":"47",
     "class:Dialog":"71", "class:CheckboxItem":"162", "class:Label":"127", "type:DSDataFormat":"262",
     "class:GridRenderer":"234", "object:ClassFactory":"201", "class:WSRequest":"97",
     "class:CellSelection":"250", "group:iscServer":"21", "group:componentXML":"12",
     "group:jspTags":"24", "class:StretchImg":"126", "type:ListGridFieldType":"346",
     "class:Canvas":"212", "class:Splitbar":"141", "class:PropertySheet":"104",
     "class:FusionChart":"198", "class:VLayout":"118", "group:relogin":"50",
     "group:stringMethods":"64", "class:IButton":"124", "class:WSDataSource":"108",
     "class:HLayout":"117", "class:Snapbar":"143", "class:TextAreaItem":"176"}
})
