/*---------->    YesNoMaybeItem.js    <----------*/


// subclass either TextItem or StaticTextItem, depending on whether we
// provide a free-form edit field as well as the value picker
ClassFactory.defineClass("YesNoMaybeItem", TextItem);

// class (static) properties and methods
YesNoMaybeItem.addClassProperties({
    // (just placeholders for now - these are set dynamically)
	dialog:null,
	currentEditor:null,
    
    // create the picker dialog
	makeDialog : function () {
		YesNoMaybeItem.dialog = Dialog.create({
			autoDraw:false,
			autoCenter:false,
			isModal:true,
			showHeader:false,
            showToolbar:false,
			width:130,
			height:110,
			bodyDefaults:{layoutMargin:10, membersMargin:10},
			items:[
				Button.create({title:"YES", click:"YesNoMaybeItem.setValue(this.title)"}),
				Button.create({title:"NO", click:"YesNoMaybeItem.setValue(this.title)"}),
				Button.create({title:"MAYBE", click:"YesNoMaybeItem.setValue(this.title)"})
			]
		});
	},
	// show the picker dialog at the specified position (could be smarter about this)
	showDialog : function (left, top) {
		this.dialog.moveTo(left, top);
		this.dialog.show();
	},
	// set the specified value and dismiss the picker dialog
	setValue : function (value) {
		this.currentEditor.setValue(value);
		this.dialog.hide();
	}    
});

// instance properties and methods
YesNoMaybeItem.addProperties({
	icons:[{}], // could specify a different image here

    // (this logic could alternatively go on the 'click' handler of the icon object)
	iconClick : function (form, item, icon) {
		// get global coordinates of the clicked picker icon
		var iconRect = this.getIconPageRect(icon);

		// lazily create the YesNoMaybe picker dialog the first time a yesNoMaybe editor is clicked
		if (!YesNoMaybeItem.dialog) YesNoMaybeItem.makeDialog();

		// remember what editor is active, so we can set its value from the picker dialog
		YesNoMaybeItem.currentEditor = this;

		// show the picker dialog
		YesNoMaybeItem.showDialog(iconRect[0],iconRect[1]);
	}
});

