#!/bin/sh

# detect operating system type
OS=`uname -s`

# if JAVA_HOME is not set, try to autodetect
if [ "x$JAVA_HOME" = "x" ]; then
    # On OS X the most current version is always in /Library/Java/Home
    if [ $OS = "Darwin" ]; then
        JAVA_HOME="/Library/Java/Home"
    else
        # On Unix jdk1.3+ is in /usr/j2se - failing that it's in /usr/java
        if [ -d /usr/j2se ]; then
            JAVA_HOME="/usr/j2se"
        else
            JAVA_HOME="/usr/java"
        fi
    fi
    echo
    echo "Using auto-detected JAVA_HOME: $JAVA_HOME"
    echo
else
    echo
    echo "Using user-defined JAVA_HOME: $JAVA_HOME" 
    echo
fi

# if JAVA_HOME is set, we use $JAVA_HOME/bin/java - otherwise just use whatever's in the PATH
JAVA=java
if [ "x$JAVA_HOME" != "x" ]; then
    export JAVA_HOME
    JAVA="$JAVA_HOME/bin/java"
else
    echo
    echo "Error: could not find a Java JDK or JRE on your system."
    echo
    echo "If you do not have Java installed, please download and install the JDK."
    echo "If you do have Java installed, please set the JAVA_HOME environment"
    echo "variable to the base directory of the JDK."
    echo
    exit 1
fi

# run the tool
$JAVA -Xmx512m -cp $JAVA_HOME/lib/tools.jar:$JAVA_HOME/lib/dt.jar:../../WEB-INF/embeddedTomcat/lib/servlet-api.jar:../../WEB-INF/embeddedTomcat/lib/catalina-optional.jar:../../WEB-INF/embeddedTomcat/lib/jmx.jar:../../WEB-INF/embeddedTomcat/lib/commons-el.jar:../../WEB-INF/embeddedTomcat/lib/naming-resources.jar:../../WEB-INF/embeddedTomcat/lib/tomcat-coyote.jar:../../WEB-INF/embeddedTomcat/lib/catalina.jar:../../WEB-INF/embeddedTomcat/lib/naming-factory.jar:../../WEB-INF/embeddedTomcat/lib/tomcat-http.jar:../../WEB-INF/embeddedTomcat/lib/xercesImpl.jar:../../WEB-INF/embeddedTomcat/lib/tomcat-util.jar:../../WEB-INF/embeddedTomcat/lib/jsp-api.jar:../../WEB-INF/embeddedTomcat/lib/commons-logging.jar:../../WEB-INF/embeddedTomcat/lib/jasper-runtime.jar:../../WEB-INF/embeddedTomcat/lib/servlets-default.jar:../../WEB-INF/embeddedTomcat/lib/jasper-compiler.jar:../../WEB-INF/embeddedTomcat/lib/commons-modeler-2.0.jar:../../WEB-INF/embeddedTomcat/lib/jasper-compiler-jdt.jar:../../WEB-INF/embeddedTomcat/lib/xml-apis.jar:../../WEB-INF/classes/:../../WEB-INF/lib/log4j-1.2.15.jar:../../WEB-INF/lib/commons-cli-1.1.jar:../../WEB-INF/lib/isomorphic_embedded_tomcat.jar com.isomorphic.embedded_tomcat.EmbeddedTomcat --maxThreads 200 --catalinaHome ../embeddedTomcat "$@"
