@echo off

set HAVE_JDK=0
set HAVE_JRE=0
rem ===========================================================================
rem JAVA_HOME detection
rem ===========================================================================
rem if JAVA_HOME is set in the env, use that
set USER_DEFINED_JAVA_HOME=1
if not "%JAVA_HOME%" == "" goto checkJavaHome
set USER_DEFINED_JAVA_HOME=0

rem if JAVA_HOME is not set in the current environment, try to look it up in the registry
rem ===========================================================================
rem JDK detection
rem ===========================================================================
regedit /e javaVersion.txt "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Development Kit"
if not exist javaVersion.txt goto tryJRE
for /f "tokens=2 delims==" %%i in ('type javaVersion.txt ^| find "CurrentVersion"') do set JAVA_VERSION=%%i
for /f "tokens=*" %%i in (%JAVA_VERSION%) do set JAVA_VERSION=%%i
del javaVersion.txt

regedit /e javaHome.txt "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Development Kit\%JAVA_VERSION%"
if not exist javaHome.txt goto tryJRE
for /f "tokens=2 delims==" %%i in ('type javaHome.txt ^| find "JavaHome"') do set JAVA_HOME=%%i
for /f "tokens=*" %%i in (%JAVA_HOME%) do set JAVA_HOME=%%i
del javaHome.txt
if not "%JAVA_HOME%" == "" set HAVE_JDK=1
goto checkJavaHome

rem ===========================================================================
rem JRE detection
rem ===========================================================================
:tryJRE
regedit /e javaVersion.txt "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Runtime Environment"
if not exist javaVersion.txt goto checkJavaHome
for /f "tokens=2 delims==" %%i in ('type javaVersion.txt ^| find "CurrentVersion"') do set JAVA_VERSION=%%i
for /f "tokens=*" %%i in (%JAVA_VERSION%) do set JAVA_VERSION=%%i
del javaVersion.txt

regedit /e javaHome.txt "HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Runtime Environment\%JAVA_VERSION%"
if not exist javaHome.txt goto tryJRE
for /f "tokens=2 delims==" %%i in ('type javaHome.txt ^| find "JavaHome"') do set JAVA_HOME=%%i
for /f "tokens=*" %%i in (%JAVA_HOME%) do set JAVA_HOME=%%i
del javaHome.txt
if not "%JAVA_HOME%" == "" set HAVE_JRE=1



:checkJavaHome
if %USER_DEFINED_JAVA_HOME% == 1 (
    echo. 
    echo:Using user-defined JAVA_HOME: %JAVA_HOME%
    echo. 
    goto setJava
)

if %HAVE_JDK% == 1 (
    echo.
    echo:Using auto-detected JDK JAVA_HOME: %JAVA_HOME%
    echo.
    goto setJava
)

if %HAVE_JRE% == 1 (
    echo.
    echo:Using auto-detected JRE JAVA_HOME: %JAVA_HOME%
    echo.
    goto setJava
)

rem if JAVA_HOME is unset, complain
if "%JAVA_HOME%" == "" (
    echo.
    echo:Error: could not find a Java JDK or JRE in your environment.
    echo.
    echo:If you do not have Java installed, please download and install the JDK.
    echo:If you do have Java installed, please set the JAVA_HOME environment
    echo:variable to the base directory of the JDK.
    echo.
    pause
    exit
)

:setJava
rem if JAVA_HOME environment var is set, look in there for the java binary - otherwise rely on the
rem PATH environment var
set JAVA=java
if not "%JAVA_HOME%" == "" set JAVA=%JAVA_HOME%\bin\java

rem read in command line args
set ARGS=
:argLoop
if ""%1""=="""" goto endArgLoop
    set ARGS=%ARGS% %1
    shift
    goto argLoop
:endArgLoop

rem run the tool
"%JAVA%" -Xmx512m -cp "%JAVA_HOME\lib\tools.jar%";"%JAVA_HOME\lib\dt.jar%";..\..\WEB-INF\embeddedTomcat\lib\servlet-api.jar;..\..\WEB-INF\embeddedTomcat\lib\catalina-optional.jar;..\..\WEB-INF\embeddedTomcat\lib\jmx.jar;..\..\WEB-INF\embeddedTomcat\lib\commons-el.jar;..\..\WEB-INF\embeddedTomcat\lib\naming-resources.jar;..\..\WEB-INF\embeddedTomcat\lib\tomcat-coyote.jar;..\..\WEB-INF\embeddedTomcat\lib\catalina.jar;..\..\WEB-INF\embeddedTomcat\lib\naming-factory.jar;..\..\WEB-INF\embeddedTomcat\lib\tomcat-http.jar;..\..\WEB-INF\embeddedTomcat\lib\xercesImpl.jar;..\..\WEB-INF\embeddedTomcat\lib\tomcat-util.jar;..\..\WEB-INF\embeddedTomcat\lib\jsp-api.jar;..\..\WEB-INF\embeddedTomcat\lib\commons-logging.jar;..\..\WEB-INF\embeddedTomcat\lib\jasper-runtime.jar;..\..\WEB-INF\embeddedTomcat\lib\servlets-default.jar;..\..\WEB-INF\embeddedTomcat\lib\jasper-compiler.jar;..\..\WEB-INF\embeddedTomcat\lib\commons-modeler-2.0.jar;..\..\WEB-INF\embeddedTomcat\lib\jasper-compiler-jdt.jar;..\..\WEB-INF\embeddedTomcat\lib\xml-apis.jar;..\..\WEB-INF\classes\;..\..\WEB-INF\lib\log4j-1.2.15.jar;..\..\WEB-INF\lib\commons-cli-1.1.jar;..\..\WEB-INF\lib\isomorphic_embedded_tomcat.jar com.isomorphic.embedded_tomcat.EmbeddedTomcat --maxThreads 200 --catalinaHome ../embeddedTomcat %ARGS%

rem if there was an error or relevant output - allow the user to see it before the window
rem auto-closes
pause
