/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.ValidatorException;
import isc.org.apache.oro.text.perl.Perl5Util;
import isc.org.apache.oro.text.regex.MalformedPatternException;
import isc.org.apache.oro.text.regex.Perl5Compiler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Validator
extends Base {
    private static Logger log;
    private static final Map validatorFunctions;
    private static final List clientOnlyValidators;
    static final Map defaultValidators;
    private Map validators;
    static /* synthetic */ Class class$com$isomorphic$util$Validator;

    public static void addValidator(String type, Method method) {
        validatorFunctions.put(type, method);
    }

    public List validateRecords(List records) throws ValidatorException {
        ArrayList<ErrorReport> results = new ArrayList<ErrorReport>();
        Iterator e = records.iterator();
        while (e.hasNext()) {
            ErrorReport errors = this.validateRecord((Map)e.next());
            if (errors == null) continue;
            results.add(errors);
        }
        return results.isEmpty() ? null : results;
    }

    public ErrorReport validateRecord(Map record) throws ValidatorException {
        ErrorReport report = new ErrorReport();
        Iterator e = this.validators.keySet().iterator();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            Object rawFieldValidators = this.validators.get(fieldName);
            if (rawFieldValidators == null) continue;
            List fieldValidators = DataTools.makeListIfSingle(rawFieldValidators);
            Validator.validateField(record, fieldName, fieldValidators, report);
        }
        return report.isEmpty() ? null : report;
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators) throws ValidatorException {
        ErrorReport report = new ErrorReport();
        Validator.validateField(record, fieldName, fieldValidators, report);
        return report;
    }

    public static void validateField(Map record, String fieldName, List fieldValidators, ErrorReport report) throws ValidatorException {
        Object value = record.get(fieldName);
        Iterator f = fieldValidators.iterator();
        while (f.hasNext()) {
            String type;
            Object fieldValidator = f.next();
            HashMap valParams = null;
            boolean stopIfFalse = false;
            if (fieldValidator instanceof String) {
                type = (String)fieldValidator;
                valParams = new HashMap();
            } else {
                valParams = (HashMap)fieldValidator;
                type = (String)valParams.get("type");
                stopIfFalse = DataTools.getBoolean(valParams, "stopIfFalse");
            }
            ErrorMessage error = Validator.processValidator(type, value, fieldName, record, valParams);
            if (error == null) continue;
            report.addError(fieldName, error);
            if (stopIfFalse) break;
        }
    }

    private static final ErrorMessage processValidator(String validatorName, Object value, String fieldName, Map record, Map validatorParams) throws ValidatorException {
        Object clientOnly;
        if (validatorParams != null && (clientOnly = validatorParams.get("clientOnly")) != null && clientOnly.toString().equals("true")) {
            return null;
        }
        if (validatorName == null) {
            return new ErrorMessage("Validator missing type property: " + validatorParams + "\nIf this is a custom validator, set the clientOnly property to true.");
        }
        if (clientOnlyValidators.contains(validatorName)) {
            return null;
        }
        ValidatorFunc vfunc = Validator.getBuiltinValidator(validatorName);
        if (vfunc != null) {
            return vfunc.validate(validatorParams, value, fieldName, record);
        }
        Method valFunc = (Method)validatorFunctions.get(validatorName);
        if (valFunc == null) {
            String valFuncName = (String)validatorParams.get("serverValidationFunction");
            if (valFuncName == null) {
                return new ErrorMessage("No built-in validator named '" + validatorName + "' was found. Set the clientOnly property to true if this is a custom validator.");
            }
            try {
                valFunc = Reflection.findMethod(valFuncName);
                Validator.addValidator(validatorName, valFunc);
            }
            catch (Throwable t) {
                log.error((Object)("No implementer for validator: " + validatorName), t);
                return new ErrorMessage("No implementer found for validator named '" + validatorName + "'\nIf you want a validator to be client-side only, set its clientOnly property to true.");
            }
        }
        ErrorMessage error = null;
        try {
            Object[] args = new Object[]{validatorParams, value, record};
            error = (ErrorMessage)valFunc.invoke(null, args);
            return error;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = Reflection.getRealTargetException(t);
            }
            return new ErrorMessage(DataTools.getStackTrace(t));
        }
    }

    static ValidatorFunc getBuiltinValidator(String validatorName) {
        return (ValidatorFunc)defaultValidators.get(validatorName);
    }

    private static final Long getParamAsLong(Map params, Object key) {
        Long param = null;
        if (!params.containsKey(key)) {
            return null;
        }
        try {
            param = new Long(params.get(key).toString());
        }
        catch (NumberFormatException e) {
            param = null;
        }
        return param;
    }

    private static final Double getParamAsDouble(Map params, Object key) {
        Double value = null;
        if (!params.containsKey(key)) {
            return null;
        }
        try {
            value = new Double(params.get(key).toString());
        }
        catch (NumberFormatException e) {
            value = null;
        }
        return value;
    }

    private static final String getErrorString(Map params) {
        String errorMessage = (String)params.get("errorMessage");
        if (errorMessage == null) {
            errorMessage = "Validation failed";
        }
        return errorMessage;
    }

    private static final String getErrorString(Map params, String defaultMessage) {
        String errorMessage = (String)params.get("errorMessage");
        if (errorMessage == null) {
            errorMessage = defaultMessage;
        }
        return errorMessage;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Validator(Map theValidators) {
        this.validators = theValidators;
    }

    static {
        Class clazz = class$com$isomorphic$util$Validator;
        if (clazz == null) {
            clazz = class$com$isomorphic$util$Validator = Validator.class("[Lcom.isomorphic.util.Validator;", false);
        }
        log = new Logger(clazz.getName());
        validatorFunctions = Collections.synchronizedMap(new HashMap());
        clientOnlyValidators = DataTools.makeList("requiredIf");
        defaultValidators = new HashMap();
        defaultValidators.put("required", new required());
        defaultValidators.put("isBoolean", new isBoolean());
        defaultValidators.put("isInteger", new isInteger());
        defaultValidators.put("isDate", new isDate());
        defaultValidators.put("isTime", new isTime());
        defaultValidators.put("integerRange", new integerRange());
        defaultValidators.put("regexp", new regexp());
        defaultValidators.put("regex", new regexp());
        defaultValidators.put("lengthRange", new lengthRange());
        defaultValidators.put("matchesField", new matchesField());
        defaultValidators.put("isOneOf", new isOneOf());
        defaultValidators.put("contains", new contains());
        defaultValidators.put("doesntContain", new doesntContain());
        defaultValidators.put("substringCount", new substringCount());
        defaultValidators.put("mask", new mask());
        defaultValidators.put("floatLimit", new floatLimit());
        defaultValidators.put("floatPrecision", new floatPrecision());
        defaultValidators.put("floatRange", new floatRange());
        defaultValidators.put("isFloat", new isFloat());
        defaultValidators.put("isIdentifier", new isIdentifier());
        defaultValidators.put("isURL", new isURL());
        defaultValidators.put("isString", new isString());
        defaultValidators.put("inValueMap", new inValueMap());
        defaultValidators.put("isRegexp", new isRegexp());
        defaultValidators.put("integerOrAuto", new integerOrAuto());
        defaultValidators.put("isMeasure", new isMeasure());
    }

    static interface ValidatorFunc {
        public ErrorMessage validate(Map var1, Object var2, String var3, Map var4) throws ValidatorException;
    }

    static class required
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return new ErrorMessage("Field is required");
            }
            return null;
        }

        required() {
        }
    }

    static class isBoolean
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("") || value instanceof Boolean) {
                return null;
            }
            if (value instanceof Number) {
                double number = ((Number)value).doubleValue();
                boolean bl = false;
                if (number != 0.0) {
                    bl = true;
                }
                record.put(fieldName, new Boolean(bl));
            } else if (value instanceof String) {
                record.put(fieldName, new Boolean((String)value));
            } else {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a true/false value"));
            }
            return null;
        }

        isBoolean() {
        }
    }

    static class isInteger
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            long longValue;
            if (value == null || value.equals("") || value instanceof Integer) {
                return null;
            }
            try {
                longValue = Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a whole number."));
            }
            record.put(fieldName, new Long(longValue));
            return null;
        }

        isInteger() {
        }
    }

    static class isDate
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            SimpleDateFormat dateFormat;
            if (value == null || value instanceof Date) {
                return null;
            }
            if (value.equals("")) {
                record.put(fieldName, null);
                return null;
            }
            String dateString = ((String)value).toString();
            if (dateString.length() == 19) {
                dateFormat = dateString.charAt(10) == 'T' ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
                dateString = dateString + " -0000";
            } else {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            }
            try {
                Date date = dateFormat.parse(dateString);
                record.put(fieldName, date);
                return null;
            }
            catch (ParseException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a date."));
            }
        }

        isDate() {
        }
    }

    static class isTime
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value instanceof Date) {
                return null;
            }
            if (value.equals("")) {
                record.put(fieldName, null);
                return null;
            }
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            try {
                Date time = timeFormat.parse(value.toString());
                record.put(fieldName, time);
                return null;
            }
            catch (ParseException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a time."));
            }
        }

        isTime() {
        }
    }

    static class integerRange
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            long num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a whole number"));
            }
            Long min = Validator.getParamAsLong(validatorParams, "min");
            Long max = Validator.getParamAsLong(validatorParams, "max");
            if (min == null && max == null) {
                throw new ValidatorException("integerRange validator called without valid min or max");
            }
            if (max != null && num > max) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be less than " + max), max);
            }
            if (min != null && num < min) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be greater than " + min), min);
            }
            return null;
        }

        integerRange() {
        }
    }

    static class regexp
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String expression = (String)validatorParams.get("expression");
            if (expression == null) {
                throw new ValidatorException("regexp validator called without expression");
            }
            Perl5Util util = new Perl5Util();
            if (!util.match(expression = "/" + expression + '/', value.toString())) {
                return new ErrorMessage(Validator.getErrorString(validatorParams));
            }
            return null;
        }

        regexp() {
        }
    }

    static class lengthRange
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Long min = Validator.getParamAsLong(validatorParams, "min");
            Long max = Validator.getParamAsLong(validatorParams, "max");
            if (min == null && max == null) {
                throw new ValidatorException("lengthRange validator called without valid min or max");
            }
            String s = value.toString();
            if (max != null && (long)s.length() > max || min != null && (long)s.length() < min) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be between " + min + '-' + max + " characters long"));
            }
            return null;
        }

        lengthRange() {
        }
    }

    static class matchesField
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            Object otherField = validatorParams.get("otherField");
            if (otherField == null) {
                throw new ValidatorException("matchesField validator called without valid otherField");
            }
            Object otherFieldValue = record.get(otherField);
            if (value == null && otherFieldValue == null || value.equals(otherFieldValue)) {
                return null;
            }
            return new ErrorMessage(Validator.getErrorString(validatorParams, "Does not match value in field '" + otherField + '\''));
        }

        matchesField() {
        }
    }

    static class isOneOf
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Collection list = (Collection)validatorParams.get("list");
            if (list == null) {
                throw new ValidatorException("isOneOf validator called without valid list for field: " + fieldName);
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                if (!value.toString().equals(e.next().toString())) continue;
                return null;
            }
            return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be one of " + list.toString() + '.'));
        }

        isOneOf() {
        }
    }

    static class contains
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            if (substring == null) {
                throw new ValidatorException("contains validator called without valid substring");
            }
            if (value.toString().indexOf(substring) == -1) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must contain '" + substring + '\''));
            }
            return null;
        }

        contains() {
        }
    }

    static class doesntContain
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            if (substring == null) {
                throw new ValidatorException("doesntContain validator called without valid substring");
            }
            if (value.toString().indexOf(substring) > -1) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must not contain '" + substring + '\''));
            }
            return null;
        }

        doesntContain() {
        }
    }

    static class substringCount
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            String val = value.toString();
            if (substring == null) {
                throw new ValidatorException("substringCount validator called without valid substring");
            }
            long matchCount = 0L;
            int i = 0;
            while (i < val.length()) {
                if ((i = val.indexOf(substring, i)) <= -1) break;
                ++matchCount;
                ++i;
            }
            String operator = (String)validatorParams.get("operator");
            Long countObj = Validator.getParamAsLong(validatorParams, "count");
            if (operator == null) {
                operator = "==";
            }
            long count = countObj == null ? 0L : countObj;
            if (operator.equals("==")) {
                if (matchCount == count) {
                    return null;
                }
            } else if (operator.equals("!=")) {
                if (matchCount != count) {
                    return null;
                }
            } else if (operator.equals(">")) {
                if (matchCount > count) {
                    return null;
                }
            } else if (operator.equals("<")) {
                if (matchCount < count) {
                    return null;
                }
            } else if (operator.equals(">=")) {
                if (matchCount >= count) {
                    return null;
                }
            } else if (operator.equals("<=")) {
                if (matchCount <= count) {
                    return null;
                }
            } else {
                throw new ValidatorException("in substringCount validator, operator was " + operator + ", must be one of ==, !=, >, <, >= or <=");
            }
            return new ErrorMessage(Validator.getErrorString(validatorParams, "Must contain " + operator + ' ' + count + " instances of '" + substring + '\''));
        }

        substringCount() {
        }
    }

    static class mask
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String mask2 = (String)validatorParams.get("mask");
            if (mask2 == null) {
                throw new ValidatorException("mask validator called without valid mask");
            }
            Perl5Util util = new Perl5Util();
            if (!util.match(mask2 = "/" + mask2 + '/', value.toString())) {
                return new ErrorMessage(Validator.getErrorString(validatorParams));
            }
            return null;
        }

        mask() {
        }
    }

    static class floatLimit
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            double num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a valid decimal."));
            }
            Double min = Validator.getParamAsDouble(validatorParams, "min");
            Double max = Validator.getParamAsDouble(validatorParams, "max");
            if (max != null && num > max) {
                return new ErrorMessage(Validator.getErrorString(validatorParams), max);
            }
            if (min != null && num < min) {
                return new ErrorMessage(Validator.getErrorString(validatorParams), min);
            }
            Double precision = Validator.getParamAsDouble(validatorParams, "precision");
            if (precision != null) {
                double multiplier = Math.pow(10.0, precision);
                double suggestedValue = new Long(Math.round(num * multiplier)).doubleValue() / multiplier;
                if (suggestedValue == num) {
                    return null;
                }
                String message = "No more than " + precision.intValue() + " digits after the decimal point.";
                return new ErrorMessage(Validator.getErrorString(validatorParams, message), new Double(suggestedValue));
            }
            return null;
        }

        floatLimit() {
        }
    }

    static class floatPrecision
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            double num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a valid decimal."));
            }
            Double precision = Validator.getParamAsDouble(validatorParams, "precision");
            if (precision != null) {
                double multiplier = Math.pow(10.0, precision);
                double suggestedValue = new Long(Math.round(num * multiplier)).doubleValue() / multiplier;
                if (suggestedValue == num) {
                    return null;
                }
                String message = "No more than " + precision.intValue() + " digits after the decimal point.";
                return new ErrorMessage(Validator.getErrorString(validatorParams, message), new Double(suggestedValue));
            }
            return null;
        }

        floatPrecision() {
        }
    }

    static class floatRange
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            double num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a valid decimal."));
            }
            Double min = Validator.getParamAsDouble(validatorParams, "min");
            Double max = Validator.getParamAsDouble(validatorParams, "max");
            if (max != null && num > max) {
                return new ErrorMessage(Validator.getErrorString(validatorParams), max);
            }
            if (min != null && num < min) {
                return new ErrorMessage(Validator.getErrorString(validatorParams), min);
            }
            return null;
        }

        floatRange() {
        }
    }

    static class isFloat
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                double num = DataTools.asDouble(value);
                record.put(fieldName, new Double(num));
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, "Must be a valid decimal."));
            }
            return null;
        }

        isFloat() {
        }
    }

    static class isIdentifier
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (DataTools.isIdentifier((String)value)) {
                return null;
            }
            return new ErrorMessage(Validator.getErrorString(validatorParams, "Not a valid identifier"));
        }

        isIdentifier() {
        }
    }

    static class isURL
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                new URL(value.toString());
            }
            catch (MalformedURLException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, e.getMessage()));
            }
            return null;
        }

        isURL() {
        }
    }

    static class isString
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            record.put(fieldName, value.toString());
            return null;
        }

        isString() {
        }
    }

    static class inValueMap
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Object valueMap = validatorParams.get("valueMap");
            if (valueMap == null) {
                throw new ValidatorException("inValueMap validator called without a valueMap");
            }
            if (valueMap instanceof Collection) {
                validatorParams.put("list", new ArrayList((Collection)valueMap));
            } else if (valueMap instanceof Map) {
                validatorParams.put("list", DataTools.enumToList(((Map)valueMap).keySet().iterator()));
            } else {
                throw new ValidatorException("The value map must be either a collection or a map");
            }
            return Validator.getBuiltinValidator("isOneOf").validate(validatorParams, value, fieldName, record);
        }

        inValueMap() {
        }
    }

    static class isRegexp
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                new Perl5Compiler().compile(value.toString());
            }
            catch (MalformedPatternException e) {
                return new ErrorMessage(Validator.getErrorString(validatorParams, e.getMessage()));
            }
            return null;
        }

        isRegexp() {
        }
    }

    static class integerOrAuto
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if ("auto".equalsIgnoreCase(value.toString())) {
                return null;
            }
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number or \"auto\"");
            }
            return Validator.getBuiltinValidator("isInteger").validate(validatorParams, value, fieldName, record);
        }

        integerOrAuto() {
        }
    }

    static class isMeasure
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("") || value.equals("*")) {
                return null;
            }
            String str = value.toString();
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number, percentage, \"*\" or \"auto\"");
            }
            if (str.endsWith("%")) {
                try {
                    Long.parseLong(str.substring(0, str.length() - 1));
                }
                catch (NumberFormatException e) {
                    return new ErrorMessage(Validator.getErrorString(validatorParams, "Not a valid percentage"));
                }
                return null;
            }
            return Validator.getBuiltinValidator("integerOrAuto").validate(validatorParams, value, fieldName, record);
        }

        isMeasure() {
        }
    }

    static class isColor
    implements ValidatorFunc {
        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String str = value.toString();
            int index = 0;
            int length = str.length();
            if (str.charAt(0) == '#') {
                index = 1;
            }
            while (index < length) {
                char ch = str.charAt(index);
                if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                    return new ErrorMessage(Validator.getErrorString(validatorParams, "Not a valid color"));
                }
                ++index;
            }
            return null;
        }

        isColor() {
        }
    }
}

