/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class IOUtil {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void copyStreams(InputStream in, OutputStream out) throws IOException {
        IOUtil.copyStreams(in, out, 4096, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufSize) throws IOException {
        IOUtil.copyStreams(in, out, bufSize, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, boolean buffered) throws IOException {
        IOUtil.copyStreams(in, out, 4096, buffered);
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufSize];
        if (buffered) {
            in = new BufferedInputStream(in);
            out = new BufferedOutputStream(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    public static void copyCharacterStreams(Reader in, Writer out) throws IOException {
        IOUtil.copyCharacterStreams(in, out, 4096, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize) throws IOException {
        IOUtil.copyCharacterStreams(in, out, bufSize, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, boolean buffered) throws IOException {
        IOUtil.copyCharacterStreams(in, out, 4096, buffered);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        char[] buffer = new char[bufSize];
        if (buffered) {
            in = new BufferedReader(in);
            out = new BufferedWriter(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addOutput(OutputStream out, Object input) throws Exception {
        if (input instanceof List) {
            List inputs = (List)input;
            Iterator e = inputs.iterator();
            while (true) {
                if (!e.hasNext()) {
                    return;
                }
                IOUtil.addOutput(out, e.next());
            }
        }
        if (input instanceof String) {
            OutputStreamWriter writer = new OutputStreamWriter(new NonFlushingOutputStream(out));
            writer.write((String)input);
            ((Writer)writer).flush();
            return;
        }
        if (input instanceof InputStream) {
            InputStream inputStream = (InputStream)input;
            try {
                IOUtil.copyStreams(inputStream, out);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var4_10 = null;
                try {}
                catch (Exception ignored) {
                    return;
                }
                inputStream.close();
                return;
            }
        }
        if (!(input instanceof Reader)) throw new Exception("Unsupported input format: " + input.getClass().getName());
        Reader inputReader = (Reader)input;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new NonFlushingOutputStream(out));
            IOUtil.copyCharacterStreams(inputReader, writer);
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            try {
                inputReader.close();
                throw throwable;
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_12 = null;
            try {}
            catch (Exception ignored) {
                return;
            }
            inputReader.close();
            return;
        }
    }

    public static Reader makeReader(Object source) {
        if (source == null) {
            throw new NullPointerException("Passed null source");
        }
        if (source instanceof Reader) {
            return (Reader)source;
        }
        if (source instanceof InputStream) {
            return new InputStreamReader((InputStream)source);
        }
        if (source instanceof String || source instanceof StringBuffer) {
            return new StringReader(source.toString());
        }
        if (source instanceof char[]) {
            return new CharArrayReader((char[])source);
        }
        if (source instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])source));
        }
        throw new IllegalArgumentException("Don't know to make a Reader from a " + source.getClass().getName());
    }

    public static String inputStreamToString(InputStream stream) throws IOException {
        return IOUtil.readerToString(new InputStreamReader(stream));
    }

    public static String readerToString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtil.copyCharacterStreams(reader, writer);
        return ((Object)writer).toString();
    }

    public static void closeQuitely(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuitely(OutputStream os) {
        try {
            os.flush();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class NonFlushingOutputStream
    extends FilterOutputStream {
        public void flush() {
        }

        public NonFlushingOutputStream(OutputStream stream) {
            super(stream);
        }
    }
}

