/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.taglib.VirtualTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import java.io.File;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WidgetXMLTag
extends VirtualTag {
    public String filename;

    public int doStartTag() throws JspException {
        this.init();
        if (this.filename != null) {
            try {
                WidgetXMLTag.parseAndOutputErrors(this.filename, (Writer)this.pageContext.getOut(), this.pageContext);
            }
            catch (Throwable e) {
                this.log.warn("Exception processing XML from file '" + this.filename + "': " + DataTools.getStackTrace(e));
                throw new JspException(DataTools.getStackTrace(e));
            }
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        String body = this.bodyContent.getString();
        this.bodyContent.clearBody();
        if (body != null && !body.equals("")) {
            try {
                SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(body), "</isomorphicXML>");
                WidgetXMLTag.parseAndOutputErrors(new InputSource(reader), (Writer)this.getPreviousOut());
            }
            catch (Throwable e) {
                this.log.error("Exception processing inline XML: " + DataTools.getStackTrace(e));
                throw new JspException(DataTools.getStackTrace(e));
            }
        }
        return 0;
    }

    public static void parseAndOutputErrors(String filename, Writer out, PageContext pageContext) throws Exception {
        try {
            if (virtualize) {
                if (new File(filename).isAbsolute()) {
                    staticLog.warn("XML Virtualization is on, but tag filename property specifies absolute path(" + filename + ").  Absolute paths cannot be virtualized - inlining instead.");
                } else {
                    if (config.getBoolean((Object)"caching.taglib.virtualizeXML.allowFileAccess", false)) {
                        WidgetXMLTag.virtualizeTag("xmlFile", filename, out, pageContext);
                        return;
                    }
                    staticLog.info("XML Virtualization is on, but allowFileAccess is off. inlining " + filename);
                }
            }
            Document doc = XML.getXMLDocument(filename);
            WidgetXMLTag.toJS(doc, out);
        }
        catch (XMLParsingException e) {
            WidgetXMLTag.outputParseErrors(e, out);
        }
    }

    public static void parseAndOutputErrors(InputSource source, Writer out) throws Exception {
        try {
            Document doc = XML.parseXML(source);
            WidgetXMLTag.toJS(doc, out);
        }
        catch (XMLParsingException e) {
            WidgetXMLTag.outputParseErrors(e, out);
        }
    }

    public static void outputParseErrors(XMLParsingException e, Writer out) throws Exception {
        staticLog.info("isc:XML tag outputting XML parsing errors");
        List errors = e.getErrors();
        Iterator i = errors.iterator();
        while (i.hasNext()) {
            String errorMessage = (String)i.next();
            errorMessage = "Server-generated XML parsing error: " + errorMessage;
            String jsString = new JSTranslater().toJS(errorMessage);
            out.write("Log.logWarn(" + jsString + ")\n");
        }
    }

    public static void toJS(Document doc, Writer out) throws Exception {
        ValidationContext context = new ValidationContext();
        Object result = DataSource.recordsFromXML(doc.getDocumentElement(), context);
        new JSTranslater().toJS(result, out);
        if (context.hasErrors()) {
            out.write("\n");
            new JSTranslater().toJSVariable(context.getErrors(), "errors", out);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRunat(String runat) {
    }

    public String getRunat() {
        return "NOT SUPPORTED";
    }

    private final /* synthetic */ void this() {
        this.filename = null;
    }

    public WidgetXMLTag() {
        this.this();
    }
}

