/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.taglib.LoadTag;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;

public class LoadSystemSchemaTag
extends LoadTag {
    public int doStartTag() throws JspException {
        this.init();
        try {
            LoadSystemSchemaTag.loadFrameworkDataSources((Writer)this.pageContext.getOut());
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadSystemSchema tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public static List getFrameworkDataSources() {
        ArrayList<String> dsList = new ArrayList<String>();
        List paths = config.getCommaSeparatedList("framework.datasources");
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            String dsDirPath = ISCFile.canonicalizePath((String)j.next());
            File dsDir = new File(dsDirPath);
            String[] files = dsDir.list();
            int i = 0;
            while (i < files.length) {
                String filename = files[i];
                if (!(filename.equals("Object.ds.xml") || filename.equals("FileAssembly.ds.xml") || filename.equals("FileAssemblyEntry.ds.xml") || filename.equals("Filesystem.ds.xml") || !filename.endsWith(".ds.xml"))) {
                    String dsName = filename.substring(0, filename.lastIndexOf(".ds.xml"));
                    dsList.add(dsName);
                }
                ++i;
            }
        }
        return dsList;
    }

    public static void loadFrameworkDataSources(Writer out) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        HashMap loadedSoFar = new HashMap();
        List dsList = LoadSystemSchemaTag.getFrameworkDataSources();
        Iterator i = dsList.iterator();
        while (i.hasNext()) {
            String dsName = (String)i.next();
            LoadSystemSchemaTag.outputDSForName(dsName, out, loadedSoFar);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void outputDSForName(String dataSourceId, Writer out, Map loadedSoFar) throws Exception {
        block7: {
            JSTranslater jsTrans = JSTranslater.instance();
            BasicDataSource ds = null;
            if (loadedSoFar.get(dataSourceId) != null) {
                return;
            }
            try {
                ds = (BasicDataSource)DataSourceManager.getDataSource(dataSourceId);
                if (ds == null) {
                    throw new Exception("No datasource for name: " + dataSourceId);
                }
                String superDSName = ds.getSuperDSName();
                if (superDSName != null && !"Object".equals(superDSName)) {
                    LoadSystemSchemaTag.outputDSForName(superDSName, out, loadedSoFar);
                }
                jsTrans.toJS(ds, out);
                loadedSoFar.put(dataSourceId, dataSourceId);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ds != null) {
                    DataSourceManager.freeDataSource(ds);
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (ds == null) break block7;
            }
            DataSourceManager.freeDataSource(ds);
        }
        out.write(";\r");
    }
}

