/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ProcessedFileCache {
    private static Logger log;
    private long stalenessCheckInterval;
    Map cache;
    static /* synthetic */ Class class$com$isomorphic$store$ProcessedFileCache;

    public void setStalenessCheckInterval(long millis) {
        this.stalenessCheckInterval = millis;
    }

    public long getStalenessCheckInterval() {
        return this.stalenessCheckInterval;
    }

    public void clearCacheEntry(Object key) {
        this.cache.remove(key);
    }

    public Object getObjectFromFile(ISCFile file) throws Exception {
        String name = file.getCanonicalPath();
        CacheEntry entry = (CacheEntry)this.cache.get(name);
        long timeStamp = file.lastModified();
        if (entry != null) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - entry.lastStalenessCheck <= this.stalenessCheckInterval) {
                return entry.cachedObject;
            }
            if (timeStamp == 0L) {
                log.warning("Can't perform staleness checking for " + name);
            }
            if (entry.timeStamp == timeStamp) {
                entry.lastStalenessCheck = currentTime;
                return entry.cachedObject;
            }
            if (log.isDebugEnabled()) {
                log.debug("STALE object for file '" + name + "', reloading (file timestamp " + timeStamp + ", cache timestamp " + entry.timeStamp + ')');
            }
        }
        Object loadedObject = this.loadObjectFromFile(file);
        this.cacheObject(name, loadedObject, timeStamp);
        return loadedObject;
    }

    public Object getObjectFromFile(String fileName) throws Exception {
        return this.getObjectFromFile(new ISCFile(fileName));
    }

    public abstract Object loadObjectFromFile(ISCFile var1) throws Exception;

    public void cacheObject(String name, Object object, long timeStamp) {
        CacheEntry entry = new CacheEntry();
        entry.timeStamp = timeStamp;
        entry.cachedObject = object;
        entry.lastStalenessCheck = System.currentTimeMillis();
        this.cache.put(name, entry);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.stalenessCheckInterval = 500L;
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public ProcessedFileCache() {
        this.this();
    }

    static {
        Class clazz = class$com$isomorphic$store$ProcessedFileCache;
        if (clazz == null) {
            clazz = class$com$isomorphic$store$ProcessedFileCache = ProcessedFileCache.class("[Lcom.isomorphic.store.ProcessedFileCache;", false);
        }
        log = new Logger(clazz.getName());
    }

    static class CacheEntry {
        public Object cachedObject;
        public long timeStamp;
        public long lastStalenessCheck;

        CacheEntry() {
        }
    }
}

