/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.base.Base;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.ProcessedFileCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataStructCache
extends Base {
    private static Logger log;
    private static JSTranslater jsTrans;
    public static StructCache cache;
    public static int getInstanceFileCalls;
    public static int getInstanceFileTime;
    static /* synthetic */ Class class$com$isomorphic$store$DataStructCache;

    public static Map getDataMap(String filename) throws Exception {
        return cache.getDataMap(filename);
    }

    public static List getSingleList(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        return DataStructCache.singleList(myMap, filename);
    }

    public static List singleList(Map myMap, String name) throws Exception {
        if (myMap.size() > 1) {
            log.warn("getSingleList: Found multiple js variables in file " + name + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + name);
        }
        return (List)myMap.get(myMap.keySet().iterator().next());
    }

    public static Object getJSVariableFromFile(String filename, String variableName) throws Exception {
        return DataStructCache.getDataMap(filename).get(variableName);
    }

    public static Map getSingleDataMap(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        if (myMap.size() > 1) {
            log.warn("getSingleDataMap: Found multiple js variables in file " + filename + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + filename);
        }
        return (Map)myMap.get(myMap.keySet().iterator().next());
    }

    public static void addCachedObjectWithNoConfigFile(String typeName, Object config) {
        cache.setDataMapForTypeName(typeName, config);
    }

    public static void removeCachedObjectWithNoConfigFile(String typeName) {
        cache.removeDataMapForTypeName(typeName);
    }

    public static Object getCachedObjectWithNoConfigFile(String typeName) {
        return cache.getDataMapForTypeName(typeName);
    }

    public static Object getInstance(String ID, String typeName, String suffix) throws Exception {
        String filename = DataStructCache.getInstanceFile(ID, typeName, suffix);
        if (filename == null) {
            return null;
        }
        return DataStructCache.loadInstance(filename, ID, suffix);
    }

    public static Object loadInstance(String filename, String ID, String suffix) throws Exception {
        if (filename.endsWith(".js")) {
            return DataStructCache.getJSVariableFromFile(filename, ID + suffix);
        }
        return XML.loadCacheableDSRecords(new ISCFile(filename));
    }

    public static String getInstanceFile(String ID, String typeName, String suffix) throws Exception {
        long start = System.currentTimeMillis();
        String result = DataStructCache._getInstanceFile(ID, typeName, suffix);
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("getInstanceFile (" + (result != null ? "success" : "failure") + "): '" + ID + "' instance of " + typeName + ": " + (end - start) + "ms");
        }
        ++getInstanceFileCalls;
        getInstanceFileTime = (int)((long)getInstanceFileTime + (end - start));
        return result;
    }

    public static String _getInstanceFile(String ID, String typeName, String suffix) throws Exception {
        String filePath;
        suffix = suffix.toLowerCase();
        String filename = ID + '.' + suffix;
        String instanceDir = config.getPath(typeName + '.' + ID + ".location");
        if (instanceDir != null) {
            filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
            if (filePath != null) {
                return filePath;
            }
            if (instanceDir != null) {
                log.warning("File " + filename + " not found at explicitly specified location " + instanceDir + ", checking project-wide area");
            }
        }
        List paths = config.getCommaSeparatedList("project." + typeName);
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            instanceDir = ISCFile.canonicalizePath((String)i.next());
            filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
            if (filePath == null) continue;
            return filePath;
        }
        paths = config.getCommaSeparatedList("framework." + typeName);
        i = paths.iterator();
        while (i.hasNext()) {
            instanceDir = ISCFile.canonicalizePath((String)i.next());
            filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
            if (filePath == null) continue;
            return filePath;
        }
        return null;
    }

    public static String getInstanceDir(String ID, String typeName, String fileSuffix) throws Exception {
        String instanceFilename = DataStructCache.getInstanceFile(ID, typeName, fileSuffix);
        if (instanceFilename == null) {
            return null;
        }
        return new File(instanceFilename).getParent();
    }

    public static String XMLOrJSFile(String baseName) throws IOException {
        boolean allowJS = config.getBoolean((Object)"allowJSDataSource", false);
        if (baseName == null) {
            return null;
        }
        String xmlName = baseName + ".xml";
        String jsName = baseName + ".js";
        ISCFile iscFile = new ISCFile(xmlName);
        if (iscFile.exists()) {
            return iscFile.getCanonicalPath();
        }
        if (allowJS && (iscFile = new ISCFile(jsName)).exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    static /* synthetic */ JSTranslater access$0() {
        return jsTrans;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$store$DataStructCache;
        if (clazz == null) {
            clazz = class$com$isomorphic$store$DataStructCache = DataStructCache.class("[Lcom.isomorphic.store.DataStructCache;", false);
        }
        log = new Logger(clazz.getName());
        jsTrans = JSTranslater.instance();
        cache = new StructCache();
        getInstanceFileCalls = 0;
        getInstanceFileTime = 0;
    }

    public static class StructCache
    extends ProcessedFileCache {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            block6: {
                start = System.currentTimeMillis();
                inStream = null;
                result = null;
                try {
                    inStream = file.getInputStream();
                    result = (Map)DataStructCache.access$0().fromJSMap(inStream);
                }
                catch (Throwable var6_5) {
                    var7_6 = null;
                    try {
                        inStream.close();
                        throw var6_5;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    throw var6_5;
                }
                {
                    var7_7 = null;
                }
                ** try [egrp 1[TRYBLOCK] [1 : 42->50)] { 
lbl19:
                // 1 sources

                inStream.close();
                break block6;
lbl21:
                // 1 sources

                catch (Exception ignored) {
                    // empty catch block
                }
            }
            end = System.currentTimeMillis();
            Logger.timing.debug("Parsed JS file '" + file.getCanonicalPath() + "': " + (end - start) + "ms");
            return result;
        }

        public Map getDataMap(String filename) throws Exception {
            return (Map)this.getObjectFromFile(DataTools.makePathAbsolute(filename));
        }

        public Object getDataMapForTypeName(String typeName) {
            return this.cache.get(typeName);
        }

        public synchronized void setDataMapForTypeName(String typeName, Object dataMap) {
            this.cache.put(typeName, dataMap);
        }

        public synchronized void removeDataMapForTypeName(String typeName) {
            this.cache.remove(typeName);
        }
    }
}

