/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VirtualXML
extends BaseServlet {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            try {
                RequestContext context = RequestContext.instance((Servlet)this, request, response);
                String pathInfo = context.pathInfo;
                if (pathInfo.startsWith("/")) {
                    pathInfo = pathInfo.substring(1);
                }
                int slashIndex = pathInfo.indexOf("/");
                String type = pathInfo.substring(0, slashIndex);
                String name = pathInfo.substring(slashIndex + 1);
                name = name.substring(0, name.lastIndexOf("."));
                if (type.equals("xmlFile")) {
                    if (!config.getBoolean((Object)"caching.taglib.virtualizeXML.allowFileAccess", false)) {
                        throw new Exception("DENIED xml file fetch: " + pathInfo);
                    }
                    List pathExcludes = config.getCommaSeparatedList("caching.taglib.virtualizeXML.fileAccessPathExcludes");
                    Iterator i = pathExcludes.iterator();
                    while (i.hasNext()) {
                        String pathExclude = (String)i.next();
                        if (pathInfo.indexOf(pathExclude) == -1) continue;
                        throw new Exception("xmlFile access to " + pathInfo + " DENIED by fileAccessPathExclude substring: " + pathExclude);
                    }
                }
                IAssembly fileAssembler = (IAssembly)InterfaceProvider.load("IAssembly");
                String fileName = fileAssembler.assembleVirtualComponent(type, name);
                ServletTools.sendStaticFile(context, fileName);
                context.completeResponse();
            }
            catch (Exception e) {
                this.handleError(response, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            requestTimer.stop();
            throw throwable;
        }
        {
            Object var5_15 = null;
            requestTimer.stop();
            return;
        }
    }

    public static String generateVirtualPath(String type, String name) {
        return type + '/' + name + ".js";
    }

    public static String generateScriptTag(String isomorphicURI, String type, String name) {
        return "</SCRIPT><SCRIPT SRC=" + isomorphicURI + "virtualXML/" + VirtualXML.generateVirtualPath(type, name) + "></SCRIPT><SCRIPT>";
    }
}

