/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.RegexRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.LRUMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class URIRegexFilter
extends BaseFilter {
    public boolean useURICache;
    public int uriCacheSize;
    protected Map uriCache;
    public String defaultAction;
    protected RegexRule defaultRule;
    public String rulesFile;
    public String webXmlRules;
    protected List rules;

    public void setUseURICache(String value) {
        this.useURICache = Boolean.valueOf(value);
    }

    public void setUriCacheSize(String value) {
        this.uriCacheSize = Integer.valueOf(value);
    }

    public void setDefaultAction(String value) {
        this.defaultAction = value;
        try {
            this.defaultRule = new RegexRule(value + ":/.*/", "defaultAction");
        }
        catch (Exception e) {
            this.log.error((Object)"Error initializing known good regex rule", e);
        }
    }

    public void setRulesFile(String value) {
        this.rulesFile = value;
    }

    public void setRules(String value) {
        this.webXmlRules = value;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            if (this.defaultRule == null) {
                if (this.webXmlRules == null && this.rulesFile == null) {
                    this.setDefaultAction("match");
                } else {
                    this.setDefaultAction("ignore");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error initializing known good regex rule", e);
        }
        if (this.webXmlRules != null) {
            Iterator i = DataTools.simpleSplit(this.webXmlRules, "\n").iterator();
            while (i.hasNext()) {
                String rule = (String)i.next();
                if ((rule = rule.trim()).length() <= 1) continue;
                try {
                    if (this.rules == null) {
                        this.rules = new ArrayList();
                    }
                    this.rules.add(new RegexRule(rule, "rules init-param in web.xml"));
                }
                catch (Exception e) {
                    this.log.warn(e.toString() + " - dropping this rule.");
                }
            }
        }
        if (this.rulesFile != null) {
            if (this.webXmlRules != null) {
                this.log.warn("Both the rules and rulesFile params are defined in web.xml. Rules defined in the rulesFile: " + this.rulesFile + " will be appended to those defined in the rules param in web.xml");
            }
            if (!this.rulesFile.startsWith("/")) {
                this.rulesFile = "/" + this.rulesFile;
            }
            List rulesFromFile = null;
            try {
                rulesFromFile = DataStructCache.getSingleList(webRoot + this.rulesFile);
            }
            catch (Exception e) {
                this.log.error("Failed to parse rules file: " + webRoot + this.rulesFile);
            }
            if (rulesFromFile != null) {
                Iterator i = rulesFromFile.iterator();
                while (i.hasNext()) {
                    String rule = (String)i.next();
                    try {
                        if (this.rules == null) {
                            this.rules = new ArrayList();
                        }
                        this.rules.add(new RegexRule(rule, "rulesFile: " + this.rulesFile));
                    }
                    catch (Exception e) {
                        this.log.warn(e.toString() + " - dropping this rule.");
                    }
                }
            }
        }
        if (this.rules == null) {
            this.useURICache = false;
        }
        if (this.useURICache) {
            this.uriCache = Collections.synchronizedMap(new LRUMap(this.uriCacheSize));
            this.log.info("URI Cache enabled - max size: " + this.uriCacheSize + " entries");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String comparePath = ServletTools.getCanonicalRequestURI(request);
        RegexRule matchedRule = null;
        if (this.rules != null) {
            if (this.useURICache) {
                matchedRule = (RegexRule)this.uriCache.get(comparePath);
            }
            if (matchedRule == null) {
                Iterator i = this.rules.iterator();
                while (i.hasNext()) {
                    RegexRule rule = (RegexRule)i.next();
                    boolean match = false;
                    try {
                        match = rule.match(comparePath);
                    }
                    catch (Exception e) {
                        this.log.warn("Syntax error in rule: " + rule.toString() + " - ignoring rule");
                    }
                    if (!match) continue;
                    matchedRule = rule;
                    break;
                }
                if (matchedRule == null) {
                    matchedRule = this.defaultRule;
                }
                if (this.useURICache) {
                    this.uriCache.put(comparePath, matchedRule);
                }
            }
        } else {
            matchedRule = this.defaultRule;
        }
        this.matchedRule(matchedRule, req, res, chain);
    }

    public void matchedRule(RegexRule rule, ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        String comparePath = ServletTools.getCanonicalRequestURI(request);
        if (rule.getAction().equals("block")) {
            this.log.info("Access to URI " + comparePath + " BLOCKED by rule:" + rule.toString());
            this.block(req, res, chain);
        } else if (rule.getAction().equals("ignore")) {
            this.ignore(req, res, chain);
        } else {
            this.match(req, res, chain);
        }
    }

    public void block(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        ((HttpServletResponse)res).sendError(404);
    }

    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        chain.doFilter(req, res);
    }

    public void ignore(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        chain.doFilter(req, res);
    }

    private final /* synthetic */ void this() {
        this.useURICache = true;
        this.uriCacheSize = 4096;
        this.defaultAction = "ignore";
        this.defaultRule = null;
    }

    public URIRegexFilter() {
        this.this();
    }
}

