/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.interfaces.IServletCompression;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.ServletTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RequestContext {
    public static Config config;
    public static Logger staticLog;
    protected static boolean ias6;
    public Logger log;
    public JSTranslater jsTrans;
    protected IServletCompression compression;
    public ServletContext servletContext;
    public ISCHttpServletRequest request;
    public HttpServletResponse response;
    public HttpSession session;
    protected Writer out;
    public boolean clientContextHeaderSent;
    public boolean cachingEnabled;
    public String contentType;
    public String requestPath;
    public String servletPath;
    public String pathInfo;
    static /* synthetic */ Class class$com$isomorphic$servlet$RequestContext;

    public static RequestContext instance(PageContext pageContext) throws Exception {
        return RequestContext.instance(pageContext.getServletContext(), pageContext.getRequest(), pageContext.getResponse());
    }

    public static RequestContext instance(ServletRequest request, ServletResponse response) throws Exception {
        return RequestContext.instance(null, (ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
    }

    public static RequestContext instance(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return RequestContext.instance(servlet.getServletConfig().getServletContext(), (ServletRequest)request, (ServletResponse)response);
    }

    public static RequestContext instance(Servlet servlet, HttpServletRequest request, HttpServletResponse response, Writer out) throws Exception {
        RequestContext context = RequestContext.instance(servlet.getServletConfig().getServletContext(), (ServletRequest)request, (ServletResponse)response);
        context.setOut(out);
        return context;
    }

    public static RequestContext instance(ServletContext servletContext, ServletRequest request, ServletResponse response) throws Exception {
        RequestContext context = new RequestContext();
        context.init(servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
        return context;
    }

    public void init(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (servletContext != null) {
            Init.go(servletContext);
            this.servletContext = servletContext;
        }
        if (config == null) {
            config = Config.getGlobal();
            if (staticLog == null) {
                Class clazz = class$com$isomorphic$servlet$RequestContext;
                if (clazz == null) {
                    clazz = class$com$isomorphic$servlet$RequestContext = RequestContext.class("[Lcom.isomorphic.servlet.RequestContext;", false);
                }
                staticLog = new Logger(clazz.getName());
            }
        }
        ias6 = config.getString("servlet.engine", "generic").equals("ias6");
        this.requestPath = RequestContext.getRequestPath(request);
        this.servletPath = request.getServletPath();
        this.pathInfo = request.getPathInfo();
        Class clazz = class$com$isomorphic$servlet$RequestContext;
        if (clazz == null) {
            clazz = class$com$isomorphic$servlet$RequestContext = RequestContext.class("[Lcom.isomorphic.servlet.RequestContext;", false);
        }
        this.log = new Logger(clazz.getName());
        this.request = new ISCHttpServletRequest(request);
        this.response = response;
        this.jsTrans = JSTranslater.instance();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Paths for request:\nServlet path: '" + request.getServletPath() + "'\nRequest URI: '" + request.getRequestURI() + "'\nPath Info: '" + request.getPathInfo() + "'\nPath Translated: '" + request.getPathTranslated() + (servletContext != null ? "'\nReal FileSystem Path: '" + servletContext.getRealPath(this.requestPath) : "") + '\'');
            if (config.getBoolean((Object)"requestContext.reportParams", false)) {
                this.log.debug("Request parameters: " + this.getParamsAsString());
            }
        }
        if (this.log.isInfoEnabled()) {
            boolean alreadyLoggedURL;
            String cgetHeader = request.getHeader("If-Modified-Since");
            boolean bl = false;
            if (cgetHeader != null && !"".equals(cgetHeader)) {
                bl = true;
            }
            boolean isCGET = bl;
            boolean bl2 = false;
            if (request.getAttribute("isc_alreadyLoggedURL") != null) {
                bl2 = alreadyLoggedURL = true;
            }
            if (!(isCGET && !this.log.isDebugEnabled() || alreadyLoggedURL)) {
                request.setAttribute("isc_alreadyLoggedURL", new Object());
                this.log.info((isCGET ? "CGET " : "") + "URL: '" + this.requestPath + "', User-Agent: '" + request.getHeader("User-Agent") + "': " + ServletTools.getBrowserSummary(this));
            }
        }
        if (config.getBoolean((Object)"servlet.logCookies", false)) {
            this.logCookies();
        }
        if (config.getBoolean((Object)"servlet.logHeaders", false)) {
            this.logHeaders();
        }
    }

    public void logCookies() {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.getCookiesAsString());
        }
    }

    public String getCookiesAsString() {
        String output = "Cookies:";
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            output = output + " NONE";
            return output;
        }
        int ii = 0;
        while (ii < cookies.length) {
            output = output + "\nName: '" + cookies[ii].getName() + "', value: '" + cookies[ii].getValue() + "', domain: '" + cookies[ii].getDomain() + "', path: '" + cookies[ii].getPath() + "', maxAge: '" + cookies[ii].getMaxAge() + "', isSecure: '" + cookies[ii].getSecure() + '\'';
            ++ii;
        }
        return output;
    }

    public void logHeaders() {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.getHeadersAsString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getHeadersAsString() {
        block1: {
            output = "Client HTTP Headers:";
            headers = this.request.getHeaderNames();
            if (headers != null) ** GOTO lbl8
            output = output + " request.getHeaderNames() returned null";
            break block1;
lbl-1000:
            // 1 sources

            {
                headerName = (String)headers.nextElement();
                output = output + '\n' + headerName + ": " + this.request.getHeader(headerName);
lbl8:
                // 2 sources

                ** while (headers.hasMoreElements())
            }
        }
        return output;
    }

    public String getParamsAsString() throws Exception {
        return this.jsTrans.toJS(this.request.getParams());
    }

    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI();
        if (ias6 && requestPath.indexOf("//") != -1) {
            Perl5Util regex = new Perl5Util();
            requestPath = regex.substitute("s#//#/#g", requestPath);
        }
        return requestPath;
    }

    public final void sendClientContextHeader() {
        if (this.clientContextHeaderSent) {
            return;
        }
        this.clientContextHeaderSent = true;
        this._sendClientContextHeader();
    }

    protected void _sendClientContextHeader() {
    }

    public void setNoCacheHeaders() throws Exception {
        if (this.response.isCommitted()) {
            throw new Exception("Response has already been committed, unable to setNoCacheHeaders()");
        }
        if (this.cachingEnabled) {
            RequestContext.setNoCacheHeaders(this.response);
            this.cachingEnabled = false;
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        if (staticLog != null) {
            staticLog.debug("Setting headers to disable caching");
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", System.currentTimeMillis());
    }

    public void setContentType(String contentType) throws IOException {
        if (this.contentType != null && !contentType.equals(this.contentType)) {
            this.log.warning("Content type has already been set to: " + this.contentType + " - setting to: " + contentType);
        }
        this.contentType = contentType;
        RequestContext.setContentType(contentType, this.response);
    }

    public static void setContentType(String contentType, HttpServletResponse response) {
        response.setContentType(contentType);
    }

    public boolean compressIfPossible() throws Exception {
        if (this.compression != null) {
            return true;
        }
        try {
            this.compression = (IServletCompression)InterfaceProvider.load("IServletCompression");
        }
        catch (Exception e) {
            if (ServletTools.compressionEnabled()) {
                this.log.error((Object)"Compresion enabled in config, but compression module not present - unable to compress", e);
            }
            return false;
        }
        return this.compression.compressIfPossible(this);
    }

    public Writer out() throws IOException {
        if (this.out == null) {
            this.log.debug("Getting output stream via servletResponse.getWriter()");
            if (this.contentType == null) {
                this.setContentType(config.getString("requestContext.defaultMimeType", "text/html"));
            }
            this.setOut(this.response.getWriter());
        }
        return this.out;
    }

    public void setOut(Writer out) throws IOException {
        if (this.out != null) {
            throw new IOException("The output stream has already been set");
        }
        this.out = out;
    }

    public void completeResponse() throws Exception {
        if (this.out == null) {
            this.log.debug("out is null, completeResponse() ignored");
            return;
        }
        try {
            this.out.flush();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (this.compression != null) {
            this.compression.completeResponse(this);
        }
        try {
            this.response.flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.out = null;
        this.clientContextHeaderSent = false;
        this.cachingEnabled = true;
        this.contentType = null;
    }

    public RequestContext() {
        this.this();
    }

    public RequestContext(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.this();
        this.init(servlet.getServletConfig().getServletContext(), request, response);
    }
}

