/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ProxyServletOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProxyHttpServletResponse
extends HttpServletResponseWrapper {
    private static Logger log;
    int status;
    ProxyServletOutputStream out;
    PrintWriter writer;
    public boolean dontCopyStreams;
    private HttpServletResponse response;
    Map headerValues;
    Map headerNames;
    String contentType;
    boolean returnedOut;
    Exception returnedOutException;
    Exception returnedWriterException;
    boolean returnedWriter;
    String creator;
    boolean unwrapOnContentEncoding;
    boolean unwrapOnContentDisposition;
    static /* synthetic */ Class class$com$isomorphic$servlet$ProxyHttpServletResponse;

    public ProxyHttpServletResponse unwrapOnContentEncoding(boolean val) {
        this.unwrapOnContentEncoding = true;
        return this;
    }

    public boolean unwrapOnContentEncoding() {
        return this.unwrapOnContentEncoding;
    }

    public ProxyHttpServletResponse unwrapOnContentDisposition(boolean val) {
        this.unwrapOnContentDisposition = true;
        return this;
    }

    public boolean unwrapOnContentDisposition() {
        return this.unwrapOnContentDisposition;
    }

    private final void init() {
        this.dontCopyStreams = false;
        this.headerValues = new HashMap();
        this.headerNames = new HashMap();
        this.contentType = null;
        this.status = 0;
    }

    public void resetBuffer() throws IllegalStateException {
        super.resetBuffer();
        if (this.returnedWriter) {
            this.writer.flush();
        }
        this.out.reset();
    }

    public void reset() throws IllegalStateException {
        super.reset();
        this.resetBuffer();
        this.init();
    }

    public void setStatus(int sc) {
        this.status = sc;
        super.setStatus(sc);
    }

    public int getStatus() {
        return this.status;
    }

    public void setOutputStream(ProxyServletOutputStream out) {
        this.out = out;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.returnedOut) {
            return this.out;
        }
        if (this.returnedWriter) {
            String debugInfo = "Error - getOutputStream() called on a request that has already returned a Writer";
            if (this.returnedWriterException != null) {
                log.error((Object)(debugInfo + " - stack trace for previous getWriter() call: "), this.returnedWriterException);
                log.error((Object)(debugInfo + " - stack trace for this getOutputStream() call: "), new Exception());
            } else {
                StringBuffer stringBuffer = new StringBuffer().append(debugInfo).append(" - enable debug logging on ");
                Class clazz = class$com$isomorphic$servlet$ProxyHttpServletResponse;
                if (clazz == null) {
                    clazz = class$com$isomorphic$servlet$ProxyHttpServletResponse = ProxyHttpServletResponse.class("[Lcom.isomorphic.servlet.ProxyHttpServletResponse;", false);
                }
                debugInfo = stringBuffer.append(clazz.getName()).append(" to see a stack trace of the previous caller.").toString();
            }
            throw new IOException(debugInfo);
        }
        if (log.isDebugEnabled()) {
            this.returnedOutException = new Exception();
        }
        this.returnedOut = true;
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.returnedWriter) {
            return this.writer;
        }
        if (this.returnedOut) {
            String debugInfo = "Error - getWriter() called on request that has already returned an OutputStream";
            if (this.returnedOutException != null) {
                log.error((Object)(debugInfo + " - stack trace for previous getOutputStream() call: "), this.returnedOutException);
                log.error((Object)(debugInfo + " - stack trace for this getWriter() call: "), new Exception());
            } else {
                StringBuffer stringBuffer = new StringBuffer().append(debugInfo).append(" - enable debug logging on ");
                Class clazz = class$com$isomorphic$servlet$ProxyHttpServletResponse;
                if (clazz == null) {
                    clazz = class$com$isomorphic$servlet$ProxyHttpServletResponse = ProxyHttpServletResponse.class("[Lcom.isomorphic.servlet.ProxyHttpServletResponse;", false);
                }
                debugInfo = stringBuffer.append(clazz.getName()).append(" to see a stack trace of the previous caller.").toString();
            }
            throw new IOException(debugInfo);
        }
        String charset = this.getCharacterEncoding();
        OutputStreamWriter osw = null;
        if (charset == null) {
            osw = new OutputStreamWriter((OutputStream)((Object)this.out));
            log.debug("Using default charset (" + this.creator + ')');
        } else {
            osw = new OutputStreamWriter((OutputStream)((Object)this.out), charset);
            log.debug("Using charset: " + charset + " (" + this.creator + ')');
        }
        this.writer = new PrintWriter(osw);
        if (log.isDebugEnabled()) {
            this.returnedWriterException = new Exception();
        }
        this.returnedWriter = true;
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.returnedWriter) {
            this.writer.flush();
        }
        this.out.flush();
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.rememberHeader(name, value);
    }

    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.headerValues.get(name.toLowerCase());
    }

    public String getHeaderNameCaseSensitive(String name) {
        return (String)this.headerNames.get(name);
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.rememberHeader(name, value);
    }

    public void rememberHeader(String name, String value) {
        if (name == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        String lcName = name.toLowerCase();
        this.headerNames.put(lcName, name);
        this.headerValues.put(lcName, value);
        if (lcName.equals("content-type")) {
            this.contentType = value;
        }
        String lcValue = value.toLowerCase();
        if (this.unwrapOnContentEncoding && name.equals("content-encoding")) {
            log.info("content-encoding set to: " + value + " - unwrapping response output stream (" + this.creator + ')');
            this.unwrapOutputStream();
        }
        if (this.unwrapOnContentDisposition && name.equals("content-disposition")) {
            log.info("content-disposition set to: " + value + " - unwrapping response output stream (" + this.creator + ')');
            this.unwrapOutputStream();
        }
    }

    public void unwrapOutputStream() {
        if (this.dontCopyStreams) {
            return;
        }
        OutputStream proxiedOutputStream = this.out.getOutputStream();
        if (!(proxiedOutputStream instanceof ByteArrayOutputStream)) {
            log.warn("Configured to unwrap output stream, but can't because the wrapped stream is of type: " + proxiedOutputStream.getClass().getName() + " instead of the expected type java.io.ByteArrayOutputStream - not unwrapping");
            return;
        }
        ByteArrayOutputStream osBuffer = (ByteArrayOutputStream)proxiedOutputStream;
        ServletOutputStream realOut = null;
        try {
            realOut = this.response.getOutputStream();
        }
        catch (Exception e) {
            log.warn("Attempt to unwrap response output stream failed: " + e.toString());
            return;
        }
        if (this.returnedWriter || this.returnedOut) {
            try {
                osBuffer.writeTo((OutputStream)realOut);
                realOut.flush();
            }
            catch (IOException ioe) {
                log.warn("Problem dumping output stream to real out - response may be corrupted.");
            }
        }
        this.out.setOutputStream((OutputStream)realOut);
        this.dontCopyStreams = true;
    }

    public String iscGetContentType() {
        return this.contentType;
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(location);
        log.debug("sendRedirect(" + location + ") - unwrapping (" + this.creator + ')');
        this.dontCopyStreams = true;
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        log.debug("sendError(" + sc + ": " + msg + ") - unwrapping (" + this.creator + ')');
        this.dontCopyStreams = true;
    }

    public void sendError(int sc) throws IOException {
        super.sendError(sc);
        log.debug("sendError(" + sc + ") - unwrapping (" + this.creator + ')');
        this.dontCopyStreams = true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.returnedOut = false;
        this.returnedWriter = false;
        this.unwrapOnContentEncoding = true;
        this.unwrapOnContentDisposition = true;
    }

    public ProxyHttpServletResponse(HttpServletResponse response, ProxyServletOutputStream out, String creator) {
        super(response);
        this.this();
        this.response = response;
        this.creator = creator;
        this.setOutputStream(out);
        this.init();
    }

    static {
        Class clazz = class$com$isomorphic$servlet$ProxyHttpServletResponse;
        if (clazz == null) {
            clazz = class$com$isomorphic$servlet$ProxyHttpServletResponse = ProxyHttpServletResponse.class("[Lcom.isomorphic.servlet.ProxyHttpServletResponse;", false);
        }
        log = new Logger(clazz.getName());
    }
}

