/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCFileItem;
import com.isomorphic.servlet.ISCFileItemFactory;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.SessionByteCounter;
import com.isomorphic.util.DataTools;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ISCHttpServletRequest
extends HttpServletRequestWrapper {
    private static Logger log;
    private static Config config;
    HttpServletRequest request;
    boolean requestParsed;
    Map stringParams;
    Map allParams;
    Map fileParams;
    Map queryParams;
    boolean requestIsMultipart;
    List fileItemParts;
    static /* synthetic */ Class class$com$isomorphic$servlet$ISCHttpServletRequest;

    public Map getQueryParams() {
        if (this.queryParams == null) {
            try {
                this.queryParams = ServletTools.parseQueryString(this.request.getQueryString());
            }
            catch (Exception e) {
                log.error((Object)"caught exception parsing queryParams", e);
                this.queryParams = new HashMap();
            }
        }
        return this.queryParams;
    }

    public String getQueryParameter(String paramName) {
        return (String)this.getQueryParams().get(paramName);
    }

    public Map getParams() throws Exception {
        if (this.allParams == null) {
            this.allParams = DataTools.mapUnion(this.getFileParams(), this.getStringParams());
        }
        return this.allParams;
    }

    public Map getStringParams() throws Exception {
        if (this.stringParams == null) {
            this.parseRequest();
            this.stringParams = ServletTools.paramsToMap((ServletRequest)this.request);
            Iterator i = this.fileItemParts.iterator();
            while (i.hasNext()) {
                FileItem item = (FileItem)i.next();
                if (!item.isFormField()) continue;
                String fieldName = item.getFieldName();
                String value = null;
                try {
                    value = item.getString("UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    log.warn("Can't parse field '" + fieldName + " using UTF-8 encoding, trying default");
                }
                value = item.getString();
                this.stringParams.put(fieldName, value);
            }
        }
        return this.stringParams;
    }

    public Map getFileParams() throws Exception {
        return this.getFileParams(null);
    }

    public Map getFileParams(List errors) throws Exception {
        if (this.fileParams == null) {
            this.parseRequest(errors);
            this.fileParams = new HashMap();
            Iterator i = this.fileItemParts.iterator();
            while (i.hasNext()) {
                FileItem item = (FileItem)i.next();
                if (item.isFormField()) continue;
                this.fileParams.put(item.getFieldName(), item);
            }
        }
        return this.fileParams;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public boolean isMultipart() {
        return this.requestIsMultipart;
    }

    public void parseRequest() throws Exception {
        this.parseRequest(null);
    }

    public void parseRequest(List errors) throws Exception {
        if (!this.isMultipart()) {
            return;
        }
        if (this.requestParsed) {
            return;
        }
        long contentLength = this.request.getContentLength();
        SessionByteCounter byteCounter = new SessionByteCounter(this.request, contentLength, this.request.getParameter("formID"), errors);
        FileUpload upload = new FileUpload((FileItemFactory)new ISCFileItemFactory(byteCounter));
        this.fileItemParts = upload.parseRequest(this.request);
        this.requestParsed = true;
    }

    public ISCFileItem getUploadedFile(String fieldName) throws Exception {
        return this.getUploadedFile(fieldName, null);
    }

    public ISCFileItem getUploadedFile(String fieldName, List errors) throws Exception {
        if (!this.isMultipart()) {
            return null;
        }
        return (ISCFileItem)this.getFileParams(errors).get(fieldName);
    }

    public String getParameter(String name) {
        Object param = null;
        try {
            param = this.getStringParams().get(name);
        }
        catch (Exception e) {
            log.error((Object)"getParameter()", e);
            return null;
        }
        if (param == null) {
            return this.request.getParameter(name);
        }
        if (param instanceof String) {
            return param;
        }
        log.warning("Parameter " + name + " is multivalued, but is being fetched as single-valued");
        return (String)((List)param).get(0);
    }

    public Enumeration getParameterNames() {
        try {
            return new Hashtable(this.getStringParams()).keys();
        }
        catch (Exception e) {
            log.error((Object)"getParameterNames()", e);
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Object params = this.getStringParams().get(name);
            if (params == null) {
                return null;
            }
            if (params instanceof List) {
                return DataTools.listToStringArray((List)params);
            }
            String[] result = new String[]{params.toString()};
            return result;
        }
        catch (Exception e) {
            log.error((Object)"getParameterValues()", e);
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.requestParsed = false;
        this.fileItemParts = new ArrayList();
    }

    public ISCHttpServletRequest(HttpServletRequest request) throws Exception {
        super(request);
        this.this();
        this.request = request;
        String contentType = request.getContentType();
        this.requestIsMultipart = FileUpload.isMultipartContent((HttpServletRequest)request);
    }

    static {
        Class clazz = class$com$isomorphic$servlet$ISCHttpServletRequest;
        if (clazz == null) {
            clazz = class$com$isomorphic$servlet$ISCHttpServletRequest = ISCHttpServletRequest.class("[Lcom.isomorphic.servlet.ISCHttpServletRequest;", false);
        }
        log = new Logger(clazz.getName());
        config = Config.getGlobal();
    }
}

