/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.interfaces.IServletCompression;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CompressionFilter
extends BaseFilter {
    private static Logger log;
    public int compressThreshold;
    public List compressableMimeTypes;
    private Config cacheControlOverrides;

    public void setCompressThreshold(String value) {
        this.compressThreshold = Integer.valueOf(value);
    }

    public void setCompressableMimeTypes(String value) {
        List list = DataTools.commaSeparatedStringToList(value);
        this.compressableMimeTypes = new ArrayList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mimeType = i.next().toString().toLowerCase();
            if (mimeType.equals("")) continue;
            this.compressableMimeTypes.add(mimeType);
        }
        if (this.compressableMimeTypes.size() == 0) {
            this.compressableMimeTypes = null;
        }
        log.warn("CompressableMimeTypes: " + (this.compressableMimeTypes != null ? this.compressableMimeTypes.toString() : "null"));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (log == null) {
            log = new Logger("com.isomorphic.compression.Compression");
        }
        this.cacheControlOverrides = config.getSubtree("compression.ie.svg.cacheControl");
        Iterator i = this.cacheControlOverrides.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.cacheControlOverrides.put(key.toLowerCase(), this.cacheControlOverrides.get(key));
        }
        if (!InterfaceProvider.exists("IServletCompression")) {
            throw new ServletException("Compression module not found - CompressionFilter unavailable.");
        }
        try {
            IServletCompression compression = (IServletCompression)InterfaceProvider.load("IServletCompression");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load compression module - compression unavailable.", e);
            throw new ServletException(e.toString());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        block44: {
            block43: {
                block42: {
                    block41: {
                        request = (HttpServletRequest)req;
                        response = (HttpServletResponse)res;
                        context = null;
                        try {
                            try {
                                context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
                                logPrefix = context.requestPath + ": ";
                                compress = true;
                                mimeType = ServletTools.mimeTypeForContext(context);
                                v0 = false;
                                if (mimeType == null || ServletTools.compressionEnabledForMimeType(mimeType, this.compressableMimeTypes) && ServletTools.compressionWorksForMimeType(context, mimeType)) {
                                    v0 = mimeTypeCompressable = true;
                                }
                                if (!ServletTools.compressionEnabled()) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Compression is disabled in config - not compressing");
                                }
                                if (compress && !ServletTools.compressionWorksForContext(context, CompressionFilter.log)) {
                                    compress = false;
                                }
                                if (compress && !ServletTools.browserClaimsGZSupport(request) && !ServletTools.alwaysCompressMimeType(mimeType)) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Browser is not compression-capable - not compressing");
                                }
                                if (compress && request.getAttribute("isc_dontCompress") != null) {
                                    compress = false;
                                    reason = request.getAttribute("isc_dontCompress");
                                    CompressionFilter.log.debug(logPrefix + "Compression disabled via isc_dontCompress flag" + (reason instanceof String != false ? reason.toString() : " - no reason provided") + '.');
                                }
                                if (compress && ServletTools.contextIsIncluded(context)) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Filter invoked as part of include/forward - not compressing");
                                }
                                ServletTools.markContextAsIncluded(context);
                                if (compress && !mimeTypeCompressable) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Mime type '" + mimeType + "' is not compressable - not compressing");
                                }
                                if (!compress) {
                                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                    var8_15 = null;
                                    break block41;
                                }
                                CompressionFilter.log.debug(logPrefix + "Request looks compressable.");
                                wrapBuf = new ByteArrayOutputStream();
                                wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), "CompressionFilter");
                                chain.doFilter((ServletRequest)request, (ServletResponse)wrapResponse);
                                if (wrapResponse.dontCopyStreams) {
                                    CompressionFilter.log.debug(logPrefix + "WrapResponse dictates no compression.");
                                    break block42;
                                }
                                try {
                                    wrapResponse.flushBuffer();
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                                wrapBuf.flush();
                                if (request.getAttribute("isc_dontCompress") != null) {
                                    compress = false;
                                    reason = request.getAttribute("isc_dontCompress");
                                    CompressionFilter.log.debug(logPrefix + "Compression disabled via isc_dontCompress flag" + (reason instanceof String != false ? reason.toString() : " - no reason provided") + '.');
                                }
                                if (compress && response.containsHeader("Content-Encoding")) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Content-Encoding was set by filtered content - not compressing");
                                }
                                if (compress && response.containsHeader("content-disposition")) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "content-disposition was set by filtered content - not compressing");
                                }
                                status = wrapResponse.getStatus();
                                if (compress && status != 200 && status != 0) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Received non-OK (200) http status: " + status + " - not compressing");
                                }
                                wrapMimeType = wrapResponse.iscGetContentType();
                                if (compress) {
                                    if (wrapMimeType != null) {
                                        CompressionFilter.log.debug(logPrefix + "Using upstream-specified mime type: " + wrapMimeType + " (container-derived mime type was: " + mimeType + ')');
                                        mimeType = wrapMimeType;
                                    } else {
                                        CompressionFilter.log.debug("Using container-derived mime type: " + mimeType);
                                    }
                                    context.contentType = mimeType;
                                }
                                if (compress && !ServletTools.compressionEnabledForMimeType(mimeType, this.compressableMimeTypes)) {
                                    compress = false;
                                    CompressionFilter.log.debug(logPrefix + "Mime type '" + mimeType + "' is not compressable - not compressing");
                                }
                                cacheControlHeaderValue = wrapResponse.getHeader("cache-control");
                                if (compress && cacheControlHeaderValue != null && ServletTools.browserIsMSIE(request) && mimeType != null && mimeType.indexOf("svg") != -1) {
                                    cacheControlHeaderValue = cacheControlHeaderValue.toLowerCase();
                                    cacheControlHeaderName = wrapResponse.getHeaderNameCaseSensitive("cache-control");
                                    cacheControlOverride = this.cacheControlOverrides.getString(cacheControlHeaderValue);
                                    if (cacheControlOverride != null) {
                                        CompressionFilter.log.debug(logPrefix + "Forcing " + cacheControlHeaderName + " to '" + cacheControlOverride + "' and proceeding with compression.");
                                        response.setHeader(cacheControlHeaderName, cacheControlOverride);
                                    } else if (cacheControlHeaderValue.equals("no-cache")) {
                                        CompressionFilter.log.warn(logPrefix + "Mime type '" + mimeType + "' is not compressable with Cache-Control: no-cache - not compressing.");
                                        compress = false;
                                    }
                                }
                                if (!compress) {
                                    out = response.getOutputStream();
                                    wrapBuf.writeTo((OutputStream)out);
                                    try {
                                        out.flush();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                    try {
                                        response.flushBuffer();
                                    }
                                    catch (Exception ignored) {
                                    }
                                    break block43;
                                }
                                compression = (IServletCompression)InterfaceProvider.load("IServletCompression");
                                compression.compressAndSend(context, wrapBuf, this.compressThreshold);
                                break block44;
                            }
                            catch (ServletException se) {
                                throw se;
                            }
                            catch (IOException ioe) {
                                throw ioe;
                            }
                            catch (Exception e) {
                                CompressionFilter.log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + '\n' + DataTools.getStackTrace(e));
                                break block44;
                            }
                        }
                        catch (Throwable var7_35) {
                            var8_18 = null;
                            try {
                                response.flushBuffer();
                                throw var7_35;
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                            throw var7_35;
                        }
                    }
                    ** try [egrp 5[TRYBLOCK] [19 : 1259->1269)] { 
lbl123:
                    // 1 sources

                    response.flushBuffer();
                    return;
lbl125:
                    // 1 sources

                    catch (Exception ignored) {
                        // empty catch block
                    }
                    return;
                }
                var8_16 = null;
                ** try [egrp 5[TRYBLOCK] [19 : 1259->1269)] { 
lbl131:
                // 1 sources

                response.flushBuffer();
                return;
lbl133:
                // 1 sources

                catch (Exception ignored) {
                    // empty catch block
                }
                return;
            }
            var8_17 = null;
            ** try [egrp 5[TRYBLOCK] [19 : 1259->1269)] { 
lbl139:
            // 1 sources

            response.flushBuffer();
            return;
lbl141:
            // 1 sources

            catch (Exception ignored) {
                // empty catch block
            }
            return;
        }
        var8_19 = null;
        try {}
        catch (Exception ignored) {
            return;
        }
        response.flushBuffer();
    }

    private final /* synthetic */ void this() {
        this.compressableMimeTypes = null;
    }

    public CompressionFilter() {
        this.this();
    }
}

