/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseServlet
extends HttpServlet {
    protected static Config config;
    protected static String webRoot;
    protected Logger log;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Init.go(servletConfig.getServletContext());
        config = Config.getGlobal();
        webRoot = config.getPath("webRoot");
        String servletName = servletConfig.getServletName();
        String className = ((Object)((Object)this)).getClass().getName();
        String logPrefix = null;
        if (!className.endsWith(servletName)) {
            logPrefix = servletName;
        }
        this.log = new Logger(className, logPrefix);
        ServletTools.applyConfigToServletOrFilter((Object)this, servletConfig);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            try {
                if (ServletTools.ignoreLog(request)) {
                    Logger.ignoreThread();
                }
                super.service(request, response);
            }
            catch (Throwable e) {
                Logger.observeThread();
                this.handleError(response, "BaseServlet Global Exception", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Logger.observeThread();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        Logger.observeThread();
    }

    public void handleError(HttpServletResponse response, Throwable t) {
        this.handleError(response, ((Object)((Object)this)).getClass().getName() + " top-level exception", t);
    }

    public void handleError(HttpServletResponse response, String errorMessage, Throwable t) {
        Logger.observeThread();
        this.log.error((Object)"Top-level servlet error: ", Reflection.getRealTargetException(t));
        ServletTools.handleServletError(response, errorMessage, t);
    }
}

