/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceBeanFilter;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.KeepPropertiesBeanFilter;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.velocity.HttpAttributeHandler;
import com.isomorphic.velocity.HttpParameterHandler;
import com.isomorphic.velocity.ISCReferenceInsertionEventHandler;
import com.isomorphic.velocity.ResponseDataHandler;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RPCManager {
    private static Config config = Config.getGlobal();
    private static int maxRequestDebugLength = config.getInt("RPCManager.maxRequestDebugLength", 1024);
    private static boolean globalOmitNullMapValuesInResponse = config.getBoolean((Object)"RPCManager.omitNullMapValuesInResponse", false);
    private static final String structuredRPCStart = "//isc_RPCResponseStart-->";
    private static final String structuredRPCEnd = "//isc_RPCResponseEnd";
    public static Logger log;
    public static VelocityEngine vEngine;
    private RequestContext context;
    private Map responseMap;
    private Long transactionNum;
    private String jsCallback;
    private Map transaction;
    private List requests;
    private boolean responseIsCustom;
    private boolean isDownload;
    private String charset;
    public boolean closeConnection;
    public boolean omitNullMapValuesInResponse;
    private Map templateContext;
    private boolean isExport;
    String customHTML;
    String serverVersion;
    boolean devenv;
    static /* synthetic */ Class class$com$isomorphic$rpc$RPCManager;

    public RPCManager omitNullMapValuesInResponse(boolean value) {
        this.omitNullMapValuesInResponse = value;
        return this;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public Object getFromTemplateContext(Object key) {
        return this.templateContext.get(key);
    }

    public void addToTemplateContext(Object key, Object value) {
        this.templateContext.put(key, value);
    }

    public static boolean isRPC(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        boolean bl = false;
        if (queryString.indexOf("isc_rpc=1") != -1 || queryString.indexOf("is_isc_rpc=true") != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isXmlHttp(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        boolean bl = false;
        if (queryString.indexOf("isc_xhr=1") != -1 || queryString.indexOf("xmlHttp=true") != -1) {
            bl = true;
        }
        return bl;
    }

    public static long getTransactionNum(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String transactionNum = (String)queryParams.get("isc_tnum");
            if (transactionNum == null) {
                transactionNum = (String)queryParams.get("iscTNum");
            }
            if (transactionNum == null) {
                return -1;
            }
            return Long.valueOf(transactionNum);
        }
        catch (Exception e) {
            log.warn((Object)"Error parsing transaction from query params", e);
            return -1;
        }
    }

    private static final String getClientVersion(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String version = (String)queryParams.get("isc_v");
            if (version == null) {
                version = (String)queryParams.get("isc_clientVersion");
            }
            return version;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine client version");
            return null;
        }
    }

    private final void writeDocumentDomain(Writer out) throws IOException {
        String documentDomain = RPCManager.getDocumentDomain((HttpServletRequest)this.context.request);
        if (documentDomain != null) {
            out.write("<SCRIPT>document.domain = '" + documentDomain + "';</SCRIPT>\n");
        }
    }

    private static final String getDocumentDomain(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String dd = (String)queryParams.get("isc_dd");
            if (dd == null) {
                dd = (String)queryParams.get("docDomain");
            }
            return dd;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine docDomain");
            return null;
        }
    }

    protected void initLog(HttpServletRequest request) {
        if ("off".equals(request.getParameter("isc_rpc_logging"))) {
            log.setInstanceLevel(Logger.OFF);
        }
    }

    public void setCustomHTML(String customHTML) {
        this.customHTML = customHTML;
    }

    public void doCustomResponse() {
        this.responseIsCustom = true;
    }

    public void setResponseCharset(String charset) {
        this.charset = charset;
    }

    public Object getData() {
        return this.getRequest().getData();
    }

    public RPCRequest getRequest() {
        int requestCount = this.requestCount();
        if (requestCount > 1) {
            log.warn((Object)("getRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        return (RPCRequest)this.requests.get(0);
    }

    public List getRequests() {
        return this.requests;
    }

    public int requestCount() {
        return this.requests.size();
    }

    public void send(Object data) throws Exception {
        this.send(new RPCResponse(data));
    }

    public void send(RPCResponse rpcResponse) throws Exception {
        RPCRequest rpcRequest = this.getRequest();
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("Single-argument send() method called twice.  This method may only be called once in response to a single RPCRequest.");
        }
        this.send(rpcRequest, rpcResponse);
    }

    public void send(RPCRequest rpcRequest, RPCResponse rpcResponse) throws Exception {
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("send(rpcRequest, rpcResponse) called twice for the same rpcRequest.  Only one RPCResponse can be sent to an RPCRequest.");
        }
        this.responseMap.put(rpcRequest, rpcResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(RPCRequest rpcRequest, Object data) throws Exception {
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setData(data);
        rpcResponse.setStatus(RPCResponse.STATUS_SUCCESS);
        this.send(rpcRequest, rpcResponse);
    }

    public void sendXMLString(RPCRequest rpcRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        this.send(rpcRequest, data);
    }

    public void send(DSRequest dsRequest, DSResponse dsResponse) throws Exception {
        if (!this.isDownload) {
            this.isDownload = dsRequest.isDownload();
        }
        if (!this.isExport) {
            this.isExport = dsRequest.isExport();
        }
        this.responseMap.put(dsRequest, dsResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(DSRequest dsRequest, Object data) throws Exception {
        DSResponse dsResponse = new DSResponse(dsRequest == null ? null : dsRequest.getDataSource());
        dsResponse.setData(data);
        dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        this.send(dsRequest, dsResponse);
    }

    public void sendXMLString(DSRequest dsRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        this.send(dsRequest, data);
    }

    public void sendSuccess(RPCRequest rpcRequest) throws Exception {
        RPCResponse rpcResponse = new RPCResponse("success");
        this.send(rpcRequest, rpcResponse);
    }

    public void sendFailure(Object request, String error) throws Exception {
        if (request instanceof DSRequest) {
            DSResponse dsResponse = new DSResponse(((DSRequest)request).getDataSource(), DSResponse.STATUS_FAILURE);
            dsResponse.setData(error);
            this.send((DSRequest)request, dsResponse);
        } else {
            RPCResponse rpcResponse = new RPCResponse(error);
            rpcResponse.setStatus(RPCResponse.STATUS_FAILURE);
            this.send((RPCRequest)request, rpcResponse);
        }
    }

    public void sendFailure(Object request, Throwable t) throws Exception {
        this.sendFailure(request, DataTools.getStackTrace(Reflection.getRealTargetException(t)));
    }

    public static Object filterDSResponseData(DSResponse dsResponse, DataSource ds) throws Exception {
        Map jsResponse = dsResponse.getJSResponse();
        Object data = jsResponse.get("data");
        if (ds == null) {
            return data;
        }
        if (data instanceof JSONFilter) {
            IBeanFilter beanFilter = ((JSONFilter)data).getBeanFilter();
            if (beanFilter instanceof KeepPropertiesBeanFilter) {
                Collection propsToKeep = ((KeepPropertiesBeanFilter)beanFilter).getPropsToKeep();
                Object obj = ((JSONFilter)data).getObj();
                DataSourceBeanFilter newFilter = new DataSourceBeanFilter(ds, propsToKeep);
                return new JSONFilter(obj, newFilter);
            }
        } else {
            boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
            if (dsResponse.dropExtraFields != null) {
                dropExtraFields = dsResponse.dropExtraFields;
                log.debug("DMI response, dropExtraFields: " + dropExtraFields);
            } else {
                if (ds.dropExtraFieldsDefined()) {
                    dropExtraFields = ds.dropExtraFields();
                }
                log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
            }
            return new JSONFilter(data, ds, dropExtraFields);
        }
        return data;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void completeResponse() throws Exception {
        Writer out;
        block38: {
            if (this.responseIsCustom) {
                return;
            }
            if (this.isDownload) {
                String mimeType = ServletTools.mimeTypeForContext(this.context);
                if (mimeType != null) {
                    this.context.setContentType(mimeType);
                }
                DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
                DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                Map data = (Map)dsResponse.getData();
                String fileName = dsRequest.getDownloadFileName();
                String fieldName = dsRequest.getDownloadFieldName();
                long contentLength = Long.valueOf(data.get(fieldName + "_filesize").toString());
                InputStream is = (InputStream)data.get(fieldName);
                String fileNameEncoding = this.encodeParameter("fileName", fileName);
                if (dsRequest.getOperationType().equals("downloadFile")) {
                    this.context.response.addHeader("content-disposition", "attachment; " + fileNameEncoding);
                } else {
                    this.context.response.addHeader("content-disposition", "inline; " + fileNameEncoding);
                }
                this.context.response.setContentLength((int)contentLength);
                ServletOutputStream os = this.context.response.getOutputStream();
                IOUtil.copyStreams(is, (OutputStream)os);
                os.flush();
                return;
            }
            if (this.isExport) {
                String lineBreakStyle;
                String exportAs;
                String mimeType = ServletTools.mimeTypeForContext(this.context);
                if (mimeType != null) {
                    this.context.setContentType(mimeType);
                }
                DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
                DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                dsResponse.setExportResults(true);
                if (dsResponse.getExportAs() == null || dsResponse.getExportAs() == "") {
                    dsResponse.setExportAs(dsRequest.getExportAs());
                }
                if (dsResponse.getExportFilename() == null || dsResponse.getExportFilename() == "") {
                    dsResponse.setExportFilename(dsRequest.getExportFilename());
                }
                if (dsResponse.getExportDisplay() == null || dsResponse.getExportDisplay() == "") {
                    dsResponse.setExportDisplay(dsRequest.getExportDisplay());
                }
                if (dsResponse.getLineBreakStyle() == null || dsResponse.getLineBreakStyle() == "") {
                    dsResponse.setLineBreakStyle(dsRequest.getLineBreakStyle());
                }
                if (dsResponse.getExportFields() == null || dsResponse.getExportFields().isEmpty()) {
                    dsResponse.setExportFields(dsRequest.getExportFields());
                }
                List<Object> data = new ArrayList<Object>();
                Object initData = dsResponse.getData();
                if (initData instanceof List) {
                    data = (List)initData;
                } else {
                    data.add(initData);
                }
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                DataSource ds = dsResponse.getDataSource();
                boolean usingDS = false;
                List fieldNames = dsResponse.getExportFields();
                ArrayList<String> finalFields = new ArrayList<String>();
                if (fieldNames == null || fieldNames.isEmpty()) {
                    fieldNames = ds.getFieldNames();
                    usingDS = true;
                }
                int i = 0;
                while (true) {
                    if (i >= fieldNames.size()) {
                        exportAs = dsResponse.getExportAs().toLowerCase();
                        lineBreakStyle = dsResponse.getLineBreakStyle().toLowerCase();
                    }
                    String fieldName = (String)fieldNames.get(i);
                    DSField field = ds.getField(fieldName);
                    if (!usingDS || usingDS && !field.getBoolean("hidden")) {
                        String fieldTitle = field.getProperty("exportTitle") != null ? field.getProperty("exportTitle") : field.getTitle();
                        fieldMap.put(fieldName, fieldTitle);
                        finalFields.add(fieldName);
                    }
                    ++i;
                }
                int formatId = exportAs.equals("json") ? 2 : (exportAs.equals("xml") ? 3 : 1);
                int n = 1;
                if (!lineBreakStyle.equals("mac")) {
                    n = lineBreakStyle.equals("unix") ? 2 : 4 - lineBreakStyle.equals("dos");
                }
                int lineBreakStyleId = n;
                DataExport de = new DataExport(formatId, lineBreakStyleId, finalFields);
                StringWriter iStream = new StringWriter();
                de.exportResultSet(data, fieldMap, (Writer)iStream);
                String fileNameEncoding = this.encodeParameter("fileName", dsResponse.getExportFilename());
                if (dsResponse.getExportDisplay().equals("download")) {
                    this.context.response.addHeader("content-disposition", "attachment; " + fileNameEncoding);
                    this.context.setContentType(formatId == 3 ? "text/xml" : (formatId == 2 ? "application/x-javascript" : "text/csv"));
                } else {
                    this.context.response.addHeader("content-disposition", "inline; " + fileNameEncoding);
                }
                String streamData = iStream.toString();
                int contentLength = streamData.length();
                this.context.response.setContentLength(contentLength);
                ServletOutputStream os = this.context.response.getOutputStream();
                os.print(streamData);
                os.flush();
                return;
            }
            boolean bl = false;
            if (this.context.response != null && RPCManager.isXmlHttp((HttpServletRequest)this.context.request)) {
                bl = true;
            }
            boolean isXMLHttp = bl;
            try {
                this.context.setNoCacheHeaders();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            try {
                String contentType;
                String string = contentType = isXMLHttp ? "text/plain" : "text/html";
                if (this.charset != null && !this.charset.trim().equals("")) {
                    contentType = contentType + "; charset=" + this.charset;
                }
                this.context.setContentType(contentType);
                log.debug("Content type for RPC transaction: " + contentType);
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            out = config.getBoolean((Object)"IDACall.showClientOutput", false) ? new StringWriter() : this.context.out();
            ArrayList<Map> orderedResponseList = new ArrayList<Map>();
            Iterator i = this.requests.iterator();
            while (true) {
                if (!i.hasNext()) {
                    if (!isXMLHttp) break;
                    out.write(structuredRPCStart);
                    JSTranslater jsTrans = JSTranslater.instance();
                    jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                    jsTrans = this.setEnumProperties(jsTrans);
                    jsTrans.toJS(orderedResponseList, out);
                    out.write(structuredRPCEnd);
                    break block38;
                }
                Object request = i.next();
                Object response = this.responseMap.get(request);
                if (response == null) {
                    throw new Exception("No response for request: " + request.toString());
                }
                if (response instanceof RPCResponse) {
                    HashMap<String, Object> payload = new HashMap<String, Object>();
                    payload.put("data", ((RPCResponse)response).getData());
                    payload.put("status", new Integer(((RPCResponse)response).getStatus()));
                    orderedResponseList.add(payload);
                    continue;
                }
                if (!(response instanceof DSResponse)) continue;
                DSResponse dsResponse = (DSResponse)response;
                if (dsResponse.wantsConnectionClosed()) {
                    this.closeConnection = true;
                }
                Map jsResponse = dsResponse.getJSResponse();
                DSRequest dsRequest = (DSRequest)request;
                String dsName = dsRequest.getDataSourceName();
                if (dsName != null) {
                    Object var13_38;
                    DataSource ds = DataSourceManager.get(dsName);
                    try {
                        Object data = RPCManager.filterDSResponseData(dsResponse, ds);
                        jsResponse.put("data", data);
                    }
                    catch (Throwable throwable) {
                        var13_38 = null;
                        DataSourceManager.free(ds);
                        throw throwable;
                    }
                    {
                        var13_38 = null;
                    }
                    DataSourceManager.free(ds);
                }
                orderedResponseList.add(jsResponse);
                dsRequest.freeDataSource();
            }
            this.iframeWrite(out, true, orderedResponseList);
        }
        out.flush();
        if (out instanceof StringWriter) {
            String output = out.toString();
            int outputSize = output.length();
            log.debug("Uncompressed result size: " + outputSize + " bytes");
            this.context.out().write(output);
            this.context.out().flush();
            if (config.getBoolean((Object)"devenv", false)) {
                log.debug((Object)"Output to client", output);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final JSTranslater setEnumProperties(JSTranslater jsTrans) throws Exception {
        String dsName;
        Object requestObj = null;
        int i = 0;
        while (true) {
            if (i >= this.requests.size() || requestObj instanceof DSRequest) {
                if (!(requestObj instanceof DSRequest)) return jsTrans;
                dsName = ((DSRequest)requestObj).getDataSourceName();
                if (dsName != null) break;
                return jsTrans;
            }
            requestObj = this.requests.get(i);
            ++i;
        }
        DataSource ds = DataSourceManager.getDataSource(dsName);
        if (ds == null) {
            return jsTrans;
        }
        try {
            jsTrans.setEnumTranslateStrategy(ds.getEnumTranslateStrategy());
            jsTrans.setEnumOrdinalProperty(ds.getEnumOrdinalProperty());
            jsTrans.setEnumConstantProperty(ds.getEnumConstantProperty());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DataSourceManager.freeDataSource(ds);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        DataSourceManager.freeDataSource(ds);
        return jsTrans;
    }

    private final String encodeParameter(String name, String value) {
        Pattern tspecials = Pattern.compile("[<()@,;:/?={} >\"\\[\\]\\t\\\\]");
        Matcher matcher = tspecials.matcher(value);
        if (value.length() <= 78) {
            if (!matcher.find()) {
                return name + '=' + value;
            }
            return name + "=\"" + value + '\"';
        }
        int counter = 0;
        String returnVal = "";
        while (value.length() > 78) {
            String work = value.substring(0, 78);
            matcher.reset(work);
            if (matcher.find()) {
                work = "\"" + work + '\"';
            }
            if (counter > 0) {
                returnVal = returnVal + "; ";
            }
            returnVal = returnVal + name + '*' + counter + '=' + work;
            ++counter;
            value = value.substring(78);
        }
        matcher.reset(value);
        if (matcher.find()) {
            value = "\"" + value + '\"';
        }
        if (counter > 0) {
            returnVal = returnVal + "; ";
        }
        returnVal = returnVal + name + '*' + counter + '=' + value;
        return returnVal;
    }

    private final void iframeWrite(Writer out, boolean structured, Object data) throws IOException, UnconvertableException {
        out.write("<HTML>\n");
        this.writeDocumentDomain(out);
        if (this.customHTML != null) {
            out.write(this.customHTML);
        }
        out.write("<BODY ONLOAD='var results = document.formResults.results.value;" + this.jsCallback + "'>");
        out.write("<BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR>");
        out.write("<FORM name='formResults'><TEXTAREA readonly name='results'>\n");
        if (structured) {
            out.write(structuredRPCStart);
        }
        JSTranslater jsTrans = new JSTranslater();
        jsTrans.quoteForTextArea();
        jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
        try {
            jsTrans = this.setEnumProperties(jsTrans);
        }
        catch (Exception e) {
            UnconvertableException uce = new UnconvertableException();
            uce.initCause(e);
            throw uce;
        }
        jsTrans.toJS(data, out);
        if (structured) {
            out.write(structuredRPCEnd);
        }
        out.write("</TEXTAREA>");
        out.write("</FORM>\n");
        out.write("</BODY></HTML>");
    }

    private final void parseRequest() throws Exception {
        Object operationData;
        if (!RPCManager.isRPC((HttpServletRequest)this.context.request)) {
            throw new Exception("Non-RPC request ignored.");
        }
        String clientVersion = RPCManager.getClientVersion((HttpServletRequest)this.context.request);
        if (!(this.devenv || clientVersion != null && this.serverVersion.equals(clientVersion))) {
            if (clientVersion == null) {
                clientVersion = "pre-5.5b2";
            }
            log.warn("client/server version mismatch.  Client is version: " + clientVersion + ", server is version: " + this.serverVersion + " - mixing different client/server versions is generally not supported.  If you've installed a more recent client version, try clearing the browser cache and reloading the page.");
        }
        Map queryParamsMap = new HashMap();
        try {
            queryParamsMap = ServletTools.parseQueryString(this.context.request.getQueryString());
        }
        catch (Exception e) {
            log.error((Object)"caught exception parsing queryParams", e);
        }
        String rawTransactionData = (String)queryParamsMap.get("_transaction");
        if (rawTransactionData == null) {
            rawTransactionData = this.context.request.getParameter("_transaction");
        }
        if (rawTransactionData == null || rawTransactionData.equals("")) {
            Writer out = this.context.out();
            ServletTools.sendHTMLStart(out);
            log.warn("Detected zero-length IDA transaction, asking client to retry.");
            log.warn("Outputting extra debug information:");
            log.warn(this.context.getCookiesAsString());
            log.warn(this.context.getHeadersAsString());
            try {
                log.warn(this.context.getParamsAsString());
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't log params", e);
            }
            this.writeDocumentDomain(out);
            out.write("<SCRIPT>");
            out.write("parent.isc.RPCManager.retryOperation(window.name);");
            out.write("</SCRIPT>");
            ServletTools.sendHTMLEnd(out);
            out.flush();
            this.context.response.flushBuffer();
            throw new ClientMustResubmitException("");
        }
        Object transactionData = null;
        transactionData = rawTransactionData.trim().startsWith("{") ? JSTranslater.instance().fromJS(rawTransactionData) : XML.toDSRecords(new StringReader(rawTransactionData));
        if (!(transactionData instanceof Map)) {
            throw new Exception("Invalid transaction format: " + (transactionData == null ? "null" : transactionData.getClass().getName()));
        }
        this.transaction = (Map)transactionData;
        this.jsCallback = (String)this.transaction.get("jscallback");
        Long transactionNum = (Long)this.transaction.get("transactionNum");
        Boolean nullValuesHandling = (Boolean)this.transaction.get("omitNullMapValuesInResponse");
        if (nullValuesHandling != null) {
            this.omitNullMapValuesInResponse(nullValuesHandling);
        }
        if (!((operationData = this.transaction.get("operations")) instanceof List)) {
            throw new Exception("Invalid 'operations' format" + operationData.getClass().getName());
        }
        List operations = (List)operationData;
        this.requests = new ArrayList();
        int requestNum = 0;
        log.debug("Processing " + operations.size() + " requests.");
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            Map m;
            ++requestNum;
            Object payload = i.next();
            if (payload instanceof Map && (m = (Map)payload).get("appID") != null && m.get("operation") != null) {
                Object criteria = m.remove("where");
                if (criteria != null) {
                    m.put("criteria", criteria);
                }
                DSRequest dsRequest = new DSRequest(m, this.context);
                dsRequest.rpc = this;
                if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                    String payloadString = DataTools.prettyPrint(m);
                    if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                        payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength to desired max bytes (in server.properties) - zero disables/negative value allows arbitrary length messages].";
                    }
                    log.debug("Request #" + requestNum + " (DSRequest) payload: " + payloadString);
                }
                this.requests.add(dsRequest);
                continue;
            }
            if (payload instanceof String) {
                if ("__ISC_NULL__".equals((String)payload)) {
                    payload = null;
                } else if ("__ISC_EMPTY_STRING__".equals((String)payload)) {
                    payload = "";
                }
            }
            if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                String payloadString = DataTools.prettyPrint(payload);
                if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                    payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength to desired max bytes (in server.properties) - zero disables/negative value allows arbitrary length messages].";
                }
                log.debug("Request #" + requestNum + " (RPCRequest) data: " + payloadString);
            }
            RPCRequest rpcRequest = new RPCRequest(payload, this.context);
            rpcRequest.rpc = this;
            this.requests.add(rpcRequest);
        }
    }

    public Long getTransactionNum() {
        return this.transactionNum;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        requestTimer = new RequestTimer(request);
        rpc = null;
        try {
            try {
                context = RequestContext.instance((ServletRequest)request, (ServletResponse)response);
                try {
                    rpc = new RPCManager(null, request, response);
                }
                catch (ClientMustResubmitException cmre) {
                    var5_8 = null;
                    requestTimer.stop();
                    try {
                        response.flushBuffer();
                        return;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return;
                }
                RPCManager.log.info("Performing " + rpc.requestCount() + " operation(s)");
                i = rpc.getRequests().iterator();
                while (i.hasNext()) {
                    r = i.next();
                    if (r instanceof RPCRequest) {
                        rpcRequest = (RPCRequest)r;
                        rpc.send(rpcRequest, rpcRequest.execute());
                        continue;
                    }
                    dsRequest = (DSRequest)r;
                    try {
                        rpc.send(dsRequest, dsRequest.execute());
                    }
                    catch (Exception e) {
                        Logger.observeThread();
                        try {
                            RPCManager.log.error((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        rpc.sendFailure((Object)dsRequest, e);
                    }
                }
            }
            catch (Throwable e) {
                Logger.observeThread();
                RPCManager.log.error((Object)"Error processing RPC Request: ", Reflection.getRealTargetException(e));
                ServletTools.handleServletError(response, " top-level exception", e);
            }
        }
        catch (Throwable var4_18) {
            var5_9 = null;
            requestTimer.stop();
            ** try [egrp 5[TRYBLOCK] [7 : 248->257)] { 
lbl51:
            // 1 sources

            response.flushBuffer();
            throw var4_18;
lbl53:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            throw var4_18;
        }
        {
            var5_10 = null;
            requestTimer.stop();
        }
        try {}
        catch (IOException ignored) {
            return;
        }
        response.flushBuffer();
    }

    public void applyEarlierResponseValues(DSRequest dsReq) throws Exception {
        Object evaluation;
        String value;
        String fieldName;
        Map map;
        Iterator<Object> i;
        String opId;
        DataSource ds;
        Date currentDate = new Date();
        this.addToTemplateContext("currentDate", currentDate);
        if (this.getFromTemplateContext("transactionDate") == null) {
            this.addToTemplateContext("transactionDate", currentDate);
        }
        if ((ds = dsReq.getDataSource()) == null) {
            return;
        }
        String opType = dsReq.getOperationType();
        Map opBinding = ds.getOperationBinding(opType, opId = dsReq.getOperationId());
        if (opBinding == null) {
            return;
        }
        Object criteriaObj = opBinding.get("criteria");
        Object valuesObj = opBinding.get("values");
        if (criteriaObj == null && valuesObj == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(this.getTemplateContext());
        params.put("dsRequest", dsReq);
        params.put("responseData", new ResponseDataHandler(this, dsReq));
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        if (dsReq.context != null) {
            escRequest = new ServletRequestAttributeMapFacade((HttpServletRequest)dsReq.context.request);
            if (dsReq.context.request != null) {
                escSession = new SessionAttributeMapFacade(dsReq.context.request.getSession());
            }
        }
        params.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        params.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        params.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (dsReq.getTemplateContext() != null) {
            i = dsReq.getTemplateContext().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (params.get(key) != null) {
                    log.warning("DSRequest-specified a template context variable: " + key + " collides with derived key of the same name - using the DSRequest-specified value.");
                }
                params.put(key, dsReq.getTemplateContext().get(key));
            }
        }
        if (criteriaObj != null) {
            ArrayList criteria;
            if (criteriaObj instanceof List) {
                criteria = (ArrayList)criteriaObj;
            } else {
                criteria = new ArrayList();
                criteria.add(criteriaObj);
            }
            i = criteria.iterator();
            while (i.hasNext()) {
                map = (Map)i.next();
                fieldName = (String)map.get("fieldName");
                value = (String)map.get("value");
                if (fieldName == null || value == null) continue;
                evaluation = RPCManager.velocityEvaluate(value, params);
                Object baseObject = dsReq.getCriteria().put(fieldName, evaluation);
            }
        }
        if (valuesObj != null) {
            ArrayList values;
            if (valuesObj instanceof List) {
                values = (ArrayList)valuesObj;
            } else {
                values = new ArrayList();
                values.add(valuesObj);
            }
            i = values.iterator();
            while (i.hasNext()) {
                map = (Map)i.next();
                fieldName = (String)map.get("fieldName");
                value = (String)map.get("value");
                if (fieldName == null || value == null) continue;
                evaluation = RPCManager.velocityEvaluate(value, params);
                dsReq.getValues().put(fieldName, evaluation);
            }
        }
    }

    public Object findResponseData(String firstOrLast, String dsName, String opType, DSRequest thisDSReq) {
        DSRequest dsReq;
        int stop;
        int inc;
        int loop;
        if (firstOrLast.equals("first")) {
            loop = 0;
            inc = 1;
            stop = this.requests.size();
        } else {
            loop = this.requests.size() - 1;
            inc = -1;
            stop = -1;
            while (loop != stop) {
                dsReq = (DSRequest)this.requests.get(loop);
                if (dsReq == thisDSReq) {
                    --loop;
                    break;
                }
                --loop;
            }
        }
        while (loop != stop) {
            dsReq = (DSRequest)this.requests.get(loop);
            if ((dsName == null || dsName.equals(dsReq.getDataSourceName())) && (opType == null || opType.equals(dsReq.getOperationType()))) {
                DSResponse dsResp = (DSResponse)this.responseMap.get(dsReq);
                if (dsResp == null) {
                    log.error("Found null DSResponse mapped to valid-looking DSRequest when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Have requests been run out of order?");
                    return null;
                }
                Object data = dsResp.getData();
                if (data == null) {
                    log.error("Found null dsResponse.data when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Looks like the operation does not return anything.");
                    return null;
                }
                if (data instanceof List) {
                    data = ((List)data).get(0);
                }
                return data;
            }
            loop += inc;
        }
        log.error("Could not find a suitable dsRequest searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType);
        return null;
    }

    public static VelocityEngine getVelocityEngine() throws Exception {
        if (vEngine != null) {
            return vEngine;
        }
        vEngine = new VelocityEngine();
        Properties properties = new Properties();
        properties.put("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        properties.put("runtime.log.logsystem.log4j.category", "org.apache.Velocity");
        vEngine.init(properties);
        return vEngine;
    }

    public static synchronized Object velocityEvaluate(String template, Map parameters) throws Exception {
        StringWriter out = new StringWriter();
        VelocityContext context = new VelocityContext(parameters);
        ISCReferenceInsertionEventHandler handler = new ISCReferenceInsertionEventHandler((Context)context);
        if (!RPCManager.getVelocityEngine().evaluate((Context)context, (Writer)out, "ResponseData", template)) {
            return null;
        }
        if (handler.foundObject != null && handler.foundObject.toString().equals(out.toString())) {
            return handler.foundObject;
        }
        return out.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.responseMap = new HashMap();
        this.responseIsCustom = false;
        this.isDownload = false;
        this.charset = config.getString("RPCManager.defaultCharset", "UTF-8");
        this.closeConnection = false;
        this.omitNullMapValuesInResponse = globalOmitNullMapValuesInResponse;
        this.templateContext = new HashMap();
        this.isExport = false;
        this.customHTML = config.getString("RPCManager.customHTML", null);
        this.serverVersion = config.getString("iscVersionNumber");
        this.devenv = config.getBoolean((Object)"devenv", false);
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.this();
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(servlet, request, response);
        this.initLog(request);
        this.parseRequest();
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.this();
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance((ServletRequest)request, (ServletResponse)response);
        this.initLog(request);
        this.parseRequest();
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response, Writer out) throws Exception {
        this(request, response);
        this.context.setOut(out);
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    static {
        Class clazz = class$com$isomorphic$rpc$RPCManager;
        if (clazz == null) {
            clazz = class$com$isomorphic$rpc$RPCManager = RPCManager.class("[Lcom.isomorphic.rpc.RPCManager;", false);
        }
        log = new Logger(clazz.getName());
    }
}

