/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RPCDMI {
    private static Logger log;
    private static Config config;
    RPCRequest rpcRequest;
    RPCManager rpc;
    RequestContext context;
    static /* synthetic */ Class class$com$isomorphic$rpc$RPCDMI;
    static /* synthetic */ Class class$com$isomorphic$rpc$RPCManager;
    static /* synthetic */ Class class$com$isomorphic$rpc$RPCRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;
    static /* synthetic */ Class class$com$isomorphic$servlet$RequestContext;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$com$isomorphic$rpc$RPCResponse;

    public static RPCResponse execute(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) throws Exception {
        return RPCDMI.execute(rpcRequest, rpc, context, false);
    }

    public static RPCResponse execute(RPCRequest rpcRequest, RPCManager rpc, RequestContext context, boolean allowAnyRPC) throws Exception {
        return new RPCDMI(rpcRequest, rpc, context).execute(allowAnyRPC);
    }

    public static boolean isDMIRequest(RPCRequest rpcRequest) {
        Map data = (Map)rpcRequest.getData();
        return data != null && data.get("is_ISC_RPC_DMI") != null;
    }

    private final RPCResponse execute() throws Exception {
        return this.execute(false);
    }

    private final RPCResponse execute(boolean allowAnyRPC) throws Exception {
        Class clazz;
        List enabledBuiltinMethods;
        Map data = (Map)this.rpcRequest.getData();
        if (data == null) {
            throw new Exception("Attempt to execute RPCDMI with null data");
        }
        String appID = this.rpcRequest.getAppID();
        String className = this.rpcRequest.getServerObjectID();
        String methodName = this.rpcRequest.getMethodName();
        List arguments = this.rpcRequest.getMethodArguments();
        Map appConfig = RPCDMI.loadAppConfig(appID);
        List rpcBindings = (List)appConfig.get("rpcBindings");
        if (rpcBindings == null) {
            throw new Exception(appID + ".app.xml does not define any rpcBindings - please add an rpcBindings section to the file");
        }
        Map serverObjectConfig = null;
        Iterator i = rpcBindings.iterator();
        while (i.hasNext()) {
            Map rpcBinding = (Map)i.next();
            String soID = (String)rpcBinding.get("ID");
            String soClassName = (String)rpcBinding.get("className");
            if ((soID == null || !soID.equals(className)) && (soClassName == null || !soClassName.equals(className))) continue;
            serverObjectConfig = rpcBinding;
            break;
        }
        if (serverObjectConfig == null) {
            throw new Exception(appID + ".app.xml: the rpcBindings section does not contain a serverObjectConfig with ID|className=\"" + className + "\".");
        }
        List visibleMethods = (List)serverObjectConfig.get("visibleMethods");
        if (visibleMethods == null) {
            throw new Exception(appID + ".app.xml: serverObjectConfig definition with ID|className=\"" + className + " does not have a visibleMethods block defined - if you intend for this method (" + methodName + ") to be visible, please add it to a visibleMethods block");
        }
        if ("isc_builtin".equals(appID) && !allowAnyRPC && !(enabledBuiltinMethods = config.getList("RPCManager.enabledBuiltinMethods")).contains(methodName) && !enabledBuiltinMethods.contains("*")) {
            throw new Exception("Attempt to execute RPC DMI Builtin '" + methodName + "' DENIED by server.properties configuration.  To enable this method, add it to the list of methods under RPCManager.enabledBuiltinMethods in server.properties");
        }
        if (methodName == null) {
            throw new Exception("Method name was not specified in RPC DMI call to \"" + className + "\" in " + appID + ".app.xml");
        }
        boolean methodIsVisible = false;
        String scriptArgs = null;
        String scriptLanguage = null;
        String script = null;
        Iterator i2 = visibleMethods.iterator();
        while (i2.hasNext()) {
            Map method = (Map)i2.next();
            String name = (String)method.get("name");
            if (!methodName.equals(name) && !name.equals("*")) continue;
            methodIsVisible = true;
            scriptArgs = (String)method.get("args");
            scriptLanguage = (String)method.get("language");
            script = (String)method.get("script");
            break;
        }
        if (!methodIsVisible) {
            throw new Exception("Method: " + methodName + " called on serverObjectConfig ID|className=\"" + className + "\" cannot be executed because it is not listed in the visibleMethods block.");
        }
        Object returnValue = null;
        Class<?> returnValueClass = null;
        if (script != null) {
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put("rpcRequest", this.rpcRequest);
            if (this.context != null) {
                bindings.put("context", this.context);
                bindings.put("request", (Object)this.context.request);
                bindings.put("response", this.context.response);
                bindings.put("servletContext", this.context.servletContext);
                try {
                    ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                    if (beanFactory != null) {
                        bindings.put("beanFactory", beanFactory.getBeanFactory(this.context.servletContext));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (this.rpc != null) {
                bindings.put("rpc", this.rpc);
                bindings.put("rpcManager", this.rpc);
            }
            bindings.put("log", log);
            if (arguments != null && scriptArgs != null) {
                List argNames = DataTools.simpleSplit(scriptArgs, ",");
                Iterator i3 = arguments.iterator();
                Iterator j = argNames.iterator();
                while (i3.hasNext() && j.hasNext()) {
                    Object arg = i3.next();
                    String argName = ((String)j.next()).trim();
                    bindings.put(argName, arg);
                }
            }
            DataTypeMap params = new DataTypeMap();
            params.put("engineName", scriptLanguage);
            params.put("script", script);
            params.put("bindings", bindings);
            RPCResponse rpcResponse = BuiltinRPC.evalServerScript(params);
            Map result = (Map)rpcResponse.getData();
            returnValue = result.get("evalResult");
            returnValueClass = returnValue.getClass();
        } else {
            ReflectionArgument[] reflectionArgumentArray = new ReflectionArgument[2];
            Class clazz2 = class$com$isomorphic$rpc$RPCManager;
            if (clazz2 == null) {
                clazz2 = class$com$isomorphic$rpc$RPCManager = RPCDMI.class("[Lcom.isomorphic.rpc.RPCManager;", false);
            }
            reflectionArgumentArray[0] = new ReflectionArgument(clazz2, this.rpc, false, false);
            Class clazz3 = class$com$isomorphic$rpc$RPCRequest;
            if (clazz3 == null) {
                clazz3 = class$com$isomorphic$rpc$RPCRequest = RPCDMI.class("[Lcom.isomorphic.rpc.RPCRequest;", false);
            }
            reflectionArgumentArray[1] = new ReflectionArgument(clazz3, this.rpcRequest, false, false);
            ReflectionArgument[] factoryOptionalArgs = reflectionArgumentArray;
            ServerObject serverObject = new ServerObject(serverObjectConfig, this.context, factoryOptionalArgs, "");
            Class serverObjectClass = serverObject._getClass();
            Method method = serverObject.getMethod(methodName);
            Object serverObjectInstance = serverObject.getInstance(method);
            HttpSession session = null;
            Class clazz4 = class$javax$servlet$http$HttpSession;
            if (clazz4 == null) {
                clazz4 = class$javax$servlet$http$HttpSession = RPCDMI.class("[Ljavax.servlet.http.HttpSession;", false);
            }
            if (Reflection.methodTakesArgType(method, clazz4)) {
                session = this.context.request.getSession(true);
            }
            ReflectionArgument[] reflectionArgumentArray2 = new ReflectionArgument[7];
            Class clazz5 = class$com$isomorphic$servlet$RequestContext;
            if (clazz5 == null) {
                clazz5 = class$com$isomorphic$servlet$RequestContext = RPCDMI.class("[Lcom.isomorphic.servlet.RequestContext;", false);
            }
            reflectionArgumentArray2[0] = new ReflectionArgument(clazz5, this.context, false, false);
            Class clazz6 = class$javax$servlet$http$HttpServletRequest;
            if (clazz6 == null) {
                clazz6 = class$javax$servlet$http$HttpServletRequest = RPCDMI.class("[Ljavax.servlet.http.HttpServletRequest;", false);
            }
            reflectionArgumentArray2[1] = new ReflectionArgument(clazz6, (Object)(this.context != null ? this.context.request : null), false, false);
            Class clazz7 = class$javax$servlet$http$HttpServletResponse;
            if (clazz7 == null) {
                clazz7 = class$javax$servlet$http$HttpServletResponse = RPCDMI.class("[Ljavax.servlet.http.HttpServletResponse;", false);
            }
            reflectionArgumentArray2[2] = new ReflectionArgument(clazz7, this.context != null ? this.context.response : null, false, false);
            Class clazz8 = class$javax$servlet$ServletContext;
            if (clazz8 == null) {
                clazz8 = class$javax$servlet$ServletContext = RPCDMI.class("[Ljavax.servlet.ServletContext;", false);
            }
            reflectionArgumentArray2[3] = new ReflectionArgument(clazz8, this.context != null ? this.context.servletContext : null, false, false);
            Class clazz9 = class$javax$servlet$http$HttpSession;
            if (clazz9 == null) {
                clazz9 = class$javax$servlet$http$HttpSession = RPCDMI.class("[Ljavax.servlet.http.HttpSession;", false);
            }
            reflectionArgumentArray2[4] = new ReflectionArgument(clazz9, session, false, false);
            Class clazz10 = class$com$isomorphic$rpc$RPCManager;
            if (clazz10 == null) {
                clazz10 = class$com$isomorphic$rpc$RPCManager = RPCDMI.class("[Lcom.isomorphic.rpc.RPCManager;", false);
            }
            reflectionArgumentArray2[5] = new ReflectionArgument(clazz10, this.rpc, false, false);
            Class clazz11 = class$com$isomorphic$rpc$RPCRequest;
            if (clazz11 == null) {
                clazz11 = class$com$isomorphic$rpc$RPCRequest = RPCDMI.class("[Lcom.isomorphic.rpc.RPCRequest;", false);
            }
            reflectionArgumentArray2[6] = new ReflectionArgument(clazz11, this.rpcRequest, false, false);
            ReflectionArgument[] optionalArgs = reflectionArgumentArray2;
            ReflectionArgument[] requiredArgs = new ReflectionArgument[arguments.size()];
            int i4 = 0;
            while (i4 < requiredArgs.length) {
                Object arg = arguments.get(i4);
                requiredArgs[i4] = new ReflectionArgument(arg == null ? null : arg.getClass(), arg);
                ++i4;
            }
            try {
                returnValue = Reflection.adaptArgsAndInvoke(serverObjectInstance, method, requiredArgs, optionalArgs);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                log.debug((Object)"Invocation threw exception", t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                log.error((Object)"Invocation threw exception", t);
                Exception x = new Exception("RPCDMI infocation threw a: " + t.getClass().getName() + " with error: " + t.getMessage());
                throw x;
            }
            returnValueClass = method.getReturnType();
        }
        if ((clazz = class$com$isomorphic$rpc$RPCResponse) == null) {
            clazz = class$com$isomorphic$rpc$RPCResponse = RPCDMI.class("[Lcom.isomorphic.rpc.RPCResponse;", false);
        }
        if (clazz.isAssignableFrom(returnValueClass)) {
            log.debug("rpc returned RPCResponse");
            return (RPCResponse)returnValue;
        }
        log.debug("rpc returned data");
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setData(returnValue);
        rpcResponse.setStatus(RPCResponse.STATUS_SUCCESS);
        return rpcResponse;
    }

    public static Map loadAppConfig(String appID) throws Exception {
        if (appID == null) {
            throw new Exception("No appID passed, unable to lookup appConfig");
        }
        Map appConfig = null;
        if (appID.equals("isc_builtin")) {
            ISCFile builtinAppConfigFile = new ISCFile(DataTools.resourceFromClassLoader("isc_builtin.app.xml"));
            if (!builtinAppConfigFile.exists()) {
                throw new Exception("Unable to locate " + appID + ".app.xml - check to make sure it's in available in the CLASSPATH");
            }
            appConfig = (Map)XML.loadCacheableDSRecords(builtinAppConfigFile);
        } else {
            appConfig = (Map)DataStructCache.getInstance(appID, "apps", "App");
            if (appConfig == null) {
                throw new Exception("Unable to locate " + appID + ".app.xml - check to make sure it's available in " + config.getString("project.apps"));
            }
        }
        log.debug("appConfig: " + DataTools.prettyPrint(appConfig));
        return appConfig;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public RPCDMI(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) {
        this.rpcRequest = rpcRequest;
        this.rpc = rpc;
        this.context = context;
    }

    static {
        Class clazz = class$com$isomorphic$rpc$RPCDMI;
        if (clazz == null) {
            clazz = class$com$isomorphic$rpc$RPCDMI = RPCDMI.class("[Lcom.isomorphic.rpc.RPCDMI;", false);
        }
        log = new Logger(clazz.getName());
        config = Config.getGlobal();
    }
}

