/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataExport
extends Base {
    private static Logger log;
    protected static JSTranslater jsTrans;
    public static final int CSV = 1;
    public static final int JS_LITERAL = 2;
    public static final int XML = 3;
    public static final int DEFAULT_OUTPUT = 1;
    public static final int MAC_LINEBREAK = 1;
    public static final int UNIX_LINEBREAK = 2;
    public static final int DOS_LINEBREAK = 3;
    public static final int DEFAULT_LINEBREAK = 4;
    protected List order;
    protected int outputType;
    protected int lineBreakStyle;
    static /* synthetic */ Class class$com$isomorphic$rpc$DataExport;

    public void setOutputType(int output) {
        this.outputType = output;
    }

    public void setOrder(List order) {
        this.order = order;
    }

    public void setOrder(String[] order) {
        this.order = DataTools.arrayToList(order);
    }

    public void exportResultSet(List rows, Writer out) throws Exception {
        this.exportResultSet(rows, (Map)null, out);
    }

    public void exportResultSet(List rows, List columns, Writer out) throws Exception {
        this.exportResultSet(rows, DataTools.identityMap(columns), out);
    }

    public void exportResultSet(List rows, Map columnRemap, Writer out) throws Exception {
        if (rows == null || rows.size() <= 0) {
            log.debug("Empty or null result set");
            return;
        }
        PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        if (this.outputType == 2) {
            if ((rows = DataTools.remapRows(rows, columnRemap, false)).size() <= 0) {
                log.debug("Empty result set after column remap");
                return;
            }
            DataExport.jsTrans.writePrefixedDate = true;
            jsTrans.toJS(rows, out);
            DataExport.jsTrans.writePrefixedDate = false;
        } else if (this.outputType == 3) {
            out.write("<List>\n");
            Iterator i = rows.iterator();
            while (i.hasNext()) {
                Map row = (Map)i.next();
                com.isomorphic.xml.XML.recordToXML("Object", row, out, false);
            }
            out.write("</List>");
        } else if (this.outputType == 1) {
            ArrayList<Object> headers;
            Collection<Object> columns;
            if (this.order != null) {
                columns = this.order;
                if (columnRemap == null) {
                    headers = columns;
                } else {
                    headers = new ArrayList<Object>();
                    Iterator e = this.order.iterator();
                    while (e.hasNext()) {
                        Object col = e.next();
                        Object remapped = columnRemap.get(col);
                        if (remapped != null) {
                            headers.add(remapped);
                            continue;
                        }
                        headers.add(col);
                    }
                }
            } else {
                if (columnRemap == null) {
                    columnRemap = this.getColumnNames(rows);
                }
                columns = columnRemap.keySet();
                headers = columnRemap.values();
            }
            this.printLine(pw, this.getDelimitedHeaders(headers, ",", "\""));
            this.printLine(pw, this.getDelimitedValues((Collection)rows, columns, ",", "\""));
        } else {
            throw new Exception("Invalid output type: " + String.valueOf(this.outputType));
        }
    }

    protected String getDelimitedHeaders(String[] headers, String delimiter, String quoteChar) {
        return this.getDelimitedHeaders(Arrays.asList(headers), delimiter, quoteChar);
    }

    protected String getDelimitedHeaders(Collection headers, String delimiter, String quoteChar) {
        StringBuffer out = new StringBuffer();
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            String header = (String)i.next();
            if (header == null) {
                header = "";
            }
            if (quoteChar != null && header.indexOf(delimiter) != -1) {
                header = quoteChar + header + quoteChar;
            }
            out.append(header);
            if (!i.hasNext()) break;
            out.append(delimiter);
        }
        return out.toString();
    }

    protected Map getColumnNames(List rows) {
        HashMap columns = new HashMap();
        Iterator listEnum = rows.iterator();
        while (listEnum.hasNext()) {
            Map row = (Map)listEnum.next();
            Iterator rowEnum = row.keySet().iterator();
            while (rowEnum.hasNext()) {
                Object column = rowEnum.next();
                columns.put(column, column);
            }
        }
        return columns;
    }

    public String getDelimitedValues(Collection rows, Collection columns, String delimiter, String quoteChar) {
        return this.getDelimitedValues(rows, DataTools.listToStringArray(columns), delimiter, quoteChar);
    }

    public String getDelimitedValues(Collection rows, String[] columns, String delimiter, String quoteChar) {
        StringWriter output = new StringWriter();
        PrintWriter out = new PrintWriter(output);
        Iterator e = rows.iterator();
        while (e.hasNext()) {
            Map row = (Map)e.next();
            int i = 0;
            while (true) {
                Object value;
                String stringValue = (value = row.get(columns[i])) == null ? "" : (value instanceof Date ? DataTools.fastDateFormat((Date)value) : value.toString());
                if (quoteChar != null) {
                    Perl5Util perl = new Perl5Util();
                    String pattern = quoteChar.equals("/") ? "s#" + quoteChar + '#' + quoteChar + quoteChar + "#g" : "s/" + quoteChar + '/' + quoteChar + quoteChar + "/g";
                    stringValue = perl.substitute(pattern, stringValue);
                    stringValue = quoteChar + stringValue + quoteChar;
                }
                out.print(stringValue);
                if (++i >= columns.length) break;
                out.print(delimiter);
            }
            this.printLine(out, "");
        }
        out.flush();
        return output.toString();
    }

    public void printLine(PrintWriter out, String printText) {
        if (!printText.equals("")) {
            out.print(printText);
        }
        if (this.lineBreakStyle == 1) {
            out.print("\n");
        } else if (this.lineBreakStyle == 2) {
            out.print("\r");
        } else if (this.lineBreakStyle == 3) {
            out.print("\r\n");
        } else {
            out.println();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DataExport() {
        this.outputType = 1;
        this.lineBreakStyle = 4;
    }

    public DataExport(int output) {
        this.outputType = output;
        this.lineBreakStyle = 4;
    }

    public DataExport(int output, int lineBreak) {
        this.outputType = output;
        this.lineBreakStyle = lineBreak;
    }

    public DataExport(int output, int lineBreak, List columnOrder) {
        this.outputType = output;
        this.lineBreakStyle = lineBreak;
        this.order = columnOrder;
    }

    static {
        Class clazz = class$com$isomorphic$rpc$DataExport;
        if (clazz == null) {
            clazz = class$com$isomorphic$rpc$DataExport = DataExport.class("[Lcom.isomorphic.rpc.DataExport;", false);
        }
        log = new Logger(clazz.getName());
        jsTrans = new JSTranslater();
    }
}

