/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.log.Logger;
import com.isomorphic.log.RevolvingMemoryAppender;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.taglib.LoadWSDLTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BuiltinRPC
extends Base {
    protected static Logger log;
    static /* synthetic */ Class class$com$isomorphic$rpc$BuiltinRPC;

    public static void downloadWSDL(String url, String format, String fileName, RPCManager rpc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        rpc.doCustomResponse();
        RequestContext.setNoCacheHeaders(response);
        response.setContentType(DataTools.mimeTypeForFileName(fileName));
        response.addHeader("content-disposition", "attachment; filename=" + fileName);
        XML.loadWSDL(LoadWSDLTag.getAbsoluteURL(url, null), format, response.getWriter());
    }

    public static RPCResponse xmlToJS(String xmlString) throws Exception {
        StringWriter out = new StringWriter();
        try {
            XML.toJS(new StringReader(xmlString), (Writer)out);
        }
        catch (XMLParsingException e) {
            log.info("Error parsing inbound XML - assuming multiple top-level elements and retrying with wrapper tag.");
            SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(xmlString), "</isomorphicXML>");
            out = new StringWriter();
            XML.toJS(reader, (Writer)out);
        }
        return new RPCResponse(out.toString());
    }

    public static RPCResponse uploadProgressCheck(HttpSession session, String formID) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("formID", formID);
        List errors = (List)session.getAttribute("errors");
        if (errors != null) {
            responseData.put("errors", errors);
        }
        responseData.put("bytesSoFar", session.getAttribute("bytesSoFar"));
        responseData.put("totalBytes", session.getAttribute("totalBytes"));
        return new RPCResponse(responseData);
    }

    public static RPCResponse deleteFile(String path) throws Exception {
        path = ISCFile.canonicalizePath(config.getPath("webRoot") + '/' + path);
        log.debug("Deleting: " + path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse saveFile(String path, String data) throws Exception {
        path = ISCFile.canonicalizePath(config.getPath("webRoot") + '/' + path);
        log.debug("Saving: " + path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        IOUtil.copyCharacterStreams(new StringReader(data), new FileWriter(file));
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse appendToFile(String path, String data) throws Exception {
        path = ISCFile.canonicalizePath(config.getPath("webRoot") + '/' + path);
        log.debug("Appending to: " + path);
        File file = new File(path);
        IOUtil.copyCharacterStreams(new StringReader(data), new FileWriter(file, true));
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse loadFile(String path) throws Exception {
        path = ISCFile.canonicalizePath(config.getPath("webRoot") + '/' + path);
        log.debug("Loading: " + path);
        File file = new File(path);
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(new FileReader(file), sw);
        RPCResponse response = new RPCResponse();
        response.setData(sw.toString());
        return response;
    }

    public static Map getAvailableScriptEngines() throws Exception {
        HashMap<String, String> scriptEngines = new HashMap<String, String>();
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            List<ScriptEngineFactory> factories = mgr.getEngineFactories();
            int i = 0;
            while (i < factories.size()) {
                ScriptEngineFactory factory = factories.get(i);
                String language = factory.getLanguageName();
                String engineName = factory.getNames().get(0);
                scriptEngines.put(engineName, language);
                ++i;
            }
            return scriptEngines;
        }
        catch (Error e) {
            try {
                new GroovyShell();
                scriptEngines.put("groovy", "Groovy");
            }
            catch (Error ee) {
                log.error((Object)"Unable to init scripting.  Make sure you're running JDK 1.6+ for JSR223 scripting or install Groovy.", e);
            }
            return scriptEngines;
        }
    }

    public static RPCResponse evalGroovyScript(DataTypeMap data) throws Exception {
        String engineName = data.getString("engineName");
        String script = data.getString("script");
        boolean captureOutput = data.getBoolean((Object)"captureOutput", false);
        List imports = data.getList("imports");
        DataTypeMap bindings = data.getMap("bindings");
        String importDirectives = BuiltinRPC.getImportDirectives(engineName, imports);
        String header = "";
        try {
            ISCFile headerFile = new ISCFile(config.getPath("script.groovy.header"));
            if (headerFile.exists()) {
                header = headerFile.getAsString();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to include groovy header", e);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        GroovyShell shell = bindings != null ? new GroovyShell(cl, new Binding((Map)((Object)bindings))) : new GroovyShell(cl);
        Object evalResult = shell.evaluate(importDirectives + header + script);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("evalResult", evalResult);
        return new RPCResponse(result);
    }

    public static RPCResponse evalServerScript(DataTypeMap data) throws Exception {
        String engineName = data.getString("engineName");
        String script = data.getString("script");
        boolean captureOutput = data.getBoolean((Object)"captureOutput", false);
        List imports = data.getList("imports");
        DataTypeMap bindings = data.getMap("bindings");
        if ("groovy".equals(engineName)) {
            return BuiltinRPC.evalGroovyScript(data);
        }
        ScriptEngineManager factory = null;
        try {
            factory = new ScriptEngineManager();
        }
        catch (Error e) {
            log.error((Object)"Unable to init scripting", e);
            throw new Exception("Unable to init scripting.  Make sure you're running JDK 1.6+");
        }
        ScriptEngine engine = null;
        log.info("Initializing scripting engine: " + engineName);
        try {
            engine = factory.getEngineByName(engineName);
        }
        catch (Error e) {
            log.error((Object)("Unable to load engine: " + engineName), e);
            throw new Exception("Unable to load engine: " + engineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
        }
        if (engine == null) {
            throw new Exception("Unable to load engine: " + engineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
        }
        String importDirectives = BuiltinRPC.getImportDirectives(engineName, imports);
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        ScriptContext sc = engine.getContext();
        if (bindings != null) {
            Iterator i = bindings.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                sc.setAttribute(key, bindings.get(key), 100);
            }
        }
        if (captureOutput) {
            sc.setWriter(stdout);
            sc.setErrorWriter(stderr);
        }
        engine.setContext(sc);
        Object evalResult = null;
        if (engineName.toLowerCase().equals("java")) {
            String classWrapperStart = "import javax.script.*;\nclass iscTmpClass {\nprivate static ScriptContext ctx;\npublic static void setScriptContext(ScriptContext context) {ctx = context;}\npublic static void main(String[] args) { Object result = doExec(args); ctx.setAttribute(\"evalResult\",result,ScriptContext.ENGINE_SCOPE);}\npublic static Object doExec(String[] args) {\n";
            String classWrapperEnd = "\n}}";
            if (script.indexOf("return ") == -1) {
                script = script + "\nreturn null;";
            }
            String evalScript = importDirectives + classWrapperStart + script + classWrapperEnd;
            log.info("Evaluating assembled script:\n" + evalScript);
            sc.setAttribute("parentLoader", Thread.currentThread().getContextClassLoader(), 100);
            engine.eval(evalScript);
            evalResult = sc.getAttribute("evalResult");
        } else {
            String evalScript = importDirectives + script;
            log.info("Evaluating assembled script:\n" + evalScript);
            evalResult = engine.eval(evalScript);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("evalResult", evalResult);
        if (captureOutput) {
            result.put("stdout", stdout.toString());
            result.put("stderr", stderr.toString());
        }
        return new RPCResponse(result);
    }

    private static final String getImportDirectives(String engineName, List imports) throws Exception {
        String lce = engineName.toLowerCase();
        String importDirectives = "";
        if (imports != null && (lce.equals("groovy") || lce.equals("ecmascript") || lce.equals("js") || lce.equals("java"))) {
            Iterator i = imports.iterator();
            while (i.hasNext()) {
                String imp = (String)i.next();
                if (imp == null || (imp = imp.trim()).equals("")) continue;
                if (imp.endsWith(";")) {
                    imp = imp.substring(0, imp.length() - 1);
                }
                if (lce.equals("groovy") || lce.equals("java")) {
                    importDirectives = importDirectives + "import " + imp + ";\n";
                    continue;
                }
                if (!lce.equals("ecmascript") && !lce.equals("js")) continue;
                if (imp.endsWith(".*")) {
                    imp = imp.substring(0, imp.length() - 2);
                }
                importDirectives = importDirectives + "importPackage(" + imp + ");\n";
            }
        }
        return importDirectives;
    }

    public static RPCResponse evalJava(String javaCode, RequestContext context) throws Exception {
        if (ISCFile.inContainerIOMode()) {
            throw new Exception("Can't execute Java code in container-IO mode - to fix, explicitly set webRoot in server.properties");
        }
        String webRoot = config.getPath("webRoot");
        String tmpPath = "/tools/devConsoleEval.jsp";
        File tmpJSP = new File(webRoot + tmpPath);
        if (tmpJSP.exists()) {
            tmpJSP.delete();
        }
        tmpJSP.createNewFile();
        File header = new File(webRoot + "/shared/jsp/evalJavaHeader.jsp");
        File footer = new File(webRoot + "/shared/jsp/evalJavaFooter.jsp");
        FileWriter fw = new FileWriter(tmpJSP);
        if (header.exists()) {
            IOUtil.copyCharacterStreams(new FileReader(header), fw);
        }
        IOUtil.copyCharacterStreams(new StringReader(javaCode), fw);
        if (footer.exists()) {
            IOUtil.copyCharacterStreams(new FileReader(footer), fw);
        }
        ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
        ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(context.response, new ProxyServletOutputStream(wrapBuf), "evalJava");
        RPCResponse response = new RPCResponse();
        try {
            ServletTools.include(context.servletContext, (ServletRequest)context.request, (ServletResponse)wrapResponse, tmpPath);
            try {
                wrapResponse.flushBuffer();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            wrapBuf.flush();
            response.setData(wrapBuf.toString());
            response.setStatus(RPCResponse.STATUS_SUCCESS);
        }
        catch (Throwable t) {
            response.setData(t.toString());
            response.setStatus(RPCResponse.STATUS_FAILURE);
        }
        return response;
    }

    public static RPCResponse loadSharedXML(String type, String ID) throws Exception {
        boolean returnXML = true;
        boolean returnJS = true;
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("type", type);
        responseData.put("ID", ID);
        try {
            String typeName = BuiltinRPC.getTypeNameForExtension(type);
            if (typeName == null) {
                throw new Exception("Unknown type: " + type);
            }
            log.debug("loadSharedXML - ID: " + ID + " typeName: " + typeName + " type: " + type);
            String path = DataStructCache.getInstanceFile(ID, typeName, type);
            log.warn("looking for: " + path);
            if (path == null) {
                throw new Exception("Can't find " + type + ' ' + ID);
            }
            ISCFile file = new ISCFile(path);
            if (!file.exists()) {
                throw new Exception("Can't find " + type + ' ' + ID);
            }
            String xml = DataTools.fileContentsAsString(file);
            if (returnXML) {
                responseData.put("xml", xml);
            }
            if (returnJS) {
                StringReader reader = new StringReader(xml);
                StringWriter sw = new StringWriter();
                XML.toJS(reader, (Writer)sw);
                responseData.put("js", sw.toString());
            }
        }
        catch (Exception e) {
            responseData.put("error", e.toString());
        }
        return new RPCResponse(responseData);
    }

    public static RPCResponse saveSharedXML(String type, String ID, String contents) throws Exception {
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("type", type);
        responseData.put("ID", ID);
        Object error = null;
        try {
            if (ISCFile.inContainerIOMode()) {
                throw new Exception("SmartClient server running in Container-IO mode - unable to save.");
            }
            String typeName = BuiltinRPC.getTypeNameForExtension(type);
            if (typeName == null) {
                throw new Exception("Unknown type: " + type);
            }
            log.debug("saveSharedXML - ID: " + ID + " typeName: " + typeName + " type: " + type);
            String path = DataStructCache.getInstanceFile(ID, typeName, type);
            if (path == null) {
                List paths = config.getCommaSeparatedList("project." + typeName);
                path = (String)paths.get(0);
                if (path == null) {
                    throw new Exception("Unable to determine default storage path for type: " + type + " was looking for config param: project." + typeName);
                }
                path = path + '/' + ID + '.' + type.toLowerCase() + ".xml";
            }
            log.warn("Saving " + type + ' ' + ID + " at location: " + path);
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            IOUtil.copyCharacterStreams(new StringReader(contents), new FileWriter(file));
        }
        catch (Exception e) {
            responseData.put("error", e.toString());
        }
        return new RPCResponse(responseData);
    }

    private static final String getTypeNameForExtension(String type) {
        String typeName = null;
        if ("DS".equals(type)) {
            typeName = "datasources";
        } else if ("APP".equals(type)) {
            typeName = "apps";
        } else if ("UI".equals(type)) {
            typeName = "ui";
        }
        return typeName;
    }

    public static List getLogNames() throws Exception {
        return RevolvingMemoryAppender.getLogNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getLogEntries(String logName) throws Exception {
        ArrayList logEntries = RevolvingMemoryAppender.getLogEntries(logName);
        ArrayList arrayList = logEntries;
        synchronized (arrayList) {
            return new ArrayList(logEntries);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$rpc$BuiltinRPC;
        if (clazz == null) {
            clazz = class$com$isomorphic$rpc$BuiltinRPC = BuiltinRPC.class("[Lcom.isomorphic.rpc.BuiltinRPC;", false);
        }
        log = new Logger(clazz.getName());
    }
}

