/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.pool;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCKeyedObjectPool;
import com.isomorphic.pool.ISCKeyedPoolableObjectFactory;
import com.isomorphic.pool.ISCObjectPool;
import com.isomorphic.pool.ISCPoolableObjectFactory;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoolManager
extends Base {
    private Logger log;
    protected String name;
    protected String symbolicName;
    protected IPoolableObjectFactory factory;
    protected Object source;
    protected Map sources;
    static /* synthetic */ Class class$com$isomorphic$pool$PoolManager;

    public Object borrowObject(Object key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            return ((ISCKeyedObjectPool)((Object)objectSource)).borrowObject(key);
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).borrowObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            return ((ISCKeyedPoolableObjectFactory)objectSource).makeObject(key);
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public Object borrowUnpooledObject(Object key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            return ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory().makeUnpooledObject(key);
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).getObjectFactory().makeUnpooledObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeUnpooledObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            return ((ISCKeyedPoolableObjectFactory)objectSource).makeUnpooledObject(key);
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public Object borrowNewObject(Object key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            return ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory().makeObject(key);
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).getObjectFactory().makeObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            return ((ISCKeyedPoolableObjectFactory)objectSource).makeObject(key);
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public void returnObject(Object key, Object obj) {
        try {
            Object objectSource = this.getObjectSource(key);
            if (objectSource instanceof ISCObjectPool) {
                ((ISCObjectPool)((Object)objectSource)).returnObject(obj);
            } else if (objectSource instanceof ISCKeyedObjectPool) {
                ((ISCKeyedObjectPool)((Object)objectSource)).returnObject(key, obj);
            } else if (objectSource instanceof ISCPoolableObjectFactory) {
                ((ISCPoolableObjectFactory)objectSource).destroyObject(obj);
            } else if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
                ((ISCKeyedPoolableObjectFactory)objectSource).destroyObject(key, obj);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while freeing object - ignored.", e);
        }
    }

    public synchronized Object getObjectSource(Object key) throws Exception {
        if (this.factory instanceof ISCKeyedPoolableObjectFactory) {
            if (this.source == null) {
                this.source = this.makeSource(key);
            }
            return this.source;
        }
        Object source = this.sources.get(key);
        if (source == null) {
            source = this.makeSource(key);
            this.sources.put(key, source);
        }
        return source;
    }

    public Object makeSource(Object key) throws Exception {
        Config globalPoolConfig = config.getSubtree("pooling.default");
        Config objectConfig = config.getSubtree(this.name + ".pool");
        Config thisPoolConfig = config.getSubtree(this.name + '.' + key.toString() + ".pool");
        Config mergedConfig = new Config();
        DataTools.mapMerge((Map)((Object)globalPoolConfig), (Map)((Object)mergedConfig));
        DataTools.mapMerge((Map)((Object)objectConfig), (Map)((Object)mergedConfig));
        DataTools.mapMerge((Map)((Object)thisPoolConfig), (Map)((Object)mergedConfig));
        IPoolableObjectFactory factory = this.factory.newInstance(key);
        this.source = factory;
        ISCPoolableObjectFactory iscFactory = null;
        if (factory instanceof ISCPoolableObjectFactory) {
            iscFactory = (ISCPoolableObjectFactory)factory;
        }
        if (mergedConfig.getBoolean((Object)"enabled", false) && (iscFactory == null || !iscFactory.poolDisabled)) {
            mergedConfig.remove("enabled");
            Object pool = factory instanceof ISCKeyedPoolableObjectFactory ? new ISCKeyedObjectPool((ISCKeyedPoolableObjectFactory)factory, (Map)((Object)mergedConfig)) : new ISCObjectPool((ISCPoolableObjectFactory)factory, (Map)((Object)mergedConfig));
            factory.setPool(pool);
            this.source = pool;
        } else {
            this.log.info("SmartClient pooling disabled for '" + key.toString() + "' objects");
        }
        if (this.source == null) {
            throw new Exception("Unable to bind objectSource for key: " + key.toString());
        }
        return this.source;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$isomorphic$pool$PoolManager;
        if (clazz == null) {
            clazz = class$com$isomorphic$pool$PoolManager = PoolManager.class("[Lcom.isomorphic.pool.PoolManager;", false);
        }
        this.log = new Logger(clazz.getName());
        this.sources = new HashMap();
    }

    public PoolManager(String name, IPoolableObjectFactory factory) {
        this.this();
        this.name = name;
        this.factory = factory;
        this.symbolicName = this.getClass().getName();
    }
}

