/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.naming;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.util.DataTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DNS
extends Base {
    private static Logger log;
    protected DirContext ctx;
    static /* synthetic */ Class class$com$isomorphic$naming$DNS;

    public DirContext getJNDIContext() {
        return this.ctx;
    }

    public List lookupMX(String name) throws Exception {
        return this.attributeValuesAsList(this.lookup(name, "MX"));
    }

    public static Map mxMapForList(String mxList) throws Exception {
        return DNS.mxMapForList(DataTools.simpleSplit(mxList, ","));
    }

    public static Map mxMapForList(List mxList) throws Exception {
        if (mxList == null) {
            return null;
        }
        Map result = new HashMap();
        Perl5Util regex = new Perl5Util();
        Iterator i = mxList.iterator();
        while (i.hasNext()) {
            String mx = i.next().toString();
            if (regex.match("#(\\d+)\\s+(\\S+)#", mx)) {
                result = DataTools.putMultipleAsList(result, Integer.valueOf(regex.group(1)), regex.group(2));
                continue;
            }
            if (regex.match("#(\\s*(\\S+)\\s*)#", mx)) {
                result = DataTools.putMultipleAsList(result, new Integer(1), regex.group(1));
                continue;
            }
            throw new Exception("malformed MX: " + mx);
        }
        return result;
    }

    public List lookupNS(String name) throws Exception {
        return this.attributeValuesAsList(this.lookup(name, "NS"));
    }

    public List lookupAddress(String name) throws Exception {
        return this.attributeValuesAsList(this.lookup(name, "A"));
    }

    public List lookupName(String address) throws Exception {
        Perl5Util regex = new Perl5Util();
        if (!regex.match("#(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)#", address)) {
            return null;
        }
        address = regex.group(4) + '.' + regex.group(3) + '.' + regex.group(2) + '.' + regex.group(1) + ".in-addr.arpa";
        return this.attributeValuesAsList(this.lookup(address, "PTR"));
    }

    public List attributeValuesAsList(Attribute attr) throws Exception {
        if (attr == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        NamingEnumeration<?> ne = attr.getAll();
        while (ne.hasMore()) {
            result.add(ne.next());
        }
        return result;
    }

    public Attribute lookup(String query, String type) throws Exception {
        try {
            Attributes attrs = this.ctx.getAttributes(query, new String[]{type});
            return attrs.get(type);
        }
        catch (NameNotFoundException nfe) {
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DNS(String configId) throws Exception {
        this.ctx = new InitialDirContext(JNDI.bindConfiguredContext(configId).getEnvironment());
    }

    static {
        Class clazz = class$com$isomorphic$naming$DNS;
        if (clazz == null) {
            clazz = class$com$isomorphic$naming$DNS = DNS.class("[Lcom.isomorphic.naming.DNS;", false);
        }
        log = new Logger(clazz.getName());
    }
}

