/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.base.Config;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class ANSIColorizedPatternLayout
extends PatternLayout {
    private static String red = "[31m";
    private static String yellow = "[33m";
    private static String restoreColor = "[0m";
    private static Map colors = new HashMap();

    public static void initialize() {
        Config config = Config.getGlobal();
        Config configColors = config.getSubtree("ANSIColorizedPatternLayout.colors");
        if (configColors != null) {
            colors = configColors;
        }
        restoreColor = config.getString("ANSIColorizedPatternLayout.restoreColor");
    }

    public String format(LoggingEvent event) {
        String formattedMessage = super.format(event);
        String color = (String)colors.get(event.getLevel().toString());
        if (color != null) {
            formattedMessage = "\u001b" + color + formattedMessage + '\u001b' + restoreColor;
        }
        return formattedMessage;
    }

    static {
        colors.put("WARN", yellow);
        colors.put("ERROR", red);
    }
}

