/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.base.Base;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.IJSParser;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.IToJavaScript;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCDate;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.SequencedHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JSTranslater
extends Base {
    private static Logger log;
    public static boolean globalPrettyPrinting;
    public static boolean collapseSmallContainers;
    public static boolean globalOmitNullMapValues;
    public static boolean writeNativeDate;
    public static final String DEFAULT_ENUM_TRANSLATE_STRATEGY = "string";
    public static final String DEFAULT_ENUM_CONSTANT_PROPERTY = "_constant";
    public static final String DEFAULT_ENUM_ORDINAL_PROPERTY = "_ordinal";
    static final Perl5Util regex;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd kk:mm:ss";
    public static final SimpleDateFormat dateFormat;
    public static final SimpleDateFormat dateTimeFormat;
    public static final Object[] EMPTY_ARRAY;
    public static final HashMap types;
    static final HashSet safeToString;
    static final HashSet sendAsJSString;
    static final HashSet reservedWords;
    public boolean writePrefixedDate;
    public Map obfuscateMapKeys;
    private String enumTranslateStrategy;
    private String constantProperty;
    private String ordinalProperty;
    boolean prettyPrinting;
    boolean omitNullMapValues;
    Calendar calendar;
    int currentIndentDepth;
    boolean alwaysToString;
    int propNameIndent;
    String path;
    boolean quoteForXML;
    boolean quoteForTextArea;
    ValidationContext validationContext;
    boolean useSchema;
    List recursedList;
    int recursionCount;
    static /* synthetic */ Class class$com$isomorphic$js$JSTranslater;

    public static JSTranslater instance() {
        return new JSTranslater();
    }

    public static JSTranslater get() {
        JSTranslater jsTrans = new JSTranslater();
        return jsTrans;
    }

    public JSTranslater enablePrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public JSTranslater enablePrettyPrinting(boolean value) {
        this.prettyPrinting = value;
        return this;
    }

    public JSTranslater omitNullMapValues(boolean value) {
        this.omitNullMapValues = value;
        return this;
    }

    public JSTranslater collapseSmallContainers(boolean value) {
        collapseSmallContainers = value;
        return this;
    }

    public void quoteForTextArea() {
        this.quoteForTextArea = true;
        this.quoteForXML = false;
    }

    public void quoteForXML() {
        this.quoteForXML = true;
        this.quoteForTextArea = false;
    }

    public void alwaysToString() {
        this.alwaysToString = true;
    }

    public void alwaysToString(boolean toString) {
        this.alwaysToString = toString;
    }

    public void setUseSchema() {
        this.useSchema = true;
    }

    public void setUseSchema(boolean value) {
        this.useSchema = value;
    }

    public void indent(int numChars, Writer out) throws IOException {
        int ii = 0;
        while (ii < numChars) {
            out.write(" ");
            ++ii;
        }
    }

    public void indentToCurrentDepth(Writer out) throws IOException {
        int ii = 0;
        while (ii < this.currentIndentDepth) {
            out.write("    ");
            ++ii;
        }
    }

    public boolean safeToString(Object javaObj) {
        String className = javaObj.getClass().getName();
        return safeToString.contains(className);
    }

    public String toJS(Object javaObj) throws UnconvertableException {
        try {
            StringWriter out = new StringWriter();
            this.toJS(javaObj, out);
            return out.toString();
        }
        catch (IOException e) {
            log.error("IOException from StringWriter on toJS (should be impossible)");
            throw new UnconvertableException("IOException from StringWriter");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void toJS(Object javaObj, Writer out) throws UnconvertableException, IOException {
        block10: {
            long start = System.currentTimeMillis();
            if (this.recursedList == null) {
                this.recursionCount = 0;
            }
            if (this.recursionCount == 0) {
                this.recursedList = new ArrayList();
            }
            ++this.recursionCount;
            try {
                try {
                    this.convert(javaObj, out);
                }
                catch (IOException ioe) {
                    this.recursionCount = 1;
                    throw ioe;
                }
                catch (UnconvertableException ue) {
                    this.recursionCount = 1;
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                --this.recursionCount;
                if (this.recursionCount == 0) {
                    this.recursedList = null;
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                --this.recursionCount;
                if (this.recursionCount == 0) {
                    this.recursedList = null;
                }
                if (javaObj == null || this.isLeaf(javaObj)) break block10;
            }
            long end = System.currentTimeMillis();
            Logger.timing.debug("Time to convert " + javaObj.getClass().getName() + " to JS Object: " + (end - start) + "ms");
        }
    }

    private final String convert(Object javaObj) throws UnconvertableException, IOException {
        StringWriter out = new StringWriter();
        this.convert(javaObj, out);
        return out.toString();
    }

    private final void convert(Object javaObj, Writer out) throws UnconvertableException, IOException {
        this.convert(javaObj, out, null);
    }

    private final void convert(Object javaObj, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        Object obj;
        if (javaObj instanceof JSONFilter) {
            JSONFilter filter = (JSONFilter)javaObj;
            javaObj = filter.getObj();
            beanFilter = filter.getBeanFilter();
        }
        if (this.convertSimple(javaObj, out)) {
            return;
        }
        ArrayList<Object> recursedList = this.recursedList;
        if (recursedList == null) {
            log.warn("can't find current recursion set - recursion check disabled for this call.");
            log.debug((Object)"Stack trace for recursedList not found", new Exception());
            recursedList = new ArrayList<Object>();
        }
        if (javaObj != null) {
            int i = recursedList.size() - 1;
            while (i >= 0) {
                obj = recursedList.get(i);
                if (javaObj == obj) {
                    log.warn(javaObj.getClass().getName() + " contains a (potentially indirect) looping reference to itself.  Returning null for recursed value.");
                    out.write("null /* loop to object of type: " + javaObj.getClass().getName() + " */");
                    return;
                }
                --i;
            }
        }
        recursedList.add(javaObj);
        if (javaObj instanceof IToJSON) {
            ((IToJSON)javaObj).toJSON(out, this);
        } else if (javaObj instanceof IToJavaScript) {
            ((IToJavaScript)javaObj).toJavaScript(out);
        } else if (javaObj instanceof Map) {
            this.convertMap((Map)javaObj, out, beanFilter);
        } else if (javaObj instanceof Collection) {
            this.convertCollection((Collection)javaObj, out, beanFilter);
        } else if (javaObj instanceof Object[]) {
            this.convertArray((Object[])javaObj, out, beanFilter);
        } else if (javaObj instanceof Iterator) {
            this.convertIterator((Iterator)javaObj, out, beanFilter);
        } else if (javaObj instanceof Enumeration) {
            this.convertEnumeration((Enumeration)javaObj, out, beanFilter);
        } else {
            if (javaObj instanceof Element) {
                try {
                    Element element = (Element)javaObj;
                    if (log.isDebugEnabled()) {
                        log.debug("XML Element '" + element.getTagName() + "' being transformed as part of JS translation");
                    }
                    if (this.validationContext == null) {
                        this.validationContext = new ValidationContext();
                        this.validationContext.setUseSchema(this.useSchema);
                    }
                    this.convert(DataSource.recordsFromXML(element, this.validationContext), out, beanFilter);
                }
                catch (Exception e) {
                    throw new UnconvertableException(DataTools.getStackTrace(e));
                }
            }
            if (javaObj instanceof Document) {
                this.convert(((Document)javaObj).getDocumentElement(), out, beanFilter);
            } else {
                try {
                    Map propertyMap;
                    Map map = propertyMap = beanFilter != null ? beanFilter.filter(javaObj) : DataTools.getProperties(javaObj);
                    if (propertyMap.containsKey("class")) {
                        propertyMap.remove("class");
                    }
                    this.convertMap(propertyMap, out, null);
                }
                catch (Exception e) {
                    throw new UnconvertableException(DataTools.getStackTrace(e));
                }
            }
        }
        int i = recursedList.size() - 1;
        while (i >= 0) {
            obj = recursedList.get(i);
            if (obj == javaObj) {
                recursedList.remove(i);
                break;
            }
            --i;
        }
    }

    private final String convertSimple(Object javaObj) throws UnconvertableException, IOException {
        StringWriter out = new StringWriter();
        if (this.convertSimple(javaObj, out)) {
            return out.toString();
        }
        return null;
    }

    private final boolean convertSimple(Object javaObj, Writer out) throws UnconvertableException, IOException {
        if (javaObj instanceof String) {
            this.convertString((String)javaObj, out);
        } else if (javaObj instanceof Character) {
            this.convertString(String.valueOf((Character)javaObj), out);
        } else if (javaObj instanceof Clob) {
            this.convertSqlClob((Clob)javaObj, out);
        } else if (javaObj instanceof Date) {
            this.convertDate((Date)javaObj, out);
        } else if (javaObj instanceof Number) {
            out.write(javaObj.toString());
        } else if (javaObj instanceof Boolean) {
            out.write((Boolean)javaObj != false ? "true" : "false");
        } else if (javaObj instanceof Class) {
            this.convertString(((Class)javaObj).getName(), out);
        } else if (javaObj == null) {
            out.write("null");
        } else if (javaObj instanceof byte[]) {
            this.convertByteBuffer((byte[])javaObj, out);
        } else if (VersionSafeChecker.isEnum(javaObj)) {
            this.convertEnum((Enum)javaObj, out);
        } else {
            String className = javaObj.getClass().getName();
            if (sendAsJSString.contains(className)) {
                this.convertString(javaObj.toString(), out);
                return true;
            }
            if (this.alwaysToString || safeToString.contains(className)) {
                out.write(javaObj.toString());
                return true;
            }
            return false;
        }
        return true;
    }

    private final String convertMapKey(Object javaObj) throws UnconvertableException, IOException {
        String convertedKey;
        if (javaObj instanceof Date) {
            return null;
        }
        String string = convertedKey = javaObj instanceof String ? (String)javaObj : this.convertSimple(javaObj);
        if (convertedKey == null) {
            return null;
        }
        if (!(convertedKey.startsWith("\"") || convertedKey.startsWith("'") || !reservedWords.contains(convertedKey) && JSTranslater.isValidJSIdentifier(convertedKey))) {
            convertedKey = this.convertSimple(convertedKey);
        }
        return convertedKey;
    }

    boolean isAList(Object obj) {
        return obj instanceof Object[] || obj instanceof Collection || obj instanceof Iterator || obj instanceof Enumeration;
    }

    void convertByteBuffer(byte[] buf, Writer out) throws UnconvertableException, IOException {
        String theString = new String(buf);
        out.write("\"");
        if (theString != null) {
            out.write(theString);
        }
        out.write("\"");
    }

    void convertEnum(Enum e, Writer out) throws UnconvertableException, IOException {
        if (this.enumTranslateStrategy == null) {
            out.write("\"" + e.toString() + '\"');
        } else if (this.enumTranslateStrategy.toLowerCase().equals("ordinal")) {
            out.write(String.valueOf(e.ordinal()));
        } else if (this.enumTranslateStrategy.toLowerCase().equals("bean")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.ordinalProperty, new Integer(e.ordinal()));
            map.put(this.constantProperty, e.toString());
            Map propMap = null;
            try {
                propMap = DataTools.getPropertyDescriptors(e);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (propMap != null) {
                Iterator i = propMap.keySet().iterator();
                while (i.hasNext()) {
                    Method readMethod;
                    PropertyDescriptor prop;
                    String propName = (String)i.next();
                    if ("class".equals(propName) || "declaringClass".equals(propName) || (prop = (PropertyDescriptor)propMap.get(propName)) == null || (readMethod = prop.getReadMethod()) == null) continue;
                    try {
                        Object value = readMethod.invoke((Object)e, null);
                        map.put(propName, value);
                    }
                    catch (Exception ex) {
                        log.warn(e);
                    }
                }
            }
            this.convertMap(map, out, null);
        } else {
            out.write("\"" + e.toString() + '\"');
        }
    }

    boolean isLeaf(Object value) {
        if (value == null || value instanceof String) {
            return true;
        }
        if (value instanceof Collection || value instanceof Map || value instanceof Object[]) {
            return false;
        }
        return value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Date || value instanceof Time || this.safeToString(value);
    }

    boolean containsOnlyLeaves(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (this.isLeaf(i.next())) continue;
            return false;
        }
        return true;
    }

    boolean containsOnlyLeaves(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = map.get(key);
            if (this.isLeaf(key) && this.isLeaf(value)) continue;
            return false;
        }
        return true;
    }

    void convertMap(Map inputMap, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        Object constructorObj;
        Map map = inputMap.getClass().getName().equals("org.hibernate.util.IdentityMap") ? new SequencedHashMap(inputMap) : inputMap;
        boolean collapse = false;
        if (this.prettyPrinting && collapseSmallContainers) {
            if (this.containsOnlyLeaves(map)) {
                collapse = true;
            } else {
                this.propNameIndent = 0;
            }
        }
        String constructor = null;
        if (map.containsKey("__autoConstruct") && (constructorObj = map.get("__autoConstruct")) != null) {
            constructor = constructorObj.toString();
            out.write("isc." + constructor + ".create(");
        }
        out.write("{");
        if (this.prettyPrinting && !collapse) {
            ++this.currentIndentDepth;
        }
        int linePos = this.currentIndentDepth * 4;
        int elemLength = 0;
        boolean dropLine = true;
        boolean startingLine = true;
        if (beanFilter != null) {
            try {
                map = beanFilter.filter(map);
            }
            catch (Exception e) {
                log.warn((Object)"Error in convertMap trying to filter bean", e);
                throw new UnconvertableException("Error in convertMap trying to filter bean: " + e.getMessage());
            }
        }
        Set mapKeys = map.keySet();
        if (constructor != null) {
            mapKeys = new LinkedHashSet(mapKeys);
            mapKeys.remove("__autoConstruct");
        }
        boolean hadOneKey = false;
        Iterator iter = mapKeys.iterator();
        while (iter.hasNext()) {
            String convertedKey;
            Object obfuscatedValue;
            Object key = iter.next();
            Object value = map.get(key);
            if (this.omitNullMapValues && value == null) continue;
            if (this.obfuscateMapKeys != null && value instanceof String && (obfuscatedValue = this.obfuscateMapKeys.get(key)) != null) {
                value = obfuscatedValue;
            }
            if ((convertedKey = this.convertMapKey(key)) == null) {
                log.info("Ignoring unconvertible Map key of type: " + key.getClass().getName());
                continue;
            }
            if (convertedKey.equals("hibernateLazyInitializer")) continue;
            String convertedValue = this.convert(value);
            if (collapse) {
                elemLength = convertedKey.length() + convertedValue.length() + 2;
                boolean bl = false;
                if (!collapse || !startingLine && elemLength + linePos > 100) {
                    bl = dropLine = true;
                }
            }
            if (hadOneKey) {
                out.write(",");
                if (!dropLine) {
                    out.write(" ");
                }
            } else {
                hadOneKey = true;
            }
            if (this.prettyPrinting) {
                if (dropLine) {
                    out.write("\n");
                    this.indentToCurrentDepth(out);
                    startingLine = true;
                    if (collapse) {
                        this.indent(this.propNameIndent + 1, out);
                        linePos = this.currentIndentDepth * 4 + this.propNameIndent + 1;
                    }
                } else {
                    startingLine = false;
                }
                linePos += elemLength;
            }
            out.write(convertedKey);
            if (this.prettyPrinting && !collapse) {
                this.propNameIndent = convertedKey.length() + 1;
            }
            out.write(":");
            out.write(convertedValue);
            if (!this.prettyPrinting || collapse) continue;
            this.propNameIndent = 0;
        }
        if (this.prettyPrinting) {
            if (!collapse) {
                out.write("\n");
                --this.currentIndentDepth;
                this.indentToCurrentDepth(out);
            }
            out.write("}");
        } else {
            out.write("}");
        }
        if (constructor != null) {
            out.write(")\n");
        }
    }

    void convertArray(Object[] array, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        this.convertCollection(Arrays.asList(array), out, beanFilter);
    }

    void convertCollection(Collection collection, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        boolean collapse = false;
        if (this.prettyPrinting && collapseSmallContainers) {
            if (this.containsOnlyLeaves(collection)) {
                collapse = true;
            } else {
                this.propNameIndent = 0;
            }
        }
        this.convertIterator(collection.iterator(), out, beanFilter, collapse);
    }

    void convertIterator(Iterator list, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        this.convertIterator(list, out, beanFilter, false);
    }

    void convertIterator(Iterator iterator, Writer out, IBeanFilter beanFilter, boolean collapse) throws UnconvertableException, IOException {
        out.write("[");
        if (this.prettyPrinting && !collapse) {
            ++this.currentIndentDepth;
        }
        int linePos = this.currentIndentDepth * 4;
        int itemLength = 0;
        boolean dropLine = true;
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (collapse) {
                itemLength = this.convert(item).length() + 2;
                boolean bl = false;
                if (itemLength + linePos > 100) {
                    bl = dropLine = true;
                }
            }
            if (this.prettyPrinting && dropLine) {
                out.write("\n");
                this.indentToCurrentDepth(out);
                if (collapse) {
                    this.indent(this.propNameIndent + 1, out);
                }
                linePos = this.currentIndentDepth * 4 + this.propNameIndent;
            } else {
                linePos += itemLength;
            }
            this.convert(item, out, this.isAList(item) ? null : beanFilter);
            if (!iterator.hasNext()) continue;
            out.write(",");
            if (dropLine) continue;
            out.write(" ");
        }
        if (this.prettyPrinting) {
            if (!collapse) {
                out.write("\n");
                --this.currentIndentDepth;
                this.indentToCurrentDepth(out);
            }
            out.write("]");
        } else {
            out.write("]");
        }
    }

    void convertEnumeration(final Enumeration e, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        this.convertIterator(new Iterator(){

            public final boolean hasNext() {
                return e.hasMoreElements();
            }

            public final Object next() {
                return e.nextElement();
            }

            public final void remove() {
            }
        }, out, beanFilter);
    }

    void convertDate(Date date, Writer out) throws UnconvertableException, IOException {
        if (this.writePrefixedDate) {
            out.write("\"$$DATE$$:");
            out.write(DataTools.fastDateFormat(date));
            out.write("\"");
        } else if (date instanceof ISCDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String dateArgs = "" + calendar.get(1) + ',' + calendar.get(2) + ',' + calendar.get(5);
            if (writeNativeDate) {
                out.write("new Date(" + dateArgs + ')');
            } else {
                out.write("Date.parseServerDate(" + dateArgs + ')');
            }
        } else {
            out.write("new Date(" + date.getTime() + ')');
        }
    }

    void convertSqlClob(Clob clob, Writer out) throws UnconvertableException, IOException {
        try {
            this.convertString(clob.getSubString(1L, (int)clob.length()), out);
        }
        catch (SQLException se) {
            log.error((Object)"Error converting Clob", se);
            throw new UnconvertableException(se.toString());
        }
    }

    void convertString(String value, Writer out) throws UnconvertableException, IOException {
        out.write("\"");
        boolean substituting = false;
        int copiedFrom = 0;
        int length = value.length();
        int i = 0;
        while (i < length) {
            char quote = value.charAt(i);
            switch (quote) {
                case '<': {
                    if (this.quoteForXML) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("&lt;");
                        copiedFrom = i + 1;
                        break;
                    }
                    if (length <= i + 8 || value.charAt(i + 1) != '/') break;
                    if (!this.quoteForTextArea && value.regionMatches(true, i + 2, "script>", 0, 7)) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("<\\");
                        out.write(value.substring(i + 1, i + 9));
                        copiedFrom = i + 9;
                        i += 8;
                        break;
                    }
                    if (!this.quoteForTextArea || !value.regionMatches(true, i + 2, "textarea>", 0, 9)) break;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("<\\");
                    out.write(value.substring(i + 1, i + 11));
                    copiedFrom = i + 11;
                    i += 10;
                    break;
                }
                case '>': {
                    if (!this.quoteForXML) break;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("&gt;");
                    copiedFrom = i + 1;
                    break;
                }
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    switch (quote) {
                        case '\r': {
                            out.write("\\r");
                            break;
                        }
                        case '\n': {
                            out.write("\\n");
                            break;
                        }
                        case '\"': {
                            out.write("\\\"");
                            break;
                        }
                        case '\\': {
                            out.write("\\\\");
                            break;
                        }
                    }
                    copiedFrom = i + 1;
                    break;
                }
                case '&': {
                    if (this.quoteForXML) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("&amp;");
                        copiedFrom = i + 1;
                        break;
                    }
                    if (!this.quoteForTextArea || value.length() > i + 1 && " \n\r".indexOf(value.charAt(i + 1)) != -1) break;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("&amp;");
                    copiedFrom = i + 1;
                    break;
                }
            }
            ++i;
        }
        if (substituting) {
            out.write(value.substring(copiedFrom));
        } else {
            out.write(value);
        }
        out.write("\"");
    }

    public void toJSVariableInScript(Object javaObj, String variableName, Writer out) throws UnconvertableException, IOException {
        if (variableName == null) {
            return;
        }
        out.write("<SCRIPT>\n");
        this.toJSVariable(javaObj, variableName, out);
        out.write("</SCRIPT>\n");
    }

    public void toJSVariable(Object javaObj, String variableName, Writer out) throws UnconvertableException, IOException {
        if (variableName == null) {
            return;
        }
        out.write("var " + variableName + " = ");
        this.toJS(javaObj, out);
        out.write(";\n");
    }

    public Map fromJS(Map params) {
        SequencedHashMap result = new SequencedHashMap();
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)params.get(key);
            if (value == null || value.length() == 0 || value.equals("null")) continue;
            try {
                result.put(key, this.fromJS(value));
            }
            catch (UnconvertableException ue) {
                log.error("Value " + value + " for key " + key + " is unconvertable, ignoring.");
            }
        }
        return result;
    }

    public Object fromJS(String jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        return this.fromJS(new StringReader(jsData));
    }

    public Object fromJS(InputStream jsData) throws UnconvertableException {
        return this.fromJS(new InputStreamReader(jsData));
    }

    public Object fromJS(Reader jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        try {
            IJSParser parser = (IJSParser)InterfaceProvider.load("IJSParser");
            return parser.parseDataStruct(this.getEOFReader(jsData));
        }
        catch (Exception pe) {
            String error = "parse failure: \n" + pe.toString();
            log.error(error);
            throw new UnconvertableException(error);
        }
    }

    public Object fromJSMap(String jsData) throws UnconvertableException {
        return this.fromJSMap(new StringReader(jsData));
    }

    public Object fromJSMap(InputStream jsData) throws UnconvertableException {
        return this.fromJSMap(new InputStreamReader(jsData));
    }

    public Object fromJSMap(Reader jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        try {
            IJSParser parser = (IJSParser)InterfaceProvider.load("IJSParser");
            return parser.parseDataMap(this.getEOFReader(jsData));
        }
        catch (Exception pe) {
            String error = "parse failure: \n" + pe.toString();
            log.error((Object)error, pe);
            throw new UnconvertableException(error);
        }
    }

    private final Reader getEOFReader(Reader in) throws IOException {
        return new SequenceReader(in, "//>START PARSING\n");
    }

    public static boolean isValidJSIdentifier(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        int length = str.length();
        if (!JSTranslater.isJSIdentifierStart(c)) {
            return false;
        }
        int i = 1;
        while (i < length) {
            c = str.charAt(i);
            if (!JSTranslater.isJSIdentifierPart(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJSIdentifierPart(char c) {
        return JSTranslater.isJSIdentifierStart(c) || Character.isDigit(c);
    }

    public static boolean isJSIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    public static boolean isJSReservedWord(String s) {
        return reservedWords.contains(s);
    }

    public String getEnumTranslateStrategy() {
        return this.enumTranslateStrategy;
    }

    public void setEnumTranslateStrategy(String newValue) {
        if (newValue != null) {
            this.enumTranslateStrategy = newValue;
        }
    }

    public String getEnumOrdinalProperty() {
        return this.ordinalProperty;
    }

    public String getEnumConstantProperty() {
        return this.enumTranslateStrategy;
    }

    public void setEnumOrdinalProperty(String newValue) {
        if (newValue != null) {
            this.ordinalProperty = newValue;
        }
    }

    public void setEnumConstantProperty(String newValue) {
        if (newValue != null) {
            this.constantProperty = newValue;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.writePrefixedDate = false;
        this.obfuscateMapKeys = config.getSubtree("map.obfuscateKeys");
        this.enumTranslateStrategy = DEFAULT_ENUM_TRANSLATE_STRATEGY;
        this.constantProperty = DEFAULT_ENUM_CONSTANT_PROPERTY;
        this.ordinalProperty = DEFAULT_ENUM_ORDINAL_PROPERTY;
        this.prettyPrinting = globalPrettyPrinting;
        this.omitNullMapValues = globalOmitNullMapValues;
        this.calendar = null;
        this.currentIndentDepth = 0;
        this.alwaysToString = false;
        this.propNameIndent = 0;
        this.path = "";
        this.quoteForXML = false;
        this.quoteForTextArea = false;
        this.validationContext = null;
        this.useSchema = true;
        this.recursionCount = 0;
    }

    public JSTranslater() {
        this.this();
    }

    static {
        Class clazz = class$com$isomorphic$js$JSTranslater;
        if (clazz == null) {
            clazz = class$com$isomorphic$js$JSTranslater = JSTranslater.class("[Lcom.isomorphic.js.JSTranslater;", false);
        }
        log = new Logger(clazz.getName());
        globalPrettyPrinting = config.getBoolean((Object)"jsTranslater.prettyPrint", false);
        collapseSmallContainers = config.getBoolean((Object)"jsTranslater.prettyPrint.collapseSmallContainers", false);
        globalOmitNullMapValues = config.getBoolean((Object)"jsTranslater.omitNullMapValues", false);
        writeNativeDate = config.getBoolean((Object)"jsTranslater.writeNativeDate", false);
        regex = new Perl5Util();
        dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateTimeFormat = new SimpleDateFormat(DATETIME_FORMAT);
        EMPTY_ARRAY = new Object[0];
        types = new HashMap();
        safeToString = new HashSet();
        sendAsJSString = new HashSet();
        sendAsJSString.addAll(Arrays.asList("java.net.URL", "java.net.URI"));
        reservedWords = new HashSet();
        reservedWords.addAll(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with", "debugger", "undefined"));
    }
}

