/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.js.JSSyntaxScanner;
import com.isomorphic.js.TrailingCommaException;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JSSyntaxScannerFilter
extends BaseFilter {
    Map ignoreList;
    public boolean scanAssembledFiles;
    public List scannableMimeTypes;
    public boolean sendErrorsToBrowser;
    private String isomorphicURI;
    private String modulesURI;
    private String devModulesURI;
    private boolean devenv;

    public void setScanAssembledFiles(String value) {
        this.scanAssembledFiles = Boolean.valueOf(value);
    }

    public void setScannableMimeTypes(String value) {
        List list = DataTools.commaSeparatedStringToList(value);
        this.scannableMimeTypes = new ArrayList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mimeType = i.next().toString().toLowerCase();
            if (mimeType.equals("")) continue;
            this.scannableMimeTypes.add(mimeType);
        }
    }

    public void setSendErrorsToBrowser(String value) {
        this.sendErrorsToBrowser = Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            if (!this.scanAssembledFiles) {
                JSSyntaxScannerFilter jSSyntaxScannerFilter = this;
                synchronized (jSSyntaxScannerFilter) {
                    block10: {
                        if (this.ignoreList == null) {
                            this.ignoreList = new HashMap();
                        }
                        if (!InterfaceProvider.exists("IAssembly")) break block10;
                        try {
                            IAssembly assembly = (IAssembly)InterfaceProvider.load("IAssembly");
                            Iterator i = assembly.getRegisteredURLs().iterator();
                            while (i.hasNext()) {
                                this.ignoreList.put(i.next(), "URL is registered with the FileAssembler");
                            }
                        }
                        catch (Exception e) {
                            this.log.info("Couldn't load list of FileAssembler URLs - if the filter intercepts those URLs, they will be scanned.");
                        }
                    }
                    this.log.debug("Ignore list: " + DataTools.prettyPrint(this.ignoreList));
                }
            }
            this.isomorphicURI = "/" + config.getPath("isomorphicPathRootRelative");
            this.modulesURI = config.getPath("modulesURI");
            this.devModulesURI = config.getPath("devModulesURI");
            this.devenv = config.getBoolean((Object)"devenv", false);
            return;
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize JSSyntaxScannerFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    private final boolean mimeTypeIsScannable(String mimeType) {
        if (mimeType == null || this.scannableMimeTypes == null) {
            return false;
        }
        mimeType = mimeType.toLowerCase();
        Iterator i = this.scannableMimeTypes.iterator();
        while (i.hasNext()) {
            String scannableMimeType = (String)i.next();
            if (mimeType.indexOf(scannableMimeType) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        block43: {
            block41: {
                block40: {
                    request = (HttpServletRequest)req;
                    response = (HttpServletResponse)res;
                    context = null;
                    try {
                        try {
                            block42: {
                                context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
                                logPrefix = context.requestPath + ": ";
                                requestURI = ServletTools.getCanonicalRequestURI((HttpServletRequest)context.request);
                                scan = true;
                                if (!ServletTools.compressionWorksForContext(context, this.log)) {
                                    scan = false;
                                }
                                mimeType = ServletTools.mimeTypeForContext(context);
                                if (scan && mimeType != null && !this.mimeTypeIsScannable(mimeType)) {
                                    scan = false;
                                    this.log.debug(logPrefix + "ignoring non-scannable mimeType: " + mimeType + ", not bufferring");
                                }
                                if (this.ignoreList != null && (ignoreReason = (String)this.ignoreList.get(requestURI)) != null) {
                                    scan = false;
                                    this.log.debug(logPrefix + "not scanning URI: " + requestURI + " because: " + ignoreReason);
                                }
                                if (scan) {
                                    if (this.devenv) {
                                        if (requestURI.startsWith(this.modulesURI) || requestURI.startsWith(this.devModulesURI)) {
                                            scan = false;
                                        }
                                    } else if (requestURI.startsWith(this.isomorphicURI)) {
                                        scan = false;
                                    }
                                }
                                if (!scan) {
                                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                    var8_15 = null;
                                    break block40;
                                }
                                wrapBuf = new ByteArrayOutputStream();
                                wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), "JSSyntaxScannerFilter");
                                chain.doFilter((ServletRequest)request, (ServletResponse)wrapResponse);
                                wrapResponse.flushBuffer();
                                if (wrapResponse.dontCopyStreams) {
                                    this.log.debug(logPrefix + "WrapResponse dictates no stream - not scanning.");
                                    break block41;
                                }
                                if (response.containsHeader("Content-Encoding")) {
                                    scan = false;
                                    this.log.debug(logPrefix + "Content-Encoding was set by filtered content - not scanning");
                                }
                                if ((wrapMimeType = wrapResponse.iscGetContentType()) != null) {
                                    mimeType = wrapMimeType;
                                }
                                if (scan && !this.mimeTypeIsScannable(mimeType)) {
                                    scan = false;
                                    this.log.debug(logPrefix + "ignoring non-scannable mimeType: " + mimeType);
                                }
                                doSendErrorsToBrowser = this.sendErrorsToBrowser;
                                errors = null;
                                if (scan) {
                                    scanner = JSSyntaxScanner.instance();
                                    try {
                                        if (mimeType.indexOf("text/html") != -1) {
                                            fileName = requestURI;
                                            if (requestURI.toLowerCase().endsWith(".jsp")) {
                                                fileName = fileName + " (line numbers refer to result of jsp execution, considering only JS script blocks)";
                                            }
                                            this.log.info(logPrefix + "scanning <script> tags in html output");
                                            scanner.scanHTML(wrapBuf.toString(), fileName);
                                            break block42;
                                        } else {
                                            doSendErrorsToBrowser = false;
                                            this.log.info(logPrefix + "scanning js source");
                                            scanner.scanJS(wrapBuf.toString(), requestURI);
                                        }
                                        break block42;
                                    }
                                    catch (TrailingCommaException tce) {
                                        errors = tce.toString();
                                        this.log.error(tce);
                                        source = IOUtil.inputStreamToString(this.servletContext.getResourceAsStream(requestURI));
                                        if (source == null) {
                                            source = wrapBuf.toString();
                                        }
                                        reader = new LineNumberReader(new StringReader(source));
                                        commaLine = tce.commaLine;
                                        foundMatch = false;
                                    }
                                    while (true) {
                                        if ((line = reader.readLine()) == null) {
                                            if (!foundMatch) {
                                                commaLine = commaLine.trim();
                                                break;
                                            }
                                            break block42;
                                        }
                                        if (!line.startsWith(commaLine)) continue;
                                        foundMatch = true;
                                        errorLocation = "possible source of last error: " + requestURI + ", line: " + reader.getLineNumber() + " - line reads:\n" + line;
                                        errors = errors + '\n' + errorLocation;
                                        this.log.error(errorLocation);
                                    }
                                    while ((line = reader.readLine()) != null) {
                                        if (line.indexOf(commaLine) == -1) continue;
                                        errorLocation = "possible source of last error: " + requestURI + ", line: " + reader.getLineNumber() + " - line reads:\n" + line;
                                        errors = errors + '\n' + errorLocation;
                                        this.log.error(errorLocation);
                                    }
                                }
                            }
                            if (errors != null && doSendErrorsToBrowser) {
                                context.out().write("<HTML><BODY><B><U>JSSyntaxScannerFilter Error Report:</U></B><P><PRE>");
                                context.out().write(errors);
                                context.out().write("</PRE></BODY></HTML>");
                                break block43;
                            } else {
                                out = response.getOutputStream();
                                wrapBuf.writeTo((OutputStream)out);
                                try {
                                    out.flush();
                                }
                                catch (Exception ignored) {}
                            }
                            break block43;
                        }
                        catch (ServletException se) {
                            throw se;
                        }
                        catch (IOException ioe) {
                            throw ioe;
                        }
                        catch (Exception e) {
                            this.log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + '\n' + DataTools.getStackTrace(e));
                            break block43;
                        }
                    }
                    catch (Throwable var7_37) {
                        var8_17 = null;
                        try {
                            response.flushBuffer();
                            throw var7_37;
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        throw var7_37;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [14 : 1100->1110)] { 
lbl121:
                // 1 sources

                response.flushBuffer();
                return;
lbl123:
                // 1 sources

                catch (Exception ignored) {
                    // empty catch block
                }
                return;
            }
            var8_16 = null;
            ** try [egrp 4[TRYBLOCK] [14 : 1100->1110)] { 
lbl129:
            // 1 sources

            response.flushBuffer();
            return;
lbl131:
            // 1 sources

            catch (Exception ignored) {
                // empty catch block
            }
            return;
        }
        var8_18 = null;
        try {}
        catch (Exception ignored) {
            return;
        }
        response.flushBuffer();
    }

    private final /* synthetic */ void this() {
        this.scanAssembledFiles = false;
        this.scannableMimeTypes = null;
        this.sendErrorsToBrowser = true;
    }

    public JSSyntaxScannerFilter() {
        this.this();
    }
}

