/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.base.Base;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.TrailingCommaException;
import com.isomorphic.log.Logger;
import isc.org.apache.oro.text.perl.Perl5Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JSSyntaxScanner
extends Base {
    private static Logger log;
    static /* synthetic */ Class class$com$isomorphic$js$JSSyntaxScanner;

    public static JSSyntaxScanner instance() {
        return new JSSyntaxScanner();
    }

    public void scanHTML(String buf, String fileName) throws Exception {
        Perl5Util regex = new Perl5Util();
        if (buf == null) {
            return;
        }
        int length = buf.length();
        int startIndex = 0;
        boolean inScript = false;
        int line = 1;
        int lineChar = 0;
        int i = 0;
        while (i < length) {
            char theChar = buf.charAt(i);
            ++lineChar;
            switch (theChar) {
                case '\n': 
                case '\r': {
                    ++line;
                    lineChar = 0;
                    break;
                }
                case '<': {
                    if (length > i + 8 && buf.regionMatches(true, i + 1, "/script>", 0, 8)) {
                        if (!inScript) break;
                        if (startIndex != i) {
                            this.scanJS(buf.substring(startIndex, i), fileName);
                        }
                        i += 8;
                        lineChar += 8;
                        inScript = false;
                        break;
                    }
                    if (length <= i + 6 || !buf.regionMatches(true, i + 1, "script", 0, 6)) break;
                    boolean jsBlock = false;
                    int closeIndex = buf.indexOf(">", i + 7);
                    if (buf.charAt(i + 7) == '>') {
                        jsBlock = true;
                    } else {
                        if (closeIndex == -1) {
                            throw new Exception("Script block with missing rightbracket at line: " + line);
                        }
                        String sub = buf.substring(i + 7, closeIndex + 1);
                        jsBlock = true;
                        if (regex.match("m#(language|type)=#i", sub) && !regex.match("m#(language|type)=.*(javascript|ecmascript|jscript)#i", sub)) {
                            jsBlock = false;
                        }
                    }
                    if (!jsBlock) break;
                    inScript = true;
                    lineChar = closeIndex - i;
                    i = closeIndex;
                    startIndex = i + 1;
                    break;
                }
            }
            ++i;
        }
    }

    public void scanJS(String buffer, String fileName) throws Exception {
        if (buffer == null) {
            return;
        }
        int length = buffer.length();
        boolean haveComma = false;
        int commaCharPos = 0;
        int pos = 0;
        int TT_EOL = -1;
        int TT_COMMENT = -2;
        int TT_STRING = -3;
        int TT_NUMBER = -4;
        int TT_WORD = -5;
        int TT_REGEX = -6;
        int lastToken = TT_EOL;
        char lastQuote = '\u0000';
        boolean stringPlus = false;
        while (pos < buffer.length()) {
            if (lastToken != 43) {
                stringPlus = false;
            }
            char theChar = buffer.charAt(pos);
            switch (theChar) {
                case '\"': 
                case '\'': {
                    int end = JSSyntaxScanner.matchString(buffer, pos);
                    stringPlus = false;
                    pos = end;
                    lastToken = TT_STRING;
                    lastQuote = theChar;
                    haveComma = false;
                    break;
                }
                case ',': {
                    haveComma = true;
                    commaCharPos = pos++;
                    break;
                }
                case '\t': 
                case ' ': {
                    ++pos;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    lastToken = TT_NUMBER;
                    ++pos;
                    haveComma = false;
                    break;
                }
                case '\n': 
                case '\r': {
                    ++pos;
                    lastToken = TT_EOL;
                    break;
                }
                case '+': {
                    if (lastToken == TT_STRING) {
                        stringPlus = true;
                    }
                    lastToken = theChar;
                    haveComma = false;
                    ++pos;
                    break;
                }
                case '/': {
                    int end;
                    if (buffer.charAt(pos + 1) == '/') {
                        pos = end = JSSyntaxScanner.findEOL(buffer, pos + 2);
                        lastToken = TT_EOL;
                        break;
                    }
                    if (buffer.charAt(pos + 1) == '*') {
                        pos = end = buffer.indexOf("*/", pos + 2) + 2;
                        break;
                    }
                    haveComma = false;
                    if (lastToken == TT_WORD || lastToken == TT_NUMBER || lastToken == 41) {
                        ++pos;
                        break;
                    }
                    pos = end = JSSyntaxScanner.matchString(buffer, pos);
                    lastToken = TT_REGEX;
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierStart(theChar)) {
                        String id = JSSyntaxScanner.grabIdentifier(buffer, pos);
                        lastToken = TT_WORD;
                        pos += id.length();
                        haveComma = false;
                        break;
                    }
                    if ((theChar == '}' || theChar == ']') && haveComma) {
                        throw new TrailingCommaException(buffer, fileName, theChar, commaCharPos);
                    }
                    lastToken = theChar;
                    ++pos;
                    haveComma = false;
                }
            }
        }
    }

    public static int matchString(String text, int startPos) {
        char quoteChar = text.charAt(startPos++);
        while (startPos < text.length()) {
            char theChar = text.charAt(startPos);
            if (theChar == quoteChar) {
                return startPos + 1;
            }
            if (theChar == '\\') {
                ++startPos;
            }
            ++startPos;
        }
        return text.length();
    }

    public static int findEOL(String text, int startPos) {
        int pos = startPos;
        while (pos < text.length()) {
            char theChar = text.charAt(pos);
            if (theChar == '\r' || theChar == '\n') {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    public static String grabIdentifier(String text, int startPos) throws Exception {
        char theChar = text.charAt(startPos);
        if (!JSTranslater.isJSIdentifierStart(theChar)) {
            throw new Exception("not at the start of an identifier");
        }
        int endPos = startPos;
        while (endPos++ < text.length()) {
            theChar = text.charAt(endPos);
            if (!JSTranslater.isJSIdentifierPart(theChar)) break;
        }
        return text.substring(startPos, endPos);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$js$JSSyntaxScanner;
        if (clazz == null) {
            clazz = class$com$isomorphic$js$JSSyntaxScanner = JSSyntaxScanner.class("[Lcom.isomorphic.js.JSSyntaxScanner;", false);
        }
        log = new Logger(clazz.getName());
    }
}

