/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import isc.org.apache.oro.text.GlobCompiler;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.VFS;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ISCFile {
    private static Logger log;
    public static ServletContext servletContext;
    public static final String CONTAINER_IO_PREFIX = "__USE_CONTAINER__";
    static final int CONTAINER_IO_PREFIX_LENGTH;
    String canonicalPath;
    String filename;
    URL url;
    File file;
    FileObject fileObject;
    static /* synthetic */ Class class$com$isomorphic$io$ISCFile;

    public boolean delete() throws IOException {
        if (this.file != null) {
            return this.file.delete();
        }
        if (this.fileObject != null) {
            return this.fileObject.delete();
        }
        throw new IOException("delete() operation not supported for filename: " + this.filename);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() throws IOException {
        block14: {
            if (this.file != null) {
                return DataTools.caseSensitiveFileExists(this.filename, this.file);
            }
            if (this.fileObject != null) {
                return this.fileObject.exists();
            }
            if (this.url == null) {
                return false;
            }
            is = null;
            try {
                try {
                    is = this.getInputStream();
                    if (is != null) {
                        var4_2 = true;
                        var3_3 = null;
                        break block14;
                    }
                    ** GOTO lbl-1000
                }
                catch (IOException ioe) {
                    ** GOTO lbl-1000
                }
            }
            catch (Throwable var2_10) {
                var3_4 = null;
                try {
                    if (is == null) throw var2_10;
                    is.close();
                    throw var2_10;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw var2_10;
            }
        }
        try {}
        catch (Exception ignored) {
            // empty catch block
            return var4_2;
        }
        if (is == null) return var4_2;
        is.close();
        return var4_2;
lbl-1000:
        // 2 sources

        {
            var3_5 = null;
        }
        try {}
        catch (Exception ignored) {
            return false;
        }
        if (is == null) return false;
        is.close();
        return false;
    }

    public String getParent() {
        if (this.fileObject != null) {
            try {
                return this.fileObject.getParent().getName().getURI();
            }
            catch (Exception e) {
                return null;
            }
        }
        return new File(this.filename).getParent();
    }

    public String getCanonicalPath() throws IOException {
        if (this.canonicalPath == null) {
            if (this.file != null) {
                this.canonicalPath = this.file.getCanonicalPath();
            } else if (this.url != null) {
                this.canonicalPath = this.url.toExternalForm();
            }
        }
        if (this.canonicalPath != null) {
            return this.canonicalPath;
        }
        return this.filename;
    }

    public boolean canRead() throws IOException {
        if (this.file != null) {
            return this.file.canRead();
        }
        if (this.fileObject != null) {
            return this.fileObject.isReadable();
        }
        return this.url != null;
    }

    public boolean canWrite() throws IOException {
        if (this.file != null) {
            return this.file.canWrite();
        }
        if (this.fileObject != null) {
            return this.fileObject.isWriteable();
        }
        return false;
    }

    public boolean mkdir() throws IOException {
        if (this.file != null) {
            return this.file.mkdir();
        }
        if (this.fileObject != null) {
            try {
                this.fileObject.createFolder();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IOException("mkdir() not supported for filename: " + this.filename);
    }

    public boolean mkdirs() throws IOException {
        if (this.file != null) {
            return this.file.mkdirs();
        }
        if (this.fileObject != null) {
            try {
                this.fileObject.createFolder();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IOException("mkdirs() not supported for filename: " + this.filename);
    }

    public String getPath() throws IOException {
        return this.getCanonicalPath();
    }

    public String getName() throws IOException {
        String name = ISCFile.canonicalizePath(this.getPath());
        int slashIndex = name.lastIndexOf("/");
        if (slashIndex != -1) {
            name = name.substring(slashIndex + 1);
        }
        return name;
    }

    public Object getNativeHandler() {
        if (this.file != null) {
            return this.file;
        }
        if (this.fileObject != null) {
            return this.fileObject;
        }
        return this.url;
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public String getAsString() throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(this.getReader(), sw);
        return sw.toString();
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.fileObject != null) {
            return this.fileObject.getContent().getInputStream();
        }
        return this.url.openConnection().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.file != null) {
            return new FileOutputStream(this.file);
        }
        if (this.fileObject != null) {
            return this.fileObject.getContent().getOutputStream();
        }
        throw new IOException("getOutputStream not supported for filename: " + this.filename);
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public long length() throws IOException {
        if (!this.exists()) {
            return 0L;
        }
        if (this.file != null) {
            return this.file.length();
        }
        if (this.fileObject != null) {
            return this.fileObject.getContent().getSize();
        }
        return this.url.openConnection().getContentLength();
    }

    public long lastModified() throws IOException {
        if (this.file != null) {
            return this.file.lastModified();
        }
        if (this.fileObject != null) {
            if (this.exists()) {
                long lastModified = this.fileObject.getContent().getLastModifiedTime();
                lastModified = (long)Math.floor(lastModified / 1000L) * 1000L;
                return lastModified;
            }
            return 0L;
        }
        return this.url.openConnection().getLastModified();
    }

    public static boolean isContainerIOPath(String path) {
        if (path == null) {
            return false;
        }
        boolean bl = false;
        if (path.indexOf(CONTAINER_IO_PREFIX) != -1) {
            bl = true;
        }
        return bl;
    }

    public static String stripContainerIOPrefix(String path) {
        int containerIOIndex = path.indexOf(CONTAINER_IO_PREFIX);
        if (containerIOIndex != -1) {
            path = path.substring(containerIOIndex + CONTAINER_IO_PREFIX_LENGTH);
        }
        return path;
    }

    public static String canonicalizePath(String path) {
        char lastChar;
        if (path == null) {
            return null;
        }
        path = path.trim();
        StringWriter sw = new StringWriter();
        int copiedFrom = 0;
        int length = path.length();
        int ii = 0;
        while (ii < length) {
            char currChar = path.charAt(ii);
            if (currChar == '\\' || currChar == '/') {
                sw.write(path.substring(copiedFrom, ii));
                sw.write(47);
                while (ii + 1 < length) {
                    char nextChar = path.charAt(ii + 1);
                    if (nextChar != '/' && nextChar != '\\') break;
                    if (ii - 1 >= 0 && path.charAt(ii - 1) == ':') {
                        sw.write(47);
                    }
                    ++ii;
                }
                copiedFrom = ii + 1;
            }
            ++ii;
        }
        sw.write(path.substring(copiedFrom, length));
        path = sw.getBuffer().toString();
        length = path.length();
        if (length > 1 && ((lastChar = path.charAt(length - 1)) == '/' || lastChar == '\\')) {
            path = path.substring(0, length - 1);
        }
        return path;
    }

    public static boolean inContainerIOMode() {
        Config config = Config.getGlobal();
        return ISCFile.isContainerIOPath(config.getPath("webRoot"));
    }

    public static List list(String path) {
        if (servletContext != null) {
            Set files = null;
            files = servletContext.getResourcePaths(path);
            if (files == null) {
                return null;
            }
            return new ArrayList(files);
        }
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        String[] files = f.list();
        if (files == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            String fileName = ISCFile.canonicalizePath(path + '/' + file);
            File x = new File(fileName);
            if (x.isDirectory()) {
                results.add(fileName + '/');
            } else {
                results.add(fileName);
            }
            ++i;
        }
        return results;
    }

    public static List list(String path, String regex) {
        Set files = servletContext.getResourcePaths(path);
        if (files == null) {
            return null;
        }
        if (!regex.startsWith("/") || !regex.endsWith("/")) {
            regex = "/" + regex + '/';
        }
        Perl5Util perl5 = new Perl5Util();
        ArrayList<String> matchingFiles = new ArrayList<String>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            String file = (String)i.next();
            if (!perl5.match(regex, file)) continue;
            matchingFiles.add(file);
        }
        return matchingFiles;
    }

    public static List find(String basePath, boolean recurse, String glob) {
        String regex = GlobCompiler.globToPerl5((char[])glob.toCharArray(), (int)0);
        regex = "^" + regex + "(\\/)?$";
        return ISCFile.ffind(basePath, recurse, regex);
    }

    public static List ffind(String basePath, boolean recurse, String regex) {
        if (basePath == null) {
            return null;
        }
        List filesAtBasePath = ISCFile.list(basePath);
        if (filesAtBasePath == null) {
            return null;
        }
        if (!regex.startsWith("/") || !regex.endsWith("/")) {
            regex = "/" + regex + '/';
        }
        ArrayList<String> matchingFiles = new ArrayList<String>();
        Perl5Util perl5 = new Perl5Util();
        Iterator i = filesAtBasePath.iterator();
        while (i.hasNext()) {
            List matchingFilesInDir;
            String path = (String)i.next();
            if (recurse && ISCFile.isDirectory(path) && (matchingFilesInDir = ISCFile.ffind(path, true, regex)) != null) {
                matchingFiles.addAll(matchingFilesInDir);
            }
            if (!perl5.match(regex, path)) continue;
            matchingFiles.add(path);
        }
        return matchingFiles;
    }

    public boolean isDirectory() throws IOException {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.fileObject != null) {
            return this.fileObject.getType().hasChildren();
        }
        return this.filename.endsWith("/");
    }

    public static boolean isDirectory(String path) {
        return path.endsWith("/");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ISCFile(URL url) {
        this.url = url;
    }

    public ISCFile(File file) {
        this.file = file;
    }

    public ISCFile(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public ISCFile(String filename) throws IOException {
        this.filename = filename;
        if (filename.startsWith("ram://") || filename.startsWith("res://")) {
            this.fileObject = VFS.getManager().resolveFile(filename);
        } else if (ISCFile.isContainerIOPath(filename)) {
            filename = ISCFile.canonicalizePath(ISCFile.stripContainerIOPrefix(filename));
            if (servletContext == null) {
                log.error("Configured for containerIO, but servletContext not available!");
            }
            if (!filename.startsWith("/")) {
                filename = "/" + filename;
            }
            this.url = servletContext.getResource(filename);
        } else {
            if (filename.startsWith("file:")) {
                filename = filename.substring("file:".length());
            }
            if (DataTools.isURI(filename)) {
                this.url = new URL(filename);
            } else {
                this.file = new File(ISCFile.canonicalizePath(filename));
            }
        }
    }

    static {
        Class clazz = class$com$isomorphic$io$ISCFile;
        if (clazz == null) {
            clazz = class$com$isomorphic$io$ISCFile = ISCFile.class("[Lcom.isomorphic.io.ISCFile;", false);
        }
        log = new Logger(clazz.getName());
        servletContext = null;
        CONTAINER_IO_PREFIX_LENGTH = CONTAINER_IO_PREFIX.length();
    }
}

