/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.xml.XML;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValidationContext
extends HashMap {
    static Logger log;
    public static int typeLookupTime;
    boolean propertiesOnly;
    boolean useSchema;
    String path;
    String fieldName;
    Element currentElement;
    Map errors;
    Map typeCache;
    final Object MARKER;
    static /* synthetic */ Class class$com$isomorphic$datasource$ValidationContext;

    public boolean isPropertiesOnly() {
        return this.propertiesOnly;
    }

    public void setPropertiesOnly() {
        this.setPropertiesOnly(true);
    }

    public void setPropertiesOnly(boolean value) {
        this.propertiesOnly = value;
    }

    public void setUseSchema() {
        this.setUseSchema(true);
    }

    public void setUseSchema(boolean value) {
        this.useSchema = value;
    }

    public String getPath() {
        return this.path;
    }

    public void addPath(String segment) {
        this.path = this.path + '/' + segment;
        this.fieldName = segment;
    }

    public void removePathSegment() {
        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
        this.fieldName = this.path.substring(this.path.lastIndexOf("/") + 1, this.path.length());
    }

    public void setCurrentElement(Element element) {
        this.currentElement = element;
    }

    public Map getErrors() {
        return this.errors;
    }

    public void addError(Object newErrors) {
        this.addError(this.fieldName, newErrors);
    }

    public void addError(String fieldName, Object newErrors) {
        if (newErrors == null) {
            return;
        }
        if (this.errors == null) {
            this.errors = new HashMap();
        }
        log.debug("Adding validation errors at path '" + this.path + "': " + newErrors);
        String recordPath = this.getCurrentRecordPath(fieldName);
        ErrorReport report = (ErrorReport)this.errors.get(recordPath);
        if (report == null) {
            report = new ErrorReport();
            report.put("recordPath", recordPath);
            if (this.currentElement != null) {
                report.put("xpath", XML.getXPath(this.currentElement));
            }
            this.errors.put(recordPath, report);
        }
        DataTools.putCombinedList((Map)((Object)report), fieldName, newErrors);
    }

    public boolean hasErrors() {
        boolean bl = false;
        if (this.errors != null) {
            bl = true;
        }
        return bl;
    }

    public void clearErrors() {
        this.errors = null;
    }

    public String getCurrentRecordPath(String fieldName) {
        String recordPath = this.path;
        if (fieldName != null && recordPath.endsWith("/" + fieldName)) {
            recordPath = recordPath.substring(0, recordPath.lastIndexOf("/"));
        }
        return recordPath;
    }

    public ErrorReport getCurrentErrorReport() {
        if (this.errors == null) {
            return null;
        }
        return (ErrorReport)this.errors.get(this.getCurrentRecordPath(null));
    }

    public BasicDataSource getType(String typeName) throws Exception {
        if (typeName == null || "".equals(typeName)) {
            return null;
        }
        if (!this.useSchema && !"Object".equals(typeName)) {
            return null;
        }
        if (this.typeCache.get(typeName) != null) {
            return null;
        }
        long start = System.currentTimeMillis();
        BasicDataSource ds = (BasicDataSource)DataSourceManager.getDataSource(typeName);
        long end = System.currentTimeMillis();
        typeLookupTime = (int)((long)typeLookupTime + (end - start));
        if (ds == null) {
            this.typeCache.put(typeName, this.MARKER);
        }
        return ds;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.propertiesOnly = false;
        this.useSchema = true;
        this.path = "";
        this.fieldName = "";
        this.currentElement = null;
        this.errors = null;
        this.typeCache = new HashMap();
        this.MARKER = new Object();
    }

    public ValidationContext() {
        this.this();
    }

    static {
        Class clazz = class$com$isomorphic$datasource$ValidationContext;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$ValidationContext = ValidationContext.class("[Lcom.isomorphic.datasource.ValidationContext;", false);
        }
        log = new Logger(clazz.getName());
    }
}

