/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCKeyedPoolableObjectFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoolableDataSourceFactory
extends ISCKeyedPoolableObjectFactory {
    private static Logger log;
    private static Config config;
    private static List nonWebDemosDataSources;
    private static boolean wwwProduction;
    private boolean enableUpToDateCheck;
    static /* synthetic */ Class class$com$isomorphic$datasource$PoolableDataSourceFactory;

    public IPoolableObjectFactory newInstance(Object key) throws Exception {
        return new PoolableDataSourceFactory();
    }

    public void activateObject(Object key, Object obj) throws Exception {
        ++this.numActivateObjectCalls;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        ++this.numDestroyObjectCalls;
        ((DataSource)obj).clearState();
    }

    public Object makeUnpooledObject(Object key) throws Exception {
        return DataSource.forName(key.toString());
    }

    public Object makeObject(Object key) throws Exception {
        ++this.numMakeObjectCalls;
        return this.makeUnpooledObject(key);
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        ++this.numPassivateObjectCalls;
        ((DataSource)obj).clearState();
    }

    public boolean validateObject(Object key, Object obj) {
        ++this.numValidateObjectCalls;
        if (obj == null) {
            return true;
        }
        DataSource ds = (DataSource)obj;
        String dsName = ds.getName();
        if (wwwProduction && !nonWebDemosDataSources.contains(dsName)) {
            return false;
        }
        if (this.enableUpToDateCheck) {
            boolean isStale = ds.isStale();
            if (isStale) {
                log.debug("Discarding stale DataSource of type '" + key.toString() + '\'');
            }
            return isStale ^ true;
        }
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.enableUpToDateCheck = false;
    }

    PoolableDataSourceFactory() {
        this.this();
        boolean globalCheckEnabled = config.getBoolean((Object)"datasources.enableUpToDateCheck", false);
        Boolean thisCheckEnabled = config.getBoolean((Object)"datasources.enableUpToDateCheck", null);
        boolean bl = false;
        if (thisCheckEnabled != null && thisCheckEnabled.booleanValue() || thisCheckEnabled == null && globalCheckEnabled) {
            bl = true;
        }
        this.enableUpToDateCheck = bl;
    }

    static {
        Class clazz = class$com$isomorphic$datasource$PoolableDataSourceFactory;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$PoolableDataSourceFactory = PoolableDataSourceFactory.class("[Lcom.isomorphic.datasource.PoolableDataSourceFactory;", false);
        }
        log = new Logger(clazz.getName());
        config = Config.getGlobal();
        nonWebDemosDataSources = config.getList("nonWebDemosDataSources", new ArrayList());
        wwwProduction = config.getBoolean((Object)"wwwProduction", false);
    }
}

