/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FilesystemDataSource
extends BasicDataSource {
    private static Logger log;
    static /* synthetic */ Class class$com$isomorphic$datasource$FilesystemDataSource;

    public DSResponse execute(DSRequest req) throws Exception {
        String operationType = req.getOperationType();
        Map criteria = req.getCriteria();
        Map values = req.getValues();
        String webRoot = config.getPath("webRoot");
        if (FilesystemDataSource.isFetch(operationType)) {
            String regex;
            String path = (String)criteria.get("absolutePath");
            if (path == null) {
                path = (String)criteria.get("parentID");
            }
            boolean listSubTree = DataTools.getBoolean(criteria, "listSubTree");
            boolean webrootOnly = true;
            if (criteria.containsKey("webrootOnly")) {
                webrootOnly = DataTools.getBoolean(criteria, "webrootOnly");
            }
            if ((regex = (String)criteria.get("fileFilter")) == null) {
                regex = ".*";
            }
            log.debug("listing files at: " + path);
            if (listSubTree) {
                return this.listSubTree(req, path, regex);
            }
            List fileNames = webrootOnly ? (regex.equals(".*") ? ISCFile.list(path) : ISCFile.list(path, regex)) : Arrays.asList(new File(path).list());
            return FilesystemDataSource.responseForFileList(fileNames, webrootOnly);
        }
        if (FilesystemDataSource.isUpdate(operationType)) {
            String path = (String)criteria.get("path");
            File file = new File(ISCFile.canonicalizePath(webRoot + '/' + path));
            String newName = (String)values.get("name");
            String newPath = path.substring(0, path.indexOf("/"));
            File newFile = new File(ISCFile.canonicalizePath(webRoot + '/' + newPath + '/' + newName));
            log.debug("file rename: " + file.getCanonicalPath() + " to: " + newFile.getCanonicalPath());
            if (newFile.exists()) {
                throw new Exception("File named '" + newName + "' already exists.");
            }
            if (file.exists()) {
                file.renameTo(newFile);
            }
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setInvalidateCache(true);
            return dsResponse;
        }
        if (FilesystemDataSource.isRemove(operationType)) {
            String path = (String)criteria.get("path");
            File file = new File(ISCFile.canonicalizePath(webRoot + '/' + path));
            log.debug("file remove: " + file.getCanonicalPath());
            if (file.exists()) {
                DataTools.recursiveFileDelete(file);
            }
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setData(values);
            return dsResponse;
        }
        if (FilesystemDataSource.isAdd(operationType)) {
            String path = (String)values.get("path");
            String name = (String)values.get("name");
            String fullPath = ISCFile.canonicalizePath(webRoot + '/' + path + '/' + name);
            File file = new File(fullPath);
            log.debug("add: " + file.getCanonicalPath());
            if (file.exists()) {
                throw new Exception("File named '" + name + "' already exists.");
            }
            Boolean isFolder = (Boolean)values.get("isFolder");
            if (isFolder != null && isFolder.booleanValue()) {
                log.debug("dir add: " + file.getCanonicalPath());
                file.mkdirs();
            } else {
                log.debug("file add: " + file.getCanonicalPath());
                file.createNewFile();
            }
            DSResponse dsResponse = new DSResponse();
            dsResponse.setData(FilesystemDataSource.getFileValues(file));
            return dsResponse;
        }
        throw new Exception("Invalid operation: " + operationType);
    }

    public DSResponse listSubTree(DSRequest req, String basePath, String regex) throws Exception {
        List files = ISCFile.ffind(basePath, true, regex);
        return FilesystemDataSource.responseForFileList(files, true);
    }

    public static Map getFileValues(File file) throws Exception {
        HashMap<String, Object> fileInfo = new HashMap<String, Object>();
        String parent = file.getParent();
        fileInfo.put("parentID", parent.endsWith("/") ? parent : parent + '/');
        fileInfo.put("name", file.getName());
        fileInfo.put("path", file.getPath());
        fileInfo.put("size", new Long(file.length()));
        fileInfo.put("lastModified", new Long(file.lastModified()));
        fileInfo.put("isFolder", new Boolean(file.isDirectory()));
        return fileInfo;
    }

    public static DSResponse responseForFileList(List fileNames, boolean webrootRelative) throws Exception {
        String webRoot = config.getPath("webRoot");
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < fileNames.size()) {
            String path = (String)fileNames.get(i);
            Map<String, String> fileInfo = new HashMap();
            if (webrootRelative) {
                log.warn("using path: " + path);
                ISCFile file = new ISCFile(path);
                ISCFile absFile = new ISCFile(webRoot + path);
                String parent = file.getParent();
                if (parent.length() > 2 && parent.charAt(1) == ':') {
                    parent = parent.substring(2);
                }
                fileInfo.put("parentID", (parent = ISCFile.canonicalizePath(parent)).endsWith("/") ? parent : parent + '/');
                fileInfo.put("name", file.getName());
                fileInfo.put("path", path);
                fileInfo.put("size", (String)((Object)new Long(absFile.length())));
                fileInfo.put("lastModified", (String)((Object)new Long(absFile.lastModified())));
                fileInfo.put("isFolder", (String)((Object)new Boolean(ISCFile.isDirectory(path))));
            } else {
                fileInfo = FilesystemDataSource.getFileValues(new File(path));
            }
            fileInfo.put("mimeType", DataTools.mimeTypeForFileName(path));
            output.add(fileInfo);
            ++i;
        }
        DSResponse res = new DSResponse();
        res.setData(output);
        res.setStartRow(0L);
        res.setEndRow(output.size());
        res.setTotalRows(output.size());
        res.setSuccess();
        return res;
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        String fieldName = req.getDownloadFieldName();
        Map criteria = req.getCriteria();
        String path = (String)criteria.get("absolutePath");
        HashMap<String, Object> result = new HashMap<String, Object>();
        File file = new File(path);
        result.put(fieldName + "_filesize", new Long(file.length()));
        result.put(fieldName, new FileInputStream(file));
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setData(result);
        return dsResponse;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$datasource$FilesystemDataSource;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$FilesystemDataSource = FilesystemDataSource.class("[Lcom.isomorphic.datasource.FilesystemDataSource;", false);
        }
        log = new Logger(clazz.getName());
        if (!config.getBoolean((Object)"FilesystemDataSource.enabled", false)) {
            throw new Error("Attempt to instantiate FilesystemDataSource denied. Set FilesystemDataSource.enabled in config to turn it on");
        }
    }
}

