/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataSourceDMI {
    private static Logger log;
    private static Config config;
    DSRequest dsRequest;
    RPCManager rpc;
    RequestContext context;
    private List operationTypesNotRequiringExplicitBindings;
    static /* synthetic */ Class class$com$isomorphic$datasource$DataSourceDMI;
    static /* synthetic */ Class class$com$isomorphic$rpc$RPCManager;
    static /* synthetic */ Class class$com$isomorphic$datasource$DSRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;
    static /* synthetic */ Class class$com$isomorphic$servlet$RequestContext;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$com$isomorphic$datasource$DataSource;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$isomorphic$datasource$DSResponse;

    public static DSResponse execute(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        return new DataSourceDMI(dsRequest, rpc, context).execute();
    }

    public DSResponse execute() throws Exception {
        DSResponse validationFailure;
        this.dsRequest.setBeenThroughDMI(true);
        String dsName = this.dsRequest.getDataSourceName();
        if (dsName == null) {
            return null;
        }
        DataSource ds = this.dsRequest.getDataSource();
        if (ds == null) {
            return null;
        }
        String operationType = this.dsRequest.getOperationType();
        String operationId = this.dsRequest.getOperationId();
        boolean bl = false;
        if (operationId != null && operationId.equals(ds.getAutoOperationId(operationType))) {
            bl = true;
        }
        boolean operationIdIsAuto = bl;
        String operationBindingString = "operationBinding for DataSource: " + ds.getName() + " with operationType: " + operationType + (operationIdIsAuto || operationId == null ? "" : ", operationId: ") + operationId;
        Map operationBinding = ds.getOperationBinding(operationType, operationId);
        boolean bl2 = false;
        if (operationBinding != null) {
            bl2 = true;
        }
        boolean haveExplicitBinding = bl2;
        Map defaultServerObjectConfig = ds.getServerObjectConfig();
        if (!haveExplicitBinding && defaultServerObjectConfig == null) {
            return null;
        }
        if (!haveExplicitBinding) {
            if (this.explicitBindingNotRequired(operationType)) {
                operationBinding = DataTools.buildMap("operationType", operationType);
                if (operationId != null) {
                    operationBinding.put("operationId", operationId);
                }
            } else {
                throw new Exception("attempt to call unknown operationType: " + operationType);
            }
        }
        if ((validationFailure = ds.validateDSRequest(this.dsRequest)) != null) {
            return validationFailure;
        }
        Map serverObjectConfig = (Map)operationBinding.get("serverObject");
        if (serverObjectConfig == null) {
            serverObjectConfig = defaultServerObjectConfig;
        }
        boolean dropExtraFields = config.getBoolean((Object)"DMI.dropExtraFields", true);
        if (ds.dropExtraFieldsDefined()) {
            dropExtraFields = ds.dropExtraFields();
        }
        if (serverObjectConfig != null && serverObjectConfig.get("dropExtraFields") != null) {
            dropExtraFields = "true".equals(serverObjectConfig.get("dropExtraFields").toString().toLowerCase());
        }
        if (operationBinding.get("dropExtraFields") != null) {
            dropExtraFields = "true".equals(operationBinding.get("dropExtraFields").toString().toLowerCase());
        }
        String scriptArgs = (String)operationBinding.get("args");
        String scriptLanguage = (String)operationBinding.get("language");
        String script = (String)operationBinding.get("script");
        Class<?> returnValueClass = null;
        Object returnValue = null;
        if (script != null) {
            Map criteriaOrValues = this.dsRequest.getValues() == null ? this.dsRequest.getCriteria() : this.dsRequest.getValues();
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            if (this.context != null) {
                bindings.put("context", this.context);
                bindings.put("request", (Object)this.context.request);
                bindings.put("response", this.context.response);
                bindings.put("servletContext", this.context.servletContext);
                try {
                    ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                    if (beanFactory != null) {
                        bindings.put("beanFactory", beanFactory.getBeanFactory(this.context.servletContext));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (this.rpc != null) {
                bindings.put("rpc", this.rpc);
                bindings.put("rpcManager", this.rpc);
            }
            bindings.put("ds", ds);
            bindings.put("dataSource", ds);
            bindings.put("dsRequest", this.dsRequest);
            bindings.put("criteria", this.dsRequest.getCriteria());
            bindings.put("values", this.dsRequest.getValues());
            bindings.put("criteriaOrValues", criteriaOrValues);
            bindings.put("log", log);
            DataTypeMap params = new DataTypeMap();
            params.put("engineName", scriptLanguage);
            params.put("script", script);
            params.put("bindings", bindings);
            RPCResponse rpcResponse = BuiltinRPC.evalServerScript(params);
            Map result = (Map)rpcResponse.getData();
            returnValue = result.get("evalResult");
            returnValueClass = returnValue.getClass();
        } else {
            Map criteriaOrValues;
            if (haveExplicitBinding && serverObjectConfig == null) {
                if ("sql".equals(ds.getType())) {
                    if (operationBinding.containsKey("customSQL") || operationBinding.containsKey("selectClause") || operationBinding.containsKey("tableClause") || operationBinding.containsKey("whereClause") || operationBinding.containsKey("valuesClause") || operationBinding.containsKey("orderClause")) {
                        return null;
                    }
                    if (operationBinding.containsKey("criteria") || operationBinding.containsKey("values")) {
                        return null;
                    }
                    if (operationBinding.containsKey("exportResults")) {
                        return null;
                    }
                }
                if ("hibernate".equals(ds.getType()) && (operationBinding.containsKey("customSQL") || operationBinding.containsKey("customHQL"))) {
                    return null;
                }
            }
            if (serverObjectConfig == null) {
                throw new Exception("Can't find serverObject for " + operationBindingString + " - you must define a <serverObject> in the <operationBinding> or provide a default one at the same level as the <operationBindings> declaration.");
            }
            ReflectionArgument[] reflectionArgumentArray = new ReflectionArgument[2];
            Class clazz = class$com$isomorphic$rpc$RPCManager;
            if (clazz == null) {
                clazz = class$com$isomorphic$rpc$RPCManager = DataSourceDMI.class("[Lcom.isomorphic.rpc.RPCManager;", false);
            }
            reflectionArgumentArray[0] = new ReflectionArgument(clazz, this.rpc, false, false);
            Class clazz2 = class$com$isomorphic$datasource$DSRequest;
            if (clazz2 == null) {
                clazz2 = class$com$isomorphic$datasource$DSRequest = DataSourceDMI.class("[Lcom.isomorphic.datasource.DSRequest;", false);
            }
            reflectionArgumentArray[1] = new ReflectionArgument(clazz2, this.dsRequest, false, false);
            ReflectionArgument[] factoryOptionalArgs = reflectionArgumentArray;
            ServerObject serverObject = new ServerObject(serverObjectConfig, this.context, factoryOptionalArgs, operationBindingString);
            String methodName = (String)operationBinding.get("serverMethod");
            if (methodName == null) {
                methodName = operationType;
            }
            Class serverObjectClass = serverObject._getClass();
            Method method = serverObject.getMethod(methodName);
            Object serverObjectInstance = serverObject.getInstance(method);
            if (method == null && !haveExplicitBinding) {
                log.debug("DataSourceDMI: no public method name: " + methodName + " available on class: " + serverObjectClass.getName() + " - defaulting to builtin operations.");
                return null;
            }
            String methodArguments = (String)operationBinding.get("methodArguments");
            ReflectionArgument[] requiredArgs = null;
            ReflectionArgument[] optionalArgs = null;
            Map map = criteriaOrValues = this.dsRequest.getValues() == null ? this.dsRequest.getCriteria() : this.dsRequest.getValues();
            if (methodArguments != null) {
                List methodArgList = DataTools.simpleSplit(methodArguments, ",");
                requiredArgs = new ReflectionArgument[methodArgList.size()];
                VelocityEngine vEngine = this.getVelocityEngine();
                VelocityContext vContext = new VelocityContext();
                if (this.context != null) {
                    vContext.put("context", (Object)this.context);
                    vContext.put("request", (Object)this.context.request);
                    vContext.put("response", (Object)this.context.response);
                    vContext.put("servletContext", (Object)this.context.servletContext);
                }
                if (this.rpc != null) {
                    vContext.put("rpc", (Object)this.rpc);
                    vContext.put("rpcManager", (Object)this.rpc);
                }
                vContext.put("dsRequest", (Object)this.dsRequest);
                vContext.put("ds", (Object)ds);
                vContext.put("dataSource", (Object)ds);
                vContext.put("criteriaOrValues", (Object)criteriaOrValues);
                StringWriter out = new StringWriter();
                int i = 0;
                while (i < requiredArgs.length) {
                    String methodArg = (String)methodArgList.get(i);
                    vEngine.evaluate((Context)vContext, (Writer)out, "DataSourceDMI", "#set($iscResult = " + methodArg + ")\n");
                    Object value = vContext.get("iscResult");
                    log.debug("assigning: " + methodArg + " type: " + (value == null ? "null" : value.getClass().getName()));
                    requiredArgs[i] = new ReflectionArgument(value != null ? value.getClass() : null, value);
                    ++i;
                }
            } else {
                HttpSession session = null;
                Class clazz3 = class$javax$servlet$http$HttpSession;
                if (clazz3 == null) {
                    clazz3 = class$javax$servlet$http$HttpSession = DataSourceDMI.class("[Ljavax.servlet.http.HttpSession;", false);
                }
                if (Reflection.methodTakesArgType(method, clazz3)) {
                    session = this.context.request.getSession(true);
                }
                ReflectionArgument[] reflectionArgumentArray2 = new ReflectionArgument[9];
                Class clazz4 = class$com$isomorphic$servlet$RequestContext;
                if (clazz4 == null) {
                    clazz4 = class$com$isomorphic$servlet$RequestContext = DataSourceDMI.class("[Lcom.isomorphic.servlet.RequestContext;", false);
                }
                reflectionArgumentArray2[0] = new ReflectionArgument(clazz4, this.context, false, false);
                Class clazz5 = class$javax$servlet$http$HttpServletRequest;
                if (clazz5 == null) {
                    clazz5 = class$javax$servlet$http$HttpServletRequest = DataSourceDMI.class("[Ljavax.servlet.http.HttpServletRequest;", false);
                }
                reflectionArgumentArray2[1] = new ReflectionArgument(clazz5, (Object)this.context.request, false, false);
                Class clazz6 = class$javax$servlet$http$HttpServletResponse;
                if (clazz6 == null) {
                    clazz6 = class$javax$servlet$http$HttpServletResponse = DataSourceDMI.class("[Ljavax.servlet.http.HttpServletResponse;", false);
                }
                reflectionArgumentArray2[2] = new ReflectionArgument(clazz6, this.context.response, false, false);
                Class clazz7 = class$javax$servlet$ServletContext;
                if (clazz7 == null) {
                    clazz7 = class$javax$servlet$ServletContext = DataSourceDMI.class("[Ljavax.servlet.ServletContext;", false);
                }
                reflectionArgumentArray2[3] = new ReflectionArgument(clazz7, this.context.servletContext, false, false);
                Class clazz8 = class$javax$servlet$http$HttpSession;
                if (clazz8 == null) {
                    clazz8 = class$javax$servlet$http$HttpSession = DataSourceDMI.class("[Ljavax.servlet.http.HttpSession;", false);
                }
                reflectionArgumentArray2[4] = new ReflectionArgument(clazz8, session, false, false);
                Class clazz9 = class$com$isomorphic$rpc$RPCManager;
                if (clazz9 == null) {
                    clazz9 = class$com$isomorphic$rpc$RPCManager = DataSourceDMI.class("[Lcom.isomorphic.rpc.RPCManager;", false);
                }
                reflectionArgumentArray2[5] = new ReflectionArgument(clazz9, this.rpc, false, false);
                Class clazz10 = class$com$isomorphic$datasource$DSRequest;
                if (clazz10 == null) {
                    clazz10 = class$com$isomorphic$datasource$DSRequest = DataSourceDMI.class("[Lcom.isomorphic.datasource.DSRequest;", false);
                }
                reflectionArgumentArray2[6] = new ReflectionArgument(clazz10, this.dsRequest, false, false);
                Class clazz11 = class$com$isomorphic$datasource$DataSource;
                if (clazz11 == null) {
                    clazz11 = class$com$isomorphic$datasource$DataSource = DataSourceDMI.class("[Lcom.isomorphic.datasource.DataSource;", false);
                }
                reflectionArgumentArray2[7] = new ReflectionArgument(clazz11, ds, false, false);
                Class clazz12 = class$java$util$Map;
                if (clazz12 == null) {
                    clazz12 = class$java$util$Map = DataSourceDMI.class("[Ljava.util.Map;", false);
                }
                reflectionArgumentArray2[8] = new ReflectionArgument(clazz12, criteriaOrValues, true, true);
                optionalArgs = reflectionArgumentArray2;
            }
            try {
                returnValue = Reflection.adaptArgsAndInvoke(serverObjectInstance, method, requiredArgs, optionalArgs, ds);
            }
            catch (InvocationTargetException e) {
                Throwable t = Reflection.getRealTargetException(e);
                log.debug((Object)"Invocation threw exception", t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                log.error((Object)"Invocation threw exception", t);
                Exception x = new Exception("RPCDMI infocation threw a: " + t.getClass().getName() + " with error: " + t.getMessage());
                throw x;
            }
            returnValueClass = method.getReturnType();
        }
        DSResponse dsResponse = null;
        Class clazz = class$com$isomorphic$datasource$DSResponse;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$DSResponse = DataSourceDMI.class("[Lcom.isomorphic.datasource.DSResponse;", false);
        }
        if (clazz.isAssignableFrom(returnValueClass)) {
            dsResponse = (DSResponse)returnValue;
        } else {
            dsResponse = new DSResponse(ds);
            dsResponse.setData(returnValue);
            dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        }
        dsResponse.dropExtraFields = new Boolean(dropExtraFields);
        return dsResponse;
    }

    protected VelocityEngine getVelocityEngine() throws Exception {
        VelocityEngine vEngine = new VelocityEngine();
        Properties properties = new Properties();
        properties.put("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        properties.put("runtime.log.logsystem.log4j.category", "org.apache.Velocity");
        vEngine.init(properties);
        return vEngine;
    }

    protected boolean explicitBindingNotRequired(String operationType) {
        return this.operationTypesNotRequiringExplicitBindings.contains(operationType);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.operationTypesNotRequiringExplicitBindings = config.getList("DMI.operationTypesNotRequiringExplicitBindings", new ArrayList());
    }

    public DataSourceDMI(DSRequest dsRequest, RPCManager rpc, RequestContext context) {
        this.this();
        this.dsRequest = dsRequest;
        this.rpc = rpc;
        this.context = context;
    }

    static {
        Class clazz = class$com$isomorphic$datasource$DataSourceDMI;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$DataSourceDMI = DataSourceDMI.class("[Lcom.isomorphic.datasource.DataSourceDMI;", false);
        }
        log = new Logger(clazz.getName());
        config = Config.getGlobal();
    }
}

