/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ISCMapBean;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.VirtualDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.ISCDate;
import com.isomorphic.xml.XML;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataSource
extends Base
implements IType,
IToJSON {
    private static Logger log;
    public static int totalDataSources;
    public static int totalInstantiationTime;
    public static final String OP_FETCH = "fetch";
    public static final String OP_ADD = "add";
    public static final String OP_REMOVE = "remove";
    public static final String OP_UPDATE = "update";
    public static final String OP_CUSTOM = "custom";
    public static final String OP_VALIDATE = "validate";
    public static Map creationCount;
    public static boolean useAxisForSQLDS;
    protected String dsName;
    protected String dsConfigFile;
    protected Map dsConfig;
    protected List fieldList;
    protected long configTimestamp;
    static /* synthetic */ Class class$com$isomorphic$datasource$DataSource;

    public static DataSource forName(String dsName) throws Exception {
        Map dsConfig;
        String dsConfigFile = null;
        if ("Object".equals(dsName)) {
            dsConfig = DataTools.buildMap("ID", "Object");
        } else {
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile(dsName);
            if (dsObject != null && dsObject instanceof DataSource) {
                return (DataSource)dsObject;
            }
            dsConfigFile = DataStructCache.getInstanceFile(dsName, "datasources", "DS");
            if (dsConfigFile == null) {
                return null;
            }
            dsConfig = (Map)DataStructCache.loadInstance(dsConfigFile, dsName, "DS");
            if (dsConfig == null) {
                throw new Exception("Can't locate datasource for name: " + dsName);
            }
            String ID = (String)dsConfig.get("ID");
            if (ID != null && !dsName.equals(ID)) {
                if (log.isDebugEnabled()) {
                    log.debug("dsName case sensitivity mismatch - looking for: " + dsName + ", but got: " + ID);
                }
                return null;
            }
            if (dsConfig == null) {
                return null;
            }
        }
        long start = System.currentTimeMillis();
        DataSource ds = DataSource.fromConfig(dsConfig);
        long end = System.currentTimeMillis();
        totalInstantiationTime = (int)((long)totalInstantiationTime + (end - start));
        if (dsConfigFile != null) {
            ds.dsConfigFile = dsConfigFile;
            ds.configTimestamp = new ISCFile(dsConfigFile).lastModified();
        }
        return ds;
    }

    public static DataSource fromConfig(Map theConfig) throws Exception {
        String dsType = DataSource.getType(theConfig);
        if ("view".equals(dsType)) {
            VirtualDataSource ds = new VirtualDataSource();
            ((DataSource)ds).init(theConfig);
            return ds;
        }
        return BasicDataSource.fromConfig(theConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(Map theConfig) throws Exception {
        this.dsConfig = DataTools.mapMerge(theConfig, (Map)new SequencedHashMap());
        this.dsName = (String)this.dsConfig.get("ID");
        this.fieldList = new ArrayList();
        if (this.dsName == null) {
            log.warn("dsConfig with no ID: " + DataTools.prettyPrint(this.dsConfig));
        }
        if (!log.isDebugEnabled()) return;
        log.debug("Creating instance of DataSource '" + this.dsName + '\'');
        Map map = creationCount;
        synchronized (map) {
            DataTools.incrementIntInMap(creationCount, this.dsName);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
            ++totalDataSources;
            return;
        }
    }

    public static DataSource fromXML(Element elem) throws Exception {
        return DataSource.fromConfig((Map)XML.toDSRecords(elem));
    }

    public static DataSource fromXML(Document doc) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement());
    }

    public static DataSource fromXML(String xml) throws Exception {
        return DataSource.fromXML(new StringReader(xml));
    }

    public static DataSource fromXML(Reader reader) throws Exception {
        return DataSource.fromConfig((Map)XML.toDSRecords(reader));
    }

    public boolean isStale() {
        if (this.configTimestamp == (long)-1) {
            return false;
        }
        String filename = this.dsConfigFile;
        File configFile = new File(filename);
        boolean bl = false;
        if (configFile.exists() && configFile.lastModified() > this.configTimestamp) {
            bl = true;
        }
        return bl;
    }

    public String getName() {
        return this.dsName;
    }

    public String getConfigFilename() {
        return this.dsConfigFile;
    }

    public Map getServerObjectConfig() {
        return (Map)this.dsConfig.get("serverObject");
    }

    public List getOperationBindings() {
        return (List)this.dsConfig.get("operationBindings");
    }

    public String getAutoOperationId(String operationType) {
        return this.getName() + '_' + operationType;
    }

    public Map getOperationBinding(String operationType) {
        return this.getOperationBinding(operationType, this.getAutoOperationId(operationType));
    }

    public Map getOperationBinding(String operationType, String operationId) {
        List operationBindings = this.getOperationBindings();
        if (operationBindings == null) {
            return null;
        }
        boolean bl = false;
        if (operationId != null && operationId.equals(this.getAutoOperationId(operationType))) {
            bl = true;
        }
        boolean operationIdIsAuto = bl;
        Map autoOperationBinding = null;
        Iterator i = operationBindings.iterator();
        while (i.hasNext()) {
            Map operationBinding = (Map)i.next();
            if (!operationType.equals((String)operationBinding.get("operationType"))) continue;
            String bindingOperationId = (String)operationBinding.get("operationId");
            if (operationId != null && operationId.equals(bindingOperationId)) {
                return operationBinding;
            }
            if (bindingOperationId != null || !operationIdIsAuto && operationId != null) continue;
            autoOperationBinding = operationBinding;
        }
        if (autoOperationBinding != null) {
            return autoOperationBinding;
        }
        return null;
    }

    public boolean dropExtraFieldsDefined() {
        boolean bl = false;
        if (this.dsConfig.get("dropExtraFields") != null) {
            bl = true;
        }
        return bl;
    }

    public boolean dropExtraFields() {
        Boolean dropExtraFields = (Boolean)this.dsConfig.get("dropExtraFields");
        boolean bl = false;
        if (dropExtraFields == null || dropExtraFields.booleanValue()) {
            bl = true;
        }
        return bl;
    }

    public String getTestFileName() throws Exception {
        String testFilePath;
        String finalPath;
        String testFileName = (String)this.dsConfig.get("dbImportFileName");
        if (testFileName == null) {
            testFileName = (String)this.dsConfig.get("testFileName");
        }
        if (testFileName == null) {
            testFileName = this.dsName + ".data";
        }
        if ((finalPath = this.tryExtension(testFilePath = (testFilePath = testFileName).indexOf("/") == -1 ? DataStructCache.getInstanceDir(this.getName(), "datasources", "ds") + "/test_data/" + testFileName : Config.getGlobal().get("webRoot") + testFileName, ".xml")) == null) {
            finalPath = this.tryExtension(testFilePath, ".csv");
        }
        if (finalPath == null) {
            finalPath = this.tryExtension(testFilePath, ".js");
        }
        if (finalPath == null) {
            log.info("No test data file for datasource '" + this.getName() + ".  Tried " + testFilePath + " with extensions .xml, .csv and .js");
        }
        return finalPath;
    }

    private final String tryExtension(String baseName, String extension) throws Exception {
        String fullName = baseName.endsWith(extension) ? baseName : baseName + extension;
        log.debug("Look for test file at path " + fullName);
        ISCFile iscFile = new ISCFile(fullName);
        if (iscFile.exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public List getFieldNames() {
        return this.fieldList;
    }

    public List getFields() {
        List fieldNames = this.getFieldNames();
        if (fieldNames == null) {
            return null;
        }
        ArrayList<DSField> fields = new ArrayList<DSField>();
        Iterator i = fieldNames.iterator();
        while (i.hasNext()) {
            fields.add(this.getField((String)i.next()));
        }
        return fields;
    }

    public List getPrimaryKeys() {
        return new ArrayList();
    }

    public String getPrimaryKey() {
        List pks = this.getPrimaryKeys();
        if (pks == null || pks.get(0) == null) {
            return null;
        }
        return pks.get(0).toString();
    }

    public Map getConfig() {
        return this.dsConfig;
    }

    public int getVersion() {
        return new Integer(this.dsConfig.get("dataSourceVersion").toString());
    }

    public static String getType(Map dsConfig) {
        Object type = dsConfig.get("serverType");
        if (type == null) {
            type = dsConfig.get("type");
        }
        if (type == null) {
            type = dsConfig.get("dataSourceType");
        }
        if (type == null && dsConfig.get("constructor") != null && !"DataSource".equals(dsConfig.get("constructor"))) {
            type = dsConfig.get("constructor");
        }
        if (type == null && dsConfig.get("serviceNamespace") != null) {
            type = "webService";
        }
        if (type == null) {
            type = dsConfig.get("dataFormat");
        }
        if (type == null && dsConfig.get("recordXPath") != null) {
            type = "xml";
        }
        return (String)type;
    }

    public String getType() {
        return DataSource.getType(this.dsConfig);
    }

    public boolean inheritsFrom(String dsName) {
        return false;
    }

    public Map getRawFields() {
        return (Map)this.dsConfig.get("fields");
    }

    public DSField getField(String fieldName) {
        return null;
    }

    public String getFieldTitle(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getTitle();
    }

    public Map getValueMaps() {
        return this.getValueMaps(this.getFieldNames());
    }

    public Map getValueMaps(List fieldNames) {
        HashMap valueMaps = new HashMap();
        if (fieldNames == null || fieldNames.size() == 0) {
            return valueMaps;
        }
        Iterator e = fieldNames.iterator();
        while (e.hasNext()) {
            Object valueMap;
            String fieldName = (String)e.next();
            DSField field = this.getField(fieldName);
            if (field == null || (valueMap = field.get("valueMap")) == null || !(valueMap instanceof Map)) continue;
            valueMaps.put(fieldName, valueMap);
        }
        return valueMaps;
    }

    public String getRecordXPath() {
        return (String)this.dsConfig.get("recordXPath");
    }

    public boolean isAdvancedCriteria(Map criteria) {
        if (criteria == null) {
            return false;
        }
        String constructor = (String)criteria.get("_constructor");
        if ("AdvancedCriteria".equals(constructor)) {
            return true;
        }
        String fieldName = (String)criteria.get("fieldName");
        String operator = (String)criteria.get("operator");
        return this.getField("fieldName") == null && this.getField("operator") == null && this.getField(fieldName) != null && operator != null;
    }

    public static DataSource getElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        String constructor = element.getAttribute("constructor");
        BasicDataSource ds = context.getType(constructor);
        if (ds != null) {
            return ds;
        }
        ds = context.getType(tagName);
        return ds;
    }

    public static Object recordsFromXML(Object data) throws Exception {
        return DataSource.recordsFromXML(data, new ValidationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object recordsFromXML(Object data, ValidationContext context) throws Exception {
        Object object;
        DataSource ds;
        block13: {
            String string;
            block12: {
                if (data instanceof List) {
                    return DataSource.recordsFromXML((List)data, context);
                }
                if (!(data instanceof Element)) {
                    return data;
                }
                Element element = (Element)data;
                ds = DataSource.getElementType(element, context);
                try {
                    String loadID;
                    if (ds == null) {
                        if (!element.hasAttributes() && XML.getElementChildren(element).isEmpty()) {
                            string = XML.toSimpleValue(element);
                            Object var5_6 = null;
                            break block12;
                        }
                        ds = context.getType("Object");
                    }
                    Object result = ds.toRecords(element, context);
                    if ("DataSource".equals(ds.getName()) && (loadID = (String)((Map)result).get("loadID")) != null) {
                        DataSource refDS = null;
                        try {
                            refDS = DataSourceManager.getDataSource(loadID);
                            if (refDS == null) {
                                throw new Exception("Unable load DataSource reference by loadID: " + loadID);
                            }
                            result = refDS.getConfig();
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            DataSourceManager.freeDataSource(refDS);
                            throw throwable;
                        }
                        {
                            Object var11_14 = null;
                        }
                        DataSourceManager.freeDataSource(refDS);
                    }
                    if (context.hasErrors()) {
                        Logger.validation.warning("Validation errors validating a '" + ds.getName() + "':\n" + DataTools.prettyPrint(context.getErrors()));
                    }
                    object = result;
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    DataSourceManager.freeDataSource(ds);
                    throw throwable;
                }
            }
            DataSourceManager.freeDataSource(ds);
            return string;
        }
        Object var5_7 = null;
        DataSourceManager.freeDataSource(ds);
        return object;
    }

    public static Object recordsFromXML(List elements) throws Exception {
        return DataSource.recordsFromXML(elements, new ValidationContext());
    }

    public static Object recordsFromXML(List elements, ValidationContext context) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator e = elements.iterator();
        while (e.hasNext()) {
            values.add(DataSource.recordsFromXML(e.next(), context));
        }
        return values;
    }

    public Object create(Object data, ValidationContext context) throws Exception {
        return this.toRecords(data, context);
    }

    public Object toRecords(Object data) throws Exception {
        return this.toRecords(data, new ValidationContext());
    }

    public Object toRecords(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    public Object toRecord(Object data) throws Exception {
        return this.toRecord(data, new ValidationContext());
    }

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    public void ds2Schema(DataSource ds, Writer out) throws Exception {
        out.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        out.write("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n");
        out.write("<xs:element name='" + ds.getName() + "'>");
        out.write("<xs:complexType>");
        out.write("<xs:any processContents='lax'>");
        List fields = ds.getFieldNames();
        Iterator e = fields.iterator();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            String xmlType = ds.getField(fieldName).getType();
            out.write("<xs:attribute name='" + fieldName + "' type='" + xmlType + "'>");
        }
        out.write("<xs:anyAttribute processContents='lax'>");
        out.write("</xs:complexType>");
        out.write("</xs:element>");
        out.write("</xs:schema>");
    }

    public static boolean isModificationOperation(String operationType) {
        boolean bl = false;
        if (DataSource.isAdd(operationType) || DataSource.isRemove(operationType) || DataSource.isUpdate(operationType) || "replace".equals(operationType)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFetch(String opType) {
        boolean bl = false;
        if (OP_FETCH.equals(opType) || "select".equals(opType) || "filter".equals(opType)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAdd(String opType) {
        boolean bl = false;
        if (OP_ADD.equals(opType) || "insert".equals(opType)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRemove(String opType) {
        boolean bl = false;
        if (OP_REMOVE.equals(opType) || "delete".equals(opType)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isUpdate(String opType) {
        return OP_UPDATE.equals(opType);
    }

    public static boolean isDownload(String opType) {
        boolean bl = false;
        if ("downloadFile".equals(opType) || "viewFile".equals(opType)) {
            bl = true;
        }
        return bl;
    }

    public DSResponse execute(DSRequest req) throws Exception {
        DSResponse validationFailure = this.validateDSRequest(req);
        if (validationFailure != null) {
            return validationFailure;
        }
        String operationType = req.getOperationType();
        if (DataSource.isFetch(operationType)) {
            return this.executeFetch(req);
        }
        if (DataSource.isAdd(operationType)) {
            return this.executeAdd(req);
        }
        if (DataSource.isRemove(operationType)) {
            return this.executeRemove(req);
        }
        if (DataSource.isUpdate(operationType)) {
            return this.executeUpdate(req);
        }
        if (operationType.equals("replace")) {
            return this.executeReplace(req);
        }
        if (operationType.equals("loadSchema")) {
            return this.executeLoadDS(req);
        }
        if (DataSource.isDownload(operationType)) {
            return this.executeDownload(req);
        }
        if (operationType.equals(OP_VALIDATE)) {
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setSuccess();
            return dsResponse;
        }
        return this.executeCustom(req);
    }

    public Object setProperties(Map properties, Object target) {
        JXPathContext context = null;
        HashMap tryAsBean = null;
        HashMap adaptedProperties = new HashMap();
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String fieldName = (String)i.next();
            DSField field = this.getField(fieldName);
            if (field == null) continue;
            Object value = properties.get(fieldName);
            String valueXPath = field.getValueXPath();
            if (valueXPath == null) {
                if (tryAsBean == null) {
                    tryAsBean = new HashMap();
                }
                if (value instanceof Collection || value instanceof Map) {
                    try {
                        PropertyDescriptor pd = new PropertyDescriptor(fieldName, target.getClass());
                        if (pd != null) {
                            value = this.adaptValue(pd, field, value);
                            adaptedProperties.put(fieldName, value);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception trying to adapt collection/map: " + fieldName + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                        e.printStackTrace();
                        log.info(e);
                    }
                }
                tryAsBean.put(fieldName, value);
                continue;
            }
            if (context == null) {
                context = JXPathContext.newContext((Object)target);
            }
            Object adaptedValue = value;
            Pointer p = context.getPointer(valueXPath);
            if (p instanceof BeanPropertyPointer) {
                try {
                    BeanPropertyPointer bpp = (BeanPropertyPointer)p;
                    Object bean = bpp.getBean();
                    PropertyDescriptor pd = new PropertyDescriptor(bpp.getPropertyName(), bean.getClass());
                    if (pd != null) {
                        adaptedValue = this.adaptValue(pd, field, value);
                    }
                }
                catch (Exception e) {
                    log.warn("Exception trying to adapt value for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                }
            }
            try {
                context.setValue(valueXPath, adaptedValue);
            }
            catch (Exception e) {
                log.warn("Couldn't set value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
        }
        i = adaptedProperties.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            properties.put(key, adaptedProperties.get(key));
            tryAsBean.put((String)key, adaptedProperties.get(key));
        }
        if (tryAsBean != null) {
            try {
                DataTools.setProperties(tryAsBean, target, this);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        return target;
    }

    private final Object adaptValue(PropertyDescriptor pd, DSField field, Object value) throws Exception {
        Class<?> javaClass = null;
        Class<?> javaCollectionClass = null;
        Class<?> javaKeyClass = null;
        try {
            String typeName = field.getProperty("javaClass");
            if (typeName != null) {
                javaClass = Class.forName(typeName);
            }
            if ((typeName = field.getProperty("javaCollectionClass")) != null) {
                javaCollectionClass = Class.forName(typeName);
            }
            if ((typeName = field.getProperty("javaKeyClass")) != null) {
                javaKeyClass = Class.forName(typeName);
            }
        }
        catch (Exception e) {
            log.warn(e.getClass().getName() + ' ' + e.getMessage() + " encountered whilst trying to derive Java classes from override class names for DataSource '" + this.getName() + "', field name '" + field.getName() + '\'');
        }
        Method method = pd.getWriteMethod();
        Class<?>[] argTypes = method.getParameterTypes();
        List genericInfo = VersionSafeChecker.getGenericParameterTypes(method);
        VersionSafeChecker.GenericParameterNode targetGenericInfo = null;
        if (genericInfo != null && genericInfo.size() > 0) {
            targetGenericInfo = (VersionSafeChecker.GenericParameterNode)genericInfo.get(0);
        }
        if (targetGenericInfo != null && targetGenericInfo.getClassByIndex(0) == argTypes[0]) {
            targetGenericInfo = targetGenericInfo.getChildNode();
        }
        ReflectionArgument reflectionArg = new ReflectionArgument(value.getClass(), value, true, true);
        if (argTypes.length > 0) {
            String fieldType = field.getType();
            DataSource subDataSource = fieldType == null ? null : DataSource.forName(fieldType);
            value = Reflection.adaptValue(argTypes[0], targetGenericInfo, reflectionArg, null, subDataSource, javaClass, javaCollectionClass, javaKeyClass);
        }
        return value;
    }

    public Map getProperties(Object obj) {
        return this.getProperties(obj, true, true);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields);
    }

    public Map getProperties(Object obj, Collection propsToKeep) {
        return this.getProperties(obj, propsToKeep, false, false);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields) {
        String fieldName;
        if (obj == null) {
            return null;
        }
        JXPathContext context = null;
        ArrayList<String> tryAsBean = null;
        HashMap<String, String> ignoredFields = new HashMap<String, String>();
        ArrayList<String> hadXPath = null;
        SequencedHashMap result = new SequencedHashMap();
        List fieldNames = this.getFieldNames();
        Iterator i = fieldNames.iterator();
        while (i.hasNext()) {
            fieldName = (String)i.next();
            if (propsToKeep != null && !propsToKeep.contains(fieldName)) continue;
            DSField field = this.getField(fieldName);
            if (dropIgnoredFields && DataTools.getBoolean(field, "ignore")) {
                ignoredFields.put(fieldName, "ignore");
                continue;
            }
            String valueXPath = field.getValueXPath();
            if (valueXPath == null) {
                if (tryAsBean == null) {
                    tryAsBean = new ArrayList<String>();
                }
                tryAsBean.add(fieldName);
                continue;
            }
            if (hadXPath == null) {
                hadXPath = new ArrayList<String>();
            }
            hadXPath.add(fieldName);
            if (context == null) {
                context = JXPathContext.newContext((Object)obj);
            }
            try {
                result.put((Object)fieldName, context.getValue(valueXPath));
            }
            catch (Exception e) {
                log.warn("Couldn't get value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
        }
        if (!dropExtraFields || tryAsBean != null || propsToKeep != null) {
            Object key;
            Iterator<Object> i2;
            Map beanValues;
            block24: {
                beanValues = null;
                if (!(obj instanceof Map) || obj instanceof ISCMapBean) {
                    try {
                        if (propsToKeep != null) {
                            if (hadXPath != null) {
                                propsToKeep = new ArrayList(propsToKeep);
                                propsToKeep.removeAll(hadXPath);
                            }
                            beanValues = DataTools.getProperties(obj, propsToKeep);
                            break block24;
                        }
                        if (hadXPath != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadXPath);
                        }
                        beanValues = DataTools.getProperties(obj, dropExtraFields ? tryAsBean : null);
                    }
                    catch (Exception e) {
                        log.warn("Couldn't get values: " + ((Object)tryAsBean).toString() + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
                    }
                } else {
                    beanValues = new HashMap();
                }
            }
            if (obj instanceof Map) {
                i2 = null;
                i2 = propsToKeep != null ? propsToKeep.iterator() : (dropExtraFields ? tryAsBean.iterator() : DataTools.mapDisjunction((Map)obj, ignoredFields).keySet().iterator());
                while (i2.hasNext()) {
                    Object value;
                    key = i2.next();
                    if (beanValues.get(key) != null || (value = ((Map)obj).get(key)) == null) continue;
                    beanValues.put(key, value);
                }
            }
            if (hadXPath != null) {
                i2 = hadXPath.iterator();
                while (i2.hasNext()) {
                    key = i2.next();
                    if (!hadXPath.contains(key)) continue;
                    beanValues.remove(key);
                }
            }
            DataTools.putAllNotPresent((Map)result, beanValues);
        }
        i = fieldNames.iterator();
        while (i.hasNext()) {
            fieldName = (String)i.next();
            Object value = result.get((Object)fieldName);
            if (value == null || !(value instanceof Date)) continue;
            DSField field = this.getField(fieldName);
            String fieldType = null;
            try {
                fieldType = ((BasicDataSource)this).getSimpleBaseType(field.getType());
            }
            catch (Exception e) {
                log.warn("Unable to look up simpleBaseType for field: " + fieldName);
                continue;
            }
            if (!"date".equals(fieldType) || "datetime".equals(field.getType())) continue;
            value = new ISCDate(((Date)value).getTime());
            result.put((Object)fieldName, value);
        }
        return result;
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields) throws Exception {
        ValidationContext context = new ValidationContext();
        context.setPropertiesOnly(reportMissingRequiredFields ^ true);
        this.toRecords(data, context);
        Map errors = context.getErrors();
        if (errors == null) {
            return null;
        }
        return (ErrorReport)errors.values().toArray()[0];
    }

    public DSResponse validateDSRequest(DSRequest dsRequest) throws Exception {
        if (dsRequest.getBeenThroughValidation()) {
            return null;
        }
        dsRequest.setBeenThroughValidation(true);
        List errors = DataSource.validateDSRequest(this, dsRequest);
        if (errors != null) {
            Logger.validation.info("Validation error: " + DataTools.prettyPrint(errors));
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setStatus(DSResponse.STATUS_VALIDATION_ERROR);
            dsResponse.setErrors(errors);
            return dsResponse;
        }
        return null;
    }

    public static List validateDSRequest(DataSource dataSource, DSRequest dsRequest) throws Exception {
        Map errors;
        String operationType = dsRequest.getOperationType();
        if (!DataSource.isModificationOperation(operationType) || DataSource.isRemove(operationType)) {
            return null;
        }
        ValidationContext context = new ValidationContext();
        if (dsRequest.getOperationType().equals(OP_UPDATE)) {
            context.setPropertiesOnly();
        }
        dsRequest.setValidatedValues(dataSource.toRecords(dsRequest.getValueSets(), context));
        if (log.isDebugEnabled()) {
            log.debug("post-validation valueSet: " + DataTools.prettyPrint(dsRequest.getValueSets()));
        }
        if ((errors = context.getErrors()) != null) {
            return new ArrayList(errors.values());
        }
        return null;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeReplace(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeLoadDS(DSRequest req) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("dsName", this.getName());
        result.put("dsData", JSTranslater.instance().toJS(this.getConfig()));
        DSResponse dsResponse = new DSResponse(this);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(result);
        dsResponse.setData(list);
        return dsResponse;
    }

    protected DSResponse notSupported(DSRequest req) throws Exception {
        throw new Exception("Operation type '" + req.getOperationType() + "' not supported by this DataSource (" + this.getName() + ')');
    }

    public Map getLastRow() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ')');
    }

    public Map getLastPrimaryKeys() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ')');
    }

    public void clearState() {
    }

    public List fetch(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        return this.execute(req).getDataList();
    }

    public List filter(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "filter");
        req.setCriteria(criteria);
        return this.execute(req).getDataList();
    }

    public long add(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_ADD);
        req.setValues(values);
        return this.execute(req).getAffectedRows();
    }

    public long replace(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "replace");
        req.setValues(values);
        return this.execute(req).getAffectedRows();
    }

    public long update(Object criteria, Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_UPDATE);
        req.setCriteria(criteria);
        req.setValues(values);
        return this.execute(req).getAffectedRows();
    }

    public long remove(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_REMOVE);
        req.setCriteria(criteria);
        return this.execute(req).getAffectedRows();
    }

    public long insert(Object values) throws Exception {
        return this.add(values);
    }

    public long delete(Object criteria) throws Exception {
        return this.remove(criteria);
    }

    public List select(Object criteria) throws Exception {
        return this.fetch(criteria);
    }

    public Map selectUnique(Map criteria) throws Exception {
        throw new Exception("not supported by this class");
    }

    public Map selectSingle(String key, Object value) throws Exception {
        return this.forceSingle(this.select(key, value));
    }

    public Map selectSingle(Object criteria) throws Exception {
        return this.forceSingle(this.select(criteria));
    }

    public List select(String key, Object value) throws Exception {
        return this.select(DataTools.buildMap(key, value));
    }

    public List filter(String key, Object value) throws Exception {
        return this.filter(DataTools.buildMap(key, value));
    }

    private final Map forceSingle(List result) throws Exception {
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return (Map)result.get(0);
    }

    public String toXML() {
        return this.toXML(this.dsConfig);
    }

    public String toXML(Map dsConfig) {
        StringBuffer buf = new StringBuffer();
        buf.append("<DataSource\n");
        Iterator i = dsConfig.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = dsConfig.get(key);
            if (value instanceof List || value instanceof Map) continue;
            buf.append("\t" + key + "=\"" + value + "\"\n");
        }
        buf.append(">\n");
        List fieldNames = this.getFieldNames();
        if (fieldNames != null && !fieldNames.isEmpty()) {
            buf.append("\t<fields>\n");
            Iterator i2 = fieldNames.iterator();
            while (i2.hasNext()) {
                DSField field = this.getField((String)i2.next());
                buf.append("\t\t<field");
                buf.append(" name=\"" + field.getName() + '\"');
                buf.append(" type=\"" + field.getType() + '\"');
                Long length = field.getLength();
                if (length != null) {
                    buf.append(" length=\"" + length + '\"');
                }
                if (field.isPrimaryKey()) {
                    buf.append(" primaryKey=\"true\"");
                }
                buf.append("/>\n");
            }
            buf.append("\t</fields>\n");
        }
        buf.append("</DataSource>\n");
        return buf.toString();
    }

    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        Map dsConfig = this.getConfig();
        HashMap<String, Object> maskedConfig = new HashMap<String, Object>(dsConfig);
        maskedConfig.remove("serverObject");
        List operationBindings = (List)maskedConfig.get("operationBindings");
        if (operationBindings != null) {
            ArrayList newBindings = new ArrayList();
            maskedConfig.put("operationBindings", newBindings);
            int i = 0;
            while (i < operationBindings.size()) {
                HashMap newBinding = new HashMap((Map)operationBindings.get(i));
                newBinding.remove("serverObject");
                newBinding.remove("customSQL");
                newBinding.remove("customHQL");
                newBinding.remove("selectClause");
                newBinding.remove("tableClause");
                newBinding.remove("whereClause");
                newBinding.remove("valuesClause");
                newBinding.remove("orderClause");
                newBinding.remove("groupClause");
                newBinding.remove("groupWhereClause");
                newBindings.add(newBinding);
                ++i;
            }
        }
        if ("true".equals(dsConfig.get("autoDeriveSchema")) && this instanceof BasicDataSource) {
            DataSource inheritsFrom = ((BasicDataSource)this).autoDeriveDS;
            maskedConfig.put("inheritsFrom", inheritsFrom);
        }
        Map fields = (Map)maskedConfig.get("fields");
        BasicDataSource superDS = ((BasicDataSource)this).getSuper();
        if (fields != null) {
            ArrayList<Object> fieldList = new ArrayList<Object>();
            Iterator i = fields.keySet().iterator();
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                Object fieldObj = fields.get(fieldName);
                boolean copied = false;
                if (!(fieldObj instanceof Map)) {
                    fieldList.add(fieldObj);
                    continue;
                }
                Map fieldMap = (Map)fieldObj;
                if (!fieldMap.containsKey("name")) {
                    if (!copied) {
                        fieldMap = new SequencedHashMap(fieldMap);
                        copied = true;
                    }
                    fieldMap.put("name", fieldName);
                }
                if (DataTools.getBoolean(fieldMap, "ignore")) {
                    DSField superField = null;
                    if (superDS != null) {
                        superField = ((DataSource)superDS).getField((String)fieldMap.get("name"));
                    }
                    if (superField == null) continue;
                    if (!copied) {
                        fieldMap = new SequencedHashMap(fieldMap);
                        copied = true;
                    }
                    fieldMap.put("hidden", "true");
                }
                if (fieldMap.get("tableName") != null && fieldMap.get("canSave") == null) {
                    if (!copied) {
                        fieldMap = new SequencedHashMap(fieldMap);
                        copied = true;
                    }
                    fieldMap.put("canSave", Boolean.FALSE);
                }
                fieldList.add(fieldMap);
            }
            maskedConfig.put("fields", fieldList);
        }
        if (useAxisForSQLDS && "sql".equals(this.getType())) {
            dsConfig.put("__autoConstruct", "WSDataSource");
        }
        jsTrans.toJS(maskedConfig, out);
    }

    public String getFieldXML() throws Exception {
        return DataSource.getFieldXML(this.fieldList);
    }

    public static String getFieldXML(List fields) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<fields>\n");
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            Object map = i.next();
            if (!(map instanceof Map)) {
                log.warn("Found object of type " + map.getClass() + " in list passed to getFieldXML - was expecting Map");
                continue;
            }
            StringWriter out = new StringWriter();
            XML.recordToXML("field", (Map)map, out);
            xml.append("\t");
            xml.append(out.toString());
        }
        xml.append("</fields>\n");
        return xml.toString();
    }

    public String escapeValueForWhereClause(Object value, Object key) {
        return value.toString();
    }

    public String getEnumTranslateStrategy() {
        String value = (String)this.dsConfig.get("enumTranslateStrategy");
        if (value == null) {
            value = "string";
        }
        return value;
    }

    public void setEnumTranslateStrategy(String newValue) {
        this.dsConfig.put("enumTranslateStrategy", newValue);
    }

    public String getEnumOrdinalProperty() {
        String value = (String)this.dsConfig.get("enumOrdinalProperty");
        if (value == null) {
            value = "_ordinal";
        }
        return value;
    }

    public String getEnumConstantProperty() {
        String value = (String)this.dsConfig.get("enumConstantProperty");
        if (value == null) {
            value = "_constant";
        }
        return value;
    }

    public void setEnumOrdinalProperty(String newValue) {
        this.dsConfig.put("enumOrdinalProperty", newValue);
    }

    public void setEnumConstantProperty(String newValue) {
        this.dsConfig.put("enumConstantProperty", newValue);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.configTimestamp = -1;
    }

    public DataSource() {
        this.this();
    }

    static {
        Class clazz = class$com$isomorphic$datasource$DataSource;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$DataSource = DataSource.class("[Lcom.isomorphic.datasource.DataSource;", false);
        }
        log = new Logger(clazz.getName());
        totalDataSources = 0;
        totalInstantiationTime = 0;
        creationCount = new HashMap();
        useAxisForSQLDS = config.getBoolean((Object)"useAxisForSQLDS", false);
    }
}

