/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Const;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSResponse {
    private static Logger log;
    public static final int STATUS_SUCCESS;
    public static final int STATUS_FAILURE;
    public static final int STATUS_LOGIN_INCORRECT = -5;
    public static final int STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED = -6;
    public static final int STATUS_LOGIN_REQUIRED = -7;
    public static final int STATUS_LOGIN_SUCCESS = -8;
    public static final int STATUS_VALIDATION_ERROR;
    private DataSource dataSource;
    protected Map responseData;
    public Boolean dropExtraFields;
    long affectedRows;
    private int status;
    private List errors;
    private boolean requestConnectionClose;
    static /* synthetic */ Class class$com$isomorphic$datasource$DSResponse;

    public Object getParameter(Object key) {
        return this.responseData.get(key);
    }

    public void setParameter(Object key, Object value) {
        if (key != null && value != null) {
            this.responseData.put(key, value);
        } else if (key != null) {
            this.responseData.remove(key);
        }
    }

    public void setProperty(String key, Object value) {
        this.setParameter(key, value);
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public void setAffectedRows(long affectedRows) {
        this.affectedRows = affectedRows;
    }

    public boolean getInvalidateCache() {
        return (Boolean)this.responseData.get("invalidateCache");
    }

    public void setInvalidateCache(boolean invalidateCache) {
        this.responseData.put("invalidateCache", new Boolean(invalidateCache));
    }

    public void setData(Object data) {
        this.setParameter("data", data);
        if (data instanceof List) {
            long rowCount = ((List)data).size();
            log.info("DSResponse: List with " + rowCount + " items");
        } else if (data instanceof Map) {
            long rowCount = ((Map)data).size();
            log.info("DSResponse: Map with " + rowCount + " keys");
        }
    }

    public List getDataList() {
        Object data = this.getData();
        if (data instanceof List) {
            return (List)data;
        }
        return null;
    }

    public Map getDataMap() {
        List theData = this.getDataList();
        if (theData == null || theData.isEmpty()) {
            return null;
        }
        return (Map)theData.get(0);
    }

    public Object getData() {
        return this.getParameter("data");
    }

    public Object getDataField(String name) {
        Map resultRow = this.getDataMap();
        if (resultRow == null) {
            return null;
        }
        return resultRow.get(name);
    }

    public long getStartRow() {
        Object startRow = this.responseData.get("startRow");
        if (startRow == null) {
            return -1;
        }
        return Long.parseLong(startRow.toString());
    }

    public void setStartRow(long startRow) {
        this.responseData.put("startRow", new Long(startRow));
    }

    public long getEndRow() {
        Object endRow = this.responseData.get("endRow");
        if (endRow == null) {
            return -1;
        }
        return Long.parseLong(endRow.toString());
    }

    public void setEndRow(long endRow) {
        this.responseData.put("endRow", new Long(endRow));
        long startRow = this.getStartRow();
        if (startRow > endRow) {
            this.setStartRow(Math.max(0L, Math.min(startRow, endRow)));
        }
    }

    public long getTotalRows() {
        Object totalRows = this.responseData.get("totalRows");
        if (totalRows == null) {
            return -1;
        }
        return Long.parseLong(totalRows.toString());
    }

    public void setTotalRows(long totalRows) {
        this.responseData.put("totalRows", new Long(totalRows));
    }

    public int getStatus() {
        return this.status;
    }

    public boolean statusIsError() {
        return this.status < 0;
    }

    public boolean statusIsSuccess() {
        return this.status == STATUS_SUCCESS;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setSuccess() {
        this.setStatus(STATUS_SUCCESS);
    }

    public void setFailure() {
        this.setStatus(STATUS_FAILURE);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public List getErrors() {
        return this.errors;
    }

    public void setErrors(List errors) {
        this.errors = errors;
        this.setStatus(STATUS_VALIDATION_ERROR);
    }

    public ErrorReport getErrorReport() {
        if (this.errors != null) {
            return (ErrorReport)this.errors.get(0);
        }
        return null;
    }

    public void addErrorReport(ErrorReport errorReport) {
        if (this.errors == null) {
            this.setErrorReport(errorReport);
        } else {
            this.errors.add(errorReport);
        }
    }

    public void setErrorReport(ErrorReport errorReport) {
        this.errors = new ArrayList();
        this.addErrorReport(errorReport);
        this.setStatus(STATUS_VALIDATION_ERROR);
    }

    public void addError(String fieldName, ErrorMessage errorMessage) {
        ErrorReport errorReport = this.getErrorReport();
        if (errorReport == null) {
            errorReport = new ErrorReport();
            this.setErrorReport(errorReport);
        }
        errorReport.addError(fieldName, errorMessage);
        this.setStatus(STATUS_VALIDATION_ERROR);
    }

    public void addError(String fieldName, String errorMessage) {
        this.addError(fieldName, new ErrorMessage(errorMessage));
    }

    public Map getJSResponse() {
        this.setParameter("errors", this.errors);
        this.setParameter("status", new Integer(this.getStatus()));
        return this.responseData;
    }

    public long getRowCount() {
        Object data = this.getData();
        if (data instanceof List) {
            return ((List)data).size();
        }
        return this.affectedRows;
    }

    public void requestConnectionClose() {
        this.requestConnectionClose = true;
    }

    public boolean wantsConnectionClosed() {
        return this.requestConnectionClose;
    }

    public Map getRecord() {
        if (this.getDataSource() == null) {
            log.warn("Attempted to call getRecord() on a DSResponse with null DataSource");
            return null;
        }
        Object data = this.getData();
        if (data instanceof List) {
            data = ((List)data).get(0);
        }
        Map record = this.getDataSource().getProperties(data);
        return record;
    }

    public List getRecords() {
        ArrayList<Object> source;
        if (this.getDataSource() == null) {
            log.warn("Attempted to call getRecord() on a DSResponse with null DataSource");
            return null;
        }
        ArrayList<Map> target = new ArrayList<Map>();
        Object data = this.getData();
        if (!(data instanceof List)) {
            source = new ArrayList<Object>();
            source.add(data);
        } else {
            source = (ArrayList<Object>)data;
        }
        Iterator i = source.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            target.add(this.getDataSource().getProperties(object));
        }
        return target;
    }

    public Object getFieldValue(String fieldName) {
        return this.getRecord().get(fieldName);
    }

    public boolean getExportResults() {
        if (this.getParameter("exportResults") == null) {
            return false;
        }
        return (Boolean)this.getParameter("exportResults");
    }

    public void setExportResults(boolean exportResults) {
        this.setParameter("exportResults", new Boolean(exportResults));
    }

    public String getExportAs() {
        return (String)this.getParameter("exportAs");
    }

    public void setExportAs(String exportAs) {
        this.setParameter("exportAs", exportAs);
    }

    public String getExportFilename() {
        return (String)this.getParameter("exportFilename");
    }

    public void setExportFilename(String exportFilename) {
        this.setParameter("exportFilename", exportFilename);
    }

    public String getExportDisplay() {
        return (String)this.getParameter("exportDisplay");
    }

    public void setExportDisplay(String exportDisplay) {
        this.setParameter("exportDisplay", exportDisplay);
    }

    public String getLineBreakStyle() {
        return (String)this.getParameter("lineBreakStyle");
    }

    public void setLineBreakStyle(String lineBreakStyle) {
        this.setParameter("lineBreakStyle", lineBreakStyle);
    }

    public List getExportFields() {
        return (List)this.getParameter("exportFields");
    }

    public void setExportFields(List exportFields) {
        this.setParameter("exportFields", exportFields);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.responseData = new HashMap();
        this.affectedRows = 0L;
        this.status = Const.UNSET;
        this.requestConnectionClose = false;
    }

    public DSResponse() {
        this.this();
        this.responseData.put("invalidateCache", new Boolean(false));
        this.responseData.put("isDSResponse", new Boolean(true));
        this.setSuccess();
    }

    public DSResponse(int status) {
        this();
        this.setStatus(status);
    }

    public DSResponse(Object data) {
        this();
        this.setData(data);
    }

    public DSResponse(Object data, int status) {
        this();
        this.setData(data);
        this.setStatus(status);
    }

    public DSResponse(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public DSResponse(DataSource dataSource, int status) {
        this();
        this.setDataSource(dataSource);
        this.setStatus(status);
    }

    public DSResponse(DataSource dataSource, Object data) {
        this();
        this.setDataSource(dataSource);
        this.setData(data);
    }

    public DSResponse(DataSource dataSource, Object data, int status) {
        this();
        this.setDataSource(dataSource);
        this.setData(data);
        this.setStatus(status);
    }

    static {
        Class clazz = class$com$isomorphic$datasource$DSResponse;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$DSResponse = DSResponse.class("[Lcom.isomorphic.datasource.DSResponse;", false);
        }
        log = new Logger(clazz.getName());
        STATUS_SUCCESS = RPCResponse.STATUS_SUCCESS;
        STATUS_FAILURE = RPCResponse.STATUS_FAILURE;
        STATUS_VALIDATION_ERROR = Const.VALIDATION_ERROR;
    }
}

