/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.application.AppBase;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceDMI;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCFileItem;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSRequest {
    private static Logger log;
    private static Config config;
    public static final long FETCH_ALL = -1L;
    public static final long ENDROW_UNSET = -1L;
    public static final String BUILTIN_APPLICATION = "builtinApplication";
    private Map requestData;
    public boolean isClientRequest;
    public RequestContext context;
    public RPCManager rpc;
    private AppBase app;
    private boolean beenThroughDMI;
    private boolean beenThroughValidation;
    private String operationType;
    List uploadedFiles;
    String downloadFieldName;
    String downloadFileName;
    private Object sortBy;
    private long batchSize;
    private long startRow;
    private long endRow;
    private String dataSourceName;
    DataSource ds;
    Map templateContext;
    private boolean _allowMultiUpdate;
    private Object constraints;
    private List outputs;
    private Map operationConfig;
    private boolean forceInvalidateCache;
    static /* synthetic */ Class class$com$isomorphic$datasource$DSRequest;

    public Object getParameter(Object key) {
        return this.requestData.get(key);
    }

    public void setParameter(Object key, Object value) {
        this.requestData.put(key, value);
    }

    public boolean getBeenThroughDMI() {
        return this.beenThroughDMI;
    }

    public void setBeenThroughDMI(boolean newValue) {
        this.beenThroughDMI = newValue;
    }

    public boolean getBeenThroughValidation() {
        return this.beenThroughValidation;
    }

    public void setBeenThroughValidation(boolean newValue) {
        this.beenThroughValidation = newValue;
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseUploadedFiles() throws Exception {
        Map criteria;
        block8: {
            if (!this.context.request.isMultipart()) break block8;
            DataSource ds = DataSourceManager.getDataSource(this.getDataSourceName());
            ArrayList<ISCFileItem> uploadedFiles = null;
            HashMap<String, Object> addFields = new HashMap<String, Object>();
            Map values = this.getValues();
            try {
                int maxSize = config.getInt("DSRequest.maxUploadFileSize", 0);
                Iterator i = values.keySet().iterator();
                while (true) {
                    long fileSize;
                    block9: {
                        if (i.hasNext()) break block9;
                        this.setUploadedFiles(uploadedFiles);
                        this.setValues(DataTools.mapMerge(addFields, values));
                        break;
                    }
                    String fieldName = (String)i.next();
                    DSField field = ds.getField(fieldName);
                    if (field == null || !field.isBinary()) continue;
                    String filename = ISCFile.canonicalizePath((String)values.get(fieldName));
                    String shortFilename = filename;
                    if (shortFilename.indexOf("/") != -1) {
                        shortFilename = shortFilename.substring(shortFilename.lastIndexOf("/") + 1);
                    }
                    ISCFileItem file = null;
                    ArrayList<ErrorReport> errors = null;
                    if (this.context.request.getQueryParameter("singleUpload") != null && (fileSize = (long)this.context.request.getContentLength()) > (long)maxSize) {
                        errors = new ArrayList<ErrorReport>();
                        ErrorReport errorReport = new ErrorReport();
                        errors.add(errorReport);
                        ErrorMessage errorMessage = new ErrorMessage("Size of '" + shortFilename + "' (" + DataTools.formatFileSize(fileSize) + ") exceeded maximum allowed file size of " + DataTools.formatFileSize(maxSize));
                        errorReport.addError(fieldName, errorMessage);
                    }
                    if ((file = this.context.request.getUploadedFile(fieldName, errors)) == null) continue;
                    if (uploadedFiles == null) {
                        uploadedFiles = new ArrayList<ISCFileItem>();
                    }
                    uploadedFiles.add(file);
                    file.setFileName(filename);
                    addFields.put(fieldName + "_filename", shortFilename);
                    file.setShortFileName(shortFilename);
                    fileSize = file.getSize();
                    addFields.put(fieldName + "_filesize", new Long(fileSize));
                    addFields.put(fieldName + "_date_created", new Date());
                }
            }
            catch (Throwable throwable) {
                Object var6_17 = null;
                DataSourceManager.free(ds);
                throw throwable;
            }
            {
                Object var6_18 = null;
            }
            DataSourceManager.free(ds);
        }
        if ((criteria = this.getCriteria()).get("download_fieldname") != null) {
            this.setDownloadFieldName((String)criteria.get("download_fieldname"));
            this.setDownloadFileName((String)criteria.get("download_filename"));
        }
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperationSource() {
        return (String)this.getParameter("operationSource");
    }

    public String getOperation() {
        return (String)this.getParameter("operation");
    }

    public String getOperationId() {
        return this.getOperation();
    }

    public void setOperationId(String operation) {
        this.setParameter("operation", operation);
    }

    public String getComponentId() {
        return (String)this.getParameter("componentId");
    }

    public void setComponentId(String componentId) {
        this.setParameter("componentId", componentId);
    }

    public Map getCriteria() {
        if (DataSource.isAdd(this.getOperationType())) {
            return this.getValues();
        }
        Object criteria = this.getRawCriteria();
        if (criteria instanceof List) {
            List l = (List)criteria;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getCriteria() called on dsRequest containing multiple where clauses, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)criteria;
    }

    public List getCriteriaSets() {
        return DataTools.makeListIfSingle(this.getRawCriteria());
    }

    public void setCriteria(Object criteria) {
        this.requestData.put("criteria", criteria);
    }

    public Object getRawCriteria() {
        return this.requestData.get("criteria");
    }

    public void setUploadedFiles(List uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public ISCFileItem getUploadedFile(String fieldName) throws Exception {
        ISCFileItem fileItem = this.context.request.getUploadedFile(fieldName);
        return fileItem;
    }

    public List getUploadedFiles() {
        return this.uploadedFiles;
    }

    public List getUploadedFileStreams() {
        List uplodedFiles = this.getUploadedFiles();
        if (this.uploadedFiles == null) {
            return null;
        }
        ArrayList<InputStream> uploadedFileStreams = new ArrayList<InputStream>();
        Iterator i = this.uploadedFiles.iterator();
        while (i.hasNext()) {
            ISCFileItem file = (ISCFileItem)i.next();
            uploadedFileStreams.add(file.getInputStream());
        }
        return uploadedFileStreams;
    }

    public void setDownloadFieldName(String downloadFieldName) {
        this.downloadFieldName = downloadFieldName;
    }

    public String getDownloadFieldName() {
        return this.downloadFieldName;
    }

    public void setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public boolean isDownload() {
        String opType;
        return this.getDownloadFieldName() != null && ("downloadFile".equals(opType = this.getOperationType()) || "viewFile".equals(opType));
    }

    public boolean isExport() {
        return this.getExportResults();
    }

    public Map getValues() {
        if (DataSource.isFetch(this.getOperationType())) {
            return this.getCriteria();
        }
        if (DataSource.isRemove(this.getOperationType())) {
            return this.getCriteria();
        }
        Object values = this.getRawValues();
        if (values instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public List getValueSets() {
        if (DataSource.isFetch(this.getOperationType())) {
            return this.getCriteriaSets();
        }
        if (DataSource.isRemove(this.getOperationType())) {
            return this.getCriteriaSets();
        }
        return DataTools.makeListIfSingle(this.getRawValues());
    }

    public void setValues(Object values) {
        this.requestData.put("values", values);
    }

    public Object getRawValues() {
        return this.requestData.get("values");
    }

    public Map getOldValues() {
        Object values = this.getRawOldValues();
        if (values instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getOldValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public List getOldValueSets() {
        return DataTools.makeListIfSingle(this.getRawOldValues());
    }

    public Object getRawOldValues() {
        return this.requestData.get("oldValues");
    }

    public Object getRawSortBy() {
        return this.sortBy;
    }

    public String getSortBy() {
        if (this.sortBy instanceof List) {
            List l = (List)this.sortBy;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (String)l.get(0);
            }
            log.warning("getSortBy() called on dsRequest containing multiple sortBy fields, returning first in list.");
            return (String)l.get(0);
        }
        return (String)this.sortBy;
    }

    public List getSortByFields() {
        return DataTools.makeListIfSingle(this.sortBy);
    }

    public void setSortBy(Object sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isPaged() {
        boolean bl = false;
        if (this.batchSize != (long)-1 || this.startRow != 0L || this.endRow != (long)-1) {
            bl = true;
        }
        return bl;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public void setStartRow(long startRow) {
        this.startRow = startRow;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public void setEndRow(long endRow) {
        this.endRow = endRow;
    }

    public Object getFieldValue(Object fieldName) {
        Map valueSet = this.getValues();
        if (valueSet != null && valueSet.get(fieldName) != null) {
            return valueSet.get(fieldName);
        }
        Map criteria = this.getCriteria();
        if (criteria != null && criteria.get(fieldName) != null) {
            return criteria.get(fieldName);
        }
        return null;
    }

    public void setFieldValue(Object fieldName, Object value) {
        Map valueSet = this.getValues();
        if (valueSet != null) {
            valueSet.put(fieldName, value);
            return;
        }
        Map criteria = this.getCriteria();
        if (criteria != null) {
            criteria.put(fieldName, value);
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        DataSourceManager.free(this.ds);
        this.ds = null;
    }

    public DataSource getDataSource() throws Exception {
        if (this.ds == null && this.getDataSourceName() != null) {
            this.ds = DataSourceManager.getDataSource(this.getDataSourceName());
        }
        return this.ds;
    }

    public void setDataSource(DataSource ds) {
        if (this.ds != null) {
            DataSourceManager.freeDataSource(ds);
        }
        this.ds = ds;
    }

    public ErrorReport validate() throws Exception {
        List l = DataSource.validateDSRequest(this.getDataSource(), this);
        if (l != null) {
            return (ErrorReport)l.get(0);
        }
        return null;
    }

    public DSResponse execute() throws Exception {
        if (this.uploadedFiles != null) {
            int maxSize = config.getInt("DSRequest.maxUploadFileSize", 0);
            DSResponse dsResponse = null;
            Iterator i = this.uploadedFiles.iterator();
            while (i.hasNext()) {
                ISCFileItem file = (ISCFileItem)i.next();
                List errors = file.getErrors();
                if (errors == null) continue;
                dsResponse = new DSResponse(this.getDataSource());
                dsResponse.setErrors(errors);
                dsResponse.requestConnectionClose();
            }
            if (dsResponse != null) {
                return dsResponse;
            }
        }
        DSResponse dsResponse = null;
        if (!this.beenThroughDMI && this.rpc != null) {
            this.rpc.applyEarlierResponseValues(this);
            dsResponse = DataSourceDMI.execute(this, this.rpc, this.context);
        }
        if (dsResponse == null) {
            dsResponse = this.getApp().execute(this, this.context);
        }
        Map operationBinding = null;
        if (this.ds != null) {
            operationBinding = this.ds.getOperationBinding(this.getOperationType(), this.getOperationId());
        }
        if (operationBinding != null) {
            Map map;
            Object value;
            if (operationBinding.containsKey("exportResults")) {
                String s = (String)operationBinding.get("exportResults");
                boolean b = s.equals("true");
                dsResponse.setExportResults(b);
            }
            if (operationBinding.containsKey("exportFilename")) {
                dsResponse.setExportFilename((String)operationBinding.get("exportFilename"));
            }
            if (operationBinding.containsKey("exportAs")) {
                dsResponse.setExportAs((String)operationBinding.get("exportAs"));
            }
            if (operationBinding.containsKey("lineBreakStyle")) {
                dsResponse.setLineBreakStyle((String)operationBinding.get("lineBreakStyle"));
            }
            if (operationBinding.containsKey("exportFields") && (value = (map = (Map)operationBinding.get("exportFields")).get(map.keySet().toArray()[0])) instanceof List) {
                dsResponse.setExportFields((List)value);
            }
        }
        this.freeDataSource();
        return dsResponse;
    }

    public void addToTemplateContext(String name, Object value) {
        this.templateContext.put(name, value);
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public void finalize() throws Throwable {
        this.freeDataSource();
    }

    public void freeDataSource() {
        if (this.ds != null) {
            DataSourceManager.free(this.ds);
            this.ds = null;
        }
    }

    public String getAppID() {
        return (String)this.getParameter("appID");
    }

    public void setAppID(String appID) {
        this.setParameter("appID", appID);
        this.app = null;
    }

    public AppBase getApp() throws Exception {
        if (this.app == null) {
            this.app = AppBase.findByAppID(this.getAppID());
        }
        return this.app;
    }

    public void setAllowMultiUpdate(boolean newValue) {
        this._allowMultiUpdate = newValue;
    }

    public boolean getAllowMultiUpdate() {
        return this._allowMultiUpdate;
    }

    public Object constraints() {
        return this.constraints;
    }

    public void addConstraints(Object obj) {
        List newConstraints;
        if (obj == null) {
            return;
        }
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        if ((newConstraints = DataTools.makeListIfSingle(obj)).contains("*")) {
            this.constraints = null;
            return;
        }
        DataTools.addDisjunctionToSet((List)this.constraints, newConstraints);
    }

    public List outputs() {
        return this.outputs;
    }

    public void setOutputs(List outputs) {
        this.outputs = outputs;
    }

    public void addOutputs(Object obj) {
        List addedOutputs;
        if (obj == null) {
            return;
        }
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        if ((addedOutputs = DataTools.makeListIfSingle(obj)).contains("*")) {
            this.outputs = null;
            return;
        }
        DataTools.addDisjunctionToSet(this.outputs, addedOutputs);
    }

    public Map operationConfig() {
        return this.operationConfig;
    }

    public void setOperationConfig(Map operationConfig) {
        this.operationConfig = operationConfig;
    }

    public Map getOperationConfig() {
        return this.operationConfig;
    }

    public Object getOperationProperty(String property) {
        if (this.operationConfig == null || property == null) {
            return null;
        }
        return this.operationConfig.get(property);
    }

    public Object getOperationProperty(String property, Object defaultValue) {
        Object value = this.getOperationProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean forceInvalidateCache() {
        return this.forceInvalidateCache;
    }

    public void forceInvalidateCache(boolean value) {
        this.forceInvalidateCache = value;
    }

    public void setValidatedValues(Object values) {
        if (this.requestData.containsKey("_unvalidatedValues")) {
            log.warn("setValidatedValues called more than once for this DSRequest object");
            return;
        }
        this.requestData.put("_unvalidatedValues", this.getRawValues());
        this.setValues(values);
    }

    public Object getUnvalidatedValues() {
        if (this.requestData.containsKey("_unvalidatedValues")) {
            return this.requestData.get("_unvalidatedValues");
        }
        return this.getRawValues();
    }

    public boolean getExportResults() {
        if (this.getParameter("exportResults") == null) {
            return false;
        }
        return (Boolean)this.getParameter("exportResults");
    }

    public void setExportResults(boolean exportResults) {
        this.setParameter("exportResults", new Boolean(exportResults));
    }

    public String getExportAs() {
        return (String)this.getParameter("exportAs");
    }

    public void setExportAs(String exportAs) {
        this.setParameter("exportAs", exportAs);
    }

    public String getExportFilename() {
        return (String)this.getParameter("exportFilename");
    }

    public void setExportFilename(String exportFilename) {
        this.setParameter("exportFilename", exportFilename);
    }

    public String getExportDisplay() {
        return (String)this.getParameter("exportDisplay");
    }

    public void setExportDisplay(String exportDisplay) {
        this.setParameter("exportDisplay", exportDisplay);
    }

    public String getLineBreakStyle() {
        return (String)this.getParameter("lineBreakStyle");
    }

    public void setLineBreakStyle(String lineBreakStyle) {
        this.setParameter("lineBreakStyle", lineBreakStyle);
    }

    public List getExportFields() {
        return (List)this.getParameter("exportFields");
    }

    public void setExportFields(List exportFields) {
        this.setParameter("exportFields", exportFields);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.isClientRequest = false;
        this.beenThroughDMI = false;
        this.beenThroughValidation = false;
        this.operationType = null;
        this.downloadFieldName = null;
        this.downloadFileName = null;
        this.sortBy = null;
        this.batchSize = -1;
        this.startRow = 0L;
        this.endRow = -1;
        this.templateContext = new HashMap();
        this._allowMultiUpdate = false;
        this.constraints = null;
        this.outputs = null;
        this.operationConfig = null;
        this.forceInvalidateCache = false;
    }

    public DSRequest(String dataSourceName, String operationType) {
        this();
        this.operationType = operationType;
        this.dataSourceName = dataSourceName;
    }

    public DSRequest() {
        this(new HashMap());
        this.setAppID(BUILTIN_APPLICATION);
    }

    public DSRequest(Map requestData) {
        Object endRow;
        Object startRow;
        String paramResultSize;
        List outputs;
        this.this();
        this.requestData = requestData;
        if (this.getRawCriteria() == null) {
            this.setCriteria(new HashMap());
        }
        if (this.getAppID() == null) {
            this.setAppID(BUILTIN_APPLICATION);
        }
        try {
            this.app = this.getApp();
        }
        catch (Exception e) {
            log.error((Object)"Couldn't fetch app definition", e);
        }
        String operation = this.getOperation();
        Map reqOpConfig = (Map)this.getParameter("operationConfig");
        this.operationType = operation;
        HashMap operations = this.app.getOperationsMap();
        if (operations == null) {
            log.error("No operations defined in app '" + this.getAppID() + "' - creating empty config");
            operations = new HashMap();
        }
        Map serverOpConfig = (Map)operations.get(operation);
        Object dataSource = null;
        if (serverOpConfig != null) {
            dataSource = serverOpConfig.get("dataSource");
            if (serverOpConfig.get("type") != null) {
                this.operationType = (String)serverOpConfig.get("type");
            }
            if (dataSource != null) {
                if (dataSource instanceof String) {
                    this.dataSourceName = dataSource;
                } else {
                    List dataSources = dataSource;
                    this.dataSourceName = (String)dataSources.get(0);
                }
            }
        } else if (reqOpConfig != null && reqOpConfig.get("dataSource") != null) {
            this.operationType = (String)reqOpConfig.get("operationType");
            this.dataSourceName = (String)reqOpConfig.get("dataSource");
        } else if (operation != null && operation.indexOf(95) != -1) {
            this.operationType = operation.substring(operation.lastIndexOf(95) + 1);
            this.dataSourceName = operation.substring(0, operation.lastIndexOf(95));
        }
        if (!this.getAppID().equals(BUILTIN_APPLICATION)) {
            List qualifiedUserTypes = DataTools.makeList("*");
            try {
                DataTools.addAll(qualifiedUserTypes, this.app.userIsOfTypes());
            }
            catch (Exception e) {
                log.error((Object)"Can't look up app users", e);
            }
            Iterator i = qualifiedUserTypes.iterator();
            while (i.hasNext()) {
                String userType = (String)i.next();
                this.addConstraints(this.app.getConstraintsForUserType(userType, operation));
                this.addOutputs(this.app.getOutputsForUserType(userType, operation));
            }
        }
        if (this.outputs() == null && (outputs = (List)this.getParameter("outputs")) != null) {
            this.setOutputs(outputs);
        }
        HashMap opConfig = new HashMap();
        DataTools.mapMerge(serverOpConfig, opConfig);
        DataTools.mapMerge(reqOpConfig, opConfig);
        this.setOperationConfig(opConfig);
        Object sortOrder = this.getParameter("sortBy");
        if (sortOrder == null) {
            sortOrder = opConfig.get("sortBy");
        }
        this.setSortBy(sortOrder);
        Object cfgBatchSize = opConfig.get("batchSize");
        if (cfgBatchSize == null) {
            cfgBatchSize = opConfig.get("resultSize");
        }
        if (cfgBatchSize != null) {
            if (cfgBatchSize instanceof Long) {
                Long longCfgResultSize = (Long)cfgBatchSize;
                this.setBatchSize(longCfgResultSize.intValue());
            }
            if (cfgBatchSize instanceof String) {
                String stringCfgResultSize = (String)cfgBatchSize;
                this.setBatchSize(Long.parseLong(stringCfgResultSize));
            }
        }
        if ((paramResultSize = (String)this.getParameter("resultSize")) != null) {
            this.setBatchSize(Integer.parseInt(paramResultSize));
        }
        if ((startRow = this.getParameter("startRow")) != null) {
            this.setStartRow(Long.parseLong(startRow.toString()));
        }
        if ((endRow = this.getParameter("endRow")) != null) {
            this.setEndRow(Long.parseLong(endRow.toString()));
        }
    }

    public DSRequest(Map requestData, RequestContext context) throws Exception {
        this(requestData);
        if (this.getOperation() == null) {
            throw new Exception("operation not specified");
        }
        this.context = context;
        this.isClientRequest = true;
        this.parseUploadedFiles();
    }

    static {
        Class clazz = class$com$isomorphic$datasource$DSRequest;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$DSRequest = DSRequest.class("[Lcom.isomorphic.datasource.DSRequest;", false);
        }
        log = new Logger(clazz.getName());
        config = Config.getGlobal();
    }
}

