/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.JSExpressionType;
import com.isomorphic.datasource.SimpleType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSExpression;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.xml.XML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicDataSource
extends DataSource {
    private static Logger log;
    public static int numRecords;
    public static int numFields;
    private static final String CACHED_TYPE = "__cachedType";
    static final String builtinTypesFile = "builtinTypes.xml";
    static Map builtinTypes;
    protected Map ds2NativeFieldMap;
    protected Map native2DSFieldMap;
    protected Map derivedClientToServerFieldMap;
    protected Map derivedServerToClientFieldMap;
    protected Map dsFields;
    protected List primaryKeys;
    String superDSName;
    BasicDataSource superDS;
    public DataSource autoDeriveDS;
    static /* synthetic */ Class class$com$isomorphic$datasource$BasicDataSource;

    public static DataSource fromConfig(Map theConfig) throws Exception {
        String ID = (String)theConfig.get("ID");
        String dsType = BasicDataSource.getType(theConfig);
        if (dsType == null) {
            dsType = theConfig.get("tableName") != null ? "sql" : "basic";
        }
        String serverClass = (String)theConfig.get("serverConstructor");
        DataSource ds = null;
        if (serverClass != null) {
            try {
                log.debug("Using class " + serverClass + " as implementer for DataSource " + ID);
                ds = (DataSource)Reflection.newInstance(serverClass);
            }
            catch (Exception e) {
                log.warning("Couldn't create DataSource " + ID + " as an instance of class '" + serverClass + "', creating as a normal DataSource.  Problem was:\n" + DataTools.getStackTrace(e));
            }
        }
        if (ds == null) {
            if (dsType.equals("table") || dsType.equals("sql")) {
                ds = (DataSource)InterfaceProvider.load("SQLDataSource");
            } else if (dsType.equals("hibernate")) {
                ds = (DataSource)InterfaceProvider.load("HibernateDataSource");
            } else if (dsType.equals("LDAP")) {
                ds = (DataSource)InterfaceProvider.load("LDAPDataSource");
                ds = (DataSource)InterfaceProvider.load("HibernateDataSource");
            } else {
                ds = dsType.equals("session") ? (DataSource)InterfaceProvider.load("SessionDataSource") : new BasicDataSource();
            }
        }
        ds.init(theConfig);
        return ds;
    }

    public void init(Map theConfig) throws Exception {
        super.init(theConfig);
        this.ds2NativeFieldMap = new HashMap();
        this.native2DSFieldMap = new HashMap();
        this.derivedServerToClientFieldMap = new HashMap();
        this.derivedClientToServerFieldMap = new HashMap();
        this.primaryKeys = new ArrayList();
        if (this.dsConfig.get("fields") == null) {
            this.dsConfig.put("fields", new HashMap());
        }
        this.buildFieldData();
        this.superDSName = (String)this.dsConfig.get("inheritsFrom");
        this.superDS = this.getSuper();
        if (this.autoDeriveDS instanceof BasicDataSource) {
            this.superDS = (BasicDataSource)this.autoDeriveDS;
            this.superDSName = this.superDS.dsName;
        }
        if (this.superDS != null) {
            DataTools.addAsList(this.fieldList, this.superDS.getFieldNames());
        }
    }

    public Map ds2NativeFieldMap() {
        return this.ds2NativeFieldMap;
    }

    public Map native2DSFieldMap() {
        return this.native2DSFieldMap;
    }

    public String getSuperDSName() {
        return this.superDSName;
    }

    protected BasicDataSource getSuper() {
        if (this.autoDeriveDS instanceof BasicDataSource) {
            this.superDS = (BasicDataSource)this.autoDeriveDS;
            this.superDSName = this.superDS.dsName;
        }
        if (this.superDS == null && this.superDSName != null) {
            log.debug("Looking up superDS of DataSource " + this.getName() + ": '" + this.superDSName + '\'');
            try {
                this.superDS = (BasicDataSource)DataSourceManager.getDataSource(this.superDSName);
            }
            catch (Exception e) {
                log.warning("Exception loading DataSource " + this.superDSName + ": " + DataTools.getStackTrace(e));
            }
            if (this.superDS == null) {
                log.warning("DataSource " + this.getName() + " declared to inherit from DataSource " + this.superDSName + " which could not be loaded");
                this.superDSName = null;
            }
        }
        return this.superDS;
    }

    public void clearState() {
        if (this.superDS != null) {
            DataSourceManager.freeDataSource(this.superDS);
        }
        this.superDS = null;
    }

    public String getProperty(Object key) {
        Object value = this.dsConfig.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected void buildFieldData() throws Exception {
        String fieldName;
        Object origRawFields = this.dsConfig.get("fields");
        if (origRawFields instanceof List) {
            this.dsConfig.put("fields", DataTools.indexOnProperty((List)origRawFields, "name"));
        }
        this.dsFields = DataTools.mapMerge(this.getRawFields(), new HashMap());
        HashMap addFields = new HashMap();
        Iterator i = this.dsFields.keySet().iterator();
        while (i.hasNext()) {
            fieldName = (String)i.next();
            Object fd = this.dsFields.get(fieldName);
            if (!(fd instanceof Map)) {
                log.warn(this.dsName + ": value of field " + fieldName + " is not a Map");
                continue;
            }
            Map fieldData = (Map)fd;
            String type = (String)fieldData.get("type");
            String title = (String)fieldData.get("title");
            if (type == null || !type.equals("binary") && !type.equals("blob")) continue;
            HashMap<String, Object> filename = new HashMap<String, Object>();
            filename.put("name", fieldName + "_filename");
            filename.put("type", "text");
            filename.put("length", new Long(255L));
            filename.put("title", "Name");
            filename.put("hidden", new Boolean(true));
            filename.put("canEdit", new Boolean(false));
            addFields.put(fieldName + "_filename", filename);
            HashMap<String, Object> filesize = new HashMap<String, Object>();
            filesize.put("name", fieldName + "_filesize");
            filesize.put("type", "number");
            filesize.put("title", "Size");
            filesize.put("hidden", new Boolean(true));
            filesize.put("canEdit", new Boolean(false));
            addFields.put(fieldName + "_filesize", filesize);
            HashMap<String, Object> date_created = new HashMap<String, Object>();
            date_created.put("name", fieldName + "_date_created");
            date_created.put("type", "date");
            date_created.put("title", "Date Created");
            date_created.put("hidden", new Boolean(true));
            date_created.put("canEdit", new Boolean(false));
            addFields.put(fieldName + "_date_created", date_created);
        }
        DataTools.mapMerge(addFields, this.dsFields);
        Iterator e = new ArrayList(this.dsFields.keySet()).iterator();
        while (e.hasNext()) {
            fieldName = (String)e.next();
            Map fieldData = (Map)this.dsFields.get(fieldName);
            DSField field = null;
            if (!(fieldData instanceof DSField)) {
                field = new DSField(fieldData);
                this.dsFields.put(fieldName, field);
            } else {
                field = (DSField)fieldData;
            }
            if (!field.containsKey("name")) {
                field.put("name", fieldName);
            }
            if (field.getType() == null) {
                field.put("type", "text");
            }
            this.fieldList.add(fieldName);
            if (field.isDerived()) {
                if (field.getNativeName() == null) {
                    this.derivedClientToServerFieldMap.put(fieldName, fieldName);
                    continue;
                }
                this.derivedClientToServerFieldMap.put(fieldName, field.getNativeName());
                continue;
            }
            if (field.getNativeName() == null) {
                this.ds2NativeFieldMap.put(fieldName, fieldName);
            } else {
                this.ds2NativeFieldMap.put(fieldName, field.getNativeName());
            }
            if (!field.isPrimaryKey()) continue;
            this.primaryKeys.add(fieldName);
        }
        this.native2DSFieldMap = DataTools.reverseMap(this.ds2NativeFieldMap);
        this.derivedServerToClientFieldMap = DataTools.reverseMap(this.derivedClientToServerFieldMap);
        Object rawTypes = this.dsConfig.get("types");
        if (rawTypes instanceof List) {
            this.dsConfig.put("types", DataTools.indexOnProperty((List)rawTypes, "ID"));
        }
    }

    public Map getExpandedDs2NativeFieldMap() {
        Map fieldMap = new HashMap();
        if (this.getSuper() != null) {
            fieldMap = this.getSuper().ds2NativeFieldMap;
        }
        DataTools.mapMerge(this.ds2NativeFieldMap, fieldMap);
        return fieldMap;
    }

    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = (DSField)this.dsFields.get(fieldName);
        if (field == null && this.getSuper() != null) {
            field = this.getSuper().getField(fieldName);
        }
        return field;
    }

    public String getClientConstructor() {
        String constructor = (String)this.dsConfig.get("instanceConstructor");
        if (constructor == null) {
            constructor = (String)this.dsConfig.get("Constructor");
        }
        return constructor;
    }

    public List getPrimaryKeys() {
        List pks = new ArrayList();
        if (this.getSuper() != null) {
            pks = this.getSuper().getPrimaryKeys();
        }
        DataTools.addAll(pks, this.primaryKeys);
        return pks;
    }

    public Map getDerivedNativeToDSFieldMap() {
        return this.derivedServerToClientFieldMap;
    }

    public Map getDerivedDSToNativeFieldMap() {
        return this.derivedClientToServerFieldMap;
    }

    public boolean inheritsFrom(String dsName) {
        boolean bl = false;
        if (this.getName().equals(dsName) || this.getSuper() != null && this.getSuper().inheritsFrom(dsName)) {
            bl = true;
        }
        return bl;
    }

    public Object toRecords(Object data) throws Exception {
        return this.toRecords(data, new ValidationContext());
    }

    public Object toRecords(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            List recordList = (List)data;
            long start = System.currentTimeMillis();
            Object result = this.toRecords(recordList, context);
            long end = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Done validating " + recordList.size() + " '" + this.getName() + "'s at path '" + context.getPath() + "': " + (end - start) + "ms" + (recordList.size() == 0 ? "" : " (avg " + (end - start) / (long)recordList.size() + ')'));
            }
            return result;
        }
        long start = System.currentTimeMillis();
        Object result = this.toRecord(data, context);
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Done validating a '" + this.getName() + "' at path '" + context.getPath() + "': " + (end - start) + "ms");
        }
        return result;
    }

    public Object toRecords(List data, ValidationContext context) throws Exception {
        if (data == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating " + data.size() + " '" + this.getName() + "'s at path '" + context.getPath() + '\'');
        }
        ArrayList<Object> records = new ArrayList<Object>();
        int i = 0;
        while (i < data.size()) {
            records.add(this.toRecord(data.get(i), context));
            ++i;
        }
        return records;
    }

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating a '" + this.getName() + "' at path '" + context.getPath() + '\'');
        }
        ++numRecords;
        if (data instanceof Element) {
            return this.elementAsRecord((Element)data, context);
        }
        if (!(data instanceof Map)) {
            Logger.validation.warn("Unexpected Java type '" + data.getClass() + "' passed to DataSource '" + this.getName() + "' at path '" + context.getPath() + '\'');
            return data;
        }
        Map record = (Map)data;
        if (record.keySet().size() == 1 && record.get("ref") instanceof String) {
            return new JSExpression((String)record.get("ref"));
        }
        context.addPath(this.getName());
        record = new SequencedHashMap(record);
        HashSet keys = new HashSet(record.keySet());
        Iterator e = keys.iterator();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            DSField field = this.getField(fieldName);
            Object value = record.get(fieldName);
            if (field == null) {
                this.handleExtraValue(record, fieldName, value, context);
                continue;
            }
            if (value == null || value instanceof JSExpression) continue;
            record.put(fieldName, this.validateFieldValue(record, field, value, context));
        }
        this.checkStructure(record, context);
        this.checkAutoConstruct(record, context);
        context.removePathSegment();
        return record;
    }

    protected void handleExtraValue(Map record, String fieldName, Object value, ValidationContext context) throws Exception {
        if (value == null) {
            return;
        }
        Logger.validation.debug("Value provided for unknown field: " + this.getName() + '.' + fieldName + ": value is: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object elementAsRecord(Element element, ValidationContext context) throws Exception {
        List children;
        DataSource dsType;
        String declaredType;
        IType elementType = this.getExplicitType(element, context);
        if (elementType != null && elementType instanceof SimpleType) {
            log.debug("elementAsRecord using explicitly declared simple type: " + elementType.getName() + " at: " + context.getPath());
            return ((SimpleType)elementType).create(element, context);
        }
        if (elementType == null) {
            elementType = this.findElementType(element, context);
        }
        if (elementType != null && elementType instanceof DataSource && !(declaredType = (dsType = (DataSource)elementType).getName()).equals(this.getName())) {
            if (!(dsType.inheritsFrom(this.getName()) || declaredType.equals("JSExpression") || declaredType.equals("JS") || this.getName().equals("Object"))) {
                Logger.validation.warn("Element is an instance of type " + dsType.getName() + ", which does not inherit from declared field type " + this.getName() + " at " + context.getPath());
            }
            Logger.validation.debug(this.getName() + " delegating validation to type: " + dsType.getName() + " at " + context.getPath());
            return dsType.toRecords(element, context);
        }
        if (element.hasAttributes() && element.hasAttribute("ref") && element.getAttribute("ref").length() > 0 && element.getAttributes().getLength() == 1 && XML.getElementChildren(element).size() == 0) {
            return new JSExpression(element.getAttribute("ref"));
        }
        context.addPath(XML.getXPathSegment(element));
        SequencedHashMap record = new SequencedHashMap();
        Map attributes = XML.attributesToMap(element);
        Iterator i = attributes.keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                String value;
                children = XML.getElementChildren(element);
                if (!attributes.isEmpty() || !children.isEmpty() || (value = XML.toSimpleValue(element)) == null || "".equals(value.trim())) break;
                return new JSExpression(value);
            }
            String attrName = (String)i.next();
            DSField field = this.getField(attrName);
            Object attrValue = attributes.get(attrName);
            if (field == null) {
                record.put(attrName, attrValue);
                this.handleExtraValue((Map)record, attrName, attrValue, context);
                continue;
            }
            record.put(attrName, this.validateFieldValue((Map)record, field, attrValue, context));
        }
        Iterator e = children.iterator();
        while (true) {
            Element indirectChild;
            if (!e.hasNext()) {
                this.checkStructure((Map)record, context);
                this.checkAutoConstruct((Map)record, context);
                context.removePathSegment();
                return record;
            }
            Element child = (Element)e.next();
            String fieldName = child.getTagName();
            DSField field = this.getField(fieldName);
            if (child.hasAttribute("_isc_name")) {
                fieldName = child.getAttributeNS(null, "_isc_name");
                child.removeAttribute("_isc_name");
            }
            if ((elementType = this.getExplicitType(child, context)) != null) {
                try {
                    DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, fieldName, elementType, child, context));
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    throw throwable;
                }
                {
                    Object var12_16 = null;
                    continue;
                }
            }
            List indirectChildren = XML.getElementChildren(child);
            boolean haveSingleJSExpression = false;
            if (field != null && field.isMultiple() && indirectChildren.size() == 1) {
                Element onlyChild = (Element)indirectChildren.get(0);
                IType type = this.getExplicitType(onlyChild, context);
                if (type == null) {
                    type = this.findElementType(onlyChild, context);
                }
                if (type instanceof JSExpressionType) {
                    haveSingleJSExpression = true;
                }
            }
            if (field != null && field.isMultiple() && !haveSingleJSExpression) {
                Object value;
                if (!indirectChildren.isEmpty()) {
                    value = indirectChildren;
                    DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, value, context));
                    continue;
                }
                if (child.hasAttributes()) {
                    DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, child, context));
                    continue;
                }
                value = XML.toSimpleValue(child);
                if (value != null && !"".equals(((String)value).trim())) {
                    if (record.containsKey(fieldName)) continue;
                    record.put(fieldName, new JSExpression((String)value));
                    continue;
                }
                if (record.containsKey(fieldName)) continue;
                record.put(fieldName, new ArrayList());
                continue;
            }
            if (indirectChildren.size() == 1 && (elementType = this.findElementType(indirectChild = (Element)indirectChildren.get(0), context)) != null) {
                Object var15_21;
                try {
                    DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, fieldName, elementType, indirectChild, context));
                    var15_21 = null;
                }
                catch (Throwable throwable) {
                    var15_21 = null;
                    throw throwable;
                }
            }
            if (field != null) {
                DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, child, context));
                continue;
            }
            this.handleExtraElementValue((Map)record, fieldName, child, indirectChildren, context);
        }
    }

    protected void handleExtraElementValue(Map record, String fieldName, Element child, List indirectChildren, ValidationContext context) throws Exception {
        Object value = null;
        if (indirectChildren.size() == 0 && !child.hasAttributes()) {
            value = XML.toSimpleValue(child);
        } else {
            BasicDataSource objectDS = context.getType("Object");
            value = ((DataSource)objectDS).toRecord(child, context);
        }
        if (!record.containsKey(fieldName)) {
            record.put(fieldName, value);
        } else {
            DataTools.putCombinedList(record, fieldName, value);
        }
        this.handleExtraValue(record, fieldName, value, context);
    }

    protected Object validateFieldValue(Map record, DSField field, Object value, ValidationContext context) throws Exception {
        return this.validateFieldValue(record, field.getName(), null, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object validateFieldValue(Map record, String fieldName, IType declaredType, Object value, ValidationContext context) throws Exception {
        Object object;
        ++numFields;
        context.addPath(fieldName);
        try {
            IType type;
            DSField field = this.getField(fieldName);
            IType fieldType = this.getFieldType(fieldName, context);
            if (declaredType != null) {
                // empty if block
            }
            IType iType = type = declaredType != null ? declaredType : fieldType;
            if (type == null && field != null) {
                Logger.validation.warning("No such type '" + field.getType() + "', not processing field value at " + context.getPath());
                Object object2 = value;
                Object var7_11 = null;
                context.removePathSegment();
                return object2;
            }
            if (Logger.validation.isDebugEnabled()) {
                Logger.validation.debug("Validating field:\n" + context.getPath() + " as " + this.getName() + '.' + fieldName + " type: " + type.getName());
            }
            boolean enabledPropertiesOnly = false;
            try {
                if (field != null && field.isPropertiesOnly() && !context.isPropertiesOnly()) {
                    context.setPropertiesOnly();
                    enabledPropertiesOnly = true;
                }
                object = type.create(value, context);
                Object var14_15 = null;
                if (enabledPropertiesOnly) {
                    context.setPropertiesOnly(false);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (!enabledPropertiesOnly) throw throwable;
                context.setPropertiesOnly(false);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            context.removePathSegment();
            throw throwable;
        }
        Object var7_12 = null;
        context.removePathSegment();
        return object;
    }

    public void checkStructure(Map record, ValidationContext context) {
        Iterator i = this.getFieldNames().iterator();
        while (i.hasNext()) {
            Object value;
            String fieldName = (String)i.next();
            DSField field = this.getField(fieldName);
            if (!this.checkRequired(record, field, value = record.get(fieldName), context) || value == null && !record.containsKey(fieldName)) continue;
            if (value instanceof JSExpression) {
                return;
            }
            if (field.isMultiple()) {
                value = DataTools.makeListIfSingle(value);
            }
            record.put(fieldName, value);
            if (field.getUniqueProperty() == null) continue;
            value = DataTools.indexOnProperty(DataTools.makeListIfSingle(value), field.getUniqueProperty());
            record.put(fieldName, value);
        }
    }

    public boolean checkRequired(Map record, DSField field, Object value, ValidationContext context) {
        if (field.isRequired() && ("".equals(value) || value == null && (!context.isPropertiesOnly() || record.containsKey(field.getName())))) {
            context.addError(field.getName(), new ErrorMessage("Field is required"));
            return false;
        }
        return true;
    }

    public void checkAutoConstruct(Map record, ValidationContext context) {
        String constructor;
        boolean propertiesOnly;
        boolean bl = false;
        if (context.isPropertiesOnly() || DataTools.getBoolean(record, "propertiesOnly")) {
            bl = propertiesOnly = true;
        }
        if ((constructor = (String)record.get("constructor")) == null) {
            constructor = this.getClientConstructor();
        }
        if (constructor != null) {
            if (!propertiesOnly) {
                record.put("__autoConstruct", constructor);
            } else {
                record.put("_constructor", constructor);
                if (record.containsKey("constructor")) {
                    record.remove("constructor");
                }
            }
        }
    }

    public IType findElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        IType type = this.getType(tagName, context);
        return type;
    }

    public IType getExplicitType(Element element, ValidationContext context) throws Exception {
        IType type = null;
        String xsType = element.getAttribute("xsi:type");
        if (xsType != null) {
            if (xsType.startsWith("xsd:")) {
                xsType = xsType.substring(4);
            }
            if ((type = this.getType(xsType, context)) != null) {
                return type;
            }
        }
        String constructor = element.getAttribute("constructor");
        type = this.getType(constructor, context);
        return type;
    }

    protected IType getFieldType(String fieldName, ValidationContext context) throws Exception {
        ArrayList<Map> allValidators;
        SimpleType type;
        Object fieldValidators;
        boolean isEnumType;
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        String typeId = field.getType();
        IType baseType = this.getType(typeId, context);
        if (baseType instanceof DataSource) {
            return baseType;
        }
        boolean bl = false;
        if (this.simpleTypeInheritsFrom(typeId, "enum") || this.simpleTypeInheritsFrom(typeId, "intEnum")) {
            bl = isEnumType = true;
        }
        if ((fieldValidators = field.get("validators")) == null) {
            if (isEnumType) {
                fieldValidators = new ArrayList();
            } else {
                return baseType;
            }
        }
        if ((type = (SimpleType)field.get(CACHED_TYPE)) != null) {
            return type;
        }
        Object typeValidators = null;
        if (baseType != null) {
            typeValidators = ((SimpleType)baseType).getValidators();
        }
        if ((allValidators = DataTools.makeListIfSingle(DataTools.combineAsLists(typeValidators, fieldValidators))) == null) {
            allValidators = new ArrayList<Map>();
        }
        if (isEnumType) {
            Map localType;
            Object valueMap = field.get("valueMap");
            if (valueMap == null && (localType = this.getLocalType(typeId)) != null) {
                valueMap = localType.get("valueMap");
            }
            Collection<Object> list = null;
            if (valueMap instanceof Map) {
                list = ((Map)valueMap).keySet();
            } else if (valueMap instanceof Collection) {
                list = (Collection)valueMap;
            }
            if (list != null && list.size() > 0) {
                boolean found = false;
                Iterator i = allValidators.iterator();
                while (i.hasNext()) {
                    Map validator;
                    Object o = i.next();
                    if (!(o instanceof Map) || !"isOneOf".equals((validator = (Map)o).get("type")) || validator.containsKey("list")) continue;
                    validator.put("list", list);
                    found = true;
                }
                if (!found) {
                    allValidators.add(0, DataTools.buildMap("type", "isOneOf", "list", list));
                }
            } else {
                log.warn("Can't auto-generate enum validators for field: " + fieldName + " of type: " + typeId);
            }
        }
        if (Logger.validation.isDebugEnabled()) {
            Logger.validation.debug("Creating field validator for field " + this.getName() + '.' + field.getName() + ", of simple type: " + field.getType() + ", with inline validators: " + fieldValidators + ", and type validators: " + typeValidators);
        }
        type = new SimpleType(typeId, allValidators);
        field.put(CACHED_TYPE, type);
        return type;
    }

    protected IType makeType(String typeId, Map typeDef) throws Exception {
        if (typeDef == null) {
            return null;
        }
        SimpleType type = (SimpleType)typeDef.get(CACHED_TYPE);
        if (type != null) {
            return type;
        }
        if (Logger.validation.isDebugEnabled()) {
            Logger.validation.debug("Creating simple type validator for simple type: " + typeId);
        }
        type = new SimpleType(typeId, this.getSimpleTypeValidators(typeDef));
        typeDef.put(CACHED_TYPE, type);
        return type;
    }

    protected IType getType(String typeId, ValidationContext context) throws Exception {
        Map typeDef = this.getBuiltinType(typeId);
        if (typeDef != null) {
            return this.makeType(typeId, typeDef);
        }
        typeDef = this.getLocalType(typeId);
        if (typeDef != null) {
            log.debug("Using local type " + typeId);
            if (typeDef.get("fields") != null) {
                DataSource ds = context.getType(typeId);
                if (ds == null) {
                    ds = DataSource.fromConfig(typeDef);
                }
                return ds;
            }
            return this.makeType(typeId, typeDef);
        }
        DataSource ds = this.findDataSource(typeId, context);
        if (ds != null) {
            return ds;
        }
        return null;
    }

    protected Map getSimpleTypeDef(String typeId) throws Exception {
        Map typeDef = this.getBuiltinType(typeId);
        if (typeDef != null) {
            return typeDef;
        }
        typeDef = this.getLocalType(typeId);
        if (typeDef != null && typeDef.get("fields") == null) {
            return typeDef;
        }
        return null;
    }

    public String getSimpleBaseType(String typeId) throws Exception {
        Map typeDef = this.getSimpleTypeDef(typeId);
        while (typeDef != null) {
            String parentTypeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId == null) {
                return typeId;
            }
            Map parentTypeDef = this.getSimpleTypeDef(parentTypeId);
            if (parentTypeDef == null) {
                log.warn("type: " + typeId + " declares inheritsFrom: " + parentTypeId + " but parentTypeId could not be found");
                return typeId;
            }
            typeId = parentTypeId;
            typeDef = parentTypeDef;
        }
        return null;
    }

    public boolean simpleTypeInheritsFrom(String typeId, String parentTypeId) throws Exception {
        if (parentTypeId.equals(typeId)) {
            return true;
        }
        Map typeDef = this.getSimpleTypeDef(typeId);
        while (typeDef != null) {
            typeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId.equals(typeId)) {
                return true;
            }
            typeDef = this.getSimpleTypeDef(typeId);
        }
        return false;
    }

    public Object getSimpleTypeValidators(Map type) throws Exception {
        Object validators = type.get("validators");
        String parentTypeID = (String)type.get("inheritsFrom");
        if (parentTypeID != null) {
            Map parentType = this.getLocalType(parentTypeID);
            if (parentType == null) {
                parentType = this.getBuiltinType(parentTypeID);
            }
            Object parentValidators = parentType.get("validators");
            validators = DataTools.combineAsLists(parentValidators, validators);
        }
        return validators;
    }

    protected Map getLocalType(String typeID) throws Exception {
        if (typeID == null) {
            return null;
        }
        Map types = (Map)this.dsConfig.get("types");
        if (types != null && types.get(typeID) != null) {
            return (Map)types.get(typeID);
        }
        if (this.getSuper() != null) {
            return this.getSuper().getLocalType(typeID);
        }
        return null;
    }

    protected DataSource findDataSource(String dsName, ValidationContext context) throws Exception {
        if (dsName == null) {
            return null;
        }
        Map type = this.getLocalType(dsName);
        if (type != null && type.get("fields") != null) {
            log.debug("Getting DataSource " + dsName + " as a locally defined type");
            DataSource ds = context.getType(dsName);
            if (ds == null) {
                ds = DataSource.fromConfig(type);
            }
            return ds;
        }
        return context.getType(dsName);
    }

    public Map getBuiltinType(String typeID) throws Exception {
        if (typeID == null) {
            return null;
        }
        return (Map)builtinTypes.get(typeID);
    }

    public Map selectUnique(Map constraints) throws Exception {
        return this.selectSingle(DataTools.subsetMap(constraints, this.primaryKeys));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.dsFields = null;
        this.superDSName = null;
        this.superDS = null;
        this.autoDeriveDS = null;
    }

    public BasicDataSource() {
        this.this();
    }

    static {
        Class clazz = class$com$isomorphic$datasource$BasicDataSource;
        if (clazz == null) {
            clazz = class$com$isomorphic$datasource$BasicDataSource = BasicDataSource.class("[Lcom.isomorphic.datasource.BasicDataSource;", false);
        }
        log = new Logger(clazz.getName());
        numRecords = 0;
        numFields = 0;
        builtinTypes = new HashMap();
        List paths = config.getCommaSeparatedList("framework.datasources");
        SequencedHashMap triedPaths = new SequencedHashMap();
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            String dsDirPath = ISCFile.canonicalizePath((String)j.next());
            String fileName = null;
            try {
                fileName = dsDirPath + "/builtinTypes.xml";
                builtinTypes = (Map)XML.toDSRecords(fileName);
                if (builtinTypes == null) continue;
                break;
            }
            catch (Exception e) {
                triedPaths.put(fileName, e);
            }
        }
        if (builtinTypes.size() == 0) {
            System.out.println("Problem loading builtinTypes.xml");
            Iterator i = triedPaths.keySet().iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                Exception e = (Exception)triedPaths.get(path);
                System.out.println("Exception when loading from " + path + ":\n" + DataTools.getStackTrace(e));
            }
        }
    }
}

