/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Base;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Reflection
extends Base {
    private static final String initializerMethodName = "_initialize";
    private static Logger log;
    private static Map reflectionCache;
    static /* synthetic */ Class class$com$isomorphic$base$Reflection;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Queue;

    public static Class classForName(String name) throws Exception {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static Throwable getRealTargetException(Throwable ite) {
        if (ite instanceof InvocationTargetException) {
            return Reflection.getRealTargetException(((InvocationTargetException)ite).getTargetException());
        }
        return ite;
    }

    public static Object instantiateClass(String className) throws Exception {
        return Reflection.instantiateClass(className, null);
    }

    public static Object instantiateClass(String className, Object[] initArgs) throws Exception {
        Map classCache = Reflection.getClassCache(className);
        Object classInstance = Reflection.newInstance((Class)classCache.get("ClassObject"));
        try {
            Reflection.invokeMethod(classInstance, initializerMethodName, initArgs);
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        return classInstance;
    }

    public static Object newInstance(String className) throws Exception {
        return Reflection.newInstance(Reflection.classForName(className));
    }

    /*
     * WARNING - void declaration
     */
    public static Object newInstance(Class clazz) throws Exception {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            void ie;
            iae = new IllegalAccessException("Instantiation of class: " + clazz.getName() + " threw an IllegalAccessException - either the class or its zero-argument constructor is not accessible");
            iae.fillInStackTrace();
            throw ie;
        }
        catch (InstantiationException ie) {
            void eiie;
            ie = new InstantiationException("Instantiation of class: " + clazz.getName() + " threw an InstantiationException - most likely cause is the class represents an abstract class, an interface, an array class, a primitive type, or void; or the class has no zero-argument constructor.");
            ie.fillInStackTrace();
            throw eiie;
        }
        catch (ExceptionInInitializerError eiie) {
            void se;
            eiie = new ExceptionInInitializerError("Instantiation of class: " + clazz.getName() + " threw an ExceptionInInitializerError - most likely cause is a failure to initialize the class (check your static initializers). Root cause: " + eiie.getCause().toString());
            eiie.fillInStackTrace();
            throw se;
        }
        catch (SecurityException se) {
            se = new SecurityException("Instantiation of class: " + clazz.getName() + " threw a SecurityException - most likely cause is that there is no permissio nto create a new instance of this class - error: " + se.toString());
            se.fillInStackTrace();
            throw se;
        }
    }

    private static final Map populateClassCache(String className) throws Exception {
        HashMap<String, Serializable> classCache = new HashMap<String, Serializable>();
        reflectionCache.put(className, classCache);
        Class classObject = Reflection.classForName(className);
        classCache.put("ClassObject", classObject);
        HashMap methodCache = new HashMap();
        classCache.put("methods", methodCache);
        Method[] classMethods = classObject.getMethods();
        int ii = 0;
        while (ii < classMethods.length) {
            Method method = classMethods[ii];
            Reflection.addMethodToCache(method, methodCache);
            ++ii;
        }
        return classCache;
    }

    private static final void addMethodToCache(Method method, Map methodCache) throws Exception {
        String methodName = method.getName();
        Object value = methodCache.get(methodName);
        if (value == null) {
            methodCache.put(methodName, method);
        } else if (value instanceof Method) {
            HashMap argCache = new HashMap();
            methodCache.put(methodName, argCache);
            Reflection.addMethodToCache((Method)value, methodCache);
            Reflection.addMethodToCache(method, methodCache);
        } else if (value instanceof Map) {
            Map argCache = (Map)value;
            Integer numArgs = new Integer(method.getParameterTypes().length);
            Object argValue = argCache.get(numArgs);
            if (argValue == null) {
                argCache.put(numArgs, method);
            } else if (argValue instanceof Method) {
                ArrayList<Method> argList = new ArrayList<Method>();
                argList.add(method);
                argList.add((Method)argValue);
            } else if (argValue instanceof List) {
                ((List)argValue).add(method);
            }
        }
    }

    private static final Class[] lookupTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] result = new Class[args.length];
        int ii = 0;
        while (ii < args.length) {
            result[ii] = args[ii] == null ? null : args[ii].getClass();
            ++ii;
        }
        return result;
    }

    public static Method findMethod(String methodName) throws Exception {
        int index = methodName.lastIndexOf(46);
        return Reflection.findMethod(methodName.substring(0, index), methodName.substring(index + 1));
    }

    public static Method findMethod(String className, String methodName) throws Exception {
        return Reflection.findMethod(className, methodName, new Class[0]);
    }

    public static Method findMethod(Object instance, String methodName) throws Exception {
        return Reflection.findMethod(instance.getClass().getName(), methodName, new Class[0]);
    }

    public static Method findMethod(String className, String methodName, Class[] methodArgs) throws Exception {
        Map classCache = Reflection.getClassCache(className);
        Class classObject = (Class)classCache.get("ClassObject");
        Map methodCache = (Map)classCache.get("methods");
        Method directLookup = null;
        try {
            directLookup = classObject.getMethod(methodName, methodArgs);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (directLookup != null) {
            return directLookup;
        }
        Object value = methodCache.get(methodName);
        if (value == null) {
            String message = "Method " + methodName + " not found on class " + className;
            throw new NoSuchMethodException(message);
        }
        if (value instanceof Method) {
            return (Method)value;
        }
        if (value instanceof Map) {
            Object argValue = ((Map)value).get(new Integer(methodArgs.length));
            if (argValue == null) {
                String message = "Method " + methodName + " exists on " + className + " but with a different number of parameters - you passed in " + methodArgs.length;
                throw new NoSuchMethodException(message);
            }
            if (argValue instanceof Method) {
                return (Method)argValue;
            }
            if (argValue instanceof List) {
                String message = "Method " + className + '.' + methodName + " is overloaded with the same number of parameters (" + methodArgs.length + ") - this is not supported.";
                throw new Exception(message);
            }
            String message = "Shouldn't happen: reflectionCache is corrupt - method lookup by param number returned object type: " + methodName;
            throw new Exception(message);
        }
        String message = "Shouldn't happen: reflectionCache is corrupt - method lookup returned object type: " + methodName;
        throw new Exception(message);
    }

    private static final synchronized Map getClassCache(String className) throws Exception {
        Map classCache = (Map)reflectionCache.get(className);
        if (classCache == null) {
            classCache = Reflection.populateClassCache(className);
        }
        return classCache;
    }

    public static Object invokeMethod(Object classInstance, String methodName) throws Exception {
        return Reflection.invokeMethod(classInstance, methodName, new Object[0]);
    }

    public static Object invokeMethod(Object classInstance, String methodName, Object[] params) throws Exception {
        try {
            Method method = Reflection.findMethod(classInstance.getClass().getName(), methodName, Reflection.lookupTypes(params));
            return method.invoke(classInstance, params);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = Reflection.getRealTargetException(ite);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            log.error("invokeMethod() for method '" + methodName + "' caught a throwable that is neither an Exception nor an Error. Repackaging and re-throwing as an Error");
            Error error = new Error(throwable.getMessage());
            error.fillInStackTrace();
            throw error;
        }
    }

    public static Object invokeMethod(Object classInstance, String methodName, Object param1) throws Exception {
        Object[] params = new Object[]{param1};
        return Reflection.invokeMethod(classInstance, methodName, params);
    }

    public static Object invokeMethod(Object classInstance, String methodName, Object param1, Object param2) throws Exception {
        Object[] params = new Object[]{param1, param2};
        return Reflection.invokeMethod(classInstance, methodName, params);
    }

    public static Object invokeMethod(Object classInstance, String methodName, Object param1, Object param2, Object param3) throws Exception {
        Object[] params = new Object[]{param1, param2, param3};
        return Reflection.invokeMethod(classInstance, methodName, params);
    }

    public static Object invokeStaticMethod(String className, String methodName) throws Exception {
        Object[] params = new Object[]{};
        return Reflection.invokeStaticMethod(className, methodName, params);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object param1) throws Exception {
        Object[] params = new Object[]{param1};
        return Reflection.invokeStaticMethod(className, methodName, params);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object param1, Object param2) throws Exception {
        Object[] params = new Object[]{param1, param2};
        return Reflection.invokeStaticMethod(className, methodName, params);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object param1, Object param2, Object param3) throws Exception {
        Object[] params = new Object[]{param1, param2, param3};
        return Reflection.invokeStaticMethod(className, methodName, params);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] params) throws Exception {
        try {
            Method method = Reflection.findMethod(className, methodName, Reflection.lookupTypes(params));
            return method.invoke(null, params);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = Reflection.getRealTargetException(ite);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            log.error("invokeStaticMethod() for method '" + methodName + "' caught a throwable that is neither an Exception or an Error. Repackaging and re-throwing as an Error");
            Error error = new Error(throwable.getMessage());
            error.fillInStackTrace();
            throw error;
        }
    }

    private static final String getFormattedParamTypes(Object[] params) {
        String result = "";
        if (params == null || params.length == 0) {
            return "(empty parameter list)";
        }
        int ii = 0;
        while (ii < params.length) {
            result = result + (params[ii] != null ? params[ii].getClass().getName() : "null");
            if (ii + 1 < params.length) {
                result = result + ", ";
            }
            ++ii;
        }
        return result;
    }

    private static final String getFormattedMethodSignature(Method method) {
        if (method == null) {
            return null;
        }
        String result = method.getReturnType().getName() + ' ' + method.getDeclaringClass().getName() + '.' + method.getName() + '(';
        Class<?>[] paramTypes = method.getParameterTypes();
        int ii = 0;
        while (ii < paramTypes.length) {
            result = result + paramTypes[ii].getName();
            if (ii + 1 < paramTypes.length) {
                result = result + ", ";
            }
            ++ii;
        }
        result = result + ')';
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            result = result + " throws ";
            int ii2 = 0;
            while (ii2 < exceptionTypes.length) {
                result = result + exceptionTypes[ii2].getName();
                if (ii2 + 1 < exceptionTypes.length) {
                    result = result + ", ";
                }
                ++ii2;
            }
        }
        return result;
    }

    public static Object adaptArgsAndInvoke(Object instance, Method method, ReflectionArgument[] requiredArgs) throws Exception {
        return Reflection.adaptArgsAndInvoke(instance, method, requiredArgs, null, null);
    }

    public static Object adaptArgsAndInvoke(Object instance, Method method, ReflectionArgument[] requiredArgs, ReflectionArgument[] optionalArgs) throws Exception {
        return Reflection.adaptArgsAndInvoke(instance, method, requiredArgs, optionalArgs, null);
    }

    public static Object adaptArgsAndInvoke(Object instance, Method method, ReflectionArgument[] requiredArgs, ReflectionArgument[] optionalArgs, DataSource dataSource) throws Exception {
        ArrayList<Object> methodArgs = new ArrayList<Object>();
        if (optionalArgs == null) {
            optionalArgs = new ReflectionArgument[]{};
        }
        if (requiredArgs == null) {
            requiredArgs = new ReflectionArgument[]{};
        }
        log.debug("adaptArgsAndInvoke:\n\n " + method.toString() + "\n\nrequiredArgs: " + Reflection.typesAsString(requiredArgs) + " optionalArgs: " + Reflection.typesAsString(optionalArgs));
        int requiredArgIndex = 0;
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        List genericParamTypes = VersionSafeChecker.getGenericParameterTypes(method);
        int i = 0;
        while (i < parameterTypes.size()) {
            block25: {
                ReflectionArgument reqArg;
                VersionSafeChecker.GenericParameterNode genericParamInfo;
                Class<?> paramType;
                block24: {
                    paramType = parameterTypes.get(i);
                    genericParamInfo = (VersionSafeChecker.GenericParameterNode)genericParamTypes.get(i);
                    if (genericParamInfo != null && genericParamInfo.getClassByIndex(0) == paramType) {
                        genericParamInfo = genericParamInfo.getChildNode();
                    }
                    Exception requiredAdaptException = null;
                    reqArg = null;
                    if (requiredArgIndex < requiredArgs.length) {
                        reqArg = requiredArgs[requiredArgIndex];
                        boolean assignedRequiredArg = false;
                        try {
                            if (reqArg.getValue() == null) {
                                boolean optionalArgMatch = false;
                                int k = 0;
                                while (k < optionalArgs.length) {
                                    if (paramType.isAssignableFrom(optionalArgs[k].getType())) {
                                        Class clazz = class$java$lang$Object;
                                        if (clazz == null) {
                                            clazz = Reflection.class("[Ljava.lang.Object;", false);
                                        }
                                        if (!paramType.isAssignableFrom(clazz)) {
                                            optionalArgMatch = true;
                                            break;
                                        }
                                    }
                                    ++k;
                                }
                                if (optionalArgMatch) {
                                    log.debug("not assigning null value to optional arg slot: " + paramType.getName());
                                } else {
                                    methodArgs.add(null);
                                    assignedRequiredArg = true;
                                }
                            } else {
                                methodArgs.add(Reflection.adaptValue(paramType, genericParamInfo, reqArg, optionalArgs, dataSource, null, null, null));
                                assignedRequiredArg = true;
                            }
                            if (!assignedRequiredArg) break block24;
                            if (log.isDebugEnabled()) {
                                log.debug("Successfully adapted required arg type: " + (reqArg.getType() == null ? "null" : reqArg.getType().getName()) + " to type: " + paramType.getName());
                            }
                            ++requiredArgIndex;
                            break block25;
                        }
                        catch (Exception e) {
                            if (log.isDebugEnabled()) {
                                Class type = requiredArgs[requiredArgIndex].getType();
                                log.debug("Failed to adapt required arg type: " + (type == null ? "null" : type.getName()) + " to type: " + paramType.getName() + ". Error string: " + e.toString() + " in " + e.getStackTrace()[0].toString());
                            }
                            requiredAdaptException = e;
                        }
                    }
                }
                boolean assignedOptionalArg = false;
                int j = 0;
                while (j < optionalArgs.length) {
                    ReflectionArgument optionalArg = optionalArgs[j];
                    try {
                        methodArgs.add(Reflection.adaptValue(paramType, genericParamInfo, optionalArg, optionalArgs, dataSource, null, null, null));
                        assignedOptionalArg = true;
                        if (!log.isDebugEnabled()) break;
                        log.debug("Successfully adapted optional arg type: " + optionalArg.getType().getName() + " to type: " + paramType.getName());
                        break;
                    }
                    catch (Exception e) {
                        Class<?> clazz = e.getClass();
                        Class clazz2 = class$java$lang$Exception;
                        if (clazz2 == null) {
                            clazz2 = Reflection.class("[Ljava.lang.Exception;", false);
                        }
                        if (clazz != clazz2) {
                            log.warn("Exception occurred attempting to map arguments: " + e.toString() + " in " + e.getStackTrace()[0].toString());
                        }
                        ++j;
                    }
                }
                if (!assignedOptionalArg) {
                    String errorString = "Unable to assign a required or optional argument to slot #" + (i + 1) + " taking type: " + paramType.getName() + " of method:\n\n" + method.toString() + "\n\nNo remaining optional arguments match this type";
                    errorString = reqArg != null ? errorString + ".  The next required argument passed by the client was of type: " + (reqArg.getType() == null ? "null" : reqArg.getType().getName()) + '.' : errorString + " and all required arguments passed by the client have already been assigned.";
                    if (optionalArgs.length == 0) {
                        errorString = errorString + "  Note that no optional arguments were available for this assignment, likely because your method definition in your .app.xml file specifies explicit methodArguments.  Please check to make sure this methodArguments declaration matches your method signature.";
                    }
                    errorString = errorString + "\n\n";
                    throw new Exception(errorString);
                }
            }
            ++i;
        }
        Object[] args = DataTools.listToArray(methodArgs);
        log.debug("method takes: " + parameterTypes.size() + " args.  I've assembled: " + methodArgs.size() + " args");
        log.debug("invoking method:\n" + Reflection.getFormattedMethodSignature(method) + "\n\nwith arg types: " + Reflection.getFormattedParamTypes(args));
        return method.invoke(instance, args);
    }

    private static final String typesAsString(Class[] classes) {
        ArrayList<String> result = new ArrayList<String>();
        if (classes == null) {
            return ((Object)result).toString();
        }
        int i = 0;
        while (i < classes.length) {
            result.add(classes[i].getName());
            ++i;
        }
        return ((Object)result).toString();
    }

    private static final String typesAsString(ReflectionArgument[] args) {
        ArrayList<String> result = new ArrayList<String>();
        if (args == null) {
            return ((Object)result).toString();
        }
        int i = 0;
        while (i < args.length) {
            Class type = args[i].getType();
            if (type == null) {
                result.add("null");
            } else {
                result.add(type.getName());
            }
            ++i;
        }
        return ((Object)result).toString();
    }

    public static Object adaptValue(Class targetType, VersionSafeChecker.GenericParameterNode targetGenericInfo, ReflectionArgument arg, ReflectionArgument[] optionalArgs, DataSource dataSource, Class javaClass, Class javaCollectionClass, Class javaKeyClass) throws Exception {
        String targetTypeName;
        ArrayList argValue;
        String argTypeName;
        Class<?> argType;
        block94: {
            block93: {
                block92: {
                    block91: {
                        Object newArgValue;
                        block90: {
                            argType = arg.getType();
                            argTypeName = argType == null ? "null" : argType.getName();
                            argValue = arg.getValue();
                            targetTypeName = targetType.getName();
                            if (argType == null && argValue == null) {
                                return null;
                            }
                            log.debug("checking whether type: " + argTypeName + " fulfills type: " + targetTypeName);
                            Class clazz = class$java$util$Collection;
                            if (clazz == null) {
                                clazz = class$java$util$Collection = Reflection.class("[Ljava.util.Collection;", false);
                            }
                            if (clazz.isAssignableFrom(targetType)) break block90;
                            Class clazz2 = class$java$util$Map;
                            if (clazz2 == null) {
                                clazz2 = class$java$util$Map = Reflection.class("[Ljava.util.Map;", false);
                            }
                            if (!clazz2.isAssignableFrom(targetType)) break block91;
                        }
                        if (optionalArgs != null) {
                            int i = 0;
                            while (i < optionalArgs.length) {
                                Class optionalType = optionalArgs[i].getType();
                                if (optionalType == argType && !optionalArgs[i].allowTypeConversion()) {
                                    throw new Exception(argTypeName + " not adaptable to: " + targetTypeName);
                                }
                                ++i;
                            }
                        }
                        Iterator<Object> i = null;
                        if (javaCollectionClass != null) {
                            newArgValue = javaCollectionClass.newInstance();
                        } else if (targetType.isInterface() || Modifier.isAbstract(targetType.getModifiers())) {
                            Class clazz = class$java$util$Map;
                            if (clazz == null) {
                                clazz = class$java$util$Map = Reflection.class("[Ljava.util.Map;", false);
                            }
                            if (clazz.isAssignableFrom(targetType)) {
                                newArgValue = new SequencedHashMap();
                            } else {
                                Class clazz3 = class$java$util$List;
                                if (clazz3 == null) {
                                    clazz3 = class$java$util$List = Reflection.class("[Ljava.util.List;", false);
                                }
                                if (clazz3.isAssignableFrom(targetType)) {
                                    newArgValue = new ArrayList();
                                } else {
                                    Class clazz4 = class$java$util$Set;
                                    if (clazz4 == null) {
                                        clazz4 = class$java$util$Set = Reflection.class("[Ljava.util.Set;", false);
                                    }
                                    if (clazz4.isAssignableFrom(targetType)) {
                                        newArgValue = new HashSet();
                                    } else {
                                        Class clazz5 = class$java$util$Queue;
                                        if (clazz5 == null) {
                                            clazz5 = class$java$util$Queue = Reflection.class("[Ljava.util.Queue;", false);
                                        }
                                        if (clazz5.isAssignableFrom(targetType)) {
                                            newArgValue = new LinkedList();
                                        } else {
                                            Class clazz6 = class$java$util$Collection;
                                            if (clazz6 == null) {
                                                clazz6 = class$java$util$Collection = Reflection.class("[Ljava.util.Collection;", false);
                                            }
                                            newArgValue = clazz6.isAssignableFrom(targetType) ? new ArrayList() : argValue.getClass().newInstance();
                                        }
                                    }
                                }
                            }
                        } else {
                            newArgValue = targetType.newInstance();
                        }
                        Object key = null;
                        Class clazz = class$java$lang$Object;
                        if (clazz == null) {
                            clazz = class$java$lang$Object = Reflection.class("[Ljava.lang.Object;", false);
                        }
                        Class keyClass = clazz;
                        Class<?> valueClass = null;
                        Class clazz7 = class$java$util$Collection;
                        if (clazz7 == null) {
                            clazz7 = class$java$util$Collection = Reflection.class("[Ljava.util.Collection;", false);
                        }
                        if (clazz7.isAssignableFrom(targetType)) {
                            Map map;
                            if (argValue instanceof Map && (map = (Map)((Object)argValue)).size() == 1) {
                                Iterator mapi = map.entrySet().iterator();
                                Map.Entry mape = mapi.next();
                                if (mape.getValue() instanceof Collection) {
                                    argValue = mape.getValue();
                                    argType = argValue.getClass();
                                    argTypeName = argType.getName();
                                } else if (mape.getValue() instanceof Map) {
                                    argValue = new ArrayList();
                                    ((List)argValue).add(mape.getValue());
                                    argType = argValue.getClass();
                                    argTypeName = argType.getName();
                                }
                            }
                            i = ((Collection)argValue).iterator();
                            if (targetGenericInfo != null) {
                                valueClass = targetGenericInfo.getClassByIndex(0);
                            }
                        } else {
                            i = ((Map)((Object)argValue)).keySet().iterator();
                            if (targetGenericInfo != null) {
                                keyClass = targetGenericInfo.getClassByIndex(0);
                                valueClass = targetGenericInfo.getClassByIndex(1);
                            }
                        }
                        if (javaClass != null) {
                            valueClass = javaClass;
                        }
                        if (javaKeyClass != null) {
                            keyClass = javaKeyClass;
                        }
                        boolean resetValueClass = false;
                        if (valueClass == null) {
                            resetValueClass = true;
                        }
                        while (i.hasNext()) {
                            Class clazz8;
                            Class clazz9;
                            Object value = null;
                            if (resetValueClass) {
                                valueClass = null;
                            }
                            if ((clazz9 = class$java$util$Collection) == null) {
                                clazz9 = Reflection.class("[Ljava.util.Collection;", false);
                            }
                            if (clazz9.isAssignableFrom(targetType)) {
                                value = i.next();
                            } else {
                                key = i.next();
                                value = ((Map)((Object)argValue)).get(key);
                            }
                            if (valueClass == null && value != null) {
                                valueClass = value.getClass();
                            }
                            Object newValue = null;
                            if (value != null) {
                                ReflectionArgument subArg = new ReflectionArgument(value.getClass(), value, true, true);
                                newValue = Reflection.adaptValue(valueClass, targetGenericInfo == null ? null : targetGenericInfo.getChildNode(), subArg, optionalArgs, dataSource, javaClass, javaCollectionClass, javaKeyClass);
                            }
                            Object newKey = key;
                            Class clazz10 = class$java$lang$Object;
                            if (clazz10 == null) {
                                clazz10 = Reflection.class("[Ljava.lang.Object;", false);
                            }
                            if (keyClass != clazz10) {
                                ReflectionArgument subArg = new ReflectionArgument(key.getClass(), key, true, true);
                                newKey = Reflection.adaptValue(keyClass, targetGenericInfo == null ? null : targetGenericInfo.getChildNode(), subArg, optionalArgs, dataSource, null, null, null);
                            }
                            if ((clazz8 = class$java$util$Collection) == null) {
                                clazz8 = Reflection.class("[Ljava.util.Collection;", false);
                            }
                            if (clazz8.isAssignableFrom(targetType)) {
                                ((Collection)newArgValue).add(newValue);
                                continue;
                            }
                            ((Map)newArgValue).put(newKey, newValue);
                        }
                        return newArgValue;
                    }
                    if (targetType.isAssignableFrom(argType)) {
                        return javaClass == null ? argType.cast(argValue) : javaClass.cast(argValue);
                    }
                    if (!arg.allowBeanConversion()) break block92;
                    Class clazz = class$java$util$Map;
                    if (clazz == null) {
                        clazz = class$java$util$Map = Reflection.class("[Ljava.util.Map;", false);
                    }
                    if (!clazz.isAssignableFrom(argType)) break block93;
                }
                if (!VersionSafeChecker.isEnum(targetType)) break block94;
            }
            Object translatedValue = javaClass != null ? DataTools.convertType(javaClass, argValue) : DataTools.convertType(targetType, argValue);
            return translatedValue;
        }
        if (arg.allowBeanConversion()) {
            Class clazz = class$java$util$Map;
            if (clazz == null) {
                clazz = class$java$util$Map = Reflection.class("[Ljava.util.Map;", false);
            }
            if (clazz.isAssignableFrom(argType)) {
                if (optionalArgs != null) {
                    int i = 0;
                    while (i < optionalArgs.length) {
                        Class optionalType = optionalArgs[i].getType();
                        if (optionalType == targetType) {
                            throw new Exception(argTypeName + " not adaptable to: " + targetTypeName);
                        }
                        ++i;
                    }
                }
                log.debug("Converting Map arg to bean of type: " + targetTypeName);
                if (argValue == null) {
                    log.debug("Assigning null value to bean: " + targetTypeName);
                    return null;
                }
                Object beanInstance = null;
                try {
                    beanInstance = Reflection.newInstance(targetType);
                }
                catch (Exception e) {
                    Throwable rte = Reflection.getRealTargetException(e);
                    log.warn("Failed to convert Map arg to bean of type: " + targetTypeName + " - because instantiation of " + targetTypeName + " threw the following Exception: " + rte.toString());
                    throw e;
                }
                Map map = (Map)((Object)argValue);
                Map newArgMap = (Map)argValue.getClass().newInstance();
                Map props = DataTools.getPropertyDescriptors(beanInstance);
                Iterator i = map.keySet().iterator();
                while (i.hasNext()) {
                    Object value;
                    Object key = i.next();
                    Object newArgValue = value = map.get(key);
                    String subFieldType = null;
                    Class<?> subJavaClass = null;
                    Class<?> subJavaCollectionClass = null;
                    Class<?> subJavaKeyClass = null;
                    String subFieldName = key.toString();
                    if (dataSource != null && subFieldName != null) {
                        try {
                            DSField field = dataSource.getField(subFieldName);
                            if (field != null) {
                                String typeName = field.getProperty("javaClass");
                                if (typeName != null) {
                                    subJavaClass = Class.forName(typeName);
                                }
                                if ((typeName = field.getProperty("javaCollectionClass")) != null) {
                                    subJavaCollectionClass = Class.forName(typeName);
                                }
                                if ((typeName = field.getProperty("javaKeyClass")) != null) {
                                    subJavaKeyClass = Class.forName(typeName);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn(e.getClass().getName() + ' ' + e.getMessage() + " encountered whilst trying to derive Java classes from override class names for DataSource '" + dataSource.getName() + "', field name '" + subFieldName + '\'');
                        }
                    }
                    if (value instanceof Collection || value instanceof Map) {
                        PropertyDescriptor pd = (PropertyDescriptor)props.get(key);
                        VersionSafeChecker.GenericParameterNode type = null;
                        ReflectionArgument ra = null;
                        boolean readMethod = true;
                        if (pd != null) {
                            DSField subField;
                            Method method = pd.getReadMethod();
                            if (method != null) {
                                type = VersionSafeChecker.getGenericReturnType(method);
                                ra = new ReflectionArgument(value.getClass(), value, true, true);
                            } else {
                                readMethod = false;
                                method = pd.getWriteMethod();
                                if (method != null) {
                                    List paramTypes = VersionSafeChecker.getGenericParameterTypes(method);
                                    type = (VersionSafeChecker.GenericParameterNode)paramTypes.get(0);
                                    ra = new ReflectionArgument(value.getClass(), value, true, true);
                                }
                            }
                            if (dataSource != null && (subFieldName = key.toString()) != null && (subField = dataSource.getField(subFieldName)) != null) {
                                subFieldType = subField.getType();
                            }
                            DataSource subDataSource = subFieldType == null ? null : DataSource.forName(subFieldType);
                            newArgValue = Reflection.adaptValue(readMethod ? method.getReturnType() : method.getParameterTypes()[0], type == null ? null : type.getChildNode(), ra, optionalArgs, subDataSource, subJavaClass, subJavaCollectionClass, subJavaKeyClass);
                        }
                    }
                    newArgMap.put(key, newArgValue);
                }
                try {
                    if (dataSource != null) {
                        return dataSource.setProperties(newArgMap, beanInstance);
                    }
                    return DataTools.setProperties(newArgMap, beanInstance, dataSource);
                }
                catch (Exception e) {
                    Throwable rte = Reflection.getRealTargetException(e);
                    String error = "Failed to convert Map arg to bean of type: " + targetTypeName + " - because bean population via DataTools.setProperties() threw the following Exception: " + rte.toString();
                    if (rte instanceof IllegalArgumentException || rte instanceof ClassCastException) {
                        error = error + ". Maybe you have overridden an automatic binding by setting property 'javaClass' on a DataSourceField to an incorrect class (ie, a class that cannot be cast to the type that the setter function actually takes)?";
                    }
                    log.warn(error);
                    throw e;
                }
            }
        }
        if (arg.allowTypeConversion()) {
            log.debug("trying convertType");
            return DataTools.convertType(targetType, argValue);
        }
        throw new Exception(argTypeName + " not adaptable to: " + targetTypeName);
    }

    public static boolean methodTakesArgType(Method method, Class type) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (parameterTypes[i] == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getBeanFields(String className) throws Exception {
        Class<?> classObj = Class.forName(className);
        Map propertyDescriptors = DataTools.getPropertyDescriptors(classObj);
        ArrayList fields = new ArrayList();
        Iterator i = propertyDescriptors.keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            if ("class".equals(propertyName)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescriptors.get(propertyName);
            String type = propertyDescriptor.getPropertyType().getName();
            String fieldType = null;
            HashMap<String, String> valueMap = null;
            if (VersionSafeChecker.isEnum(propertyDescriptor.getPropertyType())) {
                fieldType = "enum";
                ?[] constants = propertyDescriptor.getPropertyType().getEnumConstants();
                valueMap = new HashMap<String, String>();
                int j = 0;
                while (j < constants.length) {
                    String key = constants[j].toString();
                    String value = DataTools.deriveTitleFromName(key);
                    valueMap.put(key, value);
                    ++j;
                }
            }
            if ("java.lang.String".equals(type) || "java.lang.Character".equals(type) || "char".equals(type)) {
                fieldType = "text";
            } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
                fieldType = "boolean";
            } else if ("java.util.Date".equals(type) || "java.sql.Date".equals(type)) {
                fieldType = "date";
            } else if ("java.lang.Byte".equals(type) || "byte".equals(type) || "java.lang.Short".equals(type) || "short".equals(type) || "java.lang.Integer".equals(type) || "int".equals(type) || "java.lang.Long".equals(type) || "long".equals(type) || "java.math.BigInteger".equals(type)) {
                fieldType = "integer";
            } else if ("java.lang.Float".equals(type) || "float".equals(type) || "java.lang.Double".equals(type) || "double".equals(type) || "java.math.BigDecimal".equals(type)) {
                fieldType = "float";
            }
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", propertyName);
            if (fieldType == null) {
                fieldType = new String(type);
                field.put("unknownType", Boolean.TRUE);
            }
            field.put("type", fieldType);
            if (valueMap != null) {
                field.put("valueMap", valueMap);
            }
            fields.add(field);
        }
        return fields;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$base$Reflection;
        if (clazz == null) {
            clazz = class$com$isomorphic$base$Reflection = Reflection.class("[Lcom.isomorphic.base.Reflection;", false);
        }
        log = new Logger(clazz.getName());
        reflectionCache = new HashMap();
    }
}

