/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.File;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ISCInit {
    private static Config config;
    private static boolean initialized;
    public static boolean webRootSet;
    private static String webRoot;
    private static Logger log;
    public static final String AUTODETECT = "__AUTODETECT__";
    static /* synthetic */ Class class$com$isomorphic$base$ISCInit;

    public static void go() {
        try {
            if (initialized && webRootSet) {
                return;
            }
            if (!initialized) {
                log.info("Isomorphic SmartClient Framework - Initializing");
                config = Config.getGlobal();
                if (config == null) {
                    config = Config.initGlobalConfig();
                }
                Logger.initialize();
                initialized = true;
                String version = config.getString("iscVersion");
                String packageDate = config.getString("iscPackageDate");
                log.info("Isomorphic SmartClient Framework (" + version + ' ' + packageDate + ") - Initialization Complete");
            }
            if (!webRootSet) {
                if (webRoot == null) {
                    webRoot = config.getPath("webRoot");
                }
                if (!AUTODETECT.equals(webRoot) && (ISCInit.verifyWebRoot(webRoot) || ISCFile.isContainerIOPath(webRoot))) {
                    log.info("Using Configured webRoot: " + webRoot);
                    webRootSet = true;
                    return;
                }
                if (!AUTODETECT.equals(webRoot)) {
                    throw new Exception("Configured webRoot path is invalid please check your server.properties setting.  Current value is: " + webRoot);
                }
                if (ISCFile.servletContext == null) {
                    log.info("No ServletContext available yet - using container IO for now");
                    config.put("webRoot", "__USE_CONTAINER__");
                    return;
                }
                String realPath = ISCFile.servletContext.getRealPath("/");
                String autoWebRoot = ISCInit.fixRealPath(realPath);
                if (autoWebRoot == null) {
                    log.info("Container refusing to provide getRealPath() - assuming WAR context and using container IO");
                    config.put("webRoot", "__USE_CONTAINER__");
                } else if (ISCInit.verifyWebRoot(autoWebRoot)) {
                    config.put("webRoot", autoWebRoot);
                    log.info("Auto-detected webRoot - using: " + autoWebRoot);
                } else {
                    config.put("webRoot", "__USE_CONTAINER__");
                    log.info("WebRoot auto-detection failed - using container IO");
                }
                webRootSet = true;
            }
        }
        catch (Throwable e) {
            System.err.println("Isomorphic Init: Exception in Init.go()");
            e.printStackTrace(System.err);
        }
    }

    private static final String fixRealPath(String path) {
        if (path == null) {
            return null;
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private static final boolean verifyWebRoot(String webRoot) {
        log.debug("Verifying webroot: " + webRoot);
        webRoot = ISCFile.canonicalizePath(webRoot);
        File webRootDir = new File(webRoot);
        if (!webRootDir.exists() || !webRootDir.isDirectory()) {
            return false;
        }
        String markerFileName = ISCFile.canonicalizePath(webRoot + '/' + config.getPath("isomorphicPathRootRelative"));
        File markerFile = new File(markerFileName);
        try {
            markerFile = markerFile.getAbsoluteFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!markerFile.exists()) {
            log.error("Can't find marker file for webRoot: " + markerFileName + " for configured/autodetected webRoot - if you moved the 'isomorphic' directory, please set isomorphicDirRootRelative in server.properties to the new location and restart the servlet engine.");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        initialized = false;
        webRootSet = false;
        Class clazz = class$com$isomorphic$base$ISCInit;
        if (clazz == null) {
            clazz = class$com$isomorphic$base$ISCInit = ISCInit.class("[Lcom.isomorphic.base.ISCInit;", false);
        }
        log = new Logger(clazz.getName());
    }
}

