/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.collections.ProxyMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigParser
extends ProxyMap {
    private static Logger log;
    static /* synthetic */ Class class$com$isomorphic$base$ConfigParser;

    public void setConfigData(Map data) {
        this.map = data;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = super.get(key);
        if (value == null) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        try {
            value = this.interpolate(value.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    protected Object interpolate(Object value) throws Exception {
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        return value;
    }

    protected String interpolate(String value) throws Exception {
        if (value == null) {
            return null;
        }
        Perl5Util regex = new Perl5Util();
        while (regex.match("m#(.*[^\\\\]|^)\\$(.*)#", value)) {
            String preMatch = regex.group(1);
            String match = regex.group(2);
            value = (preMatch == null ? "" : preMatch) + this.interpolateVariable(match);
        }
        value = regex.substitute("s'\\\\\\$'\\$'g", value);
        return value;
    }

    protected String interpolateVariable(String variable) throws Exception {
        Perl5Util regex = new Perl5Util();
        if (regex.match("m#jndi\\:([^:]+):([^:]+)?:(\\S+)#", variable)) {
            String contextName = this.interpolate(regex.group(1));
            String jndiKey = this.interpolate(regex.group(2));
            String keyContext = this.interpolate(regex.group(3));
            Context ctx = JNDI.bindConfiguredContext(contextName);
            String interpolatedValue = "";
            if (ctx instanceof DirContext) {
                Attributes attrs = ((DirContext)ctx).getAttributes(keyContext, new String[]{jndiKey});
                Attribute attr = null;
                if (attrs != null) {
                    attr = attrs.get(jndiKey);
                }
                if (attrs == null || attr == null) {
                    throw new Exception("unable to resolve config variable: " + variable + " - lookup failed for key: " + jndiKey);
                }
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    interpolatedValue = interpolatedValue + ne.next().toString();
                    if (!ne.hasMore()) continue;
                    interpolatedValue = interpolatedValue + ',';
                }
            } else {
                throw new Exception("Resolved context type: " + ctx.getClass().getName() + " is not supported.");
            }
            if (interpolatedValue.indexOf("'") != -1) {
                interpolatedValue = regex.substitute("s/'/\\\\'/g", interpolatedValue);
            }
            variable = regex.substitute("s'jndi\\:([^:]+):([^:]+)?:(\\S+)'" + interpolatedValue + '\'', variable);
        } else if (regex.match("m#([\\w.]+)#", variable)) {
            String variableName = regex.group(1);
            Object interpolatedValue = this.get(variableName);
            if (interpolatedValue == null) {
                throw new Exception("variable expansion failed for variable: " + variableName);
            }
            String theValue = interpolatedValue.toString();
            if (theValue.indexOf("'") != -1) {
                theValue = regex.substitute("s/'/\\\\'/g", theValue);
            }
            variable = regex.substitute("s'[\\w.]+'" + theValue + '\'', variable);
        } else {
            throw new Exception("found variable expansion for directive '" + variable + "'but I'm unable to match the characters following as a legitimate variable name. Acceptable variable names must match [a-zA-Z_0-9].");
        }
        return variable;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ConfigParser(Map configData) {
        super(configData);
    }

    public ConfigParser() {
        super(new HashMap());
    }

    static {
        Class clazz = class$com$isomorphic$base$ConfigParser;
        if (clazz == null) {
            clazz = class$com$isomorphic$base$ConfigParser = ConfigParser.class("[Lcom.isomorphic.base.ConfigParser;", false);
        }
        log = new Logger(clazz.getName());
    }
}

