/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.ConfigParser;
import com.isomorphic.base.IConfigLoader;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.collections.SequencedHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigLoader
implements IConfigLoader {
    private static Logger log;
    public static String framework;
    public static String frameworkDevenv;
    public static String project;
    public static String devenv;
    public static String interfaces;
    public static String server;
    protected static ClassLoader ourClassLoader;
    static /* synthetic */ Class class$com$isomorphic$base$ConfigLoader;
    static /* synthetic */ Class class$com$isomorphic$base$Config;

    protected void loadAndMerge(String fileName, String fileLocation, Map accumulator) throws Exception {
        this.loadAndMerge(fileName, fileLocation, accumulator, false, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadAndMerge(String fileName, String fileLocation, Map accumulator, boolean suppressLog, boolean useJavaPropertyLoader) throws Exception {
        if (fileLocation == null) {
            fileLocation = "";
        }
        if (!suppressLog) {
            log.info("Attempting to load " + fileName + " from " + fileLocation);
        }
        InputStream is = null;
        String loadedFromLocation = fileLocation;
        String loadedFilename = fileName;
        ISCFile file = null;
        if (fileLocation.equals("CLASSPATH")) {
            file = new ISCFile(DataTools.resourceFromClassLoader(fileName));
        } else {
            String path = fileName;
            if (!"".equals(fileLocation)) {
                path = fileLocation + '/' + fileName;
            } else {
                loadedFromLocation = fileName;
            }
            file = new ISCFile(path);
        }
        if (!file.exists()) {
            if (suppressLog) throw new Exception("File not found: " + fileName);
            log.info("Unable to locate " + fileName + " in " + fileLocation);
            throw new Exception("File not found: " + fileName);
        }
        loadedFilename = file.getCanonicalPath();
        is = file.getInputStream();
        loadedFromLocation = loadedFromLocation + " at location: " + loadedFilename;
        try {
            Map<Object, Object> thisConfig = null;
            if (useJavaPropertyLoader) {
                Properties props = new Properties();
                props.load(is);
                thisConfig = props;
            } else {
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
                String line = null;
                Perl5Util regex = new Perl5Util();
                thisConfig = new HashMap();
                boolean ignoreBlock = false;
                while ((line = reader.readLine()) != null) {
                    if (regex.match("m/^#END_DOTNET_ONLY/", line)) {
                        ignoreBlock = false;
                        continue;
                    }
                    if (regex.match("m/^#START_DOTNET_ONLY/", line)) {
                        ignoreBlock = true;
                        continue;
                    }
                    if (ignoreBlock || regex.match("m/^#/", line) || !regex.match("m/\\s*(.*?)\\s*(:|=)(.*)/", line)) continue;
                    String key = regex.group(1).trim();
                    String value = regex.group(3).trim();
                    thisConfig.put(key, value);
                }
            }
            DataTools.mapMerge(thisConfig, accumulator);
            SequencedHashMap configInfo = new SequencedHashMap();
            configInfo.put("name", fileName);
            configInfo.put("location", fileLocation);
            configInfo.put("loaded_from", loadedFromLocation);
            configInfo.put("filename", loadedFilename);
            configInfo.put("contents", new TreeMap<Object, Object>(thisConfig));
            configInfo.put("type", useJavaPropertyLoader ? "java" : "isomorphic");
            Config.loadedConfigFiles.add(configInfo);
            log.info("Successfully loaded " + fileName + " from " + loadedFromLocation);
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var11_20 = null;
        }
        try {}
        catch (Exception ignored) {
            return;
        }
        is.close();
    }

    public Map loadConfig(ConfigParser parser) throws Exception {
        Map accumulator = Collections.synchronizedMap(new HashMap());
        try {
            this.loadAndMerge(framework, "CLASSPATH", accumulator);
        }
        catch (Exception e) {
            throw new Error("Can't find framework.properties - unable to proceed.  Please add this file to your classpath and try again.  Actual error: " + e.toString());
        }
        try {
            this.loadAndMerge(project, "CLASSPATH", accumulator);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.loadAndMerge(frameworkDevenv, "CLASSPATH", accumulator, true, false);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.loadAndMerge(devenv, "CLASSPATH", accumulator, true, false);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.loadAndMerge(interfaces, "CLASSPATH", accumulator, true, false);
        }
        catch (Exception webRoot) {
            // empty catch block
        }
        try {
            this.loadAndMerge(server, "CLASSPATH", accumulator);
        }
        catch (Exception ignored) {
            parser.setConfigData(accumulator);
            Config config = new Config((Map)((Object)parser));
            String webRoot = config.getString("webRoot");
            if ("__AUTODETECT__".equals(webRoot)) {
                webRoot = "__USE_CONTAINER__";
            }
            String configPath = webRoot + "/WEB-INF/classes";
            try {
                this.loadAndMerge(server, configPath, accumulator);
            }
            catch (Exception ignored2) {
                configPath = webRoot + "/isomorphicConfig";
                try {
                    this.loadAndMerge(server, configPath, accumulator);
                }
                catch (Exception ignored3) {
                    log.info("Unable to load " + server);
                }
            }
        }
        parser.setConfigData(accumulator);
        Config config = new Config((Map)((Object)parser));
        List configOverrides = config.getList("loadConfigOverrides", new ArrayList());
        Iterator i = configOverrides.iterator();
        while (i.hasNext()) {
            String override = (String)i.next();
            try {
                this.loadAndMerge(override, "CLASSPATH", accumulator, false, true);
            }
            catch (Exception e) {
                log.warning("Could not load override: " + override + " via CLASSPATH.");
            }
            try {
                this.loadAndMerge(override, "", accumulator, false, true);
            }
            catch (Exception e) {
                log.warning("Could not load override: " + override + " via filesystem - skipping.");
            }
        }
        String cliOverride = null;
        try {
            cliOverride = System.getProperty("isc_config.override");
        }
        catch (Exception e) {
            log.warn("Can't check for command-line config override because system's security won't alow access to isc_config.override property.");
        }
        if (cliOverride != null) {
            try {
                this.loadAndMerge(cliOverride, "", accumulator, false, true);
            }
            catch (Exception e) {
                log.warning("Could not load command-line specified override: " + cliOverride + " - skipping.");
            }
        }
        return accumulator;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$base$ConfigLoader;
        if (clazz == null) {
            clazz = class$com$isomorphic$base$ConfigLoader = ConfigLoader.class("[Lcom.isomorphic.base.ConfigLoader;", false);
        }
        log = new Logger(clazz.getName());
        framework = "framework.properties";
        frameworkDevenv = "devenv.framework.properties";
        project = "project.properties";
        devenv = "devenv.properties";
        interfaces = "isc_interfaces.properties";
        server = "server.properties";
        Class clazz2 = class$com$isomorphic$base$Config;
        if (clazz2 == null) {
            clazz2 = class$com$isomorphic$base$Config = ConfigLoader.class("[Lcom.isomorphic.base.Config;", false);
        }
        ourClassLoader = clazz2.getClassLoader();
    }
}

