/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.ConfigLoader;
import com.isomorphic.base.ConfigParser;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import isc.org.apache.oro.text.regex.Perl5Compiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Config
extends DataTypeMap {
    private static Logger log;
    public static List loadedConfigFiles;
    protected static Config globalConfig;
    protected boolean cachingEnabled;
    protected Map cache;
    static /* synthetic */ Class class$com$isomorphic$base$Config;

    public static Config getGlobal() {
        return globalConfig;
    }

    public static Object getProperty(String propertyName) {
        return Config.getGlobal().get(propertyName);
    }

    public static synchronized Config initGlobalConfig() throws Exception {
        return Config.initGlobalConfig(new ConfigLoader(), new ConfigParser());
    }

    public static synchronized Config initGlobalConfig(ConfigLoader loader, ConfigParser parser) throws Exception {
        parser.setConfigData(loader.loadConfig(parser));
        globalConfig = new Config((Map)((Object)parser));
        return globalConfig;
    }

    public static Properties buildProperties(Map map) {
        return (Properties)DataTools.mapMerge(map, new Properties());
    }

    public Config getConfigBlock(String key) {
        return new Config(DataTools.getPrefixed(key, (Map)((Object)this)));
    }

    public Config getSubtree(String key) {
        return new Config(DataTools.getSubtreePrefixed(key, (Map)((Object)this)));
    }

    public Properties asProperties() {
        return Config.buildProperties((Map)((Object)this));
    }

    public void setIfNull(Object key, Object value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    public Object getClassInstance(String key) throws Exception {
        if (this.get(key) == null) {
            return null;
        }
        Class theClass = null;
        String value = this.get(key).toString();
        try {
            theClass = Reflection.classForName(value);
        }
        catch (Exception ce) {
            if (value.equals("true") || value.equals("yes")) {
                return new Boolean(true);
            }
            if (value.equals("false") || value.equals("no")) {
                return new Boolean(false);
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return value;
            }
        }
        Object classInstance = Reflection.instantiateClass(value);
        if (classInstance instanceof IAutoConfigurable) {
            String configRoot = null;
            configRoot = key;
            Field[] fields = theClass.getFields();
            int ii = 0;
            while (ii < fields.length) {
                Field field = fields[ii];
                String configPath = configRoot + '.' + field.getName();
                if (this.get(configPath) != null) {
                    field.set(classInstance, this.getClassInstance(configPath));
                }
                ++ii;
            }
        }
        return classInstance;
    }

    public Object get(Object key) {
        Object value = null;
        if (this.cachingEnabled && (value = this.cache.get(key)) != null) {
            return value;
        }
        value = super.get(key);
        if (value == null) {
            return null;
        }
        if (this.cachingEnabled) {
            this.cache.put(key, value);
        }
        return value;
    }

    public void clearCache() {
        if (this.cachingEnabled) {
            this.cache.clear();
        }
    }

    public void clear() {
        super.clear();
        if (this.cachingEnabled) {
            this.cache.clear();
        }
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        super.put(key, value);
        this.clearCache();
        return oldValue;
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        super.putAll(t);
        this.clearCache();
    }

    public Object remove(Object key) {
        Object value = this.get(key);
        super.remove(key);
        this.clearCache();
        return value;
    }

    public String getString(String key, String defaultValue) {
        String s = super.getString(key, defaultValue);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getPath(String key) {
        return this.getPath(key, null);
    }

    public String getPath(String key, String defaultValue) {
        String value = this.getString(key, defaultValue);
        if (value == null) {
            return value;
        }
        value = ISCFile.canonicalizePath(value);
        if (this.cachingEnabled) {
            this.cache.put(key, value);
        }
        return value;
    }

    public static void deleteProperties(List properties) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Config.deleteProperty((String)i.next());
        }
    }

    public static void deleteProperty(String key) throws Exception {
        Config.persistProperty(key, null);
    }

    public static void deleteProperties(List properties, String propertyFile) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Config.deleteProperty((String)i.next(), propertyFile);
        }
    }

    public static void deleteProperty(String key, String propertyFile) throws Exception {
        Config.persistProperty(key, null, propertyFile);
    }

    public static void persistProperties(Map properties, String propertyFile) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            Object value = properties.get(key);
            if (value == null) {
                Config.persistProperty(key, null, propertyFile);
                continue;
            }
            Config.persistProperty(key, value.toString(), propertyFile);
        }
    }

    public static void persistProperties(Map properties) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            Object value = properties.get(key);
            if (value == null) {
                Config.persistProperty(key, null);
                continue;
            }
            Config.persistProperty(key, value.toString());
        }
    }

    public static void persistProperty(String key, String value) throws Exception {
        Iterator i = loadedConfigFiles.iterator();
        while (i.hasNext()) {
            Map configData = (Map)i.next();
            String filename = (String)configData.get("filename");
            Config.persistProperty(key, value, filename);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void persistProperty(String key, String value, String propertyFile) throws Exception {
        block34: {
            block32: {
                block31: {
                    config = Config.getGlobal();
                    if (key == null) {
                        return;
                    }
                    if (propertyFile == null) {
                        return;
                    }
                    logContext = "property '" + key + "' with value: " + value + " to file: " + propertyFile;
                    Config.log.debug("Going to write " + logContext);
                    if (DataTools.pathIsRelative(propertyFile)) {
                        propertyFile = config.getBoolean((Object)"devenv", false) != false ? config.getPath("webRoot") + "/isomorphicConfig/" + propertyFile : config.getPath("webRoot") + "/WEB-INF/classes/" + propertyFile;
                    }
                    if (DataTools.isContainerIOPath(propertyFile)) {
                        throw new Exception("Unable to persist " + logContext + " because SmartClient is running in containerIO mode (WAR deployment, no direct filesystem access).  To fix this, set the webRoot variable in your server.properties if possible.");
                    }
                    theFile = new File(propertyFile);
                    if (!theFile.exists() && !(created = theFile.createNewFile())) {
                        throw new Exception("Unable to persist " + logContext + " because " + propertyFile + " does not exist and creating new file at that location failed.");
                    }
                    tmpFileName = propertyFile + ".configPersist";
                    tmpFile = new File(tmpFileName);
                    if (tmpFile.exists() && !(deleted = tmpFile.delete())) {
                        throw new Exception("Unable to persist " + logContext + ".  Unable to delete temporary file: " + tmpFileName);
                    }
                    created = tmpFile.createNewFile();
                    if (!created) {
                        throw new Exception("Unable to persist " + logContext + ".  Unable to create temporary file: " + tmpFileName);
                    }
                    is = null;
                    os = null;
                    ps = null;
                    try {
                        try {
                            is = new FileInputStream(theFile);
                            os = new FileOutputStream(tmpFile);
                            ps = new PrintStream(os);
                            reader = new LineNumberReader(new InputStreamReader(is));
                            line = null;
                            regex = new Perl5Util();
                            replacedInline = false;
                            while (true) {
                                block33: {
                                    if ((line = reader.readLine()) != null) break block33;
                                    if (!replacedInline && value != null) {
                                        ps.println(key + ": " + value);
                                    }
                                    break;
                                }
                                if (regex.match("m/^" + Perl5Compiler.quotemeta((String)key) + "(\\s*):/", line)) {
                                    replacedInline = true;
                                    if (value == null) continue;
                                    ps.println(key + ": " + value);
                                    continue;
                                }
                                ps.println(line);
                            }
                        }
                        catch (Exception e) {
                            Config.log.warn((Object)("Unable to persist property '" + key + "' with value: " + value + " to propertyFile: " + propertyFile), e);
                            throw e;
                        }
                    }
                    catch (Throwable var12_20) {
                        var13_21 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        try {
                            os.getFD().sync();
                            os.close();
                            throw var12_20;
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        throw var12_20;
                    }
                    {
                        var13_22 = null;
                        if (is == null) break block31;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 687->695)] { 
lbl77:
                    // 1 sources

                    is.close();
                    break block31;
lbl79:
                    // 1 sources

                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    ** try [egrp 3[TRYBLOCK] [3 : 702->710)] { 
lbl84:
                    // 1 sources

                    ps.close();
                    break block32;
lbl86:
                    // 1 sources

                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
            ** try [egrp 4[TRYBLOCK] [4 : 712->728)] { 
lbl90:
            // 1 sources

            os.getFD().sync();
            os.close();
            break block34;
lbl93:
            // 1 sources

            catch (Exception ignored) {
                // empty catch block
            }
        }
        backupFile = new File(propertyFile + ".configBackup");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        if (!(backupSuccess = theFile.renameTo(backupFile))) {
            throw new Exception("Property persist failed because " + theFile.getAbsolutePath() + " could not be renamed to " + backupFile.getAbsolutePath());
        }
        renameSuccess = tmpFile.renameTo(theFile);
        if (renameSuccess != false) return;
        throw new Exception("Property persist failed because " + tmpFile.getAbsolutePath() + " could not be renamed to " + theFile.getAbsolutePath());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.cachingEnabled = false;
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public Config(Map configData) {
        super(configData);
        this.this();
        if (this.getBoolean((Object)"config.enableCaching", true)) {
            this.cachingEnabled = true;
        }
    }

    public Config() {
        this(Collections.synchronizedMap(new HashMap()));
    }

    static {
        Class clazz = class$com$isomorphic$base$Config;
        if (clazz == null) {
            clazz = class$com$isomorphic$base$Config = Config.class("[Lcom.isomorphic.base.Config;", false);
        }
        log = new Logger(clazz.getName());
        loadedConfigFiles = new ArrayList();
        globalConfig = null;
    }
}

