/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.Authentication;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DevModeAuthFilter
extends URIRegexFilter {
    private static String authAttribute = "isc.devModeAuthorized";
    public List authorizedUsers;

    public void setAuthorizedUsers(String value) {
        Iterator i = DataTools.simpleSplit(value, ",").iterator();
        while (i.hasNext()) {
            String user = ((String)i.next()).trim();
            this.authorizedUsers.add(user);
        }
    }

    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        String userId = this.getUserId((HttpServletRequest)req, (HttpServletResponse)res);
        if (userId != null && this.authorizedUsers.contains(userId)) {
            req.setAttribute(authAttribute, (Object)userId);
        }
        chain.doFilter(req, res);
    }

    public static boolean devModeAuthorized(HttpServletRequest request) {
        boolean bl = false;
        if (request.getAttribute(authAttribute) != null) {
            bl = true;
        }
        return bl;
    }

    public static String getAuthorizedUserId(HttpServletRequest request) {
        return (String)request.getAttribute(authAttribute);
    }

    public String getUserId(HttpServletRequest request, HttpServletResponse response) {
        String login;
        try {
            Principal principal = request.getUserPrincipal();
            login = principal.getName();
            if (login != null) {
                return login;
            }
        }
        catch (Exception context) {
            // empty catch block
        }
        try {
            RequestContext context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            Authentication.isAuthenticated(context);
            login = Authentication.getUsername(context);
            if (login != null) {
                return login;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.authorizedUsers = new ArrayList();
    }

    public DevModeAuthFilter() {
        this.this();
    }
}

