/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.Authentication;
import com.isomorphic.auth.ConfigRequestContextAuthenticator;
import com.isomorphic.auth.IRequestContextAuthenticator;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.RegexRule;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AuthenticationFilter
extends URIRegexFilter {
    public String loginPage;
    public String logoutPage;
    public String maxLoginAttemptsExceededPage;
    public String defaultLoginRedirect;
    public String initialTargetParam;
    public int maxTries;
    public String realm;
    public int securityLevel;
    public String username;
    public String password;
    private IRequestContextAuthenticator authenticator;
    private Logger log;
    protected boolean enabled;
    private String filterName;

    public void setLoginPage(String value) {
        this.loginPage = value;
    }

    public void setLogoutPage(String value) {
        this.logoutPage = value;
    }

    public void setMaxLoginAttemptsExceededPage(String value) {
        this.maxLoginAttemptsExceededPage = value;
    }

    public void setDefaultLoginRedirect(String value) {
        this.defaultLoginRedirect = value;
    }

    public void setInitialTargetParam(String value) {
        this.initialTargetParam = value;
    }

    public void setMaxTries(String value) {
        this.maxTries = Integer.valueOf(value);
    }

    public void setRealm(String value) {
        this.realm = value;
    }

    public void setSecurityLevel(String value) {
        this.securityLevel = Integer.valueOf(value);
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setAuthenticator(String value) throws Exception {
        this.authenticator = Authentication.getAuthenticator(value);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.username != null && this.password != null && ServletTools.servletOrFilterParametersToMap(filterConfig).get("authenticator") == null) {
            try {
                this.setAuthenticator("simpleConfig");
            }
            catch (Exception e) {
                this.log.error((Object)"can't auto-initialize simpleConfig authenticator - check your configuration", e);
                throw new ServletException(e.toString());
            }
        }
        if (this.authenticator instanceof ConfigRequestContextAuthenticator) {
            if (this.username != null) {
                ((ConfigRequestContextAuthenticator)this.authenticator).username = this.username;
            }
            if (this.password != null) {
                ((ConfigRequestContextAuthenticator)this.authenticator).password = this.password;
            }
        }
        if (this.realm == null) {
            this.realm = filterConfig.getFilterName();
        }
        this.log = new Logger(this.getClass().getName(), filterConfig.getFilterName() + " (realm: " + this.realm + ", securityLevel: " + this.securityLevel + ')');
        try {
            if (!this.enabled) {
                this.log.warn("AuthenticationFilter present in web.xml, but authentication globally disabled in config via authentication.enabled: false.  Not initializing, will allow all requests without any checks.");
                return;
            }
            this.setDefaultAction("match");
            if (this.rules == null) {
                this.log.info("No rules file defined, treating all intercepted resources as private");
            } else {
                try {
                    this.rules.add(0, new RegexRule("match:#^/isomorphic/login/loginSuccessMarker.html#", "authFilter default"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error initializing known good regex rule", e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize AuthenticationFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [47 : 1388->1392)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String getInitialTarget(RequestContext context) {
        String queryString = context.request.getQueryString();
        String initialTarget = context.requestPath;
        if (queryString != null && queryString.length() > 0) {
            if (!queryString.startsWith("?")) {
                initialTarget = initialTarget + '?';
            }
            initialTarget = initialTarget + queryString;
        }
        return initialTarget;
    }

    private final void maxLoginsExceeded(RequestContext context, String comparePath) throws Exception {
        context.request.setAttribute("isc.TOO_MANY_LOGIN_ATTEMPTS", new Integer(this.maxTries));
        String maxTriesURL = this.maxLoginAttemptsExceededPage;
        if (maxTriesURL == null) {
            this.log.warn("maxTries is set, but maxLoginAttemptsExceededPage is not defined, defaulting to loginPage");
            maxTriesURL = this.loginPage;
        }
        this.log.debug("REDIRECTING user to: " + maxTriesURL + " for access to private resource: " + comparePath + " (user exceeded maximum login attempts limit of " + this.maxTries + ')');
        context.response.sendRedirect(ServletTools.adjustForContextPath(maxTriesURL, (HttpServletRequest)context.request));
    }

    private final /* synthetic */ void this() {
        this.loginPage = "/isomorphic/login/iscAuth/login.html";
        this.logoutPage = "/isomorphic/login/iscAuth/logout.html";
        this.maxLoginAttemptsExceededPage = "/isomorphic/login/iscAuth/maxLoginAttemptsExceeded.html";
        this.defaultLoginRedirect = "/";
        this.initialTargetParam = "initialTarget";
        this.maxTries = -1;
        this.securityLevel = 0;
        this.authenticator = null;
        this.enabled = Authentication.enabled;
    }

    public AuthenticationFilter() {
        this.this();
    }
}

