/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.IRequestContextAuthenticator;
import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Authentication
extends Base {
    private static Logger log;
    private static Map authCache;
    public static boolean enabled;
    private static String authenticatorKey;
    private static String realmKey;
    private static String usernameKey;
    private static String userKey;
    private static String loginCounterKey;
    private static String initialTargetKey;
    private static String achievedSecurityLevelKey;
    static /* synthetic */ Class class$com$isomorphic$auth$Authentication;

    public static IRequestContextAuthenticator getAuthenticator(String name) throws Exception {
        String authenticatorImpl = config.getString("authenticator." + name);
        if (authenticatorImpl == null) {
            throw new Exception("Can't find config block for authenticator: " + name + " - looking for authenticator." + name + " block in server.properties");
        }
        try {
            Reflection.classForName(authenticatorImpl);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("authenticator." + name + " defines: " + authenticatorImpl + " as its implementor, but no such class exists in the runtime (class.forName())");
        }
        IRequestContextAuthenticator authenticator = (IRequestContextAuthenticator)config.getClassInstance("authenticator." + name);
        return authenticator;
    }

    public static IRequestContextAuthenticator getAuthenticator(RequestContext context) throws Exception {
        return (IRequestContextAuthenticator)context.request.getAttribute(authenticatorKey);
    }

    public static void setAuthenticator(RequestContext context, IRequestContextAuthenticator authenticator) throws Exception {
        context.request.setAttribute(authenticatorKey, authenticator);
    }

    public static void setRealm(RequestContext context, String realm) throws Exception {
        context.request.setAttribute(realmKey, realm);
    }

    public static String getRealm(RequestContext context) throws Exception {
        return (String)context.request.getAttribute(realmKey);
    }

    public static String getUsername(RequestContext context) throws Exception {
        return (String)Authentication.getContextValue(context, usernameKey);
    }

    public static void setUsername(RequestContext context, String uid) throws Exception {
        Authentication.setContextValue(context, usernameKey, uid);
    }

    public static Object getUser(RequestContext context) throws Exception {
        return Authentication.getContextValue(context, userKey);
    }

    public static void setUser(RequestContext context, Object user) throws Exception {
        Authentication.setContextValue(context, userKey, user);
    }

    public static boolean isAuthenticated(RequestContext context) throws Exception {
        boolean bl = false;
        if (Authentication.getUser(context) != null) {
            bl = true;
        }
        return bl;
    }

    public static void setLoginCounter(RequestContext context, int counter) throws Exception {
        Authentication.setContextValue(context, loginCounterKey, new Integer(counter));
    }

    public static int getLoginCounter(RequestContext context) throws Exception {
        Integer counter = (Integer)Authentication.getContextValue(context, loginCounterKey);
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    public static String getInitialTarget(RequestContext context) throws Exception {
        return (String)Authentication.getContextValue(context, initialTargetKey);
    }

    public static void setInitialTarget(RequestContext context, String initialTarget) throws Exception {
        Authentication.setContextValue(context, initialTargetKey, initialTarget);
    }

    public static void setAchievedSecurityLevel(RequestContext context, int newValue) throws Exception {
        Authentication.setContextValue(context, achievedSecurityLevelKey, new Integer(newValue));
    }

    public static int getAchievedSecurityLevel(RequestContext context) throws Exception {
        Integer value = (Integer)Authentication.getContextValue(context, achievedSecurityLevelKey);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static void clearAuthInfo(RequestContext context) throws Exception {
        String authStateKey = (String)context.request.getAttribute(realmKey);
        if (authStateKey == null) {
            return;
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        context.session.setAttribute(authStateKey, null);
    }

    private static final Object getContextValue(RequestContext context, String key) throws Exception {
        Map contextStore;
        String authStateKey = (String)context.request.getAttribute(realmKey);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (Map)context.session.getAttribute(authStateKey)) == null) {
            return null;
        }
        return contextStore.get(key);
    }

    private static final void setContextValue(RequestContext context, String key, Object value) throws Exception {
        HashMap<String, Object> contextStore;
        String authStateKey = (String)context.request.getAttribute(realmKey);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (HashMap<String, Object>)context.session.getAttribute(authStateKey)) == null) {
            contextStore = new HashMap<String, Object>();
            context.session.setAttribute(authStateKey, contextStore);
        }
        contextStore.put(key, value);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$isomorphic$auth$Authentication;
        if (clazz == null) {
            clazz = class$com$isomorphic$auth$Authentication = Authentication.class("[Lcom.isomorphic.auth.Authentication;", false);
        }
        log = new Logger(clazz.getName());
        authCache = new HashMap();
        enabled = config.getBoolean((Object)"authentication.enabled", false);
        authenticatorKey = "isc.auth.authenticator";
        realmKey = "isc.auth.realm";
        usernameKey = "username";
        userKey = "user";
        loginCounterKey = "loginCounter";
        initialTargetKey = "initialTarget";
        achievedSecurityLevelKey = "achievedSecurityLevel";
    }
}

