/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.application;

import com.isomorphic.base.Base;
import com.isomorphic.base.Const;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.interfaces.IMessaging;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.SessionDataSource;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AppBase
extends Base {
    protected static Logger log;
    protected static final boolean authorizationEnabled;
    protected static Perl5Util staticRegex;
    protected static String DEFAULT_IMPLEMENTER;
    protected static String DEFAULT_PACKAGE;
    protected String appID;
    protected Map appConfig;
    protected Map definedUserTypes;
    protected RequestContext context;
    protected String operation;
    protected String operationType;
    protected DSRequest request;
    protected DSResponse result;
    protected Map userTypes;
    protected DataSource dataSource;
    protected Map operationsMap;
    Map leasedDataSources;
    static /* synthetic */ Class class$com$isomorphic$application$AppBase;

    public static AppBase findByAppID(String appID) throws Exception {
        Map userTypes;
        AppBase theApp = null;
        if (appID.equals("builtinApplication") || appID.equals("defaultApplication")) {
            if (authorizationEnabled) {
                throw new Exception("The special application 'builtinApplication' cannot be used unless authorization is globally disabled (property authorization.enabled: false)");
            }
            theApp = new AppBase();
            theApp.appID = "builtinApplication";
            theApp.appConfig = new HashMap();
            return theApp;
        }
        Map appConfig = (Map)DataStructCache.getInstance(appID, "apps", "App");
        if (appConfig == null) {
            throw new Exception("Unable to find app file for application ID " + appID);
        }
        String appClassname = (String)appConfig.get("appImplementer");
        if (appClassname == null) {
            appClassname = DEFAULT_IMPLEMENTER;
        } else if (appClassname.indexOf(".") == -1 && DEFAULT_PACKAGE != null && !"".equals(DEFAULT_PACKAGE)) {
            appClassname = DEFAULT_PACKAGE + '.' + appClassname;
        }
        log.info("Using class '" + appClassname + "' as the implementer for application '" + appID + '\'');
        theApp = null;
        try {
            theApp = (AppBase)Reflection.instantiateClass(appClassname);
        }
        catch (Exception e) {
            throw new Exception("Unable to instantiate " + appClassname + " - check the appImplementer setting in the app file for appID: " + appID + " and ensure that your class has a public zero-argument constructor - actual error was: " + e.toString());
        }
        theApp.appID = appID;
        theApp.appConfig = appConfig;
        Map userTypeRequirements = userTypes = (Map)appConfig.get("userTypes");
        if (userTypes != null && !userTypes.isEmpty() && userTypes.values().iterator().next() instanceof Map) {
            userTypeRequirements = new SequencedHashMap();
            Iterator e = userTypes.values().iterator();
            while (e.hasNext()) {
                Map userType = (Map)e.next();
                String userTypeID = (String)userType.get("ID");
                userTypeRequirements.put(userTypeID, userType.get("requirements"));
            }
        }
        log.info("UserType requirements: " + DataTools.prettyPrint(userTypeRequirements));
        theApp.definedUserTypes = userTypeRequirements;
        return theApp;
    }

    protected void canPerformAutoOperation() throws Exception {
        if (this.appID.equals("builtinApplication") || this.appID.equals("defaultApplication")) {
            if (authorizationEnabled) {
                throw new Exception("DENIED attempt to execute auto operation '" + this.operation + "' bound to the auto-generated default application because authorization is currently enabled");
            }
        } else {
            String definedOperationsOnly = (String)this.appConfig.get("definedOperationsOnly");
            if (definedOperationsOnly != null && definedOperationsOnly.equals("true") && this.getOperationConfig(this.operation) == null) {
                throw new Exception("DENIED attempt to execute auto operation '" + this.operation + "' bound to the application '" + this.appID + "' because this application is configued for defined operations only and there is no definition for this operation in the app file");
            }
        }
    }

    protected Map createAutoOperation(String operationType, Map passedOperationConfig, String dataSourceId) {
        if (passedOperationConfig == null) {
            passedOperationConfig = new HashMap();
        }
        passedOperationConfig.remove("dataSource");
        passedOperationConfig.remove("type");
        passedOperationConfig.remove("ID");
        Map defaultOperationConfig = DataTools.buildMap("ID", this.operation, "type", operationType, "dataSource", dataSourceId);
        DataTools.mapMerge(defaultOperationConfig, passedOperationConfig);
        return passedOperationConfig;
    }

    private final boolean userQualifiesForOperation(String operation) throws Exception {
        if (this.definedUserTypes == null || this.definedUserTypes.size() == 0) {
            log.debug("No userTypes defined, allowing anyone access to all operations for this application");
            return true;
        }
        Map opConstraints = this.getOperationConstraints(operation);
        List allowedUserTypes = opConstraints == null || opConstraints.containsKey("*") ? DataTools.enumToList(this.definedUserTypes.keySet().iterator()) : DataTools.enumToList(opConstraints.keySet().iterator());
        List qualifiedUserTypes = this.userIsOfTypes(allowedUserTypes);
        if (qualifiedUserTypes != null) {
            log.debug((Object)"Qualified for user types for this operation", qualifiedUserTypes);
            return true;
        }
        return false;
    }

    public boolean userQualifiesForType(String userType) throws Exception {
        Logger.auth.info("AppBase::boolean userQualifiesForType(String userType): override this method to provide custom userType qualification logic (base implementation returns true)");
        return true;
    }

    public boolean userIsOfType(String userType) throws Exception {
        if (this.definedUserTypes == null) {
            return false;
        }
        Boolean qualified = (Boolean)this.userTypes.get(userType);
        if (qualified != null) {
            return qualified;
        }
        boolean bl = false;
        if (!authorizationEnabled || this.userQualifiesForType(userType)) {
            bl = true;
        }
        qualified = new Boolean(bl);
        this.userTypes.put(userType, qualified);
        return qualified;
    }

    public List userIsOfTypes() throws Exception {
        if (this.definedUserTypes == null) {
            return null;
        }
        return this.userIsOfTypes(DataTools.enumToList(this.definedUserTypes.keySet().iterator()));
    }

    public List userIsOfTypes(List userTypes) throws Exception {
        ArrayList<String> qualified = new ArrayList<String>();
        Iterator e = userTypes.iterator();
        while (e.hasNext()) {
            String userType = (String)e.next();
            if (!this.userIsOfType(userType)) continue;
            qualified.add(userType);
        }
        if (qualified.size() > 0) {
            return qualified;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DSResponse execute(DSRequest request, RequestContext context) throws Exception {
        DSResponse dSResponse;
        block15: {
            DSResponse dSResponse2;
            block14: {
                DSResponse dSResponse3;
                block12: {
                    this.request = request;
                    this.context = context;
                    this.result = new DSResponse(request == null ? null : request.getDataSource());
                    Logger.pushContext(request.getAppID() + '.' + request.getOperation());
                    try {
                        block13: {
                            Object var8_6;
                            this.operation = request.getOperation();
                            Map operationConfig = this.getOperationConfig(this.operation);
                            if (operationConfig == null) {
                                this.canPerformAutoOperation();
                                String dataSourceId = request.getDataSourceName();
                                String operationType = request.getOperationType();
                                if ((dataSourceId == null || operationType == null) && this.getCustomMethod(this.operation) == null) {
                                    String message = "Auto-operation name (" + this.operation + ") must either be of the format dataSourceId_operationType or a public zero-argument method";
                                    throw new Exception(message);
                                }
                                Map operations = this.getOperationsMap();
                                if (operationConfig == null) {
                                    operationConfig = this.createAutoOperation(operationType, request.getOperationConfig(), dataSourceId);
                                }
                                operations.put(this.operation, operationConfig);
                            } else {
                                this.operationType = this.getDSOperationType(this.operation);
                            }
                            if (!this.userQualifiesForOperation(this.operation)) {
                                log.warn("User does not qualify for any userTypes that are allowed to perform this operation ('" + this.operation + "')");
                                this.result.setStatus(Const.AUTHORIZATION_FAILURE);
                                dSResponse3 = this.result;
                                Object var4_12 = null;
                                break block12;
                            }
                            try {
                                this.executeAppOperation();
                            }
                            catch (Throwable throwable) {
                                var8_6 = null;
                                this.freeDataSources();
                                throw throwable;
                            }
                            {
                                var8_6 = null;
                                this.freeDataSources();
                                if (this.result.getStatus() == Const.UNSET) {
                                    this.result.setSuccess();
                                }
                                if (!this.result.statusIsError()) break block13;
                                dSResponse2 = this.result;
                            }
                            break block14;
                        }
                        String exportAs = (String)this.getOperationProperty(this.operation, "exportAs");
                        if (exportAs != null) {
                            throw new Exception("CSV export is not supported in this version.");
                        }
                        dSResponse = this.result;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var4_15 = null;
                        Logger.popContext();
                        throw throwable;
                    }
                }
                Logger.popContext();
                return dSResponse3;
            }
            Object var4_13 = null;
            Logger.popContext();
            return dSResponse2;
        }
        Object var4_14 = null;
        Logger.popContext();
        return dSResponse;
    }

    public void _messagingSend() throws Exception {
        IMessaging messaging = (IMessaging)InterfaceProvider.load("IMessaging");
        messaging.send(this.context, this.request.getValues());
    }

    protected void executeAppOperation() throws Exception {
        Method customMethod = this.getCustomMethod(this.operation);
        if (customMethod != null) {
            log.info("Invoking custom app operation method '_" + this.operation + '\'');
            customMethod.invoke((Object)this, (Object[])new Class[0]);
        } else {
            log.debug("No public zero-argument method named '_" + this.operation + "' found, performing generic datasource operation");
            String dsName = this.request.getDataSourceName();
            if (dsName == null) {
                throw new Exception("No public zero-argument method named '_" + this.operation + " and request does not specify a DataSource to use for a default operation - unable to proceed.");
            }
            this.dataSource = this.request.getDataSource();
            this.executeDefaultDSOperation();
            this.dataSource = null;
        }
    }

    protected void executeDefaultDSOperation() throws Exception {
        String dsName = this.request.getDataSourceName();
        DataSource ds = this.request.getDataSource();
        if (ds == null) {
            throw new Exception("Can't find dataSource: " + dsName + " - please make sure that you have a " + dsName + ".ds.xml file for it in [webRoot]/shared/ds");
        }
        String operationType = this.request.getOperationType();
        if (this.request.isClientRequest && ("remove".equals(operationType) || "update".equals(operationType))) {
            List criteria = this.request.getCriteriaSets();
            Iterator i = criteria.iterator();
            while (i.hasNext()) {
                Map data = (Map)i.next();
                if (data == null) {
                    throw new Exception("Received null criteria for " + operationType + " operation - would delete all records - ignoring.");
                }
                ArrayList passedKeys = new ArrayList(data.keySet());
                List keysPresent = DataTools.setIntersection(ds.getPrimaryKeys(), passedKeys);
                List keysMissing = DataTools.setDisjunction(ds.getPrimaryKeys(), keysPresent);
                if (keysMissing.size() <= 0 || ds instanceof SessionDataSource) continue;
                throw new Exception("Criteria received from the client for " + operationType + " operation is missing the following required unique and/or primary fields: " + keysMissing.toString());
            }
        }
        this.result = ds.execute(this.request);
    }

    public DataSource getDataSource(String dsName) throws Exception {
        DataSource ds = (DataSource)this.leasedDataSources.get(dsName);
        if (ds == null) {
            ds = DataSourceManager.getDataSource(dsName);
            this.leasedDataSources.put(dsName, ds);
        }
        return ds;
    }

    public void freeDataSources() {
        Iterator i = this.leasedDataSources.values().iterator();
        while (i.hasNext()) {
            DataSourceManager.freeDataSource((DataSource)i.next());
        }
    }

    private final Method getCustomMethod(String operationName) {
        try {
            Method method = Reflection.findMethod(this, "_" + operationName);
            if (method != null) {
                return method;
            }
            if (this.dataSource == null) {
                return null;
            }
            if ("auto".equals(this.request.getOperationSource())) {
                String dataSourceId = this.dataSource.getName();
                if ("fetch".equals(this.operationType)) {
                    return Reflection.findMethod(this, "_" + dataSourceId + "_select");
                }
                if ("add".equals(this.operationType)) {
                    return Reflection.findMethod(this, "_" + dataSourceId + "_insert");
                }
                if ("remove".equals(this.operationType)) {
                    return Reflection.findMethod(this, "_" + dataSourceId + "_delete");
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getOperationsMap() {
        if ((Map)this.appConfig.get("operations") == null) {
            this.appConfig.put("operations", new HashMap());
        }
        if (this.operationsMap == null) {
            this.operationsMap = new DataTypeMap((Map)this.appConfig.get("operations"));
        }
        return this.operationsMap;
    }

    public Map getOperationConfig(String appOperation) {
        Map opConfig = (Map)this.getOperationsMap().get(appOperation);
        if (opConfig == null) {
            return new HashMap();
        }
        return opConfig;
    }

    public Object getOperationProperty(String appOperation, String property) {
        try {
            return DataTools.nestedGet(this.getOperationsMap(), appOperation + '.' + property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getOperationConstraints(String appOperation) {
        return (Map)this.getOperationProperty(appOperation, "constraints");
    }

    public Map getOperationOutputs(String appOperation) {
        return (Map)this.getOperationProperty(appOperation, "outputs");
    }

    public String getDSOperationType(String appOperation) {
        return (String)this.getOperationProperty(appOperation, "type");
    }

    public List getConstraintsForUserType(String userType, String operation) {
        Map opConstraints = this.getOperationConstraints(operation);
        if (opConstraints == null || opConstraints.get(userType) == null) {
            return null;
        }
        return DataTools.makeListIfSingle(opConstraints.get(userType));
    }

    public List getOutputsForUserType(String userType, String operation) {
        Map opOutputs = this.getOperationOutputs(operation);
        if (opOutputs == null || opOutputs.get(userType) == null) {
            return null;
        }
        return DataTools.makeListIfSingle(opOutputs.get(userType));
    }

    public void _getTime() throws Exception {
        Long currentTime = new Long(System.currentTimeMillis());
        this.result.setData(currentTime);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.context = null;
        this.operation = null;
        this.operationType = null;
        this.request = null;
        this.result = null;
        this.userTypes = new HashMap();
        this.dataSource = null;
        this.operationsMap = null;
        this.leasedDataSources = new HashMap();
    }

    public AppBase() {
        this.this();
    }

    static {
        Class clazz = class$com$isomorphic$application$AppBase;
        if (clazz == null) {
            clazz = class$com$isomorphic$application$AppBase = AppBase.class("[Lcom.isomorphic.application.AppBase;", false);
        }
        log = new Logger(clazz.getName());
        authorizationEnabled = config.getBoolean((Object)"authorization.enabled", false);
        staticRegex = new Perl5Util();
        DEFAULT_IMPLEMENTER = "com.isomorphic.application.AppBase";
        DEFAULT_PACKAGE = config.getString("application.defaultPackage");
    }
}

